local L = LibStub("AceLocale-3.0"):GetLocale("BossTactics")

function BossTactics:ShowGroupFrame()

	if(self.MainGroupWindow == nil)then
		self:CreateGroupFrame()
		self:CreateLeftGroupPanel()
		self:CreateRightPanel(self.MainGroupWindow, "group")
		self:AdjustRightGroupPanel()
	end
	if(self.MainWindow)then
		self.MainWindow:Hide()
    end
	self.MainGroupWindow:Show()
	self.MainGroupWindow:Raise()
	self.windowState = "group"
end;

function BossTactics:ClearGroupFrame()
	local leftpane = self.MainGroupWindow.LeftPane
    local rightpane = self.MainGroupWindow.RightPane
    self.currInstanceId = "EMPTY"
    self.currModuleId = -1
    self.currBossId = -1

    leftpane.BossBtn:Disable()
    leftpane.ModeBtn:Disable()
    leftpane.ScrollGroupMsgFrame:GetScrollChild():SetText("")
    rightpane.ScrollRight:GetScrollChild():SetText("")
    rightpane.SwitchStdBtn:Disable()
    rightpane.TrashBtn:Disable()
    rightpane.SaveBtn:Disable()
    rightpane.SaveAsBtn:Disable()
    rightpane.DelBtn:Disable()
    leftpane.titleLeftPane:SetText("BossTactics")
end;

function BossTactics:IsGroupFrameShown()
	if(self.MainGroupWindow == nil)then return false end
	return self.MainGroupWindow:IsVisible()
end


----------------------------------------
--Gui functions-------------------------
----------------------------------------

function BossTactics:CreateGroupFrame()

	local screenX = GetScreenWidth() -140
    local screenY = GetScreenHeight()-130

    local mainX = 875
    local mainY = 530

    local scale = 1.0

    if(screenY < mainY)then
        scale = screenY/mainY
    elseif(screenX < mainX)then
        scale = screenX/mainX
    end

    self.MainGroupWindow = CreateFrame("Frame", "BT_GroupMainFrame",UIParent)
    local theFrame = self.MainGroupWindow
    theFrame.stateMove = false
    theFrame:ClearAllPoints()
    theFrame:SetPoint("CENTER",UIParent,"CENTER",0,40)
    theFrame:SetHeight(mainY)
    theFrame:SetFrameLevel(100)
    theFrame:SetToplevel(true)
    theFrame:SetWidth(mainX)
    theFrame:SetScale(scale)

    theFrame.TitleTexture = theFrame:CreateTexture("BT_GroupTitleBG","BACKGROUND")
    theFrame.TitleTexture:SetPoint("TOPLEFT",theFrame,"TOPLEFT",7,-5)
    theFrame.TitleTexture:SetWidth(theFrame:GetWidth()-15)
    theFrame.TitleTexture:SetHeight(25)
    theFrame.TitleTexture:SetTexture(16/255,24/255,177/255)

    theFrame:SetBackdrop({
        bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 12,
        --edgeFile = "Interface\\Addons\\BossTactics\\Textures\\otravi-semi-full-border", edgeSize = 32,
        edgeFile = "Interface/Tooltips/UI-Tooltip-Border", edgeSize = 32,
        insets = {left = 7, right = 7, top = 7, bottom = 7},
    })
    theFrame:SetBackdropBorderColor(0,0,1.0)
    theFrame:SetBackdropColor(24/255, 24/255, 24/255)
    theFrame:EnableMouse(true)
    theFrame:SetMovable(false)

    theFrame:SetScript("OnMouseUp", function()
    				if(self.MainGroupWindow.stateMove)then
    					 if ( this.isMoving ) then
                          this:StopMovingOrSizing();
                          this.isMoving = false;
                         end
                    end
                    end)



    theFrame:SetScript("OnMouseDown", function()
    				if(self.MainGroupWindow.stateMove)then
    					 if (arg1 == "LeftButton") then
                          this:StartMoving();
                          this.isMoving = true;
                     	 end
                    end
                        end)

    theFrame.Title=theFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
    theFrame.Title:SetPoint("TOPLEFT",theFrame,"TOPLEFT",12,-12)
    theFrame.Title:SetTextColor(1.0,1.0,1.0,1.0)
    theFrame.Title:SetText("BossTactics - "..L["5-man instances"])

    theFrame.CloseButton=CreateFrame("Button","BT_closemaingroupframe",theFrame)
    theFrame.CloseButton:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
    theFrame.CloseButton:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
    theFrame.CloseButton:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
    theFrame.CloseButton:SetWidth(22)
    theFrame.CloseButton:SetHeight(22)
    theFrame.CloseButton:SetPoint("TOPRIGHT",theFrame,"TOPRIGHT",-9,-9)
    theFrame.CloseButton:SetScript("OnClick",function() self:HandleCloseMainWindow() end)

    theFrame.MoveButton=CreateFrame("Button","BT_movemaingroupframe",theFrame)
    theFrame.MoveButton:SetNormalTexture("Interface\\Buttons\\UI-AttributeButton-Encourage-Up.blp")
    theFrame.MoveButton:SetPushedTexture("Interface\\Buttons\\UI-AttributeButton-Encourage-Down.blp")
    theFrame.MoveButton:SetHighlightTexture("Interface\\Buttons\\UI-AttributeButton-Encourage-Hilight.blp")
    theFrame.MoveButton:SetWidth(18)
    theFrame.MoveButton:SetHeight(18)
    theFrame.MoveButton:SetPoint("TOPRIGHT",theFrame,"TOPRIGHT",-30,-11)
    theFrame.MoveButton:SetScript("OnClick",function()
    		if(theFrame.stateMove)then
    			self:Print(L["move end"])
    			theFrame.stateMove = false
    			theFrame:SetMovable(false)
    		else
    			self:Print(L["move start"])
    			theFrame.stateMove = true
    			theFrame:SetMovable(true)
    		end
     end)

end;

function BossTactics:CreateLeftGroupPanel()

	local theFrame = self.MainGroupWindow;
    theFrame.LeftPane = CreateFrame("Frame","BT_GroupLeftPane",theFrame)
    theFrame.LeftPane:ClearAllPoints()
    theFrame.LeftPane:SetPoint("TOPLEFT",theFrame,"TOPLEFT",0,-30)
    theFrame.LeftPane:SetHeight(theFrame:GetHeight()-30)
    theFrame.LeftPane:SetWidth(theFrame:GetWidth()/2)

    self:CreateTopButtonBar(theFrame.LeftPane)
    theFrame.LeftPane.BossBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",30,-40)
    theFrame.LeftPane.ModeBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",140,-40)
    theFrame.LeftPane.Patchlvl:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",220,-13)

    theFrame.LeftPane.InfoBtn = CreateFrame("Button","BT_GroupInfoBtn",theFrame.LeftPane,"UIPanelButtonTemplate")
    theFrame.LeftPane.InfoBtn:SetWidth(70)
    theFrame.LeftPane.InfoBtn:SetHeight(20)
    theFrame.LeftPane.InfoBtn:SetText(L["Info"])
    theFrame.LeftPane.InfoBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",30,-70)
    theFrame.LeftPane.InfoBtn:SetScript("OnClick",function()
                        BossTactics:ShowInfoFrame()
                          end)
	theFrame.LeftPane.RaidViewBtn = CreateFrame("Button","BT_GroupRaidViewBtn",theFrame.LeftPane,"UIPanelButtonTemplate")
    theFrame.LeftPane.RaidViewBtn:SetWidth(100)
    theFrame.LeftPane.RaidViewBtn:SetHeight(20)
    theFrame.LeftPane.RaidViewBtn:SetText(L["Raid View"])
    theFrame.LeftPane.RaidViewBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",110,-70)
    theFrame.LeftPane.RaidViewBtn:SetScript("OnClick",function()
    					self.windowState = "raid"
                        self:CheckForFrameSwitch()
                        self:SwitchFrameData()
                          end)

	theFrame.LeftPane.SendMsgBtn = CreateFrame("Button","BT_GroupSendMsgBtn",theFrame.LeftPane,"UIPanelButtonTemplate")
    theFrame.LeftPane.SendMsgBtn:SetWidth(110)
    theFrame.LeftPane.SendMsgBtn:SetHeight(20)
    theFrame.LeftPane.SendMsgBtn:SetText(L["Post Message"])
    theFrame.LeftPane.SendMsgBtn:Disable()
    theFrame.LeftPane.SendMsgBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",30,-160)
    theFrame.LeftPane.SendMsgBtn:SetScript("OnClick",function()
    						if(GetNumPartyMembers() < 1)then BossTactics:Print(L["no print without group"]); return; end
							local tbl = { strsplit("\n", self.MainGroupWindow.LeftPane.ScrollGroupMsgFrame:GetScrollChild():GetText()) }
                            for i,v in ipairs(tbl)do
                                SendChatMessage(v,"PARTY")
                            end
                          end)
	theFrame.LeftPane.SaveBtn = CreateFrame("Button","BT_GroupSaveBtn",theFrame.LeftPane,"UIPanelButtonTemplate")
    theFrame.LeftPane.SaveBtn:SetWidth(100)
    theFrame.LeftPane.SaveBtn:SetHeight(20)
    theFrame.LeftPane.SaveBtn:SetText(L["Save"])
    theFrame.LeftPane.SaveBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",150,-160)
    theFrame.LeftPane.SaveBtn:Disable()
    theFrame.LeftPane.SaveBtn:SetScript("OnClick",function()
                        self:SaveGroupText()
                          end)
    theFrame.LeftPane.StdBtn = CreateFrame("Button","BT_GroupStdBtn",theFrame.LeftPane,"UIPanelButtonTemplate")
    theFrame.LeftPane.StdBtn:SetWidth(190)
    theFrame.LeftPane.StdBtn:SetHeight(20)
    theFrame.LeftPane.StdBtn:SetText(L["Recover Standard"])
    theFrame.LeftPane.StdBtn:Disable()
    theFrame.LeftPane.StdBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",30,-130)
    theFrame.LeftPane.StdBtn:SetScript("OnClick",function()
                        self:RestoreDefaultGroupText()
                              end)

	theFrame.LeftPane.titleLeftPane = theFrame.LeftPane:CreateFontString(nil,"OVERLAY","MailTextFontNormal")
    theFrame.LeftPane.titleLeftPane:SetTextColor(226/255,186/255,0)
    theFrame.LeftPane.titleLeftPane:SetText("BossTactics")
    theFrame.LeftPane.titleLeftPane:SetPoint("TOP",theFrame.LeftPane,"Top",0,-105)

	theFrame.LeftPane.ScrollGroupMsgFrame = CreateFrame("ScrollFrame","BT_ScrollGroupMsgFrame",theFrame.LeftPane,"UIPanelScrollFrameTemplate")
    theFrame.LeftPane.ScrollGroupMsgFrame:ClearAllPoints();
    theFrame.LeftPane.ScrollGroupMsgFrame:SetPoint("BOTTOMLEFT",theFrame.LeftPane, "BOTTOMLEFT", 5,15)
    theFrame.LeftPane.ScrollGroupMsgFrame:SetWidth(theFrame.LeftPane:GetWidth()-45);
    theFrame.LeftPane.ScrollGroupMsgFrame:SetHeight(270);

    local groupmsg_edit = CreateFrame("EditBox","BT_groupmsgedit",theFrame.LeftPane.ScrollgroupmsgFrame)
    theFrame.LeftPane.FrameOfgroupmsg = CreateFrame("Frame","BT_addonlistframe_border",theFrame.LeftPane)
    theFrame.LeftPane.FrameOfgroupmsg:SetBackdrop({
    edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
    })
    theFrame.LeftPane.FrameOfgroupmsg:SetBackdropBorderColor(16/255,24/255,177/255)
    theFrame.LeftPane.FrameOfgroupmsg:SetHeight(290)
    theFrame.LeftPane.FrameOfgroupmsg:SetWidth(theFrame.LeftPane:GetWidth()-10)
    theFrame.LeftPane.FrameOfgroupmsg:ClearAllPoints()
    theFrame.LeftPane.FrameOfgroupmsg:SetPoint("BOTTOMLEFT",theFrame.LeftPane,"BOTTOMLEFT",5,5)

    groupmsg_edit:ClearAllPoints();
    groupmsg_edit:SetWidth(theFrame.LeftPane:GetWidth()-30)
    groupmsg_edit:SetHeight(65)
    groupmsg_edit:SetPoint("TOPLEFT",theFrame.LeftPane.ScrollGroupMsgFrame,"TOPLEFT",0,0)
    theFrame.LeftPane.ScrollGroupMsgFrame:SetScrollChild(groupmsg_edit)
    theFrame.LeftPane.ScrollGroupMsgFrame:SetBackdropColor(24/255, 24/255, 24/255)
    theFrame.LeftPane.titlegroupmsgScroll = theFrame.LeftPane:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
    theFrame.LeftPane.titlegroupmsgScroll:SetTextColor(1,1,1)
    theFrame.LeftPane.titlegroupmsgScroll:SetText(L["Title Groupmessage"])
    theFrame.LeftPane.titlegroupmsgScroll:SetPoint("BOTTOMLEFT",theFrame.LeftPane,"BOTTOMLEFT",10,297)
    groupmsg_edit:SetScript("OnTextChanged", function()
             ScrollingEdit_OnTextChanged(this, this:GetParent())
              end)
    groupmsg_edit:SetScript("OnCursorChanged", function()
             ScrollingEdit_OnCursorChanged(this, arg1, arg2-10, arg3, arg4) end)
    groupmsg_edit:SetScript("OnUpdate", function()
             ScrollingEdit_OnUpdate(this, this:GetParent()) end)
    groupmsg_edit:SetScript("OnEscapePressed", function()
                this:ClearFocus()
                end)
    groupmsg_edit:SetScript("OnChar", function()
                self:GroupDataChanged()
                end)
    groupmsg_edit:SetAutoFocus(false)
    groupmsg_edit:SetMultiLine(true)
    groupmsg_edit:EnableMouse(true)
    groupmsg_edit:SetFontObject("GameFontNormal")
    groupmsg_edit:SetTextColor(84/255,129/255,171/255)
    groupmsg_edit:SetTextInsets(10,10,10,10)
end;

function BossTactics:AdjustRightGroupPanel()

	local theFrame = self.MainGroupWindow
	theFrame.RightPane.ScrollRight:SetPoint("TOPLEFT",theFrame.RightPane, "TOPLEFT",0,-50)
	theFrame.RightPane.ScrollRight:SetHeight(theFrame.RightPane:GetHeight()-60);
	theFrame.RightPane.SaveAsBtn:SetPoint("TOPRIGHT",theFrame.RightPane,"TOPRIGHT",-15,-25)
	theFrame.RightPane.DelBtn:SetPoint("TOPRIGHT",theFrame.RightPane,"TOPRIGHT",-120,-25)
end;

function BossTactics:SwitchFrameData()

	local leftpane = nil

	if(self:IsGroupFrameShown())then
    	leftpane = self.MainGroupWindow.LeftPane
	elseif(self:IsRaidFrameShown())then
		leftpane = self.MainWindow.LeftPane
	end
	if(not leftpane)then return end

	self.currAddon = leftpane.AddonBtn.currAddon
    self.currBossId = leftpane.BossBtn.currBossId
    self.currInstanceId = leftpane.InstanzBtn.currInstanceId
    self.currModuleId = leftpane.InstanzBtn.currModuleId
    self.currInstanceMode = leftpane.ModeBtn.currInstanceMode
    self.currBossTable = leftpane.BossBtn.currBossTable
end

function BossTactics:SaveGroupText()

	local bossDB = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.curr5ManInstance][self.currBossId]
    local module = LibStub("AceAddon-3.0"):GetAddon( self.modules[self.currModuleId].id )
    local defaultDB = module:GetDefaults()
    local defaultBoss = defaultDB.profile.bosses[self.currInstanceMode][self.curr5ManInstance][self.currBossId]
    local leftpane = self.MainGroupWindow.LeftPane

   	bossDB.grtext = leftpane.ScrollGroupMsgFrame:GetScrollChild():GetText()
   	leftpane.SaveBtn:Disable()
    
end

function BossTactics:RestoreDefaultGroupText()

	local bossDB = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.curr5ManInstance][self.currBossId]
    local module = LibStub("AceAddon-3.0"):GetAddon( self.modules[self.currModuleId].id )
    local defaultDB = module:GetDefaults()
    local defaultBoss = defaultDB.profile.bosses[self.currInstanceMode][self.curr5ManInstance][self.currBossId]
    local leftpane = self.MainGroupWindow.LeftPane

	bossDB.grtext = defaultBoss.grtext
	leftpane.ScrollGroupMsgFrame:GetScrollChild():SetText(bossDB.grtext)
	self:Print(L["defaults recovered"])
	leftpane.SaveBtn:Disable()

end

function BossTactics:GroupDataChanged()
	self.MainGroupWindow.LeftPane.SaveBtn:Enable()
end