local L = LibStub("AceLocale-3.0"):GetLocale("BossTactics")
local BabbleClass = LibStub("LibBabble-Class-3.0"):GetLookupTable();

---------------------------------------------------------
--- opens dialog if data musst be updated panel
-- optional: message
---------------------------------------------------------

function BossTactics:ShowUpdateInfoFrame(message)
    if(self.UpdateFrame == nil)then
        self.UpdateFrame = CreateFrame("Frame","BT_UpdateFrame",UIParent)
        self.UpdateFrame:ClearAllPoints()
        self.UpdateFrame:SetPoint("CENTER",UIParent)
        self.UpdateFrame:SetHeight(150)
        self.UpdateFrame:SetWidth(350)
        self.UpdateFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        self.UpdateFrame:SetBackdropColor(1/255, 1/255, 1/255)
        --self.UpdateFrame:SetBackdropBorderColor(1.0,0,0.0)

        self.UpdateFrame.YesBtn = CreateFrame("Button","BT_updateframe_ok",self.UpdateFrame,"UIPanelButtonTemplate")
        self.UpdateFrame.YesBtn:SetWidth(60)
        self.UpdateFrame.YesBtn:SetHeight(20)
        self.UpdateFrame.YesBtn:SetText(L["Yes"])
        self.UpdateFrame.YesBtn:SetPoint("BOTTOMLEFT",self.UpdateFrame,"BOTTOMLEFT",15,15)
        self.UpdateFrame.YesBtn:SetScript("OnClick",function()
            local currModule = LibStub("AceAddon-3.0"):GetAddon( self.currInstanceId )
            currModule:ResetData()
            self:RestoreDefaults()
        this:GetParent():Hide() end)
        self.UpdateFrame.YesBtn:SetFrameLevel(self.UpdateFrame:GetFrameLevel()+1)

        self.UpdateFrame.NoBtn = CreateFrame("Button","BT_updateframe_c",self.UpdateFrame,"UIPanelButtonTemplate")
        self.UpdateFrame.NoBtn:SetWidth(100)
        self.UpdateFrame.NoBtn:SetHeight(20)
        self.UpdateFrame.NoBtn:SetText(L["No"])
        self.UpdateFrame.NoBtn:SetPoint("BOTTOMLEFT",self.UpdateFrame,"BOTTOMLEFT",120,15)
        self.UpdateFrame.NoBtn:SetScript("OnClick",function() this:GetParent():Hide() end)
        self.UpdateFrame.NoBtn:SetFrameLevel(self.UpdateFrame:GetFrameLevel()+1)

        self.UpdateFrame.infotext = self.UpdateFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        self.UpdateFrame.infotext:SetTextColor(1,1,1)
        self.UpdateFrame.infotext:SetWidth(330)
        self.UpdateFrame.infotext:SetPoint("TOP",self.UpdateFrame,"TOP",10,-25)
        self.UpdateFrame.infotext:SetJustifyH("LEFT")

        self.UpdateFrame.closebtn=CreateFrame("Button","BT_uinfoclose",self.UpdateFrame)
        self.UpdateFrame.closebtn:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
        self.UpdateFrame.closebtn:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
        self.UpdateFrame.closebtn:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
        self.UpdateFrame.closebtn:SetWidth(20)
        self.UpdateFrame.closebtn:SetHeight(20)
        self.UpdateFrame.closebtn:SetPoint("TOPRIGHT",self.UpdateFrame,"TOPRIGHT",-5,-5)
        self.UpdateFrame.closebtn:SetScript("OnClick",function() this:GetParent():Hide() end)
        self.UpdateFrame.closebtn:SetFrameLevel(self.UpdateFrame:GetFrameLevel()+1)
    end
    if(message)then
        self.UpdateFrame.infotext:SetText(message)
    else
        self.UpdateFrame.infotext:SetText(L["update info text"])
    end
    self.UpdateFrame:Show()
    self.UpdateFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+20)

end;

---------------------------------------------------------
--- opens dialog with yes no choice
---------------------------------------------------------

function BossTactics:ShowQuestionFrame(message, yesFunc, noFunc, arg1Yes, arg2Yes, arg1No, arg2No)
    if(self.QuestionFrame == nil)then
        self.QuestionFrame = CreateFrame("Frame","BT_QuestionFrame",UIParent)
        self.QuestionFrame:ClearAllPoints()
        self.QuestionFrame:SetPoint("CENTER",UIParent)
        self.QuestionFrame:SetHeight(200)
        self.QuestionFrame:SetWidth(350)
        self.QuestionFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        self.QuestionFrame:SetBackdropColor(1/255, 1/255, 1/255)
        --self.QuestionFrame:SetBackdropBorderColor(1.0,0,0.0)

        self.QuestionFrame.YesBtn = CreateFrame("Button","BT_QuestionFrame_ok",self.QuestionFrame,"UIPanelButtonTemplate")
        self.QuestionFrame.YesBtn:SetWidth(60)
        self.QuestionFrame.YesBtn:SetHeight(20)
        self.QuestionFrame.YesBtn:SetText(L["Yes"])
        self.QuestionFrame.YesBtn:SetPoint("BOTTOMLEFT",self.QuestionFrame,"BOTTOMLEFT",15,15)
        self.QuestionFrame.YesBtn:SetScript("OnClick",function()
        	this:GetParent():Hide()
            if(self.QuestionFrame.YesFunc)then
                self.QuestionFrame.YesFunc(self.QuestionFrame.yesArg1,self.QuestionFrame.yesArg2)
            end
           end)
        self.QuestionFrame.YesBtn:SetFrameLevel(self.QuestionFrame:GetFrameLevel()+1)

        self.QuestionFrame.NoBtn = CreateFrame("Button","BT_QuestionFrame_c",self.QuestionFrame,"UIPanelButtonTemplate")
        self.QuestionFrame.NoBtn:SetWidth(60)
        self.QuestionFrame.NoBtn:SetHeight(20)
        self.QuestionFrame.NoBtn:SetText(L["No"])
        self.QuestionFrame.NoBtn:SetPoint("BOTTOMLEFT",self.QuestionFrame,"BOTTOMLEFT",120,15)
        self.QuestionFrame.NoBtn:SetScript("OnClick",function()
        			this:GetParent():Hide()
                    if(self.QuestionFrame.NoFunc)then
                        self.QuestionFrame.NoFunc(self.QuestionFrame.noArg1,self.QuestionFrame.noArg2)
                    end
             end)
        self.QuestionFrame.NoBtn:SetFrameLevel(self.QuestionFrame:GetFrameLevel()+1)

        self.QuestionFrame.infotext = self.QuestionFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        self.QuestionFrame.infotext:SetTextColor(1,1,1)
        self.QuestionFrame.infotext:SetWidth(270)
        self.QuestionFrame.infotext:SetPoint("TOP",self.QuestionFrame,"TOP",10,-25)
        self.QuestionFrame.infotext:SetJustifyH("CENTER")
    end
    self.QuestionFrame.YesFunc = yesFunc
    self.QuestionFrame.NoFunc = noFunc
    self.QuestionFrame.yesArg1 = arg1Yes
    self.QuestionFrame.yesArg2 = arg2Yes
    self.QuestionFrame.noArg1 = arg1No
    self.QuestionFrame.noArg2 = arg2No
    self.QuestionFrame:Show()
    self.QuestionFrame.infotext:SetText(message)
    if(self.MainWindow)then
        self.QuestionFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+20)
    end

end;

---------------------------------------------------------
--- update information frame
---------------------------------------------------------

function BossTactics:ShowUpdateMessageFrame(message, allFunc, okFunc, arg1All, arg2All, arg1Ok, arg2Ok)
    if(self.UpdateMessageFrame == nil)then
        self.UpdateMessageFrame = CreateFrame("Frame","BT_UpdateMessageFrame",UIParent)
        self.UpdateMessageFrame:ClearAllPoints()
        self.UpdateMessageFrame:SetPoint("CENTER",UIParent)
        self.UpdateMessageFrame:SetHeight(200)
        self.UpdateMessageFrame:SetWidth(350)
        self.UpdateMessageFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        self.UpdateMessageFrame:SetBackdropColor(1/255, 1/255, 1/255)

        self.UpdateMessageFrame.okBtn = CreateFrame("Button","BT_UpdateMessageFrame_ok",self.UpdateMessageFrame,"UIPanelButtonTemplate")
        self.UpdateMessageFrame.okBtn:SetWidth(60)
        self.UpdateMessageFrame.okBtn:SetHeight(20)
        self.UpdateMessageFrame.okBtn:SetText(L["Ok"])
        self.UpdateMessageFrame.okBtn:SetPoint("BOTTOMLEFT",self.UpdateMessageFrame,"BOTTOMLEFT",15,15)
        self.UpdateMessageFrame.okBtn:SetScript("OnClick",function()
        	if(self.UpdateMessageFrame.OkFunc)then
            	self.UpdateMessageFrame.OkFunc(self.UpdateMessageFrame.okArg1,self.UpdateMessageFrame.okArg2)
            end
            this:GetParent():Hide()
           end)
        self.UpdateMessageFrame.okBtn:SetFrameLevel(self.UpdateMessageFrame:GetFrameLevel()+1)

        self.UpdateMessageFrame.AllBtn = CreateFrame("Button","BT_UpdateMessageFrame_c",self.UpdateMessageFrame,"UIPanelButtonTemplate")
        self.UpdateMessageFrame.AllBtn:SetWidth(60)
        self.UpdateMessageFrame.AllBtn:SetHeight(20)
        self.UpdateMessageFrame.AllBtn:SetText(L["All"])
        self.UpdateMessageFrame.AllBtn:SetPoint("BOTTOMLEFT",self.UpdateMessageFrame,"BOTTOMLEFT",120,15)
        self.UpdateMessageFrame.AllBtn:SetScript("OnClick",function()
                    if(self.UpdateMessageFrame.AllFunc)then
            	        self.UpdateMessageFrame.AllFunc(self.UpdateMessageFrame.allArg1,self.UpdateMessageFrame.allArg2)
                    end
                    this:GetParent():Hide()
             end)
        self.UpdateMessageFrame.AllBtn:SetFrameLevel(self.UpdateMessageFrame:GetFrameLevel()+1)

        self.UpdateMessageFrame.infotext = self.UpdateMessageFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        self.UpdateMessageFrame.infotext:SetTextColor(1,1,1)
        self.UpdateMessageFrame.infotext:SetWidth(270)
        self.UpdateMessageFrame.infotext:SetText(message)
        self.UpdateMessageFrame.infotext:SetPoint("TOP",self.UpdateMessageFrame,"TOP",10,-25)
        self.UpdateMessageFrame.infotext:SetJustifyH("CENTER")

    end
    self.UpdateMessageFrame:Show()
    self.UpdateMessageFrame.AllFunc = allFunc
    self.UpdateMessageFrame.allArg1 = arg1All
    self.UpdateMessageFrame.allArg2 = arg2All
    self.UpdateMessageFrame.OkFunc = okFunc
    self.UpdateMessageFrame.okArg1 = arg1Ok
    self.UpdateMessageFrame.okArg2 = arg2Ok
    if(self.MainWindow)then
        self.UpdateMessageFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+20)
    end

end;

---------------------------------------------------------
--- opens dialog if a user in group > self.currInstanceMemberMax
---------------------------------------------------------

function BossTactics:ShowTacticQuestionFrame(target)
	if(self.isNotWatchingAsked) then return end
	self.isNotWatching = true
    if(self.TacticQuestionFrame == nil)then
        self.TacticQuestionFrame = CreateFrame("Frame","BT_TacticQuestionFrame",UIParent)
        self.TacticQuestionFrame:ClearAllPoints()
        self.TacticQuestionFrame:SetPoint("CENTER",UIParent)
        self.TacticQuestionFrame:SetHeight(120)
        self.TacticQuestionFrame:SetWidth(350)
        self.TacticQuestionFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        self.TacticQuestionFrame:SetBackdropColor(1/255, 1/255, 1/255)
        --self.TacticQuestionFrame:SetBackdropBorderColor(1.0,0,0.0)

        self.TacticQuestionFrame.YesBtn = CreateFrame("Button","BT_TacticQuestionFrame_ok",self.TacticQuestionFrame,"UIPanelButtonTemplate")
        self.TacticQuestionFrame.YesBtn:SetWidth(60)
        self.TacticQuestionFrame.YesBtn:SetHeight(20)
        self.TacticQuestionFrame.YesBtn:SetText(L["Yes"])
        self.TacticQuestionFrame.YesBtn:SetPoint("BOTTOMLEFT",self.TacticQuestionFrame,"BOTTOMLEFT",15,15)
        self.TacticQuestionFrame.YesBtn:SetScript("OnClick",function()
            self.isNotWatching = false;
            self.isNotWatchingAsked = false
            self:StartUserSession(target, true)
            self:BT_SendDataMessage("{SYNCREQ}")
            this:GetParent():Hide()
        this:GetParent():Hide() end)
        self.TacticQuestionFrame.YesBtn:SetFrameLevel(self.TacticQuestionFrame:GetFrameLevel()+1)

        self.TacticQuestionFrame.NoBtn = CreateFrame("Button","BT_TacticQuestionFrame_c",self.TacticQuestionFrame,"UIPanelButtonTemplate")
        self.TacticQuestionFrame.NoBtn:SetWidth(60)
        self.TacticQuestionFrame.NoBtn:SetHeight(20)
        self.TacticQuestionFrame.NoBtn:SetText(L["No"])
        self.TacticQuestionFrame.NoBtn:SetPoint("BOTTOMLEFT",self.TacticQuestionFrame,"BOTTOMLEFT",120,15)
        self.TacticQuestionFrame.NoBtn:SetScript("OnClick",function()
                    self.isNotWatching = true
                    self.isNotWatchingAsked = true
                    this:GetParent():Hide()
             end)
        self.TacticQuestionFrame.NoBtn:SetFrameLevel(self.TacticQuestionFrame:GetFrameLevel()+1)

        self.TacticQuestionFrame.infotext = self.TacticQuestionFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        self.TacticQuestionFrame.infotext:SetTextColor(1,1,1)
        self.TacticQuestionFrame.infotext:SetWidth(270)
        self.TacticQuestionFrame.infotext:SetText(L["tactic question text"])
        self.TacticQuestionFrame.infotext:SetPoint("TOP",self.TacticQuestionFrame,"TOP",10,-25)
        self.TacticQuestionFrame.infotext:SetJustifyH("CENTER")

        self.TacticQuestionFrame.closebtn=CreateFrame("Button","BT_uinfoclose",self.TacticQuestionFrame)
        self.TacticQuestionFrame.closebtn:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
        self.TacticQuestionFrame.closebtn:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
        self.TacticQuestionFrame.closebtn:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
        self.TacticQuestionFrame.closebtn:SetWidth(20)
        self.TacticQuestionFrame.closebtn:SetHeight(20)
        self.TacticQuestionFrame.closebtn:SetPoint("TOPRIGHT",self.TacticQuestionFrame,"TOPRIGHT",-5,-5)
        self.TacticQuestionFrame.closebtn:SetScript("OnClick",function() this:GetParent():Hide() end)
        self.TacticQuestionFrame.closebtn:SetFrameLevel(self.TacticQuestionFrame:GetFrameLevel()+1)
    end
    self.TacticQuestionFrame:Show()
    if(self.MainWindow)then
        self.TacticQuestionFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+20)
    end

end;

---------------------------------------------------------
--- opens Info panel
---------------------------------------------------------

function BossTactics:ShowInfoFrame()
    if(self.InfoFrame == nil)then
        self.InfoFrame = CreateFrame("Frame","BT_infoframe",UIParent)
        self.InfoFrame:ClearAllPoints()
        self.InfoFrame:SetPoint("CENTER",UIParent)
        self.InfoFrame:SetHeight(270)
        self.InfoFrame:SetWidth(350)
        self.InfoFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        self.InfoFrame:SetBackdropColor(1/255, 1/255, 1/255)
        --self.InfoFrame:SetBackdropBorderColor(1.0,0,0.0)

        self.InfoFrame.OkBtn = CreateFrame("Button","BT_infoframe_ok",self.InfoFrame,"UIPanelButtonTemplate")
        self.InfoFrame.OkBtn:SetWidth(100)
        self.InfoFrame.OkBtn:SetHeight(20)
        self.InfoFrame.OkBtn:SetText(L["Ok"])
        self.InfoFrame.OkBtn:SetPoint("BOTTOM",self.InfoFrame,"BOTTOM",0,15)
        self.InfoFrame.OkBtn:SetScript("OnClick",function() this:GetParent():Hide() end)
        self.InfoFrame.OkBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)

        self.InfoFrame.title = self.InfoFrame:CreateFontString(nil,"OVERLAY","MailTextFontNormal")
        self.InfoFrame.title:SetTextColor(1,1,1)
        self.InfoFrame.title:SetText(string.format(L["title info"],self.version))
        self.InfoFrame.title:SetPoint("TOP",self.InfoFrame,"TOP",0,-15)

        self.InfoFrame.infotext = self.InfoFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        self.InfoFrame.infotext:SetTextColor(1,1,1)
        self.InfoFrame.infotext:SetWidth(330)
        self.InfoFrame.infotext:SetHeight(200)
        self.InfoFrame.infotext:SetText(L["info text"])
        self.InfoFrame.infotext:SetPoint("TOP",self.InfoFrame,"TOP",10,-30)
        self.InfoFrame.infotext:SetJustifyH("LEFT")

        self.InfoFrame.closebtn=CreateFrame("Button","BT_infoclose",self.InfoFrame)
        self.InfoFrame.closebtn:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
        self.InfoFrame.closebtn:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
        self.InfoFrame.closebtn:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
        self.InfoFrame.closebtn:SetWidth(20)
        self.InfoFrame.closebtn:SetHeight(20)
        self.InfoFrame.closebtn:SetPoint("TOPRIGHT",self.InfoFrame,"TOPRIGHT",-5,-5)
        self.InfoFrame.closebtn:SetScript("OnClick",function() this:GetParent():Hide() end)
        self.InfoFrame.closebtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)
    end
    self.InfoFrame:Show()
    self.InfoFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+20)
    if(self.currInstanceId ~= "EMPTY" and self.modules[self.currModuleId].info)then
        self.InfoFrame.infotext:SetText(L["info text"]..self.modules[self.currModuleId].info)
    else
        self.InfoFrame.infotext:SetText(L["info text"])
    end

end;

---------------------------------------------------------
--- opens Info message
---------------------------------------------------------

function BossTactics:ShowInfoMessage(message)
    if (not message)then return end

    if(self.InfoMessageFrame == nil)then
        self.InfoMessageFrame = CreateFrame("Frame","BT_messageframe",UIParent)
        self.InfoMessageFrame:ClearAllPoints()
        self.InfoMessageFrame:SetPoint("CENTER",UIParent)
        self.InfoMessageFrame:SetHeight(150)
        self.InfoMessageFrame:SetWidth(350)
        self.InfoMessageFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        self.InfoMessageFrame:SetBackdropColor(1/255, 1/255, 1/255)
        --self.InfoMessageFrame:SetBackdropBorderColor(1.0,0,0.0)

        self.InfoMessageFrame.OkBtn = CreateFrame("Button","BT_infomessage_ok",self.InfoMessageFrame,"UIPanelButtonTemplate")
        self.InfoMessageFrame.OkBtn:SetWidth(100)
        self.InfoMessageFrame.OkBtn:SetHeight(20)
        self.InfoMessageFrame.OkBtn:SetText(L["Ok"])
        self.InfoMessageFrame.OkBtn:SetPoint("BOTTOM",self.InfoMessageFrame,"BOTTOM",0,15)
        self.InfoMessageFrame.OkBtn:SetScript("OnClick",function() this:GetParent():Hide() end)

        self.InfoMessageFrame.infotext = self.InfoMessageFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        self.InfoMessageFrame.infotext:SetTextColor(1,1,1)
        self.InfoMessageFrame.infotext:SetWidth(280)
        self.InfoMessageFrame.infotext:SetPoint("TOP",self.InfoMessageFrame,"TOP",0,-40)
        self.InfoMessageFrame.infotext:SetJustifyH("LEFT")

        self.InfoMessageFrame.closebtn=CreateFrame("Button","BT_infomessage_close",self.InfoMessageFrame)
        self.InfoMessageFrame.closebtn:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
        self.InfoMessageFrame.closebtn:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
        self.InfoMessageFrame.closebtn:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
        self.InfoMessageFrame.closebtn:SetWidth(20)
        self.InfoMessageFrame.closebtn:SetHeight(20)
        self.InfoMessageFrame.closebtn:SetPoint("TOPRIGHT",self.InfoMessageFrame,"TOPRIGHT",-5,-5)
        self.InfoMessageFrame.closebtn:SetScript("OnClick",function() this:GetParent():Hide() end)
    end
    self.InfoMessageFrame:Show()
    self.InfoMessageFrame:SetFrameLevel(40)
    if(self.MainWindow)then
   		self.InfoMessageFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+20)
   		self.InfoMessageFrame.OkBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)
   		self.InfoMessageFrame.closebtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)
    end
    self.InfoMessageFrame.infotext:SetText(message)
end;

---------------------------------------------------------
--- opens Info that version incompatible
---------------------------------------------------------

function BossTactics:ShowVersionInfoFrame()
    if(self.VersionFrame == nil)then
        self.VersionFrame = CreateFrame("Frame","BT_Versionframe",UIParent)
        self.VersionFrame:ClearAllPoints()
        self.VersionFrame:SetPoint("CENTER",UIParent)
        self.VersionFrame:SetHeight(130)
        self.VersionFrame:SetWidth(320)
        self.VersionFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        self.VersionFrame:SetBackdropColor(1/255, 1/255, 1/255)
        --self.VersionFrame:SetBackdropBorderColor(1.0,0,0.0)

        self.VersionFrame.OkBtn = CreateFrame("Button","BT_version_ok",self.VersionFrame,"UIPanelButtonTemplate")
        self.VersionFrame.OkBtn:SetWidth(100)
        self.VersionFrame.OkBtn:SetHeight(20)
        self.VersionFrame.OkBtn:SetText(L["Ok"])
        self.VersionFrame.OkBtn:SetPoint("BOTTOM",self.VersionFrame,"BOTTOM",0,15)
        self.VersionFrame.OkBtn:SetScript("OnClick",function() this:GetParent():Hide() end)

        self.VersionFrame.Versiontext = self.VersionFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        self.VersionFrame.Versiontext:SetTextColor(1,1,1)
        self.VersionFrame.Versiontext:SetWidth(270)
        self.VersionFrame.Versiontext:SetHeight(80)
        self.VersionFrame.Versiontext:SetText(L["Version info text"])
        self.VersionFrame.Versiontext:SetPoint("TOP",self.VersionFrame,"TOP",10,-10)
        self.VersionFrame.Versiontext:SetJustifyH("LEFT")

        self.VersionFrame.closebtn=CreateFrame("Button","BT_Versionclose",self.VersionFrame)
        self.VersionFrame.closebtn:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
        self.VersionFrame.closebtn:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
        self.VersionFrame.closebtn:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
        self.VersionFrame.closebtn:SetWidth(20)
        self.VersionFrame.closebtn:SetHeight(20)
        self.VersionFrame.closebtn:SetPoint("TOPRIGHT",self.VersionFrame,"TOPRIGHT",-5,-5)
        self.VersionFrame.closebtn:SetScript("OnClick",function() this:GetParent():Hide() end)

    end
    self.VersionFrame:Show()
    if(self.MainWindow) then
        self.VersionFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+20)
        self.VersionFrame.OkBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)
        self.VersionFrame.closebtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)
    end

end;

-----------------------------------------------------------------
-- Displays ID Info
-----------------------------------------------------------------

function BossTactics:ShowIdInfoFrame()
     local theFrame = self.MainWindow
	 if(theFrame.IdInfoFrame == nil)then
        theFrame.IdInfoFrame = CreateFrame("Frame","BT_IdInfoFrame",theFrame)
        theFrame.IdInfoFrame:SetFrameLevel(theFrame:GetFrameLevel()+20)
        theFrame.IdInfoFrame:ClearAllPoints()
        theFrame.IdInfoFrame:SetPoint("CENTER",theFrame)
        theFrame.IdInfoFrame:SetHeight(310)
        theFrame.IdInfoFrame:SetWidth(430)
        theFrame.IdInfoFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        theFrame.IdInfoFrame:SetBackdropColor(1/255, 1/255, 1/255)

        theFrame.IdInfoFrame.OkBtn = CreateFrame("Button","BT_idframe_ok",theFrame.IdInfoFrame,"UIPanelButtonTemplate")
        theFrame.IdInfoFrame.OkBtn:SetWidth(100)
        theFrame.IdInfoFrame.OkBtn:SetHeight(20)
        theFrame.IdInfoFrame.OkBtn:SetText(L["Ok"])
        theFrame.IdInfoFrame.OkBtn:SetPoint("BOTTOMRIGHT",theFrame.IdInfoFrame,"BOTTOMRIGHT",-15,15)
        theFrame.IdInfoFrame.OkBtn:SetScript("OnClick",function() this:GetParent():Hide() end)

        theFrame.IdInfoFrame.title = theFrame.IdInfoFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        theFrame.IdInfoFrame.title:SetTextColor(1,1,1)
        theFrame.IdInfoFrame.title:SetText(L["title IdInfo"])
        theFrame.IdInfoFrame.title:SetPoint("TOP",theFrame.IdInfoFrame,"TOP",0,-15)

		theFrame.IdInfoFrame.CharLabel = theFrame.IdInfoFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        theFrame.IdInfoFrame.CharLabel:SetTextColor(1,1,1)
        theFrame.IdInfoFrame.CharLabel:SetHeight(10)
        theFrame.IdInfoFrame.CharLabel:SetPoint("TOPLEFT",theFrame.IdInfoFrame,"TOPLEFT",20,-35)
        theFrame.IdInfoFrame.CharLabel:SetJustifyH("LEFT")
        theFrame.IdInfoFrame.CharLabel:SetText(L["Char"])

        theFrame.IdInfoFrame.CharDropdown = CreateFrame("Frame", "BT_IdInfoCharDropdown", theFrame.IdInfoFrame, "UIDropDownMenuTemplate");
        theFrame.IdInfoFrame.CharDropdown:SetPoint("TOPLEFT",theFrame.IdInfoFrame, "TOPLEFT", 10,-50)
        theFrame.IdInfoFrame.CharDropdown.selected = ""

        getglobal(theFrame.IdInfoFrame.CharDropdown:GetName().."Button"):SetScript("OnClick",function()
       		local tmp = {}
       		for i,v in pairs(self.db.profile.savedIds) do
				if(#v >0)then
					tinsert(tmp,{i,i})
				end
			end
       		self.currDropdownTable = {
            	["func"] = theFrame.IdInfoFrame.CharClick,
                ["values"] = tmp,
            }
       		ToggleDropDownMenu(1, nil, theFrame.IdInfoFrame.CharDropdown);
         end)

        UIDropDownMenu_SetWidth(theFrame.IdInfoFrame.CharDropdown,150)
        UIDropDownMenu_Initialize(theFrame.IdInfoFrame.CharDropdown, function () BossTactics:DropDownOneLevel_Initialize() end);

		theFrame.IdInfoFrame.CharClick = function(id, arg2)
			if(arg2)then
			 	id = arg2
			end
			UIDropDownMenu_SetText(theFrame.IdInfoFrame.CharDropdown, id)
			local idTable = self.db.profile.savedIds[id]
			local theFrame = self.MainWindow.IdInfoFrame.ScrollPanel
			for i,v in ipairs(theFrame.ids)do
		        v.instName:Hide()
                v.difficultyName:Hide()
                v.id:Hide()
                v.duration:Hide()
            end
            if(#theFrame.ids < #idTable)then
            	local diff = #idTable - #theFrame.ids
            	for i=1, diff, 1 do
            		local value = {}
            		value.instName = theFrame:CreateFontString(nil,"OVERLAY","NumberFontNormalYellow")
            		value.instName:SetJustifyH("LEFT")
      			 	value.instName:SetWidth(150)
      			 	value.difficultyName = theFrame:CreateFontString(nil,"OVERLAY","GameFontWhite")
            		value.difficultyName:SetJustifyH("LEFT")
      			 	value.difficultyName:SetWidth(150)
      			 	value.id = theFrame:CreateFontString(nil,"OVERLAY","GameFontWhite")
            		value.id:SetJustifyH("LEFT")
      			 	value.id:SetWidth(150)
      			 	value.duration = theFrame:CreateFontString(nil,"OVERLAY","GameFontWhite")
            		value.duration:SetJustifyH("LEFT")
      			 	value.duration:SetWidth(150)
      			 	tinsert(theFrame.ids,value)
            	end
            end
            local height = 0
	        for i,v in ipairs(idTable)do
                theFrame.ids[i].instName:Show()
                theFrame.ids[i].difficultyName:Show()
                theFrame.ids[i].id:Show()
                theFrame.ids[i].duration:Show()

                theFrame.ids[i].instName:SetText(v.instname)
                theFrame.ids[i].difficultyName:SetText(v.difficultyName)
                theFrame.ids[i].id:SetText(v.id)
                theFrame.ids[i].duration:SetText(SecondsToTime(v.resetTime))

                local normHeight = theFrame.ids[i].id:GetStringHeight()
                theFrame.ids[i].instName:SetPoint("TOPLEFT",theFrame,"TOPLEFT",15,height)
                height = height - theFrame.ids[i].instName:GetStringHeight()-3
                theFrame.ids[i].difficultyName:SetPoint("TOPLEFT",theFrame,"TOPLEFT",15,height)
                theFrame.ids[i].duration:SetPoint("TOPLEFT",theFrame,"TOPLEFT",180,height)
                height = height - normHeight-3
                theFrame.ids[i].id:SetPoint("TOPLEFT",theFrame,"TOPLEFT",15,height)
                height = height - normHeight-3

                height = height - 5

            end
			theFrame:SetHeight(-height)
		end

		theFrame.IdInfoFrame.IDScroll = CreateFrame("ScrollFrame","BT_IDResScroll",theFrame.IdInfoFrame,"UIPanelScrollFrameTemplate")
        theFrame.IdInfoFrame.IDScroll:ClearAllPoints()
        theFrame.IdInfoFrame.IDScroll:SetPoint("TOPLEFT",theFrame.IdInfoFrame, "TOPLEFT",15,-90)
        theFrame.IdInfoFrame.IDScroll:SetWidth(370)
        theFrame.IdInfoFrame.IDScroll:SetHeight(170)

       	theFrame.IdInfoFrame.ScrollFrame = CreateFrame("Frame","BT_IdInfoScrollBorder",theFrame.IdInfoFrame)
        theFrame.IdInfoFrame.ScrollFrame:SetBackdrop({
        edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
        })
        theFrame.IdInfoFrame.ScrollFrame:SetBackdropBorderColor(16/255,24/255,177/255)
        theFrame.IdInfoFrame.ScrollFrame:SetHeight(190)
        theFrame.IdInfoFrame.ScrollFrame:SetWidth(400)
        theFrame.IdInfoFrame.ScrollFrame:ClearAllPoints()
        theFrame.IdInfoFrame.ScrollFrame:SetPoint("TOPLEFT",theFrame.IdInfoFrame,"TOPLEFT",15,-80)

        theFrame.IdInfoFrame.ScrollPanel= CreateFrame("Frame","BT_IDScrollPanel",theFrame.IdInfoFrame.IDScroll)
        theFrame.IdInfoFrame.ScrollPanel:ClearAllPoints()
        theFrame.IdInfoFrame.ScrollPanel:SetWidth(460)
        theFrame.IdInfoFrame.ScrollPanel:SetHeight(300)
        theFrame.IdInfoFrame.ScrollPanel:SetPoint("TOPLEFT",theFrame.IdInfoFrame.IDScroll,"TOPLEFT",0,0)
        theFrame.IdInfoFrame.IDScroll:SetScrollChild(theFrame.IdInfoFrame.ScrollPanel)
        theFrame.IdInfoFrame.ScrollPanel.ids = {}

        for i,v in pairs(self.db.profile.savedIds) do
        	if(#v > 0)then
        		theFrame.IdInfoFrame:CharClick(i)
        		break
        	end
        end

        theFrame.IdInfoFrame.closebtn=CreateFrame("Button","BT_idframeclose",theFrame.IdInfoFrame)
        theFrame.IdInfoFrame.closebtn:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
        theFrame.IdInfoFrame.closebtn:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
        theFrame.IdInfoFrame.closebtn:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
        theFrame.IdInfoFrame.closebtn:SetWidth(20)
        theFrame.IdInfoFrame.closebtn:SetHeight(20)
        theFrame.IdInfoFrame.closebtn:SetPoint("TOPRIGHT",theFrame.IdInfoFrame,"TOPRIGHT",-5,-5)
        theFrame.IdInfoFrame.closebtn:SetScript("OnClick",function() this:GetParent():Hide() end)

    end
    theFrame.IdInfoFrame:Show()
	self:UpdateInstanceIDs()
end;

-----------------------------------------------------------------
--frame for configuration of the chat features
-----------------------------------------------------------------

function BossTactics:ShowChatConfigFrame()

	 if(self.ChatConfigFrame == nil)then
        self.ChatConfigFrame = CreateFrame("Frame","BT_ChatConfigFrame",UIParent)
        self.ChatConfigFrame:ClearAllPoints()
        self.ChatConfigFrame:SetPoint("CENTER",UIParent)
        self.ChatConfigFrame:SetHeight(180)
        self.ChatConfigFrame:SetWidth(430)
        self.ChatConfigFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        self.ChatConfigFrame:SetBackdropColor(1/255, 1/255, 1/255)

        self.ChatConfigFrame.OkBtn = CreateFrame("Button","BT_chaframe_ok",self.ChatConfigFrame,"UIPanelButtonTemplate")
        self.ChatConfigFrame.OkBtn:SetWidth(100)
        self.ChatConfigFrame.OkBtn:SetHeight(20)
        self.ChatConfigFrame.OkBtn:SetText(L["Ok"])
        self.ChatConfigFrame.OkBtn:SetPoint("BOTTOMRIGHT",self.ChatConfigFrame,"BOTTOMRIGHT",-15,15)
        self.ChatConfigFrame.OkBtn:SetScript("OnClick",function() this:GetParent():Hide() end)

        self.ChatConfigFrame.title = self.ChatConfigFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        self.ChatConfigFrame.title:SetTextColor(1,1,1)
        self.ChatConfigFrame.title:SetText(L["title ChatConfig"])
        self.ChatConfigFrame.title:SetPoint("TOP",self.ChatConfigFrame,"TOP",0,-15)

        self.ChatConfigFrame.ChannelBtn = CreateFrame("Button","BT_modeBtn",self.ChatConfigFrame,"UIPanelButtonTemplate")
        self.ChatConfigFrame.ChannelBtn:SetWidth(130)
        self.ChatConfigFrame.ChannelBtn:SetHeight(20)
        self.ChatConfigFrame.ChannelBtn:SetText(L["select channel"])
        self.ChatConfigFrame.ChannelBtn:SetPoint("TOPLEFT",self.ChatConfigFrame,"TOPLEFT",20,-50)
        self.ChatConfigFrame.ChannelBtn:SetScript("OnClick",function()
                        local tbl = {}
                        for i,v in ipairs (self.db.char.joinedChannelList)do
                        	local channinfo = self:GetChannelInfoFromId(v)
                        	tinsert(tbl, {channinfo.name,channinfo.name})
                        end
                        self.currDropdownTable = {
                                ["func"] = function (arg1) self:CannelConfDropdownClick(arg1) end,
                                ["values"] = tbl
                            }
                        ToggleDropDownMenu(1, nil, self.ChatConfigFrame.ChannelDropdown,this, 0, 0);
                          end)
        self.ChatConfigFrame.ChannelDropdown = CreateFrame("Frame", "BT_ChannelConfDropdown", self.ChatConfigFrame.ChannelBtn, "UIDropDownMenuTemplate");
        UIDropDownMenu_Initialize(self.ChatConfigFrame.ChannelDropdown, function () BossTactics:DropDownOneLevel_Initialize() end, "MENU");

        self.ChatConfigFrame.ColorLabel = self.ChatConfigFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        self.ChatConfigFrame.ColorLabel:SetTextColor(1,1,1)
        self.ChatConfigFrame.ColorLabel:SetText(L["Color"]..":")
        self.ChatConfigFrame.ColorLabel:SetPoint("TOPLEFT",self.ChatConfigFrame,"TOPLEFT",20,-85)

        self.ChatConfigFrame.ColorInput = CreateFrame("EditBox","BT_colorinputbox",self.ChatConfigFrame, "InputBoxTemplate")
		self.ChatConfigFrame.ColorInput:SetMaxLetters(6)
		self.ChatConfigFrame.ColorInput:SetPoint("TOPLEFT",self.ChatConfigFrame, "TOPLEFT", 70,-80)
		self.ChatConfigFrame.ColorInput:SetWidth(70);
		self.ChatConfigFrame.ColorInput:SetHeight(20);
		self.ChatConfigFrame.ColorInput:SetText("");
		self.ChatConfigFrame.ColorInput:SetAutoFocus(false);
		self.ChatConfigFrame.ColorInput:SetScript("OnEscapePressed", function()
					this:ClearFocus()
					end)

		self.ChatConfigFrame.ColorSelectBtn = CreateFrame("Button","BT_modeBtn",self.ChatConfigFrame,"UIPanelButtonTemplate")
        self.ChatConfigFrame.ColorSelectBtn:SetWidth(80)
        self.ChatConfigFrame.ColorSelectBtn:SetHeight(20)
        self.ChatConfigFrame.ColorSelectBtn:SetText(L["Color"])
        self.ChatConfigFrame.ColorSelectBtn:SetPoint("TOPLEFT",self.ChatConfigFrame,"TOPLEFT",145,-80)
        self.ChatConfigFrame.ColorSelectBtn:Disable()
        self.ChatConfigFrame.ColorSelectBtn:SetScript("OnClick",function()
                       local function Color_Change()
	                        local r, g, b = ColorPickerFrame:GetColorRGB()
                            BossTactics:UpdateColor(r,g,b)
                        end
                        local function Color_Abort(prevvals)
	                        local R,G,B = unpack(prevvals)
	                        BossTactics:UpdateColor(R,G,B)
                        end
                        ColorPickerFrame.func = Color_Change
                        ColorPickerFrame.cancelFunc = Color_Abort
                        local chaninfo = self:GetChannelInfoFromShortcut(this:GetParent().ChannelBtn:GetText())
                        local r,g,b = self:HexToRgb(chaninfo.color)
                        ColorPickerFrame.previousValues = {r, g, b}
                        ColorPickerFrame:SetColorRGB(r, g, b)
	    			    ColorPickerFrame:Show()
                          end)
        self.ChatConfigFrame.StdBtn = CreateFrame("Button","BT_modeBtn",self.ChatConfigFrame,"UIPanelButtonTemplate")
        self.ChatConfigFrame.StdBtn:SetWidth(180)
        self.ChatConfigFrame.StdBtn:SetHeight(20)
        self.ChatConfigFrame.StdBtn:SetText(L["Recover Standard"])
        self.ChatConfigFrame.StdBtn:SetPoint("TOPLEFT",self.ChatConfigFrame,"TOPLEFT",235,-80)
        self.ChatConfigFrame.StdBtn:Disable()
        self.ChatConfigFrame.StdBtn:SetScript("OnClick",function()
        		local selChan = self.ChatConfigFrame.ChannelBtn:GetText()
        		local def = self:GetDefaults()
        		local chaninfo = self:GetChannelInfoFromShortcut(selChan)
                if(selChan == BabbleClass["Druid"])then
		            self.db.profile.cdruid=def.profile.cdruid
		            self.ChatConfigFrame.ColorInput:SetText(def.profile.cdruid)
		            chaninfo.color = def.profile.cdruid
	            elseif(selChan == BabbleClass["Deathknight"])then
                    self.db.profile.cdeathknight=def.profile.deathknight
		            self.ChatConfigFrame.ColorInput:SetText(def.profile.cdeathknight)
		            chaninfo.color = def.profile.cdeathknight
                elseif(selChan == BabbleClass["Hunter"])then
                    self.db.profile.chunter=def.profile.chunter
		            self.ChatConfigFrame.ColorInput:SetText(def.profile.chunter)
		            chaninfo.color = def.profile.chunter
                elseif(selChan == BabbleClass["Mage"])then
                    self.db.profile.cmage=def.profile.cmage
		            self.ChatConfigFrame.ColorInput:SetText(def.profile.cmage)
		            chaninfo.color = def.profile.cmage
                elseif(selChan == BabbleClass["Paladin"])then
                    self.db.profile.cpaladin=def.profile.cpaladin
		            self.ChatConfigFrame.ColorInput:SetText(def.profile.cpaladin)
		            chaninfo.color = def.profile.cpaladin
                elseif(selChan == BabbleClass["Priest"])then
                    self.db.profile.cpriest=def.profile.cpriest
		            self.ChatConfigFrame.ColorInput:SetText(def.profile.cpriest)
		            chaninfo.color = def.profile.cpriest
                elseif(selChan == BabbleClass["Rogue"])then
                    self.db.profile.crogue=def.profile.crogue
		            self.ChatConfigFrame.ColorInput:SetText(def.profile.crogue)
		            chaninfo.color = def.profile.crogue
                elseif(selChan == BabbleClass["Shaman"])then
                    self.db.profile.cshaman=def.profile.cshaman
		            self.ChatConfigFrame.ColorInput:SetText(def.profile.cshaman)
		            chaninfo.color = def.profile.cshaman
                elseif(selChan == BabbleClass["Warlock"])then
                    self.db.profile.cwarlock=def.profile.cwarlock
		            self.ChatConfigFrame.ColorInput:SetText(def.profile.cwarlock)
		            chaninfo.color = def.profile.cwarlock
                elseif(selChan == BabbleClass["Warrior"])then
                   self.db.profile.cwarrior=def.profile.cwarrior
		            self.ChatConfigFrame.ColorInput:SetText(def.profile.cwarrior)
		            chaninfo.color = def.profile.cwarrior
                elseif(selChan == L["tank"])then
                    self.db.profile.ctank=def.profile.ctank
		            self.ChatConfigFrame.ColorInput:SetText(def.profile.ctank)
		            chaninfo.color = def.profile.ctank
                elseif(selChan == L["healer"])then
                    self.db.profile.chealer=def.profile.chealer
		            self.ChatConfigFrame.ColorInput:SetText(def.profile.chealer)
		            chaninfo.color = def.profile.chealer
                elseif(selChan == L["ranged DPS"])then
                    self.db.profile.cdd=def.profile.cdd
		            self.ChatConfigFrame.ColorInput:SetText(def.profile.cdd)
		            chaninfo.color = def.profile.cdd
                elseif(selChan == L["melee"])then
                    self.db.profile.cmelee=def.profile.cmelee
		            self.ChatConfigFrame.ColorInput:SetText(def.profile.cmelee)
		            chaninfo.color = def.profile.cmelee
                end
                          end)


        self.ChatConfigFrame.closebtn=CreateFrame("Button","BT_chatframeclose",self.ChatConfigFrame)
        self.ChatConfigFrame.closebtn:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
        self.ChatConfigFrame.closebtn:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
        self.ChatConfigFrame.closebtn:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
        self.ChatConfigFrame.closebtn:SetWidth(20)
        self.ChatConfigFrame.closebtn:SetHeight(20)
        self.ChatConfigFrame.closebtn:SetPoint("TOPRIGHT",self.ChatConfigFrame,"TOPRIGHT",-5,-5)
        self.ChatConfigFrame.closebtn:SetScript("OnClick",function() this:GetParent():Hide() end)

    end
    self.ChatConfigFrame:Show()
    if(self.MainWindow) then
        self.ChatConfigFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+20)
        self.ChatConfigFrame.OkBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)
        self.ChatConfigFrame.closebtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)
    end

end;

function BossTactics:CannelConfDropdownClick(chan)

	local chaninfo = self:GetChannelInfoFromShortcut(chan)
	self.ChatConfigFrame.ChannelBtn:SetText(chan)
	self.ChatConfigFrame.ColorInput:SetText(chaninfo.color)
	self.ChatConfigFrame.StdBtn:Enable()
	self.ChatConfigFrame.ColorSelectBtn:Enable()

end

---------------------------------------------------------
--- Shows the Task Manager
---------------------------------------------------------

function BossTactics:ShowTaskManager(taskInfo)
	local theFrame = self.MainWindow
    if(theFrame.TaskManagerFrame == nil)then
        theFrame.TaskManagerFrame = CreateFrame("Frame","BT_TaskManagerframe",theFrame)
        theFrame.TaskManagerFrame:ClearAllPoints()
        theFrame.TaskManagerFrame:SetPoint("CENTER",theFrame)
        theFrame.TaskManagerFrame:SetHeight(420)
        theFrame.TaskManagerFrame:SetWidth(540)
        theFrame.TaskManagerFrame:EnableMouse(true)
        theFrame.TaskManagerFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        theFrame.TaskManagerFrame:SetBackdropColor(1/255, 1/255, 1/255)

        theFrame.TaskManagerFrame.Title = theFrame.TaskManagerFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        theFrame.TaskManagerFrame.Title:SetTextColor(1,1,1)
        theFrame.TaskManagerFrame.Title:SetHeight(20)
        theFrame.TaskManagerFrame.Title:SetText(L["Task Manager"])
        theFrame.TaskManagerFrame.Title:SetPoint("TOP",theFrame.TaskManagerFrame,"TOP",0,-10)
        theFrame.TaskManagerFrame.Title:SetJustifyH("LEFT")

        theFrame.TaskManagerFrame.TaskLabel = theFrame.TaskManagerFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        theFrame.TaskManagerFrame.TaskLabel:SetTextColor(1,1,1)
        theFrame.TaskManagerFrame.TaskLabel:SetHeight(10)
        theFrame.TaskManagerFrame.TaskLabel:SetPoint("TOPLEFT",theFrame.TaskManagerFrame,"TOPLEFT",20,-45)
        theFrame.TaskManagerFrame.TaskLabel:SetJustifyH("LEFT")

        theFrame.TaskManagerFrame.TaskDropdown = CreateFrame("Frame", "BT_TaskManagerTaskDropdown", theFrame.TaskManagerFrame, "UIDropDownMenuTemplate");
        theFrame.TaskManagerFrame.TaskDropdown:SetPoint("TOPLEFT",theFrame.TaskManagerFrame, "TOPLEFT", 10,-60)
        theFrame.TaskManagerFrame.TaskDropdown.selected = L["tank"]

        getglobal(theFrame.TaskManagerFrame.TaskDropdown:GetName().."Button"):SetScript("OnClick",function()
       		self.currDropdownTable = {
            	["func"] = theFrame.TaskManagerFrame.taskInfo.Task.Click,
                ["values"] = theFrame.TaskManagerFrame.taskInfo.Task:Values(),
            }
       		ToggleDropDownMenu(1, nil, theFrame.TaskManagerFrame.TaskDropdown);
         end)

        UIDropDownMenu_SetWidth(theFrame.TaskManagerFrame.TaskDropdown,100)
        UIDropDownMenu_Initialize(theFrame.TaskManagerFrame.TaskDropdown, function () BossTactics:DropDownOneLevel_Initialize() end);

        theFrame.TaskManagerFrame.PlayerLabel = theFrame.TaskManagerFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        theFrame.TaskManagerFrame.PlayerLabel:SetTextColor(1,1,1)
        theFrame.TaskManagerFrame.PlayerLabel:SetHeight(10)
        theFrame.TaskManagerFrame.PlayerLabel:SetPoint("TOPLEFT",theFrame.TaskManagerFrame,"TOPLEFT",140,-45)
        theFrame.TaskManagerFrame.PlayerLabel:SetJustifyH("LEFT")

        theFrame.TaskManagerFrame.PlayerDropdown = CreateFrame("Frame", "BT_TaskManagerPlayerDropdown", theFrame.TaskManagerFrame, "UIDropDownMenuTemplate");
        theFrame.TaskManagerFrame.PlayerDropdown.selected = ""
        theFrame.TaskManagerFrame.PlayerDropdown:SetPoint("TOPLEFT",theFrame.TaskManagerFrame, "TOPLEFT", 130,-60)
        getglobal(theFrame.TaskManagerFrame.PlayerDropdown:GetName().."Button"):SetScript("OnClick",function()
       		self.currDropdownTable = {
            	["func"] = theFrame.TaskManagerFrame.taskInfo.Player1.Click,
                ["values"] = theFrame.TaskManagerFrame.taskInfo.Player1:Values(),
            }
       		ToggleDropDownMenu(1, nil, theFrame.TaskManagerFrame.PlayerDropdown);
         end)
        UIDropDownMenu_SetWidth(theFrame.TaskManagerFrame.PlayerDropdown,100)
        UIDropDownMenu_Initialize(theFrame.TaskManagerFrame.PlayerDropdown, function () BossTactics:DropDownOneLevel_Initialize() end);
         theFrame.TaskManagerFrame.PlayerNames = {}
         theFrame.TaskManagerFrame.DeleteBtns = {}
         theFrame.TaskManagerFrame.CurrPlayerCount = 0
         theFrame.TaskManagerFrame.CurrPlayerX = 20
         theFrame.TaskManagerFrame.CurrPlayerY = -100
         theFrame.TaskManagerFrame.AddPlayer = function(text,text2)
         	if(type(text) == "table")then text = text2 end
         	local nextId = theFrame.TaskManagerFrame.CurrPlayerCount+1
         	if(nextId > 10)then

				return
         	end
         	for i,v in ipairs(theFrame.TaskManagerFrame.PlayerNames)do
         		if(v.str:GetText() == text and not v.deleted)then
         			return
         		end
         	end
         	if(not theFrame.TaskManagerFrame.PlayerNames[nextId])then
         		theFrame.TaskManagerFrame.PlayerNames[nextId] =  CreateFrame("Frame","BT_TaskName"..nextId,theFrame.TaskManagerFrame)
         		theFrame.TaskManagerFrame.PlayerNames[nextId].str = theFrame.TaskManagerFrame.PlayerNames[nextId]:CreateFontString(nil,"OVERLAY","GameFontNormal")
         		theFrame.TaskManagerFrame.PlayerNames[nextId]:EnableMouse(true)
         		theFrame.TaskManagerFrame.PlayerNames[nextId]:SetScript("OnMouseUp", function()
         			 theFrame.TaskManagerFrame.ChangeInput.inserted = true
         			 theFrame.TaskManagerFrame.taskInfo:Select(this.str:GetText())
         			 theFrame.TaskManagerFrame.ChangeInput.selected = strsub(this.str:GetText(),11,-3)
         		end)
         		theFrame.TaskManagerFrame.PlayerNames[nextId]:SetHeight(20)
         		theFrame.TaskManagerFrame.PlayerNames[nextId].str:SetPoint("TOPLEFT",theFrame.TaskManagerFrame.PlayerNames[nextId],"TOPLEFT",0,0)
         		theFrame.TaskManagerFrame.DeleteBtns[nextId] = CreateFrame("Frame","BT_TaskDel"..nextId,theFrame.TaskManagerFrame)
         		theFrame.TaskManagerFrame.DeleteBtns[nextId]:EnableMouse(true)
         		theFrame.TaskManagerFrame.DeleteBtns[nextId]:SetScript("OnMouseUp", function()
         			this.deleted = true
         			theFrame.TaskManagerFrame.CurrPlayerX = 20
         			theFrame.TaskManagerFrame.CurrPlayerY = -100
         			local found = false
         			local ind = 0
         			for i,v in ipairs(theFrame.TaskManagerFrame.DeleteBtns)do
         				if(v.deleted) then
         					ind = i
         					break
         				end
         			end
         			theFrame.TaskManagerFrame.PlayerNames[ind].deleted = true
         			for i,v in ipairs(theFrame.TaskManagerFrame.PlayerNames)do
         				local w = v.str:GetStringWidth()
         				if(theFrame.TaskManagerFrame.CurrPlayerX + w + 21 > 400)then
         		            theFrame.TaskManagerFrame.CurrPlayerX = 20
                            theFrame.TaskManagerFrame.CurrPlayerY = -102-v.str:GetStringHeight()
                        end
         				if(v.deleted and not found)then
         					theFrame.TaskManagerFrame.DeleteBtns[i]:Hide()
         					v:Hide()
         					theFrame.TaskManagerFrame.taskInfo.Player1:Delete(v.str:GetText())
         					theFrame.TaskManagerFrame.CurrPlayerCount = theFrame.TaskManagerFrame.CurrPlayerCount-1
         					found = true
         				elseif(not v.deleted)then
         					if(found)then
         						v:ClearAllPoints()
         						theFrame.TaskManagerFrame.DeleteBtns[i]:ClearAllPoints()
         						theFrame.TaskManagerFrame.DeleteBtns[i]:SetPoint("TOPLEFT",theFrame.TaskManagerFrame,"TOPLEFT",w+3+theFrame.TaskManagerFrame.CurrPlayerX,theFrame.TaskManagerFrame.CurrPlayerY)
         	v:SetPoint("TOPLEFT",theFrame.TaskManagerFrame,"TOPLEFT",theFrame.TaskManagerFrame.CurrPlayerX,theFrame.TaskManagerFrame.CurrPlayerY)
         					end
         					theFrame.TaskManagerFrame.CurrPlayerX = theFrame.TaskManagerFrame.CurrPlayerX + 21 + w
         				end
         			end
         			for i,v in ipairs(theFrame.TaskManagerFrame.PlayerNames)do
         			    if(v.deleted)then
         			        tinsert(theFrame.TaskManagerFrame.PlayerNames, tremove(theFrame.TaskManagerFrame.PlayerNames,i))
                            tinsert(theFrame.TaskManagerFrame.DeleteBtns, tremove(theFrame.TaskManagerFrame.DeleteBtns,i))
                            break
                    	end
         			end
         			theFrame.TaskManagerFrame.ChangeInput:SetText("")
         		end)
         		theFrame.TaskManagerFrame.DeleteBtns[nextId].tx = theFrame.TaskManagerFrame.DeleteBtns[nextId]:CreateTexture("BT_taskTx"..nextId,"BACKGROUND")
         		theFrame.TaskManagerFrame.DeleteBtns[nextId]:SetWidth(15)
         		theFrame.TaskManagerFrame.DeleteBtns[nextId]:SetHeight(15)
         		theFrame.TaskManagerFrame.DeleteBtns[nextId].tx:SetAllPoints(theFrame.TaskManagerFrame.DeleteBtns[nextId])
         		theFrame.TaskManagerFrame.DeleteBtns[nextId].tx:SetTexture("Interface\\RAIDFRAME\\ReadyCheck-NotReady")
         	end
         	theFrame.TaskManagerFrame.PlayerNames[nextId].deleted=false
         	theFrame.TaskManagerFrame.DeleteBtns[nextId].deleted=false
         	theFrame.TaskManagerFrame.PlayerNames[nextId]:Show()
         	theFrame.TaskManagerFrame.DeleteBtns[nextId]:Show()
         	theFrame.TaskManagerFrame.PlayerNames[nextId].str:SetText(text)
         	local w = theFrame.TaskManagerFrame.PlayerNames[nextId].str:GetStringWidth()
         	if(theFrame.TaskManagerFrame.CurrPlayerX + w + 21 > 400)then
         		theFrame.TaskManagerFrame.CurrPlayerX = 20
         		theFrame.TaskManagerFrame.CurrPlayerY = -102-theFrame.TaskManagerFrame.PlayerNames[nextId].str:GetStringHeight()
         	end
         	theFrame.TaskManagerFrame.PlayerNames[nextId]:ClearAllPoints()
         	theFrame.TaskManagerFrame.DeleteBtns[nextId]:ClearAllPoints()
         	theFrame.TaskManagerFrame.PlayerNames[nextId]:SetWidth(w)
         	theFrame.TaskManagerFrame.DeleteBtns[nextId]:SetPoint("TOPLEFT",theFrame.TaskManagerFrame,"TOPLEFT",w+3+theFrame.TaskManagerFrame.CurrPlayerX,theFrame.TaskManagerFrame.CurrPlayerY)
         	theFrame.TaskManagerFrame.PlayerNames[nextId]:SetPoint("TOPLEFT",theFrame.TaskManagerFrame,"TOPLEFT",theFrame.TaskManagerFrame.CurrPlayerX,theFrame.TaskManagerFrame.CurrPlayerY)
         	theFrame.TaskManagerFrame.CurrPlayerX = theFrame.TaskManagerFrame.CurrPlayerX + 21 + w
         	theFrame.TaskManagerFrame.CurrPlayerCount = theFrame.TaskManagerFrame.CurrPlayerCount+1
        	 end

       	theFrame.TaskManagerFrame.Clean = function ()
       		theFrame.TaskManagerFrame.CurrPlayerX = 20
         	theFrame.TaskManagerFrame.CurrPlayerY = -100
         	theFrame.TaskManagerFrame.CurrPlayerCount = 0
       		for i,v in ipairs(theFrame.TaskManagerFrame.PlayerNames)do
       			if(not v.deleted)then
       				v.deleted = true
       				theFrame.TaskManagerFrame.DeleteBtns[i].deleted = true
       				v:Hide()
       				theFrame.TaskManagerFrame.DeleteBtns[i]:Hide()
       			else
       				break
       			end
       		end
       		theFrame.TaskManagerFrame.TaskInput:SetText("")
       		theFrame.TaskManagerFrame.TaskInput.tmpOld = ""
       	end

        theFrame.TaskManagerFrame.Player2Label = theFrame.TaskManagerFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        theFrame.TaskManagerFrame.Player2Label:SetTextColor(1,1,1)
        theFrame.TaskManagerFrame.Player2Label:SetHeight(10)
        theFrame.TaskManagerFrame.Player2Label:SetPoint("TOPLEFT",theFrame.TaskManagerFrame,"TOPLEFT",260,-45)
        theFrame.TaskManagerFrame.Player2Label:SetJustifyH("LEFT")

        theFrame.TaskManagerFrame.Player2Dropdown = CreateFrame("Frame", "BT_TaskManagerPlayer2Dropdown", theFrame.TaskManagerFrame, "UIDropDownMenuTemplate");
        theFrame.TaskManagerFrame.Player2Dropdown.selected = ""
        theFrame.TaskManagerFrame.Player2Dropdown:SetPoint("TOPLEFT",theFrame.TaskManagerFrame, "TOPLEFT", 250,-60)
        getglobal(theFrame.TaskManagerFrame.Player2Dropdown:GetName().."Button"):SetScript("OnClick",function()
       		self.currDropdownTable = {
            	["func"] = theFrame.TaskManagerFrame.taskInfo.Player2.Click,
                ["values"] = theFrame.TaskManagerFrame.taskInfo.Player2:Values(),
            }
       		ToggleDropDownMenu(1, nil, theFrame.TaskManagerFrame.Player2Dropdown);
         end)
         UIDropDownMenu_SetWidth(theFrame.TaskManagerFrame.Player2Dropdown,100)
        UIDropDownMenu_Initialize(theFrame.TaskManagerFrame.Player2Dropdown, function () BossTactics:DropDownOneLevel_Initialize() end);
        theFrame.TaskManagerFrame.Player2Dropdown:Hide()
        theFrame.TaskManagerFrame.Player2Label:Hide()

        theFrame.TaskManagerFrame.Player3Label = theFrame.TaskManagerFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        theFrame.TaskManagerFrame.Player3Label:SetTextColor(1,1,1)
        theFrame.TaskManagerFrame.Player3Label:SetHeight(10)
        theFrame.TaskManagerFrame.Player3Label:SetText(L["Player:"])
        theFrame.TaskManagerFrame.Player3Label:SetPoint("TOPLEFT",theFrame.TaskManagerFrame,"TOPLEFT",380,-45)
        theFrame.TaskManagerFrame.Player3Label:SetJustifyH("LEFT")

        theFrame.TaskManagerFrame.Player3Dropdown = CreateFrame("Frame", "BT_TaskManagerPlayer3Dropdown", theFrame.TaskManagerFrame, "UIDropDownMenuTemplate");
        theFrame.TaskManagerFrame.Player3Dropdown.selected = ""
        theFrame.TaskManagerFrame.Player3Dropdown:SetPoint("TOPLEFT",theFrame.TaskManagerFrame, "TOPLEFT", 370,-60)
        getglobal(theFrame.TaskManagerFrame.Player3Dropdown:GetName().."Button"):SetScript("OnClick",function()

       		self.currDropdownTable = {
            	["func"] = theFrame.TaskManagerFrame.taskInfo.Player3.Click,
                ["values"] = theFrame.TaskManagerFrame.taskInfo.Player3:Values(),
            }
       		ToggleDropDownMenu(1, nil, theFrame.TaskManagerFrame.Player3Dropdown);
         end)
         UIDropDownMenu_SetWidth(theFrame.TaskManagerFrame.Player3Dropdown,100)
        UIDropDownMenu_Initialize(theFrame.TaskManagerFrame.Player3Dropdown, function () BossTactics:DropDownOneLevel_Initialize() end);
        theFrame.TaskManagerFrame.Player3Dropdown:Hide()
        theFrame.TaskManagerFrame.Player3Label:Hide()

        theFrame.TaskManagerFrame.TaskScroll = CreateFrame("ScrollFrame","BT_TaskScroll",theFrame.TaskManagerFrame,"UIPanelScrollFrameTemplate")
        theFrame.TaskManagerFrame.TaskScroll:ClearAllPoints()
        theFrame.TaskManagerFrame.TaskScroll:SetPoint("TOPLEFT",theFrame.TaskManagerFrame, "TOPLEFT",100,-140)
        theFrame.TaskManagerFrame.TaskScroll:SetWidth(300)
        theFrame.TaskManagerFrame.TaskScroll:SetHeight(100)

        theFrame.TaskManagerFrame.ScrollFrame = CreateFrame("Frame","BT_TaskmanagerScrollBorder",theFrame.TaskManagerFrame)
        theFrame.TaskManagerFrame.ScrollFrame:SetBackdrop({
        edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
        })
        theFrame.TaskManagerFrame.ScrollFrame:SetBackdropBorderColor(16/255,24/255,177/255)
        theFrame.TaskManagerFrame.ScrollFrame:SetHeight(120)
        theFrame.TaskManagerFrame.ScrollFrame:SetWidth(335)
        theFrame.TaskManagerFrame.ScrollFrame:ClearAllPoints()
        theFrame.TaskManagerFrame.ScrollFrame:SetPoint("TOPLEFT",theFrame.TaskManagerFrame,"TOPLEFT",95,-130)

        theFrame.TaskManagerFrame.TaskInput= CreateFrame("EditBox","BT_TaskInputEdit",theFrame.TaskManagerFrame.TaskScroll)
        theFrame.TaskManagerFrame.TaskInput:ClearAllPoints()
        theFrame.TaskManagerFrame.TaskInput:SetWidth(300)
        theFrame.TaskManagerFrame.TaskInput:SetHeight(100)
        theFrame.TaskManagerFrame.TaskInput:SetPoint("TOPLEFT",theFrame.TaskManagerFrame.TaskScroll,"TOPLEFT",0,0)
        theFrame.TaskManagerFrame.TaskScroll:SetScrollChild(theFrame.TaskManagerFrame.TaskInput)
        theFrame.TaskManagerFrame.TaskInput:SetAutoFocus(false)
        theFrame.TaskManagerFrame.TaskInput:SetScript("OnEscapePressed", function()
                    this:ClearFocus()
                        end)
        theFrame.TaskManagerFrame.TaskInput:SetScript("OnTextChanged", function()
                 ScrollingEdit_OnTextChanged(this, this:GetParent())
                end)
        theFrame.TaskManagerFrame.TestFontStr = theFrame.TaskManagerFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        theFrame.TaskManagerFrame.TestFontStr:Hide()

        theFrame.TaskManagerFrame.TaskInput:SetScript("OnCursorChanged", function()
                 ScrollingEdit_OnCursorChanged(this, arg1, arg2-10, arg3, arg4)
                 if(strlen(this:GetText())>0)then
                 	local spl = {strsplit("\n",this:GetText())}
                 	local line = self:round(arg2/arg4)+1
                 	local currlines = 0
                    for i,v in ipairs(spl)do
                       theFrame.TaskManagerFrame.TestFontStr:SetText(v)
                       local len = theFrame.TaskManagerFrame.TestFontStr:GetStringWidth()
                        local anzlines = floor(len/280)
                        currlines = currlines+anzlines+1
                        if(currlines >= line)then
                            line = i
                            break
                        end
                    end
                    theFrame.TaskManagerFrame.ChangeInput.inserted = true
                 	theFrame.TaskManagerFrame.taskInfo:CursorChange(line)
                 end
                  end)
        theFrame.TaskManagerFrame.TaskInput:SetScript("OnUpdate", function()
                 ScrollingEdit_OnUpdate(this, this:GetParent())
                  end)
    	 theFrame.TaskManagerFrame.TaskInput:SetScript("OnTextChanged", function(text)
                        	local curs = this:GetCursorPosition()
                        	this:SetText(this.tmpOld)
                        	this:SetCursorPosition(curs-1)
                        end)
    	theFrame.TaskManagerFrame.TaskInput:SetMultiLine(true)
        theFrame.TaskManagerFrame.TaskInput:EnableMouse(true)
        theFrame.TaskManagerFrame.TaskInput:SetFont("Fonts\\FRIZQT__.TTF",12)
        theFrame.TaskManagerFrame.TaskInput:SetTextColor(1,1,1)
        theFrame.TaskManagerFrame.TaskInput:SetTextInsets(10,10,10,10)

        theFrame.TaskManagerFrame.ChangeInput = CreateFrame("EditBox","BT_taskman_input",theFrame.TaskManagerFrame, "InputBoxTemplate")
        theFrame.TaskManagerFrame.ChangeInput:SetMaxLetters(200)
        theFrame.TaskManagerFrame.ChangeInput:SetPoint("TOPLEFT", theFrame.TaskManagerFrame, "TOPLEFT", 95,-270)
        theFrame.TaskManagerFrame.ChangeInput:SetWidth(350);
        theFrame.TaskManagerFrame.ChangeInput:SetHeight(20);
        theFrame.TaskManagerFrame.ChangeInput:SetAutoFocus(false)
        theFrame.TaskManagerFrame.ChangeInput.tmpOld = ""

        theFrame.TaskManagerFrame.ChangeInput:SetScript("OnEnterPressed", function()
        			if(strlen(this:GetText())>0)then
                        theFrame.TaskManagerFrame.taskInfo:Save(this.selected,strsub(this:GetText(),strlen(this.selected)+14))
                        this:SetText("")
                    end
                    theFrame.TaskManagerFrame.Ok2Btn:Hide()
                    end)
        theFrame.TaskManagerFrame.ChangeInput:SetScript("OnEscapePressed", function()
                    this:ClearFocus()
                    end)
        theFrame.TaskManagerFrame.ChangeInput:SetScript("OnTextChanged", function()
                if(strlen(this:GetText())>0)then
                	theFrame.TaskManagerFrame.Ok2Btn:Show()
                end
                if(this.inserted)then
                	this.inserted = false
                	return
                end
                local curs = this:GetCursorPosition()
        		local find,ende = strfind(this.tmpOld,"|r")
                if(find and curs <= find)then
                    this:SetText(this.tmpOld)
                    if(ende == strlen(this.tmpOld))then
                    	this:SetText(this.tmpOld.." ")
                    else
                    	this:SetText(this.tmpOld)
					end
                    this:SetCursorPosition(curs)
                else
                    this.tmpOld = this:GetText()
                end
                end)

        theFrame.TaskManagerFrame.PostBtn = CreateFrame("Button","BT_TaskManager_Post",theFrame.TaskManagerFrame,"UIPanelButtonTemplate")
        theFrame.TaskManagerFrame.PostBtn:SetWidth(80)
        theFrame.TaskManagerFrame.PostBtn:SetHeight(20)
        theFrame.TaskManagerFrame.PostBtn:SetText(L["Post"])
        theFrame.TaskManagerFrame.PostBtn:SetPoint("TOPLEFT",theFrame.TaskManagerFrame,"TOPLEFT",30,-310)
        theFrame.TaskManagerFrame.PostBtn:SetScript("OnClick",function()
        		theFrame.TaskManagerFrame.taskInfo:Post(theFrame.TaskManagerFrame.TaskDropdown.selected)
          end)

        theFrame.TaskManagerFrame.PostAllBtn = CreateFrame("Button","BT_TaskManager_PostAll",theFrame.TaskManagerFrame,"UIPanelButtonTemplate")
        theFrame.TaskManagerFrame.PostAllBtn:SetWidth(100)
        theFrame.TaskManagerFrame.PostAllBtn:SetHeight(20)
        theFrame.TaskManagerFrame.PostAllBtn:SetText(L["PostAll"])
        theFrame.TaskManagerFrame.PostAllBtn:SetPoint("TOPLEFT",theFrame.TaskManagerFrame,"TOPLEFT",120,-310)
        theFrame.TaskManagerFrame.PostAllBtn:SetScript("OnClick",function()
        	theFrame.TaskManagerFrame.taskInfo:PostAll()
          end)


        theFrame.TaskManagerFrame.OkBtn = CreateFrame("Button","BT_TaskManager_ok",theFrame.TaskManagerFrame,"UIPanelButtonTemplate")
        theFrame.TaskManagerFrame.OkBtn:SetWidth(100)
        theFrame.TaskManagerFrame.OkBtn:SetHeight(20)
        theFrame.TaskManagerFrame.OkBtn:SetText(L["Ok"])
        theFrame.TaskManagerFrame.OkBtn:SetPoint("BOTTOM",theFrame.TaskManagerFrame,"BOTTOM",0,15)
        theFrame.TaskManagerFrame.OkBtn:SetScript("OnClick",function()
        	if(theFrame.TaskManagerFrame.taskInfo.CloseAction)then
        		theFrame.TaskManagerFrame.taskInfo:CloseAction()
        	end
        	this:GetParent():Hide()
        end)

        theFrame.TaskManagerFrame.Ok2Btn = CreateFrame("Button","BT_TaskManager_Ok2",theFrame.TaskManagerFrame,"UIPanelButtonTemplate")
        theFrame.TaskManagerFrame.Ok2Btn:SetWidth(30)
        theFrame.TaskManagerFrame.Ok2Btn:SetHeight(20)
        theFrame.TaskManagerFrame.Ok2Btn:SetText(L["Ok"])
        theFrame.TaskManagerFrame.Ok2Btn:SetPoint("TOPLEFT", theFrame.TaskManagerFrame, "TOPLEFT", 450,-270)
        theFrame.TaskManagerFrame.Ok2Btn:SetScript("OnClick",function()
			local text = theFrame.TaskManagerFrame.ChangeInput
			if(strlen(theFrame.TaskManagerFrame.ChangeInput:GetText())>0)then
            	theFrame.TaskManagerFrame.taskInfo:Save(text.selected,strsub(text:GetText(),strlen(text.selected)+14))
                theFrame.TaskManagerFrame.ChangeInput:SetText("")
            end
            this:Hide()
         end)
        theFrame.TaskManagerFrame.closebtn=CreateFrame("Button","BT_TaskManagerclose",theFrame.TaskManagerFrame)
        theFrame.TaskManagerFrame.closebtn:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
        theFrame.TaskManagerFrame.closebtn:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
        theFrame.TaskManagerFrame.closebtn:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
        theFrame.TaskManagerFrame.closebtn:SetWidth(20)
        theFrame.TaskManagerFrame.closebtn:SetHeight(20)
        theFrame.TaskManagerFrame.closebtn:SetPoint("TOPRIGHT",theFrame.TaskManagerFrame,"TOPRIGHT",-5,-5)
        theFrame.TaskManagerFrame.closebtn:SetScript("OnClick",function()
        	if(theFrame.TaskManagerFrame.taskInfo.CloseAction)then
        		theFrame.TaskManagerFrame.taskInfo:CloseAction()
        	end
        	this:GetParent():Hide()
        end)

        theFrame.TaskManagerFrame.TaskManagerWhisper = function (arg1,target,whisper)
        	theFrame.TaskManagerFrame.taskInfo:HandleWhisper(target,whisper)
        end
    end
    theFrame.TaskManagerFrame.taskInfo = taskInfo
    taskInfo.Task:Init()
    theFrame.TaskManagerFrame.TaskLabel:SetText(taskInfo.Task.Label)
    theFrame.TaskManagerFrame.PlayerLabel:SetText(taskInfo.Player1.Label)
    taskInfo.Player1:Init()
    if(taskInfo.Player2)then
    	theFrame.TaskManagerFrame.Player2Label:SetText(taskInfo.Player2.Label)
    	taskInfo.Player2:Init()
    end
    if(taskInfo.Player3)then
    	theFrame.TaskManagerFrame.Player3Label:SetText(taskInfo.Player3.Label)
    	taskInfo.Player3:Init()
    end
    if(taskInfo.showInputChange)then
    	theFrame.TaskManagerFrame.Ok2Btn:Show()
    	theFrame.TaskManagerFrame.ChangeInput:Show()
    else
    	theFrame.TaskManagerFrame.Ok2Btn:Hide()
    	theFrame.TaskManagerFrame.ChangeInput:Hide()
    end
    theFrame.TaskManagerFrame:Show()
    if(theFrame) then
        theFrame.TaskManagerFrame:SetFrameLevel(theFrame:GetFrameLevel()+20)
    end

end;

---------------------------------------------------------
--- Shows the Query Manager
---------------------------------------------------------

function BossTactics:ShowQueryManager()
	local theFrame = self.MainWindow

    if(theFrame.QueryManagerFrame == nil)then
        theFrame.QueryManagerFrame = CreateFrame("Frame","BT_QueryManagerframe",theFrame)
        theFrame.QueryManagerFrame:ClearAllPoints()
        theFrame.QueryManagerFrame:SetPoint("CENTER",theFrame.MainWindow)
        theFrame.QueryManagerFrame:SetHeight(290)
        theFrame.QueryManagerFrame:SetWidth(540)
        theFrame.QueryManagerFrame:EnableMouse(true)
        theFrame.QueryManagerFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        theFrame.QueryManagerFrame:SetBackdropColor(1/255, 1/255, 1/255)

        theFrame.QueryManagerFrame.Title = theFrame.QueryManagerFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        theFrame.QueryManagerFrame.Title:SetTextColor(1,1,1)
        theFrame.QueryManagerFrame.Title:SetHeight(20)
        theFrame.QueryManagerFrame.Title:SetText(L["Query Manager"])
        theFrame.QueryManagerFrame.Title:SetPoint("TOP",theFrame.QueryManagerFrame,"TOP",0,-10)
        theFrame.QueryManagerFrame.Title:SetJustifyH("LEFT")

        theFrame.QueryManagerFrame.TypeLabel = theFrame.QueryManagerFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        theFrame.QueryManagerFrame.TypeLabel:SetTextColor(1,1,1)
        theFrame.QueryManagerFrame.TypeLabel:SetHeight(10)
        theFrame.QueryManagerFrame.TypeLabel:SetText(L["Type:"])
        theFrame.QueryManagerFrame.TypeLabel:SetPoint("TOPLEFT",theFrame.QueryManagerFrame,"TOPLEFT",20,-45)
        theFrame.QueryManagerFrame.TypeLabel:SetJustifyH("LEFT")

        theFrame.QueryManagerFrame.TypeDropdown = CreateFrame("Frame", "BT_QueryManagerTypeDropdown", theFrame.QueryManagerFrame, "UIDropDownMenuTemplate");
        theFrame.QueryManagerFrame.TypeDropdown:SetPoint("TOPLEFT",theFrame.QueryManagerFrame, "TOPLEFT", 10,-60)
        theFrame.QueryManagerFrame.TypeDropdown.selected = "Addons"
        UIDropDownMenu_SetWidth(theFrame.QueryManagerFrame.TypeDropdown,100)
        UIDropDownMenu_Initialize(theFrame.QueryManagerFrame.TypeDropdown, function () BossTactics:DropDownOneLevel_Initialize() end);
        getglobal(theFrame.QueryManagerFrame.TypeDropdown:GetName().."Button"):SetScript("OnClick",function()
       		self.currDropdownTable = {
            	["func"] = function (arg1) self:QueryManagerTypeDropdownClick(arg1) end,
                ["values"] = {{"Addons","Addons"}, {"Items","Items"}}
            }
       		ToggleDropDownMenu(1, nil, theFrame.QueryManagerFrame.TypeDropdown);
         end)
         UIDropDownMenu_SetText(theFrame.QueryManagerFrame.TypeDropdown, "Addons")

        theFrame.QueryManagerFrame.QueryLabel = theFrame.QueryManagerFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        theFrame.QueryManagerFrame.QueryLabel:SetTextColor(1,1,1)
        theFrame.QueryManagerFrame.QueryLabel:SetHeight(10)
        theFrame.QueryManagerFrame.QueryLabel:SetText(L["Query:"])
        theFrame.QueryManagerFrame.QueryLabel:SetPoint("TOPLEFT",theFrame.QueryManagerFrame,"TOPLEFT",20,-95)
        theFrame.QueryManagerFrame.QueryLabel:SetJustifyH("LEFT")

        theFrame.QueryManagerFrame.QueryDropdown = CreateFrame("Frame", "BT_QueryManagerQueryDropdown", theFrame.QueryManagerFrame, "UIDropDownMenuTemplate");
        theFrame.QueryManagerFrame.QueryDropdown.selected = -1
        theFrame.QueryManagerFrame.QueryDropdown:SetPoint("TOPLEFT",theFrame.QueryManagerFrame, "TOPLEFT", 10,-110)
        UIDropDownMenu_SetWidth(theFrame.QueryManagerFrame.QueryDropdown,100)
        UIDropDownMenu_Initialize(theFrame.QueryManagerFrame.QueryDropdown, function () BossTactics:DropDownOneLevel_Initialize() end);
        getglobal(theFrame.QueryManagerFrame.QueryDropdown:GetName().."Button"):SetScript("OnClick",function()
       		local tbl = {}

       		for i,v in ipairs(self.db.profile.queryList)do
       			if(v.type == self.MainWindow.QueryManagerFrame.TypeDropdown.selected)then
       				tinsert(tbl,{v.name,v.name})
       			end
       		end
       		self.currDropdownTable = {
            	["func"] = function (arg1, arg2) self:QueryManagerQueryDropdownClick(arg1, arg2) end,
                ["values"] = tbl,
            }
       		ToggleDropDownMenu(1, nil, theFrame.QueryManagerFrame.QueryDropdown);
         end)

        theFrame.QueryManagerFrame.QueryScroll = CreateFrame("ScrollFrame","BT_QueryScroll",theFrame.QueryManagerFrame,"UIPanelScrollFrameTemplate")
        theFrame.QueryManagerFrame.QueryScroll:ClearAllPoints()
        theFrame.QueryManagerFrame.QueryScroll:SetPoint("TOPLEFT",theFrame.QueryManagerFrame, "TOPLEFT",200,-50)
        theFrame.QueryManagerFrame.QueryScroll:SetWidth(200)
        theFrame.QueryManagerFrame.QueryScroll:SetHeight(100)

        theFrame.QueryManagerFrame.ScrollFrame = CreateFrame("Frame","BT_querymanagerScrollBorder",theFrame.QueryManagerFrame)
        theFrame.QueryManagerFrame.ScrollFrame:SetBackdrop({
        edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
        })
        theFrame.QueryManagerFrame.ScrollFrame:SetBackdropBorderColor(16/255,24/255,177/255)
        theFrame.QueryManagerFrame.ScrollFrame:SetHeight(120)
        theFrame.QueryManagerFrame.ScrollFrame:SetWidth(235)
        theFrame.QueryManagerFrame.ScrollFrame:ClearAllPoints()
        theFrame.QueryManagerFrame.ScrollFrame:SetPoint("TOPLEFT",theFrame.QueryManagerFrame,"TOPLEFT",195,-40)

        theFrame.QueryManagerFrame.QueryInput= CreateFrame("EditBox","BT_QueryInputEdit",theFrame.QueryManagerFrame.QueryScroll)
        theFrame.QueryManagerFrame.QueryInput:ClearAllPoints()
        theFrame.QueryManagerFrame.QueryInput:SetWidth(200)
        theFrame.QueryManagerFrame.QueryInput:SetHeight(100)
        theFrame.QueryManagerFrame.QueryInput:SetPoint("TOPLEFT",theFrame.QueryManagerFrame.QueryScroll,"TOPLEFT",0,0)
        theFrame.QueryManagerFrame.QueryScroll:SetScrollChild(theFrame.QueryManagerFrame.QueryInput)
        theFrame.QueryManagerFrame.QueryInput:SetAutoFocus(false)
        theFrame.QueryManagerFrame.QueryInput:SetScript("OnEscapePressed", function()
                    this:ClearFocus()
                        end)
        theFrame.QueryManagerFrame.QueryInput:SetScript("OnTextChanged", function()
                 ScrollingEdit_OnTextChanged(this, this:GetParent())
                end)
        theFrame.QueryManagerFrame.QueryInput:SetScript("OnCursorChanged", function()
                 ScrollingEdit_OnCursorChanged(this, arg1, arg2-10, arg3, arg4)
                  end)
        theFrame.QueryManagerFrame.QueryInput:SetScript("OnUpdate", function()
                 ScrollingEdit_OnUpdate(this, this:GetParent())
                  end)
    	theFrame.QueryManagerFrame.QueryInput:SetMultiLine(true)
        theFrame.QueryManagerFrame.QueryInput:EnableMouse(true)
        theFrame.QueryManagerFrame.QueryInput:SetFont("Fonts\\FRIZQT__.TTF",12)
        theFrame.QueryManagerFrame.QueryInput:SetTextColor(1,1,1)
        theFrame.QueryManagerFrame.QueryInput:SetTextInsets(10,10,10,10)

        theFrame.QueryManagerFrame.HelpBtn = CreateFrame("Button","BT_QueryManager_Help",theFrame.QueryManagerFrame,"UIPanelButtonTemplate")
        theFrame.QueryManagerFrame.HelpBtn:SetWidth(20)
        theFrame.QueryManagerFrame.HelpBtn:SetHeight(20)
        theFrame.QueryManagerFrame.HelpBtn:SetText("?")
        theFrame.QueryManagerFrame.HelpBtn:SetPoint("TOPLEFT",theFrame.QueryManagerFrame,"TOPLEFT",440,-45)
        theFrame.QueryManagerFrame.HelpBtn:SetScript("OnClick",function()
        	if(theFrame.QueryManagerFrame.TypeDropdown.selected == "Addons")then
        		 self:ShowHelpFrame(L["help query addons"],theFrame.QueryManagerFrame)
        	elseif(theFrame.QueryManagerFrame.TypeDropdown.selected == "Items")then
        		 self:ShowHelpFrame(L["help query items"],theFrame.QueryManagerFrame)
        	end
         end)

        theFrame.QueryManagerFrame.NewBtn = CreateFrame("Button","BT_QueryManager_New",theFrame.QueryManagerFrame,"UIPanelButtonTemplate")
        theFrame.QueryManagerFrame.NewBtn:SetWidth(50)
        theFrame.QueryManagerFrame.NewBtn:SetHeight(20)
        theFrame.QueryManagerFrame.NewBtn:SetText(L["New"])
        theFrame.QueryManagerFrame.NewBtn:SetPoint("TOPLEFT",theFrame.QueryManagerFrame,"TOPLEFT",30,-180)
        theFrame.QueryManagerFrame.NewBtn:SetScript("OnClick",function() self:NewQuery()  end)

        theFrame.QueryManagerFrame.SaveBtn = CreateFrame("Button","BT_QueryManager_Save",theFrame.QueryManagerFrame,"UIPanelButtonTemplate")
        theFrame.QueryManagerFrame.SaveBtn:SetWidth(100)
        theFrame.QueryManagerFrame.SaveBtn:SetHeight(20)
        theFrame.QueryManagerFrame.SaveBtn:SetText(L["Save"])
        theFrame.QueryManagerFrame.SaveBtn:SetPoint("TOPLEFT",theFrame.QueryManagerFrame,"TOPLEFT",90,-180)
        theFrame.QueryManagerFrame.SaveBtn:SetScript("OnClick",function() self:SaveQuery()  end)

        theFrame.QueryManagerFrame.DeleteBtn = CreateFrame("Button","BT_QueryManager_Delete",theFrame.QueryManagerFrame,"UIPanelButtonTemplate")
        theFrame.QueryManagerFrame.DeleteBtn:SetWidth(100)
        theFrame.QueryManagerFrame.DeleteBtn:SetHeight(20)
        theFrame.QueryManagerFrame.DeleteBtn:SetText(L["Delete"])
        theFrame.QueryManagerFrame.DeleteBtn:SetPoint("TOPLEFT",theFrame.QueryManagerFrame,"TOPLEFT",200,-180)
        theFrame.QueryManagerFrame.DeleteBtn:SetScript("OnClick",function()
        	self:ShowQuestionFrame(L["del query message"], function() BossTactics:DeleteQuery() end)
         end)

        theFrame.QueryManagerFrame.ExecuteBtn = CreateFrame("Button","BT_QueryManager_Execute",theFrame.QueryManagerFrame,"UIPanelButtonTemplate")
        theFrame.QueryManagerFrame.ExecuteBtn:SetWidth(100)
        theFrame.QueryManagerFrame.ExecuteBtn:SetHeight(20)
        theFrame.QueryManagerFrame.ExecuteBtn:SetText(L["Execute"])
        theFrame.QueryManagerFrame.ExecuteBtn:SetPoint("TOPLEFT",theFrame.QueryManagerFrame,"TOPLEFT",310,-180)
        theFrame.QueryManagerFrame.ExecuteBtn:SetScript("OnClick",function()
        	local parser = self:ParseQuery(theFrame.QueryManagerFrame.QueryInput:GetText(),theFrame.QueryManagerFrame.TypeDropdown.selected)
    		if(self:CheckTree(parser,theFrame.QueryManagerFrame.TypeDropdown.selected))then
				self:ShowQueryResultFrame()
				self:ClearQueryResults(self:PrintTree(parser,theFrame.QueryManagerFrame.TypeDropdown.selected))
				self:BT_SendDataMessage("{RLQR:"..theFrame.QueryManagerFrame.QueryInput:GetText()..":"..theFrame.QueryManagerFrame.TypeDropdown.selected.."}")
            else
                if(type(parser) == "table")then
                    if(parser.err and parser.msg == "No Input")then
                        theFrame.QueryManagerFrame.ErrorLabel:SetErrorText(L["No text"])
                        return
                    elseif(parser.err and parser.msg == "No :")then
                        theFrame.QueryManagerFrame.ErrorLabel:SetErrorText(format(L["No char allowed"], ":"))
                        return
                    elseif(parser.err and parser.msg == "No }")then
                        theFrame.QueryManagerFrame.ErrorLabel:SetErrorText(format(L["No char allowed"], "}"))
                        return
                    end
                end
                theFrame.QueryManagerFrame.ErrorLabel:SetErrorText(L["Invalid input"])
            end
          end)

        theFrame.QueryManagerFrame.CheckBtn = CreateFrame("Button","BT_QueryManager_Check",theFrame.QueryManagerFrame,"UIPanelButtonTemplate")
        theFrame.QueryManagerFrame.CheckBtn:SetWidth(100)
        theFrame.QueryManagerFrame.CheckBtn:SetHeight(20)
        theFrame.QueryManagerFrame.CheckBtn:SetText(L["Check"])
        theFrame.QueryManagerFrame.CheckBtn:SetPoint("TOPLEFT",theFrame.QueryManagerFrame,"TOPLEFT",420,-180)
        theFrame.QueryManagerFrame.CheckBtn:SetScript("OnClick",function()
    			local parser = self:ParseQuery(theFrame.QueryManagerFrame.QueryInput:GetText(), theFrame.QueryManagerFrame.TypeDropdown.selected)
    			if(self:CheckTree(parser,theFrame.QueryManagerFrame.TypeDropdown.selected))then
    				local result = self:EvaluateQuery(parser,theFrame.QueryManagerFrame.TypeDropdown.selected)
					local resultArr = {strsplit("#",result)}
                    local resultStr, resultPred = self:CreateEvaluationString(parser, theFrame.QueryManagerFrame.TypeDropdown.selected, resultArr)
                    if(resultPred)then
                    	theFrame.QueryManagerFrame.ErrorLabel:SetNoErrorText(L["Valid input"])
                    else
    					theFrame.QueryManagerFrame.ErrorLabel:SetWarningText(L["Query not work"])
    				end
    			else
    				if(type(parser) == "table")then
		                if(parser.err and parser.msg == "No Input")then
                            theFrame.QueryManagerFrame.ErrorLabel:SetErrorText(L["No text"])
                            return
                        elseif(parser.err and parser.msg == "No :")then
                            theFrame.QueryManagerFrame.ErrorLabel:SetErrorText(format(L["No char allowed"], ":"))
                            return
                        elseif(parser.err and parser.msg == "No }")then
                            theFrame.QueryManagerFrame.ErrorLabel:SetErrorText(format(L["No char allowed"], "}"))
                            return
                        end
                    end
                    theFrame.QueryManagerFrame.ErrorLabel:SetErrorText(L["Invalid input"])
    			end
          end)

		theFrame.QueryManagerFrame.ErrorLabel = theFrame.QueryManagerFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        theFrame.QueryManagerFrame.ErrorLabel:SetTextColor(1,1,1)
        theFrame.QueryManagerFrame.ErrorLabel:SetHeight(20)
        theFrame.QueryManagerFrame.ErrorLabel:SetWidth(400)
        theFrame.QueryManagerFrame.ErrorLabel:SetText("")
        theFrame.QueryManagerFrame.ErrorLabel:SetPoint("TOPLEFT",theFrame.QueryManagerFrame,"TOPLEFT",40,-210)
        theFrame.QueryManagerFrame.ErrorLabel:SetJustifyH("LEFT")
        theFrame.QueryManagerFrame.ErrorLabel.SetErrorText = function(info,text)
        					theFrame.QueryManagerFrame.ErrorLabel:SetTextColor(1,0,0)
        					theFrame.QueryManagerFrame.ErrorLabel:SetText(L["Error: "]..text)
        					theFrame.QueryManagerFrame.ErrorLabel:SetAlpha(1)
        					theFrame.QueryManagerFrame.ErrorLabel.timer=3
        					theFrame.QueryManagerFrame.ErrorLabel.Timer:ScheduleRepeatingTimer("BT_ErrorLabelTimer", function ()
        						 BossTactics:FadeErrorLabelText() end, 0.2)
        	 end
        theFrame.QueryManagerFrame.ErrorLabel.SetNoErrorText = function(info,text)
        					theFrame.QueryManagerFrame.ErrorLabel:SetTextColor(0,1,0)
        					theFrame.QueryManagerFrame.ErrorLabel:SetText(text)
        					theFrame.QueryManagerFrame.ErrorLabel:SetAlpha(1)
        					theFrame.QueryManagerFrame.ErrorLabel.timer=3
        					theFrame.QueryManagerFrame.ErrorLabel.Timer:ScheduleRepeatingTimer("BT_ErrorLabelTimer", function ()
        						 BossTactics:FadeErrorLabelText() end, 0.2)
        	 end
        theFrame.QueryManagerFrame.ErrorLabel.SetWarningText = function(info,text)
        					theFrame.QueryManagerFrame.ErrorLabel:SetTextColor(1,1,0)
        					theFrame.QueryManagerFrame.ErrorLabel:SetText(L["Warning: "]..text)
        					theFrame.QueryManagerFrame.ErrorLabel:SetAlpha(1)
        					theFrame.QueryManagerFrame.ErrorLabel.timer=3
        					theFrame.QueryManagerFrame.ErrorLabel.Timer:ScheduleRepeatingTimer("BT_ErrorLabelTimer", function ()
        						 BossTactics:FadeErrorLabelText() end, 0.2)
        	 end
        theFrame.QueryManagerFrame.ErrorLabel.Timer = LibStub("LibSimpleTimer-1.0")

        theFrame.QueryManagerFrame.OkBtn = CreateFrame("Button","BT_QueryManager_ok",theFrame.QueryManagerFrame,"UIPanelButtonTemplate")
        theFrame.QueryManagerFrame.OkBtn:SetWidth(100)
        theFrame.QueryManagerFrame.OkBtn:SetHeight(20)
        theFrame.QueryManagerFrame.OkBtn:SetText(L["Ok"])
        theFrame.QueryManagerFrame.OkBtn:SetPoint("BOTTOM",theFrame.QueryManagerFrame,"BOTTOM",0,15)
        theFrame.QueryManagerFrame.OkBtn:SetScript("OnClick",function() this:GetParent():Hide() end)

        theFrame.QueryManagerFrame.closebtn=CreateFrame("Button","BT_QueryManagerclose",theFrame.QueryManagerFrame)
        theFrame.QueryManagerFrame.closebtn:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
        theFrame.QueryManagerFrame.closebtn:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
        theFrame.QueryManagerFrame.closebtn:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
        theFrame.QueryManagerFrame.closebtn:SetWidth(20)
        theFrame.QueryManagerFrame.closebtn:SetHeight(20)
        theFrame.QueryManagerFrame.closebtn:SetPoint("TOPRIGHT",theFrame.QueryManagerFrame,"TOPRIGHT",-5,-5)
        theFrame.QueryManagerFrame.closebtn:SetScript("OnClick",function() this:GetParent():Hide() end)

         for i,v in ipairs(self.db.profile.queryList)do
       		if(v.type == theFrame.QueryManagerFrame.TypeDropdown.selected)then
                UIDropDownMenu_SetText(theFrame.QueryManagerFrame.QueryDropdown, v.name)
                theFrame.QueryManagerFrame.QueryDropdown.selected = v.name
                theFrame.QueryManagerFrame.QueryInput:SetText(v.query)
                if(v.std)then
                    self.MainWindow.QueryManagerFrame.SaveBtn:Disable()
                else
                    self.MainWindow.QueryManagerFrame.SaveBtn:Enable()
                end
                break
            end
        end

    end
    theFrame.QueryManagerFrame:Show()
    if(theFrame) then
        theFrame.QueryManagerFrame:SetFrameLevel(theFrame:GetFrameLevel()+20)
    end

    if(self:IsRaidLeader())then
    	theFrame.QueryManagerFrame.ExecuteBtn:Enable()
    else
    	theFrame.QueryManagerFrame.ExecuteBtn:Disable()
    end

end;

function BossTactics:FadeErrorLabelText()

	local theLabel = self.MainWindow.QueryManagerFrame.ErrorLabel
	theLabel.timer = theLabel.timer-0.1
	if(theLabel.timer <= 1)then
		theLabel:SetAlpha(theLabel.timer)
	end
	if(theLabel.timer <= 0)then
		theLabel.Timer:CancelTimer("BT_ErrorLabelTimer")
	end

end;

function BossTactics:DeleteQuery()
	local theFrame = self.MainWindow
	for i,v in ipairs(self.db.profile.queryList)do
    	if(v.name == theFrame.QueryManagerFrame.QueryDropdown.selected)then
            tremove(self.db.profile.queryList,i)
            local found = false
            for ind,val in ipairs(self.db.profile.queryList)do
                if(val.type == self.MainWindow.QueryManagerFrame.TypeDropdown.selected)then
                    UIDropDownMenu_SetText(theFrame.QueryManagerFrame.QueryDropdown, val.name)
                    theFrame.QueryManagerFrame.QueryDropdown.selected = val.name
                    theFrame.QueryManagerFrame.QueryInput:SetText(val.query)
                    found = true
                    break
                end
            end
            if(not found)then
                UIDropDownMenu_SetText(theFrame.QueryManagerFrame.QueryDropdown, "")
                theFrame.QueryManagerFrame.QueryDropdown.selected = -1
                theFrame.QueryManagerFrame.QueryInput:SetText("")
            end
            theFrame.QueryManagerFrame.ErrorLabel:SetNoErrorText(L["Query deleted"])
            break
        end
    end
end

function BossTactics:NewQuery()

	local theFrame = self.MainWindow.QueryManagerFrame
	local parser = self:ParseQuery(theFrame.QueryInput:GetText(),theFrame.TypeDropdown.selected)
    if(self:CheckTree(parser,theFrame.TypeDropdown.selected))then
		self:ShowNewTextInputFrame(function(info,text)
		local type = theFrame.TypeDropdown.selected
		local found = false
		for i,v in ipairs(self.db.profile.queryList)do
       		if(v.name == text)then
                found = true
            end
        end
        if(found)then
        	theFrame.ErrorLabel:SetErrorText(L["Query name exists"])
        else
			tinsert(self.db.profile.queryList,{name = text, type = type, query = theFrame.QueryInput:GetText()})
		    UIDropDownMenu_SetText(theFrame.QueryDropdown, text)
            theFrame.QueryDropdown.selected = text
            theFrame.ErrorLabel:SetNoErrorText(L["Query Save Ok"])
        end
        theFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+20)
	  end,
	  L["Title New Query Inputframe"],L["New Query info"], theFrame)
    else
        if(type(parser) == "table")then
            if(parser.err and parser.msg == "No Input")then
                theFrame.ErrorLabel:SetErrorText(L["No text"])
                return
            elseif(parser.err and parser.msg == "No :")then
            	theFrame.ErrorLabel:SetErrorText(format(L["No char allowed"], ":"))
                return
            elseif(parser.err and parser.msg == "No }")then
                theFrame.ErrorLabel:SetErrorText(format(L["No char allowed"], "}"))
                return
            end
        end
        theFrame.ErrorLabel:SetErrorText(L["Invalid input"])
    end
	theFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+20)
end

function BossTactics:SaveQuery()
	local theFrame = self.MainWindow.QueryManagerFrame
	local parser = self:ParseQuery(theFrame.QueryInput:GetText(), theFrame.TypeDropdown.selected)
    if(self:CheckTree(parser,theFrame.TypeDropdown.selected))then
		local type = theFrame.TypeDropdown.selected
		local found = false
		for i,v in ipairs(self.db.profile.queryList)do
       		if(v.name == theFrame.QueryDropdown.selected)then
                v.query = theFrame.QueryInput:GetText()
                v.type = type
                found = true
                break;
            end
        end
        if(not found)then
        	theFrame.ErrorLabel:SetWarningText(L["Query not saved"])
        else
        	theFrame.ErrorLabel:SetNoErrorText(L["Query Save Ok"])
        end
    else
        if(type(parser) == "table")then
            if(parser.err and parser.msg == "No Input")then
                theFrame.ErrorLabel:SetErrorText(L["No text"])
                return
            elseif(parser.err and parser.msg == "No :")then
                theFrame.ErrorLabel:SetErrorText(format(L["No char allowed"], ":"))
                return
            elseif(parser.err and parser.msg == "No }")then
                theFrame.ErrorLabel:SetErrorText(format(L["No char allowed"], "}"))
                return
            end
        end
        theFrame.ErrorLabel:SetErrorText(L["Invalid input"])
    end
end

function BossTactics:QueryManagerTypeDropdownClick(selection)
	local theFrame = self.MainWindow.QueryManagerFrame

	UIDropDownMenu_SetText(theFrame.TypeDropdown, selection)
	theFrame.TypeDropdown.selected = selection
	if(theFrame.QueryDropdown.selected == -1)then
		for i,v in ipairs(self.db.profile.queryList)do
       		if(v.type == selection)then
                UIDropDownMenu_SetText(theFrame.QueryDropdown, v.name)
                theFrame.QueryDropdown.selected = v.name
                theFrame.QueryInput:SetText(v.query)
                break
            end
        end
	end
end

function BossTactics:QueryManagerQueryDropdownClick(selectionText)
	UIDropDownMenu_SetText(self.MainWindow.QueryManagerFrame.QueryDropdown, selectionText)
	self.MainWindow.QueryManagerFrame.QueryDropdown.selected = selectionText
	for i,v in ipairs(self.db.profile.queryList)do
       	if(v.type == self.MainWindow.QueryManagerFrame.TypeDropdown.selected and v.name == selectionText)then
            self.MainWindow.QueryManagerFrame.QueryInput:SetText(v.query)
            if(v.std)then
                self.MainWindow.QueryManagerFrame.SaveBtn:Disable()
            else
                self.MainWindow.QueryManagerFrame.SaveBtn:Enable()
            end
            break;
        end
    end
end

----------------------------------------------------------------
--Panel which shows item Id
----------------------------------------------------------------

function BossTactics:ShowInputBoxFrame(title,text)

	local theFrame = self

    if(theFrame.InputBoxFrame == nil)then
        theFrame.InputBoxFrame = CreateFrame("Frame","BT_InputBoxframe",UIParent)
        theFrame.InputBoxFrame:ClearAllPoints()
        theFrame.InputBoxFrame:SetPoint("CENTER",UIParent)
        theFrame.InputBoxFrame:SetHeight(130)
        theFrame.InputBoxFrame:SetWidth(200)
        theFrame.InputBoxFrame:EnableMouse(true)
        theFrame.InputBoxFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        theFrame.InputBoxFrame:SetBackdropColor(0, 0, 0,1.0)

        theFrame.InputBoxFrame.Title = theFrame.InputBoxFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        theFrame.InputBoxFrame.Title:SetTextColor(1,1,1)
        theFrame.InputBoxFrame.Title:SetHeight(20)
        theFrame.InputBoxFrame.Title:SetText(title)
        theFrame.InputBoxFrame.Title:SetPoint("TOP",theFrame.InputBoxFrame,"TOP",0,-10)
        theFrame.InputBoxFrame.Title:SetJustifyH("LEFT")

        theFrame.InputBoxFrame.Input = CreateFrame("EditBox","BT_InputFrameB",theFrame.InputBoxFrame,"InputBoxTemplate")
        theFrame.InputBoxFrame.Input:ClearAllPoints()
        theFrame.InputBoxFrame.Input:SetPoint("CENTER",theFrame.InputBoxFrame, "CENTER",0,0)
        theFrame.InputBoxFrame.Input:SetWidth(80)
        theFrame.InputBoxFrame.Input:SetHeight(20)
        theFrame.InputBoxFrame.Input:EnableMouse(true)
        theFrame.InputBoxFrame.Input:SetAutoFocus(false)
        theFrame.InputBoxFrame.Input:SetScript("OnEscapePressed", function()
                    this:ClearFocus()
                    end)

		theFrame.InputBoxFrame.OkBtn = CreateFrame("Button","BT_InputBox_ok",theFrame.InputBoxFrame,"UIPanelButtonTemplate")
        theFrame.InputBoxFrame.OkBtn:SetWidth(100)
        theFrame.InputBoxFrame.OkBtn:SetHeight(20)
        theFrame.InputBoxFrame.OkBtn:SetText(L["Ok"])
        theFrame.InputBoxFrame.OkBtn:SetPoint("BOTTOM",theFrame.InputBoxFrame,"BOTTOM",0,15)
        theFrame.InputBoxFrame.OkBtn:SetScript("OnClick",function() this:GetParent():Hide() end)

    end
    theFrame.InputBoxFrame.Input:SetText(text)
    theFrame.InputBoxFrame.Input:SetFocus()
    theFrame.InputBoxFrame:Show()
    if(self.MainWindow) then
    	if(self.MainWindow.QueryManagerFrame)then
    		theFrame.InputBoxFrame:SetFrameLevel(self.MainWindow.QueryManagerFrame:GetFrameLevel()+20)
    	else
        	theFrame.InputBoxFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+20)
        end
    end

end;

----------------------------------------------------------------
--Panel which shows long help texts
----------------------------------------------------------------

function BossTactics:ShowHelpFrame(text,frame)

	local theFrame = self

    if(theFrame.HelpFrame == nil)then
        theFrame.HelpFrame = CreateFrame("Frame","BT_Helpframe",UIParent)
        theFrame.HelpFrame:ClearAllPoints()
        theFrame.HelpFrame:SetPoint("CENTER",UIParent)
        theFrame.HelpFrame:SetHeight(400)
        theFrame.HelpFrame:SetWidth(300)
        theFrame.HelpFrame:EnableMouse(true)
        theFrame.HelpFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        theFrame.HelpFrame:SetBackdropColor(0, 0, 0,1.0)

        theFrame.HelpFrame.Title = theFrame.HelpFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        theFrame.HelpFrame.Title:SetTextColor(1,1,1)
        theFrame.HelpFrame.Title:SetHeight(20)
        theFrame.HelpFrame.Title:SetText(L["Help"])
        theFrame.HelpFrame.Title:SetPoint("TOP",theFrame.HelpFrame,"TOP",0,-10)
        theFrame.HelpFrame.Title:SetJustifyH("LEFT")

        theFrame.HelpFrame.HelpScroll = CreateFrame("ScrollFrame","BT_HelpResScroll",theFrame.HelpFrame,"UIPanelScrollFrameTemplate")
        theFrame.HelpFrame.HelpScroll:ClearAllPoints()
        theFrame.HelpFrame.HelpScroll:SetPoint("TOPLEFT",theFrame.HelpFrame, "TOPLEFT",5,-50)
        theFrame.HelpFrame.HelpScroll:SetWidth(260)
        theFrame.HelpFrame.HelpScroll:SetHeight(300)

        theFrame.HelpFrame.ScrollPanel= CreateFrame("EditBox","BT_ScrollPanel",theFrame.HelpFrame.QueryScroll)
        theFrame.HelpFrame.ScrollPanel:ClearAllPoints()
        theFrame.HelpFrame.ScrollPanel:SetWidth(260)
        theFrame.HelpFrame.ScrollPanel:SetHeight(200)
        theFrame.HelpFrame.ScrollPanel:SetPoint("TOPLEFT",theFrame.HelpFrame.QueryScroll,"TOPLEFT",0,0)
        theFrame.HelpFrame.HelpScroll:SetScrollChild(theFrame.HelpFrame.ScrollPanel)
        theFrame.HelpFrame.ScrollPanel:SetScript("OnEscapePressed", function()
                    this:ClearFocus()
                        end)
        theFrame.HelpFrame.ScrollPanel:SetScript("OnTextChanged", function()
                 ScrollingEdit_OnTextChanged(this, this:GetParent())
                end)
        theFrame.HelpFrame.ScrollPanel:SetScript("OnCursorChanged", function()
                 ScrollingEdit_OnCursorChanged(this, arg1, arg2-10, arg3, arg4)
                  end)
        theFrame.HelpFrame.ScrollPanel:SetScript("OnUpdate", function()
                 ScrollingEdit_OnUpdate(this, this:GetParent())
                  end)
    	theFrame.HelpFrame.ScrollPanel:SetMultiLine(true)
    	theFrame.HelpFrame.ScrollPanel:SetAutoFocus(false)
        theFrame.HelpFrame.ScrollPanel:EnableMouse(false)
        theFrame.HelpFrame.ScrollPanel:SetFont("Fonts\\FRIZQT__.TTF",12)
        theFrame.HelpFrame.ScrollPanel:SetTextColor(1,1,1)
        theFrame.HelpFrame.ScrollPanel:SetTextInsets(10,10,10,10)

		theFrame.HelpFrame.OkBtn = CreateFrame("Button","BT_Help_ok",theFrame.HelpFrame,"UIPanelButtonTemplate")
        theFrame.HelpFrame.OkBtn:SetWidth(100)
        theFrame.HelpFrame.OkBtn:SetHeight(20)
        theFrame.HelpFrame.OkBtn:SetText(L["Close"])
        theFrame.HelpFrame.OkBtn:SetPoint("BOTTOM",theFrame.HelpFrame,"BOTTOM",0,15)
        theFrame.HelpFrame.OkBtn:SetScript("OnClick",function() this:GetParent():Hide() end)

        theFrame.HelpFrame.closebtn=CreateFrame("Button","BT_Helpclose",theFrame.HelpFrame)
        theFrame.HelpFrame.closebtn:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
        theFrame.HelpFrame.closebtn:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
        theFrame.HelpFrame.closebtn:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
        theFrame.HelpFrame.closebtn:SetWidth(20)
        theFrame.HelpFrame.closebtn:SetHeight(20)
        theFrame.HelpFrame.closebtn:SetPoint("TOPRIGHT",theFrame.HelpFrame,"TOPRIGHT",-5,-5)
        theFrame.HelpFrame.closebtn:SetScript("OnClick",function() this:GetParent():Hide() end)

    end
    theFrame.HelpFrame:Show()
    theFrame.HelpFrame.ScrollPanel:SetText(text)
    theFrame.HelpFrame.ScrollPanel:SetCursorPosition(1)
    if(frame) then
    	theFrame.HelpFrame:SetFrameLevel(frame:GetFrameLevel()+20)
    end

end;

----------------------------------------------------------------
--Panel which shows query results
----------------------------------------------------------------

function BossTactics:ShowQueryResultFrame()

	local theFrame = self

    if(theFrame.QueryResultFrame == nil)then
        theFrame.QueryResultFrame = CreateFrame("Frame","BT_QueryResultframe",UIParent)
        theFrame.QueryResultFrame:ClearAllPoints()
        theFrame.QueryResultFrame:SetPoint("CENTER",UIParent)
        theFrame.QueryResultFrame:SetHeight(600)
        theFrame.QueryResultFrame:SetWidth(500)
        theFrame.QueryResultFrame:EnableMouse(true)
        theFrame.QueryResultFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        theFrame.QueryResultFrame:SetBackdropColor(0, 0, 0,1.0)

        theFrame.QueryResultFrame.Title = theFrame.QueryResultFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        theFrame.QueryResultFrame.Title:SetTextColor(1,1,1)
        theFrame.QueryResultFrame.Title:SetHeight(20)
        theFrame.QueryResultFrame.Title:SetText(L["Query Result"])
        theFrame.QueryResultFrame.Title:SetPoint("TOP",theFrame.QueryResultFrame,"TOP",0,-10)
        theFrame.QueryResultFrame.Title:SetJustifyH("LEFT")

        theFrame.QueryResultFrame.QueryScroll = CreateFrame("ScrollFrame","BT_QueryResScroll",theFrame.QueryResultFrame,"UIPanelScrollFrameTemplate")
        theFrame.QueryResultFrame.QueryScroll:ClearAllPoints()
        theFrame.QueryResultFrame.QueryScroll:SetPoint("TOPLEFT",theFrame.QueryResultFrame, "TOPLEFT",0,-50)
        theFrame.QueryResultFrame.QueryScroll:SetWidth(460)
        theFrame.QueryResultFrame.QueryScroll:SetHeight(500)

        theFrame.QueryResultFrame.ScrollPanel= CreateFrame("Frame","BT_QRScrollPanel",theFrame.QueryResultFrame.QueryScroll)
        theFrame.QueryResultFrame.ScrollPanel:ClearAllPoints()
        theFrame.QueryResultFrame.ScrollPanel:SetWidth(460)
        theFrame.QueryResultFrame.ScrollPanel:SetHeight(300)
        theFrame.QueryResultFrame.ScrollPanel:SetPoint("TOPLEFT",theFrame.QueryResultFrame.QueryScroll,"TOPLEFT",0,0)
        theFrame.QueryResultFrame.QueryScroll:SetScrollChild(theFrame.QueryResultFrame.ScrollPanel)

        theFrame.QueryResultFrame.ScrollPanel.results = {}

		theFrame.QueryResultFrame.OkBtn = CreateFrame("Button","BT_QueryResult_ok",theFrame.QueryResultFrame,"UIPanelButtonTemplate")
        theFrame.QueryResultFrame.OkBtn:SetWidth(100)
        theFrame.QueryResultFrame.OkBtn:SetHeight(20)
        theFrame.QueryResultFrame.OkBtn:SetText(L["Close"])
        theFrame.QueryResultFrame.OkBtn:SetPoint("BOTTOM",theFrame.QueryResultFrame,"BOTTOM",0,15)
        theFrame.QueryResultFrame.OkBtn:SetScript("OnClick",function() this:GetParent():Hide() end)

        theFrame.QueryResultFrame.closebtn=CreateFrame("Button","BT_QueryResultclose",theFrame.QueryResultFrame)
        theFrame.QueryResultFrame.closebtn:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
        theFrame.QueryResultFrame.closebtn:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
        theFrame.QueryResultFrame.closebtn:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
        theFrame.QueryResultFrame.closebtn:SetWidth(20)
        theFrame.QueryResultFrame.closebtn:SetHeight(20)
        theFrame.QueryResultFrame.closebtn:SetPoint("TOPRIGHT",theFrame.QueryResultFrame,"TOPRIGHT",-5,-5)
        theFrame.QueryResultFrame.closebtn:SetScript("OnClick",function() this:GetParent():Hide() end)

    end
    theFrame.QueryResultFrame:Show()
    if(self.MainWindow) then
    	if(self.MainWindow.QueryManagerFrame)then
    		theFrame.QueryResultFrame:SetFrameLevel(self.MainWindow.QueryManagerFrame:GetFrameLevel()+20)
    	else
        	theFrame.QueryResultFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+20)
        end
    end

end;

function BossTactics:InsertQueryResult(name,result,resultPred)

	local theFrame = self.QueryResultFrame.ScrollPanel
	for i,v in ipairs(theFrame.results)do
		if(v.name:GetText() == name)then
			v.query:SetText(result)
			if(resultPred)then
				v.status:SetTexture("Interface\\RAIDFRAME\\ReadyCheck-Ready")
			else
				v.status:SetTexture("Interface\\RAIDFRAME\\ReadyCheck-NotReady")
			end
			break
		end
	end
end

function BossTactics:ClearQueryResults(currQuery)

	local theFrame = self.QueryResultFrame.ScrollPanel
	local anzMembers = GetNumRaidMembers()
	local i
	for i,v in ipairs(theFrame.results)do
		v.name:Hide()
		v.query:Hide()
		v.status:Hide()
	end
	theFrame.results = {}
	for i=1, anzMembers, 1 do
        local name, rank, subgroup, level, class,
              fileName,zone, online, isDead, role, isML = GetRaidRosterInfo(i)
       	local value = {}
       	--if(theFrame.results[i])then
       	--	value = theFrame.results[i]
       	--else

       	--end
       	value.name = theFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        local playerClass, englishClass = UnitClass(name)
       	value.name:SetTextColor(RAID_CLASS_COLORS[englishClass].r,RAID_CLASS_COLORS[englishClass].g,RAID_CLASS_COLORS[englishClass].b)
       	value.name:SetJustifyH("LEFT")
       	value.name:SetText(name)
       	value.name:SetWidth(90)
       	value.query = theFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
       	value.query:SetJustifyH("LEFT")
       	value.query:SetWidth(290)
       	value.status = theFrame:CreateTexture("BT_queryStatus"..i,"BACKGROUND")
       	value.status:SetTexture("Interface\\RAIDFRAME\\ReadyCheck-Waiting")
        value.status:SetWidth(16)
        value.status:SetHeight(16)
       	if(online)then
        	value.query:SetTextColor(1,1,1)
        else
        	value.query:SetTextColor(128/255,128/255,128/255)
        end
       	self:QueryInsertionSort(theFrame.results,value)
    end

	local height = 0
	for i,v in ipairs(theFrame.results)do
		v.name:SetPoint("TOPLEFT",theFrame,"TOPLEFT",15,height)
		v.status:SetPoint("TOPLEFT",theFrame,"TOPLEFT",420,height)
		v.query:SetPoint("TOPLEFT",theFrame,"TOPLEFT",125,height)
		v.query:SetText(currQuery)
		height = height - v.query:GetStringHeight() - 5
	end

	theFrame:SetHeight(-height)
end;

-----------------------------------------------------
--insertion sort for fontstring arrays
-----------------------------------------------------

function BossTactics:QueryInsertionSort(arr, value)
    local lastElement = true
    for index,v in ipairs(arr) do
        if(v.name:GetText() >= value.name:GetText()) then
            tinsert(arr,index,value)
            lastElement = false
            break
        end
    end
    if(lastElement)then
        tinsert(arr,value)
    end
end;


------------------------------------------------------------------
--Panel where the actual real raidleader
--can choose options to set his leaders
------------------------------------------------------------------

function BossTactics:ShowRaidleadersFrame()

    if(self.RaidleadersFrame == nil)then
        self.RaidleadersFrame = CreateFrame("Frame","BT_RaidleadersFrame",self.MainWindow)
        self.RaidleadersFrame:ClearAllPoints()
        self.RaidleadersFrame:SetPoint("CENTER",self.MainWindow)
        self.RaidleadersFrame:SetHeight(250)
        self.RaidleadersFrame:SetWidth(450)
        self.RaidleadersFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        self.RaidleadersFrame:SetBackdropColor(1/255, 1/255, 1/255)
        --self.RaidleadersFrame:SetBackdropBorderColor(1.0,0,0.0)

        self.RaidleadersFrame.SaveBtn = CreateFrame("Button","BT_Raidleadersframe_Save",self.RaidleadersFrame,"UIPanelButtonTemplate")
        self.RaidleadersFrame.SaveBtn:SetWidth(100)
        self.RaidleadersFrame.SaveBtn:SetHeight(20)
        self.RaidleadersFrame.SaveBtn:SetText(L["Save"])
        self.RaidleadersFrame.SaveBtn:SetPoint("BOTTOMLEFT",self.RaidleadersFrame,"BOTTOMLEFT",15,15)
        self.RaidleadersFrame.SaveBtn:SetScript("OnClick",function()
                    if(self.RaidleadersFrame.SaveCheckBoxBtn:GetChecked())then
                        self.db.profile.saveRaidleaders = true
                    else
                        self.db.profile.saveRaidleaders = false
                    end
                    --self.db.profile.raidleaderList = {}
                    for i,v in ipairs(self.RaidleadersFrame.SelectedFrame.TextArray)do
                        local found = false
                        for index,value in ipairs(self.db.profile.raidleaderList)do
                            if(value == v:GetText())then
                               found = true
                               break
                            end
                        end
                        if(not found)then
                               tinsert(self.db.profile.raidleaderList,v:GetText())
                               self:BT_SendDataMessage("{AYES}",true,v:GetText())
                        end
                    end
                    for i,v in ipairs(self.db.profile.raidleaderList)do
                        local found = false
                        for index,value in ipairs(self.RaidleadersFrame.SelectedFrame.TextArray)do
                            if(v == value:GetText())then
                               found = true
                               break
                            end
                        end
                        if(not found)then
                           tremove(self.db.profile.raidleaderList,i)
                           if(UnitInRaid(v))then
                               self:BT_SendDataMessage("{ANO}",true,v)
                           end
                        end
                    end
                    this:GetParent():Hide()
             end)
        self.RaidleadersFrame.SaveBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)

        self.RaidleadersFrame.CancelBtn = CreateFrame("Button","BT_Raidleadersframe_Cancel",self.RaidleadersFrame,"UIPanelButtonTemplate")
        self.RaidleadersFrame.CancelBtn:SetWidth(100)
        self.RaidleadersFrame.CancelBtn:SetHeight(20)
        self.RaidleadersFrame.CancelBtn:SetText(L["Cancel"])
        self.RaidleadersFrame.CancelBtn:SetPoint("BOTTOMLEFT",self.RaidleadersFrame,"BOTTOMLEFT",120,15)
        self.RaidleadersFrame.CancelBtn:SetScript("OnClick",function() this:GetParent():Hide() end)
        self.RaidleadersFrame.CancelBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)

        self.RaidleadersFrame.Title = self.RaidleadersFrame:CreateFontString(nil,"OVERLAY","MailTextFontNormal")
        self.RaidleadersFrame.Title:SetTextColor(1,1,1)
        self.RaidleadersFrame.Title:SetText(L["raidleaders title"])
        self.RaidleadersFrame.Title:SetPoint("TOP",self.RaidleadersFrame,"TOP",0,-20)
        self.RaidleadersFrame.Title:SetJustifyH("LEFT")

        self.RaidleadersFrame.Raidleadersbtn=CreateFrame("Button","BT_cRaidleaders",self.RaidleadersFrame)
        self.RaidleadersFrame.Raidleadersbtn:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
        self.RaidleadersFrame.Raidleadersbtn:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
        self.RaidleadersFrame.Raidleadersbtn:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
        self.RaidleadersFrame.Raidleadersbtn:SetWidth(20)
        self.RaidleadersFrame.Raidleadersbtn:SetHeight(20)
        self.RaidleadersFrame.Raidleadersbtn:SetPoint("TOPRIGHT",self.RaidleadersFrame,"TOPRIGHT",-5,-5)
        self.RaidleadersFrame.Raidleadersbtn:SetScript("OnClick",function() this:GetParent():Hide() end)
        self.RaidleadersFrame.Raidleadersbtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)

        local choosableFrame = CreateFrame("Frame","BT_choosableRaidleaderframe",self.RaidleadersFrame)
        self.RaidleadersFrame.ChoosableFrame = choosableFrame

        choosableFrame:ClearAllPoints();
        choosableFrame:SetPoint("TOPLEFT",self.RaidleadersFrame, "TOPLEFT", 10,-70)
        choosableFrame:SetWidth(150);
        choosableFrame:SetHeight(70);
        choosableFrame:SetBackdrop({
        --bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 12,
        --edgeFile = "Interface\\TutorialFrame\\TutorialFrameBorder",
        edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
        --insets = {left = 1, right = 1, top = 1, bottom = 1},
        })
        choosableFrame:SetBackdropBorderColor(16/255,24/255,177/255)
        choosableFrame:SetBackdropColor(24/255, 24/255, 24/255)
        self.RaidleadersFrame.titleChoosableScroll = self.RaidleadersFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        self.RaidleadersFrame.titleChoosableScroll:SetTextColor(1,1,1)
        self.RaidleadersFrame.titleChoosableScroll:SetText(L["Title Choosable"])
        self.RaidleadersFrame.titleChoosableScroll:SetPoint("TOPLEFT",self.RaidleadersFrame,"TOPLEFT",10,-50)
        choosableFrame.offset = 1
        choosableFrame.scrollUp = false
        choosableFrame.TextArray = {}
        choosableFrame.CheckSelected = function()
                 if(#choosableFrame.TextArray >= 1)then
                    choosableFrame.SelectedTexture:Show()
                else
                    choosableFrame.SelectedTexture:Hide()
                end
            end

        choosableFrame.SelectedTexture = choosableFrame:CreateTexture("BT_SelectedChoosable","BACKGROUND")
        choosableFrame.SelectedTexture:SetPoint("TOPLEFT",choosableFrame,"TOPLEFT",5,-10)
        choosableFrame.SelectedTexture:SetWidth(choosableFrame:GetWidth()-30)
        choosableFrame.SelectedTexture:SetHeight(15)
        choosableFrame.SelectedTexture:SetTexture(16/255,24/255,177/255)

        choosableFrame.scrollDownBtn=CreateFrame("Button","BT_scrolldown_choosableRl",choosableFrame)
        choosableFrame.scrollDownBtn:SetNormalTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Up.blp")
        choosableFrame.scrollDownBtn:SetPushedTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Down.blp")
        choosableFrame.scrollDownBtn:SetHighlightTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Highlight.blp")
        choosableFrame.scrollDownBtn:SetWidth(20)
        choosableFrame.scrollDownBtn:SetHeight(20)
        choosableFrame.scrollDownBtn:SetPoint("BOTTOMRIGHT",choosableFrame,"BOTTOMRIGHT",-5,7)
        choosableFrame.scrollDownBtn:SetScript("OnClick",function()
                if(this:GetParent().offset< #(this:GetParent().TextArray))then
                    local oldoffset = this:GetParent().offset
                    this:GetParent().offset = this:GetParent().offset+1
                    while(this:GetParent().TextArray[this:GetParent().offset] and
                            this:GetParent().TextArray[this:GetParent().offset].status == false) do
                         this:GetParent().offset = this:GetParent().offset+1
                    end
                    if(not this:GetParent().TextArray[this:GetParent().offset]) then
                        this:GetParent().offset = oldoffset
                    end
                    BossTactics:ScrollStringTop(this:GetParent(),this:GetParent().TextArray,false)
                end
                 end)

        choosableFrame.scrollUpBtn=CreateFrame("Button","BT_scrollup_choosableRl",choosableFrame)
        choosableFrame.scrollUpBtn:SetNormalTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Up.blp")
        choosableFrame.scrollUpBtn:SetPushedTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Down.blp")
        choosableFrame.scrollUpBtn:SetHighlightTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Highlight.blp")
        choosableFrame.scrollUpBtn:SetWidth(20)
        choosableFrame.scrollUpBtn:SetHeight(20)
        choosableFrame.scrollUpBtn:SetPoint("TOPRIGHT",choosableFrame,"TOPRIGHT",-5,-7)
        choosableFrame.scrollUpBtn:SetScript("OnClick",function()
                if(this:GetParent().offset > 1)then
                    this:GetParent().scrollUp = true;
                    local oldoffset = this:GetParent().offset
                    this:GetParent().offset = this:GetParent().offset-1
                    while(this:GetParent().TextArray[this:GetParent().offset] and
                            this:GetParent().TextArray[this:GetParent().offset].status == false) do
                         this:GetParent().offset = this:GetParent().offset-1
                    end
                    if(not this:GetParent().TextArray[this:GetParent().offset]) then
                        this:GetParent().offset = oldoffset
                    end
                    BossTactics:ScrollStringTop(this:GetParent(),this:GetParent().TextArray,false)
                end
                 end)

        --make the buttons

        self.RaidleadersFrame.PutLeftBtn = CreateFrame("Button","BT_RL_putleft",self.RaidleadersFrame,"UIPanelButtonTemplate")
        self.RaidleadersFrame.PutLeftBtn:SetWidth(60)
        self.RaidleadersFrame.PutLeftBtn:SetHeight(20)
        self.RaidleadersFrame.PutLeftBtn:SetText("<")
        self.RaidleadersFrame.PutLeftBtn:SetPoint("TOPLEFT",self.RaidleadersFrame,"TOPLEFT",195,-100)
        self.RaidleadersFrame.PutLeftBtn:SetScript("OnClick",function()
                                if(#self.RaidleadersFrame.SelectedFrame.TextArray >= 1)then
                                    local sel = tremove(self.RaidleadersFrame.SelectedFrame.TextArray,self.RaidleadersFrame.SelectedFrame.offset)
                                    if(sel.status) then
                                        local newFontstr = self.RaidleadersFrame.ChoosableFrame:CreateFontString(nil, "OVERLAY","GameFontNormalSmall")
                                        newFontstr:SetText(sel:GetText())
                                        newFontstr:SetTextColor(1,1,1)
                                        newFontstr.status = true
                                        self:InsertionSort(self.RaidleadersFrame.ChoosableFrame.TextArray,newFontstr)
                                        self:ScrollStringTop(self.RaidleadersFrame.ChoosableFrame,self.RaidleadersFrame.ChoosableFrame.TextArray,true)
                                    end
                                    sel:Hide()
                                    if(self.RaidleadersFrame.SelectedFrame.offset > #self.RaidleadersFrame.SelectedFrame.TextArray)then
                                        self.RaidleadersFrame.SelectedFrame.offset = self.RaidleadersFrame.SelectedFrame.offset-1
                                    end
                                    self:ScrollStringTop(self.RaidleadersFrame.SelectedFrame,self.RaidleadersFrame.SelectedFrame.TextArray,false)
                                    self.RaidleadersFrame.ChoosableFrame:CheckSelected()
                                    self.RaidleadersFrame.SelectedFrame:CheckSelected()
                                end
                              end)
        self.RaidleadersFrame.PutLeftBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)


        self.RaidleadersFrame.PutRightBtn = CreateFrame("Button","BT_Rl_putright",choosableFrame,"UIPanelButtonTemplate")
        self.RaidleadersFrame.PutRightBtn:SetWidth(60)
        self.RaidleadersFrame.PutRightBtn:SetHeight(20)
        self.RaidleadersFrame.PutRightBtn:SetText(">")
        self.RaidleadersFrame.PutRightBtn:SetPoint("TOPLEFT",self.RaidleadersFrame,"TOPLEFT",195,-80)
        self.RaidleadersFrame.PutRightBtn:SetScript("OnClick",function()
                                if(#self.RaidleadersFrame.ChoosableFrame.TextArray >= 1 and
                                    self.RaidleadersFrame.ChoosableFrame.TextArray[self.RaidleadersFrame.ChoosableFrame.offset].status)then
                                    local sel = tremove(self.RaidleadersFrame.ChoosableFrame.TextArray,self.RaidleadersFrame.ChoosableFrame.offset)
                                    local newFontstr = self.RaidleadersFrame.SelectedFrame:CreateFontString(nil, "OVERLAY","GameFontNormalSmall")
                                    newFontstr:SetText(sel:GetText())
                                    sel:Hide()
                                    newFontstr:SetTextColor(1,1,1)
                                    newFontstr.status = true
                                    self:InsertionSort(self.RaidleadersFrame.SelectedFrame.TextArray,newFontstr)
                                    self:ScrollStringTop(self.RaidleadersFrame.SelectedFrame,self.RaidleadersFrame.SelectedFrame.TextArray,true)
                                    if(self.RaidleadersFrame.ChoosableFrame.offset > #self.RaidleadersFrame.ChoosableFrame.TextArray)then
                                        self.RaidleadersFrame.ChoosableFrame.offset = self.RaidleadersFrame.ChoosableFrame.offset-1
                                    end
                                    self:ScrollStringTop(self.RaidleadersFrame.ChoosableFrame,self.RaidleadersFrame.ChoosableFrame.TextArray,false)
                                    self.RaidleadersFrame.ChoosableFrame:CheckSelected()
                                    self.RaidleadersFrame.SelectedFrame:CheckSelected()
                                end
                                  end)
        self.RaidleadersFrame.PutRightBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)

        --make the selected box

        local selectedFrame = CreateFrame("Frame","BT_selectedRaidleaderframe",self.RaidleadersFrame)
        self.RaidleadersFrame.SelectedFrame = selectedFrame

        selectedFrame:ClearAllPoints();
        selectedFrame:SetPoint("TOPRIGHT",self.RaidleadersFrame, "TOPRIGHT", -10,-70)
        selectedFrame:SetWidth(150);
        selectedFrame:SetHeight(70);
        selectedFrame:SetBackdrop({
        --bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 12,
        --edgeFile = "Interface\\TutorialFrame\\TutorialFrameBorder",
        edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
        --insets = {left = 1, right = 1, top = 1, bottom = 1},
        })
        selectedFrame:SetBackdropBorderColor(16/255,24/255,177/255)
        selectedFrame:SetBackdropColor(24/255, 24/255, 24/255)
        self.RaidleadersFrame.titleselectedScroll = self.RaidleadersFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        self.RaidleadersFrame.titleselectedScroll:SetTextColor(1,1,1)
        self.RaidleadersFrame.titleselectedScroll:SetText(L["Title selected"])
        self.RaidleadersFrame.titleselectedScroll:SetPoint("TOPRIGHT",self.RaidleadersFrame,"TOPRIGHT",-80,-50)
        selectedFrame.offset = 1
        selectedFrame.scrollUp = false
        selectedFrame.TextArray = {}
        selectedFrame.CheckSelected = function ()
                if(#selectedFrame.TextArray >= 1)then
                    selectedFrame.SelectedTexture:Show()
                else
                    selectedFrame.SelectedTexture:Hide()
                end
              end

        selectedFrame.SelectedTexture = selectedFrame:CreateTexture("BT_Selectedselected","BACKGROUND")
        selectedFrame.SelectedTexture:SetPoint("TOPLEFT",selectedFrame,"TOPLEFT",5,-10)
        selectedFrame.SelectedTexture:SetWidth(selectedFrame:GetWidth()-30)
        selectedFrame.SelectedTexture:SetHeight(15)
        selectedFrame.SelectedTexture:SetTexture(16/255,24/255,177/255)

        selectedFrame.scrollDownBtn=CreateFrame("Button","BT_scrolldown_selectedRl2",selectedFrame)
        selectedFrame.scrollDownBtn:SetNormalTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Up.blp")
        selectedFrame.scrollDownBtn:SetPushedTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Down.blp")
        selectedFrame.scrollDownBtn:SetHighlightTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Highlight.blp")
        selectedFrame.scrollDownBtn:SetWidth(20)
        selectedFrame.scrollDownBtn:SetHeight(20)
        selectedFrame.scrollDownBtn:SetPoint("BOTTOMRIGHT",selectedFrame,"BOTTOMRIGHT",-5,7)
        selectedFrame.scrollDownBtn:SetScript("OnClick",function()
                if(this:GetParent().offset< #(this:GetParent().TextArray))then
                    this:GetParent().offset = this:GetParent().offset+1
                    BossTactics:ScrollStringTop(this:GetParent(),this:GetParent().TextArray,false)
                end
                 end)

        selectedFrame.scrollUpBtn=CreateFrame("Button","BT_scrollup_selectedRl2",selectedFrame)
        selectedFrame.scrollUpBtn:SetNormalTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Up.blp")
        selectedFrame.scrollUpBtn:SetPushedTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Down.blp")
        selectedFrame.scrollUpBtn:SetHighlightTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Highlight.blp")
        selectedFrame.scrollUpBtn:SetWidth(20)
        selectedFrame.scrollUpBtn:SetHeight(20)
        selectedFrame.scrollUpBtn:SetPoint("TOPRIGHT",selectedFrame,"TOPRIGHT",-5,-7)
        selectedFrame.scrollUpBtn:SetScript("OnClick",function()
                if(this:GetParent().offset > 1)then
                    this:GetParent().scrollUp = true;
                    this:GetParent().offset = this:GetParent().offset-1
                    BossTactics:ScrollStringTop(this:GetParent(),this:GetParent().TextArray,false)
                end
                 end)

    --make the checkboxes
        self.RaidleadersFrame.SaveCheckBoxBtn = CreateFrame("CheckButton","BT_RL_SaveCheckBox",choosableFrame,"UICheckButtonTemplate")
        self.RaidleadersFrame.SaveCheckBoxBtn:SetWidth(20)
        self.RaidleadersFrame.SaveCheckBoxBtn:SetHeight(20)
        self.RaidleadersFrame.SaveCheckBoxBtn:SetPoint("TOPLEFT",self.RaidleadersFrame,"TOPLEFT",10,-160)
        self.RaidleadersFrame.SaveCheckBoxBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)
        self.RaidleadersFrame.SaveCheckBoxBtn:SetChecked(self.db.profile.saveRaidleaders)

        self.RaidleadersFrame.TextSaveCB = self.RaidleadersFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        self.RaidleadersFrame.TextSaveCB:SetTextColor(1,1,1)
        self.RaidleadersFrame.TextSaveCB:SetText(L["Text Save Checkbox"])
        self.RaidleadersFrame.TextSaveCB:SetWidth(400)
        self.RaidleadersFrame.TextSaveCB:SetJustifyH("LEFT")
        self.RaidleadersFrame.TextSaveCB:SetPoint("TOPLEFT",self.RaidleadersFrame,"TOPLEFT",35,-160)

    end
    self:UpdateRaidleaderFrame()
    self.RaidleadersFrame:Show()
    self.RaidleadersFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+21)

end;

function BossTactics:UpdateRaidleaderFrame()

    if(not self.RaidleadersFrame) then return end

    local choosableFrame = self.RaidleadersFrame.ChoosableFrame
    local selectedFrame = self.RaidleadersFrame.SelectedFrame
    local anzMembers = GetNumRaidMembers()
    local i =0

    for i,v in ipairs(selectedFrame.TextArray)do
        v:Hide()
    end
    selectedFrame.TextArray = {}

   -- if(self.db.profile.saveRaidleaders)then
        for i,v in ipairs(self.db.profile.raidleaderList)do
           local tmpFontstr = selectedFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
           tmpFontstr:SetTextColor(1,1,1)
           tmpFontstr:SetText(v)
           tmpFontstr.status = true
           self:InsertionSort(selectedFrame.TextArray,tmpFontstr)
           self:ScrollStringTop(selectedFrame,selectedFrame.TextArray,true)
        end
   -- end
    for i,v in ipairs(choosableFrame.TextArray)do
        v:Hide()
    end
    choosableFrame.TextArray = {}
    self:UpdateRaidleaderFrameData()

end;

function BossTactics:UpdateRaidleaderFrameData()
    local choosableFrame = self.RaidleadersFrame.ChoosableFrame
    local selectedFrame = self.RaidleadersFrame.SelectedFrame
    local anzMembers = GetNumRaidMembers()
    for index,v in ipairs(selectedFrame.TextArray) do
         v:SetTextColor(152/255,152/255,152/255)
         v.status = false
    end
    for index,v in ipairs(choosableFrame.TextArray) do
         v:SetTextColor(152/255,152/255,152/255)
         v.status = false
         v.found = false
    end
     for i=1, anzMembers, 1 do
        local name, rank, subgroup, level, class,
              fileName,zone, online, isDead, role, isML = GetRaidRosterInfo(i)
        if(rank == 1 and name ~= self.player)then
            local found = false
            for index,v in ipairs(selectedFrame.TextArray) do
                if(v:GetText() == name) then
                    found = true
                    v:SetTextColor(1,1,1)
                    v.status = true
                    break
                end
            end
            if(not found)then
               for index,v in ipairs(choosableFrame.TextArray) do
                    if(v:GetText() == name) then
                        found = true
                        v:SetTextColor(1,1,1)
                        v.status = true;
                        v.found = true
                        break
                    end
                end
               if(not found)then
                   local tmpFontstr = choosableFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
                   tmpFontstr:SetTextColor(1,1,1)
                   tmpFontstr:SetText(name)
                   self:InsertionSort(choosableFrame.TextArray,tmpFontstr)
                   self:ScrollStringTop(choosableFrame,choosableFrame.TextArray,true)
                   tmpFontstr.status = true
               end
            end
        end
    end
    selectedFrame:CheckSelected()
    choosableFrame:CheckSelected()

end;

function BossTactics:ShowVoteRlFrame()

	 if(not UnitInRaid(self.player))then
	 	self:Print(L["no raid"])
	 	return
	 end
	 if(not self:IsRaidLeader())then
	 	self:Print(L["vote chat err"])
	 	return
	 end

	 if(self.RlVoteFrame == nil)then
        self.RlVoteFrame = CreateFrame("Frame","BT_RlVoteFrame",UIPanel)
        self.RlVoteFrame:ClearAllPoints()
        self.RlVoteFrame:SetPoint("CENTER",UIParent)
        self.RlVoteFrame:SetHeight(270)
        self.RlVoteFrame:SetWidth(350)
        self.RlVoteFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        self.RlVoteFrame:SetBackdropColor(1/255, 1/255, 1/255)

        self.RlVoteFrame.StartBtn = CreateFrame("Button","BT_RlVoteFrame_Start",self.RlVoteFrame,"UIPanelButtonTemplate")
        self.RlVoteFrame.StartBtn:SetWidth(180)
        self.RlVoteFrame.StartBtn:SetHeight(20)
        self.RlVoteFrame.StartBtn:SetText(L["Start vote"])
        self.RlVoteFrame.StartBtn:SetPoint("BOTTOMLEFT",self.RlVoteFrame,"BOTTOMLEFT",15,15)
        self.RlVoteFrame.StartBtn:SetScript("OnClick",function()
                   local alts = {strsplit("\n",self.RlVoteFrame.ScrollvoteAltsFrame:GetScrollChild():GetText())}
                   local count =0;
                   for i,v in ipairs(alts)do
                        if(strlen(strtrim(v)) > 0)then
                            count = count+1
                        end
                   end
                   if(count < 2)then
                   	    BossTactics:ShowInfoMessage(L["vote err1"])
                        return
                   end
                   if(count > 5)then
                   	    BossTactics:ShowInfoMessage(L["vote err3"])
                        return
                   end
                   if(strlen(strtrim(self.RlVoteFrame.voteInput:GetText())) == 0)then
                   		BossTactics:ShowInfoMessage(L["vote err2"])
                        return
                   end
                   this:Disable()
                   self:ShowVoteFrame(self.player, strtrim(self.RlVoteFrame.voteInput:GetText()), true)
                   self.RlVoteFrame.voteStarted = true
				   self.RlVoteFrame.alts = {}
				   self.RlVoteFrame.responseCount = 0
				   self:BT_SendDataMessage("{VOTESTART:"..strtrim(self.RlVoteFrame.voteInput:GetText()).."}")
				   for i,v in ipairs(alts)do
                        if(strlen(strtrim(v)) > 0)then
                            self:BT_SendDataMessage("{VMSG:"..strtrim(v).."}")
                            tinsert(self.RlVoteFrame.alts,{v,0})
                        end
                   end
                   tinsert(self.RlVoteFrame.alts,{L["Abstention"],0})
                   self.RlVoteFrame.timer=30
                   self.RlVoteFrame.TimeLeftText:Show()
                   self.RlVoteFrame.VoteTimer:ScheduleRepeatingTimer("BT_VoteRlTimer", function ()
                        self.RlVoteFrame.timer = self.RlVoteFrame.timer-1
                        self.RlVoteFrame.TimeLeftText:SetText(format(L["Vote Time rl text"],self.RlVoteFrame.timer))
                        if(self.RlVoteFrame.timer <= 0)then
                           local ind = #self.RlVoteFrame.alts
                           self.RlVoteFrame.alts[ind][2] = self.RlVoteFrame.alts[ind][2]+GetNumRaidMembers()-self.RlVoteFrame.responseCount
                           self.RlVoteFrame:ReceivedVote()
                           self.RlVoteFrame.TimeLeftText:SetText(L["vote done"])
                           self.RlVoteFrame:VoteCleanup()
                        end
                     end, 1)
             end)

        self.RlVoteFrame.CancelBtn = CreateFrame("Button","BT_RlVoteFrame_Cancel",self.RlVoteFrame,"UIPanelButtonTemplate")
        self.RlVoteFrame.CancelBtn:SetWidth(100)
        self.RlVoteFrame.CancelBtn:SetHeight(20)
        self.RlVoteFrame.CancelBtn:SetPoint("BOTTOMLEFT",self.RlVoteFrame,"BOTTOMLEFT",190,15)
        self.RlVoteFrame.CancelBtn:SetScript("OnClick",function()
        	self.RlVoteFrame:VoteCleanup()
        	this:GetParent():Hide()
        end)

        self.RlVoteFrame.PrintVoteBtn = CreateFrame("Button","BT_RlVoteFrame_PrintVote",self.RlVoteFrame,"UIPanelButtonTemplate")
        self.RlVoteFrame.PrintVoteBtn:SetWidth(140)
        self.RlVoteFrame.PrintVoteBtn:SetHeight(20)
        self.RlVoteFrame.PrintVoteBtn:SetText(L["PrintVote"])
        self.RlVoteFrame.PrintVoteBtn:SetPoint("BOTTOMLEFT",self.RlVoteFrame,"BOTTOMLEFT",190,75)
        self.RlVoteFrame.PrintVoteBtn:SetScript("OnClick",function()
        	local anzMembers = GetNumRaidMembers()
        	SendChatMessage(format(L["voteRa"],self.RlVoteFrame.voteInput:GetText()),"RAID")
        	for i,v in ipairs(self.RlVoteFrame.alts)do
        		local result = (v[2]/anzMembers)*100
        		SendChatMessage(v[1]..": "..format("%.2f",result).."%","RAID")
        	end

         end)

        self.RlVoteFrame.Title = self.RlVoteFrame:CreateFontString(nil,"OVERLAY","MailTextFontNormal")
        self.RlVoteFrame.Title:SetTextColor(1,1,1)
        self.RlVoteFrame.Title:SetText(L["rl vote title"])
        self.RlVoteFrame.Title:SetPoint("TOP",self.RlVoteFrame,"TOP",0,-15)
        self.RlVoteFrame.Title:SetJustifyH("LEFT")

        self.RlVoteFrame.titlevoteInputScroll = self.RlVoteFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        self.RlVoteFrame.titlevoteInputScroll:SetTextColor(1,1,1)
        self.RlVoteFrame.titlevoteInputScroll:SetText(L["Title vote Input"])
        self.RlVoteFrame.titlevoteInputScroll:SetPoint("TOPLEFT",self.RlVoteFrame,"TOPLEFT",20,-45)

        self.RlVoteFrame.voteInput = CreateFrame("EditBox","BT_vote_edit",self.RlVoteFrame, "InputBoxTemplate")
        self.RlVoteFrame.voteInput:SetMaxLetters(200)
        self.RlVoteFrame.voteInput:SetPoint("TOPLEFT",self.RlVoteFrame, "TOPLEFT", 20,-60)
        self.RlVoteFrame.voteInput:SetWidth(190);
        self.RlVoteFrame.voteInput:SetHeight(20);
        self.RlVoteFrame.voteInput:SetAutoFocus(false)

        self.RlVoteFrame.resultText = self.RlVoteFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        self.RlVoteFrame.resultText:SetTextColor(1,1,1)
        self.RlVoteFrame.resultText:SetPoint("TOPLEFT",self.RlVoteFrame,"TOPLEFT",20,-95)
        self.RlVoteFrame.resultText:SetJustifyH("LEFT")

		self.RlVoteFrame.ScrollvoteAltsFrame = CreateFrame("ScrollFrame","BT_ScrollvoteAltsFrame",self.RlVoteFrame,"UIPanelScrollFrameTemplate")
        self.RlVoteFrame.ScrollvoteAltsFrame:ClearAllPoints();
        self.RlVoteFrame.ScrollvoteAltsFrame:SetPoint("TOPLEFT",self.RlVoteFrame, "TOPLEFT", 35,-120)
        self.RlVoteFrame.ScrollvoteAltsFrame:SetWidth(self.RlVoteFrame:GetWidth()-100);
        self.RlVoteFrame.ScrollvoteAltsFrame:SetHeight(65);

        local voteAlts_edit = CreateFrame("EditBox","BT_voteAltsedit",self.RlVoteFrame.ScrollvoteAltsFrame)
        self.RlVoteFrame.FrameOfvoteAlts = CreateFrame("Frame","BT_addonlistframe_border",self.RlVoteFrame)
        self.RlVoteFrame.FrameOfvoteAlts:SetBackdrop({
        edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
        })
        self.RlVoteFrame.FrameOfvoteAlts:SetBackdropBorderColor(16/255,24/255,177/255)
        self.RlVoteFrame.FrameOfvoteAlts:SetHeight(90)
        self.RlVoteFrame.FrameOfvoteAlts:SetWidth(self.RlVoteFrame:GetWidth()-50)
        self.RlVoteFrame.FrameOfvoteAlts:ClearAllPoints()
        self.RlVoteFrame.FrameOfvoteAlts:SetPoint("TOPLEFT",self.RlVoteFrame,"TOPLEFT",20,-105)

        voteAlts_edit:ClearAllPoints();
        voteAlts_edit:SetWidth(self.RlVoteFrame:GetWidth()-70)
        voteAlts_edit:SetHeight(65)
        voteAlts_edit:SetPoint("TOPLEFT",self.RlVoteFrame.ScrollvoteAltsFrame,"TOPLEFT",0,0)
        voteAlts_edit:SetText(L["std alts"])
       	voteAlts_edit:SetTextColor(1,1,1)
       	voteAlts_edit:SetFontObject("GameFontNormalSmall")
        self.RlVoteFrame.ScrollvoteAltsFrame:SetScrollChild(voteAlts_edit)
        self.RlVoteFrame.ScrollvoteAltsFrame:SetBackdropColor(24/255, 24/255, 24/255)
        self.RlVoteFrame.titlevoteAltsScroll = self.RlVoteFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        self.RlVoteFrame.titlevoteAltsScroll:SetTextColor(1,1,1)
        self.RlVoteFrame.titlevoteAltsScroll:SetText(L["Title vote alts"])
        self.RlVoteFrame.titlevoteAltsScroll:SetPoint("TOPLEFT",self.RlVoteFrame,"TOPLEFT",20,-95)
        voteAlts_edit:SetScript("OnTextChanged", function()
                 ScrollingEdit_OnTextChanged(this, this:GetParent())
                  end)
        voteAlts_edit:SetScript("OnCursorChanged", function()
                 ScrollingEdit_OnCursorChanged(this, arg1, arg2-10, arg3, arg4) end)
        voteAlts_edit:SetScript("OnUpdate", function()
                 ScrollingEdit_OnUpdate(this, this:GetParent()) end)
        voteAlts_edit:SetScript("OnEscapePressed", function()
                    this:ClearFocus()
                    end)
        voteAlts_edit:SetAutoFocus(false)
        voteAlts_edit:SetMultiLine(true)
        voteAlts_edit:EnableMouse(true)

        self.RlVoteFrame.TimeLeftText = self.RlVoteFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        self.RlVoteFrame.TimeLeftText:SetTextColor(1,1,1)
        self.RlVoteFrame.TimeLeftText:SetPoint("TOPLEFT",self.RlVoteFrame,"TOPLEFT",20,-210)
        self.RlVoteFrame.TimeLeftText:Hide()

        self.RlVoteFrame.VoteTimer = LibStub("LibSimpleTimer-1.0")
        self.RlVoteFrame.timer=0

        self.RlVoteFrame.SelfVoteDone = function()
        	if(self.RlVoteFrame.voteStarted or self:IsRaidLeader())then
        		self.RlVoteFrame.ScrollvoteAltsFrame:Hide()
        		self.RlVoteFrame.titlevoteAltsScroll:Hide()
        		self.RlVoteFrame.FrameOfvoteAlts:Hide()
        		self.RlVoteFrame.resultText:Show()
        		self.RlVoteFrame:ReceivedVote()
        	end
        end

        self.RlVoteFrame.ReceivedVote = function (index)
        	if(index and type(index) == "number")then
        		self.RlVoteFrame.alts[index][2] = self.RlVoteFrame.alts[index][2]+1
        		self.RlVoteFrame.responseCount = self.RlVoteFrame.responseCount+1
        	end
        	local anzMembers = GetNumRaidMembers()
        	local outputStr = ""
        	for i,v in ipairs(self.RlVoteFrame.alts)do
        		local result = (v[2]/anzMembers)*100
        		outputStr = outputStr..v[1]..": "..format("%.2f",result).."%\n"
        	end
        	self.RlVoteFrame.resultText:SetText(outputStr)
        	if(self.RlVoteFrame.responseCount == anzMembers)then
        		self.RlVoteFrame.TimeLeftText:SetText(L["vote done"])
        		self.RlVoteFrame:VoteCleanup()
        	end
        end

        self.RlVoteFrame.VoteCleanup = function ()
        	self.RlVoteFrame.voteStarted = false
        	self.RlVoteFrame.VoteTimer:CancelTimer("BT_VoteRlTimer")
        	self.RlVoteFrame.PrintVoteBtn:Show()
        	self.RlVoteFrame.CancelBtn:SetText(L["Close"])
        end
    end
    self.RlVoteFrame.CancelBtn:SetText(L["Cancel"])
    self.RlVoteFrame.ScrollvoteAltsFrame:Show()
    self.RlVoteFrame.titlevoteAltsScroll:Show()
    self.RlVoteFrame.FrameOfvoteAlts:Show()
    self.RlVoteFrame.resultText:Hide()
    self.RlVoteFrame.TimeLeftText:SetText("")
    self.RlVoteFrame.StartBtn:Enable()
    self.RlVoteFrame.PrintVoteBtn:Hide()
    if(not self.RlVoteFrame:IsShown())then
    	self.RlVoteFrame.voteInput:SetText("")
    end
    self.RlVoteFrame:Show()
    if(self.MainWindow and self.MainWindow:IsShown())then
    	self.RlVoteFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+21)
    	self.RlVoteFrame.StartBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)
    	self.RlVoteFrame.CancelBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)
    end


end;

function BossTactics:ShowVoteFrame(fromPlayer, question, isSelfvote)
	 local theFrame = self.VoteFrame
	 if(theFrame == nil)then
        self.VoteFrame = CreateFrame("Frame","BT_VoteFrame",UIPanel)
        theFrame = self.VoteFrame
        theFrame:ClearAllPoints()
        theFrame:SetPoint("CENTER",UIParent)
        theFrame:SetHeight(160)
        theFrame:SetWidth(350)
        theFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        theFrame:SetBackdropColor(1/255, 1/255, 1/255)

        theFrame.CancelBtn = CreateFrame("Button","BT_VoteFrame_Cancel",theFrame,"UIPanelButtonTemplate")
        theFrame.CancelBtn:SetWidth(140)
        theFrame.CancelBtn:SetHeight(20)
        theFrame.CancelBtn:SetText(L["Cancel Vote"])
        theFrame.CancelBtn:SetPoint("BOTTOMLEFT",theFrame,"BOTTOMLEFT",190,15)
        theFrame.CancelBtn:SetScript("OnClick",function()
        	self:BT_SendDataMessage("{NOVOTE}")
        	theFrame:Clear()
         	this:GetParent():Hide()
         	if(self.RlVoteFrame)then
        		self.RlVoteFrame:SelfVoteDone()
        	end
          end)
        theFrame.SendBtn = CreateFrame("Button","BT_VoteFrame_Send",theFrame,"UIPanelButtonTemplate")
        theFrame.SendBtn:SetWidth(100)
        theFrame.SendBtn:SetHeight(20)
        theFrame.SendBtn:SetText(L["Send"])
        theFrame.SendBtn:SetPoint("BOTTOMLEFT",theFrame,"BOTTOMLEFT",20,15)

        theFrame.Title = theFrame:CreateFontString(nil,"OVEAY","MailTextFontNormal")
        theFrame.Title:SetTextColor(1,1,1)
        theFrame.Title:SetPoint("TOP",theFrame,"TOP",0,-15)
        theFrame.Title:SetJustifyH("LEFT")

        theFrame.VoteText = theFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        theFrame.VoteText:SetTextColor(1,1,1)
        theFrame.VoteText:SetWidth(280)
        theFrame.VoteText:SetJustifyH("LEFT")
        theFrame.VoteText:SetPoint("TOPLEFT",theFrame,"TOPLEFT",20,-45)

        theFrame.VoteCheckBoxBtn1 = CreateFrame("CheckButton","BT_VoteCB1",theFrame,"UICheckButtonTemplate")
        theFrame.VoteCheckBoxBtn1:SetWidth(20)
        theFrame.VoteCheckBoxBtn1:SetHeight(20)
        theFrame.VoteCheckBoxBtn1:SetPoint("TOPLEFT",theFrame,"TOPLEFT",20,-100)
        theFrame.VoteCheckBoxBtn1:SetScript("OnClick",function()
         	theFrame.VoteCheckBoxBtn2:SetChecked(false)
         	theFrame.VoteCheckBoxBtn3:SetChecked(false)
         	theFrame.VoteCheckBoxBtn4:SetChecked(false)
         	theFrame.VoteCheckBoxBtn5:SetChecked(false)
         	theFrame.SendBtn:Enable()
          end)

        theFrame.VoteCheckBoxBtn2 = CreateFrame("CheckButton","BT_VoteCB2",theFrame,"UICheckButtonTemplate")
        theFrame.VoteCheckBoxBtn2:SetWidth(20)
        theFrame.VoteCheckBoxBtn2:SetHeight(20)
        theFrame.VoteCheckBoxBtn2:SetPoint("TOPLEFT",theFrame,"TOPLEFT",20,-120)
        theFrame.VoteCheckBoxBtn2:SetScript("OnClick",function()
         	theFrame.VoteCheckBoxBtn1:SetChecked(false)
         	theFrame.VoteCheckBoxBtn3:SetChecked(false)
         	theFrame.VoteCheckBoxBtn4:SetChecked(false)
         	theFrame.VoteCheckBoxBtn5:SetChecked(false)
         	theFrame.SendBtn:Enable()
          end)

        theFrame.VoteCheckBoxBtn3 = CreateFrame("CheckButton","BT_VoteCB3",theFrame,"UICheckButtonTemplate")
        theFrame.VoteCheckBoxBtn3:SetWidth(20)
        theFrame.VoteCheckBoxBtn3:SetHeight(20)
        theFrame.VoteCheckBoxBtn3:SetPoint("TOPLEFT",theFrame,"TOPLEFT",20,-140)
        theFrame.VoteCheckBoxBtn3:SetScript("OnClick",function()
         	theFrame.VoteCheckBoxBtn2:SetChecked(false)
         	theFrame.VoteCheckBoxBtn1:SetChecked(false)
         	theFrame.VoteCheckBoxBtn4:SetChecked(false)
         	theFrame.VoteCheckBoxBtn5:SetChecked(false)
         	theFrame.SendBtn:Enable()
          end)

        theFrame.VoteCheckBoxBtn4 = CreateFrame("CheckButton","BT_VoteCB4",theFrame,"UICheckButtonTemplate")
        theFrame.VoteCheckBoxBtn4:SetWidth(20)
        theFrame.VoteCheckBoxBtn4:SetHeight(20)
        theFrame.VoteCheckBoxBtn4:SetPoint("TOPLEFT",theFrame,"TOPLEFT",20,-160)
        theFrame.VoteCheckBoxBtn4:SetScript("OnClick",function()
         	theFrame.VoteCheckBoxBtn2:SetChecked(false)
         	theFrame.VoteCheckBoxBtn3:SetChecked(false)
         	theFrame.VoteCheckBoxBtn1:SetChecked(false)
         	theFrame.VoteCheckBoxBtn5:SetChecked(false)
         	theFrame.SendBtn:Enable()
          end)

        theFrame.VoteCheckBoxBtn5 = CreateFrame("CheckButton","BT_VoteCB5",theFrame,"UICheckButtonTemplate")
        theFrame.VoteCheckBoxBtn5:SetWidth(20)
        theFrame.VoteCheckBoxBtn5:SetHeight(20)
        theFrame.VoteCheckBoxBtn5:SetPoint("TOPLEFT",theFrame,"TOPLEFT",20,-180)
        theFrame.VoteCheckBoxBtn5:SetScript("OnClick",function()
         	theFrame.VoteCheckBoxBtn2:SetChecked(false)
         	theFrame.VoteCheckBoxBtn3:SetChecked(false)
         	theFrame.VoteCheckBoxBtn4:SetChecked(false)
         	theFrame.VoteCheckBoxBtn1:SetChecked(false)
         	theFrame.SendBtn:Enable()
          end)

        theFrame.TimeLeftText = theFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        theFrame.TimeLeftText:SetTextColor(1,1,1)
        theFrame.TimeLeftText:SetPoint("TOPLEFT",theFrame,"TOPLEFT",20,-210)

        theFrame.VoteTimer = LibStub("LibSimpleTimer-1.0")
        theFrame.timer=0

        theFrame.currVisibleCheckBoxes = 0;
        theFrame.AddVoteCheckBox = function(info,text)
        	if(theFrame.currVisibleCheckBoxes == 0)then
        		getglobal(theFrame.VoteCheckBoxBtn1:GetName() .. 'Text'):SetText(text)
        		theFrame.VoteCheckBoxBtn1:Show()
        	elseif(theFrame.currVisibleCheckBoxes == 1)then
        		getglobal(theFrame.VoteCheckBoxBtn2:GetName() .. 'Text'):SetText(text)
        		theFrame.VoteCheckBoxBtn2:Show()
        	elseif(theFrame.currVisibleCheckBoxes == 2)then
        		getglobal(theFrame.VoteCheckBoxBtn3:GetName() .. 'Text'):SetText(text)
        		theFrame.VoteCheckBoxBtn3:Show()
        	elseif(theFrame.currVisibleCheckBoxes == 3)then
        		getglobal(theFrame.VoteCheckBoxBtn4:GetName() .. 'Text'):SetText(text)
        		theFrame.VoteCheckBoxBtn4:Show()
        	elseif(theFrame.currVisibleCheckBoxes == 4)then
        		getglobal(theFrame.VoteCheckBoxBtn5:GetName() .. 'Text'):SetText(text)
        		theFrame.VoteCheckBoxBtn5:Show()
        	end
        	theFrame.currVisibleCheckBoxes = theFrame.currVisibleCheckBoxes+1
        	theFrame:SetHeight(170+theFrame.currVisibleCheckBoxes*20)
        	theFrame.TimeLeftText:SetPoint("TOPLEFT",theFrame,"TOPLEFT",20,-110-theFrame.currVisibleCheckBoxes*20)
        end

      theFrame.Clear = function()
      	theFrame.currVisibleCheckBoxes = 0
      	theFrame.SendBtn:Disable()
      	theFrame.VoteTimer:CancelTimer("BT_VoteTimer");
      end

      theFrame.SendBtn:SetScript("OnClick",function()
        	if(theFrame.VoteCheckBoxBtn1:GetChecked())then
        		self:BT_SendDataMessage("{VOTE:1}")
        	elseif(theFrame.VoteCheckBoxBtn2:GetChecked())then
        		self:BT_SendDataMessage("{VOTE:2}")
        	elseif(theFrame.VoteCheckBoxBtn3:GetChecked())then
        		self:BT_SendDataMessage("{VOTE:3}")
        	elseif(theFrame.VoteCheckBoxBtn4:GetChecked())then
        		self:BT_SendDataMessage("{VOTE:4}")
        	elseif(theFrame.VoteCheckBoxBtn5:GetChecked())then
        		self:BT_SendDataMessage("{VOTE:5}")
        	end
        	theFrame.Clear()
        	if(self.RlVoteFrame)then
        		self.RlVoteFrame:SelfVoteDone()
        	end
         	this:GetParent():Hide()
          end)

    end
    theFrame.Title:SetText(format(L["vote title"],fromPlayer))
    if(isSelfvote)then
    	theFrame.VoteText:SetText(question..L["selfvote"])
    else
        theFrame.VoteText:SetText(question)
        theFrame.timer=30
        theFrame.VoteTimer:ScheduleRepeatingTimer("BT_VoteTimer", function ()
            theFrame.timer = theFrame.timer-1
            theFrame.TimeLeftText:SetText(format(L["Vote Time text"],theFrame.timer))
            if(theFrame.timer <= 0)then
                theFrame:Hide()
                theFrame:Clear()
            end
         end, 1)
    end
    if(self:IsRaidLeader())then
    	self:ShowVoteRlFrame()
    	self.RlVoteFrame.StartBtn:Disable()
    end
    PlaySoundFile("Sound\\Creature\\LichKing\\IC_Lich King_Berserk01.wav")
    theFrame.SendBtn:Disable()
    theFrame.VoteCheckBoxBtn1:Hide()
    theFrame.VoteCheckBoxBtn2:Hide()
    theFrame.VoteCheckBoxBtn3:Hide()
    theFrame.VoteCheckBoxBtn4:Hide()
    theFrame.VoteCheckBoxBtn5:Hide()
    theFrame.VoteCheckBoxBtn1:SetChecked(false)
    theFrame.VoteCheckBoxBtn2:SetChecked(false)
    theFrame.VoteCheckBoxBtn3:SetChecked(false)
    theFrame.VoteCheckBoxBtn4:SetChecked(false)
    theFrame.VoteCheckBoxBtn5:SetChecked(false)
    theFrame:Show()
    theFrame:SetFrameLevel(1000)
    if(self.MainWindow and self.MainWindow:IsShown())then
    	theFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+21)
    	theFrame.StartBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)
    	theFrame.CancelBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)
    end


end;

function BossTactics:TestVote()
	local fromPlayer="soro"
	local question = "lalal lalal lalala alla lala  lal alla  ala laallla ala al al a lala alla jklakld aslf jkl sadfljkadslf lkasdljf alks lkjasfkl safdkjfdj  aljksdkljsdaljf kj asjkld klasdflalksjf aksfdkf sad  askfdlka sjkalsfdl"
	self:ShowVoteFrame(fromPlayer,question,true)
	self.VoteFrame:AddVoteCheckBox("test");
	self.VoteFrame:AddVoteCheckBox("test2");
end;