--With great thanks to fara.webeddie.com/frames for all the great tutorials that taught me xml.


function Binder_OnLoad(self)
	out_frame("Binder is Loaded. Use /binder to open window");
	self:RegisterEvent( "ADDON_LOADED" );
	SLASH_BINDER1 = "/Binder";
	SlashCmdList["BINDER"] = function(msg)
		Binder_SlashCommandHandler(msg);
	end
	
end

function Binder_OnEvent(self, event, ...)
	if ( event == "ADDON_LOADED" ) then
		Binder_MinimapButton_OnLoad();
		Minimap_Checkbox_WhenLoaded();
		end		
 end

--This appears in your chat frame
function out_frame(text)
	DEFAULT_CHAT_FRAME:AddMessage(text)
end

--This appears on the top of your screen
function out(text)
	UIErrorsFrame:AddMessage(text, 1.0, 1.0, 0, 1, 10)
end
	
function Binder_SlashCommandHandler()
  Binder_Toggle();
end

function Binder_Toggle()
	local frame = getglobal("Binder_Frame")
	if (frame) then
	if (  frame:IsVisible()  ) then
		--When the Frame Goes away
		frame:Hide();
		Binder_Title:Hide();
		Description_InputBox:Hide();
		Name_Input_Frame:Hide();
		ApplyOrDelete_Frame:Hide();
		Description_Frame:Hide();
		Selection_Frame:Hide();
		Loading_Frame:Hide();
		Options_Frame:Hide();
		Creation_Frame:Hide();
		Description_Input_Frame:Hide();
		Divider_Frame1:Hide();
		Divider_Frame2:Hide();
		Name_InputBox:SetText("");
		Description_InputBox:SetText("");
		Selection = false;
	else
		--When the Frame is Shown again
		frame:Show();
		Binder_Title:Show();
		Name_Input_Frame:Show();
		Description_InputBox:Show();
		ApplyOrDelete_Frame:Show();
		Description_Frame:Show();
		Selection_Frame:Show();
		Loading_Frame:Show();
		Options_Frame:Show();
		Creation_Frame:Show();
		Description_Input_Frame:Show();
		Divider_Frame1:Show();
		Divider_Frame2:Show();
		Name_InputBox:SetText("");
		Description_InputBox:SetText("");
		Selection = false;
	end
	end
end


--Global Variables
ProfileName_OnButton = "";
Currently_Selected_Profile_Num = 0;
Selection = false;

--The Scrolling Frame
function BinderScrollBar_Update()

	local line; 
	local lineplusoffset;
	FauxScrollFrame_Update(BinderScrollBar,Binder_Settings.ProfilesCreated,5,19);
	for line = 1, 5 do 
		lineplusoffset = line + FauxScrollFrame_GetOffset(BinderScrollBar);
		if ( lineplusoffset < (Binder_Settings.ProfilesCreated + 1) ) then
			getglobal("BinderEntry"..line):SetText(Binder_Settings.Profiles[lineplusoffset].Name);
			getglobal("BinderEntry"..line):Show();
		else
			getglobal("BinderEntry"..line):Hide();
		end
	end
	
	if (Currently_Selected_Profile_Num == 0)then
		else
			if (BinderEntry1:GetText() == Binder_Settings.Profiles[Currently_Selected_Profile_Num].Name) then
				BinderEntry1:LockHighlight()
				else
				BinderEntry1:UnlockHighlight();
			end
			
			if (BinderEntry2:GetText() == Binder_Settings.Profiles[Currently_Selected_Profile_Num].Name) then
				BinderEntry2:LockHighlight()
				else
				BinderEntry2:UnlockHighlight();
			end
			
			if (BinderEntry3:GetText() == Binder_Settings.Profiles[Currently_Selected_Profile_Num].Name) then
				BinderEntry3:LockHighlight()
				else
				BinderEntry3:UnlockHighlight();
			end
				
			if (BinderEntry4:GetText() == Binder_Settings.Profiles[Currently_Selected_Profile_Num].Name) then
				BinderEntry4:LockHighlight()
				else
				BinderEntry4:UnlockHighlight();
			end
				
			if (BinderEntry5:GetText() == Binder_Settings.Profiles[Currently_Selected_Profile_Num].Name) then
				BinderEntry5:LockHighlight()
				else
				BinderEntry5:UnlockHighlight();
			end
		end
end

--When you click on a profile
function ProfileSelection_OnClick(self)
	ProfileName_OnButton = self:GetText()
	
	--Sets Currently_Selected_Profile_Num to the profile number on button you pushed
	for i = 1, Binder_Settings.ProfilesCreated do 
		if ( ProfileName_OnButton ~= Binder_Settings.Profiles[i].Name )then
		end
		if ( ProfileName_OnButton == Binder_Settings.Profiles[i].Name )then
			Currently_Selected_Profile_Num = i
		end
	end
	Description_Update(Currently_Selected_Profile_Num)
	Selection = true
	
	BinderScrollBar_Update()
	--Add the middle option here
	
	--for i=1,5 do
	--	Current_Button = "BinderEntry"..i
	--	Current_Button_Name = Current_Button:GetText()
	--	if (Current_Button_Name == Binder_Settings.Profiles[Currently_Selected_Profile_Num].Name)then
	--		Current_Button:LockHighlight()
	--	else
	--		Current_Button:UnlockHighlight()
	--	end
	--end
	
	
end
	
function Description_Update(profilenum)
	if (profilenum == nil)then
	else
		Description_Frame_Text2:SetText(Binder_Settings.Profiles[profilenum].Description)
	end
end

----------------------------------------------------------------------


function Create_Button_OnUpdate()
	
	if (Name_InputBox:GetText() == "") then
		Create_Button:Disable()
		else
		Create_Button:Enable()
		end
end

--creation on hover stuff
function Binder_CreateButton_Details(tt, ldb)
	tt:SetText("This will create a new Keybind Profile with|nthe inputed name using your current Keybinds.|n(Description is optional)")
end

function Binder_CreateButton_OnEnter(self)
	if (self.dragging) then
		return
	end
	GameTooltip:SetOwner(self or UIParent, "ANCHOR_RIGHT")
	Binder_CreateButton_Details(GameTooltip)
end

Binder_Settings = {
	ProfilesCreated = 0,
	Profiles = {}
}

--The Almighty Button that WILL create your new profile


--[[
function Create_OnClick(arg1)
		local NewProfileNum = Binder_Settings.ProfilesCreated +1;
			Binder_Settings.Profiles[NewProfileNum] = {Name = Name_InputBox:GetText(),
														Description = Description_InputBox:GetText(),
														The_Binds = {}
													}
													
			out_frame("Binder Profile Created: " .. Name_InputBox:GetText()) 
			
			--If something is written in the Description box when saved, this shows in the chat screen
				if (Description_InputBox:GetText() ~= "") then
					out_frame("You entered " .. Description_InputBox:GetText().. " as the description for the Profile")
				end
			
			--Creates the Bind Table and saves all the binds to it
			Create_Binds()
			
			--Updates the number of profiles created
			Binder_Settings.ProfilesCreated = Binder_Settings.ProfilesCreated + 1
				
			out("Profile Created: "..Binder_Settings.Profiles[Binder_Settings.ProfilesCreated].Name)
			Name_InputBox:SetText("");
			Description_InputBox:SetText("");
			
			BinderScrollBar_Update()
end

--]]
--Testing this one!!!! Trying to get it so you can't make one with the same name. Problem now is in the loop (FIXED)


function Create_OnClick(arg1)
	
	local exists = false;
	
	for i = 1, Binder_Settings.ProfilesCreated do 
		namecheck = Binder_Settings.Profiles[i].Name
		if (Name_InputBox:GetText() == namecheck) then
			exists = true
			out_frame("Profile '"..Binder_Settings.Profiles[i].Name.."' not created because it already exists.")
			out("Profile '"..Binder_Settings.Profiles[i].Name.."' not created because it already exists.")
		end
	end
	
	if (exists == true)then
	else
		local NewProfileNum = Binder_Settings.ProfilesCreated +1;
		Binder_Settings.Profiles[NewProfileNum] = {Name = Name_InputBox:GetText(),
													Description = Description_InputBox:GetText(),
													The_Binds = {}
												}
													
		out_frame("Binder Profile Created: " .. Name_InputBox:GetText()) 
			
		--If something is written in the Description box when saved, this shows in the chat screen
			if (Description_InputBox:GetText() ~= "") then
				out_frame("You entered " .. Description_InputBox:GetText().. " as the description for the Profile")
			end
			
		--Creates the Bind Table and saves all the binds to it
		Create_Binds()
		
		--Updates the number of profiles created
		Binder_Settings.ProfilesCreated = Binder_Settings.ProfilesCreated + 1
				
		out("Profile Created: "..Binder_Settings.Profiles[Binder_Settings.ProfilesCreated].Name)
		Name_InputBox:SetText("");
		Description_InputBox:SetText("");
			
		BinderScrollBar_Update()
	end
end







function Create_Binds()

	local TheAction, BindingOne, BindingTwo;
	local TotalBinds = GetNumBindings();
	local NewProfileNum = Binder_Settings.ProfilesCreated +1;
	
	for i = 1, TotalBinds do
		TheAction, BindingOne, BindingTwo = GetBinding(i)
		Binder_Settings.Profiles[NewProfileNum].The_Binds[i] = {["TheAction"] = TheAction, 
																["BindingOne"] = BindingOne, 
																["BindingTwo"] = BindingTwo
																}													
	end
end

-- Minimap coding

BinderMinimapSettings = {
	Checkbox = nil;
	xposition = 300;
	yposition = 0; -- default position of the minimap icon
}



function Binder_MinimapButton_OnLoad()
	Binder_MinimapButton:SetPoint("CENTER",BinderMinimapSettings.xposition,BinderMinimapSettings.yposition)
end

function Binder_MinimapButton_Reposition()
	local xlim = (GetScreenWidth()/2)
	local ylim = (GetScreenHeight()/2)
	
	
	if ( BinderMinimapSettings.xposition > xlim) then
		BinderMinimapSettings.xposition = xlim
		end
	if ( BinderMinimapSettings.xposition < (-1) * xlim) then
		BinderMinimapSettings.xposition = (-1) * xlim
		end
	if ( BinderMinimapSettings.yposition > ylim) then
		BinderMinimapSettings.yposition = ylim
		end
	if ( BinderMinimapSettings.yposition < (-1) * ylim) then
		BinderMinimapSettings.yposition = (-1) * ylim
		end
	
	Binder_MinimapButton:SetPoint("CENTER",BinderMinimapSettings.xposition,BinderMinimapSettings.yposition)
end

function Binder_MinimapButton_DraggingFrame_OnUpdate()
	
	local xcursor, ycursor = GetCursorPosition()

	local xpos = (xcursor/UIParent:GetEffectiveScale()) - (GetScreenWidth()/2);
	local ypos = (ycursor/UIParent:GetEffectiveScale()) - (GetScreenHeight()/2);
	
	BinderMinimapSettings.xposition = xpos
	BinderMinimapSettings.yposition = ypos
	
	Binder_MinimapButton_Reposition() 
end

function Binder_MinimapButton_OnEnter(self)
	if (self.dragging) then
		return
	end
	GameTooltip:SetOwner(self or UIParent, "ANCHOR_LEFT")
	Binder_MinimapButton_Details(GameTooltip)
end

function Binder_MinimapButton_Details(tt, ldb)
	tt:SetText("Binder|n|nLeft Click: Open Frame|nRight Click: Drag)")
end

function Minimap_Reset(arg1)
	BinderMinimapSettings.xposition = 0
	BinderMinimapSettings.yposition = 0
	Binder_MinimapButton_Reposition()
end

function Minimap_Reset_Details(tt, ldb)
	tt:SetText("Will reset the position of the|nminimap button to center screen")
end

function Minimap_Reset_OnEnter(self)
	if (self.dragging) then
		return
	end
	GameTooltip:SetOwner(self or UIParent, "ANCHOR_RIGHT")
	Minimap_Reset_Details(GameTooltip)
end


function Minimap_Checkbox_WhenLoaded()
	if (BinderMinimapSettings.Checkbox == 1) then
		Minimap_CheckButton1:SetChecked(true)
	else
		Minimap_CheckButton1:SetChecked(false)
	end
	Minimap_Checkbox_OnUpdate()
end

function Minimap_Checkbox_OnUpdate()
	if (Minimap_CheckButton1:GetChecked() == 1) then
		BinderMinimapSettings.Checkbox = 1
		Binder_MinimapButton:Hide()
	else
		BinderMinimapSettings.Checkbox = nil
		Binder_MinimapButton:Show()
	end
end

--Stuff for the Apply Button
function Binder_ApplyButton_Details(tt, ldb)
	tt:SetText("This Button will Apply|nthe currently selected|nBinder profile")
end

function Binder_ApplyButton_OnEnter(self)
	if (self.dragging) then
		return
	end
	GameTooltip:SetOwner(self or UIParent, "ANCHOR_RIGHT")
	Binder_ApplyButton_Details(GameTooltip)
end

function Apply_OnClick(arg1)

	LoadBindings(0)
	SetBinding("1")
	SetBinding("2")
	SetBinding("3")
	SetBinding("4")
	SetBinding("5")
	SetBinding("6")
	SetBinding("7")
	SetBinding("8")
	SetBinding("9")
	SetBinding("0")
	SetBinding("-")
	SetBinding("=")
	
	for i = 1, GetNumBindings() do 
		local TheAction = Binder_Settings.Profiles[Currently_Selected_Profile_Num].The_Binds[i].TheAction
		local BindingOne = Binder_Settings.Profiles[Currently_Selected_Profile_Num].The_Binds[i].BindingOne
		local BindingTwo = Binder_Settings.Profiles[Currently_Selected_Profile_Num].The_Binds[i].BindingTwo
		
		if (BindingOne ~= nil)then
			SetBinding(BindingOne, TheAction)
		end
		if (BindingOne == nil)then
		end
			
		if (BindingTwo ~= nil)then
			SetBinding(BindingTwo, TheAction)
		end
		if (BindingTwo == nil)then
		end
	end
	SaveBindings(2)
	out_frame("Profile "..ProfileName_OnButton.." has been loaded")
end

function Apply_Button_OnUpdate()
	
	if (Selection == false) then
		Apply_Button:Disable()
		end
	if (Selection == true) then
		Apply_Button:Enable()
		end
end


--Stuff for the Delete Button
function Binder_DeleteButton_Details(tt, ldb)
	tt:SetText("WARNING!!! If you delete a|nprofile, you CANNOT get it back|n|nSo be careful...)")
end

function Binder_DeleteButton_OnEnter(self)
	if (self.dragging) then
		return
	end
	GameTooltip:SetOwner(self or UIParent, "ANCHOR_RIGHT")
	Binder_DeleteButton_Details(GameTooltip)
end


-- Something here is not working the right way!
function Delete_OnClick(arg1)
	
	out_frame("Profile "..ProfileName_OnButton.." was deleted")
	if (Currently_Selected_Profile_Num < Binder_Settings.ProfilesCreated)then
		for i = Currently_Selected_Profile_Num, Binder_Settings.ProfilesCreated-1 do
			Binder_Settings.Profiles[i] = Binder_Settings.Profiles[i + 1]
		end
		Binder_Settings.Profiles[Binder_Settings.ProfilesCreated] = nil
	else
		Binder_Settings.Profiles[Binder_Settings.ProfilesCreated] = nil
 	end
	
	Binder_Settings.ProfilesCreated = Binder_Settings.ProfilesCreated-1
	Currently_Selected_Profile_Num = 0
	Selection = false
	BinderScrollBar_Update()
	
end

function Hide_Areyousure()
	Areyousure_Frame:Hide()
end

function Delete_Button_OnUpdate()
	if (Selection == false) then
		Delete_Button:Disable()
		end
	
	if (Selection == true) then
		Delete_Button:Enable()
		end
end

function DeleteAll_Button_OnClick()
	for i = 1, Binder_Settings.ProfilesCreated do
		Binder_Settings.Profiles[i] = nil
	end
	Currently_Selected_Profile_Num = 0
	Binder_Settings.ProfilesCreated = 0
	BinderScrollBar_Update()
	out_frame("All profiles are erased.")
end

function DeleteAll_Button_OnUpdate()
	
	if (Currently_Selected_Profile_Num == 0)then
	else
		if (Binder_Settings.Profiles[Currently_Selected_Profile_Num].Name == "Delete All") then
			DeleteAll_Button:Enable()
			
		else 
			DeleteAll_Button:Disable()
		end
	end
end

function Close_Button_Details(tt, ldb)
	tt:SetText("Close")
end

function Close_Button_OnEnter(self)
	if (self.dragging) then
		return
	end
	GameTooltip:SetOwner(self or UIParent, "ANCHOR_RIGHT")
	Close_Button_Details(GameTooltip)
end




