﻿--BetterSocialTooltip = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceHook-2.1");
BetterSocialTooltip = AceLibrary("AceAddon-2.0"):new("AceHook-2.1");
--BetterSocialTooltip = LibStub("AceAddon-3.0"):NewAddon("BetterSocialTooltip", "AceEvent-3.0", "AceConsole-3.0", "AceHook-3.0");
--BetterSocialTooltip = LibStub("AceAddon-3.0"):NewAddon("BetterSocialTooltip", "AceHook-3.0");

function BetterSocialTooltip:OnInitialize()
end

function BetterSocialTooltip:OnEnable()
	self:HookScript(FriendsMicroButton, "OnEnter", "OnMouseOver");
end

function BetterSocialTooltip:OnDisable()
	self:UnHookAll();
end

function BetterSocialTooltip:OnMouseOver()
	local numBNetFriends, numBNetOnline = BNGetNumFriends();
	local numWoWFriends, numWoWOnline = GetNumFriends();
	local sPlural = "s";
	
	GameTooltip_AddNewbieTip(FriendsMicroButton, MicroButtonTooltipText(SOCIAL_BUTTON, "TOGGLESOCIAL"), 1.0, 1.0, 1.0, NEWBIE_TOOLTIP_SOCIAL);
	if (numBNetOnline + numWoWOnline) == 1 then
		sPlural = "";
	end
	GameTooltip:AddLine((numBNetOnline + numWoWOnline) .. " Friend" .. sPlural .. " Online", 0, 1, 0);
	-- Battle.net Friends
	for i = 1, numBNetFriends, 1 do
		local sPresenceID, sNameFirst, sNameLast, sCharName, sCharID, sClient, bIsOnline = BNGetFriendInfo(i);
		if bIsOnline then
			local sArea = sClient;
			if sClient == "WoW" then
				local _, _, _, sServer = BNGetToonInfo(sPresenceID);
				sArea = sServer;
			end
			GameTooltip:AddLine(sCharName .. " (" .. sArea .. ") [" .. sNameFirst .. " " .. sNameLast .. "]", 0, 1, 1 );
		end
	end
	-- Regular Friends
	for i = 1, numWoWFriends, 1 do
		local sName, iLevel, sClass, sArea, bConnected, sNote, fStatus = GetFriendInfo(i);
		if bConnected then
			GameTooltip:AddLine(sName, 1, 1, 1);
		end
	end
	
    GameTooltip:Show();
end