--[[
************************************************************************

tooltip.lua

File date: 2010-07-13T14:36:51Z
File revision: 237
Project revision: 237
Project version: Locale update


Author: Angelike

************************************************************************
]]--

local beql = LibStub("AceAddon-3.0"):GetAddon("beql")
local L = LibStub("AceLocale-3.0"):GetLocale("beql")

local GameTooltip = GameTooltip

local hooked, MouseOverFrame

local GameTooltipQuests = {}

local function RGBPercToHex(r, g, b)
	r = r <= 1 and r >= 0 and r or 0
	g = g <= 1 and g >= 0 and g or 0
	b = b <= 1 and b >= 0 and b or 0
	return string.format("%02x%02x%02x", r*255, g*255, b*255)
end

--[[
--------------------------------------------
-- Notes:
-- Init the Tooltips for beql
--
-- Returns:
-- * nothing
--------------------------------------------]]
function beql:Tooltip_InitTooltip()
	if not hooked then
		-- do some GameTooltip hooks
		GameTooltip:HookScript("OnShow", beql.Hooks_GameTooltip_OnShow)
		GameTooltip:HookScript("OnTooltipSetItem", beql.Hooks_GameTooltip_OnTooltipSetItem)
		GameTooltip:HookScript("OnTooltipSetUnit", beql.Hooks_GameTooltip_OnTooltipSetUnit)
		hooked = true
	end

	if not MouseOverFrame then
		MouseOverFrame = CreateFrame("Frame", "beqlMouseOverFrame")
		--MouseOverFrame:SetScale(UIParent:GetScale())
	end
end


--
-- Hooks
--

function beql.Hooks_GameTooltip_OnShow(this)
	if not beqlQ or not beql:IsEnabled() or not beql.db.profile.Tooltip.mob then
		-- not need
		return
	end

	-- not a mob, item or spell, may an object, check it for queststrings
	if not GameTooltip:GetUnit() and not GameTooltip:GetItem() and not GameTooltip:GetSpell() and GameTooltip:NumLines() > 0 and GameTooltip:IsShown() then
		if beql:Tooltip_ScanTooltip() then
			local maxwidth = 0
			for i=1, GameTooltip:NumLines() do
				maxwidth = max(_G["GameTooltipTextLeft" .. i]:GetWidth(), maxwidth)
			end

			-- adjust width
			if (GameTooltip:GetWidth() - maxwidth) < 20 then
				GameTooltip:SetWidth(maxwidth + 20.48)
			end
		end
	end
end

--[[
--------------------------------------------
-- Notes:
-- Adds a Quest on Questmob if not exists
--
-- Returns:
-- * nothing
--------------------------------------------]]
function beql:Hooks_GameTooltip_OnTooltipSetUnit()

	if not beqlQ or not beql:IsEnabled() or not beql.db.profile.Tooltip.mob then
		-- not need
		return
	end

	beql:Tooltip_ScanTooltip();

	local uID;
	local queryString = GameTooltip:GetUnit();
	if queryString then
		if beqlQ:IsQuestMob(queryString) then
			uID = beqlQ.quest_mobs[queryString];
		end
	end

	-- questmob not found, may we must "collect" the mob as item? (i.e. "Snowfall Glade Pup")
	if not uID and beqlQ:IsQuestItem(queryString) then
		uID = beqlQ:IsQuestItem(queryString);
	end

	if uID and type(uID) == 'number' then
		local found = false;
		for _, qid in pairs (GameTooltipQuests) do
			if uID == qid then
				-- quest already in tooltip
				found = true;
			end
		end
		if not found then

			-- not in tooltip, add it
			local qID, _ , qTitle, qLvl, qTag, qObj, qStat, qRec, qdaily, qZone = beqlQ:GetQuestByUid(uID);

			-- color
				local color;
				if beql.db.profile.Tooltip.GameTooltip_TitelIsQuestcolor then
					color = GetQuestDifficultyColor(qLvl);
				else
					color = CopyTable(beql.db.profile.Tooltip.Colors.GameTooltip_MobTitle);
				end

			if beql.db.profile.QuestLog.showlevel then
					qTag = " [" .. qLvl .. string.upper(beqlQ:GetShortTagForQuest(qID)).."] ";
			else
					qTag = " ";
			end

			GameTooltip:AddLine(qTag .. qTitle, color.r, color.g, color.b)
			for objname, objval in pairs(beqlQ.quest_objectives[uID]) do
				if objname == queryString then
					local objP, objN,_ = unpack(objval)
--					GameTooltip:AddLine("  - " .. objname .. ": " .. objP .. "/" .. objN, color.r, color.g, color.b)
					-- objective
					if beql.db.profile.Tooltip.GameTooltip_ColorObjectives then
						if beql.db.profile.Tooltip.GameTooltip_FadeObjectiveColors then
							local percent = beql:round((objP/objN)*100,2)
							if beql.db.profile.Tooltip.GameTooltip_ObjectiveUseStep then
								if percent < 50 then
									color = beql:FadeColors(beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete, beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveStep, objP, objN/2)
								else
									color = beql:FadeColors(beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveStep, beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete, objP-(objN/2), objN)
								end
							else
								color = beql:FadeColors(beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete, beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete, objP, objN)
							end
						else
							if objP ~= objN then
								color = beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete
							else
								color = beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete
							end
						end
					end
					GameTooltip:AddLine("  - " .. objname .. ": " .. objP .. "/" .. objN, color.r, color.g, color.b)
				end
			end

			-- perform a manual Tooltipupdate out of updatetime
			GameTooltip:GetScript("OnUpdate")(GameTooltip, 1)
		end
	end

end

--[[
--------------------------------------------
-- Notes:
-- Adds a Quest on Questitem if not exist
--
-- Returns:
-- * nothing
--------------------------------------------]]
function beql:Hooks_GameTooltip_OnTooltipSetItem()
	if not beqlQ or not beql:IsEnabled() or not beql.db.profile.Tooltip.item then
		-- not need
		return
	end

--		beql:Tooltip_ScanTooltip() -- may in future
	GameTooltipQuests = {}

	local queryString = GameTooltip:GetItem()
	if queryString then
		if beqlQ:IsQuestItem(queryString) then
			local uID, objName, objP, objN, _ = beqlQ:IsQuestItem(queryString)
			local found = false
			if GameTooltipQuests and #GameTooltipQuests > 0 then
				for _, qid in pairs (GameTooltipQuests) do
					if uID == qid then
						-- quest already in tooltip
						found = true
					end
				end
			end
			if not found then
				-- not in tooltip, add it
				local qID, _ , qTitle, qLvl, qTag = beqlQ:GetQuestByUid(uID)

				-- color
				local color
				if beql.db.profile.Tooltip.GameTooltip_TitelIsQuestcolor then
					color = GetQuestDifficultyColor(qLvl)
				else
					color = CopyTable(beql.db.profile.Tooltip.Colors.GameTooltip_ItemTitle)
				end

				if beql.db.profile.QuestLog.showlevel then
						qTag = " [" .. qLvl .. string.upper(beqlQ:GetShortTagForQuest(qID)).."] "
				else
						qTag = " "
				end


				
				GameTooltip:AddLine(qTag .. qTitle, color.r, color.g, color.b)
				-- objective
				if beql.db.profile.Tooltip.GameTooltip_ColorObjectives then
					if beql.db.profile.Tooltip.GameTooltip_FadeObjectiveColors then
						local percent = beql:round((objP/objN)*100,2)
						if beql.db.profile.Tooltip.GameTooltip_ObjectiveUseStep then
							if percent < 50 then
								color = beql:FadeColors(beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete, beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveStep, objP, objN/2)
							else
								color = beql:FadeColors(beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveStep, beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete, objP-(objN/2), objN)
							end
						else
							color = beql:FadeColors(beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete, beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete, objP, objN)
						end
					else
						if objP ~= objN then
							color = beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete
						else
							color = beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete
						end
					end
				end
				GameTooltip:AddLine("  - " .. objName .. ": " .. objP .. "/" .. objN, color.r, color.g, color.b)
			end
		end
	end
end

--
-- User Functions
--

--[[
--------------------------------------------
-- Notes:
-- Scans Tooltip for any Quests
--
-- Returns:
-- * boolean - true if found a quest
--------------------------------------------]]
function beql:Tooltip_ScanTooltip()
	GameTooltipQuests = {}
	local found, qstat = false, false
	local questline
	local line, hexcolor, linetext
	local qID, qTitle, qLvl, qTag, qComplete, _
	local color = {}
	local Color = {}
	for i= 1, GameTooltip:NumLines() do
		if i > 1 then
			line = _G["GameTooltipTextLeft" .. i]
			Color = {}
			Color.r, Color.g, Color.b, Color.a = line:GetTextColor()
			hexcolor = RGBPercToHex(Color.r, Color.g, Color.b)
			if (hexcolor == "fed100") then
				-- may a Quest
				linetext = line:GetText()
				for key, quest in pairs(beqlQ.quests) do
					-- search quest by name
					if quest.title == linetext then
						-- Quest found!
						found = true
						qID = key;
						table.insert(GameTooltipQuests, qID)
						qTitle, qLvl, _, _, qComplete = select(3,beqlQ:GetQuestByUid(qID))

						if qComplete == 2 then
							qstat = 1
							line:SetHeight(0.01)
							line:SetTextColor(0,0,0,0)
							line:SetText(" ")
							line:SetPoint("TOPLEFT", _G["GameTooltipTextLeft" .. (i-1)],0,-2)
						else
							qstat = 0
							local color
							if beql.db.profile.Tooltip.GameTooltip_TitelIsQuestcolor then
								color = GetQuestDifficultyColor(qLvl)
							else
								color = CopyTable(beql.db.profile.Tooltip.Colors.GameTooltip_MobTitle)
							end

							if beql.db.profile.QuestLog.showlevel then
									qTag = " [" .. qLvl .. string.upper(beqlQ:GetShortTagForQuest(qID)).."] "
							else
									qTag = " "
							end
							qTitle = qTag .. line:GetText()
							line:SetText(qTitle)-- .. " (QuestId: " .. tostring(key) .. ")")
							line:SetTextColor(color.r, color.g, color.b)
						end
							
					end
				end
			elseif qstat and (hexcolor == 'fefefe') and strmatch(line:GetText(), '^ (\-) ') then
				if qstat == 1 then
					line:SetHeight(0.01)
					line:SetTextColor(0,0,0,0)
					line:SetText(" ")
					line:SetPoint("TOPLEFT", _G["GameTooltipTextLeft" .. (i-1)],0,-2)
				else
					if beql.db.profile.Tooltip.GameTooltip_ColorObjectives then
						local color
						local has, need = string.match(line:GetText(), " - \.-: (%d+)/(%d+)")
						if has and need then
							if beql.db.profile.Tooltip.GameTooltip_FadeObjectiveColors then
								local percent = beql:round((has/need)*100,2)
								if beql.db.profile.Tooltip.GameTooltip_ObjectiveUseStep then
									if percent < 50 then
										color = beql:FadeColors(beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete, beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveStep, has, need/2)
									else
										color = beql:FadeColors(beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveStep, beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete, has-(need/2), need)
									end
								else
									color = beql:FadeColors(beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete, beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete, has, need)
								end
							else
								if has ~= need then
									color = beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete
								else
									color = beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete
								end
							end
						else
							color = beql.db.profile.Tooltip.Colors.GameTooltip_NonObjective
						end
						line:SetTextColor(color.r, color.g, color.b)
					end
					-- quest objective
					line:SetText(" " .. line:GetText())
				end
			elseif ( line:GetText() ~= qTitle ) then
				qstat = nil;
			end
		end
		line, linetext, hexcolor = nil, nil, nil;
	end
	return found
end

--[[
--------------------------------------------
-- Notes:
-- Handles klicks on Questtracker
--
-- Returns:
-- * nothing
--------------------------------------------]]
function beql:QuestTracker_Click(frame, button)
	beql:debugprint(frame)
	beql:debugprint(button)
		if beqlQuestWatchFrame.ismoving then
			return
		end
		if (not frame.qID or frame.qID <= 0) then
			return
		end
		
		local questindex = beql.uID_2_index[frame.qID]
		
		if not questindex then
			return
		end
		
		if arg1 == "LeftButton" and beql.db.profile.QuestTracker.LeftClick then
			if not IsShiftKeyDown() and IsControlKeyDown()  then
				if ChatFrame1EditBox:IsVisible() then
					beql:AddQuestStatusToChatFrame(questindex)
				end
			elseif IsShiftKeyDown() and not IsControlKeyDown()  then
				local link = GetQuestLink(questindex)
				if ChatFrame1EditBox:IsVisible() then
					ChatEdit_InsertLink(link);
				else
					SendChatMessage(link, DEFAULT_CHAT_FRAME.editBox:GetAttribute("chatType"))
				end
			else
				SelectQuestLogEntry(questindex)
				if( not QuestLogFrame:IsVisible() ) then
					ShowUIPanel(QuestLogFrame)
				else
					QuestLog_Update()
					QuestLog_UpdateQuestDetails(1)
				end
				if beql.db.char.QuestLogMinimized then
					beql:QuestLog_Maximize()
				end
			end
		elseif arg1 == "RightButton" and beql.db.profile.QuestTracker.RightClick then
			if beql.db.char.QuestTracker_Tooltipset then
				ResetCursor()
				GameTooltip:FadeOut()
				beql.db.char.QuestTracker_Tooltipset = false
			end
			RemoveQuestWatch(questindex)
			QuestLog_Update()
			WatchFrame_Update()
		end
end

--[[
--------------------------------------------
-- Notes:
-- Shows Tooltip on Questtracker
--
-- Returns:
-- * nothing
--------------------------------------------]]

function beql:QuestTracker_OnUpdate(elapsed)
	if not self.qID and not self.Tooltip:IsVisible() then return end
	
	if (self.lastIdUpdate or 0 ) < (GetTime()) then
		self.qID = nil;
	end

	if not self.qID or GetMouseFocus() ~= self then
		if self.Tooltip:IsVisible() then
			self.Tooltip:FadeOut()
			self.Tooltip.qID = nil;
			self.Tooltip.IsIcon = nil;
			ResetCursor()
		end
	elseif self.qID and GetMouseFocus() == self then
		if ( self.qID  ~= self.Tooltip.qID ) then
			self.Tooltip.qID = self.qID
			-- show tooltip
			ResetCursor()
			ShowInspectCursor()
			self.Tooltip:SetOwner(self, "ANCHOR_CURSOR")


			local qID, qTitle, qLvl  = select(2, beqlQ:GetQuestByUid(self.Tooltip.qID))

			if beql.db.profile.Tooltip.QuestTracker_TooltipTitleQuestcolor then
				Color = GetQuestDifficultyColor(qLvl)
			else
				Color = beql.db.profile.Tooltip.Colors.QuestTracker_TooltipTitle
			end
			self.Tooltip:AddLine(qTitle,Color.r,Color.g,Color.b)

			-- Questdetails
			if beql.db.profile.Tooltip.QuestTracker_TooltipDesc then
				local oldSelection = GetQuestLogSelection()
				SelectQuestLogEntry(qID)
				local questObjectives = select(2,GetQuestLogQuestText())
				SelectQuestLogEntry(oldSelection)
				self.Tooltip:AddLine(questObjectives,beql.db.profile.Tooltip.Colors.QuestTracker_TooltipDesc.r,beql.db.profile.Tooltip.Colors.QuestTracker_TooltipDesc.g,beql.db.profile.Tooltip.Colors.QuestTracker_TooltipDesc.b,1)
			end

			-- Groupmember
			-- temp fix for display Groupmember on Quest
			local Groupmember, Raidmember
			if GetNumPartyMembers() > 0 then
				for i=1, GetNumPartyMembers(), 1 do
					local partymember, partyrealm = UnitName("party"..i)

					if partyrealm and partyrealm ~= "" then
						partymember = partymember .. "-" .. partyrealm
					end

					if IsUnitOnQuest(qID, "party" .. i) then
						if not Groupmember then
							Groupmember = partymember
						else
							Groupmember = Groupmember .. ", " .. partymember
						end
					end
				end
				if Groupmember then
					self.Tooltip:AddLine(" ",nil, nil, nil,1)
					self.Tooltip:AddLine("PartyMember on Quest:",1, 1, 1,1)
					self.Tooltip:AddLine(Groupmember,nil, nil, nil,1)
				end
			end

			--[[
			if GetNumPartyMembers() > 0 then
				for i=1, GetNumPartyMembers(), 1 do
					local name = UnitName("party"..i)
					if beqlQ:PartyMemberHasQuest(name,qTitle) then
						if beqlQ:PartyMemberHasQuixote(name) then
							GameTooltip:AddLine(name,beql.db.profile.Color.TooltipPartyQuixote.r,beql.db.profile.Color.TooltipPartyQuixote.g,beql.db.profile.Color.TooltipPartyQuixote.b)
							for description in beqlQ:IteratePartyQuestLeaderboard(name, qTitle) do
								local oPos, oNeed = beqlQ:GetPartyQuestStatus(name, qTitle, description)
								if beql.db.profile.TooltipObjFade then
									Color = beql:FadeColors(beql.db.profile.Color.TooltipPartyObj,beql.db.profile.Color.TooltipPartyObjComp,oPos,oNeed)
								else
									if oPos == oNeed then
										Color = beql.db.profile.Color.TooltipPartyObjComp
									else
										Color = beql.db.profile.Color.TooltipPartyObj
									end
								end
								GameTooltip:AddDoubleLine("  "..description, oPos.."/"..oNeed,Color.r,Color.g,Color.b)
							end
						else
							GameTooltip:AddLine(name,beql.db.profile.Color.TooltipPartyNonQuixote.r, beql.db.profile.Color.TooltipPartyNonQuixote.g, beql.db.profile.Color.TooltipPartyNonQuixote.b)
						end
					end
				end
			end--]]

			self.Tooltip:Show()
		end
	end

end

--[===[
function beql:AchievementTracker_Click(frame, button)
	-- check for valid AchievementID
	if (not frame.aID or frame.aID <= 0) or beql.db.char.AchievementWatchMinimized then
		-- invalid AchievementID
		return
	end

	-- Handle Icon click
	if frame.IsIcon and frame.subaID and button == "RightButton" then
		AchievementButton_ToggleTracking(frame.subaID)
		return
	end

	-- Handle Left Button click
	if button == "LeftButton" then
		local aID
		if frame.subaID then
			aID = frame.subaID
		else
			aID = frame.aID
		end

		if ( IsModifiedClick("CHATLINK") ) then
			local link = GetAchievementLink(aID)
			if ChatFrame1EditBox:IsVisible() and link then
				ChatEdit_InsertLink(link)
			elseif link then
				SendChatMessage(link, DEFAULT_CHAT_FRAME.editBox:GetAttribute("chatType"))
			end
		elseif ( not AchievementFrame:IsShown() ) then
			AchievementFrame_ToggleAchievementFrame();
			AchievementFrame_SelectAchievement(aID);
		else
			if ( AchievementFrameAchievements.selection ~= aID ) then
				AchievementFrame_SelectAchievement(aID);
			else
				AchievementFrame_ToggleAchievementFrame();
			end
		end
		return
	end

	-- Handle
	if button == "RightButton"  then
		AchievementButton_ToggleTracking(frame.aID)
		return
	end

end

--[[
--------------------------------------------
-- Notes:
-- Shows Tooltip on Achievementtracker
--
-- Returns:
-- * nothing
--------------------------------------------]]
local AchievementTooltipID
--[[function beql:AchievementTrackerTooltip(frame)

	local aID, icon, subaID

	for i=1, #beqlFrameCache.AchievementLines do
		if MouseIsOver(beqlFrameCache.AchievementLines[i]) then
			aID = beqlFrameCache.AchievementLines[i].aID
			if MouseIsOver(beqlFrameCache.AchievementLines[i].iconframe) and beqlFrameCache.AchievementLines[i].iconframe.aID then
				subaID = beqlFrameCache.AchievementLines[i].iconframe.aID
				icon = true
			end
			if beqlFrameCache.AchievementLines[i].subaID then
				subaID = beqlFrameCache.AchievementLines[i].subaID
			end
			break
		end
	end

	if not aID then
		-- nothing to do
		beql.db.char.AchievementTracker_Tooltipset = nil;
		return
	end
	if
		frame.Tooltip.aID == aID
	and
		frame.Tooltip.Icon == icon
	and
		frame.Tooltip.SubAchievement == subaID
	then
		-- nothing to do
		return
	end

	beql.db.char.AchievementTracker_Tooltipset = true;
	frame.Tooltip.aID = aID
	frame.Tooltip.Icon = icon
	frame.Tooltip.SubAchievement = subaID

	AchievementTooltipID = aID

	if not beql.db.profile.AchievementTracker.showtooltip or not frame.LineFrame:IsShown() then
		return
	end

	if subaID then
		aID = subaID
	end
	-- show tooltip
	ResetCursor()
	ShowInspectCursor()
	frame.Tooltip:SetOwner(UIParent, "ANCHOR_CURSOR")

	local _, achievementName, _, completed, _, _, _, description = GetAchievementInfo(aID);
	frame.Tooltip:AddLine(achievementName)
	frame.Tooltip:AddLine(" ")
	frame.Tooltip:AddLine(description,1,1,1,true)

	local tooltiphint

	if beql.db.profile.AchievementTracker.showtooltiphint then

		if beql.db.profile.AchievementTracker.clickleft then
			tooltiphint = L['|cffeda55fClick|r to open achievement, |cffeda55fShift+Click|r to link achievement to chat.']
		end

		if beql.db.profile.AchievementTracker.clickright and not frame.Tooltip.Icon then
			tooltiphint = tooltiphint and tooltiphint .. L['|cffeda55fRight-Click|r to cancel tracking of this achievement'] or L['|cffeda55fRight-Click|r to cancel tracking of this achievement']
		elseif beql.db.profile.AchievementTracker.clickright and frame.Tooltip.Icon then
			tooltiphint = tooltiphint and tooltiphint .. L["|cffeda55fRight-Click|r click to toggle watch for this Achievement"] or L["|cffeda55fRight-Click|r click to toggle watch for this Achievement"]
		end

		if tooltiphint then
			frame.Tooltip:AddLine(tooltiphint,0,1,0,true)
		end
	end

	if beql.db.profile.debug then
		frame.Tooltip:AddLine("AchievementID: " .. aID,nil,nil,nil,true)
	end

	frame.Tooltip:Show()

end
--]]
--[[
function beql:AchievementTrackerTooltip(aID, subaID)
	
	if type(aID) ~= 'number' then return end
	
	local frame = beqlAchievementWatchFrame
	
	if
		frame.Tooltip.aID == aID
--	and
--		frame.Tooltip.Icon == icon
	and
		frame.Tooltip.SubAchievement == subaID
	then
		-- nothing to do
		return
	end

	beql.db.char.AchievementTracker_Tooltipset = true;
	frame.Tooltip.aID = aID
	frame.Tooltip.Icon = icon
	frame.Tooltip.SubAchievement = subaID
	
	frame.aID = aID
	frame.subaID = subaID

	AchievementTooltipID = aID

	if not beql.db.profile.AchievementTracker.showtooltip or not frame.LineFrame:IsShown() then
		print("exit")
		return
	end

	if subaID then
		aID = subaID
	end
	-- show tooltip
	ResetCursor()
	ShowInspectCursor()
	frame.Tooltip:SetOwner(UIParent, "ANCHOR_CURSOR")

	local _, achievementName, _, completed, _, _, _, description = GetAchievementInfo(aID);
	frame.Tooltip:AddLine(achievementName)
	frame.Tooltip:AddLine(" ")
	frame.Tooltip:AddLine(description,1,1,1,true)

	local tooltiphint

	if beql.db.profile.AchievementTracker.showtooltiphint then

		if beql.db.profile.AchievementTracker.clickleft then
			tooltiphint = L['|cffeda55fClick|r to open achievement, |cffeda55fShift+Click|r to link achievement to chat.']
		end

		if beql.db.profile.AchievementTracker.clickright and not frame.Tooltip.Icon then
			tooltiphint = tooltiphint and tooltiphint .. L['|cffeda55fRight-Click|r to cancel tracking of this achievement'] or L['|cffeda55fRight-Click|r to cancel tracking of this achievement']
		elseif beql.db.profile.AchievementTracker.clickright and frame.Tooltip.Icon then
			tooltiphint = tooltiphint and tooltiphint .. L["|cffeda55fRight-Click|r click to toggle watch for this Achievement"] or L["|cffeda55fRight-Click|r click to toggle watch for this Achievement"]
		end

		if tooltiphint then
			frame.Tooltip:AddLine(tooltiphint,0,1,0,true)
		end
	end

	if beql.db.profile.debug then
		frame.Tooltip:AddLine("AchievementID: " .. aID,nil,nil,nil,true)
	end

	frame.Tooltip:Show()

end--]]

function beql:AchievementTracker_OnUpdate(frame, elapsed)
--[[	frame.updateTooltip = (frame.updateTooltip or 0.2) - elapsed
	
	-- only check every 0.2 seconds
	if frame.updateTooltip > 0 then return end
	
	-- we don't have a achievement in cache, abort
	
	frame.updateTooltip = 0.2
	frame.lastIdUpdate = frame.lastIdUpdate or 0
	--]]
	if not frame.aID then return end
	
	if (frame.lastIdUpdate or 0 ) < (GetTime()) then
		frame.aID = nil;
		frame.subaID = nil;
		frame.IsIcon = nil;
	end
	
	-- hide tooltip when refreshtime is over or mainframe lost mousefocus
	if not frame.aID or GetMouseFocus() ~= frame then
		if frame.Tooltip:IsVisible() then
			frame.Tooltip:FadeOut()
			frame.Tooltip.aID = nil;
			frame.Tooltip.IsIcon = nil;
			ResetCursor()
		end
	elseif frame.aID and GetMouseFocus() == frame then
		if ((frame.subaID and frame.subaID) or frame.aID) ~= frame.Tooltip.aID or frame.IsIcon ~= frame.Tooltip.IsIcon then

		-- show tooltip
		ResetCursor()
		ShowInspectCursor()
		frame.Tooltip:SetOwner(UIParent, "ANCHOR_CURSOR")

		local _, achievementName, _, completed, _, _, _, description = GetAchievementInfo((frame.subaID and frame.subaID) or frame.aID);
		frame.Tooltip:AddLine(achievementName)
		frame.Tooltip:AddLine(" ")
		frame.Tooltip:AddLine(description,1,1,1,true)

		local tooltiphint

		if beql.db.profile.AchievementTracker.showtooltiphint then

			if beql.db.profile.AchievementTracker.clickleft then
				tooltiphint = L['|cffeda55fClick|r to open achievement, |cffeda55fShift+Click|r to link achievement to chat.']
			end

			if beql.db.profile.AchievementTracker.clickright and not frame.IsIcon then
				tooltiphint = tooltiphint and tooltiphint .. L['|cffeda55fRight-Click|r to cancel tracking of this achievement'] or L['|cffeda55fRight-Click|r to cancel tracking of this achievement']
			elseif beql.db.profile.AchievementTracker.clickright and frame.IsIcon then
				tooltiphint = tooltiphint and tooltiphint .. L["|cffeda55fRight-Click|r click to toggle watch for this Achievement"] or L["|cffeda55fRight-Click|r click to toggle watch for this Achievement"]
			end

			if tooltiphint then
				frame.Tooltip:AddLine(tooltiphint,0,1,0,true)
			end
		end

		if beql.db.profile.debug then
			frame.Tooltip:AddLine("AchievementID: " .. frame.aID,nil,nil,nil,true)
		end

		frame.Tooltip:Show()
		
		frame.Tooltip.aID = (frame.subaID and frame.subaID) or frame.aID
		frame.Tooltip.IsIcon = frame.IsIcon
		
		end
		
		
	end
		
	
end
--]===]

--- EOF ---
