﻿do return end--[[
************************************************************************

questhistory.lua

File date: 2010-07-11T21:24:31Z
File revision: 236
Project revision: 237
Project version: Locale update


Author: Angelike

************************************************************************
--]]

--[[ frame.xml code
	<!-- History Frame -->
	<Button name="beqlQuestHistoryButton" parent="QuestLogFrame" parentKey="beqlHistory" hidden="true" inherits="UIPanelButtonTemplate" text="Quest Browser">
		<Anchors>
			<Anchor point="TOPRIGHT" relativeTo="QuestLogFrameCancelButton" relativepoint="TOPLEFT" />
		</Anchors>
		<Size>
			<AbsDimension x="125" y="21"/>
		</Size>
		<Scripts>
			<OnClick>
				beql:Browser_Toggle()
			</OnClick>
		</Scripts>
	</Button>

	<Button name="beqlHistoryButtonTemplate" virtual="true">
		<Size>
			<AbsDimension x="299" y="16"/>
		</Size>
		<Layers>
			<Layer level="BACKGROUND">
				<FontString name="$parentTag" inherits="GameFontNormal" justifyH="RIGHT" parentKey="tag">
					<Size>
						<AbsDimension x="0" y="16"/>
					</Size>
					<Anchors>
						<Anchor point="RIGHT">
							<Offset>
								<AbsDimension x="-2" y="0"/>
							</Offset>
						</Anchor>
					</Anchors>
				</FontString>
				<FontString name="$parentGroupMates" inherits="GameFontNormalSmall" justifyH="RIGHT" parentKey="groupMates">
					<Size>
						<AbsDimension x="0" y="16"/>
					</Size>
					<Anchors>
						<Anchor point="LEFT">
							<Offset>
								<AbsDimension x="8" y="0"/>
							</Offset>
						</Anchor>
					</Anchors>
				</FontString>
				<Texture name="$parentCheck" file="Interface\Buttons\UI-CheckBox-Check" hidden="true" parentKey="check">
					<Size>
						<AbsDimension x="16" y="16"/>
					</Size>
					<Anchors>
						<Anchor point="LEFT"/>
					</Anchors> 
				</Texture>
			</Layer>
		</Layers>
		<Scripts>
			<OnLoad>
				QuestLogTitleButton_OnLoad(self);
			</OnLoad>
			<OnEvent>
				--QuestLogTitleButton_OnEvent(self, event, ...);
			</OnEvent>
			<OnClick>
				--QuestLogTitleButton_OnClick(self, button, down);
			</OnClick>
			<OnEnter>
				--QuestLogTitleButton_OnEnter(self);
			</OnEnter>
			<OnLeave>
				--QuestLogTitleButton_OnLeave(self);
			</OnLeave>
		</Scripts>
		<NormalTexture file="Interface\Buttons\UI-MinusButton-UP">
			<Size>
				<AbsDimension x="16" y="16"/>
			</Size>
			<Anchors>
				<Anchor point="LEFT">
					<Offset>
						<AbsDimension x="3" y="0"/>
					</Offset>
				</Anchor>
			</Anchors>
		</NormalTexture>
		<HighlightTexture name="$parentHighlight" file="Interface\Buttons\UI-PlusButton-Hilight" alphaMode="ADD">
			<Size>
				<AbsDimension x="16" y="16"/>
			</Size>
			<Anchors>
				<Anchor point="LEFT">
					<Offset>
						<AbsDimension x="3" y="0"/>
					</Offset>
				</Anchor>
			</Anchors>
		</HighlightTexture>
		<ButtonText name="$parentNormalText" nonspacewrap="true" parentKey="normalText">
			<Size>
				<AbsDimension x="0" y="10"/>
			</Size>
			<Anchors>
				<Anchor point="LEFT">
					<Offset>
						<AbsDimension x="20" y="0"/>
					</Offset>
				</Anchor>
			</Anchors> 
		</ButtonText>
		<NormalFont style="GameFontNormalLeft"/>
		<HighlightFont style="GameFontHighlightLeft"/>
		<DisabledFont style="GameFontDisableLeft"/>
		<Scripts>
			<OnLoad>
				beql:LoadHistoryButton(self)
			</OnLoad>
		</Scripts>
		
	</Button>

	<!--
	<Frame name="beqlHistoryFrame" toplevel="true" parent="UIParent" movable="true" enableMouse="true" hidden="true">
		<Size>
			<AbsDimension x="600" y="500"/>
		</Size>
		<Anchors>
			<Anchor point="CENTER"></Anchor>
		</Anchors>
		<Backdrop bgFile="Interface\DialogFrame\UI-DialogBox-Background" edgeFile="Interface\DialogFrame\UI-DialogBox-Border" tile="true">
			<BackgroundInsets>
				<AbsInset left="11" right="12" top="12" bottom="11"/>
			</BackgroundInsets>
			<TileSize>
				<AbsValue val="32"/>
			</TileSize>
			<EdgeSize>
				<AbsValue val="32"/>
			</EdgeSize>
		</Backdrop>
		<Layers>
			<Layer level="ARTWORK">
				<Texture file="Interface\DialogFrame\UI-DialogBox-Header">
					<Size><AbsDimension x="256" y="64"/></Size>
					<Anchors>
						<Anchor point="TOP">
							<Offset><AbsDimension x="0" y="12"/></Offset>
						</Anchor>
					</Anchors>
				</Texture>
				<Texture file="Interface\DialogFrame\UI-DialogBox-Divider">
					<Size><AbsDimension x="760" y="20"/></Size>
					<Anchors>
						<Anchor point="TOPLEFT">
							<Offset><AbsDimension x="12" y="-55"/></Offset>
						</Anchor>
					</Anchors>
				</Texture>
				<Texture file="Interface\DialogFrame\UI-DialogBox-Divider">
					<Size><AbsDimension x="760" y="20"/></Size>
					<Anchors>
						<Anchor point="TOPLEFT">
							<Offset><AbsDimension x="12" y="-400"/></Offset>
						</Anchor>
					</Anchors>
				</Texture>
			</Layer>
			<Layer level="OVERLAY">
				<FontString inherits="GameFontNormal" name="$parentTitleText" text="Quest History">
					<Anchors>
						<Anchor point="TOP" relativeTo="$parent"></Anchor>
					</Anchors>
				</FontString>
			</Layer>
		</Layers>
		<Frames>
			<Button name="$parentButtonClose" inherits="UIPanelCloseButton">
				<Anchors>
						<Anchor point="TOPRIGHT">
							<Offset>
								<AbsDimension x="-3" y="-3"/>
							</Offset>
						</Anchor>
				</Anchors>
				<Scripts>
					<OnClick>
						beql:Browser_Toggle();
					</OnClick>
				</Scripts>
			</Button>
			
			<Button name="beqlHistoryModeHistory"  text="Quest History">
				<ButtonText name="$parentText"/>
				<NormalFont style="GameFontNormalSmall"/>
				<HighlightFont style="GameFontHighlightSmall"/>
				<DisabledFont style="GameFontDisableSmall"/>
				<Size>
					<AbsDimension x="160" y="24"/>
				</Size>		
				<Anchors>
					<Anchor point="TOPLEFT">
						<Offset>
							<AbsDimension x="10" y="-25"/>
						</Offset>
					</Anchor>
				</Anchors>			
				<Scripts>
					<OnLoad>
						self:Disable()
					</OnLoad>
					<OnClick>
							beqlHistoryFrame.mode = "Quest"
							beql:EnableHistoryBrowser()
							beql:EnableCharBrowser()
							beql:EnablePartyBrowser()
							beql:ClearBrowserQuestList()
					</OnClick>
				</Scripts>
			</Button>
			
			<Button name="beqlHistoryModeCharBrowser"  text="Char Questbrowser">
				<ButtonText name="$parentText"/>
				<NormalFont style="GameFontNormalSmall"/>
				<HighlightFont style="GameFontHighlightSmall"/>
				<DisabledFont style="GameFontDisableSmall"/>
				<Size>
					<AbsDimension x="160" y="24"/>
				</Size>		
				<Anchors>
					<Anchor point="LEFT" relativeTo="beqlHistoryModeHistory" relativePoint="RIGHT">
						<Offset>
							<AbsDimension x="10" y="0"/>
						</Offset>
					</Anchor>
				</Anchors>			
				<Scripts>
					<OnClick>
							beqlHistoryFrame.mode = "Char"
							beql:EnableHistoryBrowser()
							beql:EnableCharBrowser()
							beql:EnablePartyBrowser()
							beql:ClearBrowserQuestList()
					</OnClick>
				</Scripts>
			</Button>
			
			<Button name="beqlHistoryModePartyBrowser"  text="Party Questbrowser">
				<ButtonText name="$parentText"/>
				<NormalFont style="GameFontNormalSmall"/>
				<HighlightFont style="GameFontHighlightSmall"/>
				<DisabledFont style="GameFontDisableSmall"/>
				<Size>
					<AbsDimension x="160" y="24"/>
				</Size>		
				<Anchors>
					<Anchor point="LEFT" relativeTo="beqlHistoryModeCharBrowser" relativePoint="RIGHT">
						<Offset>
							<AbsDimension x="10" y="0"/>
						</Offset>
					</Anchor>
				</Anchors>			
				<Scripts>
					<OnClick>
							beqlHistoryFrame.mode = "Party"
							beql:EnableHistoryBrowser()
							beql:EnableCharBrowser()
							beql:EnablePartyBrowser()
							beql:ClearBrowserQuestList()
					</OnClick>
				</Scripts>
			</Button>
			
			<ScrollFrame name="$parentCharlistScrollFrame" inherits="HybridScrollFrameTemplate">
				<Size>
					<AbsDimension x="186" y="330"/>
				</Size>
				<Anchors>
					<Anchor point="TOPLEFT">
						<Offset>
							<AbsDimension x="19" y="-70"/>
						</Offset>
					</Anchor>
				</Anchors>
				<Frames>
					<Slider name="$parentScrollBar" inherits="HybridScrollBarTemplate" parentKey="scrollBar">
						<Anchors>
							<Anchor point="TOPLEFT" relativePoint="TOPRIGHT">
								<Offset x="0" y="-13"/>
							</Anchor>
							<Anchor point="BOTTOMLEFT" relativePoint="BOTTOMRIGHT">
								<Offset x="0" y="14"/>
							</Anchor>
						</Anchors>
						<Scripts>
							<OnLoad>
								local name = self:GetName();
								_G[name.."BG"]:Hide();
								_G[name.."Top"]:Hide();
								_G[name.."Bottom"]:Hide();
								_G[name.."Middle"]:Hide();
								self.doNotHide = true;
							</OnLoad>
						</Scripts>
					</Slider>
					<Frame name="$parentCharlistHighlightFrame" hidden="true" parentKey="Highlight">
						<Anchors>
							<Anchor point="TOPLEFT"/>
							<Anchor point="BOTTOMRIGHT"/>
						</Anchors>
						<Layers>
							<Layer level="ARTWORK">
								<Texture name="QuestLogSkillHighlight" file="Interface\QuestFrame\UI-QuestLogTitleHighlight" alphaMode="ADD"/>
							</Layer>
						</Layers>
						<Scripts>
							<OnLoad>
								self:SetParent(nil);
							</OnLoad>
						</Scripts>
					</Frame>
				</Frames>
				<Scripts>
					<OnLoad>
						beql:Browser_CharlistInit(self)
					</OnLoad>
				</Scripts>
			</ScrollFrame>
			
			<ScrollFrame name="$parentQuestScrollFrame" inherits="HybridScrollFrameTemplate">
				<Size>
					<AbsDimension x="338" y="330"/>
				</Size>
				<Anchors>
					<Anchor  point="LEFT" relativeTo="$parentCharlistScrollFrame" relativePoint="RIGHT">
						<Offset>
							<AbsDimension x="24" y="0"/>
						</Offset>
					</Anchor>
				</Anchors>
				<Frames>
					<Slider name="$parentScrollBar" inherits="HybridScrollBarTemplate" parentKey="scrollBar">
						<Anchors>
							<Anchor point="TOPLEFT" relativePoint="TOPRIGHT">
								<Offset x="0" y="-13"/>
							</Anchor>
							<Anchor point="BOTTOMLEFT" relativePoint="BOTTOMRIGHT">
								<Offset x="0" y="14"/>
							</Anchor>
						</Anchors>
						<Scripts>
							<OnLoad>
								local name = self:GetName();
								_G[name.."BG"]:Hide();
								_G[name.."Top"]:Hide();
								_G[name.."Bottom"]:Hide();
								_G[name.."Middle"]:Hide();
								self.doNotHide = true;
							</OnLoad>
						</Scripts>
					</Slider>
				</Frames>
				<Scripts>
					<OnLoad>
						beql:Browser_QuestlistInit(self)
					</OnLoad>
				</Scripts>
			</ScrollFrame>
			
			<Frame name="beqlHistoryDetailFrame" hidden="false">
				<Size>
					<AbsDimension x="575" y="170"/>
				</Size>
				<Anchors>
					<Anchor point="BOTTOM">
						<Offset>
							<AbsDimension x="0" y="65"/>
						</Offset>
					</Anchor>
				</Anchors>		
				<Layers>
					<Layer level="OVERLAY">	
			
					<FontString name="beqlHistoryDetailLine1" inherits="GameFontNormal" text="1">
						<Anchors>
							<Anchor point="BOTTOMLEFT" relativeTo="beqlHistoryDetailFrame">
								<Offset>
									<AbsDimension x="0" y="15"/>
								</Offset>				
							</Anchor>
						</Anchors>
					</FontString>
					
					<FontString name="beqlHistoryDetailLine2" inherits="GameFontNormal" text="2">
						<Anchors>
							<Anchor point="BOTTOMLEFT" relativeTo="beqlHistoryDetailLine1">
								<Offset>
									<AbsDimension x="0" y="-15"/>
								</Offset>				
							</Anchor>
						</Anchors>
					</FontString>			
					
					<FontString name="beqlHistoryDetailLine3" inherits="GameFontNormal" text="3">
						<Anchors>
							<Anchor point="BOTTOMLEFT" relativeTo="beqlHistoryDetailLine2">
								<Offset>
									<AbsDimension x="0" y="-15"/>
								</Offset>				
							</Anchor>
						</Anchors>
					</FontString>
					
					<FontString name="beqlHistoryDetailLine4" inherits="GameFontNormal" text="4">
						<Anchors>
							<Anchor point="BOTTOMLEFT" relativeTo="beqlHistoryDetailLine3">
								<Offset>
									<AbsDimension x="0" y="-15"/>
								</Offset>				
							</Anchor>
						</Anchors>
					</FontString>	
					
					<FontString name="beqlHistoryDetailLine5" inherits="GameFontNormal" text="5">
						<Anchors>
							<Anchor point="BOTTOMLEFT" relativeTo="beqlHistoryDetailLine4">
								<Offset>
									<AbsDimension x="0" y="-15"/>
								</Offset>				
							</Anchor>
						</Anchors>
					</FontString>								
					
					<FontString name="beqlHistoryDetailLine6" inherits="GameFontNormal" text="6">
						<Anchors>
							<Anchor point="BOTTOMRIGHT" relativeTo="beqlHistoryDetailFrame">
								<Offset>
									<AbsDimension x="0" y="15"/>
								</Offset>				
							</Anchor>
						</Anchors>
					</FontString>					
					
					<FontString name="beqlHistoryDetailLine7" inherits="GameFontNormal" text="7">
						<Anchors>
							<Anchor point="BOTTOMLEFT" relativeTo="beqlHistoryDetailLine6">
								<Offset>
									<AbsDimension x="0" y="-15"/>
								</Offset>				
							</Anchor>
						</Anchors>
					</FontString>				

					<FontString name="beqlHistoryDetailLine8" inherits="GameFontNormal" text="8">
						<Anchors>
							<Anchor point="BOTTOMLEFT" relativeTo="beqlHistoryDetailLine7">
								<Offset>
									<AbsDimension x="0" y="-15"/>
								</Offset>				
							</Anchor>
						</Anchors>
					</FontString>	
					
					<FontString name="beqlHistoryDetailLine9" inherits="GameFontNormal" text="9">
						<Anchors>
							<Anchor point="BOTTOMLEFT" relativeTo="beqlHistoryDetailLine8">
								<Offset>
									<AbsDimension x="0" y="-15"/>
								</Offset>				
							</Anchor>
						</Anchors>
					</FontString>				
					
					<FontString name="beqlHistoryDetailLine10" inherits="GameFontNormal" text="10">
						<Anchors>
							<Anchor point="BOTTOMLEFT" relativeTo="beqlHistoryDetailLine9">
								<Offset>
									<AbsDimension x="0" y="-15"/>
								</Offset>				
							</Anchor>
						</Anchors>
					</FontString>				
					
					</Layer>		
				</Layers>
			</Frame>
		</Frames>		
		<Scripts>
			<OnUpdate>
				beql:Browser_OnUpdate(self, elapsed)
			</OnUpdate>
			<OnShow>
				beql:QuestBrowserShow(self)
			</OnShow>
		</Scripts>
	</Frame>
	-->

--]]

local beql = LibStub("AceAddon-3.0"):GetAddon("beql")
local L = LibStub("AceLocale-3.0"):GetLocale("beql")
QuestInfo = LibStub("LibQuestInfo", true)
local LBZ = LibStub("LibBabble-Zone-3.0", true)
local zonekeys, zonenames
if LBZ then
	zonekeys = LBZ:GetReverseLookupTable()
	zonenames = LBZ:GetUnstrictLookupTable()
end

local NonZoneKeys, NonZoneNames = {}
local QuestDB, Charlist, Questlist = {}, {}, {}

beql.TimeSinceLastUpdate = 0
beql.AniType = ""
local Gamelocale = GetLocale()

function beql:Browser_Init()
	if not QuestInfo then return end;
	if QuestInfo then
		QuestInfo.RegisterCallback(beql, "QuestDataUpdate", beql.QuestInfo_QuestUpdate)
		QuestInfo.RegisterCallback(beql, "QuestZoneUpdate", beql.QuestInfo_ZoneUpdate)
		QuestInfo.RegisterCallback(beql, "QuestLoaded", beql.QuestInfo_ZoneUpdate)
	end
end

function beql:Browser_Toggle()
	if beql.AniType ~= "" then return end
	if beqlHistoryFrame:IsShown() then
		beqlHistoryFrame:SetAlpha(1)
		beqlHistoryFrame:SetScale(1)
		beql.AniType = "FadeIn"
	else
		beqlHistoryFrame:Show()	
		beqlHistoryFrame:SetScale(0.01)
		beqlHistoryFrame:SetAlpha(0)
		beql.AniType = "FadeOut"
		beql:Browser_HistoryUpdate()
	end
end

function beql:Browser_OnUpdate(frame, elapsed)

	if beql.AniType ~= "FadeIn" and beql.AniType ~= "FadeOut" then
		return
	end

	local alpha = 0
	local scale = 0

	beql.TimeSinceLastUpdate = beql.TimeSinceLastUpdate + elapsed

	if (beql.TimeSinceLastUpdate > 0.01) then
	
		if beql.AniType ~= "FadeIn" then
			alpha = frame:GetAlpha()
			alpha = alpha + 0.05
			scale = frame:GetScale()
			scale = scale + 0.05
			frame:SetAlpha(alpha)
			if scale > 1 then scale = 1 end
			frame:SetScale(scale)
			if alpha == 1 or alpha > 1 then
				frame:SetAlpha(1)
				frame:SetScale(1)
				frame:Show()
				beql.AniType = ""
			end
		else
			alpha = frame:GetAlpha()
			alpha = alpha - 0.05
			scale = frame:GetScale()
			scale = scale - 0.05			
			frame:SetAlpha(alpha)
			if scale < 0.01 then scale = 0.01 end
			frame:SetScale(scale)			
			if alpha == 0 or alpha < 0 then
				frame:SetAlpha(0)
				frame:SetScale(0.01)			
				frame:Hide()
				beql.AniType = ""
			end
		end

		beql.TimeSinceLastUpdate = 0
	end

end

function beql:Browser_HistoryUpdate()

	do return end
	local questIndex
--	local questHistory = beql.db.profile.QuestHistory[charlist.value]
	local questHistory = {1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0}
	local i,k,v
	local ListFrame
	local qTag
	local scrolloffset
	local isCollapsed
	local i = 1
	local controli = 0

	FauxScrollFrame_Update(beqlHistoryListScrollFrame,beql:GetHistoryCount(),25,14)
	scrollofset = FauxScrollFrame_GetOffset(beqlHistoryListScrollFrame)
	
	for k, v in pairs (questHistory) do
		-- Print the Zones
		controli = controli + 1
		if controli > scrollofset then
			if i > 25 then 
				break 
			end
			ListFrame = getglobal("beqlQuestHistoryListFrame"..i)
			ListFrame:SetText(k)
--			ListFrame:SetTextColor(NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b)
			ListFrame:Show()
			i = i +1
--			if  questHistory[k].Collapsed  then
				ListFrame:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up");
--			else
--				ListFrame:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-Up"); 
--			end					
		end

		-- Print the Quests in the Zone
		if 1 == 2 and not questHistory[k].Collapsed then
			for j, l in pairs (questHistory[k]) do
				if j ~= "Collapsed" then
					if (filters.value2 == "completed" and questHistory[k][j].EndDate and questHistory[k][j].EndDate ~= 0) 
					or (filters.value2 == "notcompleted" and not questHistory[k][j].EndDate or questHistory[k][j].EndDate == 0)
					or (filters.value2 == "daily" and questHistory[k][j].Tag == "y")
					or (filters.value2 == "all") then
					controli = controli + 1
					if controli > scrollofset then
						
						if i > 25 then 
							break 
						end
						ListFrame = getglobal("beqlQuestHistoryListFrame"..i)
						ListFrame:SetNormalTexture("")
						ListFrame:SetText("")
						if questHistory[k][j].Tag then
							qTag = string.upper(questHistory[k][j].Tag)
						else
							qTag = ""
						end
						ListFrame:SetText("  ["..questHistory[k][j].Level..qTag.."] "..j)
						ListFrame:SetTextColor(GetDifficultyColor(questHistory[k][j].Level).r,GetDifficultyColor(questHistory[k][j].Level).g,GetDifficultyColor(questHistory[k][j].Level).b)
						ListFrame:Show()	
						i = i +1		
						
					end
					end
				end
			end
		end
		
		
	end
	--Clean Up unused ID's
	for j = i, 25 ,1 do
		ListFrame = getglobal("beqlQuestHistoryListFrame"..j)
		ListFrame:Hide()
	end
end

function beql:GetHistoryCount()
	do return 30 end

	local questHistory = beql.db.profile.QuestHistory[charlist.value]
	local k,v,j,l
	local n = 0
	for k, v in pairs (questHistory) do
		n = n +1
		if not questHistory[k].Collapsed then
			for j, l in pairs (questHistory[k]) do
				if j ~= "Collapsed" then
					n = n +1
				end
			end
		end
	end
	return n
end

function beql:EnableHistoryBrowser()
	if beqlHistoryFrame.mode == "Quest" then
		beqlHistoryModeHistory:Disable()
	else
		beqlHistoryModeHistory:Enable()
	end
	beql:UpdateBrwoserCharList()
end

function beql:EnableCharBrowser()
	if beqlHistoryFrame.mode == "Char" then
		beqlHistoryModeCharBrowser:Disable()
	else
		beqlHistoryModeCharBrowser:Enable()
	end
	beql:UpdateBrwoserCharList()
end

function beql:EnablePartyBrowser()
	if beqlHistoryFrame.mode == "Party" then
		beqlHistoryModePartyBrowser:Disable()
	else
		beqlHistoryModePartyBrowser:Enable()
	end
	beql:UpdateBrwoserCharList()
end

function beql:CharQuestLogUpdate()
		local realm
		local buttonheigth = beqlHistoryFrameCharlistScrollFrame.buttons[1]:GetHeight()
		
		if Charlist.Type ~= 'Char' or Charlist.time < time() - 300 then
			if Charlist.Type ~= 'Char' then
				Charlist.CurrentKey = ''
				HybridScrollFrame_SetOffset(beqlHistoryFrameCharlistScrollFrame , 0)
			end
			if (Charlist.DB) then
				-- clean up old data
				for k in pairs(Charlist.DB) do
					Charlist.DB[k] = nil
				end
			else
				Charlist.DB = {}
			end
			
			Charlist.Type = 'Char'
			Charlist.time = time()
			
			-- make a new list
			for k in pairs(beqlDBnew.char) do
				tinsert(Charlist.DB, k)
			end
			
			table.sort(Charlist.DB)
		end
		
		beqlHistoryFrameCharlistScrollFrame.Highlight:Hide()
		
		local i = -HybridScrollFrame_GetOffset(beqlHistoryFrameCharlistScrollFrame) + 1
		for k,v in pairs(Charlist.DB) do
			local keyplayer, _, keyrealm = strsplit(' ',v , 3)
			-- add new realmheader
			if keyrealm ~= realm then
				realm = keyrealm
				if i > 0 and i <= #beqlHistoryFrameCharlistScrollFrame.buttons then
					local button = beqlHistoryFrameCharlistScrollFrame.buttons[i]
					button:Reset(button)
					button:SetButton(button)
					button:SetText(realm)
					button:Disable()
				end
				i = i + 1
			end
			if i > 0 and i <= #beqlHistoryFrameCharlistScrollFrame.buttons then
				local button = beqlHistoryFrameCharlistScrollFrame.buttons[i]
				button:Reset(beqlHistoryFrameCharlistScrollFrame.buttons[i])
				button:SetText(keyplayer)
				button.playerkey = v
				
				-- set HighlightFrame
				if v == Charlist.CurrentKey then
					beqlHistoryFrameCharlistScrollFrame.Highlight:SetParent(button)
					beqlHistoryFrameCharlistScrollFrame.Highlight:ClearAllPoints()
					beqlHistoryFrameCharlistScrollFrame.Highlight:SetPoint("TOPLEFT",button ,"TOPLEFT",0,0)
					beqlHistoryFrameCharlistScrollFrame.Highlight:SetPoint("BOTTOMRIGHT",button ,"BOTTOMRIGHT",0,0)
					beqlHistoryFrameCharlistScrollFrame.Highlight:Show()
				end
			end
			i = i + 1
		end
		for j = i, #beqlHistoryFrameCharlistScrollFrame.buttons do
			beqlHistoryFrameCharlistScrollFrame.buttons[j]:Reset(beqlHistoryFrameCharlistScrollFrame.buttons[j])
			beqlHistoryFrameCharlistScrollFrame.buttons[j]:Disable()
		end
		HybridScrollFrame_Update(beqlHistoryFrameCharlistScrollFrame, (i + HybridScrollFrame_GetOffset(beqlHistoryFrameCharlistScrollFrame)-.5)  * buttonheigth, #beqlHistoryFrameCharlistScrollFrame.buttons * buttonheigth);

end

function beql:PartyQuestLogUpdate()
		local realm
		local buttonheigth = beqlHistoryFrameCharlistScrollFrame.buttons[1]:GetHeight()
		
		if Charlist.Type ~= 'Party' or Charlist.time < time() - 300 then
			if Charlist.Type ~= 'Party' then
				Charlist.CurrentKey = ''
				HybridScrollFrame_SetOffset(beqlHistoryFrameCharlistScrollFrame , 0)
			end
			if (Charlist.DB) then
				-- clean up old data
				for k in pairs(Charlist.DB) do
					Charlist.DB[k] = nil
				end
			else
				Charlist.DB = {}
			end
			
			Charlist.Type = 'Party'
			Charlist.time = time()
			
			-- make a new list
			for k in pairs(beqlDBnew.char) do
				--tinsert(Charlist.DB, k)
			end
			
			table.sort(Charlist.DB)
		end
		
		beqlHistoryFrameCharlistScrollFrame.Highlight:Hide()
		
		local i = -HybridScrollFrame_GetOffset(beqlHistoryFrameCharlistScrollFrame) + 1
		for k,v in pairs(Charlist.DB) do
			local keyplayer, _, keyrealm = strsplit(' ',v , 3)
			-- add new realmheader
			if keyrealm ~= realm then
				realm = keyrealm
				if i > 0 and i <= #beqlHistoryFrameCharlistScrollFrame.buttons then
					local button = beqlHistoryFrameCharlistScrollFrame.buttons[i]
					button:Reset(button)
					button:SetButton(button)
					button:SetText(realm)
					button:Disable()
				end
				i = i + 1
			end
			if i > 0 and i <= #beqlHistoryFrameCharlistScrollFrame.buttons then
				local button = beqlHistoryFrameCharlistScrollFrame.buttons[i]
				button:Reset(beqlHistoryFrameCharlistScrollFrame.buttons[i])
				button:SetText(keyplayer)
				button.playerkey = v
				
				-- set HighlightFrame
				if v == Charlist.CurrentKey then
					beqlHistoryFrameCharlistScrollFrame.Highlight:SetParent(button)
					beqlHistoryFrameCharlistScrollFrame.Highlight:ClearAllPoints()
					beqlHistoryFrameCharlistScrollFrame.Highlight:SetPoint("TOPLEFT",button ,"TOPLEFT",0,0)
					beqlHistoryFrameCharlistScrollFrame.Highlight:SetPoint("BOTTOMRIGHT",button ,"BOTTOMRIGHT",0,0)
					beqlHistoryFrameCharlistScrollFrame.Highlight:Show()
				end
			end
			i = i + 1
		end
		for j = i, #beqlHistoryFrameCharlistScrollFrame.buttons do
			beqlHistoryFrameCharlistScrollFrame.buttons[j]:Reset(beqlHistoryFrameCharlistScrollFrame.buttons[j])
			beqlHistoryFrameCharlistScrollFrame.buttons[j]:Disable()
		end
		HybridScrollFrame_Update(beqlHistoryFrameCharlistScrollFrame, (i + HybridScrollFrame_GetOffset(beqlHistoryFrameCharlistScrollFrame)-.5)  * buttonheigth, #beqlHistoryFrameCharlistScrollFrame.buttons * buttonheigth);

end

function beql:HistoryLogUpdate()
		local realm
		local buttonheigth = beqlHistoryFrameCharlistScrollFrame.buttons[1]:GetHeight()
		
		if Charlist.Type ~= 'History' or Charlist.time < time() - 300 then
			if Charlist.Type ~= 'History' then
				Charlist.CurrentKey = '';
				HybridScrollFrame_SetOffset(beqlHistoryFrameCharlistScrollFrame , 0)
			end
			if (Charlist.DB) then
				-- clean up old data
				for k in pairs(Charlist.DB) do
					Charlist.DB[k] = nil
				end
			else
				Charlist.DB = {}
			end
			
			Charlist.Type = 'History'
			Charlist.time = time()
			
			-- make a new list
			for k in pairs(beql.db.global.QuestHistoryDB) do
				tinsert(Charlist.DB, k)
			end
			
			table.sort(Charlist.DB)
		end
		
		beqlHistoryFrameCharlistScrollFrame.Highlight:Hide()
		
		local i = -HybridScrollFrame_GetOffset(beqlHistoryFrameCharlistScrollFrame) + 1
		for k,v in pairs(Charlist.DB) do
			local keyrealm, keyfraction, keyplayer = strsplit('_',v , 3)
			-- add new realmheader
			if keyrealm ~= realm then
				realm = keyrealm
				if i > 0 and i <= #beqlHistoryFrameCharlistScrollFrame.buttons then
					local button = beqlHistoryFrameCharlistScrollFrame.buttons[i]
					button:Reset(button)
					button:SetButton(button)
					button:SetText(realm)
					button:Disable()
				end
				i = i + 1
			end
			if i > 0 and i <= #beqlHistoryFrameCharlistScrollFrame.buttons then
				local button = beqlHistoryFrameCharlistScrollFrame.buttons[i]
				button:Reset(beqlHistoryFrameCharlistScrollFrame.buttons[i])
				button:SetText(keyplayer)
				button.playerkey = v
				
				-- set HighlightFrame
				if v == Charlist.CurrentKey then
					beqlHistoryFrameCharlistScrollFrame.Highlight:SetParent(button)
					beqlHistoryFrameCharlistScrollFrame.Highlight:ClearAllPoints()
					beqlHistoryFrameCharlistScrollFrame.Highlight:SetPoint("TOPLEFT",button ,"TOPLEFT",0,0)
					beqlHistoryFrameCharlistScrollFrame.Highlight:SetPoint("BOTTOMRIGHT",button ,"BOTTOMRIGHT",0,0)
					beqlHistoryFrameCharlistScrollFrame.Highlight:Show()
				end
			end
			i = i + 1
		end
		for j = i, #beqlHistoryFrameCharlistScrollFrame.buttons do
			beqlHistoryFrameCharlistScrollFrame.buttons[j]:Reset(beqlHistoryFrameCharlistScrollFrame.buttons[j])
			beqlHistoryFrameCharlistScrollFrame.buttons[j]:Disable()
		end
		HybridScrollFrame_Update(beqlHistoryFrameCharlistScrollFrame, (i + HybridScrollFrame_GetOffset(beqlHistoryFrameCharlistScrollFrame)-.5)  * buttonheigth, #beqlHistoryFrameCharlistScrollFrame.buttons * buttonheigth);

end

function beql:UpdateBrwoserCharList()
	if not beqlDBnew then
		return
	end
	

	if beqlHistoryFrame.mode == 'Char' then
		beql:CharQuestLogUpdate()
	elseif beqlHistoryFrame.mode == 'Party' then
		beql:PartyQuestLogUpdate()
	else
		beqlHistoryFrame.mode = 'History'
		beql:HistoryLogUpdate()
	end
end

function beql:QuestBrowserShow()
	beql:ClearBrowserQuestList()
	beql:UpdateBrwoserCharList()
end

function beql:UpdateCharQuests(key)
	local buttonheigth = beqlHistoryFrameQuestScrollFrame.buttons[1]:GetHeight()
	if Questlist.Type ~= 'Char' or Questlist.time < time() - 300  or Questlist.PlayerKey ~= key then
		if not Questlist.zonesheader then
			Questlist.zonesheader = {}
		end
		if Questlist.zones then
			for k in pairs(Questlist.zones) do
				Questlist.zones[k] = nil
			end
		else
			Questlist.zones = {}
		end
		
		if Questlist.DB then
			for k in pairs(Questlist.DB) do
				if type(Questlist.DB[k]) == 'table' then
					for l in pairs(Questlist.DB[k]) do
						Questlist.DB[k][l] = nil
					end
				end
				Questlist.DB[k] = nil
			end
		else
			Questlist.DB = {}
		end
		
		Questlist.Type = 'Char'
		Questlist.time = time()
		Questlist.PlayerKey = key
		
		for qid in pairs(beqlDBnew.char[key].questlogids) do
			local zonekey, zonename 
			zonekey = QuestInfo:GetZonebyQid(qid)
			if not zonekey then
				zonekey = "UNKNOWN"
			end
			zonename = QuestInfo:GetQuestCategoryName(zonekey)
			
			-- add header control
			if not Questlist.zonesheader[zonekey] then
				Questlist.zonesheader[zonekey] = 1
			end
			
			-- create questtable for zones
			if not Questlist.DB[zonekey] then
				Questlist.DB[zonekey] = {}
			end
			
			table.insert(Questlist.DB[zonekey],qid)
			
			-- create zone keytable
			local found
			for k, v in pairs(Questlist.zones) do
				if v == zonename then
					found = true
					break
				end
			end
			
			if not found then
				table.insert(Questlist.zones, zonename)
			end
		end
		
		for k in pairs(Questlist.DB) do
			table.sort(Questlist.DB[k], function(a,b)
				local qa = QuestInfo:GetQuestName(a)
				local qb = QuestInfo:GetQuestName(b)

				if qa == qb then
					return a < b
				else
					return qa < qb
				end
			end)
		end
		
		table.sort(Questlist.zones)
	end
	--print("CharBrowser " .. key)
	
	local i = -HybridScrollFrame_GetOffset(beqlHistoryFrameQuestScrollFrame) + 1
	
	for m = 1, 1 do
	
	for k, zonename in pairs(Questlist.zones) do
		local zonekey = QuestInfo:GetQuestCategoryKey(zonename)
		if i > 0 and i <= #beqlHistoryFrameQuestScrollFrame.buttons then
			local button = beqlHistoryFrameQuestScrollFrame.buttons[i]
			button:Reset()
			button.HeaderKey = zonekey;
			button:SetButton(button)
			button:SetText(zonename)
			if not Questlist.DB[zonekey] then
				print(zonekey .. " _ " .. zonename)
			end
			button.tag:SetText("#".. #Questlist.DB[zonekey])
			if Questlist.zonesheader[zonekey] == 1 then
				button:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-UP")
			end
		end
		i = i + 1
		if Questlist.zonesheader[zonekey] ~= 1 then
			for k, qid in pairs(Questlist.DB[zonekey]) do
				if i > 0 and i <= #beqlHistoryFrameQuestScrollFrame.buttons then
					local button = beqlHistoryFrameQuestScrollFrame.buttons[i]
					button:Reset()
					button:SetText(QuestInfo:GetQuestName(qid))
					button.tag:SetText("qID: " .. qid)
				end
				i = i + 1
			end
		end
	end
	
	end
	
	for j = i, #beqlHistoryFrameQuestScrollFrame.buttons do
		if j > 0 then
			beqlHistoryFrameQuestScrollFrame.buttons[j]:Reset(beqlHistoryFrameQuestScrollFrame.buttons[j])
			beqlHistoryFrameQuestScrollFrame.buttons[j]:Disable()
		end
	end
	HybridScrollFrame_Update(beqlHistoryFrameQuestScrollFrame, (i + HybridScrollFrame_GetOffset(beqlHistoryFrameQuestScrollFrame)-.5)  * buttonheigth, #beqlHistoryFrameQuestScrollFrame.buttons * buttonheigth);

end

function beql:UpdatePatryQuests(key)
	print("PatryBrowser " .. key)
end

function beql:UpdateQuestHistory(key)
	local buttonheigth = beqlHistoryFrameQuestScrollFrame.buttons[1]:GetHeight()
	if Questlist.Type ~= 'History' or Questlist.time < time() - 300  or Questlist.PlayerKey ~= key then
		if not Questlist.zonesheader then
			Questlist.zonesheader = {}
		end
		if Questlist.zones then
			for k in pairs(Questlist.zones) do
				Questlist.zones[k] = nil
			end
		else
			Questlist.zones = {}
		end
		
		if Questlist.DB then
			for k in pairs(Questlist.DB) do
				if type(Questlist.DB[k]) == 'table' then
					for l in pairs(Questlist.DB[k]) do
						Questlist.DB[k][l] = nil
					end
				end
				Questlist.DB[k] = nil
			end
		else
			Questlist.DB = {}
		end
		
		Questlist.Type = 'History'
		Questlist.time = time()
		Questlist.PlayerKey = key
		
		for qid in pairs(beql.db.global.QuestHistoryDB[key]) do
			--print(qid)
			local zonename, zonekey
			if beql.db.global.QuestDB[qid] then
				zonekey = select(2 , beql:GetZoneforQuestID(qid))
			else
				zonekey = "UNKNOWN"
			end
			zonename = beql:GetQuestCategoryName(zonekey)
			
			-- add header control
			if not Questlist.zonesheader[zonekey] then
				Questlist.zonesheader[zonekey] = 1
			end
			
			-- create questtable for zones
			if not Questlist.DB[zonekey] then
				Questlist.DB[zonekey] = {}
			end
			
			table.insert(Questlist.DB[zonekey],qid)
			
			-- create zone keytable
			local found
			for k, v in pairs(Questlist.zones) do
				if v == zonename then
					found = true
					break
				end
			end
			
			if not found then
				table.insert(Questlist.zones, zonename)
			end
		end
		
		for k in pairs(Questlist.DB) do
			table.sort(Questlist.DB[k], function(a,b)
				local qa = beql:GetQuestName(a)
				local qb = beql:GetQuestName(b)

				if qa == qb then
					return a < b
				else
					return qa < qb
				end
			end)
		end
		
		table.sort(Questlist.zones)
	end
	--print("CharBrowser " .. key)
	
	local i = -HybridScrollFrame_GetOffset(beqlHistoryFrameQuestScrollFrame) + 1
	
	for m = 1, 1 do
	
	for k, zonename in pairs(Questlist.zones) do
		local zonekey = beql:GetQuestCategoryKey(zonename)
		if i > 0 and i <= #beqlHistoryFrameQuestScrollFrame.buttons then
			local button = beqlHistoryFrameQuestScrollFrame.buttons[i]
			button:Reset()
			button.HeaderKey = zonekey;
			button:SetButton(button)
			button:SetText(zonename)
			button.tag:SetText("#".. #Questlist.DB[zonekey])
			if Questlist.zonesheader[zonekey] == 1 then
				button:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-UP")
			end
			QuestLogTitleButton_Resize(button)
		end
		i = i + 1
		if Questlist.zonesheader[zonekey] ~= 1 then
			for k, qid in pairs(Questlist.DB[zonekey]) do
				if i > 0 and i <= #beqlHistoryFrameQuestScrollFrame.buttons then
					local button = beqlHistoryFrameQuestScrollFrame.buttons[i]
					button:Reset()
					local level = QuestDB[qid].level or "??"
--					if type(level) == 'number' then
						--local Color = GetQuestDifficultyColor(type(level) == 'number' and level or 1)
						--button.normalText:SetTextColor(Color.r, Color.g, Color.b)
--					end
					button:SetText("[" .. level .. "] " .. beql:GetQuestName(qid))
					button.tag:SetText("qID: " .. qid)
					QuestLogTitleButton_Resize(button)
				end
				i = i + 1
			end
		end
	end
	
	end
	
	for j = i, #beqlHistoryFrameQuestScrollFrame.buttons do
		if j > 0 then
			beqlHistoryFrameQuestScrollFrame.buttons[j]:Reset(beqlHistoryFrameQuestScrollFrame.buttons[j])
			beqlHistoryFrameQuestScrollFrame.buttons[j]:Disable()
		end
	end
	HybridScrollFrame_Update(beqlHistoryFrameQuestScrollFrame, (i + HybridScrollFrame_GetOffset(beqlHistoryFrameQuestScrollFrame)-.5)  * buttonheigth, #beqlHistoryFrameQuestScrollFrame.buttons * buttonheigth);

end

function beql:Browser_CharlistInit(frame)
	HybridScrollFrame_CreateButtons(frame, "beqlHistoryButtonTemplate");
	local width = frame:GetWidth()
	frame.update = function() beql:UpdateBrwoserCharList() end
	
	for i=1, #frame.buttons do
		local button = frame.buttons[i]
		button:SetWidth(width)
		button:SetScript("OnClick", function(button)
			Charlist.CurrentKey = button.playerkey
			beql:UpdateBrwoserCharList()
			beql:UpdateBrowserQuestList()
		end)
		i = i + 1
	end

	local buttonheigth = frame.buttons[1]:GetHeight()
	HybridScrollFrame_Update(frame, #frame.buttons-1 * buttonheigth, #frame.buttons * buttonheigth);
end

function beql:UpdateBrowserQuestList()
	local key = Charlist.CurrentKey
	if beqlHistoryFrame.mode == 'Char' then
		beql:UpdateCharQuests(key)
	elseif beqlHistoryFrame.mode == 'Party' then
		beql:UpdatePatryQuests(key)
	elseif beqlHistoryFrame.mode == 'History' then
		beql:UpdateQuestHistory(key)
	end

end

function beql:ClearBrowserQuestList()
	for i = 1, #beqlHistoryFrameQuestScrollFrame.buttons do
		beqlHistoryFrameQuestScrollFrame.buttons[i]:Reset()
		beqlHistoryFrameQuestScrollFrame.buttons[i]:Disable()
	end
end

function beql:Browser_QuestlistInit(frame)
	HybridScrollFrame_CreateButtons(frame, "beqlHistoryButtonTemplate");
	local width = frame:GetWidth()
	frame.update = function() beql:UpdateBrowserQuestList() end
	
	for i=1, #frame.buttons do
		local button = frame.buttons[i]
		button:Reset()
		button:SetText(button:GetName())
		button:SetWidth(width)
		button:SetScript("OnClick", function(button)
			if button.HeaderKey then
				if Questlist.zonesheader[button.HeaderKey] == 1 then
					Questlist.zonesheader[button.HeaderKey] = 0
				else
					Questlist.zonesheader[button.HeaderKey] = 1
				end
				beql:UpdateBrowserQuestList()
			end
		end)
	end
	
	local buttonheigth = frame.buttons[1]:GetHeight()
	HybridScrollFrame_Update(frame, #frame.buttons-1 * buttonheigth, #frame.buttons * buttonheigth);

end

function beql:LoadHistoryButton(button)
	button:SetText(button:GetName())
	button.tag:Show()
	button.groupMates:Show()
	button.Reset = function(button)
		button:Enable()
		button:SetText("")
		button.tag:SetText("")
		button.groupMates:SetText("")
		button:SetNormalTexture("")
		button:SetHighlightTexture("")
		button:SetNormalFontObject(GameFontNormalLeft)
		button.HeaderKey = nil
		button.qID = nil
	end
	button.SetButton = function(button)
		button:SetNormalFontObject(GameFontHighlight)
		button:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-UP")
		button:SetHighlightTexture("Interface\\Buttons\\UI-PlusButton-Hilight")
	end
end


function beql:QuestInfo_QuestUpdate(qid, data)
	print("Update " .. qid .. " Data: '" .. data .. "'")
	if not beql.db.global.QuestStrings then
		beql.db.global.QuestStrings = {}
	end
	
	if not beql.db.global.QuestStrings[ceil(qid/100)] then
		beql.db.global.QuestStrings[ceil(qid/100)] = "|" .. data
	else
		beql.db.global.QuestStrings[ceil(qid/100)] = beql.db.global.QuestStrings[ceil(qid/100)] .. data
	end
	
	--print(...)
end

function beql:QuestInfo_ZoneUpdate(qid, zonekey)
	if not beql.db.global.QuestZones then
		beql.db.global.QuestZones = {}
	end
	
	if not beql.db.global.QuestZones[zonekey] then
		beql.db.global.QuestZones[zonekey] = {qid}
	else
		for k in ipairs(beql.db.global.QuestZones[zonekey]) do
			if beql.db.global.QuestZones[zonekey][k] == qid then
				return
			end
		end
		table.insert(beql.db.global.QuestZones[zonekey], qid)
	end
	--print(...)
end


function beql:delTable(t)
	for k in pairs(t) do
		if type(t[k]) == 'table' then
			beql:delTable(t[k])
		end
		t[k]=nil
	end
	return t
end
--]]
-- EOF --
