--[[
************************************************************************

options.lua

File date: 2010-07-13T14:36:51Z
File revision: 237
Project revision: 237
Project version: Locale update


Author: Angelike

************************************************************************
]]--

local beql = LibStub("AceAddon-3.0"):GetAddon("beql")

-- Init constants
local MODNAMESTRING	=	... -- AddonName

--local modularOptions	=	{}
local MainOptionsTable = {}

local L = LibStub("AceLocale-3.0"):GetLocale("beql")

--local AceConfig	=	LibStub("AceConfig-3.0")
local AceConfigReg	=	LibStub("AceConfigRegistry-3.0")
local AceConfigDialog	=	LibStub("AceConfigDialog-3.0")

beql.optionsFrames	=	{}

local beql_sounds = {}


-- Addon functions

-- Input: nothing
-- Output: nothing
function beql:BlizzardSetupOptions()
-- now let's get the Options

--get the optiontable and register it
	beql:MainOptionsTable()
	AceConfigReg:RegisterOptionsTable(MODNAMESTRING, MainOptionsTable , MODNAMESTRING)

-- Mainframe
	beql.optionsFrames.main	=	AceConfigDialog:AddToBlizOptions(MODNAMESTRING, nil, nil, "general")

-- Subframes
	beql.optionsFrames.questlog	=	AceConfigDialog:AddToBlizOptions(MODNAMESTRING, L["Quest Log Options"], MODNAMESTRING, "qlog")
	beql.optionsFrames.questtracker	=	AceConfigDialog:AddToBlizOptions(MODNAMESTRING, L["Quest Tracker Options"], MODNAMESTRING, "qtracker")
	beql.optionsFrames.tooltip	=	AceConfigDialog:AddToBlizOptions(MODNAMESTRING, L["Tooltip"], MODNAMESTRING, "tooltip")
	if beqlfu then -- Fubar Plugin is loaded
		beql.optionsFrames.fubar	=	AceConfigDialog:AddToBlizOptions(MODNAMESTRING, L["FubarPlugin Config"], MODNAMESTRING, "fubar")
	end
	beql.optionsFrames.profiles	=	AceConfigDialog:AddToBlizOptions(MODNAMESTRING, L["Profiles"], MODNAMESTRING, "profiles")
	--beql.optionsFrames.About	=	LibStub:GetLibrary("LibAboutPanel").new(MODNAMESTRING, "beql")

--[[ Create reload Check
	StaticPopupDialogs["CONFIRM_RELOADUI"]	=	{
		text	=	L["Reload UI ?"],
		button1	=	TEXT(ACCEPT),
		button2	=	TEXT(CANCEL),
		OnAccept	=	function(parentframedata)
			beql:Nyelv("PREV",true)
		end,
		OnCancel	=	function(parentframedata,override)
			-- Do nothing
		end,
		timeout	=	20,
		exclusive	=	1,
		notCloseablebyLogout	=	1,
	}--]]
end

-- Prepare the Optionstable

-- many many code ....
function beql:MainOptionsTable ()

	MainOptionsTable	=	{
			type	=	'group',
			args	=	{

-- General Options, shown on the main window

				general	=	{
					type	=	'group',
					order	=	1,
					name	=	L["Main Options"],
					desc	=	L["Main Options"],
					args	=	{
						DisableAddon	=	{
							type	=	'toggle',
							order	=	1,
							width	=	'full',
							name	=	L["Enable Addon"],
							desc	=	L["Enable this Addon"],
							get	=	function(info) return beql:IsEnabled()  end,
							set	=	function(info, newval) beql:ToggleActive() end,
						},
						Spacher1	=	{
							type	=	'header',
							order	=	2,
							name	=	'',
						},
						SimpleQuestLog	=	{
							type	=	'toggle',
							order	=	3,
							name	=	L["Simple Quest Log"],
							desc	=	L["Uses the default Blizzard Quest Log"],--.." - "..L["Requires Interface Reload"],
							get	=	function(info) return beql.db.profile.QuestLog.style == 'simple' end,
							set	=	function(info, newval) beql.db.profile.QuestLog.style = newval == true and 'simple' or 'extended'; beql:QuestLog_ToggleStyle(beql.db.profile.QuestLog.style) end,
							disabled	=	function(info) return not beql:IsEnabled() end,
						},
						DisableTracker	=	{
							type	=	'toggle',
							order	=	4,
							width	=	'full',
							name	=	L["Disable Tracker"],
							desc	=	L["Disable the Tracker"],--.." - "..L["Requires Interface Reload"],
							get	=	function(info) return beql.db.profile.disabledtracker end,
							set	=	function(info, newval) 
								beql.db.profile.disabledtracker = newval
								beql:QuestTracker_ToggleStatus(newval) 
							end,
							disabled	=	function(info) return not beql:IsEnabled() end,
						},
						Language	=	{
							type	=	'toggle',
							order	=	7,
							name	=	L["Enable Language support"],
							desc	=	L["Enables the language support for non-natural Languages."],
							get	=	function(info) return beql.db.profile.EnableLanguages end,
							set	=	function(info, newval)
											beql.db.profile.EnableLanguages	=	newval
										end,
							disabled	=	function(info) return not beql_lang or not beql:IsEnabled() end,
						},
						LanguageSelect	=	{
							type	=	'select',
							order	=	8,
							name	=	"Language",
							desc	=	"Change the language to a non WoW language. Reloades interface." .." - "..L["Requires Interface Reload"],
							values	=	function()
									local langtable = { SystemDefault = "SystemDefault"}
									for k in pairs(beql_lang) do
										langtable[k] = k
									end
									return langtable
								end,
							get	=	function(info) return beql.db.profile.Language end,
							set	=	function(info, newval)
									beql.db.profile.Language = newval
									securecall(function() ReloadUI() end)
								end,
							disabled	=	function(info) return not beql_lang or not beql.db.profile.EnableLanguages or not beql:IsEnabled() end,
						},

					},
				},

-- Quest Log Options

				qlog	=	{
					type	=	'group',
					order	=	2,
					name	=	L["Quest Log Options"],
					desc	=	L["Options related to the Quest Log"],
						args	=	{
							Spacing0	=	{
								type	=	'header',
								order	=	-1,
								name	=	L["General Quest Log Options"],
								hidden = true,
							},
							Locked	=	{
								type	=	'toggle',
								order	=	1,
								name	=	L["Lock Quest Log"],
								desc	=	L["Makes the quest log unmovable"],
								get	=	function(info) return beql.db.profile.QuestLog.locked end,
								set	=	function(info, newval) beql.db.profile.QuestLog.locked = newval; beqlQuestLogFrameAnchor.UpdateFrame = nil; end,
								disabled	=	function(info) return not beql:IsEnabled() end,
							},
							Reset	=	{
								type	=	'execute',
								order	=	2,
								name	=	L["Reset questlog position"],
								desc	=	L["Reset questlog position"],
								func	=	function(info)
														beqlQuestLogFrameAnchor:ClearAllPoints()
														beqlQuestLogFrameAnchor:SetPoint("TOPLEFT","UIParent","TOPLEFT",0,-104)
														beql:SaveFramePosition(beqlQuestLogFrameAnchor)
								end
							},
							Spacing1	=	{
								type	=	'header',
								order	=	3,
								name	=	'',
							},
							Layout	=	{
								type	=	'group',
								order	=	4,
								guiInline	=	true,
								width	=	'full',
								name	=	L["Questlog Layout"],
								disabled	=	function(info) return not beql:IsEnabled() end,
								args	=	{
									SimpleQuestLog	=	{
										type	=	'toggle',
										order	=	1,
										name	=	L["Simple Quest Log"],
										desc	=	L["Uses the default Blizzard Quest Log"],--.." - "..L["Requires Interface Reload"],
										get	=	function(info) return beql.db.profile.QuestLog.style == 'simple' end,
										set	=	function(info, newval) beql.db.profile.QuestLog.style = newval == true and 'simple' or 'extended'; beql:QuestLog_ToggleStyle(beql.db.profile.QuestLog.style) end,
										disabled	=	function(info) return not beql:IsEnabled() end,
									},
									ShowLevel	=	{
										type	=	'toggle',
										order	=	2,
--										width	=	'full',
										name	=	L["Show Quest Level"],
										desc	=	L["Shows the quests level"],
										get	=	function(info) return beql.db.profile.QuestLog.showlevel end,
										set	=	function(info, newval)
														beql.db.profile.QuestLog.showlevel	=	newval
														QuestLog_Update()
														beql:ManageQuests()
														WatchFrame_Update()
													end,
										disabled	=	function(info) return (not beql:IsEnabled()) end,
									},
									AlwaysMaximize	=	{
										type	=	'toggle',
										order	=	3,
										width	=	'full',
										name	=	L["Always Open Maximized"],
										desc	=	L["Force the quest log to open maximized"],
										get	=	function(info) return beql.db.profile.QuestLog.alwaysmaximize end,
										set	=	function(info, newval) beql.db.profile.QuestLog.alwaysmaximize	=	newval end,
										disabled	=	function(info) return beql.db.profile.QuestLog.alwaysminimize or (not beql:IsEnabled()) end,
										hidden = function() return beql.db.profile.QuestLog.style == 'simple' end,
									},
									AlwaysMinimize	=	{
										type	=	'toggle',
										order	=	4,
										width	=	'full',
										name	=	L["Always Open Minimized"],
										desc	=	L["Force the quest log to open minimized"],
										get	=	function(info) return beql.db.profile.QuestLog.alwaysminimize end,
										set	=	function(info, newval) beql.db.profile.QuestLog.alwaysminimize	=	newval end,
										disabled	=	function(info) return beql.db.profile.QuestLog.alwaysmaximize or (not beql:IsEnabled()) end,
										hidden = function() return beql.db.profile.QuestLog.style == 'simple' end,
								},
									QuestLogFontSize	=	{
										type	=	'range',
										order	=	5,
										width	=	'full',
										name	=	L["Font Size"],
										desc	=	L["Font Size"],
										get	=	function(info) return beql.db.profile.QuestLog.FontSize end,
										set	=	function(info, newval)
											beql.db.profile.QuestLog.FontSize	=	newval
											beql:QuestLog_SetFontSize(newval);
										end,
										min	=	6,
										max	=	20,
										step	=	1,
										disabled	=	function(info) return not beql:IsEnabled() end,
									},
									QuestLogAlpha	=	{
										type	=	'range',
										order	=	6,
--										width	=	'full',
										name	=	L["Quest Log Alpha"],
										desc	=	L["Sets the Alpha of the Quest Log"],
										get	=	function(info)
											return beql.db.profile.QuestLog.Alpha
										end,
										set	=	function(info, newval)
																beql.db.profile.QuestLog.Alpha	=	newval
																beqlQuestLogFrameAnchor.UpdateFrame = nil;
										end,
										min	=	0,
										max	=	1,
										step	=	0.01,
										disabled	=	function(info) return not beql:IsEnabled() end,
									},
									QuestLogScale	=	{
										type	=	'range',
										order	=	7,
--										width	=	'full',
										name	=	L["Quest Log Scale"],
										desc	=	L["Sets the Scale of the Quest Log"],
										get	=	function(info)
												return beql.db.profile.QuestLog.Scale
										end,
										set	=	function(info, newval)
																beql.db.profile.QuestLog.Scale	=	newval
																beqlQuestLogFrameAnchor.UpdateFrame = nil;
										end,
										min	=	0.4,
										max	=	1.5,
										step	=	0.01,
										disabled	=	function(info) return not beql:IsEnabled() end,
									},
								},
							},
							QuestCompletionSound	=	{
								type	=	'group',
								order	=	9,
								guiInline	=	true,
								width	=	'full',
								name	=	L["Completion Sound"],
								desc	=	L["Select the sound to be played when a quest is completed"],
								disabled	=	function(info) return not beql:IsEnabled() end,
								args	=	{
									InfoOnQuestCompletion	=	{
										type	=	'toggle',
										order	=	1,
										width	=	'full',
										name	=	L["Info on Quest Completion"],
										desc	=	L["Shows a message and plays a sound when you complete a quest"],
										get	=	function(info) return beql.db.profile.QuestLog.InfoOnQuestCompletion end,
										set	=	function(info, newval) beql.db.profile.QuestLog.InfoOnQuestCompletion = newval end,
										disabled	=	function(info) return not beql:IsEnabled() end,
									},
									Spacing1	=	{
										type	=	'header',
										order	=	2,
										name	=	'',
										hidden	=	function(info) return not beql.db.profile.QuestLog.InfoOnQuestCompletion or (not beql:IsEnabled()) end,
									},
									none	=	{
										type	=	'toggle',
										order	=	3,
										width	=	'full',
										name	=	L["No sound"],
										desc	=	L["Don't play a sound"],
										get	=	function(info) if not beql.db.profile.QuestLog.InfoSound or beql.db.profile.QuestLog.InfoSound ==	'' then return true else return false end end,
										set	=	function(info, newval) if newval then beql.db.profile.QuestLog.InfoSound	=	'' end end,
										hidden	=	function(info) return not beql.db.profile.QuestLog.InfoOnQuestCompletion or (not beql:IsEnabled()) end,
									},
								}
							},
							AnnounceQuestStatus	=	{
								type	=	'group',
								guiInline	=	true,
								name	=	L["Quest Progression to Party Chat"],
								order	=	10,
								args ={
									AnnounceQuestStatus	=	{
										type	=	'toggle',
										order	=	1,
										width	=	'full',
										name	=	L["Enable Quest Progression to Party Chat"],
										desc	=	L["Prints the Quest Progression Status to the Party Chat"],
										get	=	function(info) return beql.db.profile.QuestLog.chat.AnnounceQuest end,
										set	=	function(info, newval) beql.db.profile.QuestLog.chat.AnnounceQuest	=	newval end,
										disabled	=	function(info) return not beql:IsEnabled() end,
									},
									ChatType	=	{
										type	=	'select',
										width	=	'full',
										order	=	2,
										name	=	L["Select chattype"],
										desc	=	L["The chattype to post progress massages."],
										values	=	{default = L["Default chat for actual group"], group = L["Group chat"], say = L["say quest progession"]},
										get	=	function() return beql.db.profile.QuestLog.chat.chattype end,
										set	=	function(info, newval) beql.db.profile.QuestLog.chat.chattype = newval end,
										disabled	=	function(info) return not beql:IsEnabled() or not beql.db.profile.QuestLog.chat.AnnounceQuest end,
										hidden = function() return not beql.db.profile.QuestLog.chat.AnnounceQuest end,
									},
									accept	=	{
										type	=	'toggle',
										order	=	3,
										width	=	'full',
										name	=	L["Accept a new quest"],
										desc	=	L["Print a chat massage when you accept a new quest."],
										get	=	function() return beql.db.profile.QuestLog.chat.accept end,
										set	=	function(info, newval) beql.db.profile.QuestLog.chat.accept = newval end,
										disabled	=	function(info) return not beql:IsEnabled() or not beql.db.profile.QuestLog.chat.AnnounceQuest end,
										hidden = function() return not beql.db.profile.QuestLog.chat.AnnounceQuest end,
									},
									abandon	=	{
										type	=	'toggle',
										order	=	4,
										width	=	'full',
										name	=	L["Abandon a quest"],
										desc	=	L["Print a chat massage when you abandon a quest."],
										get	=	function() return beql.db.profile.QuestLog.chat.abandoned end,
										set	=	function(info, newval) beql.db.profile.QuestLog.chat.abandoned = newval end,
										disabled	=	function(info) return not beql:IsEnabled() or not beql.db.profile.QuestLog.chat.AnnounceQuest end,
										hidden = function() return not beql.db.profile.QuestLog.chat.AnnounceQuest end,
									},
									progress	=	{
										type	=	'toggle',
										order	=	5,
										width	=	'full',
										name	=	L["Progess of a quest"],
										desc	=	L["Print a chat massage when an objective of a quest is updated."],
										get	=	function() return beql.db.profile.QuestLog.chat.progress end,
										set	=	function(info, newval) beql.db.profile.QuestLog.chat.progress = newval end,
										disabled	=	function(info) return not beql:IsEnabled() or not beql.db.profile.QuestLog.chat.AnnounceQuest end,
										hidden = function() return not beql.db.profile.QuestLog.chat.AnnounceQuest end,
									},
									complete	=	{
										type	=	'toggle',
										order	=	6,
										width	=	'full',
										name	=	L["Complete a quest"],
										desc	=	L["Print a chat massage when you complete all quest objectives."],
										get	=	function() return beql.db.profile.QuestLog.chat.finished end,
										set	=	function(info, newval) beql.db.profile.QuestLog.chat.finished = newval end,
										disabled	=	function(info) return not beql:IsEnabled() or not beql.db.profile.QuestLog.chat.AnnounceQuest end,
										hidden = function() return not beql.db.profile.QuestLog.chat.AnnounceQuest end,
									},
									finished	=	{
										type	=	'toggle',
										order	=	7,
										width	=	'full',
										name	=	L["Finalize a quest."],
										desc	=	L["Print a chat massage when you deliver a completed quest to the NPC."],
										get	=	function() return beql.db.profile.QuestLog.chat.delivert end,
										set	=	function(info, newval) beql.db.profile.QuestLog.chat.delivert = newval end,
										disabled	=	function(info) return not beql:IsEnabled() or not beql.db.profile.QuestLog.chat.AnnounceQuest end,
										hidden = function() return not beql.db.profile.QuestLog.chat.AnnounceQuest end,
									},
								},
							},
							AutoComplete	=	{
								type	=	'toggle',
								order	=	11,
								width	=	'full',
								name	=	L["Auto Complete Quest"],
								desc	=	L["Automatically Complete Quests"],
								get	=	function(info) return beql.db.profile.QuestLog.autocomplete end,
								set	=	function(info, newval) beql.db.profile.QuestLog.autocomplete	=	newval end,
								disabled	=	function(info) return not beql:IsEnabled() end,
							},
						},
					},

-- Questtracker Options

				qtracker	=	{
					type	=	'group',
					order	=	3,
					name	=	L["Disable Tracker"],
					desc	=	L["Disable the Tracker"],--.." - "..L["Requires Interface Reload"],
					args	=	{
							LockedTracker	=	{
								type	=	'toggle',
								order	=	1,
								name	=	L["Lock Tracker"],
								desc	=	L["Makes the quest tracker unmovable"],
								get	=	function(info) return beql.db.profile.QuestTracker.locked end,
								set	=	function(info, newval) beql.db.profile.QuestTracker.locked = newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
								--disabled	=	function(info) return beql.db.profile.disabled.lockedtracker end,
							},
							ResetTracker	=	{
								type	=	'execute',
								order	=	2,
								name	=	L["Reset tracker position"],
								desc	=	L["Reset tracker position"],
								func	=	function(info)
														beqlQuestWatchAnchor:ClearAllPoints()
														beqlQuestWatchAnchor:SetPoint("TOPLEFT","UIParent","Center",0,0)
														beql:SaveFramePosition(beqlQuestWatchAnchor)
								end
							},
							Spacing1	=	{
								type	=	'header',
								order	=	3,
								name	=	'',
								},
							style = {
								type	=	'group',
								guiInline	=	true,
								name	=	'[ph] style',
								order	=	4,
								args	=	{
									ShowTrackerHeader	=	{
										type	=	'toggle',
										order	=	4,
										width	=	'full',
										name	=	L["Show Tracker Header"],
										desc	=	L["Shows the trackers header"],
										get	=	function(info) return beql.db.profile.QuestTracker.ShowHeader end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.ShowHeader	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
									},
									TrackerAutoResize	=	{
										type	=	'toggle',
										order	=	5,
										width	=	'full',
										name	=	L["Auto Resize Tracker"],
										desc	=	L["Automatical resizes the tracker depending on the lenght of the text in it"],
										get	=	function(info) return beql.db.profile.QuestTracker.AutoResize end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.AutoResize	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
									},
									TrackerFixedWidth	=	{
										type	=	'range',
										order	=	6,
										width	=	'full',
										name	=	L["Fixed Tracker Width"],
										desc	=	L["Sets the fixed width of the tracker if auto resize is disabled"],
										get	=	function(info) return beql.db.profile.QuestTracker.FixedWidth end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.FixedWidth	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
										min	=	20,
										max	=	600,
										step	=	10,
										disabled	=	function(info) return beql.db.profile.QuestTracker.AutoResize end,
									},
									TrackerFontHeight	=	{
										type	=	'range',
										order	=	7,
--										width	=	'full',
										name	=	L["Font Size"],
										desc	=	L["Changes the font size of the tracker"],
										get	=	function(info) return beql.db.profile.QuestTracker.FontHeight end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.FontHeight	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
										min	=	8,
										max	=	18,
										step	=	1,
									},
									QuestTrackerAlpha	=	{
										type	=	'range',
										order	=	8,
										name	=	L["Quest Tracker Alpha"],
										desc	=	L["Sets the Alpha of the Quest Tracker"],
										get	=	function(info) return beql.db.profile.QuestTracker.Alpha end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.Alpha	=	newval; beqlQuestWatchAnchor.UpdateFrame = nil; end,
										min	=	0,
										max	=	1,
										step	=	0.01,
									},
								},
							},
							WatchOptions = {
								type	=	'group',
								guiInline	=	true,
								name	=	L["Watch Options"],
								order	=	5,
								args	=	{
									AddNew	=	{
										type	=	'toggle',
										order	=	10,
										width	=	'full',
										name	=	L["Add New Quests"],
										desc	=	L["Automatical add new Quests to tracker"],
										get	=	function(info) return beql.db.profile.QuestTracker.AddNew end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.AddNew	=	newval end,
									},
									AddUntracked	=	{
										type	=	'toggle',
										order	=	11,
										width	=	'full',
										name	=	L["Add Untracked"],
										desc	=	L["Automatical add quests with updated objectives to tracker"],
										get	=	function(info) return beql.db.profile.QuestTracker.AddUntracked end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.AddUntracked	=	newval; end,
									},
									RemoveFinished	=	{
										type	=	'toggle',
										order	=	15,
										width	=	'full',
										name	=	L["Remove Completed Quests"],
										desc	=	L["Automatical remove completed quests from tracker"],
										get	=	function(info) return beql.db.profile.QuestTracker.RemoveFinished end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.RemoveFinished	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
									},
									MinimizeFinished	=	{
										type	=	'toggle',
										order	=	16,
										width	=	'full',
										name	=	L["Hide Completed Objectives"],
										desc	=	L["Automatical hide completed objectives in tracker"],
										get	=	function(info) return beql.db.profile.QuestTracker.MinimizeFinished end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.MinimizeFinished	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
									},
									HideCompletedOnly	=	{
										type	=	'toggle',
										order	=	17,
										width	=	'full',
										name	=	L["Hide Objectives for Completed only"],
										desc	=	L["Hide objectives only for completed quests"],
										get	=	function(info) return beql.db.profile.QuestTracker.HideCompletedOnly end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.HideCompletedOnly	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
										disabled	=	function(info) return beql.db.profile.QuestTracker.MinimizeFinished or beql.db.profile.QuestTracker.RemoveFinished end,
									},
									SortTrackerItems	=	{
										type	=	'toggle',
										order	=	18,
										width	=	'full',
										name	=	L["Sort Tracker Quests"],
										desc	=	L["Sort the quests in tracker"],
										get	=	function(info) return beql.db.profile.QuestTracker.SortItems end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.SortItems	=	newval beql:QuestTracker_SortWatchedQuests() beqlQuestWatchAnchor.UpdateFrame = nil; end,
									},
								},
							},

-- Marker Options on Questtracker
							MarkerOptions	=	{
								type	=	'group',
								order	=	20,
								guiInline	=	true,
								name	=	L["Markers"],
								desc	=	L["Customize the Objective/Quest Markers"],
								hidden = true,
								args	=	{
									ShowObjectiveMarkers	=	{
										type	=	'toggle',
										order	=	1,
										name	=	L["Show Objective Markers"],
										desc	=	L["Display Markers before objectives"],
										get	=	function(info) return beql.db.profile.QuestTracker.ShowObjectiveMarkers end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.ShowObjectiveMarkers	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
										--disabled	=	function(info) return beql.db.profile.disabled.markers end,
									},
									TrackerSymbol	=	{
										type	=	'range',
										order	=	2,
										name	=	L["Symbol Type"],
										desc	=	L["Set the type of symbol"],
										get	=	function(info)
														return beql.db.profile.QuestTracker.TrackerSymbol
										end,
										set	=	function(info, newval)
														beql.db.profile.QuestTracker.TrackerSymbol	=	newval
														beqlQuestWatchAnchor.UpdateFrame = nil;
										end,
										min	=	0,
										max	=	3,
										step	=	1,
										disabled	=	function(info) return beql.db.profile.QuestTracker.UseTrackerListing or not beql.db.profile.QuestTracker.ShowObjectiveMarkers end,
									},
									UseTrackerListing	=	{
										type	=	'toggle',
										order	=	3,
										name	=	L["Use Listing"],
										desc	=	L["User Listing rather than symbols"],
										get	=	function(info) return beql.db.profile.QuestTracker.UseTrackerListing end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.UseTrackerListing	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
										disabled	=	function(info) return not beql.db.profile.QuestTracker.ShowObjectiveMarkers end,
									},
									TrackerList	=	{
										type	=	'range',
										order	=	4,
										name	=	L["List Type"],
										desc	=	L["Set the type of listing"],
										get	=	function(info)
														return beql.db.profile.QuestTracker.TrackerList
										end,
										set	=	function(info, newval)
														beql.db.profile.QuestTracker.TrackerList	=	newval
														beqlQuestWatchAnchor.UpdateFrame = nil;
										end,
										min	=	0,
										max	=	3,
										step	=	1,
										disabled	=	function(info) return not beql.db.profile.QuestTracker.UseTrackerListing end,
									},
									Spacing6	=	{
										type	=	'header',
										order	=	21,
										name	=	L["Colors"],
									},
									Spacing2	=	{
										type	=	'header',
										order	=	9,
										name	=	'',
									},
									Spacing3	=	{
										type	=	'header',
										order	=	12,
										name	=	'',
									},
									Spacing4	=	{
										type	=	'header',
										order	=	14,
										name	=	L["Watch Options"],
									},
									Spacing5	=	{
										type	=	'header',
										order	=	19,
										name	=	L["Markers"],
									},
								},
							},

-- Colors on Questtracker

							Colors	=	{
								type	=	'group',
								guiInline	=	true,
								name	=	L["Colors"],
								order	=	22,
								args	=	{
									UseBackgroundColor	=	{
										type	=	'toggle',
										order	=	1,
										name	=	L["Background"],
										desc	=	L["Use Background"],
										get	=	function(info) return beql.db.profile.QuestTracker.UseBgColors end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.UseBgColors	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
									},
									CustomBgColor	=	{
										type	=	'toggle',
										order	=	2,
										name	=	L["Custom Background Color"],
										desc	=	L["Use custom color for background"],
										get	=	function(info) return beql.db.profile.QuestTracker.CustomBgColor end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.CustomBgColor	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
										disabled	=	function(info) return not beql.db.profile.QuestTracker.UseBgColors end,
									},
									BackgroundColor	=	{
										type	=	'color',
										order	=	3,
										name	=	L["Background Color"],
										desc	=	L["Sets the Background Color"],
										get	=	function(info)
														return
															beql.db.profile.QuestTracker.Colors.Bg.r,
															beql.db.profile.QuestTracker.Colors.Bg.g,
															beql.db.profile.QuestTracker.Colors.Bg.b,
															beql.db.profile.QuestTracker.Colors.Bg.a
										end,
										set	=	function(info, r, g, b, a)
														beql.db.profile.QuestTracker.Colors.Bg.r	=	r
														beql.db.profile.QuestTracker.Colors.Bg.g	=	g
														beql.db.profile.QuestTracker.Colors.Bg.b	=	b
														beql.db.profile.QuestTracker.Colors.Bg.a	=	a
														beqlQuestWatchAnchor.UpdateFrame = nil;
										end,
										hasAlpha	=	true,
										disabled	=	function(info) return not beql.db.profile.QuestTracker.CustomBgColor end,
									},
									QuestTracker_BgBorder	=	{
										type	=	'color',
										order	=	4,
										name	=	L["Background Corner Color"],
										desc	=	L["Sets the Background Corner Color"],
										get	=	function(info)
														return beql.db.profile.QuestTracker.Colors.BgBorder.r, beql.db.profile.QuestTracker.Colors.BgBorder.g, beql.db.profile.QuestTracker.Colors.BgBorder.b, beql.db.profile.QuestTracker.Colors.BgBorder.a
										end,
										set	=	function(info, r, g, b, a)
														beql.db.profile.QuestTracker.Colors.BgBorder.r	=	r
														beql.db.profile.QuestTracker.Colors.BgBorder.g	=	g
														beql.db.profile.QuestTracker.Colors.BgBorder.b	=	b
														beql.db.profile.QuestTracker.Colors.BgBorder.a	=	a
														beqlQuestWatchAnchor.UpdateFrame = nil;
										end,
										hasAlpha	=	true,
										disabled	=	function(info) return not beql.db.profile.QuestTracker.CustomBgColor end,
									},
									spacer1	=	{
													type	=	'header',
													order	=	5,
													name	=	L["Zones"],
												},
									ShowZonesInTracker	=	{
										order	=	5.5,
										type	=	'toggle',
										width	=	'full',
										name	=	L["Show Quest Zones"],
										desc	=	L["Show the quests zone it belongs to above its name"],
										get	=	function(info) return beql.db.profile.QuestTracker.ShowZones end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.ShowZones	=	newval beql:QuestTracker_SortWatchedQuests() beqlQuestWatchAnchor.UpdateFrame = nil; end,
									},
									CustomZoneColor	=	{
										type	=	'toggle',
										order	=	6,
										name	=	L["Custom Zone Color"],
										desc	=	L["Use custom color for Zone names"],
										get	=	function(info) return beql.db.profile.QuestTracker.CustomZoneColor end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.CustomZoneColor	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
										disabled = function() return not beql.db.profile.QuestTracker.ShowZones  end,
									},
									ColorZone	=	{
										type	=	'color',
										order	=	7,
										name	=	L["Zone Color"],
										desc	=	L["Sets the zone color"],
										get	=	function(info)
														return beql.db.profile.QuestTracker.Colors.Zone.r, beql.db.profile.QuestTracker.Colors.Zone.g, beql.db.profile.QuestTracker.Colors.Zone.b, beql.db.profile.QuestTracker.Colors.Zone.a
										end,
										set	=	function(info, r, g, b, a)
														beql.db.profile.QuestTracker.Colors.Zone.r	=	r
														beql.db.profile.QuestTracker.Colors.Zone.g	=	g
														beql.db.profile.QuestTracker.Colors.Zone.b	=	b
														beql.db.profile.QuestTracker.Colors.Zone.a	=	a
														beqlQuestWatchAnchor.UpdateFrame = nil;
										end,
										hasAlpha	=	false,
										disabled	=	function(info) return not beql.db.profile.QuestTracker.CustomZoneColor or not beql.db.profile.QuestTracker.ShowZones  end,
									},
									spacer3	=	{
													type	=	'header',
													order	=	8,
													name	=	'',
												},
									CustomHeaderColor	=	{
										type	=	'toggle',
										order	=	9,
										name	=	L["Custom Header Color"],
										desc	=	L["Use custom color for headers"],
										get	=	function(info) return beql.db.profile.QuestTracker.CustomHeaderColor end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.CustomHeaderColor	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
									},
									ColorHeaderEmpty	=	{
										type	=	'color',
										order	=	10,
										name	=	L["Header Color"],
										desc	=	L["Sets the color for headers"],
										get	=	function(info)
														return beql.db.profile.QuestTracker.Colors.HeaderNormal.r, beql.db.profile.QuestTracker.Colors.HeaderNormal.g, beql.db.profile.QuestTracker.Colors.HeaderNormal.b, beql.db.profile.QuestTracker.Colors.HeaderNormal.a
										end,
										set	=	function(info, r, g, b, a)
														beql.db.profile.QuestTracker.Colors.HeaderNormal.r	=	r
														beql.db.profile.QuestTracker.Colors.HeaderNormal.g	=	g
														beql.db.profile.QuestTracker.Colors.HeaderNormal.b	=	b
														beql.db.profile.QuestTracker.Colors.HeaderNormal.a	=	a
														beqlQuestWatchAnchor.UpdateFrame = nil;
										end,
										hasAlpha	=	false,
										disabled	=	function(info) return not beql.db.profile.QuestTracker.CustomHeaderColor or beql.db.profile.QuestTracker.HeaderQuestLevelColor end,
									},
									HeaderQuestLevelColor	=	{
										type	=	'toggle',
										width = 'full',
										order	=	11,
										name	=	L["Use Quest Level Colors"],
										desc	=	L["Use the colors to indicate quest difficulty"],
										get	=	function(info) return beql.db.profile.QuestTracker.HeaderQuestLevelColor end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.HeaderQuestLevelColor	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
										disabled	=	function(info) return not beql.db.profile.QuestTracker.CustomHeaderColor end,
									},
									ColorHeaderFailed	=	{
										type	=	'color',
										order	=	12,
										name	=	L["Failed Header Color"],
										desc	=	L["Sets the color for failed quests"],
										get	=	function(info)
														return beql.db.profile.QuestTracker.Colors.HeaderFailed.r, beql.db.profile.QuestTracker.Colors.HeaderFailed.g, beql.db.profile.QuestTracker.Colors.HeaderFailed.b, beql.db.profile.QuestTracker.Colors.HeaderFailed.a
										end,
										set	=	function(info, r, g, b, a)
														beql.db.profile.QuestTracker.Colors.HeaderFailed.r	=	r
														beql.db.profile.QuestTracker.Colors.HeaderFailed.g	=	g
														beql.db.profile.QuestTracker.Colors.HeaderFailed.b	=	b
														beql.db.profile.QuestTracker.Colors.HeaderFailed.a	=	a
														beqlQuestWatchAnchor.UpdateFrame = nil;
										end,
										hasAlpha	=	false,
										disabled	=	function(info) return not beql.db.profile.QuestTracker.CustomHeaderColor end,
									},
									ColorHeaderComplete	=	{
										type	=	'color',
										order	=	13,
										name	=	L["Completed Header Color"],
										desc	=	L["Sets the color for completed headers"],
										get	=	function(info)
														return beql.db.profile.QuestTracker.Colors.HeaderComplete.r, beql.db.profile.QuestTracker.Colors.HeaderComplete.g, beql.db.profile.QuestTracker.Colors.HeaderComplete.b, beql.db.profile.QuestTracker.Colors.HeaderComplete.a
										end,
										set	=	function(info, r, g, b, a)
														beql.db.profile.QuestTracker.Colors.HeaderComplete.r	=	r
														beql.db.profile.QuestTracker.Colors.HeaderComplete.g	=	g
														beql.db.profile.QuestTracker.Colors.HeaderComplete.b	=	b
														beql.db.profile.QuestTracker.Colors.HeaderComplete.a	=	a
														beqlQuestWatchAnchor.UpdateFrame = nil;
										end,
										hasAlpha	=	false,
										disabled	=	function(info) return not beql.db.profile.QuestTracker.CustomHeaderColor end,
									},
									spacer2	=	{
													type	=	'header',
													order	=	14,
													name	=	'',
												},
									CustomObjetiveColor	=	{
										type	=	'toggle',
										order	=	15,
										name	=	L["Color Objectives"],
										desc	=	L["Use custom color for objective text"],
										get	=	function(info) return beql.db.profile.QuestTracker.CustomObjetiveColor end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.CustomObjetiveColor	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
									},
									FadeColor	=	{
										type	=	'toggle',
										order	=	16,
										name	=	L["Fade Colors"],
										desc	=	L["Fade the objective colors"],
										get	=	function(info) return beql.db.profile.QuestTracker.FadeColor end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.FadeColor	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
									},
									ColorObjectiveNormal	=	{
										type	=	'color',
										order	=	17,
										name	=	L["Objective Color"],
										desc	=	L["Sets the color for objectives"],
										get	=	function(info)
														return beql.db.profile.QuestTracker.Colors.ObjectiveNormal.r, beql.db.profile.QuestTracker.Colors.ObjectiveNormal.g, beql.db.profile.QuestTracker.Colors.ObjectiveNormal.b, beql.db.profile.QuestTracker.Colors.ObjectiveNormal.a
										end,
										set	=	function(info, r, g, b, a)
														beql.db.profile.QuestTracker.Colors.ObjectiveNormal.r	=	r
														beql.db.profile.QuestTracker.Colors.ObjectiveNormal.g	=	g
														beql.db.profile.QuestTracker.Colors.ObjectiveNormal.b	=	b
														beql.db.profile.QuestTracker.Colors.ObjectiveNormal.a	=	a
														beqlQuestWatchAnchor.UpdateFrame = nil;
										end,
										hasAlpha	=	false,
										disabled	=	function(info) return not beql.db.profile.QuestTracker.CustomObjetiveColor end,
									},
									ColorObjectiveComplete	=	{
										type	=	'color',
										order	=	18,
										name	=	L["Completed Objective Color"],
										desc	=	L["Sets the color for completed objectives"],
										get	=	function(info)
														return beql.db.profile.QuestTracker.Colors.ObjectiveComplete.r, beql.db.profile.QuestTracker.Colors.ObjectiveComplete.g, beql.db.profile.QuestTracker.Colors.ObjectiveComplete.b, beql.db.profile.QuestTracker.Colors.ObjectiveComplete.a
										end,
										set	=	function(info, r, g, b, a)
														beql.db.profile.QuestTracker.Colors.ObjectiveComplete.r	=	r
														beql.db.profile.QuestTracker.Colors.ObjectiveComplete.g	=	g
														beql.db.profile.QuestTracker.Colors.ObjectiveComplete.b	=	b
														beql.db.profile.QuestTracker.Colors.ObjectiveComplete.a	=	a
														beqlQuestWatchAnchor.UpdateFrame = nil;
										end,
										hasAlpha	=	false,
										disabled	=	function(info) return not beql.db.profile.QuestTracker.CustomObjetiveColor end,
									},
									ObjectiveStepColor	=	{
										type	=	'toggle',
										order	=	19,
										name	=	L["Custom Objective Color"],
										desc	=	L["Use custom color for objective text"],
										get	=	function(info) return beql.db.profile.QuestTracker.ObjetiveStepColor end,
										set	=	function(info, newval) beql.db.profile.QuestTracker.ObjetiveStepColor	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
									},
									ColorObjectiveStep	=	{
										type	=	'color',
										order	=	20,
										name	=	L["Completed Objective Color"],
										desc	=	L["Sets the color for completed objectives"],
										get	=	function(info)
														return beql.db.profile.QuestTracker.Colors.ObjetiveStepColor.r, beql.db.profile.QuestTracker.Colors.ObjetiveStepColor.g, beql.db.profile.QuestTracker.Colors.ObjetiveStepColor.b, beql.db.profile.QuestTracker.Colors.ObjetiveStepColor.a
										end,
										set	=	function(info, r, g, b, a)
														beql.db.profile.QuestTracker.Colors.ObjetiveStepColor.r	=	r
														beql.db.profile.QuestTracker.Colors.ObjetiveStepColor.g	=	g
														beql.db.profile.QuestTracker.Colors.ObjetiveStepColor.b	=	b
														beql.db.profile.QuestTracker.Colors.ObjetiveStepColor.a	=	a
														beqlQuestWatchAnchor.UpdateFrame = nil;
										end,
										hasAlpha	=	false,
										disabled	=	function(info) return not beql.db.profile.QuestTracker.CustomObjetiveColor or not beql.db.profile.QuestTracker.ObjetiveStepColor end,
									},
									MarkerOptions	=	{
										type	=	'group',
										order	=	21,
										guiInline	=	true,
										name	=	'',
										desc	=	L["Customize the Objective/Quest Markers"],
										args	=	{
											Spacing5	=	{
												type	=	'header',
												order	=	0,
												name	=	L["Markers"],
											},
											ShowObjectiveMarkers	=	{
												type	=	'toggle',
												order	=	1,
												name	=	L["Show Objective Markers"],
												desc	=	L["Display Markers before objectives"],
												get	=	function(info) return beql.db.profile.QuestTracker.ShowObjectiveMarkers end,
												set	=	function(info, newval) beql.db.profile.QuestTracker.ShowObjectiveMarkers	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
											},
											TrackerSymbol	=	{
												type	=	'range',
												order	=	2,
												name	=	L["Symbol Type"],
												desc	=	L["Set the type of symbol"],
												get	=	function(info)
																return beql.db.profile.QuestTracker.TrackerSymbol
												end,
												set	=	function(info, newval)
																beql.db.profile.QuestTracker.TrackerSymbol	=	newval
																beqlQuestWatchAnchor.UpdateFrame = nil;
												end,
												min	=	0,
												max	=	3,
												step	=	1,
												disabled	=	function(info) return beql.db.profile.QuestTracker.UseTrackerListing or not beql.db.profile.QuestTracker.ShowObjectiveMarkers end,
											},
											UseTrackerListing	=	{
												type	=	'toggle',
												order	=	3,
												name	=	L["Use Listing"],
												desc	=	L["User Listing rather than symbols"],
												get	=	function(info) return beql.db.profile.QuestTracker.UseTrackerListing end,
												set	=	function(info, newval) beql.db.profile.QuestTracker.UseTrackerListing	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
												disabled	=	function(info) return not beql.db.profile.QuestTracker.ShowObjectiveMarkers end,
											},
											TrackerList	=	{
												type	=	'range',
												order	=	4,
												name	=	L["List Type"],
												desc	=	L["Set the type of listing"],
												get	=	function(info)
																return beql.db.profile.QuestTracker.TrackerList
												end,
												set	=	function(info, newval)
																beql.db.profile.QuestTracker.TrackerList	=	newval
																beqlQuestWatchAnchor.UpdateFrame = nil;
												end,
												min	=	0,
												max	=	3,
												step	=	1,
												disabled	=	function(info) return not beql.db.profile.QuestTracker.UseTrackerListing end,
											},
										},
									},
								},
							},
						},
					},


-- Tooltip Options

				tooltip	=	{
					type	=	'group',
					order	=	4,
					name	=	L["Tooltip"],
					desc	=	L["Tooltip Options"],
					args	=	{
						Spacer1	=	{
							type	=	'header',
							order	=	3,
							name	=	L["Quest Tracker"],
						},
						QuestTrackerTooltip = {
							type	=	'group',
							name = L["Quest Tracker"],
							order = 3,
							guiInline	=	true,
							args = {
								ActiveTracker	=	{
									type	=	'toggle',
									order	=	1,
									width	=	'full',
									name	=	L["Tracker Tooltip"],
									desc	=	L["Showing mouseover tooltips in tracker"],
									get	=	function(info) return beql.db.profile.Tooltip.QuestTracker_TooltipShow end,
									set	=	function(info, newval) beql.db.profile.Tooltip.QuestTracker_TooltipShow	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
								},
								TrackerMouseLeft	=	{
									type	=	'toggle',
									order	=	3,
									name	=	L["Enable Left Click"],
									desc	=	L["Left clicking a quest in the tracker opens the Quest Log"],
									get	=	function(info) return beql.db.profile.QuestTracker.LeftClick end,
									set	=	function(info, newval) beql.db.profile.QuestTracker.LeftClick	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
								},
								TrackerMouseRight	=	{
									type	=	'toggle',
									order	=	4,
									name	=	L["Enable Right Click"],
									desc	=	L["Right clicking a quest in the tracker removes it from the tracker"],
									get	=	function(info) return beql.db.profile.QuestTracker.RightClick end,
									set	=	function(info, newval) beql.db.profile.QuestTracker.RightClick	=	newval beqlQuestWatchAnchor.UpdateFrame = nil; end,
								},
								Spacer2	=	{
									type	=	'header',
									order	=	5,
									name	=	L["Title color"],
								},
								ColorTitleDiff	=	{
									type	=	'toggle',
									order	=	6,
									name	=	L["Use Quest Level Colors"],
									desc	=	L["Use Quest Level Colors"],
									get	=	function(info) return beql.db.profile.Tooltip.QuestTracker_TooltipTitleQuestcolor end,
									set	=	function(info, newval) beql.db.profile.Tooltip.QuestTracker_TooltipTitleQuestcolor	=	newval end,
								},
								ColorTitle	=	{
									type	=	'color',
									order	=	7,
									name	=	L["Header Color"],
									desc	=	L["Sets the color for headers"],
									get	=	function(info)
												return beql.db.profile.Tooltip.Colors.QuestTracker_TooltipTitle.r,
														beql.db.profile.Tooltip.Colors.QuestTracker_TooltipTitle.g,
														beql.db.profile.Tooltip.Colors.QuestTracker_TooltipTitle.b,
														beql.db.profile.Tooltip.Colors.QuestTracker_TooltipTitle.a
									end,
									set	=	function(info, r, g, b, a)
												beql.db.profile.Tooltip.Colors.QuestTracker_TooltipTitle.r	=	r
												beql.db.profile.Tooltip.Colors.QuestTracker_TooltipTitle.g	=	g
												beql.db.profile.Tooltip.Colors.QuestTracker_TooltipTitle.b	=	b
												beql.db.profile.Tooltip.Colors.QuestTracker_TooltipTitle.a	=	a
									end,
									hasAlpha	=	false,
									disabled	=	function(info) return beql.db.profile.Tooltip.QuestTracker_TooltipTitleQuestcolor end,
								},
								TrackerTooltipDesc	=	{
									type	=	'toggle',
									order	=	8,
									width	=	'full',
									name	=	L["Quest Description in Tracker Tooltip"],
									desc	=	L["Displays the actual quest's description in the tracker tooltip"],
									get	=	function(info) return beql.db.profile.Tooltip.QuestTracker_TooltipDesc end,
									set	=	function(info, newval) beql.db.profile.Tooltip.QuestTracker_TooltipDesc	=	newval end,
									disabled	=	function(info) return not beql.db.profile.Tooltip.QuestTracker_TooltipShow end,
								},
								ColorDesc	=	{
									type	=	'color',
									order	=	9,
									name	=	L["Quest Description Color"],
									desc	=	L["Sets the color for the Quest description"],
									get	=	function(info)
												return beql.db.profile.Tooltip.Colors.QuestTracker_TooltipDesc.r,
														beql.db.profile.Tooltip.Colors.QuestTracker_TooltipDesc.g,
														beql.db.profile.Tooltip.Colors.QuestTracker_TooltipDesc.b,
														beql.db.profile.Tooltip.Colors.QuestTracker_TooltipDesc.a
									end,
									set	=	function(info, r, g, b, a)
												beql.db.profile.Tooltip.Colors.QuestTracker_TooltipDesc.r	=	r
												beql.db.profile.Tooltip.Colors.QuestTracker_TooltipDesc.g	=	g
												beql.db.profile.Tooltip.Colors.QuestTracker_TooltipDesc.b	=	b
												beql.db.profile.Tooltip.Colors.QuestTracker_TooltipDesc.a	=	a
									end,
									hasAlpha	=	false,
								},
								TrackerTooltipParty	=	{
									type	=	'toggle',
									order	=	10,
									width	=	'full',
									name	=	L["Party Quest Progression info"],
									desc	=	L["Displays Party members quest status in the tooltip - Quixote must be installed on the partymembers client"],
									get	=	function(info) return beql.db.profile.activetrackerparty end,
									set	=	function(info, newval) beql.db.profile.activetrackerparty	=	newval end,
									disabled	=	function(info) return not beql.db.profile.Tooltip.QuestTracker_TooltipShow end,
									hidden = true,
								},
							},
						},
								ColorPartyQ	=	{
									type	=	'color',
									order	=	2,
									width	=	'full',
									name	=	L["Party Member with Quixote Color"],
									desc	=	L["Sets the color for Party member"],
									get	=	function(info)
												return beql.db.profile.Color.TooltipPartyQuixote.r,
														beql.db.profile.Color.TooltipPartyQuixote.g,
														beql.db.profile.Color.TooltipPartyQuixote.b,
														beql.db.profile.Color.TooltipPartyQuixote.a
									end,
									set	=	function(info, r, g, b, a)
												beql.db.profile.Color.TooltipPartyQuixote.r	=	r
												beql.db.profile.Color.TooltipPartyQuixote.g	=	g
												beql.db.profile.Color.TooltipPartyQuixote.b	=	b
												beql.db.profile.Color.TooltipPartyQuixote.a	=	a
									end,
									hasAlpha	=	false,
									hidden = true,
								},
								ColorPartyNQ	=	{
									type	=	'color',
									order	=	3,
									width	=	'full',
									name	=	L["Party Member Color"],
									desc	=	L["Sets the color for Party member"],
									get	=	function(info)
												return beql.db.profile.Color.TooltipPartyNonQuixote.r,
														beql.db.profile.Color.TooltipPartyNonQuixote.g,
														beql.db.profile.Color.TooltipPartyNonQuixote.b,
														beql.db.profile.Color.TooltipPartyNonQuixote.a
									end,
									set	=	function(info, r, g, b, a)
												beql.db.profile.Color.TooltipPartyNonQuixote.r	=	r
												beql.db.profile.Color.TooltipPartyNonQuixote.g	=	g
												beql.db.profile.Color.TooltipPartyNonQuixote.b	=	b
												beql.db.profile.Color.TooltipPartyNonQuixote.a	=	a
									end,
									hasAlpha	=	false,
									hidden = true,
								},
								ColorPartyObj	=	{
									type	=	'color',
									order	=	4,
									width	=	'full',
									name	=	L["Objective Color"],
									desc	=	L["Sets the color for objectives"],
									get	=	function(info)
												return beql.db.profile.Color.TooltipPartyObj.r,
														beql.db.profile.Color.TooltipPartyObj.g,
														beql.db.profile.Color.TooltipPartyObj.b,
														beql.db.profile.Color.TooltipPartyObj.a
									end,
									set	=	function(info, r, g, b, a)
												beql.db.profile.Color.TooltipPartyObj.r	=	r
												beql.db.profile.Color.TooltipPartyObj.g	=	g
												beql.db.profile.Color.TooltipPartyObj.b	=	b
												beql.db.profile.Color.TooltipPartyObj.a	=	a
									end,
									hasAlpha	=	false,
									hidden = true,
								},
								ColorPartyObj	=	{
									type	=	'color',
									order	=	5,
									width	=	'full',
									name	=	L["Completed Objective Color"],
									desc	=	L["Sets the color for completed objectives"],
									get	=	function(info)
												return beql.db.profile.Color.TooltipPartyObjComp.r,
														beql.db.profile.Color.TooltipPartyObjComp.g,
														beql.db.profile.Color.TooltipPartyObjComp.b,
														beql.db.profile.Color.TooltipPartyObjComp.a
									end,
									set	=	function(info, r, g, b, a)
												beql.db.profile.Color.TooltipPartyObjComp.r	=	r
												beql.db.profile.Color.TooltipPartyObjComp.g	=	g
												beql.db.profile.Color.TooltipPartyObjComp.b	=	b
												beql.db.profile.Color.TooltipPartyObjComp.a	=	a
									end,
									hasAlpha	=	false,
									hidden = true,
								},
								ColorObjFade	=	{
									type	=	'toggle',
									order	=	7,
									width	=	'full',
									name	=	L["Fade Colors"],
									desc	=	L["Fade Colors"],
									get	=	function(info) return beql.db.profile.TooltipObjFade end,
									set	=	function(info, newval) beql.db.profile.TooltipObjFade	=	newval end,
									hidden = true,
								},
						Spacer1	=	{
										type	=	'header',
										order	=	10,
										name	=	L["NPC color"],
								},
						Gametooltip	=	{
							type	=	'group',
							order	=	14,
							guiInline	=	true,
							name	=	L["GameTooltip"],
							desc	=	L["Colors"],
							args	=	{
								TooltipMob	=	{
									type	=	'toggle',
									order	=	1,
									width	=	'full',
									name	=	L["Mob Tooltip Quest Info"],
									desc	=	L["Show quest info in mob tooltips"],
									get	=	function(info) return beql.db.profile.Tooltip.mob end,
									set	=	function(info, newval) beql.db.profile.Tooltip.mob	=	newval end,
								},
								TooltipItem	=	{
									type	=	'toggle',
									order	=	2,
									width	=	'full',
									name	=	L["Item Tooltip Quest Info"],
									desc	=	L["Show quest info in item tooltips"],
									get	=	function(info) return beql.db.profile.Tooltip.item end,
									set	=	function(info, newval) beql.db.profile.Tooltip.item	=	newval end,
								},
								TooltipTitleColor	=	{
									type	=	'toggle',
									order	=	3,
											width	=	'full',
									name	=	L["Use Quest Level Colors"],
									desc	=	L["Use Quest Level Colors"],
									get	=	function(info) return beql.db.profile.Tooltip.GameTooltip_TitelIsQuestcolor end,
									set	=	function(info, newval) beql.db.profile.Tooltip.GameTooltip_TitelIsQuestcolor	=	newval end,
								},
								ColorMobTooltip	=	{
									type	=	'color',
									order	=	4,
									name	=	L["Mob Tooltip Quest Info"],
									desc	=	L["Mob Tooltip Quest Info"],
									get	=	function(info)
												return beql.db.profile.Tooltip.Colors.GameTooltip_MobTitle.r,
														beql.db.profile.Tooltip.Colors.GameTooltip_MobTitle.g,
														beql.db.profile.Tooltip.Colors.GameTooltip_MobTitle.b,
														beql.db.profile.Tooltip.Colors.GameTooltip_MobTitle.a
									end,
									set	=	function(info, r, g, b, a)
												beql.db.profile.Tooltip.Colors.GameTooltip_MobTitle.r	=	r
												beql.db.profile.Tooltip.Colors.GameTooltip_MobTitle.g	=	g
												beql.db.profile.Tooltip.Colors.GameTooltip_MobTitle.b	=	b
												beql.db.profile.Tooltip.Colors.GameTooltip_MobTitle.a	=	a
									end,
									hasAlpha	=	false,
									disabled	=	function(info) return beql.db.profile.Tooltip.GameTooltip_TitelIsQuestcolor end,
								},
								ColorItemTooltip	=	{
									type	=	'color',
									order	=	5,
									name	=	L["Item Tooltip Quest Info"],
									desc	=	L["Item Tooltip Quest Info"],
									get	=	function(info)
												return beql.db.profile.Tooltip.Colors.GameTooltip_ItemTitle.r,
														beql.db.profile.Tooltip.Colors.GameTooltip_ItemTitle.g,
														beql.db.profile.Tooltip.Colors.GameTooltip_ItemTitle.b,
														beql.db.profile.Tooltip.Colors.GameTooltip_ItemTitle.a
									end,
									set	=	function(info, r, g, b, a)
												beql.db.profile.Tooltip.Colors.GameTooltip_ItemTitle.r	=	r
												beql.db.profile.Tooltip.Colors.GameTooltip_ItemTitle.g	=	g
												beql.db.profile.Tooltip.Colors.GameTooltip_ItemTitle.b	=	b
												beql.db.profile.Tooltip.Colors.GameTooltip_ItemTitle.a	=	a
									end,
									hasAlpha	=	false,
									disabled	=	function(info) return beql.db.profile.Tooltip.GameTooltip_TitelIsQuestcolor end,
								},
								Spacer1	=	{
									type	=	'header',
									order	=	6,
									name	=	'',
								},
								ColorObjectives	=	{
									type	=	'toggle',
									order	=	7,
--									width	=	'half',
									name	=	L["Color Objectives"],
--									desc	=	L["Show quest info in item tooltips"],
									get	=	function(info) return beql.db.profile.Tooltip.GameTooltip_ColorObjectives end,
									set	=	function(info, newval) beql.db.profile.Tooltip.GameTooltip_ColorObjectives	=	newval end,
								},
								FadeObjectives	=	{
									type	=	'toggle',
									order	=	8,
--									width	=	'half',
									name	=	L["Fade Colors"],
--									desc	=	L["Show quest info in item tooltips"],
									get	=	function(info) return beql.db.profile.Tooltip.GameTooltip_FadeObjectiveColors end,
									set	=	function(info, newval) beql.db.profile.Tooltip.GameTooltip_FadeObjectiveColors	=	newval end,
									disabled	=	function(info) return not beql.db.profile.Tooltip.GameTooltip_ColorObjectives end,
								},
								ColorIncomplete	=	{
									type	=	'color',
									order	=	9,
									name	=	L["Incomplete"],
--									desc	=	L["Item Tooltip Quest Info"],
									get	=	function(info)
												return beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete.r,
														beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete.g,
														beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete.b,
														beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete.a
									end,
									set	=	function(info, r, g, b, a)
												beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete.r	=	r
												beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete.g	=	g
												beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete.b	=	b
												beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveIncomplete.a	=	a
									end,
									hasAlpha	=	false,
									disabled	=	function(info) return not beql.db.profile.Tooltip.GameTooltip_ColorObjectives end,
								},
								ColorComplete	=	{
									type	=	'color',
									order	=	10,
									name	=	L["Complete"],
--									desc	=	L["Item Tooltip Quest Info"],
									get	=	function(info)
												return beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete.r,
														beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete.g,
														beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete.b,
														beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete.a
									end,
									set	=	function(info, r, g, b, a)
												beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete.r	=	r
												beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete.g	=	g
												beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete.b	=	b
												beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveComplete.a	=	a
									end,
									hasAlpha	=	false,
									disabled	=	function(info) return not beql.db.profile.Tooltip.GameTooltip_ColorObjectives end,
								},
								UseFadeStepColor	=	{
									type	=	'toggle',
									order	=	11,
--									width	=	'half',
									name	=	L["Use Fade-Step-Color"],
--									desc	=	L["Show quest info in item tooltips"],
									get	=	function(info) return beql.db.profile.Tooltip.GameTooltip_ObjectiveUseStep end,
									set	=	function(info, newval) beql.db.profile.Tooltip.GameTooltip_ObjectiveUseStep	=	newval end,
									disabled	=	function(info) return not beql.db.profile.Tooltip.GameTooltip_ColorObjectives or not beql.db.profile.Tooltip.GameTooltip_FadeObjectiveColors end,
								},
								ColorFadeStep	=	{
									type	=	'color',
									order	=	12,
									name	=	L["Fade-Step-Color"],
--									desc	=	L["Item Tooltip Quest Info"],
									get	=	function(info)
												return beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveStep.r,
														beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveStep.g,
														beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveStep.b,
														beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveStep.a
									end,
									set	=	function(info, r, g, b, a)
												beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveStep.r	=	r
												beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveStep.g	=	g
												beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveStep.b	=	b
												beql.db.profile.Tooltip.Colors.GameTooltip_ObjectiveStep.a	=	a
									end,
									hasAlpha	=	false,
									disabled	=	function(info) return not beql.db.profile.Tooltip.GameTooltip_ColorObjectives or not beql.db.profile.Tooltip.GameTooltip_ObjectiveUseStep or not beql.db.profile.Tooltip.GameTooltip_FadeObjectiveColors end,
								},
								ColorNonobjective	=	{
									type	=	'color',
									order	=	13,
									name	=	L["Non Objective"],
--									desc	=	L["Item Tooltip Quest Info"],
									get	=	function(info)
												return beql.db.profile.Tooltip.Colors.GameTooltip_NonObjective.r,
														beql.db.profile.Tooltip.Colors.GameTooltip_NonObjective.g,
														beql.db.profile.Tooltip.Colors.GameTooltip_NonObjective.b,
														beql.db.profile.Tooltip.Colors.GameTooltip_NonObjective.a
									end,
									set	=	function(info, r, g, b, a)
												beql.db.profile.Tooltip.Colors.GameTooltip_NonObjective.r	=	r
												beql.db.profile.Tooltip.Colors.GameTooltip_NonObjective.g	=	g
												beql.db.profile.Tooltip.Colors.GameTooltip_NonObjective.b	=	b
												beql.db.profile.Tooltip.Colors.GameTooltip_NonObjective.a	=	a
									end,
									hasAlpha	=	false,
									disabled	=	function(info) return not beql.db.profile.Tooltip.GameTooltip_ColorObjectives end,
								},
							},
						}
					},
				},

-- Profiles
				profiles	=	LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db),

-- Achievements

			--[[	achievement	=	{
					type	=	'group',
					order	=	3,
					name	=	L["Disable Tracker"],
					desc	=	L["Disable the Tracker"].." - "..L["Requires Interface Reload"],
					args	=	{
						LockedTracker	=	{
								type	=	'toggle',
								order	=	1,
								name	=	L["Lock Tracker"],
								desc	=	L["Makes the achievement tracker unmovable"],
								get	=	function(info) return beql.db.profile.AchievementTracker.Locked end,
								set	=	function(info, newval) beql.db.profile.AchievementTracker.Locked = newval; beqlAchievementWatchAnchor.UpdateFrame = nil end,
								disabled	=	function(info) return not beql.db.profile.AchievementTracker.Enable end,
						},
						ResetTracker	=	{
								type	=	'execute',
								order	=	2,
								name	=	L["Reset tracker position"],
								desc	=	L["Reset tracker position"],
								func	=	function(info)
												beqlAchievementWatchAnchor:ClearAllPoints()
												beqlAchievementWatchAnchor:SetPoint("TOPRIGHT", "MinimapCluster", "BOTTOMLEFT", -93, -13)
												beql:SaveFramePosition(beqlAchievementWatchAnchor)
											end,
								disabled	=	function(info) return not beql.db.profile.AchievementTracker.Enable end,
							},
--[ [						Spacing1	=	{
								type	=	'header',
								order	=	3,
								name	=	'',
						}, --] ]
						ShowATrackerHeader	=	{
								type	=	'toggle',
								order	=	4,
								width	=	'full',
								name	=	L["Show Achievement Tracker Header"],
								desc	=	L["Shows the header of the Achievementtracker"],
								get	=	function(info) return beql.db.profile.AchievementTracker.ShowHeader end,
								set	=	function(info, newval)
												beql.db.profile.AchievementTracker.ShowHeader	=	newval
												beqlAchievementWatchAnchor.UpdateFrame = nil
											end,
								disabled	=	function(info) return not beql.db.profile.AchievementTracker.Enable end,
							},
						savelast	=	{
								type	=	'toggle',
								order	=	5,
								width	=	'full',
								name	=	L["Save tracked Achievement"],
								desc	=	L["Save last tracked Achievement and resore it after login"],
								get	=	function(info) return beql.db.profile.AchievementTracker.savelast end,
								set	=	function(info, newval)
												beql.db.profile.AchievementTracker.savelast	=	newval
											end,
								disabled	=	function(info) return not beql.db.profile.AchievementTracker.Enable end,
						},
						RemoveFinished	=	{
								type	=	'toggle',
								order	=	6,
								width	=	'full',
								name	=	L["Remove Completed Achievement"],
								desc	=	L["Automatical remove the completed Achievement from tracker"],
								get	=	function(info) return beql.db.profile.AchievementTracker.RemoveFinished end,
								set	=	function(info, newval)
											beql.db.profile.AchievementTracker.RemoveFinished	=	newval
											if newval then
												beql:RegisterEvent("ACHIEVEMENT_EARNED");
											else
												beql:UnregisterEvent("ACHIEVEMENT_EARNED");
											end
										end,
								disabled	=	function(info) return not beql.db.profile.AchievementTracker.Enable end,
							},
--[ [						Spacing2	=	{
								type	=	'header',
								order	=	7,
								name	=	'',
								},--] ]
						ManageLines	=	{
							type	=	'toggle',
							order	=	8,
--							width	=	'full',
							name	=	L["Manage Achievement Lines"],
							desc	=	L["Mange count of Lines to optimal display objectives from the achievement"],
							get	=	function(info) return beql.db.profile.AchievementTracker.ManageLines end,
							set	=	function(info, newval)
									beql.db.profile.AchievementTracker.ManageLines = newval
									WatchFrame_Update()
								end,
							disabled	=	function(info) return not beql:IsEnabled() or not beql.db.profile.AchievementTracker.Enable end,
						},
						MaxLines	=	{
							type	=	'range',
							order	=	9,
--							width	=	'full',
							name	=	L["Number of Lines"],
							desc	=	L["Number of lines that can be used by the Linemanger"],
							get	=	function(info) return beql.db.profile.AchievementTracker.NumLines end,
							set	=	function(info, newval)
										beql.db.profile.AchievementTracker.NumLines	=	newval
										beql:AchievementTracker_DisplayAchievements()
									end,
							min	=	1,
							max	=	100,
							step	=	1,
							disabled	=	function(info) return not beql.db.profile.AchievementTracker.Enable or not beql.db.profile.AchievementTracker.ManageLines end,
						},
						Spacing3	=	{
								type	=	'header',
								order	=	10,
								name	=	'',
								},
						ATrackerFontSize	=	{
								type	=	'range',
								order	=	12,
								width	=	'full',
								name	=	L["Achievement Tracker Scale"] .. "\n(delete me)",
								desc	=	L["Sets the Scale of the Achievement Tracker"],
								get	=	function(info) return beql.db.profile.AchievementTracker.FontSize end,
								set	=	function(info, newval)
											beql.db.profile.AchievementTracker.FontSize	=	newval;
											beqlAchievementWatchAnchor.UpdateFrame = nil;
										end,
								min	=	8,
								max	=	18,
								step	=	1,
								disabled	=	function(info) return not beql.db.profile.AchievementTracker.Enable end,
							},

						MouseEvents = {
							type	=	'group',
							guiInline	=	true,
							name	=	L["Mouse Events"],
							order	=	12,
							args = {
								ShowTooltip = {
									type = 'toggle',
									order = 1,
									name = L['Show tooltip'],
									desc = L['Show tooltip on achievemet tracker'],
									get = function(info) return beql.db.profile.AchievementTracker.showtooltip end,
									set = function(info, newval) beql.db.profile.AchievementTracker.showtooltip = newval; beqlAchievementWatchAnchor.UpdateFrame = nil; end,
									disabled	=	function(info) return not beql:IsEnabled() or not beql.db.profile.AchievementTracker.Enable end,
								},
								ShowTooltipHint = {
									type = 'toggle',
									order = 2,
									name = L['Show hint tooltip'],
									desc = L['Show tooltip hint in the achievemet tracker tooltip'],
									get = function(info) return beql.db.profile.AchievementTracker.showtooltiphint end,
									set = function(info, newval) beql.db.profile.AchievementTracker.showtooltiphint = newval end,
									disabled	=	function(info) return not beql:IsEnabled() or not beql.db.profile.AchievementTracker.Enable end,
								},
								MouseLeftClick = {
									type = 'toggle',
									order = 3,
									name = L["Enable Left Click"],
									desc = L['Enable Left+Click to open achievement'],
									get = function(info) return beql.db.profile.AchievementTracker.clickleft end,
									set = function(info, newval) beql.db.profile.AchievementTracker.clickleft = newval beqlAchievementWatchAnchor.UpdateFrame = nil end,
									disabled	=	function(info) return not beql:IsEnabled() or not beql.db.profile.AchievementTracker.Enable end,
								},
								MouseRightClick = {
									type = 'toggle',
									order = 4,
									name = L["Enable Right Click"],
									desc = L['Enables Right-Click on the achievementtracker to remove a tracked acheivement'],
									get = function(info) return beql.db.profile.AchievementTracker.clickright end,
									set = function(info, newval) beql.db.profile.AchievementTracker.clickright = newval beqlAchievementWatchAnchor.UpdateFrame = nil end,
									disabled	=	function(info) return not beql:IsEnabled() or not beql.db.profile.AchievementTracker.Enable end,
								},
							},
						},

-- Colors on Achievementtracker

							Colors	=	{
								type	=	'group',
								guiInline	=	true,
								name	=	L["Colors"]..'',
								desc	=	L["Set tracker Colors"],
								order	=	14,
								args	=	{
									Background	=	{
										type	=	'toggle',
										order	=	1,
										--width	=	'full',
										name	=	L["Background"],
										desc	=	L["Use Background"],
										get	=	function(info) return beql.db.profile.AchievementTracker.showbg end,
										set	=	function(info, newval)
													beql.db.profile.AchievementTracker.showbg	=	newval
													beqlAchievementWatchAnchor.UpdateFrame = nil
												end,
										disabled	=	function(info) return not beql.db.profile.AchievementTracker.Enable end,
									},
									CustomBackground	=	{
										type	=	'toggle',
										order	=	2,
										--width	=	'full',
										name	=	L["Custom Background Color"],
										desc	=	L["Use custom color for background"],
										get	=	function(info) return beql.db.profile.AchievementTracker.ownbgcolor end,
										set	=	function(info, newval)
													beql.db.profile.AchievementTracker.ownbgcolor	=	newval
													beqlAchievementWatchAnchor.UpdateFrame = nil
												end,
										disabled	=	function(info) return not beql.db.profile.AchievementTracker.showbg  or not beql.db.profile.AchievementTracker.Enable end,
									},
									BackgroundColor	=	{
										type	=	'color',
										order	=	3,
										name	=	L["Background Color"],
										desc	=	L["Sets the Background Color"],
										get	=	function(info)
													local a	=	beql.db.profile.AchievementTracker.Colors.BgColor.a
													local b	=	beql.db.profile.AchievementTracker.Colors.BgColor.b
													local g	=	beql.db.profile.AchievementTracker.Colors.BgColor.g
													local r	=	beql.db.profile.AchievementTracker.Colors.BgColor.r
													return r, g, b, a
										end,
										set	=	function(info, r, g, b, a)
														beql.db.profile.AchievementTracker.Colors.BgColor	=	{
																		r	=	r,
																		g	=	g,
																		b	=	b,
																		a	=	a,
														}
													beqlAchievementWatchAnchor.UpdateFrame = nil
										end,
										hasAlpha	=	true,
										disabled	=	function(info) return not beql.db.profile.AchievementTracker.ownbgcolor  or not beql.db.profile.AchievementTracker.Enable end,
									},
									QuestTracker_BgBorder	=	{
										type	=	'color',
										order	=	4,
										name	=	L["Background Corner Color"],
										desc	=	L["Sets the Background Corner Color"],
										get	=	function(info)
													local a	=	beql.db.profile.AchievementTracker.Colors.BgCornerColor.a
													local b	=	beql.db.profile.AchievementTracker.Colors.BgCornerColor.b
													local g	=	beql.db.profile.AchievementTracker.Colors.BgCornerColor.g
													local r	=	beql.db.profile.AchievementTracker.Colors.BgCornerColor.r

													--return , , ,
													return r, g, b, a
										end,
										set	=	function(info, r, g, b, a)
														beql.db.profile.AchievementTracker.Colors.BgCornerColor	=	{
																		r	=	r,
																		g	=	g,
																		b	=	b,
																		a	=	a,
														}
													beqlAchievementWatchAnchor.UpdateFrame = nil
										end,
										hasAlpha	=	true,
										disabled	=	function(info) return not beql.db.profile.AchievementTracker.ownbgcolor  or not beql.db.profile.AchievementTracker.Enable end,
									},
									ATrackerAlpha	=	{
										type	=	'range',
										order	=	5,
										width	=	'full',
										name	=	L["Achievement Tracker Alpha"],
										desc	=	L["Sets the Alpha of the Achievement Tracker"],
										get	=	function(info) return beql.db.profile.AchievementTracker.alpha end,
										set	=	function(info, newval)
													beql.db.profile.AchievementTracker.alpha	=	newval
													beqlAchievementWatchAnchor.UpdateFrame = nil
												end,
										min	=	0,
										max	=	1,
										step	=	0.01,
										disabled	=	function(info) return not beql.db.profile.AchievementTracker.Enable end,
									},
								},
							},

					},
				},
		--]]	},
		}




-- add Sounds to Options

	local i	=	1
	for k, v in pairs (beql_sounds) do
		i	=	i +1
		MainOptionsTable.args.qlog.args.QuestCompletionSound.args[k]	=	{
			type	=	'toggle',
			order	=	i + 3,
			name	=	k,
			desc	=	k,
			get	=	function(info)
						if beql.db.profile.QuestLog.InfoSound ==	v then
								return true
						else
								return false
						end
						end,
			set	=	function(onfo, newval)
						if newval then
								beql.db.profile.QuestLog.InfoSound	=	v
						end
						PlaySoundFile(v)
						end,
			hidden	=	function(info) return not beql.db.profile.QuestLog.InfoOnQuestCompletion or (not beql:IsEnabled()) end,
		}
	end

	-- Copy Tooltip options to Tooltop menue
--	MainOptionsTable.args.tooltip.args.AchievementTracker = CopyTable(MainOptionsTable.args.achievement.args.MouseEvents)
--	MainOptionsTable.args.tooltip.args.AchievementTracker.order = -1
--	MainOptionsTable.args.tooltip.args.AchievementTracker.name = "ATracker TT test"
	
--[[
	for k,v in pairs(modularOptions) do
		MainOptionsTable.args[k]	=	(type(v) ==	"function") and v() or v
	end
--]]


end

local FrameNames = {
	beqlQuestWatchAnchor = "QuestTracker",
	beqlAchievementWatchAnchor = "AchievementTracker",
	--beqlTimerWatchAnchor = "TimeTracker",
	beqlQuestLogFrameAnchor = "QuestLog",
}

-- Save postion of a frame
function beql:SaveFramePosition(frame)
	local framename = FrameNames[frame:GetName()]
	if not framename then return end

	local posx, posy, point

	local x,y = frame:GetCenter()
	local hhalf = (x > UIParent:GetWidth()/2) and "RIGHT" or "LEFT"
	local vhalf = (y > UIParent:GetHeight()/2) and "TOP" or "BOTTOM"
	point = vhalf..hhalf

	posx = beql:round(hhalf == "LEFT" and (frame:GetLeft() * UIParent:GetScale()) or ((frame:GetLeft() - UIParent:GetWidth()) * UIParent:GetScale()) , 2)
	posy = beql:round(vhalf == "TOP" and ((frame:GetTop() - UIParent:GetHeight()) * UIParent:GetScale()) or (frame:GetTop() * UIParent:GetScale()) , 2)


	frame:ClearAllPoints()
	frame:SetPoint("TOPLEFT", UIParent, point, posx/UIParent:GetScale(), posy/UIParent:GetScale())

	beql.db.char.FramePositions[framename .. "_posx"] = posx;
	beql.db.char.FramePositions[framename .. "_posy"] = posy;
	beql.db.char.FramePositions[framename .. "_point"] = point;
end

-- restore position of a frame
function beql:RestoreFramePosition(frame)
	local framename = FrameNames[frame:GetName()]
	if not framename then return end

	local posx = beql.db.char.FramePositions[framename .. "_posx"]
	local posy = beql.db.char.FramePositions[framename .. "_posy"]
	local point = beql.db.char.FramePositions[framename .. "_point"]

	frame:ClearAllPoints()
	frame:SetPoint("TOPLEFT", UIParent, point, posx/UIParent:GetScale(), posy/UIParent:GetScale())
	frame.UIScale = UIParent:GetScale();

	beql:debugprint("Restore postion of frame: " .. framename)
end

-- open Optionsinterface for a cethegory
function beql:OpenBlizzardOption(option)
	if (not option) or (not beql.optionsFrames[option]) then
		assert(false, "Option " .. option .. " not found in options table!")
	end

	InterfaceOptionsFrame_OpenToCategory(beql.optionsFrames[option])
end

-- Internal for Compatiblity with other addons
-- #NODOC
function beql:Compatibility()
	do return end
-- CT-Mod does not block Watchframe anymore
--[[
	if IsAddOnLoaded("CT_Core") then
		-- CT_Core fix
		-- leaving there for old users
		beql.db.profile.disabled.lockedtracker = false
	else
		beql.db.profile.disabled.lockedtracker = false
	end--]]

--[[
	if IsAddOnLoaded("Mobmap") then
		beql.db.profile.disabled.markers = true
		MainOptionsTable.args.qtracker.args.MarkerOptions.desc = MainOptionsTable.args.qtracker.args.MarkerOptions.desc.." "..L[" |cffff0000Disabled by|r"].." |cffe0c000Mobmap|r"
		MainOptionsTable.args.qtracker.args.MarkerOptions.args.ShowObjectiveMarkers.desc = MainOptionsTable.args.qtracker.args.MarkerOptions.args.ShowObjectiveMarkers.desc.." "..L[" |cffff0000Disabled by|r"].." |cffe0c000Mobmap|r"
		if beql.db.profile.QuestTracker.ShowObjectiveMarkers then
			beql.db.profile.QuestTracker.ShowObjectiveMarkers = false
		end
	else
		beql.db.profile.disabled.markers = false
	end--]]

	if (QuestLogFrame_MidTextures) ~= nil then
		MainOptionsTable.args.qlogoption.args.SimpleQuestLog.desc = MainOptionsTable.args.qlogoption.args.SimpleQuestLog.desc.." "..L[" |cffff0000Disabled by|r"].." |cffe0c000FramesResized|r"
		beql.db.profile.disabled.style = true
		beql.db.profile.style = true
	else
		beql.db.profile.disabled.style = false
	end

	if not IsAddOnLoaded("FuBar") then
	--	beql.db.profile.fubar.FubarPosition = "MINIMAP"
	end
end

--
-- Improve LibQuixote2
--

local QuixoteObjectiveHandler = {
	pre = {},
	post= {},
}

-- Add a pre/post Handler for QUEST_LOG_UPDATE
function beqlQ:AddObjectiveHandler (func, handlertype)
	if handlertype == 'pre' then
		local numFunctions = #QuixoteObjectiveHandler.pre
		for i = 1, numFunctions do
			if ( QuixoteObjectiveHandler.pre[i] == func ) then
				return;
			end
		end

		tinsert(QuixoteObjectiveHandler.pre, func);
		return true;

	elseif handlertype == 'post' then
		local numFunctions = #QuixoteObjectiveHandler.post
		for i = 1, numFunctions do
			if ( QuixoteObjectiveHandler.post[i] == func ) then
				return;
			end
		end

		tinsert(QuixoteObjectiveHandler.post, func);
		return true;
	end
end

-- Remove a pre/post Handler for QUEST_LOG_UPDATE
function beqlQ:RemoveObjectiveHandler (func, handlertype)
	if handlertype == 'pre' then
		local numFunctions = #QuixoteObjectiveHandler.pre
		for i = 1, numFunctions do
			if ( QuixoteObjectiveHandler.pre[i] == func ) then
				tremove(QuixoteObjectiveHandler.pre, i);
				return true;
			end
		end
	elseif handlertype == 'post' then
		local numFunctions = #QuixoteObjectiveHandler.post
		for i = 1, numFunctions do
			if ( QuixoteObjectiveHandler.post[i] == func ) then
				tremove(QuixoteObjectiveHandler.post, i);
				return true;
			end
		end
	end
end

-- Check for BG'players
local beqlQ_Hook_PARTY_MEMBERS_CHANGED = beqlQ.frame.PARTY_MEMBERS_CHANGED
beqlQ.frame.PARTY_MEMBERS_CHANGED = function(...)
	if not UnitInBattleground("player") then
		beqlQ_Hook_PARTY_MEMBERS_CHANGED(...)
	end
end

local update_is_running
function beqlQ:QUEST_LOG_UPDATE()
	if update_is_running then
		return beqlQ.frame:Show()
	end
	update_is_running = true

	-- call pre scripts
	for i= 1, #QuixoteObjectiveHandler.pre do
		QuixoteObjectiveHandler.pre[i]()
	end

	beqlQ.frame.QUEST_LOG_UPDATE();

	-- call post scripts
	for i= 1, #QuixoteObjectiveHandler.post do
		QuixoteObjectiveHandler.post[i]()
	end

	update_is_running = nil
end

beqlQ.frame:SetScript("OnEvent", function(this, event, ...)
	if event ~= "QUEST_LOG_UPDATE" then
		this[event](beqlQ, ...)
	else
		beqlQ:QUEST_LOG_UPDATE()
	end
end)
beqlQ.frame:SetScript("OnUpdate", function(this, timeSinceLast)
	this.timeSoFar = this.timeSoFar and this.timeSoFar or 0 + timeSinceLast
	if this.timeSoFar > 0.1 then
		this.timeSoFar = 0
		this:Hide()
		beqlQ:QUEST_LOG_UPDATE()
	end
end)

-- Tracker List/Symbol and Soundtable
BEQL_TrackerLists = {
	[0] = {
		[0] = "1",
		[1] = "2",
		[2] = "3",
		[3] = "4",
		[4] = "5",
		[5] = "6",
		[6] = "7",
		[7] = "8",
		[8] = "9",
		[9] = "0",
	},
	[1] = {
		[0] = "a",
		[1] = "b",
		[2] = "c",
		[3] = "d",
		[4] = "e",
		[5] = "f",
		[6] = "g",
		[7] = "h",
		[8] = "i",
		[9] = "j",
	},
	[2] = {
		[0] = "A",
		[1] = "B",
		[2] = "C",
		[3] = "D",
		[4] = "E",
		[5] = "F",
		[6] = "G",
		[7] = "H",
		[8] = "I",
		[9] = "J",
	},
	[3] = {
		[0] = "I",
		[1] = "II",
		[2] = "III",
		[3] = "IV",
		[4] = "V",
		[5] = "VI",
		[6] = "VII",
		[7] = "VIII",
		[8] = "IX",
		[9] = "X",
	},
}

BEQL_TrackerSymbols = {
	[0] = "-",
	[1] = "+",
	[2] = "@",
	[3] = ">",
}

beql_sounds = {
	["Exploration"] = "Sound\\Interface\\GnomeExploration.wav",
	["HordeVictory"] = "Sound\\Interface\\PVPVictoryHordeMono.wav",
	["AllianceVictory"] = "Sound\\Interface\\PVPVictoryAllianceMono.wav",
	["FlagCaptured1"] = "Sound\\Interface\\PVPFlagCapturedmono.wav",
	["FlagCaptured2"] = "Sound\\Interface\\PVPFlagCapturedHordemono.wav",
	["RaidWarning"] = "Sound\\Interface\\RaidWarning.wav",
	["ReadyCheck"] = "Sound\\Interface\\ReadyCheck.wav",
	["LevelUp1"] = "Sound\\Interface\\LevelUp.wav",
	["LevelUp2"] = "Sound\\Interface\\levelup2.wav",
	["Message"] = "Sound\\Interface\\iTellMessage.wav",
	["Cow"] = "Sound\\Creature\\Cow\\CowDeath.wav",
	["WorkComplete"] = "Sound\\Creature\\Peon\\PeonBuildingComplete1.wav",
}

--- EOF ---