if IsAddOnLoaded("Titan") and not IsAddOnLoaded("FuBar") then
	-- Do not load if Titanbar is loaded
	print("No FuBar found or TitanPanel loaded, quiting FubarAddon");
	return
end

local beql = LibStub("AceAddon-3.0"):GetAddon("beql")

if not beql.InitDB then return end
if not Rock then return end

local L = LibStub("AceLocale-3.0"):GetLocale("beql")
beqlfu = Rock:NewAddon("beqlFu", "LibFuBarPlugin-3.0", "LibRockDB-1.0")
local GameTooltip = GameTooltip
local AceConfigReg	=	LibStub("AceConfigRegistry-3.0")

beqlfu:SetFuBarOption('hasIcon', true)
beqlfu:SetFuBarOption('iconPath', "Interface\\Icons\\INV_Letter_03")
beqlfu:SetFuBarOption('title', "bEQL")
beqlfu:SetFuBarOption('name', "beql")
beqlfu:SetFuBarOption('revision', beql.revision)
beqlfu:SetFuBarOption('cannotDetachTooltip', true)
beqlfu:SetFuBarOption('overrideMenu', true)
beqlfu:SetFuBarOption('independentProfile', true)
beqlfu:SetFuBarOption('hideWithoutStandby', true)

-- Fubar Options

local	beqlfubar	=	{
		type	=	'group',
		order	=	6,
		name	=	L["FubarPlugin Config"],
		desc	=	L["FubarPlugin Config"],
		args	=	{
			hideplugin=	{
				type	=	'toggle',
				order	=	1,
				width	=	'full',
				name	=	L["Hide plugin"],
				desc	=	L["Hide the plugin from the panel or minimap, leaving the addon running."],
				get	=	function(info) return beql.db.profile.fubar.HidePlugin end,
				set	=	function(info, newval)
									beql.db.profile.fubar.HidePlugin	=	newval;
									if newval then
										beqlfu:Hide()
									else
										if beqlfu:IsFuBarMinimapAttached() or not FuBar then
											beqlfu:Show()
										else
											if not beql.db.profile.fubar.PanelID then
												beql.db.profile.fubar.PanelID = 1
											end
											FuBar:ShowPlugin(beqlfu, beql.db.profile.fubar.PanelID)
										end
									end

									--beqlfu:UpdateFuBarPluginSettings()
							end,
			},
			headline	=	{
				type	=	'header',
				order	=	2,
				name	=	"",
			},
			showIcon	=	{
				type	=	'toggle',
				order	=	3,
				width	=	'full',
				name	=	L["Show icon"],
				desc	=	L["Show the plugins icon on the panel."],
				get	=	function(info) return beql.db.profile.fubar.ShowIcon end,
				set	=	function(info, newval)
						beql.db.profile.fubar.ShowIcon = newval

						if (beql.db.profile.fubar.ShowIcon == true and not beqlfu:IsFuBarIconShown())
							or (beql.db.profile.fubar.ShowIcon == false and beqlfu:IsFuBarIconShown())
								then
									beqlfu:ToggleFuBarIconShown()
						end
						if beqlfu:IsFuBarTextShown() then
							beqlfu:SetFuBarText(select(2,GetNumQuestLogEntries()).."/25")
						end
					end,
				disabled	=	function(info) return beql.db.profile.fubar.HidePlugin or not beql.db.profile.fubar.ShowText end,
				hidden = function(info) return not IsAddOnLoaded("FuBar") end,
			},
			showText	=	{
				type	=	'toggle',
				order	=	4,
				width	=	'full',
				name	=	L["Show text"],
				desc	=	L["Show the plugins text on the panel."],
				get	=	function(info) return beql.db.profile.fubar.ShowText end,
				set	=	function(info, newval)
						beql.db.profile.fubar.ShowText = newval;

						if (beql.db.profile.fubar.ShowText == true and not beqlfu:IsFuBarTextShown())
							or (beql.db.profile.fubar.ShowText == false and beqlfu:IsFuBarTextShown())
								then
									beqlfu:ToggleFuBarTextShown()
						end
						if beqlfu:IsFuBarTextShown() then
							beqlfu:SetFuBarText(select(2,GetNumQuestLogEntries()).."/25")
						end
					end,
				disabled	=	function(info) return beql.db.profile.fubar.HidePlugin or not beql.db.profile.fubar.ShowIcon end,
				hidden = function(info) return not IsAddOnLoaded("FuBar") end,
			},
			showcoloredText	=	{
				type	=	'toggle',
				order	=	5,
				width	=	'full',
				name	=	L["Show colored text"],
				desc	=	L["Allow the plugin to color its text."],
				get	=	function(info) return beql.db.profile.fubar.ShowColoredText end,
				set	=	function(info, newval)
						beql.db.profile.fubar.ShowColoredText = newval
						if (beql.db.profile.fubar.ShowColoredText == true and not beqlfu:IsFuBarTextColored())
							or (beql.db.profile.fubar.ShowColoredText == false and beqlfu:IsFuBarTextColored())
								then
									beqlfu:ToggleFuBarTextColored()
						end
						if beqlfu:IsFuBarTextShown() then
							beqlfu:SetFuBarText(select(2,GetNumQuestLogEntries()).."/25")
						end
				end,
				disabled	=	function(info) return beql.db.profile.fubar.HidePlugin or not beql.db.profile.fubar.ShowText end,
				hidden = function(info) return not IsAddOnLoaded("FuBar") end,
			},
			ShowTooltip	=	{
				type	=	'toggle',
				order	=	6,
				width	=	'full',
				name	=	L["Show FuBar Tooltip"],--L["Attach to minimap"],
				desc	=	L["Shows the tooltip on mousover this plugin"],--L["Attach the plugin to the minimap instead of the panel."],
				get	=	function(info) return beql.db.profile.fubar.ShowTooltip end,
				set	=	function(info, newval) beql.db.profile.fubar.ShowTooltip = newval end,
				disabled	=	function(info) return beql.db.profile.fubar.HidePlugin  end,
			},
			headline2	=	{
				type	=	'header',
				order	=	7,
				name	=	"",
			},
			position	=	{
				type	=	'select',
				order	=	8,
--							width	=	'full',
				name	=	L["Position"],
				desc	=	L["Position the plugin on the panel."],
				values	=	{LEFT	=	L["Left"], CENTER	=	L["Center"], RIGHT	=	L["Right"], MINIMAP = L["Minimap"]},
				get	=	function(info) return beql.db.profile.fubar.FubarPosition end,
				set	=	function(info, newval)
						beql.db.profile.fubar.FubarPosition = newval
						if newval == 'MINIMAP' and not beqlfu:IsFuBarMinimapAttached() then
							beqlfu:ToggleFuBarMinimapAttached()
						elseif newval ~= 'MINIMAP' and FuBar then
							if beqlfu:IsFuBarMinimapAttached() then
								FuBar:ShowPlugin(beqlfu, beql.db.profile.fubar.PanelID or 1)
							end

							local panel = FuBar:GetPanel(beql.db.profile.fubar.PanelID)
							if panel and panel:HasPlugin(beqlfu) and panel:GetPluginSide(beqlfu) ~= newval then
								panel:SetPluginSide(beqlfu, newval)
							end

						else
							beql:debugprint("Error handle Plugin position")
						end

					end,
				disabled	=	function(info) return beql.db.profile.fubar.HidePlugin or not IsAddOnLoaded("FuBar") end,
			},
			MinimapPosition	=	{
				type	=	'range',
				order	=	10,
				width	=	'full',
				min	=	1,
				max	=	360,
				step	=	1,
				name	=	L["Minimap position"],
				desc	=	L["Minimap position"],
				get	=	function(info) return beql.db.profile.fubar.MinimapPosition end,
				set	=	function(info, newval)
					beql.db.profile.fubar.MinimapPosition	=	newval
					beqlfu.db.profile.minimapPosition = newval
					beqlfu:GetPanel():ReadjustLocation(beqlfu);
				end,
				disabled	=	function(info) return beql.db.profile.fubar.FubarPosition ~= "MINIMAP" or beql.db.profile.fubar.HidePlugin end,
			},
		},
	},


-- this db is only a dummy, real data will saved in beql.db.profile.fubar
-- this dummy is needed to access text and icon functions
beqlfu:SetDatabase("beqlFuDB")

-- create a frame to handle QUEST_LOG_UPDATE event
local f

function beqlfu:OnInitialize()
	beqlfu:SetFuBarText(select(2,GetNumQuestLogEntries()).."/25")

	-- make a update script
	f = CreateFrame("Frame", "beqlFu_EventFrame")
	f:RegisterEvent("QUEST_LOG_UPDATE")
	f:SetScript("OnEvent", function(self, event)
		if event == 'QUEST_LOG_UPDATE' then
			beqlfu:SetFuBarText(select(2,GetNumQuestLogEntries()).."/25")
		end
	end)

	-- we need DB acces, but beql doesn load it -> let beqlfu load it
	if not beql.db then
		--beql:InitDB()
	end

	if not beql.db then
		assert(false, "error load DB for beql")
	end

	beqlfu:SetFuBarOption("defaultPosition", beql.db.profile.fubar.FubarPosition)
	beqlfu:SetFuBarOption("defaultMinimapPosition", beql.db.profile.fubar.MinimapPosition)



	if FuBar then
		hooksecurefunc(FuBar,"Plugin_StopDrag", function(self, plugin)
			-- get the panel id for Pluginpanel
			if not plugin or plugin:GetName() ~= 'beqlFu' then
				-- no valid plugin
				return
			end

			if beql.db then
				-- DB is loaded
				beql.db.profile.fubar.PanelID = plugin:GetPanel().id
			end
		end)
	end
end


function beqlfu:OnEnable()
	-- correct panel position if needed
	if beql.db.profile.fubar.FubarPosition ~= 'MINIMAP' and FuBar then
		FuBar:ShowPlugin(beqlfu, beql.db.profile.fubar.PanelID or 1)
	end

	-- manage position on the panel
	if (not beqlfu:IsFuBarMinimapAttached()) and FuBar then
		local panel = FuBar:GetPanel(beql.db.profile.fubar.PanelID)
		if panel and panel:HasPlugin(beqlfu) then
			panel:SetPluginSide(beqlfu, beql.db.profile.fubar.FubarPosition)
		end
	end

	-- manage text
	if (beql.db.profile.fubar.ShowText == true and not beqlfu:IsFuBarTextShown())
		or (beql.db.profile.fubar.ShowText == false and beqlfu:IsFuBarTextShown())
			then
				beqlfu:ToggleFuBarTextShown()
	end
	-- manage colored text
	if (beql.db.profile.fubar.ShowColoredText == true and not beqlfu:IsFuBarTextColored())
		or (beql.db.profile.fubar.ShowColoredText == false and beqlfu:IsFuBarTextColored())
			then
				beqlfu:ToggleFuBarTextColored()
	end
	-- manage Icon
	if (beql.db.profile.fubar.ShowIcon == true and not beqlfu:IsFuBarIconShown())
		or (beql.db.profile.fubar.ShowIcon == false and beqlfu:IsFuBarIconShown())
			then
				beqlfu:ToggleFuBarIconShown()
	end

	beql:debugprint("enable beqlfu")
end

local beqlfu_hook_OnDragStop_minimap

function beqlfu:UpdateFuBarPlugin()

	if not beqlfu_hook_OnDragStop_minimap then
		-- add function to minimap icon dragging, to get the icon position
		local MinimapButton = _G[beqlfu:GetFrame():GetName() ..  "MinimapButton"]
		if MinimapButton and type(MinimapButton:GetScript("OnDragStop")) == 'function' then
			MinimapButton:HookScript("OnDragStop", function()
				beql.db.profile.fubar.MinimapPosition = beql:round(beqlfu.db.profile.minimapPosition)
			end)
			beqlfu_hook_OnDragStop_minimap = true
		end
	end

end

function beqlfu:UpdateFuBarTooltip()
	if not beql.db.profile.fubar.ShowTooltip then
		return
	end

	if beqlfu:IsFuBarMinimapAttached() then
		GameTooltip:SetOwner(_G[beqlfu:GetFrame():GetName() .. "MinimapButton"],"ANCHOR_BOTTOMLEFT",30,0)
	else
		GameTooltip:SetOwner(beqlfu:GetFrame(),"ANCHOR_BOTTOM",0,0)
	end

	local questEntries = select(2, GetNumQuestLogEntries())
	local numfinished = select(2, beqlQ:GetNumQuests())
	beqlfu:SetFuBarText(questEntries.."/25")

	-- build Gametooltip

	-- title
	GameTooltip:AddLine(beqlfu:GetName())
	GameTooltip:AddLine(" ") -- spacer

	-- num quests
	GameTooltip:AddDoubleLine(L["|cffffffffQuests|r"],questEntries)

	-- num watched quests
	GameTooltip:AddDoubleLine(L["|cffff8000Tracked Quests|r"],GetNumQuestWatches())

	-- num completed quests
	GameTooltip:AddDoubleLine(L["|cff00d000Completed Quests|r"], numfinished)
	GameTooltip:AddLine(" ") -- spacer

	-- tooltip hint
	GameTooltip:AddLine(L["|cffeda55fClick|r to open Quest Log and |cffeda55fShift+Click|r to open Waterfall config"] .. L[". |cffeda55fRightclick|r to open FuBar config."],0,1,0,true)

	GameTooltip:Show()
end

function beqlfu:OpenMenu()
	-- show fubar config instead of a menu
	beql:OpenBlizzardOption("fubar")
end

function beqlfu:OnFuBarClick()
	if IsShiftKeyDown() then
		beql:OpenBlizzardOption("main")
	else
		ToggleFrame(QuestLogFrame);
	end
end

-- EOF --