-- (c) Xavier Ferrair Peir, aka Mortcia of Outland EU - Horde
-- no code in this file may be used in other works without expressed permission
local bg = CreateFrame("Frame")

	--bg:RegisterEvent("CHAT_MSG_SAY")
	--bg:RegisterEvent("PLAYER_ENTERING_WORLD")
	bg:RegisterEvent("UPDATE_BATTLEFIELD_STATUS")
	--bg:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	
	bg:SetScript("OnEvent", function(bg, event, msg)

		local winner = GetBattlefieldWinner();
		local isArena, isRegistered = IsActiveBattlefieldArena();
		local status, mapName = GetBattlefieldStatus(1);
		local fraction = UnitFactionGroup("player")
		local iswinner = (fraction == "Horde" and winner == 0) or (fraction == "Alliance" and winner == 1) -- Horde = 0, Alliance = 1	
		local numScores = GetNumBattlefieldScores()
	
	for n = 1, numScores do
		local name, killingBlows, honorableKills, deaths, honorGained, faction, race, class, classToken, damageDone, healingDone, bgRating, ratingChange = GetBattlefieldScore(n)
		-- Battleground normal
		if ( name ) and not ( isArena ) and ( ratingChange == 0) then
			if event == "UPDATE_BATTLEFIELD_STATUS" and ( name == UnitName("player") ) and iswinner and status == "active" then
				SendChatMessage("won " ..mapName.. " with " ..honorableKills.. " hks", "GUILD", NIL);
			end
		end
		-- Battleground rated
		if ( name ) and not ( isArena ) and not ( ratingChange == 0) then
			if event == "UPDATE_BATTLEFIELD_STATUS" and ( name == UnitName("player") ) and iswinner and status == "active" then
				local actualRating = (bgRating + ratingChange)
				SendChatMessage("won " ..mapName.. " @ " ..actualRating.. "", "OFFICER", NIL);
			end
		end
	end

	--for a = 1, MAX_ARENA_TEAMS  do 
	--	local name, killingBlows, honorableKills, deaths, honorGained, faction, race, class, classToken, damageDone, healingDone, bgRating, ratingChange = GetBattlefieldScore(1)
	--	local teamName, teamSize, teamRating, weekPlayed, weekWins, seasonPlayed, seasonWins, playerPlayed, seasonPlayerPlayed, teamRank, playerRating = GetArenaTeam(1)
	--	if ( name ) and ( isArena ) then
	--		if event == "UPDATE_BATTLEFIELD_STATUS" and ( name == UnitName("player") ) and iswinner and status == "active" then
				-- Arena type checker
	--			SendChatMessage("won " ..mapName.. " @ " ..teamRating.. "", "OFFICER", NIL);
	--		end
	--	end
	--end
end)