--[[
Interface: 4.3.0
Title: LibBalancePowerTracker
Version: 1.0.13
Author: Kurohoshi (EU-Minahonda)

--INFO
	LibBalancePowerTracker is a library designed to provide the foresee energy feature to Balance Druids.
	CPU is only used when required, so the CPU usage is very low.
	
	FORESEE ENERGY:
	Foresee Energy is a feature that analizes the spells you have cast and/or you are casting but are yet to land and computes 
	the energy sum of them. This allows the library to distinguish between two kinds of energy and Eclipse direction: One real, 
	the one you have at the moment and other virtual, the one you'll have when all flying spells and the spell you are casting land.
	Foresee Energy works assuming the following: 
		-You're hit capped (All your spells will land).
		-You're not going to proc Euphoria (2x energy gain).
			If you proc it, it will update immediately, this only means you will reach Eclipse earlier than the library predicted the moment 
			before the Eupforia proc. You can never get an Euphoria proc that push you into Eclipse, so Eclipse procs are predicted accurately. 
	All the features with the 'virtual' tag (virtual Energy, virtual Eclipse ...) rely on Foresee Energy.
	
--API
	There are 5 variables related to Eclipse energy used in this addon:
		energy: The energy you have at the moment. Int = [-100,100]
		direction: The direction of the arrow. String = {"none","sun","moon"}
		virtual_energy: The energy you will have when the spell you're casting and all the flying spells land. Int = [-100,100]
		virtual_direction: The direction of the arrow when the spell you're casting and all the flying spells land. String = {"none","sun","moon"}
		virtual_eclipse: -100 if lunar, 100 if solar, false otherwise.

	FUNCTIONS:

	id = LibBalancePowerTracker:RegisterFullCallback(function(energy, direction, virtual_energy, virtual_direction, virtual_eclipse))
	These callbacks will be fired when there is a change in one of the Eclipse energy variables, usually twice per WR/SF/SS.
	NOTE: When registering a callback, that callback will be fired once.
		
	id = LibBalancePowerTracker:RegisterReducedCallback(function(energy, direction))
	These callbacks will be fired when there is a change ONLY in energy or direction, usually once per WR/SF/SS.
	NOTE: When registering a callback, that callback will be fired once.
	
	id = LibBalancePowerTracker:RegisterEclipseProbCallback(function(value))
	These callbacks will be fired every time value changes, value is the probability of Eclipse, taking into consideration euphoria and miss chance, 
	negative for Lunar Eclipse, positive for Solar Eclipse.
	NOTE: When registering a callback, that callback will be fired once.
	
	id,EnergyFunction = LibBalancePowerTracker:RegisterStatCallback(callback())
	Callback will be fired every time EnergyFunction changes:
		energy, direction, virtual_energy, virtual_direction, virtual_eclipse = EnergyFunction(value) 
		Note: In this case, virtual_energy, virtual_direction and virtual_eclipse are special, EnergyFunction means:
		 "You have <value*100>% chance of having at least <select(3,EnergyFunction(value))> energy when all spells land, considering euphoria & miss chance." (the same goes the direction and virtual_eclipse)
	
	failed = LibBalancePowerTracker:UnregisterCallback(id)
	Tries to unregister the callback with identifier id (id is returned only when you register the callback).
	
	energy, direction, virtual_energy, virtual_direction, virtual_eclipse = LibBalancePowerTracker:GetEclipseEnergyInfo()
	Gets the current state of the variables.
	
	value = LibBalancePowerTracker:GetEclipseChance()
	Gets the current Eclipse chance, checking Euphoria and miss chance of spells.
	
	EnergyFunction = LibBalancePowerTracker:GetEnergyFunction()	
		energy, direction, virtual_energy, virtual_direction, virtual_eclipse = EnergyFunction(value) 
		Note: In this case, virtual_energy, virtual_direction and virtual_eclipse are special, EnergyFunction means:
		 "You have <value*100>% chance of having at least <select(3,EnergyFunction(value))> energy when all spells land, considering euphoria & miss chance." (the same goes the direction and virtual_eclipse)
		
	version,subversion,revision = LibBalancePowerTracker:GetVersion()
		Gets the current working version of the library.	

--Must have an eye on this:
	AoE silence ------------------------------ Working in 4.1
	Vanish/Shadowmeld when spell is flying --- Working in 4.1
	
	A 40m y 41% celeridad llega antes el SF que el WR (se elimina correctamente, pero da problemas con la prediccin del Eclipse) 
	
--CHANGELOG
v 1.0.13 Renamed SpellQueueADT to LBPT_SpellQueueADT

v 1.0.12 Changes in UnitByName(Name)
		 Changed _Sent to account for spell number
		 Fixed not reseting eclipse direction when entering arena (this was fixed in 4.3 by Blizz)
		 PVP 4p bug workaround isn't needed anymore
		 Increased SS and WR autodelete timers to 5s (so it works at max distance on Ragnaros figth)
		 Updated SpellQueueADT-1.1
		 Memory usage no longer increases in combat (Memory leak fixed)
		 Added support to UNIT_DESTROYED event, but commented till it's necessary
		 .toc updated

v 1.0.11 Updated code to handle Euphoria & 4T12 bonus hotfix

v 1.0.10 Simplified some code
		 Sync even when not Balance
		 Checking for tier12 even when not Balance

v 1.0.9 Increased WR and SS autodelete timers by 1s, SF's by .5s
		Fixed advanced settings bugs
		Eclipse stat rewritten (less CPU used)

v 1.0.8 SpellQueueADT updated

v 1.0.7 Tier12 fully supported
		Handling specialWR now here
		Updated SpellQueueADT
		Some code improvements
		Changed reachEnd to virtualEclipse

v 1.0.6	WoW 4.2 fix
		SF autodelete timer increased by .5s
		Updated SpellQueueADT-1.1
		Interrupted spell bug fixed
		Fixed DoTs' energy for 4.2
		Early support for 4t12 bonus
		Included tier set
		Removed some unnecessary functions (RmoveFirsto0...)
		Minor bug in Advanced settings fixed.
		Minor bug causing to fire two callbacks when crossing 0 fixed.

v 1.0.5 Moved UpdateEuphoria into ReCheck
		4.1 fix
		Now shouldnt load when not a druid succeesfully
		Future log compatibility functions
		The mark shouldnt 'dance' at 0,100 and -100 energy anymore.
		Extra functions to avoid letting a spell remain in the queue when it must be erased.
		
v 1.0.4 Changed Euphoria chance based on Hamlet's findings on www.elitistjerks.com 
		Added target of target to the unit check.
		Fixed casting glyph of SS counting as casting SS
		Use spellId instead of names
		
v 1.0.3 Changed to use propperly SpellQueueADT 1.1.2
		Now erases flying spells when teleporting.
		FEATURE: Eclipse chance calculation.
		FEATURE: Energy statistically calculation.

v 1.0.2 Fixed sometimes not fetching the direction properly. 
		Fixed PvP bonus

v 1.0.1 Reduced the number of callbacks fired.

v 1.0.0 Release
--]]

local version = {1,0,13};

if (LibBalancePowerTracker and LibBalancePowerTracker.CompareVersion and LibBalancePowerTracker:CompareVersion(version)) then return; end;

--Initialize Global Lib
LibBalancePowerTracker = {};
function LibBalancePowerTracker:CompareVersion(versionTable) 
	for i,v in ipairs(versionTable) do
		if version[i] < v then
			return false;
		end;
	end;
	return true;
end;


--Locals
----GLOBALS TO LOCALS-------------------------------------------------------------------
local GetEclipseDirection,UnitPower,SPELL_FAILED_NOT_READY,SPELL_FAILED_SPELL_IN_PROGRESS = GetEclipseDirection,UnitPower,SPELL_FAILED_NOT_READY,SPELL_FAILED_SPELL_IN_PROGRESS;
local UnitLevel,UnitGUID,GetCombatRatingBonus,UnitIsPlayer,UnitBuff,GetTalentInfo,GetSpellInfo = UnitLevel,UnitGUID,GetCombatRatingBonus,UnitIsPlayer,UnitBuff,GetTalentInfo,GetSpellInfo
local GetInventoryItemID,UnitName,abs,pairs,ipairs,tonumber,GetSpellCooldown,GetTime = GetInventoryItemID,UnitName,abs,pairs,ipairs,tonumber,GetSpellCooldown,GetTime
----DATA--------------------------------------------------------------------------------
local LBPT = {};
------OPTIONS---------------------------------------------------------------------------
local options = {
	enabled = true,
	foresee = true,
}
local callBacksActivated = {
	reduced = false,
	full = false,
	eclipseProb = false,
	stat = false,
}
------VARS------------------------------------------------------------------------------
local vars = {
	isDruid = nil,
	isBalance = nil,
	changedState = false,
	computedEnergy=0,
	computedVirtualEnergy = 0,
	computedVirtualEclipse = false,
	direction = "none",
	vDirection = "none",
	spellQ = LBPT_SpellQueueADT:New(),

	energyThirds = 0,
	
	ecTime = 0,
	eclipse = false,
	
	unitLevelSent = {},
	unitIsPCSent = {},
	destGUID = {},
	euphoria = 0.12,
	wayTable = {},
	probTable = {
		firstSpell = nil,
		sun  = {},
		none = {},
		moon = {},
	},
	max_levels = 5, --Nmero mximo de hechizos que se calculan, consumo mximo aumenta de forma exponencial, 3^5 me parece un buen lmite
	inverseCumulativeDistributionFunction = function() return 0,"none",0,"none",false; end,
	eclipseProb= 0,
	
	tiers = {
		[1]=false,--head
		[3]=false,--shoulders
		[5]=false,--chest
		[7]=false,--trousers
		[10]=false,--gloves
		tierPieceCount = {},
	}
}
vars.spellQ_IteratorNext,vars.spellQ_IteratorReset = vars.spellQ:iterator();
setmetatable(vars.tiers.tierPieceCount, {__index = function () return 0 	end})
setmetatable(vars.unitLevelSent,		{__index = function () return UnitLevel("player") end})
setmetatable(vars.unitIsPCSent, 		{__index = function () return true 	end})
local playerGUID,lastCallback,callbacks,reducedCallbacks,eclipseProbCallbacks,statCallbacks,elements = false,0,{},{},{},{},0;
------STATIC----------------------------------------------------------------------------
local missTablePvE = {
	[-4] = 1,
	[-3] = .99,
	[-2] = .98,
	[-1] = .97,
	[0] = .96,
	[1] = .95,
	[2] = .94,
	[3]	= .83,
	[4]	= .72,
	[5]	= .61,
};
local missTablePvP = {
	[-4]= 1,
	[-3]= .99,
	[-2]= .98,
	[-1]= .97,
	[0]	= .96,
	[1]	= .95,
	[2]	= .94,
	[3]	= .87,
	[4]	= .80,
	[5]	= .73,
};
local data ={
	WR  = {name = GetSpellInfo(5176) ,energy = 13,spellId=5176 }, -- name & energy Wrath
	SF  = {name = GetSpellInfo(2912) ,energy = 20,spellId=2912 }, -- name & energy Starfire
	SS  = {name = GetSpellInfo(78674),energy = 15,spellId=78674}, -- name StarSurge
	EE  = {spellId = 89265}, -- Eclipse Energy spell
	SSE = {spellId = 86605}, --Starsurge Energy spell
	SuddenEclipse = {spellId = 95746}, --PvP energy proc
	LunarEclipse  = {spellId = 48518}, -- Lunar eclipse buff id
	SolarEclipse  = {spellId = 48517}, -- Solar eclipse buff id
	balanceTiersItemId ={
		[12]={
			[1]={ [71108]="n",[71497]="h"},--head
			[3]={ [71111]="n",[71500]="h"},--shoulders
			[5]={ [71110]="n",[71499]="h"},--chest
			[7]={ [71109]="n",[71498]="h"},--trousers
			[10]={[71107]="n",[71496]="h"},--gloves
			bonus4p = true,
		},
	}
};
----TIMERS-------------------------------------------------------------------------------
local timers={holder 	= CreateFrame("Frame",nil,UIParent);}
timers.broadcastTier 	= CreateFrame("Cooldown",nil,timers.holder)
timers.delayedUpdate 	= CreateFrame("Cooldown",nil,timers.holder)
timers[data.WR.spellId] = {seconds=4,timer=CreateFrame("Cooldown",nil,timers.holder)} --2.2s aprox vs normal enemy
timers[data.SS.spellId] = {seconds=4,timer=CreateFrame("Cooldown",nil,timers.holder)} --2.2s aprox vs normal enemy
timers[data.SF.spellId] = {seconds=1,timer=CreateFrame("Cooldown",nil,timers.holder)} --0.6s aprox
for k,v in pairs(timers) do	if tonumber(k)~= nil then v.timer:SetScript("OnHide",function() if vars.spellQ:RemoveAllSpellsById(k) then --[[print("Spell: "..select(1,GetSpellInfo(k)).." timed out")]] LBPT.ChangedState() end end)	end end
----FRAME--------------------------------------------------------------------------------
local frame = CreateFrame("Frame",nil,UIParent); --(Used for a workaround)
-----------------------------------------------------------------------------------------

--ENERGY FUNCTIONS-----------------------------------------------------------------------
local actualizarEnergiaWR = {
	[-13] = function(energyThirds) if energyThirds==2 then return 1 else return (energyThirds + 1)%3	end end,
	[-14] = function() return 0 end,
	[-26] = function() return 2 end,
	[-27] = function(energyThirds) if energyThirds==0 then return 0 else return (energyThirds + 2)%3	end end,
}
local nextWRenergy = { --energyThirds,
	[0] = -13,
	[1] = -13,
	[2] = -14,
}
local energyFromSpell={
	[data.SF.spellId]={
		moon	= function(_,energyThirds) return              0,energyThirds end,
		sun		= function(_,energyThirds) return data.SF.energy,energyThirds end,
		none 	= function(_,energyThirds) return data.SF.energy,energyThirds end,
	},
	[data.WR.spellId]={
		moon 	= function(_,energyThirds) 
						local n = nextWRenergy[energyThirds];
						return n,actualizarEnergiaWR[n](energyThirds); 
				end,
		sun 	= function(_,energyThirds) 
						local n = nextWRenergy[energyThirds];
						return 0,actualizarEnergiaWR[n](energyThirds); 
				end,
		none 	= function(_,energyThirds) 
						local n = nextWRenergy[energyThirds];
						return n,actualizarEnergiaWR[n](energyThirds); 
				end,
	},
	[data.SS.spellId]={
		moon 	= function(_,energyThirds) 	return -data.SS.energy,energyThirds; end,
		sun 	= function(_,energyThirds) 	return  data.SS.energy,energyThirds; end,
		none 	= function(e,energyThirds) 	if e<0 then return -data.SS.energy,energyThirds; else return data.SS.energy,energyThirds; end end,
	},
}
local doubleEnergyFromSpell={
	[data.SF.spellId]={
		moon	= function(_,energyThirds) return                0,energyThirds end,
		sun		= function(_,energyThirds) return 2*data.SF.energy,energyThirds end,
		none 	= function(_,energyThirds) return 2*data.SF.energy,energyThirds end,
	},
	[data.WR.spellId]={
		moon 	= function(_,energyThirds) 
						local n1 = nextWRenergy[energyThirds];
						local e1 = actualizarEnergiaWR[n1](energyThirds); 
						local n2 = nextWRenergy[e1];

						return n1+n2,actualizarEnergiaWR[n2](e1); 
				end,
		sun 	= function(_,energyThirds) 
						local n1 = nextWRenergy[energyThirds];
						local e1 = actualizarEnergiaWR[n1](energyThirds); 
						local n2 = nextWRenergy[e1];

						return 0,actualizarEnergiaWR[n2](e1); 
				end,
		none 	= function(_,energyThirds) 
						local n1 = nextWRenergy[energyThirds];
						local e1 = actualizarEnergiaWR[n1](energyThirds); 
						local n2 = nextWRenergy[e1];

						return n1+n2,actualizarEnergiaWR[n2](e1); 
				end,
	},
	[data.SS.spellId]={
		moon 	= function(_,energyThirds) 	return -data.SS.energy,energyThirds; end,
		sun 	= function(_,energyThirds) 	return  data.SS.energy,energyThirds; end,
		none 	= function(e,energyThirds) 	if e<0 then return -data.SS.energy,energyThirds; else return data.SS.energy,energyThirds; end end,
	},
}
local function EnergyFromSpell(id,direction,energy,energyThirds,euphoria,eclipse) --returns energy from spellid, direction, energy & special
	if euphoria and not eclipse then
		return doubleEnergyFromSpell[id][direction](energy,energyThirds);
	else
		return energyFromSpell[id][direction](energy,energyThirds,eclipse);
	end
end
-----------------------------------------------------------------------------------------

--ChangedState
function LBPT.ChangedState() vars.changedState=true end;--will be changed when registeriong callbacks (UpdateFunctions())

--Aux functions
function LBPT.MissChance() return 0; end --will be modified
local spellsUsed = {
	[data.WR.name] = tonumber(data.WR.spellId),
	[data.SS.name] = tonumber(data.SS.spellId),
	[data.SF.name] = tonumber(data.SF.spellId),
	[data.WR.spellId] = tostring(data.WR.name),
	[data.SS.spellId] = tostring(data.SS.name),
	[data.SF.spellId] = tostring(data.SF.name),
}

local function UnitNameComplete(unit)
	local name,realm = UnitName(unit,1)
	if name then
		if not realm then return name; end
		return name.."-"..realm
	end
end
local function UnitByName(name)
	if UnitNameComplete("target")==name then return "target";
	elseif UnitNameComplete("mouseover")==name then return "mouseover";
	elseif UnitNameComplete("focus")==name then return "focus";
	elseif UnitNameComplete("targettarget")==name then return "targettarget";
	end
	
	if IsActiveBattlefieldArena() then
		for i=1,5 do if UnitNameComplete("arena"..i)==name then return "arena"..i; end end
	else
		for i=1,5 do if UnitNameComplete("boss"..i)==name then return "boss"..i; end end
	end

	return "target";
end
local function UpdateSpellcastSentFunction()
	if (next(eclipseProbCallbacks) ~= nil or next(statCallbacks) ~= nil) and options.enabled and options.foresee and vars.isBalance then
		frame:RegisterEvent("UNIT_SPELLCAST_SENT"); --TODO: Remove when enabling deleteByGUID
		
		function LBPT.MissChance(num)
			local diff = vars.unitLevelSent[num] - UnitLevel("player");
			if diff <= -4 then return 0;elseif diff > 5 then diff = 5;end
			if vars.unitIsPCSent[num] then return 1-min(missTablePvP[diff]+GetCombatRatingBonus(8)*.01,1);end
			return 1-min(missTablePvE[diff]+GetCombatRatingBonus(8)*.01,1);
		end
		
		function LBPT.Choose(GUID,name) return GUID end
		
		function LBPT.UNIT_SPELLCAST_SENT(unitID,name,_,target,num) 
			if unitID == "player" and spellsUsed[name] then
				unitID = UnitByName(target)
				vars.unitIsPCSent[num]	= UnitIsPlayer(unitID) or false;
				vars.destGUID[num] = UnitGUID(unitID); --It's already been searched, so it's used here
				
				if UnitLevel(unitID) == -1 then 
					vars.unitLevelSent[num] = UnitLevel("player") + 3;
				else
					vars.unitLevelSent[num]	= UnitLevel(unitID);
				end
			end
		end
	else
		frame:UnregisterEvent("UNIT_SPELLCAST_SENT"); --TODO: Remove when enabling deleteByGUID
	
		function LBPT.MissChance() return 0; end;
		
		function LBPT.Choose(GUID,name) return name end
		
		function LBPT.UNIT_SPELLCAST_SENT(unitID,name,_,target,num) 
			if unitID == "player" and spellsUsed[name] then
				--vars.destGUID[num] = UnitGUID(UnitByName(target)); --It was intended to use GUID; but it's easier using name
				vars.destGUID[num] = target; -- The name is easier to use
			end
		end
	end
end
local function UpdateFunctions()
	callBacksActivated.reduced,callBacksActivated.full = next(reducedCallbacks) ~= nil,next(callbacks) ~= nil;
	callBacksActivated.eclipseProb,callBacksActivated.stat = next(eclipseProbCallbacks) ~= nil,next(statCallbacks) ~= nil;
	if elements ~= 0 then
		if (callBacksActivated.eclipseProb or callBacksActivated.stat) and callBacksActivated.reduced then
			function LBPT.ChangedState(real)		if LBPT.RecalcEnergy()	then return end 	LBPT.RecalcWays();	LBPT.FireCallbacks(); if real then LBPT.FireReducedCallbacks() end;	end;--aded reduced callbacks and stat analysis
		elseif callBacksActivated.reduced then
			function LBPT.ChangedState(real)		if LBPT.RecalcEnergy()	then return end 						LBPT.FireCallbacks(); if real then LBPT.FireReducedCallbacks() end;	end;--aded reduced callbacks
		elseif (callBacksActivated.eclipseProb or callBacksActivated.stat)	then
			function LBPT.ChangedState()			if LBPT.RecalcEnergy()	then return end 	LBPT.RecalcWays();	LBPT.FireCallbacks();												end;--added stat analysis 
		else
			function LBPT.ChangedState() 			if LBPT.RecalcEnergy()	then return end 						LBPT.FireCallbacks();												end;--only full callbacks (most common)
		end
		
	else 	
			function LBPT.ChangedState() 		 	vars.changedState=true	end;--Default, no callbacks, just waiting till someone calls GetEclipseEnergyInfo()
	end
	UpdateSpellcastSentFunction()
end
local function UpdateEuphoria()	vars.euphoria = select(5,GetTalentInfo(1,7)) * .12; end --Checked on shapeshift_forms_updated on load, on Player_login on reload
local function CheckEcplipseBuff() vars.eclipse = (UnitBuff('player',select(1,GetSpellInfo(data.SolarEclipse.spellId))) and 100) or (UnitBuff('player',select(1,GetSpellInfo(data.LunarEclipse.spellId))) and -100) end

do --Loading
	frame:SetScript("OnEvent",  function(_, event, ...) 	LBPT[event](...) end);
	frame:RegisterEvent("PLAYER_LOGIN"); 
	function LBPT.PLAYER_LOGIN() 
		playerGUID=UnitGUID("player");
		vars.isDruid = select(2,UnitClass('player'))=="DRUID"; 
		if vars.isDruid then 
			LibBalancePowerTracker:RegisterFunctionsLog();
			
			if options.enabled then 
				frame:RegisterEvent("PLAYER_TALENT_UPDATE");
				frame:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED");
				frame:RegisterEvent("UPDATE_SHAPESHIFT_FORMS") --not fired when /reload, used to check eclipse on load
				--Check tier
				frame:RegisterEvent("PLAYER_EQUIPMENT_CHANGED");
				for k in pairs(vars.tiers) do if tonumber(k) then LBPT.PLAYER_EQUIPMENT_CHANGED(k,GetInventoryItemID("player", k)) end end
			else 
				frame:UnregisterEvent("PLAYER_TALENT_UPDATE");
				frame:UnregisterEvent("ACTIVE_TALENT_GROUP_CHANGED");
				frame:UnregisterEvent("UPDATE_SHAPESHIFT_FORMS");
				
				frame:UnregisterEvent("PLAYER_EQUIPMENT_CHANGED");
			end
		end 
	end;
	function LBPT.UPDATE_SHAPESHIFT_FORMS() --used to check Eclipse on load
		if options.enabled and vars.isBalance then 
			LBPT.Reset(vars.isBalance) 
		end
	end;

	function LBPT.RegisterEvents(balanceNow)
		if options.enabled and balanceNow then
			if options.foresee then
				frame:RegisterEvent("UNIT_SPELLCAST_START");
				frame:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
				--frame:RegisterEvent("UNIT_SPELLCAST_SENT");
			else
				frame:UnregisterEvent("UNIT_SPELLCAST_START");
				frame:UnregisterEvent("UNIT_SPELLCAST_SUCCEEDED");
				--frame:UnregisterEvent("UNIT_SPELLCAST_SENT");
			end
			frame:RegisterEvent("PLAYER_DEAD");
			frame:RegisterEvent("ECLIPSE_DIRECTION_CHANGE");
			
			frame:RegisterEvent("PLAYER_ENTERING_WORLD");	
		else 
			frame:UnregisterEvent("UNIT_SPELLCAST_START");
			frame:UnregisterEvent("UNIT_SPELLCAST_SUCCEEDED");
			--frame:UnregisterEvent("UNIT_SPELLCAST_SENT");
			frame:UnregisterEvent("PLAYER_DEAD");
			frame:UnregisterEvent("ECLIPSE_DIRECTION_CHANGE");	
			
			frame:UnregisterEvent("PLAYER_ENTERING_WORLD");	
		end
		
		if options.enabled and (options.foresee or balanceNow) then --WR energy thirds tracker must be active when not balance
			frame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
			LBPT.CreateCombatLogFunction(options.foresee,balanceNow)
		else
			frame:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		end
		
		UpdateSpellcastSentFunction()
	end
	function LBPT.Reset(balanceNow)
		--Reset values
		vars.spellQ:Clear();
		vars.computedEnergy,vars.direction,vars.computedVirtualEnergy,vars.vDirection,vars.computedVirtualEclipse = 0,"none",0,"none",false;
		vars.probTable = {
			firstSpell = nil,
			sun  = {},
			none = {},
			moon = {},
		}
		vars.eclipse = nil
		vars.eclipseProb = 0
		
		--Propagate values
		if options.enabled and balanceNow then 	
			vars.direction = GetEclipseDirection() or vars.direction --Only useful after login, not accurate when changing talents
			CheckEcplipseBuff() --Only useful after login	
			LBPT.ChangedState(true); --energy is not accurate when changing talens
		else
			LBPT.FireCallbacks()
			LBPT.FireReducedCallbacks()
			for k,v in pairs(statCallbacks) do v(vars.inverseCumulativeDistributionFunction);end;
			for k,v in pairs(eclipseProbCallbacks) do v(vars.eclipseProb);end;
		end
	end
end

do --Combat events-------------
	function LBPT.Choose(GUID,name) return name end
	do --COMBAT LOG HANDLER -------------------------------------------------------
		function LBPT.COMBAT_LOG_EVENT_UNFILTERED()
		end
		local function SetEclipseDirection(timestamp)
			local energy = UnitPower("player" , 8);
			if energy ==100 then vars.direction = "moon"; 		vars.ecTime,vars.eclipse = timestamp, 100
			elseif energy == -100 then vars.direction = "sun";	vars.ecTime,vars.eclipse = timestamp,-100
			else
				vars.direction = GetEclipseDirection() or vars.direction;
				if (vars.direction == "moon" and energy <=0) or (vars.direction == "sun"  and energy >=0) or (vars.direction == "none") then
					vars.eclipse=false;
				end
			end
		end
		local notEnergy = {
			[data.SF.spellId] = "moon",
			[data.WR.spellId] = "sun"
		}
		local eclipseEnergy = {
			[data.LunarEclipse.spellId] = -100,
			[data.SolarEclipse.spellId] =  100,
		}
		local unfilteredCombatLogEnergize = {
			[data.EE.spellId]	= function(amountEnergy)
									if amountEnergy > 10 then 
										vars.spellQ:RemoveFlyingSpell(data.SF.spellId)
									elseif actualizarEnergiaWR[amountEnergy] then
										vars.spellQ:RemoveFlyingSpell(data.WR.spellId)
										vars.energyThirds = actualizarEnergiaWR[amountEnergy](vars.energyThirds)
									end
								end,
			[data.SSE.spellId] 	= function() 
									vars.spellQ:RemoveFlyingSpell(data.SS.spellId)
								end,
		}	
		local unfilteredCombatLogTable = {
			SPELL_ENERGIZE 	= function(id,amount,typeEnergy,timestamp)	if (typeEnergy == 8) then
																			id = unfilteredCombatLogEnergize[id] 
																			if id then id(amount); end;
																			
																			SetEclipseDirection(timestamp);
																			LBPT.ChangedState(true)
																		end
							end,
			SPELL_MISSED 	= function(id,_,_,_,who)	if spellsUsed[id] then
															vars.spellQ:RemoveFlyingSpell(id)
															LBPT.ChangedState();
														end;
							end,
			SPELL_DAMAGE 	= function(id,_,_,timestamp,who)	if notEnergy[id] == vars.direction then
																	if abs(timestamp-vars.ecTime)<.5 then return end
				
																	vars.spellQ:RemoveFlyingSpell(id)
																	if id == data.WR.spellId then
																		_,vars.energyThirds = EnergyFromSpell(id,vars.direction,vars.computedEnergy,vars.energyThirds,false,vars.eclipse)
																	end
																	LBPT.ChangedState()
																end;
							end,
			SPELL_CAST_FAILED = function(id,msg) if msg ~= SPELL_FAILED_NOT_READY and msg ~= SPELL_FAILED_SPELL_IN_PROGRESS and vars.spellQ:InterruptedCastingSpell(id) then LBPT.ChangedState() end end,
			--SPELL_AURA_APPLIED = function(id) if eclipseEnergy[id] then vars.eclipse = eclipseEnergy[id] end end,
			SPELL_AURA_REMOVED = function(id) if eclipseEnergy[id] and vars.eclipse then vars.eclipse = false LBPT.ChangedState() end end,
		}
		function LBPT.CreateCombatLogFunction(foresee,balance)
			if foresee and balance then
				function LBPT.COMBAT_LOG_EVENT_UNFILTERED(timestamp,event,_,gUIDor,_,_,_,destGUID,destName,_,_,spellId,_,_,amountEnergy,typeEnergy)
					if (gUIDor == playerGUID) then 
						event = unfilteredCombatLogTable[event] 
						if event then event(spellId,amountEnergy,typeEnergy,timestamp,LBPT.Choose(destGUID,destName)) end
					elseif (destGUID == playerGUID) and event=="SPELL_INTERRUPT" then
						if vars.spellQ:InterruptedCastingSpell(amountEnergy) then LBPT.ChangedState() end
					end
				end
			elseif balance then
				function LBPT.COMBAT_LOG_EVENT_UNFILTERED( timestamp,event,_,gUIDor,_,_,_,_,_,_,_,_,_,_,_,typeEnergy)
					if (gUIDor == playerGUID) and (event=="SPELL_ENERGIZE") and (typeEnergy == 8) then SetEclipseDirection(timestamp) LBPT.ChangedState(true) end;
				end
			elseif foresee then
				function LBPT.COMBAT_LOG_EVENT_UNFILTERED(_,event,_,gUIDor,_,_,_,_,_,_,_,spellId)
					if (gUIDor == playerGUID) and (event=="SPELL_DAMAGE") and (spellId == data.WR.spellId) then 
						_,vars.energyThirds = EnergyFromSpell(spellId,vars.direction,vars.computedEnergy,vars.energyThirds,false,false)
					end;
				end
			else
				function LBPT.COMBAT_LOG_EVENT_UNFILTERED()
				end
			end
		end
	end
	function LBPT.UNIT_SPELLCAST_SENT() ---Will be modified by UpdateSpellcastSentFunction()
	end
	function LBPT.UNIT_SPELLCAST_START(unit,_,_,num,id)
		if unit == "player" and spellsUsed[id] then
			vars.spellQ:BeginCastingSpell(id,num,LBPT.MissChance(num),vars.destGUID[num])
			LBPT.ChangedState()
		end
	end
	function LBPT.UNIT_SPELLCAST_SUCCEEDED(unit,_,_,num,id)
		if unit == "player" and spellsUsed[id] then
			unit=timers[id];
			unit.timer:SetCooldown(GetTime(),unit.seconds)
			if vars.spellQ:FinishCastingSpell(id,num,LBPT.MissChance(num),vars.destGUID[num]) then
				LBPT.ChangedState()
			end
		end
	end

	function LBPT.PLAYER_DEAD() 				vars.spellQ:Clear();	vars.direction = GetEclipseDirection() or "none"; LBPT.ChangedState(true);	end; --Reset queue & clear energy upon dying
end

do --Tier bonus check
	local broadcasted = {}
	setmetatable(broadcasted, {__index = function () return 0 end})
	timers.broadcastTier:SetScript("OnHide",function() 
		frame:UnregisterEvent("UPDATE_SHAPESHIFT_FORMS");
		for k,v in pairs(vars.tiers.tierPieceCount) do
			if broadcasted[k] ~= v then --broadcast
				if broadcasted[k] < v then --gained bonus
					for i = broadcasted[k]+1,v do
						if data.balanceTiersItemId[k]["bonus"..i.."p"] then print("|c00a080ffLibBalancePowerTracker|r: Tier"..k.." "..i.."p bonus detected.") end
					end
				else --lost bonus
					for i = v+1,broadcasted[k] do
						if data.balanceTiersItemId[k]["bonus"..i.."p"] then print("|c00a080ffLibBalancePowerTracker|r: No tier"..k.." "..i.."p bonus detected.") end
					end
				end
				broadcasted[k] = v
			end
		end
	end)
	function LBPT.PLAYER_EQUIPMENT_CHANGED(slot,hasItem)
		local setInSlot = vars.tiers[slot]
		if setInSlot then						--print("retirado objeto de "..slot)
			vars.tiers[slot]=false;
			vars.tiers.tierPieceCount[setInSlot]=vars.tiers.tierPieceCount[setInSlot]-1 --print("Tienes "..vars.tiers.tierPieceCount[setInSlot].." piezas de tier "..setInSlot)
			
			for i = 0,9 do		
				if vars.tiers.tierPieceCount[setInSlot] == i-1 and data.balanceTiersItemId[setInSlot]["bonus"..i.."p"] and LBPT.BonusTier[setInSlot][i].Off() then timers.broadcastTier:SetCooldown(GetTime(),0)  end
			end
		end
		
		if hasItem and setInSlot ~= nil then 				--print("se intenta poner una pieza en "..slot)
			local id = GetInventoryItemID("player", slot)	--print("el id de la pieza es "..tostring(id))
			for k,v in pairs(data.balanceTiersItemId) do	--print("buscando en tier "..k)
				if v[slot] and v[slot][id] then				--print("encontrado en tier "..k)
					vars.tiers[slot]=k;
					vars.tiers.tierPieceCount[k]=vars.tiers.tierPieceCount[k]+1 --print("Tienes "..vars.tiers.tierPieceCount[k].." piezas de tier "..k);
					
					for i = 0,9 do
						if vars.tiers.tierPieceCount[k] == i and v["bonus"..i.."p"] and LBPT.BonusTier[k][i].On() then timers.broadcastTier:SetCooldown(GetTime(),0) end
					end
					return
				end
			end
		end
	end
end

do --Direction & energy when teleporting (& reseting eclipse direction)
	function LBPT.PLAYER_ENTERING_WORLD()		vars.spellQ:Clear();	vars.direction = GetEclipseDirection() or "none"; LBPT.ChangedState(true); end; 
	function LBPT.ECLIPSE_DIRECTION_CHANGE(dir)	if dir == "none" and vars.direction ~= "none" then vars.direction = dir;  LBPT.ChangedState(true); end end; --It doesn't seem needed anymore
end

do --Talent check/change events
	function LBPT.PLAYER_TALENT_UPDATE()
		UpdateEuphoria() 
		if vars.isBalance == (GetSpellCooldown(data.SS.name)~=nil) then --Si cambiamos de pollo a chopo o viceversa, hemos de actualizar los eventos y resetear los valores
			return
		end
		vars.isBalance = (GetSpellCooldown(data.SS.name)~=nil)
		LBPT.RegisterEvents(vars.isBalance)
		LBPT.Reset(vars.isBalance)
	end; 
	function LBPT.ACTIVE_TALENT_GROUP_CHANGED() --Si al pasar de pollo a pollo tenemos energia, retrasar un evento para actualizar cuando vuelva a 0
		if options.enabled and GetSpellCooldown(data.SS.name)~=nil and UnitPower("player",8) ~= 0 then 
			frame:RegisterEvent("UNIT_POWER");
		end
	end
	function LBPT.UNIT_POWER(unit,power)
		if unit == "player" and power == "ECLIPSE" then
			frame:UnregisterEvent("UNIT_POWER");
			if options.enabled and (vars.computedEnergy ~= UnitPower("player",8) or vars.direction ~= GetEclipseDirection()) then 
				vars.direction = GetEclipseDirection()
				LBPT.ChangedState(true); 
			end
		end
	end
end

do --Recalc Energy function
	--Staying at 0 energy bug workaround
	local reallyZeroEnergy=false;
	local timeShown = 0;
	frame:SetScript("OnShow",	function() timeShown = GetTime()+.6; end); 
	frame:SetScript("OnUpdate", function()	if (UnitPower("player",8) ~= 0) and (UnitPower("player",8) ~= 15) then frame:Hide(); LBPT.ChangedState(true); 
											elseif (timeShown < GetTime()) then reallyZeroEnergy = true LBPT.ChangedState(true) frame:Hide(); 
											elseif (elements == 0) then frame:Hide(); 
											end; end); 


	--Recalc Energy function
	local function ExtraEnergy(energy,direction) --computes extra energy
		vars.spellQ_IteratorReset(); --reset iterator to first
		local v = vars.spellQ_IteratorNext();
		local temp,energyThirds,eclipse = 0,vars.energyThirds,vars.eclipse

		while v do
			temp,energyThirds = EnergyFromSpell(v.n,direction,energy,energyThirds,false,eclipse)
			energy = energy + temp
			v = vars.spellQ_IteratorNext();
		
			if energy>=100 then 
				energy = 100
				direction = "moon"
				eclipse = energy
			elseif energy<=-100 then 
				energy = -100 
				direction = "sun";
				eclipse = energy;
			elseif (direction == "moon" and energy <=0) or (direction == "sun"  and energy >=0) or (direction == "none") then
				eclipse = false;
			end
		end

		return energy,direction,eclipse
	end
	
	function LBPT.RecalcEnergy()
		local energy = UnitPower("player" , 8);

		if (energy == 0) or (abs(energy) == 15) then
			if not reallyZeroEnergy then 
				frame:Show()
				return true
			end
		else 
			reallyZeroEnergy=false
		end
		
		vars.computedEnergy,vars.changedState = energy, false;
		
		if options.foresee then
			vars.spellQ:RemoveTimedOutFlyingSpell(5);
			vars.computedVirtualEnergy,vars.vDirection,vars.computedVirtualEclipse = ExtraEnergy(energy,vars.direction)
			return
		end
		
		vars.computedVirtualEnergy,vars.vDirection,vars.computedVirtualEclipse = energy,vars.direction,false;
	end
end

do --Tree ADT functions
	local function TreeEnergyFromSpell(id,direction,energy,vE,eT,double)
		local temp,eT = EnergyFromSpell(id,direction,energy,eT,double,vE);
		energy = energy + temp;
		
		if energy>=100 then			return    100,   "moon",  100,eT;
		elseif energy<=-100 then 	return   -100,    "sun", -100,eT;
		elseif (direction == "moon" and energy <=0) or (direction == "sun"  and energy >=0) or (direction == "none") then
									return energy,direction,false,eT;
		else						return energy,direction,   vE,eT;
		end
	end
	local function TreeApplySpell(parentOriginal,sonMiss,sonNormal,sonDouble,element)
		local prob, energy, direction, virtualEclipse, eT = parentOriginal.prob,parentOriginal.energy,parentOriginal.direction,parentOriginal.virtualEclipse, parentOriginal.eT;
			
		if prob == 0 then sonMiss.prob,sonNormal.prob,sonDouble.prob = 0,0,0; return; end
		
		local euphoriaProb = ((((direction == "moon" and energy >=-40) or (direction == "sun"  and energy <=40) or (direction == "none")) and element.n ~= data.SS.spellId and not virtualEclipse ) and vars.euphoria) or 0;
		
		sonMiss.prob = prob * element.mc;
		sonDouble.prob = prob *(1-element.mc)* euphoriaProb 
		sonNormal.prob = prob *(1-element.mc)*(1-euphoriaProb)
		
		if sonMiss.prob ~=0 then sonMiss.energy,sonMiss.direction,sonMiss.virtualEclipse,sonMiss.eT = energy,direction,virtualEclipse,eT;end
		if sonDouble.prob~=0 then sonDouble.energy,sonDouble.direction,sonDouble.virtualEclipse,sonDouble.eT = TreeEnergyFromSpell(element.n,direction,energy,virtualEclipse,eT,true);end
		if sonNormal.prob~=0 then sonNormal.energy,sonNormal.direction,sonNormal.virtualEclipse,sonNormal.eT = TreeEnergyFromSpell(element.n,direction,energy,virtualEclipse,eT);end
	
		if sonDouble.prob~=0 then
			if (sonDouble.energy == sonNormal.energy and sonDouble.direction == sonNormal.direction) or  (direction == "none" and sonNormal.direction == "none" and ((energy >= 40 and sonDouble.energy > sonNormal.energy) or (energy <= -40 and sonDouble.energy < sonNormal.energy))) then
				sonNormal.prob = sonNormal.prob + sonDouble.prob
				sonDouble.prob = 0
			end
		end
	end
	function LBPT.RecalcWays(forced)
		local direction,energy,getNext = vars.direction,UnitPower("player" , 8),vars.spellQ:iterator();
		
		--Aclarar que tenemos en cuenta que el %miss se calcula cuando el hechizo se enva, tambin contamos con 
		--que euforia no acta como la tabla de ataques mele (se hacen dos tiradas independientes, la primera para 
		--ver si el hechizo acierta y la segunda para ver si salta euforia)
		
		--[[ WAYTREE as a Table (First child is miss, second is normal and third is Euphoria
		--(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)(11)(12)(13)(14)(15)(16)(17)(18)(19)(20)(21)(22)(23)(24)(25)(26)(27)--]]
		
		local tempTable,wayEnd,v,level,idFirstSpell  = vars.wayTable, 1,getNext(),0,false;
		if not tempTable[1] then tempTable[1] = {} end
			if v then idFirstSpell = v.n end
			tempTable[1].eT = vars.energyThirds
			tempTable[1].prob = 1;
			tempTable[1].energy = energy;
			tempTable[1].direction = direction;
			tempTable[1].virtualEclipse = vars.eclipse;
		
		while v and level <= vars.max_levels do
			for i = 1,wayEnd do 
				if not tempTable[i+wayEnd] then  tempTable[i+wayEnd] = {} end
				if not tempTable[i+2*wayEnd] then tempTable[i+2*wayEnd] = {} end
				TreeApplySpell(tempTable[i],tempTable[i], tempTable[i+wayEnd] , tempTable[i+2*wayEnd] ,v)
			end
			wayEnd,v,level=wayEnd*3,getNext(),level+1;
		end
		
		if callBacksActivated.eclipseProb or forced then --Eclipse probability calc if only the eclipse calc is selected
			local a,vE = 0,false
			for i=1,wayEnd do 
				if tempTable[i].prob>0 and tempTable[i].direction ~= direction then
					vE,a = tempTable[i].direction,a + tempTable[i].prob;
				end;
			end;
			if vE == "sun" then
				a=-a
			end
			
			if vars.eclipseProb ~= a then --Eclipse chance has changed
				vars.eclipseProb = a;for k,v in pairs(eclipseProbCallbacks) do v(a);end;
			end
		end
		
		if callBacksActivated.stat or forced then
			for i,_ in pairs(vars.probTable.sun ) do vars.probTable.sun[i] =nil end
			for i,_ in pairs(vars.probTable.moon) do vars.probTable.moon[i]=nil end
			for i,_ in pairs(vars.probTable.none) do vars.probTable.none[i]=nil end
				
			for i=1,wayEnd do 
				if tempTable[i].prob>0 then
					vars.probTable[tempTable[i].direction][tempTable[i].energy] = tempTable[i].prob + (vars.probTable[tempTable[i].direction][tempTable[i].energy] or 0)
				end;
			end;
			
			vars.probTable.firstSpell = idFirstSpell
			
			for k,v in pairs(statCallbacks) do v() end
		
			--[[print("BEGIN")
			for k,v in pairs(vars.probTable) do
				if type(v)=="table" then 
				for i,j in pairs(v) do
					print(i..":"..j)
				end end
			end
			print("END")--]]
		end
	end
	vars.inverseCumulativeDistributionFunction = function(value) 		
		--funcion (valor) devuelve la mnima energa que tendrs con un valor% de seguridad
		-- "tienes un valor*100% de tener como mnimo funcion(valor) energa
		if value>1 then value = 1 
		elseif value <0 then value = 0 end 
		local prob = 0;
		local direction = vars.direction
		local eclipse = vars.eclipse
		local mustCheckNoneTable = false
		
		if direction == "none" then
			if (vars.probTable.firstSpell == data.SF.spellId) or (vars.probTable.firstSpell == data.SS.spellId and vars.computedEnergy>=0) then
				mustCheckNoneTable = -1
				direction = "sun"
				eclipse = -100
			else
				mustCheckNoneTable = 1
				direction = "moon"
				eclipse = 100
			end
		end
		
		if direction == "sun" then
			for i = -100,100 do
				prob = vars.probTable.moon[i]
				if prob then
					value=value-prob;	
					if value<=0 then return vars.computedEnergy,vars.direction,i,"moon",i>0 and 100; end 
				end	
			end
			for i = 100,-100,-1 do
				prob = vars.probTable.sun[i]
				if prob then
					value=value-prob;	
					if value<=0 then return vars.computedEnergy,vars.direction,i,"sun",i<0 and eclipse;	end 
				end	
			end
		elseif direction == "moon" then
			for i = 100,-100,-1 do
				prob = vars.probTable.sun[i]
				if prob then
					value=value-prob;	
					if value<=0 then return vars.computedEnergy,vars.direction,i,"sun",i<0 and -100;	end 
				end	
			end
			for i = -100,100 do
				prob = vars.probTable.moon[i]
				if prob then
					value=value-prob;	
					if value<=0 then return vars.computedEnergy,vars.direction,i,"moon",i>0 and eclipse; end 
				end	
			end
		end
		
		if mustCheckNoneTable then
			for i = mustCheckNoneTable*-100,mustCheckNoneTable*100,mustCheckNoneTable do
				prob = vars.probTable.none[i]
				if prob then
					value=value-prob;	
					if value<=0 then return vars.computedEnergy,vars.direction,i,"none",false; end 
				end	
			end
		end
		
		return vars.computedEnergy,vars.direction,vars.computedEnergy,vars.direction,false;
	end
end

do--Calling callbacks functions
	function LBPT.FireCallbacks() 			for k,v in pairs(callbacks) 		do v(vars.computedEnergy,vars.direction,vars.computedVirtualEnergy,vars.vDirection,vars.computedVirtualEclipse); 	end; end;
	function LBPT.FireReducedCallbacks() 	for k,v in pairs(reducedCallbacks) 	do v(vars.computedEnergy,vars.direction); 																	end; end;
end
do--Called functions (API)
	function LibBalancePowerTracker:GetEclipseEnergyInfo(forced)	if vars.changedState or forced then LBPT.RecalcEnergy() end return vars.computedEnergy,vars.direction,vars.computedVirtualEnergy,vars.vDirection,vars.computedVirtualEclipse;	end;
	function LibBalancePowerTracker:GetEclipseChance(forced)		if (not callBacksActivated.eclipseProb) or vars.changedState or forced then LBPT.RecalcEnergy()	LBPT.RecalcWays(not callBacksActivated.eclipseProb)	end return vars.eclipseProb; end;
	function LibBalancePowerTracker:GetEnergyFunction(forced)		if (not callBacksActivated.stat) 		or vars.changedState or forced then LBPT.RecalcEnergy()	LBPT.RecalcWays(not callBacksActivated.stat )		end return vars.inverseCumulativeDistributionFunction; end;
	function LibBalancePowerTracker:RegisterReducedCallback(callback)
		lastCallback=lastCallback+1
		elements=elements+1
		reducedCallbacks[lastCallback]=callback;
		local energy,direction = LibBalancePowerTracker:GetEclipseEnergyInfo()
		callback(energy,direction)
		UpdateFunctions()
		return lastCallback
	end
	function LibBalancePowerTracker:RegisterFullCallback(callback)
		lastCallback=lastCallback+1
		elements=elements+1
		callbacks[lastCallback]=callback;
		callback(LibBalancePowerTracker:GetEclipseEnergyInfo())
		UpdateFunctions()
		return lastCallback
	end
	function LibBalancePowerTracker:RegisterEclipseProbCallback(callback)
		lastCallback=lastCallback+1
		elements=elements+1
		LBPT.RecalcWays()
		eclipseProbCallbacks[lastCallback]=callback;
		callback(LibBalancePowerTracker:GetEclipseChance())
		UpdateFunctions()
		return lastCallback
	end
	function LibBalancePowerTracker:RegisterStatCallback(callback)
		lastCallback=lastCallback+1
		elements=elements+1
		statCallbacks[lastCallback]=callback;
		LibBalancePowerTracker:GetEnergyFunction()
		UpdateFunctions()
		return lastCallback,vars.inverseCumulativeDistributionFunction
	end
	function LibBalancePowerTracker:UnregisterCallback(id)
		if reducedCallbacks[id] then
			reducedCallbacks[id]=nil;
		elseif callbacks[id] then
			callbacks[id]=nil;
		elseif eclipseProbCallbacks[id] then
			eclipseProbCallbacks[id]=nil;
		elseif statCallbacks[id] then
			statCallbacks[id]=nil;
		else
			return true;
		end
		elements=elements-1
		UpdateFunctions()
	end
	function LibBalancePowerTracker:GetVersion()	return version[1],version[2],version[3]; end;
	function LibBalancePowerTracker:GetEnabled()	return options.enabled; end;
end

--Log
function LibBalancePowerTracker:RegisterFunctionsLog()
	if LogBalancePowerTracker and LogBalancePowerTracker.Register and type(LogBalancePowerTracker.Register)=="function" then
		local logVars={energyCallbackId=false, playing=false};
		local tierTableTemp={};
		setmetatable(tierTableTemp, {__index = function () return 0 end})
		local function CompareTierTables(new)
			for k,v in pairs(new) do
				local bef = tierTableTemp[k]
				if v ~= bef then
					tierTableTemp[k] = v;
					if v<bef then
						--lost?
						if v == 3 and data.balanceTiersItemId[k].bonus4p then return "4off"..k end
						if v == 1 and data.balanceTiersItemId[k].bonus2p then return "2off"..k end
					else
						--gain?
						if v == 4 and data.balanceTiersItemId[k].bonus4p then return "4on"..k end
						if v == 2 and data.balanceTiersItemId[k].bonus2p then return "2on"..k end
					end
				end
			end
		end
		local tempEnergy,tempvEnergy,tempDir,tempvDir,tempRE=0,0,"none","none",false;
		
		LogBalancePowerTracker.Register(
			vars.spellQ.FromNumberToTable, --Function to turn numbers into tables 
			function(functionToCall) --function to call when log is enabled/disabled (to disable it, just call it with no parameters
				if functionToCall and type(functionToCall)=="function" then
					frame:SetScript("OnEvent",  function(_, event, ...) 	
													LBPT[event](...)
													if event ~= "PLAYER_EQUIPMENT_CHANGED" then
														functionToCall(event,vars.computedEnergy,vars.direction,vars.computedVirtualEnergy,vars.vDirection,vars.spellQ:tonumber(),...) 
													else
														local tierChanged = CompareTierTables(vars.tiers.tierPieceCount)
														if tierChanged then
															functionToCall("TIER_CHANGE",vars.computedEnergy,vars.direction,vars.computedVirtualEnergy,vars.vDirection,vars.spellQ:tonumber(),tierChanged)
														end
													end
												end);
					for k,v in pairs(timers) do	if tonumber(k)~= nil then v.timer:SetScript("OnHide",function() if vars.spellQ:RemoveAllSpellsById(k) then LBPT.ChangedState() functionToCall("TIMER",vars.computedEnergy,vars.direction,vars.computedVirtualEnergy,vars.vDirection,vars.spellQ:tonumber(),k) end end)	end end
				
					return vars.computedEnergy,vars.direction,vars.computedVirtualEnergy,vars.vDirection,vars.spellQ:tonumber()
				else
					frame:SetScript("OnEvent",  function(_, event, ...) 	LBPT[event](...)	end);
					for k,v in pairs(timers) do	if tonumber(k)~= nil then v.timer:SetScript("OnHide",function() if vars.spellQ:RemoveAllSpellsById(k) then LBPT.ChangedState() end end)	end end
				end
			end,
			function(enable) --function to call when enable/disable playing a log
				if (not logVars.playing) and (not LibBalancePowerTracker:GetEnabled()) then print("|c00a080ffLibBalancePowerTracker|r: LBPT is disabled, enable it before trying to run a log.") return end
				logVars.playing=enable;
				if enable then
					function LibBalancePowerTracker:GetEclipseEnergyInfo()	return tempEnergy,tempvEnergy,tempDir,tempvDir,tempRE;	end;
					options.enabled=false 
					LBPT.RegisterEvents(vars.isBalance)
					LBPT.Reset(vars.isBalance);
					print("|c00a080ffLibBalancePowerTracker|r: Disabled (Playing a log).")
				else
					function LibBalancePowerTracker:GetEclipseEnergyInfo(forced)	if vars.changedState or forced then LBPT.RecalcEnergy() end return vars.computedEnergy,vars.direction,vars.computedVirtualEnergy,vars.vDirection,vars.computedVirtualEclipse;	end;
					options.enabled=true  
					LBPT.RegisterEvents(vars.isBalance)
					LBPT.Reset(vars.isBalance)
					print("|c00a080ffLibBalancePowerTracker|r: Enabled (Stopped playing a log).")
				end
			end,
			function(energy,dir,vEnergy,vDir,virtualEclipse) --function to call to display custom values
				if not energy then
					for k,v in pairs(callbacks) 		do v(vars.computedEnergy,vars.direction,vars.computedVirtualEnergy,vars.vDirection,vars.computedVirtualEclipse);	end; 
					for k,v in pairs(reducedCallbacks) 	do v(vars.computedEnergy,vars.direction) end;
				else
					if not logVars.playing then print("|c00a080ffLibBalancePowerTracker|r: Must be running a log to use this function.") return end;
					tempEnergy,tempvEnergy,tempDir,tempvDir,tempRE = energy,dir,vEnergy,vDir,virtualEclipse;
					for k,v in pairs(callbacks) do v(energy,dir,vEnergy,vDir,virtualEclipse); end 
					for k,v in pairs(reducedCallbacks) 	do v(energy,dir); end
				end
			end
		)
	end
end


----TIER MODIFIER FUCNTION (At the end, so it sees and can modify all locals, sometimes I'll need to remove do-end blocks)
LBPT.BonusTier={
	[12]={
		[4]={
			On  = 	function()
						--SF changes--------------------------------------------
						energyFromSpell[data.SF.spellId].sun = function(_,energyThirds,eclipse) 
							if eclipse then
								return data.SF.energy,energyThirds 
							else 
								return data.SF.energy+5,energyThirds
							end
						end
						energyFromSpell[data.SF.spellId].none = function(_,energyThirds) 
							return data.SF.energy+5,energyThirds 
						end
						
						doubleEnergyFromSpell[data.SF.spellId].sun  = function(_,energyThirds) 
							return 2*(data.SF.energy+5),energyThirds
						end
						doubleEnergyFromSpell[data.SF.spellId].none = function(_,energyThirds) 
							return 2*(data.SF.energy+5),energyThirds
						end
						---------------------------------------------------------

						--WR changes---------------------------------------------
						--[[ after   ---   you get when you gain/lose bonus
							13 14			16 17
							16 17			13 14
							14 13			17 16
							17 16 			14 13
							13 13			17 17
							17 17			13 13
						--]]
						local nextTieredWRenergy = {
							[0] = -16,
							[1] = -17,
							[2] = -17,
						}
						
						actualizarEnergiaWR[-16] = function() return 2 end
						actualizarEnergiaWR[-17] = function(energyThirds) if energyThirds==0 then return 1 else return (energyThirds+2)%3 end end
						--actualizarEnergiaWR[-30] = function(energyThirds) return energyThirds end
						actualizarEnergiaWR[-33] = function(energyThirds) if energyThirds==2 then return 2 else return (energyThirds+1)%3 end end
						actualizarEnergiaWR[-34] = function() return 0 end
						
						energyFromSpell[data.WR.spellId].moon = function(_,energyThirds,eclipse) 
							local n;
							if eclipse then
								n = nextWRenergy[energyThirds];
							else
								n = nextTieredWRenergy[energyThirds];
							end
							return n,actualizarEnergiaWR[n](energyThirds); 
						end
						energyFromSpell[data.WR.spellId].sun = function(_,energyThirds,eclipse) 
							local n;
							if eclipse then
								n = nextWRenergy[energyThirds];
							else
								n = nextTieredWRenergy[energyThirds];
							end
							return 0,actualizarEnergiaWR[n](energyThirds); 
						end
						energyFromSpell[data.WR.spellId].none = function(_,energyThirds) 
							local n = nextTieredWRenergy[energyThirds];
							return n,actualizarEnergiaWR[n](energyThirds); 
						end

				
						doubleEnergyFromSpell[data.WR.spellId].moon = function(_,energyThirds) 
							local n1 = nextTieredWRenergy[energyThirds];
							local e1 = actualizarEnergiaWR[n1](energyThirds); 
							local n2 = nextTieredWRenergy[e1];

							return n1+n2,actualizarEnergiaWR[n2](e1); 
						end
						doubleEnergyFromSpell[data.WR.spellId].sun 	= function(_,energyThirds) 
							local n1 = nextTieredWRenergy[energyThirds];
							local e1 = actualizarEnergiaWR[n1](energyThirds); 
							local n2 = nextTieredWRenergy[e1];

							return 0,actualizarEnergiaWR[n2](e1); 
						end
						doubleEnergyFromSpell[data.WR.spellId].none = function(_,energyThirds) 
							local n1 = nextTieredWRenergy[energyThirds];
							local e1 = actualizarEnergiaWR[n1](energyThirds); 
							local n2 = nextTieredWRenergy[e1];

							return n1+n2,actualizarEnergiaWR[n2](e1); 
						end	
	
						return true;
					end,
			Off = 	function() 
						--SF changes--------------------------------------------
						energyFromSpell[data.SF.spellId].sun  = function(_,energyThirds) return data.SF.energy,energyThirds end
						energyFromSpell[data.SF.spellId].none = function(_,energyThirds) return data.SF.energy,energyThirds end
												
						doubleEnergyFromSpell[data.SF.spellId].sun  = function(_,energyThirds) return 2*data.SF.energy,energyThirds end
						doubleEnergyFromSpell[data.SF.spellId].none = function(_,energyThirds) return 2*data.SF.energy,energyThirds end
						---------------------------------------------------------	
						
						--WR changes---------------------------------------------
						energyFromSpell[data.WR.spellId]={
							moon 	= function(_,energyThirds) 
											local n = nextWRenergy[energyThirds];
											return n,actualizarEnergiaWR[n](energyThirds); 
									end,
							sun 	= function(_,energyThirds) 
											local n = nextWRenergy[energyThirds];
											return 0,actualizarEnergiaWR[n](energyThirds); 
									end,
							none 	= function(_,energyThirds) 
											local n = nextWRenergy[energyThirds];
											return n,actualizarEnergiaWR[n](energyThirds); 
									end,
						}
						
						doubleEnergyFromSpell[data.WR.spellId]={
							moon 	= function(_,energyThirds) 
											local n1 = nextWRenergy[energyThirds];
											local e1 = actualizarEnergiaWR[n1](energyThirds); 
											local n2 = nextWRenergy[e1];

											return n1+n2,actualizarEnergiaWR[n2](e1); 
									end,
							sun 	= function(_,energyThirds) 
											local n1 = nextWRenergy[energyThirds];
											local e1 = actualizarEnergiaWR[n1](energyThirds); 
											local n2 = nextWRenergy[e1];

											return 0,actualizarEnergiaWR[n2](e1); 
									end,
							none 	= function(_,energyThirds) 
											local n1 = nextWRenergy[energyThirds];
											local e1 = actualizarEnergiaWR[n1](energyThirds); 
											local n2 = nextWRenergy[e1];

											return n1+n2,actualizarEnergiaWR[n2](e1); 
									end,
						}
						------------------------------------------------------
						return true;
					end,
		},
	},
}



