local ldb_tip
local crayon  = LibStub("LibCrayon-3.0")
local total   = { [0] = 0, [1] = 0, [2] = 0, [3] = 0, [4] = 0 }
local taken   = { [0] = 0, [1] = 0, [2] = 0, [3] = 0, [4] = 0 }
local free    = { [0] = 0, [1] = 0, [2] = 0, [3] = 0, [4] = 0 }
local frame   = CreateFrame("Button", "Bagsy")
local ldb_obj = LibStub("LibDataBroker-1.1"):NewDataObject("Bagsy", {
	icon     = "Interface\\Icons\\INV_Misc_Bag_08.png",
	label    = "Bagsy"
})

local function set_ldb_obj_text(_, event, bag)
	if event then
		if type(bag) ~= "number" then
			for bag = 0, 4 do
				total[bag] = GetContainerNumSlots(bag)
				free[bag]  = GetContainerNumFreeSlots(bag)
				taken[bag] = total[bag] - free[bag]
			end

		elseif bag >= 0 and bag < 5 then	
			total[bag] = GetContainerNumSlots(bag)
			free[bag]  = GetContainerNumFreeSlots(bag)
			taken[bag] = total[bag] - free[bag]
		end
	end

	local total_all = total[0] + total[1] + total[2] + total[3] + total[4]
	local taken_all = taken[0] + taken[1] + taken[2] + taken[3] + taken[4]
	local free_all  = free[0]  + free[1]  + free[2]  + free[3]  + free[4]
	local colour    = crayon:GetThresholdHexColor(free_all, total_all)
	ldb_obj.text    = "|cff"..colour..(Bagsy_State and taken_all or free_all).."/"..total_all.."|r"
end

function ldb_obj.OnTooltipShow(tip)
	if not ldb_tip then ldb_tip = tip end

	tip:ClearLines()

	local state = (Bagsy_State and "taken" or "free")

	tip:AddLine("Bagsy: A DataBroker Plugin")
	tip:AddLine(" ")
	tip:AddLine("|cff8888eeYour individual bags and their "..state.." slots:|r")

	for bag = 0, 4 do
		local link  = bag > 0 and GetInventoryItemLink("player", ContainerIDToInventoryID(bag)) or "|cffffffff[Backpack]|r"
		local color = crayon:GetThresholdHexColor(free[bag], total[bag])

		tip:AddDoubleLine("|cff69b950"..(bag + 1).." "..link.."|r", "|cff"..color..(Bagsy_State and taken[bag] or free[bag]).."/"..total[bag].."|r")
	end

	tip:AddLine(" ")
	tip:AddLine("|cffffd700Currently Showing:|r |cffeeeeeeAmount of slots "..state..".|r")
	tip:AddLine(" ")
	tip:AddLine("|cff69b950Click:|r |cffeeeeeeToggles backpack open/closed.|r")
	tip:AddLine("|cff69b950Alt + Click:|r |cffeeeeeeToggles showing overall free slots or taken slots.|r")
end

function ldb_obj.OnClick(_, which)
	if IsAltKeyDown() then
		Bagsy_State = not Bagsy_State

		set_ldb_obj_text()
		ldb_obj.OnTooltipShow(ldb_tip)

		return
	end

	ToggleBackpack()
end

frame:RegisterEvent"PLAYER_LOGIN"
frame:RegisterEvent"BAG_UPDATE"

frame:SetScript("OnEvent", set_ldb_obj_text)