--------------------------------------------------------------------------------
-- Holiday Frame
--- The current Call to Arms
--------------------------------------------------------------------------------

-- General Tracker variables
local AceGUI = LibStub("AceGUI-3.0")
local addonName, BGS_TrackerClasses = ...
local TrackerClass = {}
TrackerClass.name = "HolidayFrame"
TrackerClass.detail = "Call to Arms"
TrackerClass.icon = "Interface\\ICONS\\INV_Misc_QuestionMark"
TrackerClass.info = "The current Call to Arms"
TrackerClass.colSpan = 1
TrackerClass.options = {}
TrackerClass.justify = "left"
TrackerClass.frame = nil
local _defaultOPtions = BGS_TrackerClasses:CreateDefaultTrackerOptions()
table.insert(BGS_TrackerClasses, {class = TrackerClass})
-- Tracker Specific variables
local updateTimer = 0
local _holidayInfoList = {{full = "Warsong Gulch", short = "WSG", shortPers = "WSG", icon = "Interface\\ICONS\\INV_Misc_Rune_07"}
						,{full = "Arathi Basin", short = "AB", shortPers = "AB", icon = "Interface\\ICONS\\INV_Jewelry_Amulet_07"}
						,{full = "Alterac Valley", short = "AV", shortPers = "AV", icon = "Interface\\ICONS\\INV_Jewelry_Necklace_21"}
						,{full = "Eye of the Storm", short = "EotS", shortPers = "EotS", icon = "Interface\\ICONS\\Spell_Nature_EyeOfTheStorm"}
						,{full = "Strand of the Ancients", short = "SotA", shortPers = "SotA", icon = "Interface\\ICONS\\Achievement_BG_winSOA"}
						,{full = "Isle of Conquest", short = "IoC", shortPers = "IoC", icon = "Interface\\ICONS\\Achievement_BG_winWSG"}
						,{full = "The Battle for Gilneas", short = "BfG", shortPers = "BfG", icon = "Interface\\ICONS\\Achievement_Battleground_BattleForGilneas"}
						,{full = "Twin Peaks", short = "Twin Peaks", shortPers = "Twin Peaks", icon = "Interface\\ICONS\\spell_nature_earthshock"}
						,{full = "Silvershard Mines", short = "Silv. Mines", shortPers = "Silv. Mines", icon = "Interface\\ICONS\\INV_Crate_07"}
						,{full = "Temple of Kotmogu", short = "Temp. of K.", shortPers = "Temp. of K.", icon = "Interface\\ICONS\\Achievement_Battleground_TempleOfKotmogu_02"}
						,{full = "Deepwind Gorge", short = "Deepw. G.", shortPers = "Deepw. G.", icon = "Interface\\ICONS\\achievement_zone_valleyoffourwinds"}
						}
local useShortName = true
local __



--------------------------------------------------------------------------------
-- General Tracker Methods
--------------------------------------------------------------------------------

function TrackerClass:SetColspan(cols, maxCols)
	TrackerClass.colSpan = cols
	--_OptionTable.txtTrackerClass.colSpan:SetText(TrackerClass.colSpan)
	_defaultOPtions.sl_ColSpan:SetSliderValues(1, maxCols, 1)
	_defaultOPtions.sl_ColSpan:SetValue(TrackerClass.colSpan)
end

local function UpdateHolidayInfo()
	local holidayFrame = BGS_TrackerClasses:GetFrameByName(TrackerClass.name)
	local IconPath = [[InterFace\ICONS\Spell_Shadow_Twilight]];
	local ShortStr = "" .. BGS_TrackerClasses:GetBGHoliday()
	for k, v in ipairs(_holidayInfoList) do
		if (v.full == ShortStr) then
			holidayFrame.text:SetWidth(0)
			if (useShortName) then
				ShortStr = v.shortPers
			end
			IconPath = v.icon;
			holidayFrame.text:SetText(ShortStr)
			holidayFrame.icon:SetTexture(IconPath)
			
			--local textLength = holidayFrame.text:GetWidth()
			--if (textLength > (holidayFrame:GetWidth() *TrackerClass.colSpan - 27)) then
			--	holidayFrame.text:SetWidth(holidayFrame:GetWidth() *TrackerClass.colSpan - 27)
			--end
			
			return
		end
	end
	
	ShortStr = "Unknown BG"
	holidayFrame.text:SetText(ShortStr)
	holidayFrame.icon:SetTexture(IconPath)
end

local function CreateSpecificOptions()

	local scrollcontainer = AceGUI:Create("SimpleGroup")
	scrollcontainer:SetFullWidth(true)
	scrollcontainer:SetWidth(185)
	scrollcontainer:SetFullHeight(true)
	scrollcontainer:SetHeight(170)
	scrollcontainer:SetLayout("Fill")

	table.insert(TrackerClass.options, scrollcontainer)

	local scroll = AceGUI:Create("ScrollFrame")
	scroll:SetLayout("Flow")
	scrollcontainer:AddChild(scroll)
	
	-- Tracker Info
	_defaultOPtions.frameDetail.text:SetText(TrackerClass.info)
	scroll:AddChild(_defaultOPtions.frameDetail)
	
	-- Tracker Slider
	_defaultOPtions.sl_ColSpan:SetCallback("OnMouseUp", function(__,__,value)
		local frame = BGS_TrackerClasses:GetFrameByName(TrackerClass.name)
		frame.colSpan = tonumber(value)
		BGS_TrackerClasses:TrackFramePos()
	end)
	scroll:AddChild(_defaultOPtions.sl_ColSpan)
	
	-- Tracker Text Alignment
	_defaultOPtions.ddwn_Align:SetCallback("OnValueChanged", function(_,_, choise)
		TrackerClass.justify = choise
		TrackerClass.frame.text:SetJustifyH(TrackerClass.justify)
	end)
	scroll:AddChild(_defaultOPtions.ddwn_Align)

	local cbx_abbr = AceGUI:Create("CheckBox")
	--cbx_abbr.frame:SetParent(optionFrame)
	cbx_abbr:SetLabel("Use abbreviations")
	cbx_abbr:SetFullWidth(true)
	cbx_abbr:SetValue(true)
	cbx_abbr:SetCallback("OnValueChanged", function(__,__, value)
		useShortName = value
		UpdateHolidayInfo()
	end)

	TrackerClass.options.cbx_abbr = cbx_abbr

	scroll:AddChild(cbx_abbr)
	
	for key, name in ipairs(_holidayInfoList) do
		local txt_Short = AceGUI:Create("EditBox")
		--txt_Short.frame:SetParent(optionFrame)
		txt_Short:SetLabel(name.full)
		txt_Short:SetText(name.short)
		txt_Short:SetWidth(120)
		--txt_Short:SetPoint("topleft", scroll, "topleft", 10, 0)
		txt_Short:SetCallback("OnEnterPressed", function(__,__, value)
			for k, v in ipairs(_holidayInfoList) do
				if (v.full == name.full) then
					v.shortPers = value
				end
			end
			UpdateHolidayInfo()
		end)
	
		name.editBox = txt_Short
		scroll:AddChild(txt_Short)
	
		local btn_Reset = AceGUI:Create("Button")
		--btn_Reset.frame:SetParent(optionFrame)
		btn_Reset:SetText("R")
		btn_Reset.text:SetPoint("TOPLEFT", 5, -1)
		btn_Reset.text:SetPoint("BOTTOMRIGHT", -5, 1)
		btn_Reset:SetWidth(25)
		btn_Reset:SetPoint("bottomleft", txt_Short.frame, "bottomright", 0, 0)
		btn_Reset:SetCallback("OnClick", function() 
			for k, v in ipairs(_holidayInfoList) do
				if (v.full == name.full) then
					v.shortPers = v.short
					txt_Short:SetText(name.short)
				end
			end
			UpdateHolidayInfo()
		end)
	
		scroll:AddChild(btn_Reset)
	end
end

function TrackerClass:Create()
	TrackerClass.frame = BGS_TrackerClasses:CreateTrackerFrame(TrackerClass)
	CreateSpecificOptions()
end

--------------------------------------------------------------------------------
-- Tracker Specific Methods
--------------------------------------------------------------------------------



local function _HolidayFrameScript()
	local holidayFrame = BGS_TrackerClasses:GetFrameByName(TrackerClass.name)
	holidayFrame:SetScript("OnUpdate", function(self,elapsed) 
	updateTimer = updateTimer + elapsed
	if updateTimer >= 60*30 then
		UpdateHolidayInfo()
		updateTimer = 0
	end
	end)
end
	
--------------------------------------------------------------------------------
-- Event Handling
--------------------------------------------------------------------------------

local function eventHandle(self, event, addon)
	if not (BGS_TrackerClasses:GetFrameByName(TrackerClass.name)) then
		return
	end
	
	if event == "PLAYER_PVP_KILLS_CHANGED" then
		--createOptions()
		UpdateHolidayInfo()
	return
	end
	if event == "ADDON_LOADED" then
		if addon ~= addonName then return end
		self:UnregisterEvent("ADDON_LOADED")
		_HolidayFrameScript()
		
		local infoList = BGS_TrackerClasses:GetInfoList(TrackerClass.name)
		
		if not (infoList)then
			return
		end
		
		if infoList.useShort ~= nil then
			useShortName = infoList.useShort
			TrackerClass.options.cbx_abbr:SetValue(useShortName)
		end
		
		if infoList.holidayInfoList ~= nil then
			for k, saved in ipairs(infoList.holidayInfoList) do
				for k, base in ipairs(_holidayInfoList) do
					if base.full == saved.full then
						base.shortPers = saved.shortPers
						base.editBox:SetText(base.shortPers)
					end
				end
			end
		end
		
		local frame = BGS_TrackerClasses:GetFrameByName(TrackerClass.name)
		
		return
	end
	
	if event == "PLAYER_LOGIN" then
		UpdateHolidayInfo()
		local extra = BGS_TrackerClasses:GetInfoList(TrackerClass.name)
		if extra then
			if (extra.colSpan) then
				TrackerClass.colSpan = extra.colSpan
			end
			TrackerClass.frame.colSpan = TrackerClass.colSpan
			_defaultOPtions.sl_ColSpan:SetValue(TrackerClass.colSpan)
			BGS_TrackerClasses:TrackFramePos()
			if(extra.justify) then
				TrackerClass.justify = extra.justify
			end
			_defaultOPtions.ddwn_Align:SetValue(TrackerClass.justify)
			TrackerClass.frame.text:SetJustifyH(TrackerClass.justify)
		end
	end
	
	if event == "PLAYER_LOGOUT" then
		local frame = BGS_TrackerClasses:GetFrameByName(TrackerClass.name)
		
		local smallArray = {}
		
		for k, v in ipairs (_holidayInfoList) do
			local short = {}
			short.full = v.full
			short.shortPers = v.shortPers
			table.insert(smallArray, short)
		
		end
		
		table.insert(BGstats_ExtraFrameDataList, {frame = TrackerClass.name, useShort = useShortName, holidayInfoList = smallArray, colSpan = TrackerClass.colSpan, justify = TrackerClass.justify})
	end
end

local _eventsFrame = CreateFrame("FRAME", "BGS_"..TrackerClass.name.."Events");
_eventsFrame:RegisterEvent("PLAYER_LOGIN");
_eventsFrame:RegisterEvent("ADDON_LOADED");
_eventsFrame:RegisterEvent("PLAYER_LOGOUT");
_eventsFrame:SetScript("OnEvent", function(self, event, ...) eventHandle(self, event, ...) end)