local function lineMatches(line, search_text)
      local foundMatch = false;
      if (string.len(search_text) == 0) then
	      foundMatch = true;
      else
	      if ( string.gmatch ) then 
		if ( string.gmatch(string.lower(line), search_text)() ) then
		   foundMatch = true;
		end
	      else 
		if ( string.gfind(string.lower(line), search_text)() ) then
		   foundMatch = true;
		end
	      end
      end
      return foundMatch;
end

function AtlasMajorCitiesSearch(data, text)
        local new = {};         -- create a new table
        local i;
        local v;
        local n;

        local search_text = string.lower(text);
        local match;

        if ( data.Areas == nil ) then
             if ( search_text == "" ) then
                  new = data;
             else
                  search_text = search_text:gsub("([%^%$%(%)%%%.%[%]%+%-%?])", "%%%1");
                  search_text = search_text:gsub("%*", ".*");

                  i, v = next(data, nil);      -- i is an index of data, v = data[i]
                  n = i;
                  while i do
                        if ( type(i) == "number" ) then
                           if ( string.gmatch ) then
                                match = string.gmatch(string.lower(data[i]), search_text)();
                           else
                                match = string.gfind(string.lower(data[i]), search_text)();
                           end

                           if ( match ) then
                                new[n] = { data[i] };
                                n = n + 1;
                           end
                        end
                        i, v = next(data, i);         -- get next index
                  end
             end
        else
	     n = 1;
	     local areaKey;
	     local areaData;
	     local addSeparator = false;
	     local shownAreaTitle = false;

	     for areaKey,areaData in pairs(data.Areas) do
		   local color = areaData.Color;
		   local areaName = areaData.Name;
		   local labelsKey;
		   local labelsData;
	   	   addSeparator = false;
	           shownAreaTitle = false;

		   for labelsKey,labelsData in pairs(areaData) do
			   local labelKey;
		           local labelData;

			   if ( type(labelsData) == "table" and labelsData.Label ~= nil ) then
			      local labelName = labelsData.Label;
			      local foundMatch = false;
			      for labelKey,labelData in ipairs(labelsData) do
			          if (lineMatches(labelData, search_text)) then
				      foundMatch = true;
				      break;
			          end
			      end

			      if ( foundMatch ) then
				  for labelKey,labelData in ipairs(labelsData) do
					 if (not shownAreaTitle) then
					    new[n] = { color..areaName };
					    n = n + 1;
					    shownAreaTitle = true;
					    if (lineMatches(labelData, search_text)) then
					        new[n] = { " "..color..labelName..") "..labelData };
					    else
					        new[n] = { " ".."|c88888888"..labelName..") "..labelData };
					    end
					 else
					    if ( labelKey > 1 ) then
						if (lineMatches(labelData, search_text)) then
						    new[n] = { " ".."|c00000000"..labelName..") "..color..labelData };
						else
						    new[n] = { " ".."|c00000000"..labelName..") ".."|c88888888"..labelData };
						end
					    else
						if (lineMatches(labelData, search_text)) then
						    new[n] = { " "..color..labelName..") "..labelData };
						else
						    new[n] = { " ".."|c88888888"..labelName..") "..labelData };
						end
					    end
					 end
					 n = n + 1;
					 addSeparator = true;
				  end
			      end
			end
		  end
		  if (addSeparator) then
		           new[n] = { " " };
		           n = n + 1;
		  end
	     end
	end

	return new;
end
