--[[

	Atlas Arena, a World of Warcraft instance map browser
	Copyright 2010 Arith Hsu

	This file is a plugin of Atlas.

	Atlas Arena is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]
local BabbleSubZone = Atlas_GetLocaleLibBabble("LibBabble-SubZone-3.0");
local BabbleZone = Atlas_GetLocaleLibBabble("LibBabble-Zone-3.0");

local BLUE = "|cff6666ff";
local GREY = "|cff999999";
local GREN = "|cff66cc33";
local YELL = "|cffcccc00";
local _RED = "|cffcc6666";
local ORNG = "|cffcc9933";
local PURP = "|cff9900ff";
local WHITE = "|cffffffff";
local CYAN = "|cff008888";
local INVIS = "|c00000000";
local INDENT = "   ";

local myCategory = AtlasArenaLocale["Arena Maps"];

local myData = {
	-- Blade's Edge Arena
	CircleOfBlood = {
		ZoneName = { BabbleSubZone["Blade's Edge Arena"] };
		Location = { BabbleSubZone["Circle of Blood Arena"]..", "..BabbleZone["Blade's Edge Mountains"] };
		LevelRange = "10-70";
		PlayerLimit = "2v2, 3v3, 5v5";
		{ BLUE..BabbleSubZone["Circle of Blood Arena"] };
		{ };
		{ GREY.."1) "..AtlasArenaLocale["Frixee Brasstumbler <Arena Vendor>"] };
		{ GREY.."2) "..AtlasArenaLocale["Meminnie <Arena Vendor>"] };
	};
	-- Dalaran Arena
	Dalaran_Sewers = {
		ZoneName = { BabbleSubZone["Dalaran Arena"] };
		Location = { BabbleZone["Dalaran Sewers"]..", "..BabbleZone["Dalaran"] };
		LevelRange = "10-80";
		PlayerLimit = "2v2, 3v3, 5v5";
		{ BLUE..BabbleSubZone["Dalaran Arena"] };
		{ };
		{ GREY.."1) "..AtlasArenaLocale["Xazi Smolderpipe <Arena Vendor>"] };
		{ GREY.."2) "..AtlasArenaLocale["Zom Bocom <Apprentice Arena Vendor>"] };
		{ GREY.."3) "..AtlasArenaLocale["Nargle Lashcord <Veteran Arena Vendor>"] };
		{ GREY.."4) "..AtlasArenaLocale["Trapjaw Rix <Exceptional Arena Weaponry>"] };
	};
	-- Nagrand Arena
	RingOfTrials = {
		ZoneName = { BabbleSubZone["Nagrand Arena"] };
		Location = { BabbleSubZone["The Ring of Trials"]..", "..BabbleZone["Nagrand"] };
		LevelRange = "10-70";
		PlayerLimit = "2v2, 3v3, 5v5";
		{ BLUE..BabbleSubZone["Nagrand Arena"] };
		{ };
		{ GREY.."1) "..AtlasArenaLocale["Kelara <Keeper of Sha'tari Heirlooms>"] };
		{ GREY.."2) "..AtlasArenaLocale["Grikkin Copperspring <Arena Vendor>"] };
	};
	-- The Ring of Valor
	RingOfValor = {
		ZoneName = { BabbleSubZone["The Ring of Valor"] };
		Location = { BabbleZone["Orgrimmar"] };
		LevelRange = "10-80";
		PlayerLimit = "2v2, 3v3, 5v5";
		{ BLUE..BabbleSubZone["The Ring of Valor"] };
	};
	-- Ruins of Lordaeron
	RuinsOfLordaeron = {
		ZoneName = { BabbleZone["Ruins of Lordaeron"] };
		Location = { BabbleZone["Ruins of Lordaeron"] };
		LevelRange = "10-70";
		PlayerLimit = "2v2, 3v3, 5v5";
		{ BLUE..BabbleZone["Ruins of Lordaeron"] };
	};
	-- Gurubashi Arena
	GurubashiArena = {
		ZoneName = { BabbleSubZone["Gurubashi Arena"] };
		Location = { BabbleZone["Stranglethorn Vale"] };
		LevelRange = "30-45";
		PlayerLimit = "N/A";
		{ BLUE..BabbleSubZone["Gurubashi Arena"] };
		{ };
		{ GREY.."1) "..AtlasArenaLocale["Short John Mithril"] };
	};
	-- The Rumble Cage
	RumbleCage = {
		ZoneName = { BabbleSubZone["The Rumble Cage"] };
		Location = { BabbleSubZone["Gadgetzan"]..", "..BabbleZone["Tanaris"] };
		LevelRange = "40-50";
		PlayerLimit = "2v2, 3v3, 5v5";
		{ BLUE..BabbleSubZone["The Rumble Cage"] };
		{ };
		{ GREY.."1) "..AtlasArenaLocale["Max Luna <Arena Battlemaster>"] };
		{ GREY.."2) "..AtlasArenaLocale["Vixton Pinchwhistle <Brutal Arena Vendor>"] };
		{ GREY.."3) "..AtlasArenaLocale["Ecton Brasstumbler <Apprentice Arena Vendor>"] };
		{ GREY.."4) "..AtlasArenaLocale["Evee Copperspring <Arena Vendor>"] };
		{ GREY.."5) "..AtlasArenaLocale["Argex Irongut <Veteran Arena Vendor>"] };
		{ GREY.."6) "..AtlasArenaLocale["Blazzek the Biter <Exceptional Arena Weaponry>"] };
		{ GREY.."7) "..AtlasArenaLocale["Bip Nigstrom <Arena Organizer>"] };
	};
};


Atlas_RegisterPlugin("Atlas_Arena", myCategory, myData);
