Assassin_UpdateInterval = 0.1;

function Assassin_OnLoad()
 this:RegisterEvent("UNIT_COMBO_POINTS");
 this:RegisterEvent("VARIABLES_LOADED");
 this:RegisterEvent("PLAYER_TARGET_CHANGED");
end

function Assassin_OnEvent()
	if((event == "VARIABLES_LOADED")) then
		AssassinFrame:RegisterForDrag("LeftButton");
		ComboText:SetText("0/0");
		ComboBar:SetMinMaxValues(0,5);
		ComboBar:SetValue(0);
		SliceText:SetText("0");
		SliceBar:SetMinMaxValues(0,0);
		SliceBar:SetValue(0);
		HungerText:SetText("0");
		HungerBar:SetMinMaxValues(0,0);
		HungerBar:SetValue(0);
		RuptureText:SetText("0");
		RuptureBar:SetMinMaxValues(0,0);
		RuptureBar:SetValue(0);
		AssassinFrame:Show();
		AssassinFrame.TimeSinceLastUpdate = 0;
	end		
	if((event == "UNIT_COMBO_POINTS")) then
		Assassin_showCombo(GetComboPoints("player"));
	end
	if((event == "PLAYER_TARGET_CHANGED")) then
		Assassin_showCombo(GetComboPoints("player"));
	end
end

function Assassin_OnUpdate(AssassinFrame, elapsed)
	AssassinFrame.TimeSinceLastUpdate = AssassinFrame.TimeSinceLastUpdate + elapsed;
	if (AssassinFrame.TimeSinceLastUpdate > Assassin_UpdateInterval) then
		Assassin_doSnD();
		Assassin_doHfB();
		Assassin_doRup();
		AssassinFrame.TimeSinceLastUpdate = 0;
	end
end

function Assassin_showCombo(numberCP)
	ComboBar:SetValue(numberCP);
	ComboText:SetText(numberCP .. "/5");
end

function Assassin_doSnD()
	name, rank, icon, count, debuffType, duration, expirationTime, isMine, isStealable = UnitBuff("player", "Slice and Dice");
	if not name then
		SliceText:SetText("0");
		SliceBar:SetValue(0);
		return;
	end
	theBuffTime = string.format("%.1f", expirationTime - GetTime());
	SliceText:SetText(theBuffTime);
	SliceBar:SetMinMaxValues(0, duration);
	SliceBar:SetValue(theBuffTime);
end
function Assassin_doHfB()
	name, rank, icon, count, debuffType, duration, expirationTime, isMine, isStealable = UnitBuff("player", "Hunger for Blood");
	if not name then
		HungerText:SetText("0");
		HungerBar:SetValue(0);
		return;
	end
	theBuffTime = string.format("%.1f", expirationTime - GetTime());
	HungerText:SetText("(" .. count ..") " .. theBuffTime);
	HungerBar:SetMinMaxValues(0, duration);
	HungerBar:SetValue(theBuffTime);
end

function Assassin_doRup()
	name, rank, icon, count, debuffType, duration, expirationTime, isMine, isStealable = UnitDebuff("target", "Rupture");
	if not name then
		RuptureText:SetText("0");
		RuptureBar:SetValue(0);
		return;
	end
	if isMine then
		theBuffTime = string.format("%.1f", expirationTime - GetTime());
		RuptureText:SetText(theBuffTime);
		RuptureBar:SetMinMaxValues(0, duration);
		RuptureBar:SetValue(theBuffTime);
	end
end
function Assassin_OnDragStart()
	 AssassinFrame:StartMoving();
end

function Assassin_OnDragStop()
	AssassinFrame:StopMovingOrSizing()
end