--[[
    Armory Addon for World of Warcraft(tm).
    Revision: 310 2010-08-20T17:28:21Z
    URL: http://www.wow-neighbours.com

    License:
        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program(see GPL.txt); if not, write to the Free Software
        Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    Note:
        This AddOn's source code is specifically designed to work with
        World of Warcraft's interpreted AddOn system.
        You have an implicit licence to use this AddOn with these facilities
        since that is it's designated purpose as per:
        http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat
--]]

local L = LibStub("AceLocale-3.0"):GetLocale("Armory");

-- Startup
SLASH_ARMORY1 = "/armory";

if ( L["ARMORY_SLASH_ALTERNATIVES"] ~= "ARMORY_SLASH_ALTERNATIVES" ) then
    local function GetWords(string)
        local words = {};
        for word in string:gmatch("%S+") do
            word = word:gsub("/", "");
            table.insert(words, word);
        end
        return words;
    end
    for i, command in ipairs(GetWords(L["ARMORY_SLASH_ALTERNATIVES"])) do
        _G["SLASH_ARMORY"..(i + 1)] = "/"..command;
    end
else
    SLASH_ARMORY2 = "/ar";
end

-- General
ARMORY_TITLE                                = "Armory";
ARMORY_TOOLTIP1                             = L["ARMORY_TOOLTIP1"];
ARMORY_TOOLTIP2                             = L["ARMORY_TOOLTIP2"];
ARMORY_TOOLTIP_HINT1                        = L["ARMORY_TOOLTIP_HINT1"];
ARMORY_TOOLTIP_HINT2                        = L["ARMORY_TOOLTIP_HINT2"];
ARMORY_SUBTEXT                              = L["ARMORY_SUBTEXT"];
ARMORY_TOOLTIP_LABEL                        = L["ARMORY_TOOLTIP_LABEL"];
ARMORY_TOOLTIP_TITLE                        = L["ARMORY_TOOLTIP_TITLE"];
ARMORY_TOOLTIP_SUBTEXT                      = L["ARMORY_TOOLTIP_SUBTEXT"];
ARMORY_MINIMAP_LABEL                        = L["ARMORY_MINIMAP_LABEL"];
ARMORY_MINIMAP_TITLE                        = L["ARMORY_MINIMAP_TITLE"];
ARMORY_MINIMAP_SUBTEXT                      = L["ARMORY_MINIMAP_SUBTEXT"];
ARMORY_MODULES_LABEL                        = L["ARMORY_MODULES_LABEL"];
ARMORY_MODULES_TITLE                        = L["ARMORY_MODULES_TITLE"];
ARMORY_MODULES_SUBTEXT                      = L["ARMORY_MODULES_SUBTEXT"];
ARMORY_FIND_LABEL                           = L["ARMORY_FIND_LABEL"];
ARMORY_FIND_TITLE                           = L["ARMORY_FIND_TITLE"];
ARMORY_FIND_SUBTEXT                         = L["ARMORY_FIND_SUBTEXT"];
ARMORY_EXPIRATION_LABEL                     = L["ARMORY_EXPIRATION_LABEL"];
ARMORY_EXPIRATION_TITLE                     = L["ARMORY_EXPIRATION_TITLE"];
ARMORY_EXPIRATION_SUBTEXT                   = L["ARMORY_EXPIRATION_SUBTEXT"];
ARMORY_SHARE_LABEL                          = L["ARMORY_SHARE_LABEL"];
ARMORY_SHARE_TITLE                          = L["ARMORY_SHARE_TITLE"];
ARMORY_SHARE_SUBTEXT1                       = L["ARMORY_SHARE_SUBTEXT1"];
ARMORY_SHARE_SUBTEXT2                       = L["ARMORY_SHARE_SUBTEXT2"];
ARMORY_SHARE_DOWNLOAD_ADDON                 = "ArmoryGuildRecipes";
ARMORY_SHARE_DOWNLOAD_LOADERROR             = L["ARMORY_SHARE_DOWNLOAD_LOADERROR"];
ARMORY_MISC_LABEL                           = L["ARMORY_MISC_LABEL"];
ARMORY_MISC_TITLE                           = L["ARMORY_MISC_TITLE"];
ARMORY_MISC_SUBTEXT                         = L["ARMORY_MISC_SUBTEXT"];
ARMORY_FILTER_LABEL                         = L["ARMORY_FILTER_LABEL"];
ARMORY_FILTER_ENABLE                        = L["ARMORY_FILTER_ENABLE"];
ARMORY_FILTER_DISABLE                       = L["ARMORY_FILTER_DISABLE"];
ARMORY_FILTER_ALL                           = L["ARMORY_FILTER_ALL"];
ARMORY_FILTER_CLEAR                         = L["ARMORY_FILTER_CLEAR"];
ARMORY_FILTER_TOOLTIP                       = L["ARMORY_FILTER_TOOLTIP"];
ARMORY_FONT_COLOR                           = L["ARMORY_FONT_COLOR"];
ARMORY_MESSAGE_FILTER                       = L["ARMORY_MESSAGE_FILTER"];
ARMORY_WHO                                  = L["ARMORY_WHO"];
ARMORY_WHERE                                = L["ARMORY_WHERE"];
ARMORY_WHAT                                 = L["ARMORY_WHAT"];
ARMORY_SEARCHING                            = L["ARMORY_SEARCHING"];
ARMORY_GLOBAL                               = L["ARMORY_GLOBAL"];
ARMORY_EXTENDED                             = L["ARMORY_EXTENDED"];
ARMORY_SUMMARY_LABEL                        = L["ARMORY_SUMMARY_LABEL"];
ARMORY_SUMMARY_SUBTEXT1                     = L["ARMORY_SUMMARY_SUBTEXT1"];
ARMORY_SUMMARY_SUBTEXT2                     = L["ARMORY_SUMMARY_SUBTEXT2"];
ARMORY_SUMMARY_TITLE                        = L["ARMORY_SUMMARY_TITLE"];
ARMORY_SHORTDATE_FORMAT                     = L["ARMORY_SHORTDATE_FORMAT"];
ARMORY_WARNING                              = L["ARMORY_WARNING"];
ARMORY_ERROR                                = L["ARMORY_ERROR"];
ARMORY_INFO                                 = L["ARMORY_INFO"];
ARMORY_OPEN_HINT                            = L["ARMORY_OPEN_HINT"];
ARMORY_LINK_HINT                            = L["ARMORY_LINK_HINT"];
ARMORY_BY_DATE                              = L["ARMORY_BY_DATE"];
ARMORY_BY_GROUP                             = L["ARMORY_BY_GROUP"];

-- Configuration variables
ARMORY_CMD_TOGGLE                           = L["ARMORY_CMD_TOGGLE"];
ARMORY_CMD_USAGE                            = L["ARMORY_CMD_USAGE"];
ARMORY_CMD_HELP                             = L["ARMORY_CMD_HELP"];
ARMORY_CMD_HELP_TEXT                        = L["ARMORY_CMD_HELP_TEXT"];
ARMORY_CMD_CONFIG                           = L["ARMORY_CMD_CONFIG"];
ARMORY_CMD_CONFIG_TEXT                      = L["ARMORY_CMD_CONFIG_TEXT"];
ARMORY_CMD_CONFIG_MENUTEXT                  = ALL_SETTINGS;
ARMORY_CMD_DELETE                           = L["ARMORY_CMD_DELETE"];
ARMORY_CMD_DELETE_ALL                       = L["ARMORY_CMD_DELETE_ALL"];
ARMORY_CMD_DELETE_ALL_TEXT                  = L["ARMORY_CMD_DELETE_ALL_TEXT"];
ARMORY_CMD_DELETE_ALL_MSG                   = L["ARMORY_CMD_DELETE_ALL_MSG"];
ARMORY_CMD_DELETE_REALM                     = L["ARMORY_CMD_DELETE_REALM"];
ARMORY_CMD_DELETE_REALM_PARAMS_TEXT         = L["ARMORY_CMD_DELETE_REALM_PARAMS_TEXT"];
ARMORY_CMD_DELETE_REALM_TEXT                = L["ARMORY_CMD_DELETE_REALM_TEXT"];
ARMORY_CMD_DELETE_REALM_MSG                 = L["ARMORY_CMD_DELETE_REALM_MSG"];
ARMORY_CMD_DELETE_REALM_NOT_FOUND           = L["ARMORY_CMD_DELETE_REALM_NOT_FOUND"];
ARMORY_CMD_DELETE_CHAR                      = L["ARMORY_CMD_DELETE_CHAR"];
ARMORY_CMD_DELETE_CHAR_PARAMS_TEXT          = L["ARMORY_CMD_DELETE_CHAR_PARAMS_TEXT"];
ARMORY_CMD_DELETE_CHAR_TEXT                 = L["ARMORY_CMD_DELETE_CHAR_TEXT"];
ARMORY_CMD_DELETE_CHAR_MSG                  = L["ARMORY_CMD_DELETE_CHAR_MSG"];
ARMORY_CMD_DELETE_CHAR_NOT_FOUND            = L["ARMORY_CMD_DELETE_CHAR_NOT_FOUND"];
ARMORY_CMD_SET                              = "set";
ARMORY_CMD_SET_NOVALUE                      = L["ARMORY_CMD_SET_NOVALUE"];
ARMORY_CMD_SET_NOVALUE_TEXT                 = L["ARMORY_CMD_SET_NOVALUE_TEXT"];
ARMORY_CMD_SET_SUCCESS                      = L["ARMORY_CMD_SET_SUCCESS"];
ARMORY_CMD_SET_ON                           = L["ARMORY_CMD_SET_ON"];
ARMORY_CMD_SET_OFF                          = L["ARMORY_CMD_SET_OFF"];
ARMORY_CMD_SET_PAUSEINCOMBAT                = "pincmbt";
ARMORY_CMD_SET_PAUSEINCOMBAT_TEXT           = L["ARMORY_CMD_SET_PAUSEINCOMBAT_TEXT"];
ARMORY_CMD_SET_PAUSEINCOMBAT_MENUTEXT       = L["ARMORY_CMD_SET_PAUSEINCOMBAT_MENUTEXT"];
ARMORY_CMD_SET_PAUSEINCOMBAT_TOOLTIP        = L["ARMORY_CMD_SET_PAUSEINCOMBAT_TOOLTIP"];
ARMORY_CMD_SET_PAUSEININSTANCE              = "pininst";
ARMORY_CMD_SET_PAUSEININSTANCE_TEXT         = L["ARMORY_CMD_SET_PAUSEININSTANCE_TEXT"];
ARMORY_CMD_SET_PAUSEININSTANCE_MENUTEXT     = L["ARMORY_CMD_SET_PAUSEININSTANCE_MENUTEXT"];
ARMORY_CMD_SET_PAUSEININSTANCE_TOOLTIP      = L["ARMORY_CMD_SET_PAUSEININSTANCE_TOOLTIP"];
ARMORY_CMD_SET_EXPDAYS                      = "expdays";
ARMORY_CMD_SET_EXPDAYS_PARAMS_TEXT          = "<" .. L["ARMORY_CMD_SET_EXPDAYS_PARAMS_TEXT"] .. ">";
ARMORY_CMD_SET_EXPDAYS_TEXT                 = L["ARMORY_CMD_SET_EXPDAYS_TEXT"];
ARMORY_CMD_SET_EXPDAYS_INVALID              = L["ARMORY_CMD_SET_EXPDAYS_INVALID"];
ARMORY_CMD_SET_EXPDAYS_TOOLTIP              = L["ARMORY_CMD_SET_EXPDAYS_TOOLTIP"];
ARMORY_CMD_SET_IGNOREALTS                   = "ignalts";
ARMORY_CMD_SET_IGNOREALTS_TEXT              = L["ARMORY_CMD_SET_IGNOREALTS_TEXT"];
ARMORY_CMD_SET_IGNOREALTS_MENUTEXT          = L["ARMORY_CMD_SET_IGNOREALTS_MENUTEXT"];
ARMORY_CMD_SET_IGNOREALTS_TOOLTIP           = L["ARMORY_CMD_SET_IGNOREALTS_TOOLTIP"];
ARMORY_CMD_SET_MAILCHECKVISIT               = "chkmvst";
ARMORY_CMD_SET_MAILCHECKVISIT_TEXT          = L["ARMORY_CMD_SET_MAILCHECKVISIT_TEXT"];
ARMORY_CMD_SET_MAILCHECKVISIT_MENUTEXT      = L["ARMORY_CMD_SET_MAILCHECKVISIT_MENUTEXT"];
ARMORY_CMD_SET_MAILCHECKVISIT_TOOLTIP       = L["ARMORY_CMD_SET_MAILCHECKVISIT_TOOLTIP"];
ARMORY_CMD_SET_MAILEXCLUDEVISIT             = "exclvst";
ARMORY_CMD_SET_MAILEXCLUDEVISIT_TEXT        = L["ARMORY_CMD_SET_MAILEXCLUDEVISIT_TEXT"];
ARMORY_CMD_SET_MAILEXCLUDEVISIT_MENUTEXT    = L["ARMORY_CMD_SET_MAILEXCLUDEVISIT_MENUTEXT"];
ARMORY_CMD_SET_MAILEXCLUDEVISIT_TOOLTIP     = L["ARMORY_CMD_SET_MAILEXCLUDEVISIT_TOOLTIP"];
ARMORY_CMD_SET_MAILCHECKCOUNT               = "chkmcnt";
ARMORY_CMD_SET_MAILCHECKCOUNT_TEXT          = L["ARMORY_CMD_SET_MAILCHECKCOUNT_TEXT"];
ARMORY_CMD_SET_MAILCHECKCOUNT_MENUTEXT      = L["ARMORY_CMD_SET_MAILCHECKCOUNT_MENUTEXT"];
ARMORY_CMD_SET_MAILCHECKCOUNT_TOOLTIP       = L["ARMORY_CMD_SET_MAILCHECKCOUNT_TOOLTIP"];
ARMORY_CMD_SET_MAILHIDECOUNT                = "hidemcnt";
ARMORY_CMD_SET_MAILHIDECOUNT_TEXT           = L["ARMORY_CMD_SET_MAILHIDECOUNT_TEXT"];
ARMORY_CMD_SET_MAILHIDECOUNT_MENUTEXT       = L["ARMORY_CMD_SET_MAILHIDECOUNT_MENUTEXT"];
ARMORY_CMD_SET_MAILHIDECOUNT_TOOLTIP        = L["ARMORY_CMD_SET_MAILHIDECOUNT_TOOLTIP"];
ARMORY_CMD_SET_MAILHIDELOGONCOUNT           = "hidemlcnt";
ARMORY_CMD_SET_MAILHIDELOGONCOUNT_TEXT      = L["ARMORY_CMD_SET_HIDELOGON_TEXT"];
ARMORY_CMD_SET_MAILHIDELOGONCOUNT_MENUTEXT  = L["ARMORY_CMD_SET_HIDELOGON_MENUTEXT"];
ARMORY_CMD_SET_MAILHIDELOGONCOUNT_TOOLTIP   = L["ARMORY_CMD_SET_HIDELOGON_TOOLTIP"];
ARMORY_CMD_SET_MAILHIDELOGONVISIT           = "hidemlvst";
ARMORY_CMD_SET_MAILHIDELOGONVISIT_TEXT      = L["ARMORY_CMD_SET_HIDELOGON_TEXT"];
ARMORY_CMD_SET_MAILHIDELOGONVISIT_MENUTEXT  = L["ARMORY_CMD_SET_HIDELOGON_MENUTEXT"];
ARMORY_CMD_SET_MAILHIDELOGONVISIT_TOOLTIP   = L["ARMORY_CMD_SET_HIDELOGON_TOOLTIP"];
ARMORY_CMD_SET_SEARCHALL                    = "savesac";
ARMORY_CMD_SET_SEARCHALL_TEXT               = L["ARMORY_CMD_SET_SEARCHALL_TEXT"];
ARMORY_CMD_SET_SEARCHALL_MENUTEXT           = L["ARMORY_CMD_SET_SEARCHALL_MENUTEXT"];
ARMORY_CMD_SET_SEARCHALL_TOOLTIP            = L["ARMORY_CMD_SET_SEARCHALL_TOOLTIP"];
ARMORY_CMD_SET_LASTVIEWED                   = "savelcv";
ARMORY_CMD_SET_LASTVIEWED_TEXT              = L["ARMORY_CMD_SET_LASTVIEWED_TEXT"];
ARMORY_CMD_SET_LASTVIEWED_MENUTEXT          = L["ARMORY_CMD_SET_LASTVIEWED_MENUTEXT"];
ARMORY_CMD_SET_LASTVIEWED_TOOLTIP           = L["ARMORY_CMD_SET_LASTVIEWED_TOOLTIP"];
ARMORY_CMD_SET_PERCHARACTER                 = "savepch";
ARMORY_CMD_SET_PERCHARACTER_TEXT            = L["ARMORY_CMD_SET_PERCHARACTER_TEXT"];
ARMORY_CMD_SET_PERCHARACTER_MENUTEXT        = L["ARMORY_CMD_SET_PERCHARACTER_MENUTEXT"];
ARMORY_CMD_SET_PERCHARACTER_TOOLTIP         = L["ARMORY_CMD_SET_PERCHARACTER_TOOLTIP"];
ARMORY_CMD_SET_SHOWALTEQUIP                 = "showalt";
ARMORY_CMD_SET_SHOWALTEQUIP_TEXT            = L["ARMORY_CMD_SET_SHOWALTEQUIP_TEXT"];
ARMORY_CMD_SET_SHOWALTEQUIP_MENUTEXT        = L["ARMORY_CMD_SET_SHOWALTEQUIP_MENUTEXT"];
ARMORY_CMD_SET_SHOWALTEQUIP_TOOLTIP         = L["ARMORY_CMD_SET_SHOWALTEQUIP_TOOLTIP"];
ARMORY_CMD_SET_SHOWUNEQUIP                  = "showunq";
ARMORY_CMD_SET_SHOWUNEQUIP_TEXT             = L["ARMORY_CMD_SET_SHOWUNEQUIP_TEXT"];
ARMORY_CMD_SET_SHOWUNEQUIP_MENUTEXT         = L["ARMORY_CMD_SET_SHOWUNEQUIP_MENUTEXT"];
ARMORY_CMD_SET_SHOWUNEQUIP_TOOLTIP          = L["ARMORY_CMD_SET_SHOWUNEQUIP_TOOLTIP"];
ARMORY_CMD_SET_SHOWEQCTOOLTIPS              = "showect";
ARMORY_CMD_SET_SHOWEQCTOOLTIPS_TEXT         = L["ARMORY_CMD_SET_SHOWEQCTOOLTIPS_TEXT"];
ARMORY_CMD_SET_SHOWEQCTOOLTIPS_MENUTEXT     = L["ARMORY_CMD_SET_SHOWEQCTOOLTIPS_MENUTEXT"];
ARMORY_CMD_SET_SHOWEQCTOOLTIPS_TOOLTIP      = L["ARMORY_CMD_SET_SHOWEQCTOOLTIPS_TOOLTIP"];
ARMORY_CMD_SET_SHOWITEMCOUNT                = "showict";
ARMORY_CMD_SET_SHOWITEMCOUNT_TEXT           = L["ARMORY_CMD_SET_SHOWITEMCOUNT_TEXT"];
ARMORY_CMD_SET_SHOWITEMCOUNT_MENUTEXT       = L["ARMORY_CMD_SET_SHOWITEMCOUNT_MENUTEXT"];
ARMORY_CMD_SET_SHOWITEMCOUNT_TOOLTIP        = L["ARMORY_CMD_SET_SHOWITEMCOUNT_TOOLTIP"];
ARMORY_CMD_SET_SHOWCOUNTTOTAL               = "showictot";
ARMORY_CMD_SET_SHOWCOUNTTOTAL_TEXT          = L["ARMORY_CMD_SET_SHOWCOUNTTOTAL_TEXT"];
ARMORY_CMD_SET_SHOWCOUNTTOTAL_MENUTEXT      = L["ARMORY_CMD_SET_SHOWCOUNTTOTAL_MENUTEXT"];
ARMORY_CMD_SET_SHOWCOUNTTOTAL_TOOLTIP       = L["ARMORY_CMD_SET_SHOWCOUNTTOTAL_TOOLTIP"];
ARMORY_CMD_SET_COUNTALL                     = "ictcall";
ARMORY_CMD_SET_COUNTALL_TEXT                = L["ARMORY_CMD_SET_COUNTALL_TEXT"];
ARMORY_CMD_SET_COUNTALL_MENUTEXT            = L["ARMORY_CMD_SET_COUNTALL_MENUTEXT"];
ARMORY_CMD_SET_COUNTALL_TOOLTIP             = L["ARMORY_CMD_SET_COUNTALL_TOOLTIP"];
ARMORY_CMD_SET_COUNTXFACTION                = "ictxfact";
ARMORY_CMD_SET_COUNTXFACTION_TEXT           = L["ARMORY_CMD_SET_COUNTXFACTION_TEXT"];
ARMORY_CMD_SET_COUNTXFACTION_MENUTEXT       = L["ARMORY_CMD_SET_COUNTXFACTION_MENUTEXT"];
ARMORY_CMD_SET_COUNTXFACTION_TOOLTIP        = L["ARMORY_CMD_SET_COUNTXFACTION_TOOLTIP"];
ARMORY_CMD_SET_SHOWRECIPEKNOWN              = "showrck";
ARMORY_CMD_SET_SHOWRECIPEKNOWN_TEXT         = L["ARMORY_CMD_SET_SHOWRECIPEKNOWN_TEXT"];
ARMORY_CMD_SET_SHOWRECIPEKNOWN_MENUTEXT     = L["ARMORY_CMD_SET_SHOWRECIPEKNOWN_MENUTEXT"];
ARMORY_CMD_SET_SHOWRECIPEKNOWN_TOOLTIP      = L["ARMORY_CMD_SET_SHOWRECIPEKNOWN_TOOLTIP"];
ARMORY_CMD_SET_SHOWCRAFTERS                 = "showcrft";
ARMORY_CMD_SET_SHOWCRAFTERS_TEXT            = L["ARMORY_CMD_SET_SHOWCRAFTERS_TEXT"];
ARMORY_CMD_SET_SHOWCRAFTERS_MENUTEXT        = L["ARMORY_CMD_SET_SHOWCRAFTERS_MENUTEXT"];
ARMORY_CMD_SET_SHOWCRAFTERS_TOOLTIP         = L["ARMORY_CMD_SET_SHOWCRAFTERS_TOOLTIP"];
ARMORY_CMD_SET_SHOWQUESTALTS                = "showqal";
ARMORY_CMD_SET_SHOWQUESTALTS_TEXT           = L["ARMORY_CMD_SET_SHOWQUESTALTS_TEXT"];
ARMORY_CMD_SET_SHOWQUESTALTS_MENUTEXT       = L["ARMORY_CMD_SET_SHOWQUESTALTS_MENUTEXT"];
ARMORY_CMD_SET_SHOWQUESTALTS_TOOLTIP        = L["ARMORY_CMD_SET_SHOWQUESTALTS_TOOLTIP"];
ARMORY_CMD_SET_SHOWACHIEVEMENTS             = "showach";
ARMORY_CMD_SET_SHOWACHIEVEMENTS_TEXT        = L["ARMORY_CMD_SET_SHOWACHIEVEMENTS_TEXT"];
ARMORY_CMD_SET_SHOWACHIEVEMENTS_MENUTEXT    = L["ARMORY_CMD_SET_SHOWACHIEVEMENTS_MENUTEXT"];
ARMORY_CMD_SET_SHOWACHIEVEMENTS_TOOLTIP     = L["ARMORY_CMD_SET_SHOWACHIEVEMENTS_TOOLTIP"];
ARMORY_CMD_SET_USEINPROGRESSCOLOR           = "ipcolor";
ARMORY_CMD_SET_USEINPROGRESSCOLOR_TEXT      = L["ARMORY_CMD_SET_USEINPROGRESSCOLOR_TEXT"];
ARMORY_CMD_SET_USEINPROGRESSCOLOR_MENUTEXT  = L["ARMORY_CMD_SET_USEINPROGRESSCOLOR_MENUTEXT"];
ARMORY_CMD_SET_USEINPROGRESSCOLOR_TOOLTIP   = L["ARMORY_CMD_SET_USEINPROGRESSCOLOR_TOOLTIP"];
ARMORY_CMD_SET_SHOWGEARSETS                 = "showgset";
ARMORY_CMD_SET_SHOWGEARSETS_TEXT            = L["ARMORY_CMD_SET_SHOWGEARSETS_TEXT"];
ARMORY_CMD_SET_SHOWGEARSETS_MENUTEXT        = L["ARMORY_CMD_SET_SHOWGEARSETS_MENUTEXT"];
ARMORY_CMD_SET_SHOWGEARSETS_TOOLTIP         = L["ARMORY_CMD_SET_SHOWGEARSETS_TOOLTIP"];
ARMORY_CMD_SET_SHOWGEMS                     = "showgems";
ARMORY_CMD_SET_SHOWGEMS_TEXT                = L["ARMORY_CMD_SET_SHOWGEMS_TEXT"];
ARMORY_CMD_SET_SHOWGEMS_MENUTEXT            = L["ARMORY_CMD_SET_SHOWGEMS_MENUTEXT"];
ARMORY_CMD_SET_SHOWGEMS_TOOLTIP             = L["ARMORY_CMD_SET_SHOWGEMS_TOOLTIP"];
ARMORY_CMD_SET_SHOWMINIMAP                  = "showmmb";
ARMORY_CMD_SET_SHOWMINIMAP_TEXT             = L["ARMORY_CMD_SET_SHOWMINIMAP_TEXT"];
ARMORY_CMD_SET_SHOWMINIMAP_MENUTEXT         = L["ARMORY_CMD_SET_SHOWMINIMAP_MENUTEXT"];
ARMORY_CMD_SET_SHOWMINIMAP_TOOLTIP          = L["ARMORY_CMD_SET_SHOWMINIMAP_TOOLTIP"];
ARMORY_CMD_SET_SHOWMMGLOBAL                 = "showlmb";
ARMORY_CMD_SET_SHOWMMGLOBAL_TEXT            = L["ARMORY_CMD_SET_SHOWMMGLOBAL_TEXT"];
ARMORY_CMD_SET_SHOWMMGLOBAL_MENUTEXT        = L["ARMORY_CMD_SET_SHOWMMGLOBAL_MENUTEXT"];
ARMORY_CMD_SET_SHOWMMGLOBAL_TOOLTIP         = L["ARMORY_CMD_SET_SHOWMMGLOBAL_TOOLTIP"];
ARMORY_CMD_SET_HIDEMMTOOLBAR                = "hidemtb";
ARMORY_CMD_SET_HIDEMMTOOLBAR_TEXT           = L["ARMORY_CMD_SET_HIDEMMTOOLBAR_TEXT"];
ARMORY_CMD_SET_HIDEMMTOOLBAR_MENUTEXT       = L["ARMORY_CMD_SET_HIDEMMTOOLBAR_MENUTEXT"];
ARMORY_CMD_SET_HIDEMMTOOLBAR_TOOLTIP        = L["ARMORY_CMD_SET_HIDEMMTOOLBAR_TOOLTIP"];
ARMORY_CMD_SET_MMB_ANGLE                    = "mmbang";
ARMORY_CMD_SET_MMB_ANGLE_TEXT               = L["ARMORY_CMD_SET_MMB_ANGLE_TEXT"];
ARMORY_CMD_SET_MMB_RADIUS                   = "mmbrad";
ARMORY_CMD_SET_MMB_RADIUS_TEXT              = L["ARMORY_CMD_SET_MMB_RADIUS_TEXT"];
ARMORY_CMD_SET_FILTERALL                    = "fltall";
ARMORY_CMD_SET_FILTERALL_TEXT               = L["ARMORY_CMD_SET_FILTERALL_TEXT"];
ARMORY_CMD_SET_FILTERALL_MENUTEXT           = L["ARMORY_CMD_SET_FILTERALL_MENUTEXT"];
ARMORY_CMD_SET_FILTERALL_TOOLTIP            = L["ARMORY_CMD_SET_FILTERALL_TOOLTIP"];
ARMORY_CMD_SET_SHOWSHAREMSG                 = "showsmg";
ARMORY_CMD_SET_SHOWSHAREMSG_TEXT            = L["ARMORY_CMD_SET_SHOWSHAREMSG_TEXT"];
ARMORY_CMD_SET_SHOWSHAREMSG_MENUTEXT        = L["ARMORY_CMD_SET_SHOWSHAREMSG_MENUTEXT"];
ARMORY_CMD_SET_SHOWSHAREMSG_TOOLTIP         = L["ARMORY_CMD_SET_SHOWSHAREMSG_TOOLTIP"];
ARMORY_CMD_SET_SHARESKILLS                  = "shareprf";
ARMORY_CMD_SET_SHARESKILLS_TEXT             = L["ARMORY_CMD_SET_SHARESKILLS_TEXT"];
ARMORY_CMD_SET_SHARESKILLS_MENUTEXT         = L["ARMORY_CMD_SET_SHARESKILLS_MENUTEXT"];
ARMORY_CMD_SET_SHARESKILLS_TOOLTIP          = L["ARMORY_CMD_SET_SHARESKILLS_TOOLTIP"];
ARMORY_CMD_SET_SHAREQUESTS                  = "shareqst";
ARMORY_CMD_SET_SHAREQUESTS_TEXT             = L["ARMORY_CMD_SET_SHAREQUESTS_TEXT"];
ARMORY_CMD_SET_SHAREQUESTS_MENUTEXT         = L["ARMORY_CMD_SET_SHAREQUESTS_MENUTEXT"];
ARMORY_CMD_SET_SHAREQUESTS_TOOLTIP          = L["ARMORY_CMD_SET_SHAREQUESTS_TOOLTIP"];
ARMORY_CMD_SET_SHARECHARACTER               = "sharechr";
ARMORY_CMD_SET_SHARECHARACTER_TEXT          = L["ARMORY_CMD_SET_SHARECHARACTER_TEXT"];
ARMORY_CMD_SET_SHARECHARACTER_MENUTEXT      = L["ARMORY_CMD_SET_SHARECHARACTER_MENUTEXT"];
ARMORY_CMD_SET_SHARECHARACTER_TOOLTIP       = L["ARMORY_CMD_SET_SHARECHARACTER_TOOLTIP"];
ARMORY_CMD_SET_SHAREALT                     = "sharealt";
ARMORY_CMD_SET_SHAREALT_TEXT                = L["ARMORY_CMD_SET_SHAREALT_TEXT"];
ARMORY_CMD_SET_SHAREALT_MENUTEXT            = L["ARMORY_CMD_SET_SHAREALT_MENUTEXT"];
ARMORY_CMD_SET_SHAREALT_TOOLTIP             = L["ARMORY_CMD_SET_SHAREALT_TOOLTIP"];
ARMORY_CMD_SET_SHAREININSTANCE              = "shareini";
ARMORY_CMD_SET_SHAREININSTANCE_TEXT         = L["ARMORY_CMD_SET_SHAREININSTANCE_TEXT"];
ARMORY_CMD_SET_SHAREININSTANCE_MENUTEXT     = L["ARMORY_CMD_SET_SHAREININSTANCE_MENUTEXT"];
ARMORY_CMD_SET_SHAREININSTANCE_TOOLTIP      = L["ARMORY_CMD_SET_SHAREININSTANCE_TOOLTIP"];
ARMORY_CMD_SET_SHAREINCOMBAT                = "shareinc";
ARMORY_CMD_SET_SHAREINCOMBAT_TEXT           = L["ARMORY_CMD_SET_SHAREINCOMBAT_TEXT"];
ARMORY_CMD_SET_SHAREINCOMBAT_MENUTEXT       = L["ARMORY_CMD_SET_SHAREINCOMBAT_MENUTEXT"];
ARMORY_CMD_SET_SHAREINCOMBAT_TOOLTIP        = L["ARMORY_CMD_SET_SHAREINCOMBAT_TOOLTIP"];
ARMORY_CMD_SET_SHAREALL                     = "shareall";
ARMORY_CMD_SET_SHAREALL_TEXT                = L["ARMORY_CMD_SET_SHAREALL_TEXT"];
ARMORY_CMD_SET_SHAREALL_MENUTEXT            = L["ARMORY_CMD_SET_SHAREALL_MENUTEXT"];
ARMORY_CMD_SET_SHAREALL_TOOLTIP             = L["ARMORY_CMD_SET_SHAREALL_TOOLTIP"];
ARMORY_CMD_SET_SHAREGUILD                   = "sharegld";
ARMORY_CMD_SET_SHAREGUILD_TEXT              = L["ARMORY_CMD_SET_SHAREGUILD_TEXT"];
ARMORY_CMD_SET_SHAREGUILD_MENUTEXT          = L["ARMORY_CMD_SET_SHAREGUILD_MENUTEXT"];
ARMORY_CMD_SET_SHAREGUILD_TOOLTIP           = L["ARMORY_CMD_SET_SHAREGUILD_TOOLTIP"];
ARMORY_CMD_SET_SHARECHANNEL                 = "sharechnl";
ARMORY_CMD_SET_SHARECHANNEL_TEXT            = L["ARMORY_CMD_SET_SHARECHANNEL_TEXT"];
ARMORY_CMD_SET_SHARECHANNEL_MENUTEXT        = L["ARMORY_CMD_SET_SHARECHANNEL_MENUTEXT"];
ARMORY_CMD_SET_SHARECHANNEL_TOOLTIP         = L["ARMORY_CMD_SET_SHARECHANNEL_TOOLTIP"];
ARMORY_CMD_SET_WINDOWSEARCH                 = "wndwsrch";
ARMORY_CMD_SET_WINDOWSEARCH_TEXT            = L["ARMORY_CMD_SET_WINDOWSEARCH_TEXT"];
ARMORY_CMD_SET_WINDOWSEARCH_MENUTEXT        = L["ARMORY_CMD_SET_WINDOWSEARCH_MENUTEXT"];
ARMORY_CMD_SET_WINDOWSEARCH_TOOLTIP         = L["ARMORY_CMD_SET_WINDOWSEARCH_TOOLTIP"];
ARMORY_CMD_SET_GLOBALSEARCH                 = "globsrch";
ARMORY_CMD_SET_GLOBALSEARCH_TEXT            = L["ARMORY_CMD_SET_GLOBALSEARCH_TEXT"];
ARMORY_CMD_SET_GLOBALSEARCH_MENUTEXT        = L["ARMORY_CMD_SET_GLOBALSEARCH_MENUTEXT"];
ARMORY_CMD_SET_GLOBALSEARCH_TOOLTIP         = L["ARMORY_CMD_SET_GLOBALSEARCH_TOOLTIP"];
ARMORY_CMD_SET_EXTENDEDSEARCH               = "extdsrch";
ARMORY_CMD_SET_EXTENDEDSEARCH_TEXT          = L["ARMORY_CMD_SET_EXTENDEDSEARCH_TEXT"];
ARMORY_CMD_SET_EXTENDEDSEARCH_MENUTEXT      = L["ARMORY_CMD_SET_EXTENDEDSEARCH_MENUTEXT"];
ARMORY_CMD_SET_EXTENDEDSEARCH_TOOLTIP       = L["ARMORY_CMD_SET_EXTENDEDSEARCH_TOOLTIP"];
ARMORY_CMD_SET_DEFAULTSEARCH                = "dfltsrch";
ARMORY_CMD_SET_DEFAULTSEARCH_TEXT           = L["ARMORY_CMD_SET_DEFAULTSEARCH_TEXT"];
ARMORY_CMD_SET_DEFAULTSEARCH_MENUTEXT       = L["ARMORY_CMD_SET_DEFAULTSEARCH_MENUTEXT"];
ARMORY_CMD_SET_DEFAULTSEARCH_TOOLTIP        = L["ARMORY_CMD_SET_DEFAULTSEARCH_TOOLTIP"];
ARMORY_CMD_SET_LDBLABEL                     = "ldblabel";
ARMORY_CMD_SET_LDBLABEL_TEXT                = L["ARMORY_CMD_SET_LDBLABEL_TEXT"];
ARMORY_CMD_SET_LDBLABEL_MENUTEXT            = L["ARMORY_CMD_SET_LDBLABEL_MENUTEXT"];
ARMORY_CMD_SET_LDBLABEL_TOOLTIP             = L["ARMORY_CMD_SET_LDBLABEL_TOOLTIP"];
ARMORY_CMD_SET_USEENCODING                  = "useenc";
ARMORY_CMD_SET_USEENCODING_TEXT             = L["ARMORY_CMD_SET_USEENCODING_TEXT"];
ARMORY_CMD_SET_USEENCODING_MENUTEXT         = L["ARMORY_CMD_SET_USEENCODING_MENUTEXT"];
ARMORY_CMD_SET_USEENCODING_TOOLTIP          = L["ARMORY_CMD_SET_USEENCODING_TOOLTIP"];
ARMORY_CMD_SET_SHOWNEWBIETIPS               = "shownbie"
ARMORY_CMD_SET_SHOWNEWBIETIPS_MENUTEXT      = SHOW_NEWBIE_TIPS_TEXT;
ARMORY_CMD_SET_SHOWNEWBIETIPS_TEXT          = SHOW_NEWBIE_TIPS_TEXT;
ARMORY_CMD_SET_SHOWNEWBIETIPS_TOOLTIP       = OPTION_TOOLTIP_SHOW_NEWBIE_TIPS;
ARMORY_CMD_SET_EXTENDEDTRADE                = "exttrade";
ARMORY_CMD_SET_EXTENDEDTRADE_TEXT           = L["ARMORY_CMD_SET_EXTENDEDTRADE_TEXT"];
ARMORY_CMD_SET_EXTENDEDTRADE_MENUTEXT       = L["ARMORY_CMD_SET_EXTENDEDTRADE_MENUTEXT"];
ARMORY_CMD_SET_EXTENDEDTRADE_TOOLTIP        = L["ARMORY_CMD_SET_EXTENDEDTRADE_TOOLTIP"];
ARMORY_CMD_SET_SHOWSUMMARY                  = "summary";
ARMORY_CMD_SET_SHOWSUMMARY_MENUTEXT         = L["ARMORY_CMD_SET_SHOWSUMMARY_MENUTEXT"];
ARMORY_CMD_SET_SHOWSUMMARY_TEXT             = L["ARMORY_CMD_SET_SHOWSUMMARY_TEXT"];
ARMORY_CMD_SET_SHOWSUMMARY_TOOLTIP          = L["ARMORY_CMD_SET_SHOWSUMMARY_TOOLTIP"];
ARMORY_CMD_SET_SUMMARYDELAY                 = "sumdelay";
ARMORY_CMD_SET_SUMMARYDELAY_TEXT            = L["ARMORY_CMD_SET_SUMMARYDELAY_TEXT"];
ARMORY_CMD_SET_SUMMARYDELAY_TOOLTIP         = L["ARMORY_CMD_SET_SUMMARYDELAY_TOOLTIP"];
ARMORY_CMD_SET_COOLDOWNEVENTS               = "cdevnts";
ARMORY_CMD_SET_COOLDOWNEVENTS_TEXT          = L["ARMORY_CMD_SET_COOLDOWNEVENTS_TEXT"];
ARMORY_CMD_SET_COOLDOWNEVENTS_MENUTEXT      = L["ARMORY_CMD_SET_COOLDOWNEVENTS_MENUTEXT"];
ARMORY_CMD_SET_COOLDOWNEVENTS_TOOLTIP       = L["ARMORY_CMD_SET_COOLDOWNEVENTS_TOOLTIP"];
ARMORY_CMD_SET_CHECKCOOLDOWNS               = "chkcds";
ARMORY_CMD_SET_CHECKCOOLDOWNS_TEXT          = L["ARMORY_CMD_SET_CHECKCOOLDOWNS_TEXT"];
ARMORY_CMD_SET_CHECKCOOLDOWNS_MENUTEXT      = L["ARMORY_CMD_SET_CHECKCOOLDOWNS_MENUTEXT"];
ARMORY_CMD_SET_CHECKCOOLDOWNS_TOOLTIP       = L["ARMORY_CMD_SET_CHECKCOOLDOWNS_TOOLTIP"];
ARMORY_CMD_SET_EVENTWARNINGS                = "evntwrn";
ARMORY_CMD_SET_EVENTWARNINGS_TEXT           = L["ARMORY_CMD_SET_EVENTWARNINGS_TEXT"];
ARMORY_CMD_SET_EVENTWARNINGS_MENUTEXT       = L["ARMORY_CMD_SET_EVENTWARNINGS_MENUTEXT"];
ARMORY_CMD_SET_EVENTWARNINGS_TOOLTIP        = L["ARMORY_CMD_SET_EVENTWARNINGS_TOOLTIP"];
ARMORY_CMD_SET_EVENTLOCALTIME               = "evntltm";
ARMORY_CMD_SET_EVENTLOCALTIME_TEXT          = L["ARMORY_CMD_SET_EVENTLOCALTIME_TEXT"];
ARMORY_CMD_SET_EVENTLOCALTIME_MENUTEXT      = L["ARMORY_CMD_SET_EVENTLOCALTIME_MENUTEXT"];
ARMORY_CMD_SET_EVENTLOCALTIME_TOOLTIP       = L["ARMORY_CMD_SET_EVENTLOCALTIME_TOOLTIP"];
ARMORY_CMD_RESET                            = L["ARMORY_CMD_RESET"];
ARMORY_CMD_RESET_FRAME                      = L["ARMORY_CMD_RESET_FRAME"];
ARMORY_CMD_RESET_FRAME_TEXT                 = L["ARMORY_CMD_RESET_FRAME_TEXT"];
ARMORY_CMD_RESET_FRAME_MENUTEXT             = L["ARMORY_CMD_RESET_FRAME_MENUTEXT"];
ARMORY_CMD_RESET_FRAME_SUCCESS              = L["ARMORY_CMD_RESET_FRAME_SUCCESS"];
ARMORY_CMD_RESET_SETTINGS                   = L["ARMORY_CMD_RESET_SETTINGS"];
ARMORY_CMD_RESET_SETTINGS_TEXT              = L["ARMORY_CMD_RESET_SETTINGS_TEXT"];
ARMORY_CMD_RESET_SETTINGS_SUCCESS           = L["ARMORY_CMD_RESET_SETTINGS_SUCCESS"];
ARMORY_CMD_CHECK                            = L["ARMORY_CMD_CHECK"];
ARMORY_CMD_CHECK_TEXT                       = L["ARMORY_CMD_CHECK_TEXT"];
ARMORY_CMD_CHECK_MENUTEXT                   = L["ARMORY_CMD_CHECK_MENUTEXT"];
ARMORY_CMD_CHECK_PARAMS_TEXT                = "[" .. L["ARMORY_CMD_SET_EXPDAYS_PARAMS_TEXT"] .. "]";
ARMORY_CMD_CHECK_INVALID                    = L["ARMORY_CMD_CHECK_INVALID"];
ARMORY_CMD_FIND                             = L["ARMORY_CMD_FIND"];
ARMORY_CMD_FIND_TEXT                        = L["ARMORY_CMD_FIND_TEXT"];
ARMORY_CMD_FIND_MENUTEXT                    = L["ARMORY_CMD_FIND_MENUTEXT"];
ARMORY_CMD_FIND_PARAMS_TEXT                 = L["ARMORY_CMD_FIND_PARAMS_TEXT"];
ARMORY_CMD_FIND_INVENTORY                   = L["ARMORY_CMD_FIND_INVENTORY"];
ARMORY_CMD_FIND_ALL                         = L["ARMORY_CMD_FIND_ALL"];
ARMORY_CMD_FIND_ITEM                        = L["ARMORY_CMD_FIND_ITEM"];
ARMORY_CMD_FIND_QUEST                       = L["ARMORY_CMD_FIND_QUEST"];
ARMORY_CMD_FIND_SPELL                       = L["ARMORY_CMD_FIND_SPELL"];
ARMORY_CMD_FIND_SKILL                       = L["ARMORY_CMD_FIND_SKILL"];
ARMORY_CMD_FIND_ACHIEVEMENT                 = L["ARMORY_CMD_FIND_ACHIEVEMENT"];
ARMORY_CMD_FIND_NOT_FOUND                   = L["ARMORY_CMD_FIND_NOT_FOUND"];
ARMORY_CMD_FIND_FOUND                       = L["ARMORY_CMD_FIND_FOUND"];
ARMORY_CMD_FIND_QUEST_REWARD                = L["ARMORY_CMD_FIND_QUEST_REWARD"];
ARMORY_CMD_LOOKUP                           = L["ARMORY_CMD_LOOKUP"];
ARMORY_CMD_LOOKUP_TEXT                      = L["ARMORY_CMD_LOOKUP_TEXT"];
ARMORY_CMD_LOOKUP_MENUTEXT                  = L["ARMORY_CMD_LOOKUP_MENUTEXT"];
ARMORY_CMD_DOWNLOAD                         = L["ARMORY_CMD_DOWNLOAD"];
ARMORY_CMD_DOWNLOAD_TEXT                    = L["ARMORY_CMD_DOWNLOAD_TEXT"];

-- Key binding localization text
BINDING_HEADER_ARMORY                       = ARMORY_TITLE;
BINDING_NAME_ARMORY_TOGGLE                  = L["BINDING_NAME_ARMORY_TOGGLE"];
BINDING_NAME_ARMORY_CURRENT_CHARACTER       = L["BINDING_NAME_CURRENT_CHARACTER"];
BINDING_NAME_ARMORY_PREVIOUS_CHARACTER      = L["BINDING_NAME_PREVIOUS_CHARACTER"];
BINDING_NAME_ARMORY_NEXT_CHARACTER          = L["BINDING_NAME_NEXT_CHARACTER"];
BINDING_NAME_ARMORY_LOOKUP                  = L["BINDING_NAME_LOOKUP"];
BINDING_NAME_ARMORY_FIND                    = L["BINDING_NAME_FIND"];

-- Text
ARMORY_TALENTS                              = L["ARMORY_TALENTS"];
ARMORY_TRADE_SKILLS                         = L["ARMORY_TRADE_SKILLS"];
ARMORY_TRADE_UPDATE_WARNING                 = L["ARMORY_TRADE_UPDATE_WARNING"];
   --------- Needs to be matched with the localized profession names in Bizzard ?
ARMORY_TRADE_ALCHEMY                        = L["ARMORY_TRADE_ALCHEMY"];
ARMORY_TRADE_BLACKSMITHING                  = L["ARMORY_TRADE_BLACKSMITHING"];
ARMORY_TRADE_COOKING                        = L["ARMORY_TRADE_COOKING"];
ARMORY_TRADE_ENCHANTING                     = L["ARMORY_TRADE_ENCHANTING"];
ARMORY_TRADE_ENGINEERING                    = L["ARMORY_TRADE_ENGINEERING"];
ARMORY_TRADE_FIRST_AID                      = L["ARMORY_TRADE_FIRST_AID"];
ARMORY_TRADE_FISHING                        = L["ARMORY_TRADE_FISHING"];
ARMORY_TRADE_HERBALISM                      = L["ARMORY_TRADE_HERBALISM"];
ARMORY_TRADE_JEWELCRAFTING                  = L["ARMORY_TRADE_JEWELCRAFTING"];
ARMORY_TRADE_LEATHERWORKING                 = L["ARMORY_TRADE_LEATHERWORKING"];
ARMORY_TRADE_MINING                         = L["ARMORY_TRADE_MINING"];
ARMORY_TRADE_POISONS                        = L["ARMORY_TRADE_POISONS"];
ARMORY_TRADE_SKINNING                       = L["ARMORY_TRADE_SKINNING"];
ARMORY_TRADE_TAILORING                      = L["ARMORY_TRADE_TAILORING"];
ARMORY_TRADE_INSCRIPTION                    = L["ARMORY_TRADE_INSCRIPTION"];
   ---------
ARMORY_TOTAL                                = L["ARMORY_TOTAL"];
ARMORY_ALTS                                 = L["ARMORY_ALTS"];
ARMORY_EQUIPMENT                            = L["ARMORY_EQUIPMENT"];
ARMORY_EQUIPPED                             = L["ARMORY_EQUIPPED"];
ARMORY_SELECT_UNIT_HINT                     = L["ARMORY_SELECT_UNIT_HINT"];
ARMORY_DELETE_UNIT                          = L["ARMORY_DELETE_UNIT"];
ARMORY_DELETE_UNIT_HINT                     = L["ARMORY_DELETE_UNIT_HINT"];
ARMORY_BANK_CONTAINER_NAME                  = L["ARMORY_BANK_CONTAINER_NAME"];
ARMORY_INVENTORY_ICONVIEW                   = L["ARMORY_INVENTORY_ICONVIEW"];
ARMORY_INVENTORY_ICONVIEW_TOOLTIP           = L["ARMORY_INVENTORY_ICONVIEW_TOOLTIP"];
ARMORY_INVENTORY_BAGLAYOUT                  = L["ARMORY_INVENTORY_BAGLAYOUT"];
ARMORY_INVENTORY_BAGLAYOUT_TOOLTIP          = L["ARMORY_INVENTORY_BAGLAYOUT_TOOLTIP"];
ARMORY_INVENTORY_LISTVIEW                   = L["ARMORY_INVENTORY_LISTVIEW"];
ARMORY_INVENTORY_LISTVIEW_TOOLTIP           = L["ARMORY_INVENTORY_LISTVIEW_TOOLTIP"];
ARMORY_INVENTORY_SEARCH_ALL                 = L["ARMORY_INVENTORY_SEARCH_ALL"];
ARMORY_INVENTORY_SEARCH_ALL_TOOLTIP         = L["ARMORY_INVENTORY_SEARCH_ALL_TOOLTIP"];
ARMORY_INVENTORY_SEARCH_TEXT_TOOLTIP        = L["ARMORY_INVENTORY_SEARCH_TEXT_TOOLTIP"];
ARMORY_TRADESKILL_SEARCH_TEXT_TOOLTIP       = L["ARMORY_TRADESKILL_SEARCH_TEXT_TOOLTIP"];
ARMORY_CHECK_MAIL_MESSAGE                   = L["ARMORY_CHECK_MAIL_MESSAGE"];
ARMORY_CHECK_MAIL_POPUP                     = L["ARMORY_CHECK_MAIL_POPUP"];
ARMORY_CHECK_MAIL_NONE                      = L["ARMORY_CHECK_MAIL_NONE"];
ARMORY_CHECK_MAIL_DISABLED                  = L["ARMORY_CHECK_MAIL_DISABLED"];
ARMORY_MONEY_TOTAL                          = L["ARMORY_MONEY_TOTAL"];
ARMORY_DB_INCOMPATIBLE                      = L["ARMORY_DB_INCOMPATIBLE"];
ARMORY_LOOKUP_SKILL_SEARCH_TOOLTIP          = L["ARMORY_LOOKUP_SKILL_SEARCH_TOOLTIP"];
ARMORY_LOOKUP_SKILL                         = L["ARMORY_LOOKUP_SKILL"];
ARMORY_LOOKUP_QUEST_SEARCH_TOOLTIP          = L["ARMORY_LOOKUP_QUEST_SEARCH_TOOLTIP"];
ARMORY_LOOKUP_QUEST                         = L["ARMORY_LOOKUP_QUEST"];
ARMORY_LOOKUP_QUEST_NAME                    = L["ARMORY_LOOKUP_QUEST_NAME"];
ARMORY_LOOKUP_QUEST_AREA                    = L["ARMORY_LOOKUP_QUEST_AREA"];
ARMORY_LOOKUP_CHARACTER_SEARCH_TOOLTIP      = L["ARMORY_LOOKUP_CHARACTER_SEARCH_TOOLTIP"];
ARMORY_LOOKUP_CHARACTER                     = L["ARMORY_LOOKUP_CHARACTER"];
ARMORY_LOOKUP_DETAIL                        = L["ARMORY_LOOKUP_DETAIL"];
ARMORY_LOOKUP_NODETAIL                      = L["ARMORY_LOOKUP_NODETAIL"];
ARMORY_LOOKUP_PLAYER_HINT                   = L["ARMORY_LOOKUP_PLAYER_HINT"];
ARMORY_LOOKUP_BUTTON                        = L["ARMORY_LOOKUP_BUTTON"];
ARMORY_LOOKUP_SEARCH_EXACT                  = L["ARMORY_LOOKUP_SEARCH_EXACT"];
ARMORY_LOOKUP_DISABLED                      = L["ARMORY_LOOKUP_DISABLED"];
ARMORY_LOOKUP_RESPONSE_SENT                 = L["ARMORY_LOOKUP_RESPONSE_SENT"];
ARMORY_LOOKUP_RESPONSE_RECEIVED             = L["ARMORY_LOOKUP_RESPONSE_RECEIVED"];
ARMORY_LOOKUP_REQUEST_SENT                  = L["ARMORY_LOOKUP_REQUEST_SENT"];
ARMORY_LOOKUP_REQUEST_RECEIVED              = L["ARMORY_LOOKUP_REQUEST_RECEIVED"];
ARMORY_LOOKUP_REQUEST_DETAIL                = L["ARMORY_LOOKUP_REQUEST_DETAIL"];
ARMORY_LOOKUP_IGNORED                       = L["ARMORY_LOOKUP_IGNORED"];
ARMORY_LOOKUP_REALM_ALIAS                   = L["ARMORY_LOOKUP_REALM_ALIAS"];
ARMORY_IGNORE_REASON_SHARING                = L["ARMORY_IGNORE_REASON_SHARING"];
ARMORY_IGNORE_REASON_VERSION                = L["ARMORY_IGNORE_REASON_VERSION"];
ARMORY_IGNORE_REASON_INSTANCE               = L["ARMORY_IGNORE_REASON_INSTANCE"];
ARMORY_IGNORE_REASON_COMBAT                 = L["ARMORY_IGNORE_REASON_COMBAT"];
ARMORY_QUEST_TOOLTIP_LABEL                  = L["ARMORY_QUEST_TOOLTIP_LABEL"];
ARMORY_REPUTATION_SUMMARY                   = L["ARMORY_REPUTATION_SUMMARY"];
ARMORY_XP_SUMMARY                           = L["ARMORY_XP_SUMMARY"];
ARMORY_FIND_BUTTON                          = L["ARMORY_FIND_BUTTON"];
ARMORY_LINK_TRADESKILL_TOOLTIP              = L["ARMORY_LINK_TRADESKILL_TOOLTIP"];
ARMORY_SOCIAL_ADD_TOOLTIP                   = L["ARMORY_SOCIAL_ADD_TOOLTIP"];
ARMORY_KNOWN_BY                             = L["ARMORY_KNOWN_BY"];
ARMORY_CRAFTABLE_BY                         = L["ARMORY_CRAFTABLE_BY"];
ARMORY_FULLY_RESTED                         = L["ARMORY_FULLY_RESTED"];
ARMORY_UPDATE_SUSPENDED                     = L["ARMORY_UPDATE_SUSPENDED"];
ARMORY_COOLDOWN_WARNING                     = L["ARMORY_COOLDOWN_WARNING"];
ARMORY_COOLDOWN_AVAILABLE                   = L["ARMORY_COOLDOWN_AVAILABLE"];
ARMORY_EVENT_WARNING                        = L["ARMORY_EVENT_WARNING"];
ARMORY_MAIL_COUNT_WARNING1                  = L["ARMORY_MAIL_COUNT_WARNING1"];
ARMORY_MAIL_COUNT_WARNING2                  = L["ARMORY_MAIL_COUNT_WARNING2"];
ARMORY_MAIL_VISIT_WARNING                   = L["ARMORY_MAIL_VISIT_WARNING"];
ARMORY_MAIL_LAST_VISIT                      = L["ARMORY_MAIL_LAST_VISIT"];
ARMORY_MAIL_REMAINING                       = L["ARMORY_MAIL_REMAINING"];
ARMORY_MAIL_ITEM_COUNT                      = L["ARMORY_MAIL_ITEM_COUNT"];
