
local myname, ns = ...
local _G = getfenv(0)

--=================================================
-- Upvalued functions and variables
--=================================================

local geterrorhandler					= _G.geterrorhandler
local print									= _G.print
local select								= _G.select
local time									= _G.time
local tostringall							= _G.tostringall

local AcceptQuest							= _G.AcceptQuest
local CompleteQuest						= _G.CompleteQuest
local CreateFrame							= _G.CreateFrame
local GetAddOnMetadata 					= _G.GetAddOnMetadata
local GetBuildInfo						= _G.GetBuildInfo
local GetGossipActiveQuests			= _G.GetGossipActiveQuests
local GetGossipOptions					= _G.GetGossipOptions
local GetNumGossipActiveQuests		= _G.GetNumGossipActiveQuests
local GetNumGossipAvailableQuests	= _G.GetNumGossipAvailableQuests
local GetNumGossipOptions				= _G.GetNumGossipOptions
local GetNumQuestChoices				= _G.GetNumQuestChoices
local GetQuestReward						= _G.GetQuestReward
local HideUIPanel							= _G.HideUIPanel
local IsLoggedIn							= _G.IsLoggedIn
local IsQuestCompletable				= _G.IsQuestCompletable
local IsShiftKeyDown						= _G.IsShiftKeyDown
local QuestFrame							= _G.QuestFrame
local QuestFrameDeclineButton			= _G.QuestFrameDeclineButton
local QuestIsDaily						= _G.QuestIsDaily
local SelectGossipActiveQuest			= _G.SelectGossipActiveQuest
local SelectGossipAvailableQuest		= _G.SelectGossipAvailableQuest
local SelectGossipOption				= _G.SelectGossipOption


--=================================================
-- Utility functions and constants
--=================================================

_G.Aboutis 									= {}
local Aboutis 								= _G.Aboutis
local myfullname = GetAddOnMetadata(myname, "Title")
function ns.Print(...) print("|cFF33FF99".. myfullname.. "|r:", ...) end
local Print = ns.Print

function ns.err(msg, ...) geterrorhandler()(msg:format(tostringall(...)) .. " - " .. time()) end
local err = ns.err

local IS_MOP = select(4, GetBuildInfo()) >= 50000
local ACTIVE_QUEST_PARAMS = IS_MOP and 5 or 4

--=================================================
-- Even Dispatcher
--=================================================

do -- Closure

	local f = CreateFrame("frame")
	f:SetScript("OnEvent", function(self, event, ...) if ns[event] then return ns[event](ns, event, ...) else ns:OtherEvent(event, ...) end end)

	function ns:RegisterEvent(...) for i=1,select("#", ...) do f:RegisterEvent((select(i, ...))) end end
	function ns:UnregisterEvent(...) for i=1,select("#", ...) do f:UnregisterEvent((select(i, ...))) end end

end -- Closure

--=================================================
-- Init addon
--=================================================

ns:RegisterEvent("ADDON_LOADED")
function ns:ADDON_LOADED(event, addon)
	if addon ~= myname then return end

	-- Events
	self:RegisterEvent(
		"GOSSIP_SHOW",
		"QUEST_COMPLETE",
--		"QUEST_DETAIL",
--		"QUEST_GREETING",
		"QUEST_PROGRESS"
	)

	self.enable = true -- Handle for other addons that would like to diable Aboutis

	self:UnregisterEvent("ADDON_LOADED")
	self.ADDON_LOADED = nil

	if IsLoggedIn() then self:PLAYER_LOGIN() else self:RegisterEvent("PLAYER_LOGIN") end
end


function ns:PLAYER_LOGIN()
	self:UnregisterEvent("PLAYER_LOGIN")
	self.PLAYER_LOGIN = nil
end

--=================================================
-- Core functionality
--=================================================

-- Hook the quest Decline button so that if we go back to the gossip frame, it doesn't
-- trigger the auto-accept immediately
local just_declined = nil
do -- Closure

	local DELAY_TIME = 0.5
	local delay
	local f = CreateFrame("Frame")
	f:Hide()
	f:SetScript("OnUpdate", function(self, elapsed)
		delay = delay - elapsed
		if delay < 0 then
			just_declined = nil
			f:Hide()
		end
	end)

	QuestFrameDeclineButton:HookScript("OnClick", function()
		just_declined = true
		delay = DELAY_TIME
		f:Show()
	end)

end -- Closure


-- Options to select if available
-- Vendor is first choice
local good_options = {
	trainer = 2,
	vendor = 1,
}

function ns:OtherEvent(event, ...)
	-- If the shift key is pressed or if we just declined a quest, do nothing
	if just_declined or IsShiftKeyDown() or not self.enable then return end

	if event == "GOSSIP_SHOW" then

		-- Turn in the firt completed quest of the list
		for i=1,GetNumGossipActiveQuests() do
			local is_completed = select((i-1)*ACTIVE_QUEST_PARAMS + 4, GetGossipActiveQuests())
			if is_completed then
				SelectGossipActiveQuest(i)
				return
			end
		end

		-- If there is only one selectable quest
		if GetNumGossipAvailableQuests() == 1 then
			SelectGossipAvailableQuest(1)
			return
		elseif GetNumGossipAvailableQuests() > 1 then
			-- If there are quests available, do not try to open the marchant or trainer
			return
		end

		-- Find the other interesting stuff and oppen the corresponding option
		local found_i, found_value = nil, 10
		for i=1,GetNumGossipOptions() do
			local option = select(i*2, GetGossipOptions()) -- (i-1)*2 + 2
			if good_options[option] and good_options[option] < found_value then
				found_i, found_value = i, good_options[option]
			end
		end
		if found_i then
			SelectGossipOption(found_i)
			return
		end

	elseif event == "QUEST_DETAIL" then

		if QuestIsDaily() then
			-- Auto Quest are automaticaly accepted as soon as you see the quest text
			-- This code was lifted from QuestFrame.lua to prevent calling AcceptQuest()
			-- for an already accepted quest.
			if ( QuestFrame.autoQuest ) then
				HideUIPanel(QuestFrame)
			else
				AcceptQuest()
			end
		end

	elseif event == "QUEST_PROGRESS" then

		-- Autoselect the Continue button when the quest is completed
		if IsQuestCompletable() then
			CompleteQuest()
		end

	elseif event == "QUEST_COMPLETE" then

		-- Choose the reward automaticaly if there is less then two choices available
		if GetNumQuestChoices() <= 1 then
				GetQuestReward(0)
		end

	end
end

--=================================================
-- Public interfaces
--=================================================

function Aboutis:Enable() ns.enable = true end
function Aboutis:Disable() ns.enable = nil end
function Aboutis:IsEnable() return ns.enable end

-- for debug
Aboutis.ns = ns
