-- El nombre del Frame debe ser VenderChatarraOptions, como lo llama el Merchant
local Options = CreateFrame('Frame', 'VenderChatarraOptions', nil, 'UIDropDownMenuTemplate')
local Tutorials = LibStub('CustomTutorials-1.0')
local L = VenderChatarra_Locals


--[[ Dropdown ]]--

function Options:ToggleDropdown(anchor)
	local info = {
		{
		    text = 'VenderChatarra',
		    isTitle = 1
    	},
   		{
		    text = L.AutoSell,
		    tooltipTitle = L.AutoSell,
		    tooltipText = L.AutoSellDesc,
		    func = function() VenderChatarra_AutoVender = not VenderChatarra_AutoVender or nil end,
		    checked = function() return VenderChatarra_AutoVender end
    	},
    	{
		    text = L.ShowTutorials,
		    func = function() self:ShowTutorials() end
    	}
	}

	-- ERROR CORREGIDO: El ancla debe ser el botón principal 'Scrap', no el frame 'Options'.
	-- La función EasyMenu necesita el botón al que se hace clic derecho.
	EasyMenu(info, self, Scrap, 0, 0, 'MENU') 
end


--[[ Tutorials ]]--

function Options:ShowTutorials()
	if not Tutorials:GetTutorial('VenderChatarra') then
		self:ShowTutorial('VenderChatarra', L.Tutorial, 'Interface\\Addons\\VenderChatarraOptions\\Textures\\Tutorial', 22, Scrap)
		self:ShowTutorial('VenderChatarra2', L.Tutorial2, 'Interface\\Addons\\VenderChatarraOptions\\Textures\\Tutorial2', 18, MainMenuBarBackpackButton)
	end
	
	Tutorials:ShowTutorial('VenderChatarra')
end

function Options:ShowTutorial(id, text, image, height, target)
	Tutorials:NewTutorial(id, {
		title = 'VenderChatarra',
		textOff = -190,
		text = text,
			
		imageOff = -55,
		image = image,
			
		x = -25, y = -180,
		point = 'TOPRIGHT',
		height = height,
			
		pulse = target,
		pulseHeight = 48,
		pulseWidth = 48,
	})
end


--[[ Startup ]]--

if not VenderChatarra_Tutoriales then
	Options:ShowTutorials()
	VenderChatarra_Tutoriales = true
end