local Enum = Enum or {}

-- "Meta" tables haven't been added (MinValue, NumValues, MaxValue)
-- TODO: Certain tables have outdated information.

Enum.ItemClass = {
	Consumable = 0,
	Container = 1,
	Weapon = 2,
	Gem = 3,
	Armor = 4,
	Reagent = 5,
	Projectile = 6,
	Tradegoods = 7,
	ItemEnhancement = 8,
	Recipe = 9,
	CurrencyTokenObsolete = 10,
	Quiver = 11,
	Questitem = 12,
	Key = 13,
	PermanentObsolete = 14,
	Miscellaneous = 15,
	Glyph = 16,
	Battlepet = 17,
	WoWToken = 18,
	Profession = 19,
}

Enum.ItemConsumableSubclass = {
	Fooddrink = 5,
	Bandage = 7,
	Scroll = 4,
	Elixir = 2,
	Generic = 0,
	Flasksphials = 3,
	Potion = 1,
	Itemenhancement = 6,
	VantusRune = 9,
	CombatCurio = 11,
	UtilityCurio = 10,
	Other = 8,
}

Enum.ItemWeaponSubclass = {
	Mace2H = 5,
	Thrown = 16,
	Bearclaw = 11,
	Catclaw = 12,
	Mace1H = 4,
	Polearm = 6,
	Sword1H = 7,
	Axe2H = 1,
	Sword2H = 8,
	Unarmed = 13,
	Bows = 2,
	Crossbow = 18,
	Staff = 10,
	Fishingpole = 20,
	Generic = 14,
	Guns = 3,
	Dagger = 15,
	Warglaive = 9,
	Obsolete3 = 17,
	Axe1H = 0,
	Wand = 19,
}

Enum.ItemGemSubclass = {
	Simple = 7,
	Blue = 1,
	Meta = 6,
	Prismatic = 8,
	Purple = 3,
	Green = 4,
	Yellow = 2,
	Orange = 5,
	Red = 0,
}

Enum.ItemArmorSubclass = {
	Idol = 8,
	Cosmetic = 5,
	Totem = 9,
	Shield = 6,
	Leather = 2,
	Libram = 7,
	Generic = 0,
	Mail = 3,
	Cloth = 1,
	Plate = 4,
	Relic = 11,
	Sigil = 10,
}

Enum.ItemReagentSubclass = {
	ContextToken = 2,
	Reagent = 0,
	Keystone = 1,
}

Enum.ItemRecipeSubclass = {
	Tailoring = 2,
	Blacksmithing = 4,
	FirstAid = 7,
	Alchemy = 6,
	Book = 0,
	Cooking = 5,
	Inscription = 11,
	Fishing = 9,
	Engineering = 3,
	Leatherworking = 1,
	Jewelcrafting = 10,
	Enchanting = 8,
}

Enum.ItemMiscellaneousSubclass = {
	CompanionPet = 2,
	Reagent = 1,
	MountEquipment = 6,
	Mount = 5,
	Holiday = 3,
	Junk = 0,
	Other = 4,
}

Enum.BattlePetTypes = {
	Dragonkin = 1,
	Humanoid = 0,
	Elemental = 6,
	Critter = 4,
	Magic = 5,
	Flying = 2,
	Aquatic = 8,
	Undead = 3,
	Mechanical = 9,
	Beast = 7,
	NonCombat = 10,
}

Enum.ItemProfessionSubclass = {
	Tailoring = 6,
	Blacksmithing = 0,
	Skinning = 10,
	Alchemy = 2,
	Mining = 5,
	Jewelcrafting = 11,
	Cooking = 4,
	Herbalism = 3,
	Archaeology = 13,
	Fishing = 9,
	Engineering = 7,
	Leatherworking = 1,
	Inscription = 12,
	Enchanting = 8,
}

Enum.ItemQuality = {
	Artifact = 6,
	Poor = 0,
	Common = 1,
	Uncommon = 2,
	Rare = 3,
	Legendary = 5,
	Epic = 4,
	Heirloom = 7,
	WoWToken = 8,

	--Standard = 1,
	--Good = 2,
}

Enum.InventoryType = {
	IndexHandType = 10,
	IndexFingerType = 11,
	IndexThrownType = 25,
	IndexTabardType = 19,
	IndexHoldableType = 23,
	IndexProfessionGearType = 30,
	IndexBodyType = 4,
	IndexHeadType = 1,
	IndexRobeType = 20,
	IndexNonEquipType = 0,
	IndexWaistType = 6,
	IndexTrinketType = 12,
	IndexEquipablespellUtilityType = 32,
	IndexRelicType = 28,
	IndexRangedrightType = 26,
	IndexFeetType = 8,
	IndexShieldType = 14,
	IndexAmmoType = 24,
	IndexWeaponoffhandType = 22,
	IndexWristType = 9,
	IndexEquipablespellDefensiveType = 33,
	IndexNeckType = 2,
	Index2HweaponType = 17,
	IndexWeaponType = 13,
	IndexEquipablespellWeaponType = 34,
	IndexBagType = 18,
	IndexRangedType = 15,
	IndexLegsType = 7,
	IndexChestType = 5,
	IndexShoulderType = 3,
	IndexQuiverType = 27,
	IndexEquipablespellOffensiveType = 31,
	IndexCloakType = 16,
	IndexWeaponmainhandType = 21,
	IndexProfessionToolType = 29,
}

Enum.AuctionHouseNotification = {
	AuctionSold = 4,
	AuctionOutbid = 3,
	AuctionWon = 2,
	AuctionRemoved = 1,
	BidPlaced = 0,
	AuctionExpired = 5,
}

Enum.AuctionHouseSortOrder = {
	Name = 1,
	Bid = 3,
	Price = 0,
	Level = 2,
	Buyout = 4,
	TimeRemaining = 5,
}

Enum.PlayerInteractionType = {
	ItemInteraction = 44,
	TradePartner = 1,
	GarrMission = 32,
	AdventureJournal = 54,
	AlliedRaceDetailsGiver = 9,
	TraitSystem = 61,
	GarrArchitect = 30,
	AdventureMap = 28,
	CharacterBanker = 67,
	ForgeMaster = 66,
	SpiritHealer = 18,
	Renown = 55,
	ContributionCollector = 41,
	Vendor = 12,
	GarrTalent = 35,
	AreaSpiritHealer = 19,
	LFGDungeon = 25,
	PerksProgramVendor = 57,
	TalentMaster = 15,
	MailInfo = 17,
	Registrar = 11,
	Soulbind = 50,
	GarrTradeskill = 31,
	None = 0,
	Merchant = 5,
	AnimaDiversion = 47,
	QuestGiver = 4,
	PersonalTabardVendor = 65,
	AzeriteForge = 56,
	TaxiNode = 6,
	Item = 2,
	Auctioneer = 21,
	VoidStorageBanker = 26,
	SpecializationMaster = 16,
	PlayerChoice = 37,
	GarrRecruitment = 34,
	BattleMaster = 23,
	MajorFactionRenown = 64,
	GuildBanker = 10,
	ObliterumForge = 39,
	ArtifactForge = 38,
	IslandQueue = 43,
	BlackMarketAuctioneer = 27,
	AccountBanker = 68,
	JailersTowerBuffs = 63,
	ScrappingMachine = 40,
	CovenantSanctum = 51,
	StableMaster = 22,
	CovenantPreview = 46,
	WorldMap = 29,
	GuildTabardVendor = 14,
	Banker = 8,
	AzeriteRespec = 42,
	LegendaryCrafting = 48,
	WeeklyRewards = 49,
	Transmogrifier = 24,
	Trainer = 7,
	ItemUpgrade = 53,
	ChromieTime = 45,
	ShipmentCrafter = 33,
	Trophy = 36,
	ProfessionsCraftingOrder = 58,
	PetitionVendor = 13,
	ProfessionsCustomerOrder = 60,
	NewPlayerGuide = 52,
	Professions = 59,
	BarbersChoice = 62,
	Gossip = 3,
	Binder = 20,
}

Enum.GossipNpcOption = {
	ChromieTimeNpc = 40,
	PersonalTabardVendor = 54,
	None = 0,
	Mailbox = 18,
	GlyphMaster = 24,
	CovenantPreviewNpc = 41,
	CemeterySelect = 22,
	Auctioneer = 10,
	PetUntrainer = 13,
	Banker = 6,
	SpecializationMaster = 23,
	AdventureMap = 31,
	QueueScenario = 25,
	TraitSystem = 51,
	EnableXPGain = 17,
	IslandsMissionNpc = 36,
	Transmogrify = 34,
	SpiritHealer = 4,
	GuildBanker = 14,
	Stablemaster = 12,
	GarrisonMissionNpc = 27,
	WorldMap = 38,
	CharacterBanker = 56,
	BlackMarketAuctionHouse = 46,
	ForgeMaster = 55,
	Spellclick = 15,
	ProfessionsCustomerOrder = 50,
	Trainer = 3,
	GarrisonTradeskillNpc = 29,
	UIItemInteraction = 37,
	RuneforgeLegendaryCrafting = 42,
	ContributionCollector = 33,
	AccountBanker = 57,
	PetitionVendor = 7,
	LFGDungeon = 20,
	AzeriteRespec = 35,
	GarrisonArchitect = 26,
	GarrisonRecruitment = 30,
	GarrisonTalent = 32,
	GuildTabardVendor = 8,
	Battlemaster = 9,
	CovenantRenownNpc = 45,
	ProfessionsCraftingOrder = 48,
	PerksProgramVendor = 47,
	TalentMaster = 11,
	MajorFactionRenown = 53,
	RuneforgeLegendaryUpgrade = 44,
	Vendor = 1,
	ShipmentCrafter = 28,
	ProfessionsOpen = 49,
	WorldPvPQueue = 19,
	Soulbind = 39,
	Taxinode = 2,
	NewPlayerGuide = 43,
	DisableXPGain = 16,
	BarbersChoice = 52,
	ArtifactRespec = 21,
	Binder = 5,
}

Enum.TooltipDataType = {
	Corpse = 3,
	PetAction = 11,
	Mount = 10,
	Unit = 2,
	EquipmentSet = 14,
	Currency = 5,
	Item = 0,
	QuestPartyProgress = 24,
	Totem = 18,
	Quest = 23,
	EnhancedConduit = 13,
	Toy = 19,
	Spell = 1,
	Debug = 26,
	CorruptionCleanser = 20,
	Macro = 25,
	PvPBrawl = 16,
	InstanceLock = 15,
	CompanionPet = 9,
	Achievement = 12,
	BattlePet = 6,
	Object = 4,
	RecipeRankInfo = 17,
	MinimapMouseover = 21,
	Flyout = 22,
	UnitAura = 7,
	AzeriteEssence = 8,
}

Enum.CraftingReagentType = {
	Automatic = 3,
	Finishing = 2,
	Modifying = 0,
	Basic = 1,
}

Enum.LFGRole = {
	Tank = 0,
	Healer = 1,
	Damage = 2,
}

Enum.MountType = {
	RideAlong = 4,
	Flying = 1,
	Aquatic = 2,
	Dragonriding = 3,
	Ground = 0,
}

-- Global
_G.Enum = Enum