$ErrorActionPreference = 'Stop'
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12

$root = Split-Path -Parent (Get-Item -LiteralPath $PSCommandPath).FullName
$addonDir = Join-Path $root 'BiSTooltip'
$resolvedPath = Join-Path $addonDir 'ResolvedSources.lua'
$lootPath = Join-Path $addonDir 'Loot_Sources.lua'
$wowAddonPath = 'D:\World of Warcraft\Interface\AddOns\BiSTooltip'

function Esc { param([string]$s) if([string]::IsNullOrEmpty($s)){ return '' } ($s -replace '\\','\\' -replace '"','\"' -replace '\r?\n',' ' ).Trim() }
function CleanText([string]$s){ if(-not $s){ return $null } ($s -replace '\s+',' ').Trim() }
function HtmlDecode([string]$s){
  if(-not $s){ return $null }
  $t = $s
  $t = $t.Replace('&quot;','"').Replace('&apos;',"'").Replace('&#039;',"'").Replace('&#39;',"'")
  $t = $t.Replace('&amp;','&').Replace('&nbsp;',' ')
  return $t
}

function GetCanonicalUrl([int]$id){
  $ua = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)'
  $headers = @{ 'User-Agent'=$ua; 'Accept'='text/html,application/xhtml+xml'; 'Connection'='close' }
  try{
    $r = Invoke-WebRequest -Uri ("https://www.wowhead.com/wotlk/es/item=$id") -Headers $headers -MaximumRedirection 1 -TimeoutSec 4
    $m = [regex]::Match($r.Content,'(?is)<link\s+rel="canonical"\s+href="([^"]+)"')
    if($m.Success){ return $m.Groups[1].Value.Trim() }
  }catch{}
  return $null
}

function GetCanonicalPage([int]$id, [string]$anchor){
  $base = GetCanonicalUrl $id
  if(-not $base){ return $null }
  $url = if($anchor){ $base + $anchor } else { $base }
  $ua = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)'
  $headers = @{ 'User-Agent'=$ua; 'Accept'='text/html,application/xhtml+xml'; 'Connection'='close' }
  try{
    $r = Invoke-WebRequest -Uri $url -Headers $headers -MaximumRedirection 1 -TimeoutSec 4
    if($r.Content){ return $r.Content }
  }catch{}
  return $null
}

function ParseDropFromPage([string]$html){
  if(-not $html){ return $null }
  $open = [char]60; $close = [char]62
  $pattern = "$open[^$close]+$close"
  $raw = [regex]::Replace($html,$pattern,' ')
  $txt = HtmlDecode $raw
  $txt = CleanText $txt
  $mBoss = [regex]::Match($txt,'(?is)Bot(?:i|í)n de\s*([A-Za-zÀ-ÿ'' \-,]+)')
  $mPct  = [regex]::Match($txt,'(?is)Probabilidad de Bot(?:i|í)n\s*([0-9][0-9\.,]*)\s*%')
  if(-not ($mBoss.Success -and $mPct.Success)){ return $null }
  $bossRaw = CleanText $mBoss.Groups[1].Value
  $pct = CleanText $mPct.Groups[1].Value
  $inst = $null
  $mBI = [regex]::Match($bossRaw,'^(.*?)\s*\(([^)]+)\)\s*$')
  if($mBI.Success){ $bossRaw = CleanText $mBI.Groups[1].Value; $inst = CleanText $mBI.Groups[2].Value }
  if(-not $inst){ $mInst=[regex]::Match($txt,'(?is)\ben\s+([A-Za-zÀ-ÿ \-]+)'); if($mInst.Success){ $inst = CleanText $mInst.Groups[1].Value } }
  if(-not $inst){ $inst = 'Mazmorra' }
  return @{ instance=$inst; boss=($bossRaw + ' (' + $pct + '%)') }
}

function ParseVendorFromPage([string]$html){
  if(-not $html){ return $null }
  $open = [char]60; $close = [char]62
  $pattern = "$open[^$close]+$close"
  $rawV = [regex]::Replace($html,$pattern,' ')
  $text = HtmlDecode $rawV
  $text = CleanText $text
  $mPlace = [regex]::Match($text,"(?is)(Este objeto se puede comprar en|This item can be purchased in)\s+([A-Za-zÁÉÍÓÚÑ \-']+)")
  $mVendorText = [regex]::Match($text,'(?is)(Vendido por|Sold by)\s*([^\r\n<]+)')
  if($mVendorText.Success -and $mPlace.Success){
    $vendorName = CleanText (HtmlDecode $mVendorText.Groups[2].Value)
    $place = CleanText $mPlace.Groups[2].Value
    return @{ instance='Vendedor'; boss=($vendorName + ' = ' + $place) }
  }
  return $null
}

function ParseProfFromPage([string]$html){
  if(-not $html){ return $null }
  $open = [char]60; $close = [char]62
  $pattern = "$open[^$close]+$close"
  $rawP = [regex]::Replace($html,$pattern,' ')
  $txt = HtmlDecode $rawP
  $txt = CleanText $txt
  $rx = [regex]'(?is)\b(Alquimia|Herrer[ií]a|Ingenier[ií]a|Sastrer[ií]a|Peleter[ií]a|Joyer[ií]a|Encantamiento|Inscripci[oó]n|Cocina)\b[^()\d]{0,40}\(\s*(\d{3})\s*\)'
  $m = $rx.Match($txt)
  if($m.Success){ $skill = [int]$m.Groups[2].Value; if($skill -ge 300 -and $skill -le 450){ $pname = CleanText $m.Groups[1].Value; return @{ instance='Profesión'; boss=($pname + ' (' + $skill + ')') } } }
  return $null
}

function GetOurIds([string]$filePath){
  if(-not (Test-Path -LiteralPath $filePath)){ return @() }
  $ids = New-Object System.Collections.Generic.List[int]
  Get-Content -LiteralPath $filePath -Encoding UTF8 | ForEach-Object {
    foreach($m in ([regex]'\b(\d{5,6})\b').Matches($_)){
      $val = [int]$m.Groups[1].Value
      if($val -ge 30000 -and $val -le 62000){ $ids.Add($val) }
    }
  }
  return ($ids | Select-Object -Unique)
}

function RemoveExistingIdLines([int]$id){
  if(-not (Test-Path -LiteralPath $resolvedPath)){ return }
  $pat = '^\s*ResolvedSources\[' + $id + '\]'
  $new = Get-Content -LiteralPath $resolvedPath -Encoding UTF8 | Where-Object { $_ -notmatch $pat }
  Set-Content -LiteralPath $resolvedPath -Encoding UTF8 -Value $new
}

function WriteResolved([int]$id, [hashtable]$entry){
  $inst = Esc($entry.instance)
  $boss = Esc($entry.boss)
  $line = 'ResolvedSources[' + $id + '] = { { instance = "' + $inst + '", boss = "' + $boss + '" } }'
  Add-Content -LiteralPath $resolvedPath -Encoding UTF8 -Value $line
}

function SyncToWow(){ if(Test-Path -LiteralPath $wowAddonPath){ Copy-Item -LiteralPath $resolvedPath -Destination (Join-Path $wowAddonPath 'ResolvedSources.lua') -Force } }

if(-not (Test-Path -LiteralPath $resolvedPath)){ Set-Content -LiteralPath $resolvedPath -Encoding UTF8 -Value @() }

$limit = [int]$env:BISTOOLTIP_LIMIT
$singleIdEnv = $env:BISTOOLTIP_ID
$allIds = GetOurIds $lootPath | Sort-Object -Descending
if($singleIdEnv){ $singleId = [int]$singleIdEnv; $allIds = $allIds | Where-Object { $_ -eq $singleId } }
if($limit -gt 0){ $allIds = $allIds | Select-Object -First $limit }

$total = $allIds.Count
$done = 0
$resolvedCount = 0

foreach($id in $allIds){
  $done++
  $pct=[math]::Round(($done/[double]$total)*100,0)
  $bar=('' + ('#' * ([math]::Floor($pct/2)))).PadRight(50,'.')
  Write-Host "[$bar] $pct% ($done/$total) ID $id"

  $entry = $null
  $pageDrop = GetCanonicalPage $id '#dropped-by'
  if($pageDrop){ $entry = ParseDropFromPage $pageDrop }
  if(-not $entry){ $page = GetCanonicalPage $id '' ; if($page){ $entry = ParseVendorFromPage $page } }
  if(-not $entry){ $page = if($page){ $page } else { GetCanonicalPage $id '' }; if($page){ $entry = ParseProfFromPage $page } }

  if($entry){ RemoveExistingIdLines $id; WriteResolved $id $entry; $resolvedCount++; Write-Host "RESUELTO: ID $id -> $($entry.instance) / $($entry.boss)" } else { Write-Host "SIN FUENTE: ID $id" }
}

SyncToWow
Write-Host ('Completado. Procesadas:{0} Resueltas:{1}' -f $total,$resolvedCount)