﻿local AceConfigDialog = LibStub("AceConfigDialog-3.0")
local AceGUI = LibStub("AceGUI-3.0")
local LDB = LibStub("LibDataBroker-1.1", true)
local LDBIcon = LDB and LibStub("LibDBIcon-1.0", true)
local icon_loaded = false
local icon_name = "BisTooltipIcon"
-- local DataStore = LibStub("DataStore")
-- local DataStore_Inventory = LibStub("DataStore_Inventory")

local sources = {
    wowtbc = "wowtbc"
}

Bistooltip_source_to_url = {
    ["wowtbc"] = "wowtbc.gg/wotlk"
}

local db_defaults = {
    char = {
        class_index = 1,
        spec_index = 1,
        phase_index = 1,
        filter_specs = {},
        highlight_spec = {},
        data_source = "wowtbc",
        minimap_icon = true,
        tooltip_with_ctrl = false,
        missing_sources = {}
    }
}

local configTable = {
    type = "group",
    args = {
        minimap_icon = {
            name = "Mostrar icono en el minimapa",
            order = 0,
            desc = "Muestra/oculta el icono del minimapa",
            type = "toggle",
            set = function(info, val)
                BistooltipAddon.db.char.minimap_icon = val
                if val == true then
                    if icon_loaded == true then
                        LDBIcon:Show(icon_name)
                    else
                        BistooltipAddon:addMapIcon()
                    end
                else
                    LDBIcon:Hide(icon_name)
                end
            end,
            get = function(info)
                return BistooltipAddon.db.char.minimap_icon
            end
        },
        filter_class_names = {
            name = "Ocultar nombres de clase",
            order = 1,
            desc = "Quita separadores de nombre de clase de los tooltips de objetos",
            type = "toggle",
            set = function(info, val)
                BistooltipAddon.db.char.filter_class_names = val
            end,
            get = function(info)
                return BistooltipAddon.db.char.filter_class_names
            end
        },
        tooltip_with_ctrl = {
            name = "Mostrar tooltips de objetos con Ctrl",
            order = 2,
            desc = "Mostrar tooltips de objetos solo al mantener pulsada la tecla Ctrl",
            type = "toggle",
            width = "double",
            set = function(info, val)
                BistooltipAddon.db.char.tooltip_with_ctrl = val
            end,
            get = function(info)
                return BistooltipAddon.db.char.tooltip_with_ctrl
            end
        },
        data_source = {
            name = "Fuente de datos",
            order = 3,
            desc = "Cambia la fuente de datos BiS",
            type = "select",
            style = "dropdown",
            width = "double",
            values = Bistooltip_source_to_url,
            set = function(info, key, val)
                BistooltipAddon.db.char.data_source = key
                BistooltipAddon:changeSpec(key)
            end,
            get = function(info, key)
                return BistooltipAddon.db.char.data_source
            end
        },
        filter_specs = {
            name = "Ocultar especializaciones",
            order = 4,
            desc = "Quita especializaciones no seleccionadas de los tooltips de objetos",
            type = "multiselect",
            values = {}, -- Initialize as an empty table
            set = function(info, key, val)
                local ci, si = strsplit(":", key)
                ci = tonumber(ci)
                si = tonumber(si)
                local class_name = Bistooltip_classes[ci].name
                local spec_name = Bistooltip_classes[ci].specs[si]
                BistooltipAddon.db.char.filter_specs[class_name][spec_name] = val
            end,
            get = function(info, key)
                local ci, si = strsplit(":", key)
                ci = tonumber(ci)
                si = tonumber(si)
                local class_name = Bistooltip_classes[ci].name
                local spec_name = Bistooltip_classes[ci].specs[si]
                if not BistooltipAddon.db.char.filter_specs[class_name] then
                    BistooltipAddon.db.char.filter_specs[class_name] = {}
                end
                if BistooltipAddon.db.char.filter_specs[class_name][spec_name] == nil then
                    BistooltipAddon.db.char.filter_specs[class_name][spec_name] = true
                end
                return BistooltipAddon.db.char.filter_specs[class_name][spec_name]
            end
        },
        highlight_spec = {
            name = "Resaltar especialización",
            order = 5,
            desc = "Resalta la especialización seleccionada en los tooltips de objetos",
            type = "multiselect",
            values = {}, -- Initialize as an empty table
            set = function(info, key, val)
                if val then
                    local ci, si = strsplit(":", key)
                    ci = tonumber(ci)
                    si = tonumber(si)
                    local class_name = Bistooltip_classes[ci].name
                    local spec_name = Bistooltip_classes[ci].specs[si]
                    BistooltipAddon.db.char.highlight_spec = {
                        key = key,
                        class_name = class_name,
                        spec_name = spec_name
                    }
                else
                    BistooltipAddon.db.char.highlight_spec = {}
                end

            end,
            get = function(info, key)
                return BistooltipAddon.db.char.highlight_spec.key == key
            end
        }
    }
}

local function buildFilterSpecOptions()
    local filter_specs_options = {}
    for ci, class in ipairs(Bistooltip_classes) do
        for si, spec in ipairs(class.specs) do
            local option_val = "|T" .. Bistooltip_spec_icons[class.name][spec] .. ":16|t " .. (class.name
                :gsub("Death knight","Caballero de la Muerte")
                :gsub("Druid","Druida")
                :gsub("Hunter","Cazador")
                :gsub("Mage","Mago")
                :gsub("Paladin","Paladín")
                :gsub("Priest","Sacerdote")
                :gsub("Rogue","Pícaro")
                :gsub("Shaman","Chamán")
                :gsub("Warlock","Brujo")
                :gsub("Warrior","Guerrero")) .. " " .. (spec
                :gsub("Blood tank","Sangre (tanque)")
                :gsub("Blood dps","Sangre (DPS)")
                :gsub("Frost","Escarcha")
                :gsub("Unholy","Profano")
                :gsub("Balance","Equilibrio")
                :gsub("Feral tank","Feral (tanque)")
                :gsub("Feral dps","Feral (DPS)")
                :gsub("Restoration","Restauración")
                :gsub("Beast mastery","Maestría de bestias")
                :gsub("Marksmanship","Puntería")
                :gsub("Survival","Supervivencia")
                :gsub("Arcane","Arcano")
                :gsub("Fire FFB","Fuego (FFB)")
                :gsub("Fire","Fuego")
                :gsub("Discipline","Disciplina")
                :gsub("Holy","Sagrado")
                :gsub("Shadow","Sombras")
                :gsub("Assassination","Asesinato")
                :gsub("Combat","Combate")
                :gsub("Subtlety","Sutileza")
                :gsub("Elemental","Elemental")
                :gsub("Enhancement","Mejora")
                :gsub("Affliction","Aflicción")
                :gsub("Demonology","Demonología")
                :gsub("Destruction fire","Destrucción (fuego)")
                :gsub("Destruction","Destrucción")
                :gsub("Arms","Armas")
                :gsub("Fury","Furia")
                :gsub("Protection","Protección"))
            local option_key = ci .. ":" .. si
            filter_specs_options[option_key] = option_val
        end
    end
    configTable.args.filter_specs.values = filter_specs_options
    configTable.args.highlight_spec.values = filter_specs_options
end

local function openSourceSelectDialog()
    local frame = AceGUI:Create("Window")
    frame:SetWidth(300)
    frame:SetHeight(150)
    frame:EnableResize(false)
    frame:SetCallback("OnClose", function(widget)
        AceGUI:Release(widget)
        frame = nil
    end)
    frame:SetLayout("List")
    frame:SetTitle(BistooltipAddon.AddonNameAndVersion)

    local labelEmpty = AceGUI:Create("Label")
    labelEmpty:SetFont("Fonts\\FRIZQT__.TTF", 14, "")
    labelEmpty:SetText(" ")
    frame:AddChild(labelEmpty)

    local label = AceGUI:Create("Label")
    label:SetText("Selecciona una fuente de datos BiS para usar con este addon:")
    label:SetFont("Fonts\\FRIZQT__.TTF", 14, "")
    label:SetRelativeWidth(1)
    frame:AddChild(label)

    local labelEmpty2 = AceGUI:Create("Label")
    labelEmpty2:SetFont("Fonts\\FRIZQT__.TTF", 14, "")
    labelEmpty2:SetText(" ")
    frame:AddChild(labelEmpty2)

    local sourceDropdown = AceGUI:Create("Dropdown")
    sourceDropdown:SetCallback("OnValueChanged", function(_, _, key)
        BistooltipAddon.db.char.data_source = key
        BistooltipAddon:changeSpec(key)
    end)
    sourceDropdown:SetRelativeWidth(1)
    sourceDropdown:SetList(Bistooltip_source_to_url)
    sourceDropdown:SetValue(BistooltipAddon.db.char["data_source"])
    frame:AddChild(sourceDropdown)
end

local function migrateAddonDB()
    if not BistooltipAddon.db.char.version then
        BistooltipAddon.db.char.version = 6.1
        BistooltipAddon.db.char.highlight_spec = {}
        BistooltipAddon.db.char.filter_specs = {}
        BistooltipAddon.db.char.class_index = 1
        BistooltipAddon.db.char.spec_index = 1
        BistooltipAddon.db.char.phase_index = 1
    end

    -- Set default data source to wowtbc if not already set
    if BistooltipAddon.db.char.data_source == nil then
        BistooltipAddon.db.char.data_source = "wowtbc"
    end

    if BistooltipAddon.db.char.version == 6.1 then
        BistooltipAddon.db.char.version = 6.2
        if BistooltipAddon.db.char.filter_specs["Death knight"] and
            BistooltipAddon.db.char.filter_specs["Death knight"]["Blood dps"] == nil then
            BistooltipAddon.db.char.filter_specs["Death knight"]["Blood dps"] = true
        end
    end
end

local config_shown = false
function BistooltipAddon:openConfigDialog()
    if config_shown then
        InterfaceOptionsFrame_Show()
    else
        InterfaceOptionsFrame_OpenToCategory(BistooltipAddon.AceAddonName)
    end
    config_shown = not config_shown
end

local function enableSpec(spec_name)
    if spec_name == sources.wowtbc then
        Bistooltip_bislists = Bistooltip_wowtbc_bislists
        Bistooltip_items = Bistooltip_wowtbc_items
        Bistooltip_classes = Bistooltip_wowtbc_classes
        Bistooltip_phases = Bistooltip_wowtbc_phases
    else
        -- Handle unexpected spec_name
        return
    end

    -- Check if Bistooltip_phases is nil or not a table
    if type(Bistooltip_phases) ~= "table" then
        -- Handle the error or unexpected state
        return
    end

    Bistooltip_phases_string = ""
    for i, phase in ipairs(Bistooltip_phases) do
        if i ~= 1 then
            Bistooltip_phases_string = Bistooltip_phases_string .. "/"
        end
        Bistooltip_phases_string = Bistooltip_phases_string .. phase
    end

    buildFilterSpecOptions()
end

function BistooltipAddon:addMapIcon()
    if BistooltipAddon.db.char.minimap_icon then
        icon_loaded = true
        local LDB = LibStub("LibDataBroker-1.1", true)
        local LDBIcon = LDB and LibStub("LibDBIcon-1.0", true)
        if LDB then
            local PC_MinimapBtn = LDB:NewDataObject(icon_name, {
                type = "launcher",
                text = icon_name,
                icon = "interface/icons/inv_weapon_glave_01.blp",
                OnClick = function(_, button)
                    if button == "LeftButton" then
                        BistooltipAddon:createMainFrame()
                    end
                    if button == "RightButton" then
                        BistooltipAddon:openConfigDialog()
                    end
                end,
                OnTooltipShow = function(tt)
                    tt:AddLine(BistooltipAddon.AddonNameAndVersion)
                    tt:AddLine("|cffffff00Clic izquierdo|r para abrir la ventana de listas BiS")
                    tt:AddLine("|cffffff00Clic derecho|r para abrir la configuración del addon")
                end
            })
            if LDBIcon then
                LDBIcon:Register(icon_name, PC_MinimapBtn, BistooltipAddon.db.char)
            end
        end
    end
end

function BistooltipAddon:changeSpec(spec_name)
    BistooltipAddon.db.char.class_index = 1
    BistooltipAddon.db.char.spec_index = 1
    BistooltipAddon.db.char.phase_index = 1
    enableSpec(spec_name)

    BistooltipAddon:initBislists()
    BistooltipAddon:reloadData()
end

function BistooltipAddon:initConfig()
    BistooltipAddon.db = LibStub("AceDB-3.0"):New("BisTooltipDB", db_defaults, "Default")

    migrateAddonDB()

    enableSpec(BistooltipAddon.db.char.data_source)

    buildFilterSpecOptions() -- Ensure this function is called to populate values

    LibStub("AceConfig-3.0"):RegisterOptionsTable(BistooltipAddon.AceAddonName, configTable)
    AceConfigDialog:AddToBlizOptions(BistooltipAddon.AceAddonName, BistooltipAddon.AceAddonName)
end



