﻿local eventFrame = CreateFrame("Frame", nil, UIParent)
Bistooltip_phases_string = ""

local function specHighlighted(class_name, spec_name)
    return (BistooltipAddon.db.char.highlight_spec.spec_name == spec_name and
               BistooltipAddon.db.char.highlight_spec.class_name == class_name)
end

local function specFiltered(class_name, spec_name)
    if specHighlighted(class_name, spec_name) then
        return false
    end
    if IsAltKeyDown() then
        return false
    end
    if BistooltipAddon.db.char.filter_specs[class_name] then
        return not BistooltipAddon.db.char.filter_specs[class_name][spec_name]
    end
    return false
end

local function classNamesFiltered()
    if BistooltipAddon.db.char.filter_class_names then
        return true
    end
end

local function getFilteredItem(item)
    local filtered_item = {}

    for ki, spec in ipairs(item) do
        local class_name = spec.class_name
        local spec_name = spec.spec_name
        if (not specFiltered(class_name, spec_name)) then
            table.insert(filtered_item, spec)
        end
    end
    return filtered_item
end

local function printSpecLine(tooltip, slot, class_name, spec_name)
    local slot_name = slot.name
    local slot_ranks = slot.ranks
    local prefix = "   "
    if BistooltipAddon.db.char.filter_class_names then
        prefix = ""
    end
    local left_text = prefix .. "|T" .. Bistooltip_spec_icons[class_name][spec_name] .. ":14|t " .. (spec_name
        :gsub("Blood tank","Sangre (tanque)")
        :gsub("Blood dps","Sangre (DPS)")
        :gsub("Frost","Escarcha")
        :gsub("Unholy","Profano")
        :gsub("Balance","Equilibrio")
        :gsub("Feral tank","Feral (tanque)")
        :gsub("Feral dps","Feral (DPS)")
        :gsub("Restoration","Restauración")
        :gsub("Beast mastery","Maestría de bestias")
        :gsub("Marksmanship","Puntería")
        :gsub("Survival","Supervivencia")
        :gsub("Arcane","Arcano")
        :gsub("Fire FFB","Fuego (FFB)")
        :gsub("Fire","Fuego")
        :gsub("Discipline","Disciplina")
        :gsub("Holy","Sagrado")
        :gsub("Shadow","Sombras")
        :gsub("Assassination","Asesinato")
        :gsub("Combat","Combate")
        :gsub("Subtlety","Sutileza")
        :gsub("Elemental","Elemental")
        :gsub("Enhancement","Mejora")
        :gsub("Affliction","Aflicción")
        :gsub("Demonology","Demonología")
        :gsub("Destruction fire","Destrucción (fuego)")
        :gsub("Destruction","Destrucción")
        :gsub("Arms","Armas")
        :gsub("Fury","Furia")
        :gsub("Protection","Protección"))
    if (slot_name == "Off hand" or slot_name == "Weapon" or slot_name == "Weapon 1h" or slot_name == "Weapon 2h") then
        left_text = left_text .. " (" .. (slot_name:gsub("Off hand","Mano izquierda"):gsub("Weapon 1h","Arma 1M"):gsub("Weapon 2h","Arma 2M"):gsub("Weapon","Arma")) .. ")"
    end
    tooltip:AddDoubleLine(left_text, slot_ranks, 1, 0.8, 0)
end

local function printClassName(tooltip, class_name)
    tooltip:AddLine((class_name:gsub("Death knight","Caballero de la Muerte"):gsub("Druid","Druida"):gsub("Hunter","Cazador"):gsub("Mage","Mago"):gsub("Paladin","Paladín"):gsub("Priest","Sacerdote"):gsub("Rogue","Pícaro"):gsub("Shaman","Chamán"):gsub("Warlock","Brujo"):gsub("Warrior","Guerrero")), 1, 0.8, 0)
end

-- Define your search function without debug prints
function searchIDInBislistsClassSpec(structure, id, class, spec)
    local paths = {}
    local seen = {} -- To track unique phase labels

    -- Sort phases according to Bistooltip_wowtbc_phases order
    local sortedPhases = {}
    for _, phase in ipairs(Bistooltip_wowtbc_phases) do
        if structure[class] and structure[class][spec] and structure[class][spec][phase] then
            table.insert(sortedPhases, phase)
        end
    end

    -- Iterate over sorted phases
    for _, phase in ipairs(sortedPhases) do
        local items = structure[class][spec][phase]

        for index, itemData in pairs(items) do
            if type(itemData) == "table" and itemData[1] then
                for i, itemId in ipairs(itemData) do
                    if i ~= "slot_name" and i ~= "enhs" and itemId == id then
                        -- Determine the phase label based on the value of i
                        local phaseLabel
                        if i == 1 then
                            phaseLabel = phase .. " BIS"
                        else
                            phaseLabel = phase .. " alt " .. i
                        end

                        -- Add phase label to paths if not already seen
                        if not seen[phaseLabel] then
                            table.insert(paths, phaseLabel)
                            seen[phaseLabel] = true
                        end
                    end
                end
            end
        end
    end

    if #paths > 0 then
        return table.concat(paths, " / ")
    else
        return nil
    end
end

local function caseInsensitivePairs(t)
    local keys = {}
    for k in pairs(t) do
        table.insert(keys, k)
    end
    table.sort(keys, function(a, b)
        return a:lower() < b:lower()
    end)
    local i = 0
    return function()
        i = i + 1
        local k = keys[i]
        if k then
            return k, t[k]
        end
    end
end

-- Function to calculate the length of a string without color codes
local function getStringLength(str)
    return string.len(string.gsub(str, "|c%x%x%x%x%x%x%x%x", ""):gsub("|r", ""))
end

function table.contains(table, element)
    for _, value in pairs(table) do
        if value == element then
            return true
        end
    end
    return false
end

-- Initialize DataStore_Inventory as a local variable
local DataStore_Inventory = DataStore_Inventory or nil

local function GetItemSource(itemId)
    local source

    -- Function to replace specific instance names
    local function formatInstanceName(instance)
        local tmpInstance = string.lower(instance)
        if tmpInstance == "the obsidian sanctum (heroic)" then
            instance = "The Obsidian Sanctum(25)"
        elseif tmpInstance == "the eye of eternity (heroic)" then
            instance = "The Eye Of Eternity (25)"
        elseif tmpInstance == "naxxramas (heroic)" then
            instance = "Naxxramas (25)"
        elseif tmpInstance == "ulduar (heroic)" then
            instance = "Ulduar (25)"
        end
        local instMap = {
            ["The Forge of Souls"] = "La Forja de Almas",
            ["Pit of Saron"] = "Foso de Saron",
            ["Halls of Reflection"] = "Salas de Reflexión",
            ["The Eye Of Eternity"] = "El Ojo de la Eternidad",
            ["The Eye of Eternity"] = "El Ojo de la Eternidad",
            ["The Obsidian Sanctum"] = "El Sagrario Obsidiana",
            ["Naxxramas"] = "Naxxramas",
            ["Ulduar"] = "Ulduar",
            ["Trial of the Crusader"] = "Prueba del Cruzado",
            ["Trial of the Grand Crusader"] = "Prueba del Gran Cruzado",
            ["Icecrown Citadel"] = "Ciudadela de la Corona de Hielo",
            ["Vault of Archavon"] = "La Cámara de Archavon",
            ["Onyxia's Lair"] = "Guarida de Onyxia",
            ["The Ruby Sanctum"] = "El Sagrario Rubí",
            ["Azjol-Nerub"] = "Azjol-Nerub",
            ["The Violet Hold"] = "El Bastión Violeta",
            ["Drak'Tharon Keep"] = "Fortaleza de Drak'Tharon",
            ["Gundrak"] = "Gundrak",
            ["Utgarde Keep"] = "Fortaleza de Utgarde",
            ["Utgarde Pinnacle"] = "Pináculo de Utgarde",
            ["Halls of Lightning"] = "Salas de Relámpagos",
            ["Halls of Stone"] = "Salas de Piedra",
        }
        local size = instance:match("%((%d+)%s*%)")
        local isHeroic = (instance:match("%((%s*)Heroic(%s*)%)") ~= nil) or (instance:match("%((%s*)heroic(%s*)%)") ~= nil)
        local base = instance:gsub("%s*%(%s*%d+%s*%)",""):gsub("%s*%(%s*Heroic%s*%)",""):gsub("%s*%(%s*heroic%s*%)","")
        local res = base
        for en, es in pairs(instMap) do
            if base:lower() == en:lower() then
                res = es
                break
            end
        end
        if size then res = res .. " (" .. size .. ")" end
        if isHeroic then res = res .. " (Heroico)" end
        res = res:gsub("^Arena Season (%d+)$","Temporada %1 de Arena")
        res = res:gsub("^Emblems of Valor$","Emblemas de Valor")
        res = res:gsub("^Emblems of Heroism$","Emblemas de Heroísmo")
        res = res:gsub("^Emblems of Conquest$","Emblemas de Conquista")
        res = res:gsub("^Emblems of Triumph$","Emblemas de Triunfo")
        res = res:gsub("^Emblems of Frost$","Emblemas de Escarcha")
        res = res:gsub("^World Drops$","Botín mundial")
        res = res:gsub("^Various Locations$","Varios lugares")
        res = res:gsub("^Tier (%d+) Tokens$","Fichas de conjunto %1")
        res = res:gsub("^Feast of Winter Veil$","Festividad del Velo de Invierno")
        res = res:gsub("^Hallow's End$","Halloween")
        res = res:gsub("^Noblegarden$","Jardín Noble")
        res = res:gsub("^Harvest Festival$","Festival de la Cosecha")
        res = res:gsub("^Midsummer Fire Festival$","Festival del Fuego")
        res = res:gsub("^Pilgrim's Bounty$","Festín de los Peregrinos")
        res = res:gsub("^Day of the Dead$","Día de los Muertos")
        res = res:gsub("^Scourge Invasion$","Invasión de la Plaga")
        res = res:gsub("^Lunar Festival$","Festival Lunar")
        res = res:gsub("^Brewfest$","Festival de la Cerveza")
        res = res:gsub("^Children's Week$","Semana de los Niños")
        res = res:gsub("^Love is in the air$","Amor en el aire")
        res = res:gsub("^Alterac Valley$","Valle de Alterac")
        res = res:gsub("^Arathi Basin$","Cuenca de Arathi")
        res = res:gsub("^Warsong Gulch$","Garganta Grito de Guerra")
        res = res:gsub("^Wintergrasp$","Conquista del Invierno")
        res = res:gsub("^Dalaran$","Dalaran")
        res = res:gsub("^Level 70 Honor PVP$","PVP de honor (nivel 70)")
        res = res:gsub("^Level 70 Reputation PVP$","PVP de reputación (nivel 70)")
        res = res:gsub("^Level 80 Honor PVP$","PVP de honor (nivel 80)")
        res = res:gsub("^Heroic Mode Tokens$","Distintivos de modo heroico")
        res = res:gsub("^Blizzard Collectables$","Coleccionables de Blizzard")
        res = res:gsub("^Upper Deck$","Upper Deck")
        res = res:gsub("^Trial of the Champion$","Prueba del Campeón")
        res = res:gsub("^Darkmoon Faire$","Feria de la Luna Negra")
        res = res:gsub("^Argent Tournament$","Torneo Argenta")
        res = res:gsub("^Isle of Quel'Danas$","Isla de Quel'Danas")
        res = res:gsub("^Shattrath City$","Ciudad de Shattrath")
        res = res:gsub("^The Sons of Hodir$","Los Hijos de Hodir")
        res = res:gsub("^Knights of the Ebon Blade$","Caballeros de la Espada de Ébano")
        res = res:gsub("^Argent Crusade$","Cruzada Argenta")
        res = res:gsub("^The Wyrmrest Accord$","El Acuerdo del Reposo del Dragón")
        res = res:gsub("^Kirin Tor$","Kirin Tor")
        res = res:gsub("^The Kalu'ak$","Los Kalu'ak")
        res = res:gsub("^The Oracles$","Los Oráculos")
        res = res:gsub("^Frenzyheart Tribe$","Tribu Corazón Frenético")
        return res
    end

    if ResolvedSources and ResolvedSources[itemId] then
        local entries = ResolvedSources[itemId]
        local parts = {}
        local maxn = #entries
        if maxn > 0 then
            for i=1, (maxn > 2 and 2 or maxn) do
                local e = entries[i]
                local formattedZone = formatInstanceName(e.instance or "")
                local bossText = (e.boss or "")
                    :gsub("Trash Mobs","Esbirros")
                    :gsub("Various Locations","Varios lugares")
                    :gsub("Vendors","Vendedores")
                parts[#parts+1] = "|cFF00FF00[" .. formattedZone .. "] - " .. bossText .. "|r"
            end
            if #parts > 0 then
                source = "|cFFFFFFFFFuente:|r " .. table.concat(parts, " | ")
            end
        end
    end

    if source then return source end

    for zone, group in pairs(lootTable) do
        if type(group[1]) == "number" then
            if table.contains(group, itemId) then
                local formattedZone = formatInstanceName(zone)
                source = "|cFFFFFFFFFuente:|r |cFF00FF00[" .. formattedZone .. "]|r"
            end
        else
            for boss, items in pairs(group) do
                if table.contains(items, itemId) then
                    local formattedZone = formatInstanceName(zone)
                    local bossText = boss
                        :gsub("Trash Mobs","Esbirros")
                        :gsub("Quest rewards","Recompensas de misiones")
                        :gsub("Various Locations","Varios lugares")
                        :gsub("Weapons","Armas")
                        :gsub("Accessories","Accesorios")
                        :gsub("Cloth","Tela")
                        :gsub("Leather","Cuero")
                        :gsub("Mail","Mallas")
                        :gsub("Plate","Placas")
                        :gsub("Alliance","Alianza")
                        :gsub("Horde","Horda")
                        :gsub("Gaily Wrapped Present","Regalo envuelto alegremente")
                        :gsub("Festive Gift","Regalo festivo")
                        :gsub("Winter Veil Gift","Regalo del Velo de Invierno")
                        :gsub("Gently Shaken Gift","Regalo sacudido suavemente")
                        :gsub("Ticking Present","Regalo con tictac")
                        :gsub("Carefully Wrapped Present","Regalo envuelto cuidadosamente")
                        :gsub("Smokywood Pastures Vendor","Vendedor de Pastos Leñosos")
                        :gsub("Smokywood Pastures Extra%-Special Gift","Regalo extra especial de Pastos Leñosos")
                        :gsub("Brightly Colored Egg","Huevo de colores brillantes")
                        :gsub("Fireworks Pack","Paquete de fuegos artificiales")
                        :gsub("Lucky Red Envelope","Sobre rojo de la suerte")
                        :gsub("Engineering","Ingeniería")
                        :gsub("Tailoring","Sastrería")
                        :gsub("Food","Comida")
                        :gsub("Cloth Set","Conjunto de tela")
                        :gsub("Leather Set","Conjunto de cuero")
                        :gsub("Mail Set","Conjunto de mallas")
                        :gsub("Plate Set","Conjunto de placas")
                        :gsub("Druid Set","Conjunto de druida")
                        :gsub("Hunter Set","Conjunto de cazador")
                        :gsub("Mage Set","Conjunto de mago")
                        :gsub("Paladin Set","Conjunto de paladín")
                        :gsub("Priest Set","Conjunto de sacerdote")
                        :gsub("Rogue Set","Conjunto de pícaro")
                        :gsub("Shaman Set","Conjunto de chamán")
                        :gsub("Warlock Set","Conjunto de brujo")
                        :gsub("Warrior Set","Conjunto de guerrero")
                        :gsub("Non Set Accessories","Accesorios (sin conjunto)")
                        :gsub("Non Set Cloth","Tela (sin conjunto)")
                        :gsub("Non Set Leather","Cuero (sin conjunto)")
                        :gsub("Non Set Mail","Mallas (sin conjunto)")
                        :gsub("Non Set Plate","Placas (sin conjunto)")
                        :gsub("Superior Rewards","Recompensas superiores")
                        :gsub("Epic Rewards","Recompensas épicas")
                        :gsub("Achievement Rewards","Recompensas por logros")
                        :gsub("Daily Quests","Misiones diarias")
                        :gsub("Weekly Quests","Misiones semanales")
                        :gsub("Exalted","Exaltado")
                        :gsub("Revered","Venerado")
                        :gsub("Honored","Honorable")
                        :gsub("Friendly","Amistoso")
                        :gsub("Neutral","Neutral")
                        :gsub("Alchemy","Alquimia")
                        :gsub("Blacksmithing","Herrería")
                        :gsub("Leatherworking","Peletería")
                        :gsub("Jewelcrafting","Joyería")
                        :gsub("Inscription","Inscripción")
                        :gsub("Enchanting","Encantamiento")
                        :gsub("Cooking","Cocina")
                        :gsub("First Aid","Primeros auxilios")
                        :gsub("Fishing","Pesca")
                        :gsub("Lord Ahune %(%s*Heroic%s*%)","Lord Ahune (Heroico)")
                        :gsub("Lord Ahune","Lord Ahune")
                        :gsub("Booty Run","Carrera por botín")
                        :gsub("Treat Bag","Bolsa de golosinas")
                        :gsub("Headless Horseman","Jinete decapitado")
                        :gsub("Vendors","Vendedores")
                        :gsub("The Black Knight","El Caballero Negro")
                        :gsub("Argent Confessor Paletress","Confesora Argenta Paletress")
                        :gsub("Eadric the Pure","Eadric el Puro")
                        :gsub("Isle of Quel'Danas","Isla de Quel'Danas")
                        :gsub("Shattrath City","Ciudad de Shattrath")
                        :gsub("Argent Tournament","Torneo Argenta")
                        :gsub("Wintergrasp","Conquista del Invierno")
                        :gsub("Dalaran","Dalaran")
                        :gsub("Kirin Tor","Kirin Tor")
                        :gsub("Knights of the Ebon Blade","Caballeros de la Espada de Ébano")
                        :gsub("Argent Crusade","Cruzada Argenta")
                        :gsub("The Wyrmrest Accord","El Acuerdo del Reposo del Dragón")
                        :gsub("The Sons of Hodir","Los Hijos de Hodir")
                        :gsub("The Kalu'ak","Los Kalu'ak")
                        :gsub("The Oracles","Los Oráculos")
                        :gsub("Frenzyheart Tribe","Tribu Corazón Frenético")
                        :gsub("Emblems of Heroism","Emblemas de Heroísmo")
                        :gsub("Emblems of Valor","Emblemas de Valor")
                        :gsub("Emblems of Triumph","Emblemas de Triunfo")
                        :gsub("Emblems of Frost","Emblemas de Escarcha")
                        :gsub("Tier (%d+) Tokens","Fichas de conjunto %1")
                        :gsub("Lady Deathwhisper","Señora Susurramuerte")
                        :gsub("Blood Princes","Príncipes de Sangre")
                        :gsub("The Twin Val'kyr","Val'kyr Gemelas")
                        :gsub("Icecrown Gunship Battle","Batalla de los Aeronavíos")
                    source = "|cFFFFFFFFFuente:|r |cFF00FF00[" .. formattedZone .. "] - " .. bossText .. "|r"
                    break
                end
            end
        end
        if source then break end
    end

    -- If not found in lootTable, fallback to DataStore_Inventory
    if not source then
        local dsi = DataStore_Inventory
        if dsi and dsi.GetSource then
            local Instance, Boss = dsi:GetSource(itemId)
            if Instance and Boss then
                local formattedInstance = formatInstanceName(Instance)
            local bossText = Boss
                :gsub("Trash Mobs","Esbirros")
                :gsub("Various Locations","Varios lugares")
                :gsub("Weapons","Armas")
                :gsub("Accessories","Accesorios")
                :gsub("Cloth","Tela")
                :gsub("Leather","Cuero")
                :gsub("Mail","Mallas")
                :gsub("Plate","Placas")
                :gsub("Vendors","Vendedores")
                :gsub("Alchemy","Alquimia")
                :gsub("Blacksmithing","Herrería")
                :gsub("Leatherworking","Peletería")
                :gsub("Jewelcrafting","Joyería")
                :gsub("Inscription","Inscripción")
                :gsub("Enchanting","Encantamiento")
                :gsub("Cooking","Cocina")
                :gsub("First Aid","Primeros auxilios")
                :gsub("Fishing","Pesca")
                :gsub("Achievement Rewards","Recompensas por logros")
                :gsub("Daily Quests","Misiones diarias")
                :gsub("Weekly Quests","Misiones semanales")
                :gsub("Exalted","Exaltado")
                :gsub("Revered","Venerado")
                :gsub("Honored","Honorable")
                :gsub("Friendly","Amistoso")
                :gsub("Neutral","Neutral")
                :gsub("Emblems of Heroism","Emblemas de Heroísmo")
                :gsub("Emblems of Valor","Emblemas de Valor")
                :gsub("Emblems of Triumph","Emblemas de Triunfo")
                :gsub("Emblems of Frost","Emblemas de Escarcha")
                :gsub("Tier (%d+) Tokens","Fichas de conjunto %1")
                :gsub("Lady Deathwhisper","Señora Susurramuerte")
                :gsub("Blood Princes","Príncipes de Sangre")
                :gsub("The Twin Val'kyr","Val'kyr Gemelas")
                :gsub("Icecrown Gunship Battle","Batalla de los Aeronavíos")
            source = "|cFFFFFFFFFuente:|r |cFF00FF00[" .. formattedInstance .. "] - " .. bossText .. "|r"
            else
                if BistooltipAddon and BistooltipAddon.db and BistooltipAddon.db.char then
                    BistooltipAddon.db.char.missing_sources = BistooltipAddon.db.char.missing_sources or {}
                    BistooltipAddon.db.char.missing_sources[itemId] = true
                end
                return nil
            end
        else
            if BistooltipAddon and BistooltipAddon.db and BistooltipAddon.db.char then
                BistooltipAddon.db.char.missing_sources = BistooltipAddon.db.char.missing_sources or {}
                BistooltipAddon.db.char.missing_sources[itemId] = true
            end
            return nil
        end
    end

    return source
end

-- Function to handle item tooltip
local function OnGameTooltipSetItem(tooltip)
    -- print("Debug: OnGameTooltipSetItem called")
    if BistooltipAddon.db.char.tooltip_with_ctrl and not IsControlKeyDown() then
        return
    end

    local _, link = tooltip:GetItem()
    if not link then
        return
    end

    local _, itemId, _, _, _, _, _, _, _, _, _, _, _, _ = strsplit(":", link)
    itemId = tonumber(itemId)

    if not itemId then
        return
    end

    -- tooltip:AddDoubleLine("Spec Name", "Phase", 1, 1, 1, 1, 1, 1)

    -- -- Iterate through each class and specialization
    for class, specs in caseInsensitivePairs(Bistooltip_spec_icons) do
        for spec, icon in pairs(specs) do
            -- Skip the 'classIcon' entry
            if spec ~= "classIcon" then
                -- Search for the item ID in the current class and spec
                local foundPhases = searchIDInBislistsClassSpec(Bistooltip_bislists, itemId, class, spec)

                -- Only proceed if search function returns a non-nil value
                if foundPhases then
                    -- Create a single line with icon, class, spec, and found phases
                    local iconString = string.format("|T%s:18|t", icon)
                    local classText = (class:gsub("Death knight","Caballero de la Muerte"):gsub("Druid","Druida"):gsub("Hunter","Cazador"):gsub("Mage","Mago"):gsub("Paladin","Paladín"):gsub("Priest","Sacerdote"):gsub("Rogue","Pícaro"):gsub("Shaman","Chamán"):gsub("Warlock","Brujo"):gsub("Warrior","Guerrero"))
                    local specText = (spec
                        :gsub("Blood tank","Sangre (tanque)")
                        :gsub("Blood dps","Sangre (DPS)")
                        :gsub("Frost","Escarcha")
                        :gsub("Unholy","Profano")
                        :gsub("Balance","Equilibrio")
                        :gsub("Feral tank","Feral (tanque)")
                        :gsub("Feral dps","Feral (DPS)")
                        :gsub("Restoration","Restauración")
                        :gsub("Beast mastery","Maestría de bestias")
                        :gsub("Marksmanship","Puntería")
                        :gsub("Survival","Supervivencia")
                        :gsub("Arcane","Arcano")
                        :gsub("Fire FFB","Fuego (FFB)")
                        :gsub("Fire","Fuego")
                        :gsub("Discipline","Disciplina")
                        :gsub("Holy","Sagrado")
                        :gsub("Shadow","Sombras")
                        :gsub("Assassination","Asesinato")
                        :gsub("Combat","Combate")
                        :gsub("Subtlety","Sutileza")
                        :gsub("Elemental","Elemental")
                        :gsub("Enhancement","Mejora")
                        :gsub("Affliction","Aflicción")
                        :gsub("Demonology","Demonología")
                        :gsub("Destruction fire","Destrucción (fuego)")
                        :gsub("Destruction","Destrucción")
                        :gsub("Arms","Armas")
                        :gsub("Fury","Furia")
                        :gsub("Protection","Protección"))
                    specText = specText:gsub("%s*%((.-)%)"," - %1")
                    local lineText = string.format("%s %s - %s", iconString, classText, specText)
                    local phasesText = (foundPhases
                        :gsub("PR","Pre-incursión")
                        :gsub("T10","Conjunto 10")
                        :gsub("T9","Conjunto 9")
                        :gsub("T8","Conjunto 8")
                        :gsub("T7","Conjunto 7")
                        :gsub("RS","Sagrario Rubí")
                        :gsub("BIS","Mejor en ranura")
                        :gsub(" alt "," alternativa "))
                    tooltip:AddDoubleLine(lineText, phasesText, 1, 1, 0, 1, 1, 0)
                end
            end
        end
    end

    -- if Bistooltip_char_equipment and Bistooltip_char_equipment[itemId] ~= nil then
    --     tooltip:AddLine(" ", 1, 1, 0)
    --     if Bistooltip_char_equipment[itemId] == 2 then
    --         tooltip:AddLine("You have this item equipped", 0.074, 0.964, 0.129)
    --     else
    --         tooltip:AddLine("You have this item in your inventory", 0.074, 0.964, 0.129)
    --     end
    -- end

    -- tooltip:AddLine(" ", 1, 1, 0)
    -- tooltip:AddLine("Hold ALT to disable spec filtering", 0.6, 0.6, 0.6)

    -- Fetch item source information
    local itemSource = GetItemSource(itemId)

    -- Add item source information to tooltip if available
    if itemSource then
        tooltip:AddLine(" ", 1, 1, 0)
        tooltip:AddLine(itemSource, 1, 1, 1)
        tooltip:AddLine(" ", 1, 1, 0)
    end
end

function BistooltipAddon:initBisTooltip()
    eventFrame:RegisterEvent("MODIFIER_STATE_CHANGED")
    eventFrame:SetScript("OnEvent", function(_, _, e_key, _, _)
        if GameTooltip:GetOwner() then
            if GameTooltip:GetOwner().hasItem then
                return
            end

            if e_key == "RALT" or e_key == "LALT" then
                local _, link = GameTooltip:GetItem()
                if link then
                    GameTooltip:SetHyperlink("|cff9d9d9d|Hitem:3299::::::::20:257::::::|h[Fractured Canine]|h|r")
                    GameTooltip:SetHyperlink(link)
                end
            end
        end
    end)

    GameTooltip:HookScript("OnTooltipSetItem", OnGameTooltipSetItem)
    ItemRefTooltip:HookScript("OnTooltipSetItem", OnGameTooltipSetItem)
end



