local addonName, ns = ...
local settings = ReaperHP_Settings  -- created by main addon
local defaults = ns.defaults or {}

------------------------------------------------------------
-- CREATE PANEL
------------------------------------------------------------
local panel = CreateFrame("Frame", "ReaperHPBarOptions", UIParent)
panel.name = "Reaper HP Bar"
InterfaceOptions_AddCategory(panel)

------------------------------------------------------------
-- TITLE
------------------------------------------------------------
local title = panel:CreateFontString(nil, "OVERLAY", "GameFontNormalLarge")
title:SetPoint("TOPLEFT", 16, -16)
title:SetText("Reaper HP Bar - Options")

local ypos = -50

------------------------------------------------------------
-- UTILITY: SLIDER
------------------------------------------------------------
local function MakeSlider(label, key, min, max, step)
    local name = "RHP_OptSlider_"..key
    local s = CreateFrame("Slider", name, panel, "OptionsSliderTemplate")
    s:SetPoint("TOPLEFT", 16, ypos)
    s:SetMinMaxValues(min, max)
    s:SetValueStep(step)
    s:SetWidth(260)

    _G[name.."Low"]:SetText(tostring(min))
    _G[name.."High"]:SetText(tostring(max))
    _G[name.."Text"]:SetText(label)

    s:SetValue(settings[key] or defaults[key])

    s:SetScript("OnValueChanged", function(self, val)
        if step >= 1 then val = math.floor(val) end
        settings[key] = val
        ns.ApplySettings()
    end)

    ypos = ypos - 55
    return s
end

------------------------------------------------------------
-- UTILITY: CHECKBOX
------------------------------------------------------------
local function MakeCheck(label, key)
    local c = CreateFrame("CheckButton", "RHP_OptCheck_"..key, panel, "InterfaceOptionsCheckButtonTemplate")
    c:SetPoint("TOPLEFT", 16, ypos)
    _G[c:GetName().."Text"]:SetText(label)
    c:SetChecked(settings[key])

    c:SetScript("OnClick", function(self)
        settings[key] = self:GetChecked()
        ns.ApplySettings()
    end)

    ypos = ypos - 30
    return c
end

------------------------------------------------------------
-- SLIDERS
------------------------------------------------------------
MakeSlider("Bar Width",  "width", 80, 600, 1)
MakeSlider("Bar Height", "height", 4, 40, 1)
MakeSlider("Smoothing (higher = faster)", "smoothing", 2, 30, 1)
MakeSlider("Glow Alpha", "glowAlpha", 0, 1, 0.01)

------------------------------------------------------------
-- CHECKBOXES
------------------------------------------------------------
MakeCheck("Show HP Numbers", "showNumbers")
MakeCheck("Auto Color (green → red)", "autoColor")
MakeCheck("Class Gradient (class-colored)", "classGradient")
MakeCheck("Show Absorb Overlay", "showAbsorb")
MakeCheck("Show Incoming Heal Overlay", "showIncomingHeal")

------------------------------------------------------------
-- PROFILES
------------------------------------------------------------
local profTitle = panel:CreateFontString(nil, "OVERLAY", "GameFontNormal")
profTitle:SetPoint("TOPLEFT", 320, -50)
profTitle:SetText("Profiles")

local profBox = CreateFrame("EditBox", "RHP_OptProfileName", panel, "InputBoxTemplate")
profBox:SetPoint("TOPLEFT", profTitle, "BOTTOMLEFT", 0, -8)
profBox:SetSize(160, 24)
profBox:SetAutoFocus(false)
profBox:SetText("MyProfile")

local saveBtn = CreateFrame("Button", nil, panel, "UIPanelButtonTemplate")
saveBtn:SetText("Save")
saveBtn:SetSize(80,22)
saveBtn:SetPoint("LEFT", profBox, "RIGHT", 6, 0)
saveBtn:SetScript("OnClick", function()
    local name = profBox:GetText()
    local ok, err = ns.SaveProfile(name)
    if ok then print("ReaperHPBar: Saved profile '"..name.."'") else print("ReaperHPBar: Failed to save - "..(err or "?")) end
end)

local loadBtn = CreateFrame("Button", nil, panel, "UIPanelButtonTemplate")
loadBtn:SetText("Load")
loadBtn:SetSize(80,22)
loadBtn:SetPoint("TOPLEFT", profBox, "BOTTOMLEFT", 0, -6)
loadBtn:SetScript("OnClick", function()
    local name = profBox:GetText()
    local ok, err = ns.LoadProfile(name)
    if ok then print("ReaperHPBar: Loaded profile '"..name.."'") else print("ReaperHPBar: Failed to load - "..(err or "?")) end
end)

------------------------------------------------------------
-- ON LOAD: ENSURE SLIDERS REFRESH
------------------------------------------------------------
panel:SetScript("OnShow", function()
    -- refresh slider values whenever panel opens
    for _, child in ipairs({panel:GetChildren()}) do
        if child.GetValue and child.SetValue and child:GetObjectType() == "Slider" then
            local key = child:GetName():gsub("RHP_OptSlider_", "")
            if settings[key] then
                child:SetValue(settings[key])
            end
        end
    end
end)
