-- Simple profiler for TSMPerfBoost (counts calls)
local profiler = {}
profiler.enabled = false
profiler.hits = {}
profiler.startTime = 0

local function tick(name)
    if not profiler.enabled then return end
    profiler.hits[name] = (profiler.hits[name] or 0) + 1
end

local function HookIf(fnTable, fnName)
    if not fnTable or type(fnTable[fnName]) ~= "function" then return end
    local orig = fnTable[fnName]
    fnTable[fnName] = function(...)
        tick(fnName)
        return orig(...)
    end
end

-- Try to hook common TSM2 scan functions safely
local tsm = _G.TSM or _G.TradeSkillMaster
if tsm and tsm.Scan then
    HookIf(tsm.Scan, "StartScan")
    HookIf(tsm.Scan, "StopScan")
end
if tsm and type(tsm.ScanStart) == "function" then
    HookIf(tsm, "ScanStart")
    HookIf(tsm, "ScanStop")
end

SLASH_TSMperfprof1 = "/tsmprof"
SlashCmdList["TSMperfprof"] = function(msg)
    local cmd = (msg or ""):lower()
    if cmd == "start" then
        profiler.enabled = true
        profiler.hits = {}
        profiler.startTime = GetTime()
        print("TSMPerfBoost profiler started")
    elseif cmd == "stop" then
        profiler.enabled = false
        print("TSMPerfBoost profiler stopped")
    elseif cmd == "report" then
        print("TSMPerfBoost profiler report (since " .. tostring(profiler.startTime) .. ")")
        for k,v in pairs(profiler.hits) do
            print(k .. ": " .. tostring(v))
        end
    else
        print("Usage: /tsmprof start|stop|report")
    end
end

return true
