-- TSMPerfBoost (Bronzebeard) v1.0.0 Full Addon: Optimized + Mail + AH + Tooltip

-- Main bootstrap: TSMPerfBoost.lua
local ADDON_NAME = "TSMPerfBoost"
local f = CreateFrame("Frame")
local GetTime, collectgarbage = GetTime, collectgarbage

local CONFIG = {
    gc_interval = 8,
    gc_step = 40,
    price_cache_ttl = 5,
    fps_low_threshold = 35,
    fps_high_threshold = 55,
    scan_chunk_size = 30,
}

local state = { blockUI=false, nextGC=0, lastFPS=60 }

-- FPS sampling
local frameCounter, fpsTimer = 0, 0
local function SampleFPS(elapsed)
    frameCounter = frameCounter + 1
    fpsTimer = fpsTimer + elapsed
    if fpsTimer >= 1 then state.lastFPS = frameCounter/fpsTimer frameCounter,fpsTimer=0,0 end
end

-- GC stepper
local function MaybeGC(now)
    if now >= state.nextGC then collectgarbage("step", CONFIG.gc_step) state.nextGC = now + CONFIG.gc_interval end
end

-- Throttling
local function AdjustThrottling()
    local fps = state.lastFPS
    if fps < CONFIG.fps_low_threshold then CONFIG.price_cache_ttl, CONFIG.scan_chunk_size = 10,12
    elseif fps < CONFIG.fps_high_threshold then CONFIG.price_cache_ttl, CONFIG.scan_chunk_size = 6,20
    else CONFIG.price_cache_ttl, CONFIG.scan_chunk_size = 5,30 end
end

-- Attach to TSM
local function OptimizeTSM()
    if not TSMAPI or not TSMAPI.Auction then return end
    if TSMAPI.Auction.DoScan then hooksecurefunc(TSMAPI.Auction,"DoScan",function() state.blockUI=true end) end
    if TSMAPI.Auction.OnScanComplete then hooksecurefunc(TSMAPI.Auction,"OnScanComplete",function() state.blockUI=false end) end
    if TSMAPI.Auction.ScanComplete then hooksecurefunc(TSMAPI.Auction,"ScanComplete",function() state.blockUI=false end) end
end

-- Event spam protection
local spamEvents = { BAG_UPDATE=true, BAG_NEW_ITEMS_UPDATED=true, PLAYER_MONEY=true, UPDATE_INVENTORY_ALERTS=true }
local eventFrame = CreateFrame("Frame")
for e in pairs(spamEvents) do eventFrame:RegisterEvent(e) end
eventFrame:SetScript("OnEvent",function(self,event,...) if state.blockUI and spamEvents[event] then return end end)

-- Tooltip protection & caching
local tt=GameTooltip
if tt and tt.SetHyperlink then
    local origSetHyperlink=tt.SetHyperlink
    tt.SetHyperlink=function(self,link,...) if state.blockUI then return end return origSetHyperlink(self,link,...) end
end

-- AuctionFrame OnUpdate throttling
if AuctionFrame and AuctionFrame.GetScript then
    local orig=AuctionFrame:GetScript("OnUpdate")
    if orig then AuctionFrame:SetScript("OnUpdate",function(self,elapsed) if state.blockUI then return end return orig(self,elapsed) end) end
end

-- Cache helper
local cache={}
if TSMPerfBoost_cache then cache=TSMPerfBoost_cache end
_G.TSMPerfBoost={}
_G.TSMPerfBoost.GetState=function() return state end
_G.TSMPerfBoost.ForceGC=function() collectgarbage("collect") end

-- OnUpdate
local updater=CreateFrame("Frame")
updater:SetScript("OnUpdate",function(self,elapsed) SampleFPS(elapsed) MaybeGC(GetTime()) AdjustThrottling() end)

-- Addon loaded hook
f:RegisterEvent("ADDON_LOADED")
f:SetScript("OnEvent",function(_,_,name) if name=="TradeSkillMaster" or name=="TradeSkillMaster_Auctioning" then OptimizeTSM() end end)
_G.TSMPerfBoostConfig=CONFIG

-- Mail Optimizations
local PB=_G.TSMPerfBoost
PB.mail=PB.mail or {}

-- Safe inbox processing & batching
local BATCH_DELAY, SNAPSHOT_INTERVAL, REOPEN_DELAY=0.08,0.02,0.25
local GC_SUPPRESS, GC_SUPPRESS_INTERVAL=true,5
PB.mail._snapshot=nil PB.mail._processing=false PB.mail._lastGC=0
function PB.mail.ProcessInboxSafe()
    if not InboxFrame or not GetInboxNumItems then return end
    local total=GetInboxNumItems()
    if total==0 then return end
    local processed=0
    for index=1,math.min(50,total) do
        local _,_,_,_,itemCount,_,_,_,_,itemId=GetInboxHeaderInfo(index)
        if itemId then AutoLootMailItem(index) processed=processed+1 end
    end
    if processed>0 then C_Timer.After(0.15,PB.mail.ProcessInboxSafe) end
end
if InboxFrame and InboxFrame:HasScript("OnShow") then InboxFrame:HookScript("OnShow",function() PB.mail.ProcessInboxSafe() end) end

-- Mail profiler
SLASH_TSMMAILPROF1="/tsmmprof"
SlashCmdList["TSMMAILPROF"]=function(msg)
 local s=(msg or ""):lower()
 if s=="start" then PB.mail._profile.enabled=true PB.mail._profile.hits={} PB.mail._profile.start=GetTime() print("TSMPerfBoost Mail profiler started")
 elseif s=="stop" then PB.mail._profile.enabled=false print("TSMPerfBoost Mail profiler stopped")
 elseif s=="report" then print("TSMPerfBoost Mail profiler report (since "..tostring(PB.mail._profile.start)..")") for k,v in pairs(PB.mail._profile.hits) do print(k..": "..tostring(v)) end
 else print("Usage: /tsmmprof start|stop|report") end
end

-- Optional: global QueryAuctionItems hook (coalesce queries)
local _QueryAuctionItems=QueryAuctionItems
function QueryAuctionItems(...)
  if PB._QueryCoalesce then PB._QueryCoalesce(...) end
  return _QueryAuctionItems(...)
end

-- Lightweight profiler for TSM scans
local profiler={enabled=false,hits={},startTime=0}
SLASH_TSMperfprof1="/tsmprof"
SlashCmdList["TSMperfprof"]=function(msg)
 local cmd=(msg or ""):lower()
 if cmd=="start" then profiler.enabled=true profiler.hits={} profiler.startTime=GetTime() print("TSMPerfBoost profiler started")
 elseif cmd=="stop" then profiler.enabled=false print("TSMPerfBoost profiler stopped")
 elseif cmd=="report" then print("TSMPerfBoost profiler report (since "..tostring(profiler.startTime)..")") for k,v in pairs(profiler.hits) do print(k..": "..tostring(v)) end
 else print("Usage: /tsmprof start|stop|report") end
end
