if not WeakAuras.IsLibsOK() then return end
local AddonName = ...
local Private = select(2, ...)

-- Talent Data for Stormforge Wrath Plus Realm
if not WeakAuras.IsWrathReborn() then
  return
end

local WeakAuras = WeakAuras;
local L = WeakAuras.L;

local encounter_list = ""
function Private.InitializeEncounterAndZoneLists()
  if encounter_list ~= "" then
    return
  end
  local raids = {
    {
      L["Vault of Archavon"],
      {
        { L["Archavon the Stone Watcher"], 772 },
        { L["Emalon the Storm Watcher"], 774 },
        { L["Koralon the Flame Watcher"], 776 },
        { L["Toravon the Ice Watcher"], 885 },
      }
    },
    {
      L["Naxxramas"],
      {
        -- The Arachnid Quarter
        { L["Anub'Rekhan"], 1107 },
        { L["Grand Widow Faerlina"], 1110 },
        { L["Maexxna"], 1116 },
        -- The Plague Quarter
        { L["Noth the Plaguebringer"], 1117 },
        { L["Heigan the Unclean"], 1112 },
        { L["Loatheb"], 1115 },
        -- The Military Quarter
        { L["Instructor Razuvious"], 1113 },
        { L["Gothik the Harvester"], 1109 },
        { L["The Four Horsemen"], 1121 },
        -- The Construct Quarter
        { L["Patchwerk"], 1118 },
        { L["Grobbulus"], 1111 },
        { L["Gluth"], 1108 },
        { L["Thaddius"], 1120 },
        -- Frostwyrm Lair
        { L["Sapphiron"], 1119 },
        { L["Kel'Thuzad"], 1114 }
      }
    },
    {
      L["The Obsidian Sanctum"],
      {
        { L["Tenebron"], 736 },
        { L["Shadron"], 738 },
        { L["Vesperon"], 740 },
        { L["Sartharion"], 742 },
      }
    },
    {
      L["The Eye of Eternity"],
      {
        { L["Malygos"], 734 },
      }
    },
    {
      L["Ulduar"],
      {
        -- The Siege of Ulduar
        { L["Flame Leviathan"], 744 },
        { L["Ignis the Furnace Master"], 745 },
        { L["Razorscale"], 746 },
        { L["XT-002 Deconstructor"], 747 },
        -- The Antechamber of Ulduar
        { L["Assembly of Iron"], 748 },
        { L["Kologarn"], 749 },
        { L["Auriaya"], 750 },
        -- The Keepers of Ulduar
        { L["Freya"], 753 },
        { L["Hodir"], 751 },
        { L["Mimiron"], 754 },
        { L["Thorim"], 752 },
        -- The Descent into Madness
        { L["General Vezax"], 755 },
        { L["Yogg-Saron"], 756 },
        -- Celestial Planetarium
        { L["Algalon the Observer"], 757 },
      }
    },
    {
      L["Trial of the Crusader"],
      {
        { L["Northrend Beasts"], 629 },
        { L["Lord Jaraxxus"], 633 },
        { L["Faction Champions"], 637 },
        { L["Val'kyr Twins"], 641 },
        { L["Anub'arak"], 645 },
      }
    },
    {
      L["Onyxia's Lair"],
      {
        { L["Onyxia"], 1084 },
      }
    },
    {
      L["Icecrown Citadel"],
      {
        -- The Lower Spire
        { L["Lord Marrowgar"], 845 },
        { L["Lady Deathwhisper"], 846 },
        { L["Gunship Battle"], 847 },
        { L["Deathbringer Saurfang"], 848 },
        -- The Plagueworks
        { L["Festergut"], 849 },
        { L["Rotface"], 850 },
        { L["Professor Putricide"], 851 },
        -- The Crimson Hall
        { L["Blood Prince Council"], 852 },
        { L["Blood-Queen Lana'thel"], 853 },
        -- The Frostwing Halls
        { L["Valithria Dreamwalker"], 854 },
        { L["Sindragosa"], 855 },
        -- The Frozen Throne
        { L["The Lich King"], 856 },
      }
    },
    {
      L["The Ruby Sanctum"],
      {
        { L["Baltharus the Warborn"], 890 },
        { L["General Zarithrian"], 893 },
        { L["Saviana Ragefire"], 891 },
        { L["Halion"], 887 },
      }
    },
  }
  encounter_list = (WeakAuras.IsDBMRegistered() and "" or "|cFFFF0000") .. L["Requires Deadly Boss Mods (DBM) to detect encounters."] .. (WeakAuras.IsDBMRegistered() and "" or "|r") .. "\n\n"
  for _, raid in ipairs(raids) do
    encounter_list = ("%s|cffffd200%s|r\n"):format(encounter_list, raid[1])
    for _, boss in ipairs(raid[2]) do
        encounter_list = ("%s%s: %d\n"):format(encounter_list, boss[1], boss[2])
    end
    encounter_list = encounter_list .. "\n"
  end

  encounter_list = encounter_list:sub(1, -3) .. "\n\n" .. L["Based on "] .. "https://wago.tools/db2/DungeonEncounter?build=3.4.5.63009\n" .. L["Supports multiple entries, separated by commas. Prefix with '-' for negation."]
end

function Private.get_encounters_list()
  return encounter_list
end

Private.talentInfo = {
  ["HUNTER"] = {
    {
      "Interface\\Icons\\Spell_Nature_RavenForm", -- [1]
      1, -- [2]
      2, -- [3]
      19552, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Spell_Nature_Reincarnation", -- [1]
      1, -- [2]
      3, -- [3]
      19583, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Ability_Hunter_SilentHunter", -- [1]
      2, -- [2]
      1, -- [3]
      35029, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Ability_Hunter_AspectOfTheMonkey", -- [1]
      2, -- [2]
      2, -- [3]
      19549, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\INV_Misc_Pelt_Bear_03", -- [1]
      2, -- [2]
      3, -- [3]
      19609, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Ability_Hunter_BeastSoothe", -- [1]
      2, -- [2]
      4, -- [3]
      24443, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Ability_Mount_JungleTiger", -- [1]
      3, -- [2]
      1, -- [3]
      19559, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Ability_Hunter_AspectMastery", -- [1]
      3, -- [2]
      2, -- [3]
      53265, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Ability_BullRush", -- [1]
      3, -- [2]
      3, -- [3]
      19616, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Ability_Hunter_MendPet", -- [1]
      4, -- [2]
      2, -- [3]
      19572, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\INV_Misc_MonsterClaw_04", -- [1]
      4, -- [2]
      3, -- [3]
      19598, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Ability_Druid_DemoralizingRoar", -- [1]
      5, -- [2]
      1, -- [3]
      19578, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Ability_Devour", -- [1]
      5, -- [2]
      2, -- [3]
      19577, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Nature_AbolishMagic", -- [1]
      5, -- [2]
      4, -- [3]
      19590, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Ability_Hunter_AnimalHandler", -- [1]
      6, -- [2]
      1, -- [3]
      34453, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\INV_Misc_MonsterClaw_03", -- [1]
      6, -- [2]
      3, -- [3]
      19621, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Ability_Hunter_FerociousInspiration", -- [1]
      7, -- [2]
      1, -- [3]
      34455, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Ability_Druid_FerociousBite", -- [1]
      7, -- [2]
      2, -- [3]
      19574, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Ability_Hunter_CatlikeReflexes", -- [1]
      7, -- [2]
      3, -- [3]
      34462, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Ability_Hunter_Invigeration", -- [1]
      8, -- [2]
      1, -- [3]
      53252, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Ability_Hunter_SerpentSwiftness", -- [1]
      8, -- [2]
      3, -- [3]
      34466, -- [4]
    }, -- [21]
    {
      "Interface\\Icons\\Ability_Hunter_Longevity", -- [1]
      9, -- [2]
      1, -- [3]
      53262, -- [4]
    }, -- [22]
    {
      "Interface\\Icons\\Ability_Hunter_BeastWithin", -- [1]
      9, -- [2]
      2, -- [3]
      34692, -- [4]
    }, -- [23]
    {
      "Interface\\Icons\\Ability_Hunter_CobraStrikes", -- [1]
      9, -- [2]
      3, -- [3]
      53256, -- [4]
    }, -- [24]
    {
      "Interface\\Icons\\Ability_Hunter_SeparationAnxiety", -- [1]
      10, -- [2]
      2, -- [3]
      56314, -- [4]
    }, -- [25]
    {
      "Interface\\Icons\\Ability_Hunter_BeastMastery", -- [1]
      11, -- [2]
      2, -- [3]
      53270, -- [4]
    }, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Spell_Frost_Stun", -- [1]
      1, -- [2]
      1, -- [3]
      19407, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Ability_Hunter_FocusedAim", -- [1]
      1, -- [2]
      2, -- [3]
      53620, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Ability_SearingArrow", -- [1]
      1, -- [2]
      3, -- [3]
      19426, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Ability_Hunter_ZenArchery", -- [1]
      2, -- [2]
      1, -- [3]
      34482, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Ability_Hunter_SniperShot", -- [1]
      2, -- [2]
      2, -- [3]
      19421, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Ability_PierceDamage", -- [1]
      2, -- [2]
      3, -- [3]
      19485, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Ability_Hunter_GoForTheThroat", -- [1]
      3, -- [2]
      1, -- [3]
      34950, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Ability_ImpalingBolt", -- [1]
      3, -- [2]
      2, -- [3]
      19454, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\INV_Spear_07", -- [1]
      3, -- [2]
      3, -- [3]
      19434, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Ability_Hunter_RapidKilling", -- [1]
      3, -- [2]
      4, -- [3]
      34948, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Ability_Hunter_Quickshot", -- [1]
      4, -- [2]
      2, -- [3]
      19464, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Frost_WizardMark", -- [1]
      4, -- [2]
      3, -- [3]
      19416, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Spell_Arcane_StarFire", -- [1]
      5, -- [2]
      1, -- [3]
      35100, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Ability_Hunter_Readiness", -- [1]
      5, -- [2]
      2, -- [3]
      23989, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Ability_UpgradeMoonGlaive", -- [1]
      5, -- [2]
      3, -- [3]
      19461, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Ability_Hunter_CombatExperience", -- [1]
      6, -- [2]
      1, -- [3]
      34475, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\INV_Weapon_Rifle_06", -- [1]
      6, -- [2]
      4, -- [3]
      19507, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Ability_Hunter_PiercingShots", -- [1]
      7, -- [2]
      1, -- [3]
      53234, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Ability_TrueShot", -- [1]
      7, -- [2]
      2, -- [3]
      19506, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Ability_UpgradeMoonGlaive", -- [1]
      7, -- [2]
      3, -- [3]
      35104, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Ability_Hunter_MasterMarksman", -- [1]
      8, -- [2]
      2, -- [3]
      34485, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\Ability_Hunter_RapidRegeneration", -- [1]
      8, -- [2]
      3, -- [3]
      53228, -- [4]
    }, -- [62]
    {
      "Interface\\Icons\\Ability_Hunter_WildQuiver", -- [1]
      9, -- [2]
      1, -- [3]
      53215, -- [4]
    }, -- [63]
    {
      "Interface\\Icons\\Ability_TheBlackArrow", -- [1]
      9, -- [2]
      2, -- [3]
      34490, -- [4]
    }, -- [64]
    {
      "Interface\\Icons\\Ability_Hunter_ImprovedSteadyShot", -- [1]
      9, -- [2]
      3, -- [3]
      53221, -- [4]
    }, -- [65]
    {
      "Interface\\Icons\\Ability_Hunter_Assassinate", -- [1]
      10, -- [2]
      2, -- [3]
      53241, -- [4]
    }, -- [66]
    {
      "Interface\\Icons\\Ability_Hunter_ChimeraShot2", -- [1]
      11, -- [2]
      2, -- [3]
      53209, -- [4]
    }, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Ability_Hunter_ImprovedTracking", -- [1]
      1, -- [2]
      1, -- [3]
      52783, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Ability_TownWatch", -- [1]
      1, -- [2]
      2, -- [3]
      19498, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Ability_Racial_BloodRage", -- [1]
      1, -- [2]
      3, -- [3]
      19159, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Ability_Kick", -- [1]
      2, -- [2]
      1, -- [3]
      19290, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Nature_StrangleVines", -- [1]
      2, -- [2]
      2, -- [3]
      19184, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Ability_Ensnare", -- [1]
      2, -- [2]
      3, -- [3]
      19376, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Ability_Hunter_SurvivalInstincts", -- [1]
      2, -- [2]
      4, -- [3]
      34494, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Shadow_Twilight", -- [1]
      3, -- [2]
      1, -- [3]
      19255, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Ability_GolemStormBolt", -- [1]
      3, -- [2]
      2, -- [3]
      19503, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Ability_Parry", -- [1]
      3, -- [2]
      3, -- [3]
      19295, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Ability_Rogue_FeignDeath", -- [1]
      3, -- [2]
      4, -- [3]
      19286, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\INV_Misc_Bomb_05", -- [1]
      4, -- [2]
      2, -- [3]
      56333, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Ability_Hunter_LockAndLoad", -- [1]
      4, -- [2]
      4, -- [3]
      56342, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Ability_Hunter_HunterVsWild", -- [1]
      5, -- [2]
      1, -- [3]
      56339, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfStamina", -- [1]
      5, -- [2]
      2, -- [3]
      19370, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Ability_Warrior_Challange", -- [1]
      5, -- [2]
      3, -- [3]
      19306, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Spell_Nature_Invisibilty", -- [1]
      6, -- [2]
      1, -- [3]
      19168, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Ability_Hunter_Resourcefulness", -- [1]
      6, -- [2]
      3, -- [3]
      34491, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Ability_Rogue_FindWeakness", -- [1]
      7, -- [2]
      1, -- [3]
      34500, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\INV_Spear_02", -- [1]
      7, -- [2]
      2, -- [3]
      19386, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Ability_Hunter_ThrilloftheHunt", -- [1]
      7, -- [2]
      3, -- [3]
      34497, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Ability_Hunter_MasterTactitian", -- [1]
      8, -- [2]
      1, -- [3]
      34506, -- [4]
    }, -- [102]
    {
      "Interface\\Icons\\Ability_Hunter_PotentVenom", -- [1]
      8, -- [2]
      2, -- [3]
      53295, -- [4]
    }, -- [103]
    {
      "Interface\\Icons\\Ability_Hunter_PointofNoEscape", -- [1]
      9, -- [2]
      1, -- [3]
      53298, -- [4]
    }, -- [104]
    {
      "Interface\\Icons\\Spell_Shadow_PainSpike", -- [1]
      9, -- [2]
      2, -- [3]
      3674, -- [4]
    }, -- [105]
    {
      "Interface\\Icons\\Ability_Hunter_LongShots", -- [1]
      9, -- [2]
      4, -- [3]
      53302, -- [4]
    }, -- [106]
    {
      "Interface\\Icons\\Ability_Hunter_HuntingParty", -- [1]
      10, -- [2]
      3, -- [3]
      53290, -- [4]
    }, -- [107]
    {
      "Interface\\Icons\\Ability_Hunter_ExplosiveShot", -- [1]
      11, -- [2]
      2, -- [3]
      53301, -- [4]
    }, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "HunterBeastMastery", -- [1]
      "HunterMarksmanship", -- [2]
      "HunterSurvival", -- [3]
    }, -- [121]
  },
  ["WARRIOR"] = {
    {
      "Interface\\Icons\\Ability_Rogue_Ambush", -- [1]
      1, -- [2]
      1, -- [3]
      12282, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Ability_Parry", -- [1]
      1, -- [2]
      2, -- [3]
      16462, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Ability_Gouge", -- [1]
      1, -- [2]
      3, -- [3]
      12286, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Ability_Warrior_Charge", -- [1]
      2, -- [2]
      1, -- [3]
      12285, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Spell_Magic_MageArmor", -- [1]
      2, -- [2]
      2, -- [3]
      12300, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Spell_Nature_EnchantArmor", -- [1]
      2, -- [2]
      3, -- [3]
      12295, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\INV_Sword_05", -- [1]
      3, -- [2]
      1, -- [3]
      12290, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfStamina", -- [1]
      3, -- [2]
      2, -- [3]
      12296, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Ability_SearingArrow", -- [1]
      3, -- [2]
      3, -- [3]
      16493, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Ability_BackStab", -- [1]
      3, -- [2]
      4, -- [3]
      12834, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\INV_Axe_09", -- [1]
      4, -- [2]
      2, -- [3]
      12163, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Ability_Rogue_HungerforBlood", -- [1]
      4, -- [2]
      3, -- [3]
      56636, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\INV_Axe_06", -- [1]
      5, -- [2]
      1, -- [3]
      12700, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Ability_Rogue_SliceDice", -- [1]
      5, -- [2]
      2, -- [3]
      12328, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\INV_Mace_01", -- [1]
      5, -- [2]
      3, -- [3]
      12284, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\INV_Sword_27", -- [1]
      5, -- [2]
      4, -- [3]
      12281, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Ability_Warrior_WeaponMastery", -- [1]
      6, -- [2]
      1, -- [3]
      20504, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Ability_ShockWave", -- [1]
      6, -- [2]
      3, -- [3]
      12289, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Ability_Warrior_BloodNova", -- [1]
      6, -- [2]
      4, -- [3]
      46854, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Ability_Hunter_Harass", -- [1]
      7, -- [2]
      1, -- [3]
      29834, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Ability_Warrior_SavageBlow", -- [1]
      7, -- [2]
      2, -- [3]
      12294, -- [4]
    }, -- [21]
    {
      "Interface\\Icons\\Ability_Warrior_OffensiveStance", -- [1]
      7, -- [2]
      3, -- [3]
      46865, -- [4]
    }, -- [22]
    {
      "Interface\\Icons\\Ability_Warrior_DecisiveStrike", -- [1]
      7, -- [2]
      4, -- [3]
      12862, -- [4]
    }, -- [23]
    {
      "Interface\\Icons\\Ability_Warrior_BullRush", -- [1]
      8, -- [2]
      1, -- [3]
      64976, -- [4]
    }, -- [24]
    {
      "Interface\\Icons\\Ability_Warrior_SavageBlow", -- [1]
      8, -- [2]
      2, -- [3]
      35446, -- [4]
    }, -- [25]
    {
      "Interface\\Icons\\Ability_Warrior_UnrelentingAssault", -- [1]
      8, -- [2]
      3, -- [3]
      46859, -- [4]
    }, -- [26]
    {
      "Interface\\Icons\\Ability_Warrior_ImprovedDisciplines", -- [1]
      9, -- [2]
      1, -- [3]
      29723, -- [4]
    }, -- [27]
    {
      "Interface\\Icons\\Ability_Warrior_EndlessRage", -- [1]
      9, -- [2]
      2, -- [3]
      29623, -- [4]
    }, -- [28]
    {
      "Interface\\Icons\\Ability_Warrior_BloodFrenzy", -- [1]
      9, -- [2]
      3, -- [3]
      29836, -- [4]
    }, -- [29]
    {
      "Interface\\Icons\\Ability_Warrior_Trauma", -- [1]
      10, -- [2]
      2, -- [3]
      46867, -- [4]
    }, -- [30]
    {
      "Interface\\Icons\\Ability_Warrior_Bladestorm", -- [1]
      11, -- [2]
      2, -- [3]
      46924, -- [4]
    }, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\INV_Shoulder_22", -- [1]
      1, -- [2]
      1, -- [3]
      61216, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Spell_Nature_Purge", -- [1]
      1, -- [2]
      2, -- [3]
      12321, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Ability_Rogue_Eviscerate", -- [1]
      1, -- [2]
      3, -- [3]
      12320, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Ability_Warrior_WarCry", -- [1]
      2, -- [2]
      2, -- [3]
      12324, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Spell_Nature_StoneClawTotem", -- [1]
      2, -- [2]
      3, -- [3]
      12322, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Ability_Warrior_Cleave", -- [1]
      3, -- [2]
      1, -- [3]
      12329, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Shadow_DeathScream", -- [1]
      3, -- [2]
      2, -- [3]
      12323, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Spell_Shadow_SummonImp", -- [1]
      3, -- [2]
      3, -- [3]
      16487, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Spell_Nature_FocusedMind", -- [1]
      3, -- [2]
      4, -- [3]
      12318, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Ability_DualWield", -- [1]
      4, -- [2]
      1, -- [3]
      23584, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\INV_Sword_48", -- [1]
      4, -- [2]
      2, -- [3]
      20502, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Shadow_UnholyFrenzy", -- [1]
      4, -- [2]
      3, -- [3]
      12317, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Ability_Marksmanship", -- [1]
      5, -- [2]
      1, -- [3]
      29590, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Spell_Shadow_DeathPact", -- [1]
      5, -- [2]
      2, -- [3]
      12292, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Ability_Rogue_Sprint", -- [1]
      5, -- [2]
      3, -- [3]
      29888, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Spell_Nature_AncestralGuardian", -- [1]
      6, -- [2]
      1, -- [3]
      20500, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Ability_GhoulFrenzy", -- [1]
      6, -- [2]
      3, -- [3]
      12319, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Ability_Warrior_EndlessRage", -- [1]
      7, -- [2]
      1, -- [3]
      46908, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Spell_Nature_BloodLust", -- [1]
      7, -- [2]
      2, -- [3]
      23881, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Ability_Whirlwind", -- [1]
      7, -- [2]
      4, -- [3]
      29721, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Ability_Warrior_FuriousResolve", -- [1]
      8, -- [2]
      1, -- [3]
      46910, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\Ability_Racial_Avatar", -- [1]
      8, -- [2]
      4, -- [3]
      29759, -- [4]
    }, -- [62]
    {
      "Interface\\Icons\\Ability_HeroicLeap", -- [1]
      9, -- [2]
      1, -- [3]
      60970, -- [4]
    }, -- [63]
    {
      "Interface\\Icons\\Ability_Warrior_Rampage", -- [1]
      9, -- [2]
      2, -- [3]
      29801, -- [4]
    }, -- [64]
    {
      "Interface\\Icons\\Ability_Warrior_Bloodsurge", -- [1]
      9, -- [2]
      3, -- [3]
      46913, -- [4]
    }, -- [65]
    {
      "Interface\\Icons\\Ability_Warrior_IntensifyRage", -- [1]
      10, -- [2]
      2, -- [3]
      56927, -- [4]
    }, -- [66]
    {
      "Interface\\Icons\\Ability_Warrior_TitansGrip", -- [1]
      11, -- [2]
      2, -- [3]
      46917, -- [4]
    }, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Ability_Racial_BloodRage", -- [1]
      1, -- [2]
      1, -- [3]
      12301, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\INV_Shield_06", -- [1]
      1, -- [2]
      2, -- [3]
      12298, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Ability_ThunderClap", -- [1]
      1, -- [2]
      3, -- [3]
      12287, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Ability_Warrior_Incite", -- [1]
      2, -- [2]
      2, -- [3]
      50685, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Nature_MirrorImage", -- [1]
      2, -- [2]
      3, -- [3]
      12297, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_Holy_AshesToAshes", -- [1]
      3, -- [2]
      1, -- [3]
      12975, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Ability_Warrior_Revenge", -- [1]
      3, -- [2]
      2, -- [3]
      12797, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Ability_Warrior_ShieldMastery", -- [1]
      3, -- [2]
      3, -- [3]
      29598, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Spell_Holy_Devotion", -- [1]
      3, -- [2]
      4, -- [3]
      12299, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Ability_Warrior_ShieldReflection", -- [1]
      4, -- [2]
      1, -- [3]
      59088, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Ability_Warrior_Disarm", -- [1]
      4, -- [2]
      2, -- [3]
      12313, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Ability_Warrior_Sunder", -- [1]
      4, -- [2]
      3, -- [3]
      12308, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Ability_Warrior_ShieldWall", -- [1]
      5, -- [2]
      1, -- [3]
      12312, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Ability_ThunderBolt", -- [1]
      5, -- [2]
      2, -- [3]
      12809, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Ability_Warrior_ShieldBash", -- [1]
      5, -- [2]
      3, -- [3]
      12311, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\INV_Sword_20", -- [1]
      6, -- [2]
      3, -- [3]
      16538, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Ability_Warrior_DefensiveStance", -- [1]
      7, -- [2]
      1, -- [3]
      29593, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Ability_Warrior_Vigilance", -- [1]
      7, -- [2]
      2, -- [3]
      50720, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Ability_Warrior_BloodBath", -- [1]
      7, -- [2]
      3, -- [3]
      81006, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Ability_Warrior_IntensifyRage", -- [1]
      7, -- [2]
      4, -- [3]
      81011, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\INV_Helmet_21", -- [1]
      8, -- [2]
      2, -- [3]
      29140, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Ability_Warrior_Safeguard", -- [1]
      8, -- [2]
      3, -- [3]
      46945, -- [4]
    }, -- [102]
    {
      "Interface\\Icons\\Ability_Warrior_Warbringer", -- [1]
      9, -- [2]
      1, -- [3]
      57499, -- [4]
    }, -- [103]
    {
      "Interface\\Icons\\INV_Sword_11", -- [1]
      9, -- [2]
      2, -- [3]
      20243, -- [4]
    }, -- [104]
    {
      "INTERFACE\\Icons\\Warrior_talent_icon_BloodandThunder", -- [1]
      9, -- [2]
      3, -- [3]
      81009, -- [4]
    }, -- [105]
    {
      "Interface\\Icons\\Ability_Warrior_SwordandBoard", -- [1]
      10, -- [2]
      2, -- [3]
      46951, -- [4]
    }, -- [106]
    {
      "Interface\\Icons\\INV_Shield_31", -- [1]
      10, -- [2]
      3, -- [3]
      58872, -- [4]
    }, -- [107]
    {
      "Interface\\Icons\\Ability_Warrior_Shockwave", -- [1]
      11, -- [2]
      2, -- [3]
      46968, -- [4]
    }, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "WarriorArms", -- [1]
      "WarriorFury", -- [2]
      "WarriorProtection", -- [3]
    }, -- [121]
  },
  ["SHAMAN"] = {
    {
      "Interface\\Icons\\Spell_Nature_WispSplode", -- [1]
      1, -- [2]
      2, -- [3]
      16039, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Spell_Fire_Fireball", -- [1]
      1, -- [2]
      3, -- [3]
      16035, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Spell_Fire_Immolation", -- [1]
      2, -- [2]
      1, -- [3]
      16038, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Spell_Nature_SpiritArmor", -- [1]
      2, -- [2]
      2, -- [3]
      28996, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Spell_Fire_ElementalDevastation", -- [1]
      2, -- [2]
      3, -- [3]
      30160, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Spell_Frost_FrostWard", -- [1]
      3, -- [2]
      1, -- [3]
      16040, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_Shadow_ManaBurn", -- [1]
      3, -- [2]
      2, -- [3]
      16164, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_Fire_Volcano", -- [1]
      3, -- [2]
      3, -- [3]
      16089, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Spell_Fire_SealOfFire", -- [1]
      4, -- [2]
      1, -- [3]
      16086, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Spell_Shadow_SoulLeech_2", -- [1]
      4, -- [2]
      4, -- [3]
      29062, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Spell_Nature_StormReach", -- [1]
      5, -- [2]
      1, -- [3]
      28999, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Spell_Nature_CallStorm", -- [1]
      5, -- [2]
      2, -- [3]
      16041, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Nature_UnrelentingStorm", -- [1]
      5, -- [2]
      4, -- [3]
      30664, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Nature_ElementalPrecision_1", -- [1]
      6, -- [2]
      1, -- [3]
      30672, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Spell_Lightning_LightningBolt01", -- [1]
      6, -- [2]
      3, -- [3]
      16578, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Spell_Nature_WispHeal", -- [1]
      7, -- [2]
      2, -- [3]
      16166, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Spell_Shaman_StormEarthFire", -- [1]
      7, -- [2]
      3, -- [3]
      51483, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Fire_BlueFlameRing", -- [1]
      8, -- [2]
      1, -- [3]
      63370, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Spell_Shaman_ElementalOath", -- [1]
      8, -- [2]
      2, -- [3]
      51466, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Spell_Nature_LightningOverload", -- [1]
      8, -- [2]
      3, -- [3]
      30675, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Spell_Shaman_AstralShift", -- [1]
      9, -- [2]
      1, -- [3]
      51474, -- [4]
    }, -- [21]
    {
      "Interface\\Icons\\Spell_Fire_TotemOfWrath", -- [1]
      9, -- [2]
      2, -- [3]
      30706, -- [4]
    }, -- [22]
    {
      "Interface\\Icons\\Spell_Shaman_LavaFlow", -- [1]
      9, -- [2]
      3, -- [3]
      51480, -- [4]
    }, -- [23]
    {
      "Interface\\Icons\\Spell_unused2", -- [1]
      10, -- [2]
      2, -- [3]
      62097, -- [4]
    }, -- [24]
    {
      "Interface\\Icons\\Spell_Shaman_ThunderStorm", -- [1]
      11, -- [2]
      2, -- [3]
      51490, -- [4]
    }, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Spell_Nature_EarthBindTotem", -- [1]
      1, -- [2]
      1, -- [3]
      16259, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Spell_Nature_StoneClawTotem", -- [1]
      1, -- [2]
      2, -- [3]
      16043, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Spell_Shadow_GrimWard", -- [1]
      1, -- [2]
      3, -- [3]
      17485, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Spell_Nature_StoneSkinTotem", -- [1]
      2, -- [2]
      1, -- [3]
      16258, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Ability_ThunderBolt", -- [1]
      2, -- [2]
      2, -- [3]
      16255, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Spell_Nature_SpiritWolf", -- [1]
      2, -- [2]
      3, -- [3]
      16262, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Nature_LightningShield", -- [1]
      2, -- [2]
      4, -- [3]
      16261, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Spell_Fire_FlameTounge", -- [1]
      3, -- [2]
      1, -- [3]
      16266, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Spell_Nature_ElementalAbsorption", -- [1]
      3, -- [2]
      3, -- [3]
      43338, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Spell_Nature_MirrorImage", -- [1]
      3, -- [2]
      4, -- [3]
      16254, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Ability_GhoulFrenzy", -- [1]
      4, -- [2]
      2, -- [3]
      16256, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Holy_Devotion", -- [1]
      4, -- [2]
      3, -- [3]
      16252, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Spell_Nature_Windfury", -- [1]
      5, -- [2]
      1, -- [3]
      29192, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Ability_Parry", -- [1]
      5, -- [2]
      2, -- [3]
      16268, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Spell_Nature_BloodLust", -- [1]
      5, -- [2]
      3, -- [3]
      51883, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Spell_Nature_UnleashedRage", -- [1]
      6, -- [2]
      1, -- [3]
      30802, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Ability_Hunter_SwiftStrike", -- [1]
      6, -- [2]
      3, -- [3]
      29082, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Spell_Fire_BlueCano", -- [1]
      6, -- [2]
      4, -- [3]
      63373, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Ability_DualWieldSpecialization", -- [1]
      7, -- [2]
      1, -- [3]
      30816, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Ability_DualWield", -- [1]
      7, -- [2]
      2, -- [3]
      30798, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Ability_Shaman_Stormstrike", -- [1]
      7, -- [2]
      3, -- [3]
      17364, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\Spell_Shaman_StaticShock", -- [1]
      8, -- [2]
      1, -- [3]
      51525, -- [4]
    }, -- [62]
    {
      "Interface\\Icons\\Ability_Shaman_Lavalash", -- [1]
      8, -- [2]
      2, -- [3]
      60103, -- [4]
    }, -- [63]
    {
      "Interface\\Icons\\Spell_Shaman_ImprovedStormstrike", -- [1]
      8, -- [2]
      3, -- [3]
      51521, -- [4]
    }, -- [64]
    {
      "Interface\\Icons\\Spell_Nature_MentalQuickness", -- [1]
      9, -- [2]
      1, -- [3]
      30812, -- [4]
    }, -- [65]
    {
      "Interface\\Icons\\Spell_Nature_ShamanRage", -- [1]
      9, -- [2]
      2, -- [3]
      30823, -- [4]
    }, -- [66]
    {
      "Interface\\Icons\\Spell_Nature_EarthElemental_Totem", -- [1]
      9, -- [2]
      3, -- [3]
      51523, -- [4]
    }, -- [67]
    {
      "Interface\\Icons\\Spell_Shaman_MaelstromWeapon", -- [1]
      10, -- [2]
      2, -- [3]
      51528, -- [4]
    }, -- [68]
    {
      "Interface\\Icons\\Spell_Shaman_FeralSpirit", -- [1]
      11, -- [2]
      2, -- [3]
      51533, -- [4]
    }, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Spell_Nature_MagicImmunity", -- [1]
      1, -- [2]
      2, -- [3]
      16182, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Nature_MoonGlow", -- [1]
      1, -- [2]
      3, -- [3]
      16173, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Nature_Reincarnation", -- [1]
      2, -- [2]
      1, -- [3]
      16184, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Spell_Nature_HealingTouch", -- [1]
      2, -- [2]
      2, -- [3]
      29187, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Frost_ManaRecharge", -- [1]
      2, -- [2]
      3, -- [3]
      16179, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Ability_Shaman_WaterShield", -- [1]
      3, -- [2]
      1, -- [3]
      16180, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_Nature_HealingWaveLesser", -- [1]
      3, -- [2]
      2, -- [3]
      16181, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Frost_Frostbolt", -- [1]
      3, -- [2]
      3, -- [3]
      55198, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Spell_Nature_UndyingStrength", -- [1]
      3, -- [2]
      4, -- [3]
      16176, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Spell_Nature_ManaRegenTotem", -- [1]
      4, -- [2]
      2, -- [3]
      16187, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_Nature_Tranquility", -- [1]
      4, -- [2]
      3, -- [3]
      16194, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Spell_Nature_HealingWay", -- [1]
      5, -- [2]
      1, -- [3]
      29206, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Spell_Nature_RavenForm", -- [1]
      5, -- [2]
      3, -- [3]
      16188, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Nature_FocusedMind", -- [1]
      5, -- [2]
      4, -- [3]
      30864, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Frost_WizardMark", -- [1]
      6, -- [2]
      3, -- [3]
      16178, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Spell_Nature_NatureGuardian", -- [1]
      7, -- [2]
      1, -- [3]
      30881, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Spell_Frost_SummonWaterElemental", -- [1]
      7, -- [2]
      2, -- [3]
      16190, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Ability_Shaman_CleanseSpirit", -- [1]
      7, -- [2]
      3, -- [3]
      51886, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Spell_Shaman_BlessingOfEternals", -- [1]
      8, -- [2]
      1, -- [3]
      51554, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Spell_Nature_HealingWaveGreater", -- [1]
      8, -- [2]
      2, -- [3]
      30872, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Spell_Nature_NatureBlessing", -- [1]
      8, -- [2]
      3, -- [3]
      30867, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Spell_Shaman_AncestralAwakening", -- [1]
      9, -- [2]
      1, -- [3]
      51556, -- [4]
    }, -- [102]
    {
      "Interface\\Icons\\Spell_Nature_SkinofEarth", -- [1]
      9, -- [2]
      2, -- [3]
      974, -- [4]
    }, -- [103]
    {
      "Interface\\Icons\\Spell_Nature_SkinofEarth", -- [1]
      9, -- [2]
      3, -- [3]
      51560, -- [4]
    }, -- [104]
    {
      "Interface\\Icons\\Spell_Shaman_TidalWaves", -- [1]
      10, -- [2]
      2, -- [3]
      51562, -- [4]
    }, -- [105]
    {
      "Interface\\Icons\\spell_nature_riptide", -- [1]
      11, -- [2]
      2, -- [3]
      61295, -- [4]
    }, -- [106]
    nil, -- [107]
    nil, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "ShamanElementalCombat", -- [1]
      "ShamanEnhancement", -- [2]
      "ShamanRestoration", -- [3]
    }, -- [121]
  },
  ["MAGE"] = {
    {
      "Interface\\Icons\\Spell_Holy_DispelMagic", -- [1]
      1, -- [2]
      1, -- [3]
      11210, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Spell_Holy_Devotion", -- [1]
      1, -- [2]
      2, -- [3]
      11222, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Spell_Nature_StarFall", -- [1]
      1, -- [2]
      3, -- [3]
      11237, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Spell_Arcane_ArcaneResilience", -- [1]
      2, -- [2]
      1, -- [3]
      28574, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Spell_Nature_AstralRecalGroup", -- [1]
      2, -- [2]
      2, -- [3]
      29441, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Spell_Shadow_ManaBurn", -- [1]
      2, -- [2]
      3, -- [3]
      11213, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_Nature_AbolishMagic", -- [1]
      3, -- [2]
      1, -- [3]
      11247, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_Nature_WispSplode", -- [1]
      3, -- [2]
      2, -- [3]
      11242, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Ability_Mage_StudentOfTheMind", -- [1]
      3, -- [2]
      3, -- [3]
      44397, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Spell_Arcane_StudentOfMagic", -- [1]
      3, -- [2]
      4, -- [3]
      54646, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Spell_Shadow_DetectLesserInvisibility", -- [1]
      4, -- [2]
      1, -- [3]
      11252, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Spell_Frost_IceShock", -- [1]
      4, -- [2]
      2, -- [3]
      11255, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Shadow_SiphonMana", -- [1]
      4, -- [2]
      3, -- [3]
      18462, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Ability_Mage_TormentOfTheWeak", -- [1]
      4, -- [2]
      4, -- [3]
      29447, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Spell_Arcane_Blink", -- [1]
      5, -- [2]
      1, -- [3]
      31569, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Spell_Nature_EnchantArmor", -- [1]
      5, -- [2]
      2, -- [3]
      12043, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Spell_Shadow_Charm", -- [1]
      5, -- [2]
      4, -- [3]
      11232, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Arcane_PrismaticCloak", -- [1]
      6, -- [2]
      1, -- [3]
      31574, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Spell_Shadow_Teleport", -- [1]
      6, -- [2]
      2, -- [3]
      15058, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Spell_Arcane_ArcanePotency", -- [1]
      6, -- [2]
      3, -- [3]
      31571, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Spell_Nature_StarFall", -- [1]
      7, -- [2]
      1, -- [3]
      31579, -- [4]
    }, -- [21]
    {
      "Interface\\Icons\\Spell_Nature_Lightning", -- [1]
      7, -- [2]
      2, -- [3]
      12042, -- [4]
    }, -- [22]
    {
      "Interface\\Icons\\Ability_Mage_IncantersAbsorbtion", -- [1]
      7, -- [2]
      3, -- [3]
      44394, -- [4]
    }, -- [23]
    {
      "Interface\\Icons\\Ability_Mage_PotentSpirit", -- [1]
      8, -- [2]
      2, -- [3]
      44378, -- [4]
    }, -- [24]
    {
      "Interface\\Icons\\Spell_Arcane_MindMastery", -- [1]
      8, -- [2]
      3, -- [3]
      31584, -- [4]
    }, -- [25]
    {
      "Interface\\Icons\\Spell_Nature_Slow", -- [1]
      9, -- [2]
      2, -- [3]
      31589, -- [4]
    }, -- [26]
    {
      "Interface\\Icons\\Ability_Mage_MissileBarrage", -- [1]
      9, -- [2]
      3, -- [3]
      44404, -- [4]
    }, -- [27]
    {
      "Interface\\Icons\\Ability_Mage_NetherWindPresence", -- [1]
      10, -- [2]
      2, -- [3]
      44400, -- [4]
    }, -- [28]
    {
      "Interface\\Icons\\Spell_Arcane_ArcaneTorrent", -- [1]
      10, -- [2]
      3, -- [3]
      35578, -- [4]
    }, -- [29]
    {
      "Interface\\Icons\\Ability_Mage_ArcaneBarrage", -- [1]
      11, -- [2]
      2, -- [3]
      44425, -- [4]
    }, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Spell_Fire_Fireball", -- [1]
      1, -- [2]
      1, -- [3]
      11078, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Spell_Fire_FlameShock", -- [1]
      1, -- [2]
      2, -- [3]
      18459, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Spell_Fire_FlameBolt", -- [1]
      1, -- [2]
      3, -- [3]
      11069, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Spell_Fire_Incinerate", -- [1]
      2, -- [2]
      1, -- [3]
      11119, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Spell_Fire_TotemOfWrath", -- [1]
      2, -- [2]
      2, -- [3]
      54747, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Ability_Mage_WorldInFlames", -- [1]
      2, -- [2]
      3, -- [3]
      11108, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Fire_Flare", -- [1]
      3, -- [2]
      1, -- [3]
      11100, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Spell_Fire_MeteorStorm", -- [1]
      3, -- [2]
      2, -- [3]
      11103, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Spell_Fire_Fireball02", -- [1]
      3, -- [2]
      3, -- [3]
      11366, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Spell_Fire_Fire", -- [1]
      3, -- [2]
      4, -- [3]
      11083, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Spell_Fire_SoulBurn", -- [1]
      4, -- [2]
      1, -- [3]
      11095, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Fire_FireArmor", -- [1]
      4, -- [2]
      2, -- [3]
      11094, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Spell_Fire_MasterOfElements", -- [1]
      4, -- [2]
      4, -- [3]
      29074, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Spell_Fire_PlayingWithFire", -- [1]
      5, -- [2]
      1, -- [3]
      31638, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Spell_Nature_WispHeal", -- [1]
      5, -- [2]
      2, -- [3]
      11115, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Spell_Holy_Excorcism_02", -- [1]
      5, -- [2]
      3, -- [3]
      11113, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Spell_Fire_BurningSpeed", -- [1]
      6, -- [2]
      1, -- [3]
      31641, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Spell_Fire_Immolation", -- [1]
      6, -- [2]
      3, -- [3]
      11124, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Spell_Fire_Burnout", -- [1]
      7, -- [2]
      1, -- [3]
      34293, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Spell_Fire_SealOfFire", -- [1]
      7, -- [2]
      2, -- [3]
      11129, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Spell_Fire_MoltenBlood", -- [1]
      7, -- [2]
      3, -- [3]
      31679, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\Ability_Mage_FieryPayback", -- [1]
      8, -- [2]
      1, -- [3]
      64353, -- [4]
    }, -- [62]
    {
      "Interface\\Icons\\Spell_Fire_FlameBolt", -- [1]
      8, -- [2]
      3, -- [3]
      31656, -- [4]
    }, -- [63]
    {
      "Interface\\Icons\\Ability_Mage_FireStarter", -- [1]
      9, -- [2]
      1, -- [3]
      44442, -- [4]
    }, -- [64]
    {
      "Interface\\Icons\\INV_Misc_Head_Dragon_01", -- [1]
      9, -- [2]
      2, -- [3]
      31661, -- [4]
    }, -- [65]
    {
      "Interface\\Icons\\Ability_Mage_HotStreak", -- [1]
      9, -- [2]
      3, -- [3]
      44445, -- [4]
    }, -- [66]
    {
      "Interface\\Icons\\Ability_Mage_Burnout", -- [1]
      10, -- [2]
      2, -- [3]
      44449, -- [4]
    }, -- [67]
    {
      "Interface\\Icons\\Ability_Mage_LivingBomb", -- [1]
      11, -- [2]
      2, -- [3]
      44457, -- [4]
    }, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Spell_Frost_FrostArmor", -- [1]
      1, -- [2]
      1, -- [3]
      11071, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Frost_FrostBolt02", -- [1]
      1, -- [2]
      2, -- [3]
      11070, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Frost_IceFloes", -- [1]
      1, -- [2]
      3, -- [3]
      31670, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Spell_Frost_IceShard", -- [1]
      2, -- [2]
      1, -- [3]
      11207, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Frost_FrostWard", -- [1]
      2, -- [2]
      2, -- [3]
      11189, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_Ice_MagicDamage", -- [1]
      2, -- [2]
      3, -- [3]
      29438, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_Frost_Wisp", -- [1]
      2, -- [2]
      4, -- [3]
      11175, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Frost_Frostbolt", -- [1]
      3, -- [2]
      1, -- [3]
      11151, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Spell_Frost_ColdHearted", -- [1]
      3, -- [2]
      2, -- [3]
      12472, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Spell_Frost_IceStorm", -- [1]
      3, -- [2]
      3, -- [3]
      11185, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_Shadow_DarkRitual", -- [1]
      4, -- [2]
      1, -- [3]
      16757, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Spell_Frost_Stun", -- [1]
      4, -- [2]
      2, -- [3]
      11160, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Spell_Frost_FrostShock", -- [1]
      4, -- [2]
      3, -- [3]
      11170, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Frost_WizardMark", -- [1]
      5, -- [2]
      2, -- [3]
      11958, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Frost_Glacier", -- [1]
      5, -- [2]
      3, -- [3]
      11190, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Spell_Frost_FrozenCore", -- [1]
      5, -- [2]
      4, -- [3]
      31667, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Ability_Mage_ColdAsIce", -- [1]
      6, -- [2]
      1, -- [3]
      55091, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Spell_Frost_ChillingBlast", -- [1]
      6, -- [2]
      3, -- [3]
      11180, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Ability_Mage_ShatterShield", -- [1]
      7, -- [2]
      1, -- [3]
      44745, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Spell_Ice_Lament", -- [1]
      7, -- [2]
      2, -- [3]
      11426, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Spell_Frost_ArcticWinds", -- [1]
      7, -- [2]
      3, -- [3]
      31674, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Spell_Frost_FrostBolt02", -- [1]
      8, -- [2]
      2, -- [3]
      31682, -- [4]
    }, -- [102]
    {
      "Interface\\Icons\\Ability_Mage_WintersGrasp", -- [1]
      8, -- [2]
      3, -- [3]
      44543, -- [4]
    }, -- [103]
    {
      "Interface\\Icons\\Ability_Mage_BrainFreeze", -- [1]
      9, -- [2]
      1, -- [3]
      44546, -- [4]
    }, -- [104]
    {
      "Interface\\Icons\\Spell_Frost_SummonWaterElemental_2", -- [1]
      9, -- [2]
      2, -- [3]
      31687, -- [4]
    }, -- [105]
    {
      "Interface\\Icons\\Spell_Frost_SummonWaterElemental_2", -- [1]
      9, -- [2]
      3, -- [3]
      44557, -- [4]
    }, -- [106]
    {
      "Interface\\Icons\\Ability_Mage_ChilledToTheBone", -- [1]
      10, -- [2]
      2, -- [3]
      44566, -- [4]
    }, -- [107]
    {
      "Interface\\Icons\\Ability_Mage_DeepFreeze", -- [1]
      11, -- [2]
      2, -- [3]
      44572, -- [4]
    }, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "MageArcane", -- [1]
      "MageFire", -- [2]
      "MageFrost", -- [3]
    }, -- [121]
  },
  ["PRIEST"] = {
    {
      "Interface\\Icons\\Spell_Magic_MageArmor", -- [1]
      1, -- [2]
      2, -- [3]
      14522, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Spell_Holy_SealOfVengeance", -- [1]
      1, -- [2]
      3, -- [3]
      47586, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Spell_Nature_ManaRegenTotem", -- [1]
      2, -- [2]
      1, -- [3]
      14523, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Spell_Holy_InnerFire", -- [1]
      2, -- [2]
      2, -- [3]
      14747, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Spell_Holy_WordFortitude", -- [1]
      2, -- [2]
      3, -- [3]
      14749, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Spell_Nature_Tranquility", -- [1]
      2, -- [2]
      4, -- [3]
      14531, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_Nature_Sleep", -- [1]
      3, -- [2]
      1, -- [3]
      14521, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_Frost_WindWalkOn", -- [1]
      3, -- [2]
      2, -- [3]
      14751, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Spell_Holy_PowerWordShield", -- [1]
      3, -- [2]
      3, -- [3]
      14748, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Spell_Holy_Absolution", -- [1]
      4, -- [2]
      1, -- [3]
      33167, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Ability_Hibernation", -- [1]
      4, -- [2]
      2, -- [3]
      14520, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Spell_Shadow_ManaBurn", -- [1]
      4, -- [2]
      4, -- [3]
      14750, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Holy_PowerWordShield", -- [1]
      5, -- [2]
      1, -- [3]
      33201, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Nature_EnchantArmor", -- [1]
      5, -- [2]
      2, -- [3]
      18551, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Spell_Holy_PureOfHeart", -- [1]
      5, -- [2]
      3, -- [3]
      63574, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Spell_Shadow_FocusedPower", -- [1]
      6, -- [2]
      1, -- [3]
      33186, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Spell_Arcane_MindMastery", -- [1]
      6, -- [2]
      3, -- [3]
      34908, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Arcane_FocusedPower", -- [1]
      7, -- [2]
      1, -- [3]
      45234, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Spell_Holy_PowerInfusion", -- [1]
      7, -- [2]
      2, -- [3]
      10060, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Spell_Holy_Chastise", -- [1]
      7, -- [2]
      3, -- [3]
      63504, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Spell_Holy_HolyProtection", -- [1]
      8, -- [2]
      1, -- [3]
      57470, -- [4]
    }, -- [21]
    {
      "Interface\\Icons\\Spell_Holy_Rapture", -- [1]
      8, -- [2]
      2, -- [3]
      47535, -- [4]
    }, -- [22]
    {
      "Interface\\Icons\\Spell_Holy_Aspiration", -- [1]
      8, -- [2]
      3, -- [3]
      47507, -- [4]
    }, -- [23]
    {
      "Interface\\Icons\\Spell_Holy_DevineAegis", -- [1]
      9, -- [2]
      1, -- [3]
      47509, -- [4]
    }, -- [24]
    {
      "Interface\\Icons\\Spell_Holy_PainSupression", -- [1]
      9, -- [2]
      2, -- [3]
      33206, -- [4]
    }, -- [25]
    {
      "Interface\\Icons\\Spell_Holy_HopeAndGrace", -- [1]
      9, -- [2]
      3, -- [3]
      47516, -- [4]
    }, -- [26]
    {
      "Interface\\Icons\\Spell_Holy_BorrowedTime", -- [1]
      10, -- [2]
      2, -- [3]
      52795, -- [4]
    }, -- [27]
    {
      "Interface\\Icons\\Spell_Holy_Penance", -- [1]
      11, -- [2]
      2, -- [3]
      47540, -- [4]
    }, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Spell_Holy_HealingFocus", -- [1]
      1, -- [2]
      1, -- [3]
      14913, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Spell_Holy_Renew", -- [1]
      1, -- [2]
      2, -- [3]
      14908, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Spell_Holy_SealOfSalvation", -- [1]
      1, -- [2]
      3, -- [3]
      14889, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Spell_Holy_SpellWarding", -- [1]
      2, -- [2]
      2, -- [3]
      27900, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Spell_Holy_SealOfWrath", -- [1]
      2, -- [2]
      3, -- [3]
      18530, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Spell_Holy_Restoration", -- [1]
      3, -- [2]
      1, -- [3]
      19236, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Holy_BlessedRecovery", -- [1]
      3, -- [2]
      2, -- [3]
      27811, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Spell_Holy_LayOnHands", -- [1]
      3, -- [2]
      4, -- [3]
      14892, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Spell_Holy_Purify", -- [1]
      4, -- [2]
      1, -- [3]
      27789, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Spell_Holy_Heal02", -- [1]
      4, -- [2]
      2, -- [3]
      14912, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Spell_Holy_SearingLightPriest", -- [1]
      4, -- [2]
      3, -- [3]
      14909, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Holy_PrayerOfHealing02", -- [1]
      5, -- [2]
      1, -- [3]
      14911, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\INV_Enchant_EssenceEternalLarge", -- [1]
      5, -- [2]
      2, -- [3]
      20711, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Spell_Holy_SpiritualGuidence", -- [1]
      5, -- [2]
      3, -- [3]
      14901, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Spell_Holy_SurgeOfLight", -- [1]
      6, -- [2]
      1, -- [3]
      33150, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Spell_Nature_MoonGlow", -- [1]
      6, -- [2]
      3, -- [3]
      14898, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Spell_Holy_Fanaticism", -- [1]
      7, -- [2]
      1, -- [3]
      34753, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Spell_Holy_SummonLightwell", -- [1]
      7, -- [2]
      2, -- [3]
      724, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Spell_Holy_BlessedResillience", -- [1]
      7, -- [2]
      3, -- [3]
      33142, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Spell_Holy_SymbolOfHope", -- [1]
      8, -- [2]
      1, -- [3]
      64127, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Spell_Holy_GreaterHeal", -- [1]
      8, -- [2]
      2, -- [3]
      33158, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\Spell_Holy_Serendipity", -- [1]
      8, -- [2]
      3, -- [3]
      63730, -- [4]
    }, -- [62]
    {
      "Interface\\Icons\\Ability_Paladin_InfusionofLight", -- [1]
      9, -- [2]
      1, -- [3]
      63534, -- [4]
    }, -- [63]
    {
      "Interface\\Icons\\Spell_Holy_CircleOfRenewal", -- [1]
      9, -- [2]
      2, -- [3]
      34861, -- [4]
    }, -- [64]
    {
      "Interface\\Icons\\Spell_Holy_TestOfFaith", -- [1]
      9, -- [2]
      3, -- [3]
      47558, -- [4]
    }, -- [65]
    {
      "Interface\\Icons\\Spell_Holy_DivineProvidence", -- [1]
      10, -- [2]
      2, -- [3]
      47562, -- [4]
    }, -- [66]
    {
      "Interface\\Icons\\Spell_Holy_GuardianSpirit", -- [1]
      11, -- [2]
      2, -- [3]
      47788, -- [4]
    }, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Spell_Shadow_Requiem", -- [1]
      1, -- [2]
      1, -- [3]
      15270, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Shadow_Requiem", -- [1]
      1, -- [2]
      2, -- [3]
      15337, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Shadow_Twilight", -- [1]
      1, -- [2]
      3, -- [3]
      15259, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowWard", -- [1]
      2, -- [2]
      1, -- [3]
      15318, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowWordPain", -- [1]
      2, -- [2]
      2, -- [3]
      15275, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_Shadow_BurningSpirit", -- [1]
      2, -- [2]
      3, -- [3]
      15260, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_Shadow_PsychicScream", -- [1]
      3, -- [2]
      1, -- [3]
      15392, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Shadow_UnholyFrenzy", -- [1]
      3, -- [2]
      2, -- [3]
      15273, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Spell_Shadow_SiphonMana", -- [1]
      3, -- [2]
      3, -- [3]
      15407, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Spell_Magic_LesserInvisibilty", -- [1]
      4, -- [2]
      2, -- [3]
      15274, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_Shadow_ChillTouch", -- [1]
      4, -- [2]
      3, -- [3]
      17322, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Spell_Shadow_BlackPlague", -- [1]
      4, -- [2]
      4, -- [3]
      15257, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Spell_Shadow_ImpPhaseShift", -- [1]
      5, -- [2]
      1, -- [3]
      15487, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Shadow_UnsummonBuilding", -- [1]
      5, -- [2]
      2, -- [3]
      15286, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Shadow_ImprovedVampiricEmbrace", -- [1]
      5, -- [2]
      3, -- [3]
      27839, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Spell_Nature_FocusedMind", -- [1]
      5, -- [2]
      4, -- [3]
      33213, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Spell_Shadow_Skull", -- [1]
      6, -- [2]
      1, -- [3]
      14910, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Spell_Shadow_DevouringPlague.", -- [1]
      6, -- [2]
      3, -- [3]
      63625, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Spell_Shadow_Shadowform", -- [1]
      7, -- [2]
      2, -- [3]
      15473, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowPower", -- [1]
      7, -- [2]
      3, -- [3]
      33221, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Spell_Shadow_SummonVoidWalker", -- [1]
      8, -- [2]
      1, -- [3]
      47569, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Spell_Shadow_Misery", -- [1]
      8, -- [2]
      3, -- [3]
      33191, -- [4]
    }, -- [102]
    {
      "Interface\\Icons\\Spell_Shadow_PsychicHorrors", -- [1]
      9, -- [2]
      1, -- [3]
      64044, -- [4]
    }, -- [103]
    {
      "Interface\\Icons\\Spell_Holy_Stoicism", -- [1]
      9, -- [2]
      2, -- [3]
      34914, -- [4]
    }, -- [104]
    {
      "Interface\\Icons\\Spell_Shadow_PainAndSuffering", -- [1]
      9, -- [2]
      3, -- [3]
      47580, -- [4]
    }, -- [105]
    {
      "Interface\\Icons\\Spell_Shadow_MindTwisting", -- [1]
      10, -- [2]
      3, -- [3]
      47573, -- [4]
    }, -- [106]
    {
      "Interface\\Icons\\Spell_Shadow_Dispersion", -- [1]
      11, -- [2]
      2, -- [3]
      47585, -- [4]
    }, -- [107]
    nil, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "PriestDiscipline", -- [1]
      "PriestHoly", -- [2]
      "PriestShadow", -- [3]
    }, -- [121]
  },
  ["WARLOCK"] = {
    {
      "Interface\\Icons\\Spell_Shadow_CurseOfSargeras", -- [1]
      1, -- [2]
      1, -- [3]
      18827, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Spell_Shadow_UnsummonBuilding", -- [1]
      1, -- [2]
      2, -- [3]
      18174, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Spell_Shadow_AbominationExplosion", -- [1]
      1, -- [2]
      3, -- [3]
      17810, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Spell_Shadow_CurseOfMannoroth", -- [1]
      2, -- [2]
      1, -- [3]
      18179, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Spell_Shadow_Haunting", -- [1]
      2, -- [2]
      2, -- [3]
      18213, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Spell_Shadow_BurningSpirit", -- [1]
      2, -- [2]
      3, -- [3]
      18182, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_Shadow_LifeDrain02", -- [1]
      2, -- [2]
      4, -- [3]
      17804, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_Shadow_Possession", -- [1]
      3, -- [2]
      1, -- [3]
      53754, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Spell_Shadow_FingerOfDeath", -- [1]
      3, -- [2]
      2, -- [3]
      17783, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Spell_Shadow_Contagion", -- [1]
      3, -- [2]
      3, -- [3]
      18288, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Spell_Shadow_CallofBone", -- [1]
      4, -- [2]
      1, -- [3]
      18218, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Spell_Shadow_Twilight", -- [1]
      4, -- [2]
      2, -- [3]
      18094, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Shadow_AbominationExplosion", -- [1]
      4, -- [2]
      4, -- [3]
      32381, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowEmbrace", -- [1]
      5, -- [2]
      1, -- [3]
      32385, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Spell_Shadow_Requiem", -- [1]
      5, -- [2]
      2, -- [3]
      63108, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Spell_Shadow_GrimWard", -- [1]
      5, -- [2]
      3, -- [3]
      18223, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Spell_Shadow_SummonFelHunter", -- [1]
      6, -- [2]
      1, -- [3]
      54037, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Shadow_ShadeTrueSight", -- [1]
      6, -- [2]
      2, -- [3]
      18271, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Ability_Warlock_Eradication", -- [1]
      7, -- [2]
      1, -- [3]
      47195, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Spell_Shadow_PainfulAfflictions", -- [1]
      7, -- [2]
      2, -- [3]
      30060, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Spell_Shadow_DarkRitual", -- [1]
      7, -- [2]
      3, -- [3]
      18220, -- [4]
    }, -- [21]
    {
      "Interface\\Icons\\Spell_Shadow_DeathScream", -- [1]
      8, -- [2]
      1, -- [3]
      30054, -- [4]
    }, -- [22]
    {
      "Interface\\Icons\\Spell_Shadow_CurseOfAchimonde", -- [1]
      8, -- [2]
      3, -- [3]
      32477, -- [4]
    }, -- [23]
    {
      "Interface\\Icons\\Spell_Shadow_DeathsEmbrace", -- [1]
      9, -- [2]
      1, -- [3]
      47198, -- [4]
    }, -- [24]
    {
      "Interface\\Icons\\Spell_Shadow_UnstableAffliction_3", -- [1]
      9, -- [2]
      2, -- [3]
      30108, -- [4]
    }, -- [25]
    {
      "Interface\\Icons\\Spell_Shadow_UnstableAffliction_2", -- [1]
      9, -- [2]
      3, -- [3]
      58435, -- [4]
    }, -- [26]
    {
      "Interface\\Icons\\Ability_Warlock_EverlastingAffliction", -- [1]
      10, -- [2]
      2, -- [3]
      47201, -- [4]
    }, -- [27]
    {
      "Interface\\Icons\\Ability_Warlock_Haunt", -- [1]
      11, -- [2]
      2, -- [3]
      48181, -- [4]
    }, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\INV_Stone_04", -- [1]
      1, -- [2]
      1, -- [3]
      18692, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Spell_Shadow_SummonImp", -- [1]
      1, -- [2]
      2, -- [3]
      18694, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Spell_Shadow_Metamorphosis", -- [1]
      1, -- [2]
      3, -- [3]
      18697, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Spell_Shadow_FelMending", -- [1]
      1, -- [2]
      4, -- [3]
      47230, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Spell_Shadow_LifeDrain", -- [1]
      2, -- [2]
      1, -- [3]
      18703, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Spell_Shadow_SummonVoidWalker", -- [1]
      2, -- [2]
      2, -- [3]
      18705, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Holy_MagicalSentry", -- [1]
      2, -- [2]
      3, -- [3]
      18731, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Spell_Shadow_SummonSuccubus", -- [1]
      3, -- [2]
      1, -- [3]
      18754, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Spell_Shadow_GatherShadows", -- [1]
      3, -- [2]
      2, -- [3]
      19028, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Spell_Nature_RemoveCurse", -- [1]
      3, -- [2]
      3, -- [3]
      18708, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Spell_Shadow_RagingScream", -- [1]
      3, -- [2]
      4, -- [3]
      30143, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowWordDominate", -- [1]
      4, -- [2]
      2, -- [3]
      18769, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Spell_Shadow_ImpPhaseShift", -- [1]
      4, -- [2]
      3, -- [3]
      18709, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Spell_Shadow_ManaFeed", -- [1]
      5, -- [2]
      1, -- [3]
      30326, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\INV_Ammo_FireTar", -- [1]
      5, -- [2]
      3, -- [3]
      18767, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowPact", -- [1]
      6, -- [2]
      2, -- [3]
      23785, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Ability_Warlock_MoltenCore", -- [1]
      6, -- [2]
      3, -- [3]
      47245, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Spell_Shadow_DemonicFortitude", -- [1]
      7, -- [2]
      1, -- [3]
      30319, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Ability_Warlock_DemonicEmpowerment", -- [1]
      7, -- [2]
      2, -- [3]
      47193, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Spell_Shadow_ImprovedVampiricEmbrace", -- [1]
      7, -- [2]
      3, -- [3]
      35691, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Spell_Shadow_DemonicTactics", -- [1]
      8, -- [2]
      2, -- [3]
      30242, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\Spell_Fire_Fireball02", -- [1]
      8, -- [2]
      3, -- [3]
      63156, -- [4]
    }, -- [62]
    {
      "Interface\\Icons\\Ability_Warlock_ImprovedDemonicTactics", -- [1]
      9, -- [2]
      1, -- [3]
      54347, -- [4]
    }, -- [63]
    {
      "Interface\\Icons\\Spell_Shadow_SummonFelGuard", -- [1]
      9, -- [2]
      2, -- [3]
      30146, -- [4]
    }, -- [64]
    {
      "Interface\\Icons\\Spell_Shadow_DemonicEmpathy", -- [1]
      9, -- [2]
      3, -- [3]
      63117, -- [4]
    }, -- [65]
    {
      "Interface\\Icons\\Spell_Shadow_DemonicPact", -- [1]
      10, -- [2]
      2, -- [3]
      47236, -- [4]
    }, -- [66]
    {
      "Interface\\Icons\\Spell_Shadow_DemonForm", -- [1]
      11, -- [2]
      2, -- [3]
      59672, -- [4]
    }, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowBolt", -- [1]
      1, -- [2]
      2, -- [3]
      17793, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Shadow_DeathPact", -- [1]
      1, -- [2]
      3, -- [3]
      17788, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Fire_Fire", -- [1]
      2, -- [2]
      1, -- [3]
      18119, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Ability_Mage_MoltenArmor", -- [1]
      2, -- [2]
      2, -- [3]
      63349, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Fire_WindsofWoe", -- [1]
      2, -- [2]
      3, -- [3]
      17778, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_Fire_FireBolt", -- [1]
      3, -- [2]
      1, -- [3]
      18126, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_Shadow_ScourgeBuild", -- [1]
      3, -- [2]
      2, -- [3]
      17877, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowWordPain", -- [1]
      3, -- [2]
      3, -- [3]
      17959, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Spell_Fire_LavaSpawn", -- [1]
      4, -- [2]
      1, -- [3]
      18135, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Spell_Shadow_CorpseExplode", -- [1]
      4, -- [2]
      2, -- [3]
      17917, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_Fire_SoulBurn", -- [1]
      4, -- [2]
      4, -- [3]
      17927, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Spell_Fire_PlayingWithFire", -- [1]
      5, -- [2]
      1, -- [3]
      34935, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Spell_Fire_Immolation", -- [1]
      5, -- [2]
      2, -- [3]
      17815, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Fire_FlameShock", -- [1]
      5, -- [2]
      3, -- [3]
      18130, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Shadow_NetherProtection", -- [1]
      6, -- [2]
      1, -- [3]
      30299, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Spell_Fire_SelfDestruct", -- [1]
      6, -- [2]
      3, -- [3]
      17954, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Spell_Fire_Fireball", -- [1]
      7, -- [2]
      2, -- [3]
      17962, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Spell_Shadow_SoulLeech_3", -- [1]
      7, -- [2]
      3, -- [3]
      30293, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Spell_Fire_Volcano", -- [1]
      7, -- [2]
      4, -- [3]
      18096, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowandFlame", -- [1]
      8, -- [2]
      2, -- [3]
      30288, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Ability_Warlock_ImprovedSoulLeech", -- [1]
      8, -- [2]
      3, -- [3]
      54117, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Ability_Warlock_Backdraft", -- [1]
      9, -- [2]
      1, -- [3]
      47258, -- [4]
    }, -- [102]
    {
      "Interface\\Icons\\Spell_Shadow_Shadowfury", -- [1]
      9, -- [2]
      2, -- [3]
      30283, -- [4]
    }, -- [103]
    {
      "Interface\\Icons\\Ability_Warlock_EmpoweredImp", -- [1]
      9, -- [2]
      3, -- [3]
      47220, -- [4]
    }, -- [104]
    {
      "Interface\\Icons\\Ability_Warlock_FireandBrimstone", -- [1]
      10, -- [2]
      2, -- [3]
      47266, -- [4]
    }, -- [105]
    {
      "Interface\\Icons\\Ability_Warlock_ChaosBolt", -- [1]
      11, -- [2]
      2, -- [3]
      50796, -- [4]
    }, -- [106]
    nil, -- [107]
    nil, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "WarlockCurses", -- [1]
      "WarlockSummoning", -- [2]
      "WarlockDestruction", -- [3]
    }, -- [121]
  },
  ["ROGUE"] = {
    {
      "Interface\\Icons\\Ability_Rogue_Eviscerate", -- [1]
      1, -- [2]
      1, -- [3]
      14162, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Ability_FiegnDead", -- [1]
      1, -- [2]
      2, -- [3]
      14144, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Ability_Racial_BloodRage", -- [1]
      1, -- [2]
      3, -- [3]
      14138, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Ability_Druid_Disembowel", -- [1]
      2, -- [2]
      1, -- [3]
      14156, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Ability_Rogue_BloodSplatter", -- [1]
      2, -- [2]
      2, -- [3]
      51632, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Ability_BackStab", -- [1]
      2, -- [2]
      4, -- [3]
      13733, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_Nature_EarthBindTotem", -- [1]
      3, -- [2]
      1, -- [3]
      14983, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Ability_Warrior_Riposte", -- [1]
      3, -- [2]
      2, -- [3]
      14168, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Ability_CriticalStrike", -- [1]
      3, -- [2]
      3, -- [3]
      14128, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Ability_Rogue_FeignDeath", -- [1]
      4, -- [2]
      2, -- [3]
      16513, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Ability_Poisons", -- [1]
      4, -- [2]
      3, -- [3]
      14113, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Ability_Rogue_FleetFooted", -- [1]
      5, -- [2]
      1, -- [3]
      31208, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Ice_Lament", -- [1]
      5, -- [2]
      2, -- [3]
      14177, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Ability_Rogue_KidneyShot", -- [1]
      5, -- [2]
      3, -- [3]
      14174, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Ability_Rogue_QuickRecovery", -- [1]
      5, -- [2]
      4, -- [3]
      31244, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Spell_Shadow_ChillTouch", -- [1]
      6, -- [2]
      2, -- [3]
      14186, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Spell_Shadow_DeathScream", -- [1]
      6, -- [2]
      3, -- [3]
      14158, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Ability_Rogue_DeadlyBrew", -- [1]
      7, -- [2]
      1, -- [3]
      51625, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Ability_Hunter_RapidKilling", -- [1]
      7, -- [2]
      2, -- [3]
      58426, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Ability_Rogue_DeadenedNerves", -- [1]
      7, -- [2]
      3, -- [3]
      31380, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Ability_Rogue_FocusedAttacks", -- [1]
      8, -- [2]
      1, -- [3]
      51634, -- [4]
    }, -- [21]
    {
      "Interface\\Icons\\Ability_Rogue_FindWeakness", -- [1]
      8, -- [2]
      3, -- [3]
      31234, -- [4]
    }, -- [22]
    {
      "Interface\\Icons\\Ability_Creature_Poison_06", -- [1]
      9, -- [2]
      1, -- [3]
      31226, -- [4]
    }, -- [23]
    {
      "Interface\\Icons\\Ability_Rogue_ShadowStrikes", -- [1]
      9, -- [2]
      2, -- [3]
      1329, -- [4]
    }, -- [24]
    {
      "Interface\\Icons\\Ability_Rogue_TurntheTables", -- [1]
      9, -- [2]
      3, -- [3]
      51627, -- [4]
    }, -- [25]
    {
      "Interface\\Icons\\Ability_Rogue_CutToTheChase", -- [1]
      10, -- [2]
      2, -- [3]
      51664, -- [4]
    }, -- [26]
    {
      "Interface\\Icons\\Ability_Rogue_HungerforBlood", -- [1]
      11, -- [2]
      2, -- [3]
      51662, -- [4]
    }, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Ability_Gouge", -- [1]
      1, -- [2]
      1, -- [3]
      13741, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Spell_Shadow_RitualOfSacrifice", -- [1]
      1, -- [2]
      2, -- [3]
      13732, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Ability_DualWield", -- [1]
      1, -- [2]
      3, -- [3]
      13715, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Ability_Rogue_SliceDice", -- [1]
      2, -- [2]
      1, -- [3]
      14165, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Ability_Parry", -- [1]
      2, -- [2]
      2, -- [3]
      13713, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Ability_Marksmanship", -- [1]
      2, -- [2]
      4, -- [3]
      13705, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowWard", -- [1]
      3, -- [2]
      1, -- [3]
      13742, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Ability_Warrior_Challange", -- [1]
      3, -- [2]
      2, -- [3]
      14251, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\INV_Weapon_ShortBlade_05", -- [1]
      3, -- [2]
      3, -- [3]
      13706, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Ability_Kick", -- [1]
      4, -- [2]
      1, -- [3]
      13754, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Ability_Rogue_Sprint", -- [1]
      4, -- [2]
      2, -- [3]
      13743, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Nature_Invisibilty", -- [1]
      4, -- [2]
      3, -- [3]
      13712, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Ability_Racial_Avatar", -- [1]
      4, -- [2]
      4, -- [3]
      18427, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\INV_Mace_01", -- [1]
      5, -- [2]
      1, -- [3]
      13709, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Ability_Warrior_PunishingBlow", -- [1]
      5, -- [2]
      2, -- [3]
      13877, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\INV_Sword_27", -- [1]
      5, -- [2]
      3, -- [3]
      13960, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfStrength", -- [1]
      6, -- [2]
      2, -- [3]
      30919, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Ability_Rogue_BladeTwisting", -- [1]
      6, -- [2]
      3, -- [3]
      31124, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Ability_Warrior_Revenge", -- [1]
      7, -- [2]
      1, -- [3]
      31122, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowWordDominate", -- [1]
      7, -- [2]
      2, -- [3]
      13750, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Ability_Rogue_NervesOfSteel", -- [1]
      7, -- [2]
      3, -- [3]
      31130, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\Ability_Rogue_ThrowingSpecialization", -- [1]
      8, -- [2]
      1, -- [3]
      5952, -- [4]
    }, -- [62]
    {
      "Interface\\Icons\\INV_Weapon_Shortblade_38", -- [1]
      8, -- [2]
      3, -- [3]
      35541, -- [4]
    }, -- [63]
    {
      "Interface\\Icons\\Ability_Rogue_UnfairAdvantage", -- [1]
      9, -- [2]
      1, -- [3]
      51672, -- [4]
    }, -- [64]
    {
      "Interface\\Icons\\Ability_Rogue_SurpriseAttack", -- [1]
      9, -- [2]
      2, -- [3]
      32601, -- [4]
    }, -- [65]
    {
      "Interface\\Icons\\Ability_Creature_Disease_03", -- [1]
      9, -- [2]
      3, -- [3]
      51682, -- [4]
    }, -- [66]
    {
      "Interface\\Icons\\Ability_Rogue_PreyontheWeak", -- [1]
      10, -- [2]
      2, -- [3]
      51685, -- [4]
    }, -- [67]
    {
      "Interface\\Icons\\Ability_Rogue_MurderSpree", -- [1]
      11, -- [2]
      2, -- [3]
      51690, -- [4]
    }, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Ability_Warrior_DecisiveStrike", -- [1]
      1, -- [2]
      1, -- [3]
      14179, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Shadow_Charm", -- [1]
      1, -- [2]
      2, -- [3]
      13958, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Ability_Warrior_WarCry", -- [1]
      1, -- [2]
      3, -- [3]
      14057, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Ability_Rogue_Feint", -- [1]
      2, -- [2]
      1, -- [3]
      30892, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Ability_Sap", -- [1]
      2, -- [2]
      2, -- [3]
      14076, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Ability_Stealth", -- [1]
      2, -- [2]
      3, -- [3]
      13975, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_Magic_LesserInvisibilty", -- [1]
      3, -- [2]
      1, -- [3]
      13981, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Shadow_Curse", -- [1]
      3, -- [2]
      2, -- [3]
      14278, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\INV_Sword_17", -- [1]
      3, -- [2]
      3, -- [3]
      14171, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Spell_Nature_MirrorImage", -- [1]
      4, -- [2]
      1, -- [3]
      13983, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_Shadow_Fumble", -- [1]
      4, -- [2]
      2, -- [3]
      13976, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Ability_Rogue_Ambush", -- [1]
      4, -- [2]
      3, -- [3]
      14079, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Ability_Ambush", -- [1]
      5, -- [2]
      1, -- [3]
      30894, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Shadow_AntiShadow", -- [1]
      5, -- [2]
      2, -- [3]
      14185, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Shadow_SummonSuccubus", -- [1]
      5, -- [2]
      3, -- [3]
      14082, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Spell_Shadow_LifeDrain", -- [1]
      5, -- [2]
      4, -- [3]
      16511, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Ability_Rogue_MasterOfSubtlety", -- [1]
      6, -- [2]
      1, -- [3]
      31221, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\INV_Weapon_Crossbow_11", -- [1]
      6, -- [2]
      3, -- [3]
      30902, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Ability_Rogue_EnvelopingShadows", -- [1]
      7, -- [2]
      1, -- [3]
      31211, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Spell_Shadow_Possession", -- [1]
      7, -- [2]
      2, -- [3]
      14183, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Ability_Rogue_CheatDeath", -- [1]
      7, -- [2]
      3, -- [3]
      31228, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Ability_Rogue_SinisterCalling", -- [1]
      8, -- [2]
      2, -- [3]
      31216, -- [4]
    }, -- [102]
    {
      "Interface\\Icons\\Ability_Rogue_Waylay", -- [1]
      8, -- [2]
      3, -- [3]
      51692, -- [4]
    }, -- [103]
    {
      "Interface\\Icons\\Ability_Rogue_HonorAmongstThieves", -- [1]
      9, -- [2]
      1, -- [3]
      51698, -- [4]
    }, -- [104]
    {
      "Interface\\Icons\\Ability_Rogue_Shadowstep", -- [1]
      9, -- [2]
      2, -- [3]
      36554, -- [4]
    }, -- [105]
    {
      "Interface\\Icons\\Ability_Rogue_WrongfullyAccused", -- [1]
      9, -- [2]
      3, -- [3]
      58414, -- [4]
    }, -- [106]
    {
      "Interface\\Icons\\Ability_Rogue_SlaughterfromtheShadows", -- [1]
      10, -- [2]
      2, -- [3]
      51708, -- [4]
    }, -- [107]
    {
      "Interface\\Icons\\Ability_Rogue_ShadowDance", -- [1]
      11, -- [2]
      2, -- [3]
      51713, -- [4]
    }, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "RogueAssassination", -- [1]
      "RogueCombat", -- [2]
      "RogueSubtlety", -- [3]
    }, -- [121]
  },
  ["DRUID"] = {
    {
      "Interface\\Icons\\Spell_Nature_AbolishMagic", -- [1]
      1, -- [2]
      2, -- [3]
      16814, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Spell_Arcane_Arcane03", -- [1]
      1, -- [2]
      3, -- [3]
      57810, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Spell_Nature_Sentinal", -- [1]
      2, -- [2]
      1, -- [3]
      16845, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\INV_Staff_01", -- [1]
      2, -- [2]
      2, -- [3]
      35363, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Spell_Nature_StarFall", -- [1]
      2, -- [2]
      4, -- [3]
      16821, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Spell_Nature_Thorns", -- [1]
      3, -- [2]
      1, -- [3]
      16836, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_Nature_NaturesBlessing", -- [1]
      3, -- [2]
      2, -- [3]
      16880, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_Nature_NatureGuardian", -- [1]
      3, -- [2]
      3, -- [3]
      57865, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Spell_Nature_NatureTouchGrow", -- [1]
      3, -- [2]
      4, -- [3]
      16819, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Spell_Nature_Purge", -- [1]
      4, -- [2]
      2, -- [3]
      16909, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Spell_Arcane_StarFire", -- [1]
      4, -- [2]
      3, -- [3]
      16850, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Ability_Druid_LunarGuidance", -- [1]
      5, -- [2]
      1, -- [3]
      33589, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Nature_InsectSwarm", -- [1]
      5, -- [2]
      2, -- [3]
      5570, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Nature_InsectSwarm", -- [1]
      5, -- [2]
      3, -- [3]
      57849, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Ability_Druid_Dreamstate", -- [1]
      6, -- [2]
      1, -- [3]
      33597, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Spell_Nature_MoonGlow", -- [1]
      6, -- [2]
      2, -- [3]
      16896, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Ability_Druid_BalanceofPower", -- [1]
      6, -- [2]
      3, -- [3]
      33592, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Nature_ForceOfNature", -- [1]
      7, -- [2]
      2, -- [3]
      24858, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Ability_Druid_ImprovedMoonkinForm", -- [1]
      7, -- [2]
      3, -- [3]
      48384, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Spell_Nature_FaerieFire", -- [1]
      7, -- [2]
      4, -- [3]
      33600, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Ability_Druid_OwlkinFrenzy", -- [1]
      8, -- [2]
      1, -- [3]
      48389, -- [4]
    }, -- [21]
    {
      "Interface\\Icons\\Ability_Druid_TwilightsWrath", -- [1]
      8, -- [2]
      3, -- [3]
      33603, -- [4]
    }, -- [22]
    {
      "Interface\\Icons\\Ability_Druid_Eclipse", -- [1]
      9, -- [2]
      1, -- [3]
      48516, -- [4]
    }, -- [23]
    {
      "Interface\\Icons\\Ability_Druid_Typhoon", -- [1]
      9, -- [2]
      2, -- [3]
      50516, -- [4]
    }, -- [24]
    {
      "Interface\\Icons\\Ability_Druid_ForceofNature", -- [1]
      9, -- [2]
      3, -- [3]
      33831, -- [4]
    }, -- [25]
    {
      "Interface\\Icons\\Ability_Druid_GaleWinds", -- [1]
      9, -- [2]
      4, -- [3]
      48488, -- [4]
    }, -- [26]
    {
      "Interface\\Icons\\Ability_Druid_EarthandSky", -- [1]
      10, -- [2]
      2, -- [3]
      48506, -- [4]
    }, -- [27]
    {
      "Interface\\Icons\\Ability_Druid_Starfall", -- [1]
      11, -- [2]
      2, -- [3]
      48505, -- [4]
    }, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Ability_Hunter_Pet_Hyena", -- [1]
      1, -- [2]
      2, -- [3]
      16934, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Ability_Druid_DemoralizingRoar", -- [1]
      1, -- [2]
      3, -- [3]
      16858, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Ability_Ambush", -- [1]
      2, -- [2]
      1, -- [3]
      16947, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Ability_Druid_Ravage", -- [1]
      2, -- [2]
      2, -- [3]
      16998, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\INV_Misc_Pelt_Bear_03", -- [1]
      2, -- [2]
      3, -- [3]
      16929, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Spell_Nature_SpiritWolf", -- [1]
      3, -- [2]
      1, -- [3]
      17002, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Ability_Druid_TigersRoar", -- [1]
      3, -- [2]
      2, -- [3]
      61336, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\INV_Misc_MonsterClaw_04", -- [1]
      3, -- [2]
      3, -- [3]
      16942, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Spell_Shadow_VampiricAura", -- [1]
      4, -- [2]
      1, -- [3]
      16966, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Ability_Hunter_Pet_Cat", -- [1]
      4, -- [2]
      2, -- [3]
      16972, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Ability_Racial_Cannibalize", -- [1]
      4, -- [2]
      3, -- [3]
      37116, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Ability_Druid_PrimalPrecision", -- [1]
      4, -- [2]
      4, -- [3]
      48409, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Ability_Druid_Bash", -- [1]
      5, -- [2]
      1, -- [3]
      16940, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Ability_Hunter_Pet_Bear", -- [1]
      5, -- [2]
      3, -- [3]
      49377, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Ability_Druid_HealingInstincts", -- [1]
      5, -- [2]
      4, -- [3]
      33872, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Ability_BullRush", -- [1]
      6, -- [2]
      1, -- [3]
      57878, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfAgility", -- [1]
      6, -- [2]
      2, -- [3]
      17003, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Ability_Druid_Enrage", -- [1]
      6, -- [2]
      3, -- [3]
      33853, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Spell_Nature_UnyeildingStamina", -- [1]
      7, -- [2]
      2, -- [3]
      17007, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Spell_Nature_UnyeildingStamina", -- [1]
      7, -- [2]
      3, -- [3]
      34297, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Ability_Druid_PrimalTenacity", -- [1]
      7, -- [2]
      4, -- [3]
      33851, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\Ability_Druid_ChallangingRoar", -- [1]
      8, -- [2]
      1, -- [3]
      57873, -- [4]
    }, -- [62]
    {
      "Interface\\Icons\\Ability_Druid_PredatoryInstincts", -- [1]
      8, -- [2]
      3, -- [3]
      33859, -- [4]
    }, -- [63]
    {
      "Interface\\Icons\\Ability_Druid_InfectedWound", -- [1]
      8, -- [2]
      4, -- [3]
      48483, -- [4]
    }, -- [64]
    {
      "Interface\\Icons\\Ability_Druid_KingoftheJungle", -- [1]
      9, -- [2]
      1, -- [3]
      48492, -- [4]
    }, -- [65]
    {
      "Interface\\Icons\\Ability_Druid_Mangle2", -- [1]
      9, -- [2]
      2, -- [3]
      33917, -- [4]
    }, -- [66]
    {
      "Interface\\Icons\\Ability_Druid_Mangle2", -- [1]
      9, -- [2]
      3, -- [3]
      48532, -- [4]
    }, -- [67]
    {
      "Interface\\Icons\\Ability_Druid_PrimalAgression", -- [1]
      10, -- [2]
      2, -- [3]
      48432, -- [4]
    }, -- [68]
    {
      "Interface\\Icons\\Ability_Druid_Rake", -- [1]
      10, -- [2]
      3, -- [3]
      63503, -- [4]
    }, -- [69]
    {
      "Interface\\Icons\\Ability_Druid_Berserk", -- [1]
      11, -- [2]
      2, -- [3]
      50334, -- [4]
    }, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Spell_Nature_Regeneration", -- [1]
      1, -- [2]
      1, -- [3]
      17050, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Nature_HealingWaveGreater", -- [1]
      1, -- [2]
      2, -- [3]
      17063, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfStamina", -- [1]
      1, -- [2]
      3, -- [3]
      17056, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Spell_Nature_HealingTouch", -- [1]
      2, -- [2]
      1, -- [3]
      17069, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Ability_EyeOfTheOwl", -- [1]
      2, -- [2]
      2, -- [3]
      17118, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_Nature_WispSplode", -- [1]
      2, -- [2]
      3, -- [3]
      16833, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_Frost_WindWalkOn", -- [1]
      3, -- [2]
      1, -- [3]
      17106, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Nature_CrystalBall", -- [1]
      3, -- [2]
      2, -- [3]
      16864, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Ability_Druid_MasterShapeshifter", -- [1]
      3, -- [2]
      3, -- [3]
      48411, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Spell_Holy_ElunesGrace", -- [1]
      4, -- [2]
      2, -- [3]
      24968, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_Nature_Rejuvenation", -- [1]
      4, -- [2]
      3, -- [3]
      17111, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Spell_Nature_RavenForm", -- [1]
      5, -- [2]
      1, -- [3]
      17116, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Spell_Nature_ProtectionformNature", -- [1]
      5, -- [2]
      2, -- [3]
      17104, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Nature_Tranquility", -- [1]
      5, -- [2]
      4, -- [3]
      17123, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Ability_Druid_EmpoweredTouch", -- [1]
      6, -- [2]
      1, -- [3]
      33879, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Spell_Nature_ResistNature", -- [1]
      6, -- [2]
      3, -- [3]
      17074, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Spell_Nature_GiftoftheWaterSpirit", -- [1]
      7, -- [2]
      1, -- [3]
      34151, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\INV_Relics_IdolofRejuvenation", -- [1]
      7, -- [2]
      2, -- [3]
      18562, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Ability_Druid_NaturalPerfection", -- [1]
      7, -- [2]
      3, -- [3]
      33881, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Ability_Druid_EmpoweredRejuvination", -- [1]
      8, -- [2]
      2, -- [3]
      33886, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Ability_Druid_GiftoftheEarthmother", -- [1]
      8, -- [2]
      3, -- [3]
      48496, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Ability_Druid_Replenish", -- [1]
      9, -- [2]
      1, -- [3]
      48539, -- [4]
    }, -- [102]
    {
      "Interface\\Icons\\Ability_Druid_TreeofLife", -- [1]
      9, -- [2]
      2, -- [3]
      65139, -- [4]
    }, -- [103]
    {
      "Interface\\Icons\\Ability_Druid_ImprovedTreeForm", -- [1]
      9, -- [2]
      3, -- [3]
      48535, -- [4]
    }, -- [104]
    {
      "Interface\\Icons\\Spell_Nature_StoneClawTotem", -- [1]
      10, -- [2]
      1, -- [3]
      63410, -- [4]
    }, -- [105]
    {
      "Interface\\Icons\\Ability_Druid_ManaTree", -- [1]
      10, -- [2]
      3, -- [3]
      51179, -- [4]
    }, -- [106]
    {
      "Interface\\Icons\\Ability_Druid_Flourish", -- [1]
      11, -- [2]
      2, -- [3]
      48438, -- [4]
    }, -- [107]
    nil, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "DruidBalance", -- [1]
      "DruidFeralCombat", -- [2]
      "DruidRestoration", -- [3]
    }, -- [121]
  },
  ["PALADIN"] = {
    {
      "Interface\\Icons\\Spell_Arcane_Blink", -- [1]
      1, -- [2]
      2, -- [3]
      20208, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Ability_ThunderBolt", -- [1]
      1, -- [2]
      3, -- [3]
      20224, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Spell_Holy_HolyBolt", -- [1]
      2, -- [2]
      1, -- [3]
      20239, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Spell_Nature_Sleep", -- [1]
      2, -- [2]
      2, -- [3]
      20261, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Spell_Holy_UnyieldingFaith", -- [1]
      2, -- [2]
      3, -- [3]
      9453, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Spell_Holy_AuraMastery", -- [1]
      3, -- [2]
      1, -- [3]
      31821, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_Holy_GreaterHeal", -- [1]
      3, -- [2]
      2, -- [3]
      20215, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_Holy_LayOnHands", -- [1]
      3, -- [2]
      3, -- [3]
      20235, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Spell_Holy_MindSooth", -- [1]
      4, -- [2]
      1, -- [3]
      20254, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Spell_Holy_SealOfWisdom", -- [1]
      4, -- [2]
      3, -- [3]
      20245, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Ability_Paladin_BlessedHands", -- [1]
      4, -- [2]
      4, -- [3]
      53660, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Spell_Holy_PureOfHeart", -- [1]
      5, -- [2]
      1, -- [3]
      31822, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Holy_Heal", -- [1]
      5, -- [2]
      2, -- [3]
      20216, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Holy_HealingAura", -- [1]
      5, -- [2]
      3, -- [3]
      20361, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Spell_Holy_PurifyingPower", -- [1]
      6, -- [2]
      1, -- [3]
      31825, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Spell_Holy_Power", -- [1]
      6, -- [2]
      3, -- [3]
      25829, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Spell_Holy_LightsGrace", -- [1]
      7, -- [2]
      1, -- [3]
      31836, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Holy_SearingLight", -- [1]
      7, -- [2]
      2, -- [3]
      20473, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Spell_Holy_BlessedLife", -- [1]
      7, -- [2]
      3, -- [3]
      31828, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Ability_Paladin_SacredCleansing", -- [1]
      8, -- [2]
      1, -- [3]
      53551, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Spell_Holy_HolyGuidance", -- [1]
      8, -- [2]
      3, -- [3]
      31841, -- [4]
    }, -- [21]
    {
      "Interface\\Icons\\Spell_Holy_DivineIllumination", -- [1]
      9, -- [2]
      1, -- [3]
      31842, -- [4]
    }, -- [22]
    {
      "Interface\\Icons\\Ability_Paladin_JudgementofthePure", -- [1]
      9, -- [2]
      3, -- [3]
      54155, -- [4]
    }, -- [23]
    {
      "Interface\\Icons\\Ability_Paladin_InfusionofLight", -- [1]
      10, -- [2]
      2, -- [3]
      53576, -- [4]
    }, -- [24]
    {
      "Interface\\Icons\\Ability_Paladin_EnlightenedJudgements", -- [1]
      10, -- [2]
      3, -- [3]
      53557, -- [4]
    }, -- [25]
    {
      "Interface\\Icons\\Ability_Paladin_BeaconofLight", -- [1]
      11, -- [2]
      2, -- [3]
      53563, -- [4]
    }, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Spell_Holy_BlindingHeal", -- [1]
      1, -- [2]
      2, -- [3]
      63650, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Ability_GolemThunderClap", -- [1]
      1, -- [2]
      3, -- [3]
      20262, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Spell_Holy_Stoicism", -- [1]
      2, -- [2]
      1, -- [3]
      53519, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Spell_Holy_SealOfProtection", -- [1]
      2, -- [2]
      2, -- [3]
      20175, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Spell_Magic_LesserInvisibilty", -- [1]
      2, -- [2]
      3, -- [3]
      20096, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\spell_holy_powerwordbarrier", -- [1]
      3, -- [2]
      1, -- [3]
      64205, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Holy_SealOfFury", -- [1]
      3, -- [2]
      2, -- [3]
      20468, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Spell_Holy_Devotion", -- [1]
      3, -- [2]
      3, -- [3]
      20146, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\spell_holy_powerwordbarrier", -- [1]
      4, -- [2]
      1, -- [3]
      53530, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Spell_Holy_SealOfMight", -- [1]
      4, -- [2]
      2, -- [3]
      20487, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Spell_Holy_DevotionAura", -- [1]
      4, -- [2]
      3, -- [3]
      20139, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Nature_LightningShield", -- [1]
      5, -- [2]
      2, -- [3]
      20911, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfStrength", -- [1]
      5, -- [2]
      3, -- [3]
      20177, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Spell_Holy_DivineIntervention", -- [1]
      6, -- [2]
      1, -- [3]
      31848, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\INV_Sword_20", -- [1]
      6, -- [2]
      3, -- [3]
      20196, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Spell_Holy_ReviveChampion", -- [1]
      7, -- [2]
      1, -- [3]
      31785, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfProtection", -- [1]
      7, -- [2]
      2, -- [3]
      20925, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Spell_Holy_ArdentDefender", -- [1]
      7, -- [2]
      3, -- [3]
      31850, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Ability_Defend", -- [1]
      8, -- [2]
      1, -- [3]
      20127, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Spell_Holy_WeaponMastery", -- [1]
      8, -- [2]
      3, -- [3]
      31858, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Ability_Paladin_TouchedbyLight", -- [1]
      9, -- [2]
      1, -- [3]
      53590, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\Spell_Holy_AvengersShield", -- [1]
      9, -- [2]
      2, -- [3]
      31935, -- [4]
    }, -- [62]
    {
      "Interface\\Icons\\Ability_Paladin_GaurdedbytheLight", -- [1]
      9, -- [2]
      3, -- [3]
      53583, -- [4]
    }, -- [63]
    {
      "Interface\\Icons\\Ability_Paladin_ShieldoftheTemplar", -- [1]
      10, -- [2]
      2, -- [3]
      53709, -- [4]
    }, -- [64]
    {
      "Interface\\Icons\\Ability_Paladin_JudgementsoftheJust", -- [1]
      10, -- [2]
      3, -- [3]
      53695, -- [4]
    }, -- [65]
    {
      "Interface\\Icons\\Ability_Paladin_HammeroftheRighteous", -- [1]
      11, -- [2]
      2, -- [3]
      53595, -- [4]
    }, -- [66]
    nil, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Ability_Parry", -- [1]
      1, -- [2]
      2, -- [3]
      20060, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Frost_WindWalkOn", -- [1]
      1, -- [2]
      3, -- [3]
      20101, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Holy_RighteousFury", -- [1]
      2, -- [2]
      1, -- [3]
      25956, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Spell_Holy_HolySmite", -- [1]
      2, -- [2]
      2, -- [3]
      20335, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Holy_FistOfJustice", -- [1]
      2, -- [2]
      3, -- [3]
      20042, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_Holy_Vindication", -- [1]
      3, -- [2]
      1, -- [3]
      9452, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_Holy_RetributionAura", -- [1]
      3, -- [2]
      2, -- [3]
      20117, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Ability_Warrior_InnerRage", -- [1]
      3, -- [2]
      3, -- [3]
      20375, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Spell_Holy_PersuitofJustice", -- [1]
      3, -- [2]
      4, -- [3]
      26022, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Spell_Holy_EyeforanEye", -- [1]
      4, -- [2]
      1, -- [3]
      9799, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_Holy_HolySmite", -- [1]
      4, -- [2]
      3, -- [3]
      32043, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Spell_Holy_Crusade", -- [1]
      4, -- [2]
      4, -- [3]
      31866, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\INV_Hammer_04", -- [1]
      5, -- [2]
      1, -- [3]
      20111, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Holy_MindVision", -- [1]
      5, -- [2]
      3, -- [3]
      31869, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Ability_Racial_Avatar", -- [1]
      6, -- [2]
      2, -- [3]
      20049, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Spell_Holy_DivinePurpose", -- [1]
      6, -- [2]
      3, -- [3]
      31871, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Ability_Paladin_ArtofWar", -- [1]
      7, -- [2]
      1, -- [3]
      53486, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Spell_Holy_PrayerOfHealing", -- [1]
      7, -- [2]
      2, -- [3]
      20066, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Ability_Paladin_JudgementoftheWise", -- [1]
      7, -- [2]
      3, -- [3]
      31876, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Spell_Holy_Fanaticism", -- [1]
      8, -- [2]
      2, -- [3]
      31879, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Ability_Paladin_SanctifiedWrath", -- [1]
      8, -- [2]
      3, -- [3]
      53375, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Ability_Paladin_SwiftRetribution", -- [1]
      9, -- [2]
      1, -- [3]
      53379, -- [4]
    }, -- [102]
    {
      "Interface\\Icons\\Spell_Holy_CrusaderStrike", -- [1]
      9, -- [2]
      2, -- [3]
      35395, -- [4]
    }, -- [103]
    {
      "Interface\\Icons\\Ability_Paladin_SheathofLight", -- [1]
      9, -- [2]
      3, -- [3]
      53501, -- [4]
    }, -- [104]
    {
      "Interface\\Icons\\Ability_Paladin_RighteousVengeance", -- [1]
      10, -- [2]
      2, -- [3]
      53380, -- [4]
    }, -- [105]
    {
      "Interface\\Icons\\Ability_Paladin_DivineStorm", -- [1]
      11, -- [2]
      2, -- [3]
      53385, -- [4]
    }, -- [106]
    nil, -- [107]
    nil, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "PaladinHoly", -- [1]
      "PaladinProtection", -- [2]
      "PaladinCombat", -- [3]
    }, -- [121]
  },
  ["DEATHKNIGHT"] = {
    {
      "Interface\\Icons\\INV_Axe_68", -- [1]
      1, -- [2]
      1, -- [3]
      48979, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Spell_DeathKnight_Subversion", -- [1]
      1, -- [2]
      2, -- [3]
      48997, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Ability_UpgradeMoonGlaive", -- [1]
      1, -- [2]
      3, -- [3]
      49182, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\INV_Shoulder_36", -- [1]
      2, -- [2]
      1, -- [3]
      48978, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Ability_Rogue_BloodyEye", -- [1]
      2, -- [2]
      2, -- [3]
      49004, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\INV_Sword_68", -- [1]
      2, -- [2]
      3, -- [3]
      55107, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_DeathKnight_RuneTap", -- [1]
      3, -- [2]
      1, -- [3]
      48982, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_DeathKnight_DarkConviction", -- [1]
      3, -- [2]
      2, -- [3]
      48987, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\INV_Sword_62", -- [1]
      3, -- [2]
      3, -- [3]
      49467, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Spell_DeathKnight_RuneTap", -- [1]
      4, -- [2]
      1, -- [3]
      48985, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Spell_DeathKnight_SpellDeflection", -- [1]
      4, -- [2]
      3, -- [3]
      49145, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Spell_DeathKnight_Vendetta", -- [1]
      4, -- [2]
      4, -- [3]
      49015, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Deathknight_DeathStrike", -- [1]
      5, -- [2]
      1, -- [3]
      48977, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Misc_WarsongFocus", -- [1]
      5, -- [2]
      3, -- [3]
      49006, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Ability_Hunter_RapidKilling", -- [1]
      5, -- [2]
      4, -- [3]
      49005, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Ability_BackStab", -- [1]
      6, -- [2]
      2, -- [3]
      48988, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Ability_Warrior_IntensifyRage", -- [1]
      6, -- [2]
      3, -- [3]
      53137, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Shadow_SoulLeech", -- [1]
      7, -- [2]
      1, -- [3]
      49027, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Spell_DeathKnight_BladedArmor", -- [1]
      7, -- [2]
      2, -- [3]
      49016, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Spell_Deathknight_BloodPresence", -- [1]
      7, -- [2]
      3, -- [3]
      50365, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Spell_DeathKnight_Butcher2", -- [1]
      8, -- [2]
      1, -- [3]
      62905, -- [4]
    }, -- [21]
    {
      "Interface\\Icons\\Spell_Shadow_PainSpike", -- [1]
      8, -- [2]
      2, -- [3]
      49018, -- [4]
    }, -- [22]
    {
      "Interface\\Icons\\Spell_Shadow_LifeDrain", -- [1]
      8, -- [2]
      3, -- [3]
      55233, -- [4]
    }, -- [23]
    {
      "Interface\\Icons\\Ability_Creature_Cursed_02", -- [1]
      9, -- [2]
      1, -- [3]
      49189, -- [4]
    }, -- [24]
    {
      "Interface\\Icons\\INV_Weapon_Shortblade_40", -- [1]
      9, -- [2]
      2, -- [3]
      55050, -- [4]
    }, -- [25]
    {
      "Interface\\Icons\\Spell_Deathknight_ClassIcon", -- [1]
      9, -- [2]
      3, -- [3]
      49023, -- [4]
    }, -- [26]
    {
      "Interface\\Icons\\Spell_Nature_Reincarnation", -- [1]
      10, -- [2]
      2, -- [3]
      61154, -- [4]
    }, -- [27]
    {
      "Interface\\Icons\\INV_Sword_07", -- [1]
      11, -- [2]
      2, -- [3]
      49028, -- [4]
    }, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Spell_DeathKnight_IceTouch", -- [1]
      1, -- [2]
      1, -- [3]
      49175, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Spell_Arcane_Arcane01", -- [1]
      1, -- [2]
      2, -- [3]
      49455, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Spell_Holy_Devotion", -- [1]
      1, -- [2]
      3, -- [3]
      49042, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Spell_Frost_ManaRecharge", -- [1]
      2, -- [2]
      2, -- [3]
      55061, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Spell_Shadow_DarkRitual", -- [1]
      2, -- [2]
      3, -- [3]
      49140, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Ability_DualWield", -- [1]
      2, -- [2]
      4, -- [3]
      49226, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Deathknight_IcyTalons", -- [1]
      3, -- [2]
      1, -- [3]
      50880, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Spell_Shadow_RaiseDead", -- [1]
      3, -- [2]
      2, -- [3]
      49039, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\INV_Weapon_Hand_18", -- [1]
      3, -- [2]
      3, -- [3]
      51468, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\INV_Sword_122", -- [1]
      4, -- [2]
      2, -- [3]
      51123, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Spell_Frost_FrostShock", -- [1]
      4, -- [2]
      3, -- [3]
      49149, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Shadow_Twilight", -- [1]
      4, -- [2]
      4, -- [3]
      49137, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\INV_CHEST_MAIL_04", -- [1]
      5, -- [2]
      2, -- [3]
      49186, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Spell_Nature_RemoveDisease", -- [1]
      5, -- [2]
      3, -- [3]
      49471, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Spell_Shadow_SoulLeech_2", -- [1]
      5, -- [2]
      4, -- [3]
      49796, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Spell_Deathknight_IcyTalons", -- [1]
      6, -- [2]
      1, -- [3]
      55610, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\INV_Sword_112", -- [1]
      6, -- [2]
      2, -- [3]
      49024, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Spell_Frost_FreezingBreath", -- [1]
      6, -- [2]
      3, -- [3]
      49188, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Spell_Frost_Wisp", -- [1]
      7, -- [2]
      1, -- [3]
      50040, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\INV_Staff_15", -- [1]
      7, -- [2]
      2, -- [3]
      49203, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Spell_Deathknight_FrostPresence", -- [1]
      7, -- [2]
      3, -- [3]
      50384, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\Ability_DualWieldSpecialization", -- [1]
      8, -- [2]
      1, -- [3]
      65661, -- [4]
    }, -- [62]
    {
      "Interface\\Icons\\INV_Weapon_Shortblade_79", -- [1]
      8, -- [2]
      2, -- [3]
      54639, -- [4]
    }, -- [63]
    {
      "Interface\\Icons\\INV_Armor_Helm_Plate_Naxxramas_RaidWarrior_C_01", -- [1]
      8, -- [2]
      3, -- [3]
      51271, -- [4]
    }, -- [64]
    {
      "Interface\\Icons\\Spell_Fire_ElementalDevastation", -- [1]
      9, -- [2]
      1, -- [3]
      49200, -- [4]
    }, -- [65]
    {
      "Interface\\Icons\\Spell_DeathKnight_EmpowerRuneBlade2", -- [1]
      9, -- [2]
      2, -- [3]
      49143, -- [4]
    }, -- [66]
    {
      "Interface\\Icons\\INV-Sword_53", -- [1]
      9, -- [2]
      3, -- [3]
      50187, -- [4]
    }, -- [67]
    {
      "Interface\\Icons\\Spell_Nature_Tranquility", -- [1]
      10, -- [2]
      2, -- [3]
      49202, -- [4]
    }, -- [68]
    {
      "Interface\\Icons\\Spell_Frost_ArcticWinds", -- [1]
      11, -- [2]
      2, -- [3]
      49184, -- [4]
    }, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Spell_Deathknight_PlagueStrike", -- [1]
      1, -- [2]
      1, -- [3]
      51745, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Shadow_BurningSpirit", -- [1]
      1, -- [2]
      2, -- [3]
      48962, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Nature_MirrorImage", -- [1]
      1, -- [2]
      3, -- [3]
      55129, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowWordPain", -- [1]
      2, -- [2]
      1, -- [3]
      49036, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Shadow_DeathAndDecay", -- [1]
      2, -- [2]
      2, -- [3]
      48963, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_DeathKnight_Strangulate", -- [1]
      2, -- [2]
      3, -- [3]
      49588, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_DeathKnight_Gnaw_Ghoul", -- [1]
      2, -- [2]
      4, -- [3]
      48965, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Shadow_PlagueCloud", -- [1]
      3, -- [2]
      1, -- [3]
      49013, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\INV_Weapon_Shortblade_60", -- [1]
      3, -- [2]
      2, -- [3]
      51459, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Ability_Creature_Disease_02", -- [1]
      3, -- [2]
      3, -- [3]
      49158, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_DeathKnight_SummonDeathCharger", -- [1]
      4, -- [2]
      2, -- [3]
      49146, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Ability_CriticalStrike", -- [1]
      4, -- [2]
      3, -- [3]
      49219, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Spell_DeathKnight_ArmyOfTheDead", -- [1]
      4, -- [2]
      4, -- [3]
      55620, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Shadow_Contagion", -- [1]
      5, -- [2]
      1, -- [3]
      49194, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowandFlame", -- [1]
      5, -- [2]
      2, -- [3]
      49220, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Spell_Shadow_Shadesofdarkness", -- [1]
      5, -- [2]
      3, -- [3]
      49223, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Spell_Shadow_Shadowfiend", -- [1]
      6, -- [2]
      1, -- [3]
      55666, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Spell_Shadow_AntiMagicShell", -- [1]
      6, -- [2]
      2, -- [3]
      49224, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Spell_Shadow_ShadeTrueSight", -- [1]
      6, -- [2]
      3, -- [3]
      49208, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Spell_Shadow_AnimateDead", -- [1]
      6, -- [2]
      4, -- [3]
      52143, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Spell_Shadow_UnholyFrenzy", -- [1]
      7, -- [2]
      1, -- [3]
      66799, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Spell_DeathKnight_AntiMagicZone", -- [1]
      7, -- [2]
      2, -- [3]
      51052, -- [4]
    }, -- [102]
    {
      "Interface\\Icons\\Spell_Deathknight_UnholyPresence", -- [1]
      7, -- [2]
      3, -- [3]
      50391, -- [4]
    }, -- [103]
    {
      "Interface\\Icons\\Ability_GhoulFrenzy", -- [1]
      7, -- [2]
      4, -- [3]
      63560, -- [4]
    }, -- [104]
    {
      "Interface\\Icons\\Spell_Nature_NullifyDisease", -- [1]
      8, -- [2]
      2, -- [3]
      49032, -- [4]
    }, -- [105]
    {
      "Interface\\Icons\\INV_Chest_Leather_13", -- [1]
      8, -- [2]
      3, -- [3]
      49222, -- [4]
    }, -- [106]
    {
      "Interface\\Icons\\Spell_Shadow_CallofBone", -- [1]
      9, -- [2]
      1, -- [3]
      49217, -- [4]
    }, -- [107]
    {
      "Interface\\Icons\\Ability_Creature_Cursed_03", -- [1]
      9, -- [2]
      2, -- [3]
      51099, -- [4]
    }, -- [108]
    {
      "Interface\\Icons\\Spell_DeathKnight_ScourgeStrike", -- [1]
      9, -- [2]
      3, -- [3]
      55090, -- [4]
    }, -- [109]
    {
      "Interface\\Icons\\INV_Weapon_Halberd14", -- [1]
      10, -- [2]
      2, -- [3]
      50117, -- [4]
    }, -- [110]
    {
      "Interface\\Icons\\Ability_Hunter_Pet_Bat", -- [1]
      11, -- [2]
      2, -- [3]
      49206, -- [4]
    }, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "DeathKnightBlood", -- [1]
      "DeathKnightFrost", -- [2]
      "DeathKnightUnholy", -- [3]
    }, -- [121]
  },
}
