	----------------------------------------------------------------------
	-- Leatrix Plus Media
	----------------------------------------------------------------------

	-- Begin
	local void, Leatrix_Plus = ...
	local L = Leatrix_Plus.L

	local ZoneList = {}
	local prefol = "|cffffffaa{" .. L["right-click to go back"] .. "}"

	-- Create a table for each heading
	ZoneList = {L["Zones"], L["Dungeons"], L["Various"], L["New Tracks"], L["Random"], L["Search"], L["Movies"]} -- Added L["New Tracks"]
	for k, v in ipairs(ZoneList) do
		ZoneList[v] = {}
	end

	-- Function to create a table for each zone
	local function Zn(where, category, zone, tracklist)
		tinsert(ZoneList[where], {category = category, zone = zone, tracks = tracklist})
	end

	-- Debug
	-- Zn(L["Zones"], L["Eastern Kingdoms"], "Debug3", {"|cffffd800" .. L["Zones"] .. ": Debug2", "spells/absorbgethita.ogg#1", "spells/absorbgethitb.ogg#1",})

	----------------------------------------------------------------------
	-- Zones
	----------------------------------------------------------------------

	-- Zones: Eastern Kingdoms (Updated)
	Zn(L["Zones"], L["Eastern Kingdoms"], "|cffffd800" .. L["Eastern Kingdoms"], {""})
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Alterac Mountains"]					, {"|cffffd800" .. L["Zones"] .. ": " .. L["Alterac Mountains"], prefol, "zonemusic/forest/dayforest01.mp3#55", "zonemusic/forest/dayforest02.mp3#72", "zonemusic/forest/dayforest03.mp3#64", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64", "zonemusic/cursedland/cursedland01.mp3#54", "zonemusic/cursedland/cursedland02.mp3#58", "zonemusic/cursedland/cursedland03.mp3#64", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74", "musical moments/battle/battle06.mp3#62"})
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Arathi Highlands"]					, {"|cffffd800" .. L["Zones"] .. ": " .. L["Arathi Highlands"], prefol, "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "zonemusic/mountain/daymountain01.mp3#120", "zonemusic/mountain/daymountain02.mp3#67", "zonemusic/mountain/daymountain03.mp3#80", "zonemusic/mountain/nightmountain01.mp3#64", "zonemusic/mountain/nightmountain02.mp3#63", "zonemusic/mountain/nightmountain03.mp3#69", "zonemusic/mountain/nightmountain04.mp3#64", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64", "citymusic/orgrimmar/orgrimmar01-zone.mp3#68", "citymusic/orgrimmar/orgrimmar02-zone.mp3#62", "musical moments/haunted/haunted01.mp3#62", "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74", "musical moments/battle/battle05.mp3#44", "musical moments/gloomy/gloomy01.mp3#36", "citymusic/stormwind/stormwind08-zone.mp3#77"}) -- Mystery1:10
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Badlands"]							, {"|cffffd800" .. L["Zones"] .. ": " .. L["Badlands"], prefol, "zonemusic/barrendry/daybarrendry01.mp3#64", "zonemusic/barrendry/daybarrendry02.mp3#64", "zonemusic/barrendry/daybarrendry03.mp3#55", "zonemusic/barrendry/nightbarrendry01.mp3#67", "zonemusic/barrendry/nightbarrendry02.mp3#41", "zonemusic/barrendry/nightbarrendry03.mp3#47", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64"})
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Blasted Lands"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Blasted Lands"], prefol, "zonemusic/barrendry/daybarrendry01.mp3#64", "zonemusic/barrendry/daybarrendry02.mp3#64", "zonemusic/barrendry/daybarrendry03.mp3#55", "zonemusic/barrendry/nightbarrendry01.mp3#67", "zonemusic/barrendry/nightbarrendry02.mp3#41", "zonemusic/barrendry/nightbarrendry03.mp3#47", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74", "musical moments/battle/battle06.mp3#62"})
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Burning Steppes"]					, {"|cffffd800" .. L["Zones"] .. ": " .. L["Burning Steppes"], prefol, "citymusic/orgrimmar/orgrimmar01-zone.mp3#68", "citymusic/orgrimmar/orgrimmar02-zone.mp3#62", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74"}) -- Mystery1:10
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Deadwind Pass"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Deadwind Pass"], prefol, "zonemusic/evilforest/dayevilforest01.mp3#70", "zonemusic/evilforest/dayevilforest02.mp3#72", "zonemusic/evilforest/dayevilforest03.mp3#70", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "musical moments/haunted/haunted01.mp3#62", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64"}) -- Mystery1:10
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Dun Morogh"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Dun Morogh"], prefol, "zonemusic/mountain/daymountain01.mp3#120", "zonemusic/mountain/daymountain02.mp3#67", "zonemusic/mountain/daymountain03.mp3#80", "zonemusic/mountain/nightmountain01.mp3#64", "zonemusic/mountain/nightmountain02.mp3#63", "zonemusic/mountain/nightmountain03.mp3#69", "zonemusic/mountain/nightmountain04.mp3#64", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "zonemusic/tavernalliance/tavernalliance01.mp3#47", "zonemusic/tavernalliance/tavernalliance02.mp3#51"}) -- Mystery1:10
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Duskwood"]							, {"|cffffd800" .. L["Zones"] .. ": " .. L["Duskwood"], prefol, "zonemusic/enchantedforest/enchantedforest01.mp3#50", "zonemusic/enchantedforest/enchantedforest02.mp3#67", "zonemusic/enchantedforest/enchantedforest03.mp3#235", "zonemusic/enchantedforest/enchantedforest04.mp3#60", "zonemusic/enchantedforest/enchantedforest05.mp3#70", "zonemusic/evilforest/dayevilforest01.mp3#70", "zonemusic/evilforest/dayevilforest02.mp3#72", "zonemusic/evilforest/dayevilforest03.mp3#70", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64", "zonemusic/cursedland/cursedland01.mp3#54", "zonemusic/cursedland/cursedland03.mp3#64", "musical moments/haunted/haunted01.mp3#62", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74", "citymusic/orgrimmar/orgrimmar02-zone.mp3#62"})
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Eastern Plaguelands"]				, {"|cffffd800" .. L["Zones"] .. ": " .. L["Eastern Plaguelands"], prefol, "zonemusic/cursedland/cursedland01.mp3#54", "zonemusic/cursedland/cursedland03.mp3#64", "citymusic/darnassus/darnassus walking 1.mp3#85", "citymusic/darnassus/darnassus walking 2.mp3#69", "citymusic/darnassus/darnassus walking 3.mp3#67", "musical moments/haunted/haunted01.mp3#62", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "citymusic/undercity/undercity01-zone.mp3#67", "citymusic/undercity/undercity02-zone.mp3#85", "citymusic/undercity/undercity03-zone.mp3#75", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74"}) -- Mystery1:10
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Elwynn Forest"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Elwynn Forest"], prefol, "zonemusic/forest/dayforest01.mp3#55", "zonemusic/forest/dayforest02.mp3#72", "zonemusic/forest/dayforest03.mp3#64", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74", "citymusic/stormwind/stormwind03-moment.mp3#70", "citymusic/stormwind/stormwind07-zone.mp3#87"})
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Eversong Woods"]					, {"|cffffd800" .. L["Zones"] .. ": " .. L["Eversong Woods"], prefol, "zonemusic/eversong/es_ruinswalkday01.mp3#48", "zonemusic/eversong/es_ruinswalkday02.mp3#72", "zonemusic/eversong/es_ruinswalkday03.mp3#70", "zonemusic/eversong/es_sunstriderwalkday01.mp3#80", "zonemusic/eversong/es_sunstriderwalkday02.mp3#58", "zonemusic/eversong/es_sunstriderwalkday03.mp3#67", "zonemusic/eversong/es_ruinswalknight01.mp3#51", "zonemusic/eversong/es_ruinswalknight02.mp3#83", "zonemusic/eversong/es_ruinswalknight03.mp3#67", "zonemusic/eversong/es_sunstriderwalknight01.mp3#100", "zonemusic/eversong/es_sunstriderwalknight02.mp3#100", "zonemusic/eversong/es_sunstriderwalknight03.mp3#86", "zonemusic/eversong/es_buildingwalkday01.mp3#65", "zonemusic/eversong/es_buildingwalkday02.mp3#68", "zonemusic/eversong/es_buildingwalknight01.mp3#84", "zonemusic/eversong/es_buildingwalknight02.mp3#83"})
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Ghostlands"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Ghostlands"], prefol, "zonemusic/eversong/es_buildingwalkday01.mp3#65", "zonemusic/eversong/es_buildingwalkday02.mp3#68", "zonemusic/eversong/es_buildingwalknight01.mp3#84", "zonemusic/eversong/es_buildingwalknight02.mp3#83", "zonemusic/ghostlands/gl_forest1walkday01.mp3#67", "zonemusic/ghostlands/gl_forest1walkday02.mp3#70", "zonemusic/ghostlands/gl_forest2walkday01.mp3#83", "zonemusic/ghostlands/gl_forest1walknight01.mp3#67", "zonemusic/ghostlands/gl_forest2walknight01.mp3#59", "zonemusic/ghostlands/gl_forest2walknight02.mp3#60", "zonemusic/ghostlands/gl_forest3walkday01.mp3#154", "zonemusic/ghostlands/gl_forest3walknight01.mp3#51", "zonemusic/ghostlands/gl_forest3walknight02.mp3#28", "zonemusic/ghostlands/gl_forest3walknight03.mp3#44", "zonemusic/ghostlands/gl_eversongdarkwalkuni01.mp3#62", "zonemusic/ghostlands/gl_eversongdarkwalkuni02.mp3#62", "zonemusic/ghostlands/gl_eversongdarkwalkuni03.mp3#64", "zonemusic/ghostlands/gl_eversongdarkwalkuni04.mp3#60", "zonemusic/ghostlands/gl_shalandiswalkuni01.mp3#131", "zonemusic/ghostlands/gl_shalandiswalkuni02.mp3#104", "zonemusic/ghostlands/gl_shalandiswalkuni03.mp3#67", "zonemusic/zulaman/za_zulaman_amb10.mp3#113", "zonemusic/zulaman/za_zulaman_amb11.mp3#74", "zonemusic/zulaman/za_zulaman_amb12.mp3#108", "zonemusic/zulaman/za_zulaman_amb13.mp3#70", "zonemusic/zulaman/za_zulaman_amb14.mp3#90", "zonemusic/zulaman/za_zulaman_amb15.mp3#113"})
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Hillsbrad Foothills"]				, {"|cffffd800" .. L["Zones"] .. ": " .. L["Hillsbrad Foothills"], prefol, "zonemusic/evilforest/dayevilforest01.mp3#70", "zonemusic/evilforest/dayevilforest02.mp3#72", "zonemusic/evilforest/dayevilforest03.mp3#70", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "zonemusic/forest/dayforest01.mp3#55", "zonemusic/forest/dayforest02.mp3#72", "zonemusic/forest/dayforest03.mp3#64", "zonemusic/cursedland/cursedland01.mp3#54", "zonemusic/cursedland/cursedland03.mp3#64", "zonemusic/forest/nightforest01.mp3#53", "zonemusic/forest/nightforest02.mp3#43", "zonemusic/forest/nightforest03.mp3#59", "zonemusic/forest/nightforest04.mp3#54", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "citymusic/undercity/undercity01-zone.mp3#67", "citymusic/undercity/undercity02-zone.mp3#85", "citymusic/undercity/undercity03-zone.mp3#75", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74"}) -- Mystery1:10
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Hinterlands"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Hinterlands"], prefol, "citymusic/darnassus/darnassus walking 1.mp3#85", "citymusic/darnassus/darnassus walking 2.mp3#69", "citymusic/darnassus/darnassus walking 3.mp3#67", "zonemusic/desert/daydesert01.mp3#65", "zonemusic/desert/daydesert02.mp3#81", "zonemusic/desert/daydesert03.mp3#54", "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57", "zonemusic/enchantedforest/enchantedforest01.mp3#50", "zonemusic/enchantedforest/enchantedforest02.mp3#67", "zonemusic/enchantedforest/enchantedforest03.mp3#235", "zonemusic/enchantedforest/enchantedforest04.mp3#60", "zonemusic/enchantedforest/enchantedforest05.mp3#70", "zonemusic/forest/dayforest01.mp3#55", "zonemusic/forest/dayforest02.mp3#72", "zonemusic/forest/dayforest03.mp3#64", "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74"}) -- Mystery1:10
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Loch Modan"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Loch Modan"], prefol, "zonemusic/forest/dayforest01.mp3#55", "zonemusic/forest/dayforest02.mp3#72", "zonemusic/forest/dayforest03.mp3#64", "citymusic/orgrimmar/orgrimmar01-zone.mp3#68", "citymusic/orgrimmar/orgrimmar02-zone.mp3#62"})
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Redridge Mountains"]				, {"|cffffd800" .. L["Zones"] .. ": " .. L["Redridge Mountains"], prefol, "zonemusic/evilforest/dayevilforest01.mp3#70", "zonemusic/evilforest/dayevilforest02.mp3#72", "zonemusic/evilforest/dayevilforest03.mp3#70", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "zonemusic/forest/dayforest01.mp3#55", "zonemusic/forest/dayforest02.mp3#72", "zonemusic/forest/dayforest03.mp3#64", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "zonemusic/tavernalliance/tavernalliance01.mp3#47", "zonemusic/tavernalliance/tavernalliance02.mp3#51", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74"}) -- Mystery1:10
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Searing Gorge"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Searing Gorge"], prefol, "zonemusic/desert/daydesert01.mp3#65", "zonemusic/desert/daydesert02.mp3#81", "zonemusic/desert/daydesert03.mp3#54", "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57", "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64"}) -- Mystery1:10
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Silverpine Forest"]					, {"|cffffd800" .. L["Zones"] .. ": " .. L["Silverpine Forest"], prefol, "zonemusic/evilforest/dayevilforest01.mp3#70", "zonemusic/evilforest/dayevilforest02.mp3#72", "zonemusic/evilforest/dayevilforest03.mp3#70", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "musical moments/haunted/haunted01.mp3#62", "zonemusic/forest/nightforest01.mp3#53", "zonemusic/forest/nightforest02.mp3#43", "zonemusic/forest/nightforest03.mp3#59", "zonemusic/forest/nightforest04.mp3#54", "zonemusic/cursedland/cursedland01.mp3#54", "zonemusic/cursedland/cursedland03.mp3#64", "musical moments/battle/battle04.mp3#36", "musical moments/battle/battle06.mp3#62"})
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Stranglethorn Vale"]					, {"|cffffd800" .. L["Zones"] .. ": " .. L["Stranglethorn Vale"], prefol, "zonemusic/barrendry/daybarrendry03.mp3#55", "citymusic/orgrimmar/orgrimmar01-zone.mp3#68", "citymusic/thunderbluff/thunderbluff walking 03.mp3#121", "citymusic/orgrimmar/orgrimmar02-zone.mp3#62", "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74", "musical moments/zulgurubvoodoo.mp3#84"}) -- Mystery1:10
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Swamp of Sorrows"]					, {"|cffffd800" .. L["Zones"] .. ": " .. L["Swamp of Sorrows"], prefol, "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74"}) -- Mystery1:10
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Tirisfal Glades"]					, {"|cffffd800" .. L["Zones"] .. ": " .. L["Tirisfal Glades"], prefol, "zonemusic/evilforest/dayevilforest01.mp3#70", "zonemusic/evilforest/dayevilforest02.mp3#72", "zonemusic/evilforest/dayevilforest03.mp3#70", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "musical moments/haunted/haunted01.mp3#62", "zonemusic/tavernhorde/tavernhorde03.mp3#47"})
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Westfall"]							, {"|cffffd800" .. L["Zones"] .. ": " .. L["Westfall"], prefol, "zonemusic/barrendry/daybarrendry01.mp3#64", "zonemusic/barrendry/daybarrendry02.mp3#64", "zonemusic/barrendry/daybarrendry03.mp3#55", "zonemusic/barrendry/nightbarrendry01.mp3#67", "zonemusic/barrendry/nightbarrendry02.mp3#41", "zonemusic/barrendry/nightbarrendry03.mp3#47", "zonemusic/evilforest/dayevilforest01.mp3#70", "zonemusic/evilforest/dayevilforest02.mp3#72", "zonemusic/evilforest/dayevilforest03.mp3#70", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "zonemusic/plains/dayplains01.mp3#53", "zonemusic/plains/dayplains02.mp3#76", "zonemusic/plains/nightplains01.mp3#58", "zonemusic/plains/nightplains02.mp3#68"}) -- Mystery1:10
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Western Plaguelands"]				, {"|cffffd800" .. L["Zones"] .. ": " .. L["Western Plaguelands"], prefol, "zonemusic/cursedland/cursedland01.mp3#54", "zonemusic/cursedland/cursedland03.mp3#64", "musical moments/haunted/haunted01.mp3#62", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64", "musical moments/gloomy/gloomy01.mp3#36", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70"})
	Zn(L["Zones"], L["Eastern Kingdoms"], L["Wetlands"]							, {"|cffffd800" .. L["Zones"] .. ": " .. L["Wetlands"], prefol, "zonemusic/forest/nightforest01.mp3#53", "zonemusic/forest/nightforest02.mp3#43", "zonemusic/forest/nightforest03.mp3#59", "zonemusic/forest/nightforest04.mp3#54", "zonemusic/forest/dayforest01.mp3#55", "zonemusic/forest/dayforest02.mp3#72", "zonemusic/forest/dayforest03.mp3#64", "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "musical moments/haunted/haunted01.mp3#62", "musical moments/haunted/haunted02.mp3#60", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "zonemusic/tavernalliance/tavernalliance01.mp3#47", "zonemusic/tavernalliance/tavernalliance02.mp3#51", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74"}) -- Mystery1:10

	-- Zones: Kalimdor (Updated)
	Zn(L["Zones"], L["Kalimdor"], "|cffffd800"                               , {""})
	Zn(L["Zones"], L["Kalimdor"], "|cffffd800" .. L["Kalimdor"], {""})
	Zn(L["Zones"], L["Kalimdor"], L["Ashenvale"]								, {"|cffffd800" .. L["Zones"] .. ": " .. L["Ashenvale"], prefol, "zonemusic/barrendry/daybarrendry03.mp3#55", "citymusic/orgrimmar/orgrimmar01-zone.mp3#68", "citymusic/thunderbluff/thunderbluff walking 03.mp3#121", "citymusic/orgrimmar/orgrimmar02-zone.mp3#62", "zonemusic/cursedland/cursedland01.mp3#54", "zonemusic/cursedland/cursedland02.mp3#58", "zonemusic/cursedland/cursedland03.mp3#64", "citymusic/darnassus/darnassus walking 1.mp3#85", "citymusic/darnassus/darnassus walking 2.mp3#69", "citymusic/darnassus/darnassus walking 3.mp3#67", "zonemusic/desert/daydesert01.mp3#65", "zonemusic/desert/daydesert02.mp3#81", "zonemusic/desert/daydesert03.mp3#54", "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57", "zonemusic/enchantedforest/enchantedforest01.mp3#50", "zonemusic/enchantedforest/enchantedforest02.mp3#67", "zonemusic/enchantedforest/enchantedforest03.mp3#235", "zonemusic/enchantedforest/enchantedforest04.mp3#60", "zonemusic/enchantedforest/enchantedforest05.mp3#70", "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "musical moments/magic/magic01-zone1.mp3#33", "musical moments/magic/magic01-zone2.mp3#39", "zonemusic/tavernhorde/tavernhorde01.mp3#48", "zonemusic/tavernhorde/tavernhorde02.mp3#39", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74", "musical moments/battle/battle06.mp3#62", "citymusic/darnassus/warrior terrace.mp3#53"}) -- Mystery1:10
	Zn(L["Zones"], L["Kalimdor"], L["Azshara"]									, {"|cffffd800" .. L["Zones"] .. ": " .. L["Azshara"], prefol, "citymusic/darnassus/darnassus walking 1.mp3#85", "citymusic/darnassus/darnassus walking 2.mp3#69", "citymusic/darnassus/darnassus walking 3.mp3#67", "zonemusic/desert/daydesert01.mp3#65", "zonemusic/desert/daydesert02.mp3#81", "zonemusic/desert/daydesert03.mp3#54", "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57", "musical moments/haunted/haunted01.mp3#62", "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "zonemusic/mountain/daymountain01.mp3#120", "zonemusic/mountain/daymountain02.mp3#67", "zonemusic/mountain/daymountain03.mp3#80", "zonemusic/mountain/nightmountain01.mp3#64", "zonemusic/mountain/nightmountain02.mp3#63", "zonemusic/mountain/nightmountain03.mp3#69", "zonemusic/mountain/nightmountain04.mp3#64", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74", "zonemusic/barrendry/daybarrendry03.mp3#55", "citymusic/orgrimmar/orgrimmar01-zone.mp3#68", "citymusic/thunderbluff/thunderbluff walking 03.mp3#121", "citymusic/orgrimmar/orgrimmar02-zone.mp3#62", "musical moments/battle/battle05.mp3#44"}) -- Mystery1:10
	Zn(L["Zones"], L["Kalimdor"], L["Azuremyst Isle"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Azuremyst Isle"], prefol, "zonemusic/azuremyst/ai_nagawalkuni01.mp3#103", "zonemusic/azuremyst/ai_nagawalkuni02.mp3#74", "zonemusic/azuremyst/ai_nagawalkuni03.mp3#150", "zonemusic/azuremyst/ai_nagawalkuni04.mp3#73", "zonemusic/azuremyst/ai_nagawalkuni05.mp3#98", "zonemusic/outlandgeneral/ol_alliancebasewalkuni01.mp3#134", "zonemusic/outlandgeneral/ol_alliancebasewalkuni02.mp3#110", "zonemusic/azuremyst/ai_draeneiwalkuni05.mp3#191", "zonemusic/azuremyst/ai_draeneiwalkuni06.mp3#110", "zonemusic/azuremyst/ai_draeneiwalkuni07r.mp3#110", "zonemusic/azuremyst/ai_draeneiwalkuni08r.mp3#99", "zonemusic/azuremyst/av_draeneiwalkuni02r.mp3#129", "zonemusic/azuremyst/av_draeneiwalkuni03.mp3#188", "zonemusic/azuremyst/av_draeneiwalkuni04.mp3#158", "zonemusic/azuremyst/ai_owlkinwalkuni01.mp3#49", "zonemusic/azuremyst/ai_owlkinwalkuni02.mp3#45"})
	Zn(L["Zones"], L["Kalimdor"], L["Bloodmyst Isle"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Bloodmyst Isle"], prefol, "zonemusic/azuremyst/ai_nagawalkuni01.mp3#103", "zonemusic/azuremyst/ai_nagawalkuni02.mp3#74", "zonemusic/azuremyst/ai_nagawalkuni03.mp3#150", "zonemusic/azuremyst/ai_nagawalkuni04.mp3#73", "zonemusic/azuremyst/ai_nagawalkuni05.mp3#98", "zonemusic/bloodmyst/bi_satyrwalkuni01r.mp3#126", "zonemusic/bloodmyst/bi_satyrwalkuni02.mp3#129", "zonemusic/bloodmyst/bi_satyrwalkuni03.mp3#114", "zonemusic/bloodmyst/bi_satyrwalkuni04.mp3#69", "zonemusic/bloodmyst/bi_satyrwalkuni05.mp3#144"})
	Zn(L["Zones"], L["Kalimdor"], L["Barrens"]									, {"|cffffd800" .. L["Zones"] .. ": " .. L["Barrens"], prefol, "zonemusic/barrendry/daybarrendry01.mp3#64", "zonemusic/barrendry/daybarrendry02.mp3#64", "zonemusic/barrendry/daybarrendry03.mp3#55", "zonemusic/barrendry/nightbarrendry01.mp3#67", "zonemusic/barrendry/nightbarrendry02.mp3#41", "zonemusic/barrendry/nightbarrendry03.mp3#47", "citymusic/orgrimmar/orgrimmar01-zone.mp3#68", "citymusic/thunderbluff/thunderbluff walking 03.mp3#121", "citymusic/orgrimmar/orgrimmar02-zone.mp3#62", "zonemusic/desert/daydesert01.mp3#65", "zonemusic/desert/daydesert02.mp3#81", "zonemusic/desert/daydesert03.mp3#54", "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57", "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "citymusic/thunderbluff/thunderbluff walking 01.mp3#117", "citymusic/thunderbluff/thunderbluff walking 02.mp3#116", "citymusic/undercity/undercity01-zone.mp3#67", "citymusic/undercity/undercity02-zone.mp3#85", "citymusic/undercity/undercity03-zone.mp3#75", "zonemusic/tavernhorde/undead_dance.mp3#25", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64", "musical moments/battle/battle04.mp3#36", "musical moments/battle/battle06.mp3#62"})
	Zn(L["Zones"], L["Kalimdor"], L["Darkshore"]								, {"|cffffd800" .. L["Zones"] .. ": " .. L["Darkshore"], prefol, "zonemusic/forest/nightforest01.mp3#53", "zonemusic/forest/nightforest02.mp3#43", "zonemusic/forest/nightforest03.mp3#59", "zonemusic/forest/nightforest04.mp3#54", "zonemusic/desert/daydesert01.mp3#65", "zonemusic/desert/daydesert02.mp3#81", "zonemusic/desert/daydesert03.mp3#54", "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57", "musical moments/haunted/haunted01.mp3#62", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74"})
	Zn(L["Zones"], L["Kalimdor"], L["Desolace"]									, {"|cffffd800" .. L["Zones"] .. ": " .. L["Desolace"], prefol, "zonemusic/barrendry/daybarrendry01.mp3#64", "zonemusic/barrendry/daybarrendry02.mp3#64", "zonemusic/barrendry/daybarrendry03.mp3#55", "zonemusic/barrendry/nightbarrendry01.mp3#67", "zonemusic/barrendry/nightbarrendry02.mp3#41", "zonemusic/barrendry/nightbarrendry03.mp3#47", "zonemusic/cursedland/cursedland01.mp3#54", "zonemusic/cursedland/cursedland03.mp3#64", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "citymusic/darnassus/darnassus walking 1.mp3#85", "citymusic/darnassus/darnassus walking 2.mp3#69", "citymusic/darnassus/darnassus walking 3.mp3#67", "musical moments/battle/battle05.mp3#44", "musical moments/battle/battle06.mp3#62", "musical moments/gloomy/gloomy01.mp3#36", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "citymusic/thunderbluff/thunderbluff walking 01.mp3#117", "citymusic/thunderbluff/thunderbluff walking 02.mp3#116", "citymusic/thunderbluff/thunderbluff walking 03.mp3#121", "zonemusic/tavernhorde/tavernhorde01.mp3#48", "zonemusic/tavernhorde/tavernhorde02.mp3#39"}) -- Mystery1:10
	Zn(L["Zones"], L["Kalimdor"], L["Durotar"]									, {"|cffffd800" .. L["Zones"] .. ": " .. L["Durotar"], prefol, "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57", "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "citymusic/orgrimmar/orgrimmar01-zone.mp3#68", "citymusic/orgrimmar/orgrimmar02-zone.mp3#62", "zonemusic/tavernhorde/tavernhorde01.mp3#48", "zonemusic/tavernhorde/tavernhorde02.mp3#39", "zonemusic/plains/dayplains01.mp3#53", "zonemusic/plains/dayplains02.mp3#76", "zonemusic/plains/nightplains01.mp3#58", "zonemusic/plains/nightplains02.mp3#68", "citymusic/stormwind/stormwind08-zone.mp3#77"}) -- Mystery1:10
	Zn(L["Zones"], L["Kalimdor"], L["Dustwallow Marsh"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Dustwallow Marsh"], prefol, "zonemusic/forest/nightforest01.mp3#53", "zonemusic/forest/nightforest02.mp3#43", "zonemusic/forest/nightforest03.mp3#59", "zonemusic/forest/nightforest04.mp3#54", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64", "citymusic/stormwind/stormwind01-moment.mp3#54", "citymusic/stormwind/stormwind02-moment.mp3#35", "citymusic/stormwind/stormwind03-moment.mp3#70", "citymusic/stormwind/stormwind04-zone.mp3#62", "citymusic/stormwind/stormwind05-zone.mp3#61", "citymusic/stormwind/stormwind06-zone.mp3#53", "citymusic/stormwind/stormwind07-zone.mp3#87", "citymusic/stormwind/stormwind08-zone.mp3#77", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "citymusic/orgrimmar/orgrimmar02-zone.mp3#62"})
	Zn(L["Zones"], L["Kalimdor"], L["Felwood"]									, {"|cffffd800" .. L["Zones"] .. ": " .. L["Felwood"], prefol, "zonemusic/cursedland/cursedland01.mp3#54", "zonemusic/cursedland/cursedland02.mp3#58", "zonemusic/cursedland/cursedland03.mp3#64", "zonemusic/evilforest/dayevilforest01.mp3#70", "zonemusic/evilforest/dayevilforest02.mp3#72", "zonemusic/evilforest/dayevilforest03.mp3#70", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89"})
	Zn(L["Zones"], L["Kalimdor"], L["Feralas"]									, {"|cffffd800" .. L["Zones"] .. ": " .. L["Feralas"], prefol, "zonemusic/desert/daydesert01.mp3#65", "zonemusic/desert/daydesert02.mp3#81", "zonemusic/desert/daydesert03.mp3#54", "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57", "zonemusic/enchantedforest/enchantedforest01.mp3#50", "zonemusic/enchantedforest/enchantedforest02.mp3#67", "zonemusic/enchantedforest/enchantedforest03.mp3#235", "zonemusic/enchantedforest/enchantedforest04.mp3#60", "zonemusic/enchantedforest/enchantedforest05.mp3#70", "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "citymusic/thunderbluff/thunderbluff walking 01.mp3#117", "citymusic/thunderbluff/thunderbluff walking 02.mp3#116", "citymusic/thunderbluff/thunderbluff walking 03.mp3#121", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74"}) -- Mystery1:10
	Zn(L["Zones"], L["Kalimdor"], L["Moonglade"]								, {"|cffffd800" .. L["Zones"] .. ": " .. L["Moonglade"], prefol, "zonemusic/forest/nightforest01.mp3#53", "zonemusic/forest/nightforest02.mp3#43", "zonemusic/forest/nightforest03.mp3#59", "zonemusic/forest/nightforest04.mp3#54", "zonemusic/evilforest/dayevilforest01.mp3#70", "zonemusic/evilforest/dayevilforest02.mp3#72", "zonemusic/evilforest/dayevilforest03.mp3#70", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "zonemusic/cursedland/cursedland02.mp3#58", "zonemusic/cursedland/cursedland03.mp3#64"})
	Zn(L["Zones"], L["Kalimdor"], L["Mulgore"]									, {"|cffffd800" .. L["Zones"] .. ": " .. L["Mulgore"], prefol, "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57", "zonemusic/plains/dayplains01.mp3#53", "zonemusic/plains/dayplains02.mp3#76", "zonemusic/plains/nightplains01.mp3#58", "zonemusic/plains/nightplains02.mp3#68", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74"})
	Zn(L["Zones"], L["Kalimdor"], L["Silithus"]									, {"|cffffd800" .. L["Zones"] .. ": " .. L["Silithus"], prefol, "zonemusic/desert/daydesert01.mp3#65", "zonemusic/desert/daydesert02.mp3#81", "zonemusic/desert/daydesert03.mp3#54", "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57"}) -- Mystery1:10
	Zn(L["Zones"], L["Kalimdor"], L["Stonetalon Mountains"]					, {"|cffffd800" .. L["Zones"] .. ": " .. L["Stonetalon Mountains"], prefol, "zonemusic/barrendry/daybarrendry01.mp3#64", "zonemusic/barrendry/daybarrendry02.mp3#64", "zonemusic/barrendry/daybarrendry03.mp3#55", "zonemusic/barrendry/nightbarrendry01.mp3#67", "zonemusic/barrendry/nightbarrendry02.mp3#41", "zonemusic/barrendry/nightbarrendry03.mp3#47", "citymusic/orgrimmar/orgrimmar01-zone.mp3#68", "citymusic/thunderbluff/thunderbluff walking 03.mp3#121", "citymusic/orgrimmar/orgrimmar02-zone.mp3#62", "zonemusic/forest/nightforest01.mp3#53", "zonemusic/forest/nightforest02.mp3#43", "zonemusic/forest/nightforest03.mp3#59", "zonemusic/forest/nightforest04.mp3#54", "zonemusic/enchantedforest/enchantedforest01.mp3#50", "zonemusic/enchantedforest/enchantedforest02.mp3#67", "zonemusic/enchantedforest/enchantedforest03.mp3#235", "zonemusic/enchantedforest/enchantedforest04.mp3#60", "zonemusic/enchantedforest/enchantedforest05.mp3#70", "zonemusic/evilforest/dayevilforest01.mp3#70", "zonemusic/evilforest/dayevilforest02.mp3#72", "zonemusic/evilforest/dayevilforest03.mp3#70", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "zonemusic/tavernhorde/tavernhorde01.mp3#48", "zonemusic/tavernhorde/tavernhorde02.mp3#39", "citymusic/thunderbluff/thunderbluff walking 01.mp3#117", "citymusic/thunderbluff/thunderbluff walking 02.mp3#116", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74"})
	Zn(L["Zones"], L["Kalimdor"], L["Tanaris"]									, {"|cffffd800" .. L["Zones"] .. ": " .. L["Tanaris"], prefol, "zonemusic/desert/daydesert01.mp3#65", "zonemusic/desert/daydesert02.mp3#81", "zonemusic/desert/daydesert03.mp3#54", "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57", "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64"})
	Zn(L["Zones"], L["Kalimdor"], L["Teldrassil"]								, {"|cffffd800" .. L["Zones"] .. ": " .. L["Teldrassil"], prefol, "zonemusic/enchantedforest/enchantedforest01.mp3#50", "zonemusic/enchantedforest/enchantedforest02.mp3#67", "zonemusic/enchantedforest/enchantedforest03.mp3#235", "zonemusic/enchantedforest/enchantedforest04.mp3#60", "zonemusic/enchantedforest/enchantedforest05.mp3#70", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "citymusic/darnassus/darnassus walking 1.mp3#85", "citymusic/darnassus/darnassus walking 2.mp3#69", "citymusic/darnassus/darnassus walking 3.mp3#67", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70"}) -- Mystery1:10
	Zn(L["Zones"], L["Kalimdor"], L["Thousand Needles"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Thousand Needles"], prefol, "zonemusic/desert/daydesert01.mp3#65", "zonemusic/desert/daydesert02.mp3#81", "zonemusic/desert/daydesert03.mp3#54", "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "citymusic/thunderbluff/thunderbluff walking 01.mp3#117", "citymusic/thunderbluff/thunderbluff walking 02.mp3#116", "citymusic/thunderbluff/thunderbluff walking 03.mp3#121", "zonemusic/plains/dayplains01.mp3#53", "zonemusic/plains/dayplains02.mp3#76", "zonemusic/plains/nightplains01.mp3#58", "zonemusic/plains/nightplains02.mp3#68"}) -- Mystery1:10
	Zn(L["Zones"], L["Kalimdor"], L["Un'Goro Crater"]							, {"|cffffd800" .. L["Zones"] .. ": " .. L["Un'Goro Crater"], prefol, "zonemusic/desert/daydesert01.mp3#65", "zonemusic/desert/daydesert02.mp3#81", "zonemusic/desert/daydesert03.mp3#54", "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57", "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89"}) -- Mystery1:10
	Zn(L["Zones"], L["Kalimdor"], L["Winterspring"]								, {"|cffffd800" .. L["Zones"] .. ": " .. L["Winterspring"], prefol, "citymusic/darnassus/darnassus walking 1.mp3#85", "citymusic/darnassus/darnassus walking 2.mp3#69", "citymusic/darnassus/darnassus walking 3.mp3#67", "zonemusic/evilforest/dayevilforest01.mp3#70", "zonemusic/evilforest/dayevilforest02.mp3#72", "zonemusic/evilforest/dayevilforest03.mp3#70", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "citymusic/gnomeragon/gnomeragon01-zone.mp3#64", "citymusic/gnomeragon/gnomeragon02-zone.mp3#64", "zonemusic/mountain/daymountain01.mp3#120", "zonemusic/mountain/daymountain02.mp3#67", "zonemusic/mountain/daymountain03.mp3#80", "zonemusic/mountain/nightmountain01.mp3#64", "zonemusic/mountain/nightmountain02.mp3#63", "zonemusic/mountain/nightmountain03.mp3#69", "zonemusic/mountain/nightmountain04.mp3#64", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74", "musical moments/gloomy/gloomy01.mp3#36"}) -- Mystery1:10

	-- Zones: Outland (Updated)
	Zn(L["Zones"], L["Outland"], "|cffffd800"                               , {""})
	Zn(L["Zones"], L["Outland"], "|cffffd800" .. L["Outland"]        , {""})
	Zn(L["Zones"], L["Outland"], L["Blade's Edge Mountains"]				, {"|cffffd800" .. L["Zones"] .. ": " .. L["Blade's Edge Mountains"], prefol, "zonemusic/bladesedge/bl_generalwalkuni01.mp3#80", "zonemusic/bladesedge/bl_generalwalkuni02.mp3#75", "zonemusic/bladesedge/bl_generalwalkuni03.mp3#158", "zonemusic/bladesedge/bl_generalwalkuni04.mp3#110", "zonemusic/bladesedge/bl_generalwalkuni05.mp3#110", "zonemusic/bladesedge/bl_dryforestwalkuni01.mp3#89", "zonemusic/bladesedge/bl_dryforestwalkuni02.mp3#127", "zonemusic/bladesedge/bl_dryforestwalkuni03.mp3#131", "zonemusic/outlandgeneral/ol_hordebasewalkuni03.mp3#66", "zonemusic/outlandgeneral/ol_hordebasewalkuni04.mp3#68", "zonemusic/outlandgeneral/ol_shamanintrouni01.mp3#44", "zonemusic/outlandgeneral/ol_shamanintrouni02.mp3#53"})
	Zn(L["Zones"], L["Outland"], L["Hellfire Peninsula"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Hellfire Peninsula"], prefol, "zonemusic/hellfirepeninsula/he_generalwalkuni01.mp3#130", "zonemusic/hellfirepeninsula/he_generalwalkuni02.mp3#66", "zonemusic/hellfirepeninsula/he_generalwalkuni03.mp3#59", "zonemusic/hellfirepeninsula/he_generalwalkuni04.mp3#96", "zonemusic/hellfirepeninsula/he_generalwalkuni05.mp3#126", "zonemusic/outlandgeneral/ol_hordebasewalkuni03.mp3#66", "zonemusic/outlandgeneral/ol_hordebasewalkuni04.mp3#68", "zonemusic/outlandgeneral/ol_alliancebasewalkuni01.mp3#134", "zonemusic/outlandgeneral/ol_alliancebasewalkuni02.mp3#110", "zonemusic/outlandgeneral/ol_bloodelfbasewalkuni01.mp3#120", "zonemusic/outlandgeneral/ol_bloodelfbasewalkuni02.mp3#121", "zonemusic/outlandgeneral/ol_draeneibasewalkuni01.mp3#106", "zonemusic/outlandgeneral/ol_draeneibasewalkuni02r.mp3#99"})
	Zn(L["Zones"], L["Outland"], L["Nagrand"]									, {"|cffffd800" .. L["Zones"] .. ": " .. L["Nagrand"], prefol, "zonemusic/nagrand/na_generalwalkday01.mp3#72", "zonemusic/nagrand/na_generalwalkday02.mp3#100", "zonemusic/nagrand/na_generalwalkday03.mp3#63", "zonemusic/nagrand/na_generalwalknight01.mp3#88", "zonemusic/nagrand/na_generalwalknight02.mp3#80", "zonemusic/nagrand/na_generalwalknight03.mp3#166", "zonemusic/outlandgeneral/ol_hordebasewalkuni03.mp3#66", "zonemusic/outlandgeneral/ol_hordebasewalkuni04.mp3#68", "zonemusic/outlandgeneral/ol_draeneibasewalkuni01.mp3#106", "zonemusic/outlandgeneral/ol_draeneibasewalkuni02r.mp3#99"})
	Zn(L["Zones"], L["Outland"], L["Netherstorm"]								, {"|cffffd800" .. L["Zones"] .. ": " .. L["Netherstorm"], prefol, "zonemusic/netherstorm/ns_generalwalkuni01.mp3#150", "zonemusic/netherstorm/ns_generalwalkuni02.mp3#175", "zonemusic/netherstorm/ns_generalwalkuni03.mp3#178", "zonemusic/netherstorm/ns_generalwalkuni04.mp3#181", "zonemusic/netherstorm/ns_generalwalkuni05.mp3#184", "zonemusic/netherstorm/ns_generalwalkuni06.mp3#192", "zonemusic/netherstorm/ns_generalwalkuni07.mp3#193", "zonemusic/netherstorm/ns_generalwalkuni08.mp3#169", "zonemusic/netherstorm/ns_generalwalkuni09.mp3#199", "zonemusic/netherstorm/ns_generalwalkuni10.mp3#223", "zonemusic/outlandgeneral/ol_draeneibasewalkuni01.mp3#106", "zonemusic/outlandgeneral/ol_draeneibasewalkuni02r.mp3#99", "zonemusic/nagrand/na_generalwalkday01.mp3#72", "zonemusic/nagrand/na_generalwalkday02.mp3#100", "zonemusic/outlandgeneral/ol_historicintrouni01.mp3#79", "zonemusic/ghostlands/gl_forest3walknight01.mp3#51", "zonemusic/ghostlands/gl_forest3walknight02.mp3#28", "zonemusic/ghostlands/gl_forest3walknight03.mp3#44"})
	Zn(L["Zones"], L["Outland"], L["Shadowmoon Valley"]							, {"|cffffd800" .. L["Zones"] .. ": " .. L["Shadowmoon Valley"], prefol, "zonemusic/shadowmoonvalley/sv_generalwalkuni01.mp3#67", "zonemusic/shadowmoonvalley/sv_generalwalkuni02.mp3#112", "zonemusic/shadowmoonvalley/sv_generalwalkuni03.mp3#106", "zonemusic/shadowmoonvalley/sv_generalwalkuni04.mp3#93", "zonemusic/shadowmoonvalley/sv_generalwalkuni05.mp3#93", "zonemusic/shadowmoonvalley/sv_generalwalkuni06.mp3#67", "zonemusic/outlandgeneral/ol_hordebasewalkuni03.mp3#66", "zonemusic/outlandgeneral/ol_hordebasewalkuni04.mp3#68", "zonemusic/outlandgeneral/ol_alliancebasewalkuni01.mp3#134", "zonemusic/outlandgeneral/ol_alliancebasewalkuni02.mp3#110", "zonemusic/outlandgeneral/ol_draeneibasewalkuni01.mp3#106", "zonemusic/outlandgeneral/ol_draeneibasewalkuni02r.mp3#99", "zonemusic/blacktemple/bt_arrivalwalkuni02.mp3#81", "zonemusic/blacktemple/bt_arrivalwalkuni03.mp3#74", "zonemusic/blacktemple/bt_illidariwalkuni01.mp3#61", "zonemusic/blacktemple/bt_illidariwalkuni02.mp3#71", "zonemusic/blacktemple/bt_illidariwalkuni03.mp3#78", "zonemusic/blacktemple/bt_illidariwalkuni06.mp3#29", "zonemusic/blacktemple/bt_illidariwalkuni07.mp3#78", "zonemusic/blacktemple/bt_illidariwalkuni08.mp3#65", "zonemusic/blacktemple/bt_sanctuarywalkuni02.mp3#65", "zonemusic/blacktemple/bt_sanctuarywalkuni03.mp3#66"})
	Zn(L["Zones"], L["Outland"], L["Terokkar Forest"]							, {"|cffffd800" .. L["Zones"] .. ": " .. L["Terokkar Forest"], prefol, "zonemusic/terokkar/tf_forestwalkuni01.mp3#150", "zonemusic/terokkar/tf_forestwalkuni02.mp3#190", "zonemusic/terokkar/tf_forestwalkuni03.mp3#187", "zonemusic/outlandgeneral/ol_hordebasewalkuni03.mp3#66", "zonemusic/outlandgeneral/ol_hordebasewalkuni04.mp3#68", "zonemusic/outlandgeneral/ol_alliancebasewalkuni01.mp3#134", "zonemusic/outlandgeneral/ol_alliancebasewalkuni02.mp3#110", "zonemusic/terokkar/tf_bonewalkuni01.mp3#65", "zonemusic/terokkar/tf_bonewalkuni02.mp3#63", "zonemusic/terokkar/tf_bonewalkuni03.mp3#56", "zonemusic/terokkar/tf_bonewalkuni04.mp3#189", "zonemusic/outlandgeneral/ol_draeneibasewalkuni01.mp3#106", "zonemusic/outlandgeneral/ol_draeneibasewalkuni02r.mp3#99", "zonemusic/ghostlands/gl_forest3walknight01.mp3#51", "zonemusic/ghostlands/gl_forest3walknight02.mp3#28", "zonemusic/ghostlands/gl_forest3walknight03.mp3#44"})
	Zn(L["Zones"], L["Outland"], L["Zangarmarsh"]								, {"|cffffd800" .. L["Zones"] .. ": " .. L["Zangarmarsh"], prefol, "zonemusic/zangarmarsh/za_generalwalkuni01.mp3#81", "zonemusic/zangarmarsh/za_generalwalkuni02.mp3#120", "zonemusic/zangarmarsh/za_generalwalkuni03.mp3#59", "zonemusic/zangarmarsh/za_generalwalkuni04.mp3#103", "zonemusic/zangarmarsh/za_generalwalkuni05.mp3#71", "zonemusic/zangarmarsh/za_generalwalkuni06.mp3#89", "zonemusic/outlandgeneral/ol_hordebasewalkuni03.mp3#66", "zonemusic/outlandgeneral/ol_hordebasewalkuni04.mp3#68", "zonemusic/outlandgeneral/ol_draeneibasewalkuni01.mp3#106", "zonemusic/outlandgeneral/ol_draeneibasewalkuni02r.mp3#99"})

	-- Zones: Northrend (Updated)
	Zn(L["Zones"], L["Northrend"], "|cffffd800"                               , {""})
	Zn(L["Zones"], L["Northrend"], "|cffffd800" .. L["Northrend"]       , {""})
	Zn(L["Zones"], L["Northrend"], L["Borean Tundra"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Borean Tundra"], prefol, "zonemusic/boreantundra/bo_coldarrawalkuni01.mp3#64", "zonemusic/boreantundra/bo_coldarrawalkuni02.mp3#63", "zonemusic/boreantundra/bo_coldarrawalkuni03.mp3#124", "zonemusic/boreantundra/bo_generalwalk_day01.mp3#73", "zonemusic/boreantundra/bo_generalwalk_day02.mp3#101", "zonemusic/boreantundra/bo_generalwalk_day03.mp3#78", "zonemusic/boreantundra/bo_generalwalk_day04.mp3#112", "zonemusic/boreantundra/bo_generalwalk_day05.mp3#73", "zonemusic/boreantundra/bo_generalwalk_day06.mp3#115", "zonemusic/boreantundra/bo_generalwalk_day07.mp3#86", "zonemusic/boreantundra/bo_generalwalk_day08.mp3#71", "zonemusic/boreantundra/bo_generalwalk_night01.mp3#73", "zonemusic/boreantundra/bo_generalwalk_night02.mp3#115", "zonemusic/boreantundra/bo_generalwalk_night03.mp3#88", "zonemusic/boreantundra/bo_generalwalk_night04.mp3#70", "zonemusic/boreantundra/bo_generalwalk_night05.mp3#77", "zonemusic/boreantundra/bo_generalwalk_night06.mp3#100", "zonemusic/boreantundra/bo_generalwalk_night07.mp3#78", "zonemusic/boreantundra/bo_generalwalk_night08.mp3#111", "zonemusic/boreantundra/bo_geyserfield_general01.mp3#58", "zonemusic/boreantundra/bo_geyserfield_general02.mp3#48", "zonemusic/boreantundra/bo_geyserfield_general03.mp3#62", "zonemusic/boreantundra/bo_riplash_day01.mp3#151", "zonemusic/boreantundra/bo_riplash_day02.mp3#186", "zonemusic/boreantundra/bo_riplash_day03.mp3#161", "zonemusic/boreantundra/bo_riplash_night01.mp3#159", "zonemusic/boreantundra/bo_riplash_night02.mp3#79", "zonemusic/boreantundra/bo_riplash_night03.mp3#76", "zonemusic/boreantundra/bo_riplash_night04.mp3#95", "zonemusic/boreantundra/bo_tusk_kaskaladay01.mp3#101", "zonemusic/boreantundra/bo_tusk_kaskaladay02.mp3#79", "zonemusic/boreantundra/bo_tusk_kaskalanight01.mp3#99", "zonemusic/boreantundra/bo_tusk_kaskalanight02.mp3#59", "zonemusic/nexus/nz_nexusactionwalkuni01.mp3#76", "zonemusic/nexus/nz_nexusactionwalkuni02.mp3#68", "zonemusic/nexus/nz_nexusactionwalkuni03.mp3#102", "zonemusic/nexus/nz_nexusactionwalkuni04.mp3#107", "zonemusic/nexus/nz_nexusactionwalkuni05.mp3#90", "zonemusic/nexus/nz_nexuspulsewalkuni01.mp3#61", "zonemusic/nexus/nz_nexuspulsewalkuni02.mp3#70", "zonemusic/nexus/nz_nexusquietwalkuni01.mp3#114", "zonemusic/nexus/nz_nexusquietwalkuni02.mp3#111", "zonemusic/nexus/nz_nexusquietwalkuni03.mp3#56", "zonemusic/nexus/nz_nexusquietwalkuni04.mp3#71"})
	Zn(L["Zones"], L["Northrend"], L["Crystalsong Forest"]				, {"|cffffd800" .. L["Zones"] .. ": " .. L["Crystalsong Forest"], prefol, "zonemusic/crystalsong/cs_crystalsongwalkuni01.mp3#113", "zonemusic/crystalsong/cs_crystalsongwalkuni02.mp3#98", "zonemusic/crystalsong/cs_crystalsongwalkuni03.mp3#72", "zonemusic/crystalsong/cs_crystalsongwalkuni04.mp3#113", "zonemusic/crystalsong/cs_crystalsongwalkuni05.mp3#107", "zonemusic/dalaran/dc_generalwalkuni01.mp3#67", "zonemusic/dalaran/dc_generalwalkuni02.mp3#42", "zonemusic/dalaran/dc_generalwalkuni03.mp3#70", "zonemusic/dalaran/dc_generalwalkuni04.mp3#88", "zonemusic/dalaran/dc_sewerwalkuni01.mp3#66", "zonemusic/dalaran/dc_sewerwalkuni02.mp3#101", "zonemusic/dalaran/dc_sewerwalkuni03.mp3#72", "zonemusic/dalaran/dc_sewerwalkuni04.mp3#65", "zonemusic/dalaran/dc_spirewalkuni01.mp3#91"})
	Zn(L["Zones"], L["Northrend"], L["Dragonblight"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Dragonblight"], prefol, "zonemusic/dragonblight/db_generalintro_02.mp3#93", "zonemusic/dragonblight/db_generalintro_03.mp3#92", "zonemusic/dragonblight/db_generalintro_04.mp3#92", "zonemusic/dragonblight/db_generalwalk_day01.mp3#75", "zonemusic/dragonblight/db_generalwalk_day02.mp3#57", "zonemusic/dragonblight/db_generalwalk_day03.mp3#120", "zonemusic/dragonblight/db_generalwalk_day04.mp3#76", "zonemusic/dragonblight/db_generalwalk_day05.mp3#93", "zonemusic/dragonblight/db_generalwalk_day06.mp3#93", "zonemusic/dragonblight/db_generalwalk_day07.mp3#92", "zonemusic/dragonblight/db_generalwalk_day08.mp3#93", "zonemusic/dragonblight/db_generalwalk_night01.mp3#73", "zonemusic/dragonblight/db_generalwalk_night02.mp3#57", "zonemusic/dragonblight/db_generalwalk_night03.mp3#119", "zonemusic/dragonblight/db_generalwalk_night04.mp3#76", "zonemusic/dragonblight/db_generalwalk_night05.mp3#93", "zonemusic/dragonblight/db_generalwalk_night06.mp3#92", "zonemusic/dragonblight/db_generalwalk_night07.mp3#93", "zonemusic/dragonblight/db_generalwalk_night08.mp3#93", "zonemusic/dragonblight/db_tusk_induleday01.mp3#129", "zonemusic/dragonblight/db_tusk_induleday02.mp3#60", "zonemusic/dragonblight/db_tusk_induleday03.mp3#39", "zonemusic/dragonblight/db_tusk_indulenight01.mp3#132", "zonemusic/dragonblight/db_tusk_indulenight02.mp3#64", "zonemusic/dragonblight/db_tusk_indulenight03.mp3#39", "zonemusic/azjolnerub/an_generalintro_01.mp3#62", "zonemusic/azjolnerub/an_generalintro_02.mp3#98", "zonemusic/azjolnerub/an_generalintro_04.mp3#62", "zonemusic/azjolnerub/an_generalintro_05.mp3#76", "zonemusic/azjolnerub/an_generalintro_06.mp3#107", "zonemusic/azjolnerub/an_generalwalk_04.mp3#63", "zonemusic/azjolnerub/an_generalwalk_05.mp3#76", "zonemusic/azjolnerub/an_generalwalk_09.mp3#98", "zonemusic/azjolnerub/an_generalwalk_13.mp3#63", "zonemusic/azjolnerub/an_generalwalk_14.mp3#63", "zonemusic/azjolnerub/an_generalwalk_15.mp3#76", "zonemusic/azjolnerub/an_generalwalk_16.mp3#77", "zonemusic/naxxramas/naxxramasabominationboss1.mp3#61", "zonemusic/naxxramas/naxxramasabominationboss2.mp3#67", "zonemusic/naxxramas/naxxramasabominationwing1.mp3#61", "zonemusic/naxxramas/naxxramasabominationwing2.mp3#66", "zonemusic/naxxramas/naxxramasabominationwing3.mp3#61", "zonemusic/naxxramas/naxxramasfrostwyrm1.mp3#58", "zonemusic/naxxramas/naxxramasfrostwyrm2.mp3#82", "zonemusic/naxxramas/naxxramasfrostwyrm3.mp3#62", "zonemusic/naxxramas/naxxramasfrostwyrm4.mp3#60", "zonemusic/naxxramas/naxxramaskelthuzad1.mp3#95", "zonemusic/naxxramas/naxxramaskelthuzad2.mp3#97", "zonemusic/naxxramas/naxxramaskelthuzad3.mp3#75", "zonemusic/naxxramas/naxxramasplagueboss1.mp3#87", "zonemusic/naxxramas/naxxramasplaguewing1.mp3#88", "zonemusic/naxxramas/naxxramasplaguewing2.mp3#72", "zonemusic/naxxramas/naxxramasplaguewing3.mp3#77", "zonemusic/naxxramas/naxxramasspiderboss1.mp3#60", "zonemusic/naxxramas/naxxramasspiderboss2.mp3#64", "zonemusic/naxxramas/naxxramasspiderwing1.mp3#88", "zonemusic/naxxramas/naxxramasspiderwing2.mp3#67", "zonemusic/naxxramas/naxxramasspiderwing3.mp3#47", "zonemusic/naxxramas/naxxramaswalking1.mp3#102", "zonemusic/naxxramas/naxxramaswalking2.mp3#72", "zonemusic/naxxramas/naxxramaswalking3.mp3#87", "zonemusic/naxxramas/naxxramaswalking4.mp3#82", "zonemusic/naxxramas/naxxramaswalking5.mp3#100", "zonemusic/naxxramas/naxxramaswalking6.mp3#99"})
	Zn(L["Zones"], L["Northrend"], L["Grizzly Hills"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Grizzly Hills"], prefol, "zonemusic/grizzlyhills/gh_generalwalk_a_day01.mp3#94", "zonemusic/grizzlyhills/gh_generalwalk_a_day02.mp3#144", "zonemusic/grizzlyhills/gh_generalwalk_a_day03.mp3#88", "zonemusic/grizzlyhills/gh_generalwalk_a_day04.mp3#95", "zonemusic/grizzlyhills/gh_generalwalk_a_night01.mp3#130", "zonemusic/grizzlyhills/gh_generalwalk_a_night02.mp3#141", "zonemusic/grizzlyhills/gh_generalwalk_b_day01.mp3#107", "zonemusic/grizzlyhills/gh_generalwalk_b_day02.mp3#108", "zonemusic/grizzlyhills/gh_generalwalk_b_night01.mp3#101", "zonemusic/grizzlyhills/gh_generalwalk_b_night02.mp3#116", "zonemusic/grizzlyhills/gh_walkday01.mp3#141", "zonemusic/grizzlyhills/gh_walkday02.mp3#138", "zonemusic/grizzlyhills/gh_walkday03.mp3#238", "zonemusic/grizzlyhills/gh_walkday04.mp3#111", "zonemusic/grizzlyhills/gh_walkday05.mp3#97", "zonemusic/grizzlyhills/gh_walkday06.mp3#155", "zonemusic/grizzlyhills/gh_walkday07.mp3#155", "zonemusic/grizzlyhills/gh_walkday08.mp3#88", "zonemusic/grizzlyhills/gh_walkday09.mp3#88", "zonemusic/grizzlyhills/gh_walknight01.mp3#101", "zonemusic/grizzlyhills/gh_walknight02.mp3#111", "zonemusic/grizzlyhills/gh_walknight03.mp3#99", "zonemusic/grizzlyhills/gh_walknight04.mp3#155", "zonemusic/grizzlyhills/gh_walknight05.mp3#149", "zonemusic/grizzlyhills/gh_walknight06.mp3#133"})
	Zn(L["Zones"], L["Northrend"], L["Howling Fjord"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Howling Fjord"], prefol, "zonemusic/howlingfjord/hf_distwalkuni01.mp3#30", "zonemusic/howlingfjord/hf_distwalkuni02.mp3#47", "zonemusic/howlingfjord/hf_distwalkuni03.mp3#52", "zonemusic/howlingfjord/hf_distwalkuni04.mp3#26", "zonemusic/howlingfjord/hf_distwalkuni05.mp3#22", "zonemusic/howlingfjord/hf_distwalkuni06.mp3#41", "zonemusic/howlingfjord/hf_distwalkuni07.mp3#23", "zonemusic/howlingfjord/hf_generalwalk_day01.mp3#110", "zonemusic/howlingfjord/hf_generalwalk_day02.mp3#75", "zonemusic/howlingfjord/hf_generalwalk_day03.mp3#90", "zonemusic/howlingfjord/hf_generalwalk_day04.mp3#64", "zonemusic/howlingfjord/hf_generalwalk_day05.mp3#124", "zonemusic/howlingfjord/hf_generalwalk_day06.mp3#114", "zonemusic/howlingfjord/hf_generalwalk_day07.mp3#149", "zonemusic/howlingfjord/hf_generalwalk_night01.mp3#106", "zonemusic/howlingfjord/hf_generalwalk_night02.mp3#91", "zonemusic/howlingfjord/hf_generalwalk_night03.mp3#84", "zonemusic/howlingfjord/hf_generalwalk_night04.mp3#157", "zonemusic/howlingfjord/hf_tusk_kamaguaday01.mp3#95", "zonemusic/howlingfjord/hf_tusk_kamaguaday02.mp3#54", "zonemusic/howlingfjord/hf_tusk_kamaguanight01.mp3#99", "zonemusic/howlingfjord/hf_tusk_kamaguanight02.mp3#80", "zonemusic/utgarde keep/uk_quietwalkuni01.mp3#108", "zonemusic/utgarde keep/uk_quietwalkuni02.mp3#107"})
	Zn(L["Zones"], L["Northrend"], L["Icecrown"]							, {"|cffffd800" .. L["Zones"] .. ": " .. L["Icecrown"], prefol, "zonemusic/icecrownglacier/ic_generalwalk_day01.mp3#75", "zonemusic/icecrownglacier/ic_generalwalk_day02.mp3#101", "zonemusic/icecrownglacier/ic_generalwalk_day03.mp3#62", "zonemusic/icecrownglacier/ic_generalwalk_day04.mp3#98", "zonemusic/icecrownglacier/ic_generalwalk_night01.mp3#99", "zonemusic/icecrownglacier/ic_generalwalk_night02.mp3#81", "zonemusic/icecrownglacier/ic_generalwalk_night03.mp3#94", "zonemusic/icecrownglacier/ic_generalwalk_night04.mp3#64", "zonemusic/icecrownglacier/ic_generalwalk_night05.mp3#102", "zonemusic/icecrownraid/ir_icefortress2.mp3#105", "zonemusic/icecrownraid/ir_icefortress3.mp3#80", "zonemusic/icecrownraid/ir_icefortress4.mp3#106", "zonemusic/icecrownraid/ir_reflectedhalls1.mp3#60", "zonemusic/icecrownraid/ir_reflectedhalls2.mp3#75", "zonemusic/icecrownraid/ir_reflectedhalls3.mp3#67", "zonemusic/icecrownraid/ir_reflectedhalls4.mp3#129", "zonemusic/icecrownraid/ir_reflectedhalls5.mp3#59", "zonemusic/argenttournament/at_tourney01nightwalk.mp3#156", "zonemusic/argenttournament/at_tourney02daywalk.mp3#157", "zonemusic/argenttournament/at_tourney03nightwalkuniwalk.mp3#162", "zonemusic/argenttournament/at_tourney05nightwalk.mp3#164", "zonemusic/argenttournament/at_tourney06daywalk.mp3#144", "zonemusic/argenttournament/at_tourney07nightwalk.mp3#185", "zonemusic/argenttournament/at_tourney08nightwalk.mp3#189", "zonemusic/argenttournament/at_tourney09daywalk.mp3#151", "zonemusic/argenttournament/at_tourney10daywalk.mp3#151"})
	Zn(L["Zones"], L["Northrend"], L["Sholazar Basin"]					, {"|cffffd800" .. L["Zones"] .. ": " .. L["Sholazar Basin"], prefol, "zonemusic/sholazarbasin/sb_crystalswalkuni01.mp3#130", "zonemusic/sholazarbasin/sb_crystalswalkuni02.mp3#143", "zonemusic/sholazarbasin/sb_firewalkuni01.mp3#107", "zonemusic/sholazarbasin/sb_firewalkuni02.mp3#93", "zonemusic/sholazarbasin/sb_firewalkuni03.mp3#57", "zonemusic/sholazarbasin/sb_firewalkuni04.mp3#107", "zonemusic/sholazarbasin/sb_makersterracewalkuni01.mp3#75", "zonemusic/sholazarbasin/sb_makersterracewalkuni02.mp3#94", "zonemusic/sholazarbasin/sb_pathoflifewardenwalkuni01.mp3#136", "zonemusic/sholazarbasin/sb_pathoflifewardenwalkuni02.mp3#161", "zonemusic/sholazarbasin/sb_sholazarwalkday01.mp3#175",	"zonemusic/sholazarbasin/sb_sholazarwalkday02.mp3#114", "zonemusic/sholazarbasin/sb_sholazarwalkday03.mp3#105", "zonemusic/sholazarbasin/sb_sholazarwalkday04.mp3#112", "zonemusic/sholazarbasin/sb_sholazarwalkday05.mp3#123", "zonemusic/sholazarbasin/sb_sholazarwalkday06.mp3#142", "zonemusic/sholazarbasin/sb_sholazarwalknight01.mp3#115", "zonemusic/sholazarbasin/sb_sholazarwalknight02.mp3#137", "zonemusic/sholazarbasin/sb_sholazarwalknight03.mp3#132", "zonemusic/sholazarbasin/sb_sholazarwalknight04.mp3#91", "zonemusic/sholazarbasin/sb_sholazarwalknight05.mp3#99"})
	Zn(L["Zones"], L["Northrend"], L["Storm Peaks"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Storm Peaks"], prefol, "zonemusic/stormpeaks/sp_generalwalka_day01.mp3#86", "zonemusic/stormpeaks/sp_generalwalka_night01.mp3#88", "zonemusic/stormpeaks/sp_generalwalkadark_uni01.mp3#120", "zonemusic/stormpeaks/sp_generalwalkb_day02.mp3#82", "zonemusic/stormpeaks/sp_generalwalkb_night02.mp3#82", "zonemusic/stormpeaks/sp_generalwalkb_uni02.mp3#82", "zonemusic/stormpeaks/sp_generalwalkc_day03.mp3#64", "zonemusic/stormpeaks/sp_generalwalkc_night03.mp3#58", "zonemusic/stormpeaks/sp_generalwalkc_uni03.mp3#58", "zonemusic/stormpeaks/sp_generalwalkd_day04.mp3#55", "zonemusic/stormpeaks/sp_generalwalkd_night04.mp3#52", "zonemusic/stormpeaks/sp_generalwalkd_uni04.mp3#54", "zonemusic/stormpeaks/sp_generalwalke_day05.mp3#83", "zonemusic/stormpeaks/sp_generalwalke_night05.mp3#74", "zonemusic/stormpeaks/sp_generalwalke_uni05.mp3#83", "zonemusic/ulduar/ul_lightningbattlewalk.mp3#52", "zonemusic/ulduar/ul_stonegeneralwalk02.mp3#40", "zonemusic/ulduarraidext/ur_ulduarraidextwalk01.mp3#36", "zonemusic/ulduarraidext/ur_ulduarraidextwalk02.mp3#33", "zonemusic/ulduarraidext/ur_ulduarraidextwalk09.mp3#27", "zonemusic/ulduarraidext/ur_ulduarraidextwalk10.mp3#28"})
	Zn(L["Zones"], L["Northrend"], L["Wintergrasp"]						, {"|cffffd800" .. L["Zones"] .. ": " .. L["Wintergrasp"], prefol, "zonemusic/lakewintergrasp/wg_generalwalk_01.mp3#92", "zonemusic/lakewintergrasp/wg_generalwalk_02.mp3#62", "zonemusic/lakewintergrasp/wg_generalwalk_03.mp3#92", "zonemusic/lakewintergrasp/wg_generalwalk_04.mp3#43", "zonemusic/lakewintergrasp/wg_generalwalk_05.mp3#57"})
	Zn(L["Zones"], L["Northrend"], L["Zul'Drak"]							, {"|cffffd800" .. L["Zones"] .. ": " .. L["Zul'Drak"], prefol, "zonemusic/zuldrak/zd_generalwalk_day01.mp3#89", "zonemusic/zuldrak/zd_generalwalk_day02.mp3#90", "zonemusic/zuldrak/zd_generalwalk_day03.mp3#101", "zonemusic/zuldrak/zd_generalwalk_day04.mp3#92", "zonemusic/zuldrak/zd_generalwalk_night01.mp3#90", "zonemusic/zuldrak/zd_generalwalk_night02.mp3#90", "zonemusic/zuldrak/zd_generalwalk_night03.mp3#101", "zonemusic/zuldrak/zd_generalwalk_night04.mp3#93", "zonemusic/zuldrak/zd_mamtoth_intro01.mp3#30", "zonemusic/zuldrak/zd_mamtoth_intro02.mp3#27", "zonemusic/zuldrak/zd_quetzlun_intro01.mp3#32", "zonemusic/zuldrak/zd_quetzlun_intro02.mp3#27", "zonemusic/zuldrak/zd_rhunok_intro01.mp3#30", "zonemusic/zuldrak/zd_rhunok_intro02.mp3#27", "zonemusic/zuldrak/zd_sseratus_intro01.mp3#28", "zonemusic/zuldrak/zd_sseratus_intro02.mp3#27"})

	-- Dungeons: World of Warcraft (Updated)
	Zn(L["Dungeons"], L["World of Warcraft"], "|cffffd800" .. L["World of Warcraft"], {""})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Ahn'Qiraj"]							, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Ahn'Qiraj"], prefol, "zonemusic/ahnqiraj/ahnqirajexteriorwalking1.mp3#67", "zonemusic/ahnqiraj/ahnqirajexteriorwalking2.mp3#84", "zonemusic/ahnqiraj/ahnqirajexteriorwalking3.mp3#58", "zonemusic/ahnqiraj/ahnqirajexteriorwalking4.mp3#59"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Blackfathom Deeps"]					, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Blackfathom Deeps"], prefol, "zonemusic/desert/daydesert01.mp3#65", "zonemusic/desert/daydesert02.mp3#81", "zonemusic/desert/daydesert03.mp3#54", "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Blackrock Depths"]					, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Blackrock Depths"], prefol, "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Blackwing Lair"]					, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Blackwing Lair"], prefol, "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Deadmines"]							, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Deadmines"], prefol, "citymusic/orgrimmar/orgrimmar01-zone.mp3#68", "citymusic/orgrimmar/orgrimmar02-zone.mp3#62", "zonemusic/cursedland/cursedland01.mp3#54", "zonemusic/cursedland/cursedland03.mp3#64", "musical moments/battle/battle02.mp3#62", "musical moments/battle/battle06.mp3#62", "citymusic/orgrimmar/orgrimmar02-moment.mp3#62", "musical moments/spooky/spooky01-moment.mp3#25"}) -- Mystery1:10
	Zn(L["Dungeons"], L["World of Warcraft"], L["Dire Maul"]							, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Dire Maul"], prefol, "zonemusic/enchantedforest/enchantedforest01.mp3#50", "zonemusic/enchantedforest/enchantedforest02.mp3#67", "zonemusic/enchantedforest/enchantedforest03.mp3#235", "zonemusic/enchantedforest/enchantedforest04.mp3#60", "zonemusic/enchantedforest/enchantedforest05.mp3#70", "musical moments/spooky/spooky01-moment.mp3#25", "musical moments/gloomy/gloomy01.mp3#36"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Gnomeregan"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Gnomeregan"], prefol, "citymusic/gnomeragon/gnomeragon01-zone.mp3#64", "citymusic/gnomeragon/gnomeragon02-zone.mp3#64"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Maraudon"]							, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Maraudon"], prefol, "zonemusic/barrendry/daybarrendry01.mp3#64", "zonemusic/barrendry/daybarrendry02.mp3#64", "zonemusic/barrendry/daybarrendry03.mp3#55", "zonemusic/barrendry/nightbarrendry01.mp3#67", "zonemusic/barrendry/nightbarrendry02.mp3#41", "zonemusic/barrendry/nightbarrendry03.mp3#47", "zonemusic/soggyplace/soggyplace-zone2.mp3#97", "zonemusic/soggyplace/soggyplace-zone5.mp3#70", "zonemusic/soggyplace/soggyplace-zone1.mp3#97", "zonemusic/soggyplace/soggyplace-zone3.mp3#90", "zonemusic/soggyplace/soggyplace-zone4.mp3#89", "musical moments/battle/battle02.mp3#62"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Molten Core"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Molten Core"], prefol, "musical moments/battle/battle01.mp3#48", "musical moments/battle/battle02.mp3#62", "musical moments/battle/battle03.mp3#27", "musical moments/battle/battle04.mp3#36", "musical moments/battle/battle05.mp3#44", "musical moments/battle/battle06.mp3#62"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Naxxramas"]							, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Naxxramas"], prefol, "zonemusic/naxxramas/naxxramaswalking1.mp3#102", "zonemusic/naxxramas/naxxramaswalking2.mp3#72", "zonemusic/naxxramas/naxxramaswalking3.mp3#87", "zonemusic/naxxramas/naxxramaswalking4.mp3#82", "zonemusic/naxxramas/naxxramaswalking5.mp3#100", "zonemusic/naxxramas/naxxramaswalking6.mp3#99", "zonemusic/naxxramas/naxxramasabominationboss1.mp3#61", "zonemusic/naxxramas/naxxramasabominationboss2.mp3#67", "zonemusic/naxxramas/naxxramasabominationwing1.mp3#61", "zonemusic/naxxramas/naxxramasabominationwing2.mp3#66", "zonemusic/naxxramas/naxxramasabominationwing3.mp3#61", "zonemusic/naxxramas/naxxramasspiderwing1.mp3#88", "zonemusic/naxxramas/naxxramasspiderwing2.mp3#67", "zonemusic/naxxramas/naxxramasspiderwing3.mp3#47", "zonemusic/naxxramas/naxxramasplagueboss1.mp3#87", "zonemusic/naxxramas/naxxramasplaguewing1.mp3#88", "zonemusic/naxxramas/naxxramasplaguewing2.mp3#72", "zonemusic/naxxramas/naxxramasplaguewing3.mp3#77", "zonemusic/naxxramas/naxxramasspiderboss1.mp3#60", "zonemusic/naxxramas/naxxramasspiderboss2.mp3#64", "zonemusic/naxxramas/naxxramaskelthuzad1.mp3#95", "zonemusic/naxxramas/naxxramaskelthuzad2.mp3#97", "zonemusic/naxxramas/naxxramaskelthuzad3.mp3#75", "zonemusic/naxxramas/naxxramasfrostwyrm1.mp3#58", "zonemusic/naxxramas/naxxramasfrostwyrm2.mp3#82", "zonemusic/naxxramas/naxxramasfrostwyrm3.mp3#62", "zonemusic/naxxramas/naxxramasfrostwyrm4.mp3#60"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Onyxia's Lair"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Onyxia's Lair"], prefol, "zonemusic/barrendry/daybarrendry03.mp3#55"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Razorfen Downs"]					, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Razorfen Downs"], prefol, "citymusic/undercity/undercity01-zone.mp3#67", "citymusic/undercity/undercity02-zone.mp3#85", "citymusic/undercity/undercity03-zone.mp3#75", "zonemusic/tavernhorde/undead_dance.mp3#25"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Scarlet Monastery"]				, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Scarlet Monastery"], prefol, "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Scholomance"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Scholomance"], prefol, "musical moments/haunted/haunted01.mp3#62"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Shadowfang Keep"]					, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Shadowfang Keep"], prefol, "zonemusic/evilforest/dayevilforest01.mp3#70", "zonemusic/evilforest/dayevilforest02.mp3#72", "zonemusic/evilforest/dayevilforest03.mp3#70", "zonemusic/evilforest/nightevilforest01.mp3#57", "zonemusic/evilforest/nightevilforest02.mp3#75", "zonemusic/evilforest/nightevilforest03.mp3#70", "musical moments/battle/battle01.mp3#48", "musical moments/battle/battle02.mp3#62", "musical moments/battle/battle04.mp3#36"}) -- Mystery1:10
	-- Zn(L["Dungeons"], L["World of Warcraft"], L["Stockade"]						, {	"|cffffd800" .. L["Dungeons"] .. ": " .. L["Stockade"], prefol, "sound/ambience/wmoambience/stormwindjail.ogg#537412",}) -- Cannot play because it is an ogg file
	Zn(L["Dungeons"], L["World of Warcraft"], L["Stratholme"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Stratholme"], prefol, "citymusic/undercity/undercity01-zone.mp3#67", "citymusic/undercity/undercity02-zone.mp3#85", "citymusic/undercity/undercity03-zone.mp3#75"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Temple of Atal'Hakkar"]			, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Temple of Atal'Hakkar"], prefol, "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Uldaman"]							, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Uldaman"], prefol, "zonemusic/volcanic/dayvolcanic01.mp3#73", "zonemusic/volcanic/dayvolcanic02.mp3#87", "zonemusic/volcanic/nightvolcanic01.mp3#71", "zonemusic/volcanic/nightvolcanic02.mp3#64", "musical moments/battle/battle02.mp3#62"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Wailing Caverns"]					, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Wailing Caverns"], prefol, "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Zul'Farrak"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Zul'Farrak"], prefol, "zonemusic/desert/daydesert01.mp3#65", "zonemusic/desert/daydesert02.mp3#81", "zonemusic/desert/daydesert03.mp3#54", "zonemusic/desert/nightdesert01.mp3#77", "zonemusic/desert/nightdesert02.mp3#62", "zonemusic/desert/nightdesert03.mp3#57"})
	Zn(L["Dungeons"], L["World of Warcraft"], L["Zul'Gurub"]							, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Zul'Gurub"], prefol, "zonemusic/jungle/dayjungle01.mp3#46", "zonemusic/jungle/dayjungle02.mp3#98", "zonemusic/jungle/dayjungle03.mp3#48", "zonemusic/jungle/nightjungle01.mp3#54", "zonemusic/jungle/nightjungle02.mp3#53", "zonemusic/jungle/nightjungle03.mp3#89", "musical moments/zulgurubvoodoo.mp3#84"})
	-- Zn(L["Dungeons"], L["World of Warcraft"], L["Ragefire Chasm"]					, {	"|cffffd800" .. L["Dungeons"] .. ": " .. L["Ragefire Chasm"], prefol, })
	-- Zn(L["Dungeons"], L["World of Warcraft"], L["Razorfen Kraul"]					, {	"|cffffd800" .. L["Dungeons"] .. ": " .. L["Razorfen Kraul"], prefol, })

	-- Dungeons: Burning Crusade (Updated)
	Zn(L["Dungeons"], L["Burning Crusade"], "|cffffd800"                               , {""})
	Zn(L["Dungeons"], L["Burning Crusade"], "|cffffd800" .. L["Burning Crusade"], {""})
	Zn(L["Dungeons"], L["Burning Crusade"], L["Black Morass"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Black Morass"], prefol, "zonemusic/cavernsoftime/ct_morasswalkuni01.mp3#108", "zonemusic/cavernsoftime/ct_morasswalkuni02.mp3#80", "zonemusic/cavernsoftime/ct_morasswalkuni03.mp3#114", "zonemusic/cavernsoftime/ct_morasswalkuni04.mp3#123", "zonemusic/cavernsoftime/ct_morasswalkuni05.mp3#73"})
	Zn(L["Dungeons"], L["Burning Crusade"], L["Black Temple"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Black Temple"], prefol, "zonemusic/blacktemple/bt_arrivalwalkuni02.mp3#81", "zonemusic/blacktemple/bt_arrivalwalkuni03.mp3#74", "zonemusic/blacktemple/bt_illidariwalkuni01.mp3#61", "zonemusic/blacktemple/bt_illidariwalkuni02.mp3#71", "zonemusic/blacktemple/bt_illidariwalkuni03.mp3#78", "zonemusic/blacktemple/bt_illidariwalkuni06.mp3#29", "zonemusic/blacktemple/bt_illidariwalkuni07.mp3#78", "zonemusic/blacktemple/bt_illidariwalkuni08.mp3#65", "zonemusic/blacktemple/bt_sanctuarywalkuni02.mp3#65", "zonemusic/blacktemple/bt_sanctuarywalkuni03.mp3#66"})
	Zn(L["Dungeons"], L["Burning Crusade"], L["Coilfang Reservoir"]				, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Coilfang Reservoir"], prefol, "zonemusic/zangarmarsh/za_coilfangwalkuni01.mp3#133", "zonemusic/zangarmarsh/za_coilfangwalkuni02.mp3#99", "zonemusic/zangarmarsh/za_coilfangwalkuni03.mp3#109"})
	Zn(L["Dungeons"], L["Burning Crusade"], L["Hellfire Ramparts"]					, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Hellfire Ramparts"], prefol, "zonemusic/hellfirepeninsula/he_rampartswalkuni01.mp3#62", "zonemusic/hellfirepeninsula/he_rampartswalkuni02.mp3#69"})
	Zn(L["Dungeons"], L["Burning Crusade"], L["Hyjal Summit"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Hyjal Summit"], prefol, "zonemusic/cavernsoftime/ct_hyjalextwalkuni01.mp3#69", "zonemusic/cavernsoftime/ct_hyjalextwalkuni02.mp3#48", "zonemusic/cavernsoftime/ct_hyjalextwalkuni03.mp3#45", "zonemusic/cavernsoftime/ct_hyjalextwalkuni04.mp3#85", "zonemusic/cavernsoftime/ct_hyjalextwalkuni05.mp3#47", "zonemusic/cavernsoftime/ct_hyjalextwalkuni06.mp3#46", "zonemusic/cavernsoftime/ct_hyjalextwalkuni11.mp3#49", "zonemusic/cavernsoftime/ct_hyjalextwalkuni12.mp3#67", "zonemusic/cavernsoftime/ct_hyjalextwalkuni10.mp3#66"})
	Zn(L["Dungeons"], L["Burning Crusade"], L["Karazhan"]							, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Karazhan"], prefol, "zonemusic/karazhan/ka_generalwalkuni01.mp3#130", "zonemusic/karazhan/ka_generalwalkuni02.mp3#123", "zonemusic/karazhan/ka_generalwalkuni03.mp3#119", "zonemusic/karazhan/ka_generalwalkuni04.mp3#112", "zonemusic/karazhan/ka_generalwalkuni05.mp3#125", "zonemusic/karazhan/ka_generalwalkuni06.mp3#92", "zonemusic/karazhan/ka_generalwalkuni07.mp3#81", "zonemusic/karazhan/ka_foyerwalkuni01.mp3#113", "zonemusic/karazhan/ka_foyerwalkuni02.mp3#112", "zonemusic/karazhan/ka_foyerwalkuni03.mp3#124", "zonemusic/karazhan/ka_foyerwalkuni04.mp3#31", "zonemusic/karazhan/ka_stablewalkuni01.mp3#96", "zonemusic/karazhan/ka_stablewalkuni02.mp3#111", "zonemusic/karazhan/ka_stablewalkuni03.mp3#114", "zonemusic/karazhan/ka_operaharpsiwalkuni01.mp3#82", "zonemusic/karazhan/ka_operaorganwalkuni01.mp3#80", "zonemusic/karazhan/ka_backstagewalkuni01.mp3#98", "zonemusic/karazhan/ka_backstagewalkuni02.mp3#98", "zonemusic/karazhan/ka_librarywalkuni01.mp3#128", "zonemusic/karazhan/ka_librarywalkuni02.mp3#147", "zonemusic/karazhan/ka_librarywalkuni03.mp3#126", "zonemusic/karazhan/ka_librarywalkuni04.mp3#124", "zonemusic/karazhan/ka_towerwalkuni01.mp3#94", "zonemusic/karazhan/ka_towerwalkuni02.mp3#115", "zonemusic/karazhan/ka_towerwalkuni03.mp3#127", "zonemusic/karazhan/ka_malchezarwalkuni01.mp3#124", "zonemusic/karazhan/ka_malchezarwalkuni02.mp3#112", "zonemusic/karazhan/ka_malchezarwalkuni03.mp3#114"})
	Zn(L["Dungeons"], L["Burning Crusade"], L["Magisters' Terrace"]				, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Magisters' Terrace"], prefol, "zonemusic/eversong/es_silvermoonwalkday01.mp3#64", "zonemusic/eversong/es_silvermoonwalkday02.mp3#79", "zonemusic/eversong/es_silvermoonwalkday03.mp3#65", "zonemusic/eversong/es_silvermoonwalknight01.mp3#177", "zonemusic/eversong/es_silvermoonwalknight02.mp3#71", "zonemusic/sunwell/sw_magistersterracewalkuni01.mp3#88", "zonemusic/sunwell/sw_magistersterracewalkuni02.mp3#90", "zonemusic/sunwell/sw_magistersterracewalkuni03.mp3#89", "zonemusic/sunwell/sw_magistersterracewalkuni04.mp3#91", "zonemusic/sunwell/sw_magistersterracewalkuni05.mp3#123", "zonemusic/eversong/es_buildingwalknight01.mp3#84", "zonemusic/eversong/es_buildingwalknight02.mp3#83", "zonemusic/ghostlands/gl_forest2walkday01.mp3#83", "zonemusic/ghostlands/gl_forest2walknight01.mp3#59", "zonemusic/ghostlands/gl_forest2walknight02.mp3#60", "zonemusic/sunwell/sw_assemblychamberwalkuni01.mp3#82", "zonemusic/sunwell/sw_assemblychamberwalkuni02.mp3#88", "zonemusic/sunwell/sw_plateausunwellwalkuni04.mp3#91", "zonemusic/sunwell/sw_plateausunwellwalkuni05.mp3#93", "zonemusic/sunwell/sw_magistersasylumwalkuni01.mp3#97", "zonemusic/sunwell/sw_magistersasylumwalkuni02.mp3#95", "zonemusic/sunwell/sw_magistersasylumwalkuni03.mp3#65", "zonemusic/sunwell/sw_plateausunwellwalkuni02.mp3#78", "zonemusic/sunwell/sw_plateausunwellwalkuni03.mp3#90", "zonemusic/sunwell/sw_plateausunwellwalkuni06.mp3#87", "zonemusic/sunwell/sw_shorelaranwalkuni01.mp3#87"})
	Zn(L["Dungeons"], L["Burning Crusade"], L["Old Hillsbrad Foothills"]			, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Old Hillsbrad Foothills"], prefol, "zonemusic/cavernsoftime/ct_durnholdekeepextwalk1uni.mp3#81", "zonemusic/cavernsoftime/ct_durnholdekeepintwalk1uni.mp3#69", "zonemusic/cavernsoftime/ct_tarrenmillextwalk3uni.mp3#62", "zonemusic/cavernsoftime/ct_hillsbradextwalk1uni.mp3#62", "zonemusic/cavernsoftime/ct_hillsbradextwalk2uni.mp3#56"})
	Zn(L["Dungeons"], L["Burning Crusade"], L["Sunwell Plateau"]					, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Sunwell Plateau"], prefol, "zonemusic/ghostlands/gl_eversongdarkwalkuni01.mp3#62", "zonemusic/ghostlands/gl_eversongdarkwalkuni02.mp3#62", "zonemusic/ghostlands/gl_eversongdarkwalkuni03.mp3#64", "zonemusic/sunwell/sw_magistersterracewalkuni05.mp3#123", "zonemusic/sunwell/sw_plateausunwellwalkuni01.mp3#85", "zonemusic/sunwell/sw_plateausunwellwalkuni02.mp3#78", "zonemusic/sunwell/sw_plateausunwellwalkuni03.mp3#90", "zonemusic/sunwell/sw_plateausunwellwalkuni04.mp3#91", "zonemusic/sunwell/sw_plateausunwellwalkuni05.mp3#93", "zonemusic/sunwell/sw_plateausunwellwalkuni06.mp3#87"})
	Zn(L["Dungeons"], L["Burning Crusade"], L["Tempest Keep"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Tempest Keep"], prefol, "zonemusic/tempestkeep/tk_tempestkeep_amb_11.mp3#46", "zonemusic/tempestkeep/tk_tempestkeep_amb_12.mp3#96", "zonemusic/tempestkeep/tk_tempestkeep_amb_13.mp3#67", "zonemusic/tempestkeep/tk_tempestkeep_amb_14.mp3#88", "zonemusic/tempestkeep/tk_tempestkeep_amb_16.mp3#58", "zonemusic/tempestkeep/tk_tempestkeep_amb_17.mp3#62", "zonemusic/tempestkeep/tk_tempestkeep_amb_18.mp3#85", "zonemusic/tempestkeep/tk_tempestkeep_amb_19.mp3#48", "zonemusic/tempestkeep/tk_tempestkeep_amb_20.mp3#47", "zonemusic/tempestkeep/tk_tempestkeep_amb_23.mp3#67", "zonemusic/tempestkeep/tk_tempestkeep_btl10.mp3#59", "zonemusic/tempestkeep/tk_tempestkeep_btl11.mp3#81", "zonemusic/tempestkeep/tk_tempestkeep_btl13.mp3#36"})

	-- Dungeons: Wrath of the Lich King (Updated & Compacted)
	Zn(L["Dungeons"], L["Wrath of the Lich King"], "|cffffd800"                               , {""})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], "|cffffd800" .. L["Wrath of the Lich King"], {""})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Ahn'kahet (Old Kingdom)"]			, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Ahn'kahet (Old Kingdom)"], prefol, "zonemusic/azjolnerub/an_generalintro_01.mp3#62", "zonemusic/azjolnerub/an_generalintro_02.mp3#98", "zonemusic/azjolnerub/an_generalintro_03.mp3#111", "zonemusic/azjolnerub/an_generalintro_04.mp3#62", "zonemusic/azjolnerub/an_generalintro_05.mp3#76", "zonemusic/azjolnerub/an_generalintro_06.mp3#107", "zonemusic/azjolnerub/an_generalintro_07.mp3#107", "zonemusic/azjolnerub/an_generalintro_08.mp3#104", "zonemusic/azjolnerub/an_generalwalk_01.mp3#61", "zonemusic/azjolnerub/an_generalwalk_02.mp3#98", "zonemusic/azjolnerub/an_generalwalk_03.mp3#110", "zonemusic/azjolnerub/an_generalwalk_04.mp3#63", "zonemusic/azjolnerub/an_generalwalk_05.mp3#76", "zonemusic/azjolnerub/an_generalwalk_06.mp3#104", "zonemusic/azjolnerub/an_generalwalk_07.mp3#62", "zonemusic/azjolnerub/an_generalwalk_08.mp3#62", "zonemusic/azjolnerub/an_generalwalk_09.mp3#98", "zonemusic/azjolnerub/an_generalwalk_10.mp3#98", "zonemusic/azjolnerub/an_generalwalk_11.mp3#111", "zonemusic/azjolnerub/an_generalwalk_12.mp3#110", "zonemusic/azjolnerub/an_generalwalk_13.mp3#63", "zonemusic/azjolnerub/an_generalwalk_14.mp3#63", "zonemusic/azjolnerub/an_generalwalk_15.mp3#76", "zonemusic/azjolnerub/an_generalwalk_16.mp3#77"}) -- Shares music with Azjol-Nerub based on soundkit naming
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Azjol-Nerub"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Azjol-Nerub"], prefol, "zonemusic/azjolnerub/an_generalintro_01.mp3#62", "zonemusic/azjolnerub/an_generalintro_02.mp3#98", "zonemusic/azjolnerub/an_generalintro_03.mp3#111", "zonemusic/azjolnerub/an_generalintro_04.mp3#62", "zonemusic/azjolnerub/an_generalintro_05.mp3#76", "zonemusic/azjolnerub/an_generalintro_06.mp3#107", "zonemusic/azjolnerub/an_generalintro_07.mp3#107", "zonemusic/azjolnerub/an_generalintro_08.mp3#104", "zonemusic/azjolnerub/an_generalwalk_01.mp3#61", "zonemusic/azjolnerub/an_generalwalk_02.mp3#98", "zonemusic/azjolnerub/an_generalwalk_03.mp3#110", "zonemusic/azjolnerub/an_generalwalk_04.mp3#63", "zonemusic/azjolnerub/an_generalwalk_05.mp3#76", "zonemusic/azjolnerub/an_generalwalk_06.mp3#104", "zonemusic/azjolnerub/an_generalwalk_07.mp3#62", "zonemusic/azjolnerub/an_generalwalk_08.mp3#62", "zonemusic/azjolnerub/an_generalwalk_09.mp3#98", "zonemusic/azjolnerub/an_generalwalk_10.mp3#98", "zonemusic/azjolnerub/an_generalwalk_11.mp3#111", "zonemusic/azjolnerub/an_generalwalk_12.mp3#110", "zonemusic/azjolnerub/an_generalwalk_13.mp3#63", "zonemusic/azjolnerub/an_generalwalk_14.mp3#63", "zonemusic/azjolnerub/an_generalwalk_15.mp3#76", "zonemusic/azjolnerub/an_generalwalk_16.mp3#77"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Culling of Stratholme"]			, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Culling of Stratholme"], prefol, "zonemusic/stratholmepast/ct_stratholmepastalleyend.mp3#28", "zonemusic/stratholmepast/ct_stratholmepastalleyintro.mp3#99", "zonemusic/stratholmepast/ct_stratholmepastbattlewalk01.mp3#94", "zonemusic/stratholmepast/ct_stratholmepastbattlewalk02.mp3#36", "zonemusic/stratholmepast/ct_stratholmepastbattlewalk03.mp3#36", "zonemusic/stratholmepast/ct_stratholmepastendstinger.mp3#28", "zonemusic/stratholmepast/ct_stratholmepastindoorsintro.mp3#99", "zonemusic/stratholmepast/ct_stratholmepastintro.mp3#32", "zonemusic/stratholmepast/ct_stratholmepastmalganis.mp3#67", "zonemusic/stratholmepast/ct_stratholmepastoutdoorsintro.mp3#37", "zonemusic/stratholmepast/ct_stratholmepastoutdoorswalkanight.mp3#32", "zonemusic/stratholmepast/ct_stratholmepastoutdoorswalkauni.mp3#32", "zonemusic/stratholmepast/ct_stratholmepastoutdoorswalkbnight.mp3#36", "zonemusic/stratholmepast/ct_stratholmepastoutdoorswalkbuni.mp3#37", "zonemusic/stratholmepast/ct_stratholmepastwalkuni.mp3#102"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Drak'Tharon Keep"]				, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Drak'Tharon Keep"], prefol, "zonemusic/zuldrak/zd_generalintro_01.mp3#98", "zonemusic/zuldrak/zd_generalintro_02.mp3#98", "zonemusic/zuldrak/zd_generalintro_03.mp3#128", "zonemusic/zuldrak/zd_generalintro_04.mp3#126", "zonemusic/zuldrak/zd_generalintro_05.mp3#129", "zonemusic/zuldrak/zd_generalintro_06.mp3#125", "zonemusic/zuldrak/zd_generalwalk_day01.mp3#89", "zonemusic/zuldrak/zd_generalwalk_day02.mp3#90", "zonemusic/zuldrak/zd_generalwalk_day03.mp3#101", "zonemusic/zuldrak/zd_generalwalk_day04.mp3#92", "zonemusic/zuldrak/zd_generalwalk_night01.mp3#90", "zonemusic/zuldrak/zd_generalwalk_night02.mp3#90", "zonemusic/zuldrak/zd_generalwalk_night03.mp3#101", "zonemusic/zuldrak/zd_generalwalk_night04.mp3#93", "zonemusic/zuldrak/zd_harkoa_intro01.mp3#28", "zonemusic/zuldrak/zd_harkoa_intro02.mp3#27", "zonemusic/zuldrak/zd_mamtoth_intro01.mp3#30", "zonemusic/zuldrak/zd_mamtoth_intro02.mp3#27", "zonemusic/zuldrak/zd_quetzlun_intro01.mp3#32", "zonemusic/zuldrak/zd_quetzlun_intro02.mp3#27", "zonemusic/zuldrak/zd_rhunok_intro01.mp3#30", "zonemusic/zuldrak/zd_rhunok_intro02.mp3#27", "zonemusic/zuldrak/zd_sseratus_intro01.mp3#28", "zonemusic/zuldrak/zd_sseratus_intro02.mp3#27"}) -- Soundkits suggest Zul'Drak music
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Eye of Eternity"]					, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Eye of Eternity"], prefol, "zonemusic/nexus/nz_nexusactionwalkuni01.mp3#76", "zonemusic/nexus/nz_nexusactionwalkuni02.mp3#68", "zonemusic/nexus/nz_nexusactionwalkuni03.mp3#102", "zonemusic/nexus/nz_nexusactionwalkuni04.mp3#107", "zonemusic/nexus/nz_nexusactionwalkuni05.mp3#90", "zonemusic/nexus/nz_nexushailwalkuni01.mp3#57", "zonemusic/nexus/nz_nexushailwalkuni02.mp3#65", "zonemusic/nexus/nz_nexuspulsewalkuni01.mp3#61", "zonemusic/nexus/nz_nexuspulsewalkuni02.mp3#70", "zonemusic/nexus/nz_nexusquietwalkuni01.mp3#114", "zonemusic/nexus/nz_nexusquietwalkuni02.mp3#111", "zonemusic/nexus/nz_nexusquietwalkuni03.mp3#56", "zonemusic/nexus/nz_nexusquietwalkuni04.mp3#71"}) -- Shares music with Nexus
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Forge of Souls"]					, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Forge of Souls"], prefol, "zonemusic/icecrownraid/ir_forgeofsouls1.mp3#103", "zonemusic/icecrownraid/ir_forgeofsouls2.mp3#87", "zonemusic/icecrownraid/ir_forgeofsouls3.mp3#97", "zonemusic/icecrownraid/ir_forgeofsouls4.mp3#99", "zonemusic/icecrownraid/ir_bronzejam.mp3#116"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Gundrak"]							, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Gundrak"], prefol, "zonemusic/zuldrak/zd_generalintro_01.mp3#98", "zonemusic/zuldrak/zd_generalintro_02.mp3#98", "zonemusic/zuldrak/zd_generalintro_03.mp3#128", "zonemusic/zuldrak/zd_generalintro_04.mp3#126", "zonemusic/zuldrak/zd_generalintro_05.mp3#129", "zonemusic/zuldrak/zd_generalintro_06.mp3#125", "zonemusic/zuldrak/zd_generalwalk_day01.mp3#89", "zonemusic/zuldrak/zd_generalwalk_day02.mp3#90", "zonemusic/zuldrak/zd_generalwalk_day03.mp3#101", "zonemusic/zuldrak/zd_generalwalk_day04.mp3#92", "zonemusic/zuldrak/zd_generalwalk_night01.mp3#90", "zonemusic/zuldrak/zd_generalwalk_night02.mp3#90", "zonemusic/zuldrak/zd_generalwalk_night03.mp3#101", "zonemusic/zuldrak/zd_generalwalk_night04.mp3#93", "zonemusic/zuldrak/zd_harkoa_intro01.mp3#28", "zonemusic/zuldrak/zd_harkoa_intro02.mp3#27", "zonemusic/zuldrak/zd_mamtoth_intro01.mp3#30", "zonemusic/zuldrak/zd_mamtoth_intro02.mp3#27", "zonemusic/zuldrak/zd_quetzlun_intro01.mp3#32", "zonemusic/zuldrak/zd_quetzlun_intro02.mp3#27", "zonemusic/zuldrak/zd_rhunok_intro01.mp3#30", "zonemusic/zuldrak/zd_rhunok_intro02.mp3#27", "zonemusic/zuldrak/zd_sseratus_intro01.mp3#28", "zonemusic/zuldrak/zd_sseratus_intro02.mp3#27"}) -- Uses Zul'Drak music
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Halls of Lightning"]				, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Halls of Lightning"], prefol, "zonemusic/ulduar/ul_lightningbattlewalk.mp3#52", "zonemusic/ulduar/ul_lightninggeneralwalk01.mp3#33", "zonemusic/ulduar/ul_lightninggeneralwalk02.mp3#40", "zonemusic/ulduar/ul_lightninggeneralwalk03.mp3#35", "zonemusic/ulduar/ul_lightningintro.mp3#82"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Halls of Reflection"]				, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Halls of Reflection"], prefol, "zonemusic/icecrownraid/ir_hallsofreflection.mp3#157", "zonemusic/icecrownraid/ir_hallsofchase.mp3#106", "zonemusic/icecrownraid/ir_reflectedhalls1.mp3#60", "zonemusic/icecrownraid/ir_reflectedhalls2.mp3#75", "zonemusic/icecrownraid/ir_reflectedhalls3.mp3#67", "zonemusic/icecrownraid/ir_reflectedhalls4.mp3#129", "zonemusic/icecrownraid/ir_reflectedhalls5.mp3#59", "zonemusic/icecrownraid/ir_frostmourne1.mp3#103", "zonemusic/icecrownraid/ir_frostmourne2.mp3#103", "zonemusic/icecrownraid/ir_frostmourne3.mp3#103"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Halls of Stone"]					, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Halls of Stone"], prefol, "zonemusic/ulduar/ul_stonebattlewalk.mp3#52", "zonemusic/ulduar/ul_stonegeneralwalk01.mp3#40", "zonemusic/ulduar/ul_stonegeneralwalk02.mp3#40", "zonemusic/ulduar/ul_stonegeneralwalk03.mp3#35", "zonemusic/ulduar/ul_stoneintro.mp3#85", "zonemusic/ulduarraidext/ur_ulduarraidextwalk01.mp3#36", "zonemusic/ulduarraidext/ur_ulduarraidextwalk02.mp3#33", "zonemusic/ulduarraidext/ur_ulduarraidextwalk03.mp3#87", "zonemusic/ulduarraidext/ur_ulduarraidextwalk04.mp3#87", "zonemusic/ulduarraidext/ur_ulduarraidextwalk05.mp3#87", "zonemusic/ulduarraidext/ur_ulduarraidextwalk06.mp3#26", "zonemusic/ulduarraidext/ur_ulduarraidextwalk07.mp3#57", "zonemusic/ulduarraidext/ur_ulduarraidextwalk08.mp3#53", "zonemusic/ulduarraidext/ur_ulduarraidextwalk09.mp3#27", "zonemusic/ulduarraidext/ur_ulduarraidextwalk10.mp3#28", "zonemusic/ulduarraidext/ur_ulduarraidextwalk11.mp3#28"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Icecrown Citadel"]				, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Icecrown Citadel"], prefol, "zonemusic/icecrownraid/ir_bronzejam.mp3#116", "zonemusic/icecrownraid/ir_crimsonhall1.mp3#121", "zonemusic/icecrownraid/ir_crimsonhall2.mp3#73", "zonemusic/icecrownraid/ir_crimsonhall3.mp3#61", "zonemusic/icecrownraid/ir_crimsonhall4.mp3#130", "zonemusic/icecrownraid/ir_forgeofsouls1.mp3#103", "zonemusic/icecrownraid/ir_forgeofsouls2.mp3#87", "zonemusic/icecrownraid/ir_forgeofsouls3.mp3#97", "zonemusic/icecrownraid/ir_forgeofsouls4.mp3#99", "zonemusic/icecrownraid/ir_frostmourne1.mp3#103", "zonemusic/icecrownraid/ir_frostmourne2.mp3#103", "zonemusic/icecrownraid/ir_frostmourne3.mp3#103", "zonemusic/icecrownraid/ir_gunships.mp3#73", "zonemusic/icecrownraid/ir_gunstrings.mp3#61", "zonemusic/icecrownraid/ir_hallsofchase.mp3#106", "zonemusic/icecrownraid/ir_hallsofreflection.mp3#157", "zonemusic/icecrownraid/ir_icefortress.mp3#133", "zonemusic/icecrownraid/ir_icefortress1.mp3#153", "zonemusic/icecrownraid/ir_icefortress2.mp3#105", "zonemusic/icecrownraid/ir_icefortress3.mp3#80", "zonemusic/icecrownraid/ir_icefortress4.mp3#106", "zonemusic/icecrownraid/ir_ladyorthelich.mp3#75", "zonemusic/icecrownraid/ir_lethimpass.mp3#92", "zonemusic/icecrownraid/ir_lightshammer1.mp3#108", "zonemusic/icecrownraid/ir_lightshammer2.mp3#40", "zonemusic/icecrownraid/ir_lightshammer3.mp3#83", "zonemusic/icecrownraid/ir_lightshammer4.mp3#102", "zonemusic/icecrownraid/ir_lightshammer5.mp3#58", "zonemusic/icecrownraid/ir_lightshammer6.mp3#108", "zonemusic/icecrownraid/ir_reflectedhalls1.mp3#60", "zonemusic/icecrownraid/ir_reflectedhalls2.mp3#75", "zonemusic/icecrownraid/ir_reflectedhalls3.mp3#67", "zonemusic/icecrownraid/ir_reflectedhalls4.mp3#129", "zonemusic/icecrownraid/ir_reflectedhalls5.mp3#59", "zonemusic/icecrownraid/ir_runk_01.mp3#27", "zonemusic/icecrownraid/ir_runk_02.mp3#27", "zonemusic/icecrownraid/ir_runk_03.mp3#27", "zonemusic/icecrownraid/ir_runl_01.mp3#23", "zonemusic/icecrownraid/ir_runl_02.mp3#42", "zonemusic/icecrownraid/ir_sindragosa.mp3#68", "zonemusic/icecrownraid/ir_sindrastrings.mp3#66", "zonemusic/icecrownraid/ir_stingh_01.mp3#27", "zonemusic/icecrownraid/ir_stingh_02.mp3#16", "zonemusic/icecrownraid/ir_stingh_03.mp3#25", "zonemusic/icecrownraid/ir_stingh_04.mp3#26", "zonemusic/icecrownraid/ir_stingh_05.mp3#27", "zonemusic/icecrownraid/ir_stingh_06.mp3#27", "zonemusic/icecrownraid/ir_summit1.mp3#103", "zonemusic/icecrownraid/ir_summit2.mp3#103", "zonemusic/icecrownraid/ir_summit3.mp3#103", "zonemusic/icecrownraid/ir_summit4.mp3#103", "zonemusic/icecrownraid/ir_summit5.mp3#103", "zonemusic/icecrownraid/ir_walka_01.mp3#98", "zonemusic/icecrownraid/ir_walka_02.mp3#97", "zonemusic/icecrownraid/ir_walka_03.mp3#91", "zonemusic/icecrownraid/ir_walka_04.mp3#98", "zonemusic/icecrownraid/ir_walka_05.mp3#100", "zonemusic/icecrownraid/ir_walka_06.mp3#52", "zonemusic/icecrownraid/ir_walkb_01.mp3#52", "zonemusic/icecrownraid/ir_walkd_01.mp3#43", "zonemusic/icecrownraid/ir_walkd_02.mp3#42", "zonemusic/icecrownraid/ir_walkd_03.mp3#42", "zonemusic/icecrownraid/ir_walkd_04.mp3#43", "zonemusic/icecrownraid/ir_walkd_05.mp3#43", "zonemusic/icecrownraid/ir_walkd_06.mp3#43", "zonemusic/icecrownraid/ir_walke_01.mp3#29", "zonemusic/icecrownraid/ir_walke_02.mp3#29", "zonemusic/icecrownraid/ir_walke_03.mp3#28", "zonemusic/icecrownraid/ir_walke_04.mp3#29", "zonemusic/icecrownraid/ir_walke_05.mp3#28", "zonemusic/icecrownraid/ir_walkf_01.mp3#49", "zonemusic/icecrownraid/ir_walkf_02.mp3#47", "zonemusic/icecrownraid/ir_walkf_03.mp3#43", "zonemusic/icecrownraid/ir_walkf_04.mp3#48", "zonemusic/icecrownraid/ir_walkf_05.mp3#43", "zonemusic/icecrownraid/ir_walkf_06.mp3#43", "zonemusic/icecrownraid/ir_walkf_07.mp3#43", "zonemusic/icecrownraid/ir_walkf_08.mp3#42", "zonemusic/icecrownraid/ir_walkg_01.mp3#24", "zonemusic/icecrownraid/ir_walkg_02.mp3#24", "zonemusic/icecrownraid/ir_walkg_03.mp3#24", "zonemusic/icecrownraid/ir_walkg_04.mp3#23", "zonemusic/icecrownraid/ir_walkg_05.mp3#25", "zonemusic/icecrownraid/ir_walkg_06.mp3#24", "zonemusic/icecrownraid/ir_walkj_01.mp3#82", "zonemusic/icecrownraid/ir_walkj_02.mp3#82", "zonemusic/icecrownraid/ir_walkj_03.mp3#81", "zonemusic/icecrownraid/ir_walkj_04.mp3#82", "zonemusic/icecrownraid/ir_walkj_05.mp3#82", "zonemusic/icecrownraid/ir_walkj_06.mp3#82", "zonemusic/icecrownraid/ir_walkm_01.mp3#156", "zonemusic/icecrownraid/ir_walkz_01.mp3#46", "zonemusic/icecrownraid/ir_walkz_02.mp3#46"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Naxxramas"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Naxxramas"], prefol, "zonemusic/naxxramas/naxxramasabominationboss1.mp3#61", "zonemusic/naxxramas/naxxramasabominationboss2.mp3#67", "zonemusic/naxxramas/naxxramasabominationwing1.mp3#61", "zonemusic/naxxramas/naxxramasabominationwing2.mp3#66", "zonemusic/naxxramas/naxxramasabominationwing3.mp3#61", "zonemusic/naxxramas/naxxramasfrostwyrm1.mp3#58", "zonemusic/naxxramas/naxxramasfrostwyrm2.mp3#82", "zonemusic/naxxramas/naxxramasfrostwyrm3.mp3#62", "zonemusic/naxxramas/naxxramasfrostwyrm4.mp3#60", "zonemusic/naxxramas/naxxramashubbase1.mp3#72", "zonemusic/naxxramas/naxxramashubbase2.mp3#81", "zonemusic/naxxramas/naxxramaskelthuzad1.mp3#95", "zonemusic/naxxramas/naxxramaskelthuzad2.mp3#97", "zonemusic/naxxramas/naxxramaskelthuzad3.mp3#75", "zonemusic/naxxramas/naxxramasplagueboss1.mp3#87", "zonemusic/naxxramas/naxxramasplaguewing1.mp3#88", "zonemusic/naxxramas/naxxramasplaguewing2.mp3#72", "zonemusic/naxxramas/naxxramasplaguewing3.mp3#77", "zonemusic/naxxramas/naxxramasspiderboss1.mp3#60", "zonemusic/naxxramas/naxxramasspiderboss2.mp3#64", "zonemusic/naxxramas/naxxramasspiderwing1.mp3#88", "zonemusic/naxxramas/naxxramasspiderwing2.mp3#67", "zonemusic/naxxramas/naxxramasspiderwing3.mp3#47", "zonemusic/naxxramas/naxxramaswalking1.mp3#102", "zonemusic/naxxramas/naxxramaswalking2.mp3#72", "zonemusic/naxxramas/naxxramaswalking3.mp3#87", "zonemusic/naxxramas/naxxramaswalking4.mp3#82", "zonemusic/naxxramas/naxxramaswalking5.mp3#100", "zonemusic/naxxramas/naxxramaswalking6.mp3#99"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Nexus"]							, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Nexus"], prefol, "zonemusic/nexus/nz_nexusactionwalkuni01.mp3#76", "zonemusic/nexus/nz_nexusactionwalkuni02.mp3#68", "zonemusic/nexus/nz_nexusactionwalkuni03.mp3#102", "zonemusic/nexus/nz_nexusactionwalkuni04.mp3#107", "zonemusic/nexus/nz_nexusactionwalkuni05.mp3#90", "zonemusic/nexus/nz_nexushailwalkuni01.mp3#57", "zonemusic/nexus/nz_nexushailwalkuni02.mp3#65", "zonemusic/nexus/nz_nexuspulsewalkuni01.mp3#61", "zonemusic/nexus/nz_nexuspulsewalkuni02.mp3#70", "zonemusic/nexus/nz_nexusquietwalkuni01.mp3#114", "zonemusic/nexus/nz_nexusquietwalkuni02.mp3#111", "zonemusic/nexus/nz_nexusquietwalkuni03.mp3#56", "zonemusic/nexus/nz_nexusquietwalkuni04.mp3#71", "zonemusic/boreantundra/bo_coldarrawalkuni01.mp3#64", "zonemusic/boreantundra/bo_coldarrawalkuni02.mp3#63", "zonemusic/boreantundra/bo_coldarrawalkuni03.mp3#124"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Obsidian Sanctum"]				, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Obsidian Sanctum"], prefol, "zonemusic/chamberoftheaspects/ca_aspectsgeneralwalkaday01.mp3#93", "zonemusic/chamberoftheaspects/ca_aspectsgeneralwalkaday02.mp3#133", "zonemusic/chamberoftheaspects/ca_aspectsgeneralwalkaday03.mp3#75", "zonemusic/chamberoftheaspects/ca_aspectsgeneralwalkaday04.mp3#65", "zonemusic/chamberoftheaspects/ca_aspectsgeneralwalkanight01.mp3#90", "zonemusic/chamberoftheaspects/ca_aspectsgeneralwalkanight02.mp3#133", "zonemusic/chamberoftheaspects/ca_aspectsgeneralwalkanight03.mp3#75", "zonemusic/chamberoftheaspects/ca_aspectsgeneralwalkanight04.mp3#65", "zonemusic/chamberoftheaspects/ca_aspectsgeneralwalkauni01.mp3#75", "zonemusic/chamberoftheaspects/ca_aspectsgeneralwalkauni02.mp3#65", "zonemusic/chamberoftheaspects/ca_aspectsintroaday01.mp3#73", "zonemusic/chamberoftheaspects/ca_aspectsintroanight01.mp3#73"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Oculus"]							, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Oculus"], prefol, "zonemusic/nexus/nz_nexusactionwalkuni01.mp3#76", "zonemusic/nexus/nz_nexusactionwalkuni02.mp3#68", "zonemusic/nexus/nz_nexusactionwalkuni03.mp3#102", "zonemusic/nexus/nz_nexusactionwalkuni04.mp3#107", "zonemusic/nexus/nz_nexusactionwalkuni05.mp3#90", "zonemusic/boreantundra/bo_coldarrawalkuni01.mp3#64", "zonemusic/boreantundra/bo_coldarrawalkuni02.mp3#63", "zonemusic/boreantundra/bo_coldarrawalkuni03.mp3#124"}) -- Shares music with Nexus / Coldarra
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Onyxia's Lair"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Onyxia's Lair"], prefol, "zonemusic/barrendry/daybarrendry03.mp3#55"}) -- WotLK version, soundkit mapped to Barrens
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Pit of Saron"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Pit of Saron"], prefol, "zonemusic/icecrownraid/ir_walkd_01.mp3#43", "zonemusic/icecrownraid/ir_walkd_02.mp3#42", "zonemusic/icecrownraid/ir_walkd_03.mp3#42", "zonemusic/icecrownraid/ir_walkd_04.mp3#43", "zonemusic/icecrownraid/ir_walkd_05.mp3#43", "zonemusic/icecrownraid/ir_walkd_06.mp3#43", "zonemusic/icecrownraid/ir_walke_01.mp3#29", "zonemusic/icecrownraid/ir_walke_02.mp3#29", "zonemusic/icecrownraid/ir_walke_03.mp3#28", "zonemusic/icecrownraid/ir_walke_04.mp3#29", "zonemusic/icecrownraid/ir_walke_05.mp3#28", "zonemusic/icecrownraid/ir_walkj_01.mp3#82", "zonemusic/icecrownraid/ir_walkj_02.mp3#82", "zonemusic/icecrownraid/ir_walkj_03.mp3#81", "zonemusic/icecrownraid/ir_walkj_04.mp3#82", "zonemusic/icecrownraid/ir_walkj_05.mp3#82", "zonemusic/icecrownraid/ir_walkj_06.mp3#82"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Ruby Sanctum"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Ruby Sanctum"], prefol, "zonemusic/chamberoftheaspects/ca_aspectsgeneralwalkaday01.mp3#93", "zonemusic/chamberoftheaspects/ca_aspectsgeneralwalkanight01.mp3#90"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Ulduar"]							, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Ulduar"], prefol, "zonemusic/ulduarraidext/ur_ulduarraidextaction01.mp3#31", "zonemusic/ulduarraidext/ur_ulduarraidextaction02.mp3#137", "zonemusic/ulduarraidext/ur_ulduarraidextaction03.mp3#136", "zonemusic/ulduarraidext/ur_ulduarraidextaction04.mp3#53", "zonemusic/ulduarraidext/ur_ulduarraidextaction05.mp3#93", "zonemusic/ulduarraidext/ur_ulduarraidextaction06.mp3#93", "zonemusic/ulduarraidext/ur_ulduarraidextaction07.mp3#40", "zonemusic/ulduarraidext/ur_ulduarraidextaction08.mp3#40", "zonemusic/ulduarraidext/ur_ulduarraidextaction09.mp3#28", "zonemusic/ulduarraidext/ur_ulduarraidextaction10.mp3#28", "zonemusic/ulduarraidext/ur_ulduarraidextaction11.mp3#27", "zonemusic/ulduarraidext/ur_ulduarraidextaction12.mp3#28", "zonemusic/ulduarraidext/ur_ulduarraidextaction13.mp3#27", "zonemusic/ulduarraidext/ur_ulduarraidextaction14.mp3#36", "zonemusic/ulduarraidext/ur_ulduarraidextaction15.mp3#36", "zonemusic/ulduarraidext/ur_ulduarraidextaction16.mp3#36", "zonemusic/ulduarraidext/ur_ulduarraidextintro01.mp3#12", "zonemusic/ulduarraidext/ur_ulduarraidextintro02.mp3#14", "zonemusic/ulduarraidext/ur_ulduarraidextintro03.mp3#14", "zonemusic/ulduarraidext/ur_ulduarraidextintro04.mp3#17", "zonemusic/ulduarraidext/ur_ulduarraidextintro05.mp3#13", "zonemusic/ulduarraidext/ur_ulduarraidextintro06.mp3#13", "zonemusic/ulduarraidext/ur_ulduarraidextintro07.mp3#12", "zonemusic/ulduarraidext/ur_ulduarraidextintro08.mp3#26", "zonemusic/ulduarraidext/ur_ulduarraidextintro09.mp3#25", "zonemusic/ulduarraidext/ur_ulduarraidextwalk01.mp3#36", "zonemusic/ulduarraidext/ur_ulduarraidextwalk02.mp3#33", "zonemusic/ulduarraidext/ur_ulduarraidextwalk03.mp3#87", "zonemusic/ulduarraidext/ur_ulduarraidextwalk04.mp3#87", "zonemusic/ulduarraidext/ur_ulduarraidextwalk05.mp3#87", "zonemusic/ulduarraidext/ur_ulduarraidextwalk06.mp3#26", "zonemusic/ulduarraidext/ur_ulduarraidextwalk07.mp3#57", "zonemusic/ulduarraidext/ur_ulduarraidextwalk08.mp3#53", "zonemusic/ulduarraidext/ur_ulduarraidextwalk09.mp3#27", "zonemusic/ulduarraidext/ur_ulduarraidextwalk10.mp3#28", "zonemusic/ulduarraidext/ur_ulduarraidextwalk11.mp3#28", "zonemusic/ulduarraidint/ur_algalonbattle01walk.mp3#162", "zonemusic/ulduarraidint/ur_algalonbattle02walk.mp3#131", "zonemusic/ulduarraidint/ur_algalonherointro.mp3#148", "zonemusic/ulduarraidint/ur_algalonplanetaryhallwalk.mp3#148", "zonemusic/ulduarraidint/ur_algalonvoiceswalk.mp3#148", "zonemusic/ulduarraidint/ur_foursigilshallwalk.mp3#123", "zonemusic/ulduarraidint/ur_foursigilsherointro.mp3#218", "zonemusic/ulduarraidint/ur_hallsinstrumentalwalk.mp3#115", "zonemusic/ulduarraidint/ur_hallsofironevent.mp3#196", "zonemusic/ulduarraidint/ur_hallspastwalk.mp3#112", "zonemusic/ulduarraidint/ur_mimironbwalk.mp3#172", "zonemusic/ulduarraidint/ur_mimironcwalk.mp3#97", "zonemusic/ulduarraidint/ur_mimirondwalk.mp3#96", "zonemusic/ulduarraidint/ur_mimironealk.mp3#82", "zonemusic/ulduarraidint/ur_mimironfwalk.mp3#179", "zonemusic/ulduarraidint/ur_mimironghostswalk.mp3#179", "zonemusic/ulduarraidint/ur_mimironherointro.mp3#172", "zonemusic/ulduarraidint/ur_sigilghostswalk.mp3#75", "zonemusic/ulduarraidint/ur_titanghostswalk.mp3#113", "zonemusic/ulduarraidint/ur_titanhallsherowalk.mp3#113", "zonemusic/ulduarraidint/ur_titanmechwalk.mp3#127", "zonemusic/ulduarraidint/ur_titanorchestraintro.mp3#102", "zonemusic/ulduarraidint/ur_titansigilswalk.mp3#57", "zonemusic/ulduarraidint/ur_titanyoggwalk.mp3#94", "zonemusic/ulduarraidint/ur_ulduartonewalk.mp3#106", "zonemusic/ulduarraidint/ur_yogglitewalk.mp3#105", "zonemusic/ulduarraidint/ur_yoggsaronherointro.mp3#105", "zonemusic/ulduarraidint/ur_yoggwoodswalk.mp3#82"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Utgarde Keep"]						, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Utgarde Keep"], prefol, "zonemusic/utgarde keep/uk_generalwalkuni01.mp3#56", "zonemusic/utgarde keep/uk_generalwalkuni02.mp3#52", "zonemusic/utgarde keep/uk_generalwalkuni03.mp3#54", "zonemusic/utgarde keep/uk_generalwalkuni04.mp3#26", "zonemusic/utgarde keep/uk_generalwalkuni05.mp3#30", "zonemusic/utgarde keep/uk_quietwalkuni01.mp3#108", "zonemusic/utgarde keep/uk_quietwalkuni02.mp3#107"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Utgarde Pinnacle"]				, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Utgarde Pinnacle"], prefol, "zonemusic/utgarde keep/uk_generalwalkuni01.mp3#56", "zonemusic/utgarde keep/uk_generalwalkuni02.mp3#52", "zonemusic/utgarde keep/uk_generalwalkuni03.mp3#54", "zonemusic/utgarde keep/uk_generalwalkuni04.mp3#26", "zonemusic/utgarde keep/uk_generalwalkuni05.mp3#30", "zonemusic/utgarde keep/uk_quietwalkuni01.mp3#108"})
	Zn(L["Dungeons"], L["Wrath of the Lich King"], L["Vault of Archavon"]				, {"|cffffd800" .. L["Dungeons"] .. ": " .. L["Vault of Archavon"], prefol, "zonemusic/ulduar/ul_lightningbattlewalk.mp3#52", "zonemusic/ulduar/ul_lightninggeneralwalk01.mp3#33", "zonemusic/ulduar/ul_lightninggeneralwalk02.mp3#40", "zonemusic/ulduar/ul_lightninggeneralwalk03.mp3#35", "zonemusic/ulduar/ul_lightningintro.mp3#82"}) -- Soundkit suggests Ulduar Lightning music

	----------------------------------------------------------------------
	-- Various
	----------------------------------------------------------------------

	-- Various (Updated)
	Zn(L["Various"], L["Various"], "|cffffd800" .. L["Various"], {""})
	Zn(L["Various"], L["Various"], L["Battlegrounds"]						, {"|cffffd800" .. L["Various"] .. ": " .. L["Battlegrounds"], prefol, "zonemusic/pvp/pvp1.mp3#47", "zonemusic/pvp/pvp2.mp3#52", "zonemusic/pvp/pvp3.mp3#40", "zonemusic/pvp/pvp4.mp3#63", "zonemusic/pvp/pvp5.mp3#61", "zonemusic/cursedland/cursedland01.mp3#54", "zonemusic/cursedland/cursedland02.mp3#58", "zonemusic/cursedland/cursedland03.mp3#64", "zonemusic/cursedland/cursedland04.mp3#79", "zonemusic/cursedland/cursedland05.mp3#82", "zonemusic/cursedland/cursedland06.mp3#74", "musical moments/gloomy/gloomy01.mp3#36"}) -- Mystery1:10
	Zn(L["Various"], L["Various"], L["Cinematics"]							, {"|cffffd800" .. L["Various"] .. ": " .. L["Cinematics"], prefol})
	Zn(L["Various"], L["Various"], L["Credits"]								, {"|cffffd800" .. L["Various"] .. ": " .. L["Credits"], prefol, "citymusic/darnassus/darnassus intro.mp3#40", "citymusic/ironforge/ironforge intro.mp3#86", "citymusic/ironforge/tinkertownintro_moment.mp3#52", "citymusic/stormwind/stormwind_intro-moment.mp3#66", "citymusic/orgrimmar/orgrimmar_intro-moment.mp3#40", "citymusic/thunderbluff/thunderbluff intro.mp3#46", "citymusic/undercity/undercityintro-moment.mp3#28", "gluescreenmusic/bccredits_lament_of_the_highborne.mp3#171", "zonemusic/azuremyst/ai_exodarintro01.mp3#82", "zonemusic/eversong/es_silvermoonintro01.mp3#132"})
	Zn(L["Various"], L["Various"], L["Events"]								, {"|cffffd800" .. L["Various"] .. ": " .. L["Events"], prefol, "|cffffd800", "|cffffd800" .. L["Darkmoon Faire"], "worldevents/darkmoonfaire_1.mp3#28", "worldevents/darkmoonfaire_2.mp3#74", "worldevents/darkmoonfaire_3.mp3#58", "worldevents/darkmoonfaire_4.mp3#37"})
	Zn(L["Various"], L["Various"], L["Main Titles"]							, {"|cffffd800" .. L["Various"] .. ": " .. L["Main Titles"], prefol, "gluescreenmusic/wow_main_theme.mp3#161", "gluescreenmusic/bc_main_theme.mp3#226", "gluescreenmusic/wotlk_main_title.mp3#544"})
	Zn(L["Various"], L["Various"], L["Musical Moments"]						, {"|cffffd800" .. L["Various"] .. ": " .. L["Musical Moments"], prefol, "|cffffd800", "|cffffd800" .. L["Angelic"], "musical moments/angelic/angelic01.mp3#48", "|cffffd800", "|cffffd800" .. L["Battle"], "musical moments/battle/battle01.mp3#48", "musical moments/battle/battle02.mp3#62", "musical moments/battle/battle03.mp3#27", "musical moments/battle/battle04.mp3#36", "musical moments/battle/battle05.mp3#44", "musical moments/battle/battle06.mp3#62", "|cffffd800", "|cffffd800" .. L["Gloomy"], "musical moments/gloomy/gloomy01.mp3#36", "musical moments/gloomy/gloomy02.mp3#39", "|cffffd800", "|cffffd800" .. L["Haunted"], "musical moments/haunted/haunted01.mp3#62", "musical moments/haunted/haunted02.mp3#60", "|cffffd800", "|cffffd800" .. L["Magic"], "musical moments/magic/magic01-moment.mp3#64", "|cffffd800", "|cffffd800" .. L["Mystery"], "musical moments/mystery/mystery01-zone.mp3#60", "musical moments/mystery/mystery02-zone.mp3#53", "musical moments/mystery/mystery03-zone.mp3#61", "musical moments/mystery/mystery04-zone.mp3#64", "musical moments/mystery/mystery05-zone.mp3#82", "musical moments/mystery/mystery06-zone.mp3#65", "musical moments/mystery/mystery07-zone.mp3#83", "musical moments/mystery/mystery08-zone.mp3#83", "musical moments/mystery/mystery09-zone.mp3#82", "musical moments/mystery/mystery10-zone.mp3#62", "|cffffd800", "|cffffd800" .. L["Sacred"], "musical moments/sacred/sacred01.mp3#16", "musical moments/sacred/sacred02.mp3#19", "|cffffd800", "|cffffd800" .. L["Spooky"], "musical moments/spooky/spooky01-moment.mp3#25", "|cffffd800", "|cffffd800" .. L["Swamp"], "musical moments/swamp/swamp01.mp3#34", "|cffffd800", "|cffffd800" .. L["Various"], "musical moments/mystery/ahnqirajintro1.mp3#144", "musical moments/zulgurubvoodoo.mp3#84"})
	Zn(L["Various"], L["Various"], L["Narration"]							, {"|cffffd800" .. L["Various"] .. ": " .. L["Narration"], prefol, "cinematicvoices/dwarfnarration.mp3#62", "cinematicvoices/gnomenarration.mp3#78", "cinematicvoices/humannarration.mp3#88", "cinematicvoices/nightelfnarration.mp3#108", "cinematicvoices/orcnarration.mp3#72", "cinematicvoices/taurennarration.mp3#75", "cinematicvoices/trollnarration.mp3#64", "cinematicvoices/undeadnarration.mp3#104", "cinematicvoices/bloodelfnarration.mp3#83", "cinematicvoices/draeneinarration.mp3#74"})


	----------------------------------------------------------------------
	-- NEW Tracks (Corrected Paths, Compacted, L[] Keys for Display Names)
	----------------------------------------------------------------------
	Zn(L["New Tracks"], L["New Tracks"], "|cffffd800" .. L["New Tracks"], {""}) -- Main header for the NEW category

	Zn(L["New Tracks"], L["New Tracks"], L["AQ (Interior)"]                        , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["AQ (Interior)"], prefol, "zonemusic/ahnqiraj/ahnqirajinterior1.mp3#52", "zonemusic/ahnqiraj/ahnqirajinterior2.mp3#81", "zonemusic/ahnqiraj/ahnqirajinterior3.mp3#67", "zonemusic/ahnqiraj/ahnqirajinteriorintromain.mp3#69", "zonemusic/ahnqiraj/ahnqirajinteriorcenterroom1.mp3#69", "zonemusic/ahnqiraj/ahnqirajkingroom.mp3#73", "zonemusic/ahnqiraj/ahnqirajtriangleroom1.mp3#23", "zonemusic/ahnqiraj/ahnqirajtriangleroom2.mp3#17", "zonemusic/ahnqiraj/ahnqirajtriangleroom3.mp3#15", "zonemusic/ahnqiraj/ahnqirajtriangleroom4.mp3#19", "zonemusic/ahnqiraj/ahnqirajtriangleroom5.mp3#31", "zonemusic/ahnqiraj/ahnqirajtriangleroom6.mp3#20", "zonemusic/ahnqiraj/ahnqirajtriangleroom7.mp3#17"})
	Zn(L["New Tracks"], L["New Tracks"], L["Argent Tourney (Events)"]               , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Argent Tourney (Events)"], prefol, "zonemusic/argenttournament/at_heraldevent.mp3#13", "zonemusic/argenttournament/at_joustevent.mp3#123"})
	Zn(L["New Tracks"], L["New Tracks"], L["Azuremyst (Exodar)"]                    , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Azuremyst (Exodar)"], prefol, "zonemusic/azuremyst/ai_exodarwalkuni01.mp3#109", "zonemusic/azuremyst/ai_exodarwalkuni02.mp3#107", "zonemusic/azuremyst/ai_exodarwalkuni03.mp3#93", "zonemusic/azuremyst/av_draeneiwalkuni01.mp3#206", "zonemusic/azuremyst/av_draeneiwalkuni02.mp3#124", "zonemusic/azuremyst/av_draeneiwalkuni03r.mp3#188"})
	Zn(L["New Tracks"], L["New Tracks"], L["Black Temple (Extra)"]                   , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Black Temple (Extra)"], prefol, "zonemusic/blacktemple/bt_arrivalwalkhero01.mp3#164", "zonemusic/blacktemple/bt_arrivalwalkuni04.mp3#64", "zonemusic/blacktemple/bt_illidariwalkhero09.mp3#74", "zonemusic/blacktemple/bt_illidariwalkuni04.mp3#91", "zonemusic/blacktemple/bt_illidariwalkuni05.mp3#90", "zonemusic/blacktemple/bt_illidariwalkuni10.mp3#75", "zonemusic/blacktemple/bt_illidariwalkuni11.mp3#35", "zonemusic/blacktemple/bt_karaborwalkuni01.mp3#106", "zonemusic/blacktemple/bt_karaborwalkuni02.mp3#88", "zonemusic/blacktemple/bt_karaborwalkuni03.mp3#57", "zonemusic/blacktemple/bt_karaborwalkuni04.mp3#126", "zonemusic/blacktemple/bt_preludeevent01.mp3#253", "zonemusic/blacktemple/bt_reliquarywalkhero01.mp3#112", "zonemusic/blacktemple/bt_reliquarywalkuni02.mp3#66", "zonemusic/blacktemple/bt_reliquarywalkuni03.mp3#79", "zonemusic/blacktemple/bt_reliquarywalkuni04.mp3#63", "zonemusic/blacktemple/bt_reliquarywalkuni05.mp3#75", "zonemusic/blacktemple/bt_reliquarywalkuni06.mp3#125", "zonemusic/blacktemple/bt_reliquarywalkuni07.mp3#64", "zonemusic/blacktemple/bt_reliquarywalkuni08.mp3#88", "zonemusic/blacktemple/bt_sanctuarywalkhero01.mp3#131", "zonemusic/blacktemple/bt_sanctuarywalkuni04.mp3#65", "zonemusic/blacktemple/bt_sanctuarywalkuni05.mp3#56", "zonemusic/blacktemple/bt_sanctuarywalkuni06.mp3#58", "zonemusic/blacktemple/bt_sanctuarywalkuni07.mp3#64", "zonemusic/blacktemple/bt_sanctuarywalkuni08.mp3#57", "zonemusic/blacktemple/bt_stormwalkhero02.mp3#73", "zonemusic/blacktemple/bt_stormwalkuni01.mp3#67", "zonemusic/blacktemple/bt_stormwalkuni03.mp3#32", "zonemusic/blacktemple/bt_stormwalkuni04.mp3#48", "zonemusic/blacktemple/bt_summitwalkuni01.mp3#59", "zonemusic/blacktemple/bt_summitwalkuni02.mp3#69", "zonemusic/blacktemple/bt_summitwalkuni03.mp3#41", "zonemusic/blacktemple/bt_summitwalkuni04.mp3#114", "zonemusic/blacktemple/bt_summitwalkuni05.mp3#51"})
	Zn(L["New Tracks"], L["New Tracks"], L["Blade's Edge (Ogres)"]                         , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Blade's Edge (Ogres)"], prefol, "zonemusic/bladesedge/bl_ogrewalkuni01.mp3#75", "zonemusic/bladesedge/bl_ogrewalkuni02.mp3#110"})
	Zn(L["New Tracks"], L["New Tracks"], L["Bloodmyst (Naga)"]                           , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Bloodmyst (Naga)"], prefol, "zonemusic/bloodmyst/bi_nagaintro01.mp3#31", "zonemusic/bloodmyst/bi_nagaintro01r.mp3#25"})
	Zn(L["New Tracks"], L["New Tracks"], L["Borean Tundra (Riplash)"]                     , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Borean Tundra (Riplash)"], prefol, "zonemusic/boreantundra/bo_riplash_intro01.mp3#153", "zonemusic/boreantundra/bo_riplash_intro02.mp3#177"})
	Zn(L["New Tracks"], L["New Tracks"], L["Caverns of Time (Extra)"]                      , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Caverns of Time (Extra)"], prefol, "zonemusic/cavernsoftime/ct_hyjalextwalk9uni.mp3#73", "zonemusic/cavernsoftime/ct_morassportalintro01.mp3#28", "zonemusic/cavernsoftime/ct_hyjalextwalk7uni.mp3#66", "zonemusic/cavernsoftime/ct_hyjalextwalk8uni.mp3#70", "zonemusic/cavernsoftime/ct_brazensflightintrouni.mp3#93", "zonemusic/cavernsoftime/ct_cavernswalk1uni.mp3#112", "zonemusic/cavernsoftime/ct_cavernswalk2uni.mp3#120", "zonemusic/cavernsoftime/ct_cavernswalk3uni.mp3#169", "zonemusic/cavernsoftime/ct_cavernswalk4uni.mp3#130", "zonemusic/cavernsoftime/ct_cavernswalk5uni.mp3#151", "zonemusic/cavernsoftime/ct_cavernswalk6uni.mp3#161", "zonemusic/cavernsoftime/ct_cavernswalk7uni.mp3#178", "zonemusic/cavernsoftime/ct_cavernswalk8uni.mp3#140", "zonemusic/cavernsoftime/ct_cavernswalk9uni.mp3#161", "zonemusic/cavernsoftime/ct_durnholdecellarwalk1uni.mp3#104", "zonemusic/cavernsoftime/ct_durnholdecellarwalk2uni.mp3#59", "zonemusic/cavernsoftime/ct_durnholdecellarwalk3uni.mp3#66", "zonemusic/cavernsoftime/ct_durnholdekeepextwalk2uni.mp3#66", "zonemusic/cavernsoftime/ct_durnholdekeepextwalk3uni.mp3#70", "zonemusic/cavernsoftime/ct_durnholdekeepextwalk4uni.mp3#58", "zonemusic/cavernsoftime/ct_durnholdekeepextwalk5uni.mp3#93", "zonemusic/cavernsoftime/ct_durnholdekeepextwalk6uni.mp3#60", "zonemusic/cavernsoftime/ct_durnholdekeepintwalk2uni.mp3#123", "zonemusic/cavernsoftime/ct_durnholdekeepintwalk3uni.mp3#73", "zonemusic/cavernsoftime/ct_escapedurnintrouni.mp3#112", "zonemusic/cavernsoftime/ct_tarrenmillextwalk1uni.mp3#78", "zonemusic/cavernsoftime/ct_tarrenmillextwalk2uni.mp3#66", "zonemusic/cavernsoftime/ct_thrallescapeintrouni.mp3#45"})
	Zn(L["New Tracks"], L["New Tracks"], L["Darnassus (Druid Grove)"]                      , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Darnassus (Druid Grove)"], prefol, "citymusic/darnassus/druid grove.mp3#45"})
	Zn(L["New Tracks"], L["New Tracks"], L["Dragonblight (Intro)"]                         , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Dragonblight (Intro)"], prefol, "zonemusic/dragonblight/db_generalintro_01.mp3#92", "zonemusic/dragonblight/db_tusk_indule_day01.mp3#129", "zonemusic/dragonblight/db_tusk_indule_day02.mp3#62"})
	Zn(L["New Tracks"], L["New Tracks"], L["Ebon Hold"]                                    , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Ebon Hold"], prefol, "zonemusic/ebonhold/eh_assaultuni01.mp3#65", "zonemusic/ebonhold/eh_assaultuni02.mp3#70", "zonemusic/ebonhold/eh_assaultuni03.mp3#65", "zonemusic/ebonhold/eh_assaultuni04.mp3#67", "zonemusic/ebonhold/eh_assaultuni05.mp3#117", "zonemusic/ebonhold/eh_assaultuni06.mp3#93", "zonemusic/ebonhold/eh_assaultuni07.mp3#96", "zonemusic/ebonhold/eh_generalwalkuni01.mp3#82", "zonemusic/ebonhold/eh_generalwalkuni02.mp3#78", "zonemusic/ebonhold/eh_generalwalkuni03.mp3#82"})
	Zn(L["New Tracks"], L["New Tracks"], L["Eversong (Scenic/Scorched)"]                   , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Eversong (Scenic/Scorched)"], prefol, "zonemusic/eversong/es_scenicintronight01.mp3#97", "zonemusic/eversong/es_scortchedwalkday01.mp3#116", "zonemusic/eversong/es_scortchedwalkday02.mp3#103", "zonemusic/eversong/es_scortchedwalknight01.mp3#69", "zonemusic/eversong/es_scortchedwalknight02.mp3#61", "zonemusic/eversong/es_silvermoonwalknight03.mp3#80"})
	Zn(L["New Tracks"], L["New Tracks"], L["Ghostlands (Scenic)"]                          , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Ghostlands (Scenic)"], prefol, "zonemusic/ghostlands/gl_scenicwalkuni01.mp3#89", "zonemusic/ghostlands/gl_scenicwalkuni02.mp3#81", "zonemusic/ghostlands/gl_scenicwalkuni03.mp3#78"})
	Zn(L["New Tracks"], L["New Tracks"], L["GhostMusic"]                                  , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["GhostMusic"], prefol, "zonemusic/ghostmusic/ghostmusic03.mp3#62"})
	Zn(L["New Tracks"], L["New Tracks"], L["Grizzly Hills (Intros)"]                       , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Grizzly Hills (Intros)"], prefol, "zonemusic/grizzlyhills/gh_intro1uni01.mp3#284", "zonemusic/grizzlyhills/gh_intro2uni01.mp3#149"})
	Zn(L["New Tracks"], L["New Tracks"], L["Hellfire (Extra)"]                             , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Hellfire (Extra)"], prefol, "zonemusic/hellfirepeninsula/bl_he_ogrewalkuni01.mp3#75", "zonemusic/hellfirepeninsula/bl_he_ogrewalkuni02.mp3#110", "zonemusic/hellfirepeninsula/he_armouryintrouni01.mp3#14", "zonemusic/hellfirepeninsula/he_citadeldemonwalkuni01.mp3#53", "zonemusic/hellfirepeninsula/he_citadeldemonwalkuni02.mp3#63", "zonemusic/hellfirepeninsula/he_citadelintrouni01.mp3#19", "zonemusic/hellfirepeninsula/he_pathofgloryintrouni01.mp3#18", "zonemusic/hellfirepeninsula/he_stairsintrouni01.mp3#18", "zonemusic/hellfirepeninsula/he_wistfulintrouni01.mp3#25", "zonemusic/hellfirepeninsula/he_wistfulintrouni02.mp3#17"})
	Zn(L["New Tracks"], L["New Tracks"], L["Icecrown (Intros)"]                            , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Icecrown (Intros)"], prefol, "zonemusic/icecrownglacier/ic_generalintro_01.mp3#58", "zonemusic/icecrownglacier/ic_generalintro_02.mp3#56", "zonemusic/icecrownglacier/ic_generalintro_03.mp3#57"})
	Zn(L["New Tracks"], L["New Tracks"], L["Iron Dwarf (Northrend)"]               , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Iron Dwarf (Northrend)"], prefol, "zonemusic/northrend/irondwarf/nr_dwarf_generalwalkadark_uni01.mp3#112", "zonemusic/northrend/irondwarf/nr_dwarf_generalwalka_day01.mp3#99", "zonemusic/northrend/irondwarf/nr_dwarf_generalwalka_night01.mp3#99", "zonemusic/northrend/irondwarf/nr_dwarf_generalwalkb_day02.mp3#97", "zonemusic/northrend/irondwarf/nr_dwarf_generalwalkb_night02.mp3#95", "zonemusic/northrend/irondwarf/nr_dwarf_generalwalkb_uni02.mp3#164", "zonemusic/northrend/irondwarf/nr_dwarf_generalwalkcdark_uni04.mp3#82", "zonemusic/northrend/irondwarf/nr_dwarf_generalwalkc_day03.mp3#42", "zonemusic/northrend/irondwarf/nr_dwarf_generalwalkc_night03.mp3#42", "zonemusic/northrend/irondwarf/nr_dwarf_generalwalkc_uni03.mp3#42", "zonemusic/northrend/irondwarf/nr_dwarf_generalwalkddark_uni05.mp3#69", "zonemusic/northrend/irondwarf/nr_dwarf_generalwalkd_day04.mp3#45", "zonemusic/northrend/irondwarf/nr_dwarf_generalwalkd_night04.mp3#45"})
	Zn(L["New Tracks"], L["New Tracks"], L["Ironforge (Extra)"]                            , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Ironforge (Extra)"], prefol, "citymusic/ironforge/ironforge walking 01.mp3#123", "citymusic/ironforge/ironforge walking 03 (glenn).mp3#81", "citymusic/ironforge/ironforge walking 04.mp3#70", "citymusic/ironforge/ironforge walking 02.mp3#50"})
	Zn(L["New Tracks"], L["New Tracks"], L["Moments (Guld/Titans)"]                    , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Moments (Guld/Titans)"], prefol, "musical moments/guldansentrancetheme.mp3#100", "musical moments/sp_templeofstormsactionuni01.mp3#79"})
	Zn(L["New Tracks"], L["New Tracks"], L["Nagrand (Diamond)"]                      , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Nagrand (Diamond)"], prefol, "zonemusic/nagrand/na_diamondintrouni01.mp3#73"})
	Zn(L["New Tracks"], L["New Tracks"], L["Netherstorm (Plant Intros)"]                   , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Netherstorm (Plant Intros)"], prefol, "zonemusic/netherstorm/ns_mushroomintrouni01.mp3#39", "zonemusic/netherstorm/ns_mushroomintrouni02.mp3#33", "zonemusic/netherstorm/ns_mushroomintrouni03.mp3#37", "zonemusic/netherstorm/ns_netherplantintrouni01.mp3#44", "zonemusic/netherstorm/ns_netherplantintrouni02.mp3#51", "zonemusic/netherstorm/ns_netherplantintrouni03.mp3#47", "zonemusic/netherstorm/ns_netherplantintrouni04.mp3#45"})
	Zn(L["New Tracks"], L["New Tracks"], L["Northrend Transport"]                          , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Northrend Transport"], prefol, "zonemusic/northrend/northrendtransport/nr_northrendtransportgeneralday.mp3#152", "zonemusic/northrend/northrendtransport/nr_northrendtransportgeneralnight.mp3#92"})
	Zn(L["New Tracks"], L["New Tracks"], L["Northrend Orc Themes"]                         , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Northrend Orc Themes"], prefol, "zonemusic/northrend/orc/nr_orc_generalwalk_day01.mp3#23", "zonemusic/northrend/orc/nr_orc_generalwalk_day02.mp3#23", "zonemusic/northrend/orc/nr_orc_generalwalk_day03.mp3#23", "zonemusic/northrend/orc/nr_orc_generalwalk_day04.mp3#45", "zonemusic/northrend/orc/nr_orc_generalwalk_night01.mp3#78", "zonemusic/northrend/orc/nr_orc_generalwalk_night02.mp3#80", "zonemusic/northrend/orc/nr_orc_generalwalk_night03.mp3#79", "zonemusic/northrend/orc/nr_orc_general_intro01.mp3#27"})
	Zn(L["New Tracks"], L["New Tracks"], L["Orgrimmar (Moments)"]                          , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Orgrimmar (Moments)"], prefol, "citymusic/orgrimmar/orgrimmar01-moment.mp3#69"})
	Zn(L["New Tracks"], L["New Tracks"], L["Outland (Action/Corrupt)"]           , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Outland (Action/Corrupt)"], prefol, "zonemusic/outlandgeneral/ol_actionwalkuni01.mp3#80", "zonemusic/outlandgeneral/ol_corrupt01.mp3#61", "zonemusic/outlandgeneral/ol_corrupt02.mp3#62", "zonemusic/outlandgeneral/ol_corrupt03.mp3#74", "zonemusic/outlandgeneral/ol_corrupt04.mp3#71", "zonemusic/outlandgeneral/ol_corrupt05.mp3#72", "zonemusic/outlandgeneral/ol_corrupt06.mp3#74", "zonemusic/outlandgeneral/ol_corrupt07.mp3#52", "zonemusic/outlandgeneral/ol_corruptintro.mp3#75", "zonemusic/outlandgeneral/ol_arakkoaintrouni01.mp3#18", "zonemusic/outlandgeneral/ol_arakkoaintrouni02.mp3#14", "zonemusic/outlandgeneral/ol_burninglegionintrouni01.mp3#16", "zonemusic/outlandgeneral/ol_burninglegionintrouni02.mp3#35", "zonemusic/outlandgeneral/ol_cenarionintrouni01.mp3#44", "zonemusic/outlandgeneral/ol_cenarionintrouni02.mp3#45", "zonemusic/outlandgeneral/ol_cenarionintrouni03.mp3#71", "zonemusic/outlandgeneral/ol_crystalintrouni01.mp3#26", "zonemusic/outlandgeneral/ol_crystalintrouni02.mp3#21", "zonemusic/outlandgeneral/ol_crystalintrouni03.mp3#21", "zonemusic/outlandgeneral/ol_demonintrouni01.mp3#46", "zonemusic/outlandgeneral/ol_felorcintrouni01.mp3#16", "zonemusic/outlandgeneral/ol_felorcintrouni02.mp3#15", "zonemusic/outlandgeneral/ol_hordebasewalkuni01.mp3#40", "zonemusic/outlandgeneral/ol_hordebasewalkuni02.mp3#37", "zonemusic/outlandgeneral/ol_illidansarmyintrouni01.mp3#35", "zonemusic/outlandgeneral/ol_ogreintrouni01.mp3#28", "zonemusic/outlandgeneral/ol_ogreintrouni02.mp3#25", "zonemusic/outlandgeneral/ol_orcintrouni01.mp3#11", "zonemusic/outlandgeneral/ol_orcintrouni02.mp3#17", "zonemusic/outlandgeneral/ol_orcintrouni03.mp3#11", "zonemusic/outlandgeneral/ol_orcintrouni04.mp3#13", "zonemusic/outlandgeneral/ol_scenicintrouni01.mp3#31"})
	Zn(L["New Tracks"], L["New Tracks"], L["Sholazar (Lifeblood Cave)"]                    , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Sholazar (Lifeblood Cave)"], prefol, "zonemusic/sholazarbasin/sb_lifebloodcavewalkuni01.mp3#81", "zonemusic/sholazarbasin/sb_lifebloodcavewalkuni02.mp3#99", "zonemusic/sholazarbasin/sb_lifebloodcavewalkuni03.mp3#99"})
	Zn(L["New Tracks"], L["New Tracks"], L["Stormwind (High Seas)"]                        , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Stormwind (High Seas)"], prefol, "citymusic/stormwind/stormwind_highseas-moment.mp3#133"})
	Zn(L["New Tracks"], L["New Tracks"], L["Sunwell Plateau (Extra)"]                      , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Sunwell Plateau (Extra)"], prefol, "zonemusic/sunwell/sw_felenergywalkuni01.mp3#126", "zonemusic/sunwell/sw_isledarkwalkuni01.mp3#139", "zonemusic/sunwell/sw_isledarkwalkuni02.mp3#137", "zonemusic/sunwell/sw_isledarkwalkuni03.mp3#126", "zonemusic/sunwell/sw_islelightwalkuni01.mp3#115", "zonemusic/sunwell/sw_islelightwalkuni02.mp3#119", "zonemusic/sunwell/sw_islelightwalkuni03.mp3#90", "zonemusic/sunwell/sw_islemedwalkuni01.mp3#117", "zonemusic/sunwell/sw_islemedwalkuni02.mp3#126", "zonemusic/sunwell/sw_islemedwalkuni03.mp3#88", "zonemusic/sunwell/sw_magistersarrivalwalkuni01.mp3#87", "zonemusic/sunwell/sw_plateausunwellarrivalwalkuni01.mp3#138", "zonemusic/sunwell/sw_queldanaswalkuni01.mp3#108", "zonemusic/sunwell/sw_queldanaswalkuni02.mp3#84", "zonemusic/sunwell/sw_sanctumwalkuni01.mp3#85", "zonemusic/sunwell/sw_sunwellbombingrununi01.mp3#259", "zonemusic/sunwell/sw_sunwellflybyuni01.mp3#57", "zonemusic/sunwell/sw_thewellwalkuni01.mp3#98", "zonemusic/sunwell/sw_thewellwalkuni02.mp3#95", "zonemusic/sunwell/sw_thewellwalkuni03.mp3#95"})
	Zn(L["New Tracks"], L["New Tracks"], L["Taunka (Northrend)"]                    , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Taunka (Northrend)"], prefol, "zonemusic/northrend/taunka/nr_taunka_generalwalka_day01.mp3#138", "zonemusic/northrend/taunka/nr_taunka_generalwalka_night01.mp3#141", "zonemusic/northrend/taunka/nr_taunka_generalwalka_uni01.mp3#140", "zonemusic/northrend/taunka/nr_taunka_generalwalkb_day02.mp3#127", "zonemusic/northrend/taunka/nr_taunka_generalwalkb_night02.mp3#127", "zonemusic/northrend/taunka/nr_taunka_generalwalkc_day03.mp3#108", "zonemusic/northrend/taunka/nr_taunka_generalwalkc_night03.mp3#108", "zonemusic/northrend/taunka/nr_taunka_generalwalkd_day04.mp3#70", "zonemusic/northrend/taunka/nr_taunka_generalwalkd_night04.mp3#69", "zonemusic/northrend/taunka/nr_taunka_generalwalkd_uni02.mp3#70", "zonemusic/northrend/taunka/nr_taunka_generalwalke_uni03.mp3#73"})
	Zn(L["New Tracks"], L["New Tracks"], L["Various Taverns"]                              , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Various Taverns"], prefol, "zonemusic/taverndwarf/ra_dwarftavern1a.mp3#79", "zonemusic/taverndwarf/ra_dwarftavern1b.mp3#82", "zonemusic/taverndwarf/ra_dwarftavern2a.mp3#86", "zonemusic/taverndwarf/ra_dwarftavern2b.mp3#92", "zonemusic/taverndwarf/ra_dwarftavern3.mp3#102", "zonemusic/tavernhuman/ra_tavern1_revisiteda.mp3#70", "zonemusic/tavernhuman/ra_tavern1_revisitedb.mp3#72", "zonemusic/tavernhuman/ra_humantavern1a.mp3#92", "zonemusic/tavernhuman/ra_humantavern1b.mp3#79", "zonemusic/tavernhuman/ra_humantavern2a.mp3#86", "zonemusic/tavernhuman/ra_humantavern2b.mp3#81", "zonemusic/tavernnightelf/ra_templeofthemoona.mp3#112", "zonemusic/tavernnightelf/ra_templeofthemoonb.mp3#119", "zonemusic/tavernorc/ra_orcrestarea1a.mp3#100", "zonemusic/tavernorc/ra_orcrestarea1b.mp3#91", "zonemusic/tavernorc/ra_orcrestarea2a.mp3#87", "zonemusic/tavernorc/ra_orcrestarea2b.mp3#86", "zonemusic/tavernorc/ra_orcrestarea3a.mp3#86", "zonemusic/tavernorc/ra_orcrestarea3b.mp3#81", "zonemusic/tavernpirate/ra_piratetavern1a.mp3#83", "zonemusic/tavernpirate/ra_piratetavern1b.mp3#81", "zonemusic/tavernpirate/ra_piratetavern2a.mp3#82", "zonemusic/tavernpirate/ra_piratetavern2b.mp3#81", "zonemusic/tavernpirate/ra_piratetavern3a.mp3#88", "zonemusic/tavernpirate/ra_piratetavern3b.mp3#85", "zonemusic/taverntauren/ra_taurenrestarea1a.mp3#89", "zonemusic/taverntauren/ra_taurenrestarea1b.mp3#96", "zonemusic/taverntauren/ra_taurenrestarea2a.mp3#85", "zonemusic/taverntauren/ra_taurenrestarea2b.mp3#80", "zonemusic/taverntauren/ra_taurenrestarea3a.mp3#93", "zonemusic/taverntauren/ra_taurenrestarea3b.mp3#93", "zonemusic/tavernundead/ra_undeadtavern1a.mp3#93", "zonemusic/tavernundead/ra_undeadtavern1b.mp3#87", "zonemusic/tavernundead/ra_undeadtavern2.mp3#124", "zonemusic/tavernundead/ra_undeadtavern3a.mp3#83", "zonemusic/tavernundead/ra_undeadtavern3b.mp3#93"})
	Zn(L["New Tracks"], L["New Tracks"], L["Tempest Keep (Extra)"]                         , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Tempest Keep (Extra)"], prefol, "zonemusic/tempestkeep/tk_tempestkeep_amb_22.mp3#34", "zonemusic/tempestkeep/tk_tempestkeep_stg14.mp3#11", "zonemusic/tempestkeep/tk_tempestkeep_stg15.mp3#11", "zonemusic/tempestkeep/tk_tempestkeep_stg16.mp3#11"})
	Zn(L["New Tracks"], L["New Tracks"], L["Terokkar (Shattrath/Auch.)"]                   , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Terokkar (Shattrath/Auch.)"], prefol, "zonemusic/terokkar/tf_auchindounwalkuni01.mp3#120", "zonemusic/terokkar/tf_auchindounwalkuni02.mp3#150", "zonemusic/terokkar/tf_auchindounwalkuni03.mp3#120", "zonemusic/terokkar/tf_shattrathwalkuni01.mp3#137", "zonemusic/terokkar/tf_shattrathwalkuni02.mp3#100", "zonemusic/terokkar/tf_shattrathwalkuni03.mp3#92", "zonemusic/terokkar/tf_shattrathwalkuni04.mp3#82", "zonemusic/terokkar/tf_shattrathwalkuni05.mp3#117", "zonemusic/terokkar/tf_shattrathwalkuni06.mp3#137"})
	Zn(L["New Tracks"], L["New Tracks"], L["Northrend Troll Themes"]                       , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Northrend Troll Themes"], prefol, "zonemusic/northrend/troll/nr_troll_general01.mp3#46", "zonemusic/northrend/troll/nr_troll_general02.mp3#55", "zonemusic/northrend/troll/nr_troll_general03.mp3#38", "zonemusic/northrend/troll/nr_troll_general04.mp3#44"})
	Zn(L["New Tracks"], L["New Tracks"], L["Violet Hold"]                                  , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Violet Hold"], prefol, "zonemusic/violethold/vh_generalwalkuni01.mp3#83", "zonemusic/violethold/vh_generalwalkuni02.mp3#83", "zonemusic/violethold/vh_generalwalkuni03.mp3#69"})
	Zn(L["New Tracks"], L["New Tracks"], L["Events (Fire Festival)"]                       , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Events (Fire Festival)"], prefol, "worldevents/alliancefirepole.mp3#68", "worldevents/hordefirepole.mp3#72"})
	Zn(L["New Tracks"], L["New Tracks"], L["L70ETC Tracks"]                                , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["L70ETC Tracks"], prefol, "zonemusic/dmf_l70etc01.mp3#282"})
	Zn(L["New Tracks"], L["New Tracks"], L["Zul'Aman (Battle/Victory)"]                    , {"|cffffd800" .. L["New Tracks"] .. ": " .. L["Zul'Aman (Battle/Victory)"], prefol, "zonemusic/zulaman/za_zulaman_btl11.mp3#136", "zonemusic/zulaman/za_zulaman_btl12.mp3#117", "zonemusic/zulaman/za_zulaman_btl13.mp3#40", "zonemusic/zulaman/za_zulaman_btl14.mp3#92", "zonemusic/zulaman/za_zulaman_btl15.mp3#79", "zonemusic/zulaman/za_zulaman_vct10.mp3#80"})
	----------------------------------------------------------------------
	-- Movies
	----------------------------------------------------------------------

	-- In your Leatrix_Plus database file (e.g., Leatrix_Plus_DB.lua)

	-- Ensure L is available (Localization table)
	-- local L = Leatrix_Plus.L or {}; -- Or however your localization is loaded

	-- MOVIE_PATHS contains the specific file paths your addon will use.
	-- Keys are descriptive and used by the GetMoviePath helper.
	local MOVIE_PATHS = {
		WOW_LOGO_800 = "Interface\\Cinematics\\Logo_800",
		WOW_LOGO_1024 = "Interface\\Cinematics\\Logo_1024",
		WOW_INTRO_800 = "Interface\\Cinematics\\WOW_Intro_800",
		WOW_INTRO_1024 = "Interface\\Cinematics\\WOW_Intro_1024",
		TBC_INTRO_800 = "Interface\\Cinematics\\WOW_Intro_BC_800",
		TBC_INTRO_1024 = "Interface\\Cinematics\\WOW_Intro_BC_1024",
		WOTLK_INTRO_800 = "Interface\\Cinematics\\WOW_Intro_LK_800",
		WOTLK_INTRO_1024 = "Interface\\Cinematics\\WOW_Intro_LK_1024",
	}

	-- Simplified helper function:
	-- Tries to get the 1024 resolution path, then falls back to 800, from MOVIE_PATHS.
	local function GetMoviePath(highResKey, lowResKey)
		if MOVIE_PATHS[highResKey] then
			return MOVIE_PATHS[highResKey]
		elseif MOVIE_PATHS[lowResKey] then
			return MOVIE_PATHS[lowResKey]
		end
		-- Optional: return a specific "not found" key if neither is found,
		-- or just nil and let the ( ... or "nil_path_..." ) handle it.
		return nil
	end


	-- Zn calls now use the simpler GetMoviePath function.
	-- Each movie has one entry, preferring 1024 resolution.
	Zn(L["Movies"], L["Movies"], L["World of Warcraft"], {
		"|cffffd800" .. L["Movies"] .. ": " .. L["World of Warcraft"], prefol,
		L["WoW Cinematic Logo"] .. " |r" .. (GetMoviePath("WOW_LOGO_1024", "WOW_LOGO_800") or "nil_path_logo"),
		L["World of Warcraft Intro"] .. " |r" .. (GetMoviePath("WOW_INTRO_1024", "WOW_INTRO_800") or "nil_path_wow_intro"),
	})

	Zn(L["Movies"], L["Movies"], L["The Burning Crusade"], {
		"|cffffd800" .. L["Movies"] .. ": " .. L["The Burning Crusade"], prefol,
		L["The Burning Crusade Intro"] .. " |r" .. (GetMoviePath("TBC_INTRO_1024", "TBC_INTRO_800") or "nil_path_tbc_intro"),
	})

	Zn(L["Movies"], L["Movies"], L["Wrath of the Lich King"], {
		"|cffffd800" .. L["Movies"] .. ": " .. L["Wrath of the Lich King"], prefol,
		L["Wrath of the Lich King Intro"] .. " |r" .. (GetMoviePath("WOTLK_INTRO_1024", "WOTLK_INTRO_800") or "nil_path_wotlk_intro"),
	})

	-- ... (rest of your database definitions for music, etc.)
	----------------------------------------------------------------------
	-- End
	----------------------------------------------------------------------

	-- Give zone table a file level scope (its used in search)
	Leatrix_Plus["ZoneList"] = ZoneList

