﻿
	----------------------------------------------------------------------
	-- Leatrix Plus Flight Horde
	----------------------------------------------------------------------

	local void, Leatrix_Plus = ...
	local L = Leatrix_Plus.L

	-- Function to load flight data (load-on-demand)
	function Leatrix_Plus:LoadFlightDataHorde()

		Leatrix_Plus["FlightData"]["Horde"] = {

			----------------------------------------------------------------------
			--	Horde
			----------------------------------------------------------------------

			-- Horde: Eastern Kingdoms
			[2] = {

				-- Horde: Acherus (Eastern Plaguelands)
				["0.62:0.66:0.61:0.65:0.61:0.73:0.58:0.94"] = 392, -- Acherus: The Ebon Hold, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.62:0.66:0.61:0.65:0.58:0.75:0.59:0.82"] = 234, -- Acherus: The Ebon Hold, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.62:0.66:0.61:0.65:0.58:0.75"] = 169, -- Acherus: The Ebon Hold, Light's Hope Chapel, Tranquillien
				["0.62:0.66:0.61:0.65:0.61:0.73"] = 145, -- Acherus: The Ebon Hold, Light's Hope Chapel, Zul'Aman
				["0.62:0.66:0.61:0.65"] = 52, -- Acherus: The Ebon Hold, Light's Hope Chapel
				["0.62:0.66:0.61:0.65:0.51:0.64"] = 147, -- Acherus: The Ebon Hold, Light's Hope Chapel, Thondoril River
				["0.62:0.66:0.61:0.65:0.51:0.64:0.45:0.63"] = 223, -- Acherus: The Ebon Hold, Light's Hope Chapel, Thondoril River, The Bulwark
				["0.62:0.66:0.61:0.65:0.51:0.64:0.42:0.63"] = 307, -- Acherus: The Ebon Hold, Light's Hope Chapel, Thondoril River, Undercity
				["0.62:0.66:0.61:0.65:0.51:0.64:0.46:0.57:0.37:0.59"] = 350, -- Acherus: The Ebon Hold, Light's Hope Chapel, Thondoril River, Tarren Mill, The Sepulcher
				["0.62:0.66:0.61:0.65:0.51:0.64:0.46:0.57"] = 247, -- Acherus: The Ebon Hold, Light's Hope Chapel, Thondoril River, Tarren Mill
				["0.62:0.66:0.61:0.65:0.59:0.55:0.55:0.54"] = 282, -- Acherus: The Ebon Hold, Light's Hope Chapel, Revantusk Village, Hammerfall
				["0.62:0.66:0.61:0.65:0.59:0.55"] = 189, -- Acherus: The Ebon Hold, Light's Hope Chapel, Revantusk Village
				["0.62:0.66:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.46:0.35"] = 595, -- Acherus: The Ebon Hold, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Thorium Point
				["0.62:0.66:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34"] = 540, -- Acherus: The Ebon Hold, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath
				["0.62:0.66:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.50:0.31"] = 606, -- Acherus: The Ebon Hold, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Flame Crest
				["0.62:0.66:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.54:0.21"] = 763, -- Acherus: The Ebon Hold, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Stonard
				["0.62:0.66:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.42:0.14"] = 777, -- Acherus: The Ebon Hold, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Grom'gol
				["0.62:0.66:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.41:0.07"] = 836, -- Acherus: The Ebon Hold, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Booty Bay
				["0.62:0.66:0.61:0.65:0.42:0.63"] = 310, -- Acherus: The Ebon Hold, Light's Hope Chapel, Undercity
				["0.62:0.66:0.61:0.65:0.42:0.63:0.37:0.59"] = 345, -- Acherus: The Ebon Hold, Light's Hope Chapel, Undercity, The Sepulcher
				["0.62:0.66:0.61:0.65:0.59:0.55:0.46:0.57"] = 348, -- Acherus: The Ebon Hold, Light's Hope Chapel, Revantusk Village, Tarren Mill
				["0.62:0.66:0.61:0.65:0.42:0.63:0.45:0.63"] = 328, -- Acherus: The Ebon Hold, Light's Hope Chapel, Undercity, The Bulwark
				["0.62:0.66:0.61:0.65:0.58:0.75:0.59:0.82:0.58:0.94"] = 417, -- Acherus: The Ebon Hold, Light's Hope Chapel, Tranquillien, Silvermoon City, Shattered Sun Staging Area

				-- Horde: Booty Bay (Stranglethorn Vale)
				["0.41:0.07:0.42:0.14"] = 75, -- Booty Bay, Grom'gol
				["0.41:0.07:0.54:0.21"] = 240, -- Booty Bay, Stonard
				["0.41:0.07:0.42:0.14:0.50:0.31"] = 273, -- Booty Bay, Grom'gol, Flame Crest
				["0.41:0.07:0.50:0.34"] = 315, -- Booty Bay, Kargath
				["0.41:0.07:0.42:0.14:0.50:0.31:0.46:0.35"] = 304, -- Booty Bay, Grom'gol, Flame Crest, Thorium Point
				["0.41:0.07:0.50:0.34:0.55:0.54:0.46:0.57:0.37:0.59"] = 789, -- Booty Bay, Kargath, Hammerfall, Tarren Mill, The Sepulcher
				["0.41:0.07:0.50:0.34:0.42:0.63"] = 811, -- Booty Bay, Kargath, Undercity
				["0.41:0.07:0.50:0.34:0.55:0.54:0.46:0.57"] = 692, -- Booty Bay, Kargath, Hammerfall, Tarren Mill
				["0.41:0.07:0.50:0.34:0.55:0.54"] = 576, -- Booty Bay, Kargath, Hammerfall
				["0.41:0.07:0.50:0.34:0.55:0.54:0.59:0.55"] = 665, -- Booty Bay, Kargath, Hammerfall, Revantusk Village
				["0.41:0.07:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65"] = 804, -- Booty Bay, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel
				["0.41:0.07:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75"] = 920, -- Booty Bay, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien
				["0.41:0.07:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75:0.59:0.82"] = 986, -- Booty Bay, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.41:0.07:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73"] = 897, -- Booty Bay, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman
				["0.41:0.07:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73:0.58:0.94"] = 1145, -- Booty Bay, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.41:0.07:0.50:0.34:0.42:0.63:0.61:0.65"] = 1000, -- Booty Bay, Kargath, Undercity, Light's Hope Chapel
				["0.41:0.07:0.50:0.34:0.46:0.35"] = 370, -- Booty Bay, Kargath, Thorium Point
				["0.41:0.07:0.50:0.34:0.50:0.31"] = 381, -- Booty Bay, Kargath, Flame Crest
				["0.41:0.07:0.50:0.34:0.55:0.54:0.46:0.57:0.45:0.63"] = 760, -- Booty Bay, Kargath, Hammerfall, Tarren Mill, The Bulwark
				["0.41:0.07:0.50:0.34:0.55:0.54:0.46:0.57:0.51:0.64"] = 792, -- Booty Bay, Kargath, Hammerfall, Tarren Mill, Thondroril River
				["0.41:0.07:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.62:0.66"] = 864, -- Booty Bay, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.41:0.07:0.50:0.34:0.42:0.63:0.46:0.57"] = 881, -- Booty Bay, Kargath, Undercity, Tarren Mill
				["0.41:0.07:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75:0.59:0.82:0.58:0.94"] = 1169, -- Booty Bay, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien, Silvermoon City, Shattered Sun Staging Area
				["0.41:0.07:0.50:0.34:0.55:0.54:0.46:0.57:0.51:0.64:0.61:0.65:0.61:0.73:0.58:0.94"] = 1228, -- Booty Bay, Kargath, Hammerfall, Tarren Mill, Thondoril River, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.41:0.07:0.50:0.34:0.42:0.63:0.61:0.65:0.61:0.73:0.58:0.94"] = 1339, -- Beutebucht, Kargath, Unterstadt, Kapelle des hoffnungsvollen Lichts, Zul'Aman, Sammelpunkt der Zerschmetterten Sonne
				["0.41:0.07:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73:0.58:0.94:0.59:0.82"] = 1311, -- Booty Bay, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area, Silvermoon City
				["0.41:0.07:0.50:0.34:0.42:0.63:0.61:0.65:0.58:0.75:0.59:0.82:0.58:0.94"] = 1365, -- Booty Bay, Kargath, Undercity, Light's Hope Chapel, Tranquillien, Silvermoon City, Shattered Sun Staging Area
				["0.41:0.07:0.50:0.34:0.55:0.54:0.46:0.57:0.51:0.64:0.61:0.65"] = 887, -- Booty Bay, Kargath, Hammerfall, Tarren Mill, Thondoril River, Light's Hope Chapel
				["0.41:0.07:0.50:0.34:0.42:0.63:0.59:0.55"] = 1019, -- Booty Bay, Kargath, Undercity, Revantusk Village
				["0.41:0.07:0.50:0.34:0.42:0.63:0.37:0.59"] = 845, -- Booty Bay, Kargath, Undercity, The Sepulcher

				-- Horde: Flame Crest (Burning Steppes)
				["0.50:0.31:0.42:0.14:0.41:0.07"] = 284, -- Flame Crest, Grom'gol, Booty Bay
				["0.50:0.31:0.42:0.14"] = 207, -- Flame Crest, Grom'gol
				["0.50:0.31:0.54:0.21"] = 192, -- Flame Crest, Stonard
				["0.50:0.31:0.50:0.34"] = 81, -- Flame Crest, Kargath
				["0.50:0.31:0.46:0.35"] = 62, -- Flame Crest, Thorium Point
				["0.50:0.31:0.50:0.34:0.55:0.54:0.46:0.57:0.37:0.59"] = 557, -- Flame Crest, Kargath, Hammerfall, Tarren Mill, The Sepulcher
				["0.50:0.31:0.50:0.34:0.42:0.63"] = 578, -- Flame Crest, Kargath, Undercity
				["0.50:0.31:0.50:0.34:0.55:0.54:0.46:0.57"] = 458, -- Flame Crest, Kargath, Hammerfall, Tarren Mill
				["0.50:0.31:0.50:0.34:0.55:0.54"] = 343, -- Flame Crest, Kargath, Hammerfall
				["0.50:0.31:0.50:0.34:0.55:0.54:0.59:0.55"] = 433, -- Flame Crest, Kargath, Hammerfall, Revantusk Village
				["0.50:0.31:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65"] = 571, -- Flame Crest, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel
				["0.50:0.31:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75"] = 687, -- Flame Crest, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien
				["0.50:0.31:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75:0.59:0.82"] = 754, -- Flame Crest, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.50:0.31:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73:0.58:0.94"] = 912, -- Flame Crest, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.50:0.31:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73"] = 665, -- Flame Crest, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman
				["0.50:0.31:0.50:0.34:0.41:0.07"] = 378, -- Flame Crest, Kargath, Booty Bay
				["0.50:0.31:0.50:0.34:0.55:0.54:0.46:0.57:0.45:0.63"] = 527, -- Flame Crest, Kargath, Hammerfall, Tarren Mill, The Bulwark
				["0.50:0.31:0.50:0.34:0.55:0.54:0.46:0.57:0.51:0.64"] = 559, -- Flame Crest, Kargath, Hammerfall, Tarren Mill, Thondroril River
				["0.50:0.31:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.62:0.66"] = 632, -- Flame Crest, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.50:0.31:0.50:0.34:0.42:0.63:0.46:0.57"] = 645, -- Flame Crest, Kargath, Undercity, Tarren Mill
				["0.50:0.31:0.50:0.34:0.42:0.63:0.61:0.65"] = 767, -- Flame Crest, Kargath, Undercity, Light's Hope Chapel
				["0.50:0.31:0.54:0.21:0.41:0.07"] = 282, -- Flame Crest, Stonard, Booty Bay
				["0.50:0.31:0.50:0.34:0.42:0.63:0.45:0.63"] = 597, -- Flame Crest, Kargath, Undercity, The Bulwark
				["0.50:0.31:0.50:0.34:0.42:0.63:0.59:0.55"] = 787, -- Flame Crest, Kargath, Undercity, Revantusk Village

				-- Horde: Grom'gol (Stranglethorn Vale)
				["0.42:0.14:0.41:0.07"] = 78, -- Grom'gol, Booty Bay
				["0.42:0.14:0.54:0.21"] = 173, -- Grom'gol, Stonard
				["0.42:0.14:0.50:0.31"] = 198, -- Grom'gol, Flame Crest
				["0.42:0.14:0.50:0.34"] = 246, -- Grom'gol, Kargath
				["0.42:0.14:0.50:0.31:0.46:0.35"] = 230, -- Grom'gol, Flame Crest, Thorium Point
				["0.42:0.14:0.50:0.34:0.55:0.54:0.46:0.57:0.37:0.59"] = 722, -- Grom'gol, Kargath, Hammerfall, Tarren Mill, The Sepulcher
				["0.42:0.14:0.50:0.34:0.42:0.63"] = 743, -- Grom'gol, Kargath, Undercity
				["0.42:0.14:0.50:0.34:0.55:0.54:0.46:0.57"] = 624, -- Grom'gol, Kargath, Hammerfall, Tarren Mill
				["0.42:0.14:0.50:0.34:0.55:0.54"] = 508, -- Grom'gol, Kargath, Hammerfall
				["0.42:0.14:0.50:0.34:0.55:0.54:0.59:0.55"] = 597, -- Grom'gol, Kargath, Hammerfall, Revantusk Village
				["0.42:0.14:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65"] = 736, -- Grom'gol, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel
				["0.42:0.14:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75"] = 851, -- Grom'gol, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien
				["0.42:0.14:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75:0.59:0.82"] = 918, -- Grom'gol, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.42:0.14:0.50:0.34:0.46:0.35"] = 302, -- Grom'gol, Kargath, Thorium Point
				["0.42:0.14:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73"] = 829, -- Grom'gol, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman
				["0.42:0.14:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73:0.58:0.94"] = 1077, -- Grom'gol, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.42:0.14:0.50:0.34:0.55:0.54:0.46:0.57:0.45:0.63"] = 692, -- Grom'gol, Kargath, Hammerfall, Tarren Mill, The Bulwark
				["0.42:0.14:0.50:0.34:0.55:0.54:0.46:0.57:0.51:0.64"] = 724, -- Grom'gol, Kargath, Hammerfall, Tarren Mill, Thondroril River
				["0.42:0.14:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.62:0.66"] = 797, -- Grom'gol, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.42:0.14:0.50:0.34:0.42:0.63:0.46:0.57"] = 810, -- Grom'gol, Kargath, Undercity, Tarren Mill
				["0.42:0.14:0.50:0.34:0.42:0.63:0.59:0.55"] = 952, -- Grom'gol, Kargath, Undercity, Revantusk Village
				["0.42:0.14:0.50:0.34:0.42:0.63:0.61:0.65:0.61:0.73:0.58:0.94"] = 1271, -- Grom'gol, Kargath, Undercity, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.42:0.14:0.50:0.34:0.42:0.63:0.37:0.59"] = 778, -- Grom'gol, Kargath, Undercity, The Sepulcher
				["0.42:0.14:0.50:0.34:0.42:0.63:0.61:0.65:0.61:0.73:0.58:0.94:0.59:0.82"] = 1435, -- Grom'gol, Kargath, Undercity, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area, Silvermoon City
				["0.42:0.14:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73:0.58:0.94:0.59:0.82"] = 1246, -- Grom'gol, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area, Silvermoon City

				-- Horde: Hammerfall (Arathi Highlands)
				["0.55:0.54:0.50:0.34:0.41:0.07"] = 556, -- Hammerfall, Kargath, Booty Bay
				["0.55:0.54:0.50:0.34:0.42:0.14"] = 497, -- Hammerfall, Kargath, Grom'gol
				["0.55:0.54:0.50:0.34:0.54:0.21"] = 482, -- Hammerfall, Kargath, Stonard
				["0.55:0.54:0.50:0.34:0.50:0.31"] = 326, -- Hammerfall, Kargath, Flame Crest
				["0.55:0.54:0.50:0.34"] = 259, -- Hammerfall, Kargath
				["0.55:0.54:0.50:0.34:0.46:0.35"] = 315, -- Hammerfall, Kargath, Thorium Point
				["0.55:0.54:0.59:0.55"] = 91, -- Hammerfall, Revantusk Village
				["0.55:0.54:0.59:0.55:0.61:0.65"] = 229, -- Hammerfall, Revantusk Village, Light's Hope Chapel
				["0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75"] = 345, -- Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien
				["0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75:0.59:0.82"] = 411, -- Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.55:0.54:0.42:0.63"] = 259, -- Hammerfall, Undercity
				["0.55:0.54:0.46:0.57"] = 117, -- Hammerfall, Tarren Mill
				["0.55:0.54:0.46:0.57:0.37:0.59"] = 215, -- Hammerfall, Tarren Mill, The Sepulcher
				["0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73"] = 322, -- Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman
				["0.55:0.54:0.46:0.57:0.42:0.63:0.61:0.65:0.61:0.73"] = 532, -- Hammerfall, Tarren Mill, Undercity, Light's Hope Chapel, Zul'Aman
				["0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73:0.58:0.94"] = 571, -- Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.55:0.54:0.46:0.57:0.42:0.63:0.61:0.65"] = 441, -- Hammerfall, Tarren Mill, Undercity, Light's Hope Chapel
				["0.55:0.54:0.46:0.57:0.45:0.63"] = 185, -- Hammerfall, Tarren Mill, The Bulwark
				["0.55:0.54:0.46:0.57:0.51:0.64"] = 217, -- Hammerfall, Tarren Mill, Thondroril River
				["0.55:0.54:0.59:0.55:0.61:0.65:0.62:0.66"] = 290, -- Hammerfall, Revantusk Village, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.55:0.54:0.46:0.57:0.51:0.64:0.61:0.65:0.58:0.75:0.59:0.82"] = 497, -- Hammerfall, Tarren Mill, Thondoril River, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.55:0.54:0.46:0.57:0.51:0.64:0.61:0.65:0.58:0.75"] = 428, -- Hammerfall, Tarren Mill, Thondoril River, Light's Hope Chapel, Tranquillien

				-- Horde: Kargath (Badlands)
				["0.50:0.34:0.41:0.07"] = 298, -- Kargath, Booty Bay
				["0.50:0.34:0.42:0.14"] = 239, -- Kargath, Grom'gol
				["0.50:0.34:0.54:0.21"] = 225, -- Kargath, Stonard
				["0.50:0.34:0.50:0.31"] = 68, -- Kargath, Flame Crest
				["0.50:0.34:0.46:0.35"] = 56, -- Kargath, Thorium Point
				["0.50:0.34:0.55:0.54:0.46:0.57:0.37:0.59"] = 477, -- Kargath, Hammerfall, Tarren Mill, The Sepulcher
				["0.50:0.34:0.42:0.63"] = 498, -- Kargath, Undercity (Ashton reported 344)
				["0.50:0.34:0.55:0.54:0.46:0.57"] = 379, -- Kargath, Hammerfall, Tarren Mill
				["0.50:0.34:0.55:0.54"] = 263, -- Kargath, Hammerfall
				["0.50:0.34:0.55:0.54:0.59:0.55"] = 353, -- Kargath, Hammerfall, Revantusk Village
				["0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65"] = 490, -- Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel
				["0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75"] = 606, -- Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien
				["0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75:0.59:0.82"] = 673, -- Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73"] = 585, -- Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman
				["0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73:0.58:0.94"] = 832, -- Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.50:0.34:0.42:0.63:0.61:0.65"] = 686, -- Kargath, Undercity, Light's Hope Chapel
				["0.50:0.34:0.42:0.63:0.61:0.65:0.58:0.75:0.59:0.82"] = 870, -- Kargath, Undercity, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.50:0.34:0.42:0.63:0.37:0.59"] = 532, -- Kargath, Undercity, The Sepulcher
				["0.50:0.34:0.42:0.63:0.46:0.57"] = 565, -- Kargath, Undercity, Tarren Mill
				["0.50:0.34:0.55:0.54:0.46:0.57:0.45:0.63"] = 447, -- Kargath, Hammerfall, Tarren Mill, The Bulwark
				["0.50:0.34:0.55:0.54:0.46:0.57:0.51:0.64"] = 479, -- Kargath, Hammerfall, Tarren Mill, Thondoril River
				["0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.62:0.66"] = 551, -- Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.50:0.34:0.42:0.63:0.51:0.64"] = 582, -- Kargath, Undercity, Thondoril River
				["0.50:0.34:0.42:0.63:0.45:0.63"] = 517, -- Kargath, Undercity, The Bulwark
				["0.50:0.34:0.42:0.63:0.59:0.55"] = 706, -- Kargath, Undercity, Revantusk Village
				["0.50:0.34:0.42:0.63:0.51:0.64:0.61:0.65"] = 677, -- Kargath, Undercity, Thondoril River, Light's Hope Chapel

				-- Horde: Light's Hope Chapel (Eastern Plaguelands)
				["0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.41:0.07"] = 789, -- Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Booty Bay
				["0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.42:0.14"] = 730, -- Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Grom'gol
				["0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.54:0.21"] = 716, -- Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Stonard
				["0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.50:0.31"] = 560, -- Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Flame Crest
				["0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34"] = 492, -- Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath
				["0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.46:0.35"] = 548, -- Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Thorium Point
				["0.61:0.65:0.59:0.55:0.55:0.54"] = 234, -- Light's Hope Chapel, Revantusk Village, Hammerfall -- 3.3.5 is it ?
				["0.61:0.65:0.59:0.55"] = 141, -- Light's Hope Chapel, Revantusk Village
				["0.61:0.65:0.58:0.75"] = 118, -- Light's Hope Chapel, Tranquillien
				["0.61:0.65:0.58:0.75:0.59:0.82"] = 186, -- Light's Hope Chapel, Tranquillien, Silvermoon City (was 184, changed to 190 by GurnsyTV on CurseForge, changed to 186 by Jon Kipp Lauesen)
				["0.61:0.65:0.59:0.55:0.46:0.57"] = 301, -- Light's Hope Chapel, Revantusk Village, Tarren Mill
				["0.61:0.65:0.42:0.63"] = 262, -- Light's Hope Chapel, Undercity
				["0.61:0.65:0.42:0.63:0.37:0.59"] = 294, -- Light's Hope Chapel, Undercity, The Sepulcher
				["0.61:0.65:0.42:0.63:0.46:0.57"] = 326, -- Light's Hope Chapel, Undercity, Tarren Mill
				["0.61:0.65:0.42:0.63:0.46:0.57:0.55:0.54"] = 444, -- Light's Hope Chapel, Undercity, Tarren Mill, Hammerfall (was 262, changed by B R)
				["0.61:0.65:0.61:0.73"] = 98, -- Light's Hope Chapel, Zul'Aman
				["0.61:0.65:0.42:0.63:0.50:0.34"] = 673, -- Light's Hope Chapel, Undercity, Kargath
				["0.61:0.65:0.61:0.73:0.58:0.94"] = 344, -- Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.61:0.65:0.42:0.63:0.50:0.34:0.42:0.14"] = 911, -- Light's Hope Chapel, Undercity, Kargath, Grom'gol
				["0.61:0.65:0.42:0.63:0.50:0.34:0.50:0.31"] = 740, -- Light's Hope Chapel, Undercity, Kargath, Flame Crest
				["0.61:0.65:0.58:0.75:0.59:0.82:0.58:0.94"] = 368, -- Light's Hope Chapel, Tranquillien, Silvermoon City, Shattered Sun Staging Area
				["0.61:0.65:0.42:0.63:0.50:0.34:0.46:0.35"] = 729, -- Light's Hope Chapel, Undercity, Kargath, Thorium Point
				["0.61:0.65:0.42:0.63:0.50:0.34:0.41:0.07"] = 970, -- Light's Hope Chapel, Undercity, Kargath, Booty Bay
				["0.61:0.65:0.42:0.63:0.50:0.34:0.54:0.21"] = 896, -- Light's Hope Chapel, Undercity, Kargath, Stonard
				["0.61:0.65:0.42:0.63:0.45:0.63"] = 280, -- Light's Hope Chapel, Undercity, The Bulwark
				["0.61:0.65:0.51:0.64:0.45:0.63"] = 174, -- Light's Hope Chapel, Thondroril River, The Bulwark
				["0.61:0.65:0.51:0.64"] = 99, -- Light's Hope Chapel, Thondroril River
				["0.61:0.65:0.62:0.66"] = 65, -- Light's Hope Chapel, Acherus: The Ebon Hold
				["0.61:0.65:0.51:0.64:0.46:0.57:0.55:0.54:0.50:0.34:0.46:0.35"] = 629, -- Light's Hope Chapel, Thondoril River, Tarren Mill, Hammerfall, Kargath, Thorium Point
				["0.61:0.65:0.51:0.64:0.46:0.57:0.37:0.59"] = 302, -- Light's Hope Chapel, Thondoril River, Tarren Mill, The Sepulcher
				["0.61:0.65:0.51:0.64:0.42:0.63:0.50:0.34"] = 677, -- Light's Hope Chapel, Thondoril River, Undercity, Kargath
				["0.61:0.65:0.51:0.64:0.46:0.57"] = 198, -- Light's Hope Chapel, Thondoril River, Tarren Mill
				["0.61:0.65:0.61:0.73:0.58:0.94:0.59:0.82"] = 509, -- Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area, Silvermoon City
				["0.61:0.65:0.51:0.64:0.46:0.57:0.55:0.54"] = 316, -- Light's Hope Chapel, Thondoril River, Tarren Mill, Hammerfall
				["0.61:0.65:0.51:0.64:0.46:0.57:0.55:0.54:0.50:0.34:0.41:0.07"] = 871, -- Light's Hope Chapel, Thondoril River, Tarren Mill, Hammerfall, Kargath, Booty Bay
				["0.61:0.65:0.51:0.64:0.46:0.57:0.55:0.54:0.50:0.34:0.54:0.21"] = 798, -- Часовня Последней Надежды, Река Тондрорил, Мельница Таррен, Павший Молот, Каргат, Каменор
				["0.61:0.65:0.51:0.64:0.46:0.57:0.55:0.54:0.50:0.34:0.50:0.31"] = 641, -- Light's Hope Chapel, Thondoril River, Tarren Mill, Hammerfall, Kargath, Flame Crest
				["0.61:0.65:0.51:0.64:0.42:0.63:0.50:0.34:0.54:0.21"] = 899, -- Light's Hope Chapel, Thondoril River, Undercity, Kargath, Stonard

				-- Horde: Revantusk Village (The Hinterlands)
				["0.59:0.55:0.55:0.54:0.50:0.34:0.41:0.07"] = 648, -- Revantusk Village, Hammerfall, Kargath, Booty Bay
				["0.59:0.55:0.55:0.54:0.50:0.34:0.42:0.14"] = 589, -- Revantusk Village, Hammerfall, Kargath, Grom'gol
				["0.59:0.55:0.55:0.54:0.50:0.34:0.54:0.21"] = 575, -- Revantusk Village, Hammerfall, Kargath, Stonard
				["0.59:0.55:0.55:0.54:0.50:0.34:0.50:0.31"] = 419, -- Revantusk Village, Hammerfall, Kargath, Flame Crest
				["0.59:0.55:0.55:0.54:0.50:0.34"] = 351, -- Revantusk Village, Hammerfall, Kargath
				["0.59:0.55:0.55:0.54:0.50:0.34:0.46:0.35"] = 407, -- Revantusk Village, Hammerfall, Kargath, Thorium Point
				["0.59:0.55:0.54:0.57:0.37:0.59"] = 257, -- Revantusk Village, Tarren Mill, The Sepulcher
				["0.59:0.55:0.42:0.63"] = 284, -- Revantusk Village, Undercity
				["0.59:0.55:0.54:0.57"] = 159, -- Revantusk Village, Tarren Mill
				["0.59:0.55:0.55:0.54"] = 93, -- Revantusk Village, Hammerfall
				["0.59:0.55:0.61:0.65"] = 139, -- Revantusk Village, Light's Hope Chapel
				["0.59:0.55:0.61:0.65:0.58:0.75"] = 255, -- Revantusk Village, Light's Hope Chapel, Tranquillien
				["0.59:0.55:0.61:0.65:0.58:0.75:0.59:0.82"] = 322, -- Revantusk Village, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.59:0.55:0.42:0.63:0.50:0.34:0.41:0.07"] = 993, -- Revantusk Village, Undercity, Kargath, Booty Bay
				["0.59:0.55:0.61:0.65:0.61:0.73"] = 232, -- Revantusk Village, Light's Hope Chapel, Zul'Aman
				["0.59:0.55:0.61:0.65:0.61:0.73:0.58:0.94"] = 481, -- Revantusk Village, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.59:0.55:0.42:0.63:0.50:0.34:0.46:0.35"] = 752, -- Revantusk Village, Undercity, Kargath, Thorium Point
				["0.59:0.55:0.42:0.63:0.50:0.34:0.54:0.21"] = 920, -- Revantusk Village, Undercity, Kargath, Stonard
				["0.59:0.55:0.54:0.57:0.45:0.63"] = 228, -- Revantusk Village, Tarren Mill, The Bulwark
				["0.59:0.55:0.61:0.65:0.51:0.64"] = 236, -- Revantusk Village, Light's Hope Chapel, Thondroril River
				["0.59:0.55:0.61:0.65:0.62:0.66"] = 200, -- Revantusk Village, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.59:0.55:0.42:0.63:0.50:0.34"] = 697, -- Revantusk Village, Undercity, Kargath
				["0.59:0.55:0.46:0.57:0.51:0.64"] = 260, -- Poblado Sañadiente, Molino Tarren, Río Thondroril
				["0.59:0.55:0.42:0.63:0.45:0.63"] = 303, -- Revantusk Village, Undercity, The Bulwark

				-- Horde: Shattered Sun Staging Area (Isle of Quel'Danas)
				["0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.41:0.07"] = 1117, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Booty Bay
				["0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.42:0.14"] = 1058, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Grom'gol
				["0.58:0.94:0.61:0.73"] = 233, -- Shattered Sun Staging Area, Zul'Aman
				["0.58:0.94:0.59:0.82"] = 167, -- Shattered Sun Staging Area, Silvermoon City
				["0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.46:0.35"] = 876, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Thorium Point
				["0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.54:0.21"] = 1044, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Stonard
				["0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55"] = 469, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Revantusk Village
				["0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34"] = 820, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath
				["0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.50:0.31"] = 888, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Flame Crest
				["0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54"] = 562, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall
				["0.58:0.94:0.61:0.73:0.61:0.65"] = 329, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel
				["0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55:0.46:0.57"] = 629, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Revantusk Village, Tarren Mill
				["0.58:0.94:0.59:0.82:0.58:0.75"] = 231, -- Shattered Sun Staging Area, Silvermoon City, Tranquillien
				["0.58:0.94:0.61:0.73:0.61:0.65:0.42:0.63"] = 590, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Undercity
				["0.58:0.94:0.61:0.73:0.61:0.65:0.42:0.63:0.37:0.59"] = 623, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Undercity, The Sepulcher
				["0.58:0.94:0.59:0.82:0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.41:0.07"] = 1129, -- Shattered Sun Staging Area, Silvermoon City, Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Booty Bay
				["0.58:0.94:0.59:0.82:0.58:0.75:0.61:0.65:0.42:0.63"] = 602, -- Shattered Sun Staging Area, Silvermoon City, Tranquillien, Light's Hope Chapel, Undercity
				["0.58:0.94:0.59:0.82:0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.54:0.21"] = 1060, -- Shattered Sun Staging Area, Silvermoon City, Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Stonard
				["0.58:0.94:0.61:0.73:0.61:0.65:0.51:0.64:0.45:0.63"] = 504, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Thondroril River, The Bulwark
				["0.58:0.94:0.61:0.73:0.61:0.65:0.51:0.64"] = 427, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Thondroril River
				["0.58:0.94:0.61:0.73:0.61:0.65:0.62:0.66"] = 394, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.58:0.94:0.59:0.82:0.58:0.75:0.61:0.65:0.59:0.55:0.46:0.57"] = 641, -- Shattered Sun Staging Area, Silvermoon City, Tranquillien, Light's Hope Chapel, Revantusk Village, Tarren Mill
				["0.58:0.94:0.59:0.82:0.58:0.75:0.61:0.65"] = 346, -- Shattered Sun Staging Area, Silvermoon City, Tranquillien, Light's Hope Chapel
				["0.58:0.94:0.59:0.82:0.58:0.75:0.61:0.65:0.51:0.64:0.46:0.57:0.55:0.54:0.50:0.34:0.54:0.21"] = 1139, -- Shattered Sun Staging Area, Silvermoon City, Tranquillien, Light's Hope Chapel, Thondoril River, Tarren Mill, Hammerfall, Kargath, Stonard
				["0.58:0.94:0.59:0.82:0.58:0.75:0.61:0.65:0.42:0.63:0.45:0.63"] = 622, -- Shattered Sun Staging Area, Silvermoon City, Tranquillien, Light's Hope Chapel, Undercity, The Bulwark
				["0.58:0.94:0.61:0.73:0.61:0.65:0.51:0.64:0.42:0.63"] = 588, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Thondoril River, Undercity
				["0.58:0.94:0.61:0.73:0.61:0.65:0.42:0.63:0.45:0.63"] = 609, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Undercity, The Bulwark
				["0.58:0.94:0.59:0.82:0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.42:0.14"] = 1072, -- Shattered Sun Staging Area, Silvermoon City, Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Grom'gol
				["0.58:0.94:0.59:0.82:0.58:0.75:0.61:0.65:0.51:0.64:0.42:0.63"] = 600, -- Shattered Sun Staging Area, Silvermoon City, Tranquillien, Light's Hope Chapel, Thondoril River, Undercity
				["0.58:0.94:0.61:0.73:0.61:0.65:0.42:0.63:0.50:0.34:0.42:0.14"] = 1242, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Undercity, Kargath, Grom'gol
				["0.58:0.94:0.61:0.73:0.61:0.65:0.42:0.63:0.50:0.34:0.41:0.07"] = 1300, -- Sammelpunkt der Zerschmetterten Sonne, Zul'Aman, Kapelle des hoffnungsvollen Lichts, Unterstadt, Kargath, Beutebucht
				["0.58:0.94:0.59:0.82:0.58:0.75:0.61:0.65:0.42:0.63:0.50:0.34:0.41:0.07"] = 1313, -- Shattered Sun Staging Area, Silvermoon City, Tranquillien, Light's Hope Chapel, Undercity, Kargath, Booty Bay
				["0.58:0.94:0.61:0.73:0.61:0.65:0.51:0.64:0.46:0.57:0.55:0.54:0.50:0.34:0.41:0.07"] = 1203, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Thondoril River, Tarren Mill, Hammerfall, Kargath, Booty Bay
				["0.58:0.94:0.61:0.73:0.61:0.65:0.51:0.64:0.46:0.57"] = 526, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Thondoril River, Tarren Mill
				["0.58:0.94:0.59:0.82:0.58:0.75:0.61:0.65:0.51:0.64:0.46:0.57:0.37:0.59"] = 642, -- Shattered Sun Staging Area, Silvermoon City, Tranquillien, Light's Hope Chapel, Thondoril River, Tarren Mill, The Sepulcher
				["0.58:0.94:0.61:0.73:0.61:0.65:0.51:0.64:0.46:0.57:0.37:0.59"] = 629, -- Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Thondoril River, Tarren Mill, The Sepulcher
				["0.58:0.94:0.59:0.82:0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34"] = 833, -- Shattered Sun Staging Area, Silvermoon City, Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath


				-- Horde: Silvermoon City (Eversong Woods)
				["0.59:0.82:0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.41:0.07"] = 963, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Booty Bay
				["0.59:0.82:0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.42:0.14"] = 904, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Grom'gol
				["0.59:0.82:0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.54:0.21"] = 890, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Stonard
				["0.59:0.82:0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.50:0.31"] = 733, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Flame Crest
				["0.59:0.82:0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34"] = 667, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath
				["0.59:0.82:0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.46:0.35"] = 722, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Thorium Point
				["0.59:0.82:0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54"] = 408, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall
				["0.59:0.82:0.58:0.75:0.61:0.65:0.59:0.55"] = 316, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Revantusk Village
				["0.59:0.82:0.58:0.75:0.61:0.65"] = 179, -- Silvermoon City, Tranquillien, Light's Hope Chapel (jeppe bach reported 74)
				["0.59:0.82:0.58:0.75"] = 65, -- Silvermoon City, Tranquillien
				["0.59:0.82:0.58:0.75:0.61:0.65:0.59:0.55:0.46:0.57"] = 475, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Revantusk Village, Tarren Mill
				["0.59:0.82:0.58:0.75:0.61:0.65:0.42:0.63"] = 437, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Undercity
				["0.59:0.82:0.58:0.75:0.61:0.65:0.42:0.63:0.37:0.59"] = 469, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Undercity, The Sepulcher
				["0.59:0.82:0.58:0.75:0.61:0.73"] = 111, -- Silvermoon City, Tranquillien, Zul'Aman
				["0.59:0.82:0.58:0.75:0.61:0.65:0.42:0.63:0.46:0.57:0.55:0.54"] = 619, -- Silbermond, Tristessa, Kapelle des hoffnungsvollen Lichts, Unterstadt, Tarrens Mühle, Hammerfall
				["0.59:0.82:0.58:0.94"] = 185, -- Silvermoon City, Shattered Sun Staging Area
				["0.59:0.82:0.58:0.94:0.61:0.73"] = 415, -- Silvermoon City, Shattered Sun Staging Area, Zul'Aman
				["0.59:0.82:0.58:0.75:0.61:0.65:0.42:0.63:0.50:0.34:0.54:0.21"] = 1071, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Undercity, Kargath, Stonard
				["0.59:0.82:0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.42:0.14"] = 1240, -- Silvermoon City, Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Grom'gol
				["0.59:0.82:0.58:0.75:0.61:0.65:0.42:0.63:0.45:0.63"] = 456, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Undercity, The Bulwark
				["0.59:0.82:0.58:0.75:0.61:0.65:0.51:0.64"] = 276, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Thondroril River
				["0.59:0.82:0.58:0.75:0.61:0.65:0.51:0.64:0.45:0.63"] = 351, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Thondroril River, The Bulwark
				["0.59:0.82:0.58:0.75:0.61:0.65:0.62:0.66"] = 240, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.59:0.82:0.58:0.75:0.61:0.65:0.51:0.64:0.46:0.57"] = 375, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Thondoril River, Tarren Mill
				["0.59:0.82:0.58:0.75:0.61:0.65:0.51:0.64:0.42:0.63"] = 435, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Thondoril River, Undercity
				["0.59:0.82:0.58:0.94:0.61:0.73:0.61:0.65"] = 522, -- Silvermoon City, Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel (Tomas Nilsson reported 512)
				["0.59:0.82:0.58:0.75:0.61:0.65:0.51:0.64:0.46:0.57:0.55:0.54:0.50:0.34:0.41:0.07"] = 1046, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Thondoril River, Tarren Mill, Hammerfall, Kargath, Booty Bay
				["0.59:0.82:0.58:0.94:0.61:0.73:0.61:0.65:0.42:0.63"] = 772, -- Silvermoon City, Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Undercity
				["0.59:0.82:0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.41:0.07"] = 1300, -- Silvermoon City, Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Booty Bay
				["0.59:0.82:0.58:0.94:0.61:0.73:0.61:0.65:0.42:0.63:0.37:0.59"] = 809, -- Silbermond, Sammelpunkt der Zerschmetterten Sonne, Zul'Aman, Kapelle des hoffnungsvollen Lichts, Unterstadt, Das Grabmal
				["0.59:0.82:0.58:0.75:0.61:0.65:0.42:0.63:0.46:0.57"] = 513, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Undercity, Tarren Mill
				["0.59:0.82:0.58:0.75:0.61:0.65:0.51:0.64:0.46:0.57:0.37:0.59"] = 478, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Thondoril River, Tarren Mill, The Sepulcher
				["0.59:0.82:0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54"] = 745, -- Silvermoon City, Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall
				["0.59:0.82:0.58:0.94:0.61:0.73:0.61:0.65:0.51:0.64:0.46:0.57"] = 714, -- Silvermoon City, Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Thondoril River, Tarren Mill
				["0.59:0.82:0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.54:0.21"] = 1228, -- Silvermoon City, Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Stonard
				["0.59:0.82:0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55:0.46:0.57"] = 812, -- Silvermoon City, Shattered Sun Staging Area, Zul'Aman, Light's Hope Chapel, Revantusk Village, Tarren Mill
				["0.59:0.82:0.58:0.94:0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34"] = 1003, -- Silbermond, Sammelpunkt der Zerschmetterten Sonne, Zul'Aman, Kapelle des hoffnungsvollen Lichts, Dorf der Bruchhauer, Hammerfall, Kargath
				["0.59:0.82:0.58:0.75:0.61:0.65:0.51:0.64:0.42:0.63:0.50:0.34"] = 855, -- Луносвет, Транквиллион, Часовня Последней Надежды, Река Тондрорил, Подгород, Каргат
				["0.59:0.82:0.58:0.75:0.61:0.65:0.51:0.64:0.46:0.57:0.55:0.54:0.50:0.34:0.42:0.14"] = 988, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Thondoril River, Tarren Mill, Hammerfall, Kargath, Grom'gol
				["0.59:0.82:0.58:0.75:0.61:0.65:0.42:0.63:0.50:0.34:0.42:0.14"] = 1087, -- Silvermoon City, Tranquillien, Light's Hope Chapel, Undercity, Kargath, Grom'gol

				-- Horde: Stonard (Swamp of Sorrows)
				["0.54:0.21:0.41:0.07"] = 230, -- Stonard, Booty Bay
				["0.54:0.21:0.42:0.14"] = 179, -- Stonard, Grom'gol
				["0.54:0.21:0.50:0.31"] = 176, -- Stonard, Flame Crest
				["0.54:0.21:0.50:0.34"] = 231, -- Stonard, Kargath
				["0.54:0.21:0.50:0.31:0.46:0.35"] = 208, -- Stonard, Flame Crest, Thorium Point
				["0.54:0.21:0.50:0.34:0.55:0.54:0.46:0.57:0.37:0.59"] = 707, -- Stonard, Kargath, Hammerfall, Tarren Mill, The Sepulcher
				["0.54:0.21:0.50:0.34:0.42:0.63"] = 728, -- Stonard, Kargath, Undercity
				["0.54:0.21:0.50:0.34:0.55:0.54:0.46:0.57"] = 608, -- Stonard, Kargath, Hammerfall, Tarren Mill
				["0.54:0.21:0.50:0.34:0.55:0.54"] = 493, -- Stonard, Kargath, Hammerfall
				["0.54:0.21:0.50:0.34:0.55:0.54:0.59:0.55"] = 582, -- Stonard, Kargath, Hammerfall, Revantusk Village
				["0.54:0.21:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65"] = 720, -- Stonard, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel
				["0.54:0.21:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75"] = 836, -- Stonard, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien
				["0.54:0.21:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75:0.59:0.82"] = 903, -- Stonard, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.54:0.21:0.50:0.34:0.46:0.35"] = 287, -- Stonard, Kargath, Thorium Point
				["0.54:0.21:0.50:0.34:0.42:0.63:0.61:0.65"] = 917, -- Stonard, Kargath, Undercity, Light's Hope Chapel
				["0.54:0.21:0.50:0.34:0.42:0.63:0.46:0.57"] = 795, -- Stonard, Kargath, Undercity, Tarren Mill
				["0.54:0.21:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73"] = 814, -- Stonard, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman
				["0.54:0.21:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73:0.58:0.94"] = 1062, -- Stonard, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.54:0.21:0.50:0.34:0.42:0.63:0.37:0.59"] = 762, -- Stonard, Kargath, Undercity, The Sepulcher
				["0.54:0.21:0.50:0.34:0.55:0.54:0.46:0.57:0.45:0.63"] = 677, -- Stonard, Kargath, Hammerfall, Tarren Mill, The Bulwark
				["0.54:0.21:0.50:0.34:0.55:0.54:0.46:0.57:0.51:0.64"] = 708, -- Stonard, Kargath, Hammerfall, Tarren Mill, Thondoril River
				["0.54:0.21:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.62:0.66"] = 781, -- Stonard, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.54:0.21:0.50:0.34:0.55:0.54:0.46:0.57:0.51:0.64:0.61:0.65"] = 804, -- Stonard, Kargath, Hammerfall, Tarren Mill, Thondoril River, Light's Hope Chapel
				["0.54:0.21:0.50:0.34:0.42:0.63:0.61:0.65:0.58:0.75:0.59:0.82"] = 1100, -- Stonard, Kargath, Undercity, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.54:0.21:0.50:0.34:0.42:0.63:0.59:0.55"] = 936, -- Stonard, Kargath, Undercity, Revantusk Village

				-- Horde: Tarren Mill (Hillsbrad Foothills)
				["0.46:0.57:0.55:0.54:0.50:0.34:0.41:0.07"] = 673, -- Tarren Mill, Hammerfall, Kargath, Booty Bay
				["0.46:0.57:0.55:0.54:0.50:0.34:0.42:0.14"] = 614, -- Tarren Mill, Hammerfall, Kargath, Grom'gol
				["0.46:0.57:0.55:0.54:0.50:0.34:0.54:0.21"] = 600, -- Tarren Mill, Hammerfall, Kargath, Stonard
				["0.46:0.57:0.55:0.54:0.50:0.34:0.50:0.31"] = 443, -- Tarren Mill, Hammerfall, Kargath, Flame Crest
				["0.46:0.57:0.55:0.54:0.50:0.34"] = 377, -- Tarren Mill, Hammerfall, Kargath
				["0.46:0.57:0.55:0.54:0.50:0.34:0.46:0.35"] = 432, -- Tarren Mill, Hammerfall, Kargath, Thorium Point
				["0.46:0.57:0.55:0.54"] = 118, -- Tarren Mill, Hammerfall
				["0.46:0.57:0.59:0.55"] = 160, -- Tarren Mill, Revantusk Village
				["0.46:0.57:0.59:0.55:0.61:0.65"] = 299, -- Tarren Mill, Revantusk Village, Light's Hope Chapel
				["0.46:0.57:0.59:0.55:0.61:0.65:0.58:0.75"] = 415, -- Tarren Mill, Revantusk Village, Light's Hope Chapel, Tranquillien
				["0.46:0.57:0.59:0.55:0.61:0.65:0.58:0.75:0.59:0.82"] = 481, -- Tarren Mill, Revantusk Village, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.46:0.57:0.42:0.63"] = 139, -- Tarren Mill, Undercity (Daniel Meeks reported 100)
				["0.46:0.57:0.37:0.59"] = 99, -- Tarren Mill, The Sepulcher
				["0.46:0.57:0.42:0.63:0.61:0.65"] = 325, -- Tarren Mill, Undercity, Light's Hope Chapel
				["0.46:0.57:0.42:0.63:0.61:0.65:0.61:0.73"] = 416, -- Tarren Mill, Undercity, Light's Hope Chapel, Zul'Aman
				["0.46:0.57:0.59:0.55:0.61:0.65:0.61:0.73"] = 393, -- Tarren Mill, Revantusk Village, Light's Hope Chapel, Zul'Aman
				["0.46:0.57:0.59:0.55:0.61:0.65:0.61:0.73:0.58:0.94"] = 640, -- Tarren Mill, Revantusk Village, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.46:0.57:0.42:0.63:0.50:0.34:0.42:0.14"] = 787, -- Tarren Mill, Undercity, Kargath, Grom'gol
				["0.46:0.57:0.42:0.63:0.50:0.34"] = 550, -- Tarren Mill, Undercity, Kargath
				["0.46:0.57:0.42:0.63:0.50:0.34:0.54:0.21"] = 773, -- Tarren Mill, Undercity, Kargath, Stonard
				["0.46:0.57:0.45:0.63"] = 69, -- Tarren Mill, The Bulwark
				["0.46:0.57:0.51:0.64"] = 101, -- Tarren Mill, Thondroril River
				["0.46:0.57:0.51:0.64:0.61:0.65:0.62:0.66"] = 257, -- Tarren Mill, Thondoril River, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.46:0.57:0.51:0.64:0.61:0.65"] = 196, -- Tarren Mill, Thondoril River, Light's Hope Chapel
				["0.46:0.57:0.59:0.55:0.61:0.65:0.61:0.73:0.58:0.94:0.59:0.82"] = 804, -- Tarren Mill, Revantusk Village, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area, Silvermoon City
				["0.46:0.57:0.42:0.63:0.50:0.34:0.50:0.31"] = 617, -- Tarren Mill, Undercity, Kargath, Flame Crest
				["0.46:0.57:0.51:0.64:0.61:0.65:0.58:0.75:0.59:0.82"] = 380, -- Tarren Mill, Thondoril River, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.46:0.57:0.51:0.64:0.61:0.65:0.58:0.75"] = 312, -- Tarren Mill, Thondoril River, Light's Hope Chapel, Tranquillien
				["0.46:0.57:0.51:0.64:0.61:0.65:0.61:0.73"] = 291, -- Tarren Mill, Thondoril River, Light's Hope Chapel, Zul'Aman
				["0.46:0.57:0.42:0.63:0.50:0.34:0.41:0.07"] = 847, -- Tarren Mill, Undercity, Kargath, Booty Bay
				["0.46:0.57:0.42:0.63:0.50:0.34:0.46:0.35"] = 606, -- Tarren Mill, Undercity, Kargath, Thorium Point

				-- Horde: The Bulwark (Tirisfal Glades)
				["0.45:0.63:0.42:0.63:0.61:0.65:0.58:0.75"] = 400, -- The Bulwark, Undercity, Light's Hope Chapel, Tranquillien
				["0.45:0.63:0.42:0.63:0.61:0.65:0.58:0.75:0.59:0.82"] = 466, -- The Bulwark, Undercity, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.45:0.63:0.51:0.64:0.61:0.65:0.61:0.73:0.58:0.94"] = 505, -- The Bulwark, Thondroril River, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.45:0.63:0.46:0.57:0.37:0.59"] = 177, -- The Bulwark, Tarren Mill, The Sepulcher
				["0.45:0.63:0.42:0.63"] = 90, -- The Bulwark, Undercity
				["0.45:0.63:0.42:0.63:0.61:0.65"] = 283, -- The Bulwark, Undercity, Light's Hope Chapel
				["0.45:0.63:0.46:0.57"] = 74, -- The Bulwark, Tarren Mill
				["0.45:0.63:0.46:0.57:0.55:0.54"] = 191, -- The Bulwark, Tarren Mill, Hammerfall
				["0.45:0.63:0.46:0.57:0.59:0.55"] = 233, -- The Bulwark, Tarren Mill, Revantusk Village
				["0.45:0.63:0.46:0.57:0.55:0.54:0.50:0.34:0.46:0.35"] = 505, -- The Bulwark, Tarren Mill, Hammerfall, Kargath, Thorium Point
				["0.45:0.63:0.46:0.57:0.55:0.54:0.50:0.34"] = 449, -- The Bulwark, Tarren Mill, Hammerfall, Kargath
				["0.45:0.63:0.46:0.57:0.55:0.54:0.50:0.34:0.50:0.31"] = 516, -- The Bulwark, Tarren Mill, Hammerfall, Kargath, Flame Crest
				["0.45:0.63:0.46:0.57:0.55:0.54:0.50:0.34:0.41:0.07"] = 745, -- The Bulwark, Tarren Mill, Hammerfall, Kargath, Booty Bay
				["0.45:0.63:0.46:0.57:0.55:0.54:0.50:0.34:0.42:0.14"] = 686, -- The Bulwark, Tarren Mill, Hammerfall, Kargath, Grom'gol
				["0.45:0.63:0.46:0.57:0.55:0.54:0.50:0.34:0.54:0.21"] = 672, -- The Bulwark, Tarren Mill, Hammerfall, Kargath, Stonard
				["0.45:0.63:0.51:0.64"] = 68, -- The Bulwark, Thondroril River
				["0.45:0.63:0.51:0.64:0.61:0.65"] = 164, -- The Bulwark, Thondroril River, Light's Hope Chapel
				["0.45:0.63:0.51:0.64:0.61:0.65:0.58:0.75"] = 281, -- The Bulwark, Thondroril River, Light's Hope Chapel, Tranquillien
				["0.45:0.63:0.51:0.64:0.61:0.65:0.58:0.75:0.59:0.82"] = 348, -- The Bulwark, Thondroril River, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.45:0.63:0.51:0.64:0.61:0.65:0.61:0.73"] = 257, -- The Bulwark, Thondroril River, Light's Hope Chapel, Zul'Aman
				["0.45:0.63:0.51:0.64:0.61:0.65:0.62:0.66"] = 224, -- The Bulwark, Thondoril River, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.45:0.63:0.42:0.63:0.37:0.59"] = 128, -- The Bulwark, Undercity, The Sepulcher
				["0.45:0.63:0.42:0.63:0.50:0.34"] = 507, -- The Bulwark, Undercity, Kargath
				["0.45:0.63:0.42:0.63:0.50:0.34:0.54:0.21"] = 731, -- The Bulwark, Undercity, Kargath, Stonard
				["0.45:0.63:0.42:0.63:0.61:0.65:0.61:0.73:0.58:0.94:0.59:0.82"] = 791, -- The Bulwark, Undercity, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area, Silvermoon City
				["0.45:0.63:0.42:0.63:0.59:0.55"] = 302, -- The Bulwark, Undercity, Revantusk Village
				["0.45:0.63:0.51:0.64:0.61:0.65:0.58:0.75:0.59:0.82:0.58:0.94"] = 529, -- The Bulwark, Thondoril River, Light's Hope Chapel, Tranquillien, Silvermoon City, Shattered Sun Staging Area

				-- Horde: The Sepulcher (Silverpine Forest)
				["0.37:0.59:0.46:0.57:0.55:0.54:0.50:0.34:0.41:0.07"] = 767, -- The Sepulcher, Tarren Mill, Hammerfall, Kargath, Booty Bay
				["0.37:0.59:0.46:0.57:0.55:0.54:0.50:0.34:0.42:0.14"] = 708, -- The Sepulcher, Tarren Mill, Hammerfall, Kargath, Grom'gol
				["0.37:0.59:0.46:0.57:0.55:0.54:0.50:0.34:0.54:0.21"] = 695, -- The Sepulcher, Tarren Mill, Hammerfall, Kargath, Stonard
				["0.37:0.59:0.46:0.57:0.55:0.54:0.50:0.34:0.50:0.31"] = 538, -- The Sepulcher, Tarren Mill, Hammerfall, Kargath, Flame Crest
				["0.37:0.59:0.46:0.57:0.55:0.54:0.50:0.34"] = 471, -- The Sepulcher, Tarren Mill, Hammerfall, Kargath
				["0.37:0.59:0.46:0.57:0.55:0.54:0.50:0.34:0.46:0.35"] = 526, -- The Sepulcher, Tarren Mill, Hammerfall, Kargath, Thorium Point
				["0.37:0.59:0.46:0.57:0.55:0.54"] = 212, -- The Sepulcher, Tarren Mill, Hammerfall
				["0.37:0.59:0.46:0.57:0.59:0.55"] = 255, -- The Sepulcher, Tarren Mill, Revantusk Village
				["0.37:0.59:0.42:0.63:0.61:0.65"] = 299, -- The Sepulcher, Undercity, Light's Hope Chapel
				["0.37:0.59:0.42:0.63:0.61:0.65:0.58:0.75"] = 415, -- The Sepulcher, Undercity, Light's Hope Chapel, Tranquillien
				["0.37:0.59:0.42:0.63:0.61:0.65:0.58:0.75:0.59:0.82"] = 483, -- The Sepulcher, Undercity, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.37:0.59:0.42:0.63"] = 112, -- The Sepulcher, Undercity
				["0.37:0.59:0.46:0.57"] = 95, -- The Sepulcher, Tarren Mill
				["0.37:0.59:0.42:0.63:0.61:0.65:0.61:0.73"] = 392, -- The Sepulcher, Undercity, Light's Hope Chapel, Zul'Aman
				["0.37:0.59:0.42:0.63:0.61:0.65:0.61:0.73:0.58:0.94"] = 639, -- The Sepulcher, Undercity, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.37:0.59:0.46:0.57:0.45:0.63"] = 164, -- The Sepulcher, Tarren Mill, The Bulwark
				["0.37:0.59:0.46:0.57:0.51:0.64"] = 196, -- The Sepulcher, Tarren Mill, Thondroril River
				["0.37:0.59:0.46:0.57:0.51:0.64:0.61:0.65:0.62:0.66"] = 352, -- The Sepulcher, Tarren Mill, Thondoril River, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.37:0.59:0.42:0.63:0.45:0.63"] = 130, -- The Sepulcher, Undercity, The Bulwark
				["0.37:0.59:0.46:0.57:0.51:0.64:0.61:0.65"] = 292, -- The Sepulcher, Tarren Mill, Thondoril River, Light's Hope Chapel
				["0.37:0.59:0.46:0.57:0.51:0.64:0.61:0.65:0.61:0.73"] = 386, -- The Sepulcher, Tarren Mill, Thondoril River, Light's Hope Chapel, Zul'Aman
				["0.37:0.59:0.46:0.57:0.51:0.64:0.61:0.65:0.58:0.75"] = 407, -- Le Sépulcre, Moulin-de-Tarren, La Thondroril, Chapelle de l'Espoir de Lumière, Tranquillien
				["0.37:0.59:0.46:0.57:0.51:0.64:0.61:0.65:0.58:0.75:0.59:0.82"] = 474, -- The Sepulcher, Tarren Mill, Thondoril River, Light's Hope Chapel, Tranquillien, Silvermoon City

				-- Horde: Thondroril River (Western Plaguelands)
				["0.51:0.64:0.61:0.65:0.58:0.75:0.59:0.82"] = 280, -- Thondroril River, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.51:0.64:0.45:0.63"] = 76, -- Thondroril River, The Bulwark
				["0.51:0.64:0.61:0.65:0.61:0.73:0.58:0.94"] = 438, -- Thondroril River, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.51:0.64:0.61:0.65"] = 96, -- Thondroril River, Light's Hope Chapel
				["0.51:0.64:0.46:0.57:0.55:0.54:0.50:0.34:0.42:0.14"] = 714, -- Thondroril River, Tarren Mill, Hammerfall, Kargath, Grom'gol
				["0.51:0.64:0.46:0.57:0.55:0.54:0.50:0.34:0.41:0.07"] = 773, -- Thondroril River, Tarren Mill, Hammerfall, Kargath, Booty Bay
				["0.51:0.64:0.46:0.57:0.55:0.54:0.50:0.34:0.50:0.31"] = 543, -- Thondroril River, Tarren Mill, Hammerfall, Kargath, Flame Crest
				["0.51:0.64:0.61:0.65:0.61:0.73"] = 190, -- Thondroril River, Light's Hope Chapel, Zul'Aman
				["0.51:0.64:0.46:0.57:0.55:0.54:0.50:0.34:0.46:0.35"] = 531, -- Thondroril River, Tarren Mill, Hammerfall, Kargath, Thorium Point
				["0.51:0.64:0.42:0.63"] = 160, -- Thondroril River, Undercity
				["0.51:0.64:0.46:0.57:0.37:0.59"] = 204, -- Thondroril River, Tarren Mill, The Sepulcher
				["0.51:0.64:0.46:0.57"] = 101, -- Thondroril River, Tarren Mill
				["0.51:0.64:0.61:0.65:0.59:0.55"] = 234, -- Thondroril River, Light's Hope Chapel, Revantusk Village
				["0.51:0.64:0.61:0.65:0.58:0.75"] = 214, -- Thondroril River, Light's Hope Chapel, Tranquillien
				["0.51:0.64:0.46:0.57:0.55:0.54"] = 218, -- Thondroril River, Tarren Mill, Hammerfall
				["0.51:0.64:0.46:0.57:0.55:0.54:0.50:0.34:0.54:0.21"] = 700, -- Thondroril River, Tarren Mill, Hammerfall, Kargath, Stonard
				["0.51:0.64:0.46:0.57:0.55:0.54:0.50:0.34"] = 476, -- Thondroril River, Tarren Mill, Hammerfall, Kargath
				["0.51:0.64:0.61:0.65:0.62:0.66"] = 156, -- Thondoril River, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.51:0.64:0.46:0.57:0.59:0.55"] = 260, -- Thondoril River, Tarren Mill, Revantusk Village
				["0.51:0.64:0.42:0.63:0.37:0.59"] = 199, -- Thondroril, Unterstadt, Das Grabmal

				-- Horde: Thorium Point (Searing Gorge)
				["0.46:0.35:0.50:0.31:0.42:0.14:0.41:0.07"] = 312, -- Thorium Point, Flame Crest, Grom'gol, Booty Bay
				["0.46:0.35:0.50:0.31:0.42:0.14"] = 234, -- Thorium Point, Flame Crest, Grom'gol
				["0.46:0.35:0.50:0.31:0.54:0.21"] = 218, -- Thorium Point, Flame Crest, Stonard
				["0.46:0.35:0.50:0.31"] = 61, -- Thorium Point, Flame Crest
				["0.46:0.35:0.50:0.34"] = 70, -- Thorium Point, Kargath
				["0.46:0.35:0.50:0.34:0.55:0.54:0.46:0.57:0.37:0.59"] = 545, -- Thorium Point, Kargath, Hammerfall, Tarren Mill, The Sepulcher
				["0.46:0.35:0.50:0.34:0.42:0.63"] = 566, -- Thorium Point, Kargath, Undercity
				["0.46:0.35:0.50:0.34:0.55:0.54:0.46:0.57"] = 446, -- Thorium Point, Kargath, Hammerfall, Tarren Mill
				["0.46:0.35:0.50:0.34:0.55:0.54"] = 332, -- Thorium Point, Kargath, Hammerfall
				["0.46:0.35:0.50:0.34:0.55:0.54:0.59:0.55"] = 420, -- Thorium Point, Kargath, Hammerfall, Revantusk Village
				["0.46:0.35:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65"] = 559, -- Thorium Point, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel
				["0.46:0.35:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75"] = 674, -- Thorium Point, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien
				["0.46:0.35:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75:0.59:0.82"] = 741, -- Thorium Point, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.46:0.35:0.50:0.34:0.42:0.14"] = 307, -- Thorium Point, Kargath, Grom'gol
				["0.46:0.35:0.50:0.34:0.54:0.21"] = 294, -- Thorium Point, Kargath, Stonard
				["0.46:0.35:0.50:0.34:0.41:0.07"] = 366, -- Thorium Point, Kargath, Booty Bay
				["0.46:0.35:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73"] = 652, -- Thorium Point, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman
				["0.46:0.35:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.61:0.73:0.58:0.94"] = 900, -- Thorium Point, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.46:0.35:0.50:0.34:0.42:0.63:0.59:0.55"] = 775, -- Thorium Point, Kargath, Undercity, Revantusk Village
				["0.46:0.35:0.50:0.34:0.55:0.54:0.46:0.57:0.45:0.63"] = 515, -- Thorium Point, Kargath, Hammerfall, Tarren Mill, The Bulwark
				["0.46:0.35:0.50:0.34:0.55:0.54:0.46:0.57:0.51:0.64"] = 547, -- Thorium Point, Kargath, Hammerfall, Tarren Mill, Thondroril River
				["0.46:0.35:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.62:0.66"] = 619, -- Thorium Point, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.46:0.35:0.50:0.34:0.55:0.54:0.59:0.55:0.61:0.65:0.58:0.75:0.59:0.82:0.58:0.94"] = 925, -- Thorium Point, Kargath, Hammerfall, Revantusk Village, Light's Hope Chapel, Tranquillien, Silvermoon City, Shattered Sun Staging Area
				["0.46:0.35:0.50:0.34:0.42:0.63:0.46:0.57"] = 636, -- Thorium Point, Kargath, Undercity, Tarren Mill

				-- Horde: Tranquillien (Ghostlands)
				["0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.41:0.07"] = 900, -- Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Booty Bay
				["0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.42:0.14"] = 841, -- Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Grom'gol
				["0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.54:0.21"] = 827, -- Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Stonard
				["0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.50:0.31"] = 671, -- Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Flame Crest
				["0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34"] = 604, -- Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath
				["0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.46:0.35"] = 659, -- Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Thorium Point
				["0.58:0.75:0.61:0.65:0.59:0.55:0.55:0.54"] = 345, -- Tranquillien, Light's Hope Chapel, Revantusk Village, Hammerfall
				["0.58:0.75:0.61:0.65:0.59:0.55"] = 253, -- Tranquillien, Light's Hope Chapel, Revantusk Village
				["0.58:0.75:0.61:0.65"] = 116, -- Tranquillien, Light's Hope Chapel
				["0.58:0.75:0.59:0.82"] = 74, -- Tranquillien, Silvermoon City
				["0.58:0.75:0.61:0.65:0.42:0.63"] = 373, -- Tranquillien, Light's Hope Chapel, Undercity
				["0.58:0.75:0.61:0.65:0.42:0.63:0.37:0.59"] = 406, -- Tranquillien, Light's Hope Chapel, Undercity, The Sepulcher
				["0.58:0.75:0.61:0.65:0.59:0.55:0.46:0.57"] = 412, -- Tranquillien, Light's Hope Chapel, Revantusk Village, Tarren Mill
				["0.58:0.75:0.61:0.73"] = 52, -- Tranquillien, Zul'Aman
				["0.58:0.75:0.59:0.82:0.58:0.94"] = 257, -- Tranquillien, Silvermoon City, Shattered Sun Staging Area
				["0.58:0.75:0.61:0.65:0.42:0.63:0.46:0.57:0.55:0.54"] = 556, -- Tranquillien, Light's Hope Chapel, Undercity, Tarren Mill, Hammerfall
				["0.58:0.75:0.61:0.65:0.42:0.63:0.45:0.63"] = 393, -- Tranquillien, Light's Hope Chapel, Undercity, The Bulwark
				["0.58:0.75:0.61:0.65:0.51:0.64:0.45:0.63"] = 288, -- Tranquillien, Light's Hope Chapel, Thondroril River, The Bulwark
				["0.58:0.75:0.61:0.65:0.51:0.64"] = 213, -- Tranquillien, Light's Hope Chapel, Thondroril River
				["0.58:0.75:0.61:0.65:0.62:0.66"] = 177, -- Tranquillien, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.58:0.75:0.61:0.65:0.51:0.64:0.42:0.63"] = 372, -- Tranquillien, Light's Hope Chapel, Thondoril River, Undercity
				["0.58:0.75:0.61:0.65:0.51:0.64:0.46:0.57"] = 312, -- Tranquillien, Light's Hope Chapel, Thondoril River, Tarren Mill
				["0.58:0.75:0.61:0.65:0.51:0.64:0.42:0.63:0.37:0.59"] = 413, -- Tranquillien, Light's Hope Chapel, Thondoril River, Undercity, The Sepulcher
				["0.58:0.75:0.61:0.65:0.51:0.64:0.46:0.57:0.37:0.59"] = 414, -- Tranquillien, Light's Hope Chapel, Thondoril River, Tarren Mill, The Sepulcher

				-- Horde: Undercity (Tirisfal Glades)
				["0.42:0.63:0.50:0.34:0.41:0.07"] = 785, -- Undercity, Kargath, Booty Bay
				["0.42:0.63:0.50:0.34:0.42:0.14"] = 725, -- Undercity, Kargath, Grom'gol
				["0.42:0.63:0.50:0.34:0.54:0.21"] = 712, -- Undercity, Kargath, Stonard
				["0.42:0.63:0.50:0.34:0.50:0.31"] = 555, -- Undercity, Kargath, Flame Crest
				["0.42:0.63:0.50:0.34"] = 489, -- Undercity, Kargath
				["0.42:0.63:0.50:0.34:0.46:0.35"] = 544, -- Undercity, Kargath, Thorium Point
				["0.42:0.63:0.37:0.59"] = 106, -- Undercity, The Sepulcher
				["0.42:0.63:0.46:0.57"] = 141, -- Undercity, Tarren Mill
				["0.42:0.63:0.55:0.54"] = 301, -- Undercity, Hammerfall
				["0.42:0.63:0.59:0.55"] = 284, -- Undercity, Revantusk Village
				["0.42:0.63:0.61:0.65"] = 261, -- Undercity, Light's Hope Chapel
				["0.42:0.63:0.61:0.65:0.58:0.75"] = 378, -- Undercity, Light's Hope Chapel, Tranquillien
				["0.42:0.63:0.61:0.65:0.58:0.75:0.59:0.82"] = 444, -- Undercity, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.42:0.63:0.61:0.65:0.61:0.73"] = 356, -- Undercity, Light's Hope Chapel, Zul'Aman
				["0.42:0.63:0.61:0.65:0.61:0.73:0.58:0.94"] = 601, -- Undercity, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.42:0.63:0.45:0.63"] = 89, -- Undercity, The Bulwark
				["0.42:0.63:0.51:0.64"] = 153, -- Undercity, Thondroril River
				["0.42:0.63:0.51:0.64:0.61:0.65:0.62:0.66"] = 309, -- Undercity, Thondoril River, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.42:0.63:0.61:0.65:0.62:0.66"] = 318, -- Undercity, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.42:0.63:0.61:0.65:0.58:0.75:0.59:0.82:0.58:0.94"] = 627, -- Undercity, Light's Hope Chapel, Tranquillien, Silvermoon City, Shattered Sun Staging Area
				["0.42:0.63:0.51:0.64:0.61:0.65:0.58:0.75:0.59:0.82"] = 438, -- Undercity, Thondoril River, Light's Hope Chapel, Tranquillien, Silvermoon City
				["0.42:0.63:0.51:0.64:0.61:0.65:0.58:0.75"] = 366, -- Undercity, Thondoril River, Light's Hope Chapel, Tranquillien
				["0.42:0.63:0.51:0.64:0.61:0.65:0.61:0.73"] = 341, -- Undercity, Thondoril River, Light's Hope Chapel, Zul'Aman
				["0.42:0.63:0.51:0.64:0.61:0.65:0.61:0.73:0.58:0.94"] = 588, -- Undercity, Thondoril River, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area
				["0.42:0.63:0.61:0.65:0.61:0.73:0.58:0.94:0.59:0.82"] = 768, -- Undercity, Light's Hope Chapel, Zul'Aman, Shattered Sun Staging Area, Silvermoon City

				-- Horde: Zul'Aman
				["0.61:0.73:0.58:0.75"] = 52, -- Zul'Aman, Tranquillien
				["0.61:0.73:0.58:0.75:0.59:0.82"] = 118, -- Zul'Aman, Tranquillien, Silvermoon City
				["0.61:0.73:0.61:0.65:0.42:0.63"] = 362, -- Zul'Aman, Light's Hope Chapel, Undercity
				["0.61:0.73:0.61:0.65"] = 102, -- Zul'Aman, Light's Hope Chapel
				["0.61:0.73:0.61:0.65:0.42:0.63:0.37:0.59"] = 395, -- Zul'Aman, Light's Hope Chapel, Undercity, The Sepulcher
				["0.61:0.73:0.61:0.65:0.59:0.55"] = 244, -- Zul'Aman, Light's Hope Chapel, Revantusk Village
				["0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54"] = 335, -- Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall
				["0.61:0.73:0.61:0.65:0.59:0.55:0.46:0.57"] = 401, -- Zul'Aman, Light's Hope Chapel, Revantusk Village, Tarren Mill
				["0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.41:0.07"] = 889, -- Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Booty Bay
				["0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.42:0.14"] = 831, -- Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Grom'gol
				["0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.54:0.21"] = 817, -- Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Stonard
				["0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.50:0.31"] = 661, -- Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Flame Crest
				["0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34:0.46:0.35"] = 648, -- Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath, Thorium Point
				["0.61:0.73:0.61:0.65:0.59:0.55:0.55:0.54:0.50:0.34"] = 593, -- Zul'Aman, Light's Hope Chapel, Revantusk Village, Hammerfall, Kargath
				["0.61:0.73:0.58:0.94"] = 252, -- Zul'Aman, Shattered Sun Staging Area
				["0.61:0.73:0.58:0.94:0.59:0.82"] = 416, -- Zul'Aman, Shattered Sun Staging Area, Silvermoon City
				["0.61:0.73:0.61:0.65:0.51:0.64:0.45:0.63"] = 275, -- Zul'Aman, Light's Hope Chapel, Thondroril River, The Bulwark
				["0.61:0.73:0.61:0.65:0.51:0.64"] = 201, -- Zul'Aman, Light's Hope Chapel, Thondroril River
				["0.61:0.73:0.61:0.65:0.62:0.66"] = 166, -- Zul'Aman, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.61:0.73:0.61:0.65:0.51:0.64:0.46:0.57"] = 300, -- Zul'Aman, Light's Hope Chapel, Thondoril River, Tarren Mill
				["0.61:0.73:0.61:0.65:0.51:0.64:0.42:0.63"] = 360, -- Zul'Aman, Light's Hope Chapel, Thondoril River, Undercity
				["0.61:0.73:0.61:0.65:0.51:0.64:0.46:0.57:0.37:0.59"] = 403, -- Zul'Aman, Light's Hope Chapel, Thondoril River, Tarren Mill, The Sepulcher

			},

			-- Horde: Kalimdor
			[1] = {

				-- Horde: Bloodvenom Post (Felwood)
				["0.46:0.70:0.56:0.47:0.55:0.27:0.61:0.20"] = 518, -- Bloodvenom Post, Crossroads, Freewind Post, Gadgetzan
				["0.46:0.70:0.56:0.47:0.44:0.31:0.42:0.21"] = 623, -- Bloodvenom Post, Crossroads, Camp Mojache, Cenarion Hold
				["0.46:0.70:0.56:0.47:0.55:0.27:0.61:0.20:0.50:0.24"] = 619, -- Bloodvenom Post, Crossroads, Freewind Post, Gadgetzan, Marshal's Refuge
				["0.46:0.70:0.56:0.47:0.55:0.27"] = 426, -- Bloodvenom Post, Crossroads, Freewind Post
				["0.46:0.70:0.56:0.47:0.53:0.39:0.57:0.36:0.58:0.30"] = 434, -- Bloodvenom Post, Crossroads, Camp Taurajo, Brackenwall Village, Mudsprocket
				["0.46:0.70:0.56:0.47:0.53:0.39:0.57:0.36"] = 373, -- Bloodvenom Post, Crossroads, Camp Taurajo, Brackenwall Village
				["0.46:0.70:0.56:0.47:0.53:0.39"] = 315, -- Bloodvenom Post, Crossroads, Camp Taurajo
				["0.46:0.70:0.56:0.47:0.44:0.31"] = 493, -- Bloodvenom Post, Crossroads, Camp Mojache
				["0.46:0.70:0.41:0.63:0.41:0.53:0.32:0.42"] = 398, -- Bloodvenom Post, Zoram'gar Outpost, Sun Rock Retreat, Shadowprey Village
				["0.46:0.70:0.56:0.47:0.45:0.44"] = 347, -- Bloodvenom Post, Crossroads, Thunder Bluff
				["0.46:0.70:0.56:0.47"] = 241, -- Bloodvenom Post, Crossroads
				["0.46:0.70:0.56:0.47:0.61:0.45"] = 292, -- Bloodvenom Post, Crossroads, Ratchet
				["0.46:0.70:0.63:0.56"] = 259, -- Bloodvenom Post, Orgrimmar
				["0.46:0.70:0.50:0.65:0.55:0.58"] = 151, -- Bloodvenom Post, Emerald Sanctuary, Splintertree Post
				["0.46:0.70:0.41:0.63:0.41:0.53"] = 256, -- Bloodvenom Post, Zoram'gar Outpost, Sun Rock Retreat
				["0.46:0.70:0.41:0.63"] = 136, -- Bloodvenom Post, Zoram'gar Outpost
				["0.46:0.70:0.50:0.65"] = 69, -- Bloodvenom Post, Emerald Sanctuary
				["0.46:0.70:0.63:0.64"] = 234, -- Bloodvenom Post, Valormok
				["0.46:0.70:0.64:0.77"] = 190, -- Bloodvenom Post, Everlook
				["0.46:0.70:0.54:0.79"] = 166, -- Bloodvenom Post, Moonglade
				["0.46:0.70:0.41:0.63:0.55:0.58"] = 309, -- Bloodvenom Post, Zoram'gar Outpost, Splintertree Post
				["0.46:0.70:0.56:0.47:0.61:0.45:0.61:0.20"] = 529, -- Bloodvenom Post, Crossroads, Ratchet, Gadgetzan
				["0.46:0.70:0.56:0.47:0.45:0.44:0.32:0.42"] = 507, -- Bloodvenom Post, Crossroads, Thunder Bluff, Shadowprey Village
				["0.46:0.70:0.50:0.65:0.55:0.58:0.63:0.56:0.61:0.45:0.61:0.20"] = 587, -- Bloodvenom Post, Emerald Sanctuary, Splintertree Post, Orgrimmar, Ratchet, Gadgetzan

				-- Horde: Brackenwall Village (Dustwallow Marsh)
				["0.57:0.36:0.61:0.20"] = 205, -- Brackenwall Village, Gadgetzan
				["0.57:0.36:0.55:0.27:0.44:0.31:0.42:0.21"] = 357, -- Brackenwall Village, Freewind Post, Camp Mojache, Cenarion Hold
				["0.57:0.36:0.55:0.27:0.61:0.20:0.50:0.24"] = 298, -- Brackenwall Village, Freewind Post, Gadgetzan, Marshal's Refuge
				["0.57:0.36:0.55:0.27"] = 105, -- Brackenwall Village, Freewind Post
				["0.57:0.36:0.58:0.30"] = 62, -- Brackenwall Village, Mudsprocket
				["0.57:0.36:0.55:0.27:0.44:0.31"] = 227, -- Brackenwall Village, Freewind Post, Camp Mojache
				["0.57:0.36:0.53:0.39"] = 49, -- Brackenwall Village, Camp Taurajo
				["0.57:0.36:0.45:0.44"] = 225, -- Brackenwall Village, Thunder Bluff
				["0.57:0.36:0.53:0.39:0.45:0.44:0.32:0.42"] = 321, -- Brackenwall Village, Camp Taurajo, Thunder Bluff, Shadowprey Village
				["0.57:0.36:0.53:0.39:0.56:0.47:0.41:0.53"] = 276, -- Brackenwall Village, Camp Taurajo, Crossroads, Sun Rock Retreat
				["0.57:0.36:0.56:0.47"] = 162, -- Brackenwall Village, Crossroads
				["0.57:0.36:0.61:0.45"] = 90, -- Brackenwall Village, Ratchet
				["0.57:0.36:0.63:0.56"] = 217, -- Brackenwall Village, Orgrimmar
				["0.57:0.36:0.61:0.45:0.63:0.56:0.55:0.58"] = 273, -- Brackenwall Village, Ratchet, Orgrimmar, Splintertree Post
				["0.57:0.36:0.61:0.45:0.63:0.56:0.63:0.64"] = 279, -- Brackenwall Village, Ratchet, Orgrimmar, Valormok
				["0.57:0.36:0.61:0.45:0.63:0.56:0.55:0.58:0.50:0.65"] = 351, -- Brackenwall Village, Ratchet, Orgrimmar, Splintertree Post, Emerald Sanctuary
				["0.57:0.36:0.53:0.39:0.56:0.47:0.41:0.63"] = 357, -- Brackenwall Village, Camp Taurajo, Crossroads, Zoram'gar Outpost
				["0.57:0.36:0.53:0.39:0.56:0.47:0.46:0.70"] = 380, -- Brackenwall Village, Camp Taurajo, Crossroads, Bloodvenom Post
				["0.57:0.36:0.53:0.39:0.56:0.47:0.46:0.70:0.54:0.79"] = 501, -- Brackenwall Village, Camp Taurajo, Crossroads, Bloodvenom Post, Moonglade
				["0.57:0.36:0.61:0.45:0.63:0.56:0.63:0.64:0.64:0.77"] = 408, -- Brackenwall Village, Ratchet, Orgrimmar, Valormok, Everlook
				["0.57:0.36:0.53:0.39:0.56:0.47:0.44:0.31"] = 379, -- Brackenwall Village, Camp Taurajo, Crossroads, Camp Mojache

				-- Horde: Camp Mojache (The Barrens)
				["0.44:0.31:0.42:0.21"] = 130, -- Camp Mojache, Cenarion Hold
				["0.44:0.31:0.42:0.21:0.50:0.24"] = 222, -- Camp Mojache, Cenarion Hold, Marshal's Refuge
				["0.44:0.31:0.61:0.20"] = 201, -- Camp Mojache, Gadgetzan
				["0.44:0.31:0.55:0.27"] = 107, -- Camp Mojache, Freewind Post
				["0.44:0.31:0.55:0.27:0.58:0.30"] = 176, -- Camp Mojache, Freewind Post, Mudsprocket
				["0.44:0.31:0.55:0.27:0.57:0.36"] = 203, -- Camp Mojache, Freewind Post, Brackenwall Village
				["0.44:0.31:0.55:0.27:0.53:0.39"] = 245, -- Camp Mojache, Freewind Post, Camp Taurajo
				["0.44:0.31:0.55:0.27:0.57:0.36:0.61:0.45"] = 290, -- Camp Mojache, Freewind Post, Brackenwall Village, Ratchet
				["0.44:0.31:0.56:0.47"] = 265, -- Camp Mojache, Crossroads
				["0.44:0.31:0.45:0.44"] = 259, -- Camp Mojache, Thunder Bluff
				["0.44:0.31:0.32:0.42"] = 200, -- Camp Mojache, Shadowprey Village
				["0.44:0.31:0.32:0.42:0.41:0.53"] = 400, -- Camp Mojache, Shadowprey Village, Sun Rock Retreat
				["0.44:0.31:0.56:0.47:0.41:0.63"] = 495, -- Camp Mojache, Crossroads, Zoram'gar Outpost
				["0.44:0.31:0.56:0.47:0.55:0.58"] = 427, -- Camp Mojache, Crossroads, Splintertree Post
				["0.44:0.31:0.56:0.47:0.63:0.56"] = 381, -- Camp Mojache, Crossroads, Orgrimmar
				["0.44:0.31:0.56:0.47:0.63:0.64"] = 428, -- Camp Mojache, Crossroads, Valormok
				["0.44:0.31:0.56:0.47:0.55:0.58:0.50:0.65"] = 505, -- Camp Mojache, Crossroads, Splintertree Post, Emerald Sanctuary
				["0.44:0.31:0.56:0.47:0.46:0.70"] = 518, -- Camp Mojache, Crossroads, Bloodvenom Post
				["0.44:0.31:0.56:0.47:0.46:0.70:0.54:0.79"] = 639, -- Camp Mojache, Crossroads, Bloodvenom Post, Moonglade
				["0.44:0.31:0.56:0.47:0.63:0.64:0.64:0.77"] = 557, -- Camp Mojache, Crossroads, Valormok, Everlook
				["0.44:0.31:0.55:0.27:0.61:0.20:0.50:0.24"] = 301, -- Camp Mojache, Freewind Post, Gadgetzan, Marshal's Refuge
				["0.44:0.31:0.56:0.47:0.61:0.45"] = 316, -- Camp Mojache, Crossroads, Ratchet
				["0.44:0.31:0.56:0.47:0.63:0.56:0.64:0.77"] = 621, -- Camp Mojache, Crossroads, Orgrimmar, Everlook
				["0.44:0.31:0.56:0.47:0.41:0.53"] = 415, -- Camp Mojache, Crossroads, Sun Rock Retreat
				["0.44:0.31:0.55:0.27:0.57:0.36:0.61:0.45:0.63:0.56"] = 386, -- Camp Mojache, Freewind Post, Brackenwall Village, Ratchet, Orgrimmar
				["0.44:0.31:0.56:0.47:0.53:0.39"] = 338, -- Camp Mojache, Crossroads, Camp Taurajo
				["0.44:0.31:0.56:0.47:0.63:0.64:0.64:0.77:0.54:0.79"] = 690, -- Camp Mojache, Crossroads, Valormok, Everlook, Moonglade
				["0.44:0.31:0.45:0.44:0.63:0.56"] = 467, -- Camp Mojache, Thunder Bluff, Orgrimmar

				-- Horde: Camp Taurajo (The Barrens)
				["0.53:0.39:0.55:0.27:0.61:0.20"] = 218, -- Camp Taurajo, Freewind Post, Gadgetzan
				["0.53:0.39:0.55:0.27:0.44:0.31:0.42:0.21"] = 378, -- Camp Taurajo, Freewind Post, Camp Mojache, Cenarion Hold
				["0.53:0.39:0.55:0.27:0.61:0.20:0.50:0.24"] = 319, -- Camp Taurajo, Freewind Post, Gadgetzan, Marshal's Refuge
				["0.53:0.39:0.55:0.27"] = 125, -- Camp Taurajo, Freewind Post
				["0.53:0.39:0.57:0.36:0.58:0.30"] = 121, -- Camp Taurajo, Brackenwall Village, Mudsprocket
				["0.53:0.39:0.57:0.36"] = 60, -- Camp Taurajo, Brackenwall Village
				["0.53:0.39:0.55:0.27:0.44:0.31"] = 248, -- Camp Taurajo, Freewind Post, Camp Mojache
				["0.53:0.39:0.45:0.44:0.32:0.42"] = 273, -- Camp Taurajo, Thunder Bluff, Shadowprey Village
				["0.53:0.39:0.45:0.44"] = 114, -- Camp Taurajo, Thunder Bluff
				["0.53:0.39:0.56:0.47"] = 79, -- Camp Taurajo, Crossroads
				["0.53:0.39:0.56:0.47:0.61:0.45"] = 130, -- Camp Taurajo, Crossroads, Ratchet
				["0.53:0.39:0.56:0.47:0.63:0.56"] = 195, -- Camp Taurajo, Crossroads, Orgrimmar
				["0.53:0.39:0.56:0.47:0.55:0.58"] = 241, -- Camp Taurajo, Crossroads, Splintertree Post
				["0.53:0.39:0.56:0.47:0.41:0.53"] = 228, -- Camp Taurajo, Crossroads, Sun Rock Retreat
				["0.53:0.39:0.56:0.47:0.41:0.63"] = 309, -- Camp Taurajo, Crossroads, Zoram'gar Outpost
				["0.53:0.39:0.56:0.47:0.55:0.58:0.50:0.65"] = 319, -- Camp Taurajo, Crossroads, Splintertree Post, Emerald Sanctuary
				["0.53:0.39:0.56:0.47:0.63:0.64"] = 242, -- Camp Taurajo, Crossroads, Valormok
				["0.53:0.39:0.56:0.47:0.46:0.70"] = 332, -- Camp Taurajo, Crossroads, Bloodvenom Post
				["0.53:0.39:0.56:0.47:0.46:0.70:0.54:0.79"] = 453, -- Camp Taurajo, Crossroads, Bloodvenom Post, Moonglade
				["0.53:0.39:0.56:0.47:0.63:0.64:0.64:0.77"] = 372, -- Camp Taurajo, Crossroads, Valormok, Everlook
				["0.53:0.39:0.56:0.47:0.44:0.31"] = 330, -- Camp Taurajo, Crossroads, Camp Mojache
				["0.53:0.39:0.56:0.47:0.63:0.56:0.64:0.77"] = 435, -- Camp Taurajo, Crossroads, Orgrimmar, Everlook
				["0.53:0.39:0.55:0.27:0.58:0.30"] = 194, -- Camp Taurajo, Freewind Post, Mudsprocket
				["0.53:0.39:0.45:0.44:0.63:0.56"] = 322, -- Camp Taurajo, Thunder Bluff, Orgrimmar

				-- Horde: Cenarion Hold (Silithus)
				["0.42:0.21:0.61:0.20"] = 242, -- Cenarion Hold, Gadgetzan
				["0.42:0.21:0.50:0.24"] = 97, -- Cenarion Hold, Marshal's Refuge
				["0.42:0.21:0.44:0.31:0.55:0.27"] = 237, -- Cenarion Hold, Camp Mojache, Freewind Post
				["0.42:0.21:0.44:0.31:0.55:0.27:0.58:0.30"] = 306, -- Cenarion Hold, Camp Mojache, Freewind Post, Mudsprocket
				["0.42:0.21:0.44:0.31:0.55:0.27:0.57:0.36"] = 332, -- Cenarion Hold, Camp Mojache, Freewind Post, Brackenwall Village
				["0.42:0.21:0.44:0.31:0.55:0.27:0.53:0.39"] = 374, -- Cenarion Hold, Camp Mojache, Freewind Post, Camp Taurajo
				["0.42:0.21:0.44:0.31"] = 131, -- Cenarion Hold, Camp Mojache
				["0.42:0.21:0.44:0.31:0.32:0.42"] = 330, -- Cenarion Hold, Camp Mojache, Shadowprey Village
				["0.42:0.21:0.44:0.31:0.45:0.44"] = 390, -- Cenarion Hold, Camp Mojache, Thunder Bluff
				["0.42:0.21:0.44:0.31:0.56:0.47"] = 394, -- Cenarion Hold, Camp Mojache, Crossroads
				["0.42:0.21:0.44:0.31:0.55:0.27:0.57:0.36:0.61:0.45"] = 420, -- Cenarion Hold, Camp Mojache, Freewind Post, Brackenwall Village, Ratchet
				["0.42:0.21:0.44:0.31:0.56:0.47:0.63:0.56"] = 511, -- Cenarion Hold, Camp Mojache, Crossroads, Orgrimmar
				["0.42:0.21:0.44:0.31:0.56:0.47:0.55:0.58"] = 556, -- Cenarion Hold, Camp Mojache, Crossroads, Splintertree Post
				["0.42:0.21:0.44:0.31:0.32:0.42:0.41:0.53"] = 528, -- Cenarion Hold, Camp Mojache, Shadowprey Village, Sun Rock Retreat
				["0.42:0.21:0.44:0.31:0.56:0.47:0.41:0.63"] = 624, -- Cenarion Hold, Camp Mojache, Crossroads, Zoram'gar Outpost
				["0.42:0.21:0.44:0.31:0.56:0.47:0.55:0.58:0.50:0.65"] = 634, -- Cenarion Hold, Camp Mojache, Crossroads, Splintertree Post, Emerald Sanctuary
				["0.42:0.21:0.44:0.31:0.56:0.47:0.46:0.70"] = 647, -- Cenarion Hold, Camp Mojache, Crossroads, Bloodvenom Post
				["0.42:0.21:0.44:0.31:0.56:0.47:0.63:0.64"] = 557, -- Cenarion Hold, Camp Mojache, Crossroads, Valormok
				["0.42:0.21:0.44:0.31:0.56:0.47:0.63:0.64:0.64:0.77"] = 686, -- Cenarion Hold, Camp Mojache, Crossroads, Valormok, Everlook
				["0.42:0.21:0.44:0.31:0.56:0.47:0.46:0.70:0.54:0.79"] = 769, -- Cenarion Hold, Camp Mojache, Crossroads, Bloodvenom Post, Moonglade
				["0.42:0.21:0.44:0.31:0.56:0.47:0.61:0.45"] = 446, -- Cenarion Hold, Camp Mojache, Crossroads, Ratchet
				["0.42:0.21:0.44:0.31:0.56:0.47:0.63:0.56:0.64:0.77"] = 750, -- Cenarion Hold, Camp Mojache, Crossroads, Orgrimmar, Everlook
				["0.42:0.21:0.61:0.20:0.63:0.56"] = 591, -- Cenarion Hold, Gadgetzan, Orgrimmar
				["0.42:0.21:0.50:0.24:0.61:0.20:0.55:0.27"] = 292, -- Cenarion Hold, Marshal's Refuge, Gadgetzan, Freewind Post
				["0.42:0.21:0.61:0.20:0.55:0.27"] = 328, -- Cenarion Hold, Gadgetzan, Freewind Post
				["0.42:0.21:0.50:0.24:0.61:0.20:0.55:0.27:0.53:0.39"] = 428, -- Cenarion Hold, Marshal's Refuge, Gadgetzan, Freewind Post, Camp Taurajo
				["0.42:0.21:0.50:0.24:0.61:0.20:0.61:0.45:0.63:0.56:0.64:0.77"] = 782, -- Cenarion Hold, Marshal's Refuge, Gadgetzan, Ratchet, Orgrimmar, Everlook
				["0.42:0.21:0.50:0.24:0.61:0.20:0.61:0.45:0.63:0.56"] = 543, -- Cenarion Hold, Marshal's Refuge, Gadgetzan, Ratchet, Orgrimmar
				["0.42:0.21:0.44:0.31:0.56:0.47:0.63:0.56:0.64:0.77:0.54:0.79"] = 884, -- Cenarion Hold, Camp Mojache, Crossroads, Orgrimmar, Everlook, Moonglade
				["0.42:0.21:0.61:0.20:0.61:0.45:0.63:0.56"] = 580, -- Cenarion Hold, Gadgetzan, Ratchet, Orgrimmar
				["0.42:0.21:0.50:0.24:0.61:0.20:0.61:0.45:0.63:0.56:0.63:0.64:0.64:0.77"] = 767, -- Cenarion Hold, Marshal's Refuge, Gadgetzan, Ratchet, Orgrimmar, Valormok, Everlook
				["0.42:0.21:0.50:0.24:0.61:0.20:0.45:0.44:0.32:0.42"] = 668, -- Cenarion Hold, Marshal's Refuge, Gadgetzan, Thunder Bluff, Shadowprey Village
				["0.42:0.21:0.50:0.24:0.61:0.20:0.61:0.45"] = 447, -- Cenarion Hold, Marshal's Refuge, Gadgetzan, Ratchet

				-- Horde: Crossroads (The Barrens)
				["0.56:0.47:0.44:0.31:0.42:0.21"] = 382, -- Crossroads, Camp Mojache, Cenarion Hold
				["0.56:0.47:0.55:0.27:0.61:0.20:0.50:0.24"] = 379, -- Crossroads, Freewind Post, Gadgetzan, Marshal's Refuge
				["0.56:0.47:0.61:0.20"] = 303, -- Crossroads, Gadgetzan
				["0.56:0.47:0.55:0.27"] = 184, -- Crossroads, Freewind Post
				["0.56:0.47:0.53:0.39:0.57:0.36:0.58:0.30"] = 193, -- Crossroads, Camp Taurajo, Brackenwall Village, Mudsprocket
				["0.56:0.47:0.57:0.36"] = 162, -- Crossroads, Brackenwall Village
				["0.56:0.47:0.53:0.39"] = 74, -- Crossroads, Camp Taurajo
				["0.56:0.47:0.44:0.31"] = 252, -- Crossroads, Camp Mojache
				["0.56:0.47:0.45:0.44:0.32:0.42"] = 266, -- Crossroads, Thunder Bluff, Shadowprey Village
				["0.56:0.47:0.45:0.44"] = 107, -- Crossroads, Thunder Bluff
				["0.56:0.47:0.41:0.53"] = 150, -- Crossroads, Sun Rock Retreat
				["0.56:0.47:0.55:0.58"] = 162, -- Crossroads, Splintertree Post
				["0.56:0.47:0.63:0.56"] = 117, -- Crossroads, Orgrimmar
				["0.56:0.47:0.61:0.45"] = 52, -- Crossroads, Ratchet
				["0.56:0.47:0.63:0.64"] = 164, -- Crossroads, Valormok
				["0.56:0.47:0.55:0.58:0.50:0.65"] = 241, -- Crossroads, Splintertree Post, Emerald Sanctuary
				["0.56:0.47:0.41:0.63"] = 230, -- Crossroads, Zoram'gar Outpost
				["0.56:0.47:0.46:0.70"] = 254, -- Crossroads, Bloodvenom Post
				["0.56:0.47:0.46:0.70:0.54:0.79"] = 375, -- Crossroads, Bloodvenom Post, Moonglade
				["0.56:0.47:0.63:0.64:0.64:0.77"] = 293, -- Crossroads, Valormok, Everlook
				["0.56:0.47:0.61:0.45:0.61:0.20:0.50:0.24"] = 395, -- Crossroads, Ratchet, Gadgetzan, Marshal's Refuge
				["0.56:0.47:0.55:0.27:0.58:0.30"] = 254, -- Crossroads, Freewind Post, Mudsprocket
				["0.56:0.47:0.63:0.56:0.64:0.77"] = 357, -- Crossroads, Orgrimmar, Everlook

				-- Horde: Emerald Sanctuary (Felwood)
				["0.50:0.65:0.55:0.58:0.56:0.47:0.55:0.27:0.61:0.20"] = 514, -- Emerald Sanctuary, Splintertree Post, Crossroads, Freewind Post, Gadgetzan
				["0.50:0.65:0.55:0.58:0.56:0.47:0.44:0.31:0.42:0.21"] = 618, -- Emerald Sanctuary, Splintertree Post, Crossroads, Camp Mojache, Cenarion Hold
				["0.50:0.65:0.55:0.58:0.56:0.47:0.55:0.27:0.61:0.20:0.50:0.24"] = 615, -- Emerald Sanctuary, Splintertree Post, Crossroads, Freewind Post, Gadgetzan, Marshal's Refuge
				["0.50:0.65:0.55:0.58:0.56:0.47:0.55:0.27"] = 421, -- Emerald Sanctuary, Splintertree Post, Crossroads, Freewind Post
				["0.50:0.65:0.55:0.58:0.56:0.47:0.53:0.39:0.57:0.36:0.58:0.30"] = 430, -- Emerald Sanctuary, Splintertree Post, Crossroads, Camp Taurajo, Brackenwall Village, Mudsprocket
				["0.50:0.65:0.55:0.58:0.56:0.47:0.53:0.39:0.57:0.36"] = 368, -- Emerald Sanctuary, Splintertree Post, Crossroads, Camp Taurajo, Brackenwall Village
				["0.50:0.65:0.55:0.58:0.56:0.47:0.53:0.39"] = 310, -- Emerald Sanctuary, Splintertree Post, Crossroads, Camp Taurajo
				["0.50:0.65:0.55:0.58:0.56:0.47:0.44:0.31"] = 489, -- Emerald Sanctuary, Splintertree Post, Crossroads, Camp Mojache
				["0.50:0.65:0.41:0.63:0.41:0.53:0.32:0.42"] = 378, -- Emerald Sanctuary, Zoram'gar Outpost, Sun Rock Retreat, Shadowprey Village
				["0.50:0.65:0.55:0.58:0.56:0.47:0.45:0.44"] = 343, -- Emerald Sanctuary, Splintertree Post, Crossroads, Thunder Bluff
				["0.50:0.65:0.55:0.58:0.56:0.47"] = 237, -- Emerald Sanctuary, Splintertree Post, Crossroads
				["0.50:0.65:0.55:0.58:0.63:0.56:0.61:0.45"] = 280, -- Emerald Sanctuary, Splintertree Post, Orgrimmar, Ratchet
				["0.50:0.65:0.55:0.58:0.63:0.56"] = 173, -- Emerald Sanctuary, Splintertree Post, Orgrimmar
				["0.50:0.65:0.55:0.58"] = 84, -- Emerald Sanctuary, Splintertree Post
				["0.50:0.65:0.41:0.63:0.41:0.53"] = 235, -- Emerald Sanctuary, Zoram'gar Outpost, Sun Rock Retreat
				["0.50:0.65:0.41:0.63"] = 115, -- Emerald Sanctuary, Zoram'gar Outpost
				["0.50:0.65:0.46:0.70"] = 80, -- Emerald Sanctuary, Bloodvenom Post
				["0.50:0.65:0.55:0.58:0.63:0.64"] = 169, -- Emerald Sanctuary, Splintertree Post, Valormok
				["0.50:0.65:0.46:0.70:0.64:0.77"] = 226, -- Emerald Sanctuary, Bloodvenom Post, Everlook
				["0.50:0.65:0.46:0.70:0.54:0.79"] = 203, -- Emerald Sanctuary, Bloodvenom Post, Moonglade
				["0.50:0.65:0.46:0.70:0.56:0.47:0.61:0.45"] = 330, -- Emerald Sanctuary, Bloodvenom Post, Crossroads, Ratchet
				["0.50:0.65:0.55:0.58:0.63:0.64:0.64:0.77"] = 298, -- Emerald Sanctuary, Splintertree Post, Valormok, Everlook
				["0.50:0.65:0.55:0.58:0.63:0.56:0.64:0.77"] = 413, -- Emerald Sanctuary, Splintertree Post, Orgrimmar, Everlook
				["0.50:0.65:0.46:0.70:0.63:0.56"] = 296, -- Emerald Sanctuary, Bloodvenom Post, Orgrimmar
				["0.50:0.65:0.41:0.63:0.56:0.47:0.55:0.27:0.61:0.20"] = 626, -- Emerald Sanctuary, Zoram'gar Outpost, Crossroads, Freewind Post, Gadgetzan
				["0.50:0.65:0.55:0.58:0.56:0.47:0.41:0.53"] = 387, -- Sanctuaire d'émeraude, Poste de Bois-brisé, La Croisée, Retraite de Roche-Soleil, Retraite de Roche-Soleil
				["0.50:0.65:0.55:0.58:0.63:0.56:0.61:0.45:0.61:0.20"] = 518, -- Emerald Sanctuary, Splintertree Post, Orgrimmar, Ratchet, Gadgetzan

				-- Horde: Everlook (Winterspring)
				["0.64:0.77:0.63:0.64:0.56:0.47:0.55:0.27:0.61:0.20"] = 575, -- Everlook, Valormok, Crossroads, Freewind Post, Gadgetzan
				["0.64:0.77:0.63:0.64:0.56:0.47:0.55:0.27"] = 483, -- Everlook, Valormok, Crossroads, Freewind Post
				["0.64:0.77:0.63:0.64:0.56:0.47:0.55:0.27:0.61:0.20:0.50:0.24"] = 676, -- Everlook, Valormok, Crossroads, Freewind Post, Gadgetzan, Marshal's Refuge
				["0.64:0.77:0.63:0.64:0.56:0.47:0.44:0.31:0.42:0.21"] = 680, -- Everlook, Valormok, Crossroads, Camp Mojache, Cenarion Hold
				["0.64:0.77:0.63:0.64:0.56:0.47:0.53:0.39:0.57:0.36:0.58:0.30"] = 491, -- Everlook, Valormok, Crossroads, Camp Taurajo, Brackenwall Village, Mudsprocket
				["0.64:0.77:0.63:0.64:0.56:0.47:0.53:0.39:0.57:0.36"] = 430, -- Everlook, Valormok, Crossroads, Camp Taurajo, Brackenwall Village
				["0.64:0.77:0.63:0.64:0.56:0.47:0.53:0.39"] = 371, -- Everlook, Valormok, Crossroads, Camp Taurajo
				["0.64:0.77:0.63:0.64:0.56:0.47:0.44:0.31"] = 550, -- Everlook, Valormok, Crossroads, Camp Mojache
				["0.64:0.77:0.63:0.64:0.45:0.44:0.32:0.42"] = 544, -- Everlook, Valormok, Thunder Bluff, Shadowprey Village
				["0.64:0.77:0.63:0.64:0.45:0.44"] = 385, -- Everlook, Valormok, Thunder Bluff
				["0.64:0.77:0.63:0.64:0.56:0.47"] = 299, -- Everlook, Valormok, Crossroads
				["0.64:0.77:0.63:0.64:0.63:0.56:0.61:0.45"] = 342, -- Everlook, Valormok, Orgrimmar, Ratchet
				["0.64:0.77:0.63:0.56"] = 243, -- Everlook, Orgrimmar
				["0.64:0.77:0.63:0.64:0.55:0.58"] = 228, -- Everlook, Valormok, Splintertree Post
				["0.64:0.77:0.63:0.64:0.56:0.47:0.41:0.53"] = 448, -- Everlook, Valormok, Crossroads, Sun Rock Retreat
				["0.64:0.77:0.46:0.70:0.41:0.63"] = 296, -- Everlook, Bloodvenom Post, Zoram'gar Outpost
				["0.64:0.77:0.46:0.70:0.50:0.65"] = 229, -- Everlook, Bloodvenom Post, Emerald Sanctuary
				["0.64:0.77:0.63:0.64"] = 135, -- Everlook, Valormok
				["0.64:0.77:0.46:0.70"] = 195, -- Everlook, Bloodvenom Post
				["0.64:0.77:0.54:0.79"] = 135, -- Everlook, Moonglade
				["0.64:0.77:0.63:0.56:0.56:0.47:0.45:0.44"] = 457, -- Everlook, Orgrimmar, Crossroads, Thunder Bluff
				["0.64:0.77:0.63:0.56:0.61:0.45"] = 351, -- Everlook, Orgrimmar, Ratchet
				["0.64:0.77:0.63:0.56:0.55:0.58"] = 333, -- Everlook, Orgrimmar, Splintertree Post
				["0.64:0.77:0.63:0.56:0.61:0.45:0.61:0.20"] = 591, -- Everlook, Orgrimmar, Ratchet, Gadgetzan
				["0.64:0.77:0.63:0.56:0.56:0.47:0.44:0.31"] = 602, -- Everlook, Orgrimmar, Crossroads, Camp Mojache
				["0.64:0.77:0.63:0.64:0.55:0.58:0.50:0.65"] = 306, -- Everlook, Valormok, Splintertree Post, Emerald Sanctuary
				["0.64:0.77:0.63:0.56:0.61:0.45:0.61:0.20:0.50:0.24"] = 696, -- Everlook, Orgrimmar, Ratchet, Gadgetzan, Marshal's Refuge
				["0.64:0.77:0.46:0.70:0.41:0.63:0.41:0.53"] = 416, -- Everlook, Bloodvenom Post, Zoram'gar Outpost, Sun Rock Retreat
				["0.64:0.77:0.46:0.70:0.41:0.63:0.41:0.53:0.32:0.42"] = 558, -- Everlook, Bloodvenom Post, Zoram'gar Outpost, Sun Rock Retreat, Shadowprey Village
				["0.64:0.77:0.63:0.56:0.55:0.58:0.50:0.65"] = 411, -- Everlook, Orgrimmar, Splintertree Post, Emerald Sanctuary
				["0.64:0.77:0.63:0.64:0.55:0.58:0.41:0.63"] = 388, -- Everlook, Valormok, Splintertree Post, Zoram'gar Outpost
				["0.64:0.77:0.63:0.56:0.56:0.47"] = 350, -- Everlook, Orgrimmar, Crossroads
				["0.64:0.77:0.63:0.56:0.56:0.47:0.55:0.27"] = 535, -- Everlook, Orgrimmar, Crossroads, Freewind Post
				["0.64:0.77:0.63:0.56:0.56:0.47:0.53:0.39"] = 424, -- Everlook, Orgrimmar, Crossroads, Camp Taurajo
				["0.64:0.77:0.63:0.64:0.56:0.47:0.55:0.27:0.58:0.30"] = 552, -- Everlook, Valormok, Crossroads, Freewind Post, Mudsprocket
				["0.64:0.77:0.63:0.56:0.56:0.47:0.44:0.31:0.42:0.21"] = 732, -- Everlook, Orgrimmar, Crossroads, Camp Mojache, Cenarion Hold
				["0.64:0.77:0.63:0.56:0.56:0.47:0.41:0.53"] = 500, -- Everlook, Orgrimmar, Crossroads, Sun Rock Retreat
				["0.64:0.77:0.63:0.64:0.45:0.44:0.44:0.31"] = 637, -- Everlook, Valormok, Thunder Bluff, Camp Mojache
				["0.64:0.77:0.63:0.56:0.56:0.47:0.41:0.63:0.50:0.65"] = 701, -- Everlook, Orgrimmar, Crossroads, Zoram'gar Outpost, Emerald Sanctuary
				["0.64:0.77:0.63:0.56:0.61:0.45:0.61:0.20:0.50:0.24:0.42:0.21"] = 790, -- Everlook, Orgrimmar, Ratchet, Gadgetzan, Marshal's Refuge, Cenarion Hold

				-- Horde: Freewind Post (Thousand Needles)
				["0.55:0.27:0.44:0.31:0.42:0.21"] = 252, -- Freewind Post, Camp Mojache, Cenarion Hold
				["0.55:0.27:0.61:0.20:0.50:0.24"] = 194, -- Freewind Post, Gadgetzan, Marshal's Refuge
				["0.55:0.27:0.61:0.20"] = 93, -- Freewind Post, Gadgetzan
				["0.55:0.27:0.58:0.30"] = 69, -- Freewind Post, Mudsprocket
				["0.55:0.27:0.57:0.36"] = 96, -- Freewind Post, Brackenwall Village
				["0.55:0.27:0.53:0.39"] = 137, -- Freewind Post, Camp Taurajo
				["0.55:0.27:0.44:0.31"] = 123, -- Freewind Post, Camp Mojache
				["0.55:0.27:0.44:0.31:0.32:0.42"] = 323, -- Freewind Post, Camp Mojache, Shadowprey Village
				["0.55:0.27:0.45:0.44"] = 223, -- Freewind Post, Thunder Bluff
				["0.55:0.27:0.56:0.47"] = 192, -- Freewind Post, Crossroads
				["0.55:0.27:0.57:0.36:0.61:0.45"] = 184, -- Freewind Post, Brackenwall Village, Ratchet
				["0.55:0.27:0.57:0.36:0.61:0.45:0.63:0.56"] = 279, -- Freewind Post, Brackenwall Village, Ratchet, Orgrimmar
				["0.55:0.27:0.56:0.47:0.55:0.58"] = 354, -- Freewind Post, Crossroads, Splintertree Post
				["0.55:0.27:0.56:0.47:0.41:0.53"] = 342, -- Freewind Post, Crossroads, Sun Rock Retreat
				["0.55:0.27:0.56:0.47:0.41:0.63"] = 422, -- Freewind Post, Crossroads, Zoram'gar Outpost
				["0.55:0.27:0.56:0.47:0.46:0.70"] = 445, -- Freewind Post, Crossroads, Bloodvenom Post
				["0.55:0.27:0.56:0.47:0.55:0.58:0.50:0.65"] = 432, -- Freewind Post, Crossroads, Splintertree Post, Emerald Sanctuary
				["0.55:0.27:0.56:0.47:0.63:0.64"] = 355, -- Freewind Post, Crossroads, Valormok
				["0.55:0.27:0.56:0.47:0.63:0.64:0.64:0.77"] = 484, -- Freewind Post, Crossroads, Valormok, Everlook
				["0.55:0.27:0.56:0.47:0.46:0.70:0.54:0.79"] = 566, -- Freewind Post, Crossroads, Bloodvenom Post, Moonglade
				["0.55:0.27:0.56:0.47:0.63:0.56"] = 308, -- Freewind Post, Crossroads, Orgrimmar
				["0.55:0.27:0.45:0.44:0.32:0.42"] = 382, -- Freewind Post, Thunder Bluff, Shadowprey Village
				["0.55:0.27:0.56:0.47:0.61:0.45"] = 243, -- Freewind Post, Crossroads, Ratchet
				["0.55:0.27:0.61:0.20:0.63:0.56"] = 443, -- Freewind Post, Gadgetzan, Orgrimmar
				["0.55:0.27:0.45:0.44:0.63:0.56:0.55:0.58"] = 519, -- Freewind Post, Thunder Bluff, Orgrimmar, Splintertree Post
				["0.55:0.27:0.45:0.44:0.63:0.56"] = 430, -- Freewind Post, Thunder Bluff, Orgrimmar

				-- Horde: Gadgetzan (Tanaris)
				["0.61:0.20:0.42:0.21"] = 233, -- Gadgetzan, Cenarion Hold
				["0.61:0.20:0.50:0.24"] = 108, -- Gadgetzan, Marshal's Refuge
				["0.61:0.20:0.55:0.27"] = 87, -- Gadgetzan, Freewind Post
				["0.61:0.20:0.55:0.27:0.58:0.30"] = 155, -- Gadgetzan, Freewind Post, Mudsprocket
				["0.61:0.20:0.57:0.36"] = 194, -- Gadgetzan, Brackenwall Village
				["0.61:0.20:0.55:0.27:0.53:0.39"] = 223, -- Gadgetzan, Freewind Post, Camp Taurajo
				["0.61:0.20:0.44:0.31"] = 199, -- Gadgetzan, Camp Mojache
				["0.61:0.20:0.44:0.31:0.32:0.42"] = 399, -- Gadgetzan, Camp Mojache, Shadowprey Village
				["0.61:0.20:0.45:0.44"] = 304, -- Gadgetzan, Thunder Bluff
				["0.61:0.20:0.56:0.47"] = 300, -- Gadgetzan, Crossroads
				["0.61:0.20:0.61:0.45"] = 243, -- Gadgetzan, Ratchet
				["0.61:0.20:0.63:0.56"] = 350, -- Gadgetzan, Orgrimmar
				["0.61:0.20:0.61:0.45:0.63:0.56:0.55:0.58"] = 429, -- Gadgetzan, Ratchet, Orgrimmar, Splintertree Post
				["0.61:0.20:0.55:0.27:0.56:0.47:0.41:0.53"] = 427, -- Gadgetzan, Freewind Post, Crossroads, Sun Rock Retreat
				["0.61:0.20:0.55:0.27:0.56:0.47:0.41:0.63"] = 508, -- Gadgetzan, Freewind Post, Crossroads, Zoram'gar Outpost
				["0.61:0.20:0.61:0.45:0.63:0.56:0.55:0.58:0.50:0.65"] = 507, -- Gadgetzan, Ratchet, Orgrimmar, Splintertree Post, Emerald Sanctuary
				["0.61:0.20:0.55:0.27:0.56:0.47:0.46:0.70"] = 531, -- Gadgetzan, Freewind Post, Crossroads, Bloodvenom Post
				["0.61:0.20:0.61:0.45:0.63:0.56:0.63:0.64"] = 434, -- Gadgetzan, Ratchet, Orgrimmar, Valormok
				["0.61:0.20:0.61:0.45:0.63:0.56:0.63:0.64:0.64:0.77"] = 564, -- Gadgetzan, Ratchet, Orgrimmar, Valormok, Everlook
				["0.61:0.20:0.55:0.27:0.56:0.47:0.46:0.70:0.54:0.79"] = 652, -- Gadgetzan, Freewind Post, Crossroads, Bloodvenom Post, Moonglade
				["0.61:0.20:0.45:0.44:0.32:0.42"] = 463, -- Gadgetzan, Thunder Bluff, Shadowprey Village
				["0.61:0.20:0.56:0.47:0.53:0.39"] = 374, -- Gadgetzan, Crossroads, Camp Taurajo
				["0.61:0.20:0.61:0.45:0.63:0.56:0.64:0.77"] = 580, -- Gadgetzan, Ratchet, Orgrimmar, Everlook
				["0.61:0.20:0.57:0.36:0.58:0.30"] = 255, -- Gadgetzan, Brackenwall Village, Mudsprocket
				["0.61:0.20:0.55:0.27:0.56:0.47:0.63:0.64"] = 441, -- Gadgetzan, Freewind Post, Crossroads, Valormok
				["0.61:0.20:0.56:0.47:0.41:0.63"] = 532, -- Gadgetzan, Crossroads, Zoram'gar Outpost
				["0.61:0.20:0.63:0.56:0.55:0.58"] = 439, -- Gadgetzan, Orgrimmar, Splintertree Post

				-- Horde: Marshal's Refuge (Un'Goro Crater)
				["0.50:0.24:0.42:0.21"] = 100, -- Marshal's Refuge, Cenarion Hold
				["0.50:0.24:0.61:0.20"] = 113, -- Marshal's Refuge, Gadgetzan
				["0.50:0.24:0.61:0.20:0.55:0.27"] = 200, -- Marshal's Refuge, Gadgetzan, Freewind Post
				["0.50:0.24:0.61:0.20:0.55:0.27:0.58:0.30"] = 268, -- Marshal's Refuge, Gadgetzan, Freewind Post, Mudsprocket
				["0.50:0.24:0.61:0.20:0.55:0.27:0.57:0.36"] = 294, -- Marshal's Refuge, Gadgetzan, Freewind Post, Brackenwall Village
				["0.50:0.24:0.61:0.20:0.55:0.27:0.53:0.39"] = 336, -- Marshal's Refuge, Gadgetzan, Freewind Post, Camp Taurajo
				["0.50:0.24:0.42:0.21:0.44:0.31"] = 224, -- Marshal's Refuge, Cenarion Hold, Camp Mojache
				["0.50:0.24:0.42:0.21:0.44:0.31:0.32:0.42"] = 424, -- Marshal's Refuge, Cenarion Hold, Camp Mojache, Shadowprey Village
				["0.50:0.24:0.61:0.20:0.45:0.44"] = 416, -- Marshal's Refuge, Gadgetzan, Thunder Bluff
				["0.50:0.24:0.61:0.20:0.55:0.27:0.56:0.47"] = 392, -- Marshal's Refuge, Gadgetzan, Freewind Post, Crossroads
				["0.50:0.24:0.61:0.20:0.61:0.45"] = 354, -- Marshal's Refuge, Gadgetzan, Ratchet
				["0.50:0.24:0.61:0.20:0.61:0.45:0.63:0.56"] = 450, -- Marshal's Refuge, Gadgetzan, Ratchet, Orgrimmar
				["0.50:0.24:0.61:0.20:0.61:0.45:0.63:0.56:0.55:0.58"] = 540, -- Marshal's Refuge, Gadgetzan, Ratchet, Orgrimmar, Splintertree Post
				["0.50:0.24:0.61:0.20:0.55:0.27:0.56:0.47:0.41:0.53"] = 540, -- Marshal's Refuge, Gadgetzan, Freewind Post, Crossroads, Sun Rock Retreat
				["0.50:0.24:0.61:0.20:0.55:0.27:0.56:0.47:0.41:0.63"] = 621, -- Marshal's Refuge, Gadgetzan, Freewind Post, Crossroads, Zoram'gar Outpost
				["0.50:0.24:0.61:0.20:0.61:0.45:0.63:0.56:0.55:0.58:0.50:0.65"] = 618, -- Marshal's Refuge, Gadgetzan, Ratchet, Orgrimmar, Splintertree Post, Emerald Sanctuary
				["0.50:0.24:0.61:0.20:0.55:0.27:0.56:0.47:0.46:0.70"] = 645, -- Marshal's Refuge, Gadgetzan, Freewind Post, Crossroads, Bloodvenom Post
				["0.50:0.24:0.61:0.20:0.61:0.45:0.63:0.56:0.63:0.64"] = 546, -- Marshal's Refuge, Gadgetzan, Ratchet, Orgrimmar, Valormok
				["0.50:0.24:0.61:0.20:0.61:0.45:0.63:0.56:0.63:0.64:0.64:0.77"] = 675, -- Marshal's Refuge, Gadgetzan, Ratchet, Orgrimmar, Valormok, Everlook
				["0.50:0.24:0.61:0.20:0.55:0.27:0.56:0.47:0.46:0.70:0.54:0.79"] = 766, -- Marshal's Refuge, Gadgetzan, Freewind Post, Crossroads, Bloodvenom Post, Moonglade
				["0.50:0.24:0.61:0.20:0.44:0.31"] = 312, -- Marshal's Refuge, Gadgetzan, Camp Mojache
				["0.50:0.24:0.61:0.20:0.61:0.45:0.63:0.56:0.64:0.77"] = 691, -- Marshal's Refuge, Gadgetzan, Ratchet, Orgrimmar, Everlook
				["0.50:0.24:0.61:0.20:0.44:0.31:0.32:0.42"] = 512, -- Marshal's Refuge, Gadgetzan, Camp Mojache, Shadowprey Village
				["0.50:0.24:0.61:0.20:0.57:0.36:0.53:0.39"] = 354, -- Marshal's Refuge, Gadgetzan, Brackenwall Village, Camp Taurajo
				["0.50:0.24:0.61:0.20:0.57:0.36"] = 306, -- Marshal's Refuge, Gadgetzan, Brackenwall Village

				-- Horde: Moonglade (Moonglade)
				["0.54:0.79:0.46:0.70:0.56:0.47:0.44:0.31:0.42:0.21"] = 734, -- Moonglade, Bloodvenom Post, Crossroads, Camp Mojache, Cenarion Hold
				["0.54:0.79:0.46:0.70:0.56:0.47:0.55:0.27:0.61:0.20:0.50:0.24"] = 730, -- Moonglade, Bloodvenom Post, Crossroads, Freewind Post, Gadgetzan, Marshal's Refuge
				["0.54:0.79:0.46:0.70:0.56:0.47:0.55:0.27"] = 537, -- Moonglade, Bloodvenom Post, Crossroads, Freewind Post
				["0.54:0.79:0.46:0.70:0.56:0.47:0.53:0.39:0.57:0.36:0.58:0.30"] = 545, -- Moonglade, Bloodvenom Post, Crossroads, Camp Taurajo, Brackenwall Village, Mudsprocket
				["0.54:0.79:0.46:0.70:0.56:0.47:0.55:0.27:0.61:0.20"] = 629, -- Moonglade, Bloodvenom Post, Crossroads, Freewind Post, Gadgetzan
				["0.54:0.79:0.46:0.70:0.56:0.47:0.53:0.39:0.57:0.36"] = 484, -- Moonglade, Bloodvenom Post, Crossroads, Camp Taurajo, Brackenwall Village
				["0.54:0.79:0.46:0.70:0.56:0.47:0.53:0.39"] = 426, -- Moonglade, Bloodvenom Post, Crossroads, Camp Taurajo
				["0.54:0.79:0.46:0.70:0.56:0.47:0.44:0.31"] = 604, -- Moonglade, Bloodvenom Post, Crossroads, Camp Mojache
				["0.54:0.79:0.46:0.70:0.41:0.63:0.41:0.53:0.32:0.42"] = 515, -- Moonglade, Bloodvenom Post, Zoram'gar Outpost, Sun Rock Retreat, Shadowprey Village
				["0.54:0.79:0.46:0.70:0.56:0.47:0.45:0.44"] = 459, -- Moonglade, Bloodvenom Post, Crossroads, Thunder Bluff
				["0.54:0.79:0.46:0.70:0.56:0.47"] = 353, -- Moonglade, Bloodvenom Post, Crossroads
				["0.54:0.79:0.46:0.70:0.56:0.47:0.61:0.45"] = 404, -- Moonglade, Bloodvenom Post, Crossroads, Ratchet
				["0.54:0.79:0.64:0.77:0.63:0.64:0.63:0.56"] = 377, -- Moonglade, Everlook, Valormok, Orgrimmar
				["0.54:0.79:0.46:0.70:0.50:0.65:0.55:0.58"] = 269, -- Moonglade, Bloodvenom Post, Emerald Sanctuary, Splintertree Post
				["0.54:0.79:0.46:0.70:0.41:0.63:0.41:0.53"] = 373, -- Moonglade, Bloodvenom Post, Zoram'gar Outpost, Sun Rock Retreat
				["0.54:0.79:0.46:0.70:0.41:0.63"] = 253, -- Moonglade, Bloodvenom Post, Zoram'gar Outpost
				["0.54:0.79:0.46:0.70:0.50:0.65"] = 186, -- Moonglade, Bloodvenom Post, Emerald Sanctuary
				["0.54:0.79:0.64:0.77:0.63:0.64"] = 276, -- Moonglade, Everlook, Valormok
				["0.54:0.79:0.64:0.77"] = 142, -- Moonglade, Everlook
				["0.54:0.79:0.46:0.70"] = 157, -- Moonglade, Bloodvenom Post
				["0.54:0.79:0.46:0.70:0.50:0.65:0.55:0.58:0.63:0.56"] = 358, -- Moonglade, Bloodvenom Post, Emerald Sanctuary, Splintertree Post, Orgrimmar
				["0.54:0.79:0.64:0.77:0.63:0.56"] = 384, -- Moonglade, Everlook, Orgrimmar
				["0.54:0.79:0.46:0.70:0.63:0.56"] = 371, -- Moonglade, Bloodvenom Post, Orgrimmar
				["0.54:0.79:0.64:0.77:0.63:0.56:0.61:0.45:0.57:0.36"] = 592, -- Moonglade, Everlook, Orgrimmar, Ratchet, Brackenwall Village
				["0.54:0.79:0.46:0.70:0.63:0.64"] = 339, -- Moonglade, Bloodvenom Post, Valormok
				["0.54:0.79:0.64:0.77:0.63:0.64:0.55:0.58"] = 370, -- Moonglade, Everlook, Valormok, Splintertree Post
				["0.54:0.79:0.64:0.77:0.63:0.64:0.56:0.47:0.44:0.31"] = 692, -- Moonglade, Everlook, Valormok, Crossroads, Camp Mojache
				["0.54:0.79:0.64:0.77:0.63:0.56:0.61:0.45:0.61:0.20:0.50:0.24:0.42:0.21"] = 933, -- Moonglade, Everlook, Orgrimmar, Ratchet, Gadgetzan, Marshal's Refuge, Cenarion Hold
				["0.54:0.79:0.46:0.70:0.56:0.47:0.45:0.44:0.32:0.42"] = 618, -- Moonglade, Bloodvenom Post, Crossroads, Thunder Bluff, Shadowprey Village
				["0.54:0.79:0.64:0.77:0.63:0.64:0.55:0.58:0.50:0.65"] = 448, -- Moonglade, Everlook, Valormok, Splintertree Post, Emerald Sanctuary
				["0.54:0.79:0.46:0.70:0.41:0.63:0.55:0.58"] = 426, -- Moonglade, Bloodvenom Post, Zoram'gar Outpost, Splintertree Post
				["0.54:0.79:0.64:0.77:0.63:0.56:0.61:0.45"] = 492, -- Mondlichtung, Ewige Warte, Orgrimmar, Ratschet
				["0.54:0.79:0.64:0.77:0.63:0.56:0.56:0.47:0.41:0.53"] = 641, -- Moonglade, Everlook, Orgrimmar, Crossroads, Sun Rock Retreat
				["0.54:0.79:0.64:0.77:0.63:0.56:0.61:0.45:0.61:0.20"] = 730, -- Moonglade, Everlook, Orgrimmar, Ratchet, Gadgetzan
				["0.54:0.79:0.64:0.77:0.63:0.56:0.56:0.47:0.44:0.31"] = 743, -- Moonglade, Everlook, Orgrimmar, Crossroads, Camp Mojache
				["0.54:0.79:0.64:0.77:0.63:0.56:0.61:0.45:0.61:0.20:0.50:0.24"] = 836, -- Moonglade, Everlook, Orgrimmar, Ratchet, Gadgetzan, Marshal's Refuge
				["0.54:0.79:0.46:0.70:0.56:0.47:0.61:0.45:0.61:0.20"] = 640, -- Moonglade, Bloodvenom Post, Crossroads, Ratchet, Gadgetzan
				["0.54:0.79:0.64:0.77:0.63:0.64:0.56:0.47:0.53:0.39"] = 513, -- Moonglade, Everlook, Valormok, Crossroads, Camp Taurajo

				-- Horde: Mudsprocket (Dustwallow Marsh)
				["0.58:0.30:0.55:0.27:0.44:0.31:0.42:0.21"] = 324, -- Mudsprocket, Freewind Post, Camp Mojache, Cenarion Hold
				["0.58:0.30:0.55:0.27:0.61:0.20:0.50:0.24"] = 265, -- Mudsprocket, Freewind Post, Gadgetzan, Marshal's Refuge
				["0.58:0.30:0.55:0.27"] = 71, -- Mudsprocket, Freewind Post
				["0.58:0.30:0.55:0.27:0.61:0.20"] = 164, -- Mudsprocket, Freewind Post, Gadgetzan
				["0.58:0.30:0.55:0.27:0.44:0.31"] = 194, -- Mudsprocket, Freewind Post, Camp Mojache
				["0.58:0.30:0.57:0.36"] = 63, -- Mudsprocket, Brackenwall Village
				["0.58:0.30:0.57:0.36:0.53:0.39"] = 111, -- Mudsprocket, Brackenwall Village, Camp Taurajo
				["0.58:0.30:0.57:0.36:0.53:0.39:0.45:0.44:0.32:0.42"] = 383, -- Mudsprocket, Brackenwall Village, Camp Taurajo, Thunder Bluff, Shadowprey Village
				["0.58:0.30:0.57:0.36:0.53:0.39:0.45:0.44"] = 224, -- Mudsprocket, Brackenwall Village, Camp Taurajo, Thunder Bluff
				["0.58:0.30:0.57:0.36:0.53:0.39:0.56:0.47"] = 189, -- Mudsprocket, Brackenwall Village, Camp Taurajo, Crossroads
				["0.58:0.30:0.57:0.36:0.61:0.45"] = 150, -- Mudsprocket, Brackenwall Village, Ratchet
				["0.58:0.30:0.57:0.36:0.61:0.45:0.63:0.56"] = 245, -- Mudsprocket, Brackenwall Village, Ratchet, Orgrimmar
				["0.58:0.30:0.57:0.36:0.61:0.45:0.63:0.56:0.55:0.58"] = 334, -- Mudsprocket, Brackenwall Village, Ratchet, Orgrimmar, Splintertree Post
				["0.58:0.30:0.57:0.36:0.53:0.39:0.56:0.47:0.41:0.53"] = 338, -- Mudsprocket, Brackenwall Village, Camp Taurajo, Crossroads, Sun Rock Retreat
				["0.58:0.30:0.57:0.36:0.53:0.39:0.56:0.47:0.41:0.63"] = 419, -- Mudsprocket, Brackenwall Village, Camp Taurajo, Crossroads, Zoram'gar Outpost
				["0.58:0.30:0.57:0.36:0.61:0.45:0.63:0.56:0.55:0.58:0.50:0.65"] = 412, -- Mudsprocket, Brackenwall Village, Ratchet, Orgrimmar, Splintertree Post, Emerald Sanctuary
				["0.58:0.30:0.57:0.36:0.61:0.45:0.63:0.56:0.63:0.64"] = 340, -- Mudsprocket, Brackenwall Village, Ratchet, Orgrimmar, Valormok
				["0.58:0.30:0.57:0.36:0.53:0.39:0.56:0.47:0.46:0.70"] = 442, -- Mudsprocket, Brackenwall Village, Camp Taurajo, Crossroads, Bloodvenom Post
				["0.58:0.30:0.57:0.36:0.53:0.39:0.56:0.47:0.46:0.70:0.54:0.79"] = 563, -- Mudsprocket, Brackenwall Village, Camp Taurajo, Crossroads, Bloodvenom Post, Moonglade
				["0.58:0.30:0.57:0.36:0.61:0.45:0.63:0.56:0.63:0.64:0.64:0.77"] = 469, -- Mudsprocket, Brackenwall Village, Ratchet, Orgrimmar, Valormok, Everlook
				["0.58:0.30:0.55:0.27:0.45:0.44"] = 294, -- Mudsprocket, Freewind Post, Thunder Bluff
				["0.58:0.30:0.55:0.27:0.56:0.47:0.61:0.45"] = 314, -- Mudsprocket, Freewind Post, Crossroads, Ratchet
				["0.58:0.30:0.55:0.27:0.53:0.39"] = 209, -- Mudsprocket, Freewind Post, Camp Taurajo
				["0.58:0.30:0.57:0.36:0.63:0.56"] = 279, -- Mudsprocket, Brackenwall Village, Orgrimmar
				["0.58:0.30:0.55:0.27:0.56:0.47:0.63:0.56"] = 379, -- Mudsprocket, Freewind Post, Crossroads, Orgrimmar
				["0.58:0.30:0.55:0.27:0.44:0.31:0.32:0.42"] = 394, -- Mudsprocket, Freewind Post, Camp Mojache, Shadowprey Village
				["0.58:0.30:0.55:0.27:0.45:0.44:0.32:0.42"] = 453, -- Mudsprocket, Freewind Post, Thunder Bluff, Shadowprey Village
				["0.58:0.30:0.57:0.36:0.61:0.20"] = 266, -- Mudsprocket, Brackenwall Village, Gadgetzan
				["0.58:0.30:0.57:0.36:0.61:0.45:0.63:0.56:0.64:0.77"] = 485, -- Mudsprocket, Brackenwall Village, Ratchet, Orgrimmar, Everlook
				["0.58:0.30:0.57:0.36:0.53:0.39:0.56:0.47:0.44:0.31"] = 441, -- Mudsprocket, Brackenwall Village, Camp Taurajo, Crossroads, Camp Mojache

				-- Horde: Orgrimmar (Durotar)
				["0.63:0.56:0.61:0.20"] = 417, -- Orgrimmar, Gadgetzan
				["0.63:0.56:0.56:0.47:0.44:0.31:0.42:0.21"] = 492, -- Orgrimmar, Crossroads, Camp Mojache, Cenarion Hold
				["0.63:0.56:0.61:0.45:0.61:0.20:0.50:0.24"] = 454, -- Orgrimmar, Ratchet, Gadgetzan, Marshal's Refuge (José Antonio González reported 478)
				["0.63:0.56:0.56:0.47:0.55:0.27"] = 292, -- Orgrimmar, Crossroads, Freewind Post (Yaki Kadafi reported 109) (John Comrie reported 147)
				["0.63:0.56:0.61:0.45:0.57:0.36:0.58:0.30"] = 268, -- Orgrimmar, Ratchet, Brackenwall Village, Mudsprocket
				["0.63:0.56:0.57:0.36"] = 229, -- Orgrimmar, Brackenwall Village
				["0.63:0.56:0.56:0.47:0.53:0.39"] = 181, -- Orgrimmar, Crossroads, Camp Taurajo
				["0.63:0.56:0.56:0.47:0.44:0.31"] = 361, -- Orgrimmar, Crossroads, Camp Mojache
				["0.63:0.56:0.56:0.47:0.45:0.44:0.32:0.42"] = 373, -- Orgrimmar, Crossroads, Thunder Bluff, Shadowprey Village (guy.decrolier@gmail.com reported 194)
				["0.63:0.56:0.45:0.44"] = 224, -- Orgrimmar, Thunder Bluff (David Galindo reported 233)
				["0.63:0.56:0.56:0.47"] = 110, -- Orgrimmar, Crossroads (Dom Alegria reported 181)
				["0.63:0.56:0.61:0.45"] = 108, -- Orgrimmar, Ratchet
				["0.63:0.56:0.63:0.64"] = 95, -- Orgrimmar, Valormok
				["0.63:0.56:0.55:0.58"] = 90, -- Orgrimmar, Splintertree Post
				["0.63:0.56:0.56:0.47:0.41:0.53"] = 258, -- Orgrimmar, Crossroads, Sun Rock Retreat
				["0.63:0.56:0.55:0.58:0.41:0.63"] = 249, -- Orgrimmar, Splintertree Post, Zoram'gar Outpost
				["0.63:0.56:0.55:0.58:0.50:0.65"] = 168, -- Orgrimmar, Splintertree Post, Emerald Sanctuary
				["0.63:0.56:0.46:0.70"] = 252, -- Orgrimmar, Bloodvenom Post
				["0.63:0.56:0.63:0.64:0.64:0.77:0.54:0.79"] = 358, -- Orgrimmar, Valormok, Everlook, Moonglade
				["0.63:0.56:0.64:0.77"] = 240, -- Orgrimmar, Everlook
				["0.63:0.56:0.55:0.58:0.50:0.65:0.46:0.70:0.54:0.79"] = 371, -- Orgrimmar, Splintertree Post, Emerald Sanctuary, Bloodvenom Post, Moonglade
				["0.63:0.56:0.56:0.47:0.41:0.63"] = 339, -- Orgrimmar, Crossroads, Zoram'gar Outpost
				["0.63:0.56:0.64:0.77:0.54:0.79"] = 374, -- Orgrimmar, Everlook, Moonglade
				["0.63:0.56:0.61:0.45:0.61:0.20:0.50:0.24:0.42:0.21"] = 549, -- Orgrimmar, Ratchet, Gadgetzan, Marshal's Refuge, Cenarion Hold
				["0.63:0.56:0.57:0.36:0.58:0.30"] = 289, -- Orgrimmar, Brackenwall Village, Mudsprocket
				["0.63:0.56:0.56:0.47:0.55:0.27:0.61:0.20:0.50:0.24:0.42:0.21"] = 581, -- Orgrimmar, Crossroads, Freewind Post, Gadgetzan, Marshal's Refuge, Cenarion Hold
				["0.63:0.56:0.61:0.20:0.42:0.21"] = 650, -- Orgrimmar, Gadgetzan, Cenarion Hold
				["0.63:0.56:0.45:0.44:0.53:0.39"] = 312, -- Orgrimmar, Thunder Bluff, Camp Taurajo
				["0.63:0.56:0.45:0.44:0.55:0.27"] = 429, -- Orgrimmar, Thunder Bluff, Freewind Post
				["0.63:0.56:0.56:0.47:0.55:0.27:0.58:0.30"] = 361, -- Orgrimmar, Crossroads, Freewind Post, Mudsprocket
				["0.63:0.56:0.46:0.70:0.50:0.65"] = 278, -- Orgrimmar, Bloodvenom Post, Emerald Sanctuary
				["0.63:0.56:0.61:0.45:0.57:0.36:0.55:0.27:0.44:0.31:0.32:0.42"] = 633, -- Orgrimmar, Ratchet, Brackenwall Village, Freewind Post, Camp Mojache, Shadowprey Village
				["0.63:0.56:0.56:0.47:0.41:0.53:0.32:0.42"] = 400, -- Orgrimmar, Crossroads, Sun Rock Retreat, Shadowprey Village
				["0.63:0.56:0.45:0.44:0.41:0.53"] = 407, -- Orgrimmar, Thunder Bluff, Sun Rock Retreat
				["0.63:0.56:0.56:0.47:0.41:0.63:0.50:0.65"] = 459, -- Orgrimmar, Crossroads, Zoram'gar Outpost, Emerald Sanctuary
				["0.63:0.56:0.56:0.47:0.55:0.27:0.61:0.20:0.50:0.24"] = 485, -- Orgrimmar, La Croisée, Poste de Librevent, Gadgetzan, Refuge des Marshal
				["0.63:0.56:0.56:0.47:0.44:0.31:0.32:0.42"] = 559, -- Orgrimmar, Crossroads, Camp Mojache, Shadowprey Village
				["0.63:0.56:0.57:0.36:0.53:0.39"] = 276, -- Orgrimmar, Brackenwall, Camp Taurajo

				-- Horde: Ratchet (The Barrens)
				["0.61:0.45:0.61:0.20:0.50:0.24:0.42:0.21"] = 443, -- Ratchet, Gadgetzan, Marshal's Refuge, Cenarion Hold
				["0.61:0.45:0.61:0.20:0.50:0.24"] = 347, -- Ratchet, Gadgetzan, Marshal's Refuge
				["0.61:0.45:0.57:0.36:0.55:0.27"] = 204, -- Ratchet, Brackenwall Village, Freewind Post
				["0.61:0.45:0.61:0.20"] = 241, -- Ratchet, Gadgetzan
				["0.61:0.45:0.56:0.47:0.44:0.31"] = 320, -- Ratchet, Crossroads, Camp Mojache
				["0.61:0.45:0.57:0.36:0.58:0.30"] = 161, -- Ratchet, Brackenwall Village, Mudsprocket
				["0.61:0.45:0.57:0.36"] = 101, -- Ratchet, Brackenwall Village
				["0.61:0.45:0.56:0.47:0.53:0.39"] = 141, -- Ratchet, Crossroads, Camp Taurajo
				["0.61:0.45:0.56:0.47:0.45:0.44:0.32:0.42"] = 334, -- Ratchet, Crossroads, Thunder Bluff, Shadowprey Village
				["0.61:0.45:0.56:0.47:0.45:0.44"] = 175, -- Ratchet, Crossroads, Thunder Bluff (Elena Liakhovskaia reported 70)
				["0.61:0.45:0.56:0.47"] = 69, -- Ratchet, Crossroads
				["0.61:0.45:0.56:0.47:0.41:0.53"] = 218, -- Ratchet, Crossroads, Sun Rock Retreat
				["0.61:0.45:0.63:0.56:0.55:0.58"] = 190, -- Ratchet, Orgrimmar, Splintertree Post -- CHANGE from 101 to 191 (Basse, Nate Sander, Lori Payne, Video Games, Josh Romey, Nelson Egger II)
				["0.61:0.45:0.63:0.56"] = 101, -- Ratchet, Orgrimmar
				["0.61:0.45:0.63:0.56:0.63:0.64"] = 196, -- Ratchet, Orgrimmar, Valormok
				["0.61:0.45:0.63:0.56:0.55:0.58:0.50:0.65"] = 269, -- Ratchet, Orgrimmar, Splintertree Post, Emerald Sanctuary
				["0.61:0.45:0.56:0.47:0.41:0.63"] = 299, -- Ratchet, Crossroads, Zoram'gar Outpost
				["0.61:0.45:0.56:0.47:0.46:0.70"] = 321, -- Ratchet, Crossroads, Bloodvenom Post
				["0.61:0.45:0.63:0.56:0.63:0.64:0.64:0.77:0.54:0.79"] = 458, -- Ratchet, Orgrimmar, Valormok, Everlook, Moonglade
				["0.61:0.45:0.63:0.56:0.63:0.64:0.64:0.77"] = 325, -- Ratchet, Orgrimmar, Valormok, Everlook
				["0.61:0.45:0.56:0.47:0.55:0.27"] = 253, -- Ratchet, Crossroads, Freewind Post
				["0.61:0.45:0.63:0.56:0.64:0.77"] = 341, -- Ratchet, Orgrimmar, Everlook
				["0.61:0.45:0.56:0.47:0.46:0.70:0.54:0.79"] = 443, -- Ratchet, Crossroads, Bloodvenom Post, Moonglade
				["0.61:0.45:0.56:0.47:0.55:0.27:0.58:0.30"] = 322, -- Ratchet, Crossroads, Freewind Post, Mudsprocket
				["0.61:0.45:0.63:0.56:0.55:0.58:0.41:0.63"] = 349, -- Ratchet, Orgrimmar, Splintertree Post, Zoram'gar Outpost
				["0.61:0.45:0.56:0.47:0.41:0.63:0.50:0.65"] = 420, -- Ratchet, Crossroads, Zoram'gar Outpost, Emerald Sanctuary
				["0.61:0.45:0.63:0.56:0.45:0.44"] = 326, -- Ratchet, Orgrimmar, Thunder Bluff
				["0.61:0.45:0.63:0.56:0.45:0.44:0.53:0.39"] = 413, -- Trinquete, Orgrimmar, Cima del Trueno, Campamento Taurajo
				["0.61:0.45:0.56:0.47:0.55:0.58"] = 231, -- Ratchet, Crossroads, Splintertree Post
				["0.61:0.45:0.56:0.47:0.41:0.53:0.32:0.42"] = 361, -- Ratchet, Crossroads, Sun Rock Retreat, Shadowprey Village
				["0.61:0.45:0.57:0.36:0.55:0.27:0.44:0.31"] = 326, -- Ratchet, Brackenwall Village, Freewind Post, Camp Mojache
				["0.61:0.45:0.63:0.56:0.64:0.77:0.54:0.79"] = 474, -- Ratschet, Orgrimmar, Ewige Warte, Mondlichtung
				["0.61:0.45:0.56:0.47:0.44:0.31:0.42:0.21"] = 450, -- Ratchet, Crossroads, Camp Mojache, Cenarion Hold
				["0.61:0.45:0.57:0.36:0.53:0.39:0.45:0.44"] = 262, -- Ratchet, Brackenwall Village, Camp Taurajo, Thunder Bluff
				["0.61:0.45:0.61:0.20:0.44:0.31"] = 441, -- Ratchet, Gadgetzan, Camp Mojache

				-- Horde: Shadowprey Village (Desolace)
				["0.32:0.42:0.44:0.31:0.42:0.21"] = 326, -- Shadowprey Village, Camp Mojache, Cenarion Hold
				["0.32:0.42:0.44:0.31:0.42:0.21:0.50:0.24"] = 417, -- Shadowprey Village, Camp Mojache, Cenarion Hold, Marshal's Refuge
				["0.32:0.42:0.44:0.31:0.55:0.27:0.61:0.20"] = 395, -- Shadowprey Village, Camp Mojache, Freewind Post, Gadgetzan
				["0.32:0.42:0.44:0.31:0.55:0.27"] = 303, -- Shadowprey Village, Camp Mojache, Freewind Post
				["0.32:0.42:0.44:0.31"] = 196, -- Shadowprey Village, Camp Mojache
				["0.32:0.42:0.44:0.31:0.55:0.27:0.58:0.30"] = 372, -- Shadowprey Village, Camp Mojache, Freewind Post, Mudsprocket
				["0.32:0.42:0.45:0.44:0.53:0.39:0.57:0.36"] = 323, -- Shadowprey Village, Thunder Bluff, Camp Taurajo, Brackenwall Village
				["0.32:0.42:0.45:0.44:0.53:0.39"] = 265, -- Shadowprey Village, Thunder Bluff, Camp Taurajo
				["0.32:0.42:0.45:0.44:0.56:0.47:0.61:0.45"] = 332, -- Shadowprey Village, Thunder Bluff, Crossroads, Ratchet
				["0.32:0.42:0.45:0.44:0.56:0.47"] = 281, -- Shadowprey Village, Thunder Bluff, Crossroads
				["0.32:0.42:0.45:0.44"] = 178, -- Shadowprey Village, Thunder Bluff
				["0.32:0.42:0.41:0.53"] = 199, -- Shadowprey Village, Sun Rock Retreat
				["0.32:0.42:0.45:0.44:0.56:0.47:0.55:0.58"] = 443, -- Shadowprey Village, Thunder Bluff, Crossroads, Splintertree Post
				["0.32:0.42:0.45:0.44:0.63:0.56"] = 386, -- Shadowprey Village, Thunder Bluff, Orgrimmar
				["0.32:0.42:0.45:0.44:0.63:0.64"] = 429, -- Shadowprey Village, Thunder Bluff, Valormok
				["0.32:0.42:0.41:0.53:0.41:0.63:0.50:0.65"] = 441, -- Shadowprey Village, Sun Rock Retreat, Zoram'gar Outpost, Emerald Sanctuary
				["0.32:0.42:0.41:0.53:0.41:0.63"] = 320, -- Shadowprey Village, Sun Rock Retreat, Zoram'gar Outpost
				["0.32:0.42:0.41:0.53:0.41:0.63:0.46:0.70"] = 457, -- Shadowprey Village, Sun Rock Retreat, Zoram'gar Outpost, Bloodvenom Post
				["0.32:0.42:0.41:0.53:0.41:0.63:0.46:0.70:0.54:0.79"] = 581, -- Shadowprey Village, Sun Rock Retreat, Zoram'gar Outpost, Bloodvenom Post, Moonglade
				["0.32:0.42:0.45:0.44:0.63:0.64:0.64:0.77"] = 558, -- Shadowprey Village, Thunder Bluff, Valormok, Everlook
				["0.32:0.42:0.45:0.44:0.55:0.27"] = 382, -- Shadowprey Village, Thunder Bluff, Freewind Post
				["0.32:0.42:0.45:0.44:0.53:0.39:0.57:0.36:0.58:0.30"] = 384, -- Shadowprey Village, Thunder Bluff, Camp Taurajo, Brackenwall Village, Mudsprocket
				["0.32:0.42:0.45:0.44:0.61:0.20"] = 469, -- Shadowprey Village, Thunder Bluff, Gadgetzan
				["0.32:0.42:0.44:0.31:0.55:0.27:0.61:0.20:0.50:0.24"] = 497, -- Shadowprey Village, Camp Mojache, Freewind Post, Gadgetzan, Marshal's Refuge
				["0.32:0.42:0.41:0.53:0.56:0.47:0.63:0.56"] = 465, -- Shadowprey Village, Sun Rock Retreat, Crossroads, Orgrimmar
				["0.32:0.42:0.45:0.44:0.63:0.56:0.64:0.77"] = 626, -- Shadowprey Village, Thunder Bluff, Orgrimmar, Everlook
				["0.32:0.42:0.45:0.44:0.63:0.64:0.64:0.77:0.54:0.79"] = 691, -- Shadowprey Village, Thunder Bluff, Valormok, Everlook, Moonglade
				["0.32:0.42:0.41:0.53:0.56:0.47:0.55:0.27"] = 533, -- Shadowprey Village, Sun Rock Retreat, Crossroads, Freewind Post
				["0.32:0.42:0.41:0.53:0.56:0.47"] = 348, -- Shadowprey Village, Sun Rock Retreat, Crossroads
				["0.32:0.42:0.45:0.44:0.56:0.47:0.55:0.58:0.50:0.65"] = 521, -- Shadowprey Village, Thunder Bluff, Crossroads, Splintertree Post, Emerald Sanctuary
				["0.32:0.42:0.41:0.53:0.56:0.47:0.61:0.45"] = 400, -- Schattenflucht, Sonnenfels, Das Wegekreuz, Ratschet
				["0.32:0.42:0.41:0.53:0.56:0.47:0.53:0.39"] = 422, -- Shadowprey Village, Sun Rock Retreat, Crossroads, Camp Taurajo
				["0.32:0.42:0.41:0.53:0.56:0.47:0.55:0.58"] = 511, -- Shadowprey Village, Sun Rock Retreat, Crossroads, Splintertree Post
				["0.32:0.42:0.45:0.44:0.41:0.63"] = 443, -- Shadowprey Village, Thunder Bluff, Zoram'gar Outpost
				["0.32:0.42:0.45:0.44:0.56:0.47:0.46:0.70:0.54:0.79"] = 655, -- Proie-de-l'Ombre, Les Pitons du Tonnerre, La Croisée, Poste de la Vénéneuse, Reflet-de-Lune, Reflet-de-Lune
				["0.32:0.42:0.41:0.53:0.56:0.47:0.55:0.27:0.61:0.20"] = 626, -- Shadowprey Village, Sun Rock Retreat, Crossroads, Freewind Post, Gadgetzan
				["0.32:0.42:0.45:0.44:0.56:0.47:0.46:0.70"] = 534, -- Shadowprey Village, Thunder Bluff, Crossroads, Bloodvenom Post
				["0.32:0.42:0.45:0.44:0.61:0.20:0.50:0.24"] = 572, -- Shadowprey Village, Thunder Bluff, Gadgetzan, Marshal's Refuge

				-- Horde: Splintertree Post (Ashenvale)
				["0.55:0.58:0.56:0.47:0.44:0.31:0.42:0.21"] = 541, -- Splintertree Post, Crossroads, Camp Mojache, Cenarion Hold
				["0.55:0.58:0.56:0.47:0.55:0.27:0.61:0.20:0.50:0.24"] = 538, -- Splintertree Post, Crossroads, Freewind Post, Gadgetzan, Marshal's Refuge
				["0.55:0.58:0.56:0.47:0.55:0.27"] = 345, -- Splintertree Post, Crossroads, Freewind Post
				["0.55:0.58:0.56:0.47:0.53:0.39:0.57:0.36:0.58:0.30"] = 354, -- Splintertree Post, Crossroads, Camp Taurajo, Brackenwall Village, Mudsprocket
				["0.55:0.58:0.56:0.47:0.55:0.27:0.61:0.20"] = 436, -- Splintertree Post, Crossroads, Freewind Post, Gadgetzan
				["0.55:0.58:0.56:0.47:0.53:0.39:0.57:0.36"] = 292, -- Splintertree Post, Crossroads, Camp Taurajo, Brackenwall Village
				["0.55:0.58:0.56:0.47:0.53:0.39"] = 234, -- Splintertree Post, Crossroads, Camp Taurajo
				["0.55:0.58:0.56:0.47:0.44:0.31"] = 412, -- Splintertree Post, Crossroads, Camp Mojache
				["0.55:0.58:0.56:0.47:0.45:0.44:0.32:0.42"] = 426, -- Splintertree Post, Crossroads, Thunder Bluff, Shadowprey Village
				["0.55:0.58:0.56:0.47:0.45:0.44"] = 267, -- Splintertree Post, Crossroads, Thunder Bluff
				["0.55:0.58:0.56:0.47"] = 160, -- Splintertree Post, Crossroads
				["0.55:0.58:0.63:0.56:0.61:0.45"] = 203, -- Splintertree Post, Orgrimmar, Ratchet
				["0.55:0.58:0.63:0.56"] = 96, -- Splintertree Post, Orgrimmar
				["0.55:0.58:0.63:0.64"] = 92, -- Splintertree Post, Valormok
				["0.55:0.58:0.50:0.65"] = 85, -- Splintertree Post, Emerald Sanctuary
				["0.55:0.58:0.41:0.63"] = 166, -- Splintertree Post, Zoram'gar Outpost
				["0.55:0.58:0.41:0.63:0.41:0.53"] = 287, -- Splintertree Post, Zoram'gar Outpost, Sun Rock Retreat
				["0.55:0.58:0.50:0.65:0.46:0.70"] = 163, -- Splintertree Post, Emerald Sanctuary, Bloodvenom Post
				["0.55:0.58:0.50:0.65:0.46:0.70:0.54:0.79"] = 287, -- Splintertree Post, Emerald Sanctuary, Bloodvenom Post, Moonglade
				["0.55:0.58:0.63:0.64:0.64:0.77"] = 221, -- Splintertree Post, Valormok, Everlook
				["0.55:0.58:0.56:0.47:0.61:0.45"] = 212, -- Splintertree Post, Crossroads, Ratchet
				["0.55:0.58:0.56:0.47:0.41:0.53"] = 310, -- Splintertree Post, Crossroads, Sun Rock Retreat
				["0.55:0.58:0.63:0.56:0.46:0.70"] = 348, -- Splintertree Post, Orgrimmar, Bloodvenom Post
				["0.55:0.58:0.41:0.63:0.46:0.70"] = 303, -- Splintertree Post, Zoram'gar Outpost, Bloodvenom Post
				["0.55:0.58:0.63:0.64:0.64:0.77:0.54:0.79"] = 354, -- Splintertree Post, Valormok, Everlook, Moonglade
				["0.55:0.58:0.63:0.56:0.64:0.77"] = 336, -- Splintertree Post, Orgrimmar, Everlook
				["0.55:0.58:0.41:0.63:0.41:0.53:0.32:0.42"] = 429, -- Splintertree Post, Zoram'gar Outpost, Sun Rock Retreat, Shadowprey Village
				["0.55:0.58:0.63:0.56:0.45:0.44:0.53:0.39"] = 408, -- Splintertree Post, Orgrimmar, Thunder Bluff, Camp Taurajo
				["0.55:0.58:0.63:0.56:0.45:0.44"] = 321, -- Splintertree Post, Orgrimmar, Thunder Bluff

				-- Horde: Sun Rock Retreat (Stonetalon Mountains)
				["0.41:0.53:0.56:0.47:0.55:0.27:0.61:0.20"] = 426, -- Sun Rock Retreat, Crossroads, Freewind Post, Gadgetzan
				["0.41:0.53:0.32:0.42:0.44:0.31:0.42:0.21"] = 469, -- Sun Rock Retreat, Shadowprey Village, Camp Mojache, Cenarion Hold
				["0.41:0.53:0.56:0.47:0.55:0.27:0.61:0.20:0.50:0.24"] = 527, -- Sun Rock Retreat, Crossroads, Freewind Post, Gadgetzan, Marshal's Refuge
				["0.41:0.53:0.56:0.47:0.55:0.27"] = 333, -- Sun Rock Retreat, Crossroads, Freewind Post
				["0.41:0.53:0.56:0.47:0.53:0.39:0.57:0.36:0.58:0.30"] = 342, -- Sun Rock Retreat, Crossroads, Camp Taurajo, Brackenwall Village, Mudsprocket
				["0.41:0.53:0.56:0.47:0.53:0.39:0.57:0.36"] = 281, -- Sun Rock Retreat, Crossroads, Camp Taurajo, Brackenwall Village
				["0.41:0.53:0.56:0.47:0.53:0.39"] = 223, -- Sun Rock Retreat, Crossroads, Camp Taurajo
				["0.41:0.53:0.32:0.42:0.44:0.31"] = 339, -- Sun Rock Retreat, Shadowprey Village, Camp Mojache
				["0.41:0.53:0.32:0.42"] = 143, -- Sun Rock Retreat, Shadowprey Village
				["0.41:0.53:0.45:0.44"] = 175, -- Sun Rock Retreat, Thunder Bluff
				["0.41:0.53:0.56:0.47"] = 150, -- Sun Rock Retreat, Crossroads
				["0.41:0.53:0.56:0.47:0.61:0.45"] = 201, -- Sun Rock Retreat, Crossroads, Ratchet (was 200, changed to 150 by William Black, changed back to 201 by Oliver Snith)
				["0.41:0.53:0.56:0.47:0.63:0.56"] = 266, -- Sun Rock Retreat, Crossroads, Orgrimmar
				["0.41:0.53:0.41:0.63:0.55:0.58"] = 294, -- Sun Rock Retreat, Zoram'gar Outpost, Splintertree Post
				["0.41:0.53:0.56:0.47:0.63:0.64"] = 313, -- Sun Rock Retreat, Crossroads, Valormok
				["0.41:0.53:0.56:0.47:0.63:0.64:0.64:0.77"] = 442, -- Sun Rock Retreat, Crossroads, Valormok, Everlook
				["0.41:0.53:0.41:0.63:0.50:0.65"] = 242, -- Sun Rock Retreat, Zoram'gar Outpost, Emerald Sanctuary
				["0.41:0.53:0.41:0.63:0.46:0.70"] = 257, -- Sun Rock Retreat, Zoram'gar Outpost, Bloodvenom Post
				["0.41:0.53:0.41:0.63:0.46:0.70:0.54:0.79"] = 382, -- Sun Rock Retreat, Zoram'gar Outpost, Bloodvenom Post, Moonglade
				["0.41:0.53:0.41:0.63"] = 121, -- Sun Rock Retreat, Zoram'gar Outpost
				["0.41:0.53:0.56:0.47:0.55:0.58"] = 312, -- Sun Rock Retreat, Crossroads, Splintertree Post
				["0.41:0.53:0.45:0.44:0.63:0.56:0.55:0.58"] = 471, -- Sun Rock Retreat, Thunder Bluff, Orgrimmar, Splintertree Post
				["0.41:0.53:0.45:0.44:0.63:0.56"] = 382, -- Sun Rock Retreat, Thunder Bluff, Orgrimmar
				["0.41:0.53:0.41:0.63:0.46:0.70:0.64:0.77"] = 405, -- Sun Rock Retreat, Zoram'gar Outpost, Bloodvenom Post, Everlook
				["0.41:0.53:0.56:0.47:0.63:0.56:0.64:0.77"] = 506, -- Sun Rock Retreat, Crossroads, Orgrimmar, Everlook
				["0.41:0.53:0.56:0.47:0.44:0.31"] = 401, -- Sun Rock Retreat, Crossroads, Camp Mojache

				-- Horde: Thunder Bluff (Mulgore)
				["0.45:0.44:0.44:0.31:0.42:0.21"] = 381, -- Thunder Bluff, Camp Mojache, Cenarion Hold
				["0.45:0.44:0.61:0.20:0.50:0.24"] = 395, -- Thunder Bluff, Gadgetzan, Marshal's Refuge
				["0.45:0.44:0.55:0.27"] = 204, -- Thunder Bluff, Freewind Post
				["0.45:0.44:0.61:0.20"] = 290, -- Thunder Bluff, Gadgetzan (Maja Jean Jakobsen reported 194)
				["0.45:0.44:0.53:0.39:0.57:0.36:0.58:0.30"] = 206, -- Thunder Bluff, Camp Taurajo, Brackenwall Village, Mudsprocket
				["0.45:0.44:0.57:0.36"] = 239, -- Thunder Bluff, Brackenwall Village
				["0.45:0.44:0.53:0.39"] = 87, -- Thunder Bluff, Camp Taurajo (Steven Martin suggested 97 but testing showed 87)
				["0.45:0.44:0.44:0.31"] = 252, -- Thunder Bluff, Camp Mojache
				["0.45:0.44:0.32:0.42"] = 159, -- Thunder Bluff, Shadowprey Village
				["0.45:0.44:0.41:0.53"] = 182, -- Thunder Bluff, Sun Rock Retreat
				["0.45:0.44:0.56:0.47"] = 103, -- Thunder Bluff, Crossroads
				["0.45:0.44:0.56:0.47:0.61:0.45"] = 154, -- Thunder Bluff, Crossroads, Ratchet
				["0.45:0.44:0.63:0.56"] = 207, -- Thunder Bluff, Orgrimmar (Kraal Nae-Dell reported 249)
				["0.45:0.44:0.56:0.47:0.55:0.58"] = 265, -- Thunder Bluff, Crossroads, Splintertree Post
				["0.45:0.44:0.63:0.64"] = 251, -- Thunder Bluff, Valormok
				["0.45:0.44:0.56:0.47:0.55:0.58:0.50:0.65"] = 343, -- Thunder Bluff, Crossroads, Splintertree Post, Emerald Sanctuary
				["0.45:0.44:0.56:0.47:0.46:0.70"] = 355, -- Thunder Bluff, Crossroads, Bloodvenom Post
				["0.45:0.44:0.41:0.63"] = 265, -- Thunder Bluff, Zoram'gar Outpost
				["0.45:0.44:0.63:0.64:0.64:0.77:0.54:0.79"] = 513, -- Thunder Bluff, Valormok, Everlook, Moonglade
				["0.45:0.44:0.63:0.64:0.64:0.77"] = 380, -- Thunder Bluff, Valormok, Everlook
				["0.45:0.44:0.61:0.20:0.50:0.24:0.42:0.21"] = 490, -- Thunder Bluff, Gadgetzan, Marshal's Refuge, Cenarion Hold
				["0.45:0.44:0.63:0.56:0.64:0.77"] = 448, -- Thunder Bluff, Orgrimmar, Everlook
				["0.45:0.44:0.56:0.47:0.46:0.70:0.54:0.79"] = 477, -- Thunder Bluff, Crossroads, Bloodvenom Post, Moonglade
				["0.45:0.44:0.63:0.56:0.61:0.45"] = 315, -- Thunder Bluff, Orgrimmar, Ratchet
				["0.45:0.44:0.55:0.27:0.58:0.30"] = 273, -- Thunder Bluff, Freewind Post, Mudsprocket
				["0.45:0.44:0.61:0.20:0.42:0.21"] = 523, -- Thunder Bluff, Gadgetzan, Cenarion Hold
				["0.45:0.44:0.63:0.56:0.55:0.58"] = 297, -- Thunder Bluff, Orgrimmar, Splintertree Post
				["0.45:0.44:0.41:0.63:0.50:0.65"] = 385, -- Les Pitons du Tonnerre, Avant-poste de Zoram'gar, Sanctuaire d'émeraude

				-- Horde: Valormok (Azshara)
				["0.63:0.64:0.56:0.47:0.55:0.27:0.61:0.20"] = 441, -- Valormok, Crossroads, Freewind Post, Gadgetzan
				["0.63:0.64:0.56:0.47:0.44:0.31:0.42:0.21"] = 545, -- Valormok, Crossroads, Camp Mojache, Cenarion Hold
				["0.63:0.64:0.56:0.47:0.55:0.27:0.61:0.20:0.50:0.24"] = 541, -- Valormok, Crossroads, Freewind Post, Gadgetzan, Marshal's Refuge
				["0.63:0.64:0.56:0.47:0.55:0.27"] = 348, -- Valormok, Crossroads, Freewind Post
				["0.63:0.64:0.56:0.47:0.53:0.39:0.57:0.36:0.58:0.30"] = 356, -- Valormok, Crossroads, Camp Taurajo, Brackenwall Village, Mudsprocket
				["0.63:0.64:0.56:0.47:0.53:0.39:0.57:0.36"] = 295, -- Valormok, Crossroads, Camp Taurajo, Brackenwall Village
				["0.63:0.64:0.56:0.47:0.53:0.39"] = 237, -- Valormok, Crossroads, Camp Taurajo
				["0.63:0.64:0.56:0.47:0.44:0.31"] = 415, -- Valormok, Crossroads, Camp Mojache
				["0.63:0.64:0.45:0.44:0.32:0.42"] = 409, -- Valormok, Thunder Bluff, Shadowprey Village
				["0.63:0.64:0.45:0.44"] = 250, -- Valormok, Thunder Bluff
				["0.63:0.64:0.56:0.47"] = 164, -- Valormok, Crossroads
				["0.63:0.64:0.63:0.56:0.61:0.45"] = 208, -- Valormok, Orgrimmar, Ratchet
				["0.63:0.64:0.63:0.56"] = 101, -- Valormok, Orgrimmar
				["0.63:0.64:0.55:0.58"] = 94, -- Valormok, Splintertree Post
				["0.63:0.64:0.56:0.47:0.41:0.53"] = 313, -- Valormok, Crossroads, Sun Rock Retreat
				["0.63:0.64:0.55:0.58:0.41:0.63"] = 253, -- Valormok, Splintertree Post, Zoram'gar Outpost
				["0.63:0.64:0.55:0.58:0.50:0.65"] = 172, -- Valormok, Splintertree Post, Emerald Sanctuary
				["0.63:0.64:0.46:0.70"] = 233, -- Valormok, Bloodvenom Post
				["0.63:0.64:0.64:0.77:0.54:0.79"] = 264, -- Valormok, Everlook, Moonglade
				["0.63:0.64:0.64:0.77"] = 131, -- Valormok, Everlook
				["0.63:0.64:0.46:0.70:0.54:0.79"] = 349, -- Valormok, Bloodvenom Post, Moonglade
				["0.63:0.64:0.63:0.56:0.61:0.45:0.61:0.20:0.50:0.24"] = 555, -- Valormok, Orgrimmar, Ratchet, Gadgetzan, Marshal's Refuge
				["0.63:0.64:0.56:0.47:0.55:0.27:0.58:0.30"] = 417, -- Valormok, Crossroads, Freewind Post, Mudsprocket

				-- Horde: Zoram'gar Outpost (Ashenvale)
				["0.41:0.63:0.56:0.47:0.55:0.27:0.61:0.20"] = 512, -- Zoram'gar Outpost, Crossroads, Freewind Post, Gadgetzan
				["0.41:0.63:0.41:0.53:0.32:0.42:0.44:0.31:0.42:0.21"] = 589, -- Zoram'gar Outpost, Sun Rock Retreat, Shadowprey Village, Camp Mojache, Cenarion Hold
				["0.41:0.63:0.56:0.47:0.55:0.27:0.61:0.20:0.50:0.24"] = 611, -- Zoram'gar Outpost, Crossroads, Freewind Post, Gadgetzan, Marshal's Refuge
				["0.41:0.63:0.56:0.47:0.55:0.27"] = 419, -- Zoram'gar Outpost, Crossroads, Freewind Post
				["0.41:0.63:0.56:0.47:0.53:0.39:0.57:0.36:0.58:0.30"] = 428, -- Zoram'gar Outpost, Crossroads, Camp Taurajo, Brackenwall Village, Mudsprocket
				["0.41:0.63:0.56:0.47:0.53:0.39:0.57:0.36"] = 366, -- Zoram'gar Outpost, Crossroads, Camp Taurajo, Brackenwall Village
				["0.41:0.63:0.56:0.47:0.53:0.39"] = 309, -- Zoram'gar Outpost, Crossroads, Camp Taurajo
				["0.41:0.63:0.41:0.53:0.32:0.42:0.44:0.31"] = 459, -- Zoram'gar Outpost, Sun Rock Retreat, Shadowprey Village, Camp Mojache
				["0.41:0.63:0.41:0.53:0.32:0.42"] = 264, -- Zoram'gar Outpost, Sun Rock Retreat, Shadowprey Village
				["0.41:0.63:0.45:0.44"] = 247, -- Zoram'gar Outpost, Thunder Bluff
				["0.41:0.63:0.56:0.47"] = 235, -- Zoram'gar Outpost, Crossroads
				["0.41:0.63:0.56:0.47:0.61:0.45"] = 287, -- Zoram'gar Outpost, Crossroads, Ratchet
				["0.41:0.63:0.55:0.58:0.63:0.56"] = 262, -- Zoram'gar Outpost, Splintertree Post, Orgrimmar
				["0.41:0.63:0.55:0.58"] = 173, -- Zoram'gar Outpost, Splintertree Post
				["0.41:0.63:0.41:0.53"] = 121, -- Zoram'gar Outpost, Sun Rock Retreat
				["0.41:0.63:0.50:0.65"] = 122, -- Zoram'gar Outpost, Emerald Sanctuary
				["0.41:0.63:0.46:0.70"] = 138, -- Zoram'gar Outpost, Bloodvenom Post
				["0.41:0.63:0.55:0.58:0.63:0.64"] = 258, -- Zoram'gar Outpost, Splintertree Post, Valormok
				["0.41:0.63:0.46:0.70:0.64:0.77"] = 285, -- Zoram'gar Outpost, Bloodvenom Post, Everlook
				["0.41:0.63:0.46:0.70:0.54:0.79"] = 263, -- Zoram'gar Outpost, Bloodvenom Post, Moonglade
				["0.41:0.63:0.56:0.47:0.63:0.56"] = 352, -- Zoram'gar Outpost, Crossroads, Orgrimmar
				["0.41:0.63:0.45:0.44:0.32:0.42"] = 407, -- Zoram'gar Outpost, Thunder Bluff, Shadowprey Village
				["0.41:0.63:0.45:0.44:0.63:0.56"] = 455, -- Zoram'gar Outpost, Thunder Bluff, Orgrimmar
				["0.41:0.63:0.56:0.47:0.44:0.31"] = 487, -- Zoram'gar Outpost, Crossroads, Camp Mojache

			},

			-- Horde: Outland
			[3] = {

				-- Horde: Altar of Sha'tar (Shadowmoon Valley)
				["0.81:0.23:0.66:0.23"] = 67, -- Altar of Sha'tar, Shadowmoon Village
				["0.81:0.23:0.51:0.27:0.44:0.33"] = 193, -- Altar of Sha'tar, Stonebreaker Hold, Shattrath
				["0.81:0.23:0.51:0.27"] = 140, -- Altar of Sha'tar, Stonebreaker Hold
				["0.81:0.23:0.51:0.27:0.65:0.50:0.66:0.50"] = 263, -- Altar of Sha'tar, Stonebreaker Hold, Thrallmar
				["0.81:0.23:0.51:0.27:0.44:0.33:0.23:0.50"] = 329, -- Altar of Sha'tar, Stonebreaker Hold, Shattrath, Zabra'jin
				["0.81:0.23:0.51:0.27:0.44:0.33:0.29:0.38"] = 274, -- Altar of Sha'tar, Stonebreaker Hold, Shattrath, Garadar
				["0.81:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73"] = 398, -- Altar of Sha'tar, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52
				["0.81:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.72:0.72"] = 463, -- Altar of Sha'tar, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, Cosmowrench
				["0.81:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.63:0.82"] = 446, -- Altar of Sha'tar, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, The Stormspire
				["0.81:0.23:0.51:0.27:0.44:0.33:0.44:0.49"] = 272, -- Altar of Sha'tar, Stonebreaker Hold, Shattrath, Swamprat Post
				["0.81:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68"] = 378, -- Altar of Sha'tar, Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold
				["0.81:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.42:0.72"] = 403, -- Altar of Sha'tar, Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold, Evergrove
				["0.81:0.23:0.51:0.27:0.65:0.50:0.68:0.37"] = 328, -- Altar of Sha'tar, Stonebreaker Hold, Thrallmar, Spinebreaker Ridge
				["0.81:0.23:0.51:0.27:0.65:0.50:0.79:0.46"] = 333, -- Altar of Sha'tar, Stonebreaker Hold, Thrallmar, Hellfire Peninsula
				["0.81:0.23:0.51:0.27:0.44:0.33:0.54:0.43"] = 269, -- Altar of Sha'tar, Stonebreaker Hold, Shattrath, Falcon Watch
				["0.81:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64"] = 342, -- Altar of Sha'tar, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village
				["0.81:0.23:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68"] = 378, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold
				["0.81:0.23:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73"] = 398, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52
				["0.81:0.23:0.66:0.23:0.51:0.27"] = 140, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold
				["0.81:0.23:0.66:0.23:0.51:0.27:0.44:0.33"] = 194, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Shattrath
				["0.81:0.23:0.66:0.23:0.51:0.27:0.44:0.33:0.29:0.38"] = 274, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Shattrath, Garadar
				["0.81:0.23:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.63:0.82"] = 445, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, The Stormspire
				["0.81:0.23:0.66:0.23:0.51:0.27:0.65:0.50:0.66:0.50"] = 263, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Thrallmar
				["0.81:0.23:0.66:0.23:0.51:0.27:0.65:0.50:0.79:0.46"] = 333, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Thrallmar, Hellfire Peninsula
				["0.81:0.23:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49"] = 272, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post
				["0.81:0.23:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.42:0.72"] = 403, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold, Evergrove
				["0.81:0.23:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.58:0.73"] = 474, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold, Area 52
				["0.81:0.23:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64"] = 342, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village
				["0.81:0.23:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.72:0.72"] = 463, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, Cosmowrench
				["0.81:0.23:0.66:0.23:0.51:0.27:0.44:0.33:0.23:0.50"] = 329, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Shattrath, Zabra'jin
				["0.81:0.23:0.66:0.23:0.51:0.27:0.44:0.33:0.54:0.43"] = 269, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Shattrath, Falcon Watch
				["0.81:0.23:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.58:0.73:0.63:0.82"] = 521, -- Altar der Sha'tar, Schattenmond, Steinbrecherfeste, Shattrath, Sumpfrattenposten, Donnerfeste, Area 52, Die Sturmsäule
				["0.81:0.23:0.66:0.23:0.51:0.27:0.65:0.50:0.68:0.37"] = 328, -- Altar of Sha'tar, Shadowmoon Village, Stonebreaker Hold, Thrallmar, Spinebreaker Ridge

				-- Horde: Area 52 (Netherstorm)
				["0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23"] = 357, -- Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village
				["0.58:0.73:0.49:0.64:0.44:0.49:0.54:0.43:0.65:0.50:0.68:0.37"] = 342, -- Area 52, Mok'Nathal Village, Swamprat Post, Falcon Watch, Thrallmar, Spinebreaker Ridge
				["0.58:0.73:0.49:0.64:0.44:0.49:0.54:0.43:0.65:0.50:0.79:0.46"] = 343, -- Area 52, Mok'Nathal Village, Swamprat Post, Falcon Watch, Thrallmar, Hellfire Peninsula
				["0.58:0.73:0.49:0.64:0.44:0.49:0.54:0.43:0.65:0.50:0.66:0.50"] = 273, -- Area 52, Mok'Nathal Village, Swamprat Post, Falcon Watch, Thrallmar
				["0.58:0.73:0.49:0.64:0.44:0.49:0.54:0.43"] = 204, -- Area 52, Mok'Nathal Village, Swamprat Post, Falcon Watch
				["0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27"] = 292, -- Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold
				["0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33"] = 224, -- Area 52, Mok'Nathal Village, Swamprat Post, Shattrath
				["0.58:0.73:0.49:0.64:0.44:0.49"] = 137, -- Area 52, Mok'Nathal Village, Swamprat Post
				["0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.29:0.38"] = 306, -- Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Garadar
				["0.58:0.73:0.49:0.64:0.44:0.49:0.23:0.50"] = 248, -- Area 52, Mok'Nathal Village, Swamprat Post, Zabra'jin
				["0.58:0.73:0.38:0.68"] = 108, -- Area 52, Thunderlord Stronghold
				["0.58:0.73:0.49:0.64"] = 64, -- Area 52, Mok'Nathal Village
				["0.58:0.73:0.42:0.72"] = 82, -- Area 52, Evergrove (was 80, Michael Kartoz reported 86 so changed to 82)
				["0.58:0.73:0.63:0.82"] = 47, -- Area 52, The Stormspire
				["0.58:0.73:0.72:0.72"] = 66, -- Area 52, Cosmowrench
				["0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.81:0.23"] = 437, -- Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.58:0.73:0.38:0.68:0.44:0.49:0.54:0.43"] = 287, -- Area 52, Thunderlord Stronghold, Swamprat Post, Falcon Watch
				["0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.78:0.15"] = 420, -- Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.58:0.73:0.38:0.68:0.44:0.49:0.44:0.33"] = 311, -- Area 52, Thunderlord Stronghold, Swamprat Post, Shattrath
				["0.58:0.73:0.38:0.68:0.44:0.49:0.54:0.43:0.65:0.50:0.66:0.50"] = 359, -- Area 52, Thunderlord Stronghold, Swamprat Post, Falcon Watch, Thrallmar
				["0.58:0.73:0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23"] = 443, -- Area 52, Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village
				["0.58:0.73:0.38:0.68:0.44:0.49"] = 224, -- Area 52, Thunderlord Stronghold, Swamprat Post
				["0.58:0.73:0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27"] = 379, -- Area 52, Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold
				["0.58:0.73:0.38:0.68:0.23:0.50"] = 257, -- Area 52, Thunderlord Stronghold, Zabra'jin
				["0.58:0.73:0.38:0.68:0.23:0.50:0.29:0.38"] = 335, -- Area 52, Thunderlord Stronghold, Zabra'jin, Garadar
				["0.58:0.73:0.38:0.68:0.44:0.49:0.54:0.43:0.65:0.50:0.79:0.46"] = 430, -- Area 52, Thunderlord Stronghold, Swamprat Post, Falcon Watch, Thrallmar, Hellfire Peninsula
				["0.58:0.73:0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.78:0.15"] = 507, -- Area 52, Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.58:0.73:0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.81:0.23"] = 524, -- Area 52, Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.58:0.73:0.38:0.68:0.44:0.49:0.54:0.43:0.65:0.50:0.68:0.37"] = 424, -- Area 52, Thunderlord Stronghold, Swamprat Post, Falcon Watch, Thrallmar, Spinebreaker Ridge
				["0.58:0.73:0.38:0.68:0.23:0.50:0.44:0.33"] = 405, -- Area 52, Thunderlord Stronghold, Zabra'jin, Shattrath
				["0.58:0.73:0.38:0.68:0.23:0.50:0.44:0.33:0.51:0.27"] = 474, -- Area 52, Thunderlord Stronghold, Zabra'jin, Shattrath, Stonebreaker Hold

				-- Horde: Cosmowrench (Netherstorm)
				["0.72:0.72:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23"] = 420, -- Cosmowrench, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village
				["0.72:0.72:0.58:0.73:0.49:0.64:0.44:0.49:0.54:0.43:0.65:0.50:0.68:0.37"] = 401, -- Cosmowrench, Area 52, Mok'Nathal Village, Swamprat Post, Falcon Watch, Thrallmar, Spinebreaker Ridge
				["0.72:0.72:0.58:0.73:0.49:0.64:0.44:0.49:0.54:0.43:0.65:0.50:0.79:0.46"] = 406, -- Cosmowrench, Area 52, Mok'Nathal Village, Swamprat Post, Falcon Watch, Thrallmar, Hellfire Peninsula
				["0.72:0.72:0.58:0.73:0.49:0.64:0.44:0.49:0.54:0.43:0.65:0.50:0.66:0.50"] = 336, -- Cosmowrench, Area 52, Mok'Nathal Village, Swamprat Post, Falcon Watch, Thrallmar
				["0.72:0.72:0.58:0.73:0.49:0.64:0.44:0.49:0.54:0.43"] = 264, -- Cosmowrench, Area 52, Mok'Nathal Village, Swamprat Post, Falcon Watch
				["0.72:0.72:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27"] = 355, -- Cosmowrench, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold
				["0.72:0.72:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33"] = 287, -- Cosmowrench, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath
				["0.72:0.72:0.58:0.73:0.49:0.64:0.44:0.49"] = 204, -- Cosmowrench, Area 52, Mok'Nathal Village, Swamprat Post
				["0.72:0.72:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.29:0.38"] = 371, -- Cosmowrench, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Garadar
				["0.72:0.72:0.58:0.73:0.49:0.64:0.44:0.49:0.23:0.50"] = 312, -- Cosmowrench, Area 52, Mok'Nathal Village, Swamprat Post, Zabra'jin
				["0.72:0.72:0.58:0.73:0.38:0.68"] = 173, -- Cosmowrench, Area 52, Thunderlord Stronghold
				["0.72:0.72:0.58:0.73:0.49:0.64"] = 129, -- Cosmowrench, Area 52, Mok'Nathal Village
				["0.72:0.72:0.58:0.73:0.42:0.72"] = 146, -- Cosmowrench, Area 52, Evergrove
				["0.72:0.72:0.58:0.73"] = 64, -- Cosmowrench, Area 52
				["0.72:0.72:0.63:0.82"] = 61, -- Cosmowrench, The Stormspire
				["0.72:0.72:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.78:0.15"] = 484, -- Cosmowrench, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.72:0.72:0.58:0.73:0.38:0.68:0.44:0.49:0.44:0.33"] = 374, -- Cosmowrench, Area 52, Thunderlord Stronghold, Swamprat Post, Shattrath
				["0.72:0.72:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.81:0.23"] = 501, -- Cosmowrench, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.72:0.72:0.58:0.73:0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27"] = 442, -- Cosmowrench, Area 52, Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold
				["0.72:0.72:0.58:0.73:0.38:0.68:0.44:0.49"] = 288, -- Cosmowrench, Area 52, Thunderlord Stronghold, Swamprat Post
				["0.72:0.72:0.63:0.82:0.38:0.68:0.44:0.49:0.54:0.43:0.65:0.50:0.66:0.50"] = 457, -- Cosmowrench, The Stormspire, Thunderlord Stronghold, Swamprat Post, Falcon Watch, Thrallmar
				["0.72:0.72:0.58:0.73:0.38:0.68:0.23:0.50"] = 320, -- Cosmowrench, Area 52, Thunderlord Stronghold, Zabra'jin
				["0.72:0.72:0.58:0.73:0.38:0.68:0.44:0.49:0.44:0.33:0.29:0.38"] = 456, -- Cosmowrench, Area 52, Thunderlord Stronghold, Swamprat Post, Shattrath, Garadar
				["0.72:0.72:0.63:0.82:0.38:0.68:0.44:0.49:0.44:0.33"] = 409, -- Cosmowrench, The Stormspire, Thunderlord Stronghold, Swamprat Post, Shattrath
				["0.72:0.72:0.58:0.73:0.38:0.68:0.23:0.50:0.29:0.38"] = 398, -- Cosmowrench, Area 52, Thunderlord Stronghold, Zabra'jin, Garadar
				["0.72:0.72:0.58:0.73:0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.78:0.15"] = 571, -- Cosmowrench, Area 52, Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.72:0.72:0.63:0.82:0.38:0.68:0.44:0.49"] = 322, -- Cosmowrench, The Stormspire, Thunderlord Stronghold, Swamprat Post
				["0.72:0.72:0.58:0.73:0.38:0.68:0.44:0.49:0.54:0.43:0.65:0.50:0.66:0.50"] = 423, -- Kosmozang, Area 52, Donnerfeste, Sumpfrattenposten, Falkenwacht, Thrallmar
				["0.72:0.72:0.58:0.73:0.38:0.68:0.44:0.49:0.54:0.43"] = 351, -- Cosmowrench, Area 52, Thunderlord Stronghold, Swamprat Post, Falcon Watch
				["0.72:0.72:0.58:0.73:0.38:0.68:0.23:0.50:0.54:0.43"] = 464, -- Космоворот, Зона 52, Оплот Громоборцев, Забра'джин, Соколиный дозор

				-- Horde: Evergrove (Blade's Edge Mountains)
				["0.42:0.72:0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23"] = 371, -- Evergrove, Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village
				["0.42:0.72:0.38:0.68:0.44:0.49:0.54:0.43:0.65:0.50:0.68:0.37"] = 353, -- Evergrove, Thunderlord Stronghold, Swamprat Post, Falcon Watch, Thrallmar, Spinebreaker Ridge
				["0.42:0.72:0.38:0.68:0.44:0.49:0.54:0.43:0.65:0.50:0.79:0.46"] = 358, -- Evergrove, Thunderlord Stronghold, Swamprat Post, Falcon Watch, Thrallmar, Hellfire Peninsula
				["0.42:0.72:0.38:0.68:0.44:0.49:0.54:0.43:0.65:0.50:0.66:0.50"] = 287, -- Evergrove, Thunderlord Stronghold, Swamprat Post, Falcon Watch, Thrallmar
				["0.42:0.72:0.38:0.68:0.44:0.49:0.54:0.43"] = 215, -- Evergrove, Thunderlord Stronghold, Swamprat Post, Falcon Watch
				["0.42:0.72:0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27"] = 306, -- Evergrove, Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold
				["0.42:0.72:0.38:0.68:0.44:0.49:0.44:0.33"] = 238, -- Evergrove, Thunderlord Stronghold, Swamprat Post, Shattrath
				["0.42:0.72:0.38:0.68:0.44:0.49"] = 152, -- Evergrove, Thunderlord Stronghold, Swamprat Post
				["0.42:0.72:0.38:0.68:0.23:0.50:0.29:0.38"] = 262, -- Evergrove, Thunderlord Stronghold, Zabra'jin, Garadar
				["0.42:0.72:0.38:0.68:0.23:0.50"] = 184, -- Evergrove, Thunderlord Stronghold, Zabra'jin
				["0.42:0.72:0.38:0.68"] = 36, -- Evergrove, Thunderlord Stronghold
				["0.42:0.72:0.38:0.68:0.49:0.64"] = 91, -- Evergrove, Thunderlord Stronghold, Mok'Nathal Village
				["0.42:0.72:0.58:0.73"] = 78, -- Evergrove, Area 52
				["0.42:0.72:0.58:0.73:0.72:0.72"] = 143, -- Evergrove, Area 52, Cosmowrench
				["0.42:0.72:0.58:0.73:0.63:0.82"] = 125, -- Evergrove, Area 52, The Stormspire
				["0.42:0.72:0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.78:0.15"] = 435, -- Evergrove, Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.42:0.72:0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.81:0.23"] = 452, -- Evergrove, Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.42:0.72:0.38:0.68:0.44:0.49:0.44:0.33:0.29:0.38"] = 319, -- Evergrove, Thunderlord Stronghold, Swamprat Post, Shattrath, Garadar
				["0.42:0.72:0.38:0.68:0.63:0.82"] = 192, -- Evergrove, Thunderlord Stronghold, The Stormspire
				["0.42:0.72:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33"] = 301, -- Evergrove, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath
				["0.42:0.72:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.29:0.38"] = 381, -- Evergrove, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Garadar
				["0.42:0.72:0.38:0.68:0.23:0.50:0.44:0.33"] = 333, -- Evergrove, Thunderlord Stronghold, Zabra'jin, Shattrath
				["0.42:0.72:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27"] = 369, -- Evergrove, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold

				-- Horde: Falcon Watch (Hellfire Peninsula)
				["0.54:0.43:0.44:0.33:0.51:0.27:0.66:0.23"] = 204, -- Falcon Watch, Shattrath, Stonebreaker Hold, Shadowmoon Village
				["0.54:0.43:0.65:0.50:0.68:0.37"] = 138, -- Falcon Watch, Thrallmar, Spinebreaker Ridge (suggestion of 74 by Jeremiah Wilson)
				["0.54:0.43:0.65:0.50:0.79:0.46"] = 143, -- Falcon Watch, Thrallmar, Hellfire Peninsula
				["0.54:0.43:0.65:0.50:0.66:0.50"] = 73, -- Falcon Watch, Thrallmar (not sure 3.3.5, why does it takes + 1 hop data for no hops?)
				["0.54:0.43:0.44:0.33:0.51:0.27"] = 139, -- Falcon Watch, Shattrath, Stonebreaker Hold
				["0.54:0.43:0.44:0.33"] = 71, -- Falcon Watch, Shattrath
				["0.54:0.43:0.44:0.49"] = 69, -- Falcon Watch, Swamprat Post (Infarkt reported 90)
				["0.54:0.43:0.29:0.38"] = 132, -- Falcon Watch, Garadar
				["0.54:0.43:0.23:0.50"] = 150, -- Falcon Watch, Zabra'jin
				["0.54:0.43:0.44:0.49:0.38:0.68"] = 174, -- Falcon Watch, Swamprat Post, Thunderlord Stronghold
				["0.54:0.43:0.44:0.49:0.38:0.68:0.42:0.72"] = 201, -- Falcon Watch, Swamprat Post, Thunderlord Stronghold, Evergrove
				["0.54:0.43:0.44:0.49:0.49:0.64"] = 139, -- Falcon Watch, Swamprat Post, Mok'Nathal Village
				["0.54:0.43:0.44:0.49:0.49:0.64:0.58:0.73"] = 199, -- Falcon Watch, Swamprat Post, Mok'Nathal Village, Area 52
				["0.54:0.43:0.44:0.49:0.49:0.64:0.58:0.73:0.72:0.72"] = 260, -- Falcon Watch, Swamprat Post, Mok'Nathal Village, Area 52, Cosmowrench
				["0.54:0.43:0.44:0.49:0.49:0.64:0.58:0.73:0.63:0.82"] = 242, -- Falcon Watch, Swamprat Post, Mok'Nathal Village, Area 52, The Stormspire
				["0.54:0.43:0.44:0.33:0.51:0.27:0.66:0.23:0.81:0.23"] = 286, -- Falcon Watch, Shattrath, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.54:0.43:0.44:0.33:0.51:0.27:0.66:0.23:0.78:0.15"] = 269, -- Falcon Watch, Shattrath, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.54:0.43:0.44:0.49:0.38:0.68:0.58:0.73"] = 271, -- Falcon Watch, Swamprat Post, Thunderlord Stronghold, Area 52
				["0.54:0.43:0.44:0.49:0.38:0.68:0.58:0.73:0.63:0.82"] = 319, -- Falcon Watch, Swamprat Post, Thunderlord Stronghold, Area 52, The Stormspire
				["0.54:0.43:0.23:0.50:0.38:0.68"] = 261, -- Falcon Watch, Zabra'jin, Thunderlord Stronghold
				["0.54:0.43:0.65:0.50:0.51:0.27"] = 201, -- Falcon Watch, Thrallmar, Stonebreaker Hold

				-- Horde: Garadar (Nagrand)
				["0.29:0.38:0.44:0.33:0.51:0.27:0.66:0.23"] = 210, -- Garadar, Shattrath, Stonebreaker Hold, Shadowmoon Village
				["0.29:0.38:0.44:0.33:0.51:0.27"] = 145, -- Garadar, Shattrath, Stonebreaker Hold
				["0.29:0.38:0.44:0.33"] = 77, -- Garadar, Shattrath
				["0.29:0.38:0.54:0.43:0.65:0.50:0.68:0.37"] = 266, -- Garadar, Falcon Watch, Thrallmar, Spinebreaker Ridge
				["0.29:0.38:0.54:0.43:0.65:0.50:0.79:0.46"] = 270, -- Garadar, Falcon Watch, Thrallmar, Hellfire Peninsula
				["0.29:0.38:0.54:0.43:0.65:0.50:0.66:0.50"] = 199, -- Garadar, Falcon Watch, Thrallmar (Manuel Frank Griesel reported 41)
				["0.29:0.38:0.54:0.43"] = 126, -- Garadar, Falcon Watch
				["0.29:0.38:0.44:0.33:0.44:0.49"] = 156, -- Garadar, Shattrath, Swamprat Post
				["0.29:0.38:0.23:0.50"] = 67, -- Garadar, Zabra'jin
				["0.29:0.38:0.23:0.50:0.38:0.68"] = 177, -- Garadar, Zabra'jin, Thunderlord Stronghold
				["0.29:0.38:0.23:0.50:0.38:0.68:0.42:0.72"] = 203, -- Garadar, Zabra'jin, Thunderlord Stronghold, Evergrove
				["0.29:0.38:0.44:0.33:0.44:0.49:0.49:0.64"] = 227, -- Garadar, Shattrath, Swamprat Post, Mok'Nathal Village
				["0.29:0.38:0.23:0.50:0.38:0.68:0.58:0.73"] = 274, -- Garadar, Zabra'jin, Thunderlord Stronghold, Area 52
				["0.29:0.38:0.23:0.50:0.38:0.68:0.58:0.73:0.72:0.72"] = 339, -- Garadar, Zabra'jin, Thunderlord Stronghold, Area 52, Cosmowrench
				["0.29:0.38:0.23:0.50:0.38:0.68:0.58:0.73:0.63:0.82"] = 322, -- Garadar, Zabra'jin, Thunderlord Stronghold, Area 52, The Stormspire
				["0.29:0.38:0.44:0.33:0.51:0.27:0.66:0.23:0.81:0.23"] = 291, -- Garadar, Shattrath, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.29:0.38:0.44:0.33:0.51:0.27:0.66:0.23:0.78:0.15"] = 274, -- Garadar, Shattrath, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.29:0.38:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73"] = 282, -- Garadar, Shattrath, Sumpfrattenposten, Dorf der Mok'Nathal, Area 52
				["0.29:0.38:0.23:0.50:0.44:0.49"] = 175, -- Garadar, Zabra'jin, Swamprat Post
				["0.29:0.38:0.44:0.33:0.44:0.49:0.38:0.68:0.58:0.73"] = 359, -- Garadar, Shattrath, Swamprat Post, Thunderlord Stronghold, Area 52
				["0.29:0.38:0.44:0.33:0.44:0.49:0.38:0.68:0.42:0.72"] = 287, -- Garadar, Shattrath, Swamprat Post, Thunderlord Stronghold, Evergrove
				["0.29:0.38:0.44:0.33:0.44:0.49:0.38:0.68"] = 262, -- Garadar, Shattrath, Swamprat Post, Thunderlord Stronghold
				["0.29:0.38:0.44:0.33:0.65:0.50:0.66:0.50"] = 205, -- Garadar, Shattrath, Thrallmar
				["0.29:0.38:0.23:0.50:0.38:0.68:0.49:0.64"] = 233, -- Garadar, Zabra'jin, Thunderlord Stronghold, Mok'Nathal Village
				["0.29:0.38:0.23:0.50:0.38:0.68:0.63:0.82"] = 333, -- Garadar, Zabra'jin, Thunderlord Stronghold, The Stormspire
				["0.29:0.38:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.63:0.82"] = 330, -- Garadar, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, The Stormspire
				["0.29:0.38:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.42:0.72"] = 362, -- Garadar, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, Evergrove

				-- Horde: Hellfire Peninsula (Hellfire Peninsula) (Dark Portal)
				["0.79:0.46:0.65:0.50:0.51:0.27:0.66:0.23"] = 252, -- Hellfire Peninsula, Thrallmar, Stonebreaker Hold, Shadowmoon Village
				["0.79:0.46:0.65:0.50:0.68:0.37"] = 125, -- Hellfire Peninsula, Thrallmar, Spinebreaker Ridge
				["0.79:0.46:0.65:0.50:0.66:0.50"] = 59, -- Hellfire Peninsula, Thrallmar (Edward Barroso reported 81)
				["0.79:0.46:0.54:0.43"] = 122, -- Hellfire Peninsula, Falcon Watch
				["0.79:0.46:0.65:0.50:0.51:0.27"] = 188, -- Hellfire Peninsula, Thrallmar, Stonebreaker Hold
				["0.79:0.46:0.54:0.43:0.44:0.33"] = 193, -- Hellfire Peninsula, Falcon Watch, Shattrath
				["0.79:0.46:0.54:0.43:0.44:0.49"] = 190, -- Hellfire Peninsula, Falcon Watch, Swamprat Post
				["0.79:0.46:0.54:0.43:0.29:0.38"] = 253, -- Hellfire Peninsula, Falcon Watch, Garadar (Ben Collis reported 123)
				["0.79:0.46:0.54:0.43:0.23:0.50"] = 271, -- Hellfire Peninsula, Falcon Watch, Zabra'jin
				["0.79:0.46:0.54:0.43:0.44:0.49:0.38:0.68"] = 295, -- Hellfire Peninsula, Falcon Watch, Swamprat Post, Thunderlord Stronghold
				["0.79:0.46:0.54:0.43:0.44:0.49:0.38:0.68:0.42:0.72"] = 321, -- Hellfire Peninsula, Falcon Watch, Swamprat Post, Thunderlord Stronghold, Evergrove
				["0.79:0.46:0.54:0.43:0.44:0.49:0.49:0.64"] = 261, -- Hellfire Peninsula, Falcon Watch, Swamprat Post, Mok'Nathal Village
				["0.79:0.46:0.54:0.43:0.44:0.49:0.49:0.64:0.58:0.73"] = 316, -- Hellfire Peninsula, Falcon Watch, Swamprat Post, Mok'Nathal Village, Area 52
				["0.79:0.46:0.54:0.43:0.44:0.49:0.49:0.64:0.58:0.73:0.72:0.72"] = 381, -- Hellfire Peninsula, Falcon Watch, Swamprat Post, Mok'Nathal Village, Area 52, Cosmowrench
				["0.79:0.46:0.54:0.43:0.44:0.49:0.49:0.64:0.58:0.73:0.63:0.82"] = 364, -- Hellfire Peninsula, Falcon Watch, Swamprat Post, Mok'Nathal Village, Area 52, The Stormspire
				["0.79:0.46:0.65:0.50:0.51:0.27:0.66:0.23:0.78:0.15"] = 316, -- Hellfire Peninsula, Thrallmar, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.79:0.46:0.65:0.50:0.51:0.27:0.66:0.23:0.81:0.23"] = 333, -- Hellfire Peninsula, Thrallmar, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.79:0.46:0.65:0.50:0.51:0.27:0.44:0.33"] = 241, -- Hellfire Peninsula, Thrallmar, Stonebreaker Hold, Shattrath
				["0.79:0.46:0.65:0.50:0.44:0.33"] = 182, -- Hellfire Peninsula, Thrallmar, Shattrath (Matthias Rössing reported 203)
				["0.79:0.46:0.54:0.43:0.44:0.49:0.38:0.68:0.58:0.73"] = 392, -- Hellfire Peninsula, Falcon Watch, Swamprat Post, Thunderlord Stronghold, Area 52
				["0.79:0.46:0.65:0.50:0.44:0.33:0.23:0.50"] = 316, -- Hellfire Peninsula, Thrallmar, Shattrath, Zabra'jin
				["0.79:0.46:0.65:0.50:0.44:0.33:0.29:0.38"] = 262, -- Hellfire Peninsula, Thrallmar, Shattrath, Garadar
				["0.79:0.46:0.65:0.50:0.44:0.33:0.44:0.49:0.38:0.68:0.42:0.72"] = 390, -- Hellfire Peninsula, Thrallmar, Shattrath, Swamprat Post, Thunderlord Stronghold, Evergrove
				["0.79:0.46:0.54:0.43:0.44:0.49:0.38:0.68:0.58:0.73:0.72:0.72"] = 458, -- Полуостров Адского Пламени, Соколиный дозор, Застава Болотной Крысы, Оплот Громоборцев, Зона 52, Космоворот
				["0.79:0.46:0.54:0.43:0.44:0.49:0.38:0.68:0.63:0.82"] = 451, -- Hellfire Peninsula, Falcon Watch, Swamprat Post, Thunderlord Stronghold, The Stormspire
				["0.79:0.46:0.65:0.50:0.44:0.33:0.44:0.49"] = 259, -- Hellfire Peninsula, Thrallmar, Shattrath, Swamprat Post

				-- Horde: Mok'Nathal Village (Blade's Edge Mountains)
				["0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23"] = 292, -- Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village
				["0.49:0.64:0.44:0.49:0.54:0.43:0.65:0.50:0.68:0.37"] = 274, -- Mok'Nathal Village, Swamprat Post, Falcon Watch, Thrallmar, Spinebreaker Ridge
				["0.49:0.64:0.44:0.49:0.54:0.43:0.65:0.50:0.79:0.46"] = 279, -- Mok'Nathal Village, Swamprat Post, Falcon Watch, Thrallmar, Hellfire Peninsula
				["0.49:0.64:0.44:0.49:0.54:0.43:0.65:0.50:0.66:0.50"] = 208, -- Mok'Nathal Village, Swamprat Post, Falcon Watch, Thrallmar
				["0.49:0.64:0.44:0.49:0.54:0.43"] = 136, -- Mok'Nathal Village, Swamprat Post, Falcon Watch
				["0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27"] = 228, -- Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold
				["0.49:0.64:0.44:0.49:0.44:0.33"] = 160, -- Mok'Nathal Village, Swamprat Post, Shattrath
				["0.49:0.64:0.44:0.49"] = 74, -- Mok'Nathal Village, Swamprat Post
				["0.49:0.64:0.44:0.49:0.44:0.33:0.29:0.38"] = 243, -- Mok'Nathal Village, Swamprat Post, Shattrath, Garadar
				["0.49:0.64:0.44:0.49:0.23:0.50"] = 185, -- Mok'Nathal Village, Swamprat Post, Zabra'jin
				["0.49:0.64:0.38:0.68"] = 63, -- Mok'Nathal Village, Thunderlord Stronghold
				["0.49:0.64:0.38:0.68:0.42:0.72"] = 88, -- Mok'Nathal Village, Thunderlord Stronghold, Evergrove (Fabio Finger reported 64)
				["0.49:0.64:0.58:0.73"] = 57, -- Mok'Nathal Village, Area 52
				["0.49:0.64:0.58:0.73:0.72:0.72"] = 122, -- Mok'Nathal Village, Area 52, Cosmowrench
				["0.49:0.64:0.58:0.73:0.63:0.82"] = 104, -- Mok'Nathal Village, Area 52, The Stormspire
				["0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.81:0.23"] = 374, -- Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.78:0.15"] = 357, -- Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.49:0.64:0.38:0.68:0.23:0.50:0.44:0.33"] = 359, -- Mok'Nathal Village, Thunderlord Stronghold, Zabra'jin, Shattrath
				["0.49:0.64:0.38:0.68:0.23:0.50:0.44:0.33:0.51:0.27:0.66:0.23"] = 492, -- Mok'Nathal Village, Thunderlord Stronghold, Zabra'jin, Shattrath, Stonebreaker Hold, Shadowmoon Village
				["0.49:0.64:0.58:0.73:0.42:0.72"] = 137, -- Mok'Nathal Village, Area 52, Evergrove

				-- Horde: Sanctum of the Stars (Shadowmoon Valley)
				["0.78:0.15:0.66:0.23"] = 61, -- Sanctum of the Stars, Shadowmoon Village
				["0.78:0.15:0.51:0.27"] = 134, -- Sanctum of the Stars, Stonebreaker Hold
				["0.78:0.15:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.42:0.72"] = 397, -- Sanctum of the Stars, Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold, Evergrove
				["0.78:0.15:0.51:0.27:0.44:0.33"] = 187, -- Sanctum of the Stars, Stonebreaker Hold, Shattrath
				["0.78:0.15:0.51:0.27:0.65:0.50:0.68:0.37"] = 322, -- Sanctum of the Stars, Stonebreaker Hold, Thrallmar, Spinebreaker Ridge
				["0.78:0.15:0.51:0.27:0.44:0.33:0.29:0.38"] = 268, -- Sanctum of the Stars, Stonebreaker Hold, Shattrath, Garadar
				["0.78:0.15:0.51:0.27:0.65:0.50:0.66:0.50"] = 257, -- Sanctum of the Stars, Stonebreaker Hold, Thrallmar
				["0.78:0.15:0.51:0.27:0.44:0.33:0.23:0.50"] = 323, -- Sanctum of the Stars, Stonebreaker Hold, Shattrath, Zabra'jin
				["0.78:0.15:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.63:0.82"] = 439, -- Sanctum of the Stars, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, The Stormspire
				["0.78:0.15:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.72:0.72"] = 457, -- Sanctum of the Stars, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, Cosmowrench
				["0.78:0.15:0.51:0.27:0.65:0.50:0.79:0.46"] = 327, -- Sanctum of the Stars, Stonebreaker Hold, Thrallmar, Hellfire Peninsula
				["0.78:0.15:0.51:0.27:0.44:0.33:0.44:0.49"] = 266, -- Sanctum of the Stars, Stonebreaker Hold, Shattrath, Swamprat Post
				["0.78:0.15:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73"] = 392, -- Sanctum of the Stars, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52
				["0.78:0.15:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68"] = 371, -- Sanctum of the Stars, Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold
				["0.78:0.15:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.63:0.82"] = 439, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, The Stormspire
				["0.78:0.15:0.66:0.23:0.51:0.27:0.44:0.33"] = 187, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold, Shattrath
				["0.78:0.15:0.66:0.23:0.51:0.27:0.44:0.33:0.29:0.38"] = 268, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold, Shattrath, Garadar
				["0.78:0.15:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.42:0.72"] = 397, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold, Shattrath, Thunderlord Stronghold, Evergrove
				["0.78:0.15:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73"] = 392, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52
				["0.78:0.15:0.66:0.23:0.51:0.27"] = 134, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold
				["0.78:0.15:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49"] = 266, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post
				["0.78:0.15:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.58:0.73"] = 468, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold, Area 52
				["0.78:0.15:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68"] = 372, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold
				["0.78:0.15:0.66:0.23:0.51:0.27:0.44:0.33:0.54:0.43"] = 263, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold, Shattrath, Falcon Watch
				["0.78:0.15:0.66:0.23:0.51:0.27:0.65:0.50:0.66:0.50"] = 257, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold, Thrallmar
				["0.78:0.15:0.66:0.23:0.51:0.27:0.44:0.33:0.23:0.50"] = 323, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold, Shattrath, Zabra'jin
				["0.78:0.15:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.72:0.72"] = 457, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, Cosmowrench
				["0.78:0.15:0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64"] = 336, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village
				["0.78:0.15:0.66:0.23:0.51:0.27:0.65:0.50:0.79:0.46"] = 327, -- Sanctum of the Stars, Shadowmoon Village, Stonebreaker Hold, Thrallmar, Hellfire Peninsula

				-- Horde: Shadowmoon Village (Shadowmoon Valley)
				["0.66:0.23:0.51:0.27"] = 73, -- Shadowmoon Village, Stonebreaker Hold
				["0.66:0.23:0.51:0.27:0.44:0.33"] = 126, -- Shadowmoon Village, Stonebreaker Hold, Shattrath
				["0.66:0.23:0.51:0.27:0.44:0.33:0.29:0.38"] = 207, -- Shadowmoon Village, Stonebreaker Hold, Shattrath, Garadar
				["0.66:0.23:0.51:0.27:0.44:0.33:0.23:0.50"] = 262, -- Shadowmoon Village, Stonebreaker Hold, Shattrath, Zabra'jin
				["0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49"] = 205, -- Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post
				["0.66:0.23:0.51:0.27:0.44:0.33:0.54:0.43"] = 202, -- Shadowmoon Village, Stonebreaker Hold, Shattrath, Falcon Watch
				["0.66:0.23:0.51:0.27:0.65:0.50:0.68:0.37"] = 262, -- Shadowmoon Village, Stonebreaker Hold, Thrallmar, Spinebreaker Ridge
				["0.66:0.23:0.51:0.27:0.65:0.50:0.79:0.46"] = 267, -- Shadowmoon Village, Stonebreaker Hold, Thrallmar, Hellfire Peninsula
				["0.66:0.23:0.51:0.27:0.65:0.50:0.66:0.50"] = 196, -- Shadowmoon Village, Stonebreaker Hold, Thrallmar
				["0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64"] = 276, -- Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village
				["0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68"] = 311, -- Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold
				["0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.42:0.72"] = 336, -- Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold, Evergrove (Kristopher Williamson reported 73, not changed)
				["0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73"] = 331, -- Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52
				["0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.72:0.72"] = 397, -- Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, Cosmowrench
				["0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.63:0.82"] = 379, -- Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, The Stormspire
				["0.66:0.23:0.78:0.15"] = 66, -- Shadowmoon Village, Sanctum of the Stars
				["0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.58:0.73"] = 407, -- Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold, Area 52
				["0.66:0.23:0.81:0.23"] = 85, -- Shadowmoon Village, Altar of Sha'tar
				["0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.58:0.73:0.72:0.72"] = 473, -- Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold, Area 52, Cosmowrench
				["0.66:0.23:0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.58:0.73:0.63:0.82"] = 455, -- Shadowmoon Village, Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold, Area 52, The Stormspire

				-- Horde: Shattrath (Terokkar Forest)
				["0.44:0.33:0.23:0.50"] = 136, -- Shattrath, Zabra'jin
				["0.44:0.33:0.29:0.38"] = 81, -- Shattrath, Garadar
				["0.44:0.33:0.44:0.49"] = 79, -- Shattrath, Swamprat Post
				["0.44:0.33:0.54:0.43"] = 77, -- Shattrath, Falcon Watch
				["0.44:0.33:0.51:0.27"] = 69, -- Shattrath, Stonebreaker Hold
				["0.44:0.33:0.51:0.27:0.66:0.23"] = 133, -- Shattrath, Stonebreaker Hold, Shadowmoon Village (anders brøndum bach reported 150)
				["0.44:0.33:0.54:0.43:0.65:0.50:0.68:0.37"] = 215, -- Shattrath, Falcon Watch, Thrallmar, Spinebreaker Ridge
				["0.44:0.33:0.54:0.43:0.65:0.50:0.79:0.46"] = 220, -- Shattrath, Falcon Watch, Thrallmar, Hellfire Peninsula
				["0.44:0.33:0.54:0.43:0.65:0.50:0.66:0.50"] = 150, -- Shattrath, Falcon Watch, Thrallmar (Mirko Riemann reported 78, not changed yet)
				["0.44:0.33:0.44:0.49:0.49:0.64"] = 150, -- Shattrath, Swamprat Post, Mok'Nathal Village
				["0.44:0.33:0.44:0.49:0.38:0.68:0.42:0.72"] = 211, -- Shattrath, Swamprat Post, Thunderlord Stronghold, Evergrove
				["0.44:0.33:0.44:0.49:0.38:0.68"] = 185, -- Shattrath, Swamprat Post, Thunderlord Stronghold
				["0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73"] = 205, -- Shattrath, Swamprat Post, Mok'Nathal Village, Area 52
				["0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.63:0.82"] = 253, -- Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, The Stormspire
				["0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.72:0.72"] = 270, -- Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, Cosmowrench
				["0.44:0.33:0.51:0.27:0.66:0.23:0.81:0.23"] = 215, -- Shattrath, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.44:0.33:0.44:0.49:0.38:0.68:0.58:0.73:0.72:0.72"] = 347, -- Shattrath, Swamprat Post, Thunderlord Stronghold, Area 52, Cosmowrench
				["0.44:0.33:0.51:0.27:0.66:0.23:0.78:0.15"] = 198, -- Shattrath, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.44:0.33:0.44:0.49:0.38:0.68:0.58:0.73"] = 282, -- Shattrath, Swamprat Post, Thunderlord Stronghold, Area 52
				["0.44:0.33:0.44:0.49:0.38:0.68:0.58:0.73:0.63:0.82"] = 329, -- Shattrath, Swamprat Post, Thunderlord Stronghold, Area 52, The Stormspire
				["0.44:0.33:0.51:0.27:0.65:0.50:0.66:0.50"] = 193, -- Shattrath, Stonebreaker Hold, Thrallmar
				["0.44:0.33:0.44:0.49:0.38:0.68:0.63:0.82"] = 341, -- Shattrath, Swamprat Post, Thunderlord Stronghold, The Stormspire
				["0.44:0.33:0.51:0.27:0.65:0.50:0.68:0.37"] = 257, -- Shattrath, Stonebreaker Hold, Thrallmar, Spinebreaker Ridge
				["0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.42:0.72"] = 286, -- Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, Evergrove
				["0.44:0.33:0.23:0.50:0.38:0.68:0.58:0.73"] = 344, -- Shattrath, Zabra'jin, Thunderlord Stronghold, Area 52
				["0.44:0.33:0.65:0.50:0.66:0.50"] = 132, -- Shattrath, Thrallmar
				["0.44:0.33:0.65:0.50:0.79:0.46"] = 202, -- Shattrath, Thrallmar, Hellfire Peninsula
				["0.44:0.33:0.65:0.50:0.68:0.37"] = 197, -- Shattrath, Thrallmar, Spinebreaker Ridge
				["0.44:0.33:0.44:0.49:0.38:0.68:0.63:0.82:0.72:0.72"] = 409, -- Shattrath, Swamprat Post, Thunderlord Stronghold, The Stormspire, Cosmowrench
				["0.44:0.33:0.23:0.50:0.38:0.68:0.42:0.72"] = 272, -- Shattrath, Zabra'jin, Thunderlord Stronghold, Evergrove
				["0.44:0.33:0.23:0.50:0.38:0.68"] = 247, -- Shattrath, Zabra'jin, Thunderlord Stronghold
				["0.44:0.33:0.23:0.50:0.38:0.68:0.58:0.73:0.72:0.72"] = 409, -- Shattrath, Zabra'jin, Thunderlord Stronghold, Area 52, Cosmowrench

				-- Horde: Spinebreaker Ridge (Hellfire Peninsula)
				["0.68:0.37:0.65:0.50:0.54:0.43:0.29:0.38"] = 263, -- Spinebreaker Ridge, Thrallmar, Falcon Watch, Garadar
				["0.68:0.37:0.65:0.50:0.54:0.43:0.44:0.33"] = 200, -- Spinebreaker Ridge, Thrallmar, Falcon Watch, Shattrath
				["0.68:0.37:0.65:0.50:0.51:0.27"] = 190, -- Spinebreaker Ridge, Thrallmar, Stonebreaker Hold
				["0.68:0.37:0.65:0.50:0.51:0.27:0.66:0.23"] = 255, -- Spinebreaker Ridge, Thrallmar, Stonebreaker Hold, Shadowmoon Village
				["0.68:0.37:0.65:0.50:0.79:0.46"] = 133, -- Spinebreaker Ridge, Thrallmar, Hellfire Peninsula
				["0.68:0.37:0.65:0.50:0.66:0.50"] = 62, -- Spinebreaker Ridge, Thrallmar
				["0.68:0.37:0.65:0.50:0.54:0.43"] = 129, -- Spinebreaker Ridge, Thrallmar, Falcon Watch
				["0.68:0.37:0.65:0.50:0.54:0.43:0.44:0.49"] = 198, -- Spinebreaker Ridge, Thrallmar, Falcon Watch, Swamprat Post
				["0.68:0.37:0.65:0.50:0.54:0.43:0.23:0.50"] = 280, -- Spinebreaker Ridge, Thrallmar, Falcon Watch, Zabra'jin
				["0.68:0.37:0.65:0.50:0.54:0.43:0.44:0.49:0.38:0.68"] = 303, -- Spinebreaker Ridge, Thrallmar, Falcon Watch, Swamprat Post, Thunderlord Stronghold
				["0.68:0.37:0.65:0.50:0.54:0.43:0.44:0.49:0.38:0.68:0.42:0.72"] = 330, -- Spinebreaker Ridge, Thrallmar, Falcon Watch, Swamprat Post, Thunderlord Stronghold, Evergrove
				["0.68:0.37:0.65:0.50:0.54:0.43:0.44:0.49:0.49:0.64"] = 268, -- Spinebreaker Ridge, Thrallmar, Falcon Watch, Swamprat Post, Mok'Nathal Village
				["0.68:0.37:0.65:0.50:0.54:0.43:0.44:0.49:0.49:0.64:0.58:0.73"] = 327, -- Spinebreaker Ridge, Thrallmar, Falcon Watch, Swamprat Post, Mok'Nathal Village, Area 52
				["0.68:0.37:0.65:0.50:0.54:0.43:0.44:0.49:0.49:0.64:0.58:0.73:0.72:0.72"] = 389, -- Spinebreaker Ridge, Thrallmar, Falcon Watch, Swamprat Post, Mok'Nathal Village, Area 52, Cosmowrench
				["0.68:0.37:0.65:0.50:0.54:0.43:0.44:0.49:0.49:0.64:0.58:0.73:0.63:0.82"] = 373, -- Spinebreaker Ridge, Thrallmar, Falcon Watch, Swamprat Post, Mok'Nathal Village, Area 52, The Stormspire
				["0.68:0.37:0.65:0.50:0.51:0.27:0.66:0.23:0.78:0.15"] = 319, -- Spinebreaker Ridge, Thrallmar, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.68:0.37:0.65:0.50:0.51:0.27:0.66:0.23:0.81:0.23"] = 335, -- Spinebreaker Ridge, Thrallmar, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.68:0.37:0.65:0.50:0.44:0.33"] = 185, -- Spinebreaker Ridge, Thrallmar, Shattrath

				-- Horde: Stonebreaker Hold (Terokkar Forest)
				["0.51:0.27:0.66:0.23"] = 68, -- Stonebreaker Hold, Shadowmoon Village
				["0.51:0.27:0.65:0.50:0.68:0.37"] = 191, -- Stonebreaker Hold, Thrallmar, Spinebreaker Ridge
				["0.51:0.27:0.65:0.50:0.79:0.46"] = 195, -- Stonebreaker Hold, Thrallmar, Hellfire Peninsula
				["0.51:0.27:0.65:0.50:0.66:0.50"] = 125, -- Stonebreaker Hold, Thrallmar
				["0.51:0.27:0.44:0.33:0.54:0.43"] = 132, -- Stonebreaker Hold, Shattrath, Falcon Watch
				["0.51:0.27:0.44:0.33"] = 56, -- Stonebreaker Hold, Shattrath
				["0.51:0.27:0.44:0.33:0.29:0.38"] = 137, -- Stonebreaker Hold, Shattrath, Garadar
				["0.51:0.27:0.44:0.33:0.44:0.49"] = 135, -- Stonebreaker Hold, Shattrath, Swamprat Post
				["0.51:0.27:0.44:0.33:0.23:0.50"] = 193, -- Stonebreaker Hold, Shattrath, Zabra'jin
				["0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68"] = 242, -- Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold
				["0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.42:0.72"] = 266, -- Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold, Evergrove
				["0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64"] = 207, -- Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village
				["0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73"] = 261, -- Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52
				["0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.72:0.72"] = 330, -- Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, Cosmowrench
				["0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.63:0.82"] = 313, -- Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, The Stormspire
				["0.51:0.27:0.66:0.23:0.78:0.15"] = 133, -- Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.51:0.27:0.66:0.23:0.81:0.23"] = 149, -- Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.58:0.73:0.63:0.82"] = 385, -- Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold, Area 52, The Stormspire
				["0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.58:0.73:0.72:0.72"] = 403, -- Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold, Area 52, Cosmowrench
				["0.51:0.27:0.44:0.33:0.44:0.49:0.38:0.68:0.58:0.73"] = 338, -- Stonebreaker Hold, Shattrath, Swamprat Post, Thunderlord Stronghold, Area 52
				["0.51:0.27:0.65:0.50:0.54:0.43"] = 192, -- Stonebreaker Hold, Thrallmar, Falcon Watch
				["0.51:0.27:0.65:0.50:0.54:0.43:0.44:0.49"] = 260, -- Stonebreaker Hold, Thrallmar, Falcon Watch, Swamprat Post
				["0.51:0.27:0.65:0.50:0.54:0.43:0.29:0.38"] = 324, -- Stonebreaker Hold, Thrallmar, Falcon Watch, Garadar
				["0.51:0.27:0.44:0.33:0.23:0.50:0.38:0.68:0.58:0.73"] = 400, -- Stonebreaker Hold, Shattrath, Zabra'jin, Thunderlord Stronghold, Area 52
				["0.51:0.27:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73:0.42:0.72"] = 342, -- Stonebreaker Hold, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52, Evergrove

				-- Horde: Swamprat Post (Zangarmarsh)
				["0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23"] = 220, -- Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village
				["0.44:0.49:0.54:0.43:0.65:0.50:0.68:0.37"] = 201, -- Swamprat Post, Falcon Watch, Thrallmar, Spinebreaker Ridge
				["0.44:0.49:0.54:0.43:0.65:0.50:0.79:0.46"] = 206, -- Swamprat Post, Falcon Watch, Thrallmar, Hellfire Peninsula
				["0.44:0.49:0.54:0.43:0.65:0.50:0.66:0.50"] = 136, -- Swamprat Post, Falcon Watch, Thrallmar
				["0.44:0.49:0.54:0.43"] = 61, -- Swamprat Post, Falcon Watch
				["0.44:0.49:0.44:0.33:0.51:0.27"] = 155, -- Swamprat Post, Shattrath, Stonebreaker Hold
				["0.44:0.49:0.44:0.33"] = 86, -- Swamprat Post, Shattrath
				["0.44:0.49:0.44:0.33:0.29:0.38"] = 168, -- Swamprat Post, Shattrath, Garadar
				["0.44:0.49:0.23:0.50"] = 111, -- Swamprat Post, Zabra'jin
				["0.44:0.49:0.38:0.68"] = 106, -- Swamprat Post, Thunderlord Stronghold
				["0.44:0.49:0.38:0.68:0.42:0.72"] = 132, -- Swamprat Post, Thunderlord Stronghold, Evergrove
				["0.44:0.49:0.49:0.64"] = 71, -- Swamprat Post, Mok'Nathal Village
				["0.44:0.49:0.49:0.64:0.58:0.73"] = 126, -- Swamprat Post, Mok'Nathal Village, Area 52
				["0.44:0.49:0.49:0.64:0.58:0.73:0.72:0.72"] = 193, -- Swamprat Post, Mok'Nathal Village, Area 52, Cosmowrench
				["0.44:0.49:0.49:0.64:0.58:0.73:0.63:0.82"] = 174, -- Swamprat Post, Mok'Nathal Village, Area 52, The Stormspire
				["0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.78:0.15"] = 284, -- Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.81:0.23"] = 301, -- Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.44:0.49:0.38:0.68:0.58:0.73"] = 202, -- Swamprat Post, Thunderlord Stronghold, Area 52
				["0.44:0.49:0.38:0.68:0.58:0.73:0.63:0.82"] = 250, -- Swamprat Post, Thunderlord Stronghold, Area 52, The Stormspire
				["0.44:0.49:0.54:0.43:0.65:0.50:0.51:0.27"] = 264, -- Swamprat Post, Falcon Watch, Thrallmar, Stonebreaker Hold
				["0.44:0.49:0.44:0.33:0.65:0.50:0.66:0.50"] = 215, -- Swamprat Post, Shattrath, Thrallmar
				["0.44:0.49:0.38:0.68:0.58:0.73:0.72:0.72"] = 268, -- Swamprat Post, Thunderlord Stronghold, Area 52, Cosmowrench
				["0.44:0.49:0.54:0.43:0.29:0.38"] = 195, -- Swamprat Post, Falcon Watch, Garadar
				["0.44:0.49:0.23:0.50:0.29:0.38"] = 187, -- Swamprat Post, Zabra'jin, Garadar

				-- Horde: The Stormspire (Netherstorm)
				["0.63:0.82:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23"] = 410, -- The Stormspire, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village
				["0.63:0.82:0.58:0.73:0.49:0.64:0.44:0.49:0.54:0.43:0.65:0.50:0.68:0.37"] = 390, -- The Stormspire, Area 52, Mok'Nathal Village, Swamprat Post, Falcon Watch, Thrallmar, Spinebreaker Ridge
				["0.63:0.82:0.58:0.73:0.49:0.64:0.44:0.49:0.54:0.43:0.65:0.50:0.79:0.46"] = 395, -- The Stormspire, Area 52, Mok'Nathal Village, Swamprat Post, Falcon Watch, Thrallmar, Hellfire Peninsula
				["0.63:0.82:0.58:0.73:0.49:0.64:0.44:0.49:0.54:0.43:0.65:0.50:0.66:0.50"] = 326, -- The Stormspire, Area 52, Mok'Nathal Village, Swamprat Post, Falcon Watch, Thrallmar
				["0.63:0.82:0.58:0.73:0.49:0.64:0.44:0.49:0.54:0.43"] = 254, -- The Stormspire, Area 52, Mok'Nathal Village, Swamprat Post, Falcon Watch
				["0.63:0.82:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27"] = 345, -- The Stormspire, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold
				["0.63:0.82:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33"] = 277, -- The Stormspire, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath
				["0.63:0.82:0.58:0.73:0.49:0.64:0.44:0.49"] = 191, -- The Stormspire, Area 52, Mok'Nathal Village, Swamprat Post
				["0.63:0.82:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.29:0.38"] = 359, -- The Stormspire, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Garadar
				["0.63:0.82:0.38:0.68:0.23:0.50"] = 294, -- The Stormspire, Thunderlord Stronghold, Zabra'jin
				["0.63:0.82:0.58:0.73:0.49:0.64"] = 118, -- The Stormspire, Area 52, Mok'Nathal Village
				["0.63:0.82:0.38:0.68"] = 147, -- The Stormspire, Thunderlord Stronghold
				["0.63:0.82:0.58:0.73:0.42:0.72"] = 132, -- The Stormspire, Area 52, Evergrove
				["0.63:0.82:0.58:0.73"] = 53, -- The Stormspire, Area 52
				["0.63:0.82:0.72:0.72"] = 69, -- The Stormspire, Cosmowrench
				["0.63:0.82:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.78:0.15"] = 474, -- The Stormspire, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.63:0.82:0.38:0.68:0.44:0.49:0.44:0.33"] = 348, -- The Stormspire, Thunderlord Stronghold, Swamprat Post, Shattrath (Gareth Horton reported 332)
				["0.63:0.82:0.58:0.73:0.49:0.64:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.81:0.23"] = 490, -- The Stormspire, Area 52, Mok'Nathal Village, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.63:0.82:0.38:0.68:0.23:0.50:0.29:0.38"] = 372, -- The Stormspire, Thunderlord Stronghold, Zabra'jin, Garadar
				["0.63:0.82:0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23"] = 481, -- The Stormspire, Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village
				["0.63:0.82:0.38:0.68:0.44:0.49:0.54:0.43:0.65:0.50:0.66:0.50"] = 397, -- The Stormspire, Thunderlord Stronghold, Swamprat Post, Falcon Watch, Thrallmar
				["0.63:0.82:0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27"] = 417, -- The Stormspire, Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold
				["0.63:0.82:0.38:0.68:0.44:0.49"] = 262, -- The Stormspire, Thunderlord Stronghold, Swamprat Post
				["0.63:0.82:0.38:0.68:0.23:0.50:0.44:0.33"] = 443, -- The Stormspire, Thunderlord Stronghold, Zabra'jin, Shattrath
				["0.63:0.82:0.38:0.68:0.44:0.49:0.54:0.43"] = 325, -- The Stormspire, Thunderlord Stronghold, Swamprat Post, Falcon Watch
				["0.63:0.82:0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.81:0.23"] = 562, -- The Stormspire, Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.63:0.82:0.38:0.68:0.42:0.72"] = 172, -- The Stormspire, Thunderlord Stronghold, Evergrove

				-- Horde: Thrallmar (Hellfire Peninsula)
				["0.66:0.50:0.51:0.27:0.66:0.23"] = 192, -- Thrallmar, Stonebreaker Hold, Shadowmoon Village
				["0.66:0.50:0.68:0.37"] = 66, -- Thrallmar, Spinebreaker Ridge
				["0.66:0.50:0.79:0.46"] = 70, -- Thrallmar, Hellfire Peninsula
				["0.66:0.50:0.54:0.43"] = 66, -- Thrallmar, Falcon Watch
				["0.66:0.50:0.51:0.27"] = 129, -- Thrallmar, Stonebreaker Hold
				["0.66:0.50:0.54:0.43:0.44:0.33"] = 138, -- Thrallmar, Falcon Watch, Shattrath (Taylor Morris reported 67)
				["0.66:0.50:0.54:0.43:0.44:0.49"] = 135, -- Thrallmar, Falcon Watch, Swamprat Post
				["0.66:0.50:0.54:0.43:0.29:0.38"] = 199, -- Thrallmar, Falcon Watch, Garadar
				["0.66:0.50:0.54:0.43:0.23:0.50"] = 217, -- Thrallmar, Falcon Watch, Zabra'jin
				["0.66:0.50:0.54:0.43:0.44:0.49:0.38:0.68"] = 242, -- Thrallmar, Falcon Watch, Swamprat Post, Thunderlord Stronghold
				["0.66:0.50:0.54:0.43:0.44:0.49:0.38:0.68:0.42:0.72"] = 267, -- Thrallmar, Falcon Watch, Swamprat Post, Thunderlord Stronghold, Evergrove
				["0.66:0.50:0.54:0.43:0.44:0.49:0.49:0.64"] = 206, -- Thrallmar, Falcon Watch, Swamprat Post, Mok'Nathal Village
				["0.66:0.50:0.54:0.43:0.44:0.49:0.49:0.64:0.58:0.73"] = 262, -- Thrallmar, Falcon Watch, Swamprat Post, Mok'Nathal Village, Area 52
				["0.66:0.50:0.54:0.43:0.44:0.49:0.49:0.64:0.58:0.73:0.63:0.82"] = 309, -- Thrallmar, Falcon Watch, Swamprat Post, Mok'Nathal Village, Area 52, The Stormspire
				["0.66:0.50:0.54:0.43:0.44:0.49:0.49:0.64:0.58:0.73:0.72:0.72"] = 327, -- Thrallmar, Falcon Watch, Swamprat Post, Mok'Nathal Village, Area 52, Cosmowrench
				["0.66:0.50:0.51:0.27:0.66:0.23:0.78:0.15"] = 257, -- Thrallmar, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.66:0.50:0.54:0.43:0.44:0.49:0.38:0.68:0.58:0.73"] = 338, -- Thrallmar, Falcon Watch, Swamprat Post, Thunderlord Stronghold, Area 52
				["0.66:0.50:0.51:0.27:0.66:0.23:0.81:0.23"] = 273, -- Thrallmar, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.66:0.50:0.54:0.43:0.44:0.49:0.38:0.68:0.58:0.73:0.63:0.82"] = 385, -- Thrallmar, Falcon Watch, Swamprat Post, Thunderlord Stronghold, Area 52, The Stormspire
				["0.66:0.50:0.54:0.43:0.44:0.49:0.38:0.68:0.58:0.73:0.72:0.72"] = 403, -- Thrallmar, Falcon Watch, Swamprat Post, Thunderlord Stronghold, Area 52, Cosmowrench
				["0.66:0.50:0.51:0.27:0.44:0.33"] = 182, -- Thrallmar, Stonebreaker Hold, Shattrath
				["0.66:0.50:0.54:0.43:0.44:0.49:0.38:0.68:0.63:0.82:0.72:0.72"] = 465, -- Thrallmar, Falcon Watch, Swamprat Post, Thunderlord Stronghold, The Stormspire, Cosmowrench
				["0.66:0.50:0.44:0.33"] = 123, -- Thrallmar, Shattrath
				["0.66:0.50:0.44:0.33:0.23:0.50"] = 257, -- Thrallmar, Shattrath, Zabra'jin
				["0.66:0.50:0.54:0.43:0.23:0.50:0.38:0.68"] = 328, -- Thrallmar, Falcon Watch, Zabra'jin, Thunderlord Stronghold
				["0.66:0.50:0.54:0.43:0.23:0.50:0.38:0.68:0.58:0.73"] = 424, -- Thrallmar, Falcon Watch, Zabra'jin, Thunderlord Stronghold, Area 52
				["0.66:0.50:0.44:0.33:0.44:0.49:0.49:0.64:0.58:0.73"] = 326, -- Thrallmar, Shattrath, Swamprat Post, Mok'Nathal Village, Area 52
				["0.66:0.50:0.44:0.33:0.29:0.38"] = 202, -- Thrallmar, Shattrath, Garadar

				-- Horde: Thunderlord Stronghold (Blade's Edge Mountains)
				["0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23"] = 335, -- Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village
				["0.38:0.68:0.44:0.49:0.54:0.43:0.65:0.50:0.68:0.37"] = 316, -- Thunderlord Stronghold, Swamprat Post, Falcon Watch, Thrallmar, Spinebreaker Ridge
				["0.38:0.68:0.44:0.49:0.54:0.43:0.65:0.50:0.79:0.46"] = 322, -- Thunderlord Stronghold, Swamprat Post, Falcon Watch, Thrallmar, Hellfire Peninsula
				["0.38:0.68:0.44:0.49:0.54:0.43:0.65:0.50:0.66:0.50"] = 251, -- Thunderlord Stronghold, Swamprat Post, Falcon Watch, Thrallmar
				["0.38:0.68:0.44:0.49:0.54:0.43"] = 179, -- Thunderlord Stronghold, Swamprat Post, Falcon Watch
				["0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27"] = 271, -- Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold
				["0.38:0.68:0.44:0.49:0.44:0.33"] = 202, -- Thunderlord Stronghold, Swamprat Post, Shattrath
				["0.38:0.68:0.44:0.49"] = 116, -- Thunderlord Stronghold, Swamprat Post
				["0.38:0.68:0.23:0.50:0.29:0.38"] = 227, -- Thunderlord Stronghold, Zabra'jin, Garadar
				["0.38:0.68:0.23:0.50"] = 149, -- Thunderlord Stronghold, Zabra'jin
				["0.38:0.68:0.49:0.64"] = 55, -- Thunderlord Stronghold, Mok'Nathal Village
				["0.38:0.68:0.42:0.72"] = 26, -- Thunderlord Stronghold, Evergrove
				["0.38:0.68:0.58:0.73"] = 97, -- Thunderlord Stronghold, Area 52
				["0.38:0.68:0.58:0.73:0.72:0.72"] = 163, -- Thunderlord Stronghold, Area 52, Cosmowrench
				["0.38:0.68:0.63:0.82"] = 158, -- Thunderlord Stronghold, The Stormspire
				["0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.81:0.23"] = 416, -- Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.38:0.68:0.44:0.49:0.44:0.33:0.51:0.27:0.66:0.23:0.78:0.15"] = 400, -- Thunderlord Stronghold, Swamprat Post, Shattrath, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.38:0.68:0.23:0.50:0.44:0.33"] = 297, -- Thunderlord Stronghold, Zabra'jin, Shattrath
				["0.38:0.68:0.44:0.49:0.44:0.33:0.29:0.38"] = 284, -- Thunderlord Stronghold, Swamprat Post, Shattrath, Garadar

				-- Horde: Zabra'jin (Zangarmarsh)
				["0.23:0.50:0.29:0.38"] = 81, -- Zabra'jin, Garadar
				["0.23:0.50:0.44:0.33"] = 151, -- Zabra'jin, Shattrath
				["0.23:0.50:0.44:0.33:0.51:0.27"] = 220, -- Zabra'jin, Shattrath, Stonebreaker Hold
				["0.23:0.50:0.44:0.33:0.51:0.27:0.66:0.23"] = 284, -- Zabra'jin, Shattrath, Stonebreaker Hold, Shadowmoon Village
				["0.23:0.50:0.54:0.43:0.65:0.50:0.68:0.37"] = 287, -- Zabra'jin, Falcon Watch, Thrallmar, Spinebreaker Ridge
				["0.23:0.50:0.54:0.43:0.65:0.50:0.79:0.46"] = 290, -- Zabra'jin, Falcon Watch, Thrallmar, Hellfire Peninsula
				["0.23:0.50:0.54:0.43:0.65:0.50:0.66:0.50"] = 220, -- Zabra'jin, Falcon Watch, Thrallmar
				["0.23:0.50:0.54:0.43"] = 147, -- Zabra'jin, Falcon Watch
				["0.23:0.50:0.44:0.49"] = 112, -- Zabra'jin, Swamprat Post
				["0.23:0.50:0.38:0.68"] = 113, -- Zabra'jin, Thunderlord Stronghold
				["0.23:0.50:0.38:0.68:0.42:0.72"] = 139, -- Zabra'jin, Thunderlord Stronghold, Evergrove
				["0.23:0.50:0.38:0.68:0.49:0.64"] = 168, -- Zabra'jin, Thunderlord Stronghold, Mok'Nathal Village
				["0.23:0.50:0.38:0.68:0.58:0.73"] = 209, -- Zabra'jin, Thunderlord Stronghold, Area 52
				["0.23:0.50:0.38:0.68:0.58:0.73:0.63:0.82"] = 257, -- Zabra'jin, Thunderlord Stronghold, Area 52, The Stormspire
				["0.23:0.50:0.38:0.68:0.58:0.73:0.72:0.72"] = 275, -- Zabra'jin, Thunderlord Stronghold, Area 52, Cosmowrench
				["0.23:0.50:0.44:0.33:0.51:0.27:0.66:0.23:0.78:0.15"] = 349, -- Zabra'jin, Shattrath, Stonebreaker Hold, Shadowmoon Village, Sanctum of the Stars
				["0.23:0.50:0.44:0.49:0.49:0.64:0.58:0.73:0.72:0.72"] = 304, -- Zabra'jin, Swamprat Post, Mok'Nathal Village, Area 52, Cosmowrench
				["0.23:0.50:0.44:0.33:0.51:0.27:0.66:0.23:0.81:0.23"] = 365, -- Zabra'jin, Shattrath, Stonebreaker Hold, Shadowmoon Village, Altar of Sha'tar
				["0.23:0.50:0.44:0.33:0.51:0.27:0.65:0.50:0.66:0.50"] = 343, -- Zabra'jin, Shattrath, Stonebreaker Hold, Thrallmar
				["0.23:0.50:0.54:0.43:0.65:0.50:0.51:0.27"] = 349, -- Zabra'jin, Falcon Watch, Thrallmar, Stonebreaker Hold
				["0.23:0.50:0.44:0.33:0.65:0.50:0.68:0.37"] = 344, -- Zabra'jin, Shattrath, Thrallmar, Spinebreaker Ridge
				["0.23:0.50:0.44:0.33:0.65:0.50:0.66:0.50"] = 280, -- Zabra'jin, Shattrath, Thrallmar
				["0.23:0.50:0.44:0.49:0.49:0.64:0.58:0.73"] = 238, -- Zabra'jin, Swamprat Post, Mok'Nathal Village, Area 52

			},

			-- Horde: Northrend
			[4] = {

				----------------------------------------------------------------------
				-- Horde: Borean Tundra
				----------------------------------------------------------------------

				-- Horde: Borean Tundra: Amber Ledge
				["0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62"] = 187, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran
				["0.17:0.47:0.15:0.43"] = 28, -- Amber Ledge, Warsong Hold
				["0.17:0.47:0.18:0.53"] = 23, -- Amber Ledge, Bor'gorok Outpost
				["0.17:0.47:0.18:0.53:0.24:0.60"] = 61, -- Amber Ledge, Bor'gorok Outpost, River's Heart
				["0.17:0.47:0.12:0.47"] = 25, -- Amber Ledge, Transitus Shield (Johann Boleininger reported 62)
				["0.17:0.47:0.29:0.46:0.29:0.43"] = 68, -- Amber Ledge, Taunka'le Village, Unu'pe
				["0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.85:0.27"] = 289, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, New Agamand
				["0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 309, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.17:0.47:0.29:0.46"] = 49, -- Amber Ledge, Taunka'le Village
				["0.17:0.47:0.29:0.46:0.45:0.49"] = 109, -- Amber Ledge, Taunka'le Village, Agmar's Hammer
				["0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45"] = 166, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite
				["0.17:0.47:0.15:0.43:0.29:0.43"] = 90, -- Escarpement d'Ambre, Bastion Chanteguerre, Unu'pe
				["0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.85:0.27:0.74:0.29"] = 339, -- Bernsteinflöz, Taunka'le, Agmars Hammer, Gallgrimm, Neu-Agamand, Kamagua
				["0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38"] = 230, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp
				["0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48:0.52:0.62"] = 203, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Dalaran
				["0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48"] = 142, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple
				["0.17:0.47:0.29:0.46:0.29:0.43:0.49:0.42"] = 147, -- Amber Ledge, Taunka'le Village, Unu'pe, Moa'ki
				["0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41"] = 261, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof
				["0.17:0.47:0.29:0.46:0.29:0.43:0.49:0.42:0.74:0.29"] = 269, -- Amber Ledge, Taunka'le Village, Unu'pe, Moa'ki, Kamagua
				["0.17:0.47:0.29:0.46:0.29:0.43:0.49:0.42:0.52:0.62"] = 228, -- Amber Ledge, Taunka'le Village, Unu'pe, Moa'ki, Dalaran
				["0.17:0.47:0.15:0.43:0.29:0.43:0.49:0.42:0.59:0.45"] = 209, -- Amber Ledge, Warsong Hold, Unu'pe, Moa'ki, Venomspite
				["0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45"] = 204, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold
				["0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 279, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, The Argent Stand, Zim'Torga
				["0.17:0.47:0.29:0.46:0.31:0.57"] = 95, -- Amber Ledge, Taunka'le Village, Warsong Camp
				["0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.72:0.71"] = 285, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Dun Nifflelem
				["0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.74:0.29"] = 267, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp, Kamagua
				["0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58"] = 210, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch
				["0.17:0.47:0.15:0.43:0.29:0.43:0.49:0.42:0.74:0.29:0.85:0.27"] = 332, -- Amber Ledge, Warsong Hold, Unu'pe, Moa'ki, Kamagua, New Agamand
				["0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.56:0.64"] = 202, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, The Argent Vanguard
				["0.17:0.47:0.29:0.46:0.29:0.43:0.49:0.42:0.74:0.29:0.85:0.27"] = 311, -- Amber Ledge, Taunka'le Village, Unu'pe, Moa'ki, Kamagua, New Agamand
				["0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49:0.95:0.37"] = 341, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Oneqwah, Vengeance Landing
				["0.17:0.47:0.18:0.53:0.24:0.60:0.52:0.62"] = 190, -- Amber Ledge, Bor'gorok Outpost, River's Heart, Dalaran
				["0.17:0.47:0.29:0.46:0.45:0.49:0.49:0.42"] = 149, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Moa'ki
				["0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.64:0.58:0.69:0.58:0.70:0.45:0.84:0.41"] = 356, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Ebon Watch, Light's Breach, Conquest Hold, Camp Winterhoof
				["0.17:0.47:0.18:0.53:0.18:0.60"] = 56, -- Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp
				["0.17:0.47:0.29:0.46:0.31:0.57:0.52:0.62"] = 190, -- Amber Ledge, Taunka'le Village, Warsong Camp, Dalaran
				["0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.69:0.58"] = 239, -- El Saliente Ámbar, Poblado Taunka'le, Martillo de Agmar, Templo del Reposo del Dragón, Puesto de Vigilancia de Ébano, Brecha de la Luz
				["0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75"] = 268, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56"] = 150, -- Bernsteinflöz, Taunka'le, Agmars Hammer, Vorposten der Kor'kron
				["0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64"] = 217, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3
				["0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72"] = 115, -- Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise
				["0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79"] = 178, -- Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault
				["0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.60:0.60"] = 219, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, Sunreaver's Command
				["0.17:0.47:0.18:0.53:0.24:0.60:0.31:0.57:0.45:0.49"] = 180, -- Amber Ledge, Bor'gorok Outpost, River's Heart, Warsong Camp, Agmar's Hammer
				["0.17:0.47:0.29:0.46:0.29:0.43:0.49:0.42:0.59:0.45"] = 187, -- Amber Ledge, Taunka'le Village, Unu'pe, Moa'ki, Venomspite
				["0.17:0.47:0.29:0.46:0.29:0.43:0.49:0.42:0.54:0.48"] = 178, -- Bernsteinflöz, Taunka'le, Unu'pe, Moa'ki, Wyrmruhtempel
				["0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49"] = 272, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Oneqwah
				["0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48:0.52:0.62:0.62:0.64:0.60:0.75"] = 283, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Dalaran, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 315, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.69:0.58"] = 237, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Light's Breach
				["0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79:0.49:0.79"] = 228, -- Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault, Argent Tournament Grounds
				["0.17:0.47:0.18:0.53:0.24:0.60:0.28:0.72:0.38:0.79:0.49:0.79"] = 231, -- Escarpement d'Ambre, Avant-poste Bor'gorok, Le Cœur du fleuve, Cime de la Mort, Le caveau des Ombres, Enceinte du tournoi d'Argent
				["0.17:0.47:0.29:0.46:0.31:0.57:0.52:0.66"] = 202, -- Amber Ledge, Taunka'le Village, Warsong Camp, Crusaders' Pinnacle
				["0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79:0.57:0.79:0.64:0.81"] = 287, -- Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault, Bouldercrag's Refuge, Ulduar
				["0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79:0.57:0.79"] = 258, -- Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault, Bouldercrag's Refuge
				["0.17:0.47:0.18:0.53:0.24:0.60:0.28:0.72"] = 118, -- Amber Ledge, Bor'gorok Outpost, River's Heart, Death's Rise
				["0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60"] = 252, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, The Argent Stand
				["0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.49:0.79"] = 264, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, Argent Tournament Grounds
				["0.17:0.47:0.29:0.46:0.31:0.57:0.38:0.79"] = 204, -- Amber Ledge, Taunka'le Village, Warsong Camp, The Shadow Vault
				["0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.52:0.66:0.38:0.79"] = 288, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.24:0.60:0.18:0.60"] = 345, -- Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, River's Heart, Nesingwary Base Camp
				["0.17:0.47:0.29:0.46:0.31:0.57:0.52:0.62:0.48:0.56"] = 230, -- Amber Ledge, Taunka'le Village, Warsong Camp, Dalaran, Kor'koron Vanguard
				["0.17:0.47:0.18:0.53:0.24:0.60:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.95:0.37"] = 404, -- Amber Ledge, Bor'gorok Outpost, River's Heart, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Vengeance Landing
				["0.17:0.47:0.29:0.46:0.31:0.57:0.38:0.79:0.49:0.79"] = 255, -- Amber Ledge, Taunka'le Village, Warsong Camp, The Shadow Vault, Argent Tournament Grounds

				-- Horde: Borean Tundra: Bor'gorok Outpost
				["0.18:0.53:0.29:0.46"] = 78, -- Bor'gorok Outpost, Taunka'le Village
				["0.18:0.53:0.24:0.60:0.28:0.72"] = 143, -- Bor'gorok Outpost, River's Heart, Death's Rise
				["0.18:0.53:0.24:0.60:0.52:0.62"] = 251, -- Bor'gorok Outpost, River's Heart, Dalaran
				["0.18:0.53:0.24:0.60"] = 58, -- Bor'gorok Outpost, River's Heart
				["0.18:0.53:0.17:0.47"] = 57, -- Bor'gorok Outpost, Amber Ledge
				["0.18:0.53:0.17:0.47:0.12:0.47"] = 92, -- Bor'gorok Outpost, Amber Ledge, Transitus Shield
				["0.18:0.53:0.24:0.60:0.52:0.62:0.56:0.64"] = 273, -- Bor'gorok Outpost, River's Heart, Dalaran, The Argent Vanguard
				["0.18:0.53:0.15:0.43"] = 72, -- Bor'gorok Outpost, Warsong Hold
				["0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.85:0.27"] = 439, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, New Agamand
				["0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 469, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38"] = 351, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp
				["0.18:0.53:0.29:0.46:0.45:0.49"] = 168, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer
				["0.18:0.53:0.29:0.46:0.29:0.43:0.49:0.42"] = 225, -- Bor'gorok Outpost, Taunka'le Village, Unu'pe, Moa'ki
				["0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49:0.95:0.37"] = 517, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Oneqwah, Vengeance Landing
				["0.18:0.53:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62"] = 285, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran
				["0.18:0.53:0.15:0.43:0.29:0.43"] = 165, -- Bor'gorok Outpost, Warsong Hold, Unu'pe
				["0.18:0.53:0.29:0.46:0.29:0.43"] = 107, -- Bor'goroks Außenposten, Taunka'le, Unu'pe
				["0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45"] = 312, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold
				["0.18:0.53:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58"] = 319, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch
				["0.18:0.53:0.29:0.46:0.29:0.43:0.49:0.42:0.74:0.29"] = 408, -- Bor'goroks Außenposten, Taunka'le, Unu'pe, Moa'ki, Kamagua
				["0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45"] = 253, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite
				["0.18:0.53:0.29:0.46:0.45:0.49:0.48:0.56"] = 230, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard
				["0.18:0.53:0.29:0.46:0.45:0.49:0.49:0.42"] = 229, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Moa'ki
				["0.18:0.53:0.24:0.60:0.52:0.62:0.62:0.64"] = 296, -- Bor'gorok Outpost, River's Heart, Dalaran, K3
				["0.18:0.53:0.18:0.60"] = 48, -- Bor'gorok Outpost, Nesingwary Base Camp
				["0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.69:0.58:0.84:0.49:0.84:0.41"] = 512, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.18:0.53:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75"] = 406, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.69:0.58"] = 359, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Light's Breach
				["0.18:0.53:0.29:0.46:0.45:0.49:0.54:0.48:0.52:0.62"] = 310, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Dalaran
				["0.18:0.53:0.29:0.46:0.29:0.43:0.49:0.42:0.52:0.62"] = 346, -- Застава Бор'горока, Деревня Таунка'ле, Уну'пе, Моа'ки, Даларан
				["0.18:0.53:0.29:0.46:0.29:0.43:0.49:0.42:0.54:0.48"] = 272, -- Bor'gorok Outpost, Taunka'le Village, Unu'pe, Moa'ki, Wyrmrest Temple
				["0.18:0.53:0.29:0.46:0.45:0.49:0.54:0.48"] = 216, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple
				["0.18:0.53:0.24:0.60:0.52:0.62:0.62:0.64:0.72:0.71"] = 396, -- Bor'goroks Außenposten, Flussnabel, Dalaran, K3, Dun Niffelem
				["0.18:0.53:0.29:0.46:0.31:0.57:0.52:0.62"] = 289, -- Bor'gorok Outpost, Taunka'le Village, Warsong Camp, Dalaran
				["0.18:0.53:0.29:0.46:0.31:0.57"] = 149, -- Bor'gorok Outpost, Taunka'le Village, Warsong Camp
				["0.18:0.53:0.24:0.60:0.31:0.57"] = 135, -- Bor'gorok Outpost, River's Heart, Warsong Camp
				["0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.84:0.41:0.95:0.37"] = 483, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp, Camp Winterhoof, Vengeance Landing
				["0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49"] = 412, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Oneqwah
				["0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79:0.57:0.79"] = 352, -- Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault, Bouldercrag's Refuge
				["0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79"] = 232, -- Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault
				["0.18:0.53:0.18:0.60:0.28:0.72"] = 138, -- Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise
				["0.18:0.53:0.29:0.46:0.29:0.43:0.49:0.42:0.59:0.45"] = 286, -- Bor'gorok Outpost, Taunka'le Village, Unu'pe, Moa'ki, Venomspite
				["0.18:0.53:0.29:0.46:0.29:0.43:0.49:0.42:0.74:0.29:0.74:0.38:0.84:0.41"] = 522, -- Bor'gorok Outpost, Taunka'le Village, Unu'pe, Moa'ki, Kamagua, Apothecary Camp, Camp Winterhoof
				["0.18:0.53:0.24:0.60:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 422, -- Bor'gorok Outpost, River's Heart, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.18:0.53:0.24:0.60:0.52:0.62:0.62:0.64:0.60:0.75"] = 371, -- Bor'gorok Outpost, River's Heart, Dalaran, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79:0.49:0.79"] = 308, -- Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault, Argent Tournament Grounds
				["0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41"] = 395, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof
				["0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.74:0.29"] = 404, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp, Kamagua
				["0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.85:0.27:0.95:0.37"] = 517, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, New Agamand, Vengeance Landing
				["0.18:0.53:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 476, -- Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak

				-- Horde: Borean Tundra: Taunka'le Village
				["0.29:0.46:0.29:0.43"] = 30, -- Taunka'le Village, Unu'pe
				["0.29:0.46:0.31:0.57"] = 72, -- Taunka'le Village, Warsong Camp
				["0.29:0.46:0.18:0.53:0.24:0.60"] = 129, -- Taunka'le Village, Bor'gorok Outpost, River's Heart
				["0.29:0.46:0.45:0.49:0.59:0.45:0.85:0.27"] = 362, -- Taunka'le Village, Agmar's Hammer, Venomspite, New Agamand
				["0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62"] = 208, -- Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran
				["0.29:0.46:0.17:0.47"] = 76, -- Taunka'le Village, Amber Ledge
				["0.29:0.46:0.18:0.53"] = 73, -- Taunka'le Village, Bor'gorok Outpost
				["0.29:0.46:0.15:0.43"] = 85, -- Taunka'le Village, Warsong Hold
				["0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.60:0.60"] = 255, -- Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, Sunreaver's Command
				["0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 392, -- Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.74:0.29"] = 328, -- Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp, Kamagua
				["0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38"] = 274, -- Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp
				["0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41"] = 319, -- Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof
				["0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 399, -- Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49"] = 335, -- Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Oneqwah
				["0.29:0.46:0.29:0.43:0.49:0.42"] = 148, -- Taunka'le Village, Unu'pe, Moa'ki
				["0.29:0.46:0.45:0.49"] = 92, -- Taunka'le Village, Agmar's Hammer
				["0.29:0.46:0.17:0.47:0.12:0.47"] = 111, -- Taunka'le Village, Amber Ledge, Transitus Shield
				["0.29:0.46:0.45:0.49:0.54:0.48"] = 139, -- Taunka'le, Agmars Hammer, Wyrmruhtempel
				["0.29:0.46:0.45:0.49:0.59:0.45"] = 177, -- Taunka'le Village, Agmar's Hammer, Venomspite
				["0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45"] = 234, -- Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold
				["0.29:0.46:0.29:0.43:0.49:0.42:0.74:0.29:0.74:0.38"] = 386, -- Taunka'le Village, Unu'pe, Moa'ki, Kamagua, Apothecary Camp
				["0.29:0.46:0.45:0.49:0.54:0.48:0.52:0.62"] = 233, -- Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Dalaran
				["0.29:0.46:0.45:0.49:0.49:0.42"] = 152, -- Taunka'le Village, Agmar's Hammer, Moa'ki
				["0.29:0.46:0.29:0.43:0.49:0.42:0.54:0.48"] = 195, -- Taunka'le Village, Unu'pe, Moa'ki, Wyrmrest Temple
				["0.29:0.46:0.45:0.49:0.59:0.45:0.85:0.27:0.74:0.29"] = 437, -- Taunka'le Village, Agmar's Hammer, Venomspite, New Agamand, Kamagua
				["0.29:0.46:0.18:0.53:0.18:0.60"] = 119, -- Taunka'le Village, Bor'gorok Outpost, Nesingwary Base Camp
				["0.29:0.46:0.29:0.43:0.49:0.42:0.59:0.45:0.74:0.38:0.84:0.41"] = 365, -- Taunka'le Village, Unu'pe, Moa'ki, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.84:0.41:0.95:0.37"] = 407, -- Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp, Camp Winterhoof, Vengeance Landing
				["0.29:0.46:0.45:0.49:0.48:0.56"] = 153, -- Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard
				["0.29:0.46:0.29:0.43:0.49:0.42:0.52:0.62"] = 269, -- Taunka'le Village, Unu'pe, Moa'ki, Dalaran
				["0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58"] = 243, -- Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch
				["0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.72:0.71"] = 354, -- Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Dun Nifflelem
				["0.29:0.46:0.29:0.43:0.49:0.42:0.59:0.45"] = 209, -- Taunka'le Village, Unu'pe, Moa'ki, Venomspite
				["0.29:0.46:0.45:0.49:0.59:0.45:0.69:0.58"] = 282, -- Taunka'le Village, Agmar's Hammer, Venomspite, Light's Breach
				["0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75:0.57:0.79"] = 366, -- Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.29:0.46:0.45:0.49:0.59:0.45:0.64:0.58:0.52:0.62"] = 326, -- Taunka'le Village, Agmar's Hammer, Venomspite, Ebon Watch, Dalaran
				["0.29:0.46:0.31:0.57:0.52:0.62"] = 212, -- Taunka'le Village, Warsong Camp, Dalaran
				["0.29:0.46:0.31:0.57:0.24:0.60"] = 148, -- Taunka'le Village, Warsong Camp, River's Heart
				["0.29:0.46:0.29:0.43:0.49:0.42:0.74:0.29:0.85:0.27"] = 394, -- Poblado Taunka'le, Unu'pe, Moa'ki, Komawa, Nuevo Agamand
				["0.29:0.46:0.29:0.43:0.49:0.42:0.74:0.29:0.85:0.27:0.95:0.37"] = 473, -- Poblado Taunka'le, Unu'pe, Moa'ki, Komawa, Nuevo Agamand, Campo Venganza
				["0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.56:0.64:0.38:0.79"] = 378, -- Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.56:0.64"] = 231, -- Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, The Argent Vanguard
				["0.29:0.46:0.31:0.57:0.38:0.79"] = 235, -- Taunka'le Village, Warsong Camp, The Shadow Vault
				["0.29:0.46:0.29:0.43:0.49:0.42:0.59:0.45:0.69:0.58"] = 315, -- Taunka'le Village, Unu'pe, Moa'ki, Venomspite, Light's Breach
				["0.29:0.46:0.45:0.49:0.49:0.42:0.52:0.62"] = 273, -- Taunka'le, Agmars Hammer, Moa'ki, Dalaran
				["0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.84:0.41"] = 334, -- Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.29:0.46:0.45:0.49:0.59:0.45:0.69:0.58:0.84:0.49"] = 387, -- Taunka'le Village, Agmar's Hammer, Venomspite, Light's Breach, Camp Oneqwah
				["0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 381, -- Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.29:0.46:0.18:0.53:0.24:0.60:0.28:0.72:0.38:0.79"] = 307, -- Taunka'le Village, Bor'gorok Outpost, River's Heart, Death's Rise, The Shadow Vault
				["0.29:0.46:0.31:0.57:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 383, -- Taunka'le Village, Warsong Camp, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.29:0.46:0.45:0.49:0.48:0.56:0.64:0.58"] = 259, -- Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Ebon Watch
				["0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64"] = 255, -- Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3
				["0.29:0.46:0.29:0.43:0.49:0.42:0.74:0.29"] = 331, -- Taunka'le Village, Unu'pe, Moa'ki, Kamagua
				["0.29:0.46:0.31:0.57:0.52:0.66"] = 230, -- Taunka'le Village, Warsong Camp, Crusaders' Pinnacle
				["0.29:0.46:0.18:0.53:0.18:0.60:0.28:0.72"] = 210, -- Taunka'le, Bor'goroks Außenposten, Nesingwarys Basislager, Todesanhöhe
				["0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.56:0.64:0.38:0.79:0.57:0.79"] = 499, -- Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, The Argent Vanguard, The Shadow Vault, Bouldercrag's Refuge
				["0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75"] = 330, -- Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60"] = 306, -- Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, The Argent Stand
				["0.29:0.46:0.45:0.49:0.48:0.56:0.64:0.58:0.69:0.58"] = 303, -- Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Ebon Watch, Light's Breach
				["0.29:0.46:0.45:0.49:0.49:0.42:0.74:0.29:0.74:0.38"] = 390, -- Taunka'le Village, Agmar's Hammer, Moa'ki, Kamagua, Apothecary Camp
				["0.29:0.46:0.18:0.53:0.24:0.60:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49"] = 539, -- Taunka'le Village, Bor'gorok Outpost, River's Heart, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah
				["0.29:0.46:0.31:0.57:0.38:0.79:0.49:0.79"] = 311, -- Taunka'le Village, Warsong Camp, The Shadow Vault, Argent Tournament Grounds
				["0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.73:0.75"] = 344, -- Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Camp Tunka'lo
				["0.29:0.46:0.31:0.57:0.38:0.79:0.57:0.79"] = 355, -- Taunka'le Village, Warsong Camp, The Shadow Vault, Bouldercrag's Refuge

				-- Horde: Borean Tundra: Transitus Shield (Coldarra)
				["0.12:0.47:0.17:0.47:0.15:0.43"] = 58, -- Transitus Shield, Amber Ledge, Warsong Hold
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62"] = 216, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran
				["0.12:0.47:0.17:0.47"] = 31, -- Transitus Shield, Amber Ledge
				["0.12:0.47:0.17:0.47:0.18:0.53:0.24:0.60"] = 90, -- Transitus Shield, Amber Ledge, Bor'gorok Outpost, River's Heart
				["0.12:0.47:0.17:0.47:0.18:0.53"] = 52, -- Transitus Shield, Amber Ledge, Bor'gorok Outpost
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.73:0.75"] = 306, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Camp Tunka'lo
				["0.12:0.47:0.17:0.47:0.29:0.46:0.29:0.43"] = 97, -- Transitus Shield, Amber Ledge, Taunka'le Village, Unu'pe
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.85:0.27"] = 318, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, New Agamand
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49"] = 300, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Oneqwah
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 338, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.12:0.47:0.17:0.47:0.29:0.46"] = 78, -- Transitus Shield, Amber Ledge, Taunka'le Village
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49"] = 138, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.49:0.42"] = 178, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Moa'ki
				["0.12:0.47:0.17:0.47:0.15:0.43:0.29:0.43"] = 119, -- Transitus Shield, Amber Ledge, Warsong Hold, Unu'pe
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41"] = 370, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.12:0.47:0.17:0.47:0.15:0.43:0.29:0.43:0.49:0.42"] = 197, -- Transitus Shield, Amber Ledge, Warsong Hold, Unu'pe, Moa'ki
				["0.12:0.47:0.17:0.47:0.29:0.46:0.29:0.43:0.49:0.42"] = 176, -- Transitus Shield, Amber Ledge, Taunka'le Village, Unu'pe, Moa'ki
				["0.12:0.47:0.17:0.47:0.15:0.43:0.29:0.43:0.49:0.42:0.45:0.49"] = 239, -- Transitus Shield, Amber Ledge, Warsong Hold, Unu'pe, Moa'ki, Agmar's Hammer
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45"] = 194, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48"] = 170, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38"] = 260, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56"] = 178, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49:0.72:0.60"] = 366, -- Transitusschild, Bernsteinflöz, Taunka'le, Agmars Hammer, Gallgrimm, Burg Siegeswall, Camp Oneqwah, Argentumwache
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41"] = 289, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.85:0.27:0.95:0.37"] = 371, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, New Agamand, Vengeance Landing
				["0.12:0.47:0.17:0.47:0.29:0.46:0.29:0.43:0.49:0.42:0.59:0.45"] = 216, -- Transitus Shield, Amber Ledge, Taunka'le Village, Unu'pe, Moa'ki, Venomspite
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45"] = 233, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold
				["0.12:0.47:0.17:0.47:0.29:0.46:0.31:0.57:0.38:0.79"] = 233, -- Transitus Shield, Amber Ledge, Taunka'le Village, Warsong Camp, The Shadow Vault
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.74:0.29"] = 295, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp, Kamagua
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 343, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.12:0.47:0.17:0.47:0.18:0.53:0.24:0.60:0.52:0.62"] = 219, -- Transitus Shield, Amber Ledge, Bor'gorok Outpost, River's Heart, Dalaran
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 308, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, The Argent Stand, Zim'Torga
				["0.12:0.47:0.17:0.47:0.18:0.53:0.18:0.60"] = 83, -- Transitus Shield, Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.72:0.71"] = 313, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Dun Nifflelem
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 330, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48:0.52:0.62:0.24:0.60"] = 365, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Dalaran, River's Heart
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.56:0.64"] = 231, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, The Argent Vanguard
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.52:0.66"] = 236, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, Crusaders' Pinnacle
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64"] = 246, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48:0.52:0.62"] = 232, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Dalaran
				["0.12:0.47:0.17:0.47:0.29:0.46:0.31:0.57:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 332, -- Transitus Shield, Amber Ledge, Taunka'le Village, Warsong Camp, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.12:0.47:0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72"] = 144, -- Transitusschild, Bernsteinflöz, Bor'goroks Außenposten, Nesingwarys Basislager, Todesanhöhe
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60"] = 281, -- Bouclier Transitus, Escarpement d'Ambre, Taunka'le, Marteau d'Agmar, Temple du Repos du ver, Guet d'Ébène, Le séjour d'Argent
				["0.12:0.47:0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79"] = 206, -- Transitus Shield, Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.84:0.41"] = 299, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.69:0.58"] = 265, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Venomspite, Light's Breach
				["0.12:0.47:0.17:0.47:0.29:0.46:0.31:0.57:0.52:0.62"] = 219, -- Transitus Shield, Amber Ledge, Taunka'le Village, Warsong Camp, Dalaran
				["0.12:0.47:0.17:0.47:0.29:0.46:0.31:0.57"] = 124, -- Bouclier Transitus, Escarpement d'Ambre, Taunka'le, Camp chanteguerre
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75"] = 296, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.12:0.47:0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79:0.57:0.79:0.64:0.81"] = 316, -- Transitus Shield, Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault, Bouldercrag's Refuge, Ulduar
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.52:0.66:0.38:0.79"] = 317, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.60:0.60"] = 247, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, Sunreaver's Command
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.49:0.42:0.52:0.62"] = 259, -- Transitus Shield, Amber Ledge, Taunka'le Village, Agmar's Hammer, Moa'ki, Dalaran
				["0.12:0.47:0.17:0.47:0.18:0.53:0.24:0.60:0.28:0.72:0.38:0.79:0.57:0.79:0.64:0.81"] = 319, -- Transitus Shield, Amber Ledge, Bor'gorok Outpost, River's Heart, Death's Rise, The Shadow Vault, Bouldercrag's Refuge, Ulduar
				["0.12:0.47:0.17:0.47:0.29:0.46:0.29:0.43:0.49:0.42:0.52:0.62"] = 257, -- Transitus Shield, Amber Ledge, Taunka'le Village, Unu'pe, Moa'ki, Dalaran
				["0.12:0.47:0.17:0.47:0.29:0.46:0.31:0.57:0.24:0.60"] = 175, -- Transitus Shield, Amber Ledge, Taunka'le Village, Warsong Camp, River's Heart
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58"] = 239, -- Escudo de Tránsito, El Saliente Ámbar, Poblado Taunka'le, Martillo de Agmar, Templo del Reposo del Dragón, Puesto de Vigilancia de Ébano
				["0.12:0.47:0.17:0.47:0.29:0.46:0.31:0.57:0.38:0.79:0.57:0.79:0.64:0.81"] = 343, -- Transitus Shield, Amber Ledge, Taunka'le Village, Warsong Camp, The Shadow Vault, Bouldercrag's Refuge, Ulduar
				["0.12:0.47:0.17:0.47:0.18:0.53:0.24:0.60:0.28:0.72:0.38:0.79"] = 209, -- Transitus Shield, Amber Ledge, Bor'gorok Outpost, River's Heart, Death's Rise, The Shadow Vault
				["0.12:0.47:0.17:0.47:0.29:0.46:0.31:0.57:0.52:0.66"] = 230, -- Transitusschild, Bernsteinflöz, Taunka'le, Kriegshymnenlager, Kreuzfahrerturm
				["0.12:0.47:0.17:0.47:0.29:0.46:0.29:0.43:0.49:0.42:0.74:0.29"] = 298, -- Transitus Shield, Amber Ledge, Taunka'le Village, Unu'pe, Moa'ki, Kamagua
				["0.12:0.47:0.17:0.47:0.29:0.46:0.29:0.43:0.49:0.42:0.59:0.45:0.74:0.38:0.84:0.41:0.95:0.37"] = 370, -- Transitus Shield, Amber Ledge, Taunka'le Village, Unu'pe, Moa'ki, Venomspite, Apothecary Camp, Camp Winterhoof, Vengeance Landing
				["0.12:0.47:0.17:0.47:0.29:0.46:0.29:0.43:0.49:0.42:0.74:0.29:0.74:0.38"] = 335, -- Transitusschild, Bernsteinflöz, Taunka'le, Unu'pe, Moa'ki, Kamagua, Apothekerlager
				["0.12:0.47:0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79:0.49:0.79"] = 257, -- Transitus Shield, Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault, Argent Tournament Grounds
				["0.12:0.47:0.17:0.47:0.18:0.53:0.24:0.60:0.28:0.72:0.38:0.79:0.49:0.79"] = 259, -- Transitus Shield, Amber Ledge, Bor'gorok Outpost, River's Heart, Death's Rise, The Shadow Vault, Argent Tournament Grounds
				["0.12:0.47:0.17:0.47:0.29:0.46:0.31:0.57:0.38:0.79:0.49:0.79"] = 284, -- Transitus Shield, Amber Ledge, Taunka'le Village, Warsong Camp, The Shadow Vault, Argent Tournament Grounds
				["0.12:0.47:0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79:0.57:0.79"] = 287, -- Transitus Shield, Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault, Bouldercrag's Refuge
				["0.12:0.47:0.17:0.47:0.29:0.46:0.45:0.49:0.59:0.45:0.85:0.27:0.74:0.29"] = 368, -- Маскировочный щит, Янтарная гряда, Деревня Таунка'ле, Молот Агмара, Ядозлобь, Новый Агамонд, Камагуа

				-- Horde: Borean Tundra: Unu'pe
				["0.29:0.43:0.29:0.46"] = 22, -- Unu'pe, Taunka'le Village
				["0.29:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62"] = 230, -- Unu'pe, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran
				["0.29:0.43:0.29:0.46:0.17:0.47:0.12:0.47"] = 133, -- Unu'pe, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.29:0.43:0.15:0.43"] = 88, -- Unu'pe, Warsong Hold
				["0.29:0.43:0.49:0.42"] = 119, -- Unu'pe, Moa'ki
				["0.29:0.43:0.29:0.46:0.45:0.49"] = 113, -- Unu'pe, Taunka'le Village, Agmar's Hammer
				["0.29:0.43:0.49:0.42:0.59:0.45:0.70:0.45"] = 238, -- Unu'pe, Moa'ki, Venomspite, Conquest Hold
				["0.29:0.43:0.49:0.42:0.74:0.29:0.85:0.27"] = 364, -- Unu'pe, Moa'ki, Kamagua, New Agamand
				["0.29:0.43:0.49:0.42:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 395, -- Unu'pe, Moa'ki, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.29:0.43:0.49:0.42:0.74:0.29"] = 302, -- Unu'pe, Moa'ki, Kamagua
				["0.29:0.43:0.49:0.42:0.59:0.45:0.74:0.38"] = 277, -- Unu'pe, Moa'ki, Venomspite, Apothecary Camp
				["0.29:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64"] = 275, -- Unu'pe, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3
				["0.29:0.43:0.49:0.42:0.59:0.45:0.69:0.58"] = 285, -- Unu'pe, Moa'ki, Venomspite, Light's Breach
				["0.29:0.43:0.49:0.42:0.59:0.45:0.70:0.45:0.84:0.41"] = 322, -- Unu'pe, Moa'ki, Venomspite, Conquest Hold, Camp Winterhoof
				["0.29:0.43:0.49:0.42:0.59:0.45:0.70:0.45:0.84:0.49"] = 339, -- Unu'pe, Moa'ki, Venomspite, Conquest Hold, Camp Oneqwah
				["0.29:0.43:0.49:0.42:0.59:0.45:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 419, -- Unu'pe, Moa'ki, Venomspite, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.29:0.43:0.29:0.46:0.17:0.47"] = 97, -- Unu'pe, Taunka'le Village, Amber Ledge
				["0.29:0.43:0.29:0.46:0.18:0.53"] = 94, -- Unu'pe, Taunka'le Village, Bor'gorok Outpost
				["0.29:0.43:0.49:0.42:0.59:0.45"] = 179, -- Unu'pe, Moa'ki, Venomspite
				["0.29:0.43:0.15:0.43:0.17:0.47"] = 124, -- Unu'pe, Warsong Hold, Amber Ledge
				["0.29:0.43:0.49:0.42:0.74:0.29:0.85:0.27:0.84:0.41"] = 444, -- Unu'pe, Moa'ki, Kamagua, New Agamand, Camp Winterhoof
				["0.29:0.43:0.29:0.46:0.45:0.49:0.54:0.48"] = 161, -- Unu'pe, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple
				["0.29:0.43:0.49:0.42:0.59:0.45:0.69:0.58:0.72:0.60"] = 328, -- Unu'pe, Moa'ki, Venomspite, Light's Breach, The Argent Stand
				["0.29:0.43:0.29:0.46:0.31:0.57:0.52:0.62"] = 234, -- Unu'pe, Taunka'le Village, Warsong Camp, Dalaran
				["0.29:0.43:0.29:0.46:0.18:0.53:0.24:0.60"] = 150, -- Unu'pe, Taunka'le Village, Bor'gorok Outpost, River's Heart
				["0.29:0.43:0.29:0.46:0.45:0.49:0.48:0.56"] = 174, -- Unu'pe, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard
				["0.29:0.43:0.49:0.42:0.59:0.45:0.64:0.58"] = 261, -- Unu'pe, Moa'ki, Venomspite, Ebon Watch
				["0.29:0.43:0.49:0.42:0.59:0.45:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 365, -- Unu'pe, Moa'ki, Venomspite, Ebon Watch, The Argent Stand, Zim'Torga
				["0.29:0.43:0.49:0.42:0.59:0.45:0.64:0.58:0.72:0.60"] = 325, -- Unu'pe, Moa'ki, Gallgrimm, Schwarze Wacht, Argentumwache
				["0.29:0.43:0.49:0.42:0.52:0.62:0.24:0.60"] = 438, -- Unu'pe, Moa'ki, Dalaran, Flussnabel
				["0.29:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.72:0.71"] = 376, -- Unu'pe, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Dun Nifflelem
				["0.29:0.43:0.29:0.46:0.31:0.57:0.24:0.60"] = 169, -- Unu'pe, Taunka'le Village, Warsong Camp, River's Heart
				["0.29:0.43:0.29:0.46:0.31:0.57"] = 92, -- Unu'pe, Taunka'le Village, Warsong Camp
				["0.29:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.60:0.60"] = 276, -- Unu'pe, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, Sunreaver's Command
				["0.29:0.43:0.49:0.42:0.52:0.62"] = 239, -- Unu'pe, Moa'ki, Dalaran
				["0.29:0.43:0.29:0.46:0.31:0.57:0.52:0.62:0.62:0.64:0.72:0.71"] = 379, -- Unu'pe, Taunka'le Village, Warsong Camp, Dalaran, K3, Dun Nifflelem
				["0.29:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.56:0.64:0.38:0.79"] = 399, -- Unu'pe, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.29:0.43:0.49:0.42:0.52:0.62:0.62:0.64:0.60:0.75"] = 358, -- Unu'pe, Moa'ki, Dalaran, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.29:0.43:0.15:0.43:0.17:0.47:0.18:0.53:0.24:0.60"] = 211, -- Unu'pe, Bastion Chanteguerre, Escarpement d'Ambre, Avant-poste Bor'gorok, Le Cœur du fleuve
				["0.29:0.43:0.29:0.46:0.45:0.49:0.59:0.45"] = 198, -- Unu'pe, Taunka'le Village, Agmar's Hammer, Venomspite
				["0.29:0.43:0.49:0.42:0.59:0.45:0.74:0.38:0.84:0.41"] = 336, -- Unu'pe, Moa'ki, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.29:0.43:0.49:0.42:0.54:0.48:0.48:0.56"] = 232, -- Unu'pe, Moa'ki, Wyrmrest Temple, Kor'koron Vanguard
				["0.29:0.43:0.29:0.46:0.18:0.53:0.18:0.60"] = 141, -- Unu'pe, Taunka'le Village, Bor'gorok Outpost, Nesingwary Base Camp
				["0.29:0.43:0.29:0.46:0.31:0.57:0.38:0.79"] = 256, -- Unu'pe, Taunka'le Village, Warsong Camp, The Shadow Vault
				["0.29:0.43:0.29:0.46:0.31:0.57:0.28:0.72"] = 205, -- Unu'pe, Taunka'le Village, Warsong Camp, Death's Rise
				["0.29:0.43:0.29:0.46:0.31:0.57:0.38:0.79:0.49:0.79"] = 332, -- Unu'pe, Taunka'le, Kriegshymnenlager, Das Schattengewölbe, Argentumturnierplatz
				["0.29:0.43:0.49:0.42:0.52:0.62:0.49:0.79"] = 353, -- Unu'pe, Moa'ki, Dalaran, Argentumturnierplatz
				["0.29:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 402, -- Unu'pe, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.29:0.43:0.29:0.46:0.31:0.57:0.38:0.79:0.57:0.79"] = 377, -- Unu'pe, Taunka'le Village, Warsong Camp, The Shadow Vault, Bouldercrag's Refuge
				["0.29:0.43:0.29:0.46:0.31:0.57:0.52:0.66"] = 252, -- Unu'pe, Taunka'le Village, Warsong Camp, Crusaders' Pinnacle
				["0.29:0.43:0.49:0.42:0.59:0.45:0.64:0.58:0.60:0.60"] = 288, -- Unu'pe, Moa'ki, Venomspite, Ebon Watch, Sunreaver's Command
				["0.29:0.43:0.29:0.46:0.31:0.57:0.52:0.62:0.62:0.64"] = 279, -- Unu'pe, Taunka'le Village, Warsong Camp, Dalaran, K3
				["0.29:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38"] = 296, -- Unu'pe, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp
				["0.29:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75"] = 351, -- Unu'pe, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.29:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.56:0.64"] = 253, -- Unu'pe, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, The Argent Vanguard

				-- Horde: Borean Tundra: Warsong Hold
				["0.15:0.43:0.29:0.43:0.49:0.42:0.74:0.29"] = 394, -- Warsong Hold, Unu'pe, Moa'ki, Kamagua
				["0.15:0.43:0.17:0.47:0.12:0.47"] = 72, -- Warsong Hold, Amber Ledge, Transitus Shield (Ryandi Tjia reported 125)
				["0.15:0.43:0.18:0.53"] = 69, -- Warsong Hold, Bor'gorok Outpost
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62"] = 294, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran
				["0.15:0.43:0.17:0.47"] = 36, -- Warsong Hold, Amber Ledge
				["0.15:0.43:0.17:0.47:0.18:0.53:0.24:0.60"] = 125, -- Warsong Hold, Amber Ledge, Bor'gorok Outpost, River's Heart
				["0.15:0.43:0.29:0.46"] = 87, -- Warsong Hold, Taunka'le Village
				["0.15:0.43:0.29:0.43"] = 93, -- Warsong Hold, Unu'pe
				["0.15:0.43:0.29:0.46:0.31:0.57"] = 157, -- Warsong Hold, Taunka'le Village, Warsong Camp
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.85:0.27"] = 448, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, New Agamand
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 478, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.15:0.43:0.29:0.46:0.45:0.49"] = 177, -- Warsong Hold, Taunka'le Village, Agmar's Hammer
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.84:0.41:0.95:0.37"] = 493, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp, Camp Winterhoof, Vengeance Landing
				["0.15:0.43:0.29:0.43:0.49:0.42:0.74:0.29:0.85:0.27:0.84:0.41"] = 536, -- Warsong Hold, Unu'pe, Moa'ki, Kamagua, New Agamand, Camp Winterhoof
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45"] = 263, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48"] = 226, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.85:0.27:0.95:0.37"] = 526, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, New Agamand, Vengeance Landing
				["0.15:0.43:0.29:0.43:0.49:0.42"] = 210, -- Warsong Hold, Unu'pe, Moa'ki
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45"] = 320, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49"] = 421, -- Kriegshymnenfeste, Taunka'le, Agmars Hammer, Gallgrimm, Burg Siegeswall, Camp Oneqwah
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48:0.52:0.62"] = 319, -- Kriegshymnenfeste, Taunka'le, Agmars Hammer, Wyrmruhtempel, Dalaran
				["0.15:0.43:0.29:0.43:0.49:0.42:0.74:0.29:0.85:0.27"] = 456, -- Warsong Hold, Unu'pe, Moa'ki, Kamagua, New Agamand
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56"] = 239, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58"] = 329, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch
				["0.15:0.43:0.29:0.43:0.49:0.42:0.59:0.45:0.70:0.45"] = 330, -- Kriegshymnenfeste, Unu'pe, Moa'ki, Gallgrimm, Burg Siegeswall
				["0.15:0.43:0.17:0.47:0.18:0.53:0.18:0.60"] = 116, -- Warsong Hold, Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp
				["0.15:0.43:0.29:0.46:0.45:0.49:0.49:0.42"] = 238, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Moa'ki
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.56:0.64"] = 317, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, The Argent Vanguard
				["0.15:0.43:0.29:0.43:0.49:0.42:0.52:0.62"] = 332, -- Warsong Hold, Unu'pe, Moa'ki, Dalaran
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41"] = 405, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.69:0.58"] = 368, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, Light's Breach
				["0.15:0.43:0.29:0.43:0.49:0.42:0.74:0.29:0.85:0.27:0.95:0.37"] = 536, -- Warsong Hold, Unu'pe, Moa'ki, Kamagua, New Agamand, Vengeance Landing
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60"] = 392, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, The Argent Stand
				["0.15:0.43:0.29:0.43:0.49:0.42:0.54:0.48:0.48:0.56"] = 324, -- Warsong Hold, Unu'pe, Moa'ki, Wyrmrest Temple, Kor'koron Vanguard
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75"] = 415, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.15:0.43:0.29:0.43:0.49:0.42:0.59:0.45:0.64:0.58"] = 354, -- Warsong Hold, Unu'pe, Moa'ki, Venomspite, Ebon Watch
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 432, -- Bastion Chanteguerre, Taunka'le, Marteau d'Agmar, Temple du Repos du ver, Guet d'Ébène, Le séjour d'Argent, Zim'Torga
				["0.15:0.43:0.29:0.46:0.31:0.57:0.52:0.66"] = 317, -- Kriegshymnenfeste, Taunka'le, Kriegshymnenlager, Kreuzfahrerturm
				["0.15:0.43:0.29:0.46:0.31:0.57:0.52:0.62"] = 298, -- Warsong Hold, Taunka'le Village, Warsong Camp, Dalaran
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38"] = 360, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp
				["0.15:0.43:0.29:0.43:0.49:0.42:0.59:0.45"] = 271, -- Warsong Hold, Unu'pe, Moa'ki, Venomspite
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48:0.52:0.62:0.52:0.66"] = 346, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Dalaran, Crusaders' Pinnacle
				["0.15:0.43:0.17:0.47:0.18:0.53:0.24:0.60:0.28:0.72:0.38:0.79"] = 303, -- Warsong Hold, Amber Ledge, Bor'gorok Outpost, River's Heart, Death's Rise, The Shadow Vault
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64"] = 340, -- Kriegshymnenfeste, Taunka'le, Agmars Hammer, Vorposten der Kor'kron, Dalaran, K3
				["0.15:0.43:0.29:0.43:0.49:0.42:0.59:0.45:0.74:0.38:0.84:0.41"] = 428, -- Warsong Hold, Unu'pe, Moa'ki, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.73:0.75"] = 430, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Camp Tunka'lo
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.72:0.71"] = 440, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Dun Nifflelem
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75:0.57:0.79"] = 452, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.74:0.29"] = 413, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp, Kamagua
				["0.15:0.43:0.17:0.47:0.18:0.53:0.24:0.60:0.52:0.62"] = 319, -- Warsong Hold, Amber Ledge, Bor'gorok Outpost, River's Heart, Dalaran
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.84:0.41:0.84:0.49"] = 476, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp, Camp Winterhoof, Camp Oneqwah
				["0.15:0.43:0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72"] = 207, -- Warsong Hold, Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise
				["0.15:0.43:0.29:0.46:0.45:0.49:0.49:0.42:0.52:0.62"] = 358, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Moa'ki, Dalaran
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48:0.52:0.62:0.62:0.64"] = 363, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Dalaran, K3
				["0.15:0.43:0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79:0.57:0.79:0.64:0.81"] = 465, -- Warsong Hold, Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault, Bouldercrag's Refuge, Ulduar
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 485, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.60:0.60"] = 341, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, Sunreaver's Command
				["0.15:0.43:0.18:0.53:0.24:0.60"] = 125, -- Warsong Hold, Bor'gorok Outpost, River's Heart
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48:0.52:0.62:0.62:0.64:0.72:0.71"] = 463, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Dalaran, K3, Dun Nifflelem
				["0.15:0.43:0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79"] = 299, -- Warsong Hold, Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.84:0.41"] = 419, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.15:0.43:0.17:0.47:0.18:0.53:0.24:0.60:0.28:0.72"] = 210, -- Warsong Hold, Amber Ledge, Bor'gorok Outpost, River's Heart, Death's Rise
				["0.15:0.43:0.17:0.47:0.18:0.53:0.24:0.60:0.52:0.62:0.48:0.56:0.45:0.49"] = 431, -- Warsong Hold, Amber Ledge, Bor'gorok Outpost, River's Heart, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.15:0.43:0.18:0.53:0.24:0.60:0.52:0.62:0.62:0.64"] = 365, -- Warsong Hold, Bor'gorok Outpost, River's Heart, Dalaran, K3
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.60:0.60"] = 355, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, Sunreaver's Command
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.69:0.58:0.70:0.45"] = 447, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, Light's Breach, Conquest Hold
				["0.15:0.43:0.29:0.46:0.31:0.57:0.24:0.60:0.18:0.60"] = 269, -- Bastion Chanteguerre, Taunka'le, Camp chanteguerre, Le Cœur du fleuve, Camp de base de Nesingwary
				["0.15:0.43:0.29:0.46:0.31:0.57:0.24:0.60"] = 234, -- Warsong Hold, Taunka'le Village, Warsong Camp, River's Heart
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.85:0.27:0.84:0.41:0.84:0.49"] = 581, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, New Agamand, Camp Winterhoof, Camp Oneqwah
				["0.15:0.43:0.29:0.43:0.49:0.42:0.45:0.49"] = 274, -- Warsong Hold, Unu'pe, Moa'ki, Agmar's Hammer
				["0.15:0.43:0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79:0.57:0.79"] = 420, -- Warsong Hold, Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault, Bouldercrag's Refuge
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.24:0.60:0.18:0.60"] = 530, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, River's Heart, Nesingwary Base Camp
				["0.15:0.43:0.29:0.43:0.49:0.42:0.59:0.45:0.70:0.45:0.84:0.49"] = 431, -- Kriegshymnenfeste, Unu'pe, Moa'ki, Gallgrimm, Burg Siegeswall, Camp Oneqwah
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.56:0.64:0.60:0.75"] = 419, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49:0.95:0.37"] = 526, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Oneqwah, Vengeance Landing
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.52:0.66:0.38:0.79"] = 446, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.15:0.43:0.29:0.43:0.49:0.42:0.74:0.29:0.74:0.38:0.84:0.41"] = 508, -- Warsong Hold, Unu'pe, Moa'ki, Kamagua, Apothecary Camp, Camp Winterhoof
				["0.15:0.43:0.29:0.43:0.49:0.42:0.52:0.62:0.62:0.64:0.73:0.75"] = 466, -- Warsong Hold, Unu'pe, Moa'ki, Dalaran, K3, Camp Tunka'lo
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.64:0.58"] = 344, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, Ebon Watch
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.52:0.66"] = 324, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, Crusaders' Pinnacle
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.85:0.27"] = 612, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, New Agamand
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.64:0.58:0.52:0.62"] = 411, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, Ebon Watch, Dalaran
				["0.15:0.43:0.29:0.46:0.45:0.49:0.59:0.45:0.69:0.58:0.72:0.60"] = 410, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Venomspite, Light's Breach, The Argent Stand
				["0.15:0.43:0.29:0.46:0.45:0.49:0.49:0.42:0.74:0.29:0.85:0.27:0.95:0.37"] = 563, -- Bastion Chanteguerre, Taunka'le, Marteau d'Agmar, Moa'ki, Kamagua, Nouvelle-Agamand, Accostage de la Vengeance
				["0.15:0.43:0.29:0.46:0.31:0.57:0.38:0.79:0.49:0.79"] = 396, -- Warsong Hold, Taunka'le Village, Warsong Camp, The Shadow Vault, Argent Tournament Grounds
				["0.15:0.43:0.29:0.46:0.31:0.57:0.38:0.79:0.57:0.79"] = 441, -- Warsong Hold, Taunka'le Village, Warsong Camp, The Shadow Vault, Bouldercrag's Refuge
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48:0.52:0.62:0.49:0.79"] = 433, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.15:0.43:0.29:0.43:0.49:0.42:0.59:0.45:0.74:0.38:0.84:0.41:0.95:0.37"] = 501, -- Warsong Hold, Unu'pe, Moa'ki, Venomspite, Apothecary Camp, Camp Winterhoof, Vengeance Landing
				["0.15:0.43:0.17:0.47:0.18:0.53:0.18:0.60:0.28:0.72:0.38:0.79:0.49:0.79"] = 375, -- Warsong Hold, Amber Ledge, Bor'gorok Outpost, Nesingwary Base Camp, Death's Rise, The Shadow Vault, Argent Tournament Grounds
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 467, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.15:0.43:0.17:0.47:0.18:0.53:0.24:0.60:0.28:0.72:0.38:0.79:0.49:0.79"] = 379, -- Warsong Hold, Amber Ledge, Bor'gorok Outpost, River's Heart, Death's Rise, The Shadow Vault, Argent Tournament Grounds
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 489, -- Bastion Chanteguerre, Taunka'le, Marteau d'Agmar, Temple du Repos du ver, Dalaran, K3, Point d'impact de Grom'arsh, Ulduar
				["0.15:0.43:0.29:0.46:0.45:0.49:0.48:0.56:0.52:0.62:0.49:0.79"] = 409, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard, Dalaran, Argent Tournament Grounds
				["0.15:0.43:0.29:0.46:0.31:0.57:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 469, -- Warsong Hold, Taunka'le Village, Warsong Camp, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.15:0.43:0.17:0.47:0.18:0.53:0.24:0.60:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 489, -- Warsong Hold, Amber Ledge, Bor'gorok Outpost, River's Heart, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48:0.52:0.62:0.56:0.64"] = 341, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Dalaran, The Argent Vanguard
				["0.15:0.43:0.17:0.47:0.18:0.53:0.24:0.60:0.52:0.62:0.56:0.64"] = 340, -- Warsong Hold, Amber Ledge, Bor'gorok Outpost, River's Heart, Dalaran, The Argent Vanguard
				["0.15:0.43:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 516, -- Warsong Hold, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, The Argent Stand, Zim'Torga, Dun Nifflelem

				----------------------------------------------------------------------
				-- Horde: Crystalsong Forest
				----------------------------------------------------------------------

				-- Horde: Crystalsong Forest: Sunreaver's Command
				["0.60:0.60:0.52:0.62"] = 56, -- Sunreaver's Command, Dalaran
				["0.60:0.60:0.64:0.58"] = 38, -- Sunreaver's Command, Ebon Watch
				["0.60:0.60:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38"] = 213, -- Sunreaver's Command, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp
				["0.60:0.60:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.85:0.27"] = 305, -- Sunreaver's Command, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, New Agamand
				["0.60:0.60:0.52:0.62:0.48:0.56"] = 116, -- Sunreaver's Command, Dalaran, Kor'koron Vanguard
				["0.60:0.60:0.52:0.62:0.31:0.57"] = 205, -- Sunreaver's Command, Dalaran, Warsong Camp
				["0.60:0.60:0.64:0.58:0.54:0.48:0.45:0.49"] = 197, -- Sunreaver's Command, Ebon Watch, Wyrmrest Temple, Agmar's Hammer
				["0.60:0.60:0.52:0.62:0.49:0.42"] = 203, -- Sunreaver's Command, Dalaran, Moa'ki
				["0.60:0.60:0.52:0.62:0.56:0.64"] = 78, -- Sunreaver's Command, Dalaran, The Argent Vanguard
				["0.60:0.60:0.62:0.64"] = 34, -- Sunreaver's Command, K3
				["0.60:0.60:0.64:0.58:0.69:0.58"] = 83, -- Sonnenhäschers Schar, Schwarze Wacht, Lichtbresche
				["0.60:0.60:0.64:0.58:0.69:0.58:0.70:0.45"] = 157, -- Sunreaver's Command, Ebon Watch, Light's Breach, Conquest Hold
				["0.60:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46"] = 307, -- Sunreaver's Command, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.60:0.60:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41"] = 235, -- Sunreaver's Command, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.60:0.60:0.64:0.58:0.59:0.45"] = 137, -- Sunreaver's Command, Ebon Watch, Venomspite
				["0.60:0.60:0.52:0.62:0.54:0.48:0.59:0.45:0.70:0.45"] = 273, -- Sunreaver's Command, Dalaran, Wyrmrest Temple, Venomspite, Conquest Hold
				["0.60:0.60:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 196, -- Sunreaver's Command, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.60:0.60:0.64:0.58:0.54:0.48"] = 129, -- Sunreaver's Command, Ebon Watch, Wyrmrest Temple
				["0.60:0.60:0.64:0.58:0.69:0.58:0.84:0.49"] = 187, -- Sunreaver's Command, Ebon Watch, Light's Breach, Camp Oneqwah
				["0.60:0.60:0.52:0.62:0.48:0.56:0.45:0.49"] = 169, -- Sunreaver's Command, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.60:0.60:0.64:0.58:0.69:0.58:0.84:0.49:0.95:0.37"] = 293, -- Sunreaver's Command, Ebon Watch, Light's Breach, Camp Oneqwah, Vengeance Landing
				["0.60:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 379, -- Dominio de los Atracasol, Puesto de Vigilancia de Ébano, Templo del Reposo del Dragón, Martillo de Agmar, Poblado Taunka'le, Avanzada Bor'gorok
				["0.60:0.60:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 267, -- Sunreaver's Command, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.60:0.60:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.15:0.43"] = 363, -- Sunreaver's Command, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.60:0.60:0.62:0.64:0.60:0.75:0.64:0.81"] = 160, -- Quartier général de Saccage-soleil, K3, Point d'impact de Grom'arsh, Ulduar
				["0.60:0.60:0.52:0.62:0.24:0.60"] = 255, -- Sunreaver's Command, Dalaran, River's Heart
				["0.60:0.60:0.62:0.64:0.72:0.71"] = 134, -- Sunreaver's Command, K3, Dun Nifflelem
				["0.60:0.60:0.52:0.62:0.24:0.60:0.18:0.60"] = 290, -- Sunreaver's Command, Dalaran, River's Heart, Nesingwary Base Camp
				["0.60:0.60:0.52:0.62:0.56:0.64:0.38:0.79:0.28:0.72"] = 301, -- Sunreaver's Command, Dalaran, The Argent Vanguard, The Shadow Vault, Death's Rise
				["0.60:0.60:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.29:0.43"] = 309, -- Sunreaver's Command, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Unu'pe
				["0.60:0.60:0.52:0.62:0.48:0.56:0.59:0.45"] = 206, -- Sunreaver's Command, Dalaran, Kor'koron Vanguard, Venomspite
				["0.60:0.60:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 143, -- Quartier général de Saccage-soleil, Guet d'Ébène, Le séjour d'Argent, Zim'Torga
				["0.60:0.60:0.64:0.58:0.72:0.60"] = 102, -- Sunreaver's Command, Ebon Watch, The Argent Stand
				["0.60:0.60:0.52:0.62:0.54:0.48:0.45:0.49"] = 233, -- Sunreaver's Command, Dalaran, Wyrmrest Temple, Agmar's Hammer
				["0.60:0.60:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.18:0.53"] = 351, -- Sunreaver's Command, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.60:0.60:0.64:0.58:0.59:0.45:0.85:0.27"] = 322, -- Sunreaver's Command, Ebon Watch, Venomspite, New Agamand
				["0.60:0.60:0.64:0.58:0.59:0.45:0.74:0.38:0.84:0.41"] = 294, -- Sonnenhäschers Schar, Schwarze Wacht, Gallgrimm, Apothekerlager, Lager der Winterhufe
				["0.60:0.60:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 390, -- Sunreaver's Command, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.60:0.60:0.52:0.62:0.49:0.79"] = 170, -- Sunreaver's Command, Dalaran, Argent Tournament Grounds
				["0.60:0.60:0.62:0.64:0.60:0.75"] = 109, -- Sunreaver's Command, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.60:0.60:0.64:0.58:0.59:0.45:0.70:0.45"] = 196, -- Sunreaver's Command, Ebon Watch, Venomspite, Conquest Hold
				["0.60:0.60:0.64:0.58:0.59:0.45:0.85:0.27:0.84:0.41"] = 401, -- Sunreaver's Command, Ebon Watch, Venomspite, New Agamand, Camp Winterhoof
				["0.60:0.60:0.64:0.58:0.59:0.45:0.70:0.45:0.84:0.49"] = 297, -- Sunreaver's Command, Ebon Watch, Venomspite, Conquest Hold, Camp Oneqwah
				["0.60:0.60:0.64:0.58:0.59:0.45:0.70:0.45:0.84:0.41"] = 279, -- Sunreaver's Command, Ebon Watch, Venomspite, Conquest Hold, Camp Winterhoof
				["0.60:0.60:0.64:0.58:0.59:0.45:0.74:0.38"] = 234, -- Sunreaver's Command, Ebon Watch, Venomspite, Apothecary Camp
				["0.60:0.60:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46"] = 279, -- Sonnenhäschers Schar, Dalaran, Vorposten der Kor'kron, Agmars Hammer, Taunka'le
				["0.60:0.60:0.64:0.58:0.69:0.58:0.70:0.45:0.84:0.41"] = 240, -- Sunreaver's Command, Ebon Watch, Light's Breach, Conquest Hold, Camp Winterhoof
				["0.60:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 391, -- Sunreaver's Command, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.60:0.60:0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.41"] = 349, -- Sunreaver's Command, Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold, Camp Winterhoof
				["0.60:0.60:0.52:0.62:0.24:0.60:0.18:0.53"] = 309, -- Sunreaver's Command, Dalaran, River's Heart, Bor'gorok Outpost
				["0.60:0.60:0.52:0.62:0.54:0.48"] = 166, -- Sunreaver's Command, Dalaran, Wyrmrest Temple
				["0.60:0.60:0.52:0.62:0.52:0.66:0.38:0.79"] = 205, -- Sunreaver's Command, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.60:0.60:0.52:0.62:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 427, -- Sunreaver's Command, Dalaran, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.60:0.60:0.52:0.62:0.54:0.48:0.59:0.45:0.74:0.38:0.84:0.41"] = 371, -- Sunreaver's Command, Dalaran, Wyrmrest Temple, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.60:0.60:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47"] = 354, -- Sunreaver's Command, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.60:0.60:0.52:0.62:0.52:0.66"] = 84, -- Sunreaver's Command, Dalaran, Crusaders' Pinnacle

				----------------------------------------------------------------------
				-- Horde: Dalaran
				----------------------------------------------------------------------

				-- Horde: Dalaran
				["0.52:0.62:0.56:0.64"] = 33, -- Dalaran, The Argent Vanguard
				["0.52:0.62:0.62:0.64"] = 55, -- Dalaran, K3
				["0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.85:0.27"] = 348, -- Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, New Agamand
				["0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 310, -- Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 186, -- Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.52:0.62:0.48:0.56"] = 73, -- Dalaran, Kor'koron Vanguard
				["0.52:0.62:0.52:0.66"] = 40, -- Dalaran, Crusaders' Pinnacle
				["0.52:0.62:0.60:0.60"] = 57, -- Dalaran, Sunreaver's Command
				["0.52:0.62:0.64:0.58"] = 81, -- Dalaran, Ebon Watch
				["0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38"] = 257, -- Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp
				["0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41"] = 279, -- Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.52:0.62:0.49:0.42"] = 160, -- Dalaran, Moa'ki
				["0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.95:0.37"] = 336, -- Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Vengeance Landing
				["0.52:0.62:0.48:0.56:0.45:0.49"] = 125, -- Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45"] = 200, -- Dalaran, Ebon Watch, Light's Breach, Conquest Hold
				["0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.29:0.43"] = 266, -- Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Unu'pe
				["0.52:0.62:0.54:0.48"] = 122, -- Dalaran, Wyrmrest Temple
				["0.52:0.62:0.48:0.56:0.59:0.45"] = 163, -- Dalaran, Kor'koron Vanguard, Venomspite
				["0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46"] = 236, -- Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village
				["0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49"] = 231, -- Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah
				["0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47"] = 311, -- Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.52:0.62:0.64:0.58:0.72:0.60"] = 145, -- Dalaran, Ebon Watch, The Argent Stand
				["0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.15:0.43"] = 320, -- Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 347, -- Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.52:0.62:0.24:0.60:0.18:0.53"] = 265, -- Dalaran, River's Heart, Bor'gorok Outpost (xDontPanic42x reported 298)
				["0.52:0.62:0.24:0.60"] = 212, -- Dalaran, River's Heart
				["0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 239, -- Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.52:0.62:0.64:0.58:0.69:0.58"] = 126, -- Dalaran, Ebon Watch, Light's Breach
				["0.52:0.62:0.62:0.64:0.73:0.75"] = 145, -- Dalaran, K3, Camp Tunka'lo
				["0.52:0.62:0.62:0.64:0.60:0.75"] = 130, -- Dalaran, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.52:0.62:0.31:0.57"] = 161, -- Dalaran, Warsong Camp
				["0.52:0.62:0.52:0.66:0.28:0.72"] = 207, -- Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.52:0.62:0.31:0.57:0.29:0.46"] = 241, -- Dalaran, Warsong Camp, Taunka'le Village
				["0.52:0.62:0.48:0.56:0.59:0.45:0.69:0.58"] = 269, -- Dalaran, Kor'koron Vanguard, Venomspite, Light's Breach
				["0.52:0.62:0.48:0.56:0.59:0.45:0.85:0.27:0.95:0.37"] = 427, -- Dalaran, Kor'koron Vanguard, Venomspite, New Agamand, Vengeance Landing
				["0.52:0.62:0.54:0.48:0.45:0.49"] = 188, -- Dalaran, Wyrmrest Temple, Agmar's Hammer
				["0.52:0.62:0.54:0.48:0.59:0.45:0.85:0.27"] = 356, -- Dalaran, Wyrmrest Temple, Venomspite, New Agamand
				["0.52:0.62:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 374, -- Dalaran, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.52:0.62:0.48:0.56:0.59:0.45:0.85:0.27:0.74:0.29"] = 423, -- Dalaran, Kor'koron Vanguard, Venomspite, New Agamand, Kamagua
				["0.52:0.62:0.54:0.48:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 386, -- Dalaran, Wyrmrest Temple, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.52:0.62:0.48:0.56:0.59:0.45:0.85:0.27"] = 348, -- Dalaran, Kor'koron Vanguard, Venomspite, New Agamand
				["0.52:0.62:0.54:0.48:0.59:0.45"] = 170, -- Dalaran, Wyrmrest Temple, Venomspite
				["0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45"] = 222, -- Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold
				["0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.49"] = 323, -- Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold, Camp Oneqwah
				["0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41:0.85:0.27"] = 359, -- Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof, New Agamand
				["0.52:0.62:0.49:0.42:0.29:0.43:0.15:0.43:0.17:0.47"] = 411, -- Dalaran, Moa'ki, Unu'pe, Warsong Hold, Amber Ledge
				["0.52:0.62:0.54:0.48:0.59:0.45:0.74:0.38:0.74:0.29"] = 321, -- Dalaran, Wyrmrest Temple, Venomspite, Apothecary Camp, Kamagua
				["0.52:0.62:0.49:0.42:0.45:0.49"] = 221, -- Dalaran, Moa'ki, Agmar's Hammer
				["0.52:0.62:0.54:0.48:0.59:0.45:0.74:0.38"] = 268, -- Dalaran, Wyrmrest Temple, Venomspite, Apothecary Camp
				["0.52:0.62:0.48:0.56:0.59:0.45:0.74:0.38:0.84:0.41"] = 320, -- Dalaran, Kor'koron Vanguard, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.52:0.62:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 409, -- Dalaran, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.52:0.62:0.54:0.48:0.59:0.45:0.70:0.45:0.84:0.41"] = 313, -- Dalaran, Wyrmrest Temple, Venomspite, Conquest Hold, Camp Winterhoof
				["0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 379, -- Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 181, -- Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.52:0.62:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 383, -- Dalaran, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.52:0.62:0.24:0.60:0.18:0.53:0.29:0.46"] = 342, -- Dalaran, River's Heart, Bor'gorok Outpost, Taunka'le Village
				["0.52:0.62:0.49:0.42:0.59:0.45:0.70:0.45"] = 277, -- Dalaran, Moa'ki, Venomspite, Conquest Hold
				["0.52:0.62:0.54:0.48:0.59:0.45:0.70:0.45:0.84:0.49:0.72:0.60"] = 428, -- Dalaran, Wyrmrest Temple, Venomspite, Conquest Hold, Camp Oneqwah, The Argent Stand
				["0.52:0.62:0.49:0.42:0.74:0.29:0.85:0.27"] = 404, -- Dalaran, Moa'ki, Kamagua, New Agamand
				["0.52:0.62:0.49:0.42:0.59:0.45:0.70:0.45:0.84:0.41"] = 361, -- Dalaran, Moa'ki, Venomspite, Conquest Hold, Camp Winterhoof
				["0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 339, -- Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Ulduar
				["0.52:0.62:0.24:0.60:0.18:0.60"] = 247, -- Dalaran, River's Heart, Nesingwary Base Camp
				["0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.18:0.53"] = 308, -- Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.52:0.62:0.54:0.48:0.59:0.45:0.70:0.45:0.84:0.49:0.78:0.62:0.78:0.61"] = 421, -- Dalaran, Wyrmrest Temple, Venomspite, Conquest Hold, Camp Oneqwah, Zim'Torga
				["0.52:0.62:0.54:0.48:0.59:0.45:0.70:0.45"] = 229, -- Dalaran, Wyrmrest Temple, Venomspite, Conquest Hold
				["0.52:0.62:0.54:0.48:0.59:0.45:0.69:0.58:0.72:0.60"] = 319, -- Dalaran, Wyrmrest Temple, Venomspite, Light's Breach, The Argent Stand
				["0.52:0.62:0.54:0.48:0.45:0.49:0.29:0.46"] = 299, -- Dalaran, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.52:0.62:0.49:0.42:0.45:0.49:0.29:0.46"] = 331, -- Dalaran, Moa'ki, Agmar's Hammer, Taunka'le Village
				["0.52:0.62:0.49:0.42:0.74:0.29"] = 342, -- Dalaran, Moa'ki, Kamagua
				["0.52:0.62:0.62:0.64:0.72:0.71"] = 155, -- Dalaran, K3, Dun Niffelem
				["0.52:0.62:0.49:0.42:0.59:0.45"] = 219, -- Dalaran, Moa'ki, Venomspite
				["0.52:0.62:0.49:0.42:0.29:0.43:0.29:0.46"] = 310, -- Dalaran, Moa'ki, Unu'pe, Taunka'le Village
				["0.52:0.62:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47:0.12:0.47"] = 421, -- Dalaran, Moa'ki, Unu'pe, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.52:0.62:0.48:0.56:0.59:0.45:0.74:0.38"] = 261, -- Dalaran, Kor'koron Vanguard, Venomspite, Apothecary Camp
				["0.52:0.62:0.48:0.56:0.59:0.45:0.74:0.38:0.74:0.29"] = 314, -- Dalaran, Kor'koron Vanguard, Venomspite, Apothecary Camp, Kamagua
				["0.52:0.62:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47"] = 385, -- Dalaran, Moa'ki, Unu'pe, Taunka'le Village, Amber Ledge
				["0.52:0.62:0.49:0.42:0.29:0.43:0.29:0.46:0.18:0.53"] = 382, -- Dalaran, Moa'ki, Unu'pe, Taunka'le Village, Bor'gorok Outpost
				["0.52:0.62:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 371, -- Dalaran, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.52:0.62:0.24:0.60:0.18:0.53:0.17:0.47:0.12:0.47"] = 356, -- Dalaran, River's Heart, Bor'gorok Outpost, Amber Ledge, Transitus Shield
				["0.52:0.62:0.49:0.42:0.29:0.43:0.15:0.43"] = 375, -- Dalaran, Moa'ki, Unu'pe, Warsong Hold
				["0.52:0.62:0.64:0.58:0.59:0.45:0.45:0.49:0.29:0.46"] = 423, -- Dalaran, Ebon Watch, Venomspite, Agmar's Hammer, Taunka'le Village
				["0.52:0.62:0.64:0.58:0.72:0.60:0.84:0.49:0.84:0.41"] = 292, -- Dalaran, Ebon Watch, The Argent Stand, Camp Oneqwah, Camp Winterhoof
				["0.52:0.62:0.54:0.48:0.45:0.49:0.29:0.46:0.29:0.43"] = 328, -- Dalaran, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Unu'pe
				["0.52:0.62:0.64:0.58:0.59:0.45:0.45:0.49"] = 312, -- Dalaran, Schwarze Wacht, Gallgrimm, Agmars Hammer
				["0.52:0.62:0.52:0.66:0.38:0.79"] = 162, -- Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.52:0.62:0.54:0.48:0.59:0.45:0.69:0.58"] = 276, -- Dalaran, Wyrmrest Temple, Venomspite, Light's Breach
				["0.52:0.62:0.48:0.56:0.59:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 405, -- Dalaran, Kor'koron Vanguard, Venomspite, Light's Breach, The Argent Stand, Zim'Torga, Gundrak
				["0.52:0.62:0.64:0.58:0.59:0.45:0.45:0.49:0.29:0.46:0.17:0.47"] = 497, -- Dalaran, Ebon Watch, Venomspite, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.52:0.62:0.64:0.58:0.59:0.45"] = 180, -- Dalaran, Ebon Watch, Venomspite
				["0.52:0.62:0.62:0.64:0.73:0.75:0.64:0.81"] = 218, -- Dalaran, K3, Camp Tunka'lo, Ulduar
				["0.52:0.62:0.49:0.42:0.59:0.45:0.70:0.45:0.84:0.49"] = 378, -- Dalaran, Moa'ki, Venomspite, Conquest Hold, Camp Oneqwah
				["0.52:0.62:0.62:0.64:0.60:0.75:0.57:0.79"] = 167, -- Dalaran, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.52:0.62:0.49:0.42:0.29:0.43"] = 288, -- Dalaran, Moa'ki, Unu'pe
				["0.52:0.62:0.64:0.58:0.59:0.45:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 533, -- Dalaran, Ebon Watch, Venomspite, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.52:0.62:0.49:0.42:0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.72:0.60"] = 565, -- Dalaran, Moa'ki, Kamagua, Apothecary Camp, Conquest Hold, Light's Breach, The Argent Stand
				["0.52:0.62:0.24:0.60:0.18:0.53:0.17:0.47"] = 321, -- Dalaran, River's Heart, Bor'gorok Outpost, Amber Ledge
				["0.52:0.62:0.54:0.48:0.59:0.45:0.74:0.38:0.84:0.41"] = 328, -- Dalaran, Wyrmrest Temple, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.52:0.62:0.54:0.48:0.59:0.45:0.70:0.45:0.84:0.49"] = 330, -- Dalaran, Wyrmrest Temple, Venomspite, Conquest Hold, Camp Oneqwah
				["0.52:0.62:0.48:0.56:0.59:0.45:0.74:0.38:0.84:0.41:0.95:0.37"] = 393, -- Dalaran, Kor'koron Vanguard, Venomspite, Apothecary Camp, Camp Winterhoof, Vengeance Landing
				["0.52:0.62:0.49:0.42:0.59:0.45:0.69:0.58"] = 325, -- Dalaran, Moa'ki, Venomspite, Light's Breach
				["0.52:0.62:0.54:0.48:0.59:0.45:0.69:0.58:0.84:0.49:0.95:0.37"] = 486, -- Dalaran, Wyrmrest Temple, Venomspite, Light's Breach, Camp Oneqwah, Vengeance Landing
				["0.52:0.62:0.49:0.42:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 435, -- Dalaran, Moa'ki, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.52:0.62:0.56:0.64:0.60:0.75:0.64:0.81"] = 186, -- Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Ulduar
				["0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.41"] = 306, -- Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold, Camp Winterhoof
				["0.52:0.62:0.24:0.60:0.18:0.53:0.15:0.43"] = 337, -- Dalaran, River's Heart, Bor'gorok Outpost, Warsong Hold
				["0.52:0.62:0.24:0.60:0.28:0.72"] = 296, -- Dalaran, River's Heart, Death's Rise
				["0.52:0.62:0.49:0.42:0.59:0.45:0.74:0.38"] = 316, -- Dalaran, Moa'ki, Venomspite, Apothecary Camp
				["0.52:0.62:0.54:0.48:0.59:0.45:0.85:0.27:0.95:0.37"] = 434, -- Dalaran, Wyrmrest Temple, Venomspite, New Agamand, Vengeance Landing
				["0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.84:0.41"] = 284, -- Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Camp Winterhoof
				["0.52:0.62:0.31:0.57:0.45:0.49"] = 263, -- Dalaran, Warsong Camp, Agmar's Hammer
				["0.52:0.62:0.62:0.64:0.60:0.75:0.57:0.79:0.38:0.79"] = 280, -- Dalaran, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge, The Shadow Vault
				["0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.78:0.62:0.64:0.81"] = 476, -- Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Zim'Torga, Ulduar
				["0.52:0.62:0.31:0.57:0.29:0.46:0.17:0.47:0.12:0.47"] = 352, -- Dalaran, Camp chanteguerre, Taunka'le, Escarpement d'Ambre, Bouclier Transitus
				["0.52:0.62:0.31:0.57:0.29:0.46:0.15:0.43"] = 325, -- Dalaran, Warsong Camp, Taunka'le Village, Warsong Hold
				["0.52:0.62:0.56:0.64:0.38:0.79"] = 179, -- Dalaran, The Argent Vanguard, The Shadow Vault
				["0.52:0.62:0.64:0.58:0.72:0.60:0.84:0.49"] = 244, -- Dalaran, Guet d'Ébène, Le séjour d'Argent, Camp Oneqwah
				["0.52:0.62:0.56:0.64:0.60:0.75:0.73:0.75:0.72:0.71"] = 275, -- Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Camp Tunka'lo, Dun Nifflelem
				["0.52:0.62:0.31:0.57:0.38:0.79"] = 325, -- Dalaran, Warsong Camp, The Shadow Vault
				["0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.49:0.95:0.37"] = 428, -- Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold, Camp Oneqwah, Vengeance Landing
				["0.52:0.62:0.48:0.56:0.59:0.45:0.69:0.58:0.72:0.60"] = 312, -- Dalaran, Vorposten der Kor'kron, Gallgrimm, Lichtbresche, Argentumwache
				["0.52:0.62:0.31:0.57:0.29:0.46:0.17:0.47"] = 316, -- Dalaran, Warsong Camp, Taunka'le Village, Amber Ledge
				["0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.84:0.41:0.95:0.37"] = 357, -- Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.52:0.62:0.56:0.64:0.60:0.75"] = 135, -- Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.52:0.62:0.49:0.42:0.59:0.45:0.74:0.38:0.84:0.41"] = 375, -- Dalaran, Moa'ki, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.52:0.62:0.62:0.64:0.72:0.71:0.64:0.81"] = 239, -- Dalaran, K3, Dun Nifflelem, Ulduar
				["0.52:0.62:0.48:0.56:0.59:0.45:0.85:0.27:0.84:0.41"] = 426, -- Dalaran, Kor'koron Vanguard, Venomspite, New Agamand, Camp Winterhoof
				["0.52:0.62:0.49:0.42:0.74:0.29:0.85:0.27:0.95:0.37"] = 483, -- Dalaran, Moa'ki, Kamagua, New Agamand, Vengeance Landing
				["0.52:0.62:0.62:0.64:0.73:0.75:0.78:0.62:0.82:0.69"] = 296, -- Dalaran, K3, Camp Tunka'lo, Zim'Torga, Gundrak
				["0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 270, -- Даларан, Черная застава, Серебряная застава, Зим'Торга, Дун Ниффелем
				["0.52:0.62:0.56:0.64:0.60:0.75:0.73:0.75"] = 230, -- Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Camp Tunka'lo
				["0.52:0.62:0.62:0.64:0.73:0.75:0.78:0.62:0.72:0.60"] = 295, -- Dalaran, K3, Camp Tunka'lo, Zim'Torga, The Argent Stand
				["0.52:0.62:0.64:0.58:0.59:0.45:0.70:0.45"] = 239, -- Dalaran, Ebon Watch, Venomspite, Conquest Hold
				["0.52:0.62:0.54:0.48:0.59:0.45:0.74:0.38:0.84:0.41:0.95:0.37"] = 400, -- Dalaran, Wyrmrest Temple, Venomspite, Apothecary Camp, Camp Winterhoof, Vengeance Landing
				["0.52:0.62:0.64:0.58:0.59:0.45:0.74:0.38"] = 278, -- Даларан, Черная застава, Ядозлобь, Аптекарский поселок
				["0.52:0.62:0.62:0.64:0.73:0.75:0.78:0.62:0.78:0.61"] = 243, -- Dalaran, K3, Camp Tunka'lo, Zim'Torga
				["0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.85:0.27:0.95:0.37"] = 427, -- Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, New Agamand, Vengeance Landing
				["0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.78:0.62:0.78:0.61"] = 323, -- Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Zim'Torga
				["0.52:0.62:0.31:0.57:0.29:0.46:0.29:0.43"] = 270, -- Dalaran, Warsong Camp, Taunka'le Village, Unu'pe
				["0.52:0.62:0.52:0.66:0.38:0.79:0.57:0.79"] = 283, -- Dalaran, Crusaders' Pinnacle, The Shadow Vault, Bouldercrag's Refuge
				["0.52:0.62:0.54:0.48:0.59:0.45:0.85:0.27:0.84:0.41"] = 433, -- Dalaran, Wyrmrest Temple, Venomspite, New Agamand, Camp Winterhoof
				["0.52:0.62:0.56:0.64:0.38:0.79:0.28:0.72"] = 256, -- Dalaran, Die Argentumvorhut, Das Schattengewölbe, Todesanhöhe
				["0.52:0.62:0.49:0.42:0.29:0.43:0.15:0.43:0.17:0.47:0.18:0.53"] = 443, -- Dalaran, Moa'ki, Unu'pe, Warsong Hold, Amber Ledge, Bor'gorok Outpost
				["0.52:0.62:0.56:0.64:0.60:0.75:0.57:0.79"] = 171, -- Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41:0.74:0.38"] = 336, -- Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof, Apothecary Camp
				["0.52:0.62:0.62:0.64:0.72:0.71:0.78:0.62:0.78:0.61"] = 244, -- Dalaran, K3, Dun Niffelem, Zim'Torga
				["0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81:0.57:0.79"] = 387, -- Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Ulduar, Bouldercrag's Refuge
				["0.52:0.62:0.24:0.60:0.18:0.53:0.29:0.46:0.45:0.49"] = 432, -- Dalaran, Flussnabel, Bor'goroks Außenposten, Taunka'le, Agmars Hammer
				["0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81:0.78:0.62:0.82:0.69"] = 388, -- Dalaran, K3, Grom'arsh Crash-Site, Ulduar, Zim'Torga, Gundrak
				["0.52:0.62:0.31:0.57:0.28:0.72"] = 273, -- Dalaran, Warsong Camp, Death's Rise
				["0.52:0.62:0.49:0.42:0.59:0.45:0.70:0.45:0.84:0.49:0.72:0.60"] = 477, -- Dalaran, Moa'ki, Venomspite, Conquest Hold, Camp Oneqwah, The Argent Stand
				["0.52:0.62:0.48:0.56:0.59:0.45:0.74:0.38:0.84:0.41:0.84:0.49"] = 377, -- Dalaran, Kor'koron Vanguard, Venomspite, Apothecary Camp, Camp Winterhoof, Camp Oneqwah
				["0.52:0.62:0.62:0.64:0.72:0.71:0.78:0.62:0.82:0.69"] = 297, -- Dalaran, K3, Dun Niffelem, Zim'Torga, Gundrak
				["0.52:0.62:0.64:0.58:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 396, -- Даларан, Черная застава, Ядозлобь, Крепость Завоевателей, Лагерь Заиндевевшего Копыта, Лагерь Возмездия
				["0.52:0.62:0.64:0.58:0.59:0.45:0.85:0.27"] = 366, -- Даларан, Черная застава, Ядозлобь, Новый Агамонд
				["0.52:0.62:0.64:0.58:0.59:0.45:0.70:0.45:0.84:0.41"] = 324, -- Dalaran, Ebon Watch, Venomspite, Conquest Hold, Camp Winterhoof
				["0.52:0.62:0.49:0.42:0.74:0.29:0.74:0.38"] = 397, -- Dalaran, Moa'ki, Kamagua, Apothecary Camp
				["0.52:0.62:0.49:0.42:0.29:0.43:0.15:0.43:0.17:0.47:0.12:0.47"] = 446, -- Dalaran, Moa'ki, Unu'pe, Warsong Hold, Amber Ledge, Transitus Shield
				["0.52:0.62:0.54:0.48:0.59:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 359, -- Dalaran, Wyrmrest Temple, Venomspite, Light's Breach, The Argent Stand, Zim'Torga
				["0.52:0.62:0.62:0.64:0.73:0.75:0.64:0.81:0.57:0.79"] = 266, -- Dalaran, K3, Camp Tunka'lo, Ulduar, Bouldercrag's Refuge
				["0.52:0.62:0.52:0.66:0.38:0.79:0.57:0.79:0.64:0.81"] = 327, -- Dalaran, Crusaders' Pinnacle, The Shadow Vault, Bouldercrag's Refuge, Ulduar
				["0.52:0.62:0.49:0.42:0.45:0.49:0.29:0.46:0.18:0.53"] = 403, -- Dalaran, Moa'ki, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.52:0.62:0.54:0.48:0.59:0.45:0.70:0.45:0.84:0.49:0.95:0.37"] = 434, -- Dalaran, Wyrmrest Temple, Venomspite, Conquest Hold, Camp Oneqwah, Vengeance Landing
				["0.52:0.62:0.54:0.48:0.59:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 412, -- Dalaran, Wyrmrest Temple, Venomspite, Light's Breach, The Argent Stand, Zim'Torga, Gundrak
				["0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41:0.74:0.38:0.74:0.29"] = 390, -- Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof, Apothecary Camp, Kamagua
				["0.52:0.62:0.54:0.48:0.59:0.45:0.85:0.27:0.74:0.29"] = 431, -- Dalaran, Temple du Repos du ver, Vexevenin, Nouvelle-Agamand, Kamagua
				["0.52:0.62:0.49:0.42:0.74:0.29:0.74:0.38:0.70:0.45"] = 443, -- Dalaran, Moa'ki, Kamagua, Apothecary Camp, Conquest Hold
				["0.52:0.62:0.31:0.57:0.29:0.46:0.18:0.53"] = 313, -- Dalaran, Warsong Camp, Taunka'le Village, Bor'gorok Outpost
				["0.52:0.62:0.64:0.58:0.72:0.60:0.84:0.49:0.84:0.41:0.85:0.27"] = 371, -- Dalaran, Ebon Watch, The Argent Stand, Camp Oneqwah, Camp Winterhoof, New Agamand
				["0.52:0.62:0.49:0.42:0.59:0.45:0.74:0.38:0.84:0.41:0.95:0.37"] = 449, -- Dalaran, Moa'ki, Gallgrimm, Apothekerlager, Lager der Winterhufe, Hafen der Vergeltung
				["0.52:0.62:0.49:0.42:0.59:0.45:0.69:0.58:0.72:0.60"] = 367, -- Dalaran, Moa'ki, Venomspite, Light's Breach, The Argent Stand
				["0.52:0.62:0.49:0.42:0.59:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 461, -- Dalaran, Moa'ki, Venomspite, Light's Breach, The Argent Stand, Zim'Torga, Gundrak
				["0.52:0.62:0.62:0.64:0.60:0.75:0.57:0.79:0.38:0.79:0.28:0.72"] = 357, -- Dalaran, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge, The Shadow Vault, Death's Rise
				["0.52:0.62:0.64:0.58:0.59:0.45:0.74:0.38:0.74:0.29"] = 331, -- Dalaran, Puesto de Vigilancia de Ébano, Rencor Venenoso, Campamento de los Boticarios, Komawa
				["0.52:0.62:0.24:0.60:0.28:0.72:0.38:0.79"] = 390, -- Dalaran, River's Heart, Death's Rise, The Shadow Vault
				["0.52:0.62:0.49:0.79"] = 123, -- Dalaran, Argent Tournament Grounds
				["0.52:0.62:0.49:0.79:0.57:0.79:0.64:0.81"] = 215, -- Dalaran, Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar
				["0.52:0.62:0.49:0.42:0.74:0.29:0.74:0.38:0.84:0.41"] = 456, -- Dalaran, Moa'ki, Kamagua, Apothecary Camp, Camp Winterhoof
				["0.52:0.62:0.49:0.79:0.57:0.79"] = 171, -- Dalaran, Argent Tournament Grounds, Bouldercrag's Refuge
				["0.52:0.62:0.62:0.64:0.73:0.75:0.78:0.62:0.84:0.49"] = 325, -- Dalaran, K3, Camp Tunka'lo, Zim'Torga, Camp Oneqwah
				["0.52:0.62:0.64:0.58:0.72:0.60:0.84:0.49:0.95:0.37"] = 348, -- Dalaran, Ebon Watch, The Argent Stand, Camp Oneqwah, Vengeance Landing
				["0.52:0.62:0.49:0.79:0.57:0.79:0.60:0.75"] = 211, -- Dalaran, Argent Tournament Grounds, Bouldercrag's Refuge, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.52:0.62:0.62:0.64:0.72:0.71:0.78:0.62:0.72:0.60"] = 297, -- Dalaran, K3, Dun Nifflelem, Zim'Torga, The Argent Stand
				["0.52:0.62:0.64:0.58:0.59:0.45:0.85:0.27:0.84:0.41"] = 444, -- Dalaran, Ebon Watch, Venomspite, New Agamand, Camp Winterhoof
				["0.52:0.62:0.49:0.42:0.74:0.29:0.85:0.27:0.84:0.41"] = 483, -- Dalaran, Moa'ki, Kamagua, New Agamand, Camp Winterhoof
				["0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81:0.60:0.75"] = 382, -- Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Ulduar, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.84:0.41:0.85:0.27"] = 363, -- Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Camp Winterhoof, New Agamand
				["0.52:0.62:0.48:0.56:0.59:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 352, -- Dalaran, Vorposten der Kor'kron, Gallgrimm, Lichtbresche, Argentumwache, Zim'Torga
				["0.52:0.62:0.49:0.79:0.38:0.79"] = 207, -- Dalaran, Argent Tournament Grounds, The Shadow Vault
				["0.52:0.62:0.49:0.42:0.45:0.49:0.29:0.46:0.15:0.43"] = 416, -- Dalaran, Moa'ki, Agmars Hammer, Taunka'le, Kriegshymnenfeste
				["0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.73:0.75"] = 272, -- Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Camp Tunka'lo
				["0.52:0.62:0.64:0.58:0.59:0.45:0.45:0.49:0.29:0.46:0.15:0.43"] = 507, -- Dalaran, Guet d'Ébène, Vexevenin, Marteau d'Agmar, Taunka'le, Bastion Chanteguerre
				["0.52:0.62:0.49:0.42:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 442, -- Dalaran, Moa'ki, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.52:0.62:0.64:0.58:0.59:0.45:0.70:0.45:0.84:0.49"] = 340, -- Dalaran, Ebon Watch, Venomspite, Conquest Hold, Camp Oneqwah

				----------------------------------------------------------------------
				-- Horde: Dragonblight
				----------------------------------------------------------------------

				-- Horde: Dragonblight: Agmar's Hammer
				["0.45:0.49:0.48:0.56:0.52:0.62"] = 121, -- Agmar's Hammer, Kor'koron Vanguard, Dalaran
				["0.45:0.49:0.49:0.42"] = 64, -- Agmar's Hammer, Moa'ki
				["0.45:0.49:0.48:0.56"] = 65, -- Agmar's Hammer, Kor'koron Vanguard
				["0.45:0.49:0.54:0.48"] = 52, -- Agmar's Hammer, Wyrmrest Temple
				["0.45:0.49:0.59:0.45"] = 88, -- Agmar's Hammer, Venomspite
				["0.45:0.49:0.59:0.45:0.85:0.27"] = 273, -- Agmar's Hammer, Venomspite, New Agamand
				["0.45:0.49:0.29:0.46"] = 114, -- Agmar's Hammer, Taunka'le Village
				["0.45:0.49:0.59:0.45:0.74:0.38"] = 185, -- Agmar's Hammer, Venomspite, Apothecary Camp
				["0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 225, -- Agmars Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.45:0.49:0.29:0.46:0.15:0.43"] = 198, -- Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.45:0.49:0.54:0.48:0.52:0.62"] = 145, -- Agmar's Hammer, Wyrmrest Temple, Dalaran
				["0.45:0.49:0.49:0.42:0.29:0.43:0.15:0.43"] = 282, -- Agmar's Hammer, Moa'ki, Unu'pe, Warsong Hold
				["0.45:0.49:0.59:0.45:0.70:0.45"] = 146, -- Agmar's Hammer, Venomspite, Conquest Hold
				["0.45:0.49:0.48:0.56:0.64:0.58:0.72:0.60"] = 234, -- Agmar's Hammer, Kor'koron Vanguard, Ebon Watch, The Argent Stand
				["0.45:0.49:0.54:0.48:0.64:0.58"] = 154, -- Agmar's Hammer, Wyrmrest Temple, Ebon Watch
				["0.45:0.49:0.29:0.46:0.17:0.47"] = 189, -- Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.45:0.49:0.49:0.42:0.29:0.43"] = 195, -- Marteau d'Agmar, Moa'ki, Unu'pe
				["0.45:0.49:0.29:0.46:0.18:0.53"] = 186, -- Martillo de Agmar, Poblado Taunka'le, Avanzada Bor'gorok
				["0.45:0.49:0.49:0.42:0.74:0.29:0.85:0.27:0.95:0.37"] = 389, -- Agmar's Hammer, Moa'ki, Kamagua, New Agamand, Vengeance Landing
				["0.45:0.49:0.49:0.42:0.29:0.43:0.15:0.43:0.17:0.47"] = 318, -- Agmar's Hammer, Moa'ki, Unu'pe, Warsong Hold, Amber Ledge
				["0.45:0.49:0.49:0.42:0.74:0.29:0.85:0.27"] = 310, -- Agmar's Hammer, Moa'ki, Kamagua, New Agamand
				["0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60"] = 218, -- Agmar's Hammer, Wyrmrest Temple, Ebon Watch, The Argent Stand
				["0.45:0.49:0.59:0.45:0.85:0.27:0.84:0.41"] = 351, -- Agmar's Hammer, Venomspite, New Agamand, Camp Winterhoof
				["0.45:0.49:0.59:0.45:0.69:0.58"] = 194, -- Agmar's Hammer, Venomspite, Light's Breach
				["0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49"] = 246, -- Agmar's Hammer, Venomspite, Conquest Hold, Camp Oneqwah
				["0.45:0.49:0.49:0.42:0.52:0.62"] = 185, -- Agmar's Hammer, Moa'ki, Dalaran
				["0.45:0.49:0.59:0.45:0.74:0.38:0.84:0.41"] = 245, -- Agmar's Hammer, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.45:0.49:0.59:0.45:0.74:0.38:0.84:0.41:0.95:0.37"] = 318, -- Agmar's Hammer, Venomspite, Apothecary Camp, Camp Winterhoof, Vengeance Landing
				["0.45:0.49:0.59:0.45:0.85:0.27:0.74:0.29"] = 348, -- Agmar's Hammer, Venomspite, New Agamand, Kamagua
				["0.45:0.49:0.29:0.46:0.29:0.43"] = 143, -- Agmar's Hammer, Taunka'le Village, Unu'pe
				["0.45:0.49:0.54:0.48:0.64:0.58:0.60:0.60"] = 181, -- Agmar's Hammer, Wyrmrest Temple, Ebon Watch, Sunreaver's Command
				["0.45:0.49:0.59:0.45:0.69:0.58:0.72:0.60"] = 237, -- Agmar's Hammer, Venomspite, Light's Breach, The Argent Stand
				["0.45:0.49:0.49:0.42:0.74:0.29"] = 248, -- Agmar's Hammer, Moa'ki, Kamagua
				["0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41"] = 230, -- Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof
				["0.45:0.49:0.59:0.45:0.74:0.38:0.74:0.29"] = 239, -- Agmar's Hammer, Venomspite, Apothecary Camp, Kamagua
				["0.45:0.49:0.54:0.48:0.52:0.62:0.24:0.60:0.18:0.60"] = 379, -- Agmar's Hammer, Wyrmrest Temple, Dalaran, River's Heart, Nesingwary Base Camp
				["0.45:0.49:0.49:0.42:0.74:0.29:0.74:0.38:0.84:0.41"] = 362, -- Agmar's Hammer, Moa'ki, Kamagua, Apothecary Camp, Camp Winterhoof
				["0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 258, -- Agmars Hammer, Wyrmruhtempel, Schwarze Wacht, Argentumwache, Zim'Torga
				["0.45:0.49:0.59:0.45:0.85:0.27:0.95:0.37"] = 352, -- Agmars Hammer, Gallgrimm, Neu-Agamand, Hafen der Vergeltung
				["0.45:0.49:0.29:0.46:0.18:0.53:0.24:0.60"] = 241, -- Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost, River's Heart
				["0.45:0.49:0.31:0.57"] = 118, -- Agmar's Hammer, Warsong Camp
				["0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 303, -- Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.45:0.49:0.59:0.45:0.64:0.58"] = 170, -- Agmar's Hammer, Venomspite, Ebon Watch
				["0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 292, -- Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.45:0.49:0.31:0.57:0.38:0.79"] = 281, -- Agmar's Hammer, Warsong Camp, The Shadow Vault
				["0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49:0.78:0.62:0.78:0.61"] = 339, -- Agmar's Hammer, Venomspite, Conquest Hold, Camp Oneqwah, Zim'Torga
				["0.45:0.49:0.59:0.45:0.64:0.58:0.52:0.62"] = 237, -- Agmar's Hammer, Venomspite, Ebon Watch, Dalaran
				["0.45:0.49:0.54:0.48:0.64:0.58:0.62:0.64:0.72:0.71"] = 295, -- Agmar's Hammer, Wyrmrest Temple, Ebon Watch, K3, Dun Nifflelem
				["0.45:0.49:0.59:0.45:0.74:0.38:0.84:0.41:0.84:0.49"] = 302, -- Agmar's Hammer, Venomspite, Apothecary Camp, Camp Winterhoof, Camp Oneqwah
				["0.45:0.49:0.29:0.46:0.18:0.53:0.18:0.60"] = 232, -- Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost, Nesingwary Base Camp
				["0.45:0.49:0.48:0.56:0.52:0.62:0.52:0.66:0.38:0.79"] = 272, -- Agmar's Hammer, Kor'koron Vanguard, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.45:0.49:0.48:0.56:0.52:0.62:0.24:0.60"] = 321, -- Agmar's Hammer, Kor'koron Vanguard, Dalaran, River's Heart
				["0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.72:0.71"] = 266, -- Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Dun Nifflelem
				["0.45:0.49:0.49:0.42:0.74:0.29:0.85:0.27:0.84:0.41"] = 389, -- Agmar's Hammer, Moa'ki, Kamagua, New Agamand, Camp Winterhoof
				["0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 312, -- Agmar's Hammer, Wyrmrest Temple, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.45:0.49:0.54:0.48:0.52:0.62:0.24:0.60:0.18:0.53:0.17:0.47"] = 454, -- Agmar's Hammer, Wyrmrest Temple, Dalaran, River's Heart, Bor'gorok Outpost, Amber Ledge
				["0.45:0.49:0.59:0.45:0.64:0.58:0.52:0.62:0.56:0.64"] = 258, -- Agmar's Hammer, Venomspite, Ebon Watch, Dalaran, The Argent Vanguard
				["0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.73:0.75"] = 256, -- Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Camp Tunka'lo
				["0.45:0.49:0.48:0.56:0.52:0.62:0.24:0.60:0.18:0.53:0.15:0.43"] = 447, -- Agmar's Hammer, Kor'koron Vanguard, Dalaran, River's Heart, Bor'gorok Outpost, Warsong Hold
				["0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64"] = 167, -- Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3
				["0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75"] = 242, -- Agmars Hammer, Vorposten der Kor'kron, Dalaran, K3, Absturzstelle Grom'ash
				["0.45:0.49:0.31:0.57:0.24:0.60"] = 194, -- Agmar's Hammer, Warsong Camp, River's Heart
				["0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49:0.95:0.37"] = 351, -- Agmar's Hammer, Venomspite, Conquest Hold, Camp Oneqwah, Vengeance Landing
				["0.45:0.49:0.48:0.56:0.52:0.62:0.56:0.64"] = 143, -- Agmar's Hammer, Kor'koron Vanguard, Dalaran, The Argent Vanguard
				["0.45:0.49:0.59:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 330, -- Agmar's Hammer, Venomspite, Light's Breach, The Argent Stand, Zim'Torga, Gundrak
				["0.45:0.49:0.48:0.56:0.52:0.62:0.52:0.66"] = 150, -- Agmar's Hammer, Kor'koron Vanguard, Dalaran, Crusaders' Pinnacle
				["0.45:0.49:0.48:0.56:0.64:0.58"] = 171, -- Agmar's Hammer, Kor'koron Vanguard, Ebon Watch
				["0.45:0.49:0.31:0.57:0.52:0.62"] = 259, -- Agmar's Hammer, Warsong Camp, Dalaran
				["0.45:0.49:0.54:0.48:0.64:0.58:0.62:0.64:0.60:0.75:0.64:0.81"] = 321, -- Agmar's Hammer, Wyrmrest Temple, Ebon Watch, K3, Grom'arsh Crash-Site, Ulduar
				["0.45:0.49:0.31:0.57:0.28:0.72"] = 230, -- Agmar's Hammer, Warsong Camp, Death's Rise
				["0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49:0.78:0.62:0.82:0.69"] = 392, -- Agmar's Hammer, Venomspite, Conquest Hold, Camp Oneqwah, Zim'Torga, Gundrak
				["0.45:0.49:0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75:0.57:0.79"] = 278, -- Agmar's Hammer, Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.45:0.49:0.31:0.57:0.24:0.60:0.18:0.53:0.17:0.47:0.12:0.47"] = 339, -- Agmar's Hammer, Warsong Camp, River's Heart, Bor'gorok Outpost, Amber Ledge, Transitus Shield
				["0.45:0.49:0.54:0.48:0.64:0.58:0.62:0.64"] = 194, -- Agmar's Hammer, Wyrmrest Temple, Ebon Watch, K3
				["0.45:0.49:0.48:0.56:0.52:0.62:0.49:0.79"] = 235, -- Agmar's Hammer, Kor'koron Vanguard, Dalaran, Argent Tournament Grounds
				["0.45:0.49:0.54:0.48:0.52:0.62:0.49:0.79"] = 258, -- Agmar's Hammer, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.45:0.49:0.48:0.56:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38"] = 346, -- Agmar's Hammer, Kor'koron Vanguard, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp
				["0.45:0.49:0.48:0.56:0.52:0.62:0.56:0.64:0.60:0.75:0.64:0.81"] = 297, -- Agmar's Hammer, Kor'koron Vanguard, Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Ulduar
				["0.45:0.49:0.54:0.48:0.52:0.62:0.52:0.66:0.38:0.79"] = 295, -- Agmar's Hammer, Wyrmrest Temple, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.45:0.49:0.48:0.56:0.52:0.62:0.49:0.79:0.57:0.79:0.64:0.81"] = 327, -- Agmar's Hammer, Kor'koron Vanguard, Dalaran, Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar
				["0.45:0.49:0.49:0.42:0.74:0.29:0.74:0.38"] = 302, -- Agmar's Hammer, Moa'ki, Kamagua, Apothecary Camp
				["0.45:0.49:0.48:0.56:0.64:0.58:0.69:0.58"] = 215, -- Agmar's Hammer, Kor'koron Vanguard, Ebon Watch, Light's Breach

				-- Horde: Dragonblight: Kor'koron Vanguard
				["0.48:0.56:0.52:0.62"] = 56, -- Kor'koron Vanguard, Dalaran
				["0.48:0.56:0.52:0.62:0.60:0.60"] = 103, -- Kor'koron Vanguard, Dalaran, Sunreaver's Command
				["0.48:0.56:0.45:0.49:0.29:0.46"] = 164, -- Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village
				["0.48:0.56:0.54:0.48"] = 67, -- Kor'koron Vanguard, Wyrmrest Temple
				["0.48:0.56:0.45:0.49"] = 53, -- Kor'koron Vanguard, Agmar's Hammer
				["0.48:0.56:0.45:0.49:0.49:0.42"] = 114, -- Kor'koron Vanguard, Agmar's Hammer, Moa'ki
				["0.48:0.56:0.59:0.45"] = 90, -- Kor'koron Vanguard, Venomspite
				["0.48:0.56:0.52:0.62:0.56:0.64"] = 79, -- Kor'koron Vanguard, Dalaran, The Argent Vanguard
				["0.48:0.56:0.64:0.58:0.72:0.60"] = 171, -- Kor'koron Vanguard, Ebon Watch, The Argent Stand
				["0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 307, -- Kor'koron Vanguard, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.48:0.56:0.45:0.49:0.29:0.46:0.15:0.43"] = 248, -- Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 274, -- Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.48:0.56:0.59:0.45:0.70:0.45"] = 149, -- Kor'koron Vanguard, Venomspite, Conquest Hold
				["0.48:0.56:0.45:0.49:0.49:0.42:0.29:0.43"] = 245, -- Kor'koron Vanguard, Agmar's Hammer, Moa'ki, Unu'pe
				["0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47"] = 238, -- Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.48:0.56:0.59:0.45:0.74:0.38"] = 188, -- Kor'koron Vanguard, Venomspite, Apothecary Camp
				["0.48:0.56:0.52:0.62:0.24:0.60"] = 258, -- Kor'koron Vanguard, Dalaran, River's Heart
				["0.48:0.56:0.45:0.49:0.49:0.42:0.74:0.29"] = 297, -- Kor'koron Vanguard, Agmar's Hammer, Moa'ki, Kamagua
				["0.48:0.56:0.45:0.49:0.29:0.46:0.18:0.53"] = 236, -- Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75:0.57:0.79"] = 214, -- Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.49"] = 250, -- Avant-garde kor'kronne, Vexevenin, Bastion de la Conquête, Camp Oneqwah
				["0.48:0.56:0.64:0.58:0.60:0.60"] = 134, -- Стоянка отряда Кор'крона, Черная застава, Лагерь Похитителя Солнца
				["0.48:0.56:0.59:0.45:0.69:0.58"] = 197, -- Kor'koron Vanguard, Venomspite, Light's Breach
				["0.48:0.56:0.64:0.58"] = 107, -- Kor'koron Vanguard, Ebon Watch
				["0.48:0.56:0.45:0.49:0.29:0.46:0.29:0.43"] = 193, -- Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Unu'pe
				["0.48:0.56:0.52:0.62:0.56:0.64:0.60:0.75"] = 181, -- Kor'koron Vanguard, Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.41"] = 234, -- Kor'koron Vanguard, Venomspite, Conquest Hold, Camp Winterhoof
				["0.48:0.56:0.45:0.49:0.31:0.57"] = 168, -- Kor'koron Vanguard, Agmar's Hammer, Warsong Camp
				["0.48:0.56:0.64:0.58:0.69:0.58"] = 152, -- Kor'koron Vanguard, Ebon Watch, Light's Breach
				["0.48:0.56:0.45:0.49:0.31:0.57:0.24:0.60"] = 244, -- Kor'koron Vanguard, Agmar's Hammer, Warsong Camp, River's Heart
				["0.48:0.56:0.45:0.49:0.29:0.46:0.18:0.53:0.18:0.60"] = 282, -- Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost, Nesingwary Base Camp
				["0.48:0.56:0.59:0.45:0.85:0.27"] = 276, -- Kor'koron Vanguard, Venomspite, New Agamand
				["0.48:0.56:0.52:0.62:0.62:0.64:0.72:0.71"] = 202, -- Kor'koron Vanguard, Dalaran, K3, Dun Nifflelem
				["0.48:0.56:0.52:0.62:0.62:0.64"] = 103, -- Kor'koron Vanguard, Dalaran, K3
				["0.48:0.56:0.59:0.45:0.74:0.38:0.74:0.29"] = 242, -- Kor'koron Vanguard, Venomspite, Apothecary Camp, Kamagua
				["0.48:0.56:0.54:0.48:0.49:0.42"] = 120, -- Kor'koron Vanguard, Wyrmrest Temple, Moa'ki
				["0.48:0.56:0.52:0.62:0.52:0.66"] = 85, -- Kor'koron Vanguard, Dalaran, Crusaders' Pinnacle
				["0.48:0.56:0.52:0.62:0.56:0.64:0.60:0.75:0.64:0.81:0.72:0.71"] = 336, -- Kor'koron Vanguard, Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Ulduar, Dun Nifflelem
				["0.48:0.56:0.52:0.62:0.52:0.66:0.38:0.79"] = 208, -- Kor'koron Vanguard, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.48:0.56:0.52:0.62:0.24:0.60:0.28:0.72"] = 342, -- Kor'koron Vanguard, Dalaran, River's Heart, Death's Rise
				["0.48:0.56:0.52:0.62:0.31:0.57"] = 207, -- Kor'koron Vanguard, Dalaran, Warsong Camp
				["0.48:0.56:0.52:0.62:0.56:0.64:0.38:0.79"] = 226, -- Kor'koron Vanguard, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.48:0.56:0.45:0.49:0.49:0.42:0.29:0.43:0.15:0.43"] = 331, -- Kor'koron Vanguard, Agmar's Hammer, Moa'ki, Unu'pe, Warsong Hold
				["0.48:0.56:0.52:0.62:0.62:0.64:0.60:0.75"] = 177, -- Kor'koron Vanguard, Dalaran, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.48:0.56:0.52:0.62:0.49:0.79"] = 171, -- Kor'koron Vanguard, Dalaran, Argent Tournament Grounds
				["0.48:0.56:0.45:0.49:0.31:0.57:0.24:0.60:0.18:0.53:0.15:0.43"] = 370, -- Kor'koron Vanguard, Agmar's Hammer, Warsong Camp, River's Heart, Bor'gorok Outpost, Warsong Hold
				["0.48:0.56:0.64:0.58:0.69:0.58:0.70:0.45:0.84:0.41"] = 310, -- Kor'koron Vanguard, Ebon Watch, Light's Breach, Conquest Hold, Camp Winterhoof
				["0.48:0.56:0.59:0.45:0.74:0.38:0.84:0.41"] = 247, -- Kor'koron Vanguard, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.48:0.56:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 265, -- Kor'koron Vanguard, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.48:0.56:0.59:0.45:0.85:0.27:0.74:0.29"] = 351, -- Стоянка отряда Кор'крона, Ядозлобь, Новый Агамонд, Камагуа

				-- Horde: Dragonblight: Moa'ki
				["0.49:0.42:0.45:0.49:0.31:0.57:0.24:0.60"] = 255, -- Moa'ki, Agmar's Hammer, Warsong Camp, River's Heart
				["0.49:0.42:0.52:0.62"] = 123, -- Moa'ki, Dalaran
				["0.49:0.42:0.45:0.49"] = 65, -- Moa'ki, Agmar's Hammer
				["0.49:0.42:0.54:0.48"] = 49, -- Moa'ki, Wyrmrest Temple
				["0.49:0.42:0.59:0.45"] = 62, -- Moa'ki, Venomspite
				["0.49:0.42:0.29:0.43"] = 133, -- Moa'ki, Unu'pe
				["0.49:0.42:0.59:0.45:0.70:0.45:0.84:0.49"] = 222, -- Moa'ki, Venomspite, Conquest Hold, Camp Oneqwah
				["0.49:0.42:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 293, -- Moa'ki, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.49:0.42:0.29:0.43:0.29:0.46"] = 154, -- Moa'ki, Unu'pe, Taunka'le Village
				["0.49:0.42:0.74:0.29:0.85:0.27"] = 247, -- Moa'ki, Kamagua, New Agamand
				["0.49:0.42:0.59:0.45:0.85:0.27"] = 247, -- Moa'ki, Venomspite, New Agamand
				["0.49:0.42:0.74:0.29"] = 184, -- Moa'ki, Kamagua
				["0.49:0.42:0.59:0.45:0.74:0.38:0.84:0.41:0.95:0.37"] = 292, -- Moa'ki, Venomspite, Apothecary Camp, Camp Winterhoof, Vengeance Landing
				["0.49:0.42:0.74:0.29:0.85:0.27:0.95:0.37"] = 327, -- Moa'ki, Kamagua, New Agamand, Vengeance Landing
				["0.49:0.42:0.45:0.49:0.29:0.46:0.15:0.43"] = 259, -- Moa'ki, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.49:0.42:0.29:0.43:0.29:0.46:0.18:0.53"] = 225, -- Moa'ki, Unu'pe, Taunka'le Village, Bor'gorok Outpost
				["0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47"] = 229, -- Moa'ki, Unu'pe, Taunka'le Village, Amber Ledge
				["0.49:0.42:0.29:0.43:0.15:0.43"] = 219, -- Moa'ki, Unu'pe, Warsong Hold
				["0.49:0.42:0.59:0.45:0.74:0.38"] = 160, -- Moa'ki, Venomspite, Apothecary Camp
				["0.49:0.42:0.59:0.45:0.70:0.45"] = 121, -- Moa'ki, Venomspite, Conquest Hold
				["0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47:0.12:0.47"] = 264, -- Moa'ki, Unu'pe, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.49:0.42:0.59:0.45:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 248, -- Moa'ki, Venomspite, Ebon Watch, The Argent Stand, Zim'Torga
				["0.49:0.42:0.45:0.49:0.29:0.46"] = 174, -- Moa'ki, Agmar's Hammer, Taunka'le Village
				["0.49:0.42:0.54:0.48:0.48:0.56"] = 115, -- Moa'ki, Wyrmrest Temple, Kor'koron Vanguard
				["0.49:0.42:0.74:0.29:0.85:0.27:0.84:0.41"] = 326, -- Moa'ki, Kamagua, Neu-Agamand, Lager der Winterhufe
				["0.49:0.42:0.29:0.43:0.29:0.46:0.18:0.53:0.24:0.60"] = 282, -- Moa'ki, Unu'pe, Taunka'le Village, Bor'gorok Outpost, River's Heart
				["0.49:0.42:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 286, -- Moa'ki, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.49:0.42:0.59:0.45:0.64:0.58:0.72:0.60"] = 208, -- Moa'ki, Venomspite, Ebon Watch, The Argent Stand
				["0.49:0.42:0.59:0.45:0.70:0.45:0.84:0.41"] = 205, -- Moa'ki, Rencor Venenoso, Bastión de la Conquista, Campamento Pezuña Invernal
				["0.49:0.42:0.59:0.45:0.69:0.58"] = 168, -- Moa'ki, Venomspite, Light's Breach
				["0.49:0.42:0.59:0.45:0.64:0.58"] = 144, -- Moa'ki, Venomspite, Ebon Watch
				["0.49:0.42:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 278, -- Moa'ki, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.49:0.42:0.29:0.43:0.15:0.43:0.17:0.47:0.18:0.53"] = 286, -- Moa'ki, Unu'pe, Warsong Hold, Amber Ledge, Bor'gorok Outpost
				["0.49:0.42:0.59:0.45:0.85:0.27:0.95:0.37"] = 326, -- Moa'ki, Venomspite, New Agamand, Vengeance Landing
				["0.49:0.42:0.59:0.45:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 302, -- Moa'ki, Venomspite, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.49:0.42:0.45:0.49:0.48:0.56"] = 126, -- Moa'ki, Agmar's Hammer, Kor'koron Vanguard
				["0.49:0.42:0.45:0.49:0.31:0.57"] = 179, -- Moa'ki, Agmar's Hammer, Warsong Camp
				["0.49:0.42:0.29:0.43:0.29:0.46:0.18:0.53:0.18:0.60"] = 273, -- Moa'ki, Unu'pe, Taunka'le Village, Bor'gorok Outpost, Nesingwary Base Camp
				["0.49:0.42:0.52:0.62:0.62:0.64"] = 167, -- Moa'ki, Dalaran, K3
				["0.49:0.42:0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 311, -- Moa'ki, Wyrmrest Temple, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.49:0.42:0.52:0.62:0.52:0.66:0.38:0.79"] = 273, -- Moa'ki, Dalaran, Cime des Croisés, Le caveau des Ombres
				["0.49:0.42:0.52:0.62:0.24:0.60"] = 322, -- Moa'ki, Dalaran, River's Heart
				["0.49:0.42:0.52:0.62:0.62:0.64:0.72:0.71"] = 267, -- Moa'ki, Dalaran, K3, Dun Nifflelem
				["0.49:0.42:0.59:0.45:0.74:0.38:0.84:0.41"] = 219, -- Moa'ki, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.49:0.42:0.45:0.49:0.29:0.46:0.17:0.47"] = 250, -- Moa'ki, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.49:0.42:0.52:0.62:0.52:0.66"] = 151, -- Moa'ki, Dalaran, Crusaders' Pinnacle
				["0.49:0.42:0.52:0.62:0.62:0.64:0.60:0.75:0.57:0.79"] = 278, -- Moa'ki, Dalaran, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.49:0.42:0.52:0.62:0.56:0.64"] = 145, -- Moa'ki, Dalaran, The Argent Vanguard
				["0.49:0.42:0.45:0.49:0.31:0.57:0.28:0.72"] = 291, -- Moa'ki, Agmar's Hammer, Warsong Camp, Death's Rise
				["0.49:0.42:0.74:0.29:0.74:0.38"] = 240, -- Moa'ki, Kamagua, Apothecary Camp
				["0.49:0.42:0.45:0.49:0.29:0.46:0.18:0.53:0.24:0.60"] = 303, -- Moa'ki, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost, River's Heart
				["0.49:0.42:0.52:0.62:0.62:0.64:0.73:0.75"] = 256, -- Moa'ki, Dalaran, K3, Camp Tunka'lo
				["0.49:0.42:0.52:0.62:0.49:0.79"] = 237, -- Moa'ki, Dalaran, Argent Tournament Grounds
				["0.49:0.42:0.52:0.62:0.56:0.64:0.38:0.79"] = 291, -- Moa'ki, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.49:0.42:0.45:0.49:0.29:0.46:0.18:0.53"] = 247, -- Моа'ки, Молот Агмара, Деревня Таунка'ле, Застава Бор'горока

				-- Horde: Dragonblight: Venomspite
				["0.59:0.45:0.54:0.48:0.52:0.62"] = 149, -- Venomspite, Wyrmrest Temple, Dalaran
				["0.59:0.45:0.54:0.48"] = 52, -- Venomspite, Wyrmrest Temple
				["0.59:0.45:0.49:0.42"] = 83, -- Venomspite, Moa'ki
				["0.59:0.45:0.45:0.49"] = 133, -- Venomspite, Agmar's Hammer
				["0.59:0.45:0.48:0.56"] = 121, -- Venomspite, Kor'koron Vanguard
				["0.59:0.45:0.70:0.45"] = 60, -- Venomspite, Conquest Hold
				["0.59:0.45:0.74:0.38"] = 99, -- Venomspite, Apothecary Camp
				["0.59:0.45:0.74:0.38:0.84:0.41:0.95:0.37"] = 231, -- Venomspite, Apothecary Camp, Camp Winterhoof, Vengeance Landing
				["0.59:0.45:0.85:0.27"] = 187, -- Venomspite, New Agamand
				["0.59:0.45:0.74:0.38:0.74:0.29"] = 152, -- Venomspite, Apothecary Camp, Kamagua
				["0.59:0.45:0.85:0.27:0.84:0.41"] = 264, -- Venomspite, New Agamand, Camp Winterhoof
				["0.59:0.45:0.74:0.38:0.84:0.41"] = 158, -- Venomspite, Apothecary Camp, Camp Winterhoof
				["0.59:0.45:0.85:0.27:0.95:0.37"] = 264, -- Venomspite, New Agamand, Vengeance Landing
				["0.59:0.45:0.85:0.27:0.74:0.29"] = 261, -- Vexevenin, Nouvelle-Agamand, Kamagua
				["0.59:0.45:0.70:0.45:0.84:0.41"] = 144, -- Venomspite, Conquest Hold, Camp Winterhoof
				["0.59:0.45:0.49:0.42:0.29:0.43:0.15:0.43"] = 301, -- Venomspite, Moa'ki, Unu'pe, Warsong Hold
				["0.59:0.45:0.45:0.49:0.29:0.46:0.18:0.53"] = 316, -- Venomspite, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.59:0.45:0.69:0.58:0.72:0.60"] = 150, -- Venomspite, Light's Breach, The Argent Stand
				["0.59:0.45:0.64:0.58:0.60:0.60"] = 110, -- Venomspite, Ebon Watch, Sunreaver's Command
				["0.59:0.45:0.45:0.49:0.29:0.46:0.17:0.47"] = 319, -- Venomspite, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.59:0.45:0.45:0.49:0.29:0.46:0.15:0.43"] = 328, -- Venomspite, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.59:0.45:0.74:0.38:0.84:0.41:0.84:0.49"] = 215, -- Venomspite, Apothecary Camp, Camp Winterhoof, Camp Oneqwah
				["0.59:0.45:0.49:0.42:0.52:0.62"] = 204, -- Venomspite, Moa'ki, Dalaran
				["0.59:0.45:0.45:0.49:0.29:0.46"] = 244, -- Venomspite, Agmar's Hammer, Taunka'le Village
				["0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 304, -- Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46"] = 231, -- Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.59:0.45:0.64:0.58"] = 83, -- Venomspite, Ebon Watch
				["0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 217, -- Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 342, -- Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 316, -- Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 306, -- Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.59:0.45:0.69:0.58"] = 107, -- Venomspite, Light's Breach
				["0.59:0.45:0.64:0.58:0.72:0.60"] = 147, -- Venomspite, Ebon Watch, The Argent Stand
				["0.59:0.45:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47:0.12:0.47"] = 346, -- Venomspite, Moa'ki, Unu'pe, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.59:0.45:0.54:0.48:0.52:0.62:0.52:0.66:0.38:0.79"] = 298, -- Venomspite, Wyrmrest Temple, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.59:0.45:0.70:0.45:0.84:0.49"] = 160, -- Venomspite, Conquest Hold, Camp Oneqwah
				["0.59:0.45:0.64:0.58:0.62:0.64:0.60:0.75"] = 199, -- Venomspite, Ebon Watch, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.59:0.45:0.49:0.42:0.29:0.43"] = 214, -- Venomspite, Moa'ki, Unu'pe
				["0.59:0.45:0.64:0.58:0.62:0.64:0.72:0.71"] = 224, -- Venomspite, Ebon Watch, K3, Dun Nifflelem
				["0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53:0.18:0.60"] = 350, -- Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost, Nesingwary Base Camp
				["0.59:0.45:0.64:0.58:0.62:0.64:0.60:0.75:0.57:0.79"] = 236, -- Venomspite, Ebon Watch, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.59:0.45:0.54:0.48:0.52:0.62:0.52:0.66:0.28:0.72"] = 343, -- Venomspite, Wyrmrest Temple, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.59:0.45:0.64:0.58:0.62:0.64"] = 124, -- Venomspite, Ebon Watch, K3
				["0.59:0.45:0.49:0.42:0.74:0.29"] = 266, -- Venomspite, Moa'ki, Kamagua
				["0.59:0.45:0.48:0.56:0.52:0.62"] = 176, -- Venomspite, Kor'koron Vanguard, Dalaran
				["0.59:0.45:0.54:0.48:0.45:0.49:0.31:0.57:0.24:0.60"] = 311, -- Venomspite, Wyrmrest Temple, Agmar's Hammer, Warsong Camp, River's Heart
				["0.59:0.45:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47"] = 310, -- Rencor Venenoso, Moa'ki, Unu'pe, Poblado Taunka'le, El Saliente Ámbar
				["0.59:0.45:0.64:0.58:0.52:0.62"] = 151, -- Venomspite, Ebon Watch, Dalaran
				["0.59:0.45:0.54:0.48:0.52:0.62:0.24:0.60"] = 348, -- Venomspite, Wyrmrest Temple, Dalaran, River's Heart
				["0.59:0.45:0.54:0.48:0.52:0.62:0.56:0.64"] = 171, -- Venomspite, Wyrmrest Temple, Dalaran, The Argent Vanguard
				["0.59:0.45:0.69:0.58:0.84:0.49:0.84:0.41"] = 259, -- Venomspite, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.59:0.45:0.69:0.58:0.84:0.49"] = 211, -- Gallgrimm, Lichtbresche, Camp Oneqwah
				["0.59:0.45:0.54:0.48:0.45:0.49:0.31:0.57"] = 235, -- Venomspite, Wyrmrest Temple, Agmar's Hammer, Warsong Camp
				["0.59:0.45:0.54:0.48:0.52:0.62:0.62:0.64"] = 192, -- Venomspite, Wyrmrest Temple, Dalaran, K3
				["0.59:0.45:0.54:0.48:0.52:0.62:0.52:0.66"] = 176, -- Venomspite, Wyrmrest Temple, Dalaran, Crusaders' Pinnacle
				["0.59:0.45:0.54:0.48:0.52:0.62:0.49:0.79"] = 262, -- Venomspite, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.59:0.45:0.64:0.58:0.62:0.64:0.60:0.75:0.64:0.81"] = 250, -- Venomspite, Ebon Watch, K3, Grom'arsh Crash-Site, Ulduar
				["0.59:0.45:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 241, -- Venomspite, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.59:0.45:0.54:0.48:0.52:0.62:0.56:0.64:0.38:0.79"] = 317, -- Venomspite, Wyrmrest Temple, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.59:0.45:0.64:0.58:0.62:0.64:0.73:0.75"] = 214, -- Venomspite, Ebon Watch, K3, Camp Tunka'lo
				["0.59:0.45:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 188, -- Venomspite, Ebon Watch, The Argent Stand, Zim'Torga

				-- Horde: Dragonblight: Wyrmrest Temple
				["0.54:0.48:0.52:0.62"] = 65, -- Wyrmrest Temple, Dalaran
				["0.54:0.48:0.45:0.49"] = 47, -- Wyrmrest Temple, Agmar's Hammer
				["0.54:0.48:0.49:0.42"] = 36, -- Wyrmrest Temple, Moa'ki
				["0.54:0.48:0.59:0.45"] = 35, -- Wyrmrest Temple, Venomspite
				["0.54:0.48:0.48:0.56"] = 45, -- Wyrmrest Temple, Kor'koron Vanguard
				["0.54:0.48:0.64:0.58:0.60:0.60"] = 89, -- Wyrmrest Temple, Ebon Watch, Sunreaver's Command
				["0.54:0.48:0.52:0.62:0.56:0.64"] = 79, -- Wyrmrest Temple, Dalaran, The Argent Vanguard
				["0.54:0.48:0.45:0.49:0.29:0.46"] = 120, -- Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.54:0.48:0.59:0.45:0.85:0.27"] = 158, -- Wyrmrest Temple, Venomspite, New Agamand
				["0.54:0.48:0.49:0.42:0.74:0.29:0.85:0.27"] = 200, -- Wyrmrest Temple, Moa'ki, Kamagua, New Agamand
				["0.54:0.48:0.59:0.45:0.70:0.45"] = 73, -- Wyrmrest Temple, Venomspite, Conquest Hold
				["0.54:0.48:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 178, -- Wyrmrest Temple, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.54:0.48:0.59:0.45:0.85:0.27:0.95:0.37"] = 210, -- Wyrmrest Temple, Venomspite, New Agamand, Vengeance Landing
				["0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 177, -- Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 194, -- Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.54:0.48:0.59:0.45:0.74:0.38:0.74:0.29"] = 135, -- Wyrmrest Temple, Venomspite, Apothecary Camp, Kamagua
				["0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 171, -- Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.54:0.48:0.64:0.58:0.69:0.58"] = 100, -- Wyrmrest Temple, Ebon Watch, Light's Breach
				["0.54:0.48:0.64:0.58"] = 71, -- Wyrmrest Temple, Ebon Watch
				["0.54:0.48:0.49:0.42:0.29:0.43:0.15:0.43:0.17:0.47:0.12:0.47"] = 229, -- Wyrmrest Temple, Moa'ki, Unu'pe, Warsong Hold, Amber Ledge, Transitus Shield
				["0.54:0.48:0.49:0.42:0.29:0.43"] = 124, -- Wyrmrest Temple, Moa'ki, Unu'pe
				["0.54:0.48:0.59:0.45:0.74:0.38:0.84:0.41:0.95:0.37"] = 187, -- Wyrmrest Temple, Venomspite, Apothecary Camp, Camp Winterhoof, Vengeance Landing
				["0.54:0.48:0.64:0.58:0.72:0.60"] = 113, -- Wyrmrest Temple, Ebon Watch, The Argent Stand
				["0.54:0.48:0.64:0.58:0.62:0.64:0.60:0.75"] = 148, -- Wyrmrest Temple, Ebon Watch, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.54:0.48:0.59:0.45:0.69:0.58"] = 105, -- Wyrmrest Temple, Venomspite, Light's Breach
				["0.54:0.48:0.52:0.62:0.52:0.66:0.38:0.79"] = 165, -- Wyrmrest Temple, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.54:0.48:0.59:0.45:0.70:0.45:0.84:0.49"] = 140, -- Wyrmrest Temple, Venomspite, Conquest Hold, Camp Oneqwah
				["0.54:0.48:0.59:0.45:0.74:0.38"] = 99, -- Wyrmrest Temple, Venomspite, Apothecary Camp
				["0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 169, -- Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.54:0.48:0.52:0.62:0.52:0.66"] = 84, -- Wyrmrest Temple, Dalaran, Crusaders' Pinnacle
				["0.54:0.48:0.64:0.58:0.62:0.64"] = 98, -- Wyrmrest Temple, Ebon Watch, K3
				["0.54:0.48:0.52:0.62:0.24:0.60"] = 198, -- Wyrmrest Temple, Dalaran, River's Heart
				["0.54:0.48:0.59:0.45:0.74:0.38:0.84:0.41"] = 139, -- Wyrmrest Temple, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.54:0.48:0.45:0.49:0.31:0.57:0.24:0.60"] = 174, -- Wyrmrest Temple, Agmar's Hammer, Warsong Camp, River's Heart
				["0.54:0.48:0.45:0.49:0.31:0.57:0.28:0.72"] = 198, -- Wyrmrest Temple, Agmar's Hammer, Warsong Camp, Death's Rise
				["0.54:0.48:0.64:0.58:0.62:0.64:0.72:0.71"] = 164, -- Wyrmrest Temple, Ebon Watch, K3, Dun Nifflelem
				["0.54:0.48:0.59:0.45:0.70:0.45:0.84:0.49:0.95:0.37"] = 210, -- Wyrmrest Temple, Venomspite, Conquest Hold, Camp Oneqwah, Vengeance Landing
				["0.54:0.48:0.64:0.58:0.62:0.64:0.73:0.75"] = 158, -- Wyrmrest Temple, Ebon Watch, K3, Camp Tunka'lo
				["0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 176, -- Wyrmrest Temple, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.54:0.48:0.64:0.58:0.62:0.64:0.60:0.75:0.57:0.79"] = 172, -- Wyrmrest Temple, Ebon Watch, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.54:0.48:0.49:0.42:0.29:0.43:0.29:0.46"] = 138, -- Wyrmrest Temple, Moa'ki, Unu'pe, Taunka'le Village
				["0.54:0.48:0.64:0.58:0.62:0.64:0.73:0.75:0.64:0.81:0.57:0.79"] = 238, -- Wyrmrest Temple, Ebon Watch, K3, Camp Tunka'lo, Ulduar, Bouldercrag's Refuge
				["0.54:0.48:0.45:0.49:0.31:0.57"] = 123, -- Wyrmrest Temple, Agmar's Hammer, Warsong Camp
				["0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 140, -- Temple du Repos du ver, Guet d'Ébène, Le séjour d'Argent, Zim'Torga
				["0.54:0.48:0.59:0.45:0.70:0.45:0.84:0.41"] = 129, -- Wyrmrest Temple, Venomspite, Conquest Hold, Camp Winterhoof
				["0.54:0.48:0.49:0.42:0.74:0.29"] = 158, -- Wyrmrest Temple, Moa'ki, Kamagua
				["0.54:0.48:0.59:0.45:0.69:0.58:0.72:0.60"] = 133, -- Wyrmrest Temple, Venomspite, Light's Breach, The Argent Stand
				["0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53:0.18:0.60"] = 199, -- Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost, Nesingwary Base Camp
				["0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53:0.24:0.60"] = 206, -- Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost, River's Heart
				["0.54:0.48:0.52:0.62:0.52:0.66:0.28:0.72"] = 194, -- Wyrmrest Temple, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.54:0.48:0.59:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 263, -- Храм Драконьего Покоя, Ядозлобь, Разлом Света, Серебряная застава, Зим'Торга, Ульдуар
				["0.54:0.48:0.52:0.62:0.56:0.64:0.38:0.79:0.28:0.72"] = 229, -- Wyrmrest Temple, Dalaran, The Argent Vanguard, The Shadow Vault, Death's Rise
				["0.54:0.48:0.52:0.62:0.62:0.64:0.60:0.75:0.57:0.79"] = 169, -- Wyrmrest Temple, Dalaran, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.54:0.48:0.52:0.62:0.62:0.64:0.72:0.71"] = 161, -- Wyrmrest Temple, Dalaran, K3, Dun Nifflelem
				["0.54:0.48:0.52:0.62:0.56:0.64:0.38:0.79"] = 178, -- Wyrmrest Temple, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.54:0.48:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47:0.12:0.47"] = 211, -- Templo del Reposo del Dragón, Moa'ki, Unu'pe, Poblado Taunka'le, El Saliente Ámbar, Escudo de Tránsito
				["0.54:0.48:0.52:0.62:0.56:0.64:0.60:0.75"] = 148, -- Wyrmrest Temple, Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.54:0.48:0.64:0.58:0.62:0.64:0.60:0.75:0.64:0.81"] = 182, -- Wyrmrest Temple, Ebon Watch, K3, Grom'arsh Crash-Site, Ulduar
				["0.54:0.48:0.59:0.45:0.69:0.58:0.84:0.49"] = 174, -- Wyrmrest Temple, Venomspite, Light's Breach, Camp Oneqwah
				["0.54:0.48:0.49:0.42:0.29:0.43:0.15:0.43"] = 182, -- Temple du Repos du ver, Moa'ki, Unu'pe, Bastion Chanteguerre
				["0.54:0.48:0.52:0.62:0.24:0.60:0.18:0.60"] = 222, -- Wyrmrest Temple, Dalaran, River's Heart, Nesingwary Base Camp
				["0.54:0.48:0.45:0.49:0.29:0.46:0.29:0.43"] = 140, -- Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Unu'pe
				["0.54:0.48:0.52:0.62:0.62:0.64:0.60:0.75"] = 144, -- Wyrmrest Temple, Dalaran, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.54:0.48:0.52:0.62:0.62:0.64"] = 94, -- Wyrmrest Temple, Dalaran, K3
				["0.54:0.48:0.49:0.42:0.74:0.29:0.85:0.27:0.95:0.37"] = 253, -- Wyrmruhtempel, Moa'ki, Kamagua, Neu-Agamand, Hafen der Vergeltung
				["0.54:0.48:0.52:0.62:0.56:0.64:0.60:0.75:0.57:0.79"] = 172, -- Wyrmrest Temple, Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.54:0.48:0.52:0.62:0.49:0.79"] = 141, -- Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.54:0.48:0.52:0.62:0.24:0.60:0.28:0.72:0.38:0.79"] = 317, -- Wyrmrest Temple, Dalaran, River's Heart, Death's Rise, The Shadow Vault
				["0.54:0.48:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 179, -- Wyrmrest Temple, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.54:0.48:0.45:0.49:0.31:0.57:0.24:0.60:0.18:0.53:0.15:0.43"] = 257, -- Wyrmrest Temple, Agmar's Hammer, Warsong Camp, River's Heart, Bor'gorok Outpost, Warsong Hold
				["0.54:0.48:0.52:0.62:0.56:0.64:0.60:0.75:0.64:0.81"] = 182, -- Wyrmruhtempel, Dalaran, Die Argentumvorhut, Absturzstelle Grom'ash, Ulduar
				["0.54:0.48:0.59:0.45:0.85:0.27:0.74:0.29"] = 208, -- Wyrmrest Temple, Venomspite, New Agamand, Kamagua
				["0.54:0.48:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41"] = 203, -- Wyrmrest Temple, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.54:0.48:0.64:0.58:0.69:0.58:0.84:0.49"] = 170, -- Wyrmrest Temple, Ebon Watch, Light's Breach, Camp Oneqwah

				----------------------------------------------------------------------
				-- Horde: Grizzly Hills
				----------------------------------------------------------------------

				-- Horde: Grizzly Hills: Camp Oneqwah
				["0.84:0.49:0.70:0.45:0.59:0.45:0.49:0.42:0.29:0.43:0.15:0.43"] = 483, -- Camp Oneqwah, Conquest Hold, Venomspite, Moa'ki, Unu'pe, Warsong Hold
				["0.84:0.49:0.78:0.62:0.82:0.69"] = 147, -- Camp Oneqwah, Zim'Torga, Gundrak
				["0.84:0.49:0.70:0.45"] = 96, -- Camp Oneqwah, Conquest Hold
				["0.84:0.49:0.70:0.45:0.59:0.45"] = 183, -- Camp Oneqwah, Conquest Hold, Venomspite
				["0.84:0.49:0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 512, -- Camp Oneqwah, Light's Breach, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.31:0.57"] = 346, -- Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, Warsong Camp
				["0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60"] = 397, -- Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, River's Heart
				["0.84:0.49:0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49"] = 291, -- Camp Oneqwah, Light's Breach, Ebon Watch, Wyrmrest Temple, Agmar's Hammer
				["0.84:0.49:0.70:0.45:0.59:0.45:0.49:0.42:0.29:0.43"] = 395, -- Camp Oneqwah, Conquest Hold, Venomspite, Moa'ki, Unu'pe
				["0.84:0.49:0.84:0.41:0.74:0.38:0.59:0.45"] = 223, -- Camp Oneqwah, Camp Winterhoof, Apothecary Camp, Venomspite
				["0.84:0.49:0.69:0.58"] = 93, -- Camp Oneqwah, Light's Breach
				["0.84:0.49:0.69:0.58:0.64:0.58:0.48:0.56:0.45:0.49"] = 292, -- Camp Oneqwah, Light's Breach, Ebon Watch, Kor'koron Vanguard, Agmar's Hammer
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62"] = 330, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran
				["0.84:0.49:0.72:0.60"] = 100, -- Camp Oneqwah, The Argent Stand
				["0.84:0.49:0.78:0.62:0.64:0.81"] = 246, -- Camp Oneqwah, Zim'Torga, Ulduar
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.48:0.56"] = 299, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Kor'koron Vanguard
				["0.84:0.49:0.70:0.45:0.59:0.45:0.64:0.58"] = 266, -- Camp Oneqwah, Conquest Hold, Venomspite, Ebon Watch
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49"] = 303, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer
				["0.84:0.49:0.78:0.62:0.78:0.61"] = 93, -- Camp Oneqwah, Zim'Torga
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62:0.24:0.60"] = 529, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran, River's Heart

				-- Horde: Grizzly Hills: Conquest Hold
				["0.70:0.45:0.74:0.38"] = 57, -- Conquest Hold, Apothecary Camp
				["0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62"] = 186, -- Conquest Hold, Light's Breach, Ebon Watch, Dalaran
				["0.70:0.45:0.84:0.41"] = 85, -- Conquest Hold, Camp Winterhoof
				["0.70:0.45:0.84:0.49"] = 102, -- Conquest Hold, Camp Oneqwah
				["0.70:0.45:0.74:0.38:0.85:0.27"] = 149, -- Conquest Hold, Apothecary Camp, New Agamand
				["0.70:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 164, -- Conquest Hold, Light's Breach, The Argent Stand, Zim'Torga
				["0.70:0.45:0.59:0.45:0.54:0.48"] = 139, -- Conquest Hold, Venomspite, Wyrmrest Temple
				["0.70:0.45:0.59:0.45"] = 88, -- Conquest Hold, Venomspite
				["0.70:0.45:0.69:0.58"] = 80, -- Conquest Hold, Light's Breach
				["0.70:0.45:0.59:0.45:0.45:0.49"] = 219, -- Conquest Hold, Venomspite, Agmar's Hammer
				["0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49"] = 207, -- Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer
				["0.70:0.45:0.59:0.45:0.54:0.48:0.48:0.56"] = 204, -- Conquest Hold, Venomspite, Wyrmrest Temple, Kor'koron Vanguard
				["0.70:0.45:0.59:0.45:0.64:0.58"] = 170, -- Conquest Hold, Venomspite, Ebon Watch
				["0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62"] = 234, -- Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran
				["0.70:0.45:0.69:0.58:0.72:0.60"] = 123, -- Bastion de la Conquête, La Brèche de Lumière, Le séjour d'Argent
				["0.70:0.45:0.69:0.58:0.64:0.58:0.60:0.60"] = 146, -- Conquest Hold, Light's Breach, Ebon Watch, Sunreaver's Command
				["0.70:0.45:0.84:0.41:0.95:0.37"] = 159, -- Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.70:0.45:0.59:0.45:0.49:0.42:0.29:0.43:0.15:0.43"] = 387, -- Conquest Hold, Venomspite, Moa'ki, Unu'pe, Warsong Hold
				["0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 402, -- Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 390, -- Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.70:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 249, -- Conquest Hold, Light's Breach, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.70:0.45:0.69:0.58:0.64:0.58"] = 119, -- Conquest Hold, Light's Breach, Ebon Watch
				["0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60"] = 384, -- Conquest Hold, Light's Breach, Ebon Watch, Dalaran, River's Heart
				["0.70:0.45:0.59:0.45:0.49:0.42"] = 170, -- Conquest Hold, Venomspite, Moa'ki
				["0.70:0.45:0.59:0.45:0.49:0.42:0.29:0.43:0.29:0.46"] = 322, -- Conquest Hold, Venomspite, Moa'ki, Unu'pe, Taunka'le Village
				["0.70:0.45:0.74:0.38:0.74:0.29"] = 111, -- Conquest Hold, Apothecary Camp, Kamagua
				["0.70:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 217, -- Bastión de la Conquista, Brecha de la Luz, El Confín Argenta, Zim'Torga, Gundrak
				["0.70:0.45:0.74:0.38:0.85:0.27:0.95:0.37"] = 228, -- Conquest Hold, Apothecary Camp, New Agamand, Vengeance Landing
				["0.70:0.45:0.84:0.49:0.95:0.37"] = 206, -- Conquest Hold, Camp Oneqwah, Vengeance Landing
				["0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 393, -- Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.70:0.45:0.59:0.45:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 441, -- Conquest Hold, Venomspite, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46"] = 318, -- Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 419, -- Conquest Hold, Light's Breach, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.70:0.45:0.59:0.45:0.49:0.42:0.29:0.43"] = 301, -- Conquest Hold, Venomspite, Moa'ki, Unu'pe
				["0.70:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 318, -- Conquest Hold, Light's Breach, The Argent Stand, Zim'Torga, Ulduar
				["0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64"] = 160, -- Conquest Hold, Light's Breach, Ebon Watch, K3
				["0.70:0.45:0.59:0.45:0.48:0.56:0.52:0.62"] = 262, -- Conquest Hold, Venomspite, Kor'koron Vanguard, Dalaran
				["0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53:0.18:0.60"] = 437, -- Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost, Nesingwary Base Camp
				["0.70:0.45:0.59:0.45:0.85:0.27:0.74:0.29"] = 348, -- Conquest Hold, Venomspite, New Agamand, Kamagua
				["0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64"] = 207, -- Conquest Hold, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard
				["0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 379, -- Burg Siegeswall, Lichtbresche, Schwarze Wacht, Dalaran, Kreuzfahrerturm, Todesanhöhe
				["0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62:0.24:0.60"] = 434, -- Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran, River's Heart
				["0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75"] = 235, -- Bastion de la Conquête, La Brèche de Lumière, Guet d'Ébène, K3, Point d'impact de Grom'arsh
				["0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 429, -- Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.31:0.57"] = 322, -- Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Warsong Camp
				["0.70:0.45:0.59:0.45:0.45:0.49:0.29:0.46"] = 330, -- Conquest Hold, Venomspite, Agmar's Hammer, Taunka'le Village
				["0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 212, -- Conquest Hold, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.70:0.45:0.84:0.41:0.85:0.27"] = 164, -- Conquest Hold, Camp Winterhoof, New Agamand
				["0.70:0.45:0.69:0.58:0.64:0.58:0.48:0.56:0.45:0.49"] = 279, -- Conquest Hold, Light's Breach, Ebon Watch, Kor'koron Vanguard, Agmar's Hammer
				["0.70:0.45:0.59:0.45:0.49:0.42:0.52:0.62"] = 290, -- Conquest Hold, Venomspite, Moa'ki, Dalaran
				["0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.73:0.75"] = 250, -- Conquest Hold, Light's Breach, Ebon Watch, K3, Camp Tunka'lo
				["0.70:0.45:0.59:0.45:0.85:0.27"] = 273, -- Bastion de la Conquête, Vexevenin, Nouvelle-Agamand, Nouvelle-Agamand
				["0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62:0.62:0.64:0.72:0.71"] = 379, -- Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran, K3, Dun Nifflelem
				["0.70:0.45:0.59:0.45:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47"] = 396, -- Conquest Hold, Venomspite, Moa'ki, Unu'pe, Taunka'le Village, Amber Ledge
				["0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75:0.64:0.81"] = 286, -- Conquest Hold, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Ulduar
				["0.70:0.45:0.59:0.45:0.64:0.58:0.60:0.60"] = 196, -- Conquest Hold, Venomspite, Ebon Watch, Sunreaver's Command
				["0.70:0.45:0.59:0.45:0.45:0.49:0.29:0.46:0.17:0.47"] = 405, -- Conquest Hold, Venomspite, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.70:0.45:0.59:0.45:0.45:0.49:0.29:0.46:0.15:0.43"] = 414, -- Conquest Hold, Venomspite, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.70:0.45:0.74:0.38:0.74:0.29:0.49:0.42:0.45:0.49"] = 369, -- Conquest Hold, Apothecary Camp, Kamagua, Moa'ki, Agmar's Hammer
				["0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62:0.56:0.64"] = 257, -- Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran, The Argent Vanguard
				["0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62:0.52:0.66:0.38:0.79"] = 385, -- Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.70:0.45:0.74:0.38:0.74:0.29:0.49:0.42:0.52:0.62"] = 427, -- Conquest Hold, Apothecary Camp, Kamagua, Moa'ki, Dalaran
				["0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 299, -- Conquest Hold, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.70:0.45:0.84:0.41:0.85:0.27:0.74:0.29"] = 237, -- 정복의 요새 (회색 구릉지), 겨울발굽 야영지 (울부짖는 협만), 신 아가만드 (울부짖는 협만), 카마구아 (울부짖는 협만), 카마구아 (울부짖는 협만)
				["0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62:0.49:0.79"] = 349, -- Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.70:0.45:0.59:0.45:0.85:0.27:0.95:0.37"] = 351, -- Conquest Hold, Venomspite, New Agamand, Vengeance Landing
				["0.70:0.45:0.59:0.45:0.64:0.58:0.62:0.64:0.60:0.75:0.64:0.81"] = 336, -- Conquest Hold, Venomspite, Ebon Watch, K3, Grom'arsh Crash-Site, Ulduar
				["0.70:0.45:0.59:0.45:0.64:0.58:0.52:0.62"] = 237, -- Conquest Hold, Venomspite, Ebon Watch, Dalaran
				["0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62:0.62:0.64:0.73:0.75:0.78:0.62:0.72:0.60"] = 519, -- Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran, K3, Camp Tunka'lo, Zim'Torga, The Argent Stand
				["0.70:0.45:0.74:0.38:0.74:0.29:0.49:0.42"] = 306, -- Bastión de la Conquista, Campamento de los Boticarios, Komawa, Moa'ki
				["0.70:0.45:0.84:0.49:0.78:0.62:0.78:0.61"] = 194, -- Conquest Hold, Camp Oneqwah, Zim'Torga

				----------------------------------------------------------------------
				-- Horde: Howling Fjord
				----------------------------------------------------------------------

				-- Horde: Howling Fjord: Apothecary Camp
				["0.74:0.38:0.74:0.29"] = 54, -- Apothecary Camp, Kamagua
				["0.74:0.38:0.84:0.41"] = 60, -- Apothecary Camp, Camp Winterhoof
				["0.74:0.38:0.85:0.27"] = 93, -- Apothecary Camp, New Agamand
				["0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62"] = 232, -- Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran
				["0.74:0.38:0.84:0.41:0.95:0.37"] = 133, -- Apothecary Camp, Camp Winterhoof, Vengeance Landing
				["0.74:0.38:0.84:0.41:0.84:0.49"] = 118, -- Apothecary Camp, Camp Winterhoof, Camp Oneqwah
				["0.74:0.38:0.70:0.45"] = 48, -- Apothecary Camp, Conquest Hold
				["0.74:0.38:0.59:0.45"] = 118, -- Apothecary Camp, Venomspite
				["0.74:0.38:0.59:0.45:0.54:0.48"] = 169, -- Apothecary Camp, Venomspite, Wyrmrest Temple
				["0.74:0.38:0.59:0.45:0.49:0.42"] = 200, -- Apothecary Camp, Venomspite, Moa'ki
				["0.74:0.38:0.59:0.45:0.49:0.42:0.29:0.43"] = 331, -- Apothecary Camp, Venomspite, Moa'ki, Unu'pe
				["0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46"] = 349, -- Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49"] = 238, -- Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer
				["0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 460, -- Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 433, -- Camp des Apothicaires, Vexevenin, Temple du Repos du ver, Marteau d'Agmar, Taunka'le, Bastion Chanteguerre
				["0.74:0.38:0.59:0.45:0.45:0.49"] = 250, -- Apothecary Camp, Venomspite, Agmar's Hammer
				["0.74:0.38:0.59:0.45:0.49:0.42:0.29:0.43:0.29:0.46:0.18:0.53"] = 424, -- Apothecary Camp, Venomspite, Moa'ki, Unu'pe, Taunka'le Village, Bor'gorok Outpost
				["0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64"] = 253, -- Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard
				["0.74:0.38:0.59:0.45:0.49:0.42:0.29:0.43:0.15:0.43"] = 418, -- Apothecary Camp, Venomspite, Moa'ki, Unu'pe, Warsong Hold
				["0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.60:0.60"] = 193, -- Apothekerlager, Burg Siegeswall, Lichtbresche, Schwarze Wacht, Sonnenhäschers Schar
				["0.74:0.38:0.84:0.41:0.84:0.49:0.78:0.62:0.72:0.71"] = 294, -- Apothecary Camp, Camp Winterhoof, Camp Oneqwah, Zim'Torga, Dun Nifflelem
				["0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60"] = 431, -- Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, River's Heart
				["0.74:0.38:0.85:0.27:0.95:0.37"] = 171, -- Apothecary Camp, New Agamand, Vengeance Landing
				["0.74:0.38:0.74:0.29:0.49:0.42:0.29:0.43:0.15:0.43:0.17:0.47:0.18:0.53"] = 534, -- Apothecary Camp, Kamagua, Moa'ki, Unu'pe, Warsong Hold, Amber Ledge, Bor'gorok Outpost
				["0.74:0.38:0.70:0.45:0.69:0.58"] = 127, -- Apothecary Camp, Conquest Hold, Light's Breach
				["0.74:0.38:0.59:0.45:0.45:0.49:0.29:0.46"] = 361, -- Apothecary Camp, Venomspite, Agmar's Hammer, Taunka'le Village
				["0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.31:0.57"] = 353, -- Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Warsong Camp
				["0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62"] = 265, -- Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran
				["0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75:0.57:0.79"] = 318, -- Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.74:0.38:0.59:0.45:0.64:0.58:0.72:0.60"] = 264, -- Apothecary Camp, Venomspite, Ebon Watch, The Argent Stand
				["0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 420, -- Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.74:0.38:0.74:0.29:0.49:0.42"] = 249, -- Apothecary Camp, Kamagua, Moa'ki
				["0.74:0.38:0.59:0.45:0.54:0.48:0.48:0.56"] = 235, -- Apothecary Camp, Venomspite, Wyrmrest Temple, Kor'koron Vanguard
				["0.74:0.38:0.70:0.45:0.69:0.58:0.72:0.60"] = 170, -- Apothekerlager, Burg Siegeswall, Lichtbresche, Argentumwache
				["0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 424, -- Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.31:0.57:0.24:0.60"] = 429, -- Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Warsong Camp, River's Heart
				["0.74:0.38:0.74:0.29:0.49:0.42:0.52:0.62"] = 371, -- Apothecary Camp, Kamagua, Moa'ki, Dalaran
				["0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75"] = 281, -- Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64"] = 206, -- Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, K3
				["0.74:0.38:0.70:0.45:0.84:0.49"] = 148, -- Apothecary Camp, Conquest Hold, Camp Oneqwah
				["0.74:0.38:0.84:0.41:0.84:0.49:0.78:0.62:0.82:0.69"] = 263, -- Apothecary Camp, Camp Winterhoof, Camp Oneqwah, Zim'Torga, Gundrak
				["0.74:0.38:0.59:0.45:0.45:0.49:0.29:0.46:0.15:0.43"] = 445, -- Apothecary Camp, Venomspite, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.74:0.38:0.70:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.73:0.75:0.60:0.75:0.57:0.79"] = 432, -- Apothecary Camp, Conquest Hold, Light's Breach, The Argent Stand, Zim'Torga, Camp Tunka'lo, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.74:0.38:0.59:0.45:0.45:0.49:0.29:0.46:0.17:0.47"] = 436, -- Apothecary Camp, Venomspite, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.74:0.38:0.59:0.45:0.64:0.58:0.52:0.62"] = 268, -- Apothecary Camp, Venomspite, Ebon Watch, Dalaran
				["0.74:0.38:0.74:0.29:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47"] = 476, -- Apothecary Camp, Kamagua, Moa'ki, Unu'pe, Taunka'le Village, Amber Ledge
				["0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 345, -- Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 425, -- Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58"] = 165, -- Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch
				["0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62:0.49:0.79"] = 379, -- Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53:0.18:0.60"] = 467, -- Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost, Nesingwary Base Camp
				["0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 381, -- Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.74:0.38:0.74:0.29:0.49:0.42:0.29:0.43:0.15:0.43"] = 467, -- Apothecary Camp, Kamagua, Moa'ki, Unu'pe, Warsong Hold
				["0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62:0.52:0.66:0.38:0.79"] = 415, -- Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 258, -- Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 400, -- Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, The Shadow Vault

				-- Horde: Howling Fjord: Camp Oneqwah
				["0.84:0.49:0.84:0.41"] = 49, -- Camp Oneqwah, Camp Winterhoof
				["0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62"] = 199, -- Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran
				["0.84:0.49:0.84:0.41:0.74:0.38"] = 106, -- Camp Oneqwah, Camp Winterhoof, Apothecary Camp
				["0.84:0.49:0.95:0.37"] = 106, -- Camp Oneqwah, Vengeance Landing
				["0.84:0.49:0.69:0.58:0.64:0.58"] = 132, -- Camp Oneqwah, Light's Breach, Ebon Watch
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 488, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.84:0.49:0.84:0.41:0.74:0.38:0.74:0.29"] = 160, -- Camp Oneqwah, Camp Winterhoof, Apothecary Camp, Kamagua
				["0.84:0.49:0.70:0.45:0.59:0.45:0.48:0.56:0.52:0.62"] = 357, -- Camp Oneqwah, Burg Siegeswall, Gallgrimm, Vorposten der Kor'kron, Dalaran
				["0.84:0.49:0.84:0.41:0.85:0.27"] = 129, -- Camp Oneqwah, Camp Winterhoof, New Agamand
				["0.84:0.49:0.69:0.58:0.64:0.58:0.54:0.48"] = 222, -- Camp Oneqwah, Light's Breach, Ebon Watch, Wyrmrest Temple
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 524, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48"] = 233, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple
				["0.84:0.49:0.72:0.60:0.64:0.58"] = 152, -- Camp Oneqwah, Argentumwache, Schwarze Wacht
				["0.84:0.49:0.69:0.58:0.64:0.58:0.48:0.56"] = 240, -- Camp Oneqwah, Lichtbresche, Schwarze Wacht, Vorposten der Kor'kron
				["0.84:0.49:0.70:0.45:0.59:0.45:0.49:0.42"] = 265, -- Camp Oneqwah, Conquest Hold, Venomspite, Moa'ki
				["0.84:0.49:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75:0.57:0.79"] = 284, -- Camp Oneqwah, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64"] = 220, -- Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard
				["0.84:0.49:0.70:0.45:0.59:0.45:0.49:0.42:0.52:0.62"] = 386, -- Camp Oneqwah, Conquest Hold, Venomspite, Moa'ki, Dalaran
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 498, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.84:0.49:0.70:0.45:0.59:0.45:0.45:0.49"] = 315, -- Camp Oneqwah, Conquest Hold, Venomspite, Agmar's Hammer
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62:0.62:0.64"] = 374, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran, K3
				["0.84:0.49:0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 476, -- Camp Oneqwah, Light's Breach, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.84:0.49:0.78:0.62:0.73:0.75:0.62:0.64:0.52:0.62"] = 363, -- Camp Oneqwah, Zim'Torga, Camp Tunka'lo, K3, Dalaran
				["0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 347, -- Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 432, -- Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53:0.18:0.60"] = 532, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost, Nesingwary Base Camp
				["0.84:0.49:0.78:0.62:0.72:0.71"] = 177, -- Camp Oneqwah, Zim'Torga, Dun Nifflelem
				["0.84:0.49:0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46"] = 401, -- Camp Oneqwah, Light's Breach, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 392, -- Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.31:0.57"] = 417, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Warsong Camp
				["0.84:0.49:0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 472, -- Camp Oneqwah, Lichtbresche, Schwarze Wacht, Wyrmruhtempel, Agmars Hammer, Taunka'le, Bor'goroks Außenposten
				["0.84:0.49:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75"] = 248, -- Camp Oneqwah, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.84:0.49:0.69:0.58:0.64:0.58:0.60:0.60"] = 159, -- Camp Oneqwah, Light's Breach, Ebon Watch, Sunreaver's Command
				["0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 312, -- Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.84:0.49:0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.48:0.56"] = 340, -- Camp Oneqwah, Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Kor'koron Vanguard
				["0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 225, -- Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62:0.49:0.79"] = 443, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.84:0.49:0.69:0.58:0.64:0.58:0.62:0.64"] = 172, -- Camp Oneqwah, Light's Breach, Ebon Watch, K3
				["0.84:0.49:0.78:0.62:0.64:0.81:0.57:0.79:0.49:0.79"] = 355, -- Camp Oneqwah, Zim'Torga, Ulduar, Bergfels' Zuflucht, Argentumturnierplatz
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.31:0.57:0.24:0.60"] = 494, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Warsong Camp, River's Heart
				["0.84:0.49:0.72:0.60:0.64:0.58:0.52:0.62:0.49:0.79"] = 332, -- Camp Oneqwah, The Argent Stand, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.84:0.49:0.70:0.45:0.59:0.45:0.49:0.42:0.52:0.62:0.49:0.79"] = 499, -- Camp Oneqwah, Conquest Hold, Venomspite, Moa'ki, Dalaran, Argent Tournament Grounds
				["0.84:0.49:0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62"] = 370, -- Camp Oneqwah, Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran
				["0.84:0.49:0.78:0.62:0.73:0.75:0.60:0.75"] = 278, -- Camp Oneqwah, Zim'Torga, Camp Tunka'lo, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 366, -- Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.84:0.49:0.78:0.62:0.73:0.75"] = 179, -- Лагерь Уанква, Зим'Торга, Лагерь Тунка'ло
				["0.84:0.49:0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62:0.49:0.79"] = 484, -- Camp Oneqwah, Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.84:0.49:0.84:0.41:0.74:0.38:0.74:0.29:0.49:0.42:0.45:0.49"] = 417, -- Camp Oneqwah, Camp Winterhoof, Apothecary Camp, Kamagua, Moa'ki, Agmar's Hammer
				["0.84:0.49:0.69:0.58:0.64:0.58:0.62:0.64:0.72:0.71"] = 272, -- Camp Oneqwah, Light's Breach, Ebon Watch, K3, Dun Nifflelem
				["0.84:0.49:0.70:0.45:0.74:0.38"] = 153, -- Camp Oneqwah, Conquest Hold, Apothecary Camp
				["0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.53"] = 450, -- Camp Oneqwah, Lichtbresche, Schwarze Wacht, Dalaran, Flussnabel, Bor'goroks Außenposten
				["0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.60:0.75"] = 322, -- Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 485, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.84:0.49:0.78:0.62:0.72:0.71:0.62:0.64"] = 265, -- Camp Oneqwah, Zim'Torga, Dun Niffelem, K3
				["0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46"] = 414, -- Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village

				-- Horde: Howling Fjord: Camp Winterhoof
				["0.84:0.41:0.85:0.27"] = 80, -- Camp Winterhoof, New Agamand
				["0.84:0.41:0.95:0.37"] = 75, -- Camp Winterhoof, Vengeance Landing
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62"] = 257, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran
				["0.84:0.41:0.84:0.49"] = 58, -- Camp Winterhoof, Camp Oneqwah
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64"] = 277, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard
				["0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.48:0.56"] = 291, -- Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Kor'koron Vanguard
				["0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.31:0.57"] = 409, -- Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Warsong Camp
				["0.84:0.41:0.74:0.38"] = 57, -- Camp Winterhoof, Apothecary Camp
				["0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48"] = 226, -- Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple
				["0.84:0.41:0.74:0.38:0.59:0.45:0.49:0.42:0.29:0.43"] = 387, -- Camp Winterhoof, Apothecary Camp, Venomspite, Moa'ki, Unu'pe
				["0.84:0.41:0.85:0.27:0.59:0.45"] = 273, -- Camp Winterhoof, New Agamand, Venomspite
				["0.84:0.41:0.85:0.27:0.74:0.29:0.49:0.42"] = 348, -- Camp Winterhoof, New Agamand, Kamagua, Moa'ki
				["0.84:0.41:0.74:0.38:0.59:0.45"] = 174, -- Camp Winterhoof, Apothecary Camp, Venomspite
				["0.84:0.41:0.74:0.38:0.74:0.29:0.49:0.42"] = 305, -- Camp Winterhoof, Apothecary Camp, Kamagua, Moa'ki
				["0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49"] = 295, -- Camp Sabot-d'hiver, Camp des Apothicaires, Vexevenin, Temple du Repos du ver, Marteau d'Agmar
				["0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62"] = 322, -- Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran
				["0.84:0.41:0.74:0.38:0.74:0.29"] = 111, -- Camp Winterhoof, Apothecary Camp, Kamagua
				["0.84:0.41:0.85:0.27:0.74:0.29"] = 153, -- Camp Winterhoof, New Agamand, Kamagua
				["0.84:0.41:0.74:0.38:0.59:0.45:0.49:0.42"] = 256, -- Camp Winterhoof, Apothecary Camp, Venomspite, Moa'ki
				["0.84:0.41:0.74:0.38:0.59:0.45:0.49:0.42:0.29:0.43:0.15:0.43"] = 474, -- Camp Winterhoof, Apothecary Camp, Venomspite, Moa'ki, Unu'pe, Warsong Hold
				["0.84:0.41:0.70:0.45"] = 94, -- Camp Winterhoof, Conquest Hold
				["0.84:0.41:0.74:0.38:0.59:0.45:0.45:0.49"] = 307, -- Camp Winterhoof, Apothecary Camp, Venomspite, Agmar's Hammer
				["0.84:0.41:0.74:0.38:0.59:0.45:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 528, -- Camp Winterhoof, Apothecary Camp, Venomspite, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.84:0.41:0.84:0.49:0.69:0.58"] = 151, -- Camp Winterhoof, Camp Oneqwah, Light's Breach
				["0.84:0.41:0.74:0.38:0.74:0.29:0.49:0.42:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 589, -- Camp Winterhoof, Apothecary Camp, Kamagua, Moa'ki, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.84:0.41:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62"] = 279, -- Camp Winterhoof, Conquest Hold, Light's Breach, Ebon Watch, Dalaran
				["0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 516, -- Camp Sabot-d'hiver, Camp des Apothicaires, Vexevenin, Temple du Repos du ver, Marteau d'Agmar, Taunka'le, Escarpement d'Ambre, Bouclier Transitus
				["0.84:0.41:0.70:0.45:0.59:0.45"] = 180, -- Camp Winterhoof, Conquest Hold, Venomspite
				["0.84:0.41:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49"] = 300, -- Camp Winterhoof, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer
				["0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 490, -- Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 477, -- Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58"] = 190, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch
				["0.84:0.41:0.74:0.38:0.74:0.29:0.49:0.42:0.45:0.49"] = 369, -- Camp Winterhoof, Apothecary Camp, Kamagua, Moa'ki, Agmar's Hammer
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 530, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.84:0.41:0.84:0.49:0.78:0.62:0.78:0.61"] = 151, -- Camp Winterhoof, Camp Oneqwah, Zim'Torga
				["0.84:0.41:0.74:0.38:0.59:0.45:0.64:0.58:0.62:0.64:0.60:0.75"] = 373, -- Camp Winterhoof, Apothecary Camp, Venomspite, Ebon Watch, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 405, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.84:0.41:0.85:0.27:0.59:0.45:0.54:0.48:0.48:0.56"] = 390, -- Camp Winterhoof, New Agamand, Venomspite, Wyrmrest Temple, Kor'koron Vanguard
				["0.84:0.41:0.74:0.38:0.74:0.29:0.49:0.42:0.29:0.43"] = 436, -- Camp Winterhoof, Apothecary Camp, Kamagua, Moa'ki, Unu'pe
				["0.84:0.41:0.84:0.49:0.78:0.62:0.72:0.71"] = 235, -- Camp Winterhoof, Camp Oneqwah, Zim'Torga, Dun Nifflelem
				["0.84:0.41:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75"] = 327, -- Camp Winterhoof, Conquest Hold, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 283, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46"] = 406, -- Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62:0.52:0.66:0.38:0.79"] = 472, -- Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.84:0.41:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.31:0.57"] = 414, -- Camp Winterhoof, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Warsong Camp
				["0.84:0.41:0.74:0.38:0.59:0.45:0.69:0.58"] = 281, -- Lager der Winterhufe, Apothekerlager, Gallgrimm, Lichtbresche
				["0.84:0.41:0.74:0.38:0.59:0.45:0.45:0.49:0.29:0.46"] = 417, -- Camp Winterhoof, Apothecary Camp, Venomspite, Agmar's Hammer, Taunka'le Village
				["0.84:0.41:0.70:0.45:0.69:0.58"] = 173, -- Camp Winterhoof, Conquest Hold, Light's Breach
				["0.84:0.41:0.84:0.49:0.78:0.62:0.82:0.69"] = 203, -- Camp Winterhoof, Camp Oneqwah, Zim'Torga, Gundrak
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.62:0.64"] = 230, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, K3
				["0.84:0.41:0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62"] = 327, -- Camp Winterhoof, Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran
				["0.84:0.41:0.84:0.49:0.78:0.62:0.64:0.81"] = 304, -- Camp Winterhoof, Camp Oneqwah, Zim'Torga, Ulduar
				["0.84:0.41:0.74:0.38:0.74:0.29:0.49:0.42:0.52:0.62"] = 426, -- Camp Winterhoof, Apothecary Camp, Kamagua, Moa'ki, Dalaran
				["0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62:0.24:0.60"] = 522, -- Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran, River's Heart
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 489, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.84:0.41:0.70:0.45:0.59:0.45:0.54:0.48"] = 230, -- Camp Winterhoof, Conquest Hold, Venomspite, Wyrmrest Temple
				["0.84:0.41:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60"] = 477, -- Camp Winterhoof, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, River's Heart
				["0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 480, -- Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.84:0.41:0.74:0.38:0.59:0.45:0.49:0.42:0.29:0.43:0.29:0.46"] = 408, -- Camp Winterhoof, Apothecary Camp, Venomspite, Moa'ki, Unu'pe, Taunka'le Village
				["0.84:0.41:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64"] = 252, -- Camp Winterhoof, Conquest Hold, Light's Breach, Ebon Watch, K3
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75:0.57:0.79"] = 341, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.84:0.41:0.74:0.38:0.59:0.45:0.45:0.49:0.29:0.46:0.15:0.43"] = 501, -- Camp Winterhoof, Apothecary Camp, Venomspite, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.84:0.41:0.74:0.38:0.74:0.29:0.49:0.42:0.29:0.43:0.15:0.43"] = 524, -- Camp Winterhoof, Apothecary Camp, Kamagua, Moa'ki, Unu'pe, Warsong Hold
				["0.84:0.41:0.85:0.27:0.74:0.29:0.49:0.42:0.52:0.62"] = 470, -- Camp Winterhoof, New Agamand, Kamagua, Moa'ki, Dalaran
				["0.84:0.41:0.70:0.45:0.59:0.45:0.49:0.42"] = 261, -- Camp Winterhoof, Conquest Hold, Venomspite, Moa'ki
				["0.84:0.41:0.70:0.45:0.59:0.45:0.48:0.56:0.52:0.62"] = 355, -- Camp Winterhoof, Conquest Hold, Venomspite, Kor'koron Vanguard, Dalaran
				["0.84:0.41:0.74:0.38:0.59:0.45:0.48:0.56:0.52:0.62"] = 349, -- Camp Winterhoof, Apothecary Camp, Venomspite, Kor'koron Vanguard, Dalaran
				["0.84:0.41:0.84:0.49:0.78:0.62:0.73:0.75"] = 236, -- Camp Winterhoof, Camp Oneqwah, Zim'Torga, Camp Tunka'lo
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75"] = 305, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62:0.49:0.79"] = 436, -- Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 369, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.84:0.41:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 392, -- Camp Winterhoof, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.84:0.41:0.74:0.38:0.74:0.29:0.49:0.42:0.45:0.49:0.29:0.46"] = 479, -- Camp Winterhoof, Apothecary Camp, Kamagua, Moa'ki, Agmar's Hammer, Taunka'le Village
				["0.84:0.41:0.84:0.49:0.72:0.60"] = 158, -- Lager der Winterhufe, Camp Oneqwah, Argentumwache
				["0.84:0.41:0.85:0.27:0.59:0.45:0.54:0.48:0.52:0.62"] = 421, -- Camp Winterhoof, New Agamand, Venomspite, Wyrmrest Temple, Dalaran
				["0.84:0.41:0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62:0.49:0.79"] = 441, -- Camp Winterhoof, Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60"] = 454, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, River's Heart
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.60:0.60"] = 216, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Sunreaver's Command
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.48:0.56:0.45:0.49"] = 349, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Kor'koron Vanguard, Agmar's Hammer
				["0.84:0.41:0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62:0.52:0.66"] = 354, -- Camp Winterhoof, Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran, Crusaders' Pinnacle
				["0.84:0.41:0.84:0.49:0.78:0.62:0.64:0.81:0.57:0.79:0.49:0.79"] = 413, -- Camp Winterhoof, Camp Oneqwah, Zim'Torga, Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.84:0.41:0.85:0.27:0.59:0.45:0.64:0.58"] = 356, -- Camp Winterhoof, New Agamand, Venomspite, Ebon Watch
				["0.84:0.41:0.84:0.49:0.78:0.62:0.73:0.75:0.60:0.75"] = 336, -- Camp Winterhoof, Camp Oneqwah, Zim'Torga, Camp Tunka'lo, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.84:0.41:0.70:0.45:0.69:0.58:0.64:0.58:0.60:0.60"] = 239, -- Camp Winterhoof, Conquest Hold, Light's Breach, Ebon Watch, Sunreaver's Command
				["0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62:0.56:0.64"] = 344, -- Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran, The Argent Vanguard
				["0.84:0.41:0.74:0.38:0.59:0.45:0.49:0.42:0.52:0.62:0.49:0.79"] = 491, -- Camp Winterhoof, Apothecary Camp, Venomspite, Moa'ki, Dalaran, Argent Tournament Grounds
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 449, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.84:0.41:0.84:0.49:0.72:0.60:0.64:0.58:0.62:0.64"] = 250, -- Camp Winterhoof, Camp Oneqwah, The Argent Stand, Ebon Watch, K3
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.60:0.75"] = 379, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.84:0.41:0.74:0.38:0.59:0.45:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47:0.12:0.47"] = 519, -- Camp Winterhoof, Apothecary Camp, Venomspite, Moa'ki, Unu'pe, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.84:0.41:0.84:0.49:0.72:0.60:0.64:0.58:0.52:0.62"] = 277, -- Camp Winterhoof, Camp Oneqwah, The Argent Stand, Ebon Watch, Dalaran
				["0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.54:0.48"] = 280, -- Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Wyrmrest Temple

				-- Horde: Howling Fjord: Kamagua
				["0.74:0.29:0.85:0.27"] = 64, -- Kamagua, New Agamand
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62"] = 288, -- Kamagua, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran
				["0.74:0.29:0.74:0.38:0.84:0.41:0.84:0.49:0.78:0.62:0.78:0.61"] = 265, -- Kamagua, Apothecary Camp, Camp Winterhoof, Camp Oneqwah, Zim'Torga
				["0.74:0.29:0.74:0.38"] = 56, -- Kamagua, Apothecary Camp
				["0.74:0.29:0.85:0.27:0.95:0.37"] = 143, -- Kamagua, New Agamand, Vengeance Landing
				["0.74:0.29:0.49:0.42:0.29:0.43"] = 326, -- Kamagua, Moa'ki, Unu'pe
				["0.74:0.29:0.74:0.38:0.84:0.41:0.84:0.49:0.78:0.62:0.82:0.69"] = 318, -- Kamagua, Apothecary Camp, Camp Winterhoof, Camp Oneqwah, Zim'Torga, Gundrak
				["0.74:0.29:0.49:0.42:0.29:0.43:0.29:0.46"] = 348, -- Kamagua, Moa'ki, Unu'pe, Taunka'le Village
				["0.74:0.29:0.74:0.38:0.84:0.41"] = 116, -- Kamagua, Apothecary Camp, Camp Winterhoof
				["0.74:0.29:0.85:0.27:0.84:0.41"] = 143, -- Kamagua, New Agamand, Camp Winterhoof
				["0.74:0.29:0.85:0.27:0.84:0.41:0.84:0.49"] = 198, -- Kamagua, New Agamand, Camp Winterhoof, Camp Oneqwah
				["0.74:0.29:0.74:0.38:0.59:0.45:0.54:0.48"] = 224, -- Kamagua, Apothecary Camp, Venomspite, Wyrmrest Temple
				["0.74:0.29:0.74:0.38:0.59:0.45"] = 174, -- Kamagua, Apothecary Camp, Venomspite
				["0.74:0.29:0.74:0.38:0.84:0.41:0.95:0.37"] = 189, -- Kamagua, Apothecary Camp, Camp Winterhoof, Vengeance Landing
				["0.74:0.29:0.49:0.42:0.54:0.48:0.48:0.56"] = 308, -- Kamagua, Moa'ki, Wyrmrest Temple, Kor'koron Vanguard
				["0.74:0.29:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49"] = 294, -- Kamagua, Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer
				["0.74:0.29:0.49:0.42"] = 195, -- Kamagua, Moa'ki
				["0.74:0.29:0.74:0.38:0.70:0.45"] = 103, -- Kamagua, Apothecary Camp, Conquest Hold
				["0.74:0.29:0.49:0.42:0.45:0.49"] = 258, -- Kamagua, Moa'ki, Agmar's Hammer
				["0.74:0.29:0.49:0.42:0.29:0.43:0.15:0.43"] = 413, -- Kamagua, Moa'ki, Unu'pe, Warsong Hold
				["0.74:0.29:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62"] = 321, -- Kamagua, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran
				["0.74:0.29:0.74:0.38:0.59:0.45:0.45:0.49"] = 305, -- Kamagua, Apothecary Camp, Venomspite, Agmar's Hammer
				["0.74:0.29:0.49:0.42:0.45:0.49:0.29:0.46"] = 369, -- Kamagua, Moa'ki, Agmar's Hammer, Taunka'le Village
				["0.74:0.29:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46"] = 404, -- Kamagua, Apothekerlager, Gallgrimm, Wyrmruhtempel, Agmars Hammer, Taunka'le
				["0.74:0.29:0.74:0.38:0.84:0.41:0.84:0.49:0.78:0.62:0.72:0.71"] = 350, -- Kamagua, Apothecary Camp, Camp Winterhoof, Camp Oneqwah, Zim'Torga, Dun Nifflelem
				["0.74:0.29:0.49:0.42:0.52:0.62"] = 317, -- Kamagua, Moa'ki, Dalaran
				["0.74:0.29:0.74:0.38:0.59:0.45:0.54:0.48:0.48:0.56"] = 291, -- Kamagua, Apothecary Camp, Venomspite, Wyrmrest Temple, Kor'koron Vanguard
				["0.74:0.29:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47:0.12:0.47"] = 458, -- Kamagua, Moa'ki, Unu'pe, Taunka'le, Escarpement d'Ambre, Bouclier Transitus
				["0.74:0.29:0.49:0.42:0.29:0.43:0.29:0.46:0.18:0.53:0.18:0.60"] = 467, -- Kamagua, Moa'ki, Unu'pe, Taunka'le, Bor'goroks Außenposten, Nesingwarys Basislager
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58"] = 221, -- Kamagua, Camp des Apothicaires, Bastion de la Conquête, La Brèche de Lumière, Guet d'Ébène
				["0.74:0.29:0.49:0.42:0.29:0.43:0.29:0.46:0.18:0.53:0.24:0.60"] = 475, -- Kamagua, Moa'ki, Unu'pe, Taunka'le Village, Bor'gorok Outpost, River's Heart
				["0.74:0.29:0.49:0.42:0.54:0.48"] = 243, -- Kamagua, Moa'ki, Wyrmrest Temple
				["0.74:0.29:0.74:0.38:0.59:0.45:0.64:0.58"] = 256, -- Kamagua, Apothecary Camp, Venomspite, Ebon Watch
				["0.74:0.29:0.49:0.42:0.45:0.49:0.29:0.46:0.15:0.43"] = 453, -- Kamagua, Moa'ki, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.74:0.29:0.49:0.42:0.59:0.45:0.69:0.58:0.72:0.60"] = 405, -- Kamagua, Moa'ki, Venomspite, Light's Breach, The Argent Stand
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.72:0.60"] = 225, -- Kamagua, Apothecary Camp, Conquest Hold, Light's Breach, The Argent Stand
				["0.74:0.29:0.74:0.38:0.84:0.41:0.84:0.49"] = 172, -- Kamagua, Apothecary Camp, Camp Winterhoof, Camp Oneqwah
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 350, -- Kamagua, Apothecary Camp, Conquest Hold, Light's Breach, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64"] = 261, -- Kamagua, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, K3
				["0.74:0.29:0.85:0.27:0.59:0.45:0.45:0.49"] = 389, -- Kamagua, New Agamand, Venomspite, Agmar's Hammer
				["0.74:0.29:0.74:0.38:0.59:0.45:0.64:0.58:0.72:0.60"] = 320, -- Kamagua, Apothecary Camp, Venomspite, Ebon Watch, The Argent Stand
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75:0.57:0.79"] = 373, -- Kamagua, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 314, -- Kamagua, Apothekerlager, Burg Siegeswall, Lichtbresche, Schwarze Wacht, Dalaran, Kreuzfahrerturm
				["0.74:0.29:0.49:0.42:0.45:0.49:0.31:0.57:0.24:0.60"] = 449, -- Kamagua, Moa'ki, Agmar's Hammer, Warsong Camp, River's Heart
				["0.74:0.29:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47"] = 423, -- Kamagua, Moa'ki, Unu'pe, Taunka'le Village, Amber Ledge
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 481, -- Kamagua, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 455, -- Kamagua, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.74:0.29:0.49:0.42:0.45:0.49:0.31:0.57:0.28:0.72"] = 485, -- Kamagua, Moa'ki, Agmar's Hammer, Warsong Camp, Death's Rise
				["0.74:0.29:0.49:0.42:0.52:0.62:0.62:0.64:0.72:0.71"] = 461, -- Kamagua, Moa'ki, Dalaran, K3, Dun Nifflelem
				["0.74:0.29:0.49:0.42:0.45:0.49:0.31:0.57"] = 372, -- Kamagua, Moa'ki, Agmar's Hammer, Warsong Camp
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64"] = 309, -- Kamagua, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard
				["0.74:0.29:0.49:0.42:0.45:0.49:0.29:0.46:0.17:0.47"] = 444, -- Kamagua, Moa'ki, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.74:0.29:0.49:0.42:0.29:0.43:0.29:0.46:0.18:0.53"] = 420, -- Kamagua, Moa'ki, Unu'pe, Taunka'le Village, Bor'gorok Outpost
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58"] = 182, -- Kamagua, Apothecary Camp, Conquest Hold, Light's Breach
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 436, -- Kamagua, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.74:0.29:0.74:0.38:0.59:0.45:0.64:0.58:0.62:0.64:0.72:0.71"] = 396, -- Kamagua, Apothekerlager, Gallgrimm, Schwarze Wacht, K3, Dun Niffelem
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.72:0.71"] = 362, -- Kamagua, Apothekerlager, Burg Siegeswall, Lichtbresche, Schwarze Wacht, K3, Dun Niffelem
				["0.74:0.29:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62:0.52:0.66:0.38:0.79"] = 471, -- Kamagua, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.74:0.29:0.74:0.38:0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62"] = 370, -- Kamagua, Apothecary Camp, Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75"] = 337, -- Kamagua, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.74:0.29:0.85:0.27:0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.62:0.64"] = 370, -- Kamagua, New Agamand, Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, K3
				["0.74:0.29:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62:0.62:0.64:0.72:0.71"] = 465, -- Kamagua, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran, K3, Dun Nifflelem
				["0.74:0.29:0.49:0.42:0.45:0.49:0.29:0.46:0.18:0.53"] = 441, -- Kamagua, Moa'ki, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.74:0.29:0.85:0.27:0.84:0.41:0.84:0.49:0.78:0.62:0.72:0.71"] = 375, -- Kamagua, New Agamand, Camp Winterhoof, Camp Oneqwah, Zim'Torga, Dun Nifflelem
				["0.74:0.29:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62:0.62:0.64"] = 365, -- Kamagua, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran, K3
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 400, -- 卡瑪廓，凜風峽灣, 藥劑師營地，凜風峽灣, 征服堡，灰白之丘, 聖光止境，祖爾德拉克, 黯黑守望，祖爾德拉克, 達拉然, 銀白聯賽場地，寒冰皇冠
				["0.74:0.29:0.74:0.38:0.59:0.45:0.64:0.58:0.52:0.62"] = 323, -- Kamagua, Apothekerlager, Gallgrimm, Schwarze Wacht, Dalaran
				["0.74:0.29:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75:0.64:0.81"] = 388, -- Kamagua, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Ulduar
				["0.74:0.29:0.85:0.27:0.59:0.45:0.64:0.58:0.62:0.64"] = 379, -- Kamagua, New Agamand, Venomspite, Ebon Watch, K3
				["0.74:0.29:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62:0.49:0.79"] = 434, -- Kamagua, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.74:0.29:0.49:0.42:0.52:0.62:0.49:0.79"] = 430, -- Kamagua, Moa'ki, Dalaran, Argent Tournament Grounds
				["0.74:0.29:0.74:0.38:0.84:0.41:0.84:0.49:0.78:0.62:0.73:0.75"] = 351, -- Kamagua, Apothecary Camp, Camp Winterhoof, Camp Oneqwah, Zim'Torga, Camp Tunka'lo

				-- Horde: Howling Fjord: New Agamand
				["0.85:0.27:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62"] = 335, -- New Agamand, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran
				["0.85:0.27:0.95:0.37"] = 80, -- New Agamand, Vengeance Landing
				["0.85:0.27:0.74:0.29"] = 77, -- New Agamand, Kamagua
				["0.85:0.27:0.84:0.41:0.84:0.49"] = 136, -- New Agamand, Camp Winterhoof, Camp Oneqwah
				["0.85:0.27:0.74:0.38"] = 104, -- New Agamand, Apothecary Camp
				["0.85:0.27:0.84:0.41"] = 80, -- New Agamand, Camp Winterhoof
				["0.85:0.27:0.74:0.38:0.70:0.45"] = 150, -- New Agamand, Apothecary Camp, Conquest Hold
				["0.85:0.27:0.74:0.29:0.49:0.42:0.29:0.43"] = 402, -- New Agamand, Kamagua, Moa'ki, Unu'pe
				["0.85:0.27:0.74:0.29:0.49:0.42:0.29:0.43:0.15:0.43"] = 489, -- New Agamand, Kamagua, Moa'ki, Unu'pe, Warsong Hold
				["0.85:0.27:0.74:0.29:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47:0.12:0.47"] = 534, -- New Agamand, Kamagua, Moa'ki, Unu'pe, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.85:0.27:0.74:0.29:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47"] = 498, -- New Agamand, Kamagua, Moa'ki, Unu'pe, Taunka'le Village, Amber Ledge
				["0.85:0.27:0.74:0.29:0.49:0.42:0.29:0.43:0.29:0.46:0.18:0.53"] = 496, -- New Agamand, Kamagua, Moa'ki, Unu'pe, Taunka'le Village, Bor'gorok Outpost
				["0.85:0.27:0.74:0.29:0.49:0.42:0.29:0.43:0.29:0.46"] = 424, -- New Agamand, Kamagua, Moa'ki, Unu'pe, Taunka'le Village
				["0.85:0.27:0.59:0.45:0.54:0.48:0.45:0.49:0.31:0.57:0.24:0.60"] = 506, -- New Agamand, Venomspite, Wyrmrest Temple, Agmar's Hammer, Warsong Camp, River's Heart
				["0.85:0.27:0.59:0.45:0.54:0.48:0.45:0.49:0.31:0.57"] = 429, -- New Agamand, Venomspite, Wyrmrest Temple, Agmar's Hammer, Warsong Camp
				["0.85:0.27:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 528, -- New Agamand, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.85:0.27:0.59:0.45"] = 194, -- New Agamand, Venomspite
				["0.85:0.27:0.59:0.45:0.45:0.49"] = 327, -- New Agamand, Venomspite, Agmar's Hammer
				["0.85:0.27:0.59:0.45:0.54:0.48"] = 246, -- New Agamand, Venomspite, Wyrmrest Temple
				["0.85:0.27:0.74:0.29:0.49:0.42"] = 271, -- New Agamand, Kamagua, Moa'ki
				["0.85:0.27:0.59:0.45:0.54:0.48:0.45:0.49"] = 315, -- New Agamand, Venomspite, Wyrmrest Temple, Agmar's Hammer
				["0.85:0.27:0.74:0.38:0.70:0.45:0.69:0.58"] = 229, -- New Agamand, Apothecary Camp, Conquest Hold, Light's Breach
				["0.85:0.27:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 501, -- New Agamand, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.85:0.27:0.74:0.29:0.49:0.42:0.45:0.49"] = 334, -- New Agamand, Kamagua, Moa'ki, Agmar's Hammer
				["0.85:0.27:0.59:0.45:0.48:0.56:0.52:0.62"] = 370, -- New Agamand, Venomspite, Kor'koron Vanguard, Dalaran
				["0.85:0.27:0.59:0.45:0.54:0.48:0.52:0.62"] = 342, -- New Agamand, Venomspite, Wyrmrest Temple, Dalaran
				["0.85:0.27:0.95:0.37:0.84:0.49:0.69:0.58"] = 275, -- New Agamand, Vengeance Landing, Camp Oneqwah, Light's Breach
				["0.85:0.27:0.59:0.45:0.49:0.42"] = 277, -- New Agamand, Venomspite, Moa'ki
				["0.85:0.27:0.84:0.41:0.84:0.49:0.78:0.62:0.78:0.61"] = 228, -- New Agamand, Camp Winterhoof, Camp Oneqwah, Zim'Torga
				["0.85:0.27:0.84:0.41:0.84:0.49:0.78:0.62:0.64:0.81"] = 381, -- New Agamand, Camp Winterhoof, Camp Oneqwah, Zim'Torga, Ulduar
				["0.85:0.27:0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62"] = 334, -- New Agamand, Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran
				["0.85:0.27:0.84:0.41:0.84:0.49:0.78:0.62:0.73:0.75"] = 314, -- New Agamand, Camp Winterhoof, Camp Oneqwah, Zim'Torga, Camp Tunka'lo
				["0.85:0.27:0.95:0.37:0.84:0.49:0.78:0.62:0.78:0.61"] = 275, -- New Agamand, Vengeance Landing, Camp Oneqwah, Zim'Torga
				["0.85:0.27:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 510, -- New Agamand, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.85:0.27:0.84:0.41:0.84:0.49:0.78:0.62:0.72:0.71"] = 313, -- New Agamand, Camp Winterhoof, Camp Oneqwah, Zim'Torga, Dun Nifflelem
				["0.85:0.27:0.84:0.41:0.84:0.49:0.78:0.62:0.82:0.69"] = 281, -- New Agamand, Camp Winterhoof, Camp Oneqwah, Zim'Torga, Gundrak
				["0.85:0.27:0.74:0.29:0.49:0.42:0.52:0.62"] = 393, -- New Agamand, Kamagua, Moa'ki, Dalaran
				["0.85:0.27:0.74:0.29:0.49:0.42:0.29:0.43:0.15:0.43:0.17:0.47"] = 525, -- New Agamand, Kamagua, Moa'ki, Unu'pe, Warsong Hold, Amber Ledge
				["0.85:0.27:0.59:0.45:0.64:0.58:0.52:0.62"] = 345, -- Новый Агамонд, Ядозлобь, Черная застава, Даларан
				["0.85:0.27:0.59:0.45:0.64:0.58"] = 277, -- New Agamand, Venomspite, Ebon Watch
				["0.85:0.27:0.59:0.45:0.45:0.49:0.29:0.46:0.15:0.43"] = 521, -- New Agamand, Venomspite, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.85:0.27:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46"] = 425, -- New Agamand, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.85:0.27:0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75"] = 382, -- New Agamand, Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.85:0.27:0.74:0.38:0.70:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 397, -- New Agamand, Apothecary Camp, Conquest Hold, Light's Breach, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.85:0.27:0.95:0.37:0.84:0.49:0.78:0.62:0.72:0.71"] = 359, -- New Agamand, Vengeance Landing, Camp Oneqwah, Zim'Torga, Dun Nifflelem
				["0.85:0.27:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 361, -- New Agamand, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.85:0.27:0.59:0.45:0.54:0.48:0.48:0.56"] = 311, -- New Agamand, Venomspite, Wyrmrest Temple, Kor'koron Vanguard
				["0.85:0.27:0.59:0.45:0.45:0.49:0.29:0.46"] = 438, -- New Agamand, Venomspite, Agmar's Hammer, Taunka'le Village
				["0.85:0.27:0.74:0.29:0.49:0.42:0.29:0.43:0.29:0.46:0.18:0.53:0.18:0.60"] = 542, -- Neu-Agamand, Kamagua, Moa'ki, Unu'pe, Taunka'le, Bor'goroks Außenposten, Nesingwarys Basislager
				["0.85:0.27:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 648, -- New Agamand, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.85:0.27:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75"] = 384, -- New Agamand, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.85:0.27:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 449, -- New Agamand, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.85:0.27:0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 447, -- New Agamand, Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.85:0.27:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 483, -- New Agamand, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.85:0.27:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75:0.57:0.79"] = 421, -- New Agamand, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.85:0.27:0.84:0.41:0.84:0.49:0.69:0.58:0.64:0.58:0.62:0.64"] = 307, -- New Agamand, Camp Winterhoof, Camp Oneqwah, Light's Breach, Ebon Watch, K3
				["0.85:0.27:0.59:0.45:0.54:0.48:0.52:0.62:0.49:0.79"] = 456, -- Новый Агамонд, Ядозлобь, Храм Драконьего Покоя, Даларан, Ристалище Серебряного турнира
				["0.85:0.27:0.59:0.45:0.64:0.58:0.62:0.64:0.72:0.71"] = 417, -- New Agamand, Venomspite, Ebon Watch, K3, Dun Nifflelem
				["0.85:0.27:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.72:0.71"] = 409, -- New Agamand, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, K3, Dun Nifflelem
				["0.85:0.27:0.84:0.41:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62"] = 357, -- New Agamand, Camp Winterhoof, Conquest Hold, Light's Breach, Ebon Watch, Dalaran
				["0.85:0.27:0.84:0.41:0.84:0.49:0.72:0.60"] = 234, -- New Agamand, Camp Winterhoof, Camp Oneqwah, The Argent Stand
				["0.85:0.27:0.59:0.45:0.48:0.56:0.52:0.62:0.31:0.57:0.29:0.46:0.15:0.43"] = 685, -- New Agamand, Venomspite, Kor'koron Vanguard, Dalaran, Warsong Camp, Taunka'le Village, Warsong Hold
				["0.85:0.27:0.59:0.45:0.54:0.48:0.52:0.62:0.24:0.60"] = 542, -- Neu-Agamand, Gallgrimm, Wyrmruhtempel, Dalaran, Flussnabel
				["0.85:0.27:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64"] = 309, -- New Agamand, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, K3

				-- Horde: Howling Fjord: Vengeance Landing
				["0.95:0.37:0.85:0.27"] = 88, -- Vengeance Landing, New Agamand
				["0.95:0.37:0.85:0.27:0.74:0.29"] = 163, -- Vengeance Landing, New Agamand, Kamagua
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.49:0.42"] = 330, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Moa'ki
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62"] = 303, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran
				["0.95:0.37:0.84:0.49"] = 105, -- Vengeance Landing, Camp Oneqwah
				["0.95:0.37:0.84:0.41:0.74:0.38"] = 130, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.49:0.42:0.29:0.43:0.15:0.43"] = 548, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Moa'ki, Unu'pe, Warsong Hold
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 589, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 554, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.49:0.42:0.29:0.43"] = 461, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Moa'ki, Unu'pe
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 550, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.95:0.37:0.84:0.41"] = 74, -- Vengeance Landing, Camp Winterhoof
				["0.95:0.37:0.84:0.49:0.78:0.62:0.78:0.61"] = 197, -- Vengeance Landing, Camp Oneqwah, Zim'Torga
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46"] = 478, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49"] = 368, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer
				["0.95:0.37:0.84:0.41:0.70:0.45"] = 166, -- Vengeance Landing, CCamp Winterhoof, Conquest Hold
				["0.95:0.37:0.85:0.27:0.74:0.38"] = 189, -- Vengeance Landing, New Agamand, Apothecary Camp
				["0.95:0.37:0.85:0.27:0.74:0.29:0.49:0.42:0.29:0.43:0.15:0.43"] = 576, -- Vengeance Landing, New Agamand, Kamagua, Moa'ki, Unu'pe, Warsong Hold
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45"] = 248, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite
				["0.95:0.37:0.85:0.27:0.74:0.38:0.70:0.45"] = 236, -- Vengeance Landing, New Agamand, Apothecary Camp, Conquest Hold
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.45:0.49"] = 380, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Agmar's Hammer
				["0.95:0.37:0.85:0.27:0.59:0.45"] = 280, -- Vengeance Landing, New Agamand, Venomspite
				["0.95:0.37:0.85:0.27:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 622, -- Vengeance Landing, New Agamand, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.95:0.37:0.85:0.27:0.74:0.29:0.49:0.42"] = 358, -- Vengeance Landing, New Agamand, Kamagua, Moa'ki
				["0.95:0.37:0.84:0.41:0.70:0.45:0.59:0.45"] = 252, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Venomspite
				["0.95:0.37:0.85:0.27:0.59:0.45:0.45:0.49:0.29:0.46:0.15:0.43"] = 608, -- Vengeance Landing, New Agamand, Venomspite, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.45:0.49:0.29:0.46:0.15:0.43"] = 575, -- Accostage de la Vengeance, Camp Sabot-d'hiver, Camp des Apothicaires, Vexevenin, Marteau d'Agmar, Taunka'le, Bastion Chanteguerre
				["0.95:0.37:0.84:0.49:0.72:0.60"] = 204, -- Vengeance Landing, Camp Oneqwah, The Argent Stand
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48"] = 299, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62"] = 395, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran
				["0.95:0.37:0.84:0.49:0.78:0.62:0.82:0.69"] = 250, -- Vengeance Landing, Camp Oneqwah, Zim'Torga, Gundrak
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.49:0.42:0.29:0.43:0.29:0.46"] = 483, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Moa'ki, Unu'pe, Taunka'le Village
				["0.95:0.37:0.84:0.41:0.70:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 328, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Light's Breach, The Argent Stand, Zim'Torga
				["0.95:0.37:0.84:0.49:0.69:0.58"] = 197, -- Vengeance Landing, Camp Oneqwah, Light's Breach
				["0.95:0.37:0.85:0.27:0.59:0.45:0.54:0.48:0.52:0.62"] = 428, -- Vengeance Landing, New Agamand, Venomspite, Wyrmrest Temple, Dalaran
				["0.95:0.37:0.85:0.27:0.74:0.29:0.49:0.42:0.45:0.49"] = 421, -- Vengeance Landing, New Agamand, Kamagua, Moa'ki, Agmar's Hammer
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58"] = 236, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62:0.56:0.64"] = 417, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran, The Argent Vanguard
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49"] = 394, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch, Wyrmrest Temple, Agmar's Hammer
				["0.95:0.37:0.84:0.41:0.74:0.38:0.74:0.29"] = 184, -- Лагерь Возмездия, Лагерь Заиндевевшего Копыта, Аптекарский поселок, Камагуа
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 563, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.95:0.37:0.85:0.27:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64"] = 394, -- Vengeance Landing, New Agamand, Apothecary Camp, Conquest Hold, Light's Breach, Ebon Watch, K3
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47"] = 557, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Moa'ki, Unu'pe, Taunka'le Village, Amber Ledge
				["0.95:0.37:0.85:0.27:0.59:0.45:0.49:0.42:0.29:0.43:0.15:0.43"] = 580, -- Vengeance Landing, New Agamand, Venomspite, Moa'ki, Unu'pe, Warsong Hold
				["0.95:0.37:0.84:0.49:0.70:0.45"] = 200, -- Vengeance Landing, Camp Oneqwah, Conquest Hold
				["0.95:0.37:0.84:0.49:0.78:0.62:0.64:0.81:0.57:0.79:0.38:0.79"] = 511, -- Accostage de la Vengeance, Camp Oneqwah, Zim'Torga, Ulduar, Refuge de Rochecombe, Le caveau des Ombres
				["0.95:0.37:0.84:0.41:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62"] = 350, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Light's Breach, Ebon Watch, Dalaran
				["0.95:0.37:0.84:0.49:0.78:0.62:0.72:0.71"] = 281, -- Vengeance Landing, Camp Oneqwah, Zim'Torga, Dun Nifflelem
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75:0.57:0.79"] = 388, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.95:0.37:0.84:0.41:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 553, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.62:0.64"] = 276, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch, K3
				["0.95:0.37:0.85:0.27:0.59:0.45:0.54:0.48:0.45:0.49"] = 401, -- Hafen der Vergeltung, Neu-Agamand, Gallgrimm, Wyrmruhtempel, Agmars Hammer
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 451, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.95:0.37:0.84:0.49:0.78:0.62:0.64:0.81:0.57:0.79:0.38:0.79:0.28:0.72"] = 588, -- Vengeance Landing, Camp Oneqwah, Zim'Torga, Ulduar, Bouldercrag's Refuge, The Shadow Vault, Death's Rise
				["0.95:0.37:0.84:0.49:0.78:0.62:0.64:0.81"] = 350, -- Vengeance Landing, Camp Oneqwah, Zim'Torga, Ulduar
				["0.95:0.37:0.84:0.41:0.70:0.45:0.59:0.45:0.54:0.48"] = 302, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Venomspite, Wyrmrest Temple
				["0.95:0.37:0.85:0.27:0.74:0.38:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62"] = 421, -- Campo Venganza, Nuevo Agamand, Campamento de los Boticarios, Bastión de la Conquista, Brecha de la Luz, Puesto de Vigilancia de Ébano, Dalaran
				["0.95:0.37:0.85:0.27:0.74:0.29:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47:0.12:0.47"] = 621, -- Vengeance Landing, New Agamand, Kamagua, Moa'ki, Unu'pe, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 536, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.48:0.56:0.52:0.62:0.62:0.64"] = 469, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Kor'koron Vanguard, Dalaran, K3
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.64:0.58:0.62:0.64:0.72:0.71"] = 470, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Ebon Watch, K3, Dun Nifflelem
				["0.95:0.37:0.84:0.41:0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62"] = 398, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran
				["0.95:0.37:0.84:0.49:0.78:0.62:0.73:0.75"] = 282, -- Vengeance Landing, Camp Oneqwah, Zim'Torga, Camp Tunka'lo
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 471, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.95:0.37:0.85:0.27:0.74:0.29:0.49:0.42:0.52:0.62"] = 479, -- Hafen der Vergeltung, Neu-Agamand, Kamagua, Moa'ki, Dalaran
				["0.95:0.37:0.84:0.41:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75:0.64:0.81"] = 450, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Ulduar
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.31:0.57"] = 450, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, Warsong Camp
				["0.95:0.37:0.84:0.41:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46"] = 482, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.95:0.37:0.84:0.41:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49"] = 371, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer
				["0.95:0.37:0.85:0.27:0.59:0.45:0.54:0.48"] = 332, -- Vengeance Landing, New Agamand, Venomspite, Wyrmrest Temple
				["0.95:0.37:0.84:0.41:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60"] = 548, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, River's Heart
				["0.95:0.37:0.85:0.27:0.59:0.45:0.48:0.56:0.52:0.62"] = 455, -- Vengeance Landing, New Agamand, Venomspite, Kor'koron Vanguard, Dalaran
				["0.95:0.37:0.84:0.41:0.70:0.45:0.69:0.58:0.72:0.60"] = 287, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Light's Breach, The Argent Stand
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.45:0.49:0.29:0.46"] = 490, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Agmar's Hammer, Taunka'le Village
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60"] = 501, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, River's Heart
				["0.95:0.37:0.84:0.49:0.72:0.60:0.64:0.58:0.52:0.62"] = 323, -- Vengeance Landing, Camp Oneqwah, The Argent Stand, Ebon Watch, Dalaran
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 615, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 589, -- Accostage de la Vengeance, Camp Oneqwah, La Brèche de Lumière, Guet d'Ébène, Temple du Repos du ver, Marteau d'Agmar, Taunka'le, Bastion Chanteguerre
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 329, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.48:0.56:0.52:0.62"] = 423, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Kor'koron Vanguard, Dalaran
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.64:0.58"] = 330, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Ebon Watch
				["0.95:0.37:0.84:0.41:0.70:0.45:0.69:0.58:0.64:0.58:0.62:0.64:0.72:0.71"] = 423, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Light's Breach, Ebon Watch, K3, Dun Nifflelem
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.60:0.60"] = 263, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch, Sunreaver's Command
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 416, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.95:0.37:0.84:0.41:0.70:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 412, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Light's Breach, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.95:0.37:0.84:0.41:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 593, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.95:0.37:0.84:0.41:0.70:0.45:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 463, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.48:0.56"] = 365, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Kor'koron Vanguard
				["0.95:0.37:0.85:0.27:0.59:0.45:0.64:0.58:0.60:0.60"] = 389, -- Vengeance Landing, New Agamand, Venomspite, Ebon Watch, Sunreaver's Command
				["0.95:0.37:0.84:0.41:0.70:0.45:0.59:0.45:0.54:0.48:0.48:0.56"] = 367, -- Vengeance Landing, Camp Winterhoof, Conquest Hold, Venomspite, Wyrmrest Temple, Kor'koron Vanguard
				["0.95:0.37:0.85:0.27:0.59:0.45:0.70:0.45"] = 339, -- Vengeance Landing, New Agamand, Venomspite, Conquest Hold
				["0.95:0.37:0.85:0.27:0.74:0.29:0.49:0.42:0.45:0.49:0.29:0.46:0.15:0.43"] = 615, -- Vengeance Landing, New Agamand, Kamagua, Moa'ki, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.54:0.48:0.52:0.62:0.49:0.79"] = 509, -- Vengeance Landing, Camp Winterhoof, Apothecary Camp, Venomspite, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.95:0.37:0.85:0.27:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 585, -- Hafen der Vergeltung, Neu-Agamand, Gallgrimm, Wyrmruhtempel, Agmars Hammer, Taunka'le, Bernsteinflöz
				["0.95:0.37:0.84:0.41:0.74:0.38:0.59:0.45:0.49:0.42:0.52:0.62"] = 451, -- Лагерь Возмездия, Лагерь Заиндевевшего Копыта, Аптекарский поселок, Ядозлобь, Моа'ки, Даларан
				["0.95:0.37:0.84:0.49:0.78:0.62:0.64:0.81:0.57:0.79:0.49:0.79"] = 458, -- Vengeance Landing, Camp Oneqwah, Zim'Torga, Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.95:0.37:0.85:0.27:0.59:0.45:0.45:0.49"] = 413, -- Vengeance Landing, New Agamand, Venomspite, Agmar's Hammer
				["0.95:0.37:0.84:0.49:0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75"] = 352, -- Vengeance Landing, Camp Oneqwah, Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site

				----------------------------------------------------------------------
				-- Horde: Icecrown
				----------------------------------------------------------------------

				-- Horde: Icecrown: Argent Tournament Grounds
				["0.49:0.79:0.38:0.79"] = 89, -- Campos del Torneo Argenta, La Cámara de las Sombras
				["0.49:0.79:0.52:0.62"] = 141, -- Argent Tournament Grounds, Dalaran
				["0.49:0.79:0.38:0.79:0.31:0.57:0.29:0.46:0.17:0.47:0.12:0.47"] = 414, -- Argent Tournament Grounds, The Shadow Vault, Warsong Camp, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.49:0.79:0.52:0.66:0.56:0.64"] = 106, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard
				["0.49:0.79:0.57:0.79:0.60:0.75"] = 92, -- Argent Tournament Grounds, Bouldercrag's Refuge, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45"] = 321, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold
				["0.49:0.79:0.38:0.79:0.28:0.72:0.24:0.60"] = 282, -- Argent Tournament Grounds, The Shadow Vault, Death's Rise, River's Heart
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56"] = 197, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Kor'koron Vanguard
				["0.49:0.79:0.52:0.66"] = 74, -- Argent Tournament Grounds, Crusaders' Pinnacle
				["0.49:0.79:0.57:0.79:0.64:0.81:0.72:0.71"] = 200, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar, Dun Nifflelem
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.60:0.60"] = 182, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Sunreaver's Command
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45"] = 287, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Venomspite
				["0.49:0.79:0.52:0.62:0.49:0.42"] = 288, -- Argent Tournament Grounds, Dalaran, Moa'ki
				["0.49:0.79:0.57:0.79:0.64:0.81:0.78:0.62:0.84:0.49"] = 331, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar, Zim'Torga, Camp Oneqwah
				["0.49:0.79:0.57:0.79:0.60:0.75:0.62:0.64"] = 179, -- Argent Tournament Grounds, Bouldercrag's Refuge, Grom'arsh Crash-Site, K3
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58"] = 202, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch
				["0.49:0.79:0.38:0.79:0.31:0.57"] = 225, -- Argent Tournament Grounds, The Shadow Vault, Warsong Camp
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.49:0.42"] = 285, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Moa'ki
				["0.49:0.79:0.52:0.62:0.24:0.60:0.18:0.60"] = 375, -- Argent Tournament Grounds, Dalaran, River's Heart, Nesingwary Base Camp
				["0.49:0.79:0.38:0.79:0.31:0.57:0.29:0.46:0.29:0.43"] = 333, -- Argent Tournament Grounds, The Shadow Vault, Warsong Camp, Taunka'le Village, Unu'pe
				["0.49:0.79:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49"] = 354, -- Enceinte du tournoi d'Argent, Dalaran, Guet d'Ébène, La Brèche de Lumière, Camp Oneqwah
				["0.49:0.79:0.57:0.79:0.64:0.81"] = 96, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49"] = 249, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.49:0.79:0.57:0.79"] = 52, -- Argent Tournament Grounds, Bouldercrag's Refuge
				["0.49:0.79:0.38:0.79:0.31:0.57:0.29:0.46"] = 304, -- Argent Tournament Grounds, The Shadow Vault, Warsong Camp, Taunka'le Village
				["0.49:0.79:0.52:0.62:0.54:0.48:0.59:0.45:0.70:0.45:0.84:0.41"] = 441, -- Argent Tournament Grounds, Dalaran, Wyrmrest Temple, Venomspite, Conquest Hold, Camp Winterhoof
				["0.49:0.79:0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45"] = 349, -- Argent Tournament Grounds, Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold
				["0.49:0.79:0.52:0.62:0.64:0.58:0.69:0.58"] = 249, -- Argent Tournament Grounds, Dalaran, Ebon Watch, Light's Breach
				["0.49:0.79:0.52:0.62:0.24:0.60"] = 339, -- Argent Tournament Grounds, Dalaran, River's Heart
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.54:0.48"] = 247, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Wyrmrest Temple
				["0.49:0.79:0.57:0.79:0.64:0.81:0.78:0.62:0.78:0.61"] = 249, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar, Zim'Torga
				["0.49:0.79:0.38:0.79:0.28:0.72:0.18:0.60"] = 283, -- Argent Tournament Grounds, The Shadow Vault, Death's Rise, Nesingwary Base Camp
				["0.49:0.79:0.52:0.62:0.54:0.48"] = 250, -- Argent Tournament Grounds, Dalaran, Wyrmrest Temple
				["0.49:0.79:0.57:0.79:0.64:0.81:0.78:0.62:0.82:0.69"] = 302, -- Enceinte du tournoi d'Argent, Refuge de Rochecombe, Ulduar, Zim'Torga, Gundrak
				["0.49:0.79:0.57:0.79:0.64:0.81:0.78:0.62:0.84:0.49:0.84:0.41"] = 379, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar, Zim'Torga, Camp Oneqwah, Camp Winterhoof
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58"] = 247, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach
				["0.49:0.79:0.38:0.79:0.28:0.72"] = 166, -- Argent Tournament Grounds, The Shadow Vault, Death's Rise
				["0.49:0.79:0.38:0.79:0.31:0.57:0.29:0.46:0.17:0.47"] = 379, -- Argent Tournament Grounds, The Shadow Vault, Warsong Camp, Taunka'le Village, Amber Ledge
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49"] = 352, -- Enceinte du tournoi d'Argent, Cime des Croisés, L'avant-garde d'Argent, Dalaran, Guet d'Ébène, La Brèche de Lumière, Camp Oneqwah
				["0.49:0.79:0.52:0.62:0.64:0.58"] = 205, -- Argent Tournament Grounds, Dalaran, Ebon Watch
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38"] = 377, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 431, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.49:0.79:0.38:0.79:0.28:0.72:0.18:0.60:0.18:0.53:0.17:0.47:0.12:0.47"] = 434, -- Ристалище Серебряного турнира, Мрачный Свод, Уступ Смерти, Лагерь Эрнестуэя, Застава Бор'горока, Янтарная гряда, Маскировочный щит
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.62:0.64"] = 182, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, K3
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.24:0.60"] = 336, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, River's Heart
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46"] = 360, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village
				["0.49:0.79:0.52:0.62:0.60:0.60"] = 185, -- Argent Tournament Grounds, Dalaran, Sunreaver's Command
				["0.49:0.79:0.38:0.79:0.28:0.72:0.18:0.60:0.18:0.53"] = 343, -- Argent Tournament Grounds, The Shadow Vault, Death's Rise, Nesingwary Base Camp, Bor'gorok Outpost
				["0.49:0.79:0.38:0.79:0.31:0.57:0.29:0.46:0.15:0.43"] = 388, -- Ристалище Серебряного турнира, Мрачный Свод, Лагерь Песни Войны, Деревня Таунка'ле, Крепость Песни Войны
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.62:0.64:0.72:0.71:0.64:0.81"] = 366, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, K3, Dun Nifflelem, Ulduar
				["0.49:0.79:0.52:0.66:0.56:0.64:0.60:0.75:0.64:0.81"] = 259, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Grom'arsh Crash-Site, Ulduar
				["0.49:0.79:0.38:0.79:0.31:0.57:0.24:0.60"] = 301, -- Argent Tournament Grounds, The Shadow Vault, Warsong Camp, River's Heart
				["0.49:0.79:0.38:0.79:0.28:0.72:0.18:0.60:0.18:0.53:0.15:0.43"] = 415, -- Argent Tournament Grounds, The Shadow Vault, Death's Rise, Nesingwary Base Camp, Bor'gorok Outpost, Warsong Hold
				["0.49:0.79:0.57:0.79:0.60:0.75:0.56:0.64"] = 172, -- Argent Tournament Grounds, Bouldercrag's Refuge, Grom'arsh Crash-Site, The Argent Vanguard
				["0.49:0.79:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45"] = 323, -- Argent Tournament Grounds, Dalaran, Ebon Watch, Light's Breach, Conquest Hold
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.24:0.60:0.18:0.53:0.17:0.47"] = 446, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, River's Heart, Bor'gorok Outpost, Amber Ledge
				["0.49:0.79:0.57:0.79:0.64:0.81:0.78:0.62:0.84:0.49:0.84:0.41:0.85:0.27"] = 459, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar, Zim'Torga, Camp Oneqwah, Camp Winterhoof, New Agamand
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.49"] = 446, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold, Camp Oneqwah
				["0.49:0.79:0.52:0.66:0.31:0.57:0.24:0.60:0.18:0.60"] = 342, -- Argent Tournament Grounds, Crusaders' Pinnacle, Warsong Camp, River's Heart, Nesingwary Base Camp
				["0.49:0.79:0.52:0.62:0.48:0.56"] = 200, -- Argent Tournament Grounds, Dalaran, Kor'koron Vanguard
				["0.49:0.79:0.57:0.79:0.64:0.81:0.78:0.62:0.84:0.49:0.95:0.37"] = 436, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar, Zim'Torga, Camp Oneqwah, Vengeance Landing
				["0.49:0.79:0.52:0.62:0.56:0.64"] = 162, -- Argent Tournament Grounds, Dalaran, The Argent Vanguard
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.69:0.58"] = 394, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Venomspite, Light's Breach
				["0.49:0.79:0.52:0.62:0.31:0.57"] = 289, -- Argent Tournament Grounds, Dalaran, Warsong Camp
				["0.49:0.79:0.52:0.66:0.56:0.64:0.60:0.75"] = 208, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.49:0.79:0.52:0.66:0.31:0.57"] = 231, -- Argent Tournament Grounds, Crusaders' Pinnacle, Warsong Camp
				["0.49:0.79:0.52:0.66:0.31:0.57:0.29:0.46:0.15:0.43"] = 395, -- Argent Tournament Grounds, Crusaders' Pinnacle, Warsong Camp, Taunka'le Village, Warsong Hold
				["0.49:0.79:0.57:0.79:0.64:0.81:0.73:0.75"] = 183, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar, Camp Tunka'lo
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41"] = 400, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.49:0.79:0.57:0.79:0.60:0.75:0.73:0.75:0.72:0.71"] = 233, -- Argent Tournament Grounds, Bouldercrag's Refuge, Grom'arsh Crash-Site, Camp Tunka'lo, Dun Nifflelem
				["0.49:0.79:0.57:0.79:0.60:0.75:0.73:0.75:0.78:0.62:0.84:0.49"] = 368, -- Argent Tournament Grounds, Bouldercrag's Refuge, Grom'arsh Crash-Site, Camp Tunka'lo, Zim'Torga, Camp Oneqwah
				["0.49:0.79:0.52:0.62:0.62:0.64"] = 185, -- Argent Tournament Grounds, Dalaran, K3
				["0.49:0.79:0.52:0.66:0.31:0.57:0.29:0.46"] = 310, -- Argent Tournament Grounds, Crusaders' Pinnacle, Warsong Camp, Taunka'le Village
				["0.49:0.79:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46"] = 362, -- Argent Tournament Grounds, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village
				["0.49:0.79:0.52:0.66:0.31:0.57:0.24:0.60"] = 307, -- Argent Tournament Grounds, Crusaders' Pinnacle, Warsong Camp, River's Heart
				["0.49:0.79:0.52:0.62:0.48:0.56:0.59:0.45"] = 290, -- Argent Tournament Grounds, Dalaran, Kor'koron Vanguard, Venomspite
				["0.49:0.79:0.52:0.62:0.54:0.48:0.59:0.45:0.70:0.45:0.84:0.49"] = 458, -- Argent Tournament Grounds, Dalaran, Wyrmrest Temple, Venomspite, Conquest Hold, Camp Oneqwah
				["0.49:0.79:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 434, -- Argentumturnierplatz, Dalaran, Schwarze Wacht, Lichtbresche, Burg Siegeswall, Apothekerlager, Kamagua
				["0.49:0.79:0.52:0.62:0.54:0.48:0.45:0.49:0.29:0.46"] = 427, -- Argent Tournament Grounds, Dalaran, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.49:0.79:0.52:0.62:0.54:0.48:0.59:0.45"] = 299, -- Argent Tournament Grounds, Dalaran, Wyrmrest Temple, Venomspite
				["0.49:0.79:0.57:0.79:0.60:0.75:0.73:0.75"] = 188, -- Argent Tournament Grounds, Bouldercrag's Refuge, Grom'arsh Crash-Site, Camp Tunka'lo
				["0.49:0.79:0.52:0.62:0.24:0.60:0.18:0.53:0.17:0.47"] = 449, -- Argent Tournament Grounds, Dalaran, River's Heart, Bor'gorok Outpost, Amber Ledge
				["0.49:0.79:0.52:0.62:0.31:0.57:0.29:0.46:0.29:0.43"] = 398, -- Argent Tournament Grounds, Dalaran, Warsong Camp, Taunka'le Village, Unu'pe
				["0.49:0.79:0.38:0.79:0.28:0.72:0.18:0.60:0.18:0.53:0.17:0.47"] = 400, -- Argent Tournament Grounds, The Shadow Vault, Death's Rise, Nesingwary Base Camp, Bor'gorok Outpost, Amber Ledge
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.74:0.38"] = 385, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Venomspite, Apothecary Camp
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45"] = 346, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60"] = 266, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand
				["0.49:0.79:0.52:0.62:0.54:0.48:0.45:0.49"] = 317, -- Argentumturnierplatz, Dalaran, Wyrmruhtempel, Agmars Hammer
				["0.49:0.79:0.52:0.62:0.48:0.56:0.45:0.49"] = 252, -- Argent Tournament Grounds, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.49:0.79:0.52:0.62:0.64:0.58:0.72:0.60"] = 269, -- Argent Tournament Grounds, Dalaran, Ebon Watch, The Argent Stand
				["0.49:0.79:0.57:0.79:0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58"] = 325, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar, Zim'Torga, The Argent Stand, Light's Breach
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.29:0.43"] = 389, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Unu'pe
				["0.49:0.79:0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.49"] = 450, -- Argent Tournament Grounds, Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold, Camp Oneqwah
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.62:0.64:0.72:0.71"] = 281, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, K3, Dun Nifflelem
				["0.49:0.79:0.52:0.62:0.62:0.64:0.72:0.71"] = 284, -- Argent Tournament Grounds, Dalaran, K3, Dun Nifflelem
				["0.49:0.79:0.57:0.79:0.60:0.75:0.62:0.64:0.72:0.71"] = 279, -- Argent Tournament Grounds, Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Dun Nifflelem
				["0.49:0.79:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 310, -- Argent Tournament Grounds, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.49:0.79:0.52:0.62:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 538, -- Argent Tournament Grounds, Dalaran, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.49:0.79:0.52:0.62:0.48:0.56:0.59:0.45:0.74:0.38:0.74:0.29"] = 442, -- Argent Tournament Grounds, Dalaran, Kor'koron Vanguard, Venomspite, Apothecary Camp, Kamagua

				-- Horde: Icecrown: Crusaders' Pinnacle
				["0.52:0.66:0.56:0.64:0.52:0.62:0.54:0.48"] = 175, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Wyrmrest Temple
				["0.52:0.66:0.52:0.62"] = 72, -- Crusaders' Pinnacle, Dalaran
				["0.52:0.66:0.31:0.57"] = 159, -- Crusaders' Pinnacle, Warsong Camp
				["0.52:0.66:0.38:0.79"] = 124, -- Crusaders' Pinnacle, The Shadow Vault
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45"] = 248, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold
				["0.52:0.66:0.31:0.57:0.29:0.46:0.17:0.47"] = 313, -- Kreuzfahrerturm, Kriegshymnenlager, Taunka'le, Bernsteinflöz
				["0.52:0.66:0.56:0.64:0.52:0.62:0.62:0.64:0.72:0.71"] = 209, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, K3, Dun Nifflelem
				["0.52:0.66:0.52:0.62:0.54:0.48"] = 182, -- Crusaders' Pinnacle, Dalaran, Wyrmrest Temple
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41"] = 327, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.52:0.66:0.56:0.64:0.60:0.75:0.57:0.79"] = 172, -- Crusaders' Pinnacle, The Argent Vanguard, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.52:0.66:0.56:0.64"] = 33, -- Crusaders' Pinnacle, The Argent Vanguard
				["0.52:0.66:0.28:0.72:0.18:0.60"] = 286, -- Crusaders' Pinnacle, Death's Rise, Nesingwary Base Camp
				["0.52:0.66:0.52:0.62:0.49:0.42"] = 220, -- Crusaders' Pinnacle, Dalaran, Moa'ki
				["0.52:0.66:0.56:0.64:0.52:0.62:0.24:0.60"] = 264, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, River's Heart
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 288, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.52:0.66:0.28:0.72"] = 168, -- Crusaders' Pinnacle, Death's Rise
				["0.52:0.66:0.56:0.64:0.52:0.62:0.62:0.64"] = 109, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, K3
				["0.52:0.66:0.31:0.57:0.29:0.46"] = 238, -- Crusaders' Pinnacle, Warsong Camp, Taunka'le Village
				["0.52:0.66:0.31:0.57:0.29:0.46:0.15:0.43"] = 322, -- Crusaders' Pinnacle, Warsong Camp, Taunka'le Village, Warsong Hold
				["0.52:0.66:0.56:0.64:0.60:0.75"] = 135, -- Crusaders' Pinnacle, The Argent Vanguard, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.52:0.66:0.31:0.57:0.24:0.60"] = 235, -- Crusaders' Pinnacle, Warsong Camp, River's Heart
				["0.52:0.66:0.56:0.64:0.52:0.62:0.49:0.42"] = 212, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Moa'ki
				["0.52:0.66:0.56:0.64:0.60:0.75:0.64:0.81"] = 187, -- Crusaders' Pinnacle, The Argent Vanguard, Grom'arsh Crash-Site, Ulduar
				["0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45"] = 215, -- Вершина Рыцарей, Оплот Серебряного Авангарда, Даларан, Стоянка отряда Кор'крона, Ядозлобь
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58"] = 175, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach
				["0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49"] = 177, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58"] = 130, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch
				["0.52:0.66:0.52:0.62:0.24:0.60:0.18:0.53:0.17:0.47:0.12:0.47"] = 416, -- Cime des Croisés, Dalaran, Le Cœur du fleuve, Avant-poste Bor'gorok, Escarpement d'Ambre, Bouclier Transitus
				["0.52:0.66:0.56:0.64:0.52:0.62:0.60:0.60"] = 109, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Sunreaver's Command
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60"] = 193, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand
				["0.52:0.66:0.31:0.57:0.24:0.60:0.18:0.60"] = 270, -- Crusaders' Pinnacle, Warsong Camp, River's Heart, Nesingwary Base Camp
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 234, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49"] = 279, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah
				["0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56"] = 125, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Kor'koron Vanguard
				["0.52:0.66:0.49:0.79"] = 97, -- Crusaders' Pinnacle, Argent Tournament Grounds
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.84:0.49"] = 292, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Camp Oneqwah
				["0.52:0.66:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49"] = 287, -- Crusaders' Pinnacle, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah
				["0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.29:0.43"] = 316, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Unu'pe
				["0.52:0.66:0.52:0.62:0.54:0.48:0.45:0.49:0.29:0.46"] = 359, -- Crusaders' Pinnacle, Dalaran, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.52:0.66:0.49:0.79:0.57:0.79"] = 145, -- Crusaders' Pinnacle, Argent Tournament Grounds, Bouldercrag's Refuge
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38"] = 305, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp
				["0.52:0.66:0.56:0.64:0.52:0.62:0.62:0.64:0.73:0.75:0.78:0.62:0.84:0.49"] = 379, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, K3, Camp Tunka'lo, Zim'Torga, Camp Oneqwah
				["0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.15:0.43"] = 372, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.52:0.66:0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.49"] = 374, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold, Camp Oneqwah

				-- Horde: Icecrown: Death's Rise
				["0.28:0.72:0.38:0.79"] = 94, -- Death's Rise, The Shadow Vault
				["0.28:0.72:0.38:0.79:0.49:0.79"] = 170, -- Death's Rise, The Shadow Vault, Argent Tournament Grounds
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62"] = 238, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran
				["0.28:0.72:0.31:0.57"] = 114, -- Death's Rise, Warsong Camp
				["0.28:0.72:0.31:0.57:0.29:0.46:0.29:0.43"] = 223, -- Death's Rise, Warsong Camp, Taunka'le Village, Unu'pe
				["0.28:0.72:0.38:0.79:0.57:0.79"] = 215, -- Death's Rise, The Shadow Vault, Bouldercrag's Refuge
				["0.28:0.72:0.38:0.79:0.57:0.79:0.64:0.81:0.78:0.62:0.78:0.61"] = 412, -- Death's Rise, The Shadow Vault, Bouldercrag's Refuge, Ulduar, Zim'Torga
				["0.28:0.72:0.52:0.66"] = 175, -- Death's Rise, Crusaders' Pinnacle
				["0.28:0.72:0.38:0.79:0.57:0.79:0.60:0.75"] = 255, -- Death's Rise, The Shadow Vault, Bouldercrag's Refuge, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.28:0.72:0.24:0.60:0.52:0.62"] = 310, -- Death's Rise, River's Heart, Dalaran
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.62:0.64:0.72:0.71"] = 382, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, K3, Dun Nifflelem
				["0.28:0.72:0.38:0.79:0.57:0.79:0.64:0.81:0.72:0.71"] = 362, -- Death's Rise, The Shadow Vault, Bouldercrag's Refuge, Ulduar, Dun Nifflelem
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58"] = 348, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach
				["0.28:0.72:0.52:0.66:0.52:0.62:0.62:0.64"] = 289, -- Death's Rise, Crusaders' Pinnacle, Dalaran, K3
				["0.28:0.72:0.24:0.60"] = 117, -- Death's Rise, River's Heart
				["0.28:0.72:0.18:0.60"] = 119, -- Death's Rise, Nesingwary Base Camp
				["0.28:0.72:0.38:0.79:0.56:0.64"] = 227, -- Death's Rise, The Shadow Vault, The Argent Vanguard
				["0.28:0.72:0.52:0.66:0.56:0.64"] = 208, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard
				["0.28:0.72:0.24:0.60:0.18:0.53"] = 171, -- Death's Rise, River's Heart, Bor'gorok Outpost
				["0.28:0.72:0.31:0.57:0.45:0.49:0.48:0.56"] = 275, -- Death's Rise, Warsong Camp, Agmar's Hammer, Kor'koron Vanguard
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60"] = 368, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand
				["0.28:0.72:0.31:0.57:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 479, -- Death's Rise, Warsong Camp, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.28:0.72:0.38:0.79:0.57:0.79:0.64:0.81"] = 259, -- Death's Rise, The Shadow Vault, Bouldercrag's Refuge, Ulduar
				["0.28:0.72:0.31:0.57:0.45:0.49:0.59:0.45:0.74:0.38:0.74:0.29"] = 451, -- Death's Rise, Warsong Camp, Agmar's Hammer, Venomspite, Apothecary Camp, Kamagua
				["0.28:0.72:0.38:0.79:0.57:0.79:0.64:0.81:0.78:0.62:0.82:0.69"] = 465, -- Death's Rise, The Shadow Vault, Bouldercrag's Refuge, Ulduar, Zim'Torga, Gundrak
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 532, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.28:0.72:0.38:0.79:0.57:0.79:0.60:0.75:0.62:0.64:0.64:0.58:0.72:0.60"] = 449, -- Death's Rise, The Shadow Vault, Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Ebon Watch, The Argent Stand
				["0.28:0.72:0.31:0.57:0.52:0.62"] = 255, -- Death's Rise, Warsong Camp, Dalaran
				["0.28:0.72:0.24:0.60:0.18:0.53:0.29:0.46:0.29:0.43"] = 277, -- Death's Rise, River's Heart, Bor'gorok Outpost, Taunka'le Village, Unu'pe
				["0.28:0.72:0.18:0.60:0.18:0.53:0.17:0.47:0.12:0.47"] = 270, -- Death's Rise, Nesingwary Base Camp, Bor'gorok Outpost, Amber Ledge, Transitus Shield
				["0.28:0.72:0.38:0.79:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45"] = 443, -- Ascenso de la Muerte, La Cámara de las Sombras, La Vanguardia Argenta, Dalaran, Puesto de Vigilancia de Ébano, Brecha de la Luz, Bastión de la Conquista
				["0.28:0.72:0.38:0.79:0.56:0.64:0.52:0.62"] = 258, -- Death's Rise, The Shadow Vault, The Argent Vanguard, Dalaran
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41"] = 501, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.28:0.72:0.31:0.57:0.45:0.49:0.59:0.45:0.70:0.45"] = 358, -- Death's Rise, Warsong Camp, Agmar's Hammer, Venomspite, Conquest Hold
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.54:0.48"] = 348, -- Уступ Смерти, Вершина Рыцарей, Оплот Серебряного Авангарда, Даларан, Храм Драконьего Покоя
				["0.28:0.72:0.31:0.57:0.45:0.49:0.54:0.48"] = 262, -- Death's Rise, Warsong Camp, Agmar's Hammer, Wyrmrest Temple
				["0.28:0.72:0.38:0.79:0.57:0.79:0.64:0.81:0.73:0.75"] = 347, -- Death's Rise, The Shadow Vault, Bouldercrag's Refuge, Ulduar, Camp Tunka'lo
				["0.28:0.72:0.31:0.57:0.29:0.46:0.17:0.47:0.12:0.47"] = 305, -- Death's Rise, Warsong Camp, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.28:0.72:0.31:0.57:0.45:0.49"] = 215, -- Death's Rise, Warsong Camp, Agmar's Hammer
				["0.28:0.72:0.31:0.57:0.45:0.49:0.59:0.45"] = 300, -- Death's Rise, Warsong Camp, Agmar's Hammer, Venomspite
				["0.28:0.72:0.24:0.60:0.18:0.53:0.17:0.47:0.12:0.47"] = 262, -- Todesanhöhe, Flussnabel, Bor'goroks Außenposten, Bernsteinflöz, Transitusschild
				["0.28:0.72:0.31:0.57:0.52:0.62:0.60:0.60"] = 301, -- Todesanhöhe, Kriegshymnenlager, Dalaran, Sonnenhäschers Schar
				["0.28:0.72:0.31:0.57:0.52:0.62:0.64:0.58:0.69:0.58"] = 365, -- Death's Rise, Warsong Camp, Dalaran, Ebon Watch, Light's Breach
				["0.28:0.72:0.52:0.66:0.52:0.62"] = 245, -- Ascenso de la Muerte, Pináculo de los Cruzados, Dalaran
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.62:0.64"] = 282, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, K3
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58"] = 304, -- Ascenso de la Muerte, Pináculo de los Cruzados, La Vanguardia Argenta, Dalaran, Puesto de Vigilancia de Ébano
				["0.28:0.72:0.18:0.60:0.18:0.53:0.29:0.46:0.29:0.43"] = 285, -- Todesanhöhe, Nesingwarys Basislager, Bor'goroks Außenposten, Taunka'le, Unu'pe
				["0.28:0.72:0.31:0.57:0.45:0.49:0.59:0.45:0.85:0.27"] = 485, -- Death's Rise, Warsong Camp, Agmar's Hammer, Venomspite, New Agamand
				["0.28:0.72:0.18:0.60:0.18:0.53:0.17:0.47"] = 235, -- Death's Rise, Nesingwary Base Camp, Bor'gorok Outpost, Amber Ledge
				["0.28:0.72:0.31:0.57:0.29:0.46"] = 194, -- Death's Rise, Warsong Camp, Taunka'le Village
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49"] = 453, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah
				["0.28:0.72:0.24:0.60:0.52:0.62:0.60:0.60"] = 356, -- Death's Rise, River's Heart, Dalaran, Sunreaver's Command

				-- Horde: Icecrown: The Argent Vanguard
				["0.56:0.64:0.52:0.62"] = 32, -- The Argent Vanguard, Dalaran
				["0.56:0.64:0.52:0.62:0.60:0.60"] = 78, -- The Argent Vanguard, Dalaran, Sunreaver's Command
				["0.56:0.64:0.52:0.62:0.48:0.56"] = 93, -- The Argent Vanguard, Dalaran, Kor'koron Vanguard
				["0.56:0.64:0.52:0.62:0.62:0.64"] = 77, -- The Argent Vanguard, Dalaran, K3
				["0.56:0.64:0.52:0.66:0.31:0.57"] = 186, -- The Argent Vanguard, Crusaders' Pinnacle, Warsong Camp
				["0.56:0.64:0.52:0.62:0.64:0.58"] = 98, -- The Argent Vanguard, Dalaran, Ebon Watch
				["0.56:0.64:0.52:0.62:0.24:0.60"] = 232, -- The Argent Vanguard, Dalaran, River's Heart
				["0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41"] = 296, -- The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.56:0.64:0.52:0.66:0.31:0.57:0.29:0.46"] = 266, -- The Argent Vanguard, Crusaders' Pinnacle, Warsong Camp, Taunka'le Village
				["0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.18:0.53"] = 327, -- The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45"] = 216, -- The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold
				["0.56:0.64:0.38:0.79"] = 148, -- The Argent Vanguard, The Shadow Vault
				["0.56:0.64:0.60:0.75:0.57:0.79"] = 140, -- The Argent Vanguard, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60"] = 161, -- The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand
				["0.56:0.64:0.52:0.62:0.54:0.48"] = 142, -- The Argent Vanguard, Dalaran, Wyrmrest Temple
				["0.56:0.64:0.52:0.62:0.62:0.64:0.72:0.71"] = 177, -- The Argent Vanguard, Dalaran, K3, Dun Nifflelem
				["0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.74:0.38"] = 281, -- The Argent Vanguard, Dalaran, Kor'koron Vanguard, Venomspite, Apothecary Camp
				["0.56:0.64:0.52:0.66"] = 28, -- The Argent Vanguard, Crusaders' Pinnacle
				["0.56:0.64:0.52:0.62:0.49:0.42"] = 180, -- The Argent Vanguard, Dalaran, Moa'ki
				["0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49"] = 145, -- Die Argentumvorhut, Dalaran, Vorposten der Kor'kron, Agmars Hammer
				["0.56:0.64:0.52:0.66:0.31:0.57:0.29:0.46:0.17:0.47:0.12:0.47"] = 376, -- The Argent Vanguard, Crusaders' Pinnacle, Warsong Camp, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.95:0.37"] = 352, -- The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Vengeance Landing
				["0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58"] = 142, -- The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach
				["0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 256, -- The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.74:0.38:0.74:0.29"] = 334, -- The Argent Vanguard, Dalaran, Kor'koron Vanguard, Venomspite, Apothecary Camp, Kamagua
				["0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.69:0.58"] = 289, -- The Argent Vanguard, Dalaran, Kor'koron Vanguard, Venomspite, Light's Breach
				["0.56:0.64:0.60:0.75"] = 103, -- The Argent Vanguard, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.15:0.43"] = 340, -- 은빛십자군 선봉기지 (얼음왕관), 달라란, 코르크론 선봉기지 (용의 안식처), 아그마르의 망치 (용의 안식처), 타운카르 마을 (북풍의 땅), 전쟁노래부족 요새 (북풍의 땅), 전쟁노래부족 요새 (북풍의 땅)
				["0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46"] = 256, -- The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village
				["0.56:0.64:0.52:0.62:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 431, -- The Argent Vanguard, Dalaran, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.56:0.64:0.52:0.62:0.62:0.64:0.73:0.75"] = 167, -- The Argent Vanguard, Dalaran, K3, Camp Tunka'lo
				["0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47"] = 330, -- The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.56:0.64:0.60:0.75:0.64:0.81"] = 155, -- The Argent Vanguard, Grom'arsh Crash-Site, Ulduar
				["0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 202, -- La Vanguardia Argenta, Dalaran, Puesto de Vigilancia de Ébano, El Confín Argenta, Zim'Torga
				["0.56:0.64:0.52:0.66:0.28:0.72"] = 195, -- The Argent Vanguard, Crusaders' Pinnacle, Death's Rise
				["0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 366, -- Die Argentumvorhut, Dalaran, Vorposten der Kor'kron, Agmars Hammer, Taunka'le, Bernsteinflöz, Transitusschild
				["0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.85:0.27"] = 365, -- The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, New Agamand
				["0.56:0.64:0.52:0.66:0.31:0.57:0.29:0.46:0.17:0.47"] = 340, -- Die Argentumvorhut, Kreuzfahrerturm, Kriegshymnenlager, Taunka'le, Bernsteinflöz
				["0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 327, -- The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.56:0.64:0.38:0.79:0.28:0.72"] = 225, -- La Vanguardia Argenta, La Cámara de las Sombras, Ascenso de la Muerte
				["0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45"] = 182, -- The Argent Vanguard, Dalaran, Kor'koron Vanguard, Venomspite
				["0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38"] = 273, -- The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp
				["0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.29:0.43"] = 285, -- The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Unu'pe
				["0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49"] = 247, -- The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah
				["0.56:0.64:0.52:0.62:0.24:0.60:0.18:0.60"] = 267, -- The Argent Vanguard, Dalaran, River's Heart, Nesingwary Base Camp
				["0.56:0.64:0.52:0.62:0.24:0.60:0.18:0.53:0.17:0.47"] = 342, -- The Argent Vanguard, Dalaran, River's Heart, Bor'gorok Outpost, Amber Ledge
				["0.56:0.64:0.52:0.62:0.54:0.48:0.45:0.49"] = 209, -- The Argent Vanguard, Dalaran, Wyrmrest Temple, Agmar's Hammer
				["0.56:0.64:0.52:0.62:0.54:0.48:0.59:0.45:0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 433, -- The Argent Vanguard, Dalaran, Wyrmrest Temple, Venomspite, Light's Breach, The Argent Stand, Zim'Torga, Gundrak
				["0.56:0.64:0.52:0.62:0.54:0.48:0.59:0.45"] = 191, -- The Argent Vanguard, Dalaran, Wyrmrest Temple, Venomspite
				["0.56:0.64:0.52:0.66:0.49:0.79"] = 124, -- The Argent Vanguard, Crusaders' Pinnacle, Argent Tournament Grounds
				["0.56:0.64:0.52:0.62:0.49:0.79"] = 146, -- The Argent Vanguard, Dalaran, Argent Tournament Grounds
				["0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.49"] = 342, -- Die Argentumvorhut, Dalaran, Vorposten der Kor'kron, Gallgrimm, Burg Siegeswall, Camp Oneqwah
				["0.56:0.64:0.52:0.62:0.31:0.57"] = 181, -- The Argent Vanguard, Dalaran, Warsong Camp
				["0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.84:0.41"] = 301, -- The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Camp Winterhoof
				["0.56:0.64:0.52:0.62:0.54:0.48:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 407, -- The Argent Vanguard, Dalaran, Wyrmrest Temple, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing

				-- Horde: Icecrown: The Shadow Vault
				["0.38:0.79:0.56:0.64:0.52:0.62"] = 166, -- The Shadow Vault, The Argent Vanguard, Dalaran
				["0.38:0.79:0.57:0.79"] = 122, -- The Shadow Vault, Bouldercrag's Refuge
				["0.38:0.79:0.56:0.64"] = 135, -- The Shadow Vault, The Argent Vanguard
				["0.38:0.79:0.57:0.79:0.64:0.81:0.72:0.71"] = 270, -- Das Schattengewölbe, Bergfels' Zuflucht, Ulduar, Dun Niffelem
				["0.38:0.79:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 336, -- The Shadow Vault, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.38:0.79:0.57:0.79:0.60:0.75:0.73:0.75:0.72:0.71"] = 303, -- The Shadow Vault, Bouldercrag's Refuge, Grom'arsh Crash-Site, Camp Tunka'lo, Dun Nifflelem
				["0.38:0.79:0.57:0.79:0.60:0.75:0.62:0.64:0.52:0.62"] = 321, -- The Shadow Vault, Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Dalaran
				["0.38:0.79:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49"] = 381, -- The Shadow Vault, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah
				["0.38:0.79:0.28:0.72"] = 78, -- The Shadow Vault, Death's Rise
				["0.38:0.79:0.31:0.57:0.45:0.49"] = 237, -- The Shadow Vault, Warsong Camp, Agmar's Hammer
				["0.38:0.79:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60"] = 296, -- The Shadow Vault, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand
				["0.38:0.79:0.52:0.66"] = 121, -- The Shadow Vault, Crusaders' Pinnacle
				["0.38:0.79:0.56:0.64:0.52:0.62:0.62:0.64:0.72:0.71"] = 311, -- The Shadow Vault, The Argent Vanguard, Dalaran, K3, Dun Nifflelem
				["0.38:0.79:0.56:0.64:0.52:0.62:0.49:0.42:0.29:0.43:0.15:0.43"] = 530, -- The Shadow Vault, The Argent Vanguard, Dalaran, Moa'ki, Unu'pe, Warsong Hold
				["0.38:0.79:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45"] = 350, -- The Shadow Vault, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold
				["0.38:0.79:0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45"] = 317, -- The Shadow Vault, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Venomspite
				["0.38:0.79:0.57:0.79:0.64:0.81"] = 166, -- The Shadow Vault, Bouldercrag's Refuge, Ulduar
				["0.38:0.79:0.31:0.57:0.29:0.46:0.29:0.43"] = 246, -- Das Schattengewölbe, Kriegshymnenlager, Taunka'le, Unu'pe
				["0.38:0.79:0.31:0.57"] = 138, -- The Shadow Vault, Warsong Camp
				["0.38:0.79:0.31:0.57:0.29:0.46:0.17:0.47:0.12:0.47"] = 327, -- The Shadow Vault, Warsong Camp, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.38:0.79:0.56:0.64:0.52:0.62:0.54:0.48"] = 277, -- The Shadow Vault, The Argent Vanguard, Dalaran, Wyrmrest Temple
				["0.38:0.79:0.31:0.57:0.45:0.49:0.59:0.45:0.70:0.45"] = 381, -- The Shadow Vault, Warsong Camp, Agmar's Hammer, Venomspite, Conquest Hold
				["0.38:0.79:0.52:0.66:0.52:0.62"] = 192, -- The Shadow Vault, Crusaders' Pinnacle, Dalaran
				["0.38:0.79:0.56:0.64:0.52:0.62:0.48:0.56"] = 227, -- The Shadow Vault, The Argent Vanguard, Dalaran, Kor'koron Vanguard
				["0.38:0.79:0.56:0.64:0.52:0.62:0.24:0.60"] = 365, -- The Shadow Vault, The Argent Vanguard, Dalaran, River's Heart
				["0.38:0.79:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38"] = 407, -- The Shadow Vault, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp
				["0.38:0.79:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 500, -- The Shadow Vault, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.38:0.79:0.31:0.57:0.29:0.46"] = 217, -- The Shadow Vault, Warsong Camp, Taunka'le Village
				["0.38:0.79:0.56:0.64:0.52:0.62:0.62:0.64"] = 210, -- The Shadow Vault, The Argent Vanguard, Dalaran, K3
				["0.38:0.79:0.52:0.66:0.52:0.62:0.62:0.64:0.72:0.71"] = 336, -- The Shadow Vault, Crusaders' Pinnacle, Dalaran, K3, Dun Nifflelem
				["0.38:0.79:0.57:0.79:0.60:0.75"] = 163, -- The Shadow Vault, Bouldercrag's Refuge, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.38:0.79:0.56:0.64:0.52:0.62:0.49:0.42"] = 314, -- The Shadow Vault, The Argent Vanguard, Dalaran, Moa'ki
				["0.38:0.79:0.28:0.72:0.24:0.60"] = 195, -- The Shadow Vault, Death's Rise, River's Heart
				["0.38:0.79:0.28:0.72:0.18:0.60:0.18:0.53:0.17:0.47:0.12:0.47"] = 347, -- The Shadow Vault, Death's Rise, Nesingwary Base Camp, Bor'gorok Outpost, Amber Ledge, Transitus Shield
				["0.38:0.79:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.15:0.43"] = 473, -- Le caveau des Ombres, L'avant-garde d'Argent, Dalaran, Avant-garde kor'kronne, Marteau d'Agmar, Taunka'le, Bastion Chanteguerre
				["0.38:0.79:0.57:0.79:0.60:0.75:0.73:0.75"] = 258, -- The Shadow Vault, Bouldercrag's Refuge, Grom'arsh Crash-Site, Camp Tunka'lo
				["0.38:0.79:0.28:0.72:0.24:0.60:0.52:0.62"] = 387, -- The Shadow Vault, Death's Rise, River's Heart, Dalaran
				["0.38:0.79:0.31:0.57:0.45:0.49:0.49:0.42"] = 298, -- The Shadow Vault, Warsong Camp, Agmar's Hammer, Moa'ki
				["0.38:0.79:0.28:0.72:0.24:0.60:0.18:0.53:0.17:0.47"] = 304, -- The Shadow Vault, Death's Rise, River's Heart, Bor'gorok Outpost, Amber Ledge
				["0.38:0.79:0.56:0.64:0.60:0.75"] = 237, -- Мрачный Свод, Оплот Серебряного Авангарда, Место крушения Гром'арша
				["0.38:0.79:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58"] = 276, -- The Shadow Vault, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach
				["0.38:0.79:0.31:0.57:0.52:0.62:0.62:0.64"] = 323, -- The Shadow Vault, Warsong Camp, Dalaran, K3
				["0.38:0.79:0.56:0.64:0.60:0.75:0.64:0.81"] = 288, -- The Shadow Vault, The Argent Vanguard, Grom'arsh Crash-Site, Ulduar
				["0.38:0.79:0.31:0.57:0.45:0.49:0.59:0.45"] = 323, -- The Shadow Vault, Warsong Camp, Agmar's Hammer, Venomspite
				["0.38:0.79:0.28:0.72:0.18:0.60"] = 195, -- The Shadow Vault, Death's Rise, Nesingwary Base Camp
				["0.38:0.79:0.56:0.64:0.52:0.62:0.62:0.64:0.73:0.75"] = 301, -- The Shadow Vault, The Argent Vanguard, Dalaran, K3, Camp Tunka'lo
				["0.38:0.79:0.52:0.66:0.52:0.62:0.54:0.48"] = 302, -- The Shadow Vault, Crusaders' Pinnacle, Dalaran, Wyrmrest Temple
				["0.38:0.79:0.57:0.79:0.64:0.81:0.78:0.62:0.78:0.61"] = 319, -- The Shadow Vault, Bouldercrag's Refuge, Ulduar, Zim'Torga
				["0.38:0.79:0.31:0.57:0.29:0.46:0.15:0.43"] = 301, -- The Shadow Vault, Warsong Camp, Taunka'le Village, Warsong Hold
				["0.38:0.79:0.56:0.64:0.52:0.62:0.64:0.58"] = 232, -- The Shadow Vault, The Argent Vanguard, Dalaran, Ebon Watch
				["0.38:0.79:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49"] = 278, -- The Shadow Vault, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.38:0.79:0.28:0.72:0.18:0.60:0.18:0.53:0.15:0.43"] = 327, -- The Shadow Vault, Death's Rise, Nesingwary Base Camp, Bor'gorok Outpost, Warsong Hold
				["0.38:0.79:0.31:0.57:0.24:0.60:0.18:0.53:0.17:0.47:0.12:0.47"] = 359, -- Мрачный Свод, Лагерь Песни Войны, Слияние рек, Застава Бор'горока, Янтарная гряда, Маскировочный щит
				["0.38:0.79:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.84:0.41"] = 434, -- The Shadow Vault, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Camp Winterhoof
				["0.38:0.79:0.57:0.79:0.60:0.75:0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49"] = 434, -- Das Schattengewölbe, Bergfels' Zuflucht, Absturzstelle Grom'ash, K3, Dalaran, Vorposten der Kor'kron, Agmars Hammer
				["0.38:0.79:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 389, -- The Shadow Vault, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.38:0.79:0.28:0.72:0.18:0.60:0.18:0.53:0.29:0.46"] = 333, -- The Shadow Vault, Death's Rise, Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village
				["0.38:0.79:0.49:0.79"] = 78, -- The Shadow Vault, Argent Tournament Grounds
				["0.38:0.79:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41"] = 429, -- The Shadow Vault, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.38:0.79:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.95:0.37"] = 486, -- The Shadow Vault, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Vengeance Landing
				["0.38:0.79:0.56:0.64:0.52:0.62:0.60:0.60"] = 212, -- The Shadow Vault, The Argent Vanguard, Dalaran, Sunreaver's Command
				["0.38:0.79:0.31:0.57:0.24:0.60:0.18:0.53"] = 268, -- The Shadow Vault, Warsong Camp, River's Heart, Bor'gorok Outpost
				["0.38:0.79:0.57:0.79:0.64:0.81:0.73:0.75"] = 254, -- The Shadow Vault, Bouldercrag's Refuge, Ulduar, Camp Tunka'lo
				["0.38:0.79:0.31:0.57:0.45:0.49:0.54:0.48"] = 286, -- The Shadow Vault, Warsong Camp, Agmar's Hammer, Wyrmrest Temple
				["0.38:0.79:0.28:0.72:0.18:0.60:0.18:0.53"] = 256, -- The Shadow Vault, Death's Rise, Nesingwary Base Camp, Bor'gorok Outpost
				["0.38:0.79:0.52:0.66:0.52:0.62:0.64:0.58:0.72:0.60"] = 322, -- The Shadow Vault, Crusaders' Pinnacle, Dalaran, Ebon Watch, The Argent Stand
				["0.38:0.79:0.28:0.72:0.18:0.60:0.18:0.53:0.29:0.46:0.29:0.43"] = 362, -- The Shadow Vault, Death's Rise, Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village, Unu'pe
				["0.38:0.79:0.49:0.79:0.52:0.62"] = 214, -- Le caveau des Ombres, Enceinte du tournoi d'Argent, Dalaran
				["0.38:0.79:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.85:0.27"] = 499, -- The Shadow Vault, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, New Agamand
				["0.38:0.79:0.57:0.79:0.60:0.75:0.62:0.64"] = 249, -- The Shadow Vault, Bouldercrag's Refuge, Grom'arsh Crash-Site, K3
				["0.38:0.79:0.31:0.57:0.29:0.46:0.17:0.47"] = 292, -- The Shadow Vault, Warsong Camp, Taunka'le Village, Amber Ledge
				["0.38:0.79:0.56:0.64:0.52:0.62:0.54:0.48:0.59:0.45:0.70:0.45"] = 383, -- The Shadow Vault, The Argent Vanguard, Dalaran, Wyrmrest Temple, Venomspite, Conquest Hold
				["0.38:0.79:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 461, -- The Shadow Vault, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.38:0.79:0.31:0.57:0.45:0.49:0.59:0.45:0.85:0.27"] = 508, -- The Shadow Vault, Warsong Camp, Agmar's Hammer, Venomspite, New Agamand

				----------------------------------------------------------------------
				-- Horde: Sholazar Basin
				----------------------------------------------------------------------

				-- Horde: Sholazar Basin: Nesingwary Base Camp
				["0.18:0.60:0.24:0.60:0.52:0.62"] = 363, -- Nesingwary Base Camp, River's Heart, Dalaran
				["0.18:0.60:0.24:0.60"] = 77, -- Nesingwary Base Camp, River's Heart
				["0.18:0.60:0.18:0.53:0.17:0.47:0.12:0.47"] = 229, -- Nesingwary Base Camp, Bor'gorok Outpost, Amber Ledge, Transitus Shield
				["0.18:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45"] = 471, -- Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite
				["0.18:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45"] = 557, -- Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58:0.69:0.58"] = 531, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch, Light's Breach
				["0.18:0.60:0.18:0.53:0.29:0.46:0.45:0.49"] = 342, -- Camp de base de Nesingwary, Avant-poste Bor'gorok, Taunka'le, Marteau d'Agmar
				["0.18:0.60:0.24:0.60:0.52:0.62:0.56:0.64"] = 397, -- Nesingwary Base Camp, River's Heart, Dalaran, The Argent Vanguard
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 620, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.18:0.60:0.24:0.60:0.52:0.62:0.62:0.64:0.72:0.71"] = 581, -- Nesingwary Base Camp, River's Heart, Dalaran, K3, Dun Nifflelem
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 850, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Ulduar
				["0.18:0.60:0.18:0.53:0.15:0.43"] = 199, -- Nesingwary Base Camp, Bor'gorok Outpost, Warsong Hold
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58"] = 464, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81:0.60:0.75"] = 916, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Ulduar, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.18:0.60:0.18:0.53"] = 91, -- Nesingwary Base Camp, Bor'gorok Outpost
				["0.18:0.60:0.18:0.53:0.29:0.46"] = 207, -- Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village
				["0.18:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41"] = 683, -- Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49"] = 688, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah
				["0.18:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49"] = 708, -- Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Oneqwah
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60"] = 559, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch, The Argent Stand
				["0.18:0.60:0.24:0.60:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.15:0.43"] = 826, -- Nesingwary Base Camp, River's Heart, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.18:0.60:0.24:0.60:0.31:0.57:0.29:0.46"] = 310, -- Nesingwary Base Camp, River's Heart, Warsong Camp, Taunka'le Village
				["0.18:0.60:0.24:0.60:0.31:0.57:0.29:0.46:0.29:0.43"] = 354, -- Nesingwary Base Camp, River's Heart, Warsong Camp, Taunka'le Village, Unu'pe
				["0.18:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.54:0.48"] = 415, -- Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple
				["0.18:0.60:0.24:0.60:0.52:0.62:0.62:0.64"] = 431, -- Nesingwary Base Camp, River's Heart, Dalaran, K3
				["0.18:0.60:0.24:0.60:0.52:0.62:0.62:0.64:0.60:0.75"] = 544, -- Nesingwary Base Camp, River's Heart, Dalaran, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.18:0.60:0.18:0.53:0.17:0.47"] = 176, -- Nesingwary Base Camp, Bor'gorok Outpost, Amber Ledge
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 700, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.18:0.60:0.28:0.72"] = 137, -- Nesingwary Base Camp, Death's Rise
				["0.18:0.60:0.18:0.53:0.29:0.46:0.29:0.43"] = 251, -- Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village, Unu'pe
				["0.18:0.60:0.24:0.60:0.31:0.57"] = 191, -- Nesingwary Base Camp, River's Heart, Warsong Camp
				["0.18:0.60:0.28:0.72:0.38:0.79"] = 277, -- Nesingwary Base Camp, Death's Rise, The Shadow Vault
				["0.18:0.60:0.24:0.60:0.52:0.62:0.62:0.64:0.73:0.75"] = 566, -- Nesingwary Base Camp, River's Heart, Dalaran, K3, Camp Tunka'lo
				["0.18:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.74:0.29"] = 697, -- Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp, Kamagua
				["0.18:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38"] = 617, -- Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp
				["0.18:0.60:0.24:0.60:0.52:0.62:0.52:0.66"] = 406, -- Nesingwary Base Camp, River's Heart, Dalaran, Crusaders' Pinnacle
				["0.18:0.60:0.24:0.60:0.52:0.62:0.60:0.60"] = 433, -- Nesingwary Base Camp, River's Heart, Dalaran, Sunreaver's Command
				["0.18:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.85:0.27"] = 748, -- Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, New Agamand
				["0.18:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.48:0.56"] = 435, -- Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard
				["0.18:0.60:0.24:0.60:0.52:0.62:0.48:0.56"] = 455, -- Nesingwary Base Camp, River's Heart, Dalaran, Kor'koron Vanguard
				["0.18:0.60:0.18:0.53:0.29:0.46:0.29:0.43:0.49:0.42"] = 428, -- Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village, Unu'pe, Moa'ki
				["0.18:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.84:0.41"] = 706, -- Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.18:0.60:0.28:0.72:0.52:0.66"] = 398, -- Nesingwary Base Camp, Death's Rise, Crusaders' Pinnacle
				["0.18:0.60:0.24:0.60:0.52:0.62:0.48:0.56:0.45:0.49"] = 534, -- Nesingwary Base Camp, River's Heart, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.18:0.60:0.24:0.60:0.31:0.57:0.38:0.79"] = 435, -- Nesingwary Base Camp, River's Heart, Warsong Camp, The Shadow Vault
				["0.18:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.69:0.58"] = 629, -- Nesingwarys Basislager, Bor'goroks Außenposten, Taunka'le, Agmars Hammer, Gallgrimm, Lichtbresche
				["0.18:0.60:0.28:0.72:0.38:0.79:0.49:0.79"] = 391, -- Nesingwary Base Camp, Death's Rise, The Shadow Vault, Argent Tournament Grounds
				["0.18:0.60:0.28:0.72:0.38:0.79:0.57:0.79:0.60:0.75"] = 519, -- Nesingwary Base Camp, Death's Rise, The Shadow Vault, Bouldercrag's Refuge, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.18:0.60:0.28:0.72:0.38:0.79:0.57:0.79"] = 458, -- Nesingwary Base Camp, Death's Rise, The Shadow Vault, Bouldercrag's Refuge

				-- Horde: Sholazar Basin: River's Heart
				["0.24:0.60:0.31:0.57"] = 129, -- River's Heart, Warsong Camp
				["0.24:0.60:0.18:0.53:0.29:0.46"] = 209, -- River's Heart, Bor'gorok Outpost, Taunka'le Village
				["0.24:0.60:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49"] = 626, -- River's Heart, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah
				["0.24:0.60:0.52:0.62"] = 302, -- River's Heart, Dalaran
				["0.24:0.60:0.18:0.53"] = 94, -- River's Heart, Bor'gorok Outpost
				["0.24:0.60:0.18:0.53:0.15:0.43"] = 201, -- River's Heart, Bor'gorok Outpost, Warsong Hold
				["0.24:0.60:0.18:0.53:0.17:0.47"] = 177, -- River's Heart, Bor'gorok Outpost, Amber Ledge
				["0.24:0.60:0.28:0.72"] = 140, -- River's Heart, Death's Rise
				["0.24:0.60:0.18:0.53:0.17:0.47:0.12:0.47"] = 231, -- River's Heart, Bor'gorok Outpost, Amber Ledge, Transitus Shield
				["0.24:0.60:0.31:0.57:0.45:0.49:0.59:0.45:0.85:0.27"] = 684, -- River's Heart, Warsong Camp, Agmar's Hammer, Venomspite, New Agamand
				["0.24:0.60:0.31:0.57:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 728, -- River's Heart, Warsong Camp, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.24:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 795, -- River's Heart, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.24:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38"] = 618, -- River's Heart, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Apothecary Camp
				["0.24:0.60:0.18:0.53:0.29:0.46:0.29:0.43"] = 253, -- River's Heart, Bor'gorok Outpost, Taunka'le Village, Unu'pe
				["0.24:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.54:0.48"] = 417, -- River's Heart, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple
				["0.24:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.48:0.56"] = 436, -- River's Heart, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Kor'koron Vanguard
				["0.24:0.60:0.18:0.53:0.29:0.46:0.45:0.49"] = 345, -- River's Heart, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer
				["0.24:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45"] = 559, -- River's Heart, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold
				["0.24:0.60:0.18:0.60"] = 64, -- River's Heart, Nesingwary Base Camp
				["0.24:0.60:0.52:0.62:0.62:0.64"] = 370, -- River's Heart, Dalaran, K3
				["0.24:0.60:0.52:0.62:0.64:0.58:0.69:0.58"] = 469, -- River's Heart, Dalaran, Ebon Watch, Light's Breach
				["0.24:0.60:0.52:0.62:0.64:0.58"] = 403, -- River's Heart, Dalaran, Ebon Watch
				["0.24:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45"] = 472, -- River's Heart, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite
				["0.24:0.60:0.28:0.72:0.38:0.79"] = 280, -- River's Heart, Death's Rise, The Shadow Vault
				["0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60"] = 498, -- Flussnabel, Dalaran, Schwarze Wacht, Argentumwache
				["0.24:0.60:0.52:0.62:0.62:0.64:0.60:0.75:0.57:0.79"] = 537, -- River's Heart, Dalaran, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.24:0.60:0.52:0.62:0.48:0.56"] = 394, -- Flussnabel, Dalaran, Vorposten der Kor'kron
				["0.24:0.60:0.52:0.62:0.62:0.64:0.72:0.71"] = 520, -- River's Heart, Dalaran, K3, Dun Nifflelem
				["0.24:0.60:0.31:0.57:0.45:0.49:0.59:0.45:0.70:0.45"] = 492, -- River's Heart, Warsong Camp, Agmar's Hammer, Venomspite, Conquest Hold
				["0.24:0.60:0.18:0.53:0.29:0.46:0.29:0.43:0.49:0.42"] = 429, -- River's Heart, Bor'gorok Outpost, Taunka'le Village, Unu'pe, Moa'ki
				["0.24:0.60:0.52:0.62:0.54:0.48"] = 468, -- River's Heart, Dalaran, Wyrmrest Temple
				["0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 639, -- River's Heart, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.24:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41"] = 685, -- River's Heart, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof
				["0.24:0.60:0.52:0.62:0.52:0.66"] = 344, -- River's Heart, Dalaran, Crusaders' Pinnacle
				["0.24:0.60:0.52:0.62:0.60:0.60"] = 371, -- River's Heart, Dalaran, Sunreaver's Command
				["0.24:0.60:0.31:0.57:0.45:0.49:0.54:0.48"] = 350, -- River's Heart, Warsong Camp, Agmar's Hammer, Wyrmrest Temple
				["0.24:0.60:0.31:0.57:0.45:0.49:0.49:0.42"] = 369, -- River's Heart, Warsong Camp, Agmar's Hammer, Moa'ki
				["0.24:0.60:0.52:0.62:0.62:0.64:0.60:0.75"] = 482, -- River's Heart, Dalaran, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.24:0.60:0.31:0.57:0.45:0.49:0.59:0.45"] = 406, -- River's Heart, Warsong Camp, Agmar's Hammer, Venomspite
				["0.24:0.60:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45"] = 580, -- River's Heart, Dalaran, Ebon Watch, Light's Breach, Conquest Hold
				["0.24:0.60:0.52:0.62:0.62:0.64:0.73:0.75"] = 504, -- River's Heart, Dalaran, K3, Camp Tunka'lo
				["0.24:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.60:0.60"] = 611, -- River's Heart, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, Sunreaver's Command
				["0.24:0.60:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.95:0.37"] = 784, -- River's Heart, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Vengeance Landing
				["0.24:0.60:0.31:0.57:0.45:0.49"] = 279, -- River's Heart, Warsong Camp, Agmar's Hammer
				["0.24:0.60:0.52:0.62:0.56:0.64"] = 335, -- River's Heart, Dalaran, The Argent Vanguard
				["0.24:0.60:0.31:0.57:0.29:0.46"] = 248, -- River's Heart, Warsong Camp, Taunka'le Village
				["0.24:0.60:0.31:0.57:0.45:0.49:0.48:0.56"] = 370, -- River's Heart, Warsong Camp, Agmar's Hammer, Kor'koron Vanguard
				["0.24:0.60:0.31:0.57:0.45:0.49:0.49:0.42:0.29:0.43"] = 565, -- River's Heart, Warsong Camp, Agmar's Hammer, Moa'ki, Unu'pe
				["0.24:0.60:0.31:0.57:0.29:0.46:0.29:0.43"] = 291, -- River's Heart, Warsong Camp, Taunka'le Village, Unu'pe
				["0.24:0.60:0.31:0.57:0.29:0.46:0.17:0.47"] = 359, -- River's Heart, Warsong Camp, Taunka'le Village, Amber Ledge
				["0.24:0.60:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 745, -- River's Heart, Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.24:0.60:0.31:0.57:0.45:0.49:0.59:0.45:0.74:0.38:0.74:0.29"] = 632, -- River's Heart, Warsong Camp, Agmar's Hammer, Venomspite, Apothecary Camp, Kamagua
				["0.24:0.60:0.52:0.62:0.48:0.56:0.45:0.49"] = 472, -- River's Heart, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.24:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.54:0.48:0.64:0.58:0.72:0.60"] = 666, -- River's Heart, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Wyrmrest Temple, Ebon Watch, The Argent Stand
				["0.24:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.69:0.58"] = 631, -- River's Heart, Bor'gorok Outpost, Taunka'le Village, Agmar's Hammer, Venomspite, Light's Breach
				["0.24:0.60:0.31:0.57:0.38:0.79"] = 373, -- River's Heart, Warsong Camp, The Shadow Vault
				["0.24:0.60:0.31:0.57:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41"] = 619, -- River's Heart, Warsong Camp, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof
				["0.24:0.60:0.18:0.53:0.29:0.46:0.45:0.49:0.59:0.45:0.74:0.38:0.74:0.29"] = 699, -- Le Cœur du fleuve, Avant-poste Bor'gorok, Taunka'le, Marteau d'Agmar, Vexevenin, Camp des Apothicaires, Kamagua
				["0.24:0.60:0.31:0.57:0.45:0.49:0.59:0.45:0.74:0.38"] = 552, -- River's Heart, Warsong Camp, Agmar's Hammer, Venomspite, Apothecary Camp
				["0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 558, -- River's Heart, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.24:0.60:0.18:0.53:0.29:0.46:0.29:0.43:0.49:0.42:0.74:0.29"] = 704, -- River's Heart, Bor'gorok Outpost, Taunka'le Village, Unu'pe, Moa'ki, Kamagua
				["0.24:0.60:0.52:0.62:0.56:0.64:0.60:0.75"] = 488, -- River's Heart, Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.24:0.60:0.31:0.57:0.29:0.46:0.15:0.43"] = 374, -- River's Heart, Warsong Camp, Taunka'le Village, Warsong Hold
				["0.24:0.60:0.28:0.72:0.38:0.79:0.57:0.79:0.64:0.81"] = 527, -- River's Heart, Death's Rise, The Shadow Vault, Bouldercrag's Refuge, Ulduar
				["0.24:0.60:0.28:0.72:0.38:0.79:0.49:0.79"] = 394, -- River's Heart, Death's Rise, The Shadow Vault, Argent Tournament Grounds
				["0.24:0.60:0.52:0.62:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38"] = 665, -- River's Heart, Dalaran, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp
				["0.24:0.60:0.28:0.72:0.38:0.79:0.57:0.79"] = 461, -- River's Heart, Death's Rise, The Shadow Vault, Bouldercrag's Refuge
				["0.24:0.60:0.52:0.62:0.49:0.79"] = 473, -- Corazón del Río, Dalaran, Campos del Torneo Argenta
				["0.24:0.60:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 559, -- River's Heart, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.24:0.60:0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45"] = 616, -- Flussnabel, Dalaran, Vorposten der Kor'kron, Gallgrimm, Burg Siegeswall
				["0.24:0.60:0.52:0.62:0.49:0.79:0.57:0.79:0.64:0.81"] = 610, -- River's Heart, Dalaran, Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar

				----------------------------------------------------------------------
				-- Horde: The Storm Peaks
				----------------------------------------------------------------------

				-- Horde: The Storm Peaks: Bouldercrag's Refuge
				["0.57:0.79:0.64:0.81"] = 45, -- Bouldercrag's Refuge, Ulduar
				["0.57:0.79:0.60:0.75"] = 41, -- Bouldercrag's Refuge, Grom'arsh Crash-Site
				["0.57:0.79:0.60:0.75:0.62:0.64:0.52:0.62"] = 199, -- Bergfels' Zuflucht, Absturzstelle Grom'ash, K3, Dalaran
				["0.57:0.79:0.64:0.81:0.72:0.71"] = 149, -- Bouldercrag's Refuge, Ulduar, Dun Nifflelem
				["0.57:0.79:0.60:0.75:0.62:0.64"] = 128, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, K3
				["0.57:0.79:0.60:0.75:0.62:0.64:0.72:0.71"] = 228, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Dun Nifflelem
				["0.57:0.79:0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58"] = 215, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach
				["0.57:0.79:0.60:0.75:0.56:0.64:0.52:0.62:0.24:0.60"] = 351, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, River's Heart
				["0.57:0.79:0.60:0.75:0.73:0.75:0.72:0.71"] = 182, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, Camp Tunka'lo, Dun Nifflelem
				["0.57:0.79:0.60:0.75:0.73:0.75"] = 137, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, Camp Tunka'lo
				["0.57:0.79:0.38:0.79:0.28:0.72"] = 190, -- Bouldercrag's Refuge, The Shadow Vault, Death's Rise
				["0.57:0.79:0.60:0.75:0.56:0.64:0.52:0.62"] = 151, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran
				["0.57:0.79:0.60:0.75:0.56:0.64"] = 120, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, The Argent Vanguard
				["0.57:0.79:0.60:0.75:0.62:0.64:0.64:0.58:0.54:0.48"] = 262, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Ebon Watch, Wyrmrest Temple
				["0.57:0.79:0.60:0.75:0.56:0.64:0.52:0.66"] = 147, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, The Argent Vanguard, Crusaders' Pinnacle
				["0.57:0.79:0.60:0.75:0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.15:0.43"] = 507, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.57:0.79:0.60:0.75:0.62:0.64:0.52:0.62:0.52:0.66"] = 227, -- Refuge de Rochecombe, Point d'impact de Grom'arsh, K3, Dalaran, Cime des Croisés
				["0.57:0.79:0.64:0.81:0.73:0.75"] = 132, -- Bouldercrag's Refuge, Ulduar, Camp Tunka'lo
				["0.57:0.79:0.64:0.81:0.73:0.75:0.62:0.64"] = 246, -- Bouldercrag's Refuge, Ulduar, Camp Tunka'lo, K3
				["0.57:0.79:0.60:0.75:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49"] = 264, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.57:0.79:0.64:0.81:0.72:0.71:0.62:0.64:0.52:0.62:0.54:0.48"] = 417, -- Bouldercrag's Refuge, Ulduar, Dun Nifflelem, K3, Dalaran, Wyrmrest Temple
				["0.57:0.79:0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45"] = 289, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach, Conquest Hold
				["0.57:0.79:0.38:0.79:0.56:0.64:0.52:0.62"] = 278, -- Bouldercrag's Refuge, The Shadow Vault, The Argent Vanguard, Dalaran
				["0.57:0.79:0.60:0.75:0.62:0.64:0.64:0.58"] = 172, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Ebon Watch
				["0.57:0.79:0.38:0.79"] = 114, -- Refugio de Pedruscón, La Cámara de las Sombras
				["0.57:0.79:0.64:0.81:0.78:0.62:0.78:0.61"] = 198, -- Bouldercrag's Refuge, Ulduar, Zim'Torga
				["0.57:0.79:0.38:0.79:0.28:0.72:0.24:0.60"] = 307, -- Bouldercrag's Refuge, The Shadow Vault, Death's Rise, River's Heart
				["0.57:0.79:0.38:0.79:0.28:0.72:0.18:0.60"] = 308, -- Bouldercrag's Refuge, The Shadow Vault, Death's Rise, Nesingwary Base Camp
				["0.57:0.79:0.60:0.75:0.56:0.64:0.52:0.62:0.48:0.56"] = 212, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Kor'koron Vanguard
				["0.57:0.79:0.64:0.81:0.72:0.71:0.62:0.64:0.64:0.58:0.59:0.45"] = 377, -- Bouldercrag's Refuge, Ulduar, Dun Nifflelem, K3, Ebon Watch, Venomspite
				["0.57:0.79:0.38:0.79:0.28:0.72:0.18:0.60:0.18:0.53:0.29:0.46"] = 446, -- Bouldercrag's Refuge, The Shadow Vault, Death's Rise, Nesingwary Base Camp, Bor'gorok Outpost, Taunka'le Village
				["0.57:0.79:0.38:0.79:0.52:0.66:0.52:0.62:0.62:0.64:0.72:0.71"] = 448, -- Bouldercrag's Refuge, The Shadow Vault, Crusaders' Pinnacle, Dalaran, K3, Dun Nifflelem
				["0.57:0.79:0.38:0.79:0.28:0.72:0.18:0.60:0.18:0.53"] = 369, -- Bouldercrag's Refuge, The Shadow Vault, Death's Rise, Nesingwary Base Camp, Bor'gorok Outpost
				["0.57:0.79:0.64:0.81:0.78:0.62:0.82:0.69"] = 251, -- Bouldercrag's Refuge, Ulduar, Zim'Torga, Gundrak
				["0.57:0.79:0.38:0.79:0.31:0.57"] = 250, -- Bouldercrag's Refuge, The Shadow Vault, Warsong Camp
				["0.57:0.79:0.38:0.79:0.31:0.57:0.24:0.60"] = 326, -- Bouldercrag's Refuge, The Shadow Vault, Warsong Camp, River's Heart
				["0.57:0.79:0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62"] = 369, -- Bergfels' Zuflucht, Ulduar, Zim'Torga, Argentumwache, Schwarze Wacht, Dalaran
				["0.57:0.79:0.60:0.75:0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45"] = 361, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold
				["0.57:0.79:0.38:0.79:0.31:0.57:0.29:0.46:0.17:0.47"] = 404, -- Bouldercrag's Refuge, The Shadow Vault, Warsong Camp, Taunka'le Village, Amber Ledge
				["0.57:0.79:0.64:0.81:0.73:0.75:0.62:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 684, -- Bouldercrag's Refuge, Ulduar, Camp Tunka'lo, K3, Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.57:0.79:0.60:0.75:0.56:0.64:0.52:0.62:0.49:0.42"] = 299, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Moa'ki
				["0.57:0.79:0.38:0.79:0.31:0.57:0.29:0.46"] = 329, -- Bouldercrag's Refuge, The Shadow Vault, Warsong Camp, Taunka'le Village
				["0.57:0.79:0.64:0.81:0.78:0.62:0.84:0.49"] = 280, -- Bouldercrag's Refuge, Ulduar, Zim'Torga, Camp Oneqwah
				["0.57:0.79:0.49:0.79"] = 61, -- Bouldercrag's Refuge, Argent Tournament Grounds
				["0.57:0.79:0.49:0.79:0.52:0.66"] = 131, -- Bouldercrag's Refuge, Argent Tournament Grounds, Crusaders' Pinnacle
				["0.57:0.79:0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38"] = 346, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp
				["0.57:0.79:0.60:0.75:0.62:0.64:0.64:0.58:0.72:0.60"] = 235, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Ebon Watch, The Argent Stand
				["0.57:0.79:0.38:0.79:0.31:0.57:0.29:0.46:0.15:0.43"] = 414, -- Bouldercrag's Refuge, The Shadow Vault, Warsong Camp, Taunka'le Village, Warsong Hold
				["0.57:0.79:0.64:0.81:0.72:0.71:0.62:0.64:0.52:0.62"] = 306, -- Bouldercrag's Refuge, Ulduar, Dun Nifflelem, K3, Dalaran
				["0.57:0.79:0.64:0.81:0.78:0.62:0.84:0.49:0.84:0.41"] = 328, -- Bouldercrag's Refuge, Ulduar, Zim'Torga, Camp Oneqwah, Camp Winterhoof
				["0.57:0.79:0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 400, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.57:0.79:0.64:0.81:0.78:0.62:0.84:0.49:0.84:0.41:0.85:0.27"] = 407, -- Bouldercrag's Refuge, Ulduar, Zim'Torga, Camp Oneqwah, Camp Winterhoof, New Agamand
				["0.57:0.79:0.49:0.79:0.52:0.66:0.31:0.57"] = 288, -- Bouldercrag's Refuge, Argent Tournament Grounds, Crusaders' Pinnacle, Warsong Camp
				["0.57:0.79:0.49:0.79:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 366, -- Bouldercrag's Refuge, Argent Tournament Grounds, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.57:0.79:0.60:0.75:0.62:0.64:0.52:0.62:0.48:0.56"] = 260, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Dalaran, Kor'koron Vanguard
				["0.57:0.79:0.60:0.75:0.62:0.64:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 328, -- Приют Глыбоскала, Место крушения Гром'арша, К-3, Черная застава, Серебряная застава, Зим'Торга, Гундрак
				["0.57:0.79:0.60:0.75:0.62:0.64:0.60:0.60"] = 165, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Sunreaver's Command
				["0.57:0.79:0.60:0.75:0.62:0.64:0.64:0.58:0.59:0.45"] = 270, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Ebon Watch, Venomspite
				["0.57:0.79:0.60:0.75:0.62:0.64:0.52:0.62:0.31:0.57"] = 349, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, K3, Dalaran, Warsong Camp
				["0.57:0.79:0.60:0.75:0.73:0.75:0.78:0.62:0.84:0.49:0.84:0.41"] = 365, -- Bouldercrag's Refuge, Grom'arsh Crash-Site, Camp Tunka'lo, Zim'Torga, Camp Oneqwah, Camp Winterhoof

				-- Horde: The Storm Peaks: Camp Tunka'lo
				["0.73:0.75:0.78:0.62:0.82:0.69"] = 152, -- Camp Tunka'lo, Zim'Torga, Gundrak
				["0.73:0.75:0.62:0.64:0.52:0.62"] = 186, -- Camp Tunka'lo, K3, Dalaran
				["0.73:0.75:0.62:0.64"] = 115, -- Camp Tunka'lo, K3
				["0.73:0.75:0.64:0.81:0.57:0.79"] = 122, -- Camp Tunka'lo, Ulduar, Bouldercrag's Refuge
				["0.73:0.75:0.72:0.71"] = 46, -- Camp Tunka'lo, Dun Nifflelem
				["0.73:0.75:0.60:0.75:0.56:0.64"] = 180, -- Camp Tunka'lo, Grom'arsh Crash-Site, The Argent Vanguard
				["0.73:0.75:0.60:0.75"] = 100, -- Camp Tunka'lo, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.73:0.75:0.62:0.64:0.64:0.58:0.54:0.48:0.49:0.42:0.29:0.43:0.15:0.43"] = 520, -- Camp Tunka'lo, K3, Ebon Watch, Wyrmrest Temple, Moa'ki, Unu'pe, Warsong Hold
				["0.73:0.75:0.62:0.64:0.52:0.62:0.48:0.56"] = 247, -- Camp Tunka'lo, K3, Dalaran, Kor'koron Vanguard
				["0.73:0.75:0.60:0.75:0.57:0.79"] = 137, -- Camp Tunka'lo, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.73:0.75:0.62:0.64:0.52:0.62:0.31:0.57"] = 336, -- Camp Tunka'lo, K3, Dalaran, Warsong Camp
				["0.73:0.75:0.64:0.81"] = 74, -- Camp Tunka'lo, Ulduar
				["0.73:0.75:0.64:0.81:0.57:0.79:0.38:0.79"] = 235, -- Camp Tunka'lo, Ulduar, Bouldercrag's Refuge, The Shadow Vault
				["0.73:0.75:0.62:0.64:0.52:0.62:0.24:0.60"] = 386, -- Camp Tunka'lo, K3, Dalaran, River's Heart
				["0.73:0.75:0.62:0.64:0.64:0.58"] = 158, -- Campamento Tunka'lo, K3, Puesto de Vigilancia de Ébano
				["0.73:0.75:0.78:0.62:0.78:0.61"] = 99, -- Camp Tunka'lo, Zim'Torga
				["0.73:0.75:0.62:0.64:0.64:0.58:0.54:0.48"] = 249, -- Camp Tunka'lo, K3, Schwarze Wacht, Wyrmruhtempel
				["0.73:0.75:0.62:0.64:0.52:0.62:0.54:0.48:0.59:0.45:0.85:0.27"] = 531, -- Camp Tunka'lo, K3, Dalaran, Wyrmrest Temple, Venomspite, New Agamand
				["0.73:0.75:0.62:0.64:0.60:0.60"] = 153, -- Camp Tunka'lo, K3, Sunreaver's Command
				["0.73:0.75:0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49"] = 299, -- Camp Tunka'lo, K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.73:0.75:0.64:0.81:0.57:0.79:0.38:0.79:0.28:0.72"] = 312, -- Camp Tunka'lo, Ulduar, Bouldercrag's Refuge, The Shadow Vault, Death's Rise
				["0.73:0.75:0.60:0.75:0.56:0.64:0.52:0.66"] = 206, -- Camp Tunka'lo, Grom'arsh Crash-Site, The Argent Vanguard, Crusaders' Pinnacle
				["0.73:0.75:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.49:0.42"] = 346, -- Camp Tunka'lo, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.73:0.75:0.62:0.64:0.64:0.58:0.59:0.45"] = 257, -- Camp Tunka'lo, K3, Ebon Watch, Venomspite
				["0.73:0.75:0.60:0.75:0.57:0.79:0.38:0.79"] = 250, -- Camp Tunka'lo, Grom'arsh Crash-Site, Bouldercrag's Refuge, The Shadow Vault
				["0.73:0.75:0.62:0.64:0.52:0.62:0.24:0.60:0.18:0.60"] = 421, -- Camp Tunka'lo, K3, Dalaran, River's Heart, Nesingwary Base Camp
				["0.73:0.75:0.78:0.62:0.84:0.49:0.84:0.41"] = 229, -- Camp Tunka'lo, Zim'Torga, Camp Oneqwah, Camp Winterhoof
				["0.73:0.75:0.60:0.75:0.56:0.64:0.52:0.62"] = 211, -- Camp Tunka'lo, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran
				["0.73:0.75:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62"] = 270, -- Camp Tunka'lo, Zim'Torga, Argentumwache, Schwarze Wacht, Dalaran
				["0.73:0.75:0.78:0.62:0.84:0.49:0.95:0.37"] = 286, -- Camp Tunka'lo, Zim'Torga, Camp Oneqwah, Vengeance Landing
				["0.73:0.75:0.78:0.62:0.72:0.60:0.69:0.58:0.70:0.45"] = 249, -- Camp Tunka'lo, Zim'Torga, The Argent Stand, Light's Breach, Conquest Hold
				["0.73:0.75:0.62:0.64:0.52:0.62:0.52:0.66"] = 215, -- Camp Tunka'lo, K3, Dalaran, Crusaders' Pinnacle
				["0.73:0.75:0.78:0.62:0.72:0.60:0.69:0.58"] = 175, -- Campamento Tunka'lo, Zim'Torga, El Confín Argenta, Brecha de la Luz
				["0.73:0.75:0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46"] = 410, -- Camp Tunka'lo, K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village
				["0.73:0.75:0.78:0.62:0.72:0.60"] = 151, -- Camp Tunka'lo, Zim'Torga, Le séjour d'Argent
				["0.73:0.75:0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 520, -- Camp Tunka'lo, K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.73:0.75:0.78:0.62:0.72:0.60:0.69:0.58:0.70:0.45:0.74:0.38"] = 305, -- Camp Tunka'lo, Zim'Torga, The Argent Stand, Light's Breach, Conquest Hold, Apothecary Camp
				["0.73:0.75:0.62:0.64:0.64:0.58:0.54:0.48:0.49:0.42"] = 301, -- Camp Tunka'lo, K3, Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.73:0.75:0.64:0.81:0.57:0.79:0.49:0.79"] = 182, -- Camp Tunka'lo, Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.73:0.75:0.78:0.62:0.84:0.49"] = 181, -- Camp Tunka'lo, Zim'Torga, Camp Oneqwah
				["0.73:0.75:0.62:0.64:0.52:0.62:0.52:0.66:0.38:0.79"] = 337, -- Camp Tunka'lo, K3, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.73:0.75:0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.18:0.53"] = 482, -- Camp Tunka'lo, K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.73:0.75:0.62:0.64:0.52:0.62:0.56:0.64"] = 209, -- Camp Tunka'lo, K3, Dalaran, The Argent Vanguard
				["0.73:0.75:0.60:0.75:0.56:0.64:0.38:0.79"] = 327, -- Camp Tunka'lo, Grom'arsh Crash-Site, The Argent Vanguard, The Shadow Vault
				["0.73:0.75:0.62:0.64:0.52:0.62:0.24:0.60:0.18:0.53"] = 440, -- Camp Tunka'lo, K3, Dalaran, River's Heart, Bor'gorok Outpost

				-- Horde: The Storm Peaks: Dun Nifflelem
				["0.72:0.71:0.62:0.64:0.52:0.62"] = 159, -- Dun Nifflelem, K3, Dalaran
				["0.72:0.71:0.62:0.64:0.52:0.62:0.24:0.60"] = 360, -- Dun Niffelem, K3, Dalaran, Flussnabel
				["0.72:0.71:0.62:0.64:0.52:0.62:0.52:0.66"] = 188, -- Dun Nifflelem, K3, Dalaran, Crusaders' Pinnacle
				["0.72:0.71:0.64:0.81:0.57:0.79:0.38:0.79"] = 246, -- Dun Nifflelem, Ulduar, Bouldercrag's Refuge, The Shadow Vault
				["0.72:0.71:0.73:0.75:0.60:0.75"] = 132, -- Dun Nifflelem, Camp Tunka'lo, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.72:0.71:0.62:0.64:0.60:0.75"] = 163, -- Dun Niffelem, K3, Absturzstelle Grom'ash
				["0.72:0.71:0.62:0.64:0.52:0.62:0.31:0.57"] = 309, -- Dun Nifflelem, K3, Dalaran, Warsong Camp
				["0.72:0.71:0.62:0.64:0.52:0.62:0.56:0.64"] = 181, -- Dun Nifflelem, K3, Dalaran, The Argent Vanguard
				["0.72:0.71:0.78:0.62:0.72:0.60:0.69:0.58:0.70:0.45"] = 239, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Light's Breach, Conquest Hold
				["0.72:0.71:0.78:0.62:0.84:0.49:0.95:0.37"] = 277, -- Dun Nifflelem, Zim'Torga, Camp Oneqwah, Vengeance Landing
				["0.72:0.71:0.64:0.81:0.60:0.75"] = 128, -- Dun Nifflelem, Ulduar, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.72:0.71:0.62:0.64:0.52:0.62:0.56:0.64:0.38:0.79"] = 328, -- Dun Nifflelem, K3, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.72:0.71:0.78:0.62:0.72:0.60"] = 142, -- Dun Nifflelem, Zim'Torga, The Argent Stand
				["0.72:0.71:0.73:0.75"] = 33, -- Dun Nifflelem, Camp Tunka'lo
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48"] = 222, -- Dun Niffelem, K3, Schwarze Wacht, Wyrmruhtempel
				["0.72:0.71:0.73:0.75:0.60:0.75:0.57:0.79:0.38:0.79"] = 282, -- Dun Nifflelem, Camp Tunka'lo, Grom'arsh Crash-Site, Bouldercrag's Refuge, The Shadow Vault
				["0.72:0.71:0.64:0.81"] = 85, -- Dun Nifflelem, Ulduar
				["0.72:0.71:0.78:0.62:0.72:0.60:0.69:0.58"] = 165, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Light's Breach
				["0.72:0.71:0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 494, -- Dun Nifflelem, K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.72:0.71:0.62:0.64"] = 88, -- Dun Niffelem, K3
				["0.72:0.71:0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47"] = 458, -- Dun Nifflelem, K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.72:0.71:0.78:0.62:0.82:0.69"] = 143, -- Dun Nifflelem, Zim'Torga, Gundrak
				["0.72:0.71:0.64:0.81:0.57:0.79"] = 133, -- Dun Nifflelem, Ulduar, Bouldercrag's Refuge
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.49:0.42"] = 275, -- Dun Nifflelem, K3, Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.72:0.71:0.78:0.62:0.84:0.49:0.84:0.41"] = 220, -- Dun Nifflelem, Zim'Torga, Camp Oneqwah, Camp Winterhoof
				["0.72:0.71:0.62:0.64:0.64:0.58:0.69:0.58"] = 176, -- Dun Nifflelem, K3, Ebon Watch, Light's Breach
				["0.72:0.71:0.62:0.64:0.52:0.62:0.31:0.57:0.28:0.72"] = 422, -- Dun Nifflelem, K3, Dalaran, Warsong Camp, Death's Rise
				["0.72:0.71:0.73:0.75:0.60:0.75:0.57:0.79"] = 169, -- Dun Nifflelem, Camp Tunka'lo, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.72:0.71:0.62:0.64:0.64:0.58:0.59:0.45"] = 229, -- Dun Nifflelem, K3, Ebon Watch, Venomspite
				["0.72:0.71:0.62:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.69:0.58"] = 416, -- Dun Nifflelem, K3, Dalaran, Kor'koron Vanguard, Venomspite, Light's Breach
				["0.72:0.71:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62"] = 261, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran
				["0.72:0.71:0.78:0.62:0.84:0.49:0.84:0.41:0.74:0.38:0.74:0.29"] = 330, -- Dun Nifflelem, Zim'Torga, Camp Oneqwah, Camp Winterhoof, Apothecary Camp, Kamagua
				["0.72:0.71:0.64:0.81:0.60:0.75:0.56:0.64:0.52:0.62"] = 239, -- Dun Nifflelem, Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran
				["0.72:0.71:0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49"] = 273, -- Dun Nifflelem, K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.72:0.71:0.62:0.64:0.64:0.58:0.69:0.58:0.84:0.49:0.95:0.37"] = 386, -- Dun Nifflelem, K3, Ebon Watch, Light's Breach, Camp Oneqwah, Vengeance Landing
				["0.72:0.71:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 573, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.72:0.71:0.62:0.64:0.52:0.62:0.24:0.60:0.18:0.60"] = 394, -- Dun Niffelem, K3, Dalaran, Flussnabel, Nesingwarys Basislager
				["0.72:0.71:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 428, -- Дун Ниффелем, Зим'Торга, Серебряная застава, Черная застава, Даларан, Оплот Серебряного Авангарда, Мрачный Свод
				["0.72:0.71:0.78:0.62:0.84:0.49:0.84:0.41:0.74:0.38"] = 276, -- Dun Nifflelem, Zim'Torga, Camp Oneqwah, Camp Winterhoof, Apothecary Camp
				["0.72:0.71:0.62:0.64:0.52:0.62:0.52:0.66:0.38:0.79"] = 309, -- Dun Nifflelem, K3, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.72:0.71:0.62:0.64:0.52:0.62:0.48:0.56"] = 221, -- Dun Nifflelem, K3, Dalaran, Kor'koron Vanguard
				["0.72:0.71:0.78:0.62:0.78:0.61"] = 90, -- Dun Nifflelem, Zim'Torga
				["0.72:0.71:0.62:0.64:0.60:0.75:0.57:0.79:0.38:0.79"] = 313, -- Dun Nifflelem, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge, The Shadow Vault
				["0.72:0.71:0.78:0.62:0.84:0.49:0.84:0.41:0.85:0.27"] = 299, -- Dun Nifflelem, Zim'Torga, Camp Oneqwah, Camp Winterhoof, New Agamand
				["0.72:0.71:0.62:0.64:0.52:0.62:0.49:0.42"] = 308, -- Dun Nifflelem, K3, Dalaran, Moa'ki
				["0.72:0.71:0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.15:0.43"] = 467, -- Dun Niffelem, K3, Dalaran, Vorposten der Kor'kron, Agmars Hammer, Taunka'le, Kriegshymnenfeste
				["0.72:0.71:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 409, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.72:0.71:0.78:0.62:0.84:0.49:0.84:0.41:0.85:0.27:0.74:0.29"] = 373, -- Dun Nifflelem, Zim'Torga, Camp Oneqwah, Camp Winterhoof, New Agamand, Kamagua
				["0.72:0.71:0.62:0.64:0.52:0.62:0.54:0.48"] = 270, -- Dun Nifflelem, K3, Dalaran, Wyrmrest Temple
				["0.72:0.71:0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45"] = 250, -- Dun Nifflelem, K3, Ebon Watch, Light's Breach, Conquest Hold
				["0.72:0.71:0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46"] = 383, -- Dun Nifflelem, K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village
				["0.72:0.71:0.62:0.64:0.52:0.62:0.24:0.60:0.18:0.53"] = 413, -- Dun Nifflelem, K3, Dalaran, River's Heart, Bor'gorok Outpost
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.49:0.42:0.29:0.43"] = 405, -- Dun Nifflelem, K3, Ebon Watch, Wyrmrest Temple, Moa'ki, Unu'pe
				["0.72:0.71:0.78:0.62:0.72:0.60:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 349, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.72:0.71:0.78:0.62:0.84:0.49"] = 172, -- Dun Nifflelem, Zim'Torga, Camp Oneqwah
				["0.72:0.71:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48"] = 284, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple
				["0.72:0.71:0.64:0.81:0.57:0.79:0.38:0.79:0.28:0.72"] = 323, -- Dun Nifflelem, Ulduar, Bouldercrag's Refuge, The Shadow Vault, Death's Rise
				["0.72:0.71:0.62:0.64:0.52:0.62:0.52:0.66:0.28:0.72"] = 354, -- Dun Nifflelem, K3, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.72:0.71:0.64:0.81:0.60:0.75:0.56:0.64:0.52:0.66"] = 234, -- Dun Nifflelem, Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, Crusaders' Pinnacle
				["0.72:0.71:0.78:0.62:0.72:0.60:0.69:0.58:0.70:0.45:0.74:0.38"] = 295, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Light's Breach, Conquest Hold, Apothecary Camp
				["0.72:0.71:0.62:0.64:0.60:0.60"] = 125, -- Dun Nifflelem, K3, Sunreaver's Command
				["0.72:0.71:0.73:0.75:0.60:0.75:0.56:0.64:0.52:0.62"] = 243, -- Dun Nifflelem, Camp Tunka'lo, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran
				["0.72:0.71:0.62:0.64:0.64:0.58"] = 131, -- Dun Nifflelem, K3, Ebon Watch
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 511, -- Dun Nifflelem, K3, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.45:0.49"] = 290, -- Dun Nifflelem, K3, Ebon Watch, Wyrmrest Temple, Agmar's Hammer
				["0.72:0.71:0.62:0.64:0.64:0.58:0.69:0.58:0.84:0.49"] = 281, -- Dun Nifflelem, K3, Ebon Watch, Light's Breach, Camp Oneqwah
				["0.72:0.71:0.62:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.74:0.38:0.74:0.29"] = 461, -- Dun Nifflelem, K3, Dalaran, Kor'koron Vanguard, Venomspite, Apothecary Camp, Kamagua
				["0.72:0.71:0.62:0.64:0.64:0.58:0.59:0.45:0.74:0.38:0.74:0.29"] = 382, -- Dun Nifflelem, K3, Ebon Watch, Venomspite, Apothecary Camp, Kamagua
				["0.72:0.71:0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 360, -- Dun Nifflelem, K3, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.72:0.71:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60"] = 458, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, River's Heart
				["0.72:0.71:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66"] = 286, -- Dun Niffelem, Zim'Torga, Argentumwache, Schwarze Wacht, Dalaran, Kreuzfahrerturm
				["0.72:0.71:0.73:0.75:0.60:0.75:0.57:0.79:0.38:0.79:0.28:0.72"] = 359, -- Dun Nifflelem, Camp Tunka'lo, Grom'arsh Crash-Site, Bouldercrag's Refuge, The Shadow Vault, Death's Rise
				["0.72:0.71:0.73:0.75:0.60:0.75:0.56:0.64:0.52:0.62:0.24:0.60"] = 442, -- Dun Nifflelem, Camp Tunka'lo, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, River's Heart
				["0.72:0.71:0.64:0.81:0.60:0.75:0.56:0.64:0.38:0.79"] = 354, -- Dun Nifflelem, Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, The Shadow Vault
				["0.72:0.71:0.64:0.81:0.57:0.79:0.49:0.79"] = 193, -- Dun Nifflelem, Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.72:0.71:0.62:0.64:0.64:0.58:0.72:0.60"] = 195, -- Dun Nifflelem, K3, Ebon Watch, The Argent Stand
				["0.72:0.71:0.73:0.75:0.60:0.75:0.57:0.79:0.49:0.79"] = 229, -- Dun Nifflelem, Camp Tunka'lo, Grom'arsh Crash-Site, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.72:0.71:0.62:0.64:0.60:0.75:0.57:0.79"] = 200, -- Dun Nifflelem, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.72:0.71:0.62:0.64:0.52:0.62:0.49:0.79"] = 273, -- Dun Nifflelem, K3, Dalaran, Argent Tournament Grounds
				["0.72:0.71:0.64:0.81:0.57:0.79:0.49:0.79:0.52:0.62"] = 329, -- Dun Nifflelem, Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds, Dalaran
				["0.72:0.71:0.62:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45"] = 369, -- Dun Niffelem, K3, Dalaran, Vorposten der Kor'kron, Gallgrimm, Burg Siegeswall
				["0.72:0.71:0.62:0.64:0.52:0.62:0.54:0.48:0.45:0.49:0.29:0.46"] = 447, -- Dun Nifflelem, K3, Dalaran, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.72:0.71:0.62:0.64:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41"] = 328, -- Dun Niffelem, K3, Schwarze Wacht, Lichtbresche, Camp Oneqwah, Lager der Winterhufe

				-- Horde: The Storm Peaks: Grom'arsh Crash-Site
				["0.60:0.75:0.56:0.64:0.52:0.62"] = 111, -- Grom'arsh Crash-Site, The Argent Vanguard, Dalaran
				["0.60:0.75:0.62:0.64:0.52:0.62:0.24:0.60"] = 358, -- Grom'arsh Crash-Site, K3, Dalaran, River's Heart
				["0.60:0.75:0.62:0.64:0.52:0.62"] = 158, -- Grom'arsh Crash-Site, K3, Dalaran
				["0.60:0.75:0.73:0.75:0.72:0.71"] = 141, -- Grom'arsh Crash-Site, Camp Tunka'lo, Dun Nifflelem
				["0.60:0.75:0.64:0.81"] = 51, -- Point d'impact de Grom'arsh, Ulduar
				["0.60:0.75:0.56:0.64:0.52:0.62:0.49:0.42"] = 259, -- Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Moa'ki
				["0.60:0.75:0.62:0.64"] = 87, -- Grom'arsh Crash-Site, K3
				["0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45"] = 249, -- Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach, Conquest Hold
				["0.60:0.75:0.73:0.75"] = 97, -- Grom'arsh Crash-Site, Camp Tunka'lo
				["0.60:0.75:0.64:0.81:0.72:0.71"] = 156, -- Grom'arsh Crash-Site, Ulduar, Dun Nifflelem
				["0.60:0.75:0.73:0.75:0.78:0.62:0.82:0.69"] = 248, -- Grom'arsh Crash-Site, Camp Tunka'lo, Zim'Torga, Gundrak
				["0.60:0.75:0.56:0.64:0.52:0.66"] = 107, -- Grom'arsh Crash-Site, The Argent Vanguard, Crusaders' Pinnacle
				["0.60:0.75:0.57:0.79"] = 37, -- Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.60:0.75:0.56:0.64:0.52:0.62:0.24:0.60"] = 310, -- Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, River's Heart
				["0.60:0.75:0.62:0.64:0.72:0.71"] = 187, -- Grom'arsh Crash-Site, K3, Dun Nifflelem
				["0.60:0.75:0.73:0.75:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48"] = 389, -- Grom'arsh Crash-Site, Camp Tunka'lo, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple
				["0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38"] = 306, -- Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp
				["0.60:0.75:0.56:0.64"] = 81, -- Grom'arsh Crash-Site, The Argent Vanguard
				["0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.84:0.49:0.95:0.37"] = 385, -- Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach, Camp Oneqwah, Vengeance Landing
				["0.60:0.75:0.56:0.64:0.52:0.66:0.31:0.57"] = 264, -- Absturzstelle Grom'ash, Die Argentumvorhut, Kreuzfahrerturm, Kriegshymnenlager
				["0.60:0.75:0.62:0.64:0.64:0.58:0.72:0.60"] = 195, -- Grom'arsh Crash-Site, K3, Ebon Watch, The Argent Stand
				["0.60:0.75:0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62"] = 376, -- Grom'arsh Crash-Site, Ulduar, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran
				["0.60:0.75:0.57:0.79:0.38:0.79"] = 150, -- Lugar del accidente de Grom'arsh, Refugio de Pedruscón, La Cámara de las Sombras
				["0.60:0.75:0.56:0.64:0.38:0.79"] = 226, -- Grom'arsh Crash-Site, The Argent Vanguard, The Shadow Vault
				["0.60:0.75:0.56:0.64:0.52:0.62:0.48:0.56"] = 171, -- Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Kor'koron Vanguard
				["0.60:0.75:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 445, -- Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 359, -- Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.60:0.75:0.57:0.79:0.38:0.79:0.28:0.72"] = 227, -- Grom'arsh Crash-Site, Bouldercrag's Refuge, The Shadow Vault, Death's Rise
				["0.60:0.75:0.73:0.75:0.78:0.62:0.84:0.49:0.84:0.41"] = 325, -- Grom'arsh Crash-Site, Camp Tunka'lo, Zim'Torga, Camp Oneqwah, Camp Winterhoof
				["0.60:0.75:0.64:0.81:0.78:0.62:0.82:0.69"] = 258, -- Grom'arsh Crash-Site, Ulduar, Zim'Torga, Gundrak
				["0.60:0.75:0.62:0.64:0.64:0.58:0.54:0.48"] = 221, -- Grom'arsh Crash-Site, K3, Ebon Watch, Wyrmrest Temple
				["0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.85:0.27"] = 398, -- Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, New Agamand
				["0.60:0.75:0.73:0.75:0.78:0.62:0.84:0.49:0.95:0.37"] = 382, -- Grom'arsh Crash-Site, Camp Tunka'lo, Zim'Torga, Camp Oneqwah, Vengeance Landing
				["0.60:0.75:0.56:0.64:0.52:0.62:0.31:0.57"] = 260, -- Место крушения Гром'арша, Оплот Серебряного Авангарда, Даларан, Лагерь Песни Войны
				["0.60:0.75:0.62:0.64:0.52:0.62:0.54:0.48"] = 269, -- Grom'arsh Crash-Site, K3, Dalaran, Wyrmrest Temple
				["0.60:0.75:0.62:0.64:0.64:0.58"] = 131, -- Grom'arsh Crash-Site, K3, Ebon Watch
				["0.60:0.75:0.57:0.79:0.38:0.79:0.28:0.72:0.18:0.60"] = 345, -- Grom'arsh Crash-Site, Bouldercrag's Refuge, The Shadow Vault, Death's Rise, Nesingwary Base Camp
				["0.60:0.75:0.56:0.64:0.52:0.62:0.64:0.58"] = 176, -- Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Ebon Watch
				["0.60:0.75:0.62:0.64:0.64:0.58:0.59:0.45"] = 229, -- Grom'arsh Crash-Site, K3, Ebon Watch, Venomspite
				["0.60:0.75:0.62:0.64:0.60:0.60"] = 125, -- Grom'arsh Crash-Site, K3, Sunreaver's Command
				["0.60:0.75:0.62:0.64:0.64:0.58:0.59:0.45:0.70:0.45:0.84:0.41"] = 372, -- Grom'arsh Crash-Site, K3, Ebon Watch, Venomspite, Conquest Hold, Camp Winterhoof
				["0.60:0.75:0.56:0.64:0.52:0.66:0.31:0.57:0.29:0.46:0.15:0.43"] = 427, -- Grom'arsh Crash-Site, The Argent Vanguard, Crusaders' Pinnacle, Warsong Camp, Taunka'le Village, Warsong Hold
				["0.60:0.75:0.57:0.79:0.49:0.79"] = 97, -- Grom'arsh Crash-Site, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.60:0.75:0.73:0.75:0.78:0.62:0.84:0.49"] = 276, -- Absturzstelle Grom'ash, Camp Tunka'lo, Zim'Torga, Camp Oneqwah
				["0.60:0.75:0.56:0.64:0.52:0.62:0.49:0.79"] = 224, -- Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Argent Tournament Grounds
				["0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58"] = 175, -- Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach
				["0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41"] = 328, -- Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.60:0.75:0.56:0.64:0.52:0.66:0.49:0.79"] = 203, -- Absturzstelle Grom'ash, Die Argentumvorhut, Kreuzfahrerturm, Argentumturnierplatz
				["0.60:0.75:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49"] = 224, -- Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.60:0.75:0.62:0.64:0.64:0.58:0.59:0.45:0.70:0.45"] = 288, -- Grom'arsh Crash-Site, K3, Ebon Watch, Venomspite, Conquest Hold
				["0.60:0.75:0.56:0.64:0.52:0.66:0.31:0.57:0.29:0.46"] = 344, -- Grom'arsh Crash-Site, The Argent Vanguard, Crusaders' Pinnacle, Warsong Camp, Taunka'le Village
				["0.60:0.75:0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.49"] = 421, -- Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold, Camp Oneqwah
				["0.60:0.75:0.56:0.64:0.52:0.66:0.31:0.57:0.29:0.46:0.17:0.47"] = 418, -- Grom'arsh Crash-Site, The Argent Vanguard, Crusaders' Pinnacle, Warsong Camp, Taunka'le Village, Amber Ledge
				["0.60:0.75:0.57:0.79:0.38:0.79:0.31:0.57"] = 286, -- Grom'arsh Crash-Site, Bouldercrag's Refuge, The Shadow Vault, Warsong Camp
				["0.60:0.75:0.64:0.81:0.78:0.62:0.84:0.49:0.84:0.41"] = 335, -- Grom'arsh Crash-Site, Ulduar, Zim'Torga, Camp Oneqwah, Camp Winterhoof
				["0.60:0.75:0.56:0.64:0.52:0.62:0.49:0.42:0.45:0.49"] = 320, -- Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Moa'ki, Agmar's Hammer
				["0.60:0.75:0.57:0.79:0.49:0.79:0.52:0.62"] = 234, -- Grom'arsh Crash-Site, Bouldercrag's Refuge, Argent Tournament Grounds, Dalaran
				["0.60:0.75:0.73:0.75:0.78:0.62:0.78:0.61"] = 195, -- Grom'arsh Crash-Site, Camp Tunka'lo, Zim'Torga
				["0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.84:0.49"] = 280, -- Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach, Camp Oneqwah
				["0.60:0.75:0.62:0.64:0.52:0.62:0.49:0.79"] = 273, -- Grom'arsh Crash-Site, K3, Dalaran, Argent Tournament Grounds
				["0.60:0.75:0.62:0.64:0.52:0.62:0.54:0.48:0.45:0.49"] = 336, -- Grom'arsh Crash-Site, K3, Dalaran, Wyrmrest Temple, Agmar's Hammer

				-- Horde: The Storm Peaks: K3
				["0.62:0.64:0.52:0.62"] = 72, -- K3, Dalaran
				["0.62:0.64:0.64:0.58:0.72:0.60"] = 107, -- K3, Ebon Watch, The Argent Stand
				["0.62:0.64:0.52:0.62:0.56:0.64"] = 94, -- K3, Dalaran, The Argent Vanguard
				["0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 272, -- K3, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.62:0.64:0.64:0.58:0.69:0.58"] = 89, -- K3, Ebon Watch, Light's Breach
				["0.62:0.64:0.64:0.58:0.69:0.58:0.84:0.49:0.95:0.37"] = 298, -- K3, Ebon Watch, Light's Breach, Camp Oneqwah, Vengeance Landing
				["0.62:0.64:0.60:0.60"] = 38, -- K3, Sunreaver's Command
				["0.62:0.64:0.64:0.58:0.54:0.48"] = 134, -- K3, Ebon Watch, Wyrmrest Temple
				["0.62:0.64:0.64:0.58:0.59:0.45:0.45:0.49:0.29:0.46"] = 385, -- K3, Ebon Watch, Venomspite, Agmar's Hammer, Taunka'le Village
				["0.62:0.64:0.72:0.71"] = 101, -- K3, Dun Nifflelem
				["0.62:0.64:0.73:0.75"] = 91, -- K3, Camp Tunka'lo
				["0.62:0.64:0.60:0.75:0.64:0.81"] = 127, -- K3, Grom'arsh Crash-Site, Ulduar
				["0.62:0.64:0.64:0.58"] = 44, -- K3, Ebon Watch
				["0.62:0.64:0.64:0.58:0.69:0.58:0.84:0.49"] = 193, -- K3, Ebon Watch, Light's Breach, Camp Oneqwah
				["0.62:0.64:0.52:0.62:0.31:0.57"] = 222, -- K3, Dalaran, Warsong Camp
				["0.62:0.64:0.52:0.62:0.24:0.60:0.28:0.72"] = 357, -- K3, Dalaran, River's Heart, Death's Rise
				["0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45"] = 163, -- K3, Ebon Watch, Light's Breach, Conquest Hold
				["0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.18:0.53"] = 368, -- K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 406, -- K3, Dalaran, Vorposten der Kor'kron, Agmars Hammer, Taunka'le, Bernsteinflöz, Transitusschild
				["0.62:0.64:0.73:0.75:0.64:0.81"] = 163, -- K3, Camp Tunka'lo, Ulduar
				["0.62:0.64:0.52:0.62:0.52:0.66"] = 100, -- K3, Dalaran, Crusaders' Pinnacle
				["0.62:0.64:0.60:0.75:0.57:0.79"] = 112, -- K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.62:0.64:0.52:0.62:0.24:0.60"] = 272, -- K3, Dalaran, River's Heart
				["0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49"] = 185, -- K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.62:0.64:0.60:0.75"] = 76, -- K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.62:0.64:0.60:0.75:0.57:0.79:0.38:0.79"] = 226, -- K3, Grom'arsh Crash-Site, Bouldercrag's Refuge, The Shadow Vault
				["0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.15:0.43"] = 380, -- K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38"] = 219, -- K3, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp
				["0.62:0.64:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 387, -- K3, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.62:0.64:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41"] = 241, -- K3, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.62:0.64:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 148, -- K3, Ebon Watch, The Argent Stand, Zim'Torga
				["0.62:0.64:0.64:0.58:0.54:0.48:0.49:0.42"] = 187, -- K3, Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.62:0.64:0.60:0.75:0.57:0.79:0.38:0.79:0.28:0.72"] = 302, -- K3, Grom'arsh Crash-Site, Bouldercrag's Refuge, The Shadow Vault, Death's Rise
				["0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46"] = 296, -- K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village
				["0.62:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45:0.84:0.49"] = 382, -- K3, Dalaran, Kor'koron Vanguard, Venomspite, Conquest Hold, Camp Oneqwah
				["0.62:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.85:0.27"] = 408, -- K3, Dalaran, Kor'koron Vanguard, Venomspite, New Agamand
				["0.62:0.64:0.52:0.62:0.52:0.66:0.38:0.79"] = 223, -- K3, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.62:0.64:0.52:0.62:0.48:0.56"] = 134, -- K3, Dalaran, Kor'koron Vanguard
				["0.62:0.64:0.52:0.62:0.24:0.60:0.18:0.60"] = 307, -- K3, Dalaran, River's Heart, Nesingwary Base Camp
				["0.62:0.64:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 201, -- K3, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.62:0.64:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46"] = 313, -- K3, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.85:0.27"] = 310, -- K3, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, New Agamand
				["0.62:0.64:0.64:0.58:0.59:0.45"] = 142, -- K3, Ebon Watch, Venomspite
				["0.62:0.64:0.64:0.58:0.54:0.48:0.49:0.42:0.29:0.43"] = 318, -- K3, Ebon Watch, Wyrmrest Temple, Moa'ki, Unu'pe
				["0.62:0.64:0.52:0.62:0.24:0.60:0.18:0.53"] = 326, -- K3, Dalaran, River's Heart, Bor'gorok Outpost
				["0.62:0.64:0.52:0.62:0.54:0.48"] = 183, -- K3, Dalaran, Wyrmruhtempel
				["0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.29:0.43"] = 325, -- K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Unu'pe
				["0.62:0.64:0.52:0.62:0.52:0.66:0.28:0.72"] = 267, -- K3, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47"] = 371, -- K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.62:0.64:0.73:0.75:0.64:0.81:0.57:0.79"] = 212, -- K3, Camp Tunka'lo, Ulduar, Bouldercrag's Refuge
				["0.62:0.64:0.64:0.58:0.59:0.45:0.74:0.38"] = 240, -- K3, Ebon Watch, Venomspite, Apothecary Camp
				["0.62:0.64:0.52:0.62:0.54:0.48:0.45:0.49"] = 249, -- K3, Dalaran, Wyrmrest Temple, Agmar's Hammer
				["0.62:0.64:0.52:0.62:0.54:0.48:0.59:0.45:0.70:0.45"] = 289, -- K3, Dalaran, Wyrmrest Temple, Venomspite, Conquest Hold
				["0.62:0.64:0.60:0.75:0.57:0.79:0.49:0.79"] = 173, -- K3, Grom'arsh Crash-Site, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.62:0.64:0.64:0.58:0.59:0.45:0.70:0.45"] = 201, -- K3, Ebon Watch, Venomspite, Conquest Hold
				["0.62:0.64:0.73:0.75:0.78:0.62:0.84:0.49:0.84:0.41"] = 319, -- K3, Camp Tunka'lo, Zim'Torga, Camp Oneqwah, Camp Winterhoof
				["0.62:0.64:0.52:0.62:0.56:0.64:0.38:0.79"] = 240, -- K3, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.62:0.64:0.52:0.62:0.49:0.79:0.57:0.79"] = 233, -- K3, Dalaran, Argent Tournament Grounds, Bouldercrag's Refuge
				["0.62:0.64:0.64:0.58:0.59:0.45:0.70:0.45:0.84:0.41"] = 285, -- K3, Ebon Watch, Venomspite, Conquest Hold, Camp Winterhoof
				["0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45:0.84:0.41:0.95:0.37"] = 320, -- K3, Ebon Watch, Light's Breach, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.62:0.64:0.52:0.62:0.49:0.79"] = 186, -- K3, Dalaran, Argent Tournament Grounds
				["0.62:0.64:0.73:0.75:0.78:0.62:0.84:0.49"] = 271, -- K3, Camp Tunka'lo, Zim'Torga, Camp Oneqwah
				["0.62:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.85:0.27:0.95:0.37"] = 487, -- K3, Dalaran, Kor'koron Vanguard, Venomspite, New Agamand, Vengeance Landing
				["0.62:0.64:0.52:0.62:0.48:0.56:0.59:0.45:0.70:0.45"] = 282, -- К-3, Даларан, Стоянка отряда Кор'крона, Ядозлобь, Крепость Завоевателей

				-- Horde: The Storm Peaks: Ulduar
				["0.64:0.81:0.73:0.75"] = 88, -- Ulduar, Camp Tunka'lo
				["0.64:0.81:0.78:0.62:0.82:0.69"] = 207, -- Ulduar, Zim'Torga, Gundrak
				["0.64:0.81:0.60:0.75"] = 44, -- Ulduar, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.64:0.81:0.60:0.75:0.56:0.64"] = 124, -- Ulduar, Grom'arsh Crash-Site, The Argent Vanguard
				["0.64:0.81:0.60:0.75:0.62:0.64:0.52:0.62"] = 201, -- Ulduar, Grom'arsh Crash-Site, K3, Dalaran
				["0.64:0.81:0.72:0.71"] = 105, -- Ulduar, Dun Nifflelem
				["0.64:0.81:0.60:0.75:0.62:0.64"] = 130, -- Ulduar, Grom'arsh Crash-Site, K3
				["0.64:0.81:0.78:0.62:0.78:0.61"] = 153, -- Ulduar, Zim'Torga
				["0.64:0.81:0.60:0.75:0.62:0.64:0.64:0.58:0.59:0.45"] = 272, -- Ulduar, Grom'arsh Crash-Site, K3, Ebon Watch, Venomspite
				["0.64:0.81:0.57:0.79:0.38:0.79"] = 161, -- Ulduar, Bouldercrag's Refuge, The Shadow Vault
				["0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 599, -- Ulduar, Zim'Torga, Argentumwache, Schwarze Wacht, Wyrmruhtempel, Agmars
				["0.64:0.81:0.60:0.75:0.56:0.64:0.52:0.62"] = 154, -- Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran
				["0.64:0.81:0.57:0.79"] = 49, -- Ulduar, Bouldercrag's Refuge
				["0.64:0.81:0.60:0.75:0.56:0.64:0.52:0.62:0.24:0.60"] = 354, -- Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, River's Heart
				["0.64:0.81:0.78:0.62:0.84:0.49:0.84:0.41:0.74:0.38"] = 340, -- Ulduar, Zim'Torga, Camp Oneqwah, Camp Winterhoof, Apothecary Camp
				["0.64:0.81:0.57:0.79:0.38:0.79:0.28:0.72:0.18:0.60"] = 356, -- Ulduar, Bouldercrag's Refuge, The Shadow Vault, Death's Rise, Nesingwary Base Camp
				["0.64:0.81:0.78:0.62:0.84:0.49:0.84:0.41"] = 284, -- Ulduar, Zim'Torga, Camp Oneqwah, Camp Winterhoof
				["0.64:0.81:0.78:0.62:0.84:0.49:0.84:0.41:0.85:0.27"] = 363, -- Ulduar, Zim'Torga, Camp Oneqwah, Camp Winterhoof, New Agamand
				["0.64:0.81:0.73:0.75:0.62:0.64"] = 202, -- Ulduar, Camp Tunka'lo, K3
				["0.64:0.81:0.72:0.71:0.62:0.64:0.52:0.62"] = 262, -- Ulduar, Dun Nifflelem, K3, Dalaran
				["0.64:0.81:0.60:0.75:0.56:0.64:0.52:0.62:0.48:0.56"] = 215, -- Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Kor'koron Vanguard
				["0.64:0.81:0.57:0.79:0.38:0.79:0.52:0.66"] = 282, -- Ульдуар, Приют Глыбоскала, Мрачный Свод, Вершина Рыцарей
				["0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58"] = 258, -- Ulduar, Zim'Torga, The Argent Stand, Ebon Watch
				["0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58:0.59:0.45"] = 350, -- Ulduar, Zim'Torga, The Argent Stand, Light's Breach, Venomspite
				["0.64:0.81:0.78:0.62:0.84:0.49"] = 236, -- Ulduar, Zim'Torga, Camp Oneqwah
				["0.64:0.81:0.72:0.71:0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49"] = 376, -- Ulduar, Dun Nifflelem, K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62"] = 325, -- Ulduar, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran
				["0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60"] = 523, -- Ulduar, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, River's Heart
				["0.64:0.81:0.60:0.75:0.62:0.64:0.64:0.58"] = 174, -- Ulduar, Absturzstelle Grom'ash, K3, Schwarze Wacht
				["0.64:0.81:0.60:0.75:0.56:0.64:0.52:0.66"] = 150, -- Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, Crusaders' Pinnacle
				["0.64:0.81:0.57:0.79:0.38:0.79:0.31:0.57"] = 298, -- Ulduar, Bouldercrag's Refuge, The Shadow Vault, Warsong Camp
				["0.64:0.81:0.73:0.75:0.62:0.64:0.52:0.62"] = 273, -- Ulduar, Camp Tunka'lo, K3, Dalaran
				["0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 413, -- Ulduar, Zim'Torga, The Argent Stand, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.62:0.64"] = 298, -- Ulduar, Zim'Torga, The Argent Stand, Ebon Watch, K3
				["0.64:0.81:0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58"] = 218, -- Ulduar, Lugar del accidente de Grom'arsh, K3, Puesto de Vigilancia de Ébano, Brecha de la Luz
				["0.64:0.81:0.78:0.62:0.72:0.60"] = 206, -- Ulduar, Zim'Torga, The Argent Stand
				["0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58:0.70:0.45"] = 303, -- Ulduar, Zim'Torga, The Argent Stand, Light's Breach, Conquest Hold
				["0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 558, -- Ulduar, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.64:0.81:0.78:0.62:0.84:0.49:0.95:0.37"] = 341, -- Ulduar, Zim'Torga, Camp Oneqwah, Vengeance Landing
				["0.64:0.81:0.60:0.75:0.62:0.64:0.52:0.62:0.48:0.56:0.45:0.49"] = 315, -- Ulduar, Grom'arsh Crash-Site, K3, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.64:0.81:0.60:0.75:0.62:0.64:0.64:0.58:0.54:0.48"] = 265, -- Ulduar, Point d'impact de Grom'arsh, K3, Guet d'Ébène, Temple du Repos du ver
				["0.64:0.81:0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38"] = 349, -- Ulduar, Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp
				["0.64:0.81:0.60:0.75:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49"] = 266, -- Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer
				["0.64:0.81:0.60:0.75:0.62:0.64:0.52:0.62:0.52:0.66:0.28:0.72"] = 397, -- Ulduar, Grom'arsh Crash-Site, K3, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.52:0.62"] = 498, -- Ulduar, Zim'Torga, The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Dalaran
				["0.64:0.81:0.57:0.79:0.38:0.79:0.31:0.57:0.29:0.46:0.29:0.43"] = 406, -- Ulduar, Bouldercrag's Refuge, The Shadow Vault, Warsong Camp, Taunka'le Village, Unu'pe
				["0.64:0.81:0.57:0.79:0.38:0.79:0.28:0.72:0.18:0.60:0.18:0.53"] = 417, -- 울두아르 (폭풍우 봉우리), 바울더크랙의 은거처 (폭풍우 봉우리), 어둠의 무기고 (얼음왕관), 죽음의 마루 (얼음왕관), 네싱워리 주둔지 (숄라자르 분지), 보르고로크 전초기지 (북풍의 땅), 보르고로크 전초기지 (북풍의 땅)
				["0.64:0.81:0.60:0.75:0.56:0.64:0.52:0.62:0.31:0.57"] = 304, -- Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Warsong Camp
				["0.64:0.81:0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45"] = 292, -- Ulduar, Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach, Conquest Hold
				["0.64:0.81:0.60:0.75:0.56:0.64:0.38:0.79"] = 270, -- Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, The Shadow Vault
				["0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58"] = 230, -- Ulduar, Zim'Torga, The Argent Stand, Light's Breach
				["0.64:0.81:0.57:0.79:0.38:0.79:0.28:0.72:0.24:0.60"] = 355, -- Ulduar, Bergfels' Zuflucht, Das Schattengewölbe, Todesanhöhe, Flussnabel
				["0.64:0.81:0.78:0.62:0.84:0.49:0.84:0.41:0.74:0.38:0.74:0.29"] = 394, -- Ulduar, Zim'Torga, Camp Oneqwah, Camp Winterhoof, Apothecary Camp, Kamagua
				["0.64:0.81:0.60:0.75:0.62:0.64:0.64:0.58:0.54:0.48:0.45:0.49"] = 332, -- Ulduar, Grom'arsh Crash-Site, K3, Ebon Watch, Wyrmrest Temple, Agmar's Hammer
				["0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58:0.70:0.45:0.74:0.38"] = 359, -- Ulduar, Zim'Torga, The Argent Stand, Light's Breach, Conquest Hold, Apothecary Camp
				["0.64:0.81:0.60:0.75:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 488, -- Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.64:0.81:0.60:0.75:0.56:0.64:0.52:0.66:0.28:0.72"] = 317, -- Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, Crusaders' Pinnacle, Death's Rise
				["0.64:0.81:0.57:0.79:0.49:0.79"] = 109, -- Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.64:0.81:0.57:0.79:0.38:0.79:0.28:0.72"] = 239, -- Ulduar, Bouldercrag's Refuge, The Shadow Vault, Death's Rise
				["0.64:0.81:0.57:0.79:0.49:0.79:0.52:0.62"] = 245, -- Ulduar, Refuge de Rochecombe, Enceinte du tournoi d'Argent, Dalaran
				["0.64:0.81:0.60:0.75:0.56:0.64:0.52:0.62:0.48:0.56:0.45:0.49:0.29:0.46"] = 377, -- Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village
				["0.64:0.81:0.60:0.75:0.62:0.64:0.52:0.62:0.24:0.60"] = 402, -- Ulduar, Grom'arsh Crash-Site, K3, Dalaran, River's Heart
				["0.64:0.81:0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45:0.84:0.41"] = 377, -- Ulduar, Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach, Conquest Hold, Camp Winterhoof
				["0.64:0.81:0.60:0.75:0.56:0.64:0.52:0.62:0.49:0.42"] = 302, -- Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Moa'ki
				["0.64:0.81:0.57:0.79:0.38:0.79:0.31:0.57:0.29:0.46:0.17:0.47:0.12:0.47"] = 488, -- Ulduar, Bouldercrag's Refuge, The Shadow Vault, Warsong Camp, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.64:0.81:0.60:0.75:0.62:0.64:0.52:0.62:0.31:0.57"] = 352, -- Ulduar, Grom'arsh Crash-Site, K3, Dalaran, Warsong Camp
				["0.64:0.81:0.60:0.75:0.62:0.64:0.64:0.58:0.72:0.60"] = 237, -- Ulduar, Grom'arsh Crash-Site, K3, Ebon Watch, The Argent Stand
				["0.64:0.81:0.60:0.75:0.62:0.64:0.52:0.62:0.48:0.56"] = 263, -- Ulduar, Grom'arsh Crash-Site, K3, Dalaran, Kor'koron Vanguard
				["0.64:0.81:0.60:0.75:0.56:0.64:0.52:0.62:0.48:0.56:0.59:0.45"] = 304, -- Ulduar, Grom'arsh Crash-Site, The Argent Vanguard, Dalaran, Kor'koron Vanguard, Venomspite
				["0.64:0.81:0.57:0.79:0.38:0.79:0.31:0.57:0.29:0.46:0.15:0.43"] = 461, -- Ulduar, Bouldercrag's Refuge, The Shadow Vault, Warsong Camp, Taunka'le Village, Warsong Hold
				["0.64:0.81:0.57:0.79:0.38:0.79:0.31:0.57:0.29:0.46"] = 377, -- Ulduar, Bouldercrag's Refuge, The Shadow Vault, Warsong Camp, Taunka'le Village
				["0.64:0.81:0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.84:0.49"] = 323, -- Ulduar, Point d'impact de Grom'arsh, K3, Guet d'Ébène, La Brèche de Lumière, Camp Oneqwah
				["0.64:0.81:0.60:0.75:0.62:0.64:0.64:0.58:0.69:0.58:0.70:0.45:0.84:0.41:0.95:0.37"] = 450, -- Ulduar, Grom'arsh Crash-Site, K3, Ebon Watch, Light's Breach, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.64:0.81:0.57:0.79:0.38:0.79:0.31:0.57:0.29:0.46:0.17:0.47"] = 452, -- Ulduar, Bouldercrag's Refuge, The Shadow Vault, Warsong Camp, Taunka'le Village, Amber Ledge

				----------------------------------------------------------------------
				-- Horde: Wintergrasp
				----------------------------------------------------------------------

				-- Horde: Wintergrasp: Warsong Camp
				["0.31:0.57:0.24:0.60"] = 77, -- Warsong Camp, River's Heart
				["0.31:0.57:0.29:0.46"] = 81, -- Warsong Camp, Taunka'le Village
				["0.31:0.57:0.52:0.62"] = 141, -- Warsong Camp, Dalaran
				["0.31:0.57:0.24:0.60:0.18:0.53"] = 131, -- Warsong Camp, River's Heart, Bor'gorok Outpost
				["0.31:0.57:0.29:0.46:0.29:0.43"] = 109, -- Warsong Camp, Taunka'le Village, Unu'pe
				["0.31:0.57:0.29:0.46:0.17:0.47:0.12:0.47"] = 191, -- Warsong Camp, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.31:0.57:0.45:0.49:0.59:0.45:0.85:0.27"] = 371, -- Warsong Camp, Agmar's Hammer, Venomspite, New Agamand
				["0.31:0.57:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 401, -- Warsong Camp, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.31:0.57:0.45:0.49:0.49:0.42"] = 161, -- Warsong Camp, Agmar's Hammer, Moa'ki
				["0.31:0.57:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 365, -- Warsong Camp, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.31:0.57:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 312, -- Warsong Camp, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.31:0.57:0.45:0.49"] = 101, -- Warsong Camp, Agmar's Hammer
				["0.31:0.57:0.29:0.46:0.18:0.53"] = 152, -- Warsong Camp, Taunka'le Village, Bor'gorok Outpost
				["0.31:0.57:0.52:0.62:0.56:0.64"] = 163, -- Warsong Camp, Dalaran, The Argent Vanguard
				["0.31:0.57:0.29:0.46:0.15:0.43"] = 164, -- Warsong Camp, Taunka'le Village, Warsong Hold
				["0.31:0.57:0.52:0.62:0.62:0.64:0.72:0.71"] = 287, -- Warsong Camp, Dalaran, K3, Dun Nifflelem
				["0.31:0.57:0.45:0.49:0.59:0.45:0.70:0.45"] = 243, -- Kriegshymnenlager, Agmars Hammer, Gallgrimm, Burg Siegeswall
				["0.31:0.57:0.29:0.46:0.17:0.47"] = 155, -- Warsong Camp, Taunka'le Village, Amber Ledge
				["0.31:0.57:0.52:0.62:0.62:0.64"] = 186, -- Warsong Camp, Dalaran, K3
				["0.31:0.57:0.45:0.49:0.54:0.48"] = 149, -- Warsong Camp, Agmar's Hammer, Wyrmrest Temple
				["0.31:0.57:0.52:0.62:0.62:0.64:0.73:0.75"] = 277, -- Warsong Camp, Dalaran, K3, Camp Tunka'lo
				["0.31:0.57:0.52:0.62:0.64:0.58:0.69:0.58"] = 252, -- Warsong Camp, Dalaran, Ebon Watch, Light's Breach
				["0.31:0.57:0.38:0.79"] = 164, -- Warsong Camp, The Shadow Vault
				["0.31:0.57:0.52:0.62:0.62:0.64:0.60:0.75:0.64:0.81"] = 312, -- Warsong Camp, Dalaran, K3, Grom'arsh Crash-Site, Ulduar
				["0.31:0.57:0.24:0.60:0.18:0.60"] = 112, -- Warsong Camp, River's Heart, Nesingwary Base Camp
				["0.31:0.57:0.52:0.62:0.64:0.58"] = 208, -- Warsong Camp, Dalaran, Ebon Watch
				["0.31:0.57:0.52:0.66"] = 160, -- Kriegshymnenlager, Kreuzfahrerturm
				["0.31:0.57:0.52:0.62:0.54:0.48:0.59:0.45:0.74:0.38"] = 399, -- Warsong Camp, Dalaran, Wyrmrest Temple, Venomspite, Apothecary Camp
				["0.31:0.57:0.28:0.72"] = 113, -- Warsong Camp, Death's Rise
				["0.31:0.57:0.52:0.62:0.60:0.60"] = 188, -- Warsong Camp, Dalaran, Sunreaver's Command
				["0.31:0.57:0.52:0.62:0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41"] = 405, -- Warsong Camp, Dalaran, Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.31:0.57:0.45:0.49:0.49:0.42:0.74:0.29"] = 344, -- Warsong Camp, Agmar's Hammer, Moa'ki, Kamagua
				["0.31:0.57:0.45:0.49:0.48:0.56"] = 162, -- Warsong Camp, Agmar's Hammer, Kor'koron Vanguard
				["0.31:0.57:0.45:0.49:0.59:0.45"] = 186, -- Warsong Camp, Agmar's Hammer, Venomspite
				["0.31:0.57:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.41"] = 328, -- Warsong Camp, Agmar's Hammer, Venomspite, Conquest Hold, Camp Winterhoof
				["0.31:0.57:0.52:0.62:0.64:0.58:0.72:0.60"] = 271, -- Warsong Camp, Dalaran, Ebon Watch, The Argent Stand
				["0.31:0.57:0.45:0.49:0.59:0.45:0.74:0.38"] = 283, -- Camp chanteguerre, Marteau d'Agmar, Vexevenin, Camp des Apothicaires
				["0.31:0.57:0.52:0.62:0.62:0.64:0.60:0.75"] = 262, -- Kriegshymnenlager, Dalaran, K3, Absturzstelle Grom'ash
				["0.31:0.57:0.38:0.79:0.49:0.79"] = 240, -- Warsong Camp, The Shadow Vault, Argent Tournament Grounds
				["0.31:0.57:0.45:0.49:0.59:0.45:0.70:0.45:0.84:0.49"] = 345, -- Warsong Camp, Agmar's Hammer, Venomspite, Conquest Hold, Camp Oneqwah
				["0.31:0.57:0.52:0.62:0.49:0.79"] = 255, -- Warsong Camp, Dalaran, Argent Tournament Grounds
				["0.31:0.57:0.52:0.62:0.56:0.64:0.60:0.75:0.64:0.81"] = 317, -- Warsong Camp, Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Ulduar
				["0.31:0.57:0.45:0.49:0.59:0.45:0.74:0.38:0.74:0.29"] = 337, -- Warsong Camp, Agmar's Hammer, Venomspite, Apothecary Camp, Kamagua
				["0.31:0.57:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 396, -- Warsong Camp, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.31:0.57:0.38:0.79:0.57:0.79"] = 285, -- Warsong Camp, The Shadow Vault, Bouldercrag's Refuge
				["0.31:0.57:0.45:0.49:0.59:0.45:0.74:0.38:0.84:0.41:0.84:0.49"] = 400, -- Warsong Camp, Agmar's Hammer, Venomspite, Apothecary Camp, Camp Winterhoof, Camp Oneqwah

				----------------------------------------------------------------------
				-- Horde: Zul'Drak
				----------------------------------------------------------------------

				-- Horde: Zul'Drak: The Argent Stand
				["0.72:0.60:0.69:0.58"] = 25, -- The Argent Stand, Light's Breach
				["0.72:0.60:0.78:0.62:0.78:0.61"] = 42, -- The Argent Stand, Zim'Torga
				["0.72:0.60:0.78:0.62:0.82:0.69"] = 95, -- The Argent Stand, Zim'Torga, Gundrak
				["0.72:0.60:0.64:0.58"] = 53, -- The Argent Stand, Ebon Watch
				["0.72:0.60:0.64:0.58:0.52:0.62"] = 120, -- The Argent Stand, Ebon Watch, Dalaran
				["0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64"] = 141, -- The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard
				["0.72:0.60:0.84:0.49:0.84:0.41"] = 148, -- The Argent Stand, Camp Oneqwah, Camp Winterhoof
				["0.72:0.60:0.84:0.49"] = 100, -- The Argent Stand, Camp Oneqwah
				["0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49"] = 212, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer
				["0.72:0.60:0.84:0.49:0.95:0.37"] = 205, -- The Argent Stand, Camp Oneqwah, Vengeance Landing
				["0.72:0.60:0.84:0.49:0.70:0.45"] = 195, -- The Argent Stand, Camp Oneqwah, Conquest Hold
				["0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48"] = 196, -- The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple
				["0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 406, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.72:0.60:0.69:0.58:0.70:0.45"] = 98, -- The Argent Stand, Light's Breach, Conquest Hold
				["0.72:0.60:0.69:0.58:0.59:0.45"] = 145, -- The Argent Stand, Light's Breach, Venomspite
				["0.72:0.60:0.64:0.58:0.48:0.56:0.45:0.49"] = 213, -- The Argent Stand, Ebon Watch, Kor'koron Vanguard, Agmar's Hammer
				["0.72:0.60:0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 596, -- The Argent Stand, Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 268, -- Le séjour d'Argent, Guet d'Ébène, Dalaran, Cime des Croisés, Le caveau des Ombres
				["0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.52:0.62"] = 293, -- The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Dalaran
				["0.72:0.60:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 208, -- The Argent Stand, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.72:0.60:0.64:0.58:0.54:0.48"] = 144, -- The Argent Stand, Ebon Watch, Wyrmrest Temple
				["0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 394, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.72:0.60:0.64:0.58:0.62:0.64"] = 94, -- The Argent Stand, Ebon Watch, K3
				["0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66"] = 146, -- The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.72:0.60:0.84:0.49:0.95:0.37:0.85:0.27:0.74:0.29"] = 366, -- The Argent Stand, Camp Oneqwah, Vengeance Landing, New Agamand, Kamagua
				["0.72:0.60:0.69:0.58:0.59:0.45:0.49:0.42:0.29:0.43:0.15:0.43"] = 445, -- The Argent Stand, Light's Breach, Venomspite, Moa'ki, Unu'pe, Warsong Hold
				["0.72:0.60:0.64:0.58:0.60:0.60"] = 79, -- The Argent Stand, Ebon Watch, Sunreaver's Command
				["0.72:0.60:0.78:0.62:0.72:0.71"] = 127, -- The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.72:0.60:0.64:0.58:0.48:0.56"] = 160, -- The Argent Stand, Ebon Watch, Kor'koron Vanguard
				["0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60"] = 318, -- The Argent Stand, Ebon Watch, Dalaran, River's Heart
				["0.72:0.60:0.64:0.58:0.62:0.64:0.72:0.71"] = 194, -- Argentumwache, Schwarze Wacht, K3, Dun Niffelem
				["0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.31:0.57"] = 325, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Warsong Camp
				["0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49"] = 266, -- The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Agmar's Hammer
				["0.72:0.60:0.64:0.58:0.62:0.64:0.60:0.75"] = 168, -- The Argent Stand, Ebon Watch, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.72:0.60:0.64:0.58:0.52:0.62:0.31:0.57"] = 267, -- Argentumwache, Schwarze Wacht, Dalaran, Kriegshymnenlager
				["0.72:0.60:0.84:0.49:0.84:0.41:0.74:0.38"] = 205, -- The Argent Stand, Camp Oneqwah, Camp Winterhoof, Apothecary Camp
				["0.72:0.60:0.69:0.58:0.70:0.45:0.74:0.38"] = 155, -- The Argent Stand, Light's Breach, Conquest Hold, Apothecary Camp
				["0.72:0.60:0.64:0.58:0.54:0.48:0.49:0.42"] = 196, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.72:0.60:0.78:0.62:0.64:0.81:0.57:0.79"] = 243, -- The Argent Stand, Zim'Torga, Ulduar, Bouldercrag's Refuge
				["0.72:0.60:0.78:0.62:0.73:0.75"] = 128, -- The Argent Stand, Zim'Torga, Camp Tunka'lo
				["0.72:0.60:0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.45:0.49"] = 402, -- The Argent Stand, Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Agmar's Hammer
				["0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64:0.60:0.75"] = 243, -- The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 486, -- The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.72:0.60:0.69:0.58:0.59:0.45:0.49:0.42:0.52:0.62"] = 348, -- The Argent Stand, Light's Breach, Venomspite, Moa'ki, Dalaran
				["0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 461, -- The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 353, -- The Argent Stand, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.72:0.60:0.69:0.58:0.59:0.45:0.45:0.49"] = 277, -- The Argent Stand, Light's Breach, Venomspite, Agmar's Hammer
				["0.72:0.60:0.64:0.58:0.48:0.56:0.45:0.49:0.29:0.46:0.18:0.53"] = 395, -- The Argent Stand, Ebon Watch, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.72:0.60:0.64:0.58:0.54:0.48:0.49:0.42:0.29:0.43"] = 327, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Moa'ki, Unu'pe
				["0.72:0.60:0.84:0.49:0.70:0.45:0.59:0.45"] = 282, -- The Argent Stand, Camp Oneqwah, Conquest Hold, Venomspite
				["0.72:0.60:0.78:0.62:0.64:0.81"] = 195, -- The Argent Stand, Zim'Torga, Ulduar
				["0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.48:0.56"] = 262, -- The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Kor'koron Vanguard
				["0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46"] = 322, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 288, -- The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.72:0.60:0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62"] = 429, -- The Argent Stand, Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran
				["0.72:0.60:0.84:0.49:0.84:0.41:0.85:0.27"] = 227, -- The Argent Stand, Camp Oneqwah, Camp Winterhoof, New Agamand
				["0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 397, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.72:0.60:0.69:0.58:0.59:0.45:0.48:0.56:0.52:0.62"] = 320, -- The Argent Stand, Light's Breach, Venomspite, Kor'koron Vanguard, Dalaran
				["0.72:0.60:0.84:0.49:0.84:0.41:0.85:0.27:0.74:0.29"] = 300, -- The Argent Stand, Camp Oneqwah, Camp Winterhoof, New Agamand, Kamagua
				["0.72:0.60:0.69:0.58:0.70:0.45:0.84:0.41"] = 182, -- The Argent Stand, Light's Breach, Conquest Hold, Camp Winterhoof
				["0.72:0.60:0.64:0.58:0.59:0.45"] = 152, -- The Argent Stand, Ebon Watch, Venomspite
				["0.72:0.60:0.64:0.58:0.48:0.56:0.45:0.49:0.29:0.46:0.15:0.43"] = 408, -- The Argent Stand, Ebon Watch, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 432, -- Argentumwache, Schwarze Wacht, Wyrmruhtempel, Agmars Hammer, Taunka'le, Bernsteinflöz, Transitusschild
				["0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 313, -- Серебряная застава, Черная застава, Даларан, Вершина Рыцарей, Уступ Смерти
				["0.72:0.60:0.69:0.58:0.59:0.45:0.49:0.42:0.29:0.43:0.29:0.46:0.18:0.53"] = 451, -- The Argent Stand, Light's Breach, Venomspite, Moa'ki, Unu'pe, Taunka'le Village, Bor'gorok Outpost
				["0.72:0.60:0.69:0.58:0.59:0.45:0.74:0.38:0.74:0.29"] = 296, -- The Argent Stand, Light's Breach, Venomspite, Apothecary Camp, Kamagua
				["0.72:0.60:0.64:0.58:0.52:0.62:0.49:0.79"] = 233, -- The Argent Stand, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.72:0.60:0.69:0.58:0.59:0.45:0.74:0.38:0.84:0.41:0.95:0.37"] = 376, -- The Argent Stand, Light's Breach, Venomspite, Apothecary Camp, Camp Winterhoof, Vengeance Landing
				["0.72:0.60:0.64:0.58:0.62:0.64:0.60:0.75:0.64:0.81"] = 219, -- The Argent Stand, Ebon Watch, K3, Grom'arsh Crash-Site, Ulduar
				["0.72:0.60:0.64:0.58:0.62:0.64:0.60:0.75:0.57:0.79"] = 205, -- The Argent Stand, Ebon Watch, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79:0.28:0.72"] = 364, -- Argentumwache, Schwarze Wacht, Dalaran, Die Argentumvorhut, Das Schattengewölbe, Todesanhöhe
				["0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.52:0.62:0.56:0.64:0.38:0.79"] = 461, -- The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.53"] = 371, -- The Argent Stand, Ebon Watch, Dalaran, River's Heart, Bor'gorok Outpost
				["0.72:0.60:0.78:0.62:0.72:0.71:0.62:0.64:0.60:0.75:0.57:0.79:0.49:0.79"] = 385, -- The Argent Stand, Zim'Torga, Dun Nifflelem, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge, Argent Tournament Grounds

				-- Horde: Zul'Drak: Ebon Watch
				["0.64:0.58:0.69:0.58"] = 45, -- Ebon Watch, Light's Breach
				["0.64:0.58:0.72:0.60"] = 65, -- Ebon Watch, The Argent Stand
				["0.64:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 105, -- Ebon Watch, The Argent Stand, Zim'Torga
				["0.64:0.58:0.52:0.62"] = 68, -- Ebon Watch, Dalaran (Andrew McIlwrath reported 35)
				["0.64:0.58:0.62:0.64"] = 41, -- Ebon Watch, K3
				["0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38"] = 175, -- Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp
				["0.64:0.58:0.52:0.62:0.56:0.64"] = 89, -- Ebon Watch, Dalaran, The Argent Vanguard
				["0.64:0.58:0.59:0.45:0.70:0.45:0.84:0.41"] = 242, -- Ebon Watch, Venomspite, Conquest Hold, Camp Winterhoof
				["0.64:0.58:0.59:0.45:0.70:0.45:0.84:0.41:0.95:0.37"] = 316, -- Ebon Watch, Venomspite, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.64:0.58:0.54:0.48:0.45:0.49"] = 159, -- Ebon Watch, Wyrmrest Temple, Agmar's Hammer
				["0.64:0.58:0.59:0.45"] = 99, -- Ebon Watch, Venomspite
				["0.64:0.58:0.54:0.48"] = 91, -- Ebon Watch, Wyrmrest Temple
				["0.64:0.58:0.59:0.45:0.85:0.27:0.84:0.41"] = 363, -- Ebon Watch, Venomspite, New Agamand, Camp Winterhoof
				["0.64:0.58:0.48:0.56"] = 108, -- Ebon Watch, Kor'koron Vanguard
				["0.64:0.58:0.69:0.58:0.84:0.49:0.95:0.37"] = 255, -- Ebon Watch, Light's Breach, Camp Oneqwah, Vengeance Landing
				["0.64:0.58:0.60:0.60"] = 27, -- Ebon Watch, Sunreaver's Command
				["0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 381, -- Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.64:0.58:0.69:0.58:0.70:0.45"] = 119, -- Ebon Watch, Light's Breach, Conquest Hold
				["0.64:0.58:0.48:0.56:0.45:0.49"] = 160, -- Ebon Watch, Kor'koron Vanguard, Agmar's Hammer
				["0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 301, -- Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.64:0.58:0.54:0.48:0.49:0.42"] = 143, -- Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 341, -- Schwarze Wacht, Wyrmruhtempel, Agmars Hammer, Taunka'le, Bor'goroks Außenposten
				["0.64:0.58:0.69:0.58:0.84:0.49"] = 150, -- Черная застава, Разлом Света, Лагерь Уанква
				["0.64:0.58:0.59:0.45:0.74:0.38"] = 196, -- Ebon Watch, Venomspite, Apothecary Camp
				["0.64:0.58:0.69:0.58:0.84:0.49:0.84:0.41"] = 198, -- Ebon Watch, Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.64:0.58:0.62:0.64:0.72:0.71"] = 141, -- Ebon Watch, K3, Dun Nifflelem
				["0.64:0.58:0.59:0.45:0.70:0.45"] = 158, -- Schwarze Wacht, Gallgrimm, Burg Siegeswall
				["0.64:0.58:0.59:0.45:0.45:0.49"] = 232, -- Ebon Watch, Venomspite, Agmar's Hammer
				["0.64:0.58:0.54:0.48:0.49:0.42:0.29:0.43"] = 275, -- Ebon Watch, Wyrmrest Temple, Moa'ki, Unu'pe
				["0.64:0.58:0.62:0.64:0.73:0.75"] = 131, -- Ebon Watch, K3, Camp Tunka'lo
				["0.64:0.58:0.52:0.62:0.24:0.60"] = 266, -- Ebon Watch, Dalaran, River's Heart
				["0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 354, -- Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46"] = 270, -- Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.64:0.58:0.62:0.64:0.60:0.75:0.64:0.81"] = 167, -- Черная застава, К-3, Место крушения Гром'арша, Ульдуар
				["0.64:0.58:0.59:0.45:0.85:0.27"] = 285, -- Ebon Watch, Venomspite, New Agamand
				["0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 158, -- Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.85:0.27"] = 267, -- Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, New Agamand
				["0.64:0.58:0.69:0.58:0.70:0.45:0.84:0.41"] = 203, -- Ebon Watch, Light's Breach, Conquest Hold, Camp Winterhoof
				["0.64:0.58:0.52:0.62:0.31:0.57"] = 215, -- Ebon Watch, Dalaran, Warsong Camp
				["0.64:0.58:0.52:0.62:0.52:0.66"] = 94, -- Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.64:0.58:0.62:0.64:0.60:0.75"] = 116, -- Ebon Watch, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 344, -- Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.64:0.58:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 229, -- Ebon Watch, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.64:0.58:0.59:0.45:0.85:0.27:0.74:0.29"] = 360, -- Ebon Watch, Venomspite, New Agamand, Kamagua
				["0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 216, -- Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.64:0.58:0.52:0.62:0.49:0.79"] = 181, -- Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 261, -- Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.64:0.58:0.52:0.62:0.56:0.64:0.60:0.75"] = 190, -- Ebon Watch, Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.64:0.58:0.62:0.64:0.60:0.75:0.57:0.79"] = 153, -- Ebon Watch, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge

				-- Horde: Zul'Drak: Gundrak
				["0.82:0.69:0.78:0.62:0.78:0.61"] = 56, -- Gundrak, Zim'Torga
				["0.82:0.69:0.78:0.62:0.72:0.60"] = 109, -- Gundrak, Zim'Torga, The Argent Stand
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62"] = 227, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran
				["0.82:0.69:0.78:0.62:0.84:0.49"] = 138, -- Gundrak, Zim'Torga, Camp Oneqwah
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.60:0.60"] = 187, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Sunreaver's Command
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58"] = 132, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46"] = 430, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.49:0.42:0.29:0.43"] = 434, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Moa'ki, Unu'pe
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.31:0.57"] = 374, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Warsong Camp
				["0.82:0.69:0.78:0.62:0.84:0.49:0.95:0.37"] = 244, -- Gundrak, Zim'Torga, Camp Oneqwah, Vengeance Landing
				["0.82:0.69:0.78:0.62:0.64:0.81"] = 210, -- Gundrak, Zim'Torga, Ulduar
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.59:0.45:0.45:0.49:0.29:0.46"] = 495, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Venomspite, Agmar's Hammer, Taunka'le Village
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.70:0.45"] = 206, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Conquest Hold
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.59:0.45:0.48:0.56:0.52:0.62"] = 428, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Venomspite, Kor'koron Vanguard, Dalaran
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48"] = 251, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58"] = 160, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.49:0.42"] = 303, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48"] = 304, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.59:0.45:0.85:0.27:0.84:0.41"] = 522, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Venomspite, New Agamand, Camp Winterhoof
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.48:0.56"] = 268, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Kor'koron Vanguard
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 501, -- Gundrak, Zim'Torga, El Confín Argenta, Puesto de Vigilancia de Ébano, Templo del Reposo del Dragón, Martillo de Agmar, Poblado Taunka'le, Avanzada Bor'gorok
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60"] = 426, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, River's Heart
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 315, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.62:0.64"] = 201, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, K3
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 460, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64"] = 249, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard
				["0.82:0.69:0.78:0.62:0.73:0.75:0.60:0.75:0.57:0.79"] = 278, -- Gundrak, Zim'Torga, Camp Tunka'lo, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.59:0.45"] = 252, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Venomspite
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49"] = 319, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer
				["0.82:0.69:0.78:0.62:0.84:0.49:0.70:0.45"] = 234, -- Gundrak, Zim'Torga, Camp Oneqwah, Conquest Hold
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 540, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield
				["0.82:0.69:0.78:0.62:0.84:0.49:0.84:0.41"] = 186, -- Gundrak, Zim'Torga, Camp Oneqwah, Lager der Winterhufe
				["0.82:0.69:0.78:0.62:0.64:0.81:0.57:0.79:0.38:0.79"] = 371, -- Gundrak, Zim'Torga, Ulduar, Bouldercrag's Refuge, The Shadow Vault
				["0.82:0.69:0.78:0.62:0.73:0.75"] = 142, -- Gundrak, Zim'Torga, Camp Tunka'lo
				["0.82:0.69:0.78:0.62:0.84:0.49:0.84:0.41:0.74:0.38:0.74:0.29"] = 296, -- Gundrak, Zim'Torga, Camp Oneqwah, Camp Winterhoof, Apothecary Camp, Kamagua
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 504, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 555, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66"] = 253, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 513, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.52:0.62:0.62:0.64"] = 444, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Dalaran, K3
				["0.82:0.69:0.78:0.62:0.72:0.71"] = 140, -- Gundrak, Zim'Torga, Dun Niffelem
				["0.82:0.69:0.78:0.62:0.73:0.75:0.60:0.75"] = 241, -- Gundrak, Zim'Torga, Camp Tunka'lo, Absturzstelle Grom'ash
				["0.82:0.69:0.78:0.62:0.84:0.49:0.84:0.41:0.85:0.27"] = 265, -- Gundrak, Zim'Torga, Camp Oneqwah, Camp Winterhoof, New Agamand
				["0.82:0.69:0.78:0.62:0.64:0.81:0.60:0.75"] = 253, -- Gundrak, Zim'Torga, Ulduar, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.82:0.69:0.78:0.62:0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62"] = 467, -- Gundrak, Zim'Torga, Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 395, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.82:0.69:0.78:0.62:0.84:0.49:0.95:0.37:0.85:0.27"] = 329, -- Gundrak, Zim'Torga, Camp Oneqwah, Vengeance Landing, New Agamand
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49"] = 373, -- Gundrak, Zim'Torga, Argentumwache, Lichtbresche, Gallgrimm, Wyrmruhtempel, Agmars Hammer
				["0.82:0.69:0.78:0.62:0.72:0.71:0.62:0.64:0.52:0.62"] = 299, -- Gundrak, Zim'Torga, Dun Nifflelem, K3, Dalaran
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.48:0.56:0.45:0.49:0.29:0.46:0.17:0.47"] = 506, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 420, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.70:0.45:0.74:0.38"] = 262, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Conquest Hold, Apothecary Camp
				["0.82:0.69:0.78:0.62:0.64:0.81:0.57:0.79:0.49:0.79"] = 318, -- Gundrak, Zim'Torga, Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.52:0.62:0.24:0.60"] = 599, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Dalaran, River's Heart
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 376, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.82:0.69:0.78:0.62:0.64:0.81:0.57:0.79"] = 258, -- Gundrak, Zim'Torga, Ulduar, Bouldercrag's Refuge
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.49:0.79"] = 340, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.70:0.45:0.74:0.38:0.85:0.27"] = 354, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Conquest Hold, Apothecary Camp, New Agamand

				-- Horde: Zul'Drak: Light's Breach
				["0.69:0.58:0.64:0.58"] = 41, -- Light's Breach, Ebon Watch
				["0.69:0.58:0.70:0.45"] = 75, -- Light's Breach, Conquest Hold
				["0.69:0.58:0.72:0.60"] = 44, -- Light's Breach, The Argent Stand
				["0.69:0.58:0.64:0.58:0.52:0.62"] = 107, -- Light's Breach, Ebon Watch, Dalaran
				["0.69:0.58:0.64:0.58:0.54:0.48:0.49:0.42"] = 183, -- Light's Breach, Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.69:0.58:0.64:0.58:0.54:0.48:0.49:0.42:0.29:0.43"] = 314, -- Light's Breach, Ebon Watch, Wyrmrest Temple, Moa'ki, Unu'pe
				["0.69:0.58:0.64:0.58:0.54:0.48:0.49:0.42:0.74:0.29"] = 366, -- Light's Breach, Ebon Watch, Wyrmrest Temple, Moa'ki, Kamagua
				["0.69:0.58:0.59:0.45"] = 122, -- Light's Breach, Venomspite
				["0.69:0.58:0.59:0.45:0.85:0.27"] = 308, -- Light's Breach, Venomspite, New Agamand
				["0.69:0.58:0.59:0.45:0.49:0.42"] = 204, -- Light's Breach, Venomspite, Moa'ki
				["0.69:0.58:0.64:0.58:0.54:0.48"] = 130, -- Light's Breach, Ebon Watch, Wyrmrest Temple
				["0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49"] = 199, -- Light's Breach, Ebon Watch, Wyrmrest Temple, Agmar's Hammer
				["0.69:0.58:0.59:0.45:0.45:0.49"] = 255, -- Light's Breach, Venomspite, Agmar's Hammer
				["0.69:0.58:0.59:0.45:0.54:0.48"] = 173, -- Light's Breach, Venomspite, Wyrmrest Temple
				["0.69:0.58:0.59:0.45:0.54:0.48:0.52:0.62"] = 270, -- Light's Breach, Venomspite, Wyrmrest Temple, Dalaran
				["0.69:0.58:0.70:0.45:0.74:0.38:0.85:0.27"] = 224, -- Light's Breach, Conquest Hold, Apothecary Camp, New Agamand
				["0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 393, -- Разлом Света, Черная застава, Храм Драконьего Покоя, Молот Агмара, Деревня Таунка'ле, Крепость Песни Войны
				["0.69:0.58:0.84:0.49:0.95:0.37"] = 210, -- Light's Breach, Camp Oneqwah, Vengeance Landing
				["0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 138, -- Light's Breach, The Argent Stand, Zim'Torga, Gundrak
				["0.69:0.58:0.84:0.49"] = 106, -- Light's Breach, Camp Oneqwah
				["0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 437, -- Light's Breach, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.69:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 169, -- Light's Breach, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46"] = 309, -- Light's Breach, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49"] = 243, -- 圣光据点，祖达克, 怨毒镇，龙骨荒野, 龙眠神殿，龙骨荒野, 阿格玛之锤，龙骨荒野
				["0.69:0.58:0.84:0.49:0.84:0.41"] = 153, -- Light's Breach, Camp Oneqwah, Camp Winterhoof
				["0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 428, -- Light's Breach, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.69:0.58:0.72:0.60:0.78:0.62:0.78:0.61"] = 84, -- Light's Breach, The Argent Stand, Zim'Torga
				["0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 300, -- Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.69:0.58:0.70:0.45:0.74:0.38"] = 131, -- Light's Breach, Conquest Hold, Apothecary Camp
				["0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 384, -- Light's Breach, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.69:0.58:0.64:0.58:0.48:0.56:0.45:0.49:0.29:0.46"] = 311, -- Light's Breach, Ebon Watch, Kor'koron Vanguard, Agmar's Hammer, Taunka'le Village
				["0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29:0.49:0.42:0.45:0.49"] = 443, -- Light's Breach, Conquest Hold, Apothecary Camp, Kamagua, Moa'ki, Agmar's Hammer
				["0.69:0.58:0.70:0.45:0.84:0.41"] = 159, -- Light's Breach, Conquest Hold, Camp Winterhoof
				["0.69:0.58:0.84:0.49:0.84:0.41:0.74:0.38"] = 210, -- Light's Breach, Camp Oneqwah, Camp Winterhoof, Apothecary Camp
				["0.69:0.58:0.59:0.45:0.49:0.42:0.29:0.43:0.29:0.46:0.17:0.47"] = 431, -- Light's Breach, Venomspite, Moa'ki, Unu'pe, Taunka'le Village, Amber Ledge
				["0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 133, -- Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49:0.31:0.57:0.24:0.60"] = 433, -- Light's Breach, Venomspite, Wyrmrest Temple, Agmar's Hammer, Warsong Camp, River's Heart
				["0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 255, -- Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.69:0.58:0.59:0.45:0.49:0.42:0.29:0.43"] = 335, -- Light's Breach, Venomspite, Moa'ki, Unu'pe
				["0.69:0.58:0.64:0.58:0.62:0.64"] = 80, -- Light's Breach, Ebon Watch, K3
				["0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75:0.64:0.81"] = 207, -- Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Ulduar
				["0.69:0.58:0.70:0.45:0.74:0.38:0.74:0.29"] = 185, -- Light's Breach, Conquest Hold, Apothecary Camp, Kamagua
				["0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75:0.57:0.79"] = 192, -- Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.69:0.58:0.70:0.45:0.84:0.41:0.95:0.37"] = 232, -- Light's Breach, Conquest Hold, Camp Winterhoof, Vengeance Landing
				["0.69:0.58:0.64:0.58:0.48:0.56"] = 148, -- Light's Breach, Ebon Watch, Kor'koron Vanguard
				["0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 420, -- Lichtbresche, Schwarze Wacht, Wyrmruhtempel, Agmars Hammer, Taunka'le, Bernsteinflöz, Transitusschild
				["0.69:0.58:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 381, -- Разлом Света, Черная застава, Храм Драконьего Покоя, Молот Агмара, Деревня Таунка'ле, Застава Бор'горока
				["0.69:0.58:0.59:0.45:0.48:0.56:0.52:0.62"] = 298, -- Light's Breach, Venomspite, Kor'koron Vanguard, Dalaran
				["0.69:0.58:0.59:0.45:0.54:0.48:0.48:0.56"] = 239, -- Light's Breach, Venomspite, Wyrmrest Temple, Kor'koron Vanguard
				["0.69:0.58:0.59:0.45:0.54:0.48:0.52:0.62:0.62:0.64:0.73:0.75"] = 403, -- Light's Breach, Venomspite, Wyrmrest Temple, Dalaran, K3, Camp Tunka'lo
				["0.69:0.58:0.59:0.45:0.49:0.42:0.29:0.43:0.15:0.43"] = 422, -- Light's Breach, Venomspite, Moa'ki, Unu'pe, Warsong Hold
				["0.69:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 238, -- Brecha de la Luz, El Confín Argenta, Zim'Torga, Ulduar
				["0.69:0.58:0.64:0.58:0.62:0.64:0.60:0.75"] = 156, -- Light's Breach, Ebon Watch, K3, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64"] = 128, -- Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard
				["0.69:0.58:0.64:0.58:0.62:0.64:0.72:0.71"] = 180, -- Light's Breach, Ebon Watch, K3, Dun Nifflelem
				["0.69:0.58:0.64:0.58:0.60:0.60"] = 67, -- Light's Breach, Ebon Watch, Sunreaver's Command
				["0.69:0.58:0.59:0.45:0.54:0.48:0.52:0.62:0.52:0.66:0.38:0.79"] = 419, -- Light's Breach, Venomspite, Wyrmrest Temple, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.69:0.58:0.64:0.58:0.48:0.56:0.45:0.49"] = 200, -- Light's Breach, Ebon Watch, Kor'koron Vanguard, Agmar's Hammer
				["0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 425, -- Light's Breach, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60"] = 305, -- Light's Breach, Ebon Watch, Dalaran, River's Heart
				["0.69:0.58:0.64:0.58:0.52:0.62:0.31:0.57"] = 255, -- Light's Breach, Ebon Watch, Dalaran, Warsong Camp
				["0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 220, -- Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.60:0.75:0.57:0.79"] = 267, -- Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, Grom'arsh Crash-Site, Bouldercrag's Refuge
				["0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46"] = 353, -- Light's Breach, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 340, -- Light's Breach, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.69:0.58:0.59:0.45:0.74:0.38:0.84:0.41:0.95:0.37"] = 352, -- Lichtbresche, Gallgrimm, Apothekerlager, Lager der Winterhufe, Hafen der Vergeltung
				["0.69:0.58:0.59:0.45:0.45:0.49:0.29:0.46:0.17:0.47:0.12:0.47"] = 475, -- Light's Breach, Venomspite, Agmar's Hammer, Taunka'le Village, Amber Ledge, Transitus Shield

				-- Horde: Zul'Drak: Zim'Torga
				["0.78:0.61:0.72:0.60"] = 54, -- Zim'Torga, The Argent Stand
				["0.78:0.61:0.72:0.60:0.69:0.58"] = 77, -- Zim'Torga, The Argent Stand, Light's Breach
				["0.78:0.61:0.72:0.60:0.64:0.58"] = 105, -- Zim'Torga, The Argent Stand, Ebon Watch
				["0.78:0.61:0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 459, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.78:0.61:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.53"] = 424, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, River's Heart, Bor'gorok Outpost
				["0.78:0.61:0.72:0.60:0.64:0.58:0.48:0.56"] = 213, -- Zim'Torga, The Argent Stand, Ebon Watch, Kor'koron Vanguard
				["0.78:0.61:0.84:0.49"] = 83, -- Zim'Torga, Camp Oneqwah
				["0.78:0.61:0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46"] = 374, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village
				["0.78:0.61:0.84:0.49:0.69:0.58:0.64:0.58:0.52:0.62"] = 281, -- Zim'Torga, Camp Oneqwah, Light's Breach, Ebon Watch, Dalaran
				["0.78:0.61:0.84:0.49:0.84:0.41:0.85:0.27"] = 211, -- Zim'Torga, Camp Oneqwah, Camp Winterhoof, New Agamand
				["0.78:0.61:0.84:0.49:0.95:0.37"] = 188, -- Zim'Torga, Camp Oneqwah, Vengeance Landing
				["0.78:0.61:0.72:0.60:0.64:0.58:0.52:0.62"] = 172, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran
				["0.78:0.61:0.84:0.49:0.70:0.45"] = 179, -- Zim'Torga, Camp Oneqwah, Conquest Hold
				["0.78:0.61:0.82:0.69"] = 54, -- Zim'Torga, Gundrak
				["0.78:0.61:0.72:0.60:0.69:0.58:0.70:0.45"] = 150, -- Zim'Torga, Argentumwache, Lichtbresche, Burg Siegeswall
				["0.78:0.61:0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49"] = 318, -- Zim'Torga, The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Agmar's Hammer
				["0.78:0.61:0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.15:0.43"] = 513, -- Zim'Torga, The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Warsong Hold
				["0.78:0.61:0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49"] = 263, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer
				["0.78:0.61:0.72:0.60:0.64:0.58:0.54:0.48"] = 196, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple
				["0.78:0.61:0.72:0.60:0.69:0.58:0.59:0.45"] = 197, -- Zim'Torga, El Confín Argenta, Brecha de la Luz, Rencor Venenoso
				["0.78:0.61:0.84:0.49:0.84:0.41:0.74:0.38:0.74:0.29"] = 241, -- Zim'Torga, Camp Oneqwah, Camp Winterhoof, Apothecary Camp, Kamagua
				["0.78:0.61:0.72:0.60:0.64:0.58:0.62:0.64"] = 146, -- Zim'Torga, The Argent Stand, Ebon Watch, K3
				["0.78:0.61:0.72:0.71"] = 86, -- Zim'Torga, Dun Nifflelem
				["0.78:0.61:0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 446, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.78:0.61:0.72:0.60:0.69:0.58:0.70:0.45:0.74:0.38:0.85:0.27:0.95:0.37"] = 377, -- Zim'Torga, The Argent Stand, Light's Breach, Conquest Hold, Apothecary Camp, New Agamand, Vengeance Landing
				["0.78:0.61:0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.52:0.62"] = 345, -- Zim'Torga, The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Dalaran
				["0.78:0.61:0.84:0.49:0.84:0.41"] = 131, -- Zim'Torga, Camp Oneqwah, Camp Winterhoof
				["0.78:0.61:0.84:0.49:0.69:0.58"] = 176, -- Zim'Torga, Camp Oneqwah, Light's Breach
				["0.78:0.61:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60"] = 370, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, River's Heart
				["0.78:0.61:0.72:0.60:0.69:0.58:0.70:0.45:0.74:0.38:0.85:0.27"] = 298, -- Zim'Torga, The Argent Stand, Light's Breach, Conquest Hold, Apothecary Camp, New Agamand
				["0.78:0.61:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 405, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.78:0.61:0.72:0.60:0.69:0.58:0.59:0.45:0.74:0.38:0.84:0.41"] = 354, -- Zim'Torga, The Argent Stand, Light's Breach, Venomspite, Apothecary Camp, Camp Winterhoof
				["0.78:0.61:0.64:0.81"] = 154, -- Zim'Torga, Ulduar
				["0.78:0.61:0.64:0.81:0.60:0.75:0.62:0.64"] = 285, -- Zim'Torga, Ulduar, Grom'arsh Crash-Site, K3
				["0.78:0.61:0.73:0.75:0.62:0.64:0.52:0.62"] = 272, -- Zim'Torga, Camp Tunka'lo, K3, Dalaran
				["0.78:0.61:0.72:0.60:0.64:0.58:0.54:0.48:0.49:0.42"] = 248, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.78:0.61:0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48:0.52:0.62"] = 412, -- Zim'Torga, Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple, Dalaran
				["0.78:0.61:0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64"] = 193, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard
				["0.78:0.61:0.84:0.49:0.84:0.41:0.85:0.27:0.74:0.29:0.49:0.42:0.29:0.43:0.29:0.46:0.18:0.53"] = 703, -- Zim'Torga, Camp Oneqwah, Camp Winterhoof, New Agamand, Kamagua, Moa'ki, Unu'pe, Taunka'le Village, Bor'gorok Outpost
				["0.78:0.61:0.72:0.60:0.64:0.58:0.52:0.62:0.31:0.57"] = 319, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Warsong Camp
				["0.78:0.61:0.72:0.60:0.69:0.58:0.59:0.45:0.85:0.27"] = 382, -- Zim'Torga, The Argent Stand, Light's Breach, Venomspite, New Agamand
				["0.78:0.61:0.64:0.81:0.57:0.79"] = 202, -- Zim'Torga, Ulduar, Bouldercrag's Refuge
				["0.78:0.61:0.72:0.71:0.62:0.64:0.52:0.62"] = 244, -- Zim'Torga, Dun Nifflelem, K3, Dalaran
				["0.78:0.61:0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 503, -- Zim'Torga, The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.78:0.61:0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48:0.45:0.49:0.29:0.46:0.18:0.53"] = 500, -- Zim'Torga, The Argent Stand, Light's Breach, Venomspite, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Bor'gorok Outpost
				["0.78:0.61:0.84:0.49:0.70:0.45:0.59:0.45:0.64:0.58:0.52:0.62:0.24:0.60"] = 612, -- Zim'Torga, Camp Oneqwah, Conquest Hold, Venomspite, Ebon Watch, Dalaran, River's Heart
				["0.78:0.61:0.72:0.60:0.64:0.58:0.54:0.48:0.45:0.49:0.29:0.46:0.17:0.47"] = 449, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Agmar's Hammer, Taunka'le Village, Amber Ledge
				["0.78:0.61:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66"] = 198, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.78:0.61:0.72:0.60:0.69:0.58:0.59:0.45:0.49:0.42:0.52:0.62"] = 400, -- Zim'Torga, The Argent Stand, Light's Breach, Venomspite, Moa'ki, Dalaran
				["0.78:0.61:0.73:0.75:0.60:0.75"] = 187, -- Zim'Torga, Camp Tunka'lo, Grom'arsh Crash-Site, Grom'arsh Crash-Site
				["0.78:0.61:0.64:0.81:0.60:0.75:0.62:0.64:0.52:0.62"] = 355, -- Zim'Torga, Ulduar, Grom'arsh Crash-Site, K3, Dalaran
				["0.78:0.61:0.73:0.75"] = 86, -- Zim'Torga, Camp Tunka'lo
				["0.78:0.61:0.64:0.81:0.57:0.79:0.49:0.79"] = 263, -- Zim'Torga, Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.78:0.61:0.64:0.81:0.60:0.75"] = 198, -- Zim'Torga, Ulduar, Point d'impact de Grom'arsh
				["0.78:0.61:0.72:0.60:0.69:0.58:0.59:0.45:0.54:0.48"] = 248, -- Zim'Torga, Argentumwache, Lichtbresche, Gallgrimm, Wyrmruhtempel
				["0.78:0.61:0.72:0.60:0.64:0.58:0.52:0.62:0.49:0.79"] = 285, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.78:0.61:0.72:0.60:0.64:0.58:0.60:0.60"] = 132, -- Zim'Torga, The Argent Stand, Ebon Watch, Sunreaver's Command
				["0.78:0.61:0.84:0.49:0.70:0.45:0.59:0.45:0.54:0.48"] = 316, -- Zim'Torga, Camp Oneqwah, Conquest Hold, Venomspite, Wyrmrest Temple

			},

		}

	end
