﻿
	----------------------------------------------------------------------
	-- Leatrix Plus Flight Alliance
	----------------------------------------------------------------------

	local void, Leatrix_Plus = ...
	local L = Leatrix_Plus.L

	-- Function to load flight data (load-on-demand)
	function Leatrix_Plus:LoadFlightDataAlliance()

		Leatrix_Plus["FlightData"]["Alliance"] = {

			----------------------------------------------------------------------
			--	Alliance
			----------------------------------------------------------------------

			-- Alliance: Eastern Kingdoms
			[2] = {

				-- Alliance: Acherus (Eastern Plaguelands)
				["0.62:0.66:0.61:0.65:0.58:0.94"] = 385, -- Acherus: The Ebon Hold, Light's Hope Chapel, Shattered Sun Staging Area
				["0.62:0.66:0.61:0.65"] = 50, -- Acherus: The Ebon Hold, Light's Hope Chapel
				["0.62:0.66:0.61:0.65:0.51:0.64"] = 149, -- Acherus: The Ebon Hold, Light's Hope Chapel, Thondoril River
				["0.62:0.66:0.61:0.65:0.61:0.73"] = 151, -- Acherus: The Ebon Hold, Light's Hope Chapel, Zul'Aman
				["0.62:0.66:0.61:0.65:0.48:0.61"] = 198, -- Acherus: The Ebon Hold, Light's Hope Chapel, Chillwind Camp
				["0.62:0.66:0.61:0.65:0.50:0.58"] = 210, -- Acherus: The Ebon Hold, Light's Hope Chapel, Aerie Peak
				["0.62:0.66:0.61:0.65:0.50:0.58:0.44:0.55"] = 272, -- Acherus: The Ebon Hold, Light's Hope Chapel, Aerie Peak, Southshore
				["0.62:0.66:0.61:0.65:0.50:0.58:0.51:0.53"] = 280, -- Acherus: The Ebon Hold, Light's Hope Chapel, Aerie Peak, Refuge Pointe
				["0.62:0.66:0.61:0.65:0.50:0.58:0.44:0.55:0.45:0.44"] = 380, -- Acherus: The Ebon Hold, Light's Hope Chapel, Aerie Peak, Southshore, Menethil Harbor
				["0.62:0.66:0.61:0.65:0.47:0.41"] = 416, -- Acherus: The Ebon Hold, Light's Hope Chapel, Ironforge
				["0.62:0.66:0.61:0.65:0.50:0.58:0.51:0.53:0.53:0.39"] = 450, -- Acherus: The Ebon Hold, Light's Hope Chapel, Aerie Peak, Refuge Pointe, Thelsamar
				["0.62:0.66:0.61:0.65:0.47:0.41:0.47:0.35"] = 464, -- Acherus: The Ebon Hold, Light's Hope Chapel, Ironforge, Thorium Point
				["0.62:0.66:0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28"] = 548, -- Acherus: The Ebon Hold, Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil
				["0.62:0.66:0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27"] = 576, -- Acherus: The Ebon Hold, Light's Hope Chapel, Ironforge, Thorium Point, Stormwind
				["0.62:0.66:0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25"] = 580, -- Acherus: The Ebon Hold, Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire
				["0.62:0.66:0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25:0.47:0.21"] = 638, -- Acherus: The Ebon Hold, Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire, Darkshire
				["0.62:0.66:0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28:0.55:0.19"] = 717, -- Acherus: The Ebon Hold, Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil, Nethergarde Keep
				["0.62:0.66:0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.39:0.20"] = 638, -- Acherus: The Ebon Hold, Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Sentinel Hill
				["0.62:0.66:0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.43:0.18"] = 654, -- Acherus: The Ebon Hold, Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Rebel Camp
				["0.62:0.66:0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.41:0.07"] = 760, -- Acherus: The Ebon Hold, Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Booty Bay

				-- Alliance: Aerie Peak (The Hinterlands)
				["0.50:0.58:0.51:0.53:0.53:0.39:0.47:0.35:0.41:0.27:0.41:0.07"] = 633, -- Aerie Peak, Refuge Pointe, Thelsamar, Thorium Point, Stormwind, Booty Bay
				["0.50:0.58:0.51:0.53:0.53:0.39:0.47:0.35:0.41:0.27:0.43:0.18"] = 527, -- Aerie Peak, Refuge Pointe, Thelsamar, Thorium Point, Stormwind, Rebel Camp
				["0.50:0.58:0.51:0.53:0.53:0.39:0.47:0.35:0.41:0.27:0.39:0.20"] = 512, -- Aerie Peak, Refuge Pointe, Thelsamar, Thorium Point, Stormwind, Sentinel Hill
				["0.50:0.58:0.51:0.53:0.53:0.39:0.47:0.35:0.41:0.27"] = 448, -- Aerie Peak, Refuge Pointe, Thelsamar, Thorium Point, Stormwind
				["0.50:0.58:0.51:0.53:0.53:0.39:0.47:0.35:0.52:0.28:0.50:0.25:0.47:0.21"] = 504, -- Aerie Peak, Refuge Pointe, Thelsamar, Thorium Point, Morgan's Vigil, Lakeshire, Darkshire
				["0.50:0.58:0.51:0.53:0.53:0.39:0.47:0.35:0.52:0.28:0.55:0.19"] = 583, -- Aerie Peak, Refuge Pointe, Thelsamar, Thorium Point, Morgan's Vigil, Nethergarde Keep
				["0.50:0.58:0.51:0.53:0.53:0.39:0.47:0.35:0.52:0.28:0.50:0.25"] = 446, -- Aerie Peak, Refuge Pointe, Thelsamar, Thorium Point, Morgan's Vigil, Lakeshire
				["0.50:0.58:0.51:0.53:0.53:0.39:0.47:0.35:0.52:0.28"] = 414, -- Aerie Peak, Refuge Pointe, Thelsamar, Thorium Point, Morgan's Vigil
				["0.50:0.58:0.51:0.53:0.53:0.39:0.47:0.35"] = 324, -- Aerie Peak, Refuge Pointe, Thelsamar, Thorium Point
				["0.50:0.58:0.51:0.53:0.53:0.39"] = 246, -- Aerie Peak, Refuge Pointe, Thelsamar
				["0.50:0.58:0.47:0.41"] = 256, -- Aerie Peak, Ironforge
				["0.50:0.58:0.44:0.55:0.45:0.44"] = 176, -- Aerie Peak, Southshore, Menethil Harbor
				["0.50:0.58:0.51:0.53"] = 75, -- Aerie Peak, Refuge Pointe
				["0.50:0.58:0.44:0.55"] = 68, -- Aerie Peak, Southshore
				["0.50:0.58:0.48:0.61"] = 53, -- Aerie Peak, Chillwind Camp
				["0.50:0.58:0.61:0.65"] = 164, -- Aerie Peak, Light's Hope Chapel
				["0.50:0.58:0.51:0.53:0.53:0.39:0.47:0.35:0.41:0.27:0.50:0.25"] = 547, -- Aerie Peak, Refuge Pointe, Thelsamar, Thorium Point, Stormwind, Lakeshire
				["0.50:0.58:0.47:0.41:0.41:0.27:0.55:0.19"] = 592, -- Aerie Peak, Ironforge, Stormwind, Nethergarde Keep
				["0.50:0.58:0.47:0.41:0.41:0.27:0.41:0.07"] = 614, -- Aerie Peak, Ironforge, Stormwind, Booty Bay
				["0.50:0.58:0.47:0.41:0.41:0.27:0.47:0.21"] = 531, -- Aerie Peak, Ironforge, Stormwind, Darkshire
				["0.50:0.58:0.47:0.41:0.41:0.27"] = 429, -- Aerie Peak, Ironforge, Stormwind (James Bird reported 257)
				["0.50:0.58:0.47:0.41:0.41:0.27:0.50:0.25"] = 527, -- Aerie Peak, Ironforge, Stormwind, Lakeshire
				["0.50:0.58:0.51:0.53:0.53:0.39:0.47:0.35:0.41:0.27:0.47:0.21"] = 550, -- Aerie Peak, Refuge Pointe, Thelsamar, Thorium Point, Stormwind, Darkshire
				["0.50:0.58:0.61:0.65:0.61:0.73"] = 262, -- Aerie Peak, Light's Hope Chapel, Zul'Aman
				["0.50:0.58:0.61:0.65:0.58:0.94"] = 501, -- Aerie Peak, Light's Hope Chapel, Shattered Sun Staging Area
				["0.50:0.58:0.44:0.55:0.45:0.44:0.53:0.39"] = 339, -- Aerie Peak, Southshore, Menethil Harbor, Thelsamar
				["0.50:0.58:0.51:0.53:0.53:0.39:0.47:0.35:0.41:0.27:0.55:0.19"] = 611, -- Aerie Peak, Refuge Pointe, Thelsamar, Thorium Point, Stormwind, Nethergarde Keep
				["0.50:0.58:0.47:0.41:0.47:0.35"] = 302, -- Aerie Peak, Ironforge, Thorium Point
				["0.50:0.58:0.47:0.41:0.41:0.27:0.43:0.18"] = 508, -- Aerie Peak, Ironforge, Stormwind, Rebel Camp
				["0.50:0.58:0.48:0.61:0.51:0.64"] = 107, -- Aerie Peak, Chillwind Camp, Thondroril River
				["0.50:0.58:0.61:0.65:0.62:0.66"] = 233, -- Aerie Peak, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.50:0.58:0.47:0.41:0.47:0.35:0.41:0.27"] = 413, -- Aerie Peak, Ironforge, Thorium Point, Stormwind
				["0.50:0.58:0.47:0.41:0.47:0.35:0.41:0.27:0.41:0.07"] = 598, -- Aerie Peak, Ironforge, Thorium Point, Stormwind, Booty Bay
				["0.50:0.58:0.47:0.41:0.41:0.27:0.52:0.28"] = 568, -- Aerie Peak, Ironforge, Stormwind, Morgan's Vigil
				["0.50:0.58:0.47:0.41:0.53:0.39"] = 323, -- Aerie Peak, Ironforge, Thelsamar
				["0.50:0.58:0.51:0.53:0.45:0.44"] = 202, -- Aerie Peak, Refuge Pointe, Menethil Harbor
				["0.50:0.58:0.47:0.41:0.45:0.44"] = 336, -- Aerie Peak, Ironforge, Menethil Harbor
				["0.50:0.58:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25:0.47:0.21"] = 477, -- Aerie Peak, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire, Darkshire
				["0.50:0.58:0.47:0.41:0.41:0.27:0.39:0.20"] = 492, -- Aerie Peak, Ironforge, Stormwind, Sentinel Hill


				-- Alliance: Booty Bay (Stranglethorn Vale)
				["0.41:0.07:0.39:0.20"] = 148, -- Booty Bay, Sentinel Hill
				["0.41:0.07:0.43:0.18"] = 118, -- Booty Bay, Rebel Camp
				["0.41:0.07:0.47:0.21"] = 167, -- Booty Bay, Darkshire
				["0.41:0.07:0.43:0.18:0.47:0.21:0.55:0.19"] = 252, -- Booty Bay, Rebel Camp, Darkshire, Nethergarde Keep
				["0.41:0.07:0.43:0.18:0.47:0.21:0.50:0.25"] = 215, -- Booty Bay, Rebel Camp, Darkshire, Lakeshire
				["0.41:0.07:0.43:0.18:0.47:0.21:0.50:0.25:0.52:0.28"] = 276, -- Booty Bay, Rebel Camp, Darkshire, Lakeshire, Morgan's Vigil
				["0.41:0.07:0.41:0.27"] = 200, -- Booty Bay, Stormwind
				["0.41:0.07:0.41:0.27:0.47:0.35"] = 318, -- Booty Bay, Stormwind, Thorium Point
				["0.41:0.07:0.41:0.27:0.47:0.35:0.53:0.39"] = 397, -- Booty Bay, Stormwind, Thorium Point, Thelsamar
				["0.41:0.07:0.41:0.27:0.47:0.41"] = 401, -- Booty Bay, Stormwind, Ironforge (howieyard27@aol.com reported 200, not changed yet)
				["0.41:0.07:0.41:0.27:0.47:0.41:0.45:0.44"] = 472, -- Booty Bay, Stormwind, Ironforge, Menethil Harbor
				["0.41:0.07:0.41:0.27:0.47:0.35:0.53:0.39:0.51:0.53"] = 560, -- Booty Bay, Stormwind, Thorium Point, Thelsamar, Refuge Pointe
				["0.41:0.07:0.41:0.27:0.47:0.41:0.44:0.55"] = 573, -- Booty Bay, Stormwind, Ironforge, Southshore
				["0.41:0.07:0.41:0.27:0.47:0.35:0.53:0.39:0.51:0.53:0.50:0.58"] = 632, -- Booty Bay, Stormwind, Thorium Point, Thelsamar, Refuge Pointe, Aerie Peak
				["0.41:0.07:0.41:0.27:0.47:0.41:0.48:0.61"] = 614, -- Booty Bay, Stormwind, Ironforge, Chillwind Camp
				["0.41:0.07:0.41:0.27:0.47:0.41:0.61:0.65"] = 708, -- Booty Bay, Stormwind, Ironforge, Light's Hope Chapel
				["0.41:0.07:0.41:0.27:0.47:0.41:0.61:0.65:0.61:0.73"] = 806, -- Booty Bay, Stormwind, Ironforge, Light's Hope Chapel, Zul'Aman
				["0.41:0.07:0.41:0.27:0.47:0.41:0.51:0.53"] = 562, -- Booty Bay, Stormwind, Ironforge, Refuge Pointe
				["0.41:0.07:0.41:0.27:0.47:0.41:0.53:0.39"] = 460, -- Booty Bay, Stormwind, Ironforge, Thelsamar
				["0.41:0.07:0.41:0.27:0.47:0.41:0.51:0.53:0.50:0.58"] = 633, -- Booty Bay, Stormwind, Ironforge, Refuge Pointe, Aerie Peak
				["0.41:0.07:0.47:0.21:0.55:0.19"] = 258, -- Booty Bay, Darkshire, Nethergarde Keep
				["0.41:0.07:0.47:0.21:0.50:0.25"] = 222, -- Booty Bay, Darkshire, Lakeshire
				["0.41:0.07:0.41:0.27:0.47:0.41:0.58:0.94"] = 465, -- Booty Bay, Stormwind, Ironforge, Shattered Sun Staging Area
				["0.41:0.07:0.41:0.27:0.55:0.19"] = 363, -- Booty Bay, Stormwind, Nethergarde Keep
				["0.41:0.07:0.41:0.27:0.47:0.41:0.48:0.61:0.51:0.64"] = 667, -- Booty Bay, Stormwind, Ironforge, Chillwind Camp, Thondroril River
				["0.41:0.07:0.41:0.27:0.47:0.41:0.61:0.65:0.62:0.66"] = 774, -- Booty Bay, Stormwind, Ironforge, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.41:0.07:0.39:0.20:0.50:0.25"] = 277, -- Booty Bay, Sentinel Hill, Lakeshire
				["0.41:0.07:0.41:0.27:0.47:0.41:0.61:0.65:0.51:0.64"] = 805, -- Booty Bay, Stormwind, Ironforge, Light's Hope Chapel, Thondoril River
				["0.41:0.07:0.47:0.21:0.50:0.25:0.52:0.28"] = 283, -- Booty Bay, Darkshire, Lakeshire, Morgan's Vigil

				-- Alliance: Chillwind Camp (Western Plaguelands)
				["0.48:0.61:0.47:0.41:0.47:0.35:0.41:0.27:0.41:0.07"] = 603, -- Chillwind Camp, Ironforge, Thorium Point, Stormwind, Booty Bay (was 662, changed by Roman Seidelsohn)
				["0.48:0.61:0.47:0.41:0.47:0.35:0.41:0.27:0.39:0.20"] = 481, -- Chillwind Camp, Ironforge, Thorium Point, Stormwind, Sentinel Hill
				["0.48:0.61:0.47:0.41:0.47:0.35:0.41:0.27:0.43:0.18"] = 497, -- Chillwind Camp, Ironforge, Thorium Point, Stormwind, Rebel Camp
				["0.48:0.61:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25:0.47:0.21"] = 482, -- Chillwind Camp, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire, Darkshire
				["0.48:0.61:0.47:0.41:0.47:0.35:0.52:0.28:0.55:0.19"] = 560, -- Chillwind Camp, Ironforge, Thorium Point, Morgan's Vigil, Nethergarde Keep
				["0.48:0.61:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25"] = 423, -- Chillwind Camp, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire
				["0.48:0.61:0.47:0.41:0.47:0.35:0.52:0.28"] = 395, -- Chillwind Camp, Ironforge, Thorium Point, Morgan's Vigil
				["0.48:0.61:0.47:0.41:0.47:0.35:0.41:0.27"] = 418, -- Chillwind Camp, Ironforge, Thorium Point, Stormwind
				["0.48:0.61:0.47:0.41:0.47:0.35"] = 309, -- Chillwind Camp, Ironforge, Thorium Point
				["0.48:0.61:0.50:0.58:0.51:0.53:0.53:0.39"] = 308, -- Chillwind Camp, Aerie Peak, Refuge Pointe, Thelsamar
				["0.48:0.61:0.47:0.41"] = 259, -- Chillwind Camp, Ironforge
				["0.48:0.61:0.44:0.55:0.45:0.44"] = 193, -- Chillwind Camp, Southshore, Menethil Harbor
				["0.48:0.61:0.50:0.58:0.51:0.53"] = 138, -- Chillwind Camp, Aerie Peak, Refuge Pointe
				["0.48:0.61:0.44:0.55"] = 86, -- Chillwind Camp, Southshore
				["0.48:0.61:0.50:0.58"] = 66, -- Chillwind Camp, Aerie Peak
				["0.48:0.61:0.61:0.65"] = 146, -- Chillwind Camp, Light's Hope Chapel (Viter reported 88)
				["0.48:0.61:0.47:0.41:0.41:0.27:0.41:0.07"] = 617, -- Chillwind Camp, Ironforge, Stormwind, Baie-du-Butin, Booty Bay
				["0.48:0.61:0.47:0.41:0.47:0.35:0.41:0.27:0.50:0.25"] = 516, -- Chillwind Camp, Ironforge, Thorium Point, Stormwind, Lakeshire
				["0.48:0.61:0.47:0.41:0.41:0.27:0.50:0.25"] = 531, -- Chillwind Camp, Ironforge, Stormwind, Lakeshire
				["0.48:0.61:0.47:0.41:0.41:0.27"] = 433, -- Chillwind Camp, Ironforge, Stormwind
				["0.48:0.61:0.47:0.41:0.47:0.35:0.41:0.27:0.55:0.19"] = 581, -- Chillwind Camp, Ironforge, Thorium Point, Stormwind, Nethergarde Keep
				["0.48:0.61:0.61:0.65:0.61:0.73"] = 244, -- Chillwind Camp, Light's Hope Chapel, Zul'Aman
				["0.48:0.61:0.61:0.65:0.58:0.94"] = 482, -- Chillwind Camp, Light's Hope Chapel, Shattered Sun Staging Area
				["0.48:0.61:0.47:0.41:0.41:0.27:0.55:0.19"] = 595, -- Chillwind Camp, Ironforge, Stormwind, Nethergarde Keep
				["0.48:0.61:0.44:0.55:0.51:0.53:0.53:0.39"] = 327, -- Chillwind Camp, Southshore, Refuge Pointe, Thelsamar
				["0.48:0.61:0.44:0.55:0.51:0.53"] = 157, -- Chillwind Camp, Southshore, Refuge Pointe
				["0.48:0.61:0.47:0.41:0.41:0.27:0.43:0.18"] = 512, -- Chillwind Camp, Ironforge, Stormwind, Rebel Camp
				["0.48:0.61:0.47:0.41:0.41:0.27:0.47:0.21"] = 534, -- Chillwind Camp, Ironforge, Stormwind, Darkshire
				["0.48:0.61:0.47:0.41:0.41:0.27:0.52:0.28"] = 572, -- Chillwind Camp, Ironforge, Stormwind, Morgan's Vigil
				["0.48:0.61:0.51:0.64"] = 54, -- Chillwind Camp, Thondroril River
				["0.48:0.61:0.61:0.65:0.62:0.66"] = 214, -- Chillwind Camp, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.48:0.61:0.47:0.41:0.51:0.53"] = 428, -- Chillwind Camp, Ironforge, Refuge Pointe
				["0.48:0.61:0.50:0.58:0.51:0.53:0.45:0.44"] = 264, -- Chillwind Camp, Aerie Peak, Refuge Pointe, Menethil Harbor
				["0.48:0.61:0.47:0.41:0.45:0.44"] = 337, -- Chillwind Camp, Ironforge, Menethil Harbor
				["0.48:0.61:0.47:0.41:0.41:0.27:0.39:0.20"] = 496, -- Chillwind Camp, Ironforge, Stormwind, Sentinel Hill
				["0.48:0.61:0.47:0.41:0.47:0.35:0.41:0.27:0.47:0.21"] = 520, -- Chillwind Camp, Ironforge, Thorium Point, Stormwind, Darkshire

				-- Alliance: Darkshire (Duskwood)
				["0.47:0.21:0.41:0.07"] = 171, -- Darkshire, Booty Bay
				["0.47:0.21:0.43:0.18"] = 48, -- Darkshire, Rebel Camp
				["0.47:0.21:0.39:0.20"] = 93, -- Darkshire, Sentinel Hill
				["0.47:0.21:0.41:0.27"] = 88, -- Darkshire, Stormwind
				["0.47:0.21:0.50:0.25"] = 60, -- Darkshire, Lakeshire
				["0.47:0.21:0.55:0.19"] = 97, -- Darkshire, Nethergarde Keep
				["0.47:0.21:0.50:0.25:0.52:0.28"] = 120, -- Darkshire, Lakeshire, Morgan's Vigil
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.53:0.39"] = 270, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point, Thelsamar
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35"] = 188, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41"] = 268, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point, Ironforge
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.45:0.44"] = 337, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Menethil Harbor (was 417, changed to 337 by Roman Seidelsohn)
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.53:0.39:0.51:0.53"] = 432, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point, Thelsamar, Refuge Pointe
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.44:0.55"] = 439, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Southshore
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.53:0.39:0.51:0.53:0.50:0.58"] = 504, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point, Thelsamar, Refuge Pointe, Aerie Peak (was 582, changed by Mediana via email)
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.61:0.65"] = 575, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Light's Hope Chapel
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.50:0.58:0.44:0.55"] = 548, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Aerie Peak, Southshore
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.61:0.65:0.61:0.73"] = 674, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Light's Hope Chapel, Zul'Aman
				["0.47:0.21:0.41:0.27:0.47:0.41:0.45:0.44"] = 361, -- Darkshire, Stormwind, Ironforge, Menethil Harbor
				["0.47:0.21:0.41:0.27:0.47:0.41"] = 291, -- Darkshire, Stormwind, Ironforge
				["0.47:0.21:0.41:0.27:0.47:0.41:0.51:0.53:0.50:0.58"] = 522, -- Darkshire, Stormwind, Ironforge, Refuge Pointe, Aerie Peak
				["0.47:0.21:0.41:0.27:0.47:0.41:0.44:0.55"] = 462, -- Darkshire, Stormwind, Ironforge, Southshore
				["0.47:0.21:0.41:0.27:0.47:0.35:0.53:0.39:0.51:0.53:0.50:0.58"] = 521, -- Darkshire, Stormwind, Thorium Point, Thelsamar, Refuge Pointe, Aerie Peak
				["0.47:0.21:0.41:0.27:0.47:0.41:0.48:0.61"] = 503, -- Darkshire, Stormwind, Ironforge, Chillwind Camp
				["0.47:0.21:0.41:0.27:0.47:0.41:0.51:0.53"] = 451, -- Darkshire, Stormwind, Ironforge, Refuge Pointe
				["0.47:0.21:0.41:0.27:0.47:0.41:0.53:0.39"] = 348, -- Darkshire, Stormwind, Ironforge, Thelsamar
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.48:0.61"] = 480, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Chillwind Camp (changed to 480 by Kory Krebs and jody stapleton, was 534)
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.58:0.94"] = 333, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Shattered Sun Staging Area
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.48:0.61:0.51:0.64"] = 533, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Chillwind Camp, Thondroril River
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.61:0.65:0.62:0.66"] = 641, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.47:0.21:0.41:0.27:0.47:0.35"] = 208, -- Darkshire, Stormwind, Thorium Point
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.44:0.55:0.50:0.58"] = 509, -- Villa Oscura, Villa del Lago, Vigilia de Morgan, Puesto del Torio, Forjaz, Costasur, Pico Nidal
				["0.47:0.21:0.41:0.27:0.47:0.41:0.48:0.61:0.51:0.64"] = 556, -- Darkshire, Stormwind, Ironforge, Chillwind Camp, Thondoril River
				["0.47:0.21:0.41:0.27:0.47:0.35:0.53:0.39"] = 287, -- Darkshire, Stormwind, Thorium Point, Thelsamar
				["0.47:0.21:0.41:0.27:0.47:0.35:0.53:0.39:0.51:0.53"] = 449, -- Darkshire, Stormwind, Thorium Point, Thelsamar, Refuge Pointe
				["0.47:0.21:0.50:0.25:0.52:0.28:0.47:0.35:0.53:0.39:0.51:0.53:0.50:0.58:0.48:0.61"] = 554, -- Darkshire, Lakeshire, Morgan's Vigil, Thorium Point, Thelsamar, Refuge Pointe, Aerie Peak, Chillwind Camp

				-- Alliance: Ironforge (Dun Morogh)
				["0.47:0.41:0.47:0.35:0.41:0.27:0.41:0.07"] = 381, -- Ironforge, Thorium Point, Stormwind, Booty Bay
				["0.47:0.41:0.47:0.35:0.41:0.27:0.39:0.20"] = 260, -- Ironforge, Thorium Point, Stormwind, Sentinel Hill
				["0.47:0.41:0.47:0.35:0.41:0.27:0.43:0.18"] = 275, -- Ironforge, Thorium Point, Stormwind, Rebel Camp (8imras8 reported 224)
				["0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25:0.47:0.21"] = 260, -- Ironforge, Thorium Point, Morgan's Vigil, Lakeshire, Darkshire
				["0.47:0.41:0.47:0.35:0.52:0.28:0.55:0.19"] = 338, -- Ironforge, Thorium Point, Morgan's Vigil, Nethergarde Keep
				["0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25"] = 201, -- Ironforge, Thorium Point, Morgan's Vigil, Lakeshire
				["0.47:0.41:0.47:0.35:0.52:0.28"] = 173, -- Ironforge, Thorium Point, Morgan's Vigil
				["0.47:0.41:0.41:0.27"] = 210, -- Ironforge, Stormwind (Tatiana Beaklini reported 215) (William Aamodt reported 227, Nikolai Goldschmidt reported 81, Dale Gann reported 137)
				["0.47:0.41:0.47:0.35"] = 87, -- Ironforge, Thorium Point
				["0.47:0.41:0.53:0.39"] = 101, -- Ironforge, Thelsamar
				["0.47:0.41:0.45:0.44"] = 115, -- Ironforge, Menethil Harbor
				["0.47:0.41:0.51:0.53"] = 204, -- Ironforge, Refuge Pointe
				["0.47:0.41:0.44:0.55"] = 216, -- Ironforge, Southshore
				["0.47:0.41:0.50:0.58"] = 299, -- Ironforge, Aerie Peak
				["0.47:0.41:0.48:0.61"] = 258, -- Ironforge, Chillwind Camp (Sexy Steven reported 106)
				["0.47:0.41:0.61:0.65"] = 349, -- Ironforge, Light's Hope Chapel (Viter reported 40, Matthew Smith reported 271)
				["0.47:0.41:0.61:0.65:0.61:0.73"] = 445, -- Ironforge, Light's Hope Chapel, Zul'Aman
				["0.47:0.41:0.41:0.27:0.43:0.18"] = 290, -- Ironforge, Stormwind, Rebel Camp (Hayley Levesque reported 308)
				["0.47:0.41:0.41:0.27:0.39:0.20"] = 275, -- Ironforge, Stormwind, Sentinel Hill
				["0.47:0.41:0.41:0.27:0.50:0.25"] = 310, -- Ironforge, Stormwind, Lakeshire (was 309, changed to 211 by Dylan, changed back to 310 by Trev B and Steevan BARBOYON so 310 is correct)
				["0.47:0.41:0.41:0.27:0.55:0.19"] = 373, -- Ironforge, Stormwind, Nethergarde Keep
				["0.47:0.41:0.41:0.27:0.47:0.21"] = 313, -- Ironforge, Stormwind, Darkshire
				["0.47:0.41:0.47:0.35:0.41:0.27:0.50:0.25"] = 295, -- Ironforge, Thorium Point, Stormwind, Lakeshire
				["0.47:0.41:0.41:0.27:0.41:0.07"] = 396, -- Ironforge, Stormwind, Booty Bay
				["0.47:0.41:0.47:0.35:0.41:0.27:0.55:0.19"] = 359, -- Ironforge, Thorium Point, Stormwind, Nethergarde Keep
				["0.47:0.41:0.47:0.35:0.41:0.27:0.47:0.21"] = 298, -- Ironforge, Thorium Point, Stormwind, Darkshire
				["0.47:0.41:0.41:0.27:0.52:0.28"] = 350, -- Ironforge, Stormwind, Morgan's Vigil
				["0.47:0.41:0.58:0.94"] = 101, -- Ironforge, Shattered Sun Staging Area (was 100, changed to 111 by Maximilian Wittig, changed back to 99 by many others, changed to 100 by Oliver, changed to 101 by Daehoon Oh who reported 105)
				["0.47:0.41:0.58:0.94:0.61:0.73"] = 330, -- Ironforge, Shattered Sun Staging Area, Zul'Aman
				["0.47:0.41:0.48:0.61:0.51:0.64"] = 311, -- Ironforge, Chillwind Camp, Thondroril River
				["0.47:0.41:0.61:0.65:0.62:0.66"] = 415, -- Ironforge, Light's Hope Chapel, Acherus: The Ebon Hold

				-- Alliance: Lakeshire (Redridge Mountains)
				["0.50:0.25:0.47:0.21:0.43:0.18:0.41:0.07"] = 218, -- Lakeshire, Darkshire, Rebel Camp, Booty Bay
				["0.50:0.25:0.47:0.21:0.55:0.19"] = 148, -- Lakeshire, Darkshire, Nethergarde Keep
				["0.50:0.25:0.47:0.21"] = 60, -- Lakeshire, Darkshire
				["0.50:0.25:0.47:0.21:0.43:0.18"] = 104, -- Lakeshire, Darkshire, Rebel Camp
				["0.50:0.25:0.39:0.20"] = 133, -- Lakeshire, Sentinel Hill
				["0.50:0.25:0.41:0.27"] = 113, -- Lakeshire, Stormwind
				["0.50:0.25:0.52:0.28"] = 61, -- Lakeshire, Morgan's Vigil
				["0.50:0.25:0.52:0.28:0.47:0.35"] = 129, -- Lakeshire, Morgan's Vigil, Thorium Point
				["0.50:0.25:0.52:0.28:0.47:0.35:0.53:0.39"] = 210, -- Lakeshire, Morgan's Vigil, Thorium Point, Thelsamar
				["0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41"] = 209, -- Lakeshire, Morgan's Vigil, Thorium Point, Ironforge
				["0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.45:0.44"] = 278, -- Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Menethil Harbor
				["0.50:0.25:0.52:0.28:0.47:0.35:0.53:0.39:0.51:0.53"] = 374, -- Lakeshire, Morgan's Vigil, Thorium Point, Thelsamar, Refuge Pointe
				["0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.44:0.55"] = 379, -- Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Southshore (was 489, changed by Isaac Guinn and Georgi Georgiev)
				["0.50:0.25:0.52:0.28:0.47:0.35:0.53:0.39:0.51:0.53:0.50:0.58"] = 445, -- Lakeshire, Morgan's Vigil, Thorium Point, Thelsamar, Refuge Pointe, Aerie Peak
				["0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.48:0.61"] = 421, -- Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Chillwind Camp (was 475, changed to 421 by Christian Bösherz and Jonathon Hicks)
				["0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.61:0.65"] = 516, -- Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Light's Hope Chapel (changed to 516 by Embracefate and Henrik Löfström)
				["0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.50:0.58:0.44:0.55"] = 489, -- Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Aerie Peak, Southshore
				["0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.61:0.65:0.61:0.73"] = 614, -- Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Light's Hope Chapel, Zul'Aman
				["0.50:0.25:0.41:0.27:0.47:0.41"] = 315, -- Lakeshire, Stormwind, Ironforge
				["0.50:0.25:0.41:0.27:0.47:0.41:0.45:0.44"] = 385, -- Lakeshire, Stormwind, Ironforge, Menethil Harbor
				["0.50:0.25:0.41:0.27:0.47:0.41:0.53:0.39"] = 373, -- Lakeshire, Stormwind, Ironforge, Thelsamar
				["0.50:0.25:0.41:0.27:0.55:0.19"] = 276, -- Seenhain, Sturmwind, Burg Nethergarde
				["0.50:0.25:0.41:0.27:0.47:0.41:0.48:0.61"] = 528, -- Lakeshire, Stormwind, Ironforge, Chillwind Camp
				["0.50:0.25:0.41:0.27:0.47:0.41:0.44:0.55"] = 487, -- Lakeshire, Stormwind, Ironforge, Southshore
				["0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.58:0.94"] = 273, -- Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Shattered Sun Staging Area
				["0.50:0.25:0.47:0.21:0.41:0.07"] = 228, -- Lakeshire, Darkshire, Booty Bay
				["0.50:0.25:0.41:0.27:0.47:0.35"] = 232, -- Lakeshire, Stormwind, Thorium Point
				["0.50:0.25:0.41:0.27:0.47:0.41:0.51:0.53"] = 475, -- Lakeshire, Stormwind, Ironforge, Refuge Pointe
				["0.50:0.25:0.41:0.27:0.47:0.35:0.53:0.39:0.51:0.53"] = 474, -- Lakeshire, Stormwind, Thorium Point, Thelsamar, Refuge Pointe
				["0.50:0.25:0.39:0.20:0.43:0.18"] = 196, -- Lakeshire, Sentinel Hill, Rebel Camp
				["0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.48:0.61:0.51:0.64"] = 474, -- Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Chillwind Camp, Thondroril River
				["0.50:0.25:0.52:0.28:0.47:0.35:0.47:0.41:0.61:0.65:0.62:0.66"] = 582, -- Lakeshire, Morgan's Vigil, Thorium Point, Ironforge, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.50:0.25:0.41:0.27:0.47:0.35:0.53:0.39"] = 311, -- Lakeshire, Stormwind, Thorium Point, Thelsamar
				["0.50:0.25:0.41:0.27:0.47:0.41:0.51:0.53:0.50:0.58"] = 547, -- Lakeshire, Stormwind, Ironforge, Refuge Pointe, Aerie Peak
				["0.50:0.25:0.41:0.27:0.47:0.41:0.48:0.61:0.51:0.64"] = 581, -- Lakeshire, Stormwind, Ironforge, Chillwind Camp, Thondoril River
				["0.50:0.25:0.41:0.27:0.41:0.07"] = 297, -- Lakeshire, Stormwind, Booty Bay
				["0.50:0.25:0.41:0.27:0.47:0.35:0.53:0.39:0.51:0.53:0.50:0.58"] = 546, -- Seenhain, Sturmwind, Thoriumspitze, Thelsamar, Die Zuflucht, Nistgipfel

				-- Alliance: Light's Hope Chapel (Eastern Plaguelands)
				["0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.41:0.07"] = 712, -- Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Booty Bay
				["0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.39:0.20"] = 590, -- Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Sentinel Hill
				["0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.43:0.18"] = 606, -- Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Rebel Camp
				["0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25:0.47:0.21"] = 591, -- Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire, Darkshire
				["0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28:0.55:0.19"] = 669, -- Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil, Nethergarde Keep
				["0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25"] = 532, -- Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire
				["0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28"] = 503, -- Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil
				["0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27"] = 527, -- Light's Hope Chapel, Ironforge, Thorium Point, Stormwind
				["0.61:0.65:0.47:0.41:0.47:0.35"] = 417, -- Light's Hope Chapel, Ironforge, Thorium Point
				["0.61:0.65:0.50:0.58:0.51:0.53:0.53:0.39"] = 403, -- Light's Hope Chapel, Aerie Peak, Refuge Pointe, Thelsamar
				["0.61:0.65:0.47:0.41"] = 369, -- Light's Hope Chapel, Ironforge
				["0.61:0.65:0.50:0.58:0.44:0.55:0.45:0.44"] = 333, -- Light's Hope Chapel, Aerie Peak, Southshore, Menethil Harbor
				["0.61:0.65:0.50:0.58:0.51:0.53"] = 232, -- Light's Hope Chapel, Aerie Peak, Refuge Pointe
				["0.61:0.65:0.50:0.58:0.44:0.55"] = 225, -- Light's Hope Chapel, Aerie Peak, Southshore
				["0.61:0.65:0.50:0.58"] = 163, -- Light's Hope Chapel, Aerie Peak
				["0.61:0.65:0.48:0.61"] = 149, -- Light's Hope Chapel, Chillwind Camp
				["0.61:0.65:0.61:0.73"] = 104, -- Light's Hope Chapel, Zul'Aman
				["0.61:0.65:0.48:0.61:0.44:0.55"] = 226, -- Light's Hope Chapel, Chillwind Camp, Southshore
				["0.61:0.65:0.47:0.41:0.41:0.27"] = 541, -- Light's Hope Chapel, Ironforge, Stormwind
				["0.61:0.65:0.58:0.94"] = 339, -- Light's Hope Chapel, Shattered Sun Staging Area
				["0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.55:0.19"] = 690, -- Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Nethergarde
				["0.61:0.65:0.47:0.41:0.41:0.27:0.55:0.19"] = 704, -- Light's Hope Chapel, Ironforge, Stormwind, Nethergarde Keep
				["0.61:0.65:0.47:0.41:0.53:0.39"] = 434, -- Light's Hope Chapel, Ironforge, Thelsamar
				["0.61:0.65:0.48:0.61:0.44:0.55:0.45:0.44"] = 334, -- Light's Hope Chapel, Chillwind Camp, Southshore, Menethil Harbor
				["0.61:0.65:0.47:0.41:0.41:0.27:0.47:0.21"] = 643, -- Light's Hope Chapel, Ironforge, Stormwind, Darkshire
				["0.61:0.65:0.48:0.61:0.44:0.55:0.51:0.53"] = 298, -- Light's Hope Chapel, Chillwind Camp, Southshore, Refuge Pointe
				["0.61:0.65:0.51:0.64"] = 102, -- Light's Hope Chapel, Thondroril River
				["0.61:0.65:0.62:0.66"] = 71, -- Light's Hope Chapel, Acherus: The Ebon Hold
				["0.61:0.65:0.47:0.41:0.41:0.27:0.52:0.28"] = 680, -- Light's Hope Chapel, Ironforge, Stormwind, Morgan's Vigil
				["0.61:0.65:0.47:0.41:0.41:0.27:0.41:0.07"] = 726, -- Light's Hope Chapel, Ironforge, Stormwind, Booty Bay
				["0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.50:0.25"] = 625, -- Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Lakeshire
				["0.61:0.65:0.47:0.41:0.41:0.27:0.50:0.25"] = 639, -- Light's Hope Chapel, Ironforge, Stormwind, Lakeshire
				["0.61:0.65:0.50:0.58:0.51:0.53:0.45:0.44"] = 359, -- Light's Hope Chapel, Aerie Peak, Refuge Pointe, Menethil Harbor

				-- Alliance: Menethil Harbor (Wetlands)
				["0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27:0.41:0.07"] = 429, -- Menethil Harbor, Ironforge, Thorium Point, Stormwind, Booty Bay
				["0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27:0.43:0.18"] = 323, -- Menethil Harbor, Ironforge, Thorium Point, Stormwind, Rebel Camp
				["0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27:0.39:0.20"] = 307, -- Menethil Harbor, Ironforge, Thorium Point, Stormwind, Sentinel Hill (was 324, changed to 307 by advocate@wrath-wow.com)
				["0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27"] = 244, -- Menethil Harbor, Ironforge, Thorium Point, Stormwind
				["0.45:0.44:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25:0.47:0.21"] = 309, -- Menethil Harbor, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire, Darkshire
				["0.45:0.44:0.47:0.41:0.47:0.35:0.52:0.28:0.55:0.19"] = 386, -- Menethil Harbor, Ironforge, Thorium Point, Morgan's Vigil, Nethergarde Keep
				["0.45:0.44:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25"] = 250, -- Menethil Harbor, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire
				["0.45:0.44:0.47:0.41:0.47:0.35:0.52:0.28"] = 221, -- Menethil Harbor, Ironforge, Thorium Point, Morgan's Vigil
				["0.45:0.44:0.47:0.41:0.47:0.35"] = 135, -- Menethil Harbor, Ironforge, Thorium Point
				["0.45:0.44:0.53:0.39"] = 163, -- Menethil Harbor, Thelsamar
				["0.45:0.44:0.47:0.41"] = 89, -- Menethil Harbor, Ironforge
				["0.45:0.44:0.51:0.53"] = 114, -- Menethil Harbor, Refuge Pointe
				["0.45:0.44:0.44:0.55"] = 107, -- Menethil Harbor, Southshore
				["0.45:0.44:0.44:0.55:0.50:0.58"] = 176, -- Menethil Harbor, Southshore, Aerie Peak
				["0.45:0.44:0.44:0.55:0.48:0.61"] = 186, -- Menethil Harbor, Southshore, Chillwind Camp
				["0.45:0.44:0.44:0.55:0.48:0.61:0.61:0.65"] = 324, -- Menethil Harbor, Southshore, Chillwind Camp, Light's Hope Chapel
				["0.45:0.44:0.47:0.41:0.41:0.27:0.41:0.07"] = 445, -- Menethil Harbor, Ironforge, Stormwind, Booty Bay
				["0.45:0.44:0.47:0.41:0.41:0.27"] = 260, -- Menethil Harbor, Ironforge, Stormwind
				["0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27:0.55:0.19"] = 407, -- Menethil Harbor, Ironforge, Thorium Point, Stormwind, Nethergarde Keep
				["0.45:0.44:0.47:0.41:0.41:0.27:0.39:0.20"] = 323, -- Menethil Harbor, Ironforge, Stormwind, Sentinel Hill
				["0.45:0.44:0.47:0.41:0.41:0.27:0.50:0.25"] = 358, -- Menethil Harbor, Ironforge, Stormwind, Lakeshire
				["0.45:0.44:0.47:0.41:0.41:0.27:0.47:0.21"] = 362, -- Menethil Harbor, Ironforge, Stormwind, Darkshire
				["0.45:0.44:0.47:0.41:0.41:0.27:0.43:0.18"] = 339, -- Menethil Harbor, Ironforge, Stormwind, Rebel Camp
				["0.45:0.44:0.47:0.41:0.41:0.27:0.55:0.19"] = 422, -- Menethil Harbor, Ironforge, Stormwind, Nethergarde Keep
				["0.45:0.44:0.44:0.55:0.48:0.61:0.61:0.65:0.61:0.73"] = 422, -- Menethil Harbor, Southshore, Chillwind Camp, Light's Hope Chapel, Zul'Aman
				["0.45:0.44:0.47:0.41:0.58:0.94"] = 153, -- Menethil Harbor, Ironforge, Shattered Sun Staging Area
				["0.45:0.44:0.47:0.41:0.48:0.61"] = 309, -- Menethil Harbor, Ironforge, Chillwind Camp
				["0.45:0.44:0.51:0.53:0.50:0.58"] = 185, -- Menethil Harbor, Refuge Pointe, Aerie Peak
				["0.45:0.44:0.44:0.55:0.48:0.61:0.51:0.64"] = 236, -- Menethil Harbor, Southshore, Chillwind Camp, Thondroril River
				["0.45:0.44:0.44:0.55:0.48:0.61:0.61:0.65:0.62:0.66"] = 392, -- Menethil Harbor, Southshore, Chillwind Camp, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27:0.50:0.25"] = 343, -- Menethil Harbor, Ironforge, Thorium Point, Stormwind, Lakeshire
				["0.45:0.44:0.44:0.55:0.50:0.58:0.61:0.65"] = 339, -- Menethil Harbor, Southshore, Aerie Peak, Light's Hope Chapel
				["0.45:0.44:0.51:0.53:0.50:0.58:0.48:0.61"] = 235, -- Menethil Harbor, Refuge Pointe, Aerie Peak, Chillwind Camp
				["0.45:0.44:0.47:0.41:0.41:0.27:0.52:0.28"] = 398, -- Menethil Harbor, Ironforge, Stormwind, Morgan's Vigil
				["0.45:0.44:0.47:0.41:0.61:0.65"] = 393, -- Menethil Harbor, Ironforge, Light's Hope Chapel
				["0.45:0.44:0.53:0.39:0.47:0.35:0.41:0.27"] = 368, -- Menethil Harbor, Thelsamar, Thorium Point, Stormwind
				["0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27:0.47:0.21"] = 346, -- Menethil Harbor, Ironforge, Thorium Point, Stormwind, Darkshire
				["0.45:0.44:0.47:0.41:0.50:0.58"] = 348, -- Menethil Harbor, Ironforge, Aerie Peak

				-- Alliance: Morgan's Vigil (Burning Steppes)
				["0.52:0.28:0.50:0.25:0.47:0.21:0.43:0.18:0.41:0.07"] = 278, -- Morgan's Vigil, Lakeshire, Darkshire, Rebel Camp, Booty Bay
				["0.52:0.28:0.50:0.25:0.47:0.21:0.43:0.18"] = 165, -- Morgan's Vigil, Lakeshire, Darkshire, Rebel Camp
				["0.52:0.28:0.50:0.25:0.39:0.20"] = 195, -- Morgan's Vigil, Lakeshire, Sentinel Hill
				["0.52:0.28:0.41:0.27"] = 151, -- Morgan's Vigil, Stormwind
				["0.52:0.28:0.50:0.25:0.47:0.21"] = 121, -- Morgan's Vigil, Lakeshire, Darkshire
				["0.52:0.28:0.55:0.19"] = 198, -- Morgan's Vigil, Nethergarde Keep
				["0.52:0.28:0.50:0.25"] = 64, -- Morgan's Vigil, Lakeshire
				["0.52:0.28:0.47:0.35:0.53:0.39"] = 172, -- Morgan's Vigil, Thorium Point, Thelsamar
				["0.52:0.28:0.47:0.35"] = 91, -- Morgan's Vigil, Thorium Point
				["0.52:0.28:0.47:0.35:0.47:0.41"] = 171, -- Morgan's Vigil, Thorium Point, Ironforge
				["0.52:0.28:0.47:0.35:0.47:0.41:0.45:0.44"] = 240, -- Morgan's Vigil, Thorium Point, Ironforge, Menethil Harbor
				["0.52:0.28:0.47:0.35:0.53:0.39:0.51:0.53"] = 335, -- Morgan's Vigil, Thorium Point, Thelsamar, Refuge Pointe
				["0.52:0.28:0.47:0.35:0.47:0.41:0.44:0.55"] = 342, -- Morgan's Vigil, Thorium Point, Ironforge, Southshore
				["0.52:0.28:0.47:0.35:0.53:0.39:0.51:0.53:0.50:0.58"] = 407, -- Morgan's Vigil, Thorium Point, Thelsamar, Refuge Pointe, Aerie Peak (was 436, changed by Ludvig - Angelis0712)
				["0.52:0.28:0.47:0.35:0.47:0.41:0.48:0.61"] = 383, -- Morgan's Vigil, Thorium Point, Ironforge, Chillwind Camp
				["0.52:0.28:0.47:0.35:0.47:0.41:0.61:0.65"] = 478, -- Morgan's Vigil, Thorium Point, Ironforge, Light's Hope Chapel
				["0.52:0.28:0.47:0.35:0.47:0.41:0.50:0.58:0.48:0.61"] = 437, -- Morgan's Vigil, Thorium Point, Ironforge, Aerie Peak, Chillwind Camp
				["0.52:0.28:0.41:0.27:0.47:0.41"] = 354, -- Morgan's Vigil, Stormwind, Ironforge
				["0.52:0.28:0.47:0.35:0.47:0.41:0.61:0.65:0.61:0.73"] = 576, -- Morgan's Vigil, Thorium Point, Ironforge, Light's Hope Chapel, Zul'Aman
				["0.52:0.28:0.41:0.27:0.47:0.41:0.45:0.44"] = 423, -- Morgan's Vigil, Stormwind, Ironforge, Menethil Harbor
				["0.52:0.28:0.41:0.27:0.47:0.41:0.53:0.39"] = 411, -- Morgan's Vigil, Stormwind, Ironforge, Thelsamar
				["0.52:0.28:0.47:0.35:0.47:0.41:0.58:0.94"] = 236, -- Morgan's Vigil, Thorium Point, Ironforge, Shattered Sun Staging Area
				["0.52:0.28:0.50:0.25:0.47:0.21:0.41:0.07"] = 289, -- Morgan's Vigil, Lakeshire, Darkshire, Booty Bay
				["0.52:0.28:0.41:0.27:0.47:0.41:0.51:0.53:0.50:0.58"] = 586, -- Morgan's Vigil, Stormwind, Ironforge, Refuge Pointe, Aerie Peak
				["0.52:0.28:0.41:0.27:0.47:0.41:0.61:0.65"] = 660, -- Morgan's Vigil, Stormwind, Ironforge, Light's Hope Chapel
				["0.52:0.28:0.41:0.27:0.47:0.41:0.48:0.61"] = 566, -- Morgan's Vigil, Stormwind, Ironforge, Chillwind Camp
				["0.52:0.28:0.47:0.35:0.47:0.41:0.48:0.61:0.51:0.64"] = 436, -- Morgan's Vigil, Thorium Point, Ironforge, Chillwind Camp, Thondroril River
				["0.52:0.28:0.47:0.35:0.47:0.41:0.61:0.65:0.62:0.66"] = 544, -- Morgan's Vigil, Thorium Point, Ironforge, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.52:0.28:0.41:0.27:0.41:0.07"] = 336, -- Morgan's Vigil, Stormwind, Booty Bay
				["0.52:0.28:0.41:0.27:0.47:0.41:0.44:0.55"] = 525, -- Morgan's Vigil, Stormwind, Ironforge, Southshore
				["0.52:0.28:0.41:0.27:0.47:0.21"] = 254, -- Morgan's Vigil, Stormwind, Darkshire
				["0.52:0.28:0.41:0.27:0.43:0.18"] = 230, -- Morgan's Vigil, Stormwind, Rebel Camp
				["0.52:0.28:0.41:0.27:0.47:0.41:0.48:0.61:0.51:0.64"] = 619, -- Morgan's Vigil, Stormwind, Ironforge, Chillwind Camp, Thondoril River
				["0.52:0.28:0.47:0.35:0.47:0.41:0.44:0.55:0.50:0.58"] = 411, -- Morgan's Vigil, Thorium Point, Ironforge, Southshore, Aerie Peak

				-- Alliance: Nethergarde Keep (Blasted Lands)
				["0.55:0.19:0.47:0.21:0.43:0.18:0.41:0.07"] = 251, -- Nethergarde Keep, Darkshire, Rebel Camp, Booty Bay
				["0.55:0.19:0.47:0.21:0.43:0.18"] = 138, -- Nethergarde Keep, Darkshire, Rebel Camp (Güray Ggggs reported 58)
				["0.55:0.19:0.47:0.21:0.39:0.20"] = 183, -- Nethergarde Keep, Darkshire, Sentinel Hill
				["0.55:0.19:0.41:0.27"] = 189, -- Nethergarde Keep, Stormwind
				["0.55:0.19:0.47:0.21"] = 91, -- Nethergarde Keep, Darkshire
				["0.55:0.19:0.47:0.21:0.50:0.25"] = 150, -- Nethergarde Keep, Darkshire, Lakeshire
				["0.55:0.19:0.52:0.28"] = 207, -- Nethergarde Keep, Morgan's Vigil
				["0.55:0.19:0.52:0.28:0.47:0.35:0.53:0.39"] = 359, -- Nethergarde Keep, Morgan's Vigil, Thorium Point, Thelsamar
				["0.55:0.19:0.52:0.28:0.47:0.35"] = 278, -- Nethergarde Keep, Morgan's Vigil, Thorium Point
				["0.55:0.19:0.52:0.28:0.47:0.35:0.47:0.41"] = 357, -- Nethergarde Keep, Morgan's Vigil, Thorium Point, Ironforge
				["0.55:0.19:0.52:0.28:0.47:0.35:0.47:0.41:0.45:0.44"] = 426, -- Nethergarde Keep, Morgan's Vigil, Thorium Point, Ironforge, Menethil Harbor
				["0.55:0.19:0.52:0.28:0.47:0.35:0.53:0.39:0.51:0.53"] = 522, -- Nethergarde Keep, Morgan's Vigil, Thorium Point, Thelsamar, Refuge Pointe
				["0.55:0.19:0.52:0.28:0.47:0.35:0.47:0.41:0.44:0.55"] = 528, -- Nethergarde Keep, Morgan's Vigil, Thorium Point, Ironforge, Southshore
				["0.55:0.19:0.52:0.28:0.47:0.35:0.53:0.39:0.51:0.53:0.50:0.58"] = 593, -- Nethergarde Keep, Morgan's Vigil, Thorium Point, Thelsamar, Refuge Pointe, Aerie Peak (The Khan reported 210)
				["0.55:0.19:0.52:0.28:0.47:0.35:0.47:0.41:0.48:0.61"] = 570, -- Nethergarde Keep, Morgan's Vigil, Thorium Point, Ironforge, Chillwind Camp
				["0.55:0.19:0.52:0.28:0.47:0.35:0.47:0.41:0.61:0.65"] = 664, -- Nethergarde Keep, Morgan's Vigil, Thorium Point, Ironforge, Light's Hope Chapel
				["0.55:0.19:0.52:0.28:0.47:0.35:0.47:0.41:0.61:0.65:0.61:0.73"] = 763, -- Nethergarde Keep, Morgan's Vigil, Thorium Point, Ironforge, Light's Hope Chapel, Zul'Aman
				["0.55:0.19:0.47:0.21:0.41:0.07"] = 262, -- Nethergarde Keep, Darkshire, Booty Bay
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.41:0.45:0.44"] = 451, -- Nethergarde Keep, Darkshire, Stormwind, Ironforge, Menethil Harbor (Scott C, IJ, Nick de Vaan, Duncan Kennedy and Justin Chinn reported 150)
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.35:0.53:0.39:0.51:0.53:0.50:0.58"] = 611, -- Nethergarde Keep, Darkshire, Stormwind, Thorium Point, Thelsamar, Refuge Pointe, Aerie Peak
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.41:0.48:0.61"] = 594, -- Nethergarde Keep, Darkshire, Stormwind, Ironforge, Chillwind Camp
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.35"] = 298, -- Nethergarde Keep, Darkshire, Stormwind, Thorium Point
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.41:0.51:0.53:0.50:0.58"] = 612, -- Nethergarde Keep, Darkshire, Stormwind, Ironforge, Refuge Pointe, Aerie Peak
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.41:0.51:0.53"] = 541, -- Nethergarde Keep, Darkshire, Stormwind, Ironforge, Refuge Pointe
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.41:0.53:0.39"] = 439, -- Nethergarde Keep, Darkshire, Stormwind, Ironforge, Thelsamar
				["0.55:0.19:0.52:0.28:0.47:0.35:0.47:0.41:0.58:0.94"] = 422, -- Nethergarde Keep, Morgan's Vigil, Thorium Point, Ironforge, Shattered Sun Staging Area
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.41"] = 381, -- Nethergarde Keep, Darkshire, Stormwind, Ironforge
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.41:0.44:0.55"] = 552, -- Burg Nethergarde, Dunkelhain, Sturmwind, Eisenschmiede, Süderstade
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.35:0.53:0.39"] = 377, -- Nethergarde Keep, Darkshire, Stormwind, Thorium Point, Thelsamar
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.41:0.61:0.65"] = 687, -- Nethergarde Keep, Darkshire, Stormwind, Ironforge, Light's Hope Chapel
				["0.55:0.19:0.41:0.27:0.47:0.41:0.53:0.39"] = 450, -- Nethergarde Keep, Stormwind, Ironforge, Thelsamar
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.35:0.53:0.39:0.51:0.53"] = 540, -- Nethergarde Keep, Darkshire, Stormwind, Thorium Point, Thelsamar, Refuge Pointe
				["0.55:0.19:0.52:0.28:0.47:0.35:0.47:0.41:0.48:0.61:0.51:0.64"] = 623, -- Nethergarde Keep, Morgan's Vigil, Thorium Point, Ironforge, Chillwind Camp, Thondroril River
				["0.55:0.19:0.52:0.28:0.47:0.35:0.47:0.41:0.61:0.65:0.62:0.66"] = 731, -- Nethergarde Keep, Morgan's Vigil, Thorium Point, Ironforge, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.41:0.44:0.55:0.50:0.58"] = 622, -- Nethergarde Keep, Darkshire, Stormwind, Ironforge, Southshore, Aerie Peak
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.41:0.48:0.61:0.51:0.64"] = 646, -- Nethergarde Keep, Darkshire, Stormwind, Ironforge, Chillwind Camp, Thondoril River
				["0.55:0.19:0.41:0.27:0.43:0.18"] = 268, -- Nethergarde Keep, Stormwind, Rebel Camp
				["0.55:0.19:0.47:0.21:0.41:0.27:0.47:0.41:0.58:0.94"] = 445, -- Nethergarde Keep, Darkshire, Stormwind, Ironforge, Shattered Sun Staging Area

				-- Alliance: Rebel Camp (Stranglethorn Vale)
				["0.43:0.18:0.41:0.07"] = 116, -- Rebel Camp, Booty Bay
				["0.43:0.18:0.39:0.20"] = 66, -- Rebel Camp, Sentinel Hill
				["0.43:0.18:0.41:0.27"] = 98, -- Rebel Camp, Stormwind
				["0.43:0.18:0.47:0.21:0.55:0.19"] = 139, -- Rebel Camp, Darkshire, Nethergarde Keep
				["0.43:0.18:0.47:0.21"] = 48, -- Rebel Camp, Darkshire
				["0.43:0.18:0.47:0.21:0.50:0.25"] = 102, -- Rebel Camp, Darkshire, Lakeshire
				["0.43:0.18:0.47:0.21:0.50:0.25:0.52:0.28"] = 163, -- Rebel Camp, Darkshire, Lakeshire, Morgan's Vigil
				["0.43:0.18:0.41:0.27:0.47:0.35"] = 218, -- Rebel Camp, Stormwind, Thorium Point
				["0.43:0.18:0.41:0.27:0.47:0.35:0.53:0.39"] = 296, -- Rebel Camp, Stormwind, Thorium Point, Thelsamar
				["0.43:0.18:0.41:0.27:0.47:0.41"] = 300, -- Rebel Camp, Stormwind, Ironforge
				["0.43:0.18:0.41:0.27:0.47:0.41:0.45:0.44"] = 370, -- Rebel Camp, Stormwind, Ironforge, Menethil Harbor
				["0.43:0.18:0.41:0.27:0.47:0.35:0.53:0.39:0.51:0.53"] = 459, -- Rebel Camp, Stormwind, Thorium Point, Thelsamar, Refuge Pointe
				["0.43:0.18:0.41:0.27:0.47:0.41:0.44:0.55"] = 472, -- Rebel Camp, Stormwind, Ironforge, Southshore
				["0.43:0.18:0.41:0.27:0.47:0.35:0.53:0.39:0.51:0.53:0.50:0.58"] = 531, -- Rebel Camp, Stormwind, Thorium Point, Thelsamar, Refuge Pointe, Aerie Peak
				["0.43:0.18:0.41:0.27:0.47:0.41:0.48:0.61"] = 513, -- Rebel Camp, Stormwind, Ironforge, Chillwind Camp (was 567, changed by SchinknBrot on CurseForge and Alexander Vestbjerg)
				["0.43:0.18:0.41:0.27:0.47:0.41:0.61:0.65"] = 607, -- Rebel Camp, Stormwind, Ironforge, Light's Hope Chapel (was 676, changed to 607 by Kaptin Kraut, Brenda Adams and Erik Roslund)
				["0.43:0.18:0.41:0.27:0.47:0.41:0.61:0.65:0.61:0.73"] = 704, -- Rebel Camp, Stormwind, Ironforge, Light's Hope Chapel, Zul'Aman
				["0.43:0.18:0.41:0.27:0.47:0.41:0.51:0.53"] = 461, -- Rebel Camp, Stormwind, Ironforge, Refuge Pointe
				["0.43:0.18:0.41:0.27:0.47:0.41:0.53:0.39"] = 358, -- Rebel Camp, Stormwind, Ironforge, Thelsamar
				["0.43:0.18:0.41:0.27:0.47:0.41:0.58:0.94"] = 365, -- Rebel Camp, Stormwind, Ironforge, Shattered Sun Staging Area
				["0.43:0.18:0.41:0.27:0.47:0.41:0.51:0.53:0.50:0.58"] = 532, -- Rebel Camp, Stormwind, Ironforge, Refuge Pointe, Aerie Peak
				["0.43:0.18:0.39:0.20:0.50:0.25"] = 196, -- Rebel Camp, Sentinel Hill, Lakeshire
				["0.43:0.18:0.41:0.27:0.47:0.41:0.48:0.61:0.51:0.64"] = 566, -- Rebel Camp, Stormwind, Ironforge, Chillwind Camp, Thondroril River
				["0.43:0.18:0.41:0.27:0.47:0.41:0.61:0.65:0.62:0.66"] = 673, -- Rebel Camp, Stormwind, Ironforge, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.43:0.18:0.41:0.27:0.55:0.19"] = 261, -- Rebel Camp, Stormwind, Nethergarde Keep

				-- Alliance: Refuge Pointe (Arathi Highlands)
				["0.51:0.53:0.53:0.39:0.47:0.35:0.41:0.27:0.41:0.07"] = 558, -- Refuge Pointe, Thelsamar, Thorium Point, Stormwind, Booty Bay
				["0.51:0.53:0.53:0.39:0.47:0.35:0.41:0.27:0.39:0.20"] = 436, -- Refuge Pointe, Thelsamar, Thorium Point, Stormwind, Sentinel Hill
				["0.51:0.53:0.53:0.39:0.47:0.35:0.41:0.27:0.43:0.18"] = 452, -- Refuge Pointe, Thelsamar, Thorium Point, Stormwind, Rebel Camp
				["0.51:0.53:0.53:0.39:0.47:0.35:0.52:0.28:0.50:0.25:0.47:0.21"] = 429, -- Refuge Pointe, Thelsamar, Thorium Point, Morgan's Vigil, Lakeshire, Darkshire
				["0.51:0.53:0.53:0.39:0.47:0.35:0.52:0.28:0.55:0.19"] = 509, -- Refuge Pointe, Thelsamar, Thorium Point, Morgan's Vigil, Nethergarde Keep
				["0.51:0.53:0.53:0.39:0.47:0.35:0.52:0.28:0.50:0.25"] = 371, -- Refuge Pointe, Thelsamar, Thorium Point, Morgan's Vigil, Lakeshire
				["0.51:0.53:0.53:0.39:0.47:0.35:0.52:0.28"] = 339, -- Refuge Pointe, Thelsamar, Thorium Point, Morgan's Vigil
				["0.51:0.53:0.53:0.39:0.47:0.35:0.41:0.27"] = 373, -- Refuge Pointe, Thelsamar, Thorium Point, Stormwind
				["0.51:0.53:0.53:0.39:0.47:0.35"] = 249, -- Refuge Pointe, Thelsamar, Thorium Point
				["0.51:0.53:0.53:0.39"] = 171, -- Refuge Pointe, Thelsamar
				["0.51:0.53:0.47:0.41"] = 270, -- Refuge Pointe, Ironforge (David R reported 301)
				["0.51:0.53:0.45:0.44"] = 126, -- Refuge Pointe, Menethil Harbor
				["0.51:0.53:0.44:0.55"] = 87, -- Refuge Pointe, Southshore
				["0.51:0.53:0.50:0.58"] = 72, -- Refuge Pointe, Aerie Peak
				["0.51:0.53:0.50:0.58:0.48:0.61"] = 123, -- Refuge Pointe, Aerie Peak, Chillwind Camp
				["0.51:0.53:0.50:0.58:0.61:0.65"] = 233, -- Refuge Pointe, Aerie Peak, Light's Hope Chapel
				["0.51:0.53:0.45:0.44:0.47:0.41:0.41:0.27:0.41:0.07"] = 570, -- Refuge Pointe, Menethil Harbor, Ironforge, Stormwind, Booty Bay
				["0.51:0.53:0.45:0.44:0.47:0.41:0.41:0.27"] = 386, -- Refuge Pointe, Menethil Harbor, Ironforge, Stormwind
				["0.51:0.53:0.45:0.44:0.47:0.41:0.41:0.27:0.39:0.20"] = 449, -- Refuge Pointe, Menethil Harbor, Ironforge, Stormwind, Sentinel Hill
				["0.51:0.53:0.47:0.41:0.41:0.27"] = 440, -- Refuge Pointe, Ironforge, Stormwind
				["0.51:0.53:0.45:0.44:0.47:0.41:0.41:0.27:0.47:0.21"] = 488, -- Refuge Pointe, Menethil Harbor, Ironforge, Stormwind, Darkshire
				["0.51:0.53:0.45:0.44:0.47:0.41:0.41:0.27:0.43:0.18"] = 464, -- Refuge Pointe, Menethil Harbor, Ironforge, Stormwind, Rebel Camp
				["0.51:0.53:0.45:0.44:0.47:0.41:0.41:0.27:0.55:0.19"] = 548, -- Refuge Pointe, Menethil Harbor, Ironforge, Stormwind, Nethergarde Keep
				["0.51:0.53:0.45:0.44:0.47:0.41:0.41:0.27:0.50:0.25"] = 484, -- Refuge Pointe, Menethil Harbor, Ironforge, Stormwind, Lakeshire
				["0.51:0.53:0.50:0.58:0.61:0.65:0.58:0.94"] = 569, -- Refuge Pointe, Aerie Peak, Light's Hope Chapel, Shattered Sun Staging Area
				["0.51:0.53:0.44:0.55:0.48:0.61"] = 166, -- Refuge Pointe, Southshore, Chillwind Camp
				["0.51:0.53:0.53:0.39:0.47:0.35:0.41:0.27:0.47:0.21"] = 475, -- Refuge Pointe, Thelsamar, Thorium Point, Stormwind, Darkshire
				["0.51:0.53:0.50:0.58:0.61:0.65:0.61:0.73"] = 332, -- Refuge Pointe, Aerie Peak, Light's Hope Chapel, Zul'Aman
				["0.51:0.53:0.50:0.58:0.48:0.61:0.51:0.64"] = 175, -- Refuge Pointe, Aerie Peak, Chillwind Camp, Thondroril River
				["0.51:0.53:0.50:0.58:0.61:0.65:0.62:0.66"] = 302, -- Refuge Pointe, Aerie Peak, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.51:0.53:0.53:0.39:0.47:0.35:0.41:0.27:0.55:0.19"] = 536, -- Refuge Pointe, Thelsamar, Thorium Point, Stormwind, Nethergarde Keep
				["0.51:0.53:0.47:0.41:0.48:0.61"] = 477, -- Refuge Pointe, Ironforge, Chillwind Camp
				["0.51:0.53:0.47:0.41:0.41:0.27:0.39:0.20"] = 503, -- Refuge Pointe, Ironforge, Stormwind, Sentinel Hill
				["0.51:0.53:0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27:0.41:0.07"] = 554, -- Refuge Pointe, Menethil Harbor, Ironforge, Thorium Point, Stormwind, Booty Bay
				["0.51:0.53:0.44:0.55:0.48:0.61:0.51:0.64"] = 216, -- Die Zuflucht, Süderstade, Zugwindlager, Thondroril
				["0.51:0.53:0.47:0.41:0.41:0.27:0.41:0.07"] = 624, -- Refuge Pointe, Ironforge, Stormwind, Booty Bay

				-- Alliance: Sentinel Hill (Westfall)
				["0.39:0.20:0.41:0.07"] = 185, -- Sentinel Hill, Booty Bay
				["0.39:0.20:0.43:0.18"] = 62, -- Sentinel Hill, Rebel Camp
				["0.39:0.20:0.47:0.21:0.55:0.19"] = 186, -- Sentinel Hill, Darkshire, Nethergarde Keep
				["0.39:0.20:0.47:0.21"] = 97, -- Sentinel Hill, Darkshire
				["0.39:0.20:0.50:0.25"] = 130, -- Sentinel Hill, Lakeshire
				["0.39:0.20:0.50:0.25:0.52:0.28"] = 190, -- Sentinel Hill, Lakeshire, Morgan's Vigil
				["0.39:0.20:0.41:0.27"] = 86, -- Sentinel Hill, Stormwind
				["0.39:0.20:0.41:0.27:0.47:0.35"] = 205, -- Sentinel Hill, Stormwind, Thorium Point
				["0.39:0.20:0.41:0.27:0.47:0.35:0.53:0.39"] = 284, -- Sentinel Hill, Stormwind, Thorium Point, Thelsamar
				["0.39:0.20:0.41:0.27:0.47:0.41"] = 288, -- Sentinel Hill, Stormwind, Ironforge
				["0.39:0.20:0.41:0.27:0.47:0.41:0.45:0.44"] = 358, -- Sentinel Hill, Stormwind, Ironforge, Menethil Harbor
				["0.39:0.20:0.41:0.27:0.47:0.35:0.53:0.39:0.51:0.53"] = 447, -- Sentinel Hill, Stormwind, Thorium Point, Thelsamar, Refuge Pointe
				["0.39:0.20:0.41:0.27:0.47:0.41:0.44:0.55"] = 460, -- Sentinel Hill, Stormwind, Ironforge, Southshore
				["0.39:0.20:0.41:0.27:0.47:0.35:0.53:0.39:0.51:0.53:0.50:0.58"] = 518, -- Sentinel Hill, Stormwind, Thorium Point, Thelsamar, Refuge Pointe, Aerie Peak (Originally 376 but Norman Kustov and William reported 518)
				["0.39:0.20:0.41:0.27:0.47:0.41:0.48:0.61"] = 501, -- Sentinel Hill, Stormwind, Ironforge, Chillwind Camp (changed to 501 by veri and Cary Rodgers, was 555)
				["0.39:0.20:0.41:0.27:0.47:0.41:0.61:0.65"] = 595, -- Sentinel Hill, Stormwind, Ironforge, Light's Hope Chapel
				["0.39:0.20:0.41:0.27:0.47:0.41:0.53:0.39"] = 346, -- Sentinel Hill, Stormwind, Ironforge, Thelsamar
				["0.39:0.20:0.41:0.27:0.47:0.41:0.61:0.65:0.61:0.73"] = 693, -- Sentinel Hill, Stormwind, Ironforge, Light's Hope Chapel, Zul'Aman
				["0.39:0.20:0.41:0.27:0.47:0.41:0.51:0.53:0.50:0.58"] = 519, -- Sentinel Hill, Stormwind, Ironforge, Refuge Pointe, Aerie Peak
				["0.39:0.20:0.41:0.27:0.47:0.41:0.51:0.53"] = 449, -- Sentinel Hill, Stormwind, Ironforge, Refuge Pointe
				["0.39:0.20:0.41:0.27:0.47:0.41:0.58:0.94"] = 352, -- Sentinel Hill, Stormwind, Ironforge, Shattered Sun Staging Area
				["0.39:0.20:0.41:0.27:0.47:0.41:0.48:0.61:0.51:0.64"] = 554, -- Sentinel Hill, Stormwind, Ironforge, Chillwind Camp, Thondroril River
				["0.39:0.20:0.41:0.27:0.47:0.41:0.61:0.65:0.62:0.66"] = 661, -- Sentinel Hill, Stormwind, Ironforge, Light's Hope Chapel, Acherus: The Ebon Hold

				-- Alliance: Shattered Sun Staging Area (Isle of Quel'Danas)
				["0.58:0.94:0.61:0.65"] = 324, -- Shattered Sun Staging Area, Light's Hope Chapel
				["0.58:0.94:0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27"] = 849, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge, Thorium Point, Stormwind
				["0.58:0.94:0.61:0.65:0.48:0.61"] = 470, -- Shattered Sun Staging Area, Light's Hope Chapel, Chillwind Camp
				["0.58:0.94:0.61:0.65:0.47:0.41"] = 690, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge
				["0.58:0.94:0.61:0.65:0.50:0.58"] = 483, -- Shattered Sun Staging Area, Light's Hope Chapel, Aerie Peak
				["0.58:0.94:0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.41:0.07"] = 1033, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Booty Bay
				["0.58:0.94:0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28"] = 822, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil
				["0.58:0.94:0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28:0.55:0.19"] = 991, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil, Nethergarde Keep
				["0.58:0.94:0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25:0.47:0.21"] = 912, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire, Darkshire
				["0.58:0.94:0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.43:0.18"] = 928, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Rebel Camp
				["0.58:0.94:0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.39:0.20"] = 912, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Sentinel Hill
				["0.58:0.94:0.61:0.65:0.47:0.41:0.47:0.35"] = 738, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge, Thorium Point
				["0.58:0.94:0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25"] = 854, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire
				["0.58:0.94:0.61:0.65:0.50:0.58:0.51:0.53"] = 553, -- Shattered Sun Staging Area, Light's Hope Chapel, Aerie Peak, Refuge Pointe
				["0.58:0.94:0.61:0.65:0.50:0.58:0.51:0.53:0.53:0.39"] = 723, -- Shattered Sun Staging Area, Light's Hope Chapel, Aerie Peak, Refuge Pointe, Thelsamar
				["0.58:0.94:0.61:0.65:0.50:0.58:0.44:0.55"] = 545, -- Shattered Sun Staging Area, Light's Hope Chapel, Aerie Peak, Southshore
				["0.58:0.94:0.61:0.65:0.50:0.58:0.44:0.55:0.45:0.44"] = 653, -- Shattered Sun Staging Area, Light's Hope Chapel, Aerie Peak, Southshore, Menethil Harbor (Bilegt reported 670)
				["0.58:0.94:0.61:0.73"] = 233, -- Shattered Sun Staging Area, Zul'Aman (Yunus Gürbüz reported 242 but my own testing shows 233) (Will Hausenfluck reported 134)
				["0.58:0.94:0.61:0.65:0.47:0.41:0.41:0.27"] = 864, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge, Stormwind
				["0.58:0.94:0.61:0.65:0.47:0.41:0.41:0.27:0.55:0.19"] = 1027, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge, Stormwind, Nethergarde Keep
				["0.58:0.94:0.61:0.65:0.47:0.41:0.41:0.27:0.47:0.21"] = 965, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge, Stormwind, Darkshire
				["0.58:0.94:0.61:0.65:0.51:0.64"] = 424, -- Shattered Sun Staging Area, Light's Hope Chapel, Thondroril River
				["0.58:0.94:0.61:0.65:0.47:0.41:0.41:0.27:0.41:0.07"] = 1050, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge, Stormwind, Booty Bay
				["0.58:0.94:0.61:0.65:0.48:0.61:0.44:0.55:0.45:0.44"] = 680, -- Shattered Sun Staging Area, Light's Hope Chapel, Chillwind Camp, Southshore, Menethil Harbor
				["0.58:0.94:0.61:0.65:0.48:0.61:0.44:0.55"] = 547, -- Shattered Sun Staging Area, Light's Hope Chapel, Chillwind Camp, Southshore
				["0.58:0.94:0.61:0.65:0.62:0.66"] = 392, -- Shattered Sun Staging Area, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.58:0.94:0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.47:0.21"] = 952, -- Shattered Sun Staging Area, Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Darkshire

				-- Alliance: Southshore (Hillsbrad Foothills)
				["0.44:0.55:0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27:0.41:0.07"] = 539, -- Southshore, Menethil Harbor, Ironforge, Thorium Point, Stormwind, Booty Bay (was 597, changed by Daniel Hoedt and Robert Keller)
				["0.44:0.55:0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27:0.39:0.20"] = 430, -- Southshore, Menethil Harbor, Ironforge, Thorium Point, Stormwind, Sentinel Hill
				["0.44:0.55:0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27:0.43:0.18"] = 433, -- Southshore, Menethil Harbor, Ironforge, Thorium Point, Stormwind, Rebel Camp
				["0.44:0.55:0.45:0.44:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25:0.47:0.21"] = 417, -- Southshore, Menethil Harbor, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire, Darkshire
				["0.44:0.55:0.45:0.44:0.47:0.41:0.47:0.35:0.52:0.28:0.55:0.19"] = 496, -- Southshore, Menethil Harbor, Ironforge, Thorium Point, Morgan's Vigil, Nethergarde Keep
				["0.44:0.55:0.45:0.44:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25"] = 359, -- Southshore, Menethil Harbor, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire
				["0.44:0.55:0.45:0.44:0.47:0.41:0.47:0.35:0.52:0.28"] = 327, -- Southshore, Menethil Harbor, Ironforge, Thorium Point, Morgan's Vigil
				["0.44:0.55:0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27"] = 354, -- Southshore, Menethil Harbor, Ironforge, Thorium Point, Stormwind
				["0.44:0.55:0.45:0.44:0.47:0.41:0.47:0.35"] = 243, -- Southshore, Menethil Harbor, Ironforge, Thorium Point
				["0.44:0.55:0.51:0.53:0.53:0.39"] = 244, -- Southshore, Refuge Pointe, Thelsamar
				["0.44:0.55:0.47:0.41"] = 207, -- Southshore, Ironforge
				["0.44:0.55:0.45:0.44"] = 110, -- Southshore, Menethil Harbor
				["0.44:0.55:0.51:0.53"] = 74, -- Southshore, Refuge Pointe
				["0.44:0.55:0.50:0.58"] = 71, -- Southshore, Aerie Peak
				["0.44:0.55:0.48:0.61"] = 81, -- Southshore, Chillwind Camp (Will Hausenfluck reported 44)
				["0.44:0.55:0.48:0.61:0.61:0.65"] = 219, -- Southshore, Chillwind Camp, Light's Hope Chapel
				["0.44:0.55:0.45:0.44:0.47:0.41:0.41:0.27"] = 370, -- Southshore, Menethil Harbor, Ironforge, Stormwind
				["0.44:0.55:0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27:0.55:0.19"] = 517, -- Southshore, Menethil Harbor, Ironforge, Thorium Point, Stormwind, Nethergarde Keep
				["0.44:0.55:0.45:0.44:0.47:0.41:0.41:0.27:0.41:0.07"] = 554, -- Southshore, Menethil Harbor, Ironforge, Stormwind, Booty Bay
				["0.44:0.55:0.45:0.44:0.47:0.41:0.41:0.27:0.43:0.18"] = 449, -- Southshore, Menethil Harbor, Ironforge, Stormwind, Rebel Camp
				["0.44:0.55:0.45:0.44:0.47:0.41:0.41:0.27:0.39:0.20"] = 433, -- Southshore, Menethil Harbor, Ironforge, Stormwind, Sentinel Hill
				["0.44:0.55:0.45:0.44:0.47:0.41:0.41:0.27:0.50:0.25"] = 468, -- Southshore, Menethil Harbor, Ironforge, Stormwind, Lakeshire
				["0.44:0.55:0.45:0.44:0.47:0.41:0.41:0.27:0.47:0.21"] = 472, -- Southshore, Menethil Harbor, Ironforge, Stormwind, Darkshire
				["0.44:0.55:0.48:0.61:0.61:0.65:0.58:0.94"] = 555, -- Southshore, Chillwind Camp, Light's Hope Chapel, Shattered Sun Staging Area
				["0.44:0.55:0.48:0.61:0.61:0.65:0.61:0.73"] = 318, -- Southshore, Chillwind Camp, Light's Hope Chapel, Zul'Aman
				["0.44:0.55:0.45:0.44:0.53:0.39"] = 273, -- Southshore, Menethil Harbor, Thelsamar
				["0.44:0.55:0.47:0.41:0.41:0.27"] = 373, -- Southshore, Ironforge, Stormwind
				["0.44:0.55:0.45:0.44:0.47:0.41:0.41:0.27:0.55:0.19"] = 532, -- Southshore, Menethil Harbor, Ironforge, Stormwind, Nethergarde Keep
				["0.44:0.55:0.47:0.41:0.41:0.27:0.50:0.25"] = 471, -- Southshore, Ironforge, Stormwind, Lakeshire
				["0.44:0.55:0.48:0.61:0.51:0.64"] = 131, -- Southshore, Chillwind Camp, Thondroril River
				["0.44:0.55:0.48:0.61:0.61:0.65:0.62:0.66"] = 286, -- Southshore, Chillwind Camp, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.44:0.55:0.45:0.44:0.47:0.41:0.41:0.27:0.52:0.28"] = 508, -- Southshore, Menethil Harbor, Ironforge, Stormwind, Morgan's Vigil
				["0.44:0.55:0.47:0.41:0.41:0.27:0.43:0.18"] = 451, -- Southshore, Ironforge, Stormwind, Rebel Camp
				["0.44:0.55:0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27:0.50:0.25"] = 453, -- Southshore, Menethil Harbor, Ironforge, Thorium Point, Stormwind, Lakeshire
				["0.44:0.55:0.45:0.44:0.47:0.41:0.58:0.94"] = 263, -- Southshore, Menethil Harbor, Ironforge, Shattered Sun Staging Area
				["0.44:0.55:0.45:0.44:0.47:0.41:0.47:0.35:0.41:0.27:0.47:0.21"] = 457, -- Southshore, Menethil Harbor, Ironforge, Thorium Point, Stormwind, Darkshire
				["0.44:0.55:0.51:0.53:0.53:0.39:0.47:0.35:0.41:0.27"] = 447, -- Southshore, Refuge Pointe, Thelsamar, Thorium Point, Stormwind
				["0.44:0.55:0.47:0.41:0.53:0.39"] = 262, -- Southshore, Ironforge, Thelsamar
				["0.44:0.55:0.47:0.41:0.41:0.27:0.39:0.20"] = 436, -- Southshore, Ironforge, Stormwind, Sentinel Hill
				["0.44:0.55:0.47:0.41:0.41:0.27:0.41:0.07"] = 557, -- Southshore, Ironforge, Stormwind, Booty Bay
				["0.44:0.55:0.50:0.58:0.61:0.65:0.51:0.64"] = 332, -- Southshore, Aerie Peak, Light's Hope Chapel, Thondoril River

				-- Alliance: Stormwind (Elwynn Forest)
				["0.41:0.27:0.41:0.07"] = 200, -- Stormwind, Booty Bay
				["0.41:0.27:0.55:0.19"] = 176, -- Stormwind, Nethergarde Keep
				["0.41:0.27:0.43:0.18"] = 93, -- Stormwind, Rebel Camp
				["0.41:0.27:0.39:0.20"] = 78, -- Stormwind, Sentinel Hill
				["0.41:0.27:0.47:0.21"] = 116, -- Stormwind, Darkshire
				["0.41:0.27:0.50:0.25"] = 113, -- Stormwind, Lakeshire
				["0.41:0.27:0.52:0.28"] = 157, -- Stormwind, Morgan's Vigil
				["0.41:0.27:0.47:0.35"] = 133, -- Stormwind, Thorium Point
				["0.41:0.27:0.47:0.35:0.53:0.39"] = 212, -- Stormwind, Thorium Point, Thelsamar
				["0.41:0.27:0.47:0.41"] = 216, -- Stormwind, Ironforge
				["0.41:0.27:0.47:0.41:0.45:0.44"] = 286, -- Stormwind, Ironforge, Menethil Harbor
				["0.41:0.27:0.47:0.35:0.53:0.39:0.51:0.53"] = 375, -- Stormwind, Thorium Point, Thelsamar, Refuge Pointe
				["0.41:0.27:0.47:0.41:0.44:0.55"] = 387, -- Stormwind, Ironforge, Southshore
				["0.41:0.27:0.47:0.35:0.53:0.39:0.51:0.53:0.50:0.58"] = 446, -- Stormwind, Thorium Point, Thelsamar, Refuge Pointe, Aerie Peak
				["0.41:0.27:0.47:0.41:0.48:0.61"] = 429, -- Stormwind, Ironforge, Chillwind Camp
				["0.41:0.27:0.47:0.41:0.61:0.65"] = 523, -- Stormwind, Ironforge, Light's Hope Chapel
				["0.41:0.27:0.47:0.41:0.61:0.65:0.61:0.73"] = 621, -- Stormwind, Ironforge, Light's Hope Chapel, Zul'Aman
				["0.41:0.27:0.47:0.41:0.53:0.39"] = 274, -- Stormwind, Ironforge, Thelsamar
				["0.41:0.27:0.47:0.41:0.51:0.53"] = 377, -- Stormwind, Ironforge, Refuge Pointe
				["0.41:0.27:0.47:0.41:0.50:0.58:0.44:0.55"] = 497, -- Stormwind, Ironforge, Aerie Peak, Southshore
				["0.41:0.27:0.47:0.41:0.50:0.58"] = 464, -- Stormwind, Ironforge, Aerie Peak (was 304, changed by Jesper to 464)
				["0.41:0.27:0.47:0.41:0.50:0.58:0.48:0.61"] = 484, -- Stormwind, Ironforge, Aerie Peak, Chillwind Camp
				["0.41:0.27:0.47:0.41:0.51:0.53:0.50:0.58"] = 448, -- Stormwind, Ironforge, Refuge Pointe, Aerie Peak
				["0.41:0.27:0.47:0.41:0.58:0.94"] = 281, -- Stormwind, Ironforge, Shattered Sun Staging Area
				["0.41:0.27:0.47:0.41:0.44:0.55:0.50:0.58"] = 457, -- Stormwind, Ironforge, Southshore, Aerie Peak
				["0.41:0.27:0.47:0.41:0.48:0.61:0.51:0.64"] = 482, -- Stormwind, Ironforge, Chillwind Camp, Thondroril River
				["0.41:0.27:0.47:0.41:0.61:0.65:0.62:0.66"] = 589, -- Stormwind, Ironforge, Light's Hope Chapel, Acherus: The Ebon Hold

				-- Alliance: Thelsamar (Loch Modan)
				["0.53:0.39:0.47:0.35:0.41:0.27:0.41:0.07"] = 390, -- Thelsamar, Thorium Point, Stormwind, Booty Bay
				["0.53:0.39:0.47:0.35:0.41:0.27:0.43:0.18"] = 284, -- Thelsamar, Thorium Point, Stormwind, Rebel Camp
				["0.53:0.39:0.47:0.35:0.41:0.27:0.39:0.20"] = 269, -- Thelsamar, Thorium Point, Stormwind, Sentinel Hill
				["0.53:0.39:0.47:0.35:0.41:0.27"] = 206, -- Thelsamar, Thorium Point, Stormwind
				["0.53:0.39:0.47:0.35:0.52:0.28:0.50:0.25:0.47:0.21"] = 262, -- Thelsamar, Thorium Point, Morgan's Vigil, Lakeshire, Darkshire
				["0.53:0.39:0.47:0.35:0.52:0.28:0.55:0.19"] = 341, -- Thelsamar, Thorium Point, Morgan's Vigil, Nethergarde Keep
				["0.53:0.39:0.47:0.35:0.52:0.28:0.50:0.25"] = 204, -- Thelsamar, Thorium Point, Morgan's Vigil, Lakeshire
				["0.53:0.39:0.47:0.35:0.52:0.28"] = 172, -- Thelsamar, Thorium Point, Morgan's Vigil
				["0.53:0.39:0.47:0.35"] = 82, -- Thelsamar, Thorium Point
				["0.53:0.39:0.47:0.41"] = 109, -- Thelsamar, Ironforge
				["0.53:0.39:0.45:0.44"] = 153, -- Thelsamar, Menethil Harbor
				["0.53:0.39:0.51:0.53"] = 164, -- Thelsamar, Refuge Pointe
				["0.53:0.39:0.51:0.53:0.44:0.55"] = 250, -- Thelsamar, Refuge Pointe, Southshore
				["0.53:0.39:0.51:0.53:0.50:0.58"] = 235, -- Thelsamar, Refuge Pointe, Aerie Peak
				["0.53:0.39:0.51:0.53:0.50:0.58:0.48:0.61"] = 285, -- Thelsamar, Refuge Pointe, Aerie Peak, Chillwind Camp
				["0.53:0.39:0.51:0.53:0.50:0.58:0.61:0.65"] = 396, -- Thelsamar, Refuge Pointe, Aerie Peak, Light's Hope Chapel
				["0.53:0.39:0.47:0.41:0.41:0.27:0.39:0.20"] = 340, -- Thelsamar, Ironforge, Stormwind, Sentinel Hill
				["0.53:0.39:0.47:0.41:0.41:0.27"] = 277, -- Thelsamar, Ironforge, Stormwind
				["0.53:0.39:0.51:0.53:0.50:0.58:0.61:0.65:0.61:0.73"] = 495, -- Thelsamar, Refuge Pointe, Aerie Peak, Light's Hope Chapel, Zul'Aman
				["0.53:0.39:0.47:0.41:0.41:0.27:0.47:0.21"] = 379, -- Thelsamar, Ironforge, Stormwind, Darkshire
				["0.53:0.39:0.47:0.41:0.41:0.27:0.50:0.25"] = 376, -- Thelsamar, Ironforge, Stormwind, Lakeshire
				["0.53:0.39:0.47:0.41:0.41:0.27:0.43:0.18"] = 355, -- Thelsamar, Ironforge, Stormwind, Rebel Camp
				["0.53:0.39:0.47:0.41:0.41:0.27:0.41:0.07"] = 461, -- Thelsamar, Ironforge, Stormwind, Booty Bay
				["0.53:0.39:0.47:0.41:0.58:0.94"] = 175, -- Thelsamar, Ironforge, Shattered Sun Staging Area
				["0.53:0.39:0.47:0.35:0.41:0.27:0.47:0.21"] = 307, -- Thelsamar, Thorium Point, Stormwind, Darkshire
				["0.53:0.39:0.47:0.41:0.41:0.27:0.55:0.19"] = 440, -- Thelsamar, Ironforge, Stormwind, Nethergarde Keep
				["0.53:0.39:0.47:0.35:0.41:0.27:0.55:0.19"] = 368, -- Thelsamar, Thorium Point, Stormwind, Nethergarde Keep
				["0.53:0.39:0.51:0.53:0.44:0.55:0.48:0.61"] = 329, -- Thelsamar, Refuge Pointe, Southshore, Chillwind Camp
				["0.53:0.39:0.51:0.53:0.50:0.58:0.48:0.61:0.51:0.64"] = 339, -- Thelsamar, Refuge Pointe, Aerie Peak, Chillwind Camp, Thondroril River
				["0.53:0.39:0.51:0.53:0.50:0.58:0.61:0.65:0.62:0.66"] = 465, -- Thelsamar, Refuge Pointe, Aerie Peak, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.53:0.39:0.45:0.44:0.44:0.55"] = 254, -- Thelsamar, Menethil Harbor, Southshore
				["0.53:0.39:0.51:0.53:0.44:0.55:0.48:0.61:0.51:0.64"] = 379, -- Thelsamar, Refuge Pointe, Southshore, Chillwind Camp, Thondoril River
				["0.53:0.39:0.47:0.41:0.41:0.27:0.52:0.28"] = 416, -- Thelsamar, Ironforge, Stormwind, Morgan's Vigil
				["0.53:0.39:0.45:0.44:0.44:0.55:0.50:0.58"] = 323, -- Thelsamar, Menethil Harbor, Southshore, Aerie Peak
				["0.53:0.39:0.47:0.35:0.41:0.27:0.50:0.25"] = 304, -- Thelsamar, Thorium Point, Stormwind, Lakeshire
				["0.53:0.39:0.47:0.41:0.48:0.61"] = 319, -- Thelsamar, Ironforge, Chillwind Camp

				-- Alliance: Thondroril River (Western Plaguelands)
				["0.51:0.64:0.48:0.61:0.50:0.58"] = 123, -- Thondroril River, Chillwind Camp, Aerie Peak
				["0.51:0.64:0.48:0.61"] = 59, -- Thondroril River, Chillwind Camp
				["0.51:0.64:0.48:0.61:0.47:0.41:0.47:0.35:0.41:0.27:0.41:0.07"] = 655, -- Thondroril River, Chillwind Camp, Ironforge, Thorium Point, Stormwind, Booty Bay
				["0.51:0.64:0.48:0.61:0.47:0.41:0.47:0.35:0.41:0.27:0.43:0.18"] = 550, -- Thondroril River, Chillwind Camp, Ironforge, Thorium Point, Stormwind, Rebel Camp
				["0.51:0.64:0.48:0.61:0.47:0.41:0.47:0.35:0.52:0.28"] = 443, -- Thondroril River, Chillwind Camp, Ironforge, Thorium Point, Morgan's Vigil
				["0.51:0.64:0.48:0.61:0.44:0.55"] = 135, -- Thondroril River, Chillwind Camp, Southshore
				["0.51:0.64:0.48:0.61:0.50:0.58:0.51:0.53:0.53:0.39"] = 365, -- Thondroril River, Chillwind Camp, Aerie Peak, Refuge Pointe, Thelsamar
				["0.51:0.64:0.48:0.61:0.47:0.41:0.47:0.35:0.52:0.28:0.55:0.19"] = 613, -- Thondroril River, Chillwind Camp, Ironforge, Thorium Point, Morgan's Vigil, Nethergarde Keep
				["0.51:0.64:0.61:0.65:0.58:0.94"] = 433, -- Thondroril River, Light's Hope Chapel, Shattered Sun Staging Area
				["0.51:0.64:0.48:0.61:0.47:0.41:0.47:0.35:0.41:0.27"] = 471, -- Thondroril River, Chillwind Camp, Ironforge, Thorium Point, Stormwind
				["0.51:0.64:0.48:0.61:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25:0.47:0.21"] = 534, -- Thondroril River, Chillwind Camp, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire, Darkshire
				["0.51:0.64:0.48:0.61:0.47:0.41:0.47:0.35:0.41:0.27:0.39:0.20"] = 534, -- Thondroril River, Chillwind Camp, Ironforge, Thorium Point, Stormwind, Sentinel Hill
				["0.51:0.64:0.48:0.61:0.47:0.41:0.47:0.35"] = 359, -- Thondroril River, Chillwind Camp, Ironforge, Thorium Point
				["0.51:0.64:0.48:0.61:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25"] = 476, -- Thondroril River, Chillwind Camp, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire
				["0.51:0.64:0.48:0.61:0.47:0.41"] = 312, -- Thondroril River, Chillwind Camp, Ironforge
				["0.51:0.64:0.48:0.61:0.44:0.55:0.45:0.44"] = 242, -- Thondroril River, Chillwind Camp, Southshore, Menethil Harbor
				["0.51:0.64:0.48:0.61:0.50:0.58:0.51:0.53"] = 195, -- Thondroril River, Chillwind Camp, Aerie Peak, Refuge Pointe
				["0.51:0.64:0.61:0.65"] = 98, -- Thondroril River, Light's Hope Chapel (Sexy Steven reported 27)
				["0.51:0.64:0.61:0.65:0.61:0.73"] = 197, -- Thondroril River, Light's Hope Chapel, Zul'Aman
				["0.51:0.64:0.61:0.65:0.62:0.66"] = 165, -- Thondoril River, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.51:0.64:0.48:0.61:0.47:0.41:0.47:0.35:0.41:0.27:0.55:0.19"] = 634, -- Thondoril River, Chillwind Camp, Ironforge, Thorium Point, Stormwind, Nethergarde Keep
				["0.51:0.64:0.48:0.61:0.44:0.55:0.51:0.53"] = 206, -- Thondoril River, Chillwind Camp, Southshore, Refuge Pointe
				["0.51:0.64:0.48:0.61:0.47:0.41:0.41:0.27"] = 485, -- Thondoril River, Chillwind Camp, Ironforge, Stormwind
				["0.51:0.64:0.48:0.61:0.47:0.41:0.41:0.27:0.41:0.07"] = 669, -- Thondoril River, Chillwind Camp, Ironforge, Stormwind, Booty Bay
				["0.51:0.64:0.48:0.61:0.47:0.41:0.41:0.27:0.47:0.21"] = 587, -- Thondroril, Zugwindlager, Eisenschmiede, Sturmwind, Dunkelhain

				-- Alliance: Thorium Point (Searing Gorge)
				["0.47:0.35:0.41:0.27:0.41:0.07"] = 310, -- Thorium Point, Stormwind, Booty Bay
				["0.47:0.35:0.41:0.27:0.43:0.18"] = 206, -- Thorium Point, Stormwind, Rebel Camp
				["0.47:0.35:0.41:0.27:0.39:0.20"] = 190, -- Thorium Point, Stormwind, Sentinel Hill
				["0.47:0.35:0.41:0.27"] = 126, -- Thorium Point, Stormwind
				["0.47:0.35:0.52:0.28:0.50:0.25:0.47:0.21"] = 181, -- Thorium Point, Morgan's Vigil, Lakeshire, Darkshire
				["0.47:0.35:0.52:0.28:0.55:0.19"] = 260, -- Thorium Point, Morgan's Vigil, Nethergarde Keep
				["0.47:0.35:0.52:0.28:0.50:0.25"] = 122, -- Thorium Point, Morgan's Vigil, Lakeshire
				["0.47:0.35:0.52:0.28"] = 90, -- Thorium Point, Morgan's Vigil
				["0.47:0.35:0.53:0.39"] = 88, -- Thorium Point, Thelsamar
				["0.47:0.35:0.47:0.41"] = 94, -- Thorium Point, Ironforge
				["0.47:0.35:0.47:0.41:0.45:0.44"] = 159, -- Thorium Point, Ironforge, Menethil Harbor
				["0.47:0.35:0.53:0.39:0.51:0.53"] = 251, -- Thorium Point, Thelsamar, Refuge Pointe
				["0.47:0.35:0.47:0.41:0.44:0.55"] = 261, -- Thorium Point, Ironforge, Southshore (was 370, changed by Yannick Jacoby)
				["0.47:0.35:0.53:0.39:0.51:0.53:0.50:0.58"] = 323, -- Thorium Point, Thelsamar, Refuge Pointe, Aerie Peak
				["0.47:0.35:0.47:0.41:0.48:0.61"] = 302, -- Thorium Point, Ironforge, Chillwind Camp
				["0.47:0.35:0.47:0.41:0.61:0.65"] = 398, -- Thorium Point, Ironforge, Light's Hope Chapel
				["0.47:0.35:0.47:0.41:0.61:0.65:0.61:0.73"] = 495, -- Thorium Point, Ironforge, Light's Hope Chapel, Zul'Aman
				["0.47:0.35:0.41:0.27:0.47:0.21"] = 228, -- Thorium Point, Stormwind, Darkshire
				["0.47:0.35:0.41:0.27:0.55:0.19"] = 289, -- Thorium Point, Stormwind, Nethergarde Keep
				["0.47:0.35:0.41:0.27:0.50:0.25"] = 224, -- Thorium Point, Stormwind, Lakeshire
				["0.47:0.35:0.47:0.41:0.58:0.94"] = 155, -- Thorium Point, Ironforge, Shattered Sun Staging Area
				["0.47:0.35:0.47:0.41:0.48:0.61:0.51:0.64"] = 355, -- Thorium Point, Ironforge, Chillwind Camp, Thondroril River
				["0.47:0.35:0.47:0.41:0.61:0.65:0.62:0.66"] = 463, -- Thorium Point, Ironforge, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.47:0.35:0.47:0.41:0.44:0.55:0.50:0.58"] = 330, -- Thorium Point, Ironforge, Southshore, Aerie Peak
				["0.47:0.35:0.47:0.41:0.51:0.53:0.50:0.58"] = 322, -- Thoriumspitze, Eisenschmiede, Die Zuflucht, Nistgipfel
				["0.47:0.35:0.47:0.41:0.51:0.53"] = 250, -- Thorium Point, Ironforge, Refuge Pointe

				-- Alliance: Zul'Aman (Ghostlands)
				["0.61:0.73:0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27"] = 631, -- Zul'Aman, Light's Hope Chapel, Ironforge, Thorium Point, Stormwind
				["0.61:0.73:0.61:0.65:0.47:0.41"] = 473, -- Zul'Aman, Light's Hope Chapel, Ironforge
				["0.61:0.73:0.61:0.65"] = 107, -- Zul'Aman, Light's Hope Chapel
				["0.61:0.73:0.61:0.65:0.50:0.58:0.44:0.55"] = 328, -- Zul'Aman, Light's Hope Chapel, Aerie Peak, Southshore
				["0.61:0.73:0.61:0.65:0.48:0.61"] = 253, -- Zul'Aman, Light's Hope Chapel, Chillwind Camp
				["0.61:0.73:0.61:0.65:0.50:0.58:0.51:0.53"] = 337, -- Zul'Aman, Light's Hope Chapel, Aerie Peak, Refuge Pointe
				["0.61:0.73:0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25:0.47:0.21"] = 696, -- Zul'Aman, Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire, Darkshire
				["0.61:0.73:0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.43:0.18"] = 710, -- Zul'Aman, Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Rebel Camp
				["0.61:0.73:0.61:0.65:0.50:0.58:0.44:0.55:0.45:0.44"] = 436, -- Zul'Aman, Light's Hope Chapel, Aerie Peak, Southshore, Menethil Harbor
				["0.61:0.73:0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28:0.55:0.19"] = 775, -- Zul'Aman, Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil, Nethergarde Keep
				["0.61:0.73:0.61:0.65:0.50:0.58"] = 266, -- Zul'Aman, Light's Hope Chapel, Aerie Peak
				["0.61:0.73:0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.41:0.07"] = 818, -- Zul'Aman, Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Booty Bay
				["0.61:0.73:0.61:0.65:0.50:0.58:0.51:0.53:0.53:0.39"] = 506, -- Zul'Aman, Light's Hope Chapel, Aerie Peak, Refuge Pointe, Thelsamar
				["0.61:0.73:0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28:0.50:0.25"] = 637, -- Zul'Aman, Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil, Lakeshire
				["0.61:0.73:0.61:0.65:0.47:0.41:0.47:0.35:0.52:0.28"] = 605, -- Zul'Aman, Light's Hope Chapel, Ironforge, Thorium Point, Morgan's Vigil
				["0.61:0.73:0.61:0.65:0.47:0.41:0.47:0.35:0.41:0.27:0.39:0.20"] = 695, -- Zul'Aman, Light's Hope Chapel, Ironforge, Thorium Point, Stormwind, Sentinel Hill
				["0.61:0.73:0.58:0.94"] = 252, -- Zul'Aman, Shattered Sun Staging Area
				["0.61:0.73:0.61:0.65:0.47:0.41:0.47:0.35"] = 521, -- Zul'Aman, Light's Hope Chapel, Ironforge, Thorium Point
				["0.61:0.73:0.61:0.65:0.47:0.41:0.41:0.27:0.55:0.19"] = 809, -- Zul'Aman, Light's Hope Chapel, Ironforge, Stormwind, Nethergarde Keep
				["0.61:0.73:0.61:0.65:0.47:0.41:0.41:0.27"] = 647, -- Zul'Aman, Light's Hope Chapel, Ironforge, Stormwind
				["0.61:0.73:0.61:0.65:0.62:0.66"] = 175, -- Zul'Aman, Light's Hope Chapel, Acherus: The Ebon Hold
				["0.61:0.73:0.61:0.65:0.51:0.64"] = 207, -- Zul'Aman, Light's Hope Chapel, Thondoril River

			},

			-- Alliance: Kalimdor
			[1] = {

				-- Alliance: Blood Watch (Bloodmyst Isle)
				["0.22:0.82:0.21:0.74"] = 77, -- Blood Watch, The Exodar (Nick Bijl reported 110)

				-- Alliance: The Exodar (The Exodar)
				["0.21:0.74:0.22:0.82"] = 77, -- The Exodar, Blood Watch

				-- Alliance: Astranaar (Ashenvale)
				["0.46:0.60:0.39:0.60:0.40:0.49:0.31:0.31"] = 511, -- Astranaar, Stonetalon Peak, Nijel's Point, Feathermoon
				["0.46:0.60:0.61:0.45:0.60:0.19:0.42:0.21"] = 631, -- Astranaar, Ratchet, Gadgetzan, Cenarion Hold
				["0.46:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 538, -- Astranaar, Ratchet, Gadgetzan, Marshal's Refuge
				["0.46:0.60:0.61:0.45:0.64:0.33:0.48:0.30"] = 457, -- Astranaar, Ratchet, Theramore, Thalanaar
				["0.46:0.60:0.61:0.45:0.64:0.33:0.58:0.30"] = 357, -- Astranaar, Ratchet, Theramore, Mudsprocket
				["0.46:0.60:0.64:0.33"] = 388, -- Astranaar, Theramore
				["0.46:0.60:0.61:0.45:0.60:0.19"] = 434, -- Astranaar, Ratchet, Gadgetzan
				["0.46:0.60:0.61:0.45"] = 194, -- Astranaar, Ratchet
				["0.46:0.60:0.39:0.60:0.40:0.49"] = 279, -- Astranaar, Stonetalon Peak, Nijel's Point
				["0.46:0.60:0.39:0.60"] = 153, -- Astranaar, Stonetalon Peak
				["0.46:0.60:0.61:0.60"] = 148, -- Astranaar, Talrendis Point
				["0.46:0.60:0.58:0.61"] = 134, -- Astranaar, Forest Song
				["0.46:0.60:0.50:0.65"] = 79, -- Astranaar, Emerald Sanctuary
				["0.46:0.60:0.50:0.65:0.53:0.74:0.65:0.77"] = 296, -- Astranaar, Emerald Sanctuary, Talonbranch Glade, Everlook
				["0.46:0.60:0.50:0.65:0.53:0.74"] = 206, -- Astranaar, Emerald Sanctuary, Talonbranch Glade
				["0.46:0.60:0.50:0.65:0.53:0.74:0.55:0.79"] = 265, -- Astranaar, Emerald Sanctuary, Talonbranch Glade, Moonglade
				["0.46:0.60:0.43:0.75"] = 149, -- Astranaar, Auberdine
				["0.46:0.60:0.43:0.75:0.42:0.84"] = 233, -- Astranaar, Auberdine, Rut'theran Village
				["0.46:0.60:0.43:0.75:0.53:0.74"] = 338, -- Astranaar, Auberdine, Talonbranch Glade
				["0.46:0.60:0.43:0.75:0.40:0.49"] = 440, -- Astranaar, Auberdine, Nijel's Point
				["0.46:0.60:0.61:0.60:0.65:0.77"] = 327, -- Astranaar, Talrendis Point, Everlook
				["0.46:0.60:0.43:0.75:0.31:0.31"] = 621, -- Astranaar, Auberdine, Feathermoon
				["0.46:0.60:0.39:0.60:0.40:0.49:0.31:0.31:0.48:0.30"] = 666, -- Astranaar, Stonetalon Peak, Nijel's Point, Feathermoon, Thalanaar
				["0.46:0.60:0.43:0.75:0.53:0.74:0.65:0.77"] = 427, -- Astranaar, Auberdine, Talonbranch Glade, Everlook
				["0.46:0.60:0.64:0.33:0.48:0.30"] = 551, -- Astranaar, Theramore, Thalanaar
				["0.46:0.60:0.43:0.75:0.55:0.79"] = 300, -- Astranaar, Auberdine, Moonglade
				["0.46:0.60:0.64:0.33:0.60:0.19"] = 545, -- Astranaar, Theramore, Gadgetzan
				["0.46:0.60:0.61:0.45:0.60:0.19:0.48:0.30"] = 611, -- Astranaar, Ratchet, Gadgetzan, Thalanaar

				-- Alliance: Auberdine (Darkshore)
				["0.43:0.75:0.31:0.31"] = 473, -- Auberdine, Feathermoon
				["0.43:0.75:0.31:0.31:0.42:0.21"] = 623, -- Auberdine, Feathermoon, Cenarion Hold
				["0.43:0.75:0.64:0.33:0.60:0.19:0.50:0.24"] = 700, -- Auberdine, Theramore, Gadgetzan, Marshal's Refuge
				["0.43:0.75:0.64:0.33:0.48:0.30"] = 602, -- Auberdine, Theramore, Thalanaar
				["0.43:0.75:0.64:0.33:0.58:0.30"] = 503, -- Auberdine, Theramore, Mudsprocket
				["0.43:0.75:0.64:0.33"] = 443, -- Auberdine, Theramore
				["0.43:0.75:0.64:0.33:0.60:0.19"] = 596, -- Auberdine, Theramore, Gadgetzan
				["0.43:0.75:0.46:0.60:0.61:0.45"] = 361, -- Auberdine, Astranaar, Ratchet
				["0.43:0.75:0.40:0.49"] = 291, -- Auberdine, Nijel's Point
				["0.43:0.75:0.39:0.60"] = 181, -- Auberdine, Stonetalon Peak
				["0.43:0.75:0.46:0.60"] = 168, -- Auberdine, Astranaar
				["0.43:0.75:0.46:0.60:0.50:0.65"] = 246, -- Auberdine, Astranaar, Emerald Sanctuary
				["0.43:0.75:0.46:0.60:0.58:0.61"] = 302, -- Auberdine, Astranaar, Forest Song
				["0.43:0.75:0.61:0.60"] = 300, -- Auberdine, Talrendis Point
				["0.43:0.75:0.55:0.79:0.65:0.77"] = 270, -- Auberdine, Moonglade, Everlook
				["0.43:0.75:0.53:0.74"] = 190, -- Auberdine, Talonbranch Glade
				["0.43:0.75:0.55:0.79"] = 151, -- Auberdine, Moonglade
				["0.43:0.75:0.42:0.84"] = 84, -- Auberdine, Rut'theran Village
				["0.43:0.75:0.53:0.74:0.65:0.77"] = 279, -- Auberdine, Talonbranch Glade, Everlook
				["0.43:0.75:0.31:0.31:0.48:0.30"] = 627, -- Auberdine, Feathermoon, Thalanaar
				["0.43:0.75:0.64:0.33:0.61:0.45"] = 552, -- Auberdine, Theramore, Ratchet
				["0.43:0.75:0.46:0.60:0.61:0.45:0.60:0.19:0.48:0.30:0.58:0.30"] = 863, -- Auberdine, Astranaar, Ratchet, Gadgetzan, Thalanaar, Mudsprocket
				["0.43:0.75:0.61:0.60:0.58:0.61"] = 326, -- Auberdine, Talrendis Point, Forest Song
				["0.43:0.75:0.61:0.60:0.65:0.77"] = 478, -- Auberdine, Talrendis Point, Everlook
				["0.43:0.75:0.46:0.60:0.61:0.45:0.60:0.19"] = 602, -- Auberdine, Astranaar, Trinquete, Gadgetzan
				["0.43:0.75:0.53:0.74:0.50:0.65"] = 293, -- Auberdine, Talonbranch Glade, Emerald Sanctuary
				["0.43:0.75:0.64:0.33:0.60:0.19:0.42:0.21"] = 793, -- Auberdine, Theramore, Gadgetzan, Cenarion Hold
				["0.43:0.75:0.46:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 706, -- Auberdine, Astranaar, Ratchet, Gadgetzan, Marshal's Refuge
				["0.43:0.75:0.61:0.60:0.58:0.61:0.50:0.65"] = 432, -- Auberdine, Talrendisspitze, Waldeslied, Smaragdrefugium

				-- Alliance: Cenarion Hold (Silithus)
				["0.42:0.21:0.31:0.31"] = 175, -- Cenarion Hold, Feathermoon
				["0.42:0.21:0.31:0.31:0.48:0.30"] = 329, -- Cenarion Hold, Feathermoon, Thalanaar
				["0.42:0.21:0.50:0.24"] = 92, -- Cenarion Hold, Marshal's Refuge
				["0.42:0.21:0.60:0.19"] = 189, -- Cenarion Hold, Gadgetzan
				["0.42:0.21:0.60:0.19:0.64:0.33:0.58:0.30"] = 399, -- Cenarion Hold, Gadgetzan, Theramore, Mudsprocket
				["0.42:0.21:0.60:0.19:0.64:0.33"] = 342, -- Cenarion Hold, Gadgetzan, Theramore
				["0.42:0.21:0.60:0.19:0.61:0.45"] = 435, -- Cenarion Hold, Gadgetzan, Ratchet
				["0.42:0.21:0.31:0.31:0.40:0.49"] = 402, -- Cenarion Hold, Feathermoon, Nijel's Point
				["0.42:0.21:0.31:0.31:0.40:0.49:0.39:0.60"] = 521, -- Cenarion Hold, Feathermoon, Nijel's Point, Stonetalon Peak
				["0.42:0.21:0.60:0.19:0.61:0.45:0.46:0.60"] = 630, -- Cenarion Hold, Gadgetzan, Ratchet, Astranaar
				["0.42:0.21:0.60:0.19:0.61:0.45:0.61:0.60:0.58:0.61:0.50:0.65"] = 694, -- Cenarion Hold, Gadgetzan, Ratchet, Talrendis Point, Forest Song, Emerald Sanctuary
				["0.42:0.21:0.60:0.19:0.61:0.45:0.61:0.60:0.58:0.61"] = 587, -- Cenarion Hold, Gadgetzan, Ratchet, Talrendis Point, Forest Song
				["0.42:0.21:0.60:0.19:0.61:0.45:0.61:0.60"] = 562, -- Cenarion Hold, Gadgetzan, Ratchet, Talrendis Point
				["0.42:0.21:0.60:0.19:0.61:0.45:0.61:0.60:0.65:0.77"] = 740, -- Cenarion Hold, Gadgetzan, Ratchet, Talrendis Point, Everlook
				["0.42:0.21:0.60:0.19:0.61:0.45:0.61:0.60:0.58:0.61:0.50:0.65:0.53:0.74"] = 821, -- Cenarion Hold, Gadgetzan, Ratchet, Talrendis Point, Forest Song, Emerald Sanctuary, Talonbranch Glade
				["0.42:0.21:0.31:0.31:0.43:0.75:0.55:0.79"] = 793, -- Cenarion Hold, Feathermoon, Auberdine, Moonglade
				["0.42:0.21:0.31:0.31:0.43:0.75"] = 642, -- Cenarion Hold, Feathermoon, Auberdine
				["0.42:0.21:0.31:0.31:0.43:0.75:0.42:0.84"] = 726, -- Cenarion Hold, Feathermoon, Auberdine, Rut'theran Village
				["0.42:0.21:0.60:0.19:0.61:0.45:0.46:0.60:0.50:0.65"] = 709, -- Cenarion Hold, Gadgetzan, Ratchet, Astranaar, Emerald Sanctuary
				["0.42:0.21:0.31:0.31:0.43:0.75:0.55:0.79:0.65:0.77"] = 911, -- Cenarion Hold, Feathermoon, Auberdine, Moonglade, Everlook
				["0.42:0.21:0.60:0.19:0.48:0.30"] = 366, -- Cenarion Hold, Gadgetzan, Thalanaar
				["0.42:0.21:0.31:0.31:0.43:0.75:0.53:0.74"] = 832, -- Cenarion Hold, Feathermoon, Auberdine, Talonbranch Glade
				["0.42:0.21:0.60:0.19:0.64:0.33:0.40:0.49"] = 668, -- Cenarion Hold, Gadgetzan, Theramore, Nijel's Point
				["0.42:0.21:0.60:0.19:0.64:0.33:0.43:0.75:0.42:0.84"] = 860, -- Cenarion Hold, Gadgetzan, Theramore, Auberdine, Rut'theran Village
				["0.42:0.21:0.60:0.19:0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74:0.55:0.79"] = 895, -- Cenarion Hold, Gadgetzan, Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade, Moonglade
				["0.42:0.21:0.60:0.19:0.64:0.33:0.46:0.60:0.50:0.65"] = 784, -- Cenarion Hold, Gadgetzan, Theramore, Astranaar, Emerald Sanctuary
				["0.42:0.21:0.60:0.19:0.61:0.45:0.46:0.60:0.43:0.75:0.42:0.84"] = 862, -- Cenarion Hold, Gadgetzan, Ratchet, Astranaar, Auberdine, Rut'theran Village
				["0.42:0.21:0.60:0.19:0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74:0.65:0.77"] = 926, -- Cenarion Hold, Gadgetzan, Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade, Everlook
				["0.42:0.21:0.31:0.31:0.43:0.75:0.53:0.74:0.65:0.77"] = 920, -- Cenarion Hold, Feathermoon, Auberdine, Talonbranch Glade, Everlook

				-- Alliance: Emerald Sanctuary (Felwood)
				["0.50:0.65:0.46:0.60:0.39:0.60:0.40:0.49:0.31:0.31"] = 592, -- Emerald Sanctuary, Astranaar, Stonetalon Peak, Nijel's Point, Feathermoon
				["0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.60:0.19:0.42:0.21"] = 696, -- Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Gadgetzan, Cenarion Hold
				["0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 602, -- Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Gadgetzan, Marshal's Refuge
				["0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.64:0.33:0.48:0.30"] = 523, -- Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Theramore, Thalanaar
				["0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.60:0.19"] = 499, -- Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Gadgetzan
				["0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.64:0.33:0.58:0.30"] = 424, -- Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Theramore, Mudsprocket
				["0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.64:0.33"] = 361, -- Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Theramore
				["0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45"] = 263, -- Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet
				["0.50:0.65:0.46:0.60:0.39:0.60:0.40:0.49"] = 361, -- Emerald Sanctuary, Astranaar, Stonetalon Peak, Nijel's Point
				["0.50:0.65:0.46:0.60:0.39:0.60"] = 234, -- Emerald Sanctuary, Astranaar, Stonetalon Peak
				["0.50:0.65:0.46:0.60"] = 81, -- Emerald Sanctuary, Astranaar
				["0.50:0.65:0.58:0.61"] = 103, -- Emerald Sanctuary, Forest Song
				["0.50:0.65:0.58:0.61:0.61:0.60"] = 128, -- Emerald Sanctuary, Forest Song, Talrendis Point
				["0.50:0.65:0.53:0.74:0.65:0.77"] = 218, -- Emerald Sanctuary, Talonbranch Glade, Everlook
				["0.50:0.65:0.53:0.74:0.55:0.79"] = 187, -- Emerald Sanctuary, Talonbranch Glade, Moonglade
				["0.50:0.65:0.53:0.74"] = 128, -- Emerald Sanctuary, Talonbranch Glade
				["0.50:0.65:0.46:0.60:0.43:0.75"] = 229, -- Emerald Sanctuary, Astranaar, Auberdine
				["0.50:0.65:0.46:0.60:0.43:0.75:0.42:0.84"] = 313, -- Emerald Sanctuary, Astranaar, Auberdine, Rut'theran Village
				["0.50:0.65:0.46:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 618, -- Emerald Sanctuary, Astranaar, Ratchet, Gadgetzan, Marshal's Refuge
				["0.50:0.65:0.46:0.60:0.61:0.45:0.60:0.19"] = 514, -- Emerald Sanctuary, Astranaar, Ratchet, Gadgetzan
				["0.50:0.65:0.46:0.60:0.61:0.45"] = 274, -- Emerald Sanctuary, Astranaar, Ratchet
				["0.50:0.65:0.46:0.60:0.61:0.45:0.64:0.33"] = 374, -- Emerald Sanctuary, Astranaar, Ratchet, Theramore
				["0.50:0.65:0.53:0.74:0.43:0.75"] = 297, -- Emerald Sanctuary, Talonbranch Glade, Auberdine
				["0.50:0.65:0.53:0.74:0.43:0.75:0.42:0.84"] = 381, -- Emerald Sanctuary, Talonbranch Glade, Auberdine, Rut'theran Village
				["0.50:0.65:0.46:0.60:0.61:0.60"] = 228, -- Emerald Sanctuary, Astranaar, Talrendis Point
				["0.50:0.65:0.46:0.60:0.61:0.45:0.64:0.33:0.48:0.30"] = 537, -- Emerald Sanctuary, Astranaar, Ratchet, Theramore, Thalanaar
				["0.50:0.65:0.46:0.60:0.43:0.75:0.31:0.31"] = 701, -- Emerald Sanctuary, Astranaar, Auberdine, Feathermoon
				["0.50:0.65:0.46:0.60:0.61:0.45:0.60:0.19:0.42:0.21"] = 711, -- Emerald Sanctuary, Astranaar, Ratchet, Gadgetzan, Cenarion Hold
				["0.50:0.65:0.46:0.60:0.64:0.33:0.60:0.19:0.50:0.24"] = 728, -- Emerald Sanctuary, Astranaar, Theramore, Gadgetzan, Marshal's Refuge
				["0.50:0.65:0.46:0.60:0.64:0.33"] = 468, -- Emerald Sanctuary, Astranaar, Theramore
				["0.50:0.65:0.46:0.60:0.64:0.33:0.60:0.19"] = 624, -- Emerald Sanctuary, Astranaar, Theramore, Gadgetzan
				["0.50:0.65:0.53:0.74:0.43:0.75:0.64:0.33:0.61:0.45"] = 848, -- Emerald Sanctuary, Talonbranch Glade, Auberdine, Theramore, Ratchet
				["0.50:0.65:0.58:0.61:0.61:0.60:0.65:0.77"] = 306, -- Emerald Sanctuary, Forest Song, Talrendis Point, Everlook
				["0.50:0.65:0.53:0.74:0.43:0.75:0.31:0.31"] = 769, -- Sanctuaire d'émeraude, Clairière de Griffebranche, Auberdine, Pennelune
				["0.50:0.65:0.46:0.60:0.43:0.75:0.40:0.49"] = 520, -- Emerald Sanctuary, Astranaar, Auberdine, Nijel's Point
				["0.50:0.65:0.53:0.74:0.43:0.75:0.64:0.33:0.60:0.19:0.50:0.24"] = 996, -- Emerald Sanctuary, Talonbranch Glade, Auberdine, Theramore, Gadgetzan, Marshal's Refuge
				["0.50:0.65:0.53:0.74:0.43:0.75:0.64:0.33:0.58:0.30"] = 799, -- Emerald Sanctuary, Talonbranch Glade, Auberdine, Theramore, Mudsprocket
				["0.50:0.65:0.46:0.60:0.61:0.45:0.64:0.33:0.58:0.30"] = 437, -- Emerald Sanctuary, Astranaar, Ratchet, Theramore, Mudsprocket
				["0.50:0.65:0.58:0.61:0.61:0.60:0.43:0.75"] = 429, -- Smaragdrefugium, Waldeslied, Talrendisspitze, Auberdine
				["0.50:0.65:0.46:0.60:0.43:0.75:0.55:0.79:0.65:0.77"] = 498, -- Sanctuaire d'émeraude, Astranaar, Auberdine, Reflet-de-Lune, Long-guet, Long-guet

				-- Alliance: Everlook (Winterspring)
				["0.65:0.77:0.55:0.79:0.43:0.75:0.31:0.31"] = 724, -- Everlook, Moonglade, Auberdine, Feathermoon
				["0.65:0.77:0.61:0.60:0.61:0.45:0.60:0.19:0.42:0.21"] = 734, -- Everlook, Talrendis Point, Ratchet, Gadgetzan, Cenarion Hold
				["0.65:0.77:0.61:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 641, -- Everlook, Talrendis Point, Ratchet, Gadgetzan, Marshal's Refuge
				["0.65:0.77:0.61:0.60:0.61:0.45:0.64:0.33:0.48:0.30"] = 562, -- Everlook, Talrendis Point, Ratchet, Theramore, Thalanaar
				["0.65:0.77:0.61:0.60:0.61:0.45:0.64:0.33:0.58:0.30"] = 462, -- Everlook, Talrendis Point, Ratchet, Theramore, Mudsprocket
				["0.65:0.77:0.61:0.60:0.61:0.45:0.64:0.33"] = 399, -- Everlook, Talrendis Point, Ratchet, Theramore
				["0.65:0.77:0.61:0.60:0.61:0.45:0.60:0.19"] = 537, -- Everlook, Talrendis Point, Ratchet, Gadgetzan
				["0.65:0.77:0.61:0.60:0.61:0.45"] = 301, -- Everlook, Talrendis Point, Ratchet
				["0.65:0.77:0.55:0.79:0.43:0.75:0.40:0.49"] = 542, -- Everlook, Moonglade, Auberdine, Nijel's Point
				["0.65:0.77:0.55:0.79:0.43:0.75:0.39:0.60"] = 433, -- Everlook, Moonglade, Auberdine, Stonetalon Peak
				["0.65:0.77:0.53:0.74:0.50:0.65:0.46:0.60"] = 295, -- Everlook, Talonbranch Glade, Emerald Sanctuary, Astranaar
				["0.65:0.77:0.53:0.74:0.50:0.65"] = 216, -- Everlook, Talonbranch Glade, Emerald Sanctuary
				["0.65:0.77:0.61:0.60:0.58:0.61"] = 191, -- Everlook, Talrendis Point, Forest Song
				["0.65:0.77:0.61:0.60"] = 167, -- Everlook, Talrendis Point
				["0.65:0.77:0.55:0.79"] = 111, -- Everlook, Moonglade
				["0.65:0.77:0.53:0.74"] = 107, -- Everlook, Talonbranch Glade
				["0.65:0.77:0.55:0.79:0.43:0.75"] = 252, -- Everlook, Moonglade, Auberdine
				["0.65:0.77:0.55:0.79:0.43:0.75:0.42:0.84"] = 335, -- Everlook, Moonglade, Auberdine, Rut'theran Village
				["0.65:0.77:0.53:0.74:0.43:0.75"] = 277, -- Everlook, Talonbranch Glade, Auberdine
				["0.65:0.77:0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 834, -- Everlook, Talonbranch Glade, Emerald Sanctuary, Astranaar, Ratchet, Gadgetzan, Marshal's Refuge
				["0.65:0.77:0.55:0.79:0.43:0.75:0.31:0.31:0.42:0.21"] = 874, -- Everlook, Moonglade, Auberdine, Feathermoon, Cenarion Hold
				["0.65:0.77:0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45:0.64:0.33"] = 590, -- Everlook, Talonbranch Glade, Emerald Sanctuary, Astranaar, Ratchet, Theramore
				["0.65:0.77:0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45"] = 489, -- Everlook, Talonbranch Glade, Emerald Sanctuary, Astranaar, Ratchet
				["0.65:0.77:0.55:0.79:0.43:0.75:0.64:0.33:0.60:0.19"] = 847, -- Everlook, Moonglade, Auberdine, Theramore, Gadgetzan
				["0.65:0.77:0.61:0.60:0.61:0.45:0.64:0.33:0.48:0.30:0.31:0.31"] = 740, -- Everlook, Talrendis Point, Ratchet, Theramore, Thalanaar, Feathermoon
				["0.65:0.77:0.53:0.74:0.43:0.75:0.42:0.84"] = 361, -- Everlook, Talonbranch Glade, Auberdine, Rut'theran Village
				["0.65:0.77:0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45:0.64:0.33:0.48:0.30"] = 752, -- Long-guet, Clairière de Griffebranche, Sanctuaire d'émeraude, Astranaar, Cabestan, Theramore, Thalanaar
				["0.65:0.77:0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45:0.60:0.19"] = 730, -- Everlook, Talonbranch Glade, Emerald Sanctuary, Astranaar, Ratchet, Gadgetzan
				["0.65:0.77:0.61:0.60:0.46:0.60"] = 316, -- Everlook, Talrendis Point, Astranaar
				["0.65:0.77:0.55:0.79:0.43:0.75:0.46:0.60"] = 419, -- Everlook, Moonglade, Auberdine, Astranaar
				["0.65:0.77:0.61:0.60:0.46:0.60:0.39:0.60"] = 470, -- Everlook, Talrendis Point, Astranaar, Stonetalon Peak
				["0.65:0.77:0.53:0.74:0.50:0.65:0.46:0.60:0.39:0.60"] = 450, -- Everlook, Talonbranch Glade, Emerald Sanctuary, Astranaar, Stonetalon Peak
				["0.65:0.77:0.61:0.60:0.61:0.45:0.64:0.33:0.40:0.49"] = 733, -- Everlook, Talrendis Point, Ratchet, Theramore, Nijel's Point
				["0.65:0.77:0.53:0.74:0.50:0.65:0.58:0.61"] = 319, -- Everlook, Talonbranch Glade, Emerald Sanctuary, Forest Song
				["0.65:0.77:0.53:0.74:0.43:0.75:0.31:0.31"] = 749, -- Everlook, Talonbranch Glade, Auberdine, Feathermoon
				["0.65:0.77:0.61:0.60:0.46:0.60:0.50:0.65"] = 394, -- Everlook, Talrendis Point, Astranaar, Emerald Sanctuary
				["0.65:0.77:0.53:0.74:0.43:0.75:0.64:0.33:0.60:0.19"] = 872, -- Everlook, Talonbranch Glade, Auberdine, Theramore, Gadgetzan
				["0.65:0.77:0.55:0.79:0.43:0.75:0.46:0.60:0.50:0.65"] = 497, -- Everlook, Moonglade, Auberdine, Astranaar, Emerald Sanctuary
				["0.65:0.77:0.55:0.79:0.43:0.75:0.64:0.33:0.60:0.19:0.50:0.24"] = 951, -- Everlook, Moonglade, Auberdine, Theramore, Gadgetzan, Marshal's Refuge
				["0.65:0.77:0.55:0.79:0.43:0.75:0.64:0.33"] = 694, -- Everlook, Moonglade, Auberdine, Theramore
				["0.65:0.77:0.53:0.74:0.50:0.65:0.46:0.60:0.39:0.60:0.40:0.49:0.31:0.31"] = 807, -- Everlook, Talonbranch Glade, Emerald Sanctuary, Astranaar, Stonetalon Peak, Nijel's Point, Feathermoon
				["0.65:0.77:0.61:0.60:0.58:0.61:0.50:0.65"] = 298, -- Everlook, Talrendis Point, Forest Song, Emerald Sanctuary
				["0.65:0.77:0.53:0.74:0.43:0.75:0.40:0.49"] = 568, -- Everlook, Talonbranch Glade, Auberdine, Nijel's Point
				["0.65:0.77:0.61:0.60:0.46:0.60:0.43:0.75:0.42:0.84"] = 549, -- Everlook, Talrendis Point, Astranaar, Auberdine, Rut'theran Village
				["0.65:0.77:0.55:0.79:0.43:0.75:0.46:0.60:0.61:0.45"] = 612, -- Everlook, Moonglade, Auberdine, Astranaar, Ratchet
				["0.65:0.77:0.53:0.74:0.50:0.65:0.46:0.60:0.64:0.33:0.60:0.19"] = 840, -- Vista Eterna, Claro Ramaespolón, Santuario Esmeralda, Astranaar, Theramore, Gadgetzan
				["0.65:0.77:0.53:0.74:0.43:0.75:0.64:0.33"] = 720, -- Everlook, Talonbranch Glade, Auberdine, Theramore
				["0.65:0.77:0.53:0.74:0.43:0.75:0.31:0.31:0.42:0.21"] = 900, -- Vista Eterna, Claro Ramaespolón, Auberdine, Plumaluna, Fuerte Cenarion
				["0.65:0.77:0.53:0.74:0.43:0.75:0.46:0.60:0.58:0.61"] = 578, -- Everlook, Talonbranch Glade, Auberdine, Astranaar, Forest Song
				["0.65:0.77:0.55:0.79:0.43:0.75:0.46:0.60:0.58:0.61"] = 553, -- Круговзор, Лунная поляна, Аубердин, Астранаар, Лесная Песнь
				["0.65:0.77:0.61:0.60:0.64:0.33:0.60:0.19"] = 562, -- Ewige Warte, Talrendisspitze, Theramore, Gadgetzan,,This flight does not exist in the database.
				["0.65:0.77:0.55:0.79:0.43:0.75:0.64:0.33:0.61:0.45"] = 803, -- Everlook, Moonglade, Auberdine, Theramore, Ratchet

				-- Alliance: Feathermoon (Feralas)
				["0.31:0.31:0.42:0.21"] = 153, -- Feathermoon, Cenarion Hold
				["0.31:0.31:0.42:0.21:0.50:0.24"] = 242, -- Feathermoon, Cenarion Hold, Marshal's Refuge
				["0.31:0.31:0.48:0.30"] = 155, -- Feathermoon, Thalanaar
				["0.31:0.31:0.48:0.30:0.58:0.30"] = 240, -- Feathermoon, Thalanaar, Mudsprocket
				["0.31:0.31:0.48:0.30:0.58:0.30:0.64:0.33"] = 292, -- Feathermoon, Thalanaar, Mudsprocket, Theramore
				["0.31:0.31:0.48:0.30:0.60:0.19"] = 326, -- Feathermoon, Thalanaar, Gadgetzan
				["0.31:0.31:0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.45"] = 406, -- Feathermoon, Thalanaar, Mudsprocket, Theramore, Ratchet
				["0.31:0.31:0.40:0.49"] = 227, -- Feathermoon, Nijel's Point
				["0.31:0.31:0.40:0.49:0.39:0.60"] = 346, -- Feathermoon, Nijel's Point, Stonetalon Peak
				["0.31:0.31:0.40:0.49:0.39:0.60:0.46:0.60"] = 500, -- Feathermoon, Nijel's Point, Stonetalon Peak, Astranaar
				["0.31:0.31:0.40:0.49:0.39:0.60:0.46:0.60:0.50:0.65"] = 578, -- Feathermoon, Nijel's Point, Stonetalon Peak, Astranaar, Emerald Sanctuary
				["0.31:0.31:0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.60:0.58:0.61"] = 550, -- Feathermoon, Thalanaar, Mudsprocket, Theramore, Talrendis Point, Forest Song
				["0.31:0.31:0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.60"] = 524, -- Feathermoon, Thalanaar, Mudsprocket, Theramore, Talrendis Point
				["0.31:0.31:0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.60:0.65:0.77"] = 703, -- Feathermoon, Thalanaar, Mudsprocket, Theramore, Talrendis Point, Everlook
				["0.31:0.31:0.43:0.75:0.55:0.79"] = 618, -- Feathermoon, Auberdine, Moonglade
				["0.31:0.31:0.43:0.75:0.53:0.74"] = 657, -- Feathermoon, Auberdine, Talonbranch Glade
				["0.31:0.31:0.43:0.75"] = 468, -- Feathermoon, Auberdine
				["0.31:0.31:0.43:0.75:0.42:0.84"] = 552, -- Feathermoon, Auberdine, Rut'theran Village
				["0.31:0.31:0.48:0.30:0.64:0.33:0.61:0.45"] = 429, -- Feathermoon, Thalanaar, Theramore, Ratchet
				["0.31:0.31:0.40:0.49:0.64:0.33"] = 535, -- Feathermoon, Nijel's Point, Theramore
				["0.31:0.31:0.40:0.49:0.64:0.33:0.60:0.19"] = 690, -- Feathermoon, Nijel's Point, Theramore, Gadgetzan
				["0.31:0.31:0.42:0.21:0.60:0.19:0.64:0.33"] = 491, -- Feathermoon, Cenarion Hold, Gadgetzan, Theramore
				["0.31:0.31:0.48:0.30:0.60:0.19:0.50:0.24"] = 430, -- Feathermoon, Thalanaar, Gadgetzan, Marshal's Refuge
				["0.31:0.31:0.43:0.75:0.39:0.60"] = 649, -- Feathermoon, Auberdine, Stonetalon Peak
				["0.31:0.31:0.48:0.30:0.64:0.33:0.61:0.60:0.65:0.77"] = 724, -- Feathermoon, Thalanaar, Theramore, Talrendis Point, Everlook
				["0.31:0.31:0.43:0.75:0.55:0.79:0.65:0.77"] = 737, -- Feathermoon, Auberdine, Moonglade, Everlook
				["0.31:0.31:0.48:0.30:0.64:0.33"] = 314, -- Mondfederfeste, Thalanaar, Theramore
				["0.31:0.31:0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.45:0.46:0.60"] = 601, -- Feathermoon, Thalanaar, Mudsprocket, Theramore, Ratchet, Astranaar
				["0.31:0.31:0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.60:0.58:0.61:0.50:0.65"] = 656, -- Feathermoon, Thalanaar, Mudsprocket, Theramore, Talrendis Point, Forest Song, Emerald Sanctuary
				["0.31:0.31:0.48:0.30:0.60:0.19:0.61:0.45"] = 570, -- Feathermoon, Thalanaar, Gadgetzan, Ratchet
				["0.31:0.31:0.40:0.49:0.64:0.33:0.58:0.30"] = 598, -- Feathermoon, Nijel's Point, Theramore, Mudsprocket
				["0.31:0.31:0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.45:0.46:0.60:0.50:0.65"] = 680, -- Feathermoon, Thalanaar, Mudsprocket, Theramore, Ratchet, Astranaar, Emerald Sanctuary
				["0.31:0.31:0.42:0.21:0.60:0.19"] = 338, -- Feathermoon, Cenarion Hold, Gadgetzan
				["0.31:0.31:0.40:0.49:0.39:0.60:0.46:0.60:0.61:0.45"] = 694, -- Feathermoon, Nijel's Point, Stonetalon Peak, Astranaar, Ratchet
				["0.31:0.31:0.40:0.49:0.64:0.33:0.61:0.45"] = 649, -- Feathermoon, Nijel's Point, Theramore, Ratchet
				["0.31:0.31:0.40:0.49:0.64:0.33:0.60:0.19:0.50:0.24"] = 794, -- Feathermoon, Nijel's Point, Theramore, Gadgetzan, Marshal's Refuge
				["0.31:0.31:0.48:0.30:0.64:0.33:0.61:0.45:0.46:0.60:0.50:0.65"] = 701, -- Feathermoon, Thalanaar, Theramore, Ratchet, Astranaar, Emerald Sanctuary
				["0.31:0.31:0.48:0.30:0.64:0.33:0.61:0.45:0.46:0.60"] = 623, -- Feathermoon, Thalanaar, Theramore, Ratchet, Astranaar
				["0.31:0.31:0.48:0.30:0.64:0.33:0.61:0.45:0.46:0.60:0.58:0.61"] = 757, -- Feathermoon, Thalanaar, Theramore, Ratchet, Astranaar, Forest Song
				["0.31:0.31:0.48:0.30:0.64:0.33:0.61:0.60"] = 546, -- Feathermoon, Thalanaar, Theramore, Talrendis Point
				["0.31:0.31:0.43:0.75:0.53:0.74:0.65:0.77"] = 746, -- Feathermoon, Auberdine, Talonbranch Glade, Everlook
				["0.31:0.31:0.43:0.75:0.64:0.33:0.60:0.19:0.50:0.24"] = 1167, -- Feathermoon, Auberdine, Theramore, Gadgetzan, Marshal's Refuge
				["0.31:0.31:0.40:0.49:0.39:0.60:0.46:0.60:0.58:0.61"] = 634, -- Feathermoon, Nijel's Point, Stonetalon Peak, Astranaar, Forest Song
				["0.31:0.31:0.48:0.30:0.64:0.33:0.61:0.60:0.58:0.61:0.50:0.65"] = 678, -- Feathermoon, Thalanaar, Theramore, Talrendis Point, Forest Song, Emerald Sanctuary
				["0.31:0.31:0.43:0.75:0.46:0.60"] = 635, -- Feathermoon, Auberdine, Astranaar
				["0.31:0.31:0.43:0.75:0.46:0.60:0.50:0.65"] = 713, -- Feathermoon, Auberdine, Astranaar, Emerald Sanctuary

				-- Alliance: Forest Song (Ashenvale)
				["0.58:0.61:0.61:0.60:0.61:0.45:0.64:0.33:0.48:0.30:0.31:0.31"] = 602, -- Forest Song, Talrendis Point, Ratchet, Theramore, Thalanaar, Feathermoon
				["0.58:0.61:0.61:0.60:0.61:0.45:0.60:0.19:0.42:0.21"] = 596, -- Forest Song, Talrendis Point, Ratchet, Gadgetzan, Cenarion Hold
				["0.58:0.61:0.61:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 503, -- Forest Song, Talrendis Point, Ratchet, Gadgetzan, Marshal's Refuge
				["0.58:0.61:0.61:0.60:0.61:0.45:0.64:0.33:0.48:0.30"] = 424, -- Forest Song, Talrendis Point, Ratchet, Theramore, Thalanaar
				["0.58:0.61:0.61:0.60:0.61:0.45:0.64:0.33:0.58:0.30"] = 324, -- Forest Song, Talrendis Point, Ratchet, Theramore, Mudsprocket
				["0.58:0.61:0.61:0.60:0.61:0.45:0.64:0.33"] = 261, -- Forest Song, Talrendis Point, Ratchet, Theramore
				["0.58:0.61:0.61:0.60:0.61:0.45:0.60:0.19"] = 400, -- Forest Song, Talrendis Point, Ratchet, Gadgetzan
				["0.58:0.61:0.61:0.60:0.61:0.45"] = 163, -- Forest Song, Talrendis Point, Ratchet
				["0.58:0.61:0.46:0.60:0.39:0.60:0.40:0.49"] = 421, -- Forest Song, Astranaar, Stonetalon Peak, Nijel's Point
				["0.58:0.61:0.46:0.60:0.39:0.60"] = 295, -- Forest Song, Astranaar, Stonetalon Peak
				["0.58:0.61:0.46:0.60"] = 141, -- Forest Song, Astranaar
				["0.58:0.61:0.50:0.65"] = 111, -- Forest Song, Emerald Sanctuary
				["0.58:0.61:0.61:0.60"] = 28, -- Forest Song, Talrendis Point
				["0.58:0.61:0.61:0.60:0.65:0.77"] = 207, -- Forest Song, Talrendis Point, Everlook
				["0.58:0.61:0.50:0.65:0.53:0.74"] = 238, -- Forest Song, Emerald Sanctuary, Talonbranch Glade
				["0.58:0.61:0.50:0.65:0.53:0.74:0.55:0.79"] = 297, -- Forest Song, Emerald Sanctuary, Talonbranch Glade, Moonglade
				["0.58:0.61:0.46:0.60:0.43:0.75"] = 290, -- Forest Song, Astranaar, Auberdine
				["0.58:0.61:0.46:0.60:0.43:0.75:0.42:0.84"] = 374, -- Forest Song, Astranaar, Auberdine, Rut'theran Village
				["0.58:0.61:0.46:0.60:0.61:0.45:0.64:0.33"] = 436, -- Forest Song, Astranaar, Ratchet, Theramore
				["0.58:0.61:0.46:0.60:0.43:0.75:0.55:0.79"] = 441, -- Forest Song, Astranaar, Auberdine, Moonglade
				["0.58:0.61:0.46:0.60:0.61:0.45"] = 335, -- Forest Song, Astranaar, Ratchet
				["0.58:0.61:0.46:0.60:0.43:0.75:0.31:0.31"] = 762, -- Forest Song, Astranaar, Auberdine, Feathermoon
				["0.58:0.61:0.50:0.65:0.53:0.74:0.65:0.77"] = 328, -- Forest Song, Emerald Sanctuary, Talonbranch Glade, Everlook
				["0.58:0.61:0.46:0.60:0.39:0.60:0.40:0.49:0.31:0.31:0.48:0.30"] = 807, -- Forest Song, Astranaar, Stonetalon Peak, Nijel's Point, Feathermoon, Thalanaar
				["0.58:0.61:0.61:0.60:0.43:0.75:0.39:0.60"] = 510, -- Forest Song, Talrendis Point, Auberdine, Stonetalon Peak
				["0.58:0.61:0.46:0.60:0.61:0.45:0.60:0.19"] = 576, -- Forest Song, Astranaar, Ratchet, Gadgetzan
				["0.58:0.61:0.46:0.60:0.64:0.33"] = 529, -- Forest Song, Astranaar, Theramore
				["0.58:0.61:0.46:0.60:0.64:0.33:0.48:0.30"] = 692, -- Forest Song, Astranaar, Theramore, Thalanaar
				["0.58:0.61:0.50:0.65:0.53:0.74:0.43:0.75:0.64:0.33:0.60:0.19"] = 1002, -- Forest Song, Emerald Sanctuary, Talonbranch Glade, Auberdine, Theramore, Gadgetzan
				["0.58:0.61:0.46:0.60:0.43:0.75:0.40:0.49"] = 580, -- Forest Song, Astranaar, Auberdine, Nijel's Point
				["0.58:0.61:0.46:0.60:0.61:0.45:0.64:0.33:0.48:0.30"] = 598, -- Waldeslied, Astranaar, Ratschet, Theramore, Thalanaar

				-- Alliance: Gadgetzan (Tanaris)
				["0.60:0.19:0.48:0.30:0.31:0.31"] = 354, -- Gadgetzan, Thalanaar, Feathermoon
				["0.60:0.19:0.42:0.21"] = 197, -- Gadgetzan, Cenarion Hold
				["0.60:0.19:0.50:0.24"] = 104, -- Gadgetzan, Marshal's Refuge
				["0.60:0.19:0.48:0.30"] = 177, -- Gadgetzan, Thalanaar
				["0.60:0.19:0.64:0.33:0.58:0.30"] = 212, -- Gadgetzan, Theramore, Mudsprocket
				["0.60:0.19:0.64:0.33"] = 154, -- Gadgetzan, Theramore
				["0.60:0.19:0.61:0.45"] = 247, -- Gadgetzan, Ratchet
				["0.60:0.19:0.64:0.33:0.40:0.49"] = 481, -- Gadgetzan, Theramore, Nijel's Point
				["0.60:0.19:0.61:0.45:0.46:0.60:0.39:0.60"] = 596, -- Gadgetzan, Ratchet, Astranaar, Stonetalon Peak
				["0.60:0.19:0.61:0.45:0.46:0.60"] = 442, -- Gadgetzan, Ratchet, Astranaar
				["0.60:0.19:0.61:0.45:0.61:0.60:0.58:0.61:0.50:0.65"] = 506, -- Gadgetzan, Ratchet, Talrendis Point, Forest Song, Emerald Sanctuary
				["0.60:0.19:0.61:0.45:0.61:0.60:0.58:0.61"] = 400, -- Gadgetzan, Ratchet, Talrendis Point, Forest Song
				["0.60:0.19:0.61:0.45:0.61:0.60"] = 374, -- Gadgetzan, Ratchet, Talrendis Point
				["0.60:0.19:0.61:0.45:0.61:0.60:0.65:0.77"] = 553, -- Gadgetzan, Ratchet, Talrendis Point, Everlook
				["0.60:0.19:0.61:0.45:0.61:0.60:0.58:0.61:0.50:0.65:0.53:0.74"] = 634, -- Gadgetzan, Ratchet, Talrendis Point, Forest Song, Emerald Sanctuary, Talonbranch Glade
				["0.60:0.19:0.61:0.45:0.61:0.60:0.65:0.77:0.55:0.79"] = 663, -- Gadgetzan, Ratchet, Talrendis Point, Everlook, Moonglade
				["0.60:0.19:0.61:0.45:0.46:0.60:0.43:0.75"] = 591, -- Gadgetzan, Ratchet, Astranaar, Auberdine
				["0.60:0.19:0.61:0.45:0.46:0.60:0.43:0.75:0.42:0.84"] = 675, -- Gadgetzan, Ratchet, Astranaar, Auberdine, Rut'theran Village
				["0.60:0.19:0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74"] = 648, -- Gadgetzan, Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade
				["0.60:0.19:0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74:0.65:0.77"] = 738, -- Gadgetzan, Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade, Everlook
				["0.60:0.19:0.61:0.45:0.46:0.60:0.50:0.65"] = 521, -- Gadgetzan, Ratchet, Astranaar, Emerald Sanctuary
				["0.60:0.19:0.64:0.33:0.61:0.60"] = 387, -- Gadgetzan, Theramore, Talrendis Point
				["0.60:0.19:0.64:0.33:0.43:0.75:0.42:0.84"] = 672, -- Gadgetzan, Theramore, Auberdine, Rut'theran Village
				["0.60:0.19:0.64:0.33:0.46:0.60:0.50:0.65"] = 596, -- Gadgetzan, Theramore, Astranaar, Emerald Sanctuary
				["0.60:0.19:0.64:0.33:0.46:0.60"] = 518, -- Gadgetzan, Theramore, Astranaar
				["0.60:0.19:0.61:0.45:0.46:0.60:0.58:0.61"] = 576, -- Gadgetzan, Ratchet, Astranaar, Forest Song
				["0.60:0.19:0.64:0.33:0.46:0.60:0.39:0.60"] = 672, -- Gadgetzan, Theramore, Astranaar, Stonetalon Peak
				["0.60:0.19:0.64:0.33:0.40:0.49:0.31:0.31"] = 712, -- Gadgetzan, Theramore, Nijel's Point, Feathermoon
				["0.60:0.19:0.64:0.33:0.43:0.75"] = 588, -- Gadgetzan, Theramore, Auberdine
				["0.60:0.19:0.61:0.45:0.46:0.60:0.43:0.75:0.53:0.74"] = 780, -- Gadgetzan, Ratchet, Astranaar, Auberdine, Talonbranch Glade
				["0.60:0.19:0.64:0.33:0.46:0.60:0.58:0.61"] = 652, -- Gadgetzan, Theramore, Astranaar, Forest Song
				["0.60:0.19:0.61:0.45:0.61:0.60:0.58:0.61:0.50:0.65:0.53:0.74:0.55:0.79"] = 692, -- Gadgetzan, Ratchet, Talrendis Point, Forest Song, Emerald Sanctuary, Talonbranch Glade, Moonglade
				["0.60:0.19:0.48:0.30:0.31:0.31:0.40:0.49"] = 581, -- Gadgetzan, Thalanaar, Feathermoon, Nijel's Point
				["0.60:0.19:0.61:0.45:0.46:0.60:0.43:0.75:0.55:0.79"] = 741, -- Gadgetzan, Ratchet, Astranaar, Auberdine, Moonglade
				["0.60:0.19:0.48:0.30:0.58:0.30"] = 263, -- Gadgetzan, Thalanaar, Mudsprocket
				["0.60:0.19:0.64:0.33:0.43:0.75:0.53:0.74:0.50:0.65"] = 880, -- Gadgetzan, Theramore, Auberdine, Talonbranch Glade, Emerald Sanctuary
				["0.60:0.19:0.61:0.45:0.61:0.60:0.53:0.74"] = 657, -- Gadgetzan, Ratchet, Talrendis Point, Talonbranch Glade
				["0.60:0.19:0.64:0.33:0.61:0.60:0.65:0.77:0.55:0.79"] = 676, -- Gadgetzan, Theramore, Talrendis Point, Everlook, Moonglade
				["0.60:0.19:0.48:0.30:0.31:0.31:0.40:0.49:0.39:0.60"] = 701, -- Gadgetzan, Thalanaar, Feathermoon, Nijel's Point, Stonetalon Peak
				["0.60:0.19:0.61:0.45:0.46:0.60:0.43:0.75:0.55:0.79:0.65:0.77"] = 860, -- Gadgetzan, Ratchet, Astranaar, Auberdine, Moonglade, Everlook
				["0.60:0.19:0.64:0.33:0.40:0.49:0.39:0.60"] = 600, -- Gadgetzan, Theramore, Punta de Nijel, Cima del Espolón
				["0.60:0.19:0.61:0.45:0.46:0.60:0.39:0.60:0.40:0.49"] = 723, -- Gadgetzan, Ratchet, Astranaar, Stonetalon Peak, Nijel's Point
				["0.60:0.19:0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74:0.55:0.79"] = 707, -- Gadgetzan, Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade, Moonglade
				["0.60:0.19:0.42:0.21:0.31:0.31"] = 364, -- Gadgetzan, Cenarion Hold, Feathermoon

				-- Alliance: Marshal's Refuge (Un'Goro Crater)
				["0.50:0.24:0.42:0.21:0.31:0.31"] = 258, -- Marshal's Refuge, Cenarion Hold, Feathermoon
				["0.50:0.24:0.42:0.21"] = 94, -- Marshal's Refuge, Cenarion Hold
				["0.50:0.24:0.60:0.19:0.48:0.30"] = 281, -- Marshal's Refuge, Gadgetzan, Thalanaar
				["0.50:0.24:0.60:0.19:0.64:0.33:0.58:0.30"] = 315, -- Marshal's Refuge, Gadgetzan, Theramore, Mudsprocket
				["0.50:0.24:0.60:0.19:0.64:0.33"] = 257, -- Marshal's Refuge, Gadgetzan, Theramore
				["0.50:0.24:0.60:0.19"] = 104, -- Marshal's Refuge, Gadgetzan (Liam Walt reported 111 but my own test reports 104)
				["0.50:0.24:0.60:0.19:0.61:0.45"] = 351, -- Marshal's Refuge, Gadgetzan, Ratchet
				["0.50:0.24:0.42:0.21:0.31:0.31:0.40:0.49"] = 485, -- Marshal's Refuge, Cenarion Hold, Feathermoon, Nijel's Point
				["0.50:0.24:0.42:0.21:0.31:0.31:0.40:0.49:0.39:0.60"] = 605, -- Marshal's Refuge, Cenarion Hold, Feathermoon, Nijel's Point, Stonetalon Peak
				["0.50:0.24:0.60:0.19:0.61:0.45:0.46:0.60"] = 545, -- Marshal's Refuge, Gadgetzan, Ratchet, Astranaar
				["0.50:0.24:0.60:0.19:0.61:0.45:0.61:0.60:0.58:0.61:0.50:0.65"] = 609, -- Marshal's Refuge, Gadgetzan, Ratchet, Talrendis Point, Forest Song, Emerald Sanctuary
				["0.50:0.24:0.60:0.19:0.61:0.45:0.61:0.60:0.58:0.61"] = 503, -- Marshal's Refuge, Gadgetzan, Ratchet, Talrendis Point, Forest Song
				["0.50:0.24:0.60:0.19:0.61:0.45:0.61:0.60"] = 477, -- Marshal's Refuge, Gadgetzan, Ratchet, Talrendis Point
				["0.50:0.24:0.60:0.19:0.61:0.45:0.61:0.60:0.65:0.77"] = 656, -- Marshal's Refuge, Gadgetzan, Ratchet, Talrendis Point, Everlook
				["0.50:0.24:0.60:0.19:0.61:0.45:0.61:0.60:0.65:0.77:0.55:0.79"] = 765, -- Marshal's Refuge, Gadgetzan, Ratchet, Talrendis Point, Everlook, Moonglade
				["0.50:0.24:0.60:0.19:0.61:0.45:0.61:0.60:0.58:0.61:0.50:0.65:0.53:0.74"] = 737, -- Marshal's Refuge, Gadgetzan, Ratchet, Talrendis Point, Forest Song, Emerald Sanctuary, Talonbranch Glade
				["0.50:0.24:0.60:0.19:0.61:0.45:0.46:0.60:0.43:0.75"] = 694, -- Marshal's Refuge, Gadgetzan, Ratchet, Astranaar, Auberdine
				["0.50:0.24:0.60:0.19:0.61:0.45:0.46:0.60:0.43:0.75:0.42:0.84"] = 778, -- Marshal's Refuge, Gadgetzan, Ratchet, Astranaar, Auberdine, Rut'theran Village
				["0.50:0.24:0.60:0.19:0.48:0.30:0.31:0.31"] = 458, -- Marshal's Refuge, Gadgetzan, Thalanaar, Feathermoon
				["0.50:0.24:0.60:0.19:0.61:0.45:0.46:0.60:0.58:0.61"] = 680, -- Marshal's Refuge, Gadgetzan, Ratchet, Astranaar, Forest Song
				["0.50:0.24:0.60:0.19:0.61:0.45:0.46:0.60:0.50:0.65"] = 624, -- Marshal's Refuge, Gadgetzan, Ratchet, Astranaar, Emerald Sanctuary
				["0.50:0.24:0.60:0.19:0.64:0.33:0.40:0.49:0.31:0.31"] = 815, -- Marshal's Refuge, Gadgetzan, Theramore, Nijel's Point, Feathermoon
				["0.50:0.24:0.60:0.19:0.64:0.33:0.43:0.75:0.42:0.84"] = 776, -- Marshal's Refuge, Gadgetzan, Theramore, Auberdine, Rut'theran Village
				["0.50:0.24:0.60:0.19:0.61:0.45:0.61:0.60:0.53:0.74"] = 760, -- Marshal's Refuge, Gadgetzan, Ratchet, Talrendis Point, Talonbranch Glade
				["0.50:0.24:0.60:0.19:0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74"] = 752, -- Marshal's Refuge, Gadgetzan, Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade
				["0.50:0.24:0.60:0.19:0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74:0.65:0.77"] = 841, -- Marshal's Refuge, Gadgetzan, Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade, Everlook
				["0.50:0.24:0.60:0.19:0.64:0.33:0.43:0.75"] = 691, -- Marshal's Refuge, Gadgetzan, Theramore, Auberdine
				["0.50:0.24:0.60:0.19:0.61:0.45:0.46:0.60:0.43:0.75:0.55:0.79:0.65:0.77"] = 963, -- Marshal's Refuge, Gadgetzan, Ratchet, Astranaar, Auberdine, Moonglade, Everlook
				["0.50:0.24:0.60:0.19:0.64:0.33:0.46:0.60"] = 621, -- Marshal's Refuge, Gadgetzan, Theramore, Astranaar
				["0.50:0.24:0.60:0.19:0.64:0.33:0.40:0.49"] = 584, -- Marshal's Refuge, Gadgetzan, Theramore, Nijel's Point
				["0.50:0.24:0.60:0.19:0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74:0.55:0.79"] = 810, -- Marshal's Refuge, Gadgetzan, Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade, Moonglade
				["0.50:0.24:0.60:0.19:0.64:0.33:0.46:0.60:0.58:0.61"] = 755, -- Marshal's Refuge, Gadgetzan, Theramore, Astranaar, Forest Song
				["0.50:0.24:0.60:0.19:0.64:0.33:0.46:0.60:0.50:0.65"] = 699, -- Marshal's Refuge, Gadgetzan, Theramore, Astranaar, Emerald Sanctuary
				["0.50:0.24:0.60:0.19:0.64:0.33:0.46:0.60:0.50:0.65:0.53:0.74"] = 827, -- Marshal's Refuge, Gadgetzan, Theramore, Astranaar, Emerald Sanctuary, Talonbranch Glade
				["0.50:0.24:0.60:0.19:0.61:0.45:0.46:0.60:0.43:0.75:0.55:0.79"] = 845, -- Marshal's Refuge, Gadgetzan, Ratchet, Astranaar, Auberdine, Moonglade
				["0.50:0.24:0.60:0.19:0.64:0.33:0.43:0.75:0.53:0.74:0.65:0.77"] = 969, -- Marshal's Refuge, Gadgetzan, Theramore, Auberdine, Talonbranch Glade, Everlook
				["0.50:0.24:0.60:0.19:0.64:0.33:0.61:0.60:0.65:0.77"] = 668, -- Marshal's Refuge, Gadgetzan, Theramore, Talrendis Point, Everlook

				-- Alliance: Moonglade (Moonglade)
				["0.55:0.79:0.43:0.75:0.31:0.31"] = 614, -- Moonglade, Auberdine, Feathermoon
				["0.55:0.79:0.43:0.75:0.31:0.31:0.42:0.21"] = 764, -- Moonglade, Auberdine, Feathermoon, Cenarion Hold
				["0.55:0.79:0.65:0.77:0.61:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 755, -- Moonglade, Everlook, Talrendis Point, Ratchet, Gadgetzan, Marshal's Refuge
				["0.55:0.79:0.65:0.77:0.61:0.60:0.61:0.45:0.60:0.19"] = 651, -- Moonglade, Everlook, Talrendis Point, Ratchet, Gadgetzan
				["0.55:0.79:0.65:0.77:0.61:0.60:0.61:0.45:0.64:0.33:0.58:0.30"] = 576, -- Moonglade, Everlook, Talrendis Point, Ratchet, Theramore, Mudsprocket
				["0.55:0.79:0.65:0.77:0.61:0.60:0.61:0.45:0.64:0.33"] = 513, -- Moonglade, Everlook, Talrendis Point, Ratchet, Theramore
				["0.55:0.79:0.65:0.77:0.61:0.60:0.61:0.45:0.64:0.33:0.48:0.30"] = 675, -- Moonglade, Everlook, Talrendis Point, Ratchet, Theramore, Thalanaar
				["0.55:0.79:0.65:0.77:0.61:0.60:0.61:0.45"] = 415, -- Moonglade, Everlook, Talrendis Point, Ratchet
				["0.55:0.79:0.43:0.75:0.40:0.49"] = 433, -- Moonglade, Auberdine, Nijel's Point
				["0.55:0.79:0.43:0.75:0.39:0.60"] = 323, -- Moonglade, Auberdine, Stonetalon Peak
				["0.55:0.79:0.53:0.74:0.50:0.65:0.46:0.60"] = 253, -- Moonglade, Talonbranch Glade, Emerald Sanctuary, Astranaar
				["0.55:0.79:0.53:0.74:0.50:0.65"] = 174, -- Moonglade, Talonbranch Glade, Emerald Sanctuary
				["0.55:0.79:0.53:0.74:0.50:0.65:0.58:0.61"] = 277, -- Moonglade, Talonbranch Glade, Emerald Sanctuary, Forest Song
				["0.55:0.79:0.65:0.77:0.61:0.60"] = 281, -- Moonglade, Everlook, Talrendis Point
				["0.55:0.79:0.65:0.77"] = 119, -- Moonglade, Everlook
				["0.55:0.79:0.53:0.74"] = 62, -- Moonglade, Talonbranch Glade
				["0.55:0.79:0.43:0.75"] = 142, -- Moonglade, Auberdine
				["0.55:0.79:0.43:0.75:0.42:0.84"] = 226, -- Moonglade, Auberdine, Rut'theran Village
				["0.55:0.79:0.43:0.75:0.64:0.33:0.60:0.19"] = 738, -- Moonglade, Auberdine, Theramore, Gadgetzan
				["0.55:0.79:0.43:0.75:0.64:0.33"] = 585, -- Moonglade, Auberdine, Theramore
				["0.55:0.79:0.43:0.75:0.46:0.60:0.58:0.61"] = 443, -- Moonglade, Auberdine, Astranaar, Forest Song
				["0.55:0.79:0.43:0.75:0.46:0.60:0.61:0.45"] = 503, -- Mondlichtung, Auberdine, Astranaar, Ratschet
				["0.55:0.79:0.43:0.75:0.46:0.60"] = 310, -- Moonglade, Auberdine, Astranaar
				["0.55:0.79:0.53:0.74:0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 776, -- Moonglade, Talonbranch Glade, Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Gadgetzan, Marshal's Refuge
				["0.55:0.79:0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45"] = 447, -- Moonglade, Talonbranch Glade, Emerald Sanctuary, Astranaar, Ratchet
				["0.55:0.79:0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45:0.64:0.33:0.48:0.30"] = 710, -- Reflet-de-Lune, Clairière de Griffebranche, Sanctuaire d'émeraude, Astranaar, Cabestan, Theramore, Thalanaar
				["0.55:0.79:0.53:0.74:0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.64:0.33"] = 535, -- Moonglade, Talonbranch Glade, Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Theramore
				["0.55:0.79:0.53:0.74:0.50:0.65:0.58:0.61:0.61:0.60"] = 302, -- Moonglade, Talonbranch Glade, Emerald Sanctuary, Forest Song, Talrendis Point
				["0.55:0.79:0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45:0.60:0.19"] = 689, -- Moonglade, Talonbranch Glade, Emerald Sanctuary, Astranaar, Ratchet, Gadgetzan
				["0.55:0.79:0.43:0.75:0.46:0.60:0.50:0.65"] = 388, -- Moonglade, Auberdine, Astranaar, Emerald Sanctuary
				["0.55:0.79:0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45:0.64:0.33"] = 548, -- Moonglade, Talonbranch Glade, Emerald Sanctuary, Astranaar, Ratchet, Theramore
				["0.55:0.79:0.43:0.75:0.64:0.33:0.48:0.30"] = 744, -- Moonglade, Auberdine, Theramore, Thalanaar
				["0.55:0.79:0.43:0.75:0.64:0.33:0.58:0.30"] = 644, -- Moonglade, Auberdine, Theramore, Mudsprocket
				["0.55:0.79:0.43:0.75:0.64:0.33:0.60:0.19:0.50:0.24"] = 842, -- Moonglade, Auberdine, Theramore, Gadgetzan, Marshal's Refuge
				["0.55:0.79:0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 792, -- Moonglade, Talonbranch Glade, Emerald Sanctuary, Astranaar, Ratchet, Gadgetzan, Marshal's Refuge
				["0.55:0.79:0.43:0.75:0.64:0.33:0.61:0.45"] = 693, -- Moonglade, Auberdine, Theramore, Ratchet
				["0.55:0.79:0.65:0.77:0.61:0.60:0.64:0.33:0.60:0.19"] = 675, -- Moonglade, Everlook, Talrendis Point, Theramore, Gadgetzan
				["0.55:0.79:0.43:0.75:0.61:0.60"] = 442, -- Moonglade, Auberdine, Talrendis Point
				["0.55:0.79:0.53:0.74:0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45"] = 436, -- Moonglade, Talonbranch Glade, Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet
				["0.55:0.79:0.43:0.75:0.31:0.31:0.48:0.30"] = 769, -- Moonglade, Auberdine, Feathermoon, Thalanaar
				["0.55:0.79:0.53:0.74:0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.60:0.19"] = 673, -- Moonglade, Talonbranch Glade, Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Gadgetzan
				["0.55:0.79:0.43:0.75:0.46:0.60:0.61:0.45:0.60:0.19"] = 744, -- Moonglade, Auberdine, Astranaar, Ratchet, Gadgetzan
				["0.55:0.79:0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45:0.64:0.33:0.58:0.30"] = 611, -- Moonglade, Talonbranch Glade, Emerald Sanctuary, Astranaar, Ratchet, Theramore, Mudsprocket
				["0.55:0.79:0.65:0.77:0.61:0.60:0.58:0.61"] = 305, -- Moonglade, Everlook, Talrendis Point, Forest Song
				["0.55:0.79:0.53:0.74:0.61:0.60"] = 330, -- Moonglade, Talonbranch Glade, Talrendis Point
				["0.55:0.79:0.43:0.75:0.64:0.33:0.60:0.19:0.42:0.21"] = 935, -- Moonglade, Auberdine, Theramore, Gadgetzan, Cenarion Hold
				["0.55:0.79:0.53:0.74:0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.64:0.33:0.58:0.30"] = 598, -- Moonglade, Talonbranch Glade, Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Theramore, Mudsprocket

				-- Alliance: Mudsprocket (Dustwallow Marsh)
				["0.58:0.30:0.48:0.30:0.31:0.31"] = 283, -- Mudsprocket, Thalanaar, Feathermoon
				["0.58:0.30:0.64:0.33:0.60:0.19:0.42:0.21"] = 405, -- Mudsprocket, Theramore, Gadgetzan, Cenarion Hold
				["0.58:0.30:0.64:0.33:0.60:0.19:0.50:0.24"] = 312, -- Mudsprocket, Theramore, Gadgetzan, Marshal's Refuge
				["0.58:0.30:0.48:0.30"] = 105, -- Mudsprocket, Thalanaar
				["0.58:0.30:0.64:0.33"] = 52, -- Mudsprocket, Theramore
				["0.58:0.30:0.64:0.33:0.60:0.19"] = 209, -- Mudsprocket, Theramore, Gadgetzan
				["0.58:0.30:0.64:0.33:0.61:0.45"] = 167, -- Mudsprocket, Theramore, Ratchet
				["0.58:0.30:0.64:0.33:0.40:0.49"] = 386, -- Mudsprocket, Theramore, Nijel's Point
				["0.58:0.30:0.64:0.33:0.40:0.49:0.39:0.60"] = 505, -- Mudsprocket, Theramore, Nijel's Point, Stonetalon Peak
				["0.58:0.30:0.64:0.33:0.61:0.45:0.46:0.60"] = 361, -- Mudsprocket, Theramore, Ratchet, Astranaar
				["0.58:0.30:0.64:0.33:0.61:0.60:0.58:0.61:0.50:0.65"] = 416, -- Mudsprocket, Theramore, Talrendis Point, Forest Song, Emerald Sanctuary
				["0.58:0.30:0.64:0.33:0.61:0.60:0.58:0.61"] = 310, -- Mudsprocket, Theramore, Talrendis Point, Forest Song
				["0.58:0.30:0.64:0.33:0.61:0.60"] = 285, -- Mudsprocket, Theramore, Talrendis Point
				["0.58:0.30:0.64:0.33:0.61:0.60:0.65:0.77"] = 463, -- Mudsprocket, Theramore, Talrendis Point, Everlook
				["0.58:0.30:0.64:0.33:0.61:0.60:0.58:0.61:0.50:0.65:0.53:0.74"] = 544, -- Mudsprocket, Theramore, Talrendis Point, Forest Song, Emerald Sanctuary, Talonbranch Glade
				["0.58:0.30:0.64:0.33:0.61:0.60:0.65:0.77:0.55:0.79"] = 573, -- Mudsprocket, Theramore, Talrendis Point, Everlook, Moonglade
				["0.58:0.30:0.64:0.33:0.43:0.75"] = 492, -- Mudsprocket, Theramore, Auberdine
				["0.58:0.30:0.64:0.33:0.43:0.75:0.42:0.84"] = 576, -- Mudsprocket, Theramore, Auberdine, Rut'theran Village
				["0.58:0.30:0.64:0.33:0.61:0.45:0.46:0.60:0.58:0.61"] = 496, -- Mudsprocket, Theramore, Ratchet, Astranaar, Forest Song
				["0.58:0.30:0.64:0.33:0.40:0.49:0.31:0.31"] = 618, -- Mudsprocket, Theramore, Nijel's Point, Feathermoon
				["0.58:0.30:0.48:0.30:0.60:0.19"] = 277, -- Bourbe-à-brac, Thalanaar, Gadgetzan
				["0.58:0.30:0.64:0.33:0.61:0.45:0.46:0.60:0.39:0.60"] = 515, -- Bourbe-à-brac, Theramore, Ratchet, Astranaar, Stonetalon Peak
				["0.58:0.30:0.64:0.33:0.61:0.45:0.46:0.60:0.50:0.65"] = 440, -- Mudsprocket, Theramore, Ratchet, Astranaar, Emerald Sanctuary
				["0.58:0.30:0.64:0.33:0.46:0.60:0.39:0.60"] = 576, -- Mudsprocket, Theramore, Astranaar, Stonetalon Peak
				["0.58:0.30:0.64:0.33:0.46:0.60"] = 421, -- Mudsprocket, Theramore, Astranaar

				-- Alliance: Nijel's Point (Desolace)
				["0.40:0.49:0.31:0.31"] = 232, -- Nijel's Point, Feathermoon
				["0.40:0.49:0.31:0.31:0.42:0.21"] = 381, -- Nijel's Point, Feathermoon, Cenarion Hold
				["0.40:0.49:0.31:0.31:0.42:0.21:0.50:0.24"] = 470, -- Nijel's Point, Feathermoon, Cenarion Hold, Marshal's Refuge
				["0.40:0.49:0.31:0.31:0.48:0.30"] = 387, -- Nijel's Point, Feathermoon, Thalanaar
				["0.40:0.49:0.64:0.33:0.58:0.30"] = 370, -- Nijel's Point, Theramore, Mudsprocket
				["0.40:0.49:0.64:0.33"] = 308, -- Nijel's Point, Theramore
				["0.40:0.49:0.64:0.33:0.60:0.19"] = 464, -- Nijel's Point, Theramore, Gadgetzan
				["0.40:0.49:0.64:0.33:0.61:0.45"] = 422, -- Nijel's Point, Theramore, Ratchet
				["0.40:0.49:0.39:0.60:0.46:0.60:0.61:0.60"] = 421, -- Nijel's Point, Stonetalon Peak, Astranaar, Talrendis Point
				["0.40:0.49:0.39:0.60:0.46:0.60:0.58:0.61"] = 408, -- Nijel's Point, Stonetalon Peak, Astranaar, Forest Song
				["0.40:0.49:0.39:0.60:0.46:0.60:0.50:0.65"] = 351, -- Nijel's Point, Stonetalon Peak, Astranaar, Emerald Sanctuary
				["0.40:0.49:0.39:0.60:0.46:0.60"] = 274, -- Nijel's Point, Stonetalon Peak, Astranaar
				["0.40:0.49:0.39:0.60"] = 120, -- Nijel's Point, Stonetalon Peak
				["0.40:0.49:0.43:0.75"] = 282, -- Nijel's Point, Auberdine
				["0.40:0.49:0.43:0.75:0.42:0.84"] = 367, -- Nijel's Point, Auberdine, Rut'theran Village
				["0.40:0.49:0.43:0.75:0.53:0.74"] = 471, -- Nijel's Point, Auberdine, Talonbranch Glade
				["0.40:0.49:0.43:0.75:0.55:0.79"] = 433, -- Nijel's Point, Auberdine, Moonglade
				["0.40:0.49:0.43:0.75:0.55:0.79:0.65:0.77"] = 552, -- Nijel's Point, Auberdine, Moonglade, Everlook
				["0.40:0.49:0.43:0.75:0.46:0.60"] = 449, -- Nijel's Point, Auberdine, Astranaar
				["0.40:0.49:0.64:0.33:0.48:0.30"] = 471, -- Nijel's Point, Theramore, Thalanaar
				["0.40:0.49:0.39:0.60:0.46:0.60:0.61:0.45"] = 466, -- Nijel's Point, Stonetalon Peak, Astranaar, Ratchet
				["0.40:0.49:0.64:0.33:0.60:0.19:0.50:0.24"] = 568, -- Nijel's Point, Theramore, Gadgetzan, Marshal's Refuge
				["0.40:0.49:0.43:0.75:0.46:0.60:0.50:0.65"] = 528, -- Nijel's Point, Auberdine, Astranaar, Emerald Sanctuary
				["0.40:0.49:0.43:0.75:0.53:0.74:0.65:0.77"] = 560, -- Nijel's Point, Auberdine, Talonbranch Glade, Everlook
				["0.40:0.49:0.31:0.31:0.48:0.30:0.60:0.19"] = 557, -- Nijel's Point, Feathermoon, Thalanaar, Gadgetzan
				["0.40:0.49:0.39:0.60:0.46:0.60:0.61:0.45:0.60:0.19"] = 708, -- Nijel's Point, Stonetalon Peak, Astranaar, Ratchet, Gadgetzan
				["0.40:0.49:0.43:0.75:0.46:0.60:0.61:0.45:0.60:0.19"] = 884, -- Nijel's Point, Auberdine, Astranaar, Ratchet, Gadgetzan
				["0.40:0.49:0.43:0.75:0.46:0.60:0.61:0.45"] = 643, -- Nijel's Point, Auberdine, Astranaar, Ratchet
				["0.40:0.49:0.31:0.31:0.48:0.30:0.58:0.30"] = 472, -- Nijel's Point, Feathermoon, Thalanaar, Mudsprocket
				["0.40:0.49:0.64:0.33:0.61:0.60:0.58:0.61"] = 565, -- Combe de Nijel, Theramore, Halte de Talrendis, Chant des forêts
				["0.40:0.49:0.64:0.33:0.61:0.60:0.65:0.77:0.55:0.79"] = 828, -- Nijel's Point, Theramore, Talrendis Point, Everlook, Moonglade
				["0.40:0.49:0.64:0.33:0.61:0.60"] = 539, -- Nijel's Point, Theramore, Talrendis Point

				-- Alliance: Ratchet (The Barrens)
				["0.61:0.45:0.64:0.33:0.48:0.30:0.31:0.31"] = 446, -- Ratchet, Theramore, Thalanaar, Feathermoon
				["0.61:0.45:0.60:0.19:0.42:0.21"] = 442, -- Ratchet, Gadgetzan, Cenarion Hold
				["0.61:0.45:0.60:0.19:0.50:0.24"] = 349, -- Ratchet, Gadgetzan, Marshal's Refuge
				["0.61:0.45:0.64:0.33:0.48:0.30"] = 268, -- Ratchet, Theramore, Thalanaar
				["0.61:0.45:0.64:0.33:0.58:0.30"] = 168, -- Ratchet, Theramore, Mudsprocket
				["0.61:0.45:0.64:0.33"] = 106, -- Ratchet, Theramore
				["0.61:0.45:0.60:0.19"] = 245, -- Ratchet, Gadgetzan
				["0.61:0.45:0.61:0.60"] = 130, -- Ratchet, Talrendis Point
				["0.61:0.45:0.61:0.60:0.58:0.61"] = 155, -- Ratchet, Talrendis Point, Forest Song
				["0.61:0.45:0.61:0.60:0.58:0.61:0.50:0.65"] = 262, -- Ratchet, Talrendis Point, Forest Song, Emerald Sanctuary
				["0.61:0.45:0.46:0.60"] = 197, -- Ratchet, Astranaar
				["0.61:0.45:0.46:0.60:0.39:0.60"] = 352, -- Ratchet, Astranaar, Stonetalon Peak
				["0.61:0.45:0.64:0.33:0.40:0.49"] = 439, -- Ratchet, Theramore, Nijel's Point
				["0.61:0.45:0.46:0.60:0.43:0.75:0.42:0.84"] = 430, -- Ratchet, Astranaar, Auberdine, Rut'theran Village
				["0.61:0.45:0.46:0.60:0.43:0.75"] = 345, -- Ratchet, Astranaar, Auberdine
				["0.61:0.45:0.61:0.60:0.58:0.61:0.50:0.65:0.53:0.74"] = 389, -- Ratchet, Talrendis Point, Forest Song, Emerald Sanctuary, Talonbranch Glade
				["0.61:0.45:0.61:0.60:0.65:0.77:0.55:0.79"] = 420, -- Ratchet, Talrendis Point, Everlook, Moonglade
				["0.61:0.45:0.61:0.60:0.65:0.77"] = 310, -- Ratchet, Talrendis Point, Everlook
				["0.61:0.45:0.46:0.60:0.50:0.65"] = 276, -- Ratchet, Astranaar, Emerald Sanctuary
				["0.61:0.45:0.46:0.60:0.58:0.61"] = 332, -- Ratchet, Astranaar, Forest Song
				["0.61:0.45:0.64:0.33:0.43:0.75:0.42:0.84"] = 629, -- Ratchet, Theramore, Auberdine, Rut'theran Village
				["0.61:0.45:0.46:0.60:0.39:0.60:0.40:0.49"] = 477, -- Ratchet, Astranaar, Stonetalon Peak, Nijel's Point
				["0.61:0.45:0.61:0.60:0.43:0.75:0.42:0.84"] = 515, -- Ratchet, Talrendis Point, Auberdine, Rut'theran Village
				["0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74"] = 403, -- Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade
				["0.61:0.45:0.60:0.19:0.48:0.30"] = 421, -- Ratchet, Gadgetzan, Thalanaar
				["0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74:0.65:0.77"] = 493, -- Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade, Everlook
				["0.61:0.45:0.64:0.33:0.43:0.75"] = 545, -- Ratchet, Theramore, Auberdine
				["0.61:0.45:0.46:0.60:0.43:0.75:0.55:0.79:0.65:0.77"] = 615, -- Ratchet, Astranaar, Auberdine, Moonglade, Everlook
				["0.61:0.45:0.46:0.60:0.43:0.75:0.53:0.74"] = 535, -- Ratchet, Astranaar, Auberdine, Talonbranch Glade
				["0.61:0.45:0.61:0.60:0.58:0.61:0.50:0.65:0.53:0.74:0.55:0.79"] = 449, -- Ratchet, Talrendis Point, Forest Song, Emerald Sanctuary, Talonbranch Glade, Moonglade
				["0.61:0.45:0.46:0.60:0.43:0.75:0.40:0.49"] = 636, -- Ratchet, Astranaar, Auberdine, Nijel's Point
				["0.61:0.45:0.64:0.33:0.40:0.49:0.31:0.31"] = 671, -- Ratchet, Theramore, Nijel's Point, Feathermoon
				["0.61:0.45:0.60:0.19:0.48:0.30:0.31:0.31:0.40:0.49"] = 825, -- Ratchet, Gadgetzan, Thalanaar, Feathermoon, Nijel's Point
				["0.61:0.45:0.64:0.33:0.40:0.49:0.39:0.60"] = 558, -- Ratchet, Theramore, Nijel's Point, Stonetalon Peak
				["0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74:0.55:0.79"] = 462, -- Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade, Moonglade
				["0.61:0.45:0.60:0.19:0.48:0.30:0.31:0.31"] = 598, -- Ratchet, Gadgetzan, Thalanaar, Feathermoon
				["0.61:0.45:0.46:0.60:0.43:0.75:0.55:0.79"] = 496, -- Ratchet, Astranaar, Auberdine, Moonglade
				["0.61:0.45:0.64:0.33:0.43:0.75:0.39:0.60"] = 725, -- Ratchet, Theramore, Auberdine, Stonetalon Peak

				-- Alliance: Rut'theran Village (Teldrassil)
				["0.42:0.84:0.43:0.75:0.31:0.31"] = 557, -- Rut'theran Village, Auberdine, Feathermoon
				["0.42:0.84:0.43:0.75:0.31:0.31:0.42:0.21"] = 708, -- Rut'theran Village, Auberdine, Feathermoon, Cenarion Hold
				["0.42:0.84:0.43:0.75:0.64:0.33:0.60:0.19:0.50:0.24"] = 785, -- Rut'theran Village, Auberdine, Theramore, Gadgetzan, Marshal's Refuge
				["0.42:0.84:0.43:0.75:0.64:0.33:0.48:0.30"] = 687, -- Rut'theran Village, Auberdine, Theramore, Thalanaar
				["0.42:0.84:0.43:0.75:0.64:0.33:0.60:0.19"] = 681, -- Rut'theran Village, Auberdine, Theramore, Gadgetzan (Gladhappy Guffaws reported 777)
				["0.42:0.84:0.43:0.75:0.64:0.33:0.58:0.30"] = 587, -- Rut'theran Village, Auberdine, Theramore, Mudsprocket
				["0.42:0.84:0.43:0.75:0.64:0.33"] = 528, -- Rut'theran Village, Auberdine, Theramore
				["0.42:0.84:0.43:0.75:0.46:0.60:0.61:0.45"] = 446, -- Rut'theran Village, Auberdine, Astranaar, Ratchet
				["0.42:0.84:0.43:0.75:0.40:0.49"] = 376, -- Rut'theran Village, Auberdine, Nijel's Point
				["0.42:0.84:0.43:0.75:0.61:0.60"] = 385, -- Rut'theran Village, Auberdine, Talrendis Point
				["0.42:0.84:0.43:0.75:0.46:0.60:0.58:0.61"] = 387, -- Rut'theran Village, Auberdine, Astranaar, Forest Song
				["0.42:0.84:0.43:0.75:0.46:0.60:0.50:0.65"] = 331, -- Rut'theran Village, Auberdine, Astranaar, Emerald Sanctuary
				["0.42:0.84:0.43:0.75:0.46:0.60"] = 252, -- Rut'theran Village, Auberdine, Astranaar
				["0.42:0.84:0.43:0.75:0.39:0.60"] = 267, -- Rut'theran Village, Auberdine, Stonetalon Peak
				["0.42:0.84:0.43:0.75"] = 86, -- Rut'theran Village, Auberdine
				["0.42:0.84:0.43:0.75:0.53:0.74"] = 274, -- Rut'theran Village, Auberdine, Talonbranch Glade
				["0.42:0.84:0.43:0.75:0.55:0.79"] = 236, -- Rut'theran Village, Auberdine, Moonglade
				["0.42:0.84:0.43:0.75:0.55:0.79:0.65:0.77"] = 355, -- Rut'theran Village, Auberdine, Moonglade, Everlook
				["0.42:0.84:0.43:0.75:0.53:0.74:0.65:0.77"] = 363, -- Rut'theran Village, Auberdine, Talonbranch Glade, Everlook
				["0.42:0.84:0.43:0.75:0.61:0.60:0.65:0.77"] = 564, -- Rut'theran Village, Auberdine, Talrendis Point, Everlook
				["0.42:0.84:0.43:0.75:0.64:0.33:0.61:0.45"] = 637, -- Rut'theran Village, Auberdine, Theramore, Ratchet
				["0.42:0.84:0.43:0.75:0.64:0.33:0.60:0.19:0.42:0.21"] = 878, -- Rut'theran Village, Auberdine, Theramore, Gadgetzan, Cenarion Hold
				["0.42:0.84:0.43:0.75:0.61:0.60:0.58:0.61"] = 410, -- Rut'theran Village, Auberdine, Talrendis Point, Forest Song
				["0.42:0.84:0.43:0.75:0.53:0.74:0.50:0.65"] = 378, -- Rut'theran Village, Auberdine, Talonbranch Glade, Emerald Sanctuary
				["0.42:0.84:0.43:0.75:0.46:0.60:0.61:0.45:0.60:0.19"] = 687, -- Rut'theran Village, Auberdine, Astranaar, Ratchet, Gadgetzan
				["0.42:0.84:0.43:0.75:0.31:0.31:0.48:0.30"] = 712, -- Rut'theran Village, Auberdine, Feathermoon, Thalanaar
				["0.42:0.84:0.43:0.75:0.46:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 790, -- Rut'theran Village, Auberdine, Astranaar, Ratchet, Gadgetzan, Marshal's Refuge
				["0.42:0.84:0.43:0.75:0.31:0.31:0.48:0.30:0.60:0.19:0.50:0.24"] = 986, -- Rut'theran Village, Auberdine, Feathermoon, Thalanaar, Gadgetzan, Marshal's Refuge
				["0.42:0.84:0.43:0.75:0.61:0.60:0.61:0.45"] = 521, -- Rut'theran Village, Auberdine, Talrendis Point, Ratchet
				["0.42:0.84:0.43:0.75:0.46:0.60:0.61:0.45:0.60:0.19:0.48:0.30"] = 863, -- Rut'theran Village, Auberdine, Astranaar, Ratchet, Gadgetzan, Thalanaar
				["0.42:0.84:0.43:0.75:0.46:0.60:0.61:0.45:0.60:0.19:0.48:0.30:0.58:0.30"] = 948, -- Rut'theran Village, Auberdine, Astranaar, Ratchet, Gadgetzan, Thalanaar, Mudsprocket

				-- Alliance: Stonetalon Peak (Stonetalon Mountains)
				["0.39:0.60:0.40:0.49:0.31:0.31"] = 359, -- Stonetalon Peak, Nijel's Point, Feathermoon
				["0.39:0.60:0.40:0.49:0.31:0.31:0.42:0.21"] = 508, -- Stonetalon Peak, Nijel's Point, Feathermoon, Cenarion Hold
				["0.39:0.60:0.40:0.49:0.31:0.31:0.42:0.21:0.50:0.24"] = 596, -- Stonetalon Peak, Nijel's Point, Feathermoon, Cenarion Hold, Marshal's Refuge
				["0.39:0.60:0.40:0.49:0.31:0.31:0.48:0.30"] = 513, -- Stonetalon Peak, Nijel's Point, Feathermoon, Thalanaar
				["0.39:0.60:0.40:0.49:0.64:0.33:0.58:0.30"] = 497, -- Stonetalon Peak, Nijel's Point, Theramore, Mudsprocket
				["0.39:0.60:0.40:0.49:0.64:0.33"] = 434, -- Stonetalon Peak, Nijel's Point, Theramore
				["0.39:0.60:0.40:0.49:0.64:0.33:0.60:0.19"] = 591, -- Stonetalon Peak, Nijel's Point, Theramore, Gadgetzan
				["0.39:0.60:0.46:0.60:0.61:0.45"] = 348, -- Stonetalon Peak, Astranaar, Ratchet
				["0.39:0.60:0.40:0.49"] = 126, -- Stonetalon Peak, Nijel's Point
				["0.39:0.60:0.46:0.60"] = 154, -- Stonetalon Peak, Astranaar
				["0.39:0.60:0.46:0.60:0.50:0.65"] = 234, -- Stonetalon Peak, Astranaar, Emerald Sanctuary
				["0.39:0.60:0.46:0.60:0.58:0.61"] = 288, -- Stonetalon Peak, Astranaar, Forest Song
				["0.39:0.60:0.46:0.60:0.61:0.60"] = 303, -- Stonetalon Peak, Astranaar, Talrendis Point
				["0.39:0.60:0.43:0.75:0.55:0.79:0.65:0.77"] = 447, -- Stonetalon Peak, Auberdine, Moonglade, Everlook
				["0.39:0.60:0.46:0.60:0.50:0.65:0.53:0.74"] = 361, -- Stonetalon Peak, Astranaar, Emerald Sanctuary, Talonbranch Glade
				["0.39:0.60:0.43:0.75:0.55:0.79"] = 328, -- Stonetalon Peak, Auberdine, Moonglade
				["0.39:0.60:0.43:0.75"] = 177, -- Stonetalon Peak, Auberdine
				["0.39:0.60:0.43:0.75:0.42:0.84"] = 261, -- Stonetalon Peak, Auberdine, Rut'theran Village
				["0.39:0.60:0.40:0.49:0.64:0.33:0.61:0.45"] = 549, -- Stonetalon Peak, Nijel's Point, Theramore, Ratchet
				["0.39:0.60:0.46:0.60:0.61:0.45:0.64:0.33:0.48:0.30"] = 612, -- Stonetalon Peak, Astranaar, Ratchet, Theramore, Thalanaar
				["0.39:0.60:0.43:0.75:0.53:0.74"] = 367, -- Stonetalon Peak, Auberdine, Talonbranch Glade
				["0.39:0.60:0.46:0.60:0.61:0.45:0.64:0.33"] = 449, -- Stonetalon Peak, Astranaar, Ratchet, Theramore
				["0.39:0.60:0.40:0.49:0.64:0.33:0.48:0.30"] = 598, -- Stonetalon Peak, Nijel's Point, Theramore, Thalanaar
				["0.39:0.60:0.43:0.75:0.64:0.33:0.61:0.45"] = 728, -- Stonetalon Peak, Auberdine, Theramore, Ratchet
				["0.39:0.60:0.43:0.75:0.53:0.74:0.65:0.77"] = 455, -- Stonetalon Peak, Auberdine, Talonbranch Glade, Everlook
				["0.39:0.60:0.46:0.60:0.61:0.45:0.60:0.19:0.48:0.30"] = 765, -- Stonetalon Peak, Astranaar, Ratchet, Gadgetzan, Thalanaar

				-- Alliance: Talonbranch Glade (Felwood)
				["0.53:0.74:0.43:0.75:0.31:0.31"] = 660, -- Talonbranch Glade, Auberdine, Feathermoon
				["0.53:0.74:0.43:0.75:0.31:0.31:0.42:0.21"] = 810, -- Talonbranch Glade, Auberdine, Feathermoon, Cenarion Hold
				["0.53:0.74:0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 731, -- Talonbranch Glade, Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Gadgetzan, Marshal's Refuge
				["0.53:0.74:0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.64:0.33:0.48:0.30"] = 652, -- Talonbranch Glade, Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Theramore, Thalanaar
				["0.53:0.74:0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.64:0.33:0.58:0.30"] = 552, -- Talonbranch Glade, Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Theramore, Mudsprocket
				["0.53:0.74:0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.64:0.33"] = 489, -- Talonbranch Glade, Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Theramore
				["0.53:0.74:0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45:0.60:0.19"] = 627, -- Talonbranch Glade, Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet, Gadgetzan
				["0.53:0.74:0.50:0.65:0.58:0.61:0.61:0.60:0.61:0.45"] = 391, -- Talonbranch Glade, Emerald Sanctuary, Forest Song, Talrendis Point, Ratchet
				["0.53:0.74:0.43:0.75:0.40:0.49"] = 478, -- Talonbranch Glade, Auberdine, Nijel's Point
				["0.53:0.74:0.50:0.65:0.46:0.60:0.39:0.60"] = 363, -- Talonbranch Glade, Emerald Sanctuary, Astranaar, Stonetalon Peak
				["0.53:0.74:0.50:0.65:0.46:0.60"] = 209, -- Talonbranch Glade, Emerald Sanctuary, Astranaar
				["0.53:0.74:0.50:0.65"] = 129, -- Talonbranch Glade, Emerald Sanctuary
				["0.53:0.74:0.50:0.65:0.58:0.61"] = 232, -- Talonbranch Glade, Emerald Sanctuary, Forest Song
				["0.53:0.74:0.61:0.60"] = 283, -- Talonbranch Glade, Talrendis Point
				["0.53:0.74:0.65:0.77"] = 107, -- Talonbranch Glade, Everlook
				["0.53:0.74:0.55:0.79"] = 67, -- Talonbranch Glade, Moonglade
				["0.53:0.74:0.43:0.75:0.42:0.84"] = 272, -- Talonbranch Glade, Auberdine, Rut'theran Village
				["0.53:0.74:0.43:0.75"] = 188, -- Talonbranch Glade, Auberdine
				["0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 747, -- Talonbranch Glade, Emerald Sanctuary, Astranaar, Ratchet, Gadgetzan, Marshal's Refuge
				["0.53:0.74:0.43:0.75:0.64:0.33:0.60:0.19"] = 783, -- Talonbranch Glade, Auberdine, Theramore, Gadgetzan
				["0.53:0.74:0.43:0.75:0.46:0.60"] = 356, -- Talonbranch Glade, Auberdine, Astranaar
				["0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45"] = 402, -- Talonbranch Glade, Emerald Sanctuary, Astranaar, Ratchet
				["0.53:0.74:0.43:0.75:0.39:0.60"] = 369, -- Talonbranch Glade, Auberdine, Stonetalon Peak
				["0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45:0.60:0.19"] = 643, -- Talonbranch Glade, Emerald Sanctuary, Astranaar, Ratchet, Gadgetzan
				["0.53:0.74:0.61:0.60:0.58:0.61"] = 308, -- Talonbranch Glade, Talrendis Point, Forest Song
				["0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45:0.64:0.33"] = 502, -- Talonbranch Glade, Emerald Sanctuary, Astranaar, Ratchet, Theramore
				["0.53:0.74:0.50:0.65:0.46:0.60:0.61:0.45:0.64:0.33:0.48:0.30"] = 665, -- Talonbranch Glade, Emerald Sanctuary, Astranaar, Ratchet, Theramore, Thalanaar
				["0.53:0.74:0.65:0.77:0.61:0.60:0.61:0.45:0.60:0.19"] = 640, -- Talonbranch Glade, Everlook, Talrendis Point, Ratchet, Gadgetzan
				["0.53:0.74:0.65:0.77:0.61:0.60:0.61:0.45:0.64:0.33:0.48:0.30"] = 665, -- Clairière de Griffebranche, Long-guet, Halte de Talrendis, Cabestan, Theramore, Thalanaar
				["0.53:0.74:0.65:0.77:0.61:0.60:0.58:0.61"] = 293, -- Talonbranch Glade, Everlook, Talrendis Point, Forest Song
				["0.53:0.74:0.50:0.65:0.46:0.60:0.64:0.33:0.60:0.19"] = 753, -- Talonbranch Glade, Emerald Sanctuary, Astranaar, Theramore, Gadgetzan
				["0.53:0.74:0.50:0.65:0.58:0.61:0.61:0.60:0.64:0.33:0.60:0.19"] = 652, -- Talonbranch Glade, Emerald Sanctuary, Forest Song, Talrendis Point, Theramore, Gadgetzan
				["0.53:0.74:0.65:0.77:0.61:0.60:0.61:0.45"] = 404, -- Talonbranch Glade, Everlook, Talrendis Point, Ratchet
				["0.53:0.74:0.65:0.77:0.61:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 744, -- Talonbranch Glade, Everlook, Talrendis Point, Ratchet, Gadgetzan, Marshal's Refuge
				["0.53:0.74:0.43:0.75:0.46:0.60:0.61:0.45"] = 548, -- Talonbranch Glade, Auberdine, Astranaar, Ratchet

				-- Alliance: Talrendis Point (Azshara)
				["0.61:0.60:0.61:0.45:0.64:0.33:0.48:0.30:0.31:0.31"] = 574, -- Talrendis Point, Ratchet, Theramore, Thalanaar, Feathermoon
				["0.61:0.60:0.61:0.45:0.60:0.19:0.42:0.21"] = 569, -- Talrendis Point, Ratchet, Gadgetzan, Cenarion Hold
				["0.61:0.60:0.61:0.45:0.60:0.19:0.50:0.24"] = 476, -- Talrendis Point, Ratchet, Gadgetzan, Marshal's Refuge
				["0.61:0.60:0.61:0.45:0.64:0.33:0.48:0.30"] = 397, -- Talrendis Point, Ratchet, Theramore, Thalanaar
				["0.61:0.60:0.61:0.45:0.64:0.33:0.58:0.30"] = 297, -- Talrendis Point, Ratchet, Theramore, Mudsprocket
				["0.61:0.60:0.64:0.33"] = 241, -- Talrendis Point, Theramore
				["0.61:0.60:0.61:0.45:0.60:0.19"] = 373, -- Talrendis Point, Ratchet, Gadgetzan
				["0.61:0.60:0.61:0.45"] = 135, -- Talrendis Point, Ratchet (Brian Villarreal suggested 129)
				["0.61:0.60:0.46:0.60:0.39:0.60:0.40:0.49"] = 431, -- Talrendis Point, Astranaar, Stonetalon Peak, Nijel's Point
				["0.61:0.60:0.46:0.60:0.39:0.60"] = 305, -- Talrendis Point, Astranaar, Stonetalon Peak
				["0.61:0.60:0.46:0.60"] = 153, -- Talrendis Point, Astranaar
				["0.61:0.60:0.58:0.61:0.50:0.65"] = 132, -- Talrendis Point, Forest Song, Emerald Sanctuary
				["0.61:0.60:0.58:0.61"] = 26, -- Talrendis Point, Forest Song
				["0.61:0.60:0.53:0.74"] = 284, -- Talrendis Point, Talonbranch Glade
				["0.61:0.60:0.65:0.77:0.55:0.79"] = 289, -- Talrendis Point, Everlook, Moonglade
				["0.61:0.60:0.65:0.77"] = 179, -- Talrendis Point, Everlook
				["0.61:0.60:0.46:0.60:0.43:0.75:0.42:0.84"] = 383, -- Talrendis Point, Astranaar, Auberdine, Rut'theran Village
				["0.61:0.60:0.43:0.75"] = 301, -- Talrendis Point, Auberdine
				["0.61:0.60:0.64:0.33:0.60:0.19"] = 397, -- Talrendis Point, Theramore, Gadgetzan
				["0.61:0.60:0.46:0.60:0.50:0.65"] = 229, -- Talrendis Point, Astranaar, Emerald Sanctuary
				["0.61:0.60:0.43:0.75:0.42:0.84"] = 386, -- Talrendis Point, Auberdine, Rut'theran Village
				["0.61:0.60:0.46:0.60:0.39:0.60:0.40:0.49:0.31:0.31"] = 662, -- Talrendis Point, Astranaar, Stonetalon Peak, Nijel's Point, Feathermoon
				["0.61:0.60:0.64:0.33:0.48:0.30:0.31:0.31"] = 581, -- Talrendis Point, Theramore, Thalanaar, Feathermoon
				["0.61:0.60:0.58:0.61:0.50:0.65:0.53:0.74:0.55:0.79"] = 319, -- Talrendis Point, Forest Song, Emerald Sanctuary, Talonbranch Glade, Moonglade
				["0.61:0.60:0.64:0.33:0.58:0.30"] = 303, -- Talrendis Point, Theramore, Mudsprocket

				-- Alliance: Thalanaar
				["0.48:0.30:0.31:0.31"] = 179, -- Thalanaar, Feathermoon
				["0.48:0.30:0.31:0.31:0.42:0.21"] = 329, -- Thalanaar, Feathermoon, Cenarion Hold
				["0.48:0.30:0.60:0.19:0.50:0.24"] = 274, -- Thalanaar, Gadgetzan, Marshal's Refuge
				["0.48:0.30:0.60:0.19"] = 171, -- Thalanaar, Gadgetzan
				["0.48:0.30:0.58:0.30"] = 86, -- Thalanaar, Mudsprocket
				["0.48:0.30:0.64:0.33"] = 159, -- Thalanaar, Theramore
				["0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.45"] = 253, -- Thalanaar, Mudsprocket, Theramore, Ratchet
				["0.48:0.30:0.31:0.31:0.40:0.49"] = 405, -- Thalanaar, Feathermoon, Nijel's Point
				["0.48:0.30:0.31:0.31:0.40:0.49:0.39:0.60"] = 524, -- Thalanaar, Feathermoon, Nijel's Point, Stonetalon Peak
				["0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.45:0.46:0.60"] = 447, -- Thalanaar, Mudsprocket, Theramore, Ratchet, Astranaar
				["0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.60:0.58:0.61:0.50:0.65"] = 502, -- Thalanaar, Mudsprocket, Theramore, Talrendis Point, Forest Song, Emerald Sanctuary
				["0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.60:0.58:0.61"] = 396, -- Thalanaar, Mudsprocket, Theramore, Talrendis Point, Forest Song
				["0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.60"] = 370, -- Thalanaar, Mudsprocket, Theramore, Talrendis Point
				["0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.60:0.65:0.77"] = 548, -- Thalanaar, Mudsprocket, Theramore, Talrendis Point, Everlook
				["0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.60:0.58:0.61:0.50:0.65:0.53:0.74"] = 629, -- Thalanaar, Mudsprocket, Theramore, Talrendis Point, Forest Song, Emerald Sanctuary, Talonbranch Glade
				["0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.60:0.65:0.77:0.55:0.79"] = 658, -- Thalanaar, Mudsprocket, Theramore, Talrendis Point, Everlook, Moonglade
				["0.48:0.30:0.58:0.30:0.64:0.33:0.43:0.75"] = 577, -- Thalanaar, Mudsprocket, Theramore, Auberdine
				["0.48:0.30:0.58:0.30:0.64:0.33:0.43:0.75:0.42:0.84"] = 661, -- Thalanaar, Mudsprocket, Theramore, Auberdine, Rut'theran Village
				["0.48:0.30:0.64:0.33:0.61:0.45"] = 275, -- Thalanaar, Theramore, Ratchet
				["0.48:0.30:0.64:0.33:0.46:0.60:0.39:0.60"] = 683, -- Thalanaar, Theramore, Astranaar, Stonetalon Peak
				["0.48:0.30:0.64:0.33:0.43:0.75"] = 599, -- Thalanaar, Theramore, Auberdine
				["0.48:0.30:0.64:0.33:0.43:0.75:0.42:0.84"] = 683, -- Thalanaar, Theramore, Auberdine, Rut'theran Village
				["0.48:0.30:0.64:0.33:0.40:0.49"] = 494, -- Thalanaar, Theramore, Nijel's Point
				["0.48:0.30:0.58:0.30:0.64:0.33:0.40:0.49"] = 472, -- Thalanaar, Mudsprocket, Theramore, Nijel's Point
				["0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74:0.65:0.77"] = 742, -- Thalanaar, Mudsprocket, Theramore, Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade, Everlook
				["0.48:0.30:0.60:0.19:0.61:0.45"] = 416, -- Thalanaar, Gadgetzan, Ratchet
				["0.48:0.30:0.64:0.33:0.61:0.45:0.46:0.60"] = 469, -- Thalanaar, Theramore, Ratchet, Astranaar
				["0.48:0.30:0.31:0.31:0.43:0.75"] = 646, -- Thalanaar, Feathermoon, Auberdine
				["0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.45:0.46:0.60:0.50:0.65"] = 526, -- Thalanaar, Mudsprocket, Theramore, Ratchet, Astranaar, Emerald Sanctuary
				["0.48:0.30:0.64:0.33:0.46:0.60"] = 529, -- Thalanaar, Theramore, Astranaar
				["0.48:0.30:0.60:0.19:0.61:0.45:0.46:0.60"] = 611, -- Thalanaar, Gadgetzan, Ratchet, Astranaar
				["0.48:0.30:0.64:0.33:0.61:0.45:0.46:0.60:0.50:0.65"] = 547, -- Thalanaar, Theramore, Ratchet, Astranaar, Emerald Sanctuary
				["0.48:0.30:0.58:0.30:0.64:0.33:0.61:0.45:0.46:0.60:0.58:0.61"] = 581, -- Thalanaar, Mudsprocket, Theramore, Ratchet, Astranaar, Forest Song
				["0.48:0.30:0.64:0.33:0.61:0.45:0.46:0.60:0.58:0.61"] = 603, -- Thalanaar, Theramore, Ratchet, Astranaar, Forest Song
				["0.48:0.30:0.64:0.33:0.61:0.45:0.46:0.60:0.39:0.60"] = 623, -- Thalanaar, Theramore, Ratchet, Astranaar, Stonetalon Peak
				["0.48:0.30:0.64:0.33:0.61:0.60:0.53:0.74"] = 674, -- Thalanaar, Theramore, Talrendis Point, Talonbranch Glade
				["0.48:0.30:0.58:0.30:0.64:0.33:0.40:0.49:0.39:0.60"] = 591, -- Thalanaar, Mudsprocket, Theramore, Nijel's Point, Stonetalon Peak
				["0.48:0.30:0.64:0.33:0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74"] = 675, -- Thalanaar, Theramore, Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade
				["0.48:0.30:0.31:0.31:0.40:0.49:0.39:0.60:0.46:0.60"] = 678, -- Thalanaar, Feathermoon, Nijel's Point, Stonetalon Peak, Astranaar

				-- Alliance: Theramore (Dustwallow Marsh)
				["0.64:0.33:0.48:0.30:0.31:0.31"] = 340, -- Theramore, Thalanaar, Feathermoon
				["0.64:0.33:0.60:0.19:0.42:0.21"] = 354, -- Theramore, Gadgetzan, Cenarion Hold
				["0.64:0.33:0.60:0.19:0.50:0.24"] = 261, -- Theramore, Gadgetzan, Marshal's Refuge
				["0.64:0.33:0.48:0.30"] = 162, -- Theramore, Thalanaar
				["0.64:0.33:0.58:0.30"] = 64, -- Theramore, Mudsprocket
				["0.64:0.33:0.60:0.19"] = 157, -- Theramore, Gadgetzan
				["0.64:0.33:0.61:0.45"] = 115, -- Theramore, Ratchet
				["0.64:0.33:0.40:0.49"] = 334, -- Theramore, Nijel's Point
				["0.64:0.33:0.40:0.49:0.39:0.60"] = 453, -- Theramore, Nijel's Point, Stonetalon Peak
				["0.64:0.33:0.46:0.60"] = 369, -- Theramore, Astranaar
				["0.64:0.33:0.61:0.60:0.58:0.61:0.50:0.65"] = 366, -- Theramore, Talrendis Point, Forest Song, Emerald Sanctuary
				["0.64:0.33:0.61:0.60:0.58:0.61"] = 259, -- Theramore, Talrendis Point, Forest Song
				["0.64:0.33:0.61:0.60"] = 234, -- Theramore, Talrendis Point
				["0.64:0.33:0.61:0.60:0.65:0.77"] = 412, -- Theramore, Talrendis Point, Everlook
				["0.64:0.33:0.61:0.60:0.58:0.61:0.50:0.65:0.53:0.74"] = 494, -- Theramore, Talrendis Point, Forest Song, Emerald Sanctuary, Talonbranch Glade
				["0.64:0.33:0.61:0.60:0.65:0.77:0.55:0.79"] = 523, -- Theramore, Talrendis Point, Everlook, Moonglade
				["0.64:0.33:0.43:0.75"] = 440, -- Theramore, Auberdine (Serhii Nedilia reported 458)
				["0.64:0.33:0.43:0.75:0.42:0.84"] = 524, -- Theramore, Auberdine, Rut'theran Village
				["0.64:0.33:0.61:0.45:0.46:0.60:0.39:0.60"] = 464, -- Theramore, Ratchet, Astranaar, Stonetalon Peak
				["0.64:0.33:0.40:0.49:0.31:0.31"] = 567, -- Theramore, Nijel's Point, Feathermoon
				["0.64:0.33:0.61:0.45:0.46:0.60:0.58:0.61"] = 443, -- Theramore, Ratchet, Astranaar, Forest Song
				["0.64:0.33:0.43:0.75:0.39:0.60"] = 621, -- Theramore, Auberdine, Stonetalon Peak
				["0.64:0.33:0.61:0.45:0.46:0.60:0.50:0.65"] = 388, -- Theramore, Ratchet, Astranaar, Emerald Sanctuary
				["0.64:0.33:0.43:0.75:0.53:0.74"] = 629, -- Theramore, Auberdine, Talonbranch Glade
				["0.64:0.33:0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74:0.65:0.77"] = 605, -- Theramore, Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade, Everlook
				["0.64:0.33:0.61:0.60:0.53:0.74"] = 516, -- Theramore, Talrendis Point, Talonbranch Glade (was 234, changed by Michael Keller)
				["0.64:0.33:0.46:0.60:0.58:0.61"] = 504, -- Theramore, Astranaar, Forest Song
				["0.64:0.33:0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74"] = 516, -- Theramore, Ratschet, Astranaar, Emerald Sanctuary, Talonbranch Glade
				["0.64:0.33:0.60:0.19:0.42:0.21:0.31:0.31"] = 520, -- Theramore, Gadgetzan, Cenarion Hold, Feathermoon
				["0.64:0.33:0.46:0.60:0.39:0.60"] = 524, -- Theramore, Astranaar, Stonetalon Peak
				["0.64:0.33:0.43:0.75:0.55:0.79:0.65:0.77"] = 710, -- Theramore, Auberdine, Moonglade, Everlook
				["0.64:0.33:0.46:0.60:0.50:0.65"] = 448, -- Theramore, Astranaar, Emerald Sanctuary
				["0.64:0.33:0.46:0.60:0.50:0.65:0.53:0.74"] = 575, -- Theramore, Astranaar, Emerald Sanctuary, Talonbranch Glade
				["0.64:0.33:0.46:0.60:0.50:0.65:0.53:0.74:0.65:0.77"] = 665, -- Theramore, Astranaar, Emerald Sanctuary, Talonbranch Glade, Everlook
				["0.64:0.33:0.61:0.45:0.46:0.60:0.50:0.65:0.53:0.74:0.55:0.79"] = 574, -- Theramore, Ratchet, Astranaar, Emerald Sanctuary, Talonbranch Glade, Moonglade
				["0.64:0.33:0.43:0.75:0.55:0.79"] = 591, -- Theramore, Auberdine, Moonglade
				["0.64:0.33:0.43:0.75:0.53:0.74:0.50:0.65"] = 733, -- Theramore, Auberdine, Talonbranch Glade, Emerald Sanctuary
				["0.64:0.33:0.43:0.75:0.31:0.31"] = 913, -- Theramore, Auberdine, Mondfederfeste

			},

			-- Alliance: Outland
			[3] = {

				-- Alliance: Allerian Stronghold (Terokkar Forest)
				["0.55:0.23:0.27:0.26"] = 149, -- Allerian Stronghold, Telaar
				["0.55:0.23:0.44:0.33"] = 75, -- Allerian Stronghold, Shattrath (Luis C. reported 82, not changed yet)
				["0.55:0.23:0.69:0.15"] = 79, -- Allerian Stronghold, Wildhammer Stronghold
				["0.55:0.23:0.65:0.42"] = 96, -- Allerian Stronghold, Honor Hold
				["0.55:0.23:0.65:0.42:0.79:0.45"] = 156, -- Allerian Stronghold, Honor Hold, Hellfire Peninsula
				["0.55:0.23:0.65:0.42:0.52:0.49"] = 170, -- Allerian Stronghold, Honor Hold, Temple of Telhamat
				["0.55:0.23:0.44:0.33:0.38:0.50"] = 158, -- Allerian Stronghold, Shattrath, Telredor
				["0.55:0.23:0.44:0.33:0.38:0.50:0.27:0.56"] = 221, -- Allerian Stronghold, Shattrath, Telredor, Orebor Harborage
				["0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63"] = 227, -- Allerian Stronghold, Shattrath, Telredor, Toshley's Station
				["0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66"] = 249, -- Allerian Stronghold, Shattrath, Telredor, Sylvanaar
				["0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.42:0.72"] = 280, -- Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Evergrove
				["0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73"] = 311, -- Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52
				["0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 358, -- Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52, The Stormspire
				["0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.72:0.72"] = 375, -- Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52, Cosmowrench
				["0.55:0.23:0.69:0.15:0.81:0.23"] = 161, -- Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.55:0.23:0.69:0.15:0.78:0.15"] = 121, -- Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.55:0.23:0.65:0.42:0.75:0.50"] = 150, -- Allerian Stronghold, Honor Hold, Shatter Point
				["0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66:0.63:0.82"] = 404, -- Allerian Stronghold, Shattrath, Telredor, Sylvanaar, The Stormspire
				["0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66:0.58:0.73"] = 368, -- Allerian Stronghold, Shattrath, Telredor, Sylvanaar, Area 52
				["0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66:0.42:0.72"] = 300, -- Allerian Stronghold, Shattrath, Telredor, Sylvanaar, Evergrove
				["0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66:0.58:0.73:0.72:0.72"] = 433, -- Allerian Stronghold, Shattrath, Telredor, Sylvanaar, Area 52, Cosmowrench
				["0.55:0.23:0.65:0.42:0.52:0.49:0.38:0.50"] = 251, -- Allerian Stronghold, Honor Hold, Temple of Telhamat, Telredor

				-- Alliance: Altar of Sha'tar (Shadowmoon Valley)
				["0.81:0.23:0.69:0.15"] = 81, -- Altar of Sha'tar, Wildhammer Stronghold
				["0.81:0.23:0.55:0.23:0.44:0.33"] = 254, -- Altar of Sha'tar, Allerian Stronghold, Shattrath
				["0.81:0.23:0.55:0.23:0.65:0.42:0.75:0.50"] = 330, -- Altar of Sha'tar, Allerian Stronghold, Honor Hold, Shatter Point
				["0.81:0.23:0.55:0.23:0.65:0.42:0.79:0.45"] = 336, -- Altar of Sha'tar, Allerian Stronghold, Honor Hold, Hellfire Peninsula
				["0.81:0.23:0.55:0.23"] = 182, -- Altar of Sha'tar, Allerian Stronghold
				["0.81:0.23:0.55:0.23:0.65:0.42"] = 276, -- Altar of Sha'tar, Allerian Stronghold, Honor Hold
				["0.81:0.23:0.55:0.23:0.27:0.26"] = 330, -- Altar of Sha'tar, Allerian Stronghold, Telaar
				["0.81:0.23:0.55:0.23:0.65:0.42:0.52:0.49"] = 351, -- Altar of Sha'tar, Allerian Stronghold, Honor Hold, Temple of Telhamat
				["0.81:0.23:0.55:0.23:0.44:0.33:0.38:0.50"] = 338, -- Altar of Sha'tar, Allerian Stronghold, Shattrath, Telredor
				["0.81:0.23:0.55:0.23:0.44:0.33:0.38:0.50:0.27:0.56"] = 400, -- Altar of Sha'tar, Allerian Stronghold, Shattrath, Telredor, Orebor Harborage
				["0.81:0.23:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.72:0.72"] = 555, -- Altar of Sha'tar, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52, Cosmowrench
				["0.81:0.23:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 537, -- Altar of Sha'tar, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52, The Stormspire
				["0.81:0.23:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63"] = 406, -- Altar of Sha'tar, Allerian Stronghold, Shattrath, Telredor, Toshley's Station
				["0.81:0.23:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73"] = 489, -- Altar of Sha'tar, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52
				["0.81:0.23:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.42:0.72"] = 458, -- Altar of Sha'tar, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Evergrove
				["0.81:0.23:0.69:0.15:0.55:0.23:0.44:0.33"] = 254, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Shattrath
				["0.81:0.23:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50"] = 338, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor
				["0.81:0.23:0.69:0.15:0.55:0.23:0.27:0.26"] = 329, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Telaar
				["0.81:0.23:0.69:0.15:0.55:0.23:0.65:0.42"] = 276, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Honor Hold
				["0.81:0.23:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 537, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52, The Stormspire
				["0.81:0.23:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66"] = 428, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Sylvanaar
				["0.81:0.23:0.69:0.15:0.55:0.23:0.65:0.42:0.52:0.49"] = 350, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Honor Hold, Temple of Telhamat
				["0.81:0.23:0.69:0.15:0.55:0.23"] = 181, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold
				["0.81:0.23:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73"] = 489, -- Altar der Sha'tar, Wildhammerfeste, Allerias Feste, Shattrath, Telredor, Toshleys Station, Area 52
				["0.81:0.23:0.69:0.15:0.55:0.23:0.65:0.42:0.75:0.50"] = 329, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Honor Hold, Shatter Point
				["0.81:0.23:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.27:0.56"] = 400, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Orebor Harborage
				["0.81:0.23:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.42:0.72"] = 459, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Evergrove
				["0.81:0.23:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63"] = 406, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Toshley's Station
				["0.81:0.23:0.69:0.15:0.55:0.23:0.65:0.42:0.79:0.45"] = 336, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Honor Hold, Hellfire Peninsula
				["0.81:0.23:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.72:0.72"] = 555, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52, Cosmowrench
				["0.81:0.23:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66:0.58:0.73"] = 547, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Sylvanaar, Area 52
				["0.81:0.23:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66:0.42:0.72"] = 479, -- Altar of Sha'tar, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Sylvanaar, Evergrove

				-- Alliance: Area 52 (Netherstorm)
				["0.58:0.73:0.42:0.63:0.38:0.50:0.27:0.26"] = 290, -- Area 52, Toshley's Station, Telredor, Telaar
				["0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33"] = 262, -- Area 52, Toshley's Station, Telredor, Shattrath
				["0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23"] = 337, -- Area 52, Toshley's Station, Telredor, Shattrath, Allerian Stronghold
				["0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15"] = 414, -- Area 52, Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold
				["0.58:0.73:0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42"] = 333, -- Area 52, Toshley's Station, Telredor, Temple of Telhamat, Honor Hold
				["0.58:0.73:0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42:0.79:0.45"] = 395, -- Area 52, Toshley's Station, Telredor, Temple of Telhamat, Honor Hold, Hellfire Peninsula
				["0.58:0.73:0.42:0.63:0.38:0.50:0.52:0.49"] = 247, -- Area 52, Toshley's Station, Telredor, Temple of Telhamat
				["0.58:0.73:0.42:0.63:0.38:0.50"] = 165, -- Area 52, Toshley's Station, Telredor
				["0.58:0.73:0.32:0.66:0.27:0.56"] = 202, -- Area 52, Sylvanaar, Orebor Harborage
				["0.58:0.73:0.32:0.66"] = 127, -- Area 52, Sylvanaar
				["0.58:0.73:0.42:0.63"] = 93, -- Area 52, Toshley's Station
				["0.58:0.73:0.42:0.72"] = 80, -- Area 52, Evergrove
				["0.58:0.73:0.72:0.72"] = 66, -- Area 52, Cosmowrench
				["0.58:0.73:0.63:0.82"] = 47, -- Area 52, The Stormspire
				["0.58:0.73:0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42:0.75:0.50"] = 388, -- Area 52, Toshley's Station, Telredor, Temple of Telhamat, Honor Hold, Shatter Point
				["0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.81:0.23"] = 495, -- Area 52, Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.78:0.15"] = 456, -- Area 52, Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.58:0.73:0.32:0.66:0.38:0.50:0.44:0.33"] = 305, -- Area 52, Sylvanaar, Telredor, Shattrath
				["0.58:0.73:0.32:0.66:0.38:0.50:0.44:0.33:0.55:0.23"] = 380, -- Area 52, Sylvanaar, Telredor, Shattrath, Allerian Stronghold
				["0.58:0.73:0.32:0.66:0.38:0.50:0.52:0.49:0.65:0.42"] = 377, -- Area 52, Sylvanaar, Telredor, Temple of Telhamat, Honor Hold
				["0.58:0.73:0.32:0.66:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.78:0.15"] = 499, -- Area 52, Sylvanaar, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.58:0.73:0.32:0.66:0.38:0.50:0.27:0.26"] = 332, -- Area 52, Sylvanaar, Telredor, Telaar
				["0.58:0.73:0.32:0.66:0.38:0.50:0.52:0.49"] = 290, -- Area 52, Sylvanaar, Telredor, Temple of Telhamat
				["0.58:0.73:0.32:0.66:0.38:0.50"] = 208, -- Area 52, Sylvanaar, Telredor
				["0.58:0.73:0.32:0.66:0.38:0.50:0.52:0.49:0.65:0.42:0.75:0.50"] = 431, -- Area 52, Sylvanaar, Telredor, Temple of Telhamat, Honor Hold, Shatter Point
				["0.58:0.73:0.32:0.66:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15"] = 458, -- Area 52, Sylvanaar, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold
				["0.58:0.73:0.32:0.66:0.38:0.50:0.52:0.49:0.65:0.42:0.79:0.45"] = 438, -- Area 52, Sylvanaar, Telredor, Temple of Telhamat, Honor Hold, Hellfire Peninsula

				-- Alliance: Cosmowrench (Netherstorm)
				["0.72:0.72:0.58:0.73:0.42:0.63:0.38:0.50:0.27:0.26"] = 353, -- Cosmowrench, Area 52, Toshley's Station, Telredor, Telaar (Alan Miles reported 65)
				["0.72:0.72:0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33"] = 326, -- Cosmowrench, Area 52, Toshley's Station, Telredor, Shattrath
				["0.72:0.72:0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23"] = 401, -- Cosmowrench, Area 52, Toshley's Station, Telredor, Shattrath, Allerian Stronghold
				["0.72:0.72:0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15"] = 478, -- Cosmowrench, Area 52, Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold
				["0.72:0.72:0.58:0.73:0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42"] = 396, -- Cosmowrench, Area 52, Toshley's Station, Telredor, Temple of Telhamat, Honor Hold
				["0.72:0.72:0.58:0.73:0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42:0.79:0.45"] = 458, -- Cosmowrench, Area 52, Toshley's Station, Telredor, Temple of Telhamat, Honor Hold, Hellfire Peninsula
				["0.72:0.72:0.58:0.73:0.42:0.63:0.38:0.50:0.52:0.49"] = 310, -- Cosmowrench, Area 52, Toshley's Station, Telredor, Temple of Telhamat
				["0.72:0.72:0.58:0.73:0.42:0.63:0.38:0.50"] = 229, -- Cosmowrench, Area 52, Toshley's Station, Telredor
				["0.72:0.72:0.58:0.73:0.32:0.66:0.27:0.56"] = 266, -- Cosmowrench, Area 52, Sylvanaar, Orebor Harborage
				["0.72:0.72:0.58:0.73:0.42:0.63"] = 157, -- Cosmowrench, Area 52, Toshley's Station
				["0.72:0.72:0.58:0.73:0.32:0.66"] = 192, -- Cosmowrench, Area 52, Sylvanaar
				["0.72:0.72:0.58:0.73:0.42:0.72"] = 145, -- Cosmowrench, Area 52, Evergrove
				["0.72:0.72:0.58:0.73"] = 64, -- Cosmowrench, Area 52
				["0.72:0.72:0.63:0.82"] = 61, -- Cosmowrench, The Stormspire
				["0.72:0.72:0.58:0.73:0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42:0.75:0.50"] = 451, -- Cosmowrench, Area 52, Toshley's Station, Telredor, Temple of Telhamat, Honor Hold, Shatter Point
				["0.72:0.72:0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.81:0.23"] = 559, -- Cosmowrench, Area 52, Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.72:0.72:0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.78:0.15"] = 520, -- Cosmowrench, Area 52, Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.72:0.72:0.63:0.82:0.32:0.66:0.38:0.50"] = 296, -- Cosmowrench, The Stormspire, Sylvanaar, Telredor
				["0.72:0.72:0.58:0.73:0.32:0.66:0.38:0.50:0.44:0.33"] = 369, -- Cosmowrench, Area 52, Sylvanaar, Telredor, Shattrath
				["0.72:0.72:0.58:0.73:0.32:0.66:0.38:0.50:0.52:0.49:0.65:0.42"] = 441, -- Cosmowrench, Area 52, Sylvanaar, Telredor, Temple of Telhamat, Honor Hold
				["0.72:0.72:0.58:0.73:0.32:0.66:0.38:0.50:0.52:0.49"] = 353, -- Cosmowrench, Area 52, Sylvanaar, Telredor, Temple of Telhamat
				["0.72:0.72:0.63:0.82:0.32:0.66:0.38:0.50:0.44:0.33"] = 392, -- Cosmowrench, The Stormspire, Sylvanaar, Telredor, Shattrath
				["0.72:0.72:0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33:0.65:0.42"] = 436, -- Cosmowrench, Area 52, Toshley's Station, Telredor, Shattrath, Honor Hold

				-- Alliance: Evergrove (Blade's Edge Mountains)
				["0.42:0.72:0.42:0.63:0.38:0.50:0.27:0.26"] = 240, -- Evergrove, Toshley's Station, Telredor, Telaar
				["0.42:0.72:0.42:0.63:0.38:0.50:0.44:0.33"] = 213, -- Evergrove, Toshley's Station, Telredor, Shattrath
				["0.42:0.72:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23"] = 287, -- Evergrove, Toshley's Station, Telredor, Shattrath, Allerian Stronghold
				["0.42:0.72:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15"] = 366, -- Evergrove, Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold
				["0.42:0.72:0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42"] = 284, -- Evergrove, Toshley's Station, Telredor, Temple of Telhamat, Honor Hold
				["0.42:0.72:0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42:0.79:0.45"] = 346, -- Evergrove, Toshley's Station, Telredor, Temple of Telhamat, Honor Hold, Hellfire Peninsula
				["0.42:0.72:0.42:0.63:0.38:0.50:0.52:0.49"] = 197, -- Evergrove, Toshley's Station, Telredor, Temple of Telhamat
				["0.42:0.72:0.42:0.63:0.38:0.50"] = 116, -- Evergrove, Toshley's Station, Telredor
				["0.42:0.72:0.32:0.66:0.27:0.56"] = 130, -- Evergrove, Sylvanaar, Orebor Harborage
				["0.42:0.72:0.42:0.63"] = 44, -- Evergrove, Toshley's Station
				["0.42:0.72:0.32:0.66"] = 54, -- Evergrove, Sylvanaar
				["0.42:0.72:0.58:0.73"] = 78, -- Evergrove, Area 52
				["0.42:0.72:0.58:0.73:0.63:0.82"] = 124, -- Evergrove, Area 52, The Stormspire
				["0.42:0.72:0.58:0.73:0.72:0.72"] = 143, -- Evergrove, Area 52, Cosmowrench
				["0.42:0.72:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.78:0.15"] = 407, -- Evergrove, Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.42:0.72:0.32:0.66:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.78:0.15"] = 428, -- Evergrove, Sylvanaar, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.42:0.72:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.81:0.23"] = 446, -- Evergrove, Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.42:0.72:0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42:0.75:0.50"] = 339, -- Evergrove, Toshley's Station, Telredor, Temple of Telhamat, Honor Hold, Shatter Point
				["0.42:0.72:0.32:0.66:0.38:0.50:0.27:0.26"] = 261, -- Evergrove, Sylvanaar, Telredor, Telaar
				["0.42:0.72:0.32:0.66:0.38:0.50:0.44:0.33"] = 234, -- Evergrove, Sylvanaar, Telredor, Shattrath
				["0.42:0.72:0.32:0.66:0.38:0.50:0.44:0.33:0.55:0.23"] = 308, -- Evergrove, Sylvanaar, Telredor, Shattrath, Allerian Stronghold
				["0.42:0.72:0.32:0.66:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15"] = 386, -- Evergrove, Sylvanaar, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold
				["0.42:0.72:0.32:0.66:0.38:0.50"] = 137, -- Evergrove, Sylvanaar, Telredor
				["0.42:0.72:0.42:0.63:0.38:0.50:0.27:0.56"] = 178, -- Evergrove, Toshley's Station, Telredor, Orebor Harborage
				["0.42:0.72:0.32:0.66:0.38:0.50:0.52:0.49:0.65:0.42"] = 305, -- Evergrove, Sylvanaar, Telredor, Temple of Telhamat, Honor Hold

				-- Alliance: Hellfire Peninsula (Hellfire Peninsula) (Dark Portal)
				["0.79:0.45:0.65:0.42:0.44:0.33:0.27:0.26"] = 277, -- Hellfire Peninsula, Honor Hold, Shattrath, Telaar
				["0.79:0.45:0.65:0.42:0.44:0.33"] = 190, -- Hellfire Peninsula, Honor Hold, Shattrath
				["0.79:0.45:0.65:0.42:0.55:0.23"] = 188, -- Hellfire Peninsula, Honor Hold, Allerian Stronghold
				["0.79:0.45:0.65:0.42:0.55:0.23:0.69:0.15"] = 266, -- Hellfire Peninsula, Honor Hold, Allerian Stronghold, Wildhammer Stronghold
				["0.79:0.45:0.65:0.42"] = 73, -- Hellfire Peninsula, Honor Hold
				["0.79:0.45:0.52:0.49"] = 115, -- Hellfire Peninsula, Temple of Telhamat
				["0.79:0.45:0.52:0.49:0.38:0.50"] = 196, -- Hellfire Peninsula, Temple of Telhamat, Telredor
				["0.79:0.45:0.52:0.49:0.38:0.50:0.27:0.56"] = 259, -- Hellfire Peninsula, Temple of Telhamat, Telredor, Orebor Harborage
				["0.79:0.45:0.52:0.49:0.38:0.50:0.42:0.63"] = 265, -- Hellfire Peninsula, Temple of Telhamat, Telredor, Toshley's Station
				["0.79:0.45:0.52:0.49:0.38:0.50:0.32:0.66"] = 287, -- Hellfire Peninsula, Temple of Telhamat, Telredor, Sylvanaar
				["0.79:0.45:0.52:0.49:0.38:0.50:0.42:0.63:0.42:0.72"] = 317, -- Hellfire Peninsula, Temple of Telhamat, Telredor, Toshley's Station, Evergrove
				["0.79:0.45:0.52:0.49:0.38:0.50:0.42:0.63:0.58:0.73"] = 348, -- Hellfire Peninsula, Temple of Telhamat, Telredor, Toshley's Station, Area 52
				["0.79:0.45:0.52:0.49:0.38:0.50:0.42:0.63:0.58:0.73:0.72:0.72"] = 413, -- Hellfire Peninsula, Temple of Telhamat, Telredor, Toshley's Station, Area 52, Cosmowrench
				["0.79:0.45:0.52:0.49:0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 396, -- Hellfire Peninsula, Temple of Telhamat, Telredor, Toshley's Station, Area 52, The Stormspire
				["0.79:0.45:0.75:0.50"] = 28, -- Hellfire Peninsula, Shatter Point
				["0.79:0.45:0.65:0.42:0.55:0.23:0.69:0.15:0.81:0.23"] = 348, -- Hellfire Peninsula, Honor Hold, Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.79:0.45:0.65:0.42:0.55:0.23:0.69:0.15:0.78:0.15"] = 308, -- Hellfire Peninsula, Honor Hold, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.79:0.45:0.52:0.49:0.38:0.50:0.27:0.26"] = 321, -- Hellfire Peninsula, Temple of Telhamat, Telredor, Telaar
				["0.79:0.45:0.52:0.49:0.38:0.50:0.32:0.66:0.42:0.72"] = 339, -- Hellfire Peninsula, Temple of Telhamat, Telredor, Sylvanaar, Evergrove
				["0.79:0.45:0.52:0.49:0.38:0.50:0.32:0.66:0.58:0.73"] = 406, -- Hellfire Peninsula, Temple of Telhamat, Telredor, Sylvanaar, Area 52
				["0.79:0.45:0.52:0.49:0.38:0.50:0.32:0.66:0.63:0.82"] = 441, -- Hellfire Peninsula, Temple of Telhamat, Telredor, Sylvanaar, The Stormspire
				["0.79:0.45:0.65:0.42:0.44:0.33:0.38:0.50:0.27:0.56"] = 336, -- Hellfire Peninsula, Honor Hold, Shattrath, Telredor, Orebor Harborage
				["0.79:0.45:0.65:0.42:0.44:0.33:0.38:0.50:0.32:0.66"] = 364, -- Hellfire Peninsula, Honor Hold, Shattrath, Telredor, Sylvanaar
				["0.79:0.45:0.65:0.42:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73"] = 425, -- Hellfire Peninsula, Honor Hold, Shattrath, Telredor, Toshley's Station, Area 52
				["0.79:0.45:0.52:0.49:0.38:0.50:0.32:0.66:0.58:0.73:0.72:0.72"] = 471, -- Hellfire Peninsula, Temple of Telhamat, Telredor, Sylvanaar, Area 52, Cosmowrench
				["0.79:0.45:0.65:0.42:0.44:0.33:0.38:0.50"] = 274, -- Hellfire Peninsula, Honor Hold, Shattrath, Telredor
				["0.79:0.45:0.65:0.42:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 473, -- Hellfire Peninsula, Honor Hold, Shattrath, Telredor, Toshley's Station, Area 52, The Stormspire

				-- Alliance: Honor Hold (Hellfire Peninsula)
				["0.65:0.42:0.44:0.33:0.27:0.26"] = 207, -- Honor Hold, Shattrath, Telaar
				["0.65:0.42:0.44:0.33"] = 120, -- Honor Hold, Shattrath
				["0.65:0.42:0.55:0.23"] = 118, -- Honor Hold, Allerian Stronghold
				["0.65:0.42:0.55:0.23:0.69:0.15"] = 196, -- Honor Hold, Allerian Stronghold, Wildhammer Stronghold
				["0.65:0.42:0.79:0.45"] = 64, -- Honor Hold, Hellfire Peninsula
				["0.65:0.42:0.52:0.49"] = 76, -- Honor Hold, Temple of Telhamat
				["0.65:0.42:0.52:0.49:0.38:0.50"] = 156, -- Honor Hold, Temple of Telhamat, Telredor
				["0.65:0.42:0.52:0.49:0.38:0.50:0.27:0.56"] = 219, -- Honor Hold, Temple of Telhamat, Telredor, Orebor Harborage
				["0.65:0.42:0.52:0.49:0.38:0.50:0.42:0.63"] = 225, -- Honor Hold, Temple of Telhamat, Telredor, Toshley's Station
				["0.65:0.42:0.52:0.49:0.38:0.50:0.32:0.66"] = 248, -- Honor Hold, Temple of Telhamat, Telredor, Sylvanaar
				["0.65:0.42:0.52:0.49:0.38:0.50:0.42:0.63:0.42:0.72"] = 278, -- Honor Hold, Temple of Telhamat, Telredor, Toshley's Station, Evergrove
				["0.65:0.42:0.52:0.49:0.38:0.50:0.42:0.63:0.58:0.73"] = 309, -- Honor Hold, Temple of Telhamat, Telredor, Toshley's Station, Area 52
				["0.65:0.42:0.52:0.49:0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 356, -- Honor Hold, Temple of Telhamat, Telredor, Toshley's Station, Area 52, The Stormspire
				["0.65:0.42:0.52:0.49:0.38:0.50:0.42:0.63:0.58:0.73:0.72:0.72"] = 374, -- Honor Hold, Temple of Telhamat, Telredor, Toshley's Station, Area 52, Cosmowrench
				["0.65:0.42:0.75:0.50"] = 57, -- Honor Hold, Shatter Point
				["0.65:0.42:0.55:0.23:0.69:0.15:0.81:0.23"] = 278, -- Honor Hold, Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.65:0.42:0.55:0.23:0.69:0.15:0.78:0.15"] = 238, -- Honor Hold, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.65:0.42:0.44:0.33:0.38:0.50:0.27:0.56"] = 266, -- Honor Hold, Shattrath, Telredor, Orebor Harborage
				["0.65:0.42:0.44:0.33:0.38:0.50"] = 203, -- Honor Hold, Shattrath, Telredor
				["0.65:0.42:0.52:0.49:0.38:0.50:0.32:0.66:0.58:0.73"] = 366, -- Honor Hold, Temple of Telhamat, Telredor, Sylvanaar, Area 52
				["0.65:0.42:0.55:0.23:0.27:0.26"] = 267, -- Honor Hold, Allerian Stronghold, Telaar
				["0.65:0.42:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 403, -- Honor Hold, Shattrath, Telredor, Toshley's Station, Area 52, The Stormspire
				["0.65:0.42:0.52:0.49:0.38:0.50:0.32:0.66:0.63:0.82"] = 402, -- Honor Hold, Temple of Telhamat, Telredor, Sylvanaar, The Stormspire
				["0.65:0.42:0.52:0.49:0.38:0.50:0.27:0.26"] = 281, -- Honor Hold, Temple of Telhamat, Telredor, Telaar
				["0.65:0.42:0.44:0.33:0.38:0.50:0.32:0.66"] = 295, -- Honor Hold, Shattrath, Telredor, Sylvanaar

				-- Alliance: Orebor Harborage (Zangarmarsh)
				["0.27:0.56:0.38:0.50:0.27:0.26"] = 177, -- Orebor Harborage, Telredor, Telaar
				["0.27:0.56:0.38:0.50:0.44:0.33"] = 150, -- Orebor Harborage, Telredor, Shattrath
				["0.27:0.56:0.38:0.50:0.44:0.33:0.55:0.23"] = 225, -- Orebor Harborage, Telredor, Shattrath, Allerian Stronghold
				["0.27:0.56:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15"] = 302, -- Orebor Harborage, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold
				["0.27:0.56:0.38:0.50:0.52:0.49:0.65:0.42"] = 221, -- Orebor Harborage, Telredor, Temple of Telhamat, Honor Hold
				["0.27:0.56:0.38:0.50:0.52:0.49:0.65:0.42:0.79:0.45"] = 282, -- Orebor Harborage, Telredor, Temple of Telhamat, Honor Hold, Hellfire Peninsula
				["0.27:0.56:0.38:0.50:0.52:0.49"] = 134, -- Orebor Harborage, Telredor, Temple of Telhamat
				["0.27:0.56:0.38:0.50"] = 53, -- Orebor Harborage, Telredor
				["0.27:0.56:0.32:0.66"] = 65, -- Orebor Harborage, Sylvanaar
				["0.27:0.56:0.32:0.66:0.42:0.63"] = 122, -- Orebor Harborage, Sylvanaar, Toshley's Station
				["0.27:0.56:0.32:0.66:0.42:0.72"] = 116, -- Orebor Harborage, Sylvanaar, Evergrove
				["0.27:0.56:0.32:0.66:0.58:0.73"] = 184, -- Orebor Harborage, Sylvanaar, Area 52
				["0.27:0.56:0.32:0.66:0.58:0.73:0.72:0.72"] = 249, -- Orebor Harborage, Sylvanaar, Area 52, Cosmowrench
				["0.27:0.56:0.32:0.66:0.63:0.82"] = 219, -- Orebor Harborage, Sylvanaar, The Stormspire
				["0.27:0.56:0.38:0.50:0.52:0.49:0.65:0.42:0.75:0.50"] = 275, -- Orebor Harborage, Telredor, Temple of Telhamat, Honor Hold, Shatter Point
				["0.27:0.56:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.81:0.23"] = 384, -- Orebor Harborage, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.27:0.56:0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 253, -- Orebor Harborage, Telredor, Toshley's Station, Area 52, The Stormspire
				["0.27:0.56:0.38:0.50:0.44:0.33:0.65:0.42"] = 261, -- Orebor Harborage, Telredor, Shattrath, Honor Hold
				["0.27:0.56:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.78:0.15"] = 344, -- Orebor Harborage, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.27:0.56:0.38:0.50:0.42:0.63"] = 121, -- Orebor Harborage, Telredor, Toshley's Station

				-- Alliance: Sanctum of the Stars (Shadowmoon Valley)
				["0.78:0.15:0.55:0.23:0.44:0.33"] = 215, -- Sanctum of the Stars, Allerian Stronghold, Shattrath
				["0.78:0.15:0.55:0.23"] = 142, -- Sanctum of the Stars, Allerian Stronghold
				["0.78:0.15:0.69:0.15"] = 42, -- Sanctum of the Stars, Wildhammer Stronghold
				["0.78:0.15:0.55:0.23:0.27:0.26"] = 290, -- Sanctum of the Stars, Allerian Stronghold, Telaar
				["0.78:0.15:0.55:0.23:0.65:0.42"] = 237, -- Sanctum of the Stars, Allerian Stronghold, Honor Hold
				["0.78:0.15:0.55:0.23:0.65:0.42:0.79:0.45"] = 296, -- Sanctum of the Stars, Allerian Stronghold, Honor Hold, Hellfire Peninsula
				["0.78:0.15:0.55:0.23:0.65:0.42:0.75:0.50"] = 290, -- Sanctum of the Stars, Allerian Stronghold, Honor Hold, Shatter Point
				["0.78:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73"] = 450, -- Sanctum of the Stars, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52
				["0.78:0.15:0.55:0.23:0.65:0.42:0.52:0.49"] = 311, -- Sanctum of the Stars, Allerian Stronghold, Honor Hold, Temple of Telhamat
				["0.78:0.15:0.55:0.23:0.44:0.33:0.38:0.50"] = 298, -- Sanctum of the Stars, Allerian Stronghold, Shattrath, Telredor
				["0.78:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.72:0.72"] = 515, -- Sanctum of the Stars, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52, Cosmowrench
				["0.78:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66"] = 389, -- Sanctum of the Stars, Allerian Stronghold, Shattrath, Telredor, Sylvanaar
				["0.78:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.27:0.56"] = 361, -- Sanctum of the Stars, Allerian Stronghold, Shattrath, Telredor, Orebor Harborage
				["0.78:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63"] = 366, -- Sanctum of the Stars, Allerian Stronghold, Shattrath, Telredor, Toshley's Station
				["0.78:0.15:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.42:0.72"] = 419, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Evergrove
				["0.78:0.15:0.69:0.15:0.55:0.23:0.44:0.33"] = 215, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Shattrath
				["0.78:0.15:0.69:0.15:0.55:0.23"] = 142, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold
				["0.78:0.15:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66"] = 389, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Sylvanaar
				["0.78:0.15:0.69:0.15:0.55:0.23:0.65:0.42"] = 237, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Honor Hold
				["0.78:0.15:0.69:0.15:0.55:0.23:0.27:0.26"] = 290, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Telaar
				["0.78:0.15:0.69:0.15:0.55:0.23:0.65:0.42:0.79:0.45"] = 296, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Honor Hold, Hellfire Peninsula
				["0.78:0.15:0.69:0.15:0.55:0.23:0.65:0.42:0.75:0.50"] = 290, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Honor Hold, Shatter Point
				["0.78:0.15:0.69:0.15:0.55:0.23:0.65:0.42:0.52:0.49"] = 311, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Honor Hold, Temple of Telhamat
				["0.78:0.15:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50"] = 298, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor
				["0.78:0.15:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.27:0.56"] = 361, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Orebor Harborage
				["0.78:0.15:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.72:0.72"] = 516, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52, Cosmowrench
				["0.78:0.15:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63"] = 367, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Toshley's Station
				["0.78:0.15:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 498, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52, The Stormspire
				["0.78:0.15:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73"] = 450, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52
				["0.78:0.15:0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66:0.42:0.72"] = 440, -- Sanctum of the Stars, Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Sylvanaar, Evergrove

				-- Alliance: Shatter Point (Hellfire Peninsula)
				["0.75:0.50:0.79:0.45"] = 33, -- Shatter Point, Hellfire Peninsula
				["0.75:0.50:0.65:0.42"] = 57, -- Shatter Point, Honor Hold
				["0.75:0.50:0.65:0.42:0.55:0.23:0.69:0.15:0.81:0.23"] = 334, -- Shatter Point, Honor Hold, Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.75:0.50:0.65:0.42:0.55:0.23:0.69:0.15"] = 252, -- Shatter Point, Honor Hold, Allerian Stronghold, Wildhammer Stronghold
				["0.75:0.50:0.65:0.42:0.55:0.23"] = 174, -- Shatter Point, Honor Hold, Allerian Stronghold
				["0.75:0.50:0.65:0.42:0.52:0.49"] = 132, -- Shatter Point, Honor Hold, Temple of Telhamat
				["0.75:0.50:0.65:0.42:0.52:0.49:0.38:0.50"] = 213, -- Shatter Point, Honor Hold, Temple of Telhamat, Telredor
				["0.75:0.50:0.65:0.42:0.44:0.33"] = 175, -- Shatter Point, Honor Hold, Shattrath
				["0.75:0.50:0.65:0.42:0.44:0.33:0.27:0.26"] = 263, -- Shatter Point, Honor Hold, Shattrath, Telaar
				["0.75:0.50:0.65:0.42:0.52:0.49:0.38:0.50:0.42:0.63:0.58:0.73:0.72:0.72"] = 430, -- Shatter Point, Honor Hold, Temple of Telhamat, Telredor, Toshley's Station, Area 52, Cosmowrench
				["0.75:0.50:0.65:0.42:0.52:0.49:0.38:0.50:0.42:0.63:0.58:0.73"] = 364, -- Shatter Point, Honor Hold, Temple of Telhamat, Telredor, Toshley's Station, Area 52
				["0.75:0.50:0.65:0.42:0.52:0.49:0.38:0.50:0.27:0.56"] = 275, -- Shatter Point, Honor Hold, Temple of Telhamat, Telredor, Orebor Harborage
				["0.75:0.50:0.65:0.42:0.52:0.49:0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 412, -- Shatter Point, Honor Hold, Temple of Telhamat, Telredor, Toshley's Station, Area 52, The Stormspire
				["0.75:0.50:0.65:0.42:0.55:0.23:0.69:0.15:0.78:0.15"] = 294, -- Shatter Point, Honor Hold, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.75:0.50:0.65:0.42:0.52:0.49:0.38:0.50:0.42:0.63"] = 282, -- Shatter Point, Honor Hold, Temple of Telhamat, Telredor, Toshley's Station
				["0.75:0.50:0.65:0.42:0.52:0.49:0.38:0.50:0.42:0.63:0.42:0.72"] = 334, -- Shatter Point, Honor Hold, Temple of Telhamat, Telredor, Toshley's Station, Evergrove
				["0.75:0.50:0.65:0.42:0.52:0.49:0.38:0.50:0.32:0.66"] = 303, -- Shatter Point, Honor Hold, Temple of Telhamat, Telredor, Sylvanaar

				-- Alliance: Shattrath (Terokkar Forest)
				["0.44:0.33:0.27:0.26"] = 88, -- Shattrath, Telaar
				["0.44:0.33:0.55:0.23"] = 75, -- Shattrath, Allerian Stronghold (r-beauvais@hotmail.com reported 38)
				["0.44:0.33:0.55:0.23:0.69:0.15"] = 153, -- Shattrath, Allerian Stronghold, Wildhammer Stronghold
				["0.44:0.33:0.65:0.42:0.79:0.45"] = 172, -- Shattrath, Honor Hold, Hellfire Peninsula
				["0.44:0.33:0.65:0.42"] = 111, -- Shattrath, Honor Hold (Juniardo reported 157)
				["0.44:0.33:0.38:0.50:0.52:0.49"] = 165, -- Shattrath, Telredor, Temple of Telhamat
				["0.44:0.33:0.38:0.50"] = 84, -- Shattrath, Telredor
				["0.44:0.33:0.38:0.50:0.27:0.56"] = 146, -- Shattrath, Telredor, Orebor Harborage
				["0.44:0.33:0.38:0.50:0.42:0.63"] = 152, -- Shattrath, Telredor, Toshley's Station
				["0.44:0.33:0.38:0.50:0.32:0.66"] = 175, -- Shattrath, Telredor, Sylvanaar
				["0.44:0.33:0.38:0.50:0.42:0.63:0.42:0.72"] = 205, -- Shattrath, Telredor, Toshley's Station, Evergrove
				["0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73"] = 235, -- Shattrath, Telredor, Toshley's Station, Area 52
				["0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.72:0.72"] = 301, -- Shattrath, Telredor, Toshley's Station, Area 52, Cosmowrench
				["0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 284, -- Shattrath, Telredor, Toshley's Station, Area 52, The Stormspire
				["0.44:0.33:0.55:0.23:0.69:0.15:0.81:0.23"] =  235, -- Shattrath, Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.44:0.33:0.65:0.42:0.75:0.50"] = 165, -- Shattrath, Honor Hold, Shatter Point
				["0.44:0.33:0.55:0.23:0.69:0.15:0.78:0.15"] = 195, -- Shattrath, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.44:0.33:0.38:0.50:0.32:0.66:0.58:0.73:0.72:0.72"] = 359, -- Shattrath, Telredor, Sylvanaar, Area 52, Cosmowrench
				["0.44:0.33:0.65:0.42:0.52:0.49"] = 185, -- Shattrath, Honor Hold, Temple of Telhamat
				["0.44:0.33:0.38:0.50:0.32:0.66:0.63:0.82"] = 329, -- Shattrath, Telredor, Sylvanaar, The Stormspire
				["0.44:0.33:0.38:0.50:0.32:0.66:0.58:0.73"] = 294, -- Shattrath, Telredor, Sylvanaar, Area 52
				["0.44:0.33:0.38:0.50:0.32:0.66:0.42:0.72"] = 226, -- Shattrath, Telredor, Sylvanaar, Evergrove
				["0.44:0.33:0.38:0.50:0.32:0.66:0.63:0.82:0.72:0.72"] = 398, -- Shattrath, Telredor, Sylvanaar, The Stormspire, Cosmowrench

				-- Alliance: Sylvanaar (Blade's Edge Mountains)
				["0.32:0.66:0.38:0.50:0.27:0.26"] = 207, -- Sylvanaar, Telredor, Telaar
				["0.32:0.66:0.38:0.50:0.44:0.33"] = 179, -- Sylvanaar, Telredor, Shattrath
				["0.32:0.66:0.38:0.50:0.44:0.33:0.55:0.23"] = 255, -- Sylvanaar, Telredor, Shattrath, Allerian Stronghold
				["0.32:0.66:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15"] = 332, -- Sylvanaar, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold
				["0.32:0.66:0.38:0.50:0.52:0.49:0.65:0.42"] = 251, -- Sylvanaar, Telredor, Temple of Telhamat, Honor Hold
				["0.32:0.66:0.38:0.50:0.52:0.49:0.65:0.42:0.79:0.45"] = 312, -- Sylvanaar, Telredor, Temple of Telhamat, Honor Hold, Hellfire Peninsula
				["0.32:0.66:0.38:0.50:0.52:0.49"] = 164, -- Sylvanaar, Telredor, Temple of Telhamat
				["0.32:0.66:0.38:0.50"] = 82, -- Sylvanaar, Telredor
				["0.32:0.66:0.27:0.56"] = 76, -- Sylvanaar, Orebor Harborage
				["0.32:0.66:0.42:0.63"] = 57, -- Sylvanaar, Toshley's Station
				["0.32:0.66:0.42:0.72"] = 51, -- Sylvanaar, Evergrove
				["0.32:0.66:0.58:0.73"] = 119, -- Sylvanaar, Area 52
				["0.32:0.66:0.63:0.82"] = 155, -- Sylvanaar, The Stormspire
				["0.32:0.66:0.58:0.73:0.72:0.72"] = 185, -- Sylvanaar, Area 52, Cosmowrench
				["0.32:0.66:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.78:0.15"] = 373, -- Sylvanaar, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.32:0.66:0.38:0.50:0.52:0.49:0.65:0.42:0.75:0.50"] = 305, -- Sylvanaar, Telredor, Temple of Telhamat, Honor Hold, Shatter Point
				["0.32:0.66:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.81:0.23"] = 413, -- Sylvanaar, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.32:0.66:0.38:0.50:0.44:0.33:0.65:0.42"] = 289, -- Sylvanaar, Telredor, Shattrath, Honor Hold
				["0.32:0.66:0.38:0.50:0.44:0.33:0.65:0.42:0.79:0.45"] = 350, -- Sylvanaar, Telredor, Shattrath, Ehrenfeste, Höllenfeuerhalbinsel

				-- Alliance: Telaar (Nagrand)
				["0.27:0.26:0.44:0.33"] = 88, -- Telaar, Shattrath
				["0.27:0.26:0.55:0.23"] = 122, -- Telaar, Allerian Stronghold
				["0.27:0.26:0.55:0.23:0.69:0.15"] = 200, -- Telaar, Allerian Stronghold, Wildhammer Stronghold
				["0.27:0.26:0.44:0.33:0.65:0.42:0.79:0.45"] = 260, -- Telaar, Shattrath, Honor Hold, Hellfire Peninsula
				["0.27:0.26:0.44:0.33:0.65:0.42"] = 199, -- Telaar, Shattrath, Honor Hold
				["0.27:0.26:0.38:0.50:0.52:0.49"] = 208, -- Telaar, Telredor, Temple of Telhamat
				["0.27:0.26:0.38:0.50"] = 126, -- Telaar, Telredor
				["0.27:0.26:0.38:0.50:0.27:0.56"] = 189, -- Telaar, Telredor, Orebor Harborage
				["0.27:0.26:0.38:0.50:0.42:0.63"] = 195, -- Telaar, Telredor, Toshley's Station
				["0.27:0.26:0.38:0.50:0.32:0.66"] = 217, -- Telaar, Telredor, Sylvanaar
				["0.27:0.26:0.38:0.50:0.42:0.63:0.42:0.72"] = 248, -- Telaar, Telredor, Toshley's Station, Evergrove
				["0.27:0.26:0.38:0.50:0.42:0.63:0.58:0.73"] = 280, -- Telaar, Telredor, Toshley's Station, Area 52
				["0.27:0.26:0.38:0.50:0.42:0.63:0.58:0.73:0.72:0.72"] = 344, -- Telaar, Telredor, Toshley's Station, Area 52, Cosmowrench
				["0.27:0.26:0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 327, -- Telaar, Telredor, Toshley's Station, Area 52, The Stormspire
				["0.27:0.26:0.55:0.23:0.69:0.15:0.81:0.23"] = 281, -- Telaar, Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.27:0.26:0.44:0.33:0.65:0.42:0.75:0.50"] = 253, -- Telaar, Shattrath, Honor Hold, Shatter Point
				["0.27:0.26:0.55:0.23:0.69:0.15:0.78:0.15"] = 241, -- Telaar, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.27:0.26:0.38:0.50:0.32:0.66:0.42:0.72"] = 269, -- Telaar, Telredor, Sylvanaar, Evergrove
				["0.27:0.26:0.38:0.50:0.32:0.66:0.58:0.73"] = 336, -- Telaar, Telredor, Sylvanaar, Area 52
				["0.27:0.26:0.44:0.33:0.65:0.42:0.52:0.49"] = 273, -- Telaar, Shattrath, Honor Hold, Temple of Telhamat
				["0.27:0.26:0.38:0.50:0.32:0.66:0.58:0.73:0.72:0.72"] = 402, -- Telaar, Telredor, Sylvanaar, Area 52, Cosmowrench
				["0.27:0.26:0.38:0.50:0.52:0.49:0.65:0.42"] = 295, -- Telaar, Telredor, Temple of Telhamat, Honor Hold

				-- Alliance: Telredor (Zangarmarsh)
				["0.38:0.50:0.27:0.26"] = 125, -- Telredor, Telaar
				["0.38:0.50:0.44:0.33"] = 97, -- Telredor, Shattrath
				["0.38:0.50:0.44:0.33:0.55:0.23"] = 172, -- Telredor, Shattrath, Allerian Stronghold
				["0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15"] = 250, -- Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold
				["0.38:0.50:0.52:0.49:0.65:0.42"] = 169, -- Telredor, Temple of Telhamat, Honor Hold
				["0.38:0.50:0.52:0.49:0.65:0.42:0.79:0.45"] = 230, -- Telredor, Temple of Telhamat, Honor Hold, Hellfire Peninsula
				["0.38:0.50:0.52:0.49"] = 82, -- Telredor, Temple of Telhamat
				["0.38:0.50:0.27:0.56"] = 63, -- Telredor, Orebor Harborage
				["0.38:0.50:0.32:0.66"] = 91, -- Telredor, Sylvanaar
				["0.38:0.50:0.42:0.63"] = 69, -- Telredor, Toshley's Station
				["0.38:0.50:0.42:0.63:0.42:0.72"] = 121, -- Telredor, Toshley's Station, Evergrove
				["0.38:0.50:0.42:0.63:0.58:0.73"] = 153, -- Telredor, Toshley's Station, Area 52
				["0.38:0.50:0.42:0.63:0.58:0.73:0.72:0.72"] = 219, -- Telredor, Toshley's Station, Area 52, Cosmowrench
				["0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 200, -- Telredor, Toshley's Station, Area 52, The Stormspire
				["0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.81:0.23"] = 331, -- Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.38:0.50:0.52:0.49:0.65:0.42:0.75:0.50"] = 223, -- Telredor, Temple of Telhamat, Honor Hold, Shatter Point
				["0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.78:0.15"] = 292, -- Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.38:0.50:0.32:0.66:0.58:0.73:0.72:0.72"] = 276, -- Telredor, Sylvanaar, Area 52, Cosmowrench
				["0.38:0.50:0.32:0.66:0.42:0.72"] = 142, -- Telredor, Sylvanaar, Evergrove
				["0.38:0.50:0.44:0.33:0.65:0.42"] = 208, -- Telredor, Shattrath, Honor Hold
				["0.38:0.50:0.52:0.49:0.65:0.42:0.55:0.23"] = 284, -- Telredor, Temple of Telhamat, Honor Hold, Allerian Stronghold
				["0.38:0.50:0.32:0.66:0.63:0.82"] = 245, -- Telredor, Sylvanaar, The Stormspire
				["0.38:0.50:0.32:0.66:0.58:0.73"] = 210, -- Telredor, Sylvanaar, Area 52

				-- Alliance: Temple of Telhamat (Hellfire Peninsula)
				["0.52:0.49:0.38:0.50:0.27:0.26"] = 206, -- Temple of Telhamat, Telredor, Telaar
				["0.52:0.49:0.38:0.50:0.44:0.33"] = 178, -- Temple of Telhamat, Telredor, Shattrath
				["0.52:0.49:0.65:0.42:0.55:0.23"] = 203, -- Temple of Telhamat, Honor Hold, Allerian Stronghold
				["0.52:0.49:0.65:0.42:0.55:0.23:0.69:0.15"] = 281, -- Temple of Telhamat, Honor Hold, Allerian Stronghold, Wildhammer Stronghold
				["0.52:0.49:0.65:0.42"] = 88, -- Temple of Telhamat, Honor Hold
				["0.52:0.49:0.65:0.42:0.79:0.45"] = 149, -- Temple of Telhamat, Honor Hold, Hellfire Peninsula
				["0.52:0.49:0.38:0.50"] = 81, -- Temple of Telhamat, Telredor
				["0.52:0.49:0.38:0.50:0.27:0.56"] = 144, -- Temple of Telhamat, Telredor, Orebor Harborage
				["0.52:0.49:0.38:0.50:0.42:0.63"] = 150, -- Temple of Telhamat, Telredor, Toshley's Station
				["0.52:0.49:0.38:0.50:0.32:0.66"] = 172, -- Temple of Telhamat, Telredor, Sylvanaar
				["0.52:0.49:0.38:0.50:0.42:0.63:0.42:0.72"] = 203, -- Temple of Telhamat, Telredor, Toshley's Station, Evergrove
				["0.52:0.49:0.38:0.50:0.42:0.63:0.58:0.73"] = 233, -- Temple of Telhamat, Telredor, Toshley's Station, Area 52
				["0.52:0.49:0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 280, -- Temple of Telhamat, Telredor, Toshley's Station, Area 52, The Stormspire
				["0.52:0.49:0.38:0.50:0.42:0.63:0.58:0.73:0.72:0.72"] = 298, -- Temple of Telhamat, Telredor, Toshley's Station, Area 52, Cosmowrench
				["0.52:0.49:0.65:0.42:0.75:0.50"] = 142, -- Temple of Telhamat, Honor Hold, Shatter Point
				["0.52:0.49:0.65:0.42:0.55:0.23:0.69:0.15:0.81:0.23"] = 362, -- Temple of Telhamat, Honor Hold, Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.52:0.49:0.65:0.42:0.55:0.23:0.69:0.15:0.78:0.15"] = 323, -- Temple of Telhamat, Honor Hold, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.52:0.49:0.65:0.42:0.44:0.33"] = 204, -- Temple of Telhamat, Honor Hold, Shattrath
				["0.52:0.49:0.38:0.50:0.32:0.66:0.42:0.72"] = 223, -- Temple of Telhamat, Telredor, Sylvanaar, Evergrove
				["0.52:0.49:0.65:0.42:0.44:0.33:0.27:0.26"] = 292, -- Tempel von Telhamat, Ehrenfeste, Shattrath, Telaar
				["0.52:0.49:0.38:0.50:0.32:0.66:0.58:0.73"] = 291, -- Temple of Telhamat, Telredor, Sylvanaar, Area 52

				-- Alliance: The Stormspire (Netherstorm)
				["0.63:0.82:0.58:0.73:0.42:0.63:0.38:0.50:0.27:0.26"] = 341, -- The Stormspire, Area 52, Toshley's Station, Telredor, Telaar
				["0.63:0.82:0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33"] = 315, -- The Stormspire, Area 52, Toshley's Station, Telredor, Shattrath
				["0.63:0.82:0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23"] = 390, -- The Stormspire, Area 52, Toshley's Station, Telredor, Shattrath, Allerian Stronghold
				["0.63:0.82:0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15"] = 467, -- The Stormspire, Area 52, Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold
				["0.63:0.82:0.58:0.73:0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42"] = 386, -- The Stormspire, Area 52, Toshley's Station, Telredor, Temple of Telhamat, Honor Hold
				["0.63:0.82:0.58:0.73:0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42:0.79:0.45"] = 448, -- The Stormspire, Area 52, Toshley's Station, Telredor, Temple of Telhamat, Honor Hold, Hellfire Peninsula
				["0.63:0.82:0.58:0.73:0.42:0.63:0.38:0.50:0.52:0.49"] = 302, -- The Stormspire, Area 52, Toshley's Station, Telredor, Temple of Telhamat
				["0.63:0.82:0.58:0.73:0.42:0.63:0.38:0.50"] = 220, -- The Stormspire, Area 52, Toshley's Station, Telredor
				["0.63:0.82:0.32:0.66:0.27:0.56"] = 230, -- The Stormspire, Sylvanaar, Orebor Harborage
				["0.63:0.82:0.58:0.73:0.42:0.63"] = 146, -- The Stormspire, Area 52, Toshley's Station
				["0.63:0.82:0.32:0.66"] = 154, -- The Stormspire, Sylvanaar
				["0.63:0.82:0.58:0.73:0.42:0.72"] = 132, -- The Stormspire, Area 52, Evergrove
				["0.63:0.82:0.58:0.73"] = 53, -- The Stormspire, Area 52
				["0.63:0.82:0.72:0.72"] = 69, -- The Stormspire, Cosmowrench
				["0.63:0.82:0.58:0.73:0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42:0.75:0.50"] = 440, -- The Stormspire, Area 52, Toshley's Station, Telredor, Temple of Telhamat, Honor Hold, Shatter Point
				["0.63:0.82:0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.81:0.23"] = 549, -- The Stormspire, Area 52, Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.63:0.82:0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.78:0.15"] = 509, -- The Stormspire, Area 52, Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.63:0.82:0.32:0.66:0.38:0.50:0.44:0.33"] = 332, -- The Stormspire, Sylvanaar, Telredor, Shattrath
				["0.63:0.82:0.32:0.66:0.38:0.50"] = 236, -- The Stormspire, Sylvanaar, Telredor
				["0.63:0.82:0.32:0.66:0.38:0.50:0.27:0.26"] = 360, -- The Stormspire, Sylvanaar, Telredor, Telaar
				["0.63:0.82:0.32:0.66:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15"] = 485, -- The Stormspire, Sylvanaar, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold
				["0.63:0.82:0.32:0.66:0.38:0.50:0.52:0.49:0.65:0.42"] = 404, -- The Stormspire, Sylvanaar, Telredor, Temple of Telhamat, Honor Hold
				["0.63:0.82:0.32:0.66:0.38:0.50:0.44:0.33:0.55:0.23"] = 407, -- The Stormspire, Sylvanaar, Telredor, Shattrath, Allerian Stronghold
				["0.63:0.82:0.32:0.66:0.38:0.50:0.52:0.49"] = 317, -- The Stormspire, Sylvanaar, Telredor, Temple of Telhamat
				["0.63:0.82:0.58:0.73:0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42:0.55:0.23"] = 502, -- The Stormspire, Area 52, Toshley's Station, Telredor, Temple of Telhamat, Honor Hold, Allerian Stronghold
				["0.63:0.82:0.58:0.73:0.42:0.63:0.38:0.50:0.44:0.33:0.65:0.42"] = 426, -- The Stormspire, Area 52, Toshley's Station, Telredor, Shattrath, Honor Hold

				-- Alliance: Toshley's Station (Blade's Edge Mountains)
				["0.42:0.63:0.38:0.50:0.27:0.26"] = 197, -- Toshley's Station, Telredor, Telaar (was 265, changed to 197 by kaungmo@gmail.com and Thomas Jespersen)
				["0.42:0.63:0.38:0.50:0.44:0.33"] = 170, -- Toshley's Station, Telredor, Shattrath
				["0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23"] = 245, -- Toshley's Station, Telredor, Shattrath, Allerian Stronghold
				["0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15"] = 321, -- Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold
				["0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42:0.79:0.45"] = 302, -- Toshley's Station, Telredor, Temple of Telhamat, Honor Hold, Hellfire Peninsula
				["0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42"] = 241, -- Toshley's Station, Telredor, Temple of Telhamat, Honor Hold
				["0.42:0.63:0.38:0.50:0.52:0.49"] = 154, -- Toshley's Station, Telredor, Temple of Telhamat
				["0.42:0.63:0.38:0.50"] = 73, -- Toshley's Station, Telredor
				["0.42:0.63:0.32:0.66:0.27:0.56"] = 134, -- Toshley's Station, Sylvanaar, Orebor Harborage
				["0.42:0.63:0.32:0.66"] = 60, -- Toshley's Station, Sylvanaar
				["0.42:0.63:0.42:0.72"] = 53, -- Toshley's Station, Evergrove
				["0.42:0.63:0.58:0.73"] = 84, -- Toshley's Station, Area 52
				["0.42:0.63:0.58:0.73:0.63:0.82"] = 132, -- Toshley's Station, Area 52, The Stormspire
				["0.42:0.63:0.58:0.73:0.72:0.72"] = 150, -- Toshley's Station, Area 52, Cosmowrench
				["0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.81:0.23"] = 403, -- Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Altar of Sha'tar
				["0.42:0.63:0.38:0.50:0.52:0.49:0.65:0.42:0.75:0.50"] = 295, -- Toshley's Station, Telredor, Temple of Telhamat, Honor Hold, Shatter Point
				["0.42:0.63:0.38:0.50:0.44:0.33:0.55:0.23:0.69:0.15:0.78:0.15"] = 364, -- Toshley's Station, Telredor, Shattrath, Allerian Stronghold, Wildhammer Stronghold, Sanctum of the Stars
				["0.42:0.63:0.38:0.50:0.27:0.26:0.55:0.23"] = 318, -- Toshley's Station, Telredor, Telaar, Allerian Stronghold
				["0.42:0.63:0.38:0.50:0.44:0.33:0.65:0.42"] = 280, -- Toshley's Station, Telredor, Shattrath, Honor Hold

				-- Alliance: Wildhammer Stronghold (Shadowmoon Valley)
				["0.69:0.15:0.55:0.23:0.27:0.26"] = 249, -- Wildhammer Stronghold, Allerian Stronghold, Telaar
				["0.69:0.15:0.55:0.23:0.44:0.33"] = 174, -- Wildhammer Stronghold, Allerian Stronghold, Shattrath
				["0.69:0.15:0.55:0.23"] = 101, -- Wildhammer Stronghold, Allerian Stronghold
				["0.69:0.15:0.55:0.23:0.65:0.42"] = 196, -- Wildhammer Stronghold, Allerian Stronghold, Honor Hold
				["0.69:0.15:0.55:0.23:0.65:0.42:0.79:0.45"] = 256, -- Wildhammer Stronghold, Allerian Stronghold, Honor Hold, Hellfire Peninsula
				["0.69:0.15:0.55:0.23:0.65:0.42:0.52:0.49"] = 270, -- Wildhammer Stronghold, Allerian Stronghold, Honor Hold, Temple of Telhamat
				["0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50"] = 257, -- Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor
				["0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.27:0.56"] = 320, -- Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Orebor Harborage
				["0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63"] = 326, -- Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Toshley's Station
				["0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66"] = 348, -- Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Sylvanaar
				["0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.42:0.72"] = 379, -- Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Evergrove
				["0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73"] = 409, -- Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52
				["0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.72:0.72"] = 475, -- Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52, Cosmowrench
				["0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.42:0.63:0.58:0.73:0.63:0.82"] = 457, -- Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Toshley's Station, Area 52, The Stormspire
				["0.69:0.15:0.81:0.23"] = 84, -- Wildhammer Stronghold, Altar of Sha'tar
				["0.69:0.15:0.55:0.23:0.65:0.42:0.75:0.50"] = 250, -- Wildhammer Stronghold, Allerian Stronghold, Honor Hold, Shatter Point
				["0.69:0.15:0.78:0.15"] = 43, -- Wildhammer Stronghold, Sanctum of the Stars
				["0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66:0.63:0.82"] = 503, -- Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Sylvanaar, The Stormspire
				["0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66:0.42:0.72"] = 399, -- Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Sylvanaar, Evergrove
				["0.69:0.15:0.55:0.23:0.44:0.33:0.38:0.50:0.32:0.66:0.58:0.73"] = 467, -- Wildhammer Stronghold, Allerian Stronghold, Shattrath, Telredor, Sylvanaar, Area 52

			},

			-- Alliance: Northrend
			[4] = {

				----------------------------------------------------------------------
				-- Alliance: Borean Tundra
				----------------------------------------------------------------------

				-- Alliance: Borean Tundra: Amber Ledge
				["0.17:0.47:0.12:0.47"] = 25, -- Amber Ledge, Transitus Shield
				["0.17:0.47:0.21:0.51"] = 24, -- Amber Ledge, Fizzcrank Airstrip
				["0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62"] = 194, -- Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran
				["0.17:0.47:0.21:0.51:0.24:0.60"] = 65, -- Amber Ledge, Fizzcrank Airstrip, River's Heart
				["0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.56:0.64"] = 209, -- Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, The Argent Vanguard
				["0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46:0.88:0.40"] = 316, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29:0.88:0.28"] = 320, -- Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua, Valgarde Port
				["0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29"] = 267, -- Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua
				["0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46"] = 239, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Amberpine Lodge
				["0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 278, -- Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.17:0.47:0.22:0.39"] = 45, -- Amber Ledge, Valiance Keep
				["0.17:0.47:0.21:0.51:0.29:0.43"] = 66, -- Amber Ledge, Fizzcrank Airstrip, Unu'pe
				["0.17:0.47:0.21:0.51:0.42:0.47"] = 112, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest
				["0.17:0.47:0.21:0.51:0.42:0.47:0.41:0.57"] = 154, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Valiance Landing Camp
				["0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54"] = 164, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold
				["0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.76:0.33"] = 273, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Westguard Keep
				["0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46:0.83:0.54"] = 293, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62"] = 300, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga
				["0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60"] = 273, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand
				["0.17:0.47:0.22:0.39:0.42:0.47"] = 140, -- Amber Ledge, Valiance Keep, Stars' Rest
				["0.17:0.47:0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62"] = 233, -- Amber Ledge, Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran
				["0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.76:0.33:0.88:0.28"] = 318, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.17:0.47:0.22:0.39:0.42:0.47:0.60:0.48:0.76:0.33:0.88:0.28"] = 346, -- Amber Ledge, Valiance Keep, Stars' Rest, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42:0.60:0.48"] = 201, -- Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki, Wintergarde Keep
				["0.17:0.47:0.21:0.51:0.42:0.47:0.54:0.48"] = 171, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wyrmrest Temple
				["0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.69:0.58"] = 276, -- Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Light's Breach
				["0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42"] = 145, -- Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki
				["0.17:0.47:0.22:0.39:0.42:0.47:0.54:0.48:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81:0.72:0.71"] = 436, -- Amber Ledge, Valiance Keep, Stars' Rest, Wyrmrest Temple, Dalaran, The Argent Vanguard, Frosthold, Ulduar, Dun Nifflelem
				["0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62"] = 207, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran
				["0.17:0.47:0.22:0.39:0.42:0.47:0.60:0.48:0.73:0.46"] = 267, -- Amber Ledge, Valiance Keep, Stars' Rest, Wintergarde Keep, Amberpine Lodge
				["0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48"] = 221, -- Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep
				["0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42:0.52:0.62"] = 226, -- Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki, Dalaran
				["0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.69:0.58"] = 247, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Light's Breach
				["0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42"] = 164, -- Amber Ledge, Valiance Keep, Unu'pe, Moa'ki
				["0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29:0.76:0.33"] = 291, -- Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua, Westguard Keep
				["0.17:0.47:0.22:0.39:0.42:0.47:0.54:0.48"] = 198, -- Amber Ledge, Valiance Keep, Stars' Rest, Wyrmrest Temple
				["0.17:0.47:0.21:0.51:0.18:0.60"] = 74, -- Amber Ledge, Fizzcrank Airstrip, Nesingwary Base Camp
				["0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48"] = 192, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep
				["0.17:0.47:0.21:0.51:0.42:0.47:0.54:0.48:0.52:0.62"] = 234, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wyrmrest Temple, Dalaran
				["0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.52:0.62:0.52:0.66"] = 264, -- Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Dalaran, Crusaders' Pinnacle
				["0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.74:0.29"] = 287, -- Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Kamagua
				["0.17:0.47:0.21:0.51:0.24:0.60:0.28:0.72"] = 123, -- Amber Ledge, Fizzcrank Airstrip, River's Heart, Death's Rise
				["0.17:0.47:0.22:0.39:0.29:0.43"] = 86, -- Amber Ledge, Valiance Keep, Unu'pe
				["0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.76:0.33"] = 301, -- Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Westguard Keep
				["0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58"] = 231, -- Bernsteinflöz, Landebahn Kurbelzisch, Sternenruh, Feste Wintergarde, Schwarze Wacht
				["0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.73:0.46:0.83:0.54"] = 321, -- Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 336, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.17:0.47:0.21:0.51:0.42:0.47:0.41:0.57:0.28:0.72"] = 264, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Valiance Landing Camp, Death's Rise
				["0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62:0.62:0.64:0.72:0.71"] = 304, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran, K3, Dun Nifflelem
				["0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 313, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.17:0.47:0.21:0.51:0.42:0.47:0.41:0.57:0.52:0.66"] = 226, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Valiance Landing Camp, Crusaders' Pinnacle
				["0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62:0.52:0.66:0.38:0.79"] = 308, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.62:0.64"] = 225, -- Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, K3
				["0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.62:0.64:0.72:0.71"] = 292, -- Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, K3, Dun Nifflelem
				["0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.52:0.66"] = 213, -- Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, Crusaders' Pinnacle
				["0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.59:0.57"] = 222, -- Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, Windrunner's Overlook
				["0.17:0.47:0.21:0.51:0.24:0.60:0.28:0.72:0.57:0.79:0.64:0.81"] = 294, -- Amber Ledge, Fizzcrank Airstrip, River's Heart, Death's Rise, Bouldercrag's Refuge, Ulduar
				["0.17:0.47:0.21:0.51:0.24:0.60:0.28:0.72:0.57:0.79"] = 265, -- Amber Ledge, Fizzcrank Airstrip, River's Heart, Death's Rise, Bouldercrag's Refuge
				["0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.73:0.46"] = 268, -- Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Amberpine Lodge
				["0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.52:0.62"] = 245, -- Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Dalaran
				["0.17:0.47:0.21:0.51:0.24:0.60:0.28:0.72:0.38:0.79"] = 184, -- Amber Ledge, Fizzcrank Airstrip, River's Heart, Death's Rise, The Shadow Vault
				["0.17:0.47:0.22:0.39:0.42:0.47:0.60:0.48:0.76:0.33"] = 300, -- Amber Ledge, Valiance Keep, Stars' Rest, Wintergarde Keep, Westguard Keep
				["0.17:0.47:0.21:0.51:0.24:0.60:0.28:0.72:0.49:0.79"] = 235, -- Amber Ledge, Fizzcrank Airstrip, River's Heart, Death's Rise, Argent Tournament Grounds
				["0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.56:0.64:0.57:0.67"] = 236, -- Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, The Argent Vanguard, Frosthold
				["0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.49:0.79"] = 270, -- Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, Argent Tournament Grounds
				["0.17:0.47:0.21:0.51:0.42:0.47:0.49:0.42"] = 157, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Moa'ki
				["0.17:0.47:0.21:0.51:0.42:0.47:0.49:0.42:0.74:0.29"] = 279, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Moa'ki, Kamagua
				["0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64:0.57:0.67"] = 248, -- Bernsteinflöz, Landebahn Kurbelzisch, Sternenruh, Feste Fordragon, Dalaran, Die Argentumvorhut, Eisfestung
				["0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.54:0.48"] = 197, -- Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Wyrmrest Temple
				["0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.52:0.62:0.24:0.60"] = 378, -- Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Dalaran, River's Heart
				["0.17:0.47:0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.24:0.60"] = 367, -- Amber Ledge, Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, River's Heart
				["0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62"] = 328, -- Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga
				["0.17:0.47:0.22:0.39:0.42:0.47:0.54:0.48:0.52:0.62"] = 261, -- Amber Ledge, Valiance Keep, Stars' Rest, Wyrmrest Temple, Dalaran
				["0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.59:0.57"] = 236, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Windrunner's Overlook
				["0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.59:0.57:0.52:0.62"] = 267, -- Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Windrunner's Overlook, Dalaran

				-- Alliance: Borean Tundra: Fizzcrank Airstrip
				["0.21:0.51:0.17:0.47"] = 45, -- Fizzcrank Airstrip, Amber Ledge
				["0.21:0.51:0.17:0.47:0.12:0.47"] = 81, -- Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.21:0.51:0.22:0.39"] = 71, -- Fizzcrank Airstrip, Valiance Keep
				["0.21:0.51:0.29:0.43"] = 66, -- Fizzcrank Airstrip, Unu'pe
				["0.21:0.51:0.24:0.60:0.52:0.62"] = 257, -- Fizzcrank Airstrip, River's Heart, Dalaran
				["0.21:0.51:0.24:0.60"] = 64, -- Fizzcrank Airstrip, River's Heart
				["0.21:0.51:0.24:0.60:0.28:0.72"] = 149, -- Fizzcrank Airstrip, River's Heart, Death's Rise
				["0.21:0.51:0.24:0.60:0.52:0.62:0.56:0.64:0.57:0.67"] = 318, -- Fizzcrank Airstrip, River's Heart, Dalaran, The Argent Vanguard, Frosthold
				["0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29:0.88:0.28"] = 446, -- Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua, Valgarde Port
				["0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46:0.88:0.40"] = 438, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.21:0.51:0.42:0.47"] = 133, -- Fizzcrank Airstrip, Stars' Rest (david kwon, Tyler Theurer and Mark Nodson reported 71) (Hindenburg, Teri Frietze and Leatrix reported 133)
				["0.21:0.51:0.42:0.47:0.60:0.48:0.76:0.33"] = 374, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Westguard Keep
				["0.21:0.51:0.42:0.47:0.54:0.48"] = 219, -- Fizzcrank Airstrip, Stars' Rest, Wyrmrest Temple
				["0.21:0.51:0.42:0.47:0.60:0.48"] = 254, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep
				["0.21:0.51:0.29:0.43:0.49:0.42:0.52:0.62"] = 304, -- Landebahn Kurbelzisch, Unu'pe, Moa'ki, Dalaran
				["0.21:0.51:0.29:0.43:0.49:0.42"] = 183, -- Fizzcrank Airstrip, Unu'pe, Moa'ki
				["0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29"] = 366, -- Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua
				["0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62"] = 276, -- Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran
				["0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46"] = 325, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Amberpine Lodge
				["0.21:0.51:0.42:0.47:0.60:0.48:0.76:0.33:0.88:0.40"] = 458, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.21:0.51:0.18:0.60"] = 77, -- Fizzcrank Airstrip, Nesingwary Base Camp
				["0.21:0.51:0.29:0.43:0.49:0.42:0.60:0.48"] = 267, -- Fizzcrank Airstrip, Unu'pe, Moa'ki, Wintergarde Keep
				["0.21:0.51:0.42:0.47:0.60:0.48:0.59:0.57:0.52:0.62"] = 365, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Windrunner's Overlook, Dalaran
				["0.21:0.51:0.24:0.60:0.52:0.62:0.49:0.42"] = 406, -- Fizzcrank Airstrip, River's Heart, Dalaran, Moa'ki
				["0.21:0.51:0.42:0.47:0.60:0.48:0.59:0.57"] = 318, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Windrunner's Overlook
				["0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62"] = 415, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga
				["0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46:0.83:0.54"] = 405, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.21:0.51:0.42:0.47:0.60:0.48:0.76:0.33:0.88:0.28"] = 443, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.21:0.51:0.42:0.47:0.54:0.48:0.52:0.62"] = 315, -- Fizzcrank Airstrip, Stars' Rest, Wyrmrest Temple, Dalaran
				["0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58"] = 311, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Ebon Watch
				["0.21:0.51:0.24:0.60:0.52:0.62:0.62:0.64:0.72:0.71"] = 402, -- Fizzcrank Airstrip, River's Heart, Dalaran, K3, Dun Nifflelem
				["0.21:0.51:0.42:0.47:0.60:0.48:0.69:0.58"] = 336, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Light's Breach
				["0.21:0.51:0.24:0.60:0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 383, -- Fizzcrank Airstrip, River's Heart, Dalaran, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.21:0.51:0.24:0.60:0.52:0.62:0.62:0.64"] = 302, -- Fizzcrank Airstrip, River's Heart, Dalaran, K3
				["0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29:0.76:0.33"] = 403, -- Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua, Westguard Keep
				["0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 434, -- Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.21:0.51:0.42:0.47:0.46:0.54"] = 211, -- Fizzcrank Airstrip, Stars' Rest, Fordragon Hold
				["0.21:0.51:0.24:0.60:0.28:0.72:0.38:0.79"] = 242, -- Fizzcrank Airstrip, River's Heart, Death's Rise, The Shadow Vault
				["0.21:0.51:0.42:0.47:0.41:0.57:0.52:0.62"] = 286, -- Fizzcrank Airstrip, Stars' Rest, Valiance Landing Camp, Dalaran
				["0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29:0.76:0.33:0.88:0.40"] = 486, -- Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua, Westguard Keep, Fort Wildervar
				["0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62:0.62:0.64"] = 322, -- Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran, K3
				["0.21:0.51:0.42:0.47:0.41:0.57"] = 196, -- Fizzcrank Airstrip, Stars' Rest, Valiance Landing Camp
				["0.21:0.51:0.42:0.47:0.41:0.57:0.28:0.72"] = 361, -- Fizzcrank Airstrip, Stars' Rest, Valiance Landing Camp, Death's Rise
				["0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64"] = 299, -- Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran, The Argent Vanguard
				["0.21:0.51:0.42:0.47:0.41:0.57:0.38:0.79"] = 356, -- Fizzcrank Airstrip, Stars' Rest, Valiance Landing Camp, The Shadow Vault
				["0.21:0.51:0.42:0.47:0.49:0.42:0.74:0.29:0.88:0.28"] = 464, -- Fizzcrank Airstrip, Stars' Rest, Moa'ki, Kamagua, Valgarde Port
				["0.21:0.51:0.42:0.47:0.60:0.48:0.69:0.58:0.72:0.60"] = 378, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Light's Breach, The Argent Stand
				["0.21:0.51:0.24:0.60:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 415, -- Fizzcrank Airstrip, River's Heart, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.21:0.51:0.24:0.60:0.52:0.62:0.52:0.66"] = 285, -- Fizzcrank Airstrip, River's Heart, Dalaran, Crusaders' Pinnacle
				["0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60"] = 375, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand
				["0.21:0.51:0.42:0.47:0.49:0.42"] = 201, -- Fizzcrank Airstrip, Stars' Rest, Moa'ki
				["0.21:0.51:0.24:0.60:0.52:0.62:0.59:0.57"] = 298, -- Fizzcrank Airstrip, River's Heart, Dalaran, Windrunner's Overlook
				["0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 468, -- Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.21:0.51:0.24:0.60:0.52:0.62:0.56:0.64"] = 279, -- Fizzcrank Airstrip, River's Heart, Dalaran, The Argent Vanguard
				["0.21:0.51:0.24:0.60:0.28:0.72:0.49:0.79"] = 318, -- Fizzcrank Airstrip, River's Heart, Death's Rise, Argent Tournament Grounds
				["0.21:0.51:0.24:0.60:0.28:0.72:0.57:0.79:0.64:0.81"] = 407, -- Fizzcrank Airstrip, River's Heart, Death's Rise, Bouldercrag's Refuge, Ulduar
				["0.21:0.51:0.24:0.60:0.28:0.72:0.57:0.79"] = 363, -- Fizzcrank Airstrip, River's Heart, Death's Rise, Bouldercrag's Refuge
				["0.21:0.51:0.42:0.47:0.49:0.42:0.52:0.62"] = 322, -- Fizzcrank Airstrip, Stars' Rest, Moa'ki, Dalaran
				["0.21:0.51:0.29:0.43:0.49:0.42:0.60:0.48:0.76:0.33:0.88:0.40"] = 471, -- Fizzcrank Airstrip, Unu'pe, Moa'ki, Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.21:0.51:0.42:0.47:0.49:0.42:0.74:0.29:0.76:0.33"] = 421, -- Fizzcrank Airstrip, Stars' Rest, Moa'ki, Kamagua, Westguard Keep
				["0.21:0.51:0.29:0.43:0.49:0.42:0.54:0.48"] = 231, -- Fizzcrank Airstrip, Unu'pe, Moa'ki, Wyrmrest Temple

				-- Alliance: Borean Tundra: Transitus Shield (Coldarra)
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60"] = 95, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart
				["0.12:0.47:0.17:0.47"] = 30, -- Transitus Shield, Amber Ledge (niels lowik reported 49)
				["0.12:0.47:0.17:0.47:0.21:0.51"] = 53, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip
				["0.12:0.47:0.17:0.47:0.22:0.39"] = 74, -- Transitus Shield, Amber Ledge, Valiance Keep
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62"] = 224, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran
				["0.12:0.47:0.17:0.47:0.21:0.51:0.29:0.43"] = 96, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Unu'pe
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54"] = 193, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold
				["0.12:0.47:0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42"] = 174, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki
				["0.12:0.47:0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29:0.88:0.28"] = 349, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua, Valgarde Port
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.28:0.72"] = 151, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart, Death's Rise
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46:0.88:0.40"] = 344, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.76:0.33"] = 301, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Westguard Keep
				["0.12:0.47:0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29"] = 296, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.74:0.29:0.88:0.28"] = 369, -- Transitus Shield, Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Kamagua, Valgarde Port
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47"] = 140, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.60:0.48"] = 248, -- Transitus Shield, Amber Ledge, Valiance Keep, Stars' Rest, Wintergarde Keep
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43"] = 115, -- Transitus Shield, Amber Ledge, Valiance Keep, Unu'pe
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47"] = 169, -- Transitus Shield, Amber Ledge, Valiance Keep, Stars' Rest
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48"] = 221, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42"] = 193, -- Transitus Shield, Amber Ledge, Valiance Keep, Unu'pe, Moa'ki
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46"] = 269, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Amberpine Lodge
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.74:0.29:0.76:0.33:0.88:0.40"] = 396, -- Transitus Shield, Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Kamagua, Westguard Keep, Fort Wildervar
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.76:0.33:0.88:0.40"] = 357, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.52:0.62"] = 274, -- Transitus Shield, Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Dalaran
				["0.12:0.47:0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29:0.76:0.33"] = 321, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua, Westguard Keep
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48"] = 250, -- Transitus Shield, Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.73:0.46:0.83:0.54"] = 350, -- Transitus Shield, Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.60:0.48:0.76:0.33:0.88:0.28"] = 375, -- Transitus Shield, Amber Ledge, Valiance Keep, Stars' Rest, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62"] = 235, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.60:0.48:0.73:0.46:0.83:0.54"] = 350, -- Transitus Shield, Amber Ledge, Valiance Keep, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.54:0.48:0.52:0.62"] = 262, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wyrmrest Temple, Dalaran
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.54:0.48"] = 198, -- Transitusschild, Bernsteinflöz, Landebahn Kurbelzisch, Sternenruh, Wyrmruhtempel
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.54:0.48:0.52:0.62"] = 290, -- Transitus Shield, Amber Ledge, Valiance Keep, Stars' Rest, Wyrmrest Temple, Dalaran
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46:0.88:0.40:0.88:0.28"] = 393, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Fort Wildervar, Valgarde Port
				["0.12:0.47:0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42:0.52:0.62"] = 254, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki, Dalaran
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.54:0.48"] = 226, -- Transitus Shield, Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Wyrmrest Temple
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.76:0.33:0.88:0.28"] = 347, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.60:0.48:0.73:0.46"] = 296, -- Transitus Shield, Amber Ledge, Valiance Keep, Stars' Rest, Wintergarde Keep, Amberpine Lodge
				["0.12:0.47:0.17:0.47:0.21:0.51:0.18:0.60"] = 103, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Nesingwary Base Camp
				["0.12:0.47:0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42:0.60:0.48"] = 230, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki, Wintergarde Keep
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.69:0.58"] = 276, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Light's Breach
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62"] = 262, -- Transitus Shield, Amber Ledge, Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62:0.62:0.64:0.72:0.71"] = 333, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran, K3, Dun Nifflelem
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.49:0.42"] = 214, -- Transitus Shield, Amber Ledge, Valiance Keep, Stars' Rest, Moa'ki
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.62:0.64:0.72:0.71:0.64:0.81"] = 376, -- Маскировочный щит, Янтарная гряда, Взлетная полоса Выкрутеня, Слияние рек, Даларан, К-3, Дун Ниффелем, Ульдуар
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.60:0.48:0.59:0.57:0.52:0.62"] = 323, -- Transitusschild, Bernsteinflöz, Valianzfeste, Sternenruh, Feste Wintergarde, Windläufers Warte, Dalaran
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.76:0.33"] = 330, -- Transitus Shield, Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Westguard Keep
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62"] = 328, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars'
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.62:0.64:0.72:0.71"] = 320, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, K3, Dun Nifflelem
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.41:0.57"] = 183, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Valiance Landing Camp
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.54:0.48:0.64:0.58:0.69:0.58:0.73:0.46:0.76:0.33:0.88:0.28"] = 454, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wyrmrest Temple, Ebon Watch, Light's Breach, Amberpine Lodge, Westguard Keep, Valgarde Port
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46:0.83:0.54"] = 322, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.54:0.48"] = 227, -- Transitus Shield, Amber Ledge, Valiance Keep, Stars' Rest, Wyrmrest Temple
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 342, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.56:0.64"] = 238, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, The Argent Vanguard
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 364, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60"] = 302, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.62:0.64"] = 254, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, K3
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58:0.62:0.64"] = 286, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Ebon Watch, K3
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 328, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.59:0.57"] = 264, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Windrunner's Overlook
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.49:0.42:0.52:0.62"] = 266, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Moa'ki, Dalaran
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.41:0.57:0.38:0.79"] = 289, -- Transitusschild, Bernsteinflöz, Landebahn Kurbelzisch, Sternenruh, Valianzlager, Das Schattengewölbe
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58"] = 260, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Ebon Watch
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64"] = 252, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran, The Argent Vanguard
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62:0.62:0.64"] = 267, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran, K3
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.41:0.57:0.28:0.72"] = 293, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Valiance Landing Camp, Death's Rise
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.28:0.72:0.57:0.79"] = 294, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart, Death's Rise, Bouldercrag's Refuge
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.41:0.57:0.52:0.66"] = 256, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Valiance Landing Camp, Crusaders' Pinnacle
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.62:0.64:0.72:0.71"] = 359, -- Transitus Shield, Amber Ledge, Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, K3, Dun Nifflelem
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.56:0.64:0.57:0.67"] = 264, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, The Argent Vanguard, Frosthold
				["0.12:0.47:0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29:0.76:0.33:0.73:0.46"] = 370, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua, Westguard Keep, Amberpine Lodge
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.28:0.72:0.57:0.79:0.64:0.81"] = 323, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart, Death's Rise, Bouldercrag's Refuge, Ulduar
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64:0.57:0.67"] = 277, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran, The Argent Vanguard, Frosthold
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.49:0.42"] = 186, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Moa'ki
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.28:0.72:0.38:0.79"] = 213, -- Маскировочный щит, Янтарная гряда, Взлетная полоса Выкрутеня, Слияние рек, Уступ Смерти, Мрачный Свод
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81:0.57:0.79"] = 463, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga, Ulduar, Bouldercrag's Refuge
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.41:0.57:0.52:0.62"] = 243, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Valiance Landing Camp, Dalaran
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.52:0.66"] = 242, -- Escudo de Tránsito, El Saliente Ámbar, Pista de Aterrizaje de Palanqueta, Corazón del Río, Dalaran, Pináculo de los Cruzados
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.76:0.33:0.88:0.28"] = 376, -- Transitus Shield, Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.62:0.64"] = 293, -- Transitus Shield, Amber Ledge, Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, K3
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62:0.52:0.66:0.38:0.79"] = 337, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.52:0.62:0.24:0.60"] = 407, -- Transitusschild, Bernsteinflöz, Valianzfeste, Unu'pe, Moa'ki, Dalaran, Flussnabel
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.52:0.62:0.56:0.64"] = 289, -- Transitus Shield, Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Dalaran, The Argent Vanguard
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.41:0.57:0.38:0.79"] = 318, -- Transitus Shield, Amber Ledge, Valiance Keep, Stars' Rest, Valiance Landing Camp, The Shadow Vault
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 307, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.28:0.72:0.49:0.79"] = 264, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart, Death's Rise, Argent Tournament Grounds
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.54:0.48:0.64:0.58:0.69:0.58:0.73:0.46:0.76:0.33"] = 408, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Wyrmrest Temple, Ebon Watch, Light's Breach, Amberpine Lodge, Westguard Keep
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60"] = 329, -- Transitusschild, Bernsteinflöz, Valianzfeste, Sternenruh, Feste Wintergarde, Schwarze Wacht, Argentumwache
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.59:0.57"] = 251, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, Windrunner's Overlook
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62"] = 358, -- Transitus Shield, Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga
				["0.12:0.47:0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 360, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.49:0.79"] = 299, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, Argent Tournament Grounds
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.46:0.54:0.52:0.62:0.52:0.66:0.28:0.72"] = 366, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.74:0.29:0.76:0.33"] = 340, -- Transitusschild, Bernsteinflöz, Valianzfeste, Unu'pe, Moa'ki, Kamagua, Westwacht
				["0.12:0.47:0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42:0.52:0.62:0.49:0.79"] = 331, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki, Dalaran, Argent Tournament Grounds
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.73:0.46"] = 297, -- Transitus Shield, Amber Ledge, Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Amberpine Lodge
				["0.12:0.47:0.17:0.47:0.21:0.51:0.29:0.43:0.49:0.42:0.60:0.48:0.73:0.46"] = 277, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Unu'pe, Moa'ki, Wintergarde Keep, Amberpine Lodge
				["0.12:0.47:0.17:0.47:0.21:0.51:0.24:0.60:0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46:0.76:0.33:0.88:0.28"] = 454, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, River's Heart, Dalaran, Ebon Watch, Light's Breach, Amberpine Lodge, Westguard Keep, Valgarde Port
				["0.12:0.47:0.17:0.47:0.21:0.51:0.42:0.47:0.49:0.42:0.74:0.29:0.76:0.33"] = 332, -- Transitus Shield, Amber Ledge, Fizzcrank Airstrip, Stars' Rest, Moa'ki, Kamagua, Westguard Keep
				["0.12:0.47:0.17:0.47:0.22:0.39:0.29:0.43:0.49:0.42:0.74:0.29"] = 316, -- Transitusschild, Bernsteinflöz, Valianzfeste, Unu'pe, Moa'ki, Kamagua
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.60:0.48:0.76:0.33"] = 329, -- Bouclier Transitus, Escarpement d'Ambre, Donjon de la Bravoure, Repos des étoiles, Donjon de Garde-hiver, Donjon de la Garde de l'ouest
				["0.12:0.47:0.17:0.47:0.22:0.39:0.42:0.47:0.41:0.57:0.52:0.62"] = 271, -- Transitus Shield, Amber Ledge, Valiance Keep, Stars' Rest, Valiance Landing Camp, Dalaran

				-- Alliance: Borean Tundra: Unu'pe
				["0.29:0.43:0.22:0.39"] = 60, -- Unu'pe, Valiance Keep
				["0.29:0.43:0.42:0.47"] = 98, -- Unu'pe, Stars' Rest
				["0.29:0.43:0.49:0.42:0.52:0.62"] = 240, -- Unu'pe, Moa'ki, Dalaran
				["0.29:0.43:0.49:0.42:0.74:0.29:0.88:0.28"] = 382, -- Unu'pe, Moa'ki, Kamagua, Valgarde Port
				["0.29:0.43:0.21:0.51"] = 79, -- Unu'pe, Fizzcrank Airstrip
				["0.29:0.43:0.49:0.42:0.60:0.48:0.73:0.46:0.88:0.40"] = 387, -- Unu'pe, Moa'ki, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.29:0.43:0.49:0.42:0.74:0.29"] = 302, -- Unu'pe, Moa'ki, Kamagua
				["0.29:0.43:0.49:0.42:0.60:0.48:0.73:0.46"] = 273, -- Unu'pe, Moa'ki, Wintergarde Keep, Amberpine Lodge
				["0.29:0.43:0.49:0.42"] = 118, -- Unu'pe, Moa'ki
				["0.29:0.43:0.49:0.42:0.52:0.62:0.56:0.64:0.57:0.67"] = 300, -- Unu'pe, Moa'ki, Dalaran, The Argent Vanguard, Frosthold
				["0.29:0.43:0.22:0.39:0.17:0.47:0.12:0.47"] = 158, -- Unu'pe, Valiance Keep, Amber Ledge, Transitus Shield
				["0.29:0.43:0.22:0.39:0.17:0.47"] = 122, -- Unu'pe, Valiance Keep, Amber Ledge
				["0.29:0.43:0.21:0.51:0.24:0.60"] = 142, -- Unu'pe, Fizzcrank Airstrip, River's Heart
				["0.29:0.43:0.49:0.42:0.60:0.48:0.76:0.33"] = 323, -- Unu'pe, Moa'ki, Wintergarde Keep, Westguard Keep
				["0.29:0.43:0.49:0.42:0.60:0.48:0.73:0.46:0.83:0.54"] = 353, -- Unu'pe, Moa'ki, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.29:0.43:0.49:0.42:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62"] = 364, -- Unu'pe, Moa'ki, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga
				["0.29:0.43:0.49:0.42:0.60:0.48"] = 202, -- Unu'pe, Moa'ki, Wintergarde Keep
				["0.29:0.43:0.42:0.47:0.60:0.48"] = 218, -- Unu'pe, Stars' Rest, Wintergarde Keep
				["0.29:0.43:0.49:0.42:0.74:0.29:0.76:0.33"] = 338, -- Unu'pe, Moa'ki, Kamagua, Westguard Keep
				["0.29:0.43:0.42:0.47:0.60:0.48:0.76:0.33"] = 338, -- Unu'pe, Stars' Rest, Wintergarde Keep, Westguard Keep
				["0.29:0.43:0.42:0.47:0.46:0.54"] = 175, -- Unu'pe, Stars' Rest, Fordragon Hold
				["0.29:0.43:0.49:0.42:0.74:0.29:0.76:0.33:0.88:0.40"] = 422, -- Unu'pe, Moa'ki, Kamagua, Westguard Keep, Fort Wildervar
				["0.29:0.43:0.49:0.42:0.52:0.62:0.62:0.64:0.57:0.67"] = 326, -- Unu'pe, Moa'ki, Dalaran, K3, Frosthold
				["0.29:0.43:0.49:0.42:0.54:0.48"] = 166, -- Unu'pe, Moa'ki, Wyrmruhtempel
				["0.29:0.43:0.42:0.47:0.60:0.48:0.76:0.33:0.88:0.28"] = 407, -- Unu'pe, Stars' Rest, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.29:0.43:0.42:0.47:0.54:0.48"] = 184, -- Unu'pe, Stars' Rest, Wyrmrest Temple
				["0.29:0.43:0.42:0.47:0.46:0.54:0.52:0.62"] = 241, -- Unu'pe, Stars' Rest, Fordragon Hold, Dalaran
				["0.29:0.43:0.49:0.42:0.60:0.48:0.69:0.58"] = 285, -- Unu'pe, Moa'ki, Wintergarde Keep, Light's Breach
				["0.29:0.43:0.49:0.42:0.52:0.62:0.62:0.64:0.72:0.71"] = 383, -- Unu'pe, Moa'ki, Dalaran, K3, Dun Nifflelem
				["0.29:0.43:0.49:0.42:0.52:0.62:0.62:0.64"] = 284, -- Unu'pe, Moa'ki, Dalaran, K3
				["0.29:0.43:0.42:0.47:0.54:0.48:0.52:0.62"] = 281, -- Unu'pe, Stars' Rest, Wyrmrest Temple, Dalaran
				["0.29:0.43:0.42:0.47:0.41:0.57:0.24:0.60"] = 296, -- Unu'pe, Stars' Rest, Valiance Landing Camp, River's Heart
				["0.29:0.43:0.49:0.42:0.60:0.48:0.76:0.33:0.88:0.28"] = 391, -- Unu'pe, Moa'ki, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.29:0.43:0.49:0.42:0.60:0.48:0.76:0.33:0.88:0.40"] = 406, -- Unu'pe, Moa'ki, Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.29:0.43:0.42:0.47:0.41:0.57"] = 161, -- Unu'pe, Stars' Rest, Valiance Landing Camp
				["0.29:0.43:0.49:0.42:0.52:0.62:0.56:0.64"] = 262, -- Unu'pe, Moa'ki, Dalaran, The Argent Vanguard
				["0.29:0.43:0.49:0.42:0.60:0.48:0.64:0.58:0.72:0.60"] = 323, -- Unu'pe, Moa'ki, Wintergarde Keep, Ebon Watch, The Argent Stand
				["0.29:0.43:0.49:0.42:0.52:0.62:0.52:0.66"] = 267, -- Unu'pe, Moa'ki, Dalaran, Crusaders' Pinnacle
				["0.29:0.43:0.49:0.42:0.60:0.48:0.59:0.57"] = 267, -- Unu'pe, Moa'ki, Wintergarde Keep, Windrunner's Overlook
				["0.29:0.43:0.42:0.47:0.41:0.57:0.52:0.66"] = 270, -- Unu'pe, Stars' Rest, Valiance Landing Camp, Crusaders' Pinnacle
				["0.29:0.43:0.21:0.51:0.18:0.60"] = 155, -- Unu'pe, Piste d'atterrissage de Spumelevier, Camp de base de Nesingwary
				["0.29:0.43:0.49:0.42:0.52:0.62:0.24:0.60"] = 439, -- Unu'pe, Moa'ki, Dalaran, River's Heart
				["0.29:0.43:0.49:0.42:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 417, -- Unu'pe, Moa'ki, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.29:0.43:0.21:0.51:0.24:0.60:0.28:0.72"] = 227, -- Unu'pe, Fizzcrank Airstrip, River's Heart, Death's Rise
				["0.29:0.43:0.42:0.47:0.60:0.48:0.76:0.33:0.74:0.29"] = 388, -- Unu'pe, Stars' Rest, Wintergarde Keep, Westguard Keep, Kamagua
				["0.29:0.43:0.42:0.47:0.41:0.57:0.38:0.79"] = 321, -- Unu'pe, Stars' Rest, Valiance Landing Camp, The Shadow Vault
				["0.29:0.43:0.42:0.47:0.41:0.57:0.52:0.62"] = 251, -- Unu'pe, Stars' Rest, Valiance Landing Camp, Dalaran
				["0.29:0.43:0.49:0.42:0.60:0.48:0.69:0.58:0.72:0.60:0.78:0.62"] = 368, -- Unu'pe, Moa'ki, Feste Wintergarde, Lichtbresche, Argentumwache, Zim'Torga
				["0.29:0.43:0.49:0.42:0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 364, -- Unu'pe, Moa'ki, Dalaran, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.29:0.43:0.49:0.42:0.52:0.62:0.49:0.79"] = 353, -- Unu'pe, Moa'ki, Dalaran, Argent Tournament Grounds
				["0.29:0.43:0.49:0.42:0.60:0.48:0.64:0.58"] = 260, -- Unu'pe, Moa'ki, Wintergarde Keep, Ebon Watch
				["0.29:0.43:0.21:0.51:0.24:0.60:0.28:0.72:0.38:0.79"] = 320, -- Unu'pe, Landebahn Kurbelzisch, Flussnabel, Todesanhöhe, Das Schattengewölbe
				["0.29:0.43:0.49:0.42:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 397, -- Unu'pe, Moa'ki, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.29:0.43:0.42:0.47:0.60:0.48:0.73:0.46"] = 289, -- Unu'pe, Stars' Rest, Wintergarde Keep, Amberpine Lodge
				["0.29:0.43:0.49:0.42:0.52:0.62:0.64:0.58:0.69:0.58"] = 349, -- Unu'pe, Moa'ki, Dalaran, Ebon Watch, Light's Breach

				-- Alliance: Borean Tundra: Valiance Keep
				["0.22:0.39:0.29:0.43:0.49:0.42:0.74:0.29"] = 365, -- Valiance Keep, Unu'pe, Moa'ki, Kamagua
				["0.22:0.39:0.29:0.43"] = 65, -- Valiance Keep, Unu'pe
				["0.22:0.39:0.21:0.51"] = 76, -- Valiance Keep, Fizzcrank Airstrip
				["0.22:0.39:0.17:0.47:0.12:0.47"] = 99, -- Valiance Keep, Amber Ledge, Transitus Shield
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62"] = 285, -- Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran
				["0.22:0.39:0.29:0.43:0.49:0.42:0.74:0.29:0.88:0.28"] = 445, -- Valiance Keep, Unu'pe, Moa'ki, Kamagua, Valgarde Port
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.73:0.46:0.88:0.40"] = 450, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.22:0.39:0.21:0.51:0.24:0.60"] = 137, -- Valiance Keep, Fizzcrank Airstrip, River's Heart (Orlando Escamilla reported 153)
				["0.22:0.39:0.17:0.47"] = 64, -- Valiance Keep, Amber Ledge
				["0.22:0.39:0.42:0.47"] = 146, -- Valiance Keep, Stars' Rest
				["0.22:0.39:0.21:0.51:0.24:0.60:0.28:0.72"] = 223, -- Valiance Keep, Fizzcrank Airstrip, River's Heart, Death's Rise
				["0.22:0.39:0.29:0.43:0.49:0.42"] = 181, -- Valiance Keep, Unu'pe, Moa'ki
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.73:0.46"] = 337, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Amberpine Lodge
				["0.22:0.39:0.29:0.43:0.49:0.42:0.54:0.48"] = 230, -- Valiance Keep, Unu'pe, Moa'ki, Wyrmrest Temple
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48"] = 266, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep
				["0.22:0.39:0.42:0.47:0.41:0.57"] = 208, -- Valiance Keep, Stars' Rest, Valiance Landing Camp
				["0.22:0.39:0.42:0.47:0.46:0.54"] = 220, -- Valiance Keep, Stars' Rest, Fordragon Hold
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 411, -- Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.76:0.33"] = 386, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Westguard Keep
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.73:0.46:0.83:0.54"] = 417, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62"] = 427, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 481, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.22:0.39:0.42:0.47:0.60:0.48"] = 265, -- Valiance Keep, Stars' Rest, Wintergarde Keep
				["0.22:0.39:0.42:0.47:0.60:0.48:0.76:0.33:0.88:0.28"] = 454, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.22:0.39:0.42:0.47:0.54:0.48:0.52:0.62"] = 328, -- Valiance Keep, Stars' Rest, Wyrmrest Temple, Dalaran
				["0.22:0.39:0.42:0.47:0.60:0.48:0.73:0.46:0.83:0.54"] = 416, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.22:0.39:0.42:0.47:0.54:0.48"] = 231, -- Valiance Keep, Stars' Rest, Wyrmrest Temple
				["0.22:0.39:0.29:0.43:0.49:0.42:0.52:0.62"] = 303, -- Valiance Keep, Unu'pe, Moa'ki, Dalaran
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.59:0.57"] = 330, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Windrunner's Overlook
				["0.22:0.39:0.42:0.47:0.60:0.48:0.69:0.58"] = 347, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Light's Breach
				["0.22:0.39:0.29:0.43:0.49:0.42:0.74:0.29:0.76:0.33"] = 401, -- Valiance Keep, Unu'pe, Moa'ki, Kamagua, Westguard Keep
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.76:0.33:0.88:0.28"] = 455, -- Valianzfeste, Unu'pe, Moa'ki, Feste Wintergarde, Westwacht, Hafen von Valgarde
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.69:0.58"] = 348, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Light's Breach
				["0.22:0.39:0.42:0.47:0.60:0.48:0.76:0.33"] = 385, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Westguard Keep
				["0.22:0.39:0.42:0.47:0.49:0.42"] = 213, -- Valiance Keep, Stars' Rest, Moa'ki
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.64:0.58:0.72:0.60"] = 386, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Ebon Watch, The Argent Stand
				["0.22:0.39:0.29:0.43:0.49:0.42:0.52:0.62:0.56:0.64"] = 324, -- Valiance Keep, Unu'pe, Moa'ki, Dalaran, The Argent Vanguard
				["0.22:0.39:0.21:0.51:0.24:0.60:0.52:0.62"] = 331, -- Valiance Keep, Fizzcrank Airstrip, River's Heart, Dalaran
				["0.22:0.39:0.42:0.47:0.60:0.48:0.73:0.46:0.83:0.54:0.78:0.62"] = 488, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Westfall Brigade, Zim'Torga
				["0.22:0.39:0.21:0.51:0.18:0.60"] = 151, -- Valiance Keep, Fizzcrank Airstrip, Nesingwary Base Camp
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.64:0.58"] = 323, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Ebon Watch
				["0.22:0.39:0.42:0.47:0.49:0.42:0.74:0.29"] = 397, -- Valiance Keep, Stars' Rest, Moa'ki, Kamagua
				["0.22:0.39:0.42:0.47:0.60:0.48:0.73:0.46"] = 336, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Amberpine Lodge
				["0.22:0.39:0.42:0.47:0.60:0.48:0.73:0.46:0.88:0.40:0.88:0.28"] = 523, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Fort Wildervar, Valgarde Port
				["0.22:0.39:0.42:0.47:0.60:0.48:0.73:0.46:0.88:0.40"] = 450, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.22:0.39:0.29:0.43:0.49:0.42:0.74:0.29:0.76:0.33:0.88:0.40"] = 485, -- Valiance Keep, Unu'pe, Moa'ki, Kamagua, Westguard Keep, Fort Wildervar
				["0.22:0.39:0.42:0.47:0.46:0.54:0.64:0.58:0.59:0.57"] = 371, -- Valiance Keep, Stars' Rest, Fordragon Hold, Ebon Watch, Windrunner's Overlook
				["0.22:0.39:0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60"] = 386, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand
				["0.22:0.39:0.42:0.47:0.60:0.48:0.73:0.46:0.83:0.54:0.78:0.62:0.64:0.81:0.57:0.79"] = 690, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Westfall Brigade, Zim'Torga, Ulduar, Bouldercrag's Refuge
				["0.22:0.39:0.42:0.47:0.60:0.48:0.76:0.33:0.74:0.29"] = 435, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Westguard Keep, Kamagua
				["0.22:0.39:0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62"] = 426, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64"] = 308, -- Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, The Argent Vanguard
				["0.22:0.39:0.29:0.43:0.49:0.42:0.52:0.62:0.62:0.64"] = 347, -- Valianzfeste, Unu'pe, Moa'ki, Dalaran, K3
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.62:0.64:0.72:0.71"] = 432, -- Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, K3, Dun Nifflelem
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.24:0.60:0.18:0.60"] = 521, -- Valianzfeste, Sternenruh, Feste Fordragon, Dalaran, Flussnabel, Nesingwarys Basislager
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.62:0.64"] = 331, -- Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, K3
				["0.22:0.39:0.29:0.43:0.49:0.42:0.52:0.62:0.24:0.60:0.18:0.60"] = 537, -- Valiance Keep, Unu'pe, Moa'ki, Dalaran, River's Heart, Nesingwary Base Camp
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.69:0.58:0.72:0.60"] = 390, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Light's Breach, The Argent Stand
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.52:0.66"] = 315, -- Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, Crusaders' Pinnacle
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64:0.57:0.67"] = 347, -- Valianzfeste, Sternenruh, Feste Fordragon, Dalaran, Die Argentumvorhut, Eisfestung
				["0.22:0.39:0.42:0.47:0.54:0.48:0.64:0.58"] = 337, -- Valiance Keep, Stars' Rest, Wyrmrest Temple, Ebon Watch
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 581, -- Donjon de la Bravoure, Unu'pe, Moa'ki, Donjon de Garde-hiver, Guet d'Ébène, Le séjour d'Argent, Zim'Torga, Ulduar
				["0.22:0.39:0.42:0.47:0.60:0.48:0.64:0.58"] = 322, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Ebon Watch
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.52:0.66:0.28:0.72"] = 481, -- Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.22:0.39:0.42:0.47:0.41:0.57:0.38:0.79"] = 368, -- Valiance Keep, Stars' Rest, Valiance Landing Camp, The Shadow Vault
				["0.22:0.39:0.42:0.47:0.41:0.57:0.52:0.62"] = 298, -- Valiance Keep, Stars' Rest, Valiance Landing Camp, Dalaran
				["0.22:0.39:0.42:0.47:0.41:0.57:0.52:0.66"] = 317, -- Valiance Keep, Stars' Rest, Valiance Landing Camp, Crusaders' Pinnacle
				["0.22:0.39:0.21:0.51:0.24:0.60:0.28:0.72:0.38:0.79"] = 316, -- Valiance Keep, Fizzcrank Airstrip, River's Heart, Death's Rise, The Shadow Vault
				["0.22:0.39:0.42:0.47:0.60:0.48:0.59:0.57:0.52:0.62"] = 377, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Windrunner's Overlook, Dalaran
				["0.22:0.39:0.42:0.47:0.41:0.57:0.28:0.72"] = 374, -- Valiance Keep, Stars' Rest, Valiance Landing Camp, Death's Rise
				["0.22:0.39:0.29:0.43:0.49:0.42:0.52:0.62:0.56:0.64:0.57:0.67"] = 363, -- Valiance Keep, Unu'pe, Moa'ki, Dalaran, The Argent Vanguard, Frosthold
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 443, -- Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 512, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.22:0.39:0.29:0.43:0.49:0.42:0.74:0.29:0.76:0.33:0.73:0.46"] = 476, -- Valiance Keep, Unu'pe, Moa'ki, Kamagua, Westguard Keep, Amberpine Lodge
				["0.22:0.39:0.42:0.47:0.60:0.48:0.64:0.58:0.62:0.64"] = 363, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Ebon Watch, K3
				["0.22:0.39:0.42:0.47:0.41:0.57:0.52:0.62:0.62:0.64"] = 345, -- Valiance Keep, Stars' Rest, Valiance Landing Camp, Dalaran, K3
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.24:0.60"] = 487, -- Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, River's Heart
				["0.22:0.39:0.42:0.47:0.41:0.57:0.52:0.62:0.56:0.64:0.57:0.67"] = 360, -- Valiance Keep, Stars' Rest, Valiance Landing Camp, Dalaran, The Argent Vanguard, Frosthold
				["0.22:0.39:0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 511, -- Valiance Keep, Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.22:0.39:0.29:0.43:0.49:0.42:0.52:0.62:0.52:0.66"] = 330, -- Valiance Keep, Unu'pe, Moa'ki, Dalaran, Crusaders' Pinnacle
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.76:0.33:0.88:0.40"] = 470, -- Valianzfeste, Unu'pe, Moa'ki, Feste Wintergarde, Westwacht, Fort Wildervar
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.52:0.66:0.38:0.79"] = 436, -- Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.22:0.39:0.29:0.43:0.49:0.42:0.52:0.62:0.52:0.66:0.38:0.79"] = 452, -- Valiance Keep, Unu'pe, Moa'ki, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.73:0.46:0.83:0.54:0.72:0.60"] = 498, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Amberpine Lodge, Westfall Brigade, The Argent Stand
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.49:0.79"] = 400, -- Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, Argent Tournament Grounds
				["0.22:0.39:0.21:0.51:0.24:0.60:0.28:0.72:0.49:0.79"] = 392, -- Valiance Keep, Fizzcrank Airstrip, River's Heart, Death's Rise, Argent Tournament Grounds
				["0.22:0.39:0.42:0.47:0.41:0.57:0.24:0.60:0.18:0.60"] = 378, -- Valiance Keep, Stars' Rest, Valiance Landing Camp, River's Heart, Nesingwary Base Camp
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.49:0.79:0.57:0.79"] = 447, -- Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, Argent Tournament Grounds, Bouldercrag's Refuge
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.62:0.64:0.57:0.67:0.64:0.81"] = 471, -- Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, K3, Frosthold, Ulduar
				["0.22:0.39:0.21:0.51:0.24:0.60:0.28:0.72:0.57:0.79:0.64:0.81"] = 481, -- Valiance Keep, Fizzcrank Airstrip, River's Heart, Death's Rise, Bouldercrag's Refuge, Ulduar
				["0.22:0.39:0.29:0.43:0.49:0.42:0.54:0.48:0.64:0.58:0.69:0.58"] = 379, -- Valiance Keep, Unu'pe, Moa'ki, Wyrmrest Temple, Ebon Watch, Light's Breach
				["0.22:0.39:0.42:0.47:0.54:0.48:0.52:0.62:0.49:0.79"] = 442, -- Valiance Keep, Stars' Rest, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.64:0.58:0.72:0.60:0.83:0.54"] = 457, -- Valiance Keep, Unu'pe, Moa'ki, Wintergarde Keep, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.22:0.39:0.42:0.47:0.41:0.57:0.52:0.66:0.49:0.79"] = 414, -- Valiance Keep, Stars' Rest, Valiance Landing Camp, Crusaders' Pinnacle, Argent Tournament Grounds
				["0.22:0.39:0.21:0.51:0.24:0.60:0.41:0.57:0.46:0.54"] = 328, -- Valiance Keep, Fizzcrank Airstrip, River's Heart, Valiance Landing Camp, Fordragon Hold
				["0.22:0.39:0.42:0.47:0.41:0.57:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 457, -- Valiance Keep, Stars' Rest, Valiance Landing Camp, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.22:0.39:0.42:0.47:0.54:0.48:0.52:0.62:0.62:0.64"] = 372, -- Valiance Keep, Stars' Rest, Wyrmrest Temple, Dalaran, K3
				["0.22:0.39:0.42:0.47:0.41:0.57:0.52:0.62:0.49:0.79"] = 413, -- Valiance Keep, Stars' Rest, Valiance Landing Camp, Dalaran, Argent Tournament Grounds
				["0.22:0.39:0.42:0.47:0.46:0.54:0.52:0.62:0.62:0.64:0.57:0.67"] = 374, -- Valiance Keep, Stars' Rest, Fordragon Hold, Dalaran, K3, Frosthold
				["0.22:0.39:0.42:0.47:0.41:0.57:0.24:0.60"] = 345, -- Valiance Keep, Stars' Rest, Valiance Landing Camp, River's Heart
				["0.22:0.39:0.29:0.43:0.49:0.42:0.60:0.48:0.69:0.58:0.72:0.60:0.78:0.62"] = 431, -- Valianzfeste, Unu'pe, Moa'ki, Feste Wintergarde, Lichtbresche, Argentumwache, Zim'Torga

				----------------------------------------------------------------------
				-- Alliance: Crystalsong Forest
				----------------------------------------------------------------------

				-- Alliance: Crystalsong Forest: Windrunner's Overlook
				["0.59:0.57:0.64:0.58"] = 46, -- Windrunner's Overlook, Ebon Watch
				["0.59:0.57:0.62:0.64"] = 47, -- Windrunner's Overlook, K3
				["0.59:0.57:0.52:0.62"] = 48, -- Windrunner's Overlook, Dalaran
				["0.59:0.57:0.60:0.48"] = 77, -- Windrunner's Overlook, Wintergarde Keep
				["0.59:0.57:0.60:0.48:0.54:0.48"] = 124, -- Windrunner's Overlook, Wintergarde Keep, Wyrmrest Temple
				["0.59:0.57:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 390, -- Windrunner's Overlook, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.59:0.57:0.60:0.48:0.49:0.42"] = 169, -- Windrunner's Overlook, Wintergarde Keep, Moa'ki
				["0.59:0.57:0.62:0.64:0.57:0.67"] = 90, -- Windrunner's Overlook, K3, Frosthold
				["0.59:0.57:0.60:0.48:0.76:0.33:0.74:0.29"] = 246, -- Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Kamagua
				["0.59:0.57:0.60:0.48:0.76:0.33"] = 197, -- Windrunner's Overlook, Wintergarde Keep, Westguard Keep
				["0.59:0.57:0.60:0.48:0.76:0.33:0.88:0.28"] = 266, -- Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.59:0.57:0.60:0.48:0.42:0.47:0.29:0.43"] = 281, -- Windrunner's Overlook, Wintergarde Keep, Stars' Rest, Unu'pe
				["0.59:0.57:0.60:0.48:0.42:0.47"] = 185, -- Windrunner's Overlook, Wintergarde Keep, Stars' Rest
				["0.59:0.57:0.60:0.48:0.73:0.46"] = 147, -- Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge
				["0.59:0.57:0.52:0.62:0.56:0.64"] = 70, -- Windrunner's Overlook, Dalaran, L'avant-garde d'Argent, The Argent Vanguard
				["0.59:0.57:0.60:0.48:0.73:0.46:0.83:0.54"] = 227, -- Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.59:0.57:0.60:0.48:0.42:0.47:0.22:0.39"] = 311, -- Windrunner's Overlook, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.59:0.57:0.60:0.48:0.69:0.58"] = 159, -- Windrunner's Overlook, Wintergarde Keep, Light's Breach
				["0.59:0.57:0.60:0.48:0.42:0.47:0.21:0.51"] = 310, -- Windrunner's Overlook, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip
				["0.59:0.57:0.52:0.62:0.46:0.54"] = 136, -- Windrunner's Overlook, Dalaran, Fordragon Hold
				["0.59:0.57:0.60:0.48:0.49:0.42:0.29:0.43"] = 300, -- Windrunner's Overlook, Wintergarde Keep, Moa'ki, Unu'pe
				["0.59:0.57:0.52:0.62:0.24:0.60"] = 248, -- Windrunner's Overlook, Dalaran, River's Heart
				["0.59:0.57:0.52:0.62:0.52:0.66"] = 75, -- Windrunner's Overlook, Dalaran, Crusaders' Pinnacle
				["0.59:0.57:0.60:0.48:0.73:0.46:0.88:0.40"] = 262, -- Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.59:0.57:0.52:0.62:0.24:0.60:0.18:0.60"] = 282, -- Windrunner's Overlook, Dalaran, River's Heart, Nesingwary Base Camp
				["0.59:0.57:0.52:0.62:0.41:0.57"] = 150, -- Windrunner's Overlook, Dalaran, Valiance Landing Camp
				["0.59:0.57:0.64:0.58:0.69:0.58"] = 91, -- Windrunner's Overlook, Ebon Watch, Light's Breach
				["0.59:0.57:0.64:0.58:0.72:0.60:0.83:0.54"] = 181, -- Windrunner's Overlook, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.59:0.57:0.64:0.58:0.72:0.60"] = 110, -- Windrunner's Overlook, Ebon Watch, The Argent Stand
				["0.59:0.57:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 204, -- Windrunner's Overlook, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.59:0.57:0.62:0.64:0.57:0.67:0.57:0.79"] = 155, -- Windrunner's Overlook, K3, Frosthold, Bouldercrag's Refuge
				["0.59:0.57:0.64:0.58:0.72:0.60:0.78:0.62"] = 150, -- Windrunner's Overlook, Ebon Watch, The Argent Stand, Zim'Torga
				["0.59:0.57:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40"] = 265, -- Windläufers Warte, Schwarze Wacht, Argentumwache, Westfallbrigade, Fort Wildervar
				["0.59:0.57:0.52:0.62:0.52:0.66:0.28:0.72"] = 242, -- Windrunner's Overlook, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.59:0.57:0.62:0.64:0.57:0.67:0.64:0.81"] = 186, -- Windrunner's Overlook, K3, Frosthold, Ulduar
				["0.59:0.57:0.52:0.62:0.52:0.66:0.38:0.79"] = 198, -- Windrunner's Overlook, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.59:0.57:0.62:0.64:0.72:0.71"] = 148, -- Windrunner's Overlook, K3, Dun Nifflelem
				["0.59:0.57:0.52:0.62:0.56:0.64:0.57:0.67"] = 109, -- Windrunner's Overlook, Dalaran, The Argent Vanguard, Frosthold
				["0.59:0.57:0.64:0.58:0.46:0.54"] = 157, -- Windrunner's Overlook, Ebon Watch, Fordragon Hold
				["0.59:0.57:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 354, -- Windrunner's Overlook, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.59:0.57:0.60:0.48:0.69:0.58:0.72:0.60"] = 202, -- Windläufers Warte, Feste Wintergarde, Lichtbresche, Argentumwache
				["0.59:0.57:0.52:0.62:0.41:0.57:0.28:0.72"] = 315, -- Windrunner's Overlook, Dalaran, Valiance Landing Camp, Death's Rise
				["0.59:0.57:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 205, -- Windrunner's Overlook, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.59:0.57:0.52:0.62:0.49:0.79"] = 162, -- Windrunner's Overlook, Dalaran, Argent Tournament Grounds
				["0.59:0.57:0.52:0.62:0.24:0.60:0.21:0.51:0.22:0.39"] = 379, -- Windrunner's Overlook, Dalaran, River's Heart, Fizzcrank Airstrip, Valiance Keep
				["0.59:0.57:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51"] = 335, -- Windläufers Warte, Dalaran, Feste Fordragon, Sternenruh, Landebahn Kurbelzisch
				["0.59:0.57:0.60:0.48:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 410, -- Windrunner's Overlook, Wintergarde Keep, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.59:0.57:0.52:0.62:0.56:0.64:0.28:0.72"] = 293, -- Windrunner's Overlook, Dalaran, The Argent Vanguard, Death's Rise
				["0.59:0.57:0.64:0.58:0.69:0.58:0.73:0.46:0.76:0.33"] = 257, -- Windläufers Warte, Schwarze Wacht, Lichtbresche, Ammertannhütte, Westwacht
				["0.59:0.57:0.60:0.48:0.49:0.42:0.74:0.29"] = 352, -- Windläufers Warte, Feste Wintergarde, Moa'ki, Kamagua
				["0.59:0.57:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40:0.88:0.28"] = 339, -- Windrunner's Overlook, Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar, Valgarde Port

				----------------------------------------------------------------------
				-- Alliance: Dalaran
				----------------------------------------------------------------------

				-- Alliance: Dalaran
				["0.52:0.62:0.54:0.48"] = 122, -- Dalaran, Wyrmrest Temple
				["0.52:0.62:0.59:0.57:0.60:0.48"] = 128, -- Dalaran, Windrunner's Overlook, Wintergarde Keep (tm4psycko@yahoo.com reported 97)
				["0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.88:0.28"] = 317, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Valgarde Port (Michael Khan reported 348)
				["0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46"] = 199, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge
				["0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40"] = 301, -- Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar
				["0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62"] = 185, -- Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33"] = 248, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep
				["0.52:0.62:0.24:0.60"] = 212, -- Dalaran, River's Heart
				["0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54"] = 216, -- Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.74:0.29"] = 298, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Kamagua
				["0.52:0.62:0.46:0.54:0.42:0.47"] = 174, -- Dalaran, Fordragon Hold, Stars' Rest (RJ Graves reported 135)
				["0.52:0.62:0.49:0.42"] = 160, -- Dalaran, Moa'ki
				["0.52:0.62:0.41:0.57"] = 115, -- Dalaran, Valiance Landing Camp (Kirk M reported 141)
				["0.52:0.62:0.59:0.57"] = 53, -- Dalaran, Windrunner's Overlook
				["0.52:0.62:0.46:0.54:0.42:0.47:0.29:0.43"] = 270, -- Dalaran, Fordragon Hold, Stars' Rest, Unu'pe
				["0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 239, -- Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.52:0.62:0.56:0.64:0.57:0.67"] = 72, -- Dalaran, The Argent Vanguard, Frosthold
				["0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39"] = 302, -- Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep
				["0.52:0.62:0.62:0.64"] = 55, -- Dalaran, K3
				["0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 353, -- Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47"] = 317, -- Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.52:0.62:0.24:0.60:0.21:0.51"] = 274, -- Dalaran, River's Heart, Fizzcrank Airstrip
				["0.52:0.62:0.46:0.54"] = 100, -- Dalaran, Fordragon Hold
				["0.52:0.62:0.52:0.66:0.28:0.72"] = 206, -- Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.52:0.62:0.64:0.58"] = 82, -- Dalaran, Ebon Watch
				["0.52:0.62:0.64:0.58:0.72:0.60"] = 145, -- Dalaran, Ebon Watch, The Argent Stand
				["0.52:0.62:0.64:0.58:0.69:0.58"] = 126, -- Dalaran, Ebon Watch, Light's Breach (Florian Mein reported 85)
				["0.52:0.62:0.49:0.79"] = 123, -- Dalaran, Argent Tournament Grounds
				["0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 136, -- Dalaran, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.52:0.62:0.54:0.48:0.42:0.47:0.29:0.43"] = 282, -- Dalaran, Wyrmrest Temple, Stars' Rest, Unu'pe
				["0.52:0.62:0.49:0.42:0.29:0.43"] = 288, -- Dalaran, Moa'ki, Unu'pe
				["0.52:0.62:0.54:0.48:0.42:0.47:0.22:0.39"] = 313, -- Dalaran, Wyrmrest Temple, Stars' Rest, Valiance Keep
				["0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46:0.83:0.54"] = 280, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.52:0.62:0.64:0.58:0.60:0.48:0.73:0.46"] = 214, -- Dalaran, Ebon Watch, Wintergarde Keep, Amberpine Lodge
				["0.52:0.62:0.49:0.42:0.74:0.29:0.88:0.28"] = 421, -- Dalaran, Moa'ki, Kamagua, Valgarde Port
				["0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47"] = 343, -- Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.52:0.62:0.54:0.48:0.60:0.48"] = 169, -- Dalaran, Wyrmrest Temple, Wintergarde Keep
				["0.52:0.62:0.54:0.48:0.60:0.48:0.76:0.33:0.88:0.28"] = 358, -- Dalaran, Wyrmrest Temple, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51"] = 299, -- Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip
				["0.52:0.62:0.46:0.54:0.60:0.48:0.76:0.33"] = 307, -- Dalaran, Fordragon Hold, Wintergarde Keep, Westguard Keep
				["0.52:0.62:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 391, -- Dalaran, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.52:0.62:0.49:0.42:0.29:0.43:0.21:0.51"] = 367, -- Dalaran, Moa'ki, Unu'pe, Fizzcrank Airstrip
				["0.52:0.62:0.49:0.42:0.29:0.43:0.22:0.39"] = 348, -- Dalaran, Moa'ki, Unu'pe, Valiance Keep
				["0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46"] = 240, -- Dalaran, Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge
				["0.52:0.62:0.49:0.42:0.74:0.29"] = 341, -- Dalaran, Moa'ki, Kamagua
				["0.52:0.62:0.54:0.48:0.42:0.47"] = 187, -- Dalaran, Wyrmrest Temple, Stars' Rest
				["0.52:0.62:0.49:0.42:0.74:0.29:0.76:0.33"] = 377, -- Dalaran, Moa'ki, Kamagua, Westguard Keep
				["0.52:0.62:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 355, -- Dalaran, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.52:0.62:0.49:0.42:0.42:0.47"] = 212, -- Dalaran, Moa'ki, Stars' Rest
				["0.52:0.62:0.54:0.48:0.60:0.48:0.76:0.33"] = 289, -- Dalaran, Wyrmrest Temple, Wintergarde Keep, Westguard Keep
				["0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46"] = 209, -- Dalaran, Ebon Watch, Light's Breach, Amberpine Lodge
				["0.52:0.62:0.62:0.64:0.72:0.71"] = 156, -- Dalaran, K3, Dun Nifflelem
				["0.52:0.62:0.49:0.42:0.74:0.29:0.76:0.33:0.73:0.46:0.83:0.54"] = 535, -- Dalaran, Moa'ki, Kamagua, Westguard Keep, Amberpine Lodge, Westfall Brigade
				["0.52:0.62:0.49:0.42:0.74:0.29:0.76:0.33:0.73:0.46"] = 452, -- Dalaran, Moa'ki, Kamagua, Westguard Keep, Amberpine Lodge, Westfall Brigade
				["0.52:0.62:0.49:0.42:0.60:0.48"] = 242, -- Dalaran, Moa'ki, Wintergarde Keep
				["0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 379, -- Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.52:0.62:0.49:0.42:0.60:0.48:0.73:0.46"] = 313, -- Dalaran, Moa'ki, Wintergarde Keep, Westfall Brigade
				["0.52:0.62:0.64:0.58:0.60:0.48"] = 142, -- Dalaran, Ebon Watch, Wintergarde Keep
				["0.52:0.62:0.54:0.48:0.60:0.48:0.69:0.58"] = 251, -- Dalaran, Wyrmrest Temple, Wintergarde Keep, Light's Breach
				["0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46:0.83:0.54"] = 292, -- Dalaran, Ebon Watch, Light's Breach, Amberpine Lodge, Westfall Brigade
				["0.52:0.62:0.49:0.42:0.29:0.43:0.22:0.39:0.17:0.47:0.12:0.47"] = 445, -- Dalaran, Moa'ki, Unu'pe, Valiance Keep, Amber Ledge, Transitus Shield
				["0.52:0.62:0.49:0.42:0.42:0.47:0.21:0.51"] = 337, -- Dalaran, Moa'ki, Stars' Rest, Fizzcrank Airstrip
				["0.52:0.62:0.54:0.48:0.42:0.47:0.22:0.39:0.17:0.47"] = 375, -- Dalaran, Wyrmrest Temple, Stars' Rest, Valiance Keep, Amber Ledge
				["0.52:0.62:0.49:0.42:0.60:0.48:0.69:0.58"] = 324, -- Dalaran, Moa'ki, Wintergarde Keep, Light's Breach
				["0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46:0.88:0.40"] = 354, -- Dalaran, Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.52:0.62:0.46:0.54:0.60:0.48"] = 187, -- Dalaran, Fordragon Hold, Wintergarde Keep
				["0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46:0.83:0.54"] = 320, -- Dalaran, Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.52:0.62:0.54:0.48:0.42:0.47:0.21:0.51"] = 312, -- Dalaran, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip
				["0.52:0.62:0.62:0.64:0.72:0.71:0.64:0.81"] = 239, -- Dalaran, K3, Dun Nifflelem, Ulduar
				["0.52:0.62:0.24:0.60:0.18:0.60"] = 247, -- Dalaran, River's Heart, Nesingwary Base Camp
				["0.52:0.62:0.54:0.48:0.60:0.48:0.76:0.33:0.88:0.40"] = 373, -- Dalaran, Wyrmrest Temple, Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.52:0.62:0.49:0.42:0.60:0.48:0.76:0.33"] = 362, -- Dalaran, Moa'ki, Wintergarde Keep, Westguard Keep
				["0.52:0.62:0.49:0.42:0.42:0.47:0.22:0.39:0.17:0.47"] = 402, -- Dalaran, Moa'ki, Stars' Rest, Valiance Keep, Amber Ledge
				["0.52:0.62:0.49:0.42:0.60:0.48:0.76:0.33:0.88:0.40"] = 446, -- Dalaran, Moa'ki, Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.52:0.62:0.49:0.42:0.74:0.29:0.76:0.33:0.88:0.40"] = 462, -- Dalaran, Moa'ki, Kamagua, Westguard Keep, Fort Wildervar
				["0.52:0.62:0.64:0.58:0.60:0.48:0.76:0.33:0.88:0.28"] = 332, -- Dalaran, Ebon Watch, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.52:0.62:0.54:0.48:0.60:0.48:0.76:0.33:0.74:0.29"] = 339, -- Dalaran, Wyrmrest Temple, Wintergarde Keep, Westguard Keep, Kamagua
				["0.52:0.62:0.59:0.57:0.60:0.48:0.42:0.47"] = 237, -- Dalaran, Windläufers Warte, Feste Wintergarde, Sternenruh
				["0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39:0.17:0.47"] = 363, -- Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep, Amber Ledge
				["0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.88:0.40"] = 332, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.52:0.62:0.52:0.66"] = 40, -- Dalaran, Crusaders' Pinnacle
				["0.52:0.62:0.64:0.58:0.60:0.48:0.73:0.46:0.88:0.40"] = 328, -- Dalaran, Ebon Watch, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46:0.83:0.54:0.78:0.62"] = 352, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge, Westfall Brigade, Zim'Torga
				["0.52:0.62:0.49:0.42:0.29:0.43:0.22:0.39:0.17:0.47"] = 410, -- Dalaran, Moa'ki, Unu'pe, Valiance Keep, Amber Ledge
				["0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 399, -- Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.52:0.62:0.64:0.58:0.60:0.48:0.73:0.46:0.83:0.54"] = 294, -- Dalaran, Ebon Watch, Wintergarde Keep, Amberpine Lodge, Westfall Brigade (Maik Fischer reported 213)
				["0.52:0.62:0.64:0.58:0.60:0.48:0.76:0.33"] = 263, -- Dalaran, Schwarze Wacht, Feste Wintergarde, Westwacht
				["0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46:0.83:0.54:0.72:0.60"] = 402, -- Dalaran, Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge, Westfall Brigade, The Argent Stand
				["0.52:0.62:0.49:0.42:0.42:0.47:0.22:0.39"] = 340, -- Dalaran, Moa'ki, Stars' Rest, Valiance Keep
				["0.52:0.62:0.49:0.42:0.60:0.48:0.73:0.46:0.83:0.54"] = 393, -- Dalaran, Moa'ki, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 168, -- Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.52:0.62:0.46:0.54:0.60:0.48:0.76:0.33:0.88:0.28"] = 376, -- Dalaran, Fordragon Hold, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.52:0.62:0.49:0.42:0.42:0.47:0.21:0.51:0.17:0.47"] = 381, -- Dalaran, Moa'ki, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.52:0.62:0.24:0.60:0.21:0.51:0.42:0.47"] = 405, -- Dalaran, River's Heart, Fizzcrank Airstrip, Stars' Rest
				["0.52:0.62:0.59:0.57:0.60:0.48:0.69:0.58"] = 211, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Light's Breach
				["0.52:0.62:0.56:0.64"] = 33, -- Dalaran, The Argent Vanguard
				["0.52:0.62:0.46:0.54:0.60:0.48:0.73:0.46"] = 258, -- Dalaran, Fordragon Hold, Wintergarde Keep, Amberpine Lodge
				["0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46:0.88:0.40"] = 313, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.52:0.62:0.49:0.42:0.60:0.48:0.73:0.46:0.88:0.40"] = 427, -- Dalaran, Moa'ki, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46:0.76:0.33"] = 292, -- Dalaran, Ebon Watch, Light's Breach, Amberpine Lodge, Westguard Keep
				["0.52:0.62:0.46:0.54:0.60:0.48:0.73:0.46:0.83:0.54"] = 338, -- Dalaran, Feste Fordragon, Feste Wintergarde, Ammertannhütte, Westfallbrigade
				["0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 339, -- Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Ulduar
				["0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46:0.76:0.33:0.88:0.28"] = 360, -- Dalaran, Ebon Watch, Light's Breach, Amberpine Lodge, Westguard Keep, Valgarde Port
				["0.52:0.62:0.62:0.64:0.57:0.67"] = 98, -- Dalaran, K3, Frosthold
				["0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 270, -- Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.52:0.62:0.62:0.64:0.57:0.67:0.64:0.81"] = 195, -- Dalaran, K3, Frosthold, Ulduar
				["0.52:0.62:0.59:0.57:0.60:0.48:0.42:0.47:0.29:0.43"] = 333, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Stars' Rest, Unu'pe
				["0.52:0.62:0.46:0.54:0.60:0.48:0.76:0.33:0.74:0.29"] = 356, -- Dalaran, Fordragon Hold, Wintergarde Keep, Westguard Keep, Kamagua
				["0.52:0.62:0.46:0.54:0.60:0.48:0.69:0.58"] = 270, -- Dalaran, Fordragon Hold, Wintergarde Keep, Light's Breach
				["0.52:0.62:0.54:0.48:0.60:0.48:0.69:0.58:0.72:0.60"] = 294, -- Dalaran, Wyrmrest Temple, Wintergarde Keep, Light's Breach, The Argent Stand
				["0.52:0.62:0.54:0.48:0.60:0.48:0.69:0.58:0.72:0.60:0.78:0.62"] = 335, -- Dalaran, Wyrmrest Temple, Wintergarde Keep, Light's Breach, The Argent Stand, Zim'Torga
				["0.52:0.62:0.24:0.60:0.28:0.72"] = 296, -- Dalaran, River's Heart, Death's Rise
				["0.52:0.62:0.62:0.64:0.57:0.67:0.57:0.79"] = 162, -- Dalaran, K3, Frosthold, Bouldercrag's Refuge
				["0.52:0.62:0.49:0.42:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 417, -- Dalaran, Moa'ki, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.52:0.62:0.64:0.58:0.60:0.48:0.42:0.47"] = 251, -- Dalaran, Ebon Watch, Wintergarde Keep, Stars' Rest
				["0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46:0.88:0.40"] = 325, -- Dalaran, Ebon Watch, Light's Breach, Amberpine Lodge, Fort Wildervar
				["0.52:0.62:0.59:0.57:0.60:0.48:0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 347, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Light's Breach, The Argent Stand, Zim'Torga, Gundrak
				["0.52:0.62:0.54:0.48:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 411, -- Dalaran, Wyrmrest Temple, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.52:0.62:0.64:0.58:0.60:0.48:0.42:0.47:0.22:0.39"] = 378, -- Dalaran, Ebon Watch, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.52:0.62:0.41:0.57:0.42:0.47"] = 195, -- Dalaran, Valiance Landing Camp, Stars' Rest
				["0.52:0.62:0.41:0.57:0.28:0.72"] = 281, -- Dalaran, Valiance Landing Camp, Death's Rise
				["0.52:0.62:0.64:0.58:0.60:0.48:0.76:0.33:0.74:0.29"] = 312, -- Dalaran, Schwarze Wacht, Feste Wintergarde, Westwacht, Kamagua
				["0.52:0.62:0.49:0.42:0.60:0.48:0.73:0.46:0.83:0.54:0.72:0.60"] = 474, -- Dalaran, Moa'ki, Wintergarde Keep, Amberpine Lodge, Westfall Brigade, The Argent Stand
				["0.52:0.62:0.62:0.64:0.72:0.71:0.78:0.62:0.72:0.60"] = 296, -- Dalaran, K3, Dun Nifflelem, Zim'Torga, The Argent Stand
				["0.52:0.62:0.62:0.64:0.72:0.71:0.78:0.62:0.82:0.69"] = 297, -- Dalaran, K3, Dun Nifflelem, Zim'Torga, Gundrak
				["0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46:0.88:0.40:0.88:0.28"] = 387, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge, Fort Wildervar, Valgarde Port
				["0.52:0.62:0.41:0.57:0.42:0.47:0.21:0.51"] = 322, -- Dalaran, Valiance Landing Camp, Stars' Rest, Fizzcrank Airstrip
				["0.52:0.62:0.62:0.64:0.72:0.71:0.78:0.62"] = 244, -- Dalaran, K3, Dun Nifflelem, Zim'Torga
				["0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81:0.72:0.71"] = 272, -- Dalaran, The Argent Vanguard, Frosthold, Ulduar, Dun Nifflelem
				["0.52:0.62:0.54:0.48:0.60:0.48:0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 388, -- Dalaran, Wyrmruhtempel, Feste Wintergarde, Lichtbresche, Argentumwache, Zim'Torga, Gundrak
				["0.52:0.62:0.59:0.57:0.60:0.48:0.69:0.58:0.72:0.60"] = 253, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Light's Breach, The Argent Stand
				["0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46:0.76:0.33:0.74:0.29"] = 343, -- Dalaran, Schwarze Wacht, Lichtbresche, Ammertannhütte, Westwacht, Kamagua
				["0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81:0.78:0.62"] = 321, -- Dalaran, Die Argentumvorhut, Eisfestung, Ulduar, Zim'Torga
				["0.52:0.62:0.52:0.66:0.38:0.79"] = 163, -- Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.52:0.62:0.56:0.64:0.38:0.79"] = 179, -- Dalaran, The Argent Vanguard, The Shadow Vault
				["0.52:0.62:0.52:0.66:0.57:0.79:0.64:0.81"] = 327, -- Dalaran, Crusaders' Pinnacle, Bouldercrag's Refuge, Ulduar
				["0.52:0.62:0.41:0.57:0.42:0.47:0.22:0.39"] = 325, -- Dalaran, Valiance Landing Camp, Stars' Rest, Valiance Keep
				["0.52:0.62:0.49:0.42:0.60:0.48:0.73:0.46:0.83:0.54:0.78:0.62"] = 466, -- Dalaran, Moa'ki, Wintergarde Keep, Amberpine Lodge, Westfall Brigade, Zim'Torga
				["0.52:0.62:0.41:0.57:0.42:0.47:0.29:0.43"] = 293, -- Dalaran, Valiance Landing Camp, Stars' Rest, Unu'pe
				["0.52:0.62:0.52:0.66:0.57:0.79"] = 283, -- Dalaran, Crusaders' Pinnacle, Bouldercrag's Refuge
				["0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40:0.88:0.28"] = 374, -- Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar, Valgarde Port
				["0.52:0.62:0.49:0.42:0.60:0.48:0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 460, -- Dalaran, Moa'ki, Wintergarde Keep, Light's Breach, The Argent Stand, Zim'Torga, Gundrak
				["0.52:0.62:0.24:0.60:0.21:0.51:0.22:0.39"] = 343, -- Dalaran, River's Heart, Fizzcrank Airstrip, Valiance Keep
				["0.52:0.62:0.56:0.64:0.28:0.72"] = 257, -- Dalaran, Die Argentumvorhut, Todesanhöhe
				["0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81:0.57:0.79:0.38:0.79"] = 500, -- Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Ulduar, Bouldercrag's Refuge, The Shadow Vault
				["0.52:0.62:0.62:0.64:0.57:0.67:0.57:0.79:0.38:0.79"] = 276, -- Dalaran, K3, Frosthold, Bouldercrag's Refuge, The Shadow Vault
				["0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46:0.88:0.40:0.88:0.28"] = 428, -- Dalaran, Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge, Fort Wildervar, Valgarde Port
				["0.52:0.62:0.62:0.64:0.72:0.71:0.78:0.62:0.83:0.54"] = 299, -- Dalaran, K3, Dun Nifflelem, Zim'Torga, Westfall Brigade
				["0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81:0.57:0.79"] = 387, -- Dalaran, Schwarze Wacht, Argentumwache, Zim'Torga, Ulduar, Bergfels' Zuflucht
				["0.52:0.62:0.24:0.60:0.21:0.51:0.29:0.43"] = 337, -- Dalaran, River's Heart, Fizzcrank Airstrip, Unu'pe
				["0.52:0.62:0.56:0.64:0.57:0.79:0.64:0.81"] = 345, -- Dalaran, The Argent Vanguard, Bouldercrag's Refuge, Ulduar
				["0.52:0.62:0.46:0.54:0.60:0.48:0.76:0.33:0.88:0.40"] = 391, -- Dalaran, Fordragon Hold, Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.52:0.62:0.41:0.57:0.57:0.79:0.64:0.81:0.72:0.71"] = 544, -- Dalaran, Valianzlager, Bergfels' Zuflucht, Ulduar, Dun Niffelem
				["0.52:0.62:0.49:0.42:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 438, -- Dalaran, Moa'ki, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.52:0.62:0.46:0.54:0.60:0.48:0.73:0.46:0.88:0.40"] = 372, -- Dalaran, Fordragon Hold, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.52:0.62:0.62:0.64:0.72:0.71:0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46"] = 403, -- Dalaran, K3, Dun Nifflelem, Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge
				["0.52:0.62:0.54:0.48:0.60:0.48:0.69:0.58:0.72:0.60:0.83:0.54"] = 365, -- Dalaran, Wyrmruhtempel, Feste Wintergarde, Lichtbresche, Argentumwache, Westfallbrigade
				["0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81:0.78:0.62:0.82:0.69"] = 374, -- Dalaran, L'avant-garde d'Argent, Fort du Givre, Ulduar, Zim'Torga, Gundrak
				["0.52:0.62:0.59:0.57:0.60:0.48:0.42:0.47:0.22:0.39"] = 363, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.52:0.62:0.59:0.57:0.60:0.48:0.42:0.47:0.21:0.51"] = 362, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip
				["0.52:0.62:0.41:0.57:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 402, -- Dalaran, Valiance Landing Camp, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.52:0.62:0.56:0.64:0.57:0.79"] = 300, -- Dalaran, The Argent Vanguard, Bouldercrag's Refuge
				["0.52:0.62:0.59:0.57:0.60:0.48:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 461, -- Dalaran, Windläufers Warte, Feste Wintergarde, Sternenruh, Valianzfeste, Bernsteinflöz, Transitusschild
				["0.52:0.62:0.24:0.60:0.28:0.72:0.38:0.79"] = 390, -- Dalaran, River's Heart, Death's Rise, The Shadow Vault
				["0.52:0.62:0.64:0.58:0.60:0.48:0.76:0.33:0.88:0.40"] = 346, -- Dalaran, Ebon Watch, Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.52:0.62:0.41:0.57:0.42:0.47:0.22:0.39:0.17:0.47"] = 387, -- Dalaran, Valiance Landing Camp, Stars' Rest, Valiance Keep, Amber Ledge
				["0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46:0.88:0.40:0.88:0.28"] = 398, -- Dalaran, Ebon Watch, Light's Breach, Amberpine Lodge, Fort Wildervar, Valgarde Port
				["0.52:0.62:0.41:0.57:0.42:0.47:0.60:0.48:0.76:0.33:0.88:0.28"] = 506, -- Dalaran, Valiance Landing Camp, Stars' Rest, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.52:0.62:0.46:0.54:0.60:0.48:0.69:0.58:0.72:0.60"] = 312, -- Dalaran, Fordragon Hold, Wintergarde Keep, Light's Breach, The Argent Stand
				["0.52:0.62:0.54:0.48:0.60:0.48:0.69:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 488, -- Dalaran, Wyrmrest Temple, Wintergarde Keep, Light's Breach, The Argent Stand, Zim'Torga, Ulduar
				["0.52:0.62:0.49:0.79:0.57:0.79"] = 171, -- Dalaran, Argent Tournament Grounds, Bouldercrag's Refuge
				["0.52:0.62:0.49:0.79:0.57:0.79:0.64:0.81"] = 214, -- Dalaran, Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar
				["0.52:0.62:0.62:0.64:0.72:0.71:0.64:0.81:0.57:0.79"] = 287, -- Dalaran, K3, Dun Niffelem, Ulduar, Bergfels' Zuflucht
				["0.52:0.62:0.49:0.79:0.38:0.79"] = 207, -- Dalaran, Argent Tournament Grounds, The Shadow Vault
				["0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46:0.83:0.54:0.72:0.60"] = 361, -- Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge, Westfall Brigade, The Argent Stand
				["0.52:0.62:0.49:0.79:0.28:0.72"] = 284, -- Dalaran, Argent Tournament Grounds, Death's Rise
				["0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40:0.76:0.33"] = 380, -- Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar, Westguard Keep
				["0.52:0.62:0.41:0.57:0.42:0.47:0.21:0.51:0.17:0.47"] = 366, -- Dalaran, Valiance Landing Camp, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.52:0.62:0.41:0.57:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 423, -- Dalaran, Valiance Landing Camp, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.52:0.62:0.49:0.42:0.60:0.48:0.76:0.33:0.88:0.28"] = 431, -- Dalaran, Moa'ki, Feste Wintergarde, Westwacht, Hafen von Valgarde

				----------------------------------------------------------------------
				-- Alliance: Dragonblight
				----------------------------------------------------------------------

				-- Alliance: Dragonblight: Fordragon Hold
				["0.46:0.54:0.42:0.47"] = 74, -- Fordragon Hold, Stars' Rest
				["0.46:0.54:0.54:0.48:0.49:0.42"] = 118, -- Fordragon Hold, Wyrmrest Temple, Moa'ki
				["0.46:0.54:0.54:0.48"] = 65, -- Fordragon Hold, Wyrmrest Temple
				["0.46:0.54:0.52:0.62:0.59:0.57"] = 109, -- Fordragon Hold, Dalaran, Windrunner's Overlook
				["0.46:0.54:0.52:0.62"] = 66, -- Fordragon Hold, Dalaran
				["0.46:0.54:0.60:0.48"] = 88, -- Fordragon Hold, Wintergarde Keep
				["0.46:0.54:0.42:0.47:0.22:0.39"] = 202, -- Fordragon Hold, Stars' Rest, Valiance Keep
				["0.46:0.54:0.60:0.48:0.76:0.33:0.88:0.28"] = 276, -- Fordragon Hold, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.46:0.54:0.60:0.48:0.76:0.33:0.74:0.29"] = 257, -- Fordragon Hold, Wintergarde Keep, Westguard Keep, Kamagua
				["0.46:0.54:0.42:0.47:0.29:0.43"] = 171, -- Fordragon Hold, Stars' Rest, Unu'pe
				["0.46:0.54:0.60:0.48:0.76:0.33"] = 208, -- Fordragon Hold, Wintergarde Keep, Westguard Keep
				["0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47"] = 243, -- Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.46:0.54:0.60:0.48:0.49:0.42"] = 180, -- Fordragon Hold, Wintergarde Keep, Moa'ki
				["0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 279, -- Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.46:0.54:0.42:0.47:0.21:0.51:0.24:0.60"] = 262, -- Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, River's Heart
				["0.46:0.54:0.60:0.48:0.73:0.46"] = 159, -- Fordragon Hold, Wintergarde Keep, Amberpine Lodge
				["0.46:0.54:0.42:0.47:0.21:0.51"] = 200, -- Fordragon Hold, Stars' Rest, Fizzcrank Airstrip
				["0.46:0.54:0.64:0.58:0.69:0.58"] = 163, -- Fordragon Hold, Ebon Watch, Light's Breach
				["0.46:0.54:0.60:0.48:0.69:0.58"] = 170, -- Fordragon Hold, Wintergarde Keep, Light's Breach
				["0.46:0.54:0.52:0.62:0.52:0.66"] = 95, -- Fordragon Hold, Dalaran, Crusaders' Pinnacle
				["0.46:0.54:0.52:0.62:0.62:0.64"] = 112, -- Fordragon Hold, Dalaran, K3
				["0.46:0.54:0.60:0.48:0.73:0.46:0.83:0.54"] = 239, -- Feste Fordragon, Feste Wintergarde, Ammertannhütte, Westfallbrigade
				["0.46:0.54:0.52:0.62:0.62:0.64:0.72:0.71"] = 212, -- Fordragon Hold, Dalaran, K3, Dun Nifflelem
				["0.46:0.54:0.64:0.58:0.72:0.60"] = 183, -- Fordragon Hold, Ebon Watch, The Argent Stand
				["0.46:0.54:0.41:0.57"] = 60, -- Fordragon Hold, Valiance Landing Camp
				["0.46:0.54:0.52:0.62:0.56:0.64"] = 90, -- Fordragon Hold, Dalaran, The Argent Vanguard
				["0.46:0.54:0.54:0.48:0.49:0.42:0.74:0.29:0.88:0.28"] = 381, -- Fordragon Hold, Wyrmrest Temple, Moa'ki, Kamagua, Valgarde Port
				["0.46:0.54:0.52:0.62:0.56:0.64:0.57:0.67"] = 128, -- Fordragon Hold, Dalaran, The Argent Vanguard, Frosthold
				["0.46:0.54:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 299, -- Feste Fordragon, Sternenruh, Valianzfeste, Bernsteinflöz, Transitusschild
				["0.46:0.54:0.60:0.48:0.59:0.57"] = 152, -- Fordragon Hold, Wintergarde Keep, Windrunner's Overlook
				["0.46:0.54:0.42:0.47:0.21:0.51:0.18:0.60"] = 275, -- Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Nesingwary Base Camp
				["0.46:0.54:0.52:0.62:0.52:0.66:0.28:0.72"] = 263, -- Fordragon Hold, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.46:0.54:0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 193, -- Fordragon Hold, Dalaran, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.46:0.54:0.60:0.48:0.73:0.46:0.88:0.40"] = 273, -- Fordragon Hold, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.46:0.54:0.42:0.47:0.49:0.42"] = 142, -- Fordragon Hold, Stars' Rest, Moa'ki
				["0.46:0.54:0.41:0.57:0.24:0.60"] = 196, -- Fordragon Hold, Valiance Landing Camp, River's Heart
				["0.46:0.54:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 277, -- Крепость Фордрагона, Черная застава, Серебряная застава, Зим'Торга, Гундрак
				["0.46:0.54:0.64:0.58"] = 119, -- Fordragon Hold, Ebon Watch
				["0.46:0.54:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 225, -- Fordragon Hold, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.46:0.54:0.52:0.62:0.52:0.66:0.38:0.79"] = 218, -- Fordragon Hold, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.46:0.54:0.64:0.58:0.72:0.60:0.78:0.62"] = 223, -- Fordragon Hold, Ebon Watch, The Argent Stand, Zim'Torga
				["0.46:0.54:0.64:0.58:0.72:0.60:0.83:0.54"] = 253, -- Fordragon Hold, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.46:0.54:0.60:0.48:0.69:0.58:0.72:0.60"] = 212, -- Feste Fordragon, Feste Wintergarde, Lichtbresche, Argentumwache
				["0.46:0.54:0.41:0.57:0.24:0.60:0.18:0.60"] = 231, -- Fordragon Hold, Valiance Landing Camp, River's Heart, Nesingwary Base Camp
				["0.46:0.54:0.42:0.47:0.22:0.39:0.17:0.47"] = 264, -- Fordragon Hold, Stars' Rest, Valiance Keep, Amber Ledge
				["0.46:0.54:0.54:0.48:0.49:0.42:0.74:0.29:0.76:0.33"] = 337, -- Fordragon Hold, Wyrmrest Temple, Moa'ki, Kamagua, Westguard Keep
				["0.46:0.54:0.41:0.57:0.57:0.79"] = 341, -- Fordragon Hold, Valiance Landing Camp, Bouldercrag's Refuge
				["0.46:0.54:0.52:0.62:0.49:0.79"] = 181, -- Fordragon Hold, Dalaran, Argent Tournament Grounds
				["0.46:0.54:0.41:0.57:0.38:0.79"] = 220, -- Fordragon Hold, Valiance Landing Camp, The Shadow Vault
				["0.46:0.54:0.41:0.57:0.28:0.72"] = 226, -- Fordragon Hold, Valiance Landing Camp, Death's Rise
				["0.46:0.54:0.52:0.62:0.24:0.60"] = 267, -- Fordragon Hold, Dalaran, River's Heart
				["0.46:0.54:0.54:0.48:0.49:0.42:0.29:0.43:0.22:0.39:0.17:0.47"] = 370, -- Fordragon Hold, Wyrmrest Temple, Moa'ki, Unu'pe, Valiance Keep, Amber Ledge

				-- Alliance: Dragonblight: Moa'ki
				["0.49:0.42:0.42:0.47"] = 55, -- Moa'ki, Stars' Rest
				["0.49:0.42:0.42:0.47:0.41:0.57"] = 118, -- Moa'ki, Stars' Rest, Valiance Landing Camp
				["0.49:0.42:0.52:0.62"] = 123, -- Moa'ki, Dalaran
				["0.49:0.42:0.54:0.48"] = 49, -- Moa'ki, Wyrmrest Temple
				["0.49:0.42:0.60:0.48"] = 86, -- Moa'ki, Wintergarde Keep
				["0.49:0.42:0.54:0.48:0.46:0.54"] = 106, -- Moa'ki, Wyrmrest Temple, Fordragon Hold
				["0.49:0.42:0.60:0.48:0.76:0.33"] = 205, -- Moa'ki, Wintergarde Keep, Westguard Keep
				["0.49:0.42:0.74:0.29:0.88:0.28"] = 265, -- Moa'ki, Kamagua, Valgarde Port
				["0.49:0.42:0.29:0.43"] = 133, -- Moa'ki, Unu'pe
				["0.49:0.42:0.74:0.29"] = 185, -- Moa'ki, Kamagua
				["0.49:0.42:0.60:0.48:0.73:0.46:0.88:0.40"] = 271, -- Moa'ki, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.49:0.42:0.42:0.47:0.22:0.39"] = 184, -- Moa'ki, Stars' Rest, Valiance Keep
				["0.49:0.42:0.60:0.48:0.59:0.57"] = 150, -- Moa'ki, Wintergarde Keep, Windrunner's Overlook
				["0.49:0.42:0.74:0.29:0.76:0.33"] = 221, -- Moa'ki, Kamagua, Westguard Keep
				["0.49:0.42:0.42:0.47:0.21:0.51"] = 181, -- Moa'ki, Stars' Rest, Fizzcrank Airstrip
				["0.49:0.42:0.60:0.48:0.73:0.46:0.88:0.40:0.88:0.28"] = 344, -- Moa'ki, Wintergarde Keep, Amberpine Lodge, Fort Wildervar, Valgarde Port
				["0.49:0.42:0.60:0.48:0.73:0.46"] = 156, -- Moa'ki, Wintergarde Keep, Amberpine Lodge
				["0.49:0.42:0.29:0.43:0.21:0.51"] = 211, -- Moa'ki, Unu'pe, Fizzcrank Airstrip
				["0.49:0.42:0.29:0.43:0.22:0.39"] = 191, -- Moa'ki, Unu'pe, Valiance Keep
				["0.49:0.42:0.60:0.48:0.76:0.33:0.88:0.28"] = 274, -- Moa'ki, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.49:0.42:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 281, -- Moa'ki, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.49:0.42:0.74:0.29:0.76:0.33:0.88:0.40"] = 305, -- Moa'ki, Kamagua, Westguard Keep, Fort Wildervar
				["0.49:0.42:0.42:0.47:0.22:0.39:0.17:0.47"] = 245, -- Moa'ki, Stars' Rest, Valiance Keep, Amber Ledge
				["0.49:0.42:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 260, -- Moa'ki, Sternenruh, Landebahn Kurbelzisch, Bernsteinflöz, Transitusschild
				["0.49:0.42:0.42:0.47:0.21:0.51:0.17:0.47"] = 224, -- Moa'ki, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.49:0.42:0.60:0.48:0.76:0.33:0.88:0.40"] = 290, -- Moa'ki, Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.49:0.42:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 300, -- Moa'ki, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.49:0.42:0.42:0.47:0.46:0.54"] = 133, -- Moa'ki, Stars' Rest, Fordragon Hold
				["0.49:0.42:0.52:0.62:0.62:0.64:0.72:0.71"] = 267, -- Moa'ki, Dalaran, K3, Dun Nifflelem
				["0.49:0.42:0.52:0.62:0.52:0.66"] = 150, -- Moa'ki, Dalaran, Crusaders' Pinnacle
				["0.49:0.42:0.42:0.47:0.21:0.51:0.24:0.60"] = 243, -- Moa'ki, Repos des étoiles, Piste d'atterrissage de Spumelevier, Le Cœur du fleuve
				["0.49:0.42:0.29:0.43:0.22:0.39:0.17:0.47:0.12:0.47"] = 290, -- Moa'ki, Unu'pe, Valiance Keep, Amber Ledge, Transitus Shield
				["0.49:0.42:0.60:0.48:0.69:0.58"] = 168, -- Moa'ki, Feste Wintergarde, Lichtbresche
				["0.49:0.42:0.60:0.48:0.73:0.46:0.83:0.54"] = 236, -- Moa'ki, Feste Wintergarde, Ammertannhütte, Westfallbrigade
				["0.49:0.42:0.60:0.48:0.64:0.58"] = 143, -- Moa'ki, Feste Wintergarde, Schwarze Wacht
				["0.49:0.42:0.42:0.47:0.21:0.51:0.18:0.60"] = 256, -- Moa'ki, Repos des étoiles, Piste d'atterrissage de Spumelevier, Camp de base de Nesingwary
				["0.49:0.42:0.60:0.48:0.64:0.58:0.72:0.60"] = 206, -- Moa'ki, Wintergarde Keep, Ebon Watch, The Argent Stand
				["0.49:0.42:0.52:0.62:0.62:0.64"] = 167, -- Moa'ki, Dalaran, K3
				["0.49:0.42:0.52:0.62:0.64:0.58:0.69:0.58"] = 233, -- Moa'ki, Dalaran, Ebon Watch, Light's Breach
				["0.49:0.42:0.52:0.62:0.56:0.64"] = 145, -- Moa'ki, Dalaran, The Argent Vanguard
				["0.49:0.42:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 280, -- Moa'ki, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.49:0.42:0.42:0.47:0.41:0.57:0.24:0.60"] = 254, -- Moa'ki, Stars' Rest, Valiance Landing Camp, River's Heart
				["0.49:0.42:0.42:0.47:0.41:0.57:0.38:0.79"] = 279, -- Moa'ki, Sternenruh, Valianzlager, Das Schattengewölbe
				["0.49:0.42:0.52:0.62:0.56:0.64:0.57:0.67"] = 183, -- Moa'ki, Dalaran, The Argent Vanguard, Frosthold
				["0.49:0.42:0.42:0.47:0.41:0.57:0.28:0.72"] = 284, -- Moa'ki, Stars' Rest, Valiance Landing Camp, Death's Rise
				["0.49:0.42:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62"] = 246, -- Moa'ki, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga
				["0.49:0.42:0.52:0.62:0.52:0.66:0.28:0.72"] = 317, -- Moa'ki, Dalaran, Kreuzfahrerturm, Todesanhöhe
				["0.49:0.42:0.52:0.62:0.24:0.60"] = 322, -- Moa'ki, Dalaran, River's Heart
				["0.49:0.42:0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 248, -- Moa'ki, Dalaran, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.49:0.42:0.60:0.48:0.69:0.58:0.72:0.60"] = 210, -- Moa'ki, Feste Wintergarde, Lichtbresche, Argentumwache
				["0.49:0.42:0.52:0.62:0.49:0.79"] = 237, -- Moa'ki, Dalaran, Argent Tournament Grounds
				["0.49:0.42:0.54:0.48:0.64:0.58:0.72:0.60:0.83:0.54"] = 288, -- Moa'ki, Wyrmrest Temple, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.49:0.42:0.52:0.62:0.62:0.64:0.57:0.67:0.57:0.79"] = 274, -- Moa'ki, Dalaran, K3, Frosthold, Bouldercrag's Refuge

				-- Alliance: Dragonblight: Stars' Rest
				["0.42:0.47:0.49:0.42"] = 72, -- Stars' Rest, Moa'ki
				["0.42:0.47:0.46:0.54"] = 82, -- Stars' Rest, Fordragon Hold
				["0.42:0.47:0.41:0.57"] = 67, -- Stars' Rest, Valiance Landing Camp
				["0.42:0.47:0.54:0.48"] = 90, -- Stars' Rest, Wyrmrest Temple
				["0.42:0.47:0.60:0.48"] = 125, -- Stars' Rest, Wintergarde Keep
				["0.42:0.47:0.46:0.54:0.52:0.62"] = 147, -- Stars' Rest, Fordragon Hold, Dalaran
				["0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64"] = 170, -- Stars' Rest, Fordragon Hold, Dalaran, The Argent Vanguard
				["0.42:0.47:0.29:0.43"] = 100, -- Stars' Rest, Unu'pe
				["0.42:0.47:0.60:0.48:0.59:0.57"] = 189, -- Stars' Rest, Wintergarde Keep, Windrunner's Overlook
				["0.42:0.47:0.60:0.48:0.76:0.33:0.88:0.28"] = 313, -- Stars' Rest, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.42:0.47:0.46:0.54:0.52:0.62:0.62:0.64"] = 193, -- Stars' Rest, Fordragon Hold, Dalaran, K3
				["0.42:0.47:0.49:0.42:0.74:0.29"] = 254, -- Stars' Rest, Moa'ki, Kamagua
				["0.42:0.47:0.22:0.39"] = 133, -- Stars' Rest, Valiance Keep
				["0.42:0.47:0.21:0.51:0.17:0.47"] = 172, -- Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.42:0.47:0.21:0.51"] = 129, -- Stars' Rest, Fizzcrank Airstrip
				["0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 209, -- Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.42:0.47:0.22:0.39:0.17:0.47"] = 194, -- Stars' Rest, Valiance Keep, Amber Ledge
				["0.42:0.47:0.49:0.42:0.74:0.29:0.88:0.28"] = 334, -- Stars' Rest, Moa'ki, Kamagua, Valgarde Port
				["0.42:0.47:0.49:0.42:0.74:0.29:0.76:0.33"] = 291, -- Stars' Rest, Moa'ki, Kamagua, Westguard Keep
				["0.42:0.47:0.60:0.48:0.73:0.46:0.88:0.40:0.88:0.28"] = 382, -- Stars' Rest, Wintergarde Keep, Amberpine Lodge, Fort Wildervar, Valgarde Port
				["0.42:0.47:0.60:0.48:0.76:0.33"] = 245, -- Stars' Rest, Wintergarde Keep, Westguard Keep
				["0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 230, -- Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.42:0.47:0.60:0.48:0.73:0.46"] = 195, -- Stars' Rest, Wintergarde Keep, Amberpine Lodge
				["0.42:0.47:0.60:0.48:0.73:0.46:0.83:0.54"] = 276, -- Stars' Rest, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.42:0.47:0.60:0.48:0.64:0.58"] = 182, -- Stars' Rest, Wintergarde Keep, Ebon Watch
				["0.42:0.47:0.60:0.48:0.59:0.57:0.52:0.62"] = 236, -- Stars' Rest, Wintergarde Keep, Windrunner's Overlook, Dalaran
				["0.42:0.47:0.54:0.48:0.52:0.62"] = 186, -- Stars' Rest, Wyrmrest Temple, Dalaran
				["0.42:0.47:0.60:0.48:0.76:0.33:0.88:0.40"] = 329, -- Stars' Rest, Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.42:0.47:0.49:0.42:0.74:0.29:0.76:0.33:0.88:0.40"] = 375, -- Stars' Rest, Moa'ki, Kamagua, Westguard Keep, Fort Wildervar
				["0.42:0.47:0.60:0.48:0.76:0.33:0.74:0.29"] = 294, -- Stars' Rest, Wintergarde Keep, Westguard Keep, Kamagua
				["0.42:0.47:0.60:0.48:0.69:0.58"] = 207, -- Stars' Rest, Wintergarde Keep, Light's Breach
				["0.42:0.47:0.49:0.42:0.52:0.62"] = 193, -- Stars' Rest, Moa'ki, Dalaran
				["0.42:0.47:0.54:0.48:0.64:0.58:0.72:0.60"] = 258, -- Stars' Rest, Wyrmrest Temple, Ebon Watch, The Argent Stand
				["0.42:0.47:0.60:0.48:0.69:0.58:0.72:0.60"] = 249, -- Stars' Rest, Wintergarde Keep, Light's Breach, The Argent Stand
				["0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 339, -- Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.42:0.47:0.60:0.48:0.73:0.46:0.88:0.40"] = 310, -- Stars' Rest, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62"] = 286, -- Repos des étoiles, Donjon de Garde-hiver, Guet d'Ébène, Le séjour d'Argent, Zim'Torga
				["0.42:0.47:0.46:0.54:0.52:0.62:0.52:0.66"] = 176, -- Stars' Rest, Fordragon Hold, Dalaran, Crusaders' Pinnacle
				["0.42:0.47:0.46:0.54:0.52:0.62:0.24:0.60:0.18:0.60"] = 383, -- Stars' Rest, Fordragon Hold, Dalaran, River's Heart, Nesingwary Base Camp
				["0.42:0.47:0.60:0.48:0.64:0.58:0.52:0.62"] = 249, -- Stars' Rest, Wintergarde Keep, Ebon Watch, Dalaran
				["0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60"] = 245, -- Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand
				["0.42:0.47:0.60:0.48:0.73:0.46:0.83:0.54:0.78:0.62"] = 348, -- Stars' Rest, Wintergarde Keep, Amberpine Lodge, Westfall Brigade, Zim'Torga
				["0.42:0.47:0.46:0.54:0.52:0.62:0.62:0.64:0.57:0.67"] = 236, -- Stars' Rest, Fordragon Hold, Dalaran, K3, Frosthold
				["0.42:0.47:0.41:0.57:0.52:0.62"] = 157, -- Sternenruh, Valianzlager, Dalaran
				["0.42:0.47:0.41:0.57:0.28:0.72"] = 232, -- Stars' Rest, Valiance Landing Camp, Death's Rise
				["0.42:0.47:0.21:0.51:0.18:0.60"] = 204, -- Sternenruh, Landebahn Kurbelzisch, Nesingwarys Basislager
				["0.42:0.47:0.46:0.54:0.52:0.62:0.62:0.64:0.72:0.71"] = 293, -- Stars' Rest, Fordragon Hold, Dalaran, K3, Dun Nifflelem
				["0.42:0.47:0.21:0.51:0.24:0.60"] = 191, -- Repos des étoiles, Piste d'atterrissage de Spumelevier, Le Cœur du fleuve
				["0.42:0.47:0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 439, -- Stars' Rest, Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga, Ulduar
				["0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 273, -- Sternenruh, Feste Fordragon, Dalaran, Die Argentumvorhut, Eisfestung, Bergfels' Zuflucht
				["0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 305, -- Покой Звезд, Крепость Фордрагона, Даларан, Оплот Серебряного Авангарда, Ледяная крепость, Ульдуар
				["0.42:0.47:0.49:0.42:0.74:0.29:0.76:0.33:0.73:0.46:0.83:0.54:0.72:0.60"] = 530, -- Stars' Rest, Moa'ki, Kamagua, Westguard Keep, Amberpine Lodge, Westfall Brigade, The Argent Stand
				["0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64:0.38:0.79"] = 317, -- Stars' Rest, Fordragon Hold, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.42:0.47:0.46:0.54:0.52:0.62:0.56:0.64:0.57:0.67"] = 209, -- Stars' Rest, Fordragon Hold, Dalaran, The Argent Vanguard, Frosthold
				["0.42:0.47:0.41:0.57:0.38:0.79"] = 227, -- Stars' Rest, Valiance Landing Camp, The Shadow Vault
				["0.42:0.47:0.41:0.57:0.24:0.60"] = 203, -- Sternenruh, Valianzlager, Flussnabel
				["0.42:0.47:0.49:0.42:0.74:0.29:0.76:0.33:0.88:0.40:0.83:0.54"] = 471, -- Stars' Rest, Moa'ki, Kamagua, Westguard Keep, Fort Wildervar, Westfall Brigade
				["0.42:0.47:0.60:0.48:0.64:0.58:0.62:0.64:0.72:0.71"] = 322, -- Stars' Rest, Wintergarde Keep, Ebon Watch, K3, Dun Nifflelem
				["0.42:0.47:0.46:0.54:0.52:0.62:0.52:0.66:0.38:0.79"] = 298, -- Stars' Rest, Fordragon Hold, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.42:0.47:0.41:0.57:0.52:0.66"] = 176, -- Stars' Rest, Valiance Landing Camp, Crusaders' Pinnacle
				["0.42:0.47:0.21:0.51:0.24:0.60:0.28:0.72"] = 277, -- Stars' Rest, Fizzcrank Airstrip, River's Heart, Death's Rise
				["0.42:0.47:0.41:0.57:0.52:0.62:0.62:0.64"] = 203, -- Stars' Rest, Valiance Landing Camp, Dalaran, K3
				["0.42:0.47:0.46:0.54:0.52:0.62:0.62:0.64:0.57:0.67:0.64:0.81"] = 333, -- Stars' Rest, Fordragon Hold, Dalaran, K3, Frosthold, Ulduar
				["0.42:0.47:0.60:0.48:0.64:0.58:0.62:0.64"] = 222, -- Stars' Rest, Wintergarde Keep, Ebon Watch, K3
				["0.42:0.47:0.54:0.48:0.52:0.62:0.56:0.64"] = 208, -- Stars' Rest, Wyrmrest Temple, Dalaran, The Argent Vanguard
				["0.42:0.47:0.54:0.48:0.52:0.62:0.56:0.64:0.57:0.67"] = 246, -- Stars' Rest, Wyrmrest Temple, Dalaran, The Argent Vanguard, Frosthold
				["0.42:0.47:0.60:0.48:0.69:0.58:0.72:0.60:0.78:0.62"] = 290, -- Stars' Rest, Wintergarde Keep, Light's Breach, The Argent Stand, Zim'Torga
				["0.42:0.47:0.46:0.54:0.52:0.62:0.49:0.79"] = 262, -- Sternenruh, Feste Fordragon, Dalaran, Argentumturnierplatz
				["0.42:0.47:0.46:0.54:0.52:0.62:0.59:0.57"] = 189, -- Sternenruh, Feste Fordragon, Dalaran, Windläufers Warte
				["0.42:0.47:0.49:0.42:0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60"] = 473, -- Stars' Rest, Moa'ki, Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand
				["0.42:0.47:0.41:0.57:0.52:0.66:0.49:0.79"] = 272, -- Stars' Rest, Valiance Landing Camp, Crusaders' Pinnacle, Argent Tournament Grounds
				["0.42:0.47:0.49:0.42:0.52:0.62:0.62:0.64"] = 236, -- Stars' Rest, Moa'ki, Dalaran, K3
				["0.42:0.47:0.54:0.48:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40:0.76:0.33"] = 493, -- Sternenruh, Wyrmruhtempel, Schwarze Wacht, Argentumwache, Westfallbrigade, Fort Wildervar, Westwacht
				["0.42:0.47:0.60:0.48:0.73:0.46:0.83:0.54:0.78:0.62:0.82:0.69"] = 401, -- Stars' Rest, Wintergarde Keep, Amberpine Lodge, Westfall Brigade, Zim'Torga, Gundrak
				["0.42:0.47:0.54:0.48:0.64:0.58"] = 195, -- Stars' Rest, Wyrmrest Temple, Ebon Watch

				-- Alliance: Dragonblight: Wintergarde Keep
				["0.60:0.48:0.54:0.48"] = 55, -- Wintergarde Keep, Wyrmrest Temple
				["0.60:0.48:0.59:0.57:0.52:0.62"] = 119, -- Wintergarde Keep, Windrunner's Overlook, Dalaran
				["0.60:0.48:0.49:0.42"] = 99, -- Wintergarde Keep, Moa'ki
				["0.60:0.48:0.42:0.47"] = 115, -- Wintergarde Keep, Stars' Rest
				["0.60:0.48:0.46:0.54"] = 96, -- Wintergarde Keep, Fordragon Hold
				["0.60:0.48:0.46:0.54:0.41:0.57"] = 156, -- Wintergarde Keep, Fordragon Hold, Valiance Landing Camp
				["0.60:0.48:0.69:0.58"] = 89, -- Wintergarde Keep, Light's Breach
				["0.60:0.48:0.73:0.46"] = 77, -- Wintergarde Keep, Amberpine Lodge
				["0.60:0.48:0.76:0.33:0.88:0.28"] = 195, -- Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62"] = 168, -- Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga
				["0.60:0.48:0.42:0.47:0.29:0.43"] = 211, -- Wintergarde Keep, Stars' Rest, Unu'pe
				["0.60:0.48:0.59:0.57"] = 72, -- Wintergarde Keep, Windrunner's Overlook
				["0.60:0.48:0.64:0.58:0.62:0.64:0.57:0.67"] = 148, -- Wintergarde Keep, Ebon Watch, K3, Frosthold
				["0.60:0.48:0.64:0.58:0.62:0.64"] = 105, -- Wintergarde Keep, Ebon Watch, K3
				["0.60:0.48:0.73:0.46:0.88:0.40"] = 191, -- Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.60:0.48:0.42:0.47:0.22:0.39"] = 242, -- Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.60:0.48:0.76:0.33"] = 126, -- Wintergarde Keep, Westguard Keep
				["0.60:0.48:0.64:0.58"] = 64, -- Wintergarde Keep, Ebon Watch
				["0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 284, -- Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.60:0.48:0.76:0.33:0.88:0.40"] = 210, -- Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.60:0.48:0.54:0.48:0.52:0.62"] = 147, -- Wintergarde Keep, Wyrmrest Temple, Dalaran
				["0.60:0.48:0.42:0.47:0.21:0.51"] = 240, -- Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip
				["0.60:0.48:0.76:0.33:0.74:0.29"] = 176, -- Wintergarde Keep, Westguard Keep, Kamagua
				["0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 320, -- Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.60:0.48:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 339, -- Wintergarde Keep, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.60:0.48:0.49:0.42:0.52:0.62"] = 220, -- Wintergarde Keep, Moa'ki, Dalaran
				["0.60:0.48:0.42:0.47:0.22:0.39:0.17:0.47"] = 304, -- Wintergarde Keep, Stars' Rest, Valiance Keep, Amber Ledge
				["0.60:0.48:0.64:0.58:0.52:0.62"] = 132, -- Wintergarde Keep, Ebon Watch, Dalaran
				["0.60:0.48:0.49:0.42:0.74:0.29"] = 282, -- Wintergarde Keep, Moa'ki, Kamagua
				["0.60:0.48:0.49:0.42:0.29:0.43:0.22:0.39"] = 289, -- Wintergarde Keep, Moa'ki, Unu'pe, Valiance Keep
				["0.60:0.48:0.64:0.58:0.72:0.60"] = 128, -- Feste Wintergarde, Schwarze Wacht, Argentumwache
				["0.60:0.48:0.46:0.54:0.52:0.62"] = 162, -- Wintergarde Keep, Fordragon Hold, Dalaran
				["0.60:0.48:0.73:0.46:0.83:0.54"] = 158, -- Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.60:0.48:0.64:0.58:0.62:0.64:0.72:0.71:0.64:0.81"] = 289, -- Wintergarde Keep, Ebon Watch, K3, Dun Nifflelem, Ulduar
				["0.60:0.48:0.64:0.58:0.62:0.64:0.72:0.71"] = 205, -- Крепость Стражей Зимы, Черная застава, К-3, Дун Ниффелем
				["0.60:0.48:0.69:0.58:0.72:0.60"] = 132, -- Feste Wintergarde, Lichtbresche, Argentumwache
				["0.60:0.48:0.42:0.47:0.21:0.51:0.18:0.60"] = 316, -- Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Nesingwary Base Camp
				["0.60:0.48:0.42:0.47:0.21:0.51:0.24:0.60"] = 303, -- Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, River's Heart
				["0.60:0.48:0.49:0.42:0.74:0.29:0.88:0.28"] = 362, -- Wintergarde Keep, Moa'ki, Kamagua, Valgarde Port
				["0.60:0.48:0.59:0.57:0.52:0.62:0.52:0.66:0.38:0.79"] = 268, -- Wintergarde Keep, Windrunner's Overlook, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.60:0.48:0.46:0.54:0.41:0.57:0.24:0.60"] = 292, -- Wintergarde Keep, Fordragon Hold, Valiance Landing Camp, River's Heart
				["0.60:0.48:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 280, -- Wintergarde Keep, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.60:0.48:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 299, -- Wintergarde Keep, Ebon Watch, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.60:0.48:0.64:0.58:0.62:0.64:0.57:0.67:0.64:0.81"] = 244, -- Wintergarde Keep, Ebon Watch, K3, Frosthold, Ulduar
				["0.60:0.48:0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79"] = 212, -- Wintergarde Keep, Ebon Watch, K3, Frosthold, Bouldercrag's Refuge
				["0.60:0.48:0.59:0.57:0.52:0.62:0.56:0.64"] = 140, -- Feste Wintergarde, Windläufers Warte, Dalaran, Die Argentumvorhut
				["0.60:0.48:0.46:0.54:0.41:0.57:0.28:0.72"] = 321, -- Wintergarde Keep, Fordragon Hold, Valiance Landing Camp, Death's Rise
				["0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 221, -- Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.60:0.48:0.54:0.48:0.52:0.62:0.52:0.66:0.38:0.79"] = 298, -- Wintergarde Keep, Wyrmrest Temple, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.60:0.48:0.69:0.58:0.72:0.60:0.83:0.54"] = 202, -- Feste Wintergarde, Lichtbresche, Argentumwache, Westfallbrigade
				["0.60:0.48:0.64:0.58:0.52:0.62:0.56:0.64"] = 152, -- Wintergarde Keep, Ebon Watch, Dalaran, The Argent Vanguard
				["0.60:0.48:0.59:0.57:0.52:0.62:0.52:0.66"] = 145, -- Wintergarde Keep, Windrunner's Overlook, Dalaran, Crusaders' Pinnacle
				["0.60:0.48:0.69:0.58:0.72:0.60:0.78:0.62"] = 172, -- Wintergarde Keep, Light's Breach, The Argent Stand, Zim'Torga
				["0.60:0.48:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 324, -- Wintergarde Keep, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.60:0.48:0.54:0.48:0.52:0.62:0.56:0.64"] = 169, -- Wintergarde Keep, Wyrmrest Temple, Dalaran, The Argent Vanguard
				["0.60:0.48:0.59:0.57:0.52:0.62:0.56:0.64:0.57:0.67"] = 179, -- Wintergarde Keep, Windrunner's Overlook, Dalaran, The Argent Vanguard, Frosthold
				["0.60:0.48:0.42:0.47:0.41:0.57:0.52:0.62"] = 268, -- Wintergarde Keep, Stars' Rest, Valiance Landing Camp, Dalaran
				["0.60:0.48:0.64:0.58:0.52:0.62:0.52:0.66"] = 157, -- Wintergarde Keep, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.60:0.48:0.59:0.57:0.52:0.62:0.49:0.79"] = 232, -- Wintergarde Keep, Windrunner's Overlook, Dalaran, Argent Tournament Grounds
				["0.60:0.48:0.64:0.58:0.52:0.62:0.49:0.79"] = 244, -- Wintergarde Keep, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.60:0.48:0.54:0.48:0.52:0.62:0.49:0.79:0.38:0.79"] = 345, -- 溫特加德要塞，龍骨荒野, 龍眠神殿，龍骨荒野, 達拉然, 銀白聯賽場地，寒冰皇冠, 暗影穹殿，寒冰皇冠
				["0.60:0.48:0.54:0.48:0.52:0.62:0.52:0.66"] = 175, -- Wintergarde Keep, Wyrmrest Temple, Dalaran, Crusaders' Pinnacle
				["0.60:0.48:0.49:0.42:0.29:0.43"] = 230, -- Wintergarde Keep, Moa'ki, Unu'pe
				["0.60:0.48:0.54:0.48:0.52:0.62:0.49:0.79"] = 261, -- Wintergarde Keep, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.60:0.48:0.54:0.48:0.52:0.62:0.62:0.64:0.57:0.67"] = 234, -- Wintergarde Keep, Wyrmrest Temple, Dalaran, K3, Frosthold
				["0.60:0.48:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40"] = 283, -- Wintergarde Keep, Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar
				["0.60:0.48:0.73:0.46:0.83:0.54:0.78:0.62:0.82:0.69"] = 283, -- Wintergarde Keep, Amberpine Lodge, Westfall Brigade, Zim'Torga, Gundrak
				["0.60:0.48:0.49:0.42:0.29:0.43:0.21:0.51"] = 309, -- Wintergarde Keep, Moa'ki, Unu'pe, Fizzcrank Airstrip
				["0.60:0.48:0.42:0.47:0.41:0.57"] = 178, -- Wintergarde Keep, Stars' Rest, Valiance Landing Camp
				["0.60:0.48:0.54:0.48:0.52:0.62:0.56:0.64:0.57:0.67"] = 208, -- Wintergarde Keep, Wyrmrest Temple, Dalaran, The Argent Vanguard, Frosthold
				["0.60:0.48:0.49:0.42:0.29:0.43:0.22:0.39:0.17:0.47"] = 352, -- Wintergarde Keep, Moa'ki, Unu'pe, Valiance Keep, Amber Ledge
				["0.60:0.48:0.73:0.46:0.88:0.40:0.88:0.28"] = 265, -- Wintergarde Keep, Amberpine Lodge, Fort Wildervar, Valgarde Port
				["0.60:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 322, -- Wintergarde Keep, Ebon Watch, The Argent Stand, Zim'Torga, Ulduar

				-- Alliance: Dragonblight: Wyrmrest Temple
				["0.54:0.48:0.60:0.48"] = 36, -- Wyrmrest Temple, Wintergarde Keep
				["0.54:0.48:0.60:0.48:0.59:0.57"] = 78, -- Wyrmrest Temple, Wintergarde Keep, Windrunner's Overlook
				["0.54:0.48:0.46:0.54"] = 39, -- Wyrmrest Temple, Fordragon Hold (Jack O'Donnell reported 58)
				["0.54:0.48:0.49:0.42"] = 36, -- Wyrmrest Temple, Moa'ki
				["0.54:0.48:0.42:0.47"] = 45, -- Wyrmrest Temple, Stars' Rest
				["0.54:0.48:0.52:0.62"] = 65, -- Wyrmrest Temple, Dalaran
				["0.54:0.48:0.42:0.47:0.29:0.43"] = 109, -- Wyrmrest Temple, Stars' Rest, Unu'pe
				["0.54:0.48:0.46:0.54:0.41:0.57"] = 79, -- Wyrmrest Temple, Fordragon Hold, Valiance Landing Camp
				["0.54:0.48:0.42:0.47:0.22:0.39"] = 129, -- Wyrmrest Temple, Stars' Rest, Valiance Keep
				["0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 157, -- Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.54:0.48:0.49:0.42:0.74:0.29:0.88:0.28"] = 212, -- Wyrmrest Temple, Moa'ki, Kamagua, Valgarde Port
				["0.54:0.48:0.60:0.48:0.76:0.33"] = 114, -- Wyrmrest Temple, Wintergarde Keep, Westguard Keep
				["0.54:0.48:0.60:0.48:0.76:0.33:0.88:0.28"] = 160, -- Wyrmrest Temple, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.54:0.48:0.60:0.48:0.73:0.46"] = 82, -- Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge
				["0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 181, -- Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.54:0.48:0.60:0.48:0.69:0.58"] = 89, -- Wyrmrest Temple, Wintergarde Keep, Light's Breach
				["0.54:0.48:0.60:0.48:0.73:0.46:0.83:0.54"] = 136, -- Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.54:0.48:0.42:0.47:0.21:0.51"] = 129, -- Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip
				["0.54:0.48:0.42:0.47:0.22:0.39:0.17:0.47"] = 170, -- Wyrmrest Temple, Stars' Rest, Valiance Keep, Amber Ledge
				["0.54:0.48:0.64:0.58"] = 71, -- Wyrmrest Temple, Ebon Watch
				["0.54:0.48:0.60:0.48:0.73:0.46:0.88:0.40"] = 158, -- Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.54:0.48:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 194, -- Wyrmrest Temple, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.54:0.48:0.64:0.58:0.62:0.64:0.72:0.71:0.64:0.81"] = 220, -- Wyrmrest Temple, Ebon Watch, K3, Dun Nifflelem, Ulduar
				["0.54:0.48:0.52:0.62:0.52:0.66"] = 83, -- Wyrmrest Temple, Dalaran, Crusaders' Pinnacle
				["0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62"] = 140, -- Wyrmrest Temple, Ebon Watch, The Argent Stand, Zim'Torga
				["0.54:0.48:0.49:0.42:0.74:0.29:0.76:0.33"] = 183, -- Wyrmrest Temple, Moa'ki, Kamagua, Westguard Keep
				["0.54:0.48:0.60:0.48:0.76:0.33:0.74:0.29"] = 148, -- Wyrmruhtempel, Feste Wintergarde, Westwacht, Kamagua
				["0.54:0.48:0.46:0.54:0.41:0.57:0.24:0.60"] = 169, -- Wyrmruhtempel, Feste Fordragon, Valianzlager, Flussnabel
				["0.54:0.48:0.64:0.58:0.62:0.64"] = 98, -- Wyrmrest Temple, Ebon Watch, K3
				["0.54:0.48:0.64:0.58:0.72:0.60"] = 114, -- Wyrmrest Temple, Ebon Watch, The Argent Stand
				["0.54:0.48:0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 148, -- Wyrmrest Temple, Dalaran, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.54:0.48:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 170, -- Wyrmrest Temple, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.54:0.48:0.64:0.58:0.62:0.64:0.72:0.71"] = 165, -- Wyrmrest Temple, Ebon Watch, K3, Dun Nifflelem
				["0.54:0.48:0.52:0.62:0.62:0.64:0.72:0.71"] = 161, -- Wyrmrest Temple, Dalaran, K3, Dun Nifflelem
				["0.54:0.48:0.64:0.58:0.62:0.64:0.57:0.67:0.64:0.81"] = 191, -- Wyrmrest Temple, Ebon Watch, K3, Frosthold, Ulduar
				["0.54:0.48:0.42:0.47:0.21:0.51:0.24:0.60"] = 170, -- Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, River's Heart
				["0.54:0.48:0.52:0.62:0.56:0.64"] = 79, -- Wyrmrest Temple, Dalaran, The Argent Vanguard
				["0.54:0.48:0.60:0.48:0.73:0.46:0.83:0.54:0.72:0.60"] = 189, -- Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge, Westfall Brigade, The Argent Stand
				["0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 176, -- Wyrmrest Temple, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.54:0.48:0.49:0.42:0.74:0.29"] = 158, -- Wyrmruhtempel, Moa'ki, Kamagua
				["0.54:0.48:0.46:0.54:0.41:0.57:0.28:0.72"] = 189, -- Wyrmrest Temple, Fordragon Hold, Valiance Landing Camp, Death's Rise
				["0.54:0.48:0.52:0.62:0.56:0.64:0.57:0.67"] = 106, -- Wyrmrest Temple, Dalaran, The Argent Vanguard, Frosthold
				["0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81:0.57:0.79"] = 275, -- Temple du Repos du ver, Guet d'Ébène, Le séjour d'Argent, Zim'Torga, Ulduar, Refuge de Rochecombe
				["0.54:0.48:0.60:0.48:0.76:0.33:0.88:0.40"] = 170, -- Wyrmrest Temple, Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.54:0.48:0.42:0.47:0.21:0.51:0.18:0.60"] = 178, -- Храм Драконьего Покоя, Покой Звезд, Взлетная полоса Выкрутеня, Лагерь Эрнестуэя
				["0.54:0.48:0.52:0.62:0.52:0.66:0.28:0.72"] = 195, -- Wyrmrest Temple, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.54:0.48:0.52:0.62:0.52:0.66:0.38:0.79"] = 165, -- Wyrmrest Temple, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.54:0.48:0.64:0.58:0.72:0.60:0.83:0.54"] = 161, -- Templo do Repouso das Serpes, Posto Ébano, Fortaleza Argêntea, Brigada do Cerro Oeste
				["0.54:0.48:0.42:0.47:0.41:0.57"] = 86, -- Wyrmrest Temple, Stars' Rest, Valiance Landing Camp
				["0.54:0.48:0.52:0.62:0.62:0.64:0.57:0.67:0.57:0.79"] = 166, -- Wyrmrest Temple, Dalaran, K3, Frosthold, Bouldercrag's Refuge
				["0.54:0.48:0.52:0.62:0.62:0.64"] = 95, -- Wyrmrest Temple, Dalaran, K3
				["0.54:0.48:0.52:0.62:0.24:0.60"] = 198, -- Wyrmrest Temple, Dalaran, River's Heart
				["0.54:0.48:0.52:0.62:0.56:0.64:0.38:0.79"] = 178, -- Wyrmrest Temple, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.54:0.48:0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79"] = 169, -- Wyrmrest Temple, Ebon Watch, K3, Frosthold, Bouldercrag's Refuge
				["0.54:0.48:0.60:0.48:0.69:0.58:0.72:0.60:0.78:0.62"] = 145, -- Wyrmruhtempel, Feste Wintergarde, Lichtbresche, Argentumwache, Zim'Torga
				["0.54:0.48:0.52:0.62:0.52:0.66:0.57:0.79"] = 246, -- Wyrmrest Temple, Dalaran, Crusaders' Pinnacle, Bouldercrag's Refuge
				["0.54:0.48:0.64:0.58:0.69:0.58:0.73:0.46"] = 157, -- Wyrmrest Temple, Ebon Watch, Light's Breach, Amberpine Lodge
				["0.54:0.48:0.52:0.62:0.49:0.79"] = 141, -- Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.54:0.48:0.52:0.62:0.49:0.79:0.38:0.79"] = 197, -- Wyrmrest Temple, Dalaran, Argent Tournament Grounds, The Shadow Vault
				["0.54:0.48:0.52:0.62:0.24:0.60:0.21:0.51:0.22:0.39"] = 286, -- Wyrmrest Temple, Dalaran, River's Heart, Fizzcrank Airstrip, Valiance Keep
				["0.54:0.48:0.64:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 197, -- Wyrmrest Temple, Ebon Watch, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.54:0.48:0.64:0.58:0.69:0.58"] = 101, -- Wyrmrest Temple, Ebon Watch, Light's Breach
				["0.54:0.48:0.60:0.48:0.69:0.58:0.72:0.60"] = 118, -- Wyrmruhtempel, Feste Wintergarde, Lichtbresche, Argentumwache
				["0.54:0.48:0.42:0.47:0.41:0.57:0.24:0.60"] = 177, -- Wyrmrest Temple, Stars' Rest, Valiance Landing Camp, River's Heart
				["0.54:0.48:0.49:0.42:0.29:0.43"] = 124, -- Wyrmrest Temple, Moa'ki, Unu'pe

				----------------------------------------------------------------------
				-- Alliance: Grizzly Hills
				----------------------------------------------------------------------

				-- Alliance: Grizzly Hills: Amberpine Lodge
				["0.73:0.46:0.76:0.33"] = 84, -- Amberpine Lodge, Westguard Keep
				["0.73:0.46:0.76:0.33:0.74:0.29"] = 134, -- Amberpine Lodge, Westguard Keep, Kamagua
				["0.73:0.46:0.76:0.33:0.88:0.28"] = 152, -- Amberpine Lodge, Westguard Keep, Valgarde Port
				["0.73:0.46:0.88:0.40"] = 117, -- Amberpine Lodge, Fort Wildervar
				["0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62"] = 173, -- Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran
				["0.73:0.46:0.83:0.54"] = 84, -- Amberpine Lodge, Westfall Brigade
				["0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62"] = 150, -- Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga
				["0.73:0.46:0.60:0.48:0.42:0.47:0.22:0.39"] = 318, -- Amberpine Lodge, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67"] = 189, -- Amberpine Lodge, Light's Breach, Ebon Watch, K3, Frosthold
				["0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 396, -- Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.73:0.46:0.60:0.48:0.42:0.47"] = 190, -- Amberpine Lodge, Wintergarde Keep, Stars' Rest (Anita H. reported 70)
				["0.73:0.46:0.60:0.48:0.49:0.42"] = 175, -- Amberpine Lodge, Wintergarde Keep, Moa'ki
				["0.73:0.46:0.60:0.48"] = 82, -- Amberpine Lodge, Wintergarde Keep
				["0.73:0.46:0.60:0.48:0.54:0.48"] = 131, -- Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple
				["0.73:0.46:0.69:0.58:0.64:0.58:0.46:0.54:0.42:0.47:0.21:0.51"] = 415, -- Amberpine Lodge, Light's Breach, Ebon Watch, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip
				["0.73:0.46:0.69:0.58"] = 67, -- Amberpine Lodge, Light's Breach
				["0.73:0.46:0.76:0.33:0.74:0.29:0.49:0.42"] = 328, -- Amberpine Lodge, Westguard Keep, Kamagua, Moa'ki
				["0.73:0.46:0.88:0.40:0.88:0.28"] = 190, -- Amberpine Lodge, Fort Wildervar, Valgarde Port
				["0.73:0.46:0.69:0.58:0.72:0.60"] = 109, -- Amberpine Lodge, Light's Breach, The Argent Stand
				["0.73:0.46:0.60:0.48:0.64:0.58"] = 140, -- Amberpine Lodge, Wintergarde Keep, Ebon Watch
				["0.73:0.46:0.60:0.48:0.42:0.47:0.29:0.43"] = 287, -- Amberpine Lodge, Wintergarde Keep, Stars' Rest, Unu'pe
				["0.73:0.46:0.60:0.48:0.46:0.54"] = 172, -- Amberpine Lodge, Wintergarde Keep, Fordragon Hold
				["0.73:0.46:0.60:0.48:0.59:0.57"] = 147, -- Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook
				["0.73:0.46:0.60:0.48:0.54:0.48:0.52:0.62"] = 223, -- Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple, Dalaran
				["0.73:0.46:0.69:0.58:0.64:0.58"] = 106, -- Amberpine Lodge, Light's Breach, Ebon Watch
				["0.73:0.46:0.83:0.54:0.78:0.62:0.82:0.69"] = 209, -- Amberpine Lodge, Westfall Brigade, Zim'Torga, Gundrak
				["0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51"] = 316, -- Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip
				["0.73:0.46:0.60:0.48:0.59:0.57:0.52:0.62"] = 194, -- Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook, Dalaran
				["0.73:0.46:0.60:0.48:0.64:0.58:0.52:0.62"] = 207, -- Amberpine Lodge, Wintergarde Keep, Ebon Watch, Dalaran
				["0.73:0.46:0.60:0.48:0.49:0.42:0.29:0.43:0.21:0.51"] = 384, -- Amberpine Lodge, Wintergarde Keep, Moa'ki, Unu'pe, Fizzcrank Airstrip
				["0.73:0.46:0.76:0.33:0.74:0.29:0.49:0.42:0.54:0.48"] = 376, -- Amberpine Lodge, Westguard Keep, Kamagua, Moa'ki, Wyrmrest Temple
				["0.73:0.46:0.60:0.48:0.49:0.42:0.52:0.62"] = 296, -- Amberpine Lodge, Wintergarde Keep, Moa'ki, Dalaran
				["0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64"] = 146, -- Amberpine Lodge, Light's Breach, Ebon Watch, K3
				["0.73:0.46:0.83:0.54:0.72:0.60"] = 166, -- Amberpine Lodge, Westfall Brigade, The Argent Stand
				["0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 234, -- Gîte Ambrepin, La Brèche de Lumière, Le séjour d'Argent, Zim'Torga, Dun Nifflelem
				["0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60"] = 370, -- Ammertannhütte, Lichtbresche, Schwarze Wacht, Dalaran, Flussnabel
				["0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 203, -- Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga, Gundrak
				["0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 359, -- Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.73:0.46:0.83:0.54:0.78:0.62"] = 156, -- Ammertannhütte, Westfallbrigade, Zim'Torga
				["0.73:0.46:0.76:0.33:0.74:0.29:0.49:0.42:0.42:0.47"] = 382, -- Amberpine Lodge, Westguard Keep, Kamagua, Moa'ki, Stars' Rest
				["0.73:0.46:0.60:0.48:0.59:0.57:0.62:0.64"] = 193, -- Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook, K3
				["0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51:0.18:0.60"] = 391, -- Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Nesingwary Base Camp
				["0.73:0.46:0.60:0.48:0.49:0.42:0.29:0.43:0.22:0.39"] = 365, -- Amberpine Lodge, Wintergarde Keep, Moa'ki, Unu'pe, Valiance Keep
				["0.73:0.46:0.60:0.48:0.46:0.54:0.52:0.62"] = 237, -- Amberpine Lodge, Wintergarde Keep, Fordragon Hold, Dalaran
				["0.73:0.46:0.60:0.48:0.46:0.54:0.41:0.57:0.24:0.60"] = 368, -- Amberpine Lodge, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp, River's Heart
				["0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 198, -- Gîte Ambrepin, La Brèche de Lumière, Guet d'Ébène, Dalaran, Cime des Croisés
				["0.73:0.46:0.69:0.58:0.64:0.58:0.59:0.57"] = 139, -- Amberpine Lodge, Light's Breach, Ebon Watch, Windrunner's Overlook
				["0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64"] = 193, -- Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard
				["0.73:0.46:0.60:0.48:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 415, -- Amberpine Lodge, Wintergarde Keep, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 303, -- Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga, Ulduar
				["0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51:0.24:0.60"] = 379, -- Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, River's Heart
				["0.73:0.46:0.60:0.48:0.46:0.54:0.41:0.57"] = 231, -- Amberpine Lodge, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp
				["0.73:0.46:0.69:0.58:0.64:0.58:0.46:0.54"] = 216, -- Amberpine Lodge, Light's Breach, Ebon Watch, Fordragon Hold
				["0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67:0.64:0.81"] = 286, -- Amberpine Lodge, Light's Breach, Ebon Watch, K3, Frosthold, Ulduar
				["0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 320, -- Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.73:0.46:0.76:0.33:0.74:0.29:0.49:0.42:0.52:0.62"] = 450, -- Amberpine Lodge, Westguard Keep, Kamagua, Moa'ki, Dalaran
				["0.73:0.46:0.60:0.48:0.49:0.42:0.74:0.29"] = 358, -- Amberpine Lodge, Wintergarde Keep, Moa'ki, Kamagua
				["0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79"] = 253, -- Ammertannhütte, Lichtbresche, Schwarze Wacht, K3, Eisfestung, Bergfels' Zuflucht
				["0.73:0.46:0.60:0.48:0.64:0.58:0.62:0.64"] = 180, -- Amberpine Lodge, Wintergarde Keep, Ebon Watch, K3
				["0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 365, -- Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.57:0.67"] = 232, -- Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, Frosthold
				["0.73:0.46:0.60:0.48:0.42:0.47:0.41:0.57:0.52:0.62"] = 344, -- Amberpine Lodge, Wintergarde Keep, Stars' Rest, Valiance Landing Camp, Dalaran
				["0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 285, -- Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.73:0.46:0.60:0.48:0.64:0.58:0.52:0.62:0.49:0.79"] = 319, -- Amberpine Lodge, Wintergarde Keep, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.73:0.46:0.60:0.48:0.59:0.57:0.62:0.64:0.57:0.67:0.57:0.79"] = 300, -- Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook, K3, Frosthold, Bouldercrag's Refuge
				["0.73:0.46:0.60:0.48:0.59:0.57:0.52:0.62:0.52:0.66"] = 221, -- Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook, Dalaran, Crusaders' Pinnacle
				["0.73:0.46:0.60:0.48:0.59:0.57:0.52:0.62:0.49:0.79"] = 307, -- Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook, Dalaran, Argent Tournament Grounds
				["0.73:0.46:0.60:0.48:0.46:0.54:0.41:0.57:0.28:0.72"] = 397, -- Amberpine Lodge, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp, Death's Rise
				["0.73:0.46:0.60:0.48:0.54:0.48:0.52:0.62:0.62:0.64"] = 267, -- Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple, Dalaran, K3
				["0.73:0.46:0.69:0.58:0.64:0.58:0.54:0.48"] = 196, -- Amberpine Lodge, Light's Breach, Ebon Watch, Wyrmrest Temple
				["0.73:0.46:0.60:0.48:0.59:0.57:0.62:0.64:0.57:0.67"] = 236, -- Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook, K3, Frosthold
				["0.73:0.46:0.60:0.48:0.49:0.42:0.29:0.43"] = 307, -- Amberpine Lodge, Wintergarde Keep, Moa'ki, Unu'pe
				["0.73:0.46:0.60:0.48:0.64:0.58:0.52:0.62:0.52:0.66"] = 233, -- Ammertannhütte, Feste Wintergarde, Schwarze Wacht, Dalaran, Kreuzfahrerturm
				["0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 405, -- Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.73:0.46:0.69:0.58:0.64:0.58:0.46:0.54:0.42:0.47"] = 289, -- Amberpine Lodge, Light's Breach, Ebon Watch, Fordragon Hold, Stars' Rest
				["0.73:0.46:0.76:0.33:0.74:0.29:0.49:0.42:0.42:0.47:0.22:0.39"] = 510, -- Amberpine Lodge, Westguard Keep, Kamagua, Moa'ki, Stars' Rest, Valiance Keep
				["0.73:0.46:0.60:0.48:0.54:0.48:0.52:0.62:0.49:0.79"] = 337, -- Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.73:0.46:0.76:0.33:0.74:0.29:0.49:0.42:0.29:0.43"] = 459, -- Amberpine Lodge, Westguard Keep, Kamagua, Moa'ki, Unu'pe

				-- Alliance: Grizzly Hills: Westfall Brigade
				["0.83:0.54:0.73:0.46"] = 79, -- Westfall Brigade, Amberpine Lodge
				["0.83:0.54:0.78:0.62"] = 73, -- Westfall Brigade, Zim'Torga
				["0.83:0.54:0.72:0.60"] = 82, -- Westfall Brigade, The Argent Stand
				["0.83:0.54:0.72:0.60:0.64:0.58:0.52:0.62"] = 201, -- Westfall Brigade, The Argent Stand, Ebon Watch, Dalaran
				["0.83:0.54:0.88:0.40"] = 85, -- Westfall Brigade, Fort Wildervar
				["0.83:0.54:0.78:0.62:0.64:0.81:0.57:0.79"] = 275, -- Westfall Brigade, Zim'Torga, Ulduar, Bouldercrag's Refuge
				["0.83:0.54:0.73:0.46:0.76:0.33"] = 162, -- Westfall Brigade, Amberpine Lodge, Westguard Keep
				["0.83:0.54:0.88:0.40:0.88:0.28"] = 159, -- Westfall Brigade, Fort Wildervar, Valgarde Port
				["0.83:0.54:0.73:0.46:0.76:0.33:0.74:0.29"] = 211, -- Westfall Brigade, Amberpine Lodge, Westguard Keep, Kamagua
				["0.83:0.54:0.73:0.46:0.60:0.48:0.42:0.47:0.22:0.39"] = 394, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.83:0.54:0.73:0.46:0.60:0.48:0.42:0.47:0.29:0.43"] = 363, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Unu'pe
				["0.83:0.54:0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 472, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.83:0.54:0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 436, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.83:0.54:0.73:0.46:0.60:0.48:0.42:0.47"] = 266, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Stars' Rest
				["0.83:0.54:0.88:0.40:0.76:0.33"] = 165, -- Westfall Brigade, Fort Wildervar, Westguard Keep
				["0.83:0.54:0.73:0.46:0.60:0.48"] = 159, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep
				["0.83:0.54:0.73:0.46:0.60:0.48:0.54:0.48:0.52:0.62"] = 299, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple, Dalaran
				["0.83:0.54:0.88:0.40:0.76:0.33:0.60:0.48:0.42:0.47"] = 424, -- Westfall Brigade, Fort Wildervar, Westguard Keep, Wintergarde Keep, Stars' Rest
				["0.83:0.54:0.73:0.46:0.69:0.58"] = 144, -- Westfall Brigade, Amberpine Lodge, Light's Breach
				["0.83:0.54:0.73:0.46:0.60:0.48:0.64:0.58"] = 216, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Ebon Watch
				["0.83:0.54:0.72:0.60:0.69:0.58"] = 106, -- Westfall Brigade, The Argent Stand, Light's Breach
				["0.83:0.54:0.73:0.46:0.76:0.33:0.88:0.28"] = 230, -- Westfall Brigade, Amberpine Lodge, Westguard Keep, Valgarde Port
				["0.83:0.54:0.73:0.46:0.69:0.58:0.64:0.58"] = 183, -- Westfall Brigade, Amberpine Lodge, Light's Breach, Ebon Watch
				["0.83:0.54:0.73:0.46:0.60:0.48:0.54:0.48"] = 207, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple
				["0.83:0.54:0.73:0.46:0.60:0.48:0.64:0.58:0.52:0.62"] = 283, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Ebon Watch, Dalaran
				["0.83:0.54:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62"] = 250, -- Westfall Brigade, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran
				["0.83:0.54:0.73:0.46:0.60:0.48:0.49:0.42:0.52:0.62:0.62:0.64"] = 416, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Moa'ki, Dalaran, K3
				["0.83:0.54:0.72:0.60:0.64:0.58:0.62:0.64"] = 174, -- Westfall Brigade, The Argent Stand, Ebon Watch, K3
				["0.83:0.54:0.73:0.46:0.60:0.48:0.42:0.47:0.22:0.39:0.17:0.47"] = 456, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Valiance Keep, Amber Ledge
				["0.83:0.54:0.73:0.46:0.60:0.48:0.49:0.42:0.52:0.62"] = 372, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Moa'ki, Dalaran
				["0.83:0.54:0.73:0.46:0.60:0.48:0.59:0.57:0.52:0.62"] = 270, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook, Dalaran
				["0.83:0.54:0.88:0.40:0.76:0.33:0.60:0.48"] = 316, -- Westfall Brigade, Fort Wildervar, Westguard Keep, Wintergarde Keep
				["0.83:0.54:0.73:0.46:0.60:0.48:0.54:0.48:0.52:0.62:0.62:0.64"] = 344, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple, Dalaran, K3
				["0.83:0.54:0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51"] = 393, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip
				["0.83:0.54:0.72:0.60:0.64:0.58"] = 134, -- Westfall Brigade, The Argent Stand, Ebon Watch
				["0.83:0.54:0.73:0.46:0.60:0.48:0.49:0.42"] = 252, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Moa'ki
				["0.83:0.54:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60"] = 399, -- Westfall Brigade, The Argent Stand, Ebon Watch, Dalaran, River's Heart
				["0.83:0.54:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66"] = 226, -- Westfall Brigade, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.83:0.54:0.73:0.46:0.60:0.48:0.46:0.54:0.52:0.62"] = 313, -- Westfallbrigade, Ammertannhütte, Feste Wintergarde, Feste Fordragon, Dalaran
				["0.83:0.54:0.78:0.62:0.82:0.69"] = 126, -- Westfallbrigade, Zim'Torga, Gundrak
				["0.83:0.54:0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64"] = 221, -- Westfall Brigade, The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard
				["0.83:0.54:0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51:0.24:0.60"] = 454, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, River's Heart
				["0.83:0.54:0.78:0.62:0.64:0.81"] = 227, -- Westfall Brigade, Zim'Torga, Ulduar
				["0.83:0.54:0.78:0.62:0.72:0.71"] = 158, -- Westfall Brigade, Zim'Torga, Dun Nifflelem
				["0.83:0.54:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 434, -- Westfall Brigade, The Argent Stand, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.83:0.54:0.72:0.60:0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79"] = 281, -- Westfall Brigade, The Argent Stand, Ebon Watch, K3, Frosthold, Bouldercrag's Refuge
				["0.83:0.54:0.73:0.46:0.60:0.48:0.59:0.57"] = 223, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook
				["0.83:0.54:0.73:0.46:0.60:0.48:0.46:0.54:0.41:0.57"] = 308, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp
				["0.83:0.54:0.72:0.60:0.64:0.58:0.46:0.54:0.41:0.57:0.28:0.72"] = 469, -- Westfallbrigade, Argentumwache, Schwarze Wacht, Feste Fordragon, Valianzlager, Todesanhöhe
				["0.83:0.54:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 349, -- Westfall Brigade, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.83:0.54:0.72:0.60:0.64:0.58:0.62:0.64:0.57:0.67"] = 217, -- Westfall Brigade, The Argent Stand, Ebon Watch, K3, Frosthold
				["0.83:0.54:0.73:0.46:0.60:0.48:0.46:0.54"] = 249, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Fordragon Hold
				["0.83:0.54:0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 368, -- Westfallbrigade, Argentumwache, Schwarze Wacht, Dalaran, Die Argentumvorhut, Das Schattengewölbe
				["0.83:0.54:0.72:0.60:0.64:0.58:0.46:0.54"] = 244, -- Westfall Brigade, The Argent Stand, Ebon Watch, Fordragon Hold
				["0.83:0.54:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60"] = 447, -- Westfall Brigade, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, River's Heart
				["0.83:0.54:0.72:0.60:0.64:0.58:0.46:0.54:0.41:0.57"] = 304, -- Westfall Brigade, The Argent Stand, Ebon Watch, Fordragon Hold, Valiance Landing Camp
				["0.83:0.54:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 394, -- Westfall Brigade, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.83:0.54:0.72:0.60:0.69:0.58:0.60:0.48:0.54:0.48:0.52:0.62"] = 328, -- Westfallbrigade, Argentumwache, Lichtbresche, Feste Wintergarde, Wyrmruhtempel, Dalaran
				["0.83:0.54:0.72:0.60:0.69:0.58:0.60:0.48"] = 188, -- Westfallbrigade, Argentumwache, Lichtbresche, Feste Wintergarde
				["0.83:0.54:0.88:0.40:0.76:0.33:0.74:0.29:0.49:0.42"] = 408, -- Westfall Brigade, Fort Wildervar, Westguard Keep, Kamagua, Moa'ki
				["0.83:0.54:0.72:0.60:0.64:0.58:0.59:0.57"] = 167, -- Westfall Brigade, The Argent Stand, Ebon Watch, Windrunner's Overlook
				["0.83:0.54:0.73:0.46:0.60:0.48:0.59:0.57:0.62:0.64"] = 269, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook, K3
				["0.83:0.54:0.72:0.60:0.64:0.58:0.52:0.62:0.49:0.79"] = 313, -- Westfall Brigade, The Argent Stand, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.83:0.54:0.78:0.62:0.64:0.81:0.57:0.79:0.51:0.21"] = 335, -- Westfall Brigade, Zim'Torga, Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.83:0.54:0.73:0.46:0.60:0.48:0.59:0.57:0.52:0.62:0.52:0.66"] = 297, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook, Dalaran, Crusaders' Pinnacle
				["0.83:0.54:0.73:0.46:0.60:0.48:0.54:0.48:0.52:0.62:0.49:0.79"] = 413, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.83:0.54:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 362, -- Westfall Brigade, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.83:0.54:0.73:0.46:0.60:0.48:0.59:0.57:0.52:0.62:0.49:0.79"] = 384, -- Westfallbrigade, Ammertannhütte, Feste Wintergarde, Windläufers Warte, Dalaran, Argentumturnierplatz
				["0.83:0.54:0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51:0.18:0.60"] = 467, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Nesingwary Base Camp
				["0.83:0.54:0.73:0.46:0.60:0.48:0.46:0.54:0.41:0.57:0.24:0.60"] = 444, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp, River's Heart
				["0.83:0.54:0.73:0.46:0.60:0.48:0.64:0.58:0.62:0.64"] = 256, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Ebon Watch, K3
				["0.83:0.54:0.73:0.46:0.60:0.48:0.59:0.57:0.52:0.62:0.56:0.64"] = 292, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook, Dalaran, The Argent Vanguard
				["0.83:0.54:0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 325, -- Westfall Brigade, The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.83:0.54:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.72:0.71"] = 323, -- Westfall Brigade, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Dun Nifflelem
				["0.83:0.54:0.88:0.40:0.88:0.28:0.74:0.29"] = 253, -- Westfall Brigade, Fort Wildervar, Valgarde Port, Kamagua
				["0.83:0.54:0.73:0.46:0.60:0.48:0.64:0.58:0.52:0.62:0.49:0.79"] = 396, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.83:0.54:0.72:0.60:0.64:0.58:0.62:0.64:0.72:0.71"] = 274, -- Westfall Brigade, The Argent Stand, Ebon Watch, K3, Dun Nifflelem
				["0.83:0.54:0.73:0.46:0.60:0.48:0.59:0.57:0.62:0.64:0.57:0.67"] = 312, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook, K3, Frosthold
				["0.83:0.54:0.73:0.46:0.60:0.48:0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79"] = 364, -- Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Ebon Watch, K3, Frosthold, Bouldercrag's Refuge
				["0.83:0.54:0.78:0.62:0.64:0.81:0.57:0.79:0.38:0.79"] = 388, -- Westfall Brigade, Zim'Torga, Ulduar, Bouldercrag's Refuge, The Shadow Vault
				["0.83:0.54:0.73:0.46:0.69:0.58:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51"] = 464, -- Westfall Brigade, Amberpine Lodge, Light's Breach, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip

				----------------------------------------------------------------------
				-- Alliance: Howling Fjord
				----------------------------------------------------------------------

				-- Alliance: Howling Fjord: Fort Wildervar
				["0.88:0.40:0.83:0.54"] = 98, -- Fort Wildervar, Westfall Brigade
				["0.88:0.40:0.88:0.28"] = 74, -- Fort Wildervar, Valgarde Port
				["0.88:0.40:0.76:0.33"] = 81, -- Fort Wildervar, Westguard Keep
				["0.88:0.40:0.76:0.33:0.74:0.29"] = 130, -- Fort Wildervar, Westguard Keep, Kamagua
				["0.88:0.40:0.73:0.46"] = 97, -- Fort Wildervar, Amberpine Lodge
				["0.88:0.40:0.83:0.54:0.78:0.62"] = 170, -- Fort Wildervar, Westfall Brigade, Zim'Torga
				["0.88:0.40:0.83:0.54:0.78:0.62:0.82:0.69"] = 223, -- Fort Wildervar, Westfall Brigade, Zim'Torga, Gundrak
				["0.88:0.40:0.73:0.46:0.60:0.48:0.46:0.54:0.41:0.57:0.24:0.60"] = 463, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp, River's Heart
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62"] = 267, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran
				["0.88:0.40:0.83:0.54:0.72:0.60"] = 179, -- Fort Wildervar, Westfall Brigade, The Argent Stand
				["0.88:0.40:0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51"] = 412, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip
				["0.88:0.40:0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 491, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.88:0.40:0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 455, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.88:0.40:0.73:0.46:0.60:0.48:0.42:0.47:0.22:0.39"] = 413, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.88:0.40:0.73:0.46:0.60:0.48:0.49:0.42"] = 270, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Moa'ki
				["0.88:0.40:0.73:0.46:0.69:0.58"] = 162, -- Fort Wildervar, Amberpine Lodge, Light's Breach
				["0.88:0.40:0.73:0.46:0.60:0.48"] = 178, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64"] = 241, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, K3
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58"] = 201, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch
				["0.88:0.40:0.73:0.46:0.60:0.48:0.42:0.47:0.29:0.43"] = 382, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Unu'pe
				["0.88:0.40:0.76:0.33:0.60:0.48"] = 230, -- Fort Wildervar, Westguard Keep, Wintergarde Keep
				["0.88:0.40:0.76:0.33:0.74:0.29:0.49:0.42"] = 324, -- Fort Wildervar, Westguard Keep, Kamagua, Moa'ki
				["0.88:0.40:0.73:0.46:0.60:0.48:0.54:0.48"] = 225, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple
				["0.88:0.40:0.76:0.33:0.74:0.29:0.49:0.42:0.29:0.43:0.22:0.39"] = 514, -- Fort Wildervar, Westguard Keep, Kamagua, Moa'ki, Unu'pe, Valiance Keep
				["0.88:0.40:0.76:0.33:0.74:0.29:0.49:0.42:0.42:0.47"] = 378, -- Fort Wildervar, Westguard Keep, Kamagua, Moa'ki, Stars' Rest
				["0.88:0.40:0.76:0.33:0.60:0.48:0.42:0.47"] = 339, -- Fort Wildervar, Westguard Keep, Wintergarde Keep, Stars' Rest
				["0.88:0.40:0.76:0.33:0.60:0.48:0.46:0.54:0.52:0.62"] = 386, -- Fort Wildervar, Westguard Keep, Wintergarde Keep, Fordragon Hold, Dalaran
				["0.88:0.40:0.76:0.33:0.74:0.29:0.49:0.42:0.52:0.62"] = 445, -- Fort Wildervar, Westwacht, Kamagua, Moa'ki, Dalaran
				["0.88:0.40:0.73:0.46:0.60:0.48:0.42:0.47"] = 286, -- Fort Wildervar, Ammertannhütte, Feste Wintergarde, Sternenruh
				["0.88:0.40:0.76:0.33:0.60:0.48:0.42:0.47:0.29:0.43"] = 435, -- Fort Wildervar, Westguard Keep, Wintergarde Keep, Stars' Rest, Unu'pe
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67"] = 284, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Frosthold
				["0.88:0.40:0.76:0.33:0.60:0.48:0.54:0.48:0.52:0.62"] = 371, -- Fort Wildervar, Westguard Keep, Wintergarde Keep, Wyrmrest Temple, Dalaran
				["0.88:0.40:0.76:0.33:0.60:0.48:0.42:0.47:0.22:0.39"] = 466, -- Fort Wildervar, Westguard Keep, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.88:0.40:0.73:0.46:0.60:0.48:0.54:0.48:0.52:0.62"] = 318, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple, Dalaran
				["0.88:0.40:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 298, -- Fort Wildervar, Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga, Gundrak
				["0.88:0.40:0.83:0.54:0.78:0.62:0.72:0.71"] = 254, -- Fort Wildervar, Westfallbrigade, Zim'Torga, Dun Niffelem
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 460, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.88:0.40:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62"] = 245, -- Fort Wildervar, Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga
				["0.88:0.40:0.73:0.46:0.60:0.48:0.46:0.54"] = 267, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Fordragon Hold
				["0.88:0.40:0.76:0.33:0.60:0.48:0.42:0.47:0.21:0.51"] = 464, -- Fort Wildervar, Westguard Keep, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip
				["0.88:0.40:0.73:0.46:0.60:0.48:0.59:0.57:0.52:0.62"] = 289, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook, Dalaran
				["0.88:0.40:0.76:0.33:0.74:0.29:0.49:0.42:0.54:0.48"] = 372, -- Fort Wildervar, Westguard Keep, Kamagua, Moa'ki, Wyrmrest Temple
				["0.88:0.40:0.76:0.33:0.74:0.29:0.49:0.42:0.29:0.43:0.22:0.39:0.17:0.47:0.12:0.47"] = 612, -- Fort Wildervar, Westguard Keep, Kamagua, Moa'ki, Unu'pe, Valiance Keep, Amber Ledge, Transitus Shield
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.59:0.57"] = 234, -- Fort Wildervar, Ammertannhütte, Lichtbresche, Schwarze Wacht, Windläufers Warte
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 416, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67:0.64:0.81"] = 381, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Frosthold, Ulduar
				["0.88:0.40:0.73:0.46:0.69:0.58:0.72:0.60"] = 205, -- Fort Wildervar, Amberpine Lodge, Light's Breach, The Argent Stand
				["0.88:0.40:0.73:0.46:0.60:0.48:0.46:0.54:0.41:0.57"] = 327, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp
				["0.88:0.40:0.76:0.33:0.74:0.29:0.49:0.42:0.42:0.47:0.22:0.39"] = 506, -- Fort Wildervar, Westwacht, Kamagua, Moa'ki, Sternenruh, Valianzfeste
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 293, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.88:0.40:0.83:0.54:0.72:0.60:0.64:0.58:0.52:0.62:0.49:0.42"] = 444, -- Fort Wildervar, Westfall Brigade, The Argent Stand, Ebon Watch, Dalaran, Moa'ki
				["0.88:0.40:0.83:0.54:0.72:0.60:0.64:0.58:0.46:0.54"] = 342, -- Fort Wildervar, Westfall Brigade, The Argent Stand, Ebon Watch, Fordragon Hold
				["0.88:0.40:0.76:0.33:0.60:0.48:0.59:0.57:0.52:0.62"] = 342, -- Fort Wildervar, Westguard Keep, Wintergarde Keep, Windrunner's Overlook, Dalaran
				["0.88:0.40:0.73:0.46:0.60:0.48:0.49:0.42:0.52:0.62"] = 391, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Moa'ki, Dalaran
				["0.88:0.40:0.76:0.33:0.60:0.48:0.59:0.57:0.52:0.62:0.41:0.57"] = 444, -- Fort Wildervar, Westguard Keep, Wintergarde Keep, Windrunner's Overlook, Dalaran, Valiance Landing Camp
				["0.88:0.40:0.76:0.33:0.74:0.29:0.49:0.42:0.54:0.48:0.64:0.58"] = 476, -- Fort Wildervar, Westguard Keep, Kamagua, Moa'ki, Wyrmrest Temple, Ebon Watch
				["0.88:0.40:0.73:0.46:0.60:0.48:0.64:0.58:0.52:0.62"] = 302, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Ebon Watch, Dalaran
				["0.88:0.40:0.73:0.46:0.60:0.48:0.64:0.58"] = 235, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Ebon Watch
				["0.88:0.40:0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51:0.24:0.60"] = 473, -- Fort Wildervar, Ammertannhütte, Feste Wintergarde, Sternenruh, Landebahn Kurbelzisch, Flussnabel
				["0.88:0.40:0.83:0.54:0.72:0.60:0.64:0.58:0.62:0.64:0.57:0.67"] = 314, -- Fort Wildervar, Westfall Brigade, The Argent Stand, Ebon Watch, K3, Frosthold
				["0.88:0.40:0.73:0.46:0.60:0.48:0.59:0.57:0.52:0.62:0.56:0.64"] = 311, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook, Dalaran, The Argent Vanguard
				["0.88:0.40:0.73:0.46:0.60:0.48:0.64:0.58:0.62:0.64"] = 276, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Ebon Watch, K3
				["0.88:0.40:0.73:0.46:0.60:0.48:0.59:0.57"] = 242, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Windrunner's Overlook
				["0.88:0.40:0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51:0.18:0.60"] = 487, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Nesingwary Base Camp
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.57:0.67"] = 327, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, Frosthold
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64"] = 288, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60"] = 465, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, River's Heart
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79"] = 348, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Frosthold, Bouldercrag's Refuge
				["0.88:0.40:0.73:0.46:0.60:0.48:0.46:0.54:0.41:0.57:0.28:0.72"] = 492, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp, Death's Rise
				["0.88:0.40:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 330, -- Fort Wildervar, Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 380, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.88:0.40:0.83:0.54:0.78:0.62:0.64:0.81"] = 324, -- Fort Wildervar, Westfall Brigade, Zim'Torga, Ulduar
				["0.88:0.40:0.83:0.54:0.72:0.60:0.64:0.58:0.52:0.62:0.49:0.79"] = 411, -- Fort Wildervar, Westfallbrigade, Argentumwache, Schwarze Wacht, Dalaran, Argentumturnierplatz
				["0.88:0.40:0.73:0.46:0.60:0.48:0.54:0.48:0.52:0.62:0.49:0.79"] = 432, -- Fort Wildervar, Ammertannhütte, Feste Wintergarde, Wyrmruhtempel, Dalaran, Argentumturnierplatz
				["0.88:0.40:0.73:0.46:0.60:0.48:0.59:0.57:0.52:0.62:0.49:0.79"] = 403, -- Fort Wildervar, Ammertannhütte, Feste Wintergarde, Windläufers Warte, Dalaran, Argentumturnierplatz
				["0.88:0.40:0.83:0.54:0.72:0.60:0.64:0.58:0.52:0.62"] = 298, -- Fort Wildervar, Westfall Brigade, The Argent Stand, Ebon Watch, Dalaran
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 435, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.88:0.40:0.73:0.46:0.60:0.48:0.54:0.48:0.52:0.62:0.56:0.64:0.57:0.67"] = 379, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple, Dalaran, The Argent Vanguard, Frosthold
				["0.88:0.40:0.76:0.33:0.60:0.48:0.59:0.57:0.52:0.62:0.49:0.79"] = 456, -- Fort Wildervar, Westguard Keep, Wintergarde Keep, Windrunner's Overlook, Dalaran, Argent Tournament Grounds
				["0.88:0.40:0.73:0.46:0.60:0.48:0.54:0.48:0.52:0.62:0.62:0.64"] = 362, -- Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple, Dalaran, K3
				["0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.72:0.71"] = 341, -- Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Dun Nifflelem

				-- Alliance: Howling Fjord: Kamagua
				["0.74:0.29:0.76:0.33"] = 37, -- Kamagua, Westguard Keep
				["0.74:0.29:0.88:0.28"] = 81, -- Kamagua, Valgarde Port
				["0.74:0.29:0.76:0.33:0.88:0.40"] = 121, -- Kamagua, Westguard Keep, Fort Wildervar
				["0.74:0.29:0.76:0.33:0.73:0.46"] = 112, -- Kamagua, Westguard Keep, Amberpine Lodge
				["0.74:0.29:0.49:0.42:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 455, -- Kamagua, Moa'ki, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.74:0.29:0.76:0.33:0.60:0.48:0.54:0.48"] = 236, -- Kamagua, Westguard Keep, Wintergarde Keep, Wyrmrest Temple
				["0.74:0.29:0.49:0.42:0.29:0.43"] = 327, -- Kamagua, Moa'ki, Unu'pe
				["0.74:0.29:0.49:0.42:0.42:0.47:0.22:0.39"] = 377, -- Kamagua, Moa'ki, Stars' Rest, Valiance Keep
				["0.74:0.29:0.49:0.42"] = 195, -- Kamagua, Moa'ki
				["0.74:0.29:0.76:0.33:0.60:0.48"] = 188, -- Kamagua, Westguard Keep, Wintergarde Keep
				["0.74:0.29:0.76:0.33:0.73:0.46:0.83:0.54"] = 195, -- Kamagua, Westguard Keep, Amberpine Lodge, Westfall Brigade
				["0.74:0.29:0.49:0.42:0.42:0.47"] = 249, -- Kamagua, Moa'ki, Stars' Rest
				["0.74:0.29:0.76:0.33:0.60:0.48:0.46:0.54"] = 277, -- Kamagua, Westguard Keep, Wintergarde Keep, Fordragon Hold
				["0.74:0.29:0.49:0.42:0.42:0.47:0.41:0.57"] = 312, -- Kamagua, Moa'ki, Stars' Rest, Valiance Landing Camp
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62"] = 260, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.59:0.57"] = 249, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Windrunner's Overlook
				["0.74:0.29:0.49:0.42:0.42:0.47:0.21:0.51:0.17:0.47"] = 418, -- Kamagua, Moa'ki, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.74:0.29:0.49:0.42:0.29:0.43:0.21:0.51"] = 405, -- Kamagua, Moa'ki, Unu'pe, Fizzcrank Airstrip
				["0.74:0.29:0.49:0.42:0.29:0.43:0.22:0.39"] = 386, -- Kamagua, Moa'ki, Unu'pe, Valiance Keep
				["0.74:0.29:0.76:0.33:0.60:0.48:0.42:0.47:0.22:0.39"] = 423, -- Kamagua, Westwacht, Feste Wintergarde, Sternenruh, Valianzfeste
				["0.74:0.29:0.49:0.42:0.52:0.62"] = 317, -- Kamagua, Moa'ki, Dalaran
				["0.74:0.29:0.76:0.33:0.60:0.48:0.59:0.57:0.52:0.62"] = 299, -- Kamagua, Westguard Keep, Wintergarde Keep, Windrunner's Overlook, Dalaran
				["0.74:0.29:0.49:0.42:0.42:0.47:0.21:0.51"] = 375, -- Kamagua, Moa'ki, Stars' Rest, Fizzcrank Airstrip
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 345, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62"] = 282, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.72:0.71"] = 356, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Dun Nifflelem
				["0.74:0.29:0.49:0.42:0.54:0.48"] = 243, -- Kamagua, Moa'ki, Wyrmrest Temple
				["0.74:0.29:0.49:0.42:0.42:0.47:0.21:0.51:0.24:0.60"] = 437, -- Kamagua, Moa'ki, Stars' Rest, Fizzcrank Airstrip, River's Heart
				["0.74:0.29:0.49:0.42:0.60:0.48:0.73:0.46"] = 350, -- Kamagua, Moa'ki, Wintergarde Keep, Amberpine Lodge
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60"] = 219, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand
				["0.74:0.29:0.76:0.33:0.60:0.48:0.54:0.48:0.52:0.62"] = 328, -- Kamagua, Westguard Keep, Wintergarde Keep, Wyrmrest Temple, Dalaran
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58"] = 177, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58"] = 216, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch
				["0.74:0.29:0.49:0.42:0.52:0.62:0.56:0.64:0.57:0.67"] = 377, -- Kamagua, Moa'ki, Dalaran, The Argent Vanguard, Frosthold
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 475, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64"] = 256, -- Kamagua, Westwacht, Ammertannhütte, Lichtbresche, Schwarze Wacht, K3
				["0.74:0.29:0.76:0.33:0.60:0.48:0.64:0.58:0.62:0.64:0.57:0.67"] = 328, -- Kamagua, Westguard Keep, Wintergarde Keep, Ebon Watch, K3, Frosthold
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67"] = 298, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Frosthold
				["0.74:0.29:0.49:0.42:0.42:0.47:0.41:0.57:0.24:0.60"] = 448, -- Kamagua, Moa'ki, Stars' Rest, Valiance Landing Camp, River's Heart
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 313, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga, Gundrak
				["0.74:0.29:0.49:0.42:0.42:0.47:0.41:0.57:0.28:0.72"] = 477, -- Kamagua, Moa'ki, Stars' Rest, Valiance Landing Camp, Death's Rise
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 431, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67:0.64:0.81"] = 396, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Frosthold, Ulduar
				["0.74:0.29:0.49:0.42:0.29:0.43:0.22:0.39:0.17:0.47"] = 448, -- Kamagua, Moa'ki, Unu'pe, Valiance Keep, Amber Ledge
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62:0.64:0.81:0.57:0.79"] = 462, -- Kamagua, Westwacht, Ammertannhütte, Lichtbresche, Argentumwache, Zim'Torga, Ulduar, Bergfels' Zuflucht
				["0.74:0.29:0.49:0.42:0.60:0.48"] = 279, -- Kamagua, Moa'ki, Wintergarde Keep
				["0.74:0.29:0.76:0.33:0.60:0.48:0.64:0.58:0.62:0.64:0.72:0.71"] = 385, -- Kamagua, Westguard Keep, Wintergarde Keep, Ebon Watch, K3, Dun Nifflelem
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64"] = 304, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 308, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79"] = 363, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Frosthold, Bouldercrag's Refuge
				["0.74:0.29:0.76:0.33:0.60:0.48:0.59:0.57"] = 252, -- Kamagua, Westguard Keep, Wintergarde Keep, Windrunner's Overlook
				["0.74:0.29:0.49:0.42:0.42:0.47:0.21:0.51:0.18:0.60"] = 450, -- Kamagua, Moa'ki, Sternenruh, Landebahn Kurbelzisch, Nesingwarys Basislager
				["0.74:0.29:0.76:0.33:0.60:0.48:0.46:0.54:0.52:0.62"] = 343, -- Kamagua, Westguard Keep, Wintergarde Keep, Fordragon Hold, Dalaran
				["0.74:0.29:0.49:0.42:0.52:0.62:0.62:0.64"] = 360, -- Kamagua, Moa'ki, Dalaran, K3
				["0.74:0.29:0.76:0.33:0.60:0.48:0.64:0.58"] = 245, -- Kamagua, Westguard Keep, Wintergarde Keep, Ebon Watch
				["0.74:0.29:0.76:0.33:0.60:0.48:0.64:0.58:0.62:0.64"] = 285, -- Kamagua, Westguard Keep, Wintergarde Keep, Ebon Watch, K3
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.57:0.67"] = 342, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, Frosthold
				["0.74:0.29:0.49:0.42:0.52:0.62:0.59:0.57"] = 357, -- Kamagua, Moa'ki, Dalaran, Windrunner's Overlook
				["0.74:0.29:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 396, -- Kamagua, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.74:0.29:0.49:0.42:0.42:0.47:0.22:0.39:0.17:0.47"] = 439, -- Kamagua, Moa'ki, Stars' Rest, Valiance Keep, Amber Ledge
				["0.74:0.29:0.76:0.33:0.60:0.48:0.42:0.47:0.29:0.43"] = 392, -- Kamagua, Westguard Keep, Wintergarde Keep, Stars' Rest, Unu'pe
				["0.74:0.29:0.49:0.42:0.42:0.47:0.41:0.57:0.38:0.79"] = 472, -- Kamagua, Moa'ki, Sternenruh, Valianzlager, Das Schattengewölbe
				["0.74:0.29:0.49:0.42:0.29:0.43:0.21:0.51:0.24:040"] = 467, -- Kanagua, Moa’ki, Unu’pe, Fizzcrank Airstrip, River’s Heart
				["0.74:0.29:0.49:0.42:0.29:0.43:0.22:0.39:0.17:0.47:0.12:0.47"] = 483, -- Kamagua, Moa'ki, Unu'pe, Valiance Keep, Amber Ledge, Transitus Shield
				["0.74:0.29:0.76:0.33:0.73:0.46:0.83:0.54:0.78:0.62:0.72:0.71"] = 351, -- Kamagua, Donjon de la Garde de l'ouest, Gîte Ambrepin, Brigade de la marche de l'Ouest, Zim'Torga, Dun Nifflelem

				-- Alliance: Howling Fjord: Valgarde Port, Howling Fjord
				["0.88:0.28:0.88:0.40"] = 71, -- Valgarde Port, Fort Wildervar
				["0.88:0.28:0.76:0.33"] = 70, -- Valgarde Port, Westguard Keep
				["0.88:0.28:0.74:0.29"] = 96, -- Valgarde Port, Kamagua
				["0.88:0.28:0.76:0.33:0.73:0.46"] = 144, -- Valgarde Port, Westguard Keep, Amberpine Lodge
				["0.88:0.28:0.88:0.40:0.83:0.54"] = 168, -- Valgarde Port, Fort Wildervar, Westfall Brigade
				["0.88:0.28:0.74:0.29:0.49:0.42"] = 290, -- Valgarde Port, Kamagua, Moa'ki
				["0.88:0.28:0.76:0.33:0.60:0.48:0.42:0.47:0.22:0.39"] = 455, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62"] = 315, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran
				["0.88:0.28:0.88:0.40:0.83:0.54:0.78:0.62"] = 241, -- Valgarde Port, Fort Wildervar, Westfall Brigade, Zim'Torga
				["0.88:0.28:0.88:0.40:0.83:0.54:0.72:0.60"] = 249, -- Valgarde Port, Fort Wildervar, Westfall Brigade, The Argent Stand
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67"] = 332, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Frosthold
				["0.88:0.28:0.74:0.29:0.49:0.42:0.29:0.43"] = 421, -- Valgarde Port, Kamagua, Moa'ki, Unu'pe
				["0.88:0.28:0.76:0.33:0.60:0.48:0.42:0.47"] = 329, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Stars' Rest
				["0.88:0.28:0.76:0.33:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 534, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.88:0.28:0.76:0.33:0.60:0.48:0.42:0.47:0.21:0.51"] = 454, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip
				["0.88:0.28:0.76:0.33:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 498, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.88:0.28:0.76:0.33:0.60:0.48"] = 220, -- Valgarde Port, Westguard Keep, Wintergarde Keep
				["0.88:0.28:0.76:0.33:0.60:0.48:0.54:0.48"] = 268, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Wyrmrest Temple
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58"] = 211, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach
				["0.88:0.28:0.88:0.40:0.83:0.54:0.78:0.62:0.82:0.69"] = 294, -- Valgarde Port, Fort Wildervar, Westfall Brigade, Zim'Torga, Gundrak
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58"] = 249, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64"] = 289, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, K3
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.59:0.57"] = 282, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Windrunner's Overlook
				["0.88:0.28:0.76:0.33:0.60:0.48:0.46:0.54"] = 310, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Fordragon Hold
				["0.88:0.28:0.76:0.33:0.60:0.48:0.46:0.54:0.41:0.57"] = 369, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp
				["0.88:0.28:0.74:0.29:0.49:0.42:0.29:0.43:0.22:0.39"] = 481, -- Valgarde Port, Kamagua, Moa'ki, Unu'pe, Valiance Keep
				["0.88:0.28:0.88:0.40:0.73:0.46:0.60:0.48:0.42:0.47"] = 356, -- Valgarde Port, Fort Wildervar, Amberpine Lodge, Wintergarde Keep, Stars' Rest
				["0.88:0.28:0.88:0.40:0.83:0.54:0.72:0.60:0.64:0.58"] = 301, -- Valgarde Port, Fort Wildervar, Westfall Brigade, The Argent Stand, Ebon Watch
				["0.88:0.28:0.76:0.33:0.60:0.48:0.49:0.42"] = 313, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Moa'ki
				["0.88:0.28:0.76:0.33:0.73:0.46:0.83:0.54"] = 228, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Westfall Brigade
				["0.88:0.28:0.74:0.29:0.49:0.42:0.29:0.43:0.21:0.51:0.17:0.47:0.12:0.47"] = 580, -- Valgarde Port, Kamagua, Moa'ki, Unu'pe, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.88:0.28:0.76:0.33:0.60:0.48:0.59:0.57:0.52:0.62"] = 332, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Windrunner's Overlook, Dalaran
				["0.88:0.28:0.74:0.29:0.49:0.42:0.29:0.43:0.21:0.51"] = 501, -- Valgarde Port, Kamagua, Moa'ki, Unu'pe, Fizzcrank Airstrip
				["0.88:0.28:0.76:0.33:0.60:0.48:0.54:0.48:0.52:0.62"] = 361, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Wyrmrest Temple, Dalaran
				["0.88:0.28:0.74:0.29:0.49:0.42:0.52:0.62"] = 412, -- Valgarde Port, Kamagua, Moa'ki, Dalaran
				["0.88:0.28:0.76:0.33:0.60:0.48:0.46:0.54:0.52:0.62"] = 375, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Fordragon Hold, Dalaran
				["0.88:0.28:0.74:0.29:0.49:0.42:0.42:0.47:0.22:0.39"] = 472, -- Valgarde Port, Kamagua, Moa'ki, Stars' Rest, Valiance Keep
				["0.88:0.28:0.74:0.29:0.49:0.42:0.29:0.43:0.22:0.39:0.17:0.47:0.12:0.47"] = 579, -- Valgarde Port, Kamagua, Moa'ki, Unu'pe, Valiance Keep, Amber Ledge, Transitus Shield
				["0.88:0.28:0.76:0.33:0.60:0.48:0.59:0.57:0.62:0.64:0.57:0.67:0.64:0.81"] = 470, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Windrunner's Overlook, K3, Frosthold, Ulduar
				["0.88:0.28:0.76:0.33:0.60:0.48:0.42:0.47:0.41:0.57"] = 391, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Stars' Rest, Valiance Landing Camp
				["0.88:0.28:0.76:0.33:0.60:0.48:0.69:0.58"] = 303, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Light's Breach
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60"] = 513, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, River's Heart
				["0.88:0.28:0.76:0.33:0.60:0.48:0.42:0.47:0.21:0.51:0.24:0.60"] = 516, -- Port-Valgarde, Donjon de la Garde de l'ouest, Donjon de Garde-hiver, Repos des étoiles, Piste d'atterrissage de Spumelevier, Le Cœur du fleuve
				["0.88:0.28:0.88:0.40:0.73:0.46"] = 167, -- Valgarde Port, Fort Wildervar, Amberpine Lodge
				["0.88:0.28:0.76:0.33:0.60:0.48:0.59:0.57"] = 285, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Windrunner's Overlook
				["0.88:0.28:0.74:0.29:0.49:0.42:0.60:0.48"] = 375, -- Hafen von Valgarde, Kamagua, Moa'ki, Feste Wintergarde
				["0.88:0.28:0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 364, -- Port-Valgarde, Fort Hardivar, Gîte Ambrepin, La Brèche de Lumière, Guet d'Ébène, Dalaran, Cime des Croisés
				["0.88:0.28:0.76:0.33:0.60:0.48:0.42:0.47:0.21:0.51:0.18:0.60"] = 530, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Nesingwary Base Camp
				["0.88:0.28:0.88:0.40:0.83:0.54:0.78:0.62:0.72:0.71"] = 325, -- Valgarde Port, Fort Wildervar, Westfall Brigade, Zim'Torga, Dun Nifflelem
				["0.88:0.28:0.74:0.29:0.49:0.42:0.42:0.47"] = 344, -- Hafen von Valgarde, Kamagua, Moa'ki, Sternenruh
				["0.88:0.28:0.76:0.33:0.60:0.48:0.42:0.47:0.22:0.39:0.17:0.47"] = 518, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Stars' Rest, Valiance Keep, Amber Ledge
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64"] = 337, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard
				["0.88:0.28:0.76:0.33:0.60:0.48:0.46:0.54:0.41:0.57:0.24:0.60"] = 506, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp, River's Heart
				["0.88:0.28:0.88:0.40:0.83:0.54:0.78:0.62:0.64:0.81"] = 394, -- Port-Valgarde, Fort Hardivar, Brigade de la marche de l'Ouest, Zim'Torga, Ulduar
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 610, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.88:0.28:0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64"] = 311, -- Valgarde Port, Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, K3
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60"] = 253, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand
				["0.88:0.28:0.76:0.33:0.60:0.48:0.42:0.47:0.29:0.43"] = 425, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Stars' Rest, Unu'pe
				["0.88:0.28:0.76:0.33:0.60:0.48:0.64:0.58:0.52:0.62"] = 345, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Ebon Watch, Dalaran
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79"] = 396, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Frosthold, Bouldercrag's Refuge
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67:0.64:0.81"] = 429, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Frosthold, Ulduar
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 347, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga, Gundrak
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 483, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.88:0.28:0.74:0.29:0.49:0.42:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 549, -- Valgarde Port, Kamagua, Moa'ki, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.88:0.28:0.76:0.33:0.60:0.48:0.64:0.58:0.52:0.62:0.24:0.60"] = 543, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Ebon Watch, Dalaran, River's Heart
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 342, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.88:0.28:0.76:0.33:0.60:0.48:0.59:0.57:0.62:0.64"] = 330, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Windrunner's Overlook, K3
				["0.88:0.28:0.88:0.40:0.83:0.54:0.72:0.60:0.64:0.58:0.52:0.62"] = 368, -- Valgarde Port, Fort Wildervar, Westfall Brigade, The Argent Stand, Ebon Watch, Dalaran
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 508, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 378, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 446, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga, Ulduar
				["0.88:0.28:0.76:0.33:0.60:0.48:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 553, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.88:0.28:0.74:0.29:0.49:0.42:0.29:0.43:0.22:0.39:0.17:0.47"] = 543, -- Valgarde Port, Kamagua, Moa'ki, Unu'pe, Valiance Keep, Amber Ledge
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 464, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.88:0.28:0.76:0.33:0.60:0.48:0.64:0.58"] = 278, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Ebon Watch
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79:0.38:0.79"] = 509, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Frosthold, Bouldercrag's Refuge, The Shadow Vault
				["0.88:0.28:0.76:0.33:0.60:0.48:0.64:0.58:0.62:0.64"] = 318, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Ebon Watch, K3
				["0.88:0.28:0.76:0.33:0.60:0.48:0.54:0.48:0.52:0.62:0.56:0.64"] = 382, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Wyrmrest Temple, Dalaran, The Argent Vanguard
				["0.88:0.28:0.74:0.29:0.49:0.42:0.54:0.48"] = 338, -- Valgarde Port, Kamagua, Moa'ki, Wyrmrest Temple
				["0.88:0.28:0.76:0.33:0.60:0.48:0.54:0.48:0.52:0.62:0.62:0.64"] = 405, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Wyrmrest Temple, Dalaran, K3
				["0.88:0.28:0.76:0.33:0.60:0.48:0.64:0.58:0.72:0.60"] = 342, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Ebon Watch, The Argent Stand
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.57:0.67"] = 375, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, Frosthold
				["0.88:0.28:0.76:0.33:0.60:0.48:0.42:0.47:0.41:0.57:0.52:0.62"] = 482, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Stars' Rest, Valiance Landing Camp, Dalaran
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 428, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.88:0.28:0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 451, -- Valgarde Port, Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.88:0.28:0.76:0.33:0.60:0.48:0.59:0.57:0.52:0.62:0.41:0.57"] = 434, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Windrunner's Overlook, Dalaran, Valiance Landing Camp
				["0.88:0.28:0.76:0.33:0.60:0.48:0.64:0.58:0.62:0.64:0.57:0.67:0.64:0.81"] = 458, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Ebon Watch, K3, Frosthold, Ulduar
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 549, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.88:0.28:0.76:0.33:0.60:0.48:0.49:0.42:0.52:0.62"] = 434, -- Port-Valgarde, Donjon de la Garde de l'ouest, Donjon de Garde-hiver, Moa'ki, Dalaran
				["0.88:0.28:0.88:0.40:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62"] = 338, -- Valgarde Port, Fort Wildervar, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62"] = 293, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.46:0.54:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 658, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Fordragon Hold, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.88:0.28:0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.46:0.54"] = 359, -- Valgarde Port, Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Fordragon Hold
				["0.88:0.28:0.88:0.40:0.83:0.54:0.72:0.60:0.69:0.58"] = 273, -- Valgarde Port, Fort Wildervar, Westfall Brigade, The Argent Stand, Light's Breach
				["0.88:0.28:0.76:0.33:0.60:0.48:0.59:0.57:0.52:0.62:0.49:0.79"] = 445, -- Port-Valgarde, Donjon de la Garde de l'ouest, Donjon de Garde-hiver, Surplomb de Coursevent, Dalaran, Enceinte du tournoi d'Argent
				["0.88:0.28:0.76:0.33:0.60:0.48:0.54:0.48:0.52:0.62:0.49:0.79"] = 475, -- Valgarde Port, Westguard Keep, Wintergarde Keep, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.88:0.28:0.74:0.29:0.49:0.42:0.60:0.48:0.69:0.58"] = 457, -- Valgarde Port, Kamagua, Moa'ki, Wintergarde Keep, Light's Breach

				-- Alliance: Howling Fjord: Westguard Keep
				["0.76:0.33:0.74:0.29"] = 52, -- Westguard Keep, Kamagua
				["0.76:0.33:0.88:0.28"] = 70, -- Westguard Keep, Valgarde Port
				["0.76:0.33:0.88:0.40"] = 86, -- Westguard Keep, Fort Wildervar
				["0.76:0.33:0.73:0.46"] = 77, -- Westguard Keep, Amberpine Lodge
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62"] = 248, -- Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64"] = 222, -- Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, K3
				["0.76:0.33:0.60:0.48:0.42:0.47:0.29:0.43"] = 357, -- Westguard Keep, Wintergarde Keep, Stars' Rest, Unu'pe
				["0.76:0.33:0.60:0.48:0.42:0.47"] = 260, -- Westguard Keep, Wintergarde Keep, Stars' Rest
				["0.76:0.33:0.73:0.46:0.83:0.54"] = 160, -- Westguard Keep, Amberpine Lodge, Westfall Brigade
				["0.76:0.33:0.60:0.48"] = 152, -- Westguard Keep, Wintergarde Keep
				["0.76:0.33:0.60:0.48:0.54:0.48"] = 200, -- Westguard Keep, Wintergarde Keep, Wyrmrest Temple
				["0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60"] = 186, -- Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand
				["0.76:0.33:0.73:0.46:0.69:0.58"] = 143, -- Westguard Keep, Amberpine Lodge, Light's Breach
				["0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62"] = 226, -- Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58"] = 182, -- Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch
				["0.76:0.33:0.60:0.48:0.42:0.47:0.22:0.39"] = 387, -- Westguard Keep, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.76:0.33:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 429, -- Westguard Keep, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.76:0.33:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 465, -- Westguard Keep, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.76:0.33:0.60:0.48:0.42:0.47:0.21:0.51"] = 385, -- Westguard Keep, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip
				["0.76:0.33:0.60:0.48:0.46:0.54:0.41:0.57:0.24:0.60"] = 437, -- Westguard Keep, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp, River's Heart
				["0.76:0.33:0.74:0.29:0.49:0.42:0.29:0.43"] = 377, -- Westguard Keep, Kamagua, Moa'ki, Unu'pe
				["0.76:0.33:0.74:0.29:0.49:0.42"] = 246, -- Westguard Keep, Kamagua, Moa'ki
				["0.76:0.33:0.60:0.48:0.49:0.42:0.29:0.43"] = 375, -- Westguard Keep, Wintergarde Keep, Moa'ki, Unu'pe
				["0.76:0.33:0.74:0.29:0.49:0.42:0.52:0.62"] = 368, -- Westguard Keep, Kamagua, Moa'ki, Dalaran
				["0.76:0.33:0.60:0.48:0.54:0.48:0.52:0.62"] = 292, -- Westwacht, Feste Wintergarde, Wyrmruhtempel, Dalaran
				["0.76:0.33:0.74:0.29:0.49:0.42:0.29:0.43:0.22:0.39:0.17:0.47:0.12:0.47"] = 535, -- Westguard Keep, Kamagua, Moa'ki, Unu'pe, Valiance Keep, Amber Ledge, Transitus Shield
				["0.76:0.33:0.74:0.29:0.49:0.42:0.42:0.47"] = 300, -- Westguard Keep, Kamagua, Moa'ki, Stars' Rest
				["0.76:0.33:0.74:0.29:0.49:0.42:0.42:0.47:0.22:0.39"] = 428, -- Westguard Keep, Kamagua, Moa'ki, Stars' Rest, Valiance Keep
				["0.76:0.33:0.60:0.48:0.49:0.42"] = 244, -- Westguard Keep, Wintergarde Keep, Moa'ki
				["0.76:0.33:0.60:0.48:0.46:0.54"] = 242, -- Westguard Keep, Wintergarde Keep, Fordragon Hold
				["0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 311, -- Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.76:0.33:0.60:0.48:0.64:0.58:0.52:0.62"] = 276, -- Westguard Keep, Wintergarde Keep, Ebon Watch, Dalaran
				["0.76:0.33:0.74:0.29:0.49:0.42:0.29:0.43:0.21:0.51"] = 456, -- Westguard Keep, Kamagua, Moa'ki, Unu'pe, Fizzcrank Airstrip
				["0.76:0.33:0.60:0.48:0.59:0.57:0.52:0.62"] = 264, -- Westguard Keep, Wintergarde Keep, Windrunner's Overlook, Dalaran
				["0.76:0.33:0.74:0.29:0.49:0.42:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 525, -- Westguard Keep, Kamagua, Moa'ki, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.76:0.33:0.60:0.48:0.46:0.54:0.52:0.62"] = 307, -- Westguard Keep, Wintergarde Keep, Fordragon Hold, Dalaran
				["0.76:0.33:0.60:0.48:0.49:0.42:0.52:0.62"] = 366, -- Westguard Keep, Wintergarde Keep, Moa'ki, Dalaran
				["0.76:0.33:0.60:0.48:0.42:0.47:0.21:0.51:0.24:0.60"] = 448, -- Westguard Keep, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, River's Heart
				["0.76:0.33:0.60:0.48:0.69:0.58"] = 235, -- Westwacht, Feste Wintergarde, Lichtbresche
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64"] = 269, -- Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard
				["0.76:0.33:0.60:0.48:0.42:0.47:0.21:0.51:0.18:0.60"] = 461, -- Westguard Keep, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Nesingwary Base Camp
				["0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 279, -- Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga, Gundrak
				["0.76:0.33:0.74:0.29:0.49:0.42:0.29:0.43:0.22:0.39"] = 437, -- Westguard Keep, Kamagua, Moa'ki, Unu'pe, Valiance Keep
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67:0.64:0.81"] = 362, -- Westwacht, Ammertannhütte, Lichtbresche, Schwarze Wacht, K3, Eisfestung, Ulduar
				["0.76:0.33:0.60:0.48:0.46:0.54:0.41:0.57:0.28:0.72"] = 467, -- Westguard Keep, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp, Death's Rise
				["0.76:0.33:0.74:0.29:0.49:0.42:0.42:0.47:0.21:0.51:0.17:0.47"] = 469, -- Westguard Keep, Kamagua, Moa'ki, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67"] = 264, -- Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Frosthold
				["0.76:0.33:0.73:0.46:0.83:0.54:0.78:0.62:0.72:0.71"] = 317, -- Westguard Keep, Amberpine Lodge, Westfall Brigade, Zim'Torga, Dun Nifflelem
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.59:0.57"] = 215, -- Westwacht, Ammertannhütte, Lichtbresche, Schwarze Wacht, Windläufers Warte
				["0.76:0.33:0.60:0.48:0.59:0.57:0.52:0.62:0.56:0.64"] = 285, -- Westguard Keep, Wintergarde Keep, Windrunner's Overlook, Dalaran, The Argent Vanguard
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 274, -- Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.76:0.33:0.88:0.40:0.83:0.54"] = 183, -- Westguard Keep, Fort Wildervar, Westfall Brigade
				["0.76:0.33:0.60:0.48:0.54:0.48:0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 417, -- Westguard Keep, Wintergarde Keep, Wyrmrest Temple, Dalaran, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60"] = 446, -- Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, River's Heart
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 397, -- Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 416, -- Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.76:0.33:0.60:0.48:0.46:0.54:0.41:0.57"] = 302, -- Westguard Keep, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp
				["0.76:0.33:0.60:0.48:0.54:0.48:0.52:0.62:0.52:0.66"] = 320, -- Westguard Keep, Wintergarde Keep, Wyrmrest Temple, Dalaran, Crusaders' Pinnacle
				["0.76:0.33:0.60:0.48:0.64:0.58:0.62:0.64:0.72:0.71"] = 349, -- Westguard Keep, Wintergarde Keep, Ebon Watch, K3, Dun Nifflelem
				["0.76:0.33:0.60:0.48:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 485, -- Westguard Keep, Wintergarde Keep, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.76:0.33:0.73:0.46:0.69:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 379, -- Westguard Keep, Amberpine Lodge, Light's Breach, The Argent Stand, Zim'Torga, Ulduar
				["0.76:0.33:0.74:0.29:0.49:0.42:0.54:0.48"] = 294, -- Westguard Keep, Kamagua, Moa'ki, Wyrmrest Temple
				["0.76:0.33:0.60:0.48:0.59:0.57"] = 217, -- Westwacht, Feste Wintergarde, Windläufers Warte
				["0.76:0.33:0.60:0.48:0.42:0.47:0.41:0.57"] = 323, -- Westguard Keep, Wintergarde Keep, Stars' Rest, Valiance Landing Camp
				["0.76:0.33:0.74:0.29:0.49:0.42:0.52:0.62:0.62:0.64"] = 411, -- Westguard Keep, Kamagua, Moa'ki, Dalaran, K3
				["0.76:0.33:0.74:0.29:0.49:0.42:0.29:0.43:0.21:0.51:0.17:0.47:0.12:0.47"] = 536, -- Westguard Keep, Kamagua, Moa'ki, Unu'pe, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.76:0.33:0.60:0.48:0.42:0.47:0.22:0.39:0.17:0.47"] = 449, -- Donjon de la Garde de l'ouest, Donjon de Garde-hiver, Repos des étoiles, Donjon de la Bravoure, Escarpement d'Ambre
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.57:0.67"] = 308, -- Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, Frosthold
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79"] = 329, -- Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Frosthold, Bouldercrag's Refuge
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 361, -- Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.76:0.33:0.60:0.48:0.59:0.57:0.52:0.62:0.52:0.66:0.38:0.79"] = 413, -- Westguard Keep, Wintergarde Keep, Windrunner's Overlook, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.76:0.33:0.60:0.48:0.64:0.58:0.62:0.64"] = 249, -- Westguard Keep, Wintergarde Keep, Ebon Watch, K3
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.62:0.64:0.72:0.71"] = 322, -- Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, K3, Dun Nifflelem
				["0.76:0.33:0.60:0.48:0.59:0.57:0.52:0.62:0.49:0.79"] = 377, -- Westguard Keep, Wintergarde Keep, Windrunner's Overlook, Dalaran, Argent Tournament Grounds
				["0.76:0.33:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 441, -- Westguard Keep, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.76:0.33:0.60:0.48:0.54:0.48:0.52:0.62:0.49:0.79"] = 406, -- Westguard Keep, Wintergarde Keep, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.76:0.33:0.60:0.48:0.59:0.57:0.52:0.62:0.52:0.66"] = 290, -- Westguard Keep, Wintergarde Keep, Windrunner's Overlook, Dalaran, Crusaders' Pinnacle

				----------------------------------------------------------------------
				-- Alliance: Icecrown
				----------------------------------------------------------------------

				-- Alliance: Icecrown: Argent Tournament Grounds
				["0.49:0.79:0.52:0.66:0.41:0.57"] = 179, -- Argent Tournament Grounds, Crusaders' Pinnacle, Valiance Landing Camp
				["0.49:0.79:0.52:0.62"] = 141, -- Argent Tournament Grounds, Dalaran
				["0.49:0.79:0.52:0.66"] = 73, -- Argent Tournament Grounds, Crusaders' Pinnacle
				["0.49:0.79:0.57:0.79:0.64:0.81:0.78:0.62:0.83:0.54"] = 304, -- Argentumturnierplatz, Bergfels' Zuflucht, Ulduar, Zim'Torga, Westfallbrigade
				["0.49:0.79:0.38:0.79"] = 88, -- Argent Tournament Grounds, The Shadow Vault
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57"] = 178, -- Argentumturnierplatz, Kreuzfahrerturm, Die Argentumvorhut, Dalaran, Windläufers Warte
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46"] = 323, -- Argentumturnierplatz, Kreuzfahrerturm, Die Argentumvorhut, Dalaran, Windläufers Warte, Feste Wintergarde, Ammertannhütte
				["0.49:0.79:0.52:0.66:0.56:0.64"] = 106, -- Argentumturnierplatz, Kreuzfahrerturm, Die Argentumvorhut
				["0.49:0.79:0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.69:0.58"] = 266, -- Argent Tournament Grounds, Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, Light's Breach
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58"] = 203, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch
				["0.49:0.79:0.57:0.79"] = 51, -- Argent Tournament Grounds, Bouldercrag's Refuge
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.74:0.29"] = 422, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Kamagua
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.88:0.28"] = 441, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.49:0.79:0.28:0.72:0.24:0.60"] = 282, -- Argentumturnierplatz, Todesanhöhe, Flussnabel
				["0.49:0.79:0.57:0.79:0.57:0.67"] = 130, -- Argent Tournament Grounds, Bouldercrag's Refuge, Frosthold
				["0.49:0.79:0.28:0.72"] = 166, -- Argent Tournament Grounds, Death's Rise
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46"] = 330, -- Argentumturnierplatz, Kreuzfahrerturm, Die Argentumvorhut, Dalaran, Schwarze Wacht, Lichtbresche, Ammertannhütte
				["0.49:0.79:0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.69:0.58:0.73:0.46"] = 349, -- Argent Tournament Grounds, Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, Light's Breach, Amberpine Lodge
				["0.49:0.79:0.57:0.79:0.64:0.81"] = 96, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar
				["0.49:0.79:0.28:0.72:0.24:0.60:0.21:0.51"] = 343, -- Argent Tournament Grounds, Death's Rise, River's Heart, Fizzcrank Airstrip
				["0.49:0.79:0.28:0.72:0.24:0.60:0.21:0.51:0.17:0.47"] = 387, -- Argent Tournament Grounds, Death's Rise, River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.49:0.79:0.57:0.79:0.57:0.67:0.56:0.64"] = 163, -- Argent Tournament Grounds, Bouldercrag's Refuge, Frosthold, The Argent Vanguard
				["0.49:0.79:0.28:0.72:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 423, -- Argent Tournament Grounds, Death's Rise, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.49:0.79:0.28:0.72:0.18:0.60"] = 283, -- Argent Tournament Grounds, Death's Rise, Nesingwary Base Camp
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58"] = 247, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33"] = 372, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep
				["0.49:0.79:0.57:0.79:0.64:0.81:0.78:0.62:0.83:0.54:0.88:0.40"] = 389, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar, Zim'Torga, Westfall Brigade, Fort Wildervar
				["0.49:0.79:0.57:0.79:0.64:0.81:0.72:0.71"] = 199, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar, Dun Nifflelem
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.54:0.48"] = 246, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Wyrmrest Temple
				["0.49:0.79:0.52:0.66:0.41:0.57:0.42:0.47"] = 259, -- Argent Tournament Grounds, Crusaders' Pinnacle, Valiance Landing Camp, Stars' Rest
				["0.49:0.79:0.57:0.79:0.57:0.67:0.62:0.64:0.72:0.71"] = 278, -- Argent Tournament Grounds, Bouldercrag's Refuge, Frosthold, K3, Dun Nifflelem
				["0.49:0.79:0.52:0.62:0.24:0.60"] = 340, -- Argentumturnierplatz, Dalaran, Flussnabel
				["0.49:0.79:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54"] = 340, -- Argentumturnierplatz, Dalaran, Schwarze Wacht, Argentumwache, Westfallbrigade
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40:0.88:0.28"] = 495, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar, Valgarde Port
				["0.49:0.79:0.57:0.79:0.64:0.81:0.78:0.62:0.83:0.54:0.88:0.40:0.88:0.28"] = 463, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar, Zim'Torga, Westfall Brigade, Fort Wildervar, Valgarde Port
				["0.49:0.79:0.57:0.79:0.64:0.81:0.78:0.62:0.82:0.69"] = 302, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar, Zim'Torga, Gundrak
				["0.49:0.79:0.52:0.62:0.46:0.54"] = 228, -- Argent Tournament Grounds, Dalaran, Fordragon Hold
				["0.49:0.79:0.57:0.79:0.57:0.67:0.62:0.64"] = 178, -- Argent Tournament Grounds, Bouldercrag's Refuge, Frosthold, K3
				["0.49:0.79:0.52:0.66:0.41:0.57:0.42:0.47:0.29:0.43"] = 357, -- Argent Tournament Grounds, Crusaders' Pinnacle, Valiance Landing Camp, Stars' Rest, Unu'pe
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.49:0.42"] = 285, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Moa'ki
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.29:0.43"] = 395, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Unu'pe
				["0.49:0.79:0.57:0.79:0.64:0.81:0.78:0.62"] = 249, -- Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar, Zim'Torga
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60"] = 266, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.60:0.48"] = 264, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Wintergarde Keep
				["0.49:0.79:0.52:0.66:0.41:0.57:0.42:0.47:0.22:0.39"] = 390, -- Argent Tournament Grounds, Crusaders' Pinnacle, Valiance Landing Camp, Stars' Rest, Valiance Keep
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.60:0.48:0.76:0.33"] = 383, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Wintergarde Keep, Westguard Keep
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.60:0.48:0.76:0.33:0.74:0.29"] = 433, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Wintergarde Keep, Westguard Keep, Kamagua
				["0.49:0.79:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 507, -- Argent Tournament Grounds, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.49:0.79:0.52:0.62:0.46:0.54:0.42:0.47:0.29:0.43"] = 398, -- Argent Tournament Grounds, Dalaran, Fordragon Hold, Stars' Rest, Unu'pe
				["0.49:0.79:0.52:0.66:0.41:0.57:0.46:0.54"] = 228, -- Argent Tournament Grounds, Crusaders' Pinnacle, Valiance Landing Camp, Fordragon Hold
				["0.49:0.79:0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.72:0.60"] = 285, -- Argent Tournament Grounds, Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, The Argent Stand
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48"] = 252, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep
				["0.49:0.79:0.52:0.62:0.59:0.57"] = 180, -- Argent Tournament Grounds, Dalaran, Windrunner's Overlook
				["0.49:0.79:0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.72:0.60:0.83:0.54"] = 355, -- Argent Tournament Grounds, Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.49:0.79:0.52:0.66:0.41:0.57:0.24:0.60"] = 316, -- Argent Tournament Grounds, Crusaders' Pinnacle, Valiance Landing Camp, River's Heart
				["0.49:0.79:0.52:0.62:0.54:0.48:0.60:0.48:0.76:0.33:0.88:0.28"] = 486, -- Argent Tournament Grounds, Dalaran, Wyrmrest Temple, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54"] = 336, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.49:0.79:0.52:0.66:0.56:0.64:0.57:0.67:0.64:0.81"] = 242, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Frosthold, Ulduar
				["0.49:0.79:0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46"] = 326, -- Argent Tournament Grounds, Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge
				["0.49:0.79:0.52:0.62:0.56:0.64:0.57:0.67"] = 200, -- Argentumturnierplatz, Dalaran, Die Argentumvorhut, Eisfestung
				["0.49:0.79:0.41:0.57:0.42:0.47:0.29:0.43"] = 406, -- Argent Tournament Grounds, Valiance Landing Camp, Stars' Rest, Unu'pe
				["0.49:0.79:0.52:0.62:0.46:0.54:0.42:0.47"] = 302, -- Argent Tournament Grounds, Dalaran, Fordragon Hold, Stars' Rest
				["0.49:0.79:0.52:0.62:0.59:0.57:0.60:0.48"] = 255, -- Argent Tournament Grounds, Dalaran, Windrunner's Overlook, Wintergarde Keep
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.62:0.64:0.72:0.71"] = 281, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, K3, Dun Nifflelem
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.24:0.60"] = 336, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, River's Heart
				["0.49:0.79:0.52:0.62:0.41:0.57"] = 241, -- Argent Tournament Grounds, Dalaran, Valiance Landing Camp
				["0.49:0.79:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40"] = 425, -- Argent Tournament Grounds, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar
				["0.49:0.79:0.52:0.62:0.49:0.42"] = 288, -- Argentumturnierplatz, Dalaran, Moa'ki
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47"] = 298, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest
				["0.49:0.79:0.52:0.66:0.41:0.57:0.24:0.60:0.18:0.60"] = 350, -- Argent Tournament Grounds, Crusaders' Pinnacle, Valiance Landing Camp, River's Heart, Nesingwary Base Camp
				["0.49:0.79:0.52:0.62:0.24:0.60:0.21:0.51"] = 401, -- Argent Tournament Grounds, Dalaran, River's Heart, Fizzcrank Airstrip
				["0.49:0.79:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47"] = 445, -- Argent Tournament Grounds, Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.49:0.79:0.41:0.57"] = 228, -- Argent Tournament Grounds, Valiance Landing Camp
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.46:0.54"] = 225, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Fordragon Hold
				["0.49:0.79:0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48"] = 282, -- Argent Tournament Grounds, Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, Wintergarde Keep
				["0.49:0.79:0.52:0.62:0.56:0.64"] = 162, -- Argent Tournament Grounds, Dalaran, The Argent Vanguard
				["0.49:0.79:0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46"] = 369, -- Argent Tournament Grounds, Dalaran, Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge
				["0.49:0.79:0.41:0.57:0.42:0.47"] = 308, -- Argent Tournament Grounds, Valiance Landing Camp, Stars' Rest
				["0.49:0.79:0.52:0.62:0.64:0.58:0.69:0.58"] = 250, -- Argent Tournament Grounds, Dalaran, Ebon Watch, Light's Breach
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40"] = 422, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar
				["0.49:0.79:0.52:0.62:0.54:0.48:0.42:0.47"] = 316, -- Argent Tournament Grounds, Dalaran, Wyrmrest Temple, Stars' Rest
				["0.49:0.79:0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39"] = 429, -- Argent Tournament Grounds, Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62"] = 307, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46:0.83:0.54"] = 403, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.49:0.79:0.52:0.66:0.41:0.57:0.24:0.60:0.21:0.51"] = 377, -- Argent Tournament Grounds, Crusaders' Pinnacle, Valiance Landing Camp, River's Heart, Fizzcrank Airstrip
				["0.49:0.79:0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58"] = 222, -- Argent Tournament Grounds, Bouldercrag's Refuge, Frosthold, K3, Ebon Watch
				["0.49:0.79:0.52:0.66:0.41:0.57:0.24:0.60:0.21:0.51:0.17:0.47"] = 420, -- Argent Tournament Grounds, Crusaders' Pinnacle, Valiance Landing Camp, River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.49:0.79:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33"] = 376, -- Argent Tournament Grounds, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep
				["0.49:0.79:0.52:0.62:0.41:0.57:0.28:0.72"] = 407, -- Argent Tournament Grounds, Dalaran, Valiance Landing Camp, Death's Rise
				["0.49:0.79:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.74:0.29"] = 425, -- Argent Tournament Grounds, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Kamagua
				["0.49:0.79:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.88:0.28"] = 444, -- Argent Tournament Grounds, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.49:0.79:0.52:0.62:0.54:0.48"] = 250, -- Argent Tournament Grounds, Dalaran, Wyrmrest Temple
				["0.49:0.79:0.52:0.62:0.24:0.60:0.18:0.60"] = 374, -- Argent Tournament Grounds, Dalaran, River's Heart, Nesingwary Base Camp
				["0.49:0.79:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 481, -- Argent Tournament Grounds, Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 478, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.49:0.79:0.52:0.62:0.62:0.64:0.72:0.71"] = 285, -- Argent Tournament Grounds, Dalaran, K3, Dun Nifflelem
				["0.49:0.79:0.28:0.72:0.24:0.60:0.21:0.51:0.29:0.43"] = 407, -- Argent Tournament Grounds, Death's Rise, River's Heart, Fizzcrank Airstrip, Unu'pe
				["0.49:0.79:0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39:0.17:0.47"] = 491, -- Argent Tournament Grounds, Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep, Amber Ledge
				["0.49:0.79:0.52:0.62:0.64:0.58:0.60:0.48:0.73:0.46:0.83:0.54"] = 418, -- Argent Tournament Grounds, Dalaran, Ebon Watch, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.49:0.79:0.28:0.72:0.24:0.60:0.21:0.51:0.22:0.39"] = 413, -- Argent Tournament Grounds, Death's Rise, River's Heart, Fizzcrank Airstrip, Valiance Keep
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.62:0.64"] = 181, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, K3
				["0.49:0.79:0.52:0.66:0.28:0.72"] = 240, -- Argent Tournament Grounds, Crusaders' Pinnacle, Death's Rise
				["0.49:0.79:0.52:0.62:0.62:0.64"] = 185, -- Argent Tournament Grounds, Dalaran, K3
				["0.49:0.79:0.52:0.62:0.54:0.48:0.60:0.48:0.69:0.58"] = 380, -- Argent Tournament Grounds, Dalaran, Wyrmrest Temple, Wintergarde Keep, Light's Breach
				["0.49:0.79:0.52:0.66:0.41:0.57:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 456, -- Argent Tournament Grounds, Crusaders' Pinnacle, Valiance Landing Camp, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.49:0.79:0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46:0.83:0.54:0.78:0.62:0.82:0.69"] = 574, -- Argent Tournament Grounds, Dalaran, Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge, Westfall Brigade, Zim'Torga, Gundrak
				["0.49:0.79:0.52:0.62:0.64:0.58"] = 206, -- Argent Tournament Grounds, Dalaran, Ebon Watch
				["0.49:0.79:0.41:0.57:0.42:0.47:0.22:0.39"] = 439, -- Argent Tournament Grounds, Valiance Landing Camp, Stars' Rest, Valiance Keep
				["0.49:0.79:0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46"] = 333, -- Argent Tournament Grounds, Dalaran, Ebon Watch, Light's Breach, Amberpine Lodge
				["0.49:0.79:0.52:0.62:0.64:0.58:0.60:0.48:0.76:0.33"] = 386, -- Argentumturnierplatz, Dalaran, Schwarze Wacht, Feste Wintergarde, Westwacht
				["0.49:0.79:0.52:0.66:0.56:0.64:0.52:0.62:0.54:0.48:0.42:0.47"] = 312, -- Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Wyrmrest Temple, Stars' Rest
				["0.49:0.79:0.52:0.62:0.54:0.48:0.60:0.48"] = 298, -- Campos del Torneo Argenta, Dalaran, Templo del Reposo del Dragón, Fortaleza de Hibergarde
				["0.49:0.79:0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46:0.83:0.54"] = 416, -- Argent Tournament Grounds, Dalaran, Ebon Watch, Light's Breach, Amberpine Lodge, Westfall Brigade
				["0.49:0.79:0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46:0.76:0.33"] = 416, -- Argent Tournament Grounds, Dalaran, Ebon Watch, Light's Breach, Amberpine Lodge, Westguard Keep
				["0.49:0.79:0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46:0.83:0.54"] = 449, -- Argent Tournament Grounds, Dalaran, Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.49:0.79:0.52:0.62:0.49:0.42:0.29:0.43:0.22:0.39"] = 476, -- Argent Tournament Grounds, Dalaran, Moa'ki, Unu'pe, Valiance Keep
				["0.49:0.79:0.52:0.62:0.59:0.57:0.60:0.48:0.69:0.58"] = 338, -- Argent Tournament Grounds, Dalaran, Windrunner's Overlook, Wintergarde Keep, Light's Breach

				-- Alliance: Icecrown: Crusaders' Pinnacle
				["0.52:0.66:0.56:0.64:0.52:0.62:0.54:0.48"] = 174, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Wyrmrest Temple
				["0.52:0.66:0.56:0.64"] = 33, -- Crusaders' Pinnacle, The Argent Vanguard
				["0.52:0.66:0.56:0.64:0.52:0.62:0.62:0.64:0.72:0.71"] = 208, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, K3, Dun Nifflelem
				["0.52:0.66:0.56:0.64:0.57:0.67"] = 72, -- Crusaders' Pinnacle, The Argent Vanguard, Frosthold
				["0.52:0.66:0.56:0.64:0.52:0.62:0.24:0.60"] = 264, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, River's Heart
				["0.52:0.66:0.52:0.62:0.54:0.48"] = 182, -- Crusaders' Pinnacle, Dalaran, Wyrmrest Temple
				["0.52:0.66:0.56:0.64:0.57:0.67:0.64:0.81"] = 169, -- Crusaders' Pinnacle, The Argent Vanguard, Frosthold, Ulduar
				["0.52:0.66:0.28:0.72"] = 168, -- Crusaders' Pinnacle, Death's Rise
				["0.52:0.66:0.52:0.62"] = 71, -- Kreuzfahrerturm, Dalaran
				["0.52:0.66:0.56:0.64:0.57:0.67:0.57:0.79"] = 137, -- Crusaders' Pinnacle, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.60:0.48:0.76:0.33:0.88:0.28"] = 380, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46"] = 258, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Amberpine Lodge
				["0.52:0.66:0.56:0.64:0.52:0.62:0.49:0.42"] = 212, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Moa'ki
				["0.52:0.66:0.41:0.57"] = 107, -- Crusaders' Pinnacle, Valiance Landing Camp
				["0.52:0.66:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47"] = 226, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest
				["0.52:0.66:0.56:0.64:0.52:0.62:0.46:0.54"] = 152, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Fordragon Hold
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58"] = 174, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 287, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.52:0.66:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 431, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33"] = 300, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep
				["0.52:0.66:0.56:0.64:0.52:0.62:0.54:0.48:0.42:0.47:0.22:0.39"] = 366, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Wyrmrest Temple, Stars' Rest, Valiance Keep
				["0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48"] = 179, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep
				["0.52:0.66:0.56:0.64:0.52:0.62:0.62:0.64"] = 108, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, K3
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60"] = 193, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand
				["0.52:0.66:0.52:0.62:0.62:0.64:0.72:0.71"] = 216, -- 十字軍之巔，寒冰皇冠, 達拉然, K3，風暴群山, 丹尼弗蘭，風暴群山
				["0.52:0.66:0.38:0.79"] = 124, -- Kreuzfahrerturm, Das Schattengewölbe
				["0.52:0.66:0.41:0.57:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 394, -- Crusaders' Pinnacle, Valiance Landing Camp, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.52:0.66:0.41:0.57:0.42:0.47:0.29:0.43"] = 285, -- Crusaders' Pinnacle, Valiance Landing Camp, Stars' Rest, Unu'pe
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.60:0.48"] = 191, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Wintergarde Keep
				["0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46"] = 250, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge
				["0.52:0.66:0.41:0.57:0.42:0.47:0.22:0.39"] = 317, -- Crusaders' Pinnacle, Valiance Landing Camp, Stars' Rest, Valiance Keep
				["0.52:0.66:0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51"] = 326, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, River's Heart, Fizzcrank Airstrip
				["0.52:0.66:0.41:0.57:0.24:0.60"] = 243, -- Crusaders' Pinnacle, Valiance Landing Camp, River's Heart
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62"] = 234, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.74:0.29"] = 349, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Kamagua
				["0.52:0.66:0.41:0.57:0.42:0.47:0.21:0.51"] = 314, -- Crusaders' Pinnacle, Valiance Landing Camp, Stars' Rest, Fizzcrank Airstrip
				["0.52:0.66:0.41:0.57:0.42:0.47"] = 187, -- Crusaders' Pinnacle, Valiance Landing Camp, Stars' Rest
				["0.52:0.66:0.41:0.57:0.24:0.60:0.21:0.51"] = 304, -- Crusaders' Pinnacle, Valiance Landing Camp, River's Heart, Fizzcrank Airstrip
				["0.52:0.66:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39"] = 354, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep
				["0.52:0.66:0.41:0.57:0.24:0.60:0.18:0.60"] = 277, -- Kreuzfahrerturm, Valianzlager, Flussnabel, Nesingwarys Basislager
				["0.52:0.66:0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 405, -- Kreuzfahrerturm, Die Argentumvorhut, Dalaran, Flussnabel, Landebahn Kurbelzisch, Bernsteinflöz, Transitusschild
				["0.52:0.66:0.41:0.57:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 384, -- Crusaders' Pinnacle, Valiance Landing Camp, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54"] = 264, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58"] = 130, -- Вершина Рыцарей, Оплот Серебряного Авангарда, Даларан, Черная застава
				["0.52:0.66:0.41:0.57:0.24:0.60:0.21:0.51:0.17:0.47"] = 347, -- Crusaders' Pinnacle, Valiance Landing Camp, River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.88:0.28"] = 368, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57"] = 105, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook
				["0.52:0.66:0.52:0.62:0.59:0.57:0.60:0.48"] = 187, -- Crusaders' Pinnacle, Dalaran, Windrunner's Overlook, Wintergarde Keep
				["0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46:0.88:0.40"] = 364, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.52:0.66:0.41:0.57:0.46:0.54"] = 155, -- Crusaders' Pinnacle, Valiance Landing Camp, Fordragon Hold
				["0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40"] = 349, -- Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar
				["0.52:0.66:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.29:0.43"] = 322, -- Kreuzfahrerturm, Die Argentumvorhut, Dalaran, Feste Fordragon, Sternenruh, Unu'pe
				["0.52:0.66:0.49:0.79"] = 97, -- Crusaders' Pinnacle, Argent Tournament Grounds
				["0.52:0.66:0.52:0.62:0.24:0.60"] = 271, -- Crusaders' Pinnacle, Dalaran, River's Heart
				["0.52:0.66:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54"] = 272, -- Crusaders' Pinnacle, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.52:0.66:0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46"] = 258, -- Crusaders' Pinnacle, Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge
				["0.52:0.66:0.52:0.62:0.62:0.64:0.57:0.67:0.57:0.79"] = 223, -- Crusaders' Pinnacle, Dalaran, K3, Frosthold, Bouldercrag's Refuge
				["0.52:0.66:0.49:0.79:0.57:0.79"] = 145, -- Crusaders' Pinnacle, Argent Tournament Grounds, Bouldercrag's Refuge

				-- Alliance: Icecrown: Death's Rise
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62"] = 238, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran
				["0.28:0.72:0.41:0.57:0.46:0.54"] = 222, -- Death's Rise, Valiance Landing Camp, Fordragon Hold
				["0.28:0.72:0.41:0.57:0.46:0.54:0.60:0.48:0.76:0.33:0.88:0.28"] = 497, -- Death's Rise, Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.28:0.72:0.41:0.57"] = 173, -- Death's Rise, Valiance Landing Camp
				["0.28:0.72:0.24:0.60"] = 118, -- Death's Rise, River's Heart
				["0.28:0.72:0.24:0.60:0.21:0.51"] = 178, -- Death's Rise, River's Heart, Fizzcrank Airstrip
				["0.28:0.72:0.41:0.57:0.52:0.62:0.62:0.64"] = 309, -- Death's Rise, Valiance Landing Camp, Dalaran, K3
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.62:0.64:0.72:0.71"] = 382, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, K3, Dun Nifflelem
				["0.28:0.72:0.24:0.60:0.21:0.51:0.42:0.47"] = 310, -- 死亡高崗，寒冰皇冠, 大河之心，休拉薩盆地, 嘶軸簡易機場，北風凍原, 繁星之眠，龍骨荒野
				["0.28:0.72:0.41:0.57:0.42:0.47:0.54:0.48"] = 341, -- Cime de la Mort, Terrain d'atterrissage de la Bravoure, Repos des étoiles, Temple du Repos du ver
				["0.28:0.72:0.52:0.66:0.56:0.64:0.57:0.67"] = 246, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Frosthold
				["0.28:0.72:0.24:0.60:0.52:0.62"] = 310, -- Death's Rise, River's Heart, Dalaran
				["0.28:0.72:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 259, -- Уступ Смерти, Слияние рек, Взлетная полоса Выкрутеня, Янтарная гряда, Маскировочный щит
				["0.28:0.72:0.41:0.57:0.52:0.62:0.56:0.64"] = 286, -- Death's Rise, Valiance Landing Camp, Dalaran, The Argent Vanguard
				["0.28:0.72:0.41:0.57:0.52:0.62"] = 263, -- Death's Rise, Valiance Landing Camp, Dalaran
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.62:0.64"] = 282, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, K3
				["0.28:0.72:0.24:0.60:0.21:0.51:0.17:0.47"] = 222, -- Death's Rise, River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.28:0.72:0.52:0.66"] = 174, -- Death's Rise, Crusaders' Pinnacle
				["0.28:0.72:0.52:0.66:0.56:0.64"] = 207, -- Todesanhöhe, Kreuzfahrerturm, Die Argentumvorhut
				["0.28:0.72:0.41:0.57:0.46:0.54:0.60:0.48:0.76:0.33"] = 428, -- Death's Rise, Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Westguard Keep
				["0.28:0.72:0.52:0.66:0.56:0.64:0.57:0.67:0.57:0.79"] = 311, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.28:0.72:0.18:0.60"] = 118, -- Death's Rise, Nesingwary Base Camp
				["0.28:0.72:0.41:0.57:0.46:0.54:0.54:0.48"] = 286, -- Death's Rise, Valiance Landing Camp, Fordragon Hold, Wyrmrest Temple
				["0.28:0.72:0.52:0.66:0.56:0.64:0.57:0.67:0.64:0.81"] = 343, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Frosthold, Ulduar
				["0.28:0.72:0.38:0.79"] = 94, -- Death's Rise, The Shadow Vault
				["0.28:0.72:0.24:0.60:0.21:0.51:0.22:0.39"] = 248, -- Death's Rise, River's Heart, Fizzcrank Airstrip, Valiance Keep
				["0.28:0.72:0.57:0.79"] = 215, -- Death's Rise, Bouldercrag's Refuge
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51"] = 525, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 605, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.28:0.72:0.24:0.60:0.21:0.51:0.29:0.43"] = 243, -- Death's Rise, River's Heart, Fizzcrank Airstrip, Unu'pe
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46:0.88:0.40"] = 538, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.54:0.48"] = 363, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Wyrmrest Temple (StraightEdgeRik reported time may be incorrect)
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.46:0.54"] = 327, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Fordragon Hold
				["0.28:0.72:0.41:0.57:0.46:0.54:0.60:0.48:0.73:0.46:0.88:0.40"] = 493, -- Death's Rise, Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.28:0.72:0.57:0.79:0.64:0.81:0.72:0.71"] = 363, -- Death's Rise, Bouldercrag's Refuge, Ulduar, Dun Nifflelem
				["0.28:0.72:0.57:0.79:0.64:0.81:0.78:0.62:0.82:0.69"] = 465, -- Death's Rise, Bouldercrag's Refuge, Ulduar, Zim'Torga, Gundrak
				["0.28:0.72:0.41:0.57:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 460, -- Death's Rise, Valiance Landing Camp, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.28:0.72:0.57:0.79:0.64:0.81"] = 259, -- Уступ Смерти, Приют Глыбоскала, Ульдуар
				["0.28:0.72:0.41:0.57:0.46:0.54:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81:0.57:0.79"] = 645, -- Todesanhöhe, Valianzlager, Feste Fordragon, Schwarze Wacht, Argentumwache, Zim'Torga, Ulduar, Bergfels' Zuflucht
				["0.28:0.72:0.41:0.57:0.46:0.54:0.60:0.48:0.76:0.33:0.74:0.29"] = 478, -- Todesanhöhe, Valianzlager, Feste Fordragon, Feste Wintergarde, Westwacht, Kamagua
				["0.28:0.72:0.56:0.64:0.52:0.62"] = 259, -- Todesanhöhe, Die Argentumvorhut, Dalaran
				["0.28:0.72:0.52:0.66:0.52:0.62"] = 246, -- Death's Rise, Crusaders' Pinnacle, Dalaran
				["0.28:0.72:0.56:0.64"] = 228, -- Death's Rise, The Argent Vanguard
				["0.28:0.72:0.41:0.57:0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 389, -- Todesanhöhe, Valianzlager, Dalaran, Die Argentumvorhut, Eisfestung, Bergfels' Zuflucht
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58"] = 304, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch
				["0.28:0.72:0.41:0.57:0.42:0.47:0.21:0.51"] = 380, -- Death's Rise, Valiance Landing Camp, Stars' Rest, Fizzcrank Airstrip
				["0.28:0.72:0.57:0.79:0.64:0.81:0.78:0.62"] = 412, -- Death's Rise, Bouldercrag's Refuge, Ulduar, Zim'Torga
				["0.28:0.72:0.41:0.57:0.46:0.54:0.60:0.48:0.73:0.46"] = 379, -- Death's Rise, Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Amberpine Lodge
				["0.28:0.72:0.41:0.57:0.42:0.47:0.49:0.42"] = 322, -- Death's Rise, Valiance Landing Camp, Stars' Rest, Moa'ki
				["0.28:0.72:0.41:0.57:0.46:0.54:0.60:0.48:0.73:0.46:0.83:0.54"] = 459, -- Todesanhöhe, Valianzlager, Feste Fordragon, Feste Wintergarde, Ammertannhütte, Westfallbrigade
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58"] = 348, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach
				["0.28:0.72:0.41:0.57:0.52:0.62:0.56:0.64:0.57:0.67"] = 325, -- Death's Rise, Valiance Landing Camp, Dalaran, The Argent Vanguard, Frosthold
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54"] = 438, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.28:0.72:0.41:0.57:0.46:0.54:0.60:0.48"] = 308, -- Death's Rise, Valiance Landing Camp, Fordragon Hold, Wintergarde Keep
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60"] = 368, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand
				["0.28:0.72:0.41:0.57:0.42:0.47"] = 253, -- Death's Rise, Valiance Landing Camp, Stars' Rest
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57"] = 278, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48"] = 353, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep
				["0.28:0.72:0.41:0.57:0.46:0.54:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 497, -- Death's Rise, Valiance Landing Camp, Fordragon Hold, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.28:0.72:0.52:0.66:0.52:0.62:0.64:0.58"] = 312, -- Death's Rise, Crusaders' Pinnacle, Dalaran, Ebon Watch
				["0.28:0.72:0.56:0.64:0.52:0.62:0.62:0.64"] = 303, -- Todesanhöhe, Die Argentumvorhut, Dalaran, K3
				["0.28:0.72:0.41:0.57:0.46:0.54:0.64:0.58:0.72:0.60:0.78:0.62"] = 444, -- Death's Rise, Valiance Landing Camp, Fordragon Hold, Ebon Watch, The Argent Stand, Zim'Torga
				["0.28:0.72:0.41:0.57:0.46:0.54:0.64:0.58:0.72:0.60"] = 403, -- Death's Rise, Valiance Landing Camp, Fordragon Hold, Ebon Watch, The Argent Stand
				["0.28:0.72:0.41:0.57:0.46:0.54:0.64:0.58:0.69:0.58"] = 384, -- Death's Rise, Valiance Landing Camp, Fordragon Hold, Ebon Watch, Light's Breach
				["0.28:0.72:0.41:0.57:0.46:0.54:0.64:0.58"] = 340, -- Death's Rise, Valiance Landing Camp, Fordragon Hold, Ebon Watch
				["0.28:0.72:0.41:0.57:0.52:0.62:0.59:0.57"] = 305, -- Death's Rise, Valiance Landing Camp, Dalaran, Windrunner's Overlook
				["0.28:0.72:0.41:0.57:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 421, -- Death's Rise, Valiance Landing Camp, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.28:0.72:0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62"] = 481, -- Death's Rise, River's Heart, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.28:0.72:0.49:0.79"] = 170, -- Death's Rise, Argent Tournament Grounds
				["0.28:0.72:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46"] = 445, -- Death's Rise, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge
				["0.28:0.72:0.52:0.66:0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46"] = 474, -- Death's Rise, Crusaders' Pinnacle, Dalaran, Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge
				["0.28:0.72:0.24:0.60:0.52:0.62:0.62:0.64"] = 355, -- Death's Rise, River's Heart, Dalaran, K3
				["0.28:0.72:0.56:0.64:0.57:0.67"] = 267, -- Death's Rise, The Argent Vanguard, Frosthold
				["0.28:0.72:0.56:0.64:0.52:0.62:0.59:0.57"] = 299, -- Death's Rise, The Argent Vanguard, Dalaran, Windrunner's Overlook
				["0.28:0.72:0.49:0.79:0.52:0.62"] = 306, -- Death's Rise, Argent Tournament Grounds, Dalaran
				["0.28:0.72:0.24:0.60:0.21:0.51:0.29:0.43:0.49:0.42"] = 360, -- Death's Rise, River's Heart, Fizzcrank Airstrip, Unu'pe, Moa'ki
				["0.28:0.72:0.52:0.66:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33"] = 474, -- Death's Rise, Crusaders' Pinnacle, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep
				["0.28:0.72:0.57:0.79:0.64:0.81:0.78:0.62:0.83:0.54"] = 468, -- Death's Rise, Bouldercrag's Refuge, Ulduar, Zim'Torga, Westfall Brigade

				-- Alliance: Icecrown: The Argent Vanguard
				["0.56:0.64:0.57:0.67"] = 40, -- The Argent Vanguard, Frosthold
				["0.56:0.64:0.52:0.62"] = 33, -- The Argent Vanguard, Dalaran
				["0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48"] = 148, -- The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep
				["0.56:0.64:0.52:0.62:0.24:0.60"] = 232, -- The Argent Vanguard, Dalaran, River's Heart
				["0.56:0.64:0.52:0.62:0.62:0.64"] = 77, -- The Argent Vanguard, Dalaran, K3
				["0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51"] = 294, -- The Argent Vanguard, Dalaran, River's Heart, Fizzcrank Airstrip
				["0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60"] = 162, -- The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand
				["0.56:0.64:0.52:0.62:0.54:0.48"] = 142, -- The Argent Vanguard, Dalaran, Wyrmrest Temple
				["0.56:0.64:0.52:0.62:0.46:0.54:0.60:0.48:0.73:0.46"] = 278, -- The Argent Vanguard, Dalaran, Fordragon Hold, Wintergarde Keep, Amberpine Lodge
				["0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51"] = 320, -- The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip
				["0.56:0.64:0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46"] = 261, -- The Argent Vanguard, Dalaran, Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge
				["0.56:0.64:0.52:0.62:0.54:0.48:0.42:0.47"] = 208, -- The Argent Vanguard, Dalaran, Wyrmrest Temple, Stars' Rest
				["0.56:0.64:0.52:0.62:0.64:0.58:0.60:0.48:0.76:0.33:0.74:0.29"] = 329, -- The Argent Vanguard, Dalaran, Ebon Watch, Wintergarde Keep, Westguard Keep, Kamagua
				["0.56:0.64:0.52:0.62:0.64:0.58"] = 98, -- 은빛십자군 선봉기지 (얼음왕관), 달라란, 칠흑의 감시초소 (줄드락), 칠흑의 감시초소 (줄드락)
				["0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39"] = 321, -- The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep
				["0.56:0.64:0.52:0.62:0.64:0.58:0.60:0.48:0.76:0.33:0.88:0.28"] = 348, -- The Argent Vanguard, Dalaran, Ebon Watch, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.56:0.64:0.52:0.62:0.62:0.64:0.72:0.71"] = 177, -- The Argent Vanguard, Dalaran, K3, Dun Nifflelem
				["0.56:0.64:0.52:0.66:0.28:0.72"] = 195, -- The Argent Vanguard, Crusaders' Pinnacle, Death's Rise
				["0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58"] = 142, -- The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach
				["0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 255, -- Die Argentumvorhut, Dalaran, Schwarze Wacht, Argentumwache, Zim'Torga, Gundrak
				["0.56:0.64:0.57:0.67:0.64:0.81"] = 138, -- The Argent Vanguard, Frosthold, Ulduar
				["0.56:0.64:0.52:0.62:0.24:0.60:0.28:0.72"] = 317, -- The Argent Vanguard, Dalaran, River's Heart, Death's Rise
				["0.56:0.64:0.52:0.62:0.46:0.54"] = 121, -- The Argent Vanguard, Dalaran, Fordragon Hold
				["0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62"] = 202, -- Die Argentumvorhut, Dalaran, Schwarze Wacht, Argentumwache, Zim'Torga
				["0.56:0.64:0.57:0.67:0.57:0.79"] = 105, -- The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 373, -- Оплот Серебряного Авангарда, Даларан, Слияние рек, Взлетная полоса Выкрутеня, Янтарная гряда, Маскировочный щит
				["0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47"] = 363, -- The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.56:0.64:0.52:0.66"] = 28, -- Die Argentumvorhut, Kreuzfahrerturm
				["0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47"] = 194, -- The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest
				["0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33"] = 268, -- The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep
				["0.56:0.64:0.52:0.62:0.49:0.42:0.42:0.47:0.22:0.39"] = 361, -- The Argent Vanguard, Dalaran, Moa'ki, Stars' Rest, Valiance Keep
				["0.56:0.64:0.52:0.62:0.64:0.58:0.60:0.48:0.76:0.33"] = 279, -- The Argent Vanguard, Dalaran, Ebon Watch, Wintergarde Keep, Westguard Keep
				["0.56:0.64:0.52:0.66:0.41:0.57"] = 134, -- The Argent Vanguard, Crusaders' Pinnacle, Valiance Landing Camp
				["0.56:0.64:0.52:0.62:0.54:0.48:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 431, -- The Argent Vanguard, Dalaran, Wyrmrest Temple, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.56:0.64:0.52:0.62:0.41:0.57:0.28:0.72"] = 300, -- The Argent Vanguard, Dalaran, Valiance Landing Camp, Death's Rise
				["0.56:0.64:0.52:0.62:0.49:0.42"] = 180, -- Die Argentumvorhut, Dalaran, Moa'ki
				["0.56:0.64:0.52:0.62:0.59:0.57"] = 73, -- The Argent Vanguard, Dalaran, Windrunner's Overlook
				["0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.88:0.28"] = 337, -- Die Argentumvorhut, Dalaran, Windläufers Warte, Feste Wintergarde, Westwacht, Hafen von Valgarde
				["0.56:0.64:0.38:0.79"] = 148, -- The Argent Vanguard, The Shadow Vault
				["0.56:0.64:0.52:0.62:0.41:0.57"] = 134, -- The Argent Vanguard, Dalaran, Valiance Landing Camp
				["0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 399, -- The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.56:0.64:0.28:0.72"] = 225, -- The Argent Vanguard, Death's Rise
				["0.56:0.64:0.52:0.62:0.49:0.42:0.42:0.47:0.22:0.39:0.17:0.47"] = 422, -- Die Argentumvorhut, Dalaran, Moa'ki, Sternenruh, Valianzfeste, Bernsteinflöz
				["0.56:0.64:0.52:0.62:0.54:0.48:0.42:0.47:0.29:0.43"] = 303, -- The Argent Vanguard, Dalaran, Wyrmrest Temple, Stars' Rest, Unu'pe
				["0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47"] = 337, -- The Argent Vanguard, Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.56:0.64:0.52:0.62:0.64:0.58:0.60:0.48"] = 159, -- Die Argentumvorhut, Dalaran, Schwarze Wacht, Feste Wintergarde
				["0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 287, -- The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.56:0.64:0.52:0.62:0.54:0.48:0.60:0.48:0.69:0.58"] = 273, -- The Argent Vanguard, Dalaran, Wyrmrest Temple, Wintergarde Keep, Light's Breach
				["0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46"] = 226, -- Оплот Серебряного Авангарда, Даларан, Черная застава, Разлом Света, Приют Янтарной Сосны
				["0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.74:0.29"] = 318, -- The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Kamagua
				["0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46"] = 219, -- The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge
				["0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 420, -- The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.29:0.43"] = 291, -- The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Unu'pe
				["0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40"] = 317, -- The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar
				["0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46:0.88:0.40"] = 342, -- The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach, Amberpine Lodge, Fort Wildervar
				["0.56:0.64:0.52:0.62:0.24:0.60:0.18:0.60"] = 267, -- The Argent Vanguard, Dalaran, River's Heart, Nesingwary Base Camp
				["0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46:0.88:0.40"] = 332, -- The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.56:0.64:0.52:0.62:0.54:0.48:0.42:0.47:0.21:0.51"] = 332, -- The Argent Vanguard, Dalaran, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip
				["0.56:0.64:0.52:0.66:0.49:0.79"] = 124, -- Die Argentumvorhut, Kreuzfahrerturm, Argentumturnierplatz
				["0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54"] = 232, -- The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.56:0.64:0.52:0.62:0.49:0.79"] = 146, -- The Argent Vanguard, Dalaran, Argent Tournament Grounds
				["0.56:0.64:0.52:0.62:0.62:0.64:0.72:0.71:0.78:0.62:0.83:0.54"] = 321, -- The Argent Vanguard, Dalaran, K3, Dun Nifflelem, Zim'Torga, Westfall Brigade
				["0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46:0.83:0.54"] = 299, -- The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.56:0.64:0.52:0.62:0.49:0.79:0.57:0.79"] = 194, -- The Argent Vanguard, Dalaran, Argent Tournament Grounds, Bouldercrag's Refuge
				["0.56:0.64:0.52:0.66:0.41:0.57:0.42:0.47"] = 214, -- The Argent Vanguard, Crusaders' Pinnacle, Valiance Landing Camp, Stars' Rest

				-- Alliance: Icecrown: The Shadow Vault
				["0.38:0.79:0.52:0.62"] = 166, -- Time varies for different flights (best to ignore)
				["0.38:0.79:0.46:0.54:0.60:0.48"] = 277, -- The Shadow Vault, Fordragon Hold, Wintergarde Keep
				["0.38:0.79:0.52:0.62:0.64:0.58:0.72:0.60"] = 295, -- Das Schattengewölbe, Dalaran, Schwarze Wacht, Argentumwache (Robert Heftrich reported 342)
				["0.38:0.79:0.28:0.72"] = 78, -- The Shadow Vault, Death's Rise
				["0.38:0.79:0.64:0.81:0.78:0.62"] = 319, -- Das Schattengewölbe, Ulduar, Zim'Torga
				["0.38:0.79:0.41:0.57"] = 141, -- The Shadow Vault, Valiance Landing Camp
				["0.38:0.79:0.52:0.62:0.62:0.64:0.72:0.71"] = 311, -- The Shadow Vault, Dalaran, K3, Dun Nifflelem (Barbara Dominguez and Robin Nyzell reported 311, was 336)
				["0.38:0.79:0.46:0.54:0.60:0.48:0.76:0.33:0.88:0.28"] = 465, -- The Shadow Vault, Fordragon Hold, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.38:0.79:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 335, -- The Shadow Vault, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.38:0.79:0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39"] = 456, -- The Shadow Vault, Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep
				["0.38:0.79:0.52:0.66"] = 121, -- The Shadow Vault, Crusaders' Pinnacle
				["0.38:0.79:0.57:0.79"] = 122, -- The Shadow Vault, Bouldercrag's Refuge
				["0.38:0.79:0.64:0.81:0.72:0.71"] = 270, -- The Shadow Vault, Ulduar, Dun Nifflelem
				["0.38:0.79:0.42:0.47:0.49:0.42"] = 290, -- The Shadow Vault, Stars' Rest, Moa'ki
				["0.38:0.79:0.24:0.60"] = 194, -- The Shadow Vault, River's Heart (Alex Townsend reported 277)
				["0.38:0.79:0.57:0.67"] = 174, -- The Shadow Vault, Frosthold (Keith Magill reported 200)
				["0.38:0.79:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 507, -- The Shadow Vault, Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.38:0.79:0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46:0.88:0.40"] = 466, -- The Shadow Vault, Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.38:0.79:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 533, -- The Shadow Vault, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.38:0.79:0.52:0.62:0.24:0.60"] = 366, -- The Shadow Vault, Dalaran, River's Heart
				["0.38:0.79:0.18:0.60"] = 196, -- Das Schattengewölbe, Nesingwarys Basislager
				["0.38:0.79:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 428, -- The Shadow Vault, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.38:0.79:0.64:0.81"] = 167, -- Das Schattengewölbe, Ulduar
				["0.38:0.79:0.46:0.54:0.54:0.48"] = 255, -- Das Schattengewölbe, Feste Fordragon, Wyrmruhtempel
				["0.38:0.79:0.64:0.81:0.78:0.62:0.82:0.69"] = 373, -- The Shadow Vault, Ulduar, Zim'Torga, Gundrak
				["0.38:0.79:0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46"] = 359, -- The Shadow Vault, Dalaran, Ebon Watch, Light's Breach, Amberpine Lodge
				["0.38:0.79:0.24:0.60:0.21:0.51"] = 256, -- The Shadow Vault, River's Heart, Fizzcrank Airstrip
				["0.38:0.79:0.24:0.60:0.21:0.51:0.17:0.47"] = 299, -- The Shadow Vault, River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.38:0.79:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 389, -- The Shadow Vault, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.38:0.79:0.52:0.62:0.59:0.57:0.60:0.48"] = 281, -- The Shadow Vault, Dalaran, Windrunner's Overlook, Wintergarde Keep
				["0.38:0.79:0.52:0.62:0.46:0.54"] = 254, -- The Shadow Vault, Dalaran, Fordragon Hold
				["0.38:0.79:0.52:0.62:0.62:0.64"] = 210, -- The Shadow Vault, Dalaran, K3
				["0.38:0.79:0.52:0.62:0.54:0.48"] = 276, -- The Shadow Vault, Dalaran, Wyrmrest Temple (david field reported 302)
				["0.38:0.79:0.56:0.64"] = 135, -- The Shadow Vault, The Argent Vanguard
				["0.38:0.79:0.46:0.54:0.60:0.48:0.73:0.46"] = 347, -- The Shadow Vault, Fordragon Hold, Wintergarde Keep, Amberpine Lodge
				["0.38:0.79:0.64:0.81:0.78:0.62:0.83:0.54:0.88:0.40"] = 460, -- The Shadow Vault, Ulduar, Zim'Torga, Westfall Brigade, Fort Wildervar
				["0.38:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33"] = 473, -- The Shadow Vault, Frosthold, K3, Ebon Watch, Wintergarde Keep, Westguard Keep
				["0.38:0.79:0.52:0.62:0.46:0.54:0.42:0.47"] = 328, -- The Shadow Vault, Dalaran, Fordragon Hold, Stars' Rest
				["0.38:0.79:0.52:0.62:0.59:0.57"] = 206, -- The Shadow Vault, Dalaran, Windrunner's Overlook (Jaime Garcia reported 254)
				["0.38:0.79:0.46:0.54"] = 190, -- The Shadow Vault, Fordragon Hold
				["0.38:0.79:0.52:0.62:0.64:0.58"] = 232, -- The Shadow Vault, Dalaran, Ebon Watch (John Lewy reported 258)
				["0.38:0.79:0.42:0.47"] = 221, -- The Shadow Vault, Stars' Rest
				["0.38:0.79:0.42:0.47:0.22:0.39"] = 351, -- The Shadow Vault, Stars' Rest, Valiance Keep
				["0.38:0.79:0.24:0.60:0.21:0.51:0.22:0.39"] = 325, -- The Shadow Vault, River's Heart, Fizzcrank Airstrip, Valiance Keep
				["0.38:0.79:0.42:0.47:0.29:0.43"] = 319, -- The Shadow Vault, Stars' Rest, Unu'pe
				["0.38:0.79:0.46:0.54:0.60:0.48:0.76:0.33"] = 397, -- Das Schattengewölbe, Feste Fordragon, Feste Wintergarde, Westwacht
				["0.38:0.79:0.42:0.47:0.21:0.51:0.17:0.47"] = 392, -- The Shadow Vault, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.38:0.79:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.74:0.29"] = 451, -- Das Schattengewölbe, Dalaran, Windläufers Warte, Feste Wintergarde, Westwacht, Kamagua
				["0.38:0.79:0.46:0.54:0.60:0.48:0.76:0.33:0.74:0.29"] = 446, -- Das Schattengewölbe, Feste Fordragon, Feste Wintergarde, Westwacht, Kamagua
				["0.38:0.79:0.64:0.81:0.78:0.62:0.83:0.54"] = 375, -- The Shadow Vault, Ulduar, Zim'Torga, Westfall Brigade
				["0.38:0.79:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62"] = 336, -- The Shadow Vault, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.38:0.79:0.24:0.60:0.21:0.51:0.29:0.43"] = 320, -- The Shadow Vault, River's Heart, Fizzcrank Airstrip, Unu'pe
				["0.38:0.79:0.52:0.62:0.49:0.42"] = 339, -- The Shadow Vault, Dalaran, Moa'ki
				["0.38:0.79:0.52:0.62:0.64:0.58:0.69:0.58"] = 276, -- The Shadow Vault, Dalaran, Ebon Watch, Light's Breach
				["0.38:0.79:0.57:0.67:0.62:0.64:0.52:0.62"] = 319, -- Das Schattengewölbe, Eisfestung, K3, Dalaran
				["0.38:0.79:0.46:0.54:0.60:0.48:0.73:0.46:0.83:0.54"] = 428, -- The Shadow Vault, Fordragon Hold, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.38:0.79:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 421, -- The Shadow Vault, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.38:0.79:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.88:0.28"] = 470, -- The Shadow Vault, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.38:0.79:0.51:0.21"] = 78, -- The Shadow Vault, Argent Tournament Grounds
				["0.38:0.79:0.52:0.62:0.49:0.42:0.74:0.29:0.76:0.33:0.88:0.40"] = 615, -- The Shadow Vault, Dalaran, Moa'ki, Kamagua, Westguard Keep, Fort Wildervar
				["0.38:0.79:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54"] = 366, -- The Shadow Vault, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.38:0.79:0.52:0.62:0.54:0.48:0.60:0.48:0.76:0.33:0.88:0.40"] = 528, -- The Shadow Vault, Dalaran, Wyrmrest Temple, Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.38:0.79:0.57:0.67:0.64:0.81:0.72:0.71"] = 375, -- The Shadow Vault, Frosthold, Ulduar, Dun Nifflelem
				["0.38:0.79:0.52:0.62:0.49:0.42:0.74:0.29:0.76:0.33"] = 531, -- The Shadow Vault, Dalaran, Moa'ki, Kamagua, Westguard Keep

				----------------------------------------------------------------------
				-- Alliance: Sholazar Basin
				----------------------------------------------------------------------

				-- Alliance: Sholazar Basin: Nesingwary Base Camp
				["0.18:0.60:0.21:0.51:0.42:0.47"] = 315, -- Nesingwary Base Camp, Fizzcrank Airstrip, Stars' Rest
				["0.18:0.60:0.21:0.51:0.42:0.47:0.60:0.48"] = 495, -- Nesingwary Base Camp, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep
				["0.18:0.60:0.24:0.60"] = 77, -- Nesingwary Base Camp, River's Heart
				["0.18:0.60:0.24:0.60:0.52:0.62"] = 364, -- Nesingwary Base Camp, River's Heart, Dalaran
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62"] = 620, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.18:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46"] = 601, -- Nesingwary Base Camp, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Amberpine Lodge
				["0.18:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.69:0.58"] = 618, -- Nesingwary Base Camp, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Light's Breach
				["0.18:0.60:0.21:0.51:0.22:0.39"] = 221, -- Nesingwarys Basislager, Landebahn Kurbelzisch, Valianzfeste
				["0.18:0.60:0.24:0.60:0.52:0.62:0.62:0.64"] = 432, -- Nesingwary Base Camp, River's Heart, Dalaran, K3
				["0.18:0.60:0.24:0.60:0.52:0.62:0.62:0.64:0.72:0.71"] = 581, -- Nesingwary Base Camp, River's Heart, Dalaran, K3, Dun Nifflelem
				["0.18:0.60:0.21:0.51"] = 117, -- Nesingwary Base Camp, Fizzcrank Airstrip
				["0.18:0.60:0.24:0.60:0.52:0.62:0.54:0.48:0.60:0.48:0.76:0.33:0.88:0.28"] = 885, -- Nesingwary Base Camp, River's Heart, Dalaran, Wyrmrest Temple, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.18:0.60:0.21:0.51:0.29:0.43:0.49:0.42"] = 389, -- Nesingwary Base Camp, Fizzcrank Airstrip, Unu'pe, Moa'ki
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58"] = 465, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch
				["0.18:0.60:0.24:0.60:0.41:0.57"] = 287, -- Nesingwary Base Camp, River's Heart, Valiance Landing Camp
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 700, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60"] = 560, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch, The Argent Stand
				["0.18:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 236, -- Nesingwary Base Camp, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.18:0.60:0.24:0.60:0.41:0.57:0.42:0.47:0.49:0.42"] = 510, -- Camp de base de Nesingwary, Le Cœur du fleuve, Terrain d'atterrissage de la Bravoure, Repos des étoiles, Moa'ki
				["0.18:0.60:0.21:0.51:0.29:0.43"] = 213, -- Nesingwary Base Camp, Fizzcrank Airstrip, Unu'pe
				["0.18:0.60:0.21:0.51:0.42:0.47:0.54:0.48"] = 443, -- Nesingwary Base Camp, Fizzcrank Airstrip, Stars' Rest, Wyrmrest Temple
				["0.18:0.60:0.21:0.51:0.29:0.43:0.49:0.42:0.60:0.48"] = 515, -- Nesingwary Base Camp, Fizzcrank Airstrip, Unu'pe, Moa'ki, Wintergarde Keep
				["0.18:0.60:0.28:0.72"] = 137, -- Nesingwary Base Camp, Death's Rise
				["0.18:0.60:0.21:0.51:0.17:0.47"] = 182, -- Nesingwary Base Camp, Fizzcrank Airstrip, Amber Ledge
				["0.18:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46:0.88:0.40"] = 772, -- Nesingwary Base Camp, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.18:0.60:0.24:0.60:0.52:0.62:0.62:0.64:0.57:0.67"] = 495, -- Nesingwary Base Camp, River's Heart, Dalaran, K3, Frosthold
				["0.18:0.60:0.24:0.60:0.52:0.62:0.56:0.64"] = 397, -- Nesingwary Base Camp, River's Heart, Dalaran, The Argent Vanguard
				["0.18:0.60:0.24:0.60:0.52:0.62:0.49:0.42"] = 587, -- Nesingwary Base Camp, River's Heart, Dalaran, Moa'ki
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 747, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.18:0.60:0.24:0.60:0.52:0.62:0.52:0.66"] = 406, -- Nesingwary Base Camp, River's Heart, Dalaran, Crusaders' Pinnacle
				["0.18:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.76:0.33"] = 675, -- Nesingwary Base Camp, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Westguard Keep
				["0.18:0.60:0.28:0.72:0.38:0.79"] = 277, -- Nesingwarys Basislager, Todesanhöhe, Das Schattengewölbe
				["0.18:0.60:0.28:0.72:0.57:0.79"] = 458, -- Nesingwarys Basislager, Todesanhöhe, Bergfels' Zuflucht
				["0.18:0.60:0.21:0.51:0.42:0.47:0.46:0.54"] = 430, -- Nesingwary Base Camp, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold
				["0.18:0.60:0.24:0.60:0.52:0.62:0.56:0.64:0.57:0.67"] = 455, -- Nesingwary Base Camp, River's Heart, Dalaran, The Argent Vanguard, Frosthold
				["0.18:0.60:0.24:0.60:0.41:0.57:0.46:0.54"] = 360, -- Nesingwary Base Camp, River's Heart, Valiance Landing Camp, Fordragon Hold
				["0.18:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.76:0.33:0.88:0.28"] = 778, -- Nesingwary Base Camp, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.18:0.60:0.21:0.51:0.42:0.47:0.49:0.42:0.74:0.29"] = 690, -- Nesingwary Base Camp, Fizzcrank Airstrip, Stars' Rest, Moa'ki, Kamagua
				["0.18:0.60:0.24:0.60:0.52:0.62:0.59:0.57"] = 426, -- Nesingwary Base Camp, River's Heart, Dalaran, Windrunner's Overlook
				["0.18:0.60:0.21:0.51:0.42:0.47:0.49:0.42"] = 416, -- Nesingwary Base Camp, Fizzcrank Airstrip, Stars' Rest, Moa'ki
				["0.18:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46:0.83:0.54"] = 722, -- Nesingwary Base Camp, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.18:0.60:0.28:0.72:0.49:0.79"] = 391, -- Nesingwary Base Camp, Death's Rise, Argent Tournament Grounds
				["0.18:0.60:0.28:0.72:0.52:0.66"] = 398, -- Nesingwary Base Camp, Death's Rise, Crusaders' Pinnacle
				["0.18:0.60:0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29:0.88:0.28"] = 783, -- Nesingwary Base Camp, Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua, Valgarde Port
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54"] = 665, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.18:0.60:0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29"] = 664, -- Nesingwary Base Camp, Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua
				["0.18:0.60:0.24:0.60:0.52:0.62:0.64:0.58:0.69:0.58"] = 531, -- Nesingwary Base Camp, River's Heart, Dalaran, Ebon Watch, Light's Breach
				["0.18:0.60:0.28:0.72:0.57:0.79:0.64:0.81"] = 524, -- Nesingwary Base Camp, Death's Rise, Bouldercrag's Refuge, Ulduar
				["0.18:0.60:0.24:0.60:0.52:0.62:0.49:0.79"] = 534, -- Nesingwary Base Camp, River's Heart, Dalaran, Argent Tournament Grounds
				["0.18:0.60:0.24:0.60:0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46"] = 708, -- Nesingwary Base Camp, River's Heart, Dalaran, Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge
				["0.18:0.60:0.24:0.60:0.52:0.62:0.49:0.79:0.57:0.79:0.64:0.81"] = 672, -- Nesingwary Base Camp, River's Heart, Dalaran, Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar
				["0.18:0.60:0.24:0.60:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 600, -- Nesingwary Base Camp, River's Heart, Dalaran, The Argent Vanguard, Frosthold, Ulduar

				-- Alliance: Sholazar Basin: River's Heart
				["0.24:0.60:0.21:0.51"] = 104, -- River's Heart, Fizzcrank Airstrip
				["0.24:0.60:0.52:0.62"] = 302, -- River's Heart, Dalaran (davepringle46@yahoo.co.uk reported 336)
				["0.24:0.60:0.41:0.57:0.46:0.54:0.60:0.48:0.73:0.46:0.88:0.40"] = 705, -- River's Heart, Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.24:0.60:0.52:0.62:0.56:0.64"] = 335, -- River's Heart, Dalaran, The Argent Vanguard
				["0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 223, -- River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.24:0.60:0.41:0.57:0.46:0.54:0.60:0.48:0.76:0.33:0.88:0.28"] = 711, -- River's Heart, Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.24:0.60:0.41:0.57"] = 225, -- River's Heart, Valiance Landing Camp
				["0.24:0.60:0.21:0.51:0.22:0.39"] = 208, -- River's Heart, Fizzcrank Airstrip, Valiance Keep
				["0.24:0.60:0.21:0.51:0.17:0.47"] = 169, -- River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.24:0.60:0.28:0.72"] = 141, -- River's Heart, Death's Rise
				["0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54"] = 604, -- River's Heart, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.24:0.60:0.18:0.60"] = 65, -- River's Heart, Nesingwary Base Camp
				["0.24:0.60:0.52:0.62:0.62:0.64"] = 370, -- River's Heart, Dalaran, K3
				["0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60"] = 498, -- River's Heart, Dalaran, Ebon Watch, The Argent Stand
				["0.24:0.60:0.52:0.62:0.64:0.58"] = 402, -- River's Heart, Dalaran, Ebon Watch
				["0.24:0.60:0.21:0.51:0.29:0.43"] = 199, -- River's Heart, Fizzcrank Airstrip, Unu'pe
				["0.24:0.60:0.21:0.51:0.42:0.47"] = 302, -- River's Heart, Fizzcrank Airstrip, Stars' Rest
				["0.24:0.60:0.52:0.62:0.46:0.54:0.60:0.48:0.69:0.58"] = 689, -- River's Heart, Dalaran, Fordragon Hold, Wintergarde Keep, Light's Breach
				["0.24:0.60:0.41:0.57:0.46:0.54:0.60:0.48:0.76:0.33"] = 608, -- River's Heart, Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Westguard Keep
				["0.24:0.60:0.52:0.62:0.54:0.48:0.42:0.47"] = 566, -- River's Heart, Dalaran, Wyrmrest Temple, Stars' Rest
				["0.24:0.60:0.21:0.51:0.42:0.47:0.54:0.48"] = 430, -- River's Heart, Fizzcrank Airstrip, Stars' Rest, Wyrmrest Temple
				["0.24:0.60:0.52:0.62:0.54:0.48"] = 468, -- River's Heart, Dalaran, Wyrmrest Temple
				["0.24:0.60:0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29"] = 651, -- River's Heart, Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua
				["0.24:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46"] = 589, -- Flussnabel, Landebahn Kurbelzisch, Sternenruh, Feste Wintergarde, Ammertannhütte
				["0.24:0.60:0.52:0.62:0.62:0.64:0.72:0.71"] = 520, -- River's Heart, Dalaran, K3, Dun Nifflelem
				["0.24:0.60:0.21:0.51:0.29:0.43:0.49:0.42"] = 376, -- River's Heart, Fizzcrank Airstrip, Unu'pe, Moa'ki
				["0.24:0.60:0.41:0.57:0.46:0.54:0.60:0.48:0.73:0.46"] = 534, -- 강의 심장부 (숄라자르 분지), 용맹의 주둔지 (겨울손아귀 호수), 폴드라곤 요새 (용의 안식처), 윈터가드 성채 (용의 안식처), 호박빛소나무 오두막 (회색 구릉지), 호박빛소나무 오두막 (회색 구릉지)
				["0.24:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.64:0.58:0.62:0.64"] = 629, -- River's Heart, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Ebon Watch, K3
				["0.24:0.60:0.52:0.62:0.56:0.64:0.57:0.67"] = 393, -- River's Heart, Dalaran, The Argent Vanguard, Frosthold
				["0.24:0.60:0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46"] = 594, -- Flussnabel, Dalaran, Schwarze Wacht, Lichtbresche, Ammertannhütte
				["0.24:0.60:0.52:0.62:0.64:0.58:0.69:0.58"] = 469, -- River's Heart, Dalaran, Ebon Watch, Light's Breach
				["0.24:0.60:0.52:0.62:0.59:0.57"] = 363, -- River's Heart, Dalaran, Windrunner's Overlook
				["0.24:0.60:0.21:0.51:0.42:0.47:0.46:0.54"] = 417, -- River's Heart, Fizzcrank Airstrip, Stars' Rest, Fordragon Hold
				["0.24:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.76:0.33"] = 663, -- River's Heart, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Westguard Keep
				["0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62"] = 559, -- River's Heart, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 639, -- River's Heart, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.24:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.76:0.33:0.88:0.28"] = 766, -- River's Heart, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.24:0.60:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 538, -- River's Heart, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.24:0.60:0.21:0.51:0.42:0.47:0.49:0.42"] = 403, -- River's Heart, Fizzcrank Airstrip, Stars' Rest, Moa'ki
				["0.24:0.60:0.41:0.57:0.46:0.54"] = 298, -- River's Heart, Valiance Landing Camp, Fordragon Hold
				["0.24:0.60:0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 490, -- River's Heart, Dalaran, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.24:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46:0.88:0.40"] = 760, -- Flussnabel, Landebahn Kurbelzisch, Sternenruh, Feste Wintergarde, Ammertannhütte, Fort Wildervar
				["0.24:0.60:0.52:0.62:0.52:0.66"] = 344, -- River's Heart, Dalaran, Crusaders' Pinnacle
				["0.24:0.60:0.28:0.72:0.38:0.79"] = 280, -- River's Heart, Death's Rise, The Shadow Vault
				["0.24:0.60:0.41:0.57:0.42:0.47:0.49:0.42:0.74:0.29"] = 723, -- River's Heart, Valiance Landing Camp, Stars' Rest, Moa'ki, Kamagua
				["0.24:0.60:0.41:0.57:0.46:0.54:0.54:0.48"] = 395, -- River's Heart, Valiance Landing Camp, Fordragon Hold, Wyrmrest Temple
				["0.24:0.60:0.28:0.72:0.57:0.79:0.64:0.81"] = 528, -- Слияние рек, Уступ Смерти, Приют Глыбоскала, Ульдуар
				["0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 789, -- River's Heart, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Ulduar
				["0.24:0.60:0.41:0.57:0.46:0.54:0.60:0.48"] = 428, -- River's Heart, Valiance Landing Camp, Fordragon Hold, Wintergarde Keep
				["0.24:0.60:0.28:0.72:0.57:0.79"] = 461, -- River's Heart, Death's Rise, Bouldercrag's Refuge
				["0.24:0.60:0.52:0.62:0.49:0.42"] = 525, -- River's Heart, Dalaran, Moa'ki
				["0.24:0.60:0.21:0.51:0.42:0.47:0.60:0.48"] = 482, -- River's Heart, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep
				["0.24:0.60:0.41:0.57:0.42:0.47:0.49:0.42"] = 448, -- River's Heart, Valiance Landing Camp, Stars' Rest, Moa'ki
				["0.24:0.60:0.52:0.62:0.62:0.64:0.57:0.67"] = 434, -- River's Heart, Dalaran, K3, Frosthold
				["0.24:0.60:0.21:0.51:0.42:0.47:0.49:0.42:0.74:0.29"] = 678, -- River's Heart, Fizzcrank Airstrip, Stars' Rest, Moa'ki, Kamagua
				["0.24:0.60:0.21:0.51:0.29:0.43:0.49:0.42:0.74:0.29:0.88:0.28"] = 771, -- River's Heart, Fizzcrank Airstrip, Unu'pe, Moa'ki, Kamagua, Valgarde Port
				["0.24:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.69:0.58:0.72:0.60"] = 670, -- Flussnabel, Landebahn Kurbelzisch, Sternenruh, Feste Wintergarde, Lichtbresche, Argentumwache
				["0.24:0.60:0.52:0.62:0.46:0.54"] = 435, -- River's Heart, Dalaran, Fordragon Hold
				["0.24:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.73:0.46:0.83:0.54"] = 709, -- Flussnabel, Landebahn Kurbelzisch, Sternenruh, Feste Wintergarde, Ammertannhütte, Westfallbrigade
				["0.24:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.69:0.58:0.72:0.60:0.78:0.62"] = 730, -- Flussnabel, Landebahn Kurbelzisch, Sternenruh, Feste Wintergarde, Lichtbresche, Argentumwache, Zim'Torga
				["0.24:0.60:0.41:0.57:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 686, -- River's Heart, Valiance Landing Camp, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.24:0.60:0.21:0.51:0.29:0.43:0.49:0.42:0.60:0.48"] = 503, -- River's Heart, Fizzcrank Airstrip, Unu'pe, Moa'ki, Wintergarde Keep
				["0.24:0.60:0.28:0.72:0.49:0.79"] = 394, -- River's Heart, Death's Rise, Argent Tournament Grounds
				["0.24:0.60:0.52:0.62:0.49:0.79"] = 473, -- River's Heart, Dalaran, Argent Tournament Grounds
				["0.24:0.60:0.41:0.57:0.38:0.79"] = 466, -- River's Heart, Valiance Landing Camp, The Shadow Vault
				["0.24:0.60:0.52:0.62:0.62:0.64:0.57:0.67:0.57:0.79"] = 531, -- River's Heart, Dalaran, K3, Frosthold, Bouldercrag's Refuge
				["0.24:0.60:0.21:0.51:0.42:0.47:0.60:0.48:0.69:0.58"] = 606, -- River's Heart, Fizzcrank Airstrip, Stars' Rest, Wintergarde Keep, Light's Breach
				["0.24:0.60:0.41:0.57:0.46:0.54:0.60:0.48:0.73:0.46:0.83:0.54"] = 655, -- River's Heart, Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.24:0.60:0.52:0.62:0.49:0.42:0.74:0.29"] = 797, -- River's Heart, Dalaran, Moa'ki, Kamagua
				["0.24:0.60:0.52:0.62:0.54:0.48:0.42:0.47:0.29:0.43"] = 709, -- River's Heart, Dalaran, Wyrmrest Temple, Stars' Rest, Unu'pe
				["0.24:0.60:0.41:0.57:0.42:0.47:0.29:0.43"] = 491, -- River's Heart, Valiance Landing Camp, Stars' Rest, Unu'pe
				["0.24:0.60:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40"] = 732, -- River's Heart, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar
				["0.24:0.60:0.52:0.62:0.62:0.64:0.57:0.67:0.64:0.81"] = 579, -- River's Heart, Dalaran, K3, Frosthold, Ulduar
				["0.24:0.60:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.88:0.28"] = 759, -- River's Heart, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Valgarde Port

				----------------------------------------------------------------------
				-- Alliance: The Storm Peaks
				----------------------------------------------------------------------

				-- Alliance: The Storm Peaks: Bouldercrag's Refuge
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62"] = 143, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran
				["0.57:0.79:0.64:0.81"] = 44, -- Bouldercrag's Refuge, Ulduar
				["0.57:0.79:0.57:0.67:0.62:0.64"] = 127, -- Bouldercrag's Refuge, Frosthold, K3
				["0.57:0.79:0.57:0.67"] = 80, -- Bouldercrag's Refuge, Frosthold
				["0.57:0.79:0.51:0.21:0.52:0.66:0.28:0.72"] = 297, -- Bouldercrag's Refuge, Argent Tournament Grounds, Crusaders' Pinnacle, Death's Rise
				["0.57:0.79:0.64:0.81:0.78:0.62:0.82:0.69"] = 251, -- Bouldercrag's Refuge, Ulduar, Zim'Torga, Gundrak
				["0.57:0.79:0.64:0.81:0.72:0.71"] = 149, -- Bouldercrag's Refuge, Ulduar, Dun Nifflelem
				["0.57:0.79:0.64:0.81:0.72:0.71:0.62:0.64:0.52:0.62"] = 306, -- Bouldercrag's Refuge, Ulduar, Dun Nifflelem, K3, Dalaran
				["0.57:0.79:0.57:0.67:0.56:0.64"] = 112, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.29:0.43"] = 401, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Unu'pe
				["0.57:0.79:0.57:0.67:0.62:0.64:0.52:0.62"] = 198, -- Bouldercrag's Refuge, Frosthold, K3, Dalaran
				["0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.69:0.58"] = 215, -- Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, Light's Breach
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54"] = 231, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold
				["0.57:0.79:0.64:0.81:0.78:0.62:0.83:0.54:0.88:0.40"] = 338, -- Bouldercrag's Refuge, Ulduar, Zim'Torga, Westfall Brigade, Fort Wildervar
				["0.57:0.79:0.57:0.67:0.62:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 585, -- Bouldercrag's Refuge, Frosthold, K3, Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.57:0.79:0.57:0.67:0.62:0.64:0.72:0.71"] = 227, -- Bergfels' Zuflucht, Eisfestung, K3, Dun Niffelem
				["0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40:0.88:0.28"] = 463, -- Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar, Valgarde Port
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.66"] = 139, -- Bergfels' Zuflucht, Eisfestung, Die Argentumvorhut, Kreuzfahrerturm
				["0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39"] = 454, -- Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.66:0.28:0.72"] = 305, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Crusaders' Pinnacle, Death's Rise
				["0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.69:0.58:0.73:0.46"] = 299, -- Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, Light's Breach, Amberpine Lodge
				["0.57:0.79:0.57:0.67:0.62:0.64:0.52:0.62:0.24:0.60"] = 399, -- Bouldercrag's Refuge, Frosthold, K3, Dalaran, River's Heart
				["0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.54:0.48"] = 261, -- Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, Wyrmrest Temple
				["0.57:0.79:0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60"] = 567, -- Bouldercrag's Refuge, Ulduar, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, River's Heart
				["0.57:0.79:0.28:0.72"] = 191, -- Bouldercrag's Refuge, Death's Rise
				["0.57:0.79:0.38:0.79"] = 114, -- Bouldercrag's Refuge, The Shadow Vault
				["0.57:0.79:0.56:0.64:0.52:0.62"] = 278, -- Bergfels' Zuflucht, Die Argentumvorhut, Dalaran
				["0.57:0.79:0.28:0.72:0.24:0.60"] = 307, -- Bouldercrag's Refuge, Death's Rise, River's Heart
				["0.57:0.79:0.64:0.81:0.78:0.62"] = 198, -- Bouldercrag's Refuge, Ulduar, Zim'Torga
				["0.57:0.79:0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.62:0.64"] = 342, -- Bouldercrag's Refuge, Ulduar, Zim'Torga, The Argent Stand, Ebon Watch, K3
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60:0.18:0.60"] = 377, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, River's Heart, Nesingwary Base Camp
				["0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58"] = 171, -- Bouldercrag's Refuge, Frosthold, K3, Ebon Watch
				["0.57:0.79:0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 601, -- Bergfels' Zuflucht, Ulduar, Zim'Torga, Argentumwache, Schwarze Wacht, Dalaran, Flussnabel, Nesingwarys Basislager
				["0.57:0.79:0.64:0.81:0.78:0.62:0.83:0.54"] = 253, -- Bergfels' Zuflucht, Ulduar, Zim'Torga, Westfallbrigade
				["0.57:0.79:0.64:0.81:0.78:0.62:0.72:0.60"] = 250, -- Bergfels' Zuflucht, Ulduar, Zim'Torga, Argentumwache
				["0.57:0.79:0.28:0.72:0.18:0.60"] = 308, -- Bouldercrag's Refuge, Death's Rise, Nesingwary Base Camp
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60"] = 343, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, River's Heart
				["0.57:0.79:0.64:0.81:0.78:0.62:0.83:0.54:0.88:0.40:0.88:0.28"] = 412, -- Bouldercrag's Refuge, Ulduar, Zim'Torga, Westfall Brigade, Fort Wildervar, Valgarde Port
				["0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.72:0.60"] = 234, -- Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, The Argent Stand
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.59:0.57"] = 183, -- Bergfels' Zuflucht, Eisfestung, Die Argentumvorhut, Dalaran, Windläufers Warte
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.66:0.41:0.57"] = 244, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Crusaders' Pinnacle, Valiance Landing Camp
				["0.57:0.79:0.57:0.67:0.62:0.64:0.59:0.57"] = 181, -- Bouldercrag's Refuge, Frosthold, K3, Windrunner's Overlook
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 510, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39"] = 433, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep
				["0.57:0.79:0.28:0.72:0.24:0.60:0.21:0.51:0.22:0.39"] = 438, -- 布德克拉格庇护所，风暴峭壁, 死亡高地，冰冠冰川, 河流之心，索拉查盆地, 菲兹兰克机场，北风苔原, 无畏要塞，北风苔原
				["0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33:0.74:0.29"] = 401, -- Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, Wintergarde Keep, Westguard Keep, Kamagua
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.41:0.57"] = 245, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, Valiance Landing Camp
				["0.57:0.79:0.41:0.57"] = 253, -- Bouldercrag's Refuge, Valiance Landing Camp
				["0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33:0.88:0.28"] = 420, -- Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48"] = 232, -- Bergfels' Zuflucht, Eisfestung, K3, Schwarze Wacht, Feste Wintergarde
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47"] = 305, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.49:0.42"] = 291, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, Moa'ki
				["0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 531, -- Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.57:0.79:0.52:0.66"] = 234, -- Bergfels' Zuflucht, Kreuzfahrerturm
				["0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47"] = 327, -- Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest
				["0.57:0.79:0.56:0.64:0.52:0.62:0.62:0.64"] = 323, -- Bouldercrag's Refuge, The Argent Vanguard, Dalaran, K3
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.54:0.48:0.42:0.47:0.22:0.39"] = 445, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, Wyrmrest Temple, Stars' Rest, Valiance Keep
				["0.57:0.79:0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62"] = 369, -- Bouldercrag's Refuge, Ulduar, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran
				["0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.69:0.58:0.73:0.46:0.88:0.40"] = 414, -- Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, Light's Breach, Amberpine Lodge, Fort Wildervar
				["0.57:0.79:0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33"] = 352, -- Bouldercrag's Refuge, Frosthold, K3, Ebon Watch, Wintergarde Keep, Westguard Keep
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.41:0.57:0.28:0.72"] = 411, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, Valiance Landing Camp, Death's Rise
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51"] = 404, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, River's Heart, Fizzcrank Airstrip
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47"] = 448, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 484, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.57:0.79:0.51:0.21:0.52:0.66"] = 131, -- Bouldercrag's Refuge, Argent Tournament Grounds, Crusaders' Pinnacle
				["0.57:0.79:0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46:0.76:0.33:0.74:0.29"] = 490, -- Bouldercrag's Refuge, Ulduar, Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge, Westguard Keep, Kamagua
				["0.57:0.79:0.51:0.21"] = 61, -- Bouldercrag's Refuge, Argent Tournament Grounds
				["0.57:0.79:0.57:0.67:0.62:0.64:0.72:0.71:0.78:0.62"] = 316, -- Bouldercrag's Refuge, Frosthold, K3, Dun Nifflelem, Zim'Torga
				["0.57:0.79:0.51:0.21:0.52:0.66:0.41:0.57"] = 236, -- Bouldercrag's Refuge, Argent Tournament Grounds, Crusaders' Pinnacle, Valiance Landing Camp
				["0.57:0.79:0.28:0.72:0.24:0.60:0.21:0.51"] = 368, -- Bouldercrag's Refuge, Death's Rise, River's Heart, Fizzcrank Airstrip
				["0.57:0.79:0.28:0.72:0.24:0.60:0.21:0.51:0.17:0.47"] = 412, -- Bouldercrag's Refuge, Death's Rise, River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.57:0.79:0.28:0.72:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 448, -- Bouldercrag's Refuge, Death's Rise, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.54:0.48"] = 253, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, Wyrmrest Temple
				["0.57:0.79:0.51:0.21:0.52:0.62"] = 197, -- Bouldercrag's Refuge, Argent Tournament Grounds, Dalaran
				["0.57:0.79:0.51:0.21:0.52:0.62:0.62:0.64:0.72:0.71"] = 341, -- Bouldercrag's Refuge, Argent Tournament Grounds, Dalaran, K3, Dun Nifflelem
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51"] = 430, -- Bouldercrag's Refuge, Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip
				["0.57:0.79:0.57:0.67:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54"] = 343, -- Bergfels' Zuflucht, Eisfestung, Die Argentumvorhut, Dalaran, Schwarze Wacht, Argentumwache, Westfallbrigade
				["0.57:0.79:0.51:0.21:0.52:0.66:0.56:0.64:0.52:0.62"] = 194, -- Bouldercrag's Refuge, Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran
				["0.57:0.79:0.57:0.67:0.62:0.64:0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46"] = 428, -- Приют Глыбоскала, Ледяная крепость, К-3, Даларан, Храм Драконьего Покоя, Крепость Стражей Зимы, Приют Янтарной Сосны
				["0.57:0.79:0.57:0.67:0.62:0.64:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 539, -- Bouldercrag's Refuge, Frosthold, K3, Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.57:0.79:0.51:0.21:0.52:0.62:0.62:0.64"] = 241, -- Приют Глыбоскала, Ристалище Серебряного турнира, Даларан, К-3, К-3

				-- Alliance: The Storm Peaks: Dun Nifflelem
				["0.72:0.71:0.64:0.81:0.57:0.79"] = 133, -- Dun Nifflelem, Ulduar, Bouldercrag's Refuge
				["0.72:0.71:0.62:0.64"] = 88, -- Dun Nifflelem, K3
				["0.72:0.71:0.62:0.64:0.52:0.62:0.24:0.60"] = 359, -- Dun Nifflelem, K3, Dalaran, River's Heart
				["0.72:0.71:0.62:0.64:0.57:0.67"] = 131, -- Dun Nifflelem, K3, Frosthold
				["0.72:0.71:0.62:0.64:0.52:0.62"] = 159, -- Dun Nifflelem, K3, Dalaran
				["0.72:0.71:0.62:0.64:0.57:0.67:0.56:0.64"] = 164, -- Dun Nifflelem, K3, Frosthold, The Argent Vanguard
				["0.72:0.71:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62"] = 261, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.29:0.43"] = 384, -- Dun Nifflelem, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Unu'pe
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47"] = 288, -- Dun Nifflelem, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest
				["0.72:0.71:0.62:0.64:0.57:0.67:0.57:0.79"] = 195, -- Dun Nifflelem, K3, Frosthold, Bouldercrag's Refuge
				["0.72:0.71:0.62:0.64:0.52:0.62:0.52:0.66"] = 187, -- Дун Ниффелем, К-3, Даларан, Вершина Рыцарей
				["0.72:0.71:0.78:0.62:0.83:0.54:0.88:0.40"] = 230, -- Dun Nifflelem, Zim'Torga, Westfall Brigade, Fort Wildervar
				["0.72:0.71:0.62:0.64:0.64:0.58:0.60:0.48"] = 193, -- Dun Nifflelem, K3, Ebon Watch, Wintergarde Keep
				["0.72:0.71:0.64:0.81"] = 85, -- Dun Nifflelem, Ulduar
				["0.72:0.71:0.62:0.64:0.57:0.67:0.56:0.64:0.52:0.66:0.28:0.72"] = 358, -- Dun Nifflelem, K3, Frosthold, The Argent Vanguard, Crusaders' Pinnacle, Death's Rise
				["0.72:0.71:0.62:0.64:0.57:0.67:0.56:0.64:0.52:0.66"] = 190, -- Dun Nifflelem, K3, Frosthold, The Argent Vanguard, Crusaders' Pinnacle
				["0.72:0.71:0.62:0.64:0.59:0.57:0.60:0.48:0.54:0.48"] = 264, -- Dun Nifflelem, K3, Windrunner's Overlook, Wintergarde Keep, Wyrmrest Temple
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48"] = 222, -- Dun Niffelem, K3, Schwarze Wacht, Wyrmruhtempel
				["0.72:0.71:0.78:0.62:0.83:0.54:0.73:0.46:0.76:0.33:0.74:0.29"] = 356, -- Dun Niffelem, Zim'Torga, Westfallbrigade, Ammertannhütte, Westwacht, Kamagua
				["0.72:0.71:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60"] = 459, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, River's Heart
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 493, -- Dun Nifflelem, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.72:0.71:0.78:0.62:0.83:0.54:0.73:0.46"] = 224, -- Dun Nifflelem, Zim'Torga, Westfall Brigade, Amberpine Lodge
				["0.72:0.71:0.78:0.62:0.83:0.54:0.88:0.40:0.88:0.28"] = 303, -- Dun Nifflelem, Zim'Torga, Westfall Brigade, Fort Wildervar, Valgarde Port
				["0.72:0.71:0.62:0.64:0.52:0.62:0.24:0.60:0.18:0.60"] = 395, -- Dun Nifflelem, K3, Dalaran, River's Heart, Nesingwary Base Camp
				["0.72:0.71:0.78:0.62:0.83:0.54:0.73:0.46:0.76:0.33"] = 306, -- Dun Nifflelem, Zim'Torga, Westfall Brigade, Amberpine Lodge, Westguard Keep
				["0.72:0.71:0.62:0.64:0.52:0.62:0.41:0.57"] = 263, -- Dun Nifflelem, K3, Dalaran, Valiance Landing Camp
				["0.72:0.71:0.62:0.64:0.52:0.62:0.24:0.60:0.28:0.72"] = 444, -- 丹尼芬雷，风暴峭壁, K3，风暴峭壁, 达拉然, 河流之心，索拉查盆地, 死亡高地，冰冠冰川
				["0.72:0.71:0.78:0.62:0.72:0.60"] = 142, -- Dun Nifflelem, Zim'Torga, The Argent Stand
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51"] = 413, -- Dun Nifflelem, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip
				["0.72:0.71:0.62:0.64:0.64:0.58:0.46:0.54"] = 242, -- Dun Nifflelem, K3, Ebon Watch, Fordragon Hold
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.49:0.42"] = 275, -- Dun Nifflelem, K3, Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39"] = 415, -- Dun Nifflelem, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep
				["0.72:0.71:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66"] = 287, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.72:0.71:0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33:0.74:0.29"] = 363, -- Dun Nifflelem, K3, Ebon Watch, Wintergarde Keep, Westguard Keep, Kamagua
				["0.72:0.71:0.78:0.62:0.82:0.69"] = 143, -- Dun Nifflelem, Zim'Torga, Gundrak
				["0.72:0.71:0.78:0.62"] = 89, -- Dun Nifflelem, Zim'Torga
				["0.72:0.71:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64"] = 281, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard
				["0.72:0.71:0.62:0.64:0.64:0.58:0.69:0.58:0.73:0.46"] = 260, -- Dun Niffelem, K3, Schwarze Wacht, Lichtbresche, Ammertannhütte
				["0.72:0.71:0.62:0.64:0.52:0.62:0.54:0.48"] = 270, -- Dun Niffelem, K3, Dalaran, Wyrmruhtempel
				["0.72:0.71:0.64:0.81:0.57:0.79:0.38:0.79"] = 246, -- Dun Niffelem, Ulduar, Bergfels' Zuflucht, Das Schattengewölbe
				["0.72:0.71:0.64:0.81:0.57:0.79:0.28:0.72"] = 323, -- Dun Nifflelem, Ulduar, Bouldercrag's Refuge, Death's Rise
				["0.72:0.71:0.62:0.64:0.57:0.67:0.57:0.79:0.38:0.79"] = 309, -- Dun Nifflelem, K3, Frosthold, Bouldercrag's Refuge, The Shadow Vault
				["0.72:0.71:0.62:0.64:0.64:0.58"] = 131, -- Dun Nifflelem, K3, Guet d'Ébène
				["0.72:0.71:0.62:0.64:0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46"] = 388, -- Dun Nifflelem, K3, Dalaran, Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge
				["0.72:0.71:0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33"] = 312, -- Dun Nifflelem, K3, Ebon Watch, Wintergarde Keep, Westguard Keep
				["0.72:0.71:0.62:0.64:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 501, -- Dun Nifflelem, K3, Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.72:0.71:0.78:0.62:0.72:0.60:0.69:0.58"] = 165, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Light's Breach
				["0.72:0.71:0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62"] = 251, -- Dun Nifflelem, Ulduar, Frosthold, The Argent Vanguard, Dalaran
				["0.72:0.71:0.78:0.62:0.83:0.54"] = 146, -- Dun Nifflelem, Zim'Torga, Westfall Brigade
				["0.72:0.71:0.62:0.64:0.52:0.62:0.52:0.66:0.38:0.79"] = 310, -- Dun Nifflelem, K3, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 512, -- Dun Nifflelem, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.72:0.71:0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46"] = 248, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge
				["0.72:0.71:0.62:0.64:0.59:0.57:0.60:0.48:0.49:0.42"] = 309, -- Dun Nifflelem, K3, Windrunner's Overlook, Wintergarde Keep, Moa'ki
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 456, -- Dun Nifflelem, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.72:0.71:0.62:0.64:0.59:0.57"] = 141, -- Dun Nifflelem, K3, Windrunner's Overlook
				["0.72:0.71:0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33:0.88:0.28"] = 381, -- Dun Nifflelem, K3, Ebon Watch, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.72:0.71:0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46:0.88:0.40"] = 364, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge, Fort Wildervar
				["0.72:0.71:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 409, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39:0.17:0.47"] = 477, -- Dun Nifflelem, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep, Amber Ledge
				["0.72:0.71:0.62:0.64:0.64:0.58:0.60:0.48:0.73:0.46:0.88:0.40"] = 378, -- Dun Nifflelem, K3, Ebon Watch, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.72:0.71:0.62:0.64:0.57:0.67:0.56:0.64:0.38:0.79"] = 311, -- Dun Nifflelem, K3, Frosthold, The Argent Vanguard, The Shadow Vault
				["0.72:0.71:0.62:0.64:0.52:0.62:0.46:0.54"] = 248, -- Dun Nifflelem, K3, Dalaran, Fordragon Hold
				["0.72:0.71:0.78:0.62:0.83:0.54:0.73:0.46:0.76:0.33:0.88:0.28"] = 374, -- Dun Nifflelem, Zim'Torga, Westfall Brigade, Amberpine Lodge, Westguard Keep, Valgarde Port
				["0.72:0.71:0.64:0.81:0.57:0.67"] = 187, -- Dun Nifflelem, Ulduar, Frosthold
				["0.72:0.71:0.62:0.64:0.52:0.62:0.56:0.64"] = 181, -- Dun Nifflelem, K3, Dalaran, The Argent Vanguard
				["0.72:0.71:0.62:0.64:0.52:0.62:0.56:0.64:0.38:0.79"] = 328, -- Dun Nifflelem, K3, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.72:0.71:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48"] = 284, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple
				["0.72:0.71:0.62:0.64:0.64:0.58:0.60:0.48:0.73:0.46"] = 263, -- Dun Nifflelem, K3, Ebon Watch, Wintergarde Keep, Amberpine Lodge
				["0.72:0.71:0.62:0.64:0.52:0.62:0.41:0.57:0.28:0.72"] = 428, -- Dun Niffelem, K3, Dalaran, Valianzlager, Todesanhöhe
				["0.72:0.71:0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60"] = 451, -- Dun Nifflelem, Ulduar, Frosthold, The Argent Vanguard, Dalaran, River's Heart
				["0.72:0.71:0.62:0.64:0.59:0.57:0.60:0.48"] = 216, -- Dun Nifflelem, K3, Windrunner's Overlook, Wintergarde Keep
				["0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.49:0.42:0.74:0.29:0.88:0.28"] = 537, -- Dun Nifflelem, K3, Ebon Watch, Wyrmrest Temple, Moa'ki, Kamagua, Valgarde Port
				["0.72:0.71:0.64:0.81:0.57:0.67:0.56:0.64:0.38:0.79"] = 367, -- Dun Nifflelem, Ulduar, Frosthold, The Argent Vanguard, The Shadow Vault
				["0.72:0.71:0.62:0.64:0.64:0.58:0.69:0.58"] = 176, -- Dun Nifflelem, K3, Ebon Watch, Light's Breach
				["0.72:0.71:0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46:0.76:0.33:0.74:0.29"] = 381, -- Dun Nifflelem, Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge, Westguard Keep, Kamagua
				["0.72:0.71:0.64:0.81:0.57:0.79:0.51:0.21"] = 193, -- Dun Nifflelem, Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.72:0.71:0.62:0.64:0.57:0.67:0.57:0.79:0.51:0.21"] = 256, -- Dun Nifflelem, K3, Frosthold, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.72:0.71:0.62:0.64:0.52:0.62:0.49:0.79"] = 273, -- Dun Nifflelem, K3, Dalaran, Argent Tournament Grounds
				["0.72:0.71:0.62:0.64:0.52:0.62:0.49:0.42"] = 308, -- Dun Nifflelem, K3, Dalaran, Moa'ki
				["0.72:0.71:0.62:0.64:0.57:0.67:0.57:0.79:0.28:0.72"] = 385, -- Dun Nifflelem, K3, Frosthold, Bouldercrag's Refuge, Death's Rise
				["0.72:0.71:0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.66:0.49:0.79"] = 343, -- Dun Nifflelem, Ulduar, Frosthold, The Argent Vanguard, Crusaders' Pinnacle, Argent Tournament Grounds
				["0.72:0.71:0.62:0.64:0.52:0.62:0.54:0.48:0.42:0.47"] = 336, -- Dun Nifflelem, K3, Dalaran, Wyrmrest Temple, Stars' Rest

				-- Alliance: The Storm Peaks: Frosthold
				["0.57:0.67:0.56:0.64:0.52:0.66"] = 61, -- Frosthold, The Argent Vanguard, Crusaders' Pinnacle
				["0.57:0.67:0.62:0.64"] = 49, -- Frosthold, K3
				["0.57:0.67:0.56:0.64:0.52:0.62"] = 64, -- Frosthold, The Argent Vanguard, Dalaran
				["0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47"] = 369, -- Frosthold, The Argent Vanguard, Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.29:0.43"] = 323, -- Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Unu'pe
				["0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51"] = 326, -- Frosthold, The Argent Vanguard, Dalaran, River's Heart, Fizzcrank Airstrip
				["0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33"] = 273, -- Frosthold, K3, Ebon Watch, Wintergarde Keep, Westguard Keep
				["0.57:0.67:0.57:0.79"] = 65, -- Frosthold, Bouldercrag's Refuge
				["0.57:0.67:0.62:0.64:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 250, -- Frosthold, K3, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39"] = 354, -- Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep
				["0.57:0.67:0.64:0.81:0.72:0.71"] = 201, -- Frosthold, Ulduar, Dun Nifflelem
				["0.57:0.67:0.62:0.64:0.64:0.58:0.72:0.60"] = 156, -- Frosthold, K3, Ebon Watch, The Argent Stand
				["0.57:0.67:0.62:0.64:0.72:0.71"] = 149, -- Frosthold, K3, Dun Nifflelem
				["0.57:0.67:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51"] = 374, -- Frosthold, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip
				["0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60"] = 264, -- Frosthold, The Argent Vanguard, Dalaran, River's Heart
				["0.57:0.67:0.62:0.64:0.52:0.62"] = 120, -- Frosthold, K3, Dalaran
				["0.57:0.67:0.56:0.64"] = 34, -- Fort du Givre, L'avant-garde d'Argent, L'avant-garde d'Argent
				["0.57:0.67:0.56:0.64:0.52:0.62:0.54:0.48:0.42:0.47:0.29:0.43"] = 336, -- Frosthold, The Argent Vanguard, Dalaran, Wyrmrest Temple, Stars' Rest, Unu'pe
				["0.57:0.67:0.62:0.64:0.52:0.62:0.24:0.60"] = 320, -- Frosthold, K3, Dalaran, River's Heart
				["0.57:0.67:0.62:0.64:0.64:0.58:0.54:0.48"] = 183, -- 冰霜堡，风暴峭壁, K3，风暴峭壁, 黑锋哨站，祖达克, 龙眠神殿，龙骨荒野
				["0.57:0.67:0.62:0.64:0.64:0.58:0.69:0.58:0.73:0.46"] = 220, -- Frosthold, K3, Ebon Watch, Light's Breach, Amberpine Lodge
				["0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47"] = 226, -- Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest
				["0.57:0.67:0.62:0.64:0.64:0.58:0.72:0.60:0.78:0.62"] = 196, -- Frosthold, K3, Ebon Watch, The Argent Stand, Zim'Torga
				["0.57:0.67:0.64:0.81"] = 98, -- Frosthold, Ulduar
				["0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51"] = 352, -- Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip
				["0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33:0.88:0.28"] = 342, -- Frosthold, K3, Ebon Watch, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.57:0.67:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39"] = 375, -- Frosthold, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep
				["0.57:0.67:0.56:0.64:0.52:0.66:0.28:0.72"] = 228, -- Frosthold, The Argent Vanguard, Crusaders' Pinnacle, Death's Rise
				["0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54"] = 153, -- Eisfestung, Die Argentumvorhut, Dalaran, Feste Fordragon
				["0.57:0.67:0.62:0.64:0.59:0.57"] = 102, -- Frosthold, K3, Windrunner's Overlook
				["0.57:0.67:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 288, -- Frosthold, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.57:0.67:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54"] = 264, -- Frosthold, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.57:0.67:0.56:0.64:0.52:0.62:0.49:0.42"] = 212, -- Frosthold, The Argent Vanguard, Dalaran, Moa'ki
				["0.57:0.67:0.62:0.64:0.64:0.58"] = 93, -- Frosthold, K3, Ebon Watch
				["0.57:0.67:0.62:0.64:0.64:0.58:0.69:0.58"] = 137, -- Frosthold, K3, Ebon Watch, Light's Breach
				["0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 405, -- Frosthold, The Argent Vanguard, Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.57:0.67:0.56:0.64:0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46"] = 293, -- Frosthold, The Argent Vanguard, Dalaran, Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge
				["0.57:0.67:0.56:0.64:0.52:0.62:0.41:0.57"] = 167, -- Frosthold, The Argent Vanguard, Dalaran, Valiance Landing Camp
				["0.57:0.67:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 454, -- Frosthold, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.57:0.67:0.56:0.64:0.52:0.62:0.54:0.48:0.60:0.48:0.76:0.33:0.88:0.28"] = 411, -- Frosthold, The Argent Vanguard, Dalaran, Wyrmrest Temple, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.57:0.67:0.57:0.79:0.38:0.79"] = 178, -- Frosthold, Bouldercrag's Refuge, The Shadow Vault
				["0.57:0.67:0.56:0.64:0.38:0.79"] = 180, -- Eisfestung, Die Argentumvorhut, Das Schattengewölbe
				["0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 432, -- Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.57:0.67:0.56:0.64:0.52:0.66:0.41:0.57"] = 166, -- Frosthold, The Argent Vanguard, Crusaders' Pinnacle, Valiance Landing Camp
				["0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 452, -- Eisfestung, Die Argentumvorhut, Dalaran, Feste Fordragon, Sternenruh, Valianzfeste, Bernsteinflöz, Transitusschild
				["0.57:0.67:0.56:0.64:0.52:0.62:0.64:0.58:0.60:0.48:0.76:0.33:0.74:0.29"] = 361, -- Frosthold, The Argent Vanguard, Dalaran, Ebon Watch, Wintergarde Keep, Westguard Keep, Kamagua
				["0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33:0.74:0.29"] = 323, -- Frosthold, K3, Ebon Watch, Wintergarde Keep, Westguard Keep, Kamagua
				["0.57:0.67:0.62:0.64:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40"] = 312, -- Frosthold, K3, Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar
				["0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47"] = 395, -- Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.57:0.67:0.62:0.64:0.64:0.58:0.69:0.58:0.73:0.46:0.88:0.40"] = 336, -- Frosthold, K3, Ebon Watch, Light's Breach, Amberpine Lodge, Fort Wildervar
				["0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48"] = 153, -- Frosthold, K3, Ebon Watch, Wintergarde Keep
				["0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60:0.18:0.60"] = 299, -- Frosthold, The Argent Vanguard, Dalaran, River's Heart, Nesingwary Base Camp
				["0.57:0.67:0.64:0.81:0.78:0.62:0.82:0.69"] = 304, -- Frosthold, Ulduar, Zim'Torga, Gundrak
				["0.57:0.67:0.62:0.64:0.64:0.58:0.72:0.60:0.83:0.54"] = 226, -- Frosthold, K3, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.57:0.67:0.56:0.64:0.52:0.62:0.54:0.48"] = 174, -- Frosthold, The Argent Vanguard, Dalaran, Wyrmrest Temple
				["0.57:0.67:0.56:0.64:0.52:0.62:0.64:0.58:0.60:0.48:0.76:0.33"] = 311, -- Eisfestung, Die Argentumvorhut, Dalaran, Schwarze Wacht, Feste Wintergarde, Westwacht
				["0.57:0.67:0.62:0.64:0.59:0.57:0.60:0.48:0.73:0.46"] = 248, -- Eisfestung, K3, Windläufers Warte, Feste Wintergarde, Ammertannhütte
				["0.57:0.67:0.56:0.64:0.28:0.72"] = 257, -- Frosthold, The Argent Vanguard, Death's Rise
				["0.57:0.67:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62"] = 234, -- Frosthold, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.57:0.67:0.56:0.64:0.52:0.62:0.64:0.58"] = 130, -- Frosthold, The Argent Vanguard, Dalaran, Ebon Watch
				["0.57:0.67:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48"] = 180, -- Frosthold, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep
				["0.57:0.67:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46"] = 251, -- Frosthold, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge
				["0.57:0.67:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.73:0.46:0.88:0.40"] = 365, -- Frosthold, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.57:0.67:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33"] = 300, -- Frosthold, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep
				["0.57:0.67:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.74:0.29"] = 350, -- Frosthold, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Kamagua
				["0.57:0.67:0.56:0.64:0.52:0.62:0.59:0.57:0.60:0.48:0.76:0.33:0.88:0.28"] = 369, -- Frosthold, The Argent Vanguard, Dalaran, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.57:0.67:0.56:0.64:0.52:0.62:0.59:0.57"] = 105, -- Frosthold, The Argent Vanguard, Dalaran, Windrunner's Overlook
				["0.57:0.67:0.56:0.64:0.52:0.62:0.41:0.57:0.28:0.72"] = 332, -- Frosthold, The Argent Vanguard, Dalaran, Valiance Landing Camp, Death's Rise
				["0.57:0.67:0.56:0.64:0.52:0.62:0.64:0.58:0.72:0.60"] = 194, -- Frosthold, The Argent Vanguard, Dalaran, Ebon Watch, The Argent Stand
				["0.57:0.67:0.56:0.64:0.52:0.62:0.64:0.58:0.69:0.58"] = 174, -- Frosthold, The Argent Vanguard, Dalaran, Ebon Watch, Light's Breach
				["0.57:0.67:0.57:0.79:0.51:0.21"] = 126, -- Frosthold, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.57:0.67:0.62:0.64:0.52:0.62:0.41:0.57"] = 223, -- Frosthold, K3, Dalaran, Valiance Landing Camp
				["0.57:0.67:0.62:0.64:0.52:0.62:0.54:0.48:0.60:0.48:0.76:0.33:0.88:0.28"] = 467, -- Frosthold, K3, Dalaran, Wyrmrest Temple, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.57:0.67:0.57:0.79:0.51:0.21:0.52:0.62"] = 262, -- Frosthold, Bouldercrag's Refuge, Argent Tournament Grounds, Dalaran
				["0.57:0.67:0.56:0.64:0.52:0.66:0.49:0.79"] = 156, -- Frosthold, The Argent Vanguard, Crusaders' Pinnacle, Argent Tournament Grounds
				["0.57:0.67:0.57:0.79:0.28:0.72"] = 255, -- Frosthold, Bouldercrag's Refuge, Death's Rise
				["0.57:0.67:0.62:0.64:0.59:0.57:0.60:0.48:0.69:0.58:0.72:0.60"] = 302, -- Frosthold, K3, Windrunner's Overlook, Wintergarde Keep, Light's Breach, The Argent Stand
				["0.57:0.67:0.62:0.64:0.59:0.57:0.60:0.48:0.76:0.33:0.74:0.29"] = 347, -- Frosthold, K3, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Kamagua
				["0.57:0.67:0.56:0.64:0.52:0.62:0.49:0.79"] = 179, -- Frosthold, The Argent Vanguard, Dalaran, Argent Tournament Grounds
				["0.57:0.67:0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62"] = 422, -- Frosthold, Ulduar, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran
				["0.57:0.67:0.56:0.64:0.52:0.62:0.54:0.48:0.60:0.48:0.76:0.33"] = 342, -- Frosthold, The Argent Vanguard, Dalaran, Wyrmrest Temple, Wintergarde Keep, Westguard Keep
				["0.57:0.67:0.62:0.64:0.52:0.62:0.49:0.79"] = 234, -- Frosthold, K3, Dalaran, Argent Tournament Grounds
				["0.57:0.67:0.62:0.64:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 462, -- Frosthold, K3, Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.57:0.67:0.62:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.29:0.43"] = 378, -- Frosthold, K3, Dalaran, Fordragon Hold, Stars' Rest, Unu'pe
				["0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48:0.73:0.46"] = 224, -- Frosthold, K3, Ebon Watch, Wintergarde Keep, Amberpine Lodge

				-- Alliance: The Storm Peaks: K3
				["0.62:0.64:0.57:0.67"] = 43, -- K3, Frosthold
				["0.62:0.64:0.64:0.58"] = 44, -- K3, Ebon Watch
				["0.62:0.64:0.59:0.57"] = 54, -- K3, Windrunner's Overlook
				["0.62:0.64:0.52:0.62"] = 72, -- K3, Dalaran
				["0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39"] = 327, -- K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep
				["0.62:0.64:0.57:0.67:0.56:0.64"] = 77, -- K3, Frosthold, The Argent Vanguard
				["0.62:0.64:0.64:0.58:0.69:0.58:0.73:0.46"] = 172, -- K3, Ebon Watch, Light's Breach, Amberpine Lodge
				["0.62:0.64:0.64:0.58:0.60:0.48"] = 105, -- K3, Ebon Watch, Wintergarde Keep
				["0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33"] = 225, -- K3, Ebon Watch, Wintergarde Keep, Westguard Keep
				["0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33:0.88:0.28"] = 293, -- K3, Ebon Watch, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.62:0.64:0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40"] = 263, -- K3, Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar
				["0.62:0.64:0.59:0.57:0.60:0.48:0.42:0.47:0.22:0.39"] = 364, -- K3, Windrunner's Overlook, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.62:0.64:0.64:0.58:0.69:0.58"] = 88, -- K3, Ebon Watch, Light's Breach
				["0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47"] = 201, -- K3, Ebon Watch, Wyrmrest Temple, Stars' Rest
				["0.62:0.64:0.59:0.57:0.60:0.48:0.76:0.33"] = 249, -- K3, Windrunner's Overlook, Wintergarde Keep, Westguard Keep
				["0.62:0.64:0.52:0.62:0.49:0.42"] = 220, -- K3, Dalaran, Moa'ki
				["0.62:0.64:0.52:0.62:0.49:0.42:0.29:0.43"] = 349, -- K3, Dalaran, Moa'ki, Unu'pe
				["0.62:0.64:0.64:0.58:0.72:0.60:0.83:0.54"] = 178, -- K3, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.62:0.64:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 201, -- K3, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.62:0.64:0.52:0.62:0.24:0.60:0.18:0.60"] = 308, -- K3, Dalaran, Le Cœur du fleuve, Camp de base de Nesingwary
				["0.62:0.64:0.64:0.58:0.54:0.48"] = 134, -- K3, Ebon Watch, Wyrmrest Temple
				["0.62:0.64:0.57:0.67:0.64:0.81"] = 140, -- K3, Frosthold, Ulduar
				["0.62:0.64:0.64:0.58:0.54:0.48:0.49:0.42"] = 187, -- K3, Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.62:0.64:0.52:0.62:0.56:0.64"] = 94, -- K3, Dalaran, The Argent Vanguard
				["0.62:0.64:0.72:0.71"] = 101, -- K3, Dun Nifflelem
				["0.62:0.64:0.64:0.58:0.72:0.60"] = 107, -- K3, Ebon Watch, The Argent Stand
				["0.62:0.64:0.52:0.62:0.54:0.48"] = 182, -- K3, Dalaran, Wyrmrest Temple
				["0.62:0.64:0.52:0.62:0.24:0.60"] = 272, -- K3, Dalaran, River's Heart
				["0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51"] = 325, -- K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip
				["0.62:0.64:0.72:0.71:0.78:0.62:0.72:0.60:0.69:0.58"] = 266, -- K3, Dun Nifflelem, Zim'Torga, The Argent Stand, Light's Breach
				["0.62:0.64:0.64:0.58:0.72:0.60:0.78:0.62"] = 148, -- K3, Ebon Watch, The Argent Stand, Zim'Torga
				["0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33:0.74:0.29"] = 274, -- K3, Ebon Watch, Wintergarde Keep, Westguard Keep, Kamagua
				["0.62:0.64:0.57:0.67:0.57:0.79"] = 108, -- K3, Frosthold, Bouldercrag's Refuge
				["0.62:0.64:0.57:0.67:0.56:0.64:0.52:0.66"] = 103, -- K3, Frosthold, The Argent Vanguard, Crusaders' Pinnacle
				["0.62:0.64:0.57:0.67:0.56:0.64:0.52:0.66:0.28:0.72"] = 270, -- K3, Frosthold, The Argent Vanguard, Crusaders' Pinnacle, Death's Rise
				["0.62:0.64:0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46"] = 301, -- K3, Dalaran, Wyrmruhtempel, Feste Wintergarde, Ammertannhütte
				["0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.29:0.43"] = 297, -- K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Unu'pe
				["0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 405, -- K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.62:0.64:0.64:0.58:0.46:0.54"] = 155, -- K3, Ebon Watch, Fordragon Hold
				["0.62:0.64:0.59:0.57:0.60:0.48:0.76:0.33:0.88:0.28"] = 318, -- K3, Windrunner's Overlook, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.62:0.64:0.52:0.62:0.54:0.48:0.60:0.48:0.76:0.33"] = 351, -- K3, Dalaran, Wyrmrest Temple, Wintergarde Keep, Westguard Keep
				["0.62:0.64:0.64:0.58:0.69:0.58:0.73:0.46:0.88:0.40"] = 287, -- K3, Ebon Watch, Light's Breach, Amberpine Lodge, Fort Wildervar
				["0.62:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 439, -- K3, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39:0.17:0.47"] = 389, -- K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep, Amber Ledge
				["0.62:0.64:0.59:0.57:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 406, -- K3, Windrunner's Overlook, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.62:0.64:0.57:0.67:0.57:0.79:0.38:0.79"] = 221, -- K3, Frosthold, Bouldercrag's Refuge, The Shadow Vault
				["0.62:0.64:0.64:0.58:0.69:0.58:0.73:0.46:0.76:0.33"] = 254, -- K3, Ebon Watch, Light's Breach, Amberpine Lodge, Westguard Keep
				["0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 368, -- K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 425, -- K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.62:0.64:0.52:0.62:0.41:0.57"] = 175, -- K3, Dalaran, Valiance Landing Camp
				["0.62:0.64:0.52:0.62:0.46:0.54:0.42:0.47"] = 235, -- K3, Dalaran, Fordragon Hold, Stars' Rest
				["0.62:0.64:0.59:0.57:0.60:0.48:0.69:0.58:0.72:0.60:0.78:0.62"] = 294, -- K3, Windrunner's Overlook, Wintergarde Keep, Light's Breach, The Argent Stand, Zim'Torga
				["0.62:0.64:0.59:0.57:0.60:0.48:0.42:0.47"] = 237, -- K3, Windrunner's Overlook, Wintergarde Keep, Stars' Rest
				["0.62:0.64:0.57:0.67:0.64:0.81:0.78:0.62:0.82:0.69"] = 346, -- K3, Frosthold, Ulduar, Zim'Torga, Gundrak
				["0.62:0.64:0.52:0.62:0.46:0.54"] = 161, -- K3, Dalaran, Fordragon Hold
				["0.62:0.64:0.59:0.57:0.60:0.48:0.73:0.46"] = 200, -- K3, Windrunner's Overlook, Wintergarde Keep, Amberpine Lodge
				["0.62:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39"] = 362, -- K3, Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep
				["0.62:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 460, -- K3, Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.62:0.64:0.52:0.62:0.52:0.66:0.38:0.79"] = 223, -- K3, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.62:0.64:0.64:0.58:0.54:0.48:0.49:0.42:0.74:0.29:0.88:0.28"] = 450, -- K3, Ebon Watch, Wyrmrest Temple, Moa'ki, Kamagua, Valgarde Port
				["0.62:0.64:0.64:0.58:0.54:0.48:0.49:0.42:0.74:0.29:0.76:0.33:0.88:0.40"] = 491, -- K3, Ebon Watch, Wyrmrest Temple, Moa'ki, Kamagua, Westguard Keep, Fort Wildervar
				["0.62:0.64:0.57:0.67:0.64:0.81:0.78:0.62:0.83:0.54"] = 349, -- K3, Frosthold, Ulduar, Zim'Torga, Westfall Brigade
				["0.62:0.64:0.52:0.62:0.52:0.66"] = 100, -- K3, Dalaran, Crusaders' Pinnacle
				["0.62:0.64:0.64:0.58:0.60:0.48:0.73:0.46:0.88:0.40"] = 290, -- K3, Ebon Watch, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.62:0.64:0.64:0.58:0.60:0.48:0.73:0.46"] = 176, -- K3, Ebon Watch, Wintergarde Keep, Amberpine Lodge
				["0.62:0.64:0.57:0.67:0.57:0.79:0.28:0.72"] = 298, -- K3, Eisfestung, Bergfels' Zuflucht, Todesanhöhe
				["0.62:0.64:0.52:0.62:0.41:0.57:0.28:0.72"] = 340, -- K3, Dalaran, Valiance Landing Camp, Death's Rise
				["0.62:0.64:0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81:0.57:0.79"] = 349, -- K3, Ebon Watch, The Argent Stand, Zim'Torga, Ulduar, Bouldercrag's Refuge
				["0.62:0.64:0.57:0.67:0.57:0.79:0.51:0.21"] = 168, -- K3, Frosthold, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.62:0.64:0.52:0.62:0.49:0.79"] = 186, -- K3, Dalaran, Argentumturnierplatz
				["0.62:0.64:0.52:0.62:0.56:0.64:0.28:0.72"] = 317, -- K3, Dalaran, The Argent Vanguard, Death's Rise
				["0.62:0.64:0.52:0.62:0.49:0.79:0.57:0.79:0.64:0.81"] = 277, -- K3, Dalaran, Argent Tournament Grounds, Bouldercrag's Refuge, Ulduar
				["0.62:0.64:0.72:0.71:0.78:0.62:0.83:0.54"] = 245, -- K3, Dun Nifflelem, Zim'Torga, Westfall Brigade
				["0.62:0.64:0.64:0.58:0.60:0.48:0.73:0.46:0.83:0.54"] = 257, -- K3, Ebon Watch, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.62:0.64:0.59:0.57:0.60:0.48"] = 129, -- K3, Windrunner's Overlook, Wintergarde Keep
				["0.62:0.64:0.59:0.57:0.60:0.48:0.69:0.58"] = 211, -- K3, Windläufers Warte, Feste Wintergarde, Lichtbresche
				["0.62:0.64:0.64:0.58:0.46:0.54:0.42:0.47:0.49:0.42:0.74:0.29"] = 479, -- K3, Ebon Watch, Fordragon Hold, Stars' Rest, Moa'ki, Kamagua
				["0.62:0.64:0.52:0.62:0.49:0.42:0.42:0.47:0.22:0.39"] = 400, -- K3, Dalaran, Moa'ki, Stars' Rest, Valiance Keep
				["0.62:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.29:0.43"] = 330, -- K3, Dalaran, Fordragon Hold, Stars' Rest, Unu'pe
				["0.62:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51"] = 360, -- K3, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip
				["0.62:0.64:0.52:0.62:0.54:0.48:0.60:0.48:0.73:0.46:0.83:0.54"] = 381, -- K3, Dalaran, Wyrmrest Temple, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.62:0.64:0.64:0.58:0.60:0.48:0.42:0.47:0.22:0.39"] = 340, -- K3, Schwarze Wacht, Feste Wintergarde, Sternenruh, Valianzfeste
				["0.62:0.64:0.52:0.62:0.24:0.60:0.28:0.72"] = 357, -- K3, Dalaran, River's Heart, Death's Rise
				["0.62:0.64:0.57:0.67:0.56:0.64:0.38:0.79"] = 222, -- K3, Frosthold, The Argent Vanguard, The Shadow Vault
				["0.62:0.64:0.52:0.62:0.49:0.42:0.60:0.48:0.76:0.33"] = 423, -- K3, Dalaran, Moa'ki, Wintergarde Keep, Westguard Keep

				-- Alliance: The Storm Peaks: Ulduar
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62"] = 167, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran
				["0.64:0.81:0.72:0.71"] = 104, -- Ulduar, Dun Nifflelem
				["0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48"] = 312, -- Ulduar, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.66"] = 163, -- Ulduar, Frosthold, The Argent Vanguard, Crusaders' Pinnacle
				["0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62"] = 325, -- Ulduar, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran
				["0.64:0.81:0.78:0.62:0.83:0.54"] = 210, -- Ulduar, Zim'Torga, Westfall Brigade
				["0.64:0.81:0.57:0.67:0.56:0.64"] = 136, -- Ulduar, Frosthold, The Argent Vanguard
				["0.64:0.81:0.78:0.62"] = 154, -- Ulduar, Zim'Torga
				["0.64:0.81:0.72:0.71:0.62:0.64:0.52:0.62"] = 262, -- Ulduar, Dun Niffelem, K3, Dalaran
				["0.64:0.81:0.57:0.67:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.29:0.43"] = 447, -- Ulduar, Frosthold, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Unu'pe
				["0.64:0.81:0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48"] = 256, -- Ulduar, Fort du Givre, K3, Guet d'Ébène, Donjon de Garde-hiver, Donjon de Garde-hiver
				["0.64:0.81:0.57:0.67"] = 103, -- Ulduar, Frosthold
				["0.64:0.81:0.57:0.67:0.62:0.64"] = 151, -- Ulduar, Eisfestung, K3
				["0.64:0.81:0.78:0.62:0.82:0.69"] = 207, -- Ulduar, Zim'Torga, Gundrak
				["0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46:0.76:0.33:0.88:0.28"] = 463, -- Ulduar, Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge, Westguard Keep, Valgarde Port
				["0.64:0.81:0.78:0.62:0.83:0.54:0.88:0.40:0.88:0.28"] = 367, -- Ulduar, Zim'Torga, Westfall Brigade, Fort Wildervar, Valgarde Port
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.41:0.57"] = 270, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, Valiance Landing Camp
				["0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.62:0.64"] = 298, -- Ulduar, Zim'Torga, The Argent Stand, Ebon Watch, K3
				["0.64:0.81:0.72:0.71:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47"] = 391, -- Ульдуар, Дун Ниффелем, К-3, Черная застава, Храм Драконьего Покоя, Покой Звезд
				["0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58"] = 229, -- Ulduar, Zim'Torga, Argentumwache, Lichtbresche
				["0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58"] = 258, -- Ulduar, Zim'Torga, The Argent Stand, Ebon Watch
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 554, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64"] = 346, -- Ulduar, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard
				["0.64:0.81:0.78:0.62:0.83:0.54:0.73:0.46:0.76:0.33"] = 370, -- Ulduar, Zim'Torga, Westfall Brigade, Amberpine Lodge, Westguard Keep
				["0.64:0.81:0.57:0.79"] = 48, -- Ulduar, Bouldercrag's Refuge
				["0.64:0.81:0.78:0.62:0.72:0.60"] = 206, -- Ulduar, Zim'Torga, Le séjour d'Argent
				["0.64:0.81:0.57:0.67:0.62:0.64:0.52:0.62"] = 222, -- Ulduar, Eisfestung, K3, Dalaran
				["0.64:0.81:0.57:0.67:0.62:0.64:0.64:0.58:0.69:0.58"] = 239, -- Ulduar, Frosthold, K3, Ebon Watch, Light's Breach
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 508, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60"] = 367, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, River's Heart
				["0.64:0.81:0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33:0.88:0.28"] = 444, -- Ulduar, Frosthold, K3, Ebon Watch, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60:0.18:0.60"] = 401, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, River's Heart, Nesingwary Base Camp
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47"] = 329, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54"] = 256, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.54:0.48"] = 277, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, Wyrmrest Temple
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.54:0.48:0.42:0.47:0.22:0.39"] = 469, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, Wyrmrest Temple, Stars' Rest, Valiance Keep
				["0.64:0.81:0.57:0.67:0.62:0.64:0.64:0.58"] = 195, -- Ulduar, Frosthold, K3, Ebon Watch
				["0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48"] = 348, -- Ulduar, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple
				["0.64:0.81:0.57:0.79:0.28:0.72"] = 239, -- Ulduar, Bouldercrag's Refuge, Death's Rise
				["0.64:0.81:0.57:0.79:0.38:0.79"] = 162, -- Ulduar, Bouldercrag's Refuge, The Shadow Vault
				["0.64:0.81:0.78:0.62:0.83:0.54:0.88:0.40"] = 295, -- Ulduar, Zim'Torga, Westfall Brigade, Fort Wildervar
				["0.64:0.81:0.57:0.67:0.62:0.64:0.64:0.58:0.54:0.48"] = 286, -- Ulduar, Frosthold, K3, Ebon Watch, Wyrmrest Temple
				["0.64:0.81:0.78:0.62:0.83:0.54:0.73:0.46:0.76:0.33:0.74:0.29"] = 420, -- Ulduar, Zim'Torga, Westfall Brigade, Amberpine Lodge, Westguard Keep, Kamagua
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 533, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.64:0.81:0.57:0.67:0.62:0.64:0.59:0.57"] = 205, -- Ulduar, Frosthold, K3, Windrunner's Overlook
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.54:0.48:0.60:0.48:0.76:0.33:0.88:0.28"] = 513, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, Wyrmrest Temple, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.66:0.41:0.57"] = 269, -- Ulduar, Frosthold, The Argent Vanguard, Crusaders' Pinnacle, Valiance Landing Camp
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.21:0.51:0.17:0.47"] = 497, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.64:0.81:0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33:0.74:0.29"] = 425, -- Ulduar, Frosthold, K3, Ebon Watch, Wintergarde Keep, Westguard Keep, Kamagua
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.29:0.43"] = 425, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Unu'pe
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47"] = 471, -- Ulduar, Eisfestung, Die Argentumvorhut, Dalaran, Flussnabel, Landebahn Kurbelzisch, Bernsteinflöz
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.49:0.42"] = 315, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, Moa'ki
				["0.64:0.81:0.57:0.79:0.56:0.64:0.52:0.62"] = 326, -- Ulduar, Bouldercrag's Refuge, The Argent Vanguard, Dalaran
				["0.64:0.81:0.57:0.79:0.56:0.64"] = 296, -- Ulduar, Bouldercrag's Refuge, The Argent Vanguard
				["0.64:0.81:0.57:0.79:0.28:0.72:0.24:0.60"] = 356, -- Ulduar, Bouldercrag's Refuge, Death's Rise, River's Heart
				["0.64:0.81:0.78:0.62:0.83:0.54:0.73:0.46:0.76:0.33:0.88:0.28"] = 438, -- Ulduar, Zim'Torga, Westfall Brigade, Amberpine Lodge, Westguard Keep, Valgarde Port
				["0.64:0.81:0.72:0.71:0.62:0.64:0.52:0.62:0.56:0.64"] = 285, -- Ulduar, Dun Nifflelem, K3, Dalaran, The Argent Vanguard
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.24:0.60:0.21:0.51"] = 428, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, River's Heart, Fizzcrank Airstrip
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.46:0.54:0.42:0.47:0.22:0.39"] = 456, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, Fordragon Hold, Stars' Rest, Valiance Keep
				["0.64:0.81:0.57:0.67:0.62:0.64:0.64:0.58:0.60:0.48:0.76:0.33"] = 375, -- Ulduar, Frosthold, K3, Ebon Watch, Wintergarde Keep, Westguard Keep
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.41:0.57:0.28:0.72"] = 435, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, Valiance Landing Camp, Death's Rise
				["0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46:0.88:0.40"] = 427, -- Ulduar, Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge, Fort Wildervar
				["0.64:0.81:0.72:0.71:0.62:0.64:0.64:0.58:0.72:0.60"] = 298, -- Ulduar, Dun Nifflelem, K3, Ebon Watch, The Argent Stand
				["0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.49:0.42"] = 404, -- Ulduar, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Moa'ki
				["0.64:0.81:0.72:0.71:0.62:0.64"] = 191, -- Ulduar, Dun Nifflelem, K3
				["0.64:0.81:0.57:0.79:0.51:0.21"] = 109, -- Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.64:0.81:0.57:0.67:0.62:0.64:0.52:0.62:0.24:0.60"] = 422, -- Ulduar, Frosthold, K3, Dalaran, River's Heart
				["0.64:0.81:0.57:0.79:0.28:0.72:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 496, -- Ulduar, Bouldercrag's Refuge, Death's Rise, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.64:0.81:0.57:0.79:0.28:0.72:0.18:0.60"] = 356, -- Ulduar, Bouldercrag's Refuge, Death's Rise, Nesingwary Base Camp
				["0.64:0.81:0.57:0.79:0.28:0.72:0.24:0.60:0.21:0.51"] = 416, -- Ulduar, Bouldercrag's Refuge, Death's Rise, River's Heart, Fizzcrank Airstrip
				["0.64:0.81:0.57:0.79:0.28:0.72:0.24:0.60:0.21:0.51:0.17:0.47"] = 460, -- Ulduar, Bouldercrag's Refuge, Death's Rise, River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.64:0.81:0.72:0.71:0.62:0.64:0.64:0.58:0.60:0.48"] = 296, -- Ulduar, Dun Nifflelem, K3, Ebon Watch, Wintergarde Keep
				["0.64:0.81:0.57:0.79:0.51:0.21:0.52:0.66:0.41:0.57:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 561, -- Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds, Crusaders' Pinnacle, Valiance Landing Camp, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.64:0.81:0.57:0.67:0.62:0.64:0.52:0.62:0.24:0.60:0.18:0.60"] = 457, -- Ulduar, Frosthold, K3, Dalaran, River's Heart, Nesingwary Base Camp
				["0.64:0.81:0.57:0.67:0.62:0.64:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 556, -- Ulduar, Frosthold, K3, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.64:0.81:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 557, -- Ulduar, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.64:0.81:0.78:0.62:0.83:0.54:0.73:0.46"] = 288, -- Ulduar, Zim'Torga, Westfall Brigade, Amberpine Lodge
				["0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46"] = 313, -- Ulduar, Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge
				["0.64:0.81:0.57:0.79:0.51:0.21:0.52:0.66:0.56:0.64:0.52:0.62"] = 242, -- Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds, Crusaders' Pinnacle, The Argent Vanguard, Dalaran
				["0.64:0.81:0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46:0.76:0.33"] = 395, -- Ulduar, Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge, Westguard Keep
				["0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62:0.49:0.79"] = 281, -- Ulduar, Frosthold, The Argent Vanguard, Dalaran, Argent Tournament Grounds
				["0.64:0.81:0.57:0.79:0.51:0.21:0.52:0.62:0.24:0.60"] = 444, -- Ulduar, Bergfels' Zuflucht, Argentumturnierplatz, Dalaran, Flussnabel
				["0.64:0.81:0.57:0.67:0.62:0.64:0.64:0.58:0.72:0.60"] = 258, -- Ulduar, Frosthold, K3, Ebon Watch, The Argent Stand
				["0.64:0.81:0.57:0.79:0.51:0.21:0.52:0.66"] = 179, -- Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds, Crusaders' Pinnacle

				----------------------------------------------------------------------
				-- Alliance: Wintergrasp
				----------------------------------------------------------------------

				-- Alliance: Wintergrasp: Valiance Landing Camp
				["0.41:0.57:0.46:0.54"] = 49, -- Valiance Landing Camp, Fordragon Hold
				["0.41:0.57:0.46:0.54:0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 325, -- Valiance Landing Camp, Fordragon Hold, Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.41:0.57:0.46:0.54:0.60:0.48:0.76:0.33:0.88:0.28"] = 325, -- Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.41:0.57:0.46:0.54:0.64:0.58:0.69:0.58"] = 212, -- Valiance Landing Camp, Fordragon Hold, Ebon Watch, Light's Breach
				["0.41:0.57:0.24:0.60"] = 137, -- Valiance Landing Camp, River's Heart
				["0.41:0.57:0.46:0.54:0.60:0.48:0.73:0.46:0.88:0.40"] = 321, -- Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.41:0.57:0.42:0.47"] = 81, -- Valiance Landing Camp, Stars' Rest
				["0.41:0.57:0.46:0.54:0.60:0.48"] = 136, -- Valiance Landing Camp, Fordragon Hold, Wintergarde Keep
				["0.41:0.57:0.46:0.54:0.60:0.48:0.76:0.33:0.74:0.29"] = 306, -- Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Westguard Keep, Kamagua
				["0.41:0.57:0.46:0.54:0.60:0.48:0.76:0.33"] = 256, -- Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Westguard Keep
				["0.41:0.57:0.24:0.60:0.21:0.51:0.17:0.47"] = 241, -- Valiance Landing Camp, River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.41:0.57:0.52:0.62"] = 91, -- Valiance Landing Camp, Dalaran
				["0.41:0.57:0.46:0.54:0.54:0.48"] = 114, -- Terrain d'atterrissage de la Bravoure, Bastion Fordragon, Temple du Repos du ver
				["0.41:0.57:0.52:0.62:0.56:0.64:0.57:0.67:0.64:0.81"] = 250, -- Valiance Landing Camp, Dalaran, The Argent Vanguard, Frosthold, Ulduar
				["0.41:0.57:0.42:0.47:0.49:0.42"] = 150, -- Valiance Landing Camp, Stars' Rest, Moa'ki
				["0.41:0.57:0.52:0.66"] = 110, -- Valiance Landing Camp, Crusaders' Pinnacle
				["0.41:0.57:0.42:0.47:0.29:0.43"] = 178, -- Valiance Landing Camp, Stars' Rest, Unu'pe
				["0.41:0.57:0.46:0.54:0.64:0.58:0.72:0.60:0.78:0.62"] = 272, -- Valiance Landing Camp, Fordragon Hold, Ebon Watch, The Argent Stand, Zim'Torga
				["0.41:0.57:0.42:0.47:0.49:0.42:0.74:0.29"] = 333, -- Valiance Landing Camp, Stars' Rest, Moa'ki, Kamagua
				["0.41:0.57:0.52:0.62:0.62:0.64:0.72:0.71"] = 237, -- Valiance Landing Camp, Dalaran, K3, Dun Nifflelem
				["0.41:0.57:0.42:0.47:0.22:0.39"] = 211, -- Valianzlager, Sternenruh, Valianzfeste
				["0.41:0.57:0.28:0.72"] = 166, -- Valiance Landing Camp, Death's Rise
				["0.41:0.57:0.24:0.60:0.21:0.51"] = 198, -- Valiance Landing Camp, River's Heart, Fizzcrank Airstrip
				["0.41:0.57:0.46:0.54:0.60:0.48:0.73:0.46"] = 207, -- Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Amberpine Lodge
				["0.41:0.57:0.52:0.62:0.56:0.64"] = 114, -- Valiance Landing Camp, Dalaran, The Argent Vanguard
				["0.41:0.57:0.52:0.62:0.62:0.64:0.57:0.67"] = 180, -- Valiance Landing Camp, Dalaran, K3, Frosthold
				["0.41:0.57:0.52:0.62:0.62:0.64"] = 137, -- Valiance Landing Camp, Dalaran, K3
				["0.41:0.57:0.24:0.60:0.18:0.60"] = 171, -- Valianzlager, Flussnabel, Nesingwarys Basislager
				["0.41:0.57:0.38:0.79"] = 161, -- Valiance Landing Camp, The Shadow Vault
				["0.41:0.57:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 287, -- Valiance Landing Camp, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.41:0.57:0.52:0.62:0.56:0.64:0.57:0.67"] = 153, -- Valiance Landing Camp, Dalaran, The Argent Vanguard, Frosthold
				["0.41:0.57:0.52:0.62:0.64:0.58"] = 159, -- Valianzlager, Dalaran, Schwarze Wacht
				["0.41:0.57:0.52:0.62:0.56:0.64:0.57:0.67:0.57:0.79"] = 217, -- Valiance Landing Camp, Dalaran, The Argent Vanguard, Frosthold, Bouldercrag's Refuge
				["0.41:0.57:0.46:0.54:0.64:0.58"] = 168, -- Valiance Landing Camp, Fordragon Hold, Ebon Watch
				["0.41:0.57:0.52:0.62:0.49:0.42:0.29:0.43:0.21:0.51"] = 448, -- Valiance Landing Camp, Dalaran, Moa'ki, Unu'pe, Fizzcrank Airstrip
				["0.41:0.57:0.52:0.62:0.49:0.42:0.74:0.29:0.76:0.33:0.73:0.46"] = 533, -- Valiance Landing Camp, Dalaran, Moa'ki, Kamagua, Westguard Keep, Amberpine Lodge
				["0.41:0.57:0.42:0.47:0.22:0.39:0.17:0.47"] = 273, -- Valiance Landing Camp, Stars' Rest, Valiance Keep, Amber Ledge
				["0.41:0.57:0.46:0.54:0.64:0.58:0.72:0.60"] = 232, -- Valiance Landing Camp, Fordragon Hold, Ebon Watch, The Argent Stand
				["0.41:0.57:0.42:0.47:0.21:0.51"] = 208, -- Valiance Landing Camp, Stars' Rest, Fizzcrank Airstrip
				["0.41:0.57:0.24:0.60:0.21:0.51:0.17:0.47:0.12:0.47"] = 278, -- Valiance Landing Camp, River's Heart, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.41:0.57:0.42:0.47:0.21:0.51:0.17:0.47"] = 251, -- Valiance Landing Camp, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.41:0.57:0.52:0.62:0.59:0.57"] = 133, -- Valiance Landing Camp, Dalaran, Windrunner's Overlook
				["0.41:0.57:0.46:0.54:0.60:0.48:0.69:0.58"] = 219, -- Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Light's Breach
				["0.41:0.57:0.42:0.47:0.60:0.48:0.73:0.46"] = 274, -- Valiance Landing Camp, Stars' Rest, Wintergarde Keep, Amberpine Lodge
				["0.41:0.57:0.24:0.60:0.21:0.51:0.22:0.39"] = 267, -- Valiance Landing Camp, River's Heart, Fizzcrank Airstrip, Valiance Keep
				["0.41:0.57:0.52:0.62:0.64:0.58:0.72:0.60:0.83:0.54"] = 293, -- Valiance Landing Camp, Dalaran, Ebon Watch, The Argent Stand, Westfall Brigade
				["0.41:0.57:0.46:0.54:0.60:0.48:0.73:0.46:0.83:0.54"] = 287, -- Valiance Landing Camp, Fordragon Hold, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.41:0.57:0.52:0.66:0.49:0.79"] = 206, -- Valiance Landing Camp, Crusaders' Pinnacle, Argent Tournament Grounds
				["0.41:0.57:0.42:0.47:0.60:0.48:0.76:0.33"] = 323, -- Valiance Landing Camp, Stars' Rest, Wintergarde Keep, Westguard Keep
				["0.41:0.57:0.52:0.62:0.49:0.79"] = 206, -- Valiance Landing Camp, Dalaran, Argent Tournament Grounds
				["0.41:0.57:0.52:0.62:0.64:0.58:0.72:0.60:0.78:0.62"] = 263, -- Valiance Landing Camp, Dalaran, Ebon Watch, The Argent Stand, Zim'Torga
				["0.41:0.57:0.52:0.62:0.64:0.58:0.69:0.58:0.73:0.46"] = 287, -- Valiance Landing Camp, Dalaran, Ebon Watch, Light's Breach, Amberpine Lodge

				----------------------------------------------------------------------
				-- Alliance: Zul'Drak
				----------------------------------------------------------------------

				-- Alliance: Zul'Drak: Ebon Watch
				["0.64:0.58:0.69:0.58"] = 45, -- Ebon Watch, Light's Breach
				["0.64:0.58:0.59:0.57"] = 34, -- Ebon Watch, Windrunner's Overlook
				["0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39"] = 284, -- Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep
				["0.64:0.58:0.60:0.48"] = 62, -- Ebon Watch, Wintergarde Keep
				["0.64:0.58:0.52:0.62"] = 68, -- Ebon Watch, Dalaran
				["0.64:0.58:0.72:0.60:0.83:0.54"] = 135, -- Ebon Watch, The Argent Stand, Westfall Brigade
				["0.64:0.58:0.60:0.48:0.76:0.33:0.88:0.28"] = 251, -- Ebon Watch, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.64:0.58:0.72:0.60"] = 64, -- Ebon Watch, The Argent Stand
				["0.64:0.58:0.60:0.48:0.76:0.33:0.74:0.29"] = 232, -- Ebon Watch, Wintergarde Keep, Westguard Keep, Kamagua
				["0.64:0.58:0.54:0.48"] = 92, -- Ebon Watch, Wyrmrest Temple
				["0.64:0.58:0.54:0.48:0.42:0.47"] = 158, -- Ebon Watch, Wyrmrest Temple, Stars' Rest
				["0.64:0.58:0.60:0.48:0.49:0.42"] = 154, -- Ebon Watch, Wintergarde Keep, Moa'ki
				["0.64:0.58:0.52:0.62:0.56:0.64"] = 89, -- Ebon Watch, Dalaran, The Argent Vanguard
				["0.64:0.58:0.72:0.60:0.78:0.62"] = 105, -- Ebon Watch, The Argent Stand, Zim'Torga
				["0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51"] = 282, -- Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip
				["0.64:0.58:0.46:0.54"] = 112, -- Ebon Watch, Fordragon Hold
				["0.64:0.58:0.46:0.54:0.42:0.47"] = 185, -- Ebon Watch, Fordragon Hold, Stars' Rest
				["0.64:0.58:0.60:0.48:0.73:0.46"] = 133, -- Ebon Watch, Wintergarde Keep, Amberpine Lodge
				["0.64:0.58:0.60:0.48:0.73:0.46:0.83:0.54"] = 213, -- Ebon Watch, Wintergarde Keep, Amberpine Lodge, Westfall Brigade
				["0.64:0.58:0.69:0.58:0.73:0.46"] = 129, -- Ebon Watch, Light's Breach, Amberpine Lodge
				["0.64:0.58:0.54:0.48:0.49:0.42"] = 144, -- Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.64:0.58:0.60:0.48:0.73:0.46:0.88:0.40"] = 247, -- Ebon Watch, Wintergarde Keep, Amberpine Lodge, Fort Wildervar
				["0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 382, -- Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.64:0.58:0.60:0.48:0.76:0.33"] = 182, -- Ebon Watch, Wintergarde Keep, Westguard Keep
				["0.64:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 158, -- Ebon Watch, The Argent Stand, Zim'Torga, Gundrak
				["0.64:0.58:0.52:0.62:0.52:0.66"] = 94, -- Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 362, -- Guet d'Ébène, Temple du Repos du ver, Repos des étoiles, Piste d'atterrissage de Spumelevier, Escarpement d'Ambre, Bouclier Transitus
				["0.64:0.58:0.52:0.62:0.24:0.60"] = 266, -- Ebon Watch, Dalaran, River's Heart
				["0.64:0.58:0.60:0.48:0.42:0.47:0.22:0.39"] = 297, -- Ebon Watch, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.64:0.58:0.62:0.64"] = 40, -- Ebon Watch, K3
				["0.64:0.58:0.54:0.48:0.42:0.47:0.29:0.43"] = 254, -- Ebon Watch, Wyrmrest Temple, Stars' Rest, Unu'pe
				["0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 261, -- Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.64:0.58:0.69:0.58:0.73:0.46:0.88:0.40"] = 244, -- Ebon Watch, Light's Breach, Amberpine Lodge, Fort Wildervar
				["0.64:0.58:0.62:0.64:0.72:0.71"] = 141, -- Ebon Watch, K3, Dun Nifflelem
				["0.64:0.58:0.62:0.64:0.57:0.67"] = 84, -- Ebon Watch, K3, Frosthold
				["0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 326, -- Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.64:0.58:0.46:0.54:0.41:0.57"] = 171, -- Ebon Watch, Fordragon Hold, Valiance Landing Camp
				["0.64:0.58:0.52:0.62:0.49:0.42:0.29:0.43"] = 343, -- Ebon Watch, Dalaran, Moa'ki, Unu'pe
				["0.64:0.58:0.60:0.48:0.42:0.47"] = 170, -- Ebon Watch, Wintergarde Keep, Stars' Rest
				["0.64:0.58:0.72:0.60:0.83:0.54:0.88:0.40"] = 220, -- Ebon Watch, The Argent Stand, Westfall Brigade, Fort Wildervar
				["0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 216, -- Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.64:0.58:0.46:0.54:0.41:0.57:0.28:0.72"] = 337, -- Schwarze Wacht, Feste Fordragon, Valianzlager, Todesanhöhe
				["0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39:0.17:0.47"] = 346, -- Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep, Amber Ledge
				["0.64:0.58:0.62:0.64:0.57:0.67:0.64:0.81"] = 180, -- Ebon Watch, K3, Frosthold, Ulduar
				["0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79"] = 148, -- Ebon Watch, K3, Frosthold, Bouldercrag's Refuge
				["0.64:0.58:0.54:0.48:0.49:0.42:0.74:0.29:0.88:0.28"] = 407, -- Ebon Watch, Wyrmrest Temple, Moa'ki, Kamagua, Valgarde Port
				["0.64:0.58:0.60:0.48:0.42:0.47:0.29:0.43"] = 266, -- Ebon Watch, Wintergarde Keep, Stars' Rest, Unu'pe
				["0.64:0.58:0.54:0.48:0.49:0.42:0.74:0.29"] = 327, -- Ebon Watch, Wyrmrest Temple, Moa'ki, Kamagua
				["0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 300, -- Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.64:0.58:0.72:0.60:0.78:0.62:0.64:0.81"] = 258, -- Ebon Watch, The Argent Stand, Zim'Torga, Ulduar
				["0.64:0.58:0.52:0.62:0.56:0.64:0.57:0.67"] = 127, -- Ebon Watch, Dalaran, The Argent Vanguard, Frosthold
				["0.64:0.58:0.52:0.62:0.49:0.79"] = 181, -- Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.64:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 190, -- Ebon Watch, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.64:0.58:0.52:0.62:0.41:0.57"] = 168, -- Ebon Watch, Dalaran, Valiance Landing Camp
				["0.64:0.58:0.69:0.58:0.73:0.46:0.83:0.54"] = 212, -- Ebon Watch, Light's Breach, Amberpine Lodge, Westfall Brigade
				["0.64:0.58:0.52:0.62:0.56:0.64:0.28:0.72"] = 312, -- Ebon Watch, Dalaran, The Argent Vanguard, Death's Rise
				["0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 236, -- Ebon Watch, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.64:0.58:0.52:0.62:0.49:0.42:0.74:0.29:0.76:0.33:0.73:0.46"] = 507, -- Ebon Watch, Dalaran, Moa'ki, Kamagua, Westguard Keep, Amberpine Lodge
				["0.64:0.58:0.60:0.48:0.42:0.47:0.21:0.51"] = 296, -- Ebon Watch, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip
				["0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79:0.38:0.79"] = 262, -- Ebon Watch, K3, Frosthold, Bouldercrag's Refuge, The Shadow Vault
				["0.64:0.58:0.46:0.54:0.41:0.57:0.38:0.79"] = 331, -- Ebon Watch, Fordragon Hold, Valiance Landing Camp, The Shadow Vault
				["0.64:0.58:0.52:0.62:0.49:0.42:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 471, -- Ebon Watch, Dalaran, Moa'ki, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield

				-- Alliance: Zul'Drak: Gundrak
				["0.82:0.69:0.78:0.62"] = 56, -- Gundrak, Zim'Torga
				["0.82:0.69:0.78:0.62:0.72:0.60"] = 109, -- Gundrak, Zim'Torga, The Argent Stand
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62"] = 228, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58"] = 132, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.59:0.57"] = 194, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Windrunner's Overlook
				["0.82:0.69:0.78:0.62:0.83:0.54:0.88:0.40:0.88:0.28"] = 270, -- Gundrak, Zim'Torga, Westfall Brigade, Fort Wildervar, Valgarde Port
				["0.82:0.69:0.78:0.62:0.83:0.54:0.88:0.40"] = 197, -- Gundrak, Zim'Torga, Westfall Brigade, Fort Wildervar
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58"] = 161, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48"] = 214, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46"] = 215, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge
				["0.82:0.69:0.78:0.62:0.83:0.54"] = 112, -- Gundrak, Zim'Torga, Westfall Brigade
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 461, -- Gundrak, Zim'Torga, Le séjour d'Argent, Guet d'Ébène, Dalaran, Le Cœur du fleuve, Camp de base de Nesingwary
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51"] = 442, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.54:0.48:0.52:0.62"] = 354, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Wyrmrest Temple, Dalaran
				["0.82:0.69:0.78:0.62:0.83:0.54:0.73:0.46"] = 190, -- Gundrak, Zim'Torga, Westfall Brigade, Amberpine Lodge
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 522, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60"] = 425, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, River's Heart
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47"] = 317, -- Gundrak, Zim'Torga, Argentumwache, Schwarze Wacht, Wyrmruhtempel, Sternenruh
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48"] = 251, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple
				["0.82:0.69:0.78:0.62:0.64:0.81"] = 210, -- Gundrak, Zim'Torga, Ulduar
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47:0.22:0.39:0.17:0.47"] = 511, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Stars' Rest, Valiance Keep, Amber Ledge
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64"] = 249, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.62:0.64:0.57:0.67"] = 243, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, K3, Frosthold
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39"] = 443, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep
				["0.82:0.69:0.78:0.62:0.83:0.54:0.73:0.46:0.60:0.48"] = 270, -- Gundrak, Zim'Torga, Westfallbrigade, Ammertannhütte, Feste Wintergarde
				["0.82:0.69:0.78:0.62:0.72:0.71:0.62:0.64:0.57:0.67:0.56:0.64:0.52:0.66"] = 330, -- Gundrak, Zim'Torga, Dun Niffelem, K3, Eisfestung, Die Argentumvorhut, Kreuzfahrerturm
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.46:0.54"] = 271, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Fordragon Hold
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46:0.76:0.33"] = 297, -- Gundrak, Zim'Torga, Argentumwache, Lichtbresche, Ammertannhütte, Westwacht
				["0.82:0.69:0.78:0.62:0.83:0.54:0.73:0.46:0.69:0.58"] = 255, -- Gundrak, Zim'Torga, Westfall Brigade, Amberpine Lodge, Light's Breach
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 485, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.62:0.64"] = 201, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, K3
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47"] = 322, -- Gundrak, Zim'Torga, Argentumwache, Lichtbresche, Feste Wintergarde, Sternenruh
				["0.82:0.69:0.78:0.62:0.83:0.54:0.73:0.46:0.76:0.33"] = 273, -- Gundrak, Zim'Torga, Westfall Brigade, Amberpine Lodge, Westguard Keep
				["0.82:0.69:0.78:0.62:0.72:0.71"] = 141, -- Gundrak, Zim'Torga, Dun Nifflelem
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.49:0.42"] = 304, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66"] = 253, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46:0.76:0.33:0.74:0.29"] = 347, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge, Westguard Keep, Kamagua
				["0.82:0.69:0.78:0.62:0.83:0.54:0.73:0.46:0.76:0.33:0.74:0.29"] = 322, -- Gundrak, Zim'Torga, Westfall Brigade, Amberpine Lodge, Westguard Keep, Kamagua
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46:0.88:0.40"] = 330, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge, Fort Wildervar
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 420, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.82:0.69:0.78:0.62:0.64:0.81:0.57:0.79"] = 258, -- Gundrak, Zim'Torga, Ulduar, Bergfels' Zuflucht
				["0.82:0.69:0.78:0.62:0.64:0.81:0.57:0.67:0.56:0.64:0.52:0.62"] = 376, -- Gundrak, Zim'Torga, Ulduar, Frosthold, The Argent Vanguard, Dalaran
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 541, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47:0.22:0.39"] = 449, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.82:0.69:0.78:0.62:0.83:0.54:0.73:0.46:0.60:0.48:0.42:0.47"] = 378, -- Gundrak, Zim'Torga, Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Stars' Rest
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.46:0.54:0.41:0.57"] = 331, -- Гундрак, Зим'Торга, Серебряная застава, Черная застава, Крепость Фордрагона, Лагерь Отваги
				["0.82:0.69:0.78:0.62:0.83:0.54:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62"] = 361, -- Gundrak, Zim'Torga, Westfall Brigade, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.29:0.43"] = 412, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Unu'pe
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46:0.76:0.33:0.88:0.28"] = 366, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge, Westguard Keep, Valgarde Port
				["0.82:0.69:0.78:0.62:0.64:0.81:0.57:0.79:0.38:0.79"] = 371, -- Gundrak, Zim'Torga, Ulduar, Bouldercrag's Refuge, The Shadow Vault
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.54:0.48:0.52:0.62:0.56:0.64:0.57:0.67"] = 415, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Wyrmrest Temple, Dalaran, The Argent Vanguard, Frosthold
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.54:0.48"] = 261, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Wyrmrest Temple
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 376, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.49:0.42"] = 306, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Moa'ki
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79"] = 308, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, K3, Frosthold, Bouldercrag's Refuge
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.46:0.54:0.41:0.57"] = 363, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.59:0.57:0.52:0.62"] = 325, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Windrunner's Overlook, Dalaran
				["0.82:0.69:0.78:0.62:0.83:0.54:0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51"] = 503, -- Gundrak, Zim'Torga, Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip
				["0.82:0.69:0.78:0.62:0.83:0.54:0.73:0.46:0.60:0.48:0.54:0.48:0.52:0.62"] = 410, -- Gundrak, Zim'Torga, Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple, Dalaran
				["0.82:0.69:0.78:0.62:0.64:0.81:0.57:0.79:0.51:0.21"] = 318, -- Gundrak, Zim'Torga, Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47:0.21:0.51:0.24:0.60"] = 510, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, River's Heart
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.59:0.57:0.62:0.64:0.57:0.67"] = 367, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Windrunner's Overlook, K3, Frosthold
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.49:0.79"] = 340, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.82:0.69:0.78:0.62:0.83:0.54:0.73:0.46:0.60:0.48:0.54:0.48:0.52:0.62:0.49:0.79"] = 524, -- Gundrak, Zim'Torga, Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple, Dalaran, Argent Tournament Grounds
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.76:0.33:0.88:0.28"] = 403, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.41:0.57"] = 327, -- Gundrak, Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Valiance Landing Camp
				["0.82:0.69:0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 395, -- Gundrak, Zim'Torga, Argentumwache, Schwarze Wacht, Dalaran, Die Argentumvorhut, Das Schattengewölbe
				["0.82:0.69:0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.46:0.54:0.52:0.62"] = 368, -- Gundrak, Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Fordragon Hold, Dalaran

				-- Alliance: Zul'Drak: Light's Breach
				["0.69:0.58:0.72:0.60"] = 44, -- Light's Breach, The Argent Stand
				["0.69:0.58:0.64:0.58"] = 40, -- Light's Breach, Ebon Watch
				["0.69:0.58:0.64:0.58:0.52:0.62"] = 107, -- Light's Breach, Ebon Watch, Dalaran
				["0.69:0.58:0.72:0.60:0.78:0.62"] = 85, -- Light's Breach, The Argent Stand, Zim'Torga
				["0.69:0.58:0.73:0.46"] = 84, -- Light's Breach, Amberpine Lodge
				["0.69:0.58:0.72:0.60:0.83:0.54"] = 114, -- Light's Breach, The Argent Stand, Westfall Brigade
				["0.69:0.58:0.73:0.46:0.76:0.33:0.88:0.28"] = 236, -- Light's Breach, Amberpine Lodge, Westguard Keep, Valgarde Port
				["0.69:0.58:0.73:0.46:0.76:0.33:0.74:0.29"] = 218, -- Light's Breach, Amberpine Lodge, Westguard Keep, Kamagua
				["0.69:0.58:0.73:0.46:0.76:0.33"] = 167, -- Light's Breach, Amberpine Lodge, Westguard Keep
				["0.69:0.58:0.73:0.46:0.88:0.40"] = 200, -- Light's Breach, Amberpine Lodge, Fort Wildervar
				["0.69:0.58:0.64:0.58:0.54:0.48"] = 131, -- Light's Breach, Ebon Watch, Wyrmrest Temple
				["0.69:0.58:0.60:0.48:0.42:0.47"] = 192, -- Light's Breach, Wintergarde Keep, Stars' Rest
				["0.69:0.58:0.60:0.48:0.42:0.47:0.29:0.43"] = 288, -- Light's Breach, Wintergarde Keep, Stars' Rest, Unu'pe
				["0.69:0.58:0.60:0.48"] = 84, -- Light's Breach, Wintergarde Keep
				["0.69:0.58:0.72:0.60:0.78:0.62:0.82:0.69"] = 138, -- Light's Breach, The Argent Stand, Zim'Torga, Gundrak
				["0.69:0.58:0.60:0.48:0.46:0.54"] = 173, -- Lichtbresche, Feste Wintergarde, Feste Fordragon
				["0.69:0.58:0.60:0.48:0.42:0.47:0.21:0.51"] = 317, -- Light's Breach, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip
				["0.69:0.58:0.60:0.48:0.54:0.48"] = 131, -- Light's Breach, Wintergarde Keep, Wyrmrest Temple
				["0.69:0.58:0.73:0.46:0.83:0.54"] = 167, -- Light's Breach, Amberpine Lodge, Westfall Brigade
				["0.69:0.58:0.64:0.58:0.54:0.48:0.49:0.42"] = 183, -- Light's Breach, Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.69:0.58:0.60:0.48:0.49:0.42"] = 176, -- Light's Breach, Wintergarde Keep, Moa'ki
				["0.69:0.58:0.60:0.48:0.54:0.48:0.52:0.62"] = 223, -- Light's Breach, Wintergarde Keep, Wyrmrest Temple, Dalaran
				["0.69:0.58:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39"] = 323, -- Light's Breach, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep
				["0.69:0.58:0.60:0.48:0.49:0.42:0.52:0.62"] = 297, -- Lichtbresche, Feste Wintergarde, Moa'ki, Dalaran
				["0.69:0.58:0.60:0.48:0.59:0.57:0.52:0.62"] = 194, -- Light's Breach, Wintergarde Keep, Windrunner's Overlook, Dalaran
				["0.69:0.58:0.60:0.48:0.76:0.33:0.88:0.28"] = 272, -- Light's Breach, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.69:0.58:0.73:0.46:0.88:0.40:0.88:0.28"] = 273, -- Light's Breach, Amberpine Lodge, Fort Wildervar, Valgarde Port
				["0.69:0.58:0.64:0.58:0.54:0.48:0.42:0.47:0.29:0.43"] = 293, -- Light's Breach, Ebon Watch, Wyrmrest Temple, Stars' Rest, Unu'pe
				["0.69:0.58:0.64:0.58:0.54:0.48:0.42:0.47"] = 196, -- Light's Breach, Ebon Watch, Wyrmrest Temple, Stars' Rest
				["0.69:0.58:0.60:0.48:0.42:0.47:0.21:0.51:0.24:0.60"] = 380, -- Light's Breach, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, River's Heart
				["0.69:0.58:0.60:0.48:0.42:0.47:0.22:0.39"] = 319, -- Light's Breach, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.69:0.58:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39:0.17:0.47:0.12:0.47"] = 420, -- Light's Breach, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep, Amber Ledge, Transitus Shield
				["0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64"] = 128, -- Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard
				["0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60"] = 305, -- Light's Breach, Ebon Watch, Dalaran, River's Heart
				["0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66"] = 133, -- Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.69:0.58:0.60:0.48:0.76:0.33"] = 203, -- Lichtbresche, Feste Wintergarde, Westwacht
				["0.69:0.58:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 360, -- Lichtbresche, Feste Wintergarde, Sternenruh, Landebahn Kurbelzisch, Bernsteinflöz
				["0.69:0.58:0.60:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 396, -- Lichtbresche, Feste Wintergarde, Sternenruh, Landebahn Kurbelzisch, Bernsteinflöz, Transitusschild
				["0.69:0.58:0.60:0.48:0.46:0.54:0.52:0.62"] = 238, -- Light's Breach, Wintergarde Keep, Fordragon Hold, Dalaran
				["0.69:0.58:0.64:0.58:0.59:0.57"] = 74, -- Light's Breach, Ebon Watch, Windrunner's Overlook
				["0.69:0.58:0.72:0.60:0.78:0.62:0.72:0.71"] = 169, -- Light's Breach, The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.69:0.58:0.72:0.60:0.83:0.54:0.88:0.40:0.88:0.28"] = 273, -- Light's Breach, The Argent Stand, Westfall Brigade, Fort Wildervar, Valgarde Port
				["0.69:0.58:0.64:0.58:0.46:0.54"] = 151, -- Light's Breach, Ebon Watch, Fordragon Hold
				["0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67:0.64:0.81"] = 220, -- Light's Breach, Ebon Watch, K3, Frosthold, Ulduar
				["0.69:0.58:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51"] = 322, -- Light's Breach, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip
				["0.69:0.58:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 401, -- Light's Breach, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.69:0.58:0.60:0.48:0.54:0.48:0.52:0.62:0.62:0.64"] = 268, -- Light's Breach, Wintergarde Keep, Wyrmrest Temple, Dalaran, K3
				["0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 300, -- Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.69:0.58:0.64:0.58:0.62:0.64"] = 80, -- Light's Breach, Ebon Watch, K3
				["0.69:0.58:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 255, -- Light's Breach, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 274, -- Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79"] = 188, -- Light's Breach, Ebon Watch, K3, Frosthold, Bouldercrag's Refuge
				["0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 340, -- Light's Breach, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.69:0.58:0.60:0.48:0.59:0.57:0.62:0.64"] = 194, -- Light's Breach, Wintergarde Keep, Windrunner's Overlook, K3
				["0.69:0.58:0.64:0.58:0.62:0.64:0.57:0.67"] = 123, -- Light's Breach, Ebon Watch, K3, Frosthold
				["0.69:0.58:0.64:0.58:0.46:0.54:0.41:0.57"] = 211, -- Lichtbresche, Schwarze Wacht, Feste Fordragon, Valianzlager
				["0.69:0.58:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 365, -- Light's Breach, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.69:0.58:0.60:0.48:0.42:0.47:0.21:0.51:0.18:0.60"] = 393, -- Light's Breach, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, Nesingwary Base Camp
				["0.69:0.58:0.64:0.58:0.52:0.62:0.24:0.60:0.21:0.51:0.17:0.47"] = 410, -- Light's Breach, Ebon Watch, Dalaran, River's Heart, Fizzcrank Airstrip, Amber Ledge
				["0.69:0.58:0.64:0.58:0.46:0.54:0.41:0.57:0.28:0.72"] = 376, -- Light's Breach, Ebon Watch, Fordragon Hold, Valiance Landing Camp, Death's Rise
				["0.69:0.58:0.64:0.58:0.52:0.62:0.56:0.64:0.57:0.67"] = 167, -- Light's Breach, Ebon Watch, Dalaran, The Argent Vanguard, Frosthold
				["0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79"] = 220, -- Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.69:0.58:0.60:0.48:0.59:0.57:0.62:0.64:0.57:0.67:0.57:0.79"] = 301, -- Light's Breach, Wintergarde Keep, Windrunner's Overlook, K3, Frosthold, Bouldercrag's Refuge
				["0.69:0.58:0.60:0.48:0.59:0.57:0.62:0.64:0.72:0.71"] = 294, -- Lichtbresche, Feste Wintergarde, Windläufers Warte, K3, Dun Niffelem
				["0.69:0.58:0.64:0.58:0.52:0.62:0.49:0.79:0.38:0.79"] = 304, -- Light's Breach, Ebon Watch, Dalaran, Argent Tournament Grounds, The Shadow Vault
				["0.69:0.58:0.60:0.48:0.59:0.57:0.52:0.62:0.49:0.79"] = 308, -- Light's Breach, Wintergarde Keep, Windrunner's Overlook, Dalaran, Argent Tournament Grounds
				["0.69:0.58:0.60:0.48:0.76:0.33:0.88:0.40"] = 288, -- Light's Breach, Wintergarde Keep, Westguard Keep, Fort Wildervar
				["0.69:0.58:0.60:0.48:0.46:0.54:0.41:0.57"] = 232, -- Light's Breach, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp
				["0.69:0.58:0.72:0.60:0.78:0.62:0.72:0.71:0.62:0.64"] = 256, -- Light's Breach, The Argent Stand, Zim'Torga, Dun Nifflelem, K3
				["0.69:0.58:0.60:0.48:0.49:0.42:0.74:0.29:0.88:0.28"] = 439, -- Light's Breach, Wintergarde Keep, Moa'ki, Kamagua, Valgarde Port

				-- Alliance: Zul'Drak: The Argent Stand
				["0.72:0.60:0.78:0.62"] = 42, -- The Argent Stand, Zim'Torga
				["0.72:0.60:0.69:0.58"] = 25, -- The Argent Stand, Light's Breach
				["0.72:0.60:0.64:0.58"] = 53, -- The Argent Stand, Ebon Watch
				["0.72:0.60:0.64:0.58:0.52:0.62"] = 121, -- The Argent Stand, Ebon Watch, Dalaran
				["0.72:0.60:0.78:0.62:0.82:0.69"] = 95, -- The Argent Stand, Zim'Torga, Gundrak
				["0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64"] = 141, -- The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard
				["0.72:0.60:0.69:0.58:0.73:0.46:0.76:0.33"] = 191, -- The Argent Stand, Light's Breach, Amberpine Lodge, Westguard Keep
				["0.72:0.60:0.83:0.54:0.88:0.40:0.88:0.28"] = 230, -- The Argent Stand, Westfall Brigade, Fort Wildervar, Valgarde Port
				["0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39"] = 336, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep
				["0.72:0.60:0.83:0.54"] = 72, -- The Argent Stand, Westfall Brigade
				["0.72:0.60:0.69:0.58:0.60:0.48"] = 107, -- The Argent Stand, Light's Breach, Wintergarde Keep
				["0.72:0.60:0.69:0.58:0.73:0.46"] = 107, -- The Argent Stand, Light's Breach, Amberpine Lodge
				["0.72:0.60:0.83:0.54:0.73:0.46:0.60:0.48:0.54:0.48:0.52:0.62"] = 370, -- The Argent Stand, Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Wyrmrest Temple, Dalaran
				["0.72:0.60:0.69:0.58:0.60:0.48:0.54:0.48"] = 154, -- The Argent Stand, Light's Breach, Wintergarde Keep, Wyrmrest Temple
				["0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47"] = 215, -- The Argent Stand, Light's Breach, Wintergarde Keep, Stars' Rest
				["0.72:0.60:0.64:0.58:0.54:0.48"] = 144, -- The Argent Stand, Ebon Watch, Wyrmrest Temple
				["0.72:0.60:0.69:0.58:0.60:0.48:0.54:0.48:0.52:0.62"] = 247, -- The Argent Stand, Light's Breach, Wintergarde Keep, Wyrmrest Temple, Dalaran
				["0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47:0.22:0.39"] = 342, -- The Argent Stand, Light's Breach, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.72:0.60:0.83:0.54:0.73:0.46"] = 150, -- The Argent Stand, Westfall Brigade, Amberpine Lodge
				["0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60"] = 317, -- The Argent Stand, Ebon Watch, Dalaran, River's Heart
				["0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39:0.17:0.47"] = 398, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep, Amber Ledge
				["0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47:0.21:0.51"] = 340, -- The Argent Stand, Light's Breach, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip
				["0.72:0.60:0.64:0.58:0.46:0.54"] = 164, -- Argentumwache, Schwarze Wacht, Feste Fordragon
				["0.72:0.60:0.69:0.58:0.60:0.48:0.59:0.57:0.52:0.62"] = 218, -- The Argent Stand, Light's Breach, Wintergarde Keep, Windrunner's Overlook, Dalaran
				["0.72:0.60:0.64:0.58:0.60:0.48:0.73:0.46"] = 185, -- The Argent Stand, Ebon Watch, Wintergarde Keep, Amberpine Lodge
				["0.72:0.60:0.69:0.58:0.73:0.46:0.76:0.33:0.74:0.29"] = 240, -- The Argent Stand, Light's Breach, Amberpine Lodge, Westguard Keep, Kamagua
				["0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 353, -- The Argent Stand, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66"] = 146, -- The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47"] = 210, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest
				["0.72:0.60:0.64:0.58:0.62:0.64"] = 94, -- The Argent Stand, Ebon Watch, K3
				["0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47:0.22:0.39:0.17:0.47"] = 404, -- The Argent Stand, Light's Breach, Wintergarde Keep, Stars' Rest, Valiance Keep, Amber Ledge
				["0.72:0.60:0.64:0.58:0.62:0.64:0.57:0.67:0.57:0.79"] = 201, -- The Argent Stand, Ebon Watch, K3, Frosthold, Bouldercrag's Refuge
				["0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47:0.29:0.43"] = 311, -- The Argent Stand, Light's Breach, Wintergarde Keep, Stars' Rest, Unu'pe
				["0.72:0.60:0.64:0.58:0.54:0.48:0.49:0.42"] = 196, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.72:0.60:0.69:0.58:0.73:0.46:0.76:0.33:0.88:0.28"] = 258, -- The Argent Stand, Light's Breach, Amberpine Lodge, Westguard Keep, Valgarde Port
				["0.72:0.60:0.78:0.62:0.72:0.71"] = 127, -- The Argent Stand, Zim'Torga, Dun Nifflelem
				["0.72:0.60:0.64:0.58:0.46:0.54:0.41:0.57"] = 223, -- The Argent Stand, Ebon Watch, Fordragon Hold, Valiance Landing Camp
				["0.72:0.60:0.64:0.58:0.59:0.57"] = 87, -- The Argent Stand, Ebon Watch, Windrunner's Overlook
				["0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 414, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51"] = 335, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip
				["0.72:0.60:0.69:0.58:0.60:0.48:0.49:0.42:0.29:0.43:0.22:0.39:0.17:0.47"] = 452, -- The Argent Stand, Light's Breach, Wintergarde Keep, Moa'ki, Unu'pe, Valiance Keep, Amber Ledge
				["0.72:0.60:0.83:0.54:0.88:0.40"] = 157, -- The Argent Stand, Westfall Brigade, Fort Wildervar
				["0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 313, -- The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64:0.38:0.79"] = 288, -- The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard, The Shadow Vault
				["0.72:0.60:0.78:0.62:0.64:0.81"] = 195, -- The Argent Stand, Zim'Torga, Ulduar
				["0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.29:0.43"] = 305, -- Argentumwache, Schwarze Wacht, Wyrmruhtempel, Sternenruh, Unu'pe
				["0.72:0.60:0.64:0.58:0.46:0.54:0.41:0.57:0.28:0.72"] = 389, -- Argentumwache, Schwarze Wacht, Feste Fordragon, Valianzlager, Todesanhöhe
				["0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66:0.38:0.79"] = 269, -- The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle, The Shadow Vault
				["0.72:0.60:0.78:0.62:0.64:0.81:0.57:0.79"] = 243, -- Argentumwache, Zim'Torga, Ulduar, Bergfels' Zuflucht
				["0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 377, -- Argentumwache, Schwarze Wacht, Wyrmruhtempel, Sternenruh, Landebahn Kurbelzisch, Bernsteinflöz
				["0.72:0.60:0.64:0.58:0.62:0.64:0.57:0.67"] = 136, -- The Argent Stand, Ebon Watch, K3, Frosthold
				["0.72:0.60:0.69:0.58:0.73:0.46:0.88:0.40"] = 223, -- The Argent Stand, Light's Breach, Amberpine Lodge, Fort Wildervar
				["0.72:0.60:0.64:0.58:0.54:0.48:0.49:0.42:0.74:0.29:0.88:0.28"] = 459, -- The Argent Stand, Ebon Watch, Wyrmrest Temple, Moa'ki, Kamagua, Valgarde Port
				["0.72:0.60:0.69:0.58:0.60:0.48:0.46:0.54"] = 196, -- Argentumwache, Lichtbresche, Feste Wintergarde, Feste Fordragon
				["0.72:0.60:0.69:0.58:0.60:0.48:0.49:0.42"] = 199, -- Argentumwache, Lichtbresche, Feste Wintergarde, Moa'ki
				["0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47:0.21:0.51:0.24:0.60"] = 402, -- Argentumwache, Lichtbresche, Feste Wintergarde, Sternenruh, Landebahn Kurbelzisch, Flussnabel
				["0.72:0.60:0.69:0.58:0.60:0.48:0.76:0.33:0.88:0.28"] = 295, -- The Argent Stand, Light's Breach, Wintergarde Keep, Westguard Keep, Valgarde Port
				["0.72:0.60:0.69:0.58:0.60:0.48:0.46:0.54:0.41:0.57:0.38:0.79"] = 416, -- The Argent Stand, Light's Breach, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp, The Shadow Vault
				["0.72:0.60:0.64:0.58:0.62:0.64:0.72:0.71"] = 193, -- The Argent Stand, Ebon Watch, K3, Dun Nifflelem
				["0.72:0.60:0.64:0.58:0.52:0.62:0.49:0.79"] = 233, -- The Argent Stand, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.72:0.60:0.64:0.58:0.52:0.62:0.49:0.42:0.42:0.47"] = 319, -- The Argent Stand, Ebon Watch, Dalaran, Moa'ki, Stars' Rest
				["0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64:0.28:0.72"] = 364, -- The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard, Death's Rise
				["0.72:0.60:0.69:0.58:0.60:0.48:0.46:0.54:0.41:0.57:0.24:0.60"] = 392, -- The Argent Stand, Light's Breach, Wintergarde Keep, Fordragon Hold, Valiance Landing Camp, River's Heart
				["0.72:0.60:0.69:0.58:0.60:0.48:0.49:0.42:0.52:0.62"] = 320, -- The Argent Stand, Light's Breach, Wintergarde Keep, Moa'ki, Dalaran
				["0.72:0.60:0.69:0.58:0.73:0.46:0.76:0.33:0.74:0.29:0.49:0.42:0.29:0.43:0.21:0.51"] = 644, -- The Argent Stand, Light's Breach, Amberpine Lodge, Westguard Keep, Kamagua, Moa'ki, Unu'pe, Fizzcrank Airstrip

				-- Alliance: Zul'Drak: Zim'Torga
				["0.78:0.62:0.83:0.54"] = 56, -- Zim'Torga, Westfall Brigade
				["0.78:0.62:0.83:0.54:0.88:0.40"] = 142, -- Zim'Torga, Westfall Brigade, Fort Wildervar
				["0.78:0.62:0.82:0.69"] = 54, -- Zim'Torga, Gundrak
				["0.78:0.62:0.83:0.54:0.88:0.40:0.88:0.28"] = 215, -- Zim'Torga, Westfall Brigade, Fort Wildervar, Valgarde Port
				["0.78:0.62:0.72:0.60"] = 54, -- Zim'Torga, The Argent Stand
				["0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62"] = 173, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran
				["0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.22:0.39"] = 388, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Valiance Keep
				["0.78:0.62:0.83:0.54:0.73:0.46"] = 135, -- Zim'Torga, Westfall Brigade, Amberpine Lodge
				["0.78:0.62:0.83:0.54:0.73:0.46:0.76:0.33"] = 217, -- Zim'Torga, Westfall Brigade, Amberpine Lodge, Westguard Keep
				["0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48"] = 159, -- Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep
				["0.78:0.62:0.83:0.54:0.73:0.46:0.76:0.33:0.74:0.29"] = 268, -- Zim'Torga, Westfall Brigade, Amberpine Lodge, Westguard Keep, Kamagua
				["0.78:0.62:0.72:0.60:0.69:0.58"] = 77, -- Zim'Torga, The Argent Stand, Light's Breach
				["0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.29:0.43"] = 357, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Unu'pe
				["0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47:0.12:0.47"] = 466, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge, Transitus Shield
				["0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51:0.17:0.47"] = 430, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip, Amber Ledge
				["0.78:0.62:0.83:0.54:0.73:0.46:0.60:0.48"] = 214, -- Zim'Torga, Westfall Brigade, Amberpine Lodge, Wintergarde Keep
				["0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47"] = 266, -- Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Stars' Rest
				["0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.49:0.42"] = 251, -- Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Moa'ki
				["0.78:0.62:0.72:0.60:0.64:0.58"] = 106, -- Zim'Torga, The Argent Stand, Ebon Watch
				["0.78:0.62:0.83:0.54:0.73:0.46:0.60:0.48:0.42:0.47:0.21:0.51:0.24:0.60"] = 510, -- Zim'Torga, Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip, River's Heart
				["0.78:0.62:0.72:0.60:0.64:0.58:0.62:0.64"] = 146, -- Zim'Torga, The Argent Stand, Ebon Watch, K3
				["0.78:0.62:0.64:0.81"] = 154, -- Zim'Torga, Ulduar
				["0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48"] = 196, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple
				["0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47:0.21:0.51"] = 386, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest, Fizzcrank Airstrip
				["0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46"] = 159, -- Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge
				["0.78:0.62:0.72:0.71"] = 85, -- Зим'Торга, Дун Ниффелем
				["0.78:0.62:0.64:0.81:0.57:0.67"] = 257, -- Zim'Torga, Ulduar, Frosthold
				["0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.54:0.48:0.52:0.62"] = 299, -- Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Wyrmrest Temple, Dalaran
				["0.78:0.62:0.83:0.54:0.73:0.46:0.76:0.33:0.88:0.28"] = 286, -- Zim'Torga, Westfall Brigade, Amberpine Lodge, Westguard Keep, Valgarde Port
				["0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60"] = 370, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, River's Heart
				["0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47:0.21:0.51"] = 392, -- Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Stars' Rest, Fizzcrank Airstrip
				["0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.24:0.60:0.18:0.60"] = 405, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, River's Heart, Nesingwary Base Camp
				["0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46:0.76:0.33:0.74:0.29"] = 292, -- Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge, Westguard Keep, Kamagua
				["0.78:0.62:0.83:0.54:0.73:0.46:0.60:0.48:0.42:0.47"] = 323, -- Zim'Torga, Westfall Brigade, Amberpine Lodge, Wintergarde Keep, Stars' Rest
				["0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46:0.88:0.40"] = 275, -- Zim'Torga, Argentumwache, Lichtbresche, Ammertannhütte, Fort Wildervar
				["0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66:0.28:0.72"] = 365, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle, Death's Rise
				["0.78:0.62:0.83:0.54:0.73:0.46:0.69:0.58"] = 200, -- Zim'Torga, Westfall Brigade, Amberpine Lodge, Light's Breach
				["0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.42:0.47"] = 262, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Stars' Rest
				["0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46:0.76:0.33:0.88:0.28"] = 311, -- Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge, Westguard Keep, Valgarde Port
				["0.78:0.62:0.72:0.60:0.64:0.58:0.54:0.48:0.49:0.42"] = 248, -- Zim'Torga, The Argent Stand, Ebon Watch, Wyrmrest Temple, Moa'ki
				["0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47:0.22:0.39"] = 394, -- Zim'Torga, The Argent Stand, Light's Breach, Wintergarde Keep, Stars' Rest, Valiance Keep
				["0.78:0.62:0.72:0.60:0.64:0.58:0.46:0.54"] = 216, -- Zim'Torga, The Argent Stand, Ebon Watch, Fordragon Hold
				["0.78:0.62:0.72:0.71:0.62:0.64:0.52:0.62"] = 243, -- Зим'Торга, Дун Ниффелем, К-3, Даларан
				["0.78:0.62:0.64:0.81:0.57:0.79"] = 202, -- Zim'Torga, Ulduar, Bouldercrag's Refuge
				["0.78:0.62:0.72:0.60:0.64:0.58:0.59:0.57"] = 138, -- Zim'Torga, The Argent Stand, Ebon Watch, Windrunner's Overlook
				["0.78:0.62:0.72:0.60:0.64:0.58:0.62:0.64:0.57:0.67"] = 188, -- Zim'Torga, The Argent Stand, Ebon Watch, K3, Frosthold
				["0.78:0.62:0.64:0.81:0.57:0.79:0.38:0.79"] = 316, -- Zim'Torga, Ulduar, Bouldercrag's Refuge, The Shadow Vault
				["0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.52:0.66"] = 198, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Crusaders' Pinnacle
				["0.78:0.62:0.72:0.60:0.69:0.58:0.73:0.46:0.76:0.33"] = 242, -- Zim'Torga, The Argent Stand, Light's Breach, Amberpine Lodge, Westguard Keep
				["0.78:0.62:0.72:0.60:0.64:0.58:0.46:0.54:0.41:0.57"] = 275, -- Zim'Torga, The Argent Stand, Ebon Watch, Fordragon Hold, Valiance Landing Camp
				["0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47:0.29:0.43"] = 363, -- Zim'Torga, Argentumwache, Lichtbresche, Feste Wintergarde, Sternenruh, Unu'pe
				["0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.54:0.48"] = 206, -- Zim'Torga, Argentumwache, Lichtbresche, Feste Wintergarde, Wyrmruhtempel
				["0.78:0.62:0.72:0.60:0.69:0.58:0.60:0.48:0.42:0.47:0.21:0.51:0.24:0.60"] = 455, -- Zim'Torga, Argentumwache, Lichtbresche, Feste Wintergarde, Sternenruh, Landebahn Kurbelzisch, Flussnabel
				["0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64"] = 193, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard
				["0.78:0.62:0.72:0.60:0.64:0.58:0.46:0.54:0.41:0.57:0.28:0.72"] = 441, -- Zim'Torga, The Argent Stand, Ebon Watch, Fordragon Hold, Valiance Landing Camp, Death's Rise
				["0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.56:0.64:0.57:0.67"] = 232, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, The Argent Vanguard, Frosthold
				["0.78:0.62:0.64:0.81:0.57:0.79:0.51:0.21"] = 263, -- Zim'Torga, Ulduar, Bouldercrag's Refuge, Argent Tournament Grounds
				["0.78:0.62:0.72:0.60:0.64:0.58:0.52:0.62:0.49:0.79"] = 285, -- Zim'Torga, The Argent Stand, Ebon Watch, Dalaran, Argent Tournament Grounds
				["0.78:0.62:0.72:0.60:0.64:0.58:0.60:0.48:0.76:0.33:0.74:0.29"] = 336, -- Zim'Torga, The Argent Stand, Ebon Watch, Wintergarde Keep, Westguard Keep, Kamagua
				["0.78:0.62:0.83:0.54:0.73:0.46:0.69:0.58:0.64:0.58:0.52:0.62"] = 305, -- Zim'Torga, Westfall Brigade, Amberpine Lodge, Light's Breach, Ebon Watch, Dalaran
				["0.78:0.62:0.72:0.71:0.62:0.64:0.57:0.67:0.57:0.79:0.51:0.21"] = 341, -- Zim'Torga, Dun Nifflelem, K3, Frosthold, Bouldercrag's Refuge, Argent Tournament Grounds

			},

		}

	end
