if not WeakAuras.IsLibsOK() then return end
local AddonName = ...
local Private = select(2, ...)

-- Talent Data for the Warmane TBC Realms "Onyxia" and "Blackrock TBC"
if not WeakAuras.IsTBC() then
  return
end

local WeakAuras = WeakAuras;
local L = WeakAuras.L;

local encounter_list = ""
function Private.InitializeEncounterAndZoneLists()
  if encounter_list ~= "" then
    return
  end
  local raids = {
    {
      L["Karazhan"],
      {
        { L["Attumen the Huntsman"], 652 },
        { L["Moroes"], 653 },
        { L["Maiden of Virtue"], 654 },
        { L["Opera Hall"], 655 },
        { L["The Curator"], 656 },
        { L["Terestian Illhoof"], 657 },
        { L["Shade of Aran"], 658 },
        { L["Netherspite"], 659 },
        { L["Chess Event"], 660 },
        { L["Prince Malchezaar"], 661 },
        { L["Nightbane"], 662 },
      }
    },
    {
      L["Gruul's Lair"],
      {
        { L["High King Maulgar"], 649 },
        { L["Gruul the Dragonkiller"], 650 },
      }
    },
    {
      L["Magtheridon's Lair"],
      {
        { L["Magtheridon"], 651 },
      }
    },
    {
      L["Coilfang: Serpentshrine Cavern"],
      {
        { L["Hydross the Unstable"], 623 },
        { L["The Lurker Below"], 624 },
        { L["Leotheras the Blind"], 625 },
        { L["Fathom-Lord Karathress"], 626 },
        { L["Morogrim Tidewalker"], 627 },
        { L["Lady Vashj"], 628 },
      }
    },
    {
      L["Tempest Keep"],
      {
        { L["Al'ar"], 730 },
        { L["Void Reaver"], 731 },
        { L["High Astromancer Solarian"], 732 },
        { L["Kael'thas Sunstrider"], 733 },
      }
    },
    {
      L["The Battle for Mount Hyjal"],
      {
        { L["Rage Winterchill"], 618 },
        { L["Anetheron"], 619 },
        { L["Kaz'rogal"], 620 },
        { L["Azgalor"], 621 },
        { L["Archimonde"], 622 },
      }
    },
    {
      L["Black Temple"],
      {
        { L["High Warlord Naj'entus"], 601 },
        { L["Supremus"], 602 },
        { L["Shade of Akama"], 603 },
        { L["Teron Gorefiend"], 604 },
        { L["Gurtogg Bloodboil"], 605 },
        { L["Reliquary of Souls"], 606 },
        { L["Mother Shahraz"], 607 },
        { L["The Illidari Council"], 608 },
        { L["Illidan Stormrage"], 609 },
      }
    },
    {
      L["Zul'Aman"],
      {
        { L["Akil'zon"], 1189 },
        { L["Nalorakk"], 1190 },
        { L["Jan'alai"], 1191 },
        { L["Halazzi"], 1192 },
        { L["Hex Lord Malacrass"], 1193 },
        { L["Daakara"], 1194 },
      }
    },
    {
      L["The Sunwell Plateau"],
      {
        { L["Kalecgos"], 724 },
        { L["Brutallus"], 725 },
        { L["Felmyst"], 726 },
        { L["Eredar Twins"], 727 },
        { L["M'uru"], 728 },
        { L["Kil'jaeden"], 729 },
      }
    }
  }
  encounter_list = (WeakAuras.IsDBMRegistered() and "" or "|cFFFF0000") .. L["Requires Deadly Boss Mods (DBM) to detect encounters."] .. (WeakAuras.IsDBMRegistered() and "" or "|r") .. "\n\n"
  for _, raid in ipairs(raids) do
    encounter_list = ("%s|cffffd200%s|r\n"):format(encounter_list, raid[1])
    for _, boss in ipairs(raid[2]) do
        encounter_list = ("%s%s: %d\n"):format(encounter_list, boss[1], boss[2])
    end
    encounter_list = encounter_list .. "\n"
  end

  encounter_list = encounter_list:sub(1, -3) .. "\n\n" .. L["Based on "] .. "https://wago.tools/db2/DungeonEncounter?build=3.4.5.63009\n" .. L["Supports multiple entries, separated by commas\n"]
end

function Private.get_encounters_list()
  return encounter_list
end

Private.talentInfo = {
  ["HUNTER"] = {
    {
      "Interface\\Icons\\Spell_Nature_RavenForm", -- [1]
      1, -- [2]
      2, -- [3]
      19552, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Spell_Nature_Reincarnation", -- [1]
      1, -- [2]
      3, -- [3]
      19583, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Ability_Hunter_SilentHunter", -- [1]
      2, -- [2]
      1, -- [3]
      35029, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Ability_Hunter_AspectOfTheMonkey", -- [1]
      2, -- [2]
      2, -- [3]
      19549, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\INV_Misc_Pelt_Bear_03", -- [1]
      2, -- [2]
      3, -- [3]
      19609, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Ability_Hunter_BeastSoothe", -- [1]
      2, -- [2]
      4, -- [3]
      24443, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Ability_Mount_JungleTiger", -- [1]
      3, -- [2]
      1, -- [3]
      19559, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Ability_Druid_Dash", -- [1]
      3, -- [2]
      2, -- [3]
      19596, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Ability_BullRush", -- [1]
      3, -- [2]
      3, -- [3]
      19616, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Ability_Hunter_MendPet", -- [1]
      4, -- [2]
      2, -- [3]
      19572, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\INV_Misc_MonsterClaw_04", -- [1]
      4, -- [2]
      3, -- [3]
      19598, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Ability_Druid_DemoralizingRoar", -- [1]
      5, -- [2]
      1, -- [3]
      19578, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Ability_Devour", -- [1]
      5, -- [2]
      2, -- [3]
      19577, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Nature_AbolishMagic", -- [1]
      5, -- [2]
      4, -- [3]
      19590, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Ability_Hunter_AnimalHandler", -- [1]
      6, -- [2]
      1, -- [3]
      34453, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\INV_Misc_MonsterClaw_03", -- [1]
      6, -- [2]
      3, -- [3]
      19621, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Ability_Hunter_FerociousInspiration", -- [1]
      7, -- [2]
      1, -- [3]
      34455, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Ability_Druid_FerociousBite", -- [1]
      7, -- [2]
      2, -- [3]
      19574, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Ability_Hunter_CatlikeReflexes", -- [1]
      7, -- [2]
      3, -- [3]
      34462, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Ability_Hunter_SerpentSwiftness", -- [1]
      8, -- [2]
      3, -- [3]
      34466, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Ability_Hunter_BeastWithin", -- [1]
      9, -- [2]
      2, -- [3]
      34692, -- [4]
    }, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Spell_Frost_Stun", -- [1]
      1, -- [2]
      2, -- [3]
      19407, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Ability_SearingArrow", -- [1]
      1, -- [2]
      3, -- [3]
      19426, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Ability_Hunter_SniperShot", -- [1]
      2, -- [2]
      2, -- [3]
      19421, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Spell_Frost_WizardMark", -- [1]
      2, -- [2]
      3, -- [3]
      19416, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Ability_Hunter_GoForTheThroat", -- [1]
      3, -- [2]
      1, -- [3]
      34950, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Ability_ImpalingBolt", -- [1]
      3, -- [2]
      2, -- [3]
      19454, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\INV_Spear_07", -- [1]
      3, -- [2]
      3, -- [3]
      19434, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Ability_Hunter_RapidKilling", -- [1]
      3, -- [2]
      4, -- [3]
      34948, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Ability_Hunter_Quickshot", -- [1]
      4, -- [2]
      2, -- [3]
      19464, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Ability_PierceDamage", -- [1]
      4, -- [2]
      3, -- [3]
      19485, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Spell_Arcane_StarFire", -- [1]
      5, -- [2]
      1, -- [3]
      35100, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Ability_GolemStormBolt", -- [1]
      5, -- [2]
      2, -- [3]
      19503, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Ability_UpgradeMoonGlaive", -- [1]
      5, -- [2]
      3, -- [3]
      19461, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Ability_Hunter_CombatExperience", -- [1]
      6, -- [2]
      1, -- [3]
      34475, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\INV_Weapon_Rifle_06", -- [1]
      6, -- [2]
      4, -- [3]
      19507, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Ability_Hunter_ZenArchery", -- [1]
      7, -- [2]
      1, -- [3]
      34482, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Ability_TrueShot", -- [1]
      7, -- [2]
      2, -- [3]
      19506, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Ability_UpgradeMoonGlaive", -- [1]
      7, -- [2]
      3, -- [3]
      35104, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Ability_Hunter_MasterMarksman", -- [1]
      8, -- [2]
      2, -- [3]
      34485, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Ability_TheBlackArrow", -- [1]
      9, -- [2]
      2, -- [3]
      34490, -- [4]
    }, -- [60]
    nil, -- [61]
    nil, -- [62]
    nil, -- [63]
    nil, -- [64]
    nil, -- [65]
    nil, -- [66]
    nil, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\INV_Misc_Head_Dragon_Black", -- [1]
      1, -- [2]
      1, -- [3]
      24293, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Holy_PrayerOfHealing", -- [1]
      1, -- [2]
      2, -- [3]
      19151, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Ability_TownWatch", -- [1]
      1, -- [2]
      3, -- [3]
      19498, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Ability_Racial_BloodRage", -- [1]
      1, -- [2]
      4, -- [3]
      19159, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Nature_StrangleVines", -- [1]
      2, -- [2]
      1, -- [3]
      19184, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Ability_Parry", -- [1]
      2, -- [2]
      2, -- [3]
      19295, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Ability_Rogue_Trip", -- [1]
      2, -- [2]
      3, -- [3]
      19228, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Nature_TimeStop", -- [1]
      3, -- [2]
      1, -- [3]
      19239, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Spell_Shadow_Twilight", -- [1]
      3, -- [2]
      2, -- [3]
      19255, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Ability_Whirlwind", -- [1]
      3, -- [2]
      3, -- [3]
      19263, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Ability_Ensnare", -- [1]
      4, -- [2]
      1, -- [3]
      19376, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Ability_Kick", -- [1]
      4, -- [2]
      2, -- [3]
      19290, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Ability_Rogue_FeignDeath", -- [1]
      4, -- [2]
      4, -- [3]
      19286, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Ability_Hunter_SurvivalInstincts", -- [1]
      5, -- [2]
      1, -- [3]
      34494, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfStamina", -- [1]
      5, -- [2]
      2, -- [3]
      19370, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Ability_Warrior_Challange", -- [1]
      5, -- [2]
      3, -- [3]
      19306, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Ability_Hunter_Resourcefulness", -- [1]
      6, -- [2]
      1, -- [3]
      34491, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Spell_Nature_Invisibilty", -- [1]
      6, -- [2]
      3, -- [3]
      19168, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Ability_Hunter_ThrilloftheHunt", -- [1]
      7, -- [2]
      1, -- [3]
      34497, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\INV_Spear_02", -- [1]
      7, -- [2]
      2, -- [3]
      19386, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Ability_Rogue_FindWeakness", -- [1]
      7, -- [2]
      3, -- [3]
      34500, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Ability_Hunter_MasterTactitian", -- [1]
      8, -- [2]
      2, -- [3]
      34506, -- [4]
    }, -- [102]
    {
      "Interface\\Icons\\Ability_Hunter_Readiness", -- [1]
      9, -- [2]
      2, -- [3]
      23989, -- [4]
    }, -- [103]
    nil, -- [104]
    nil, -- [105]
    nil, -- [106]
    nil, -- [107]
    nil, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "HunterBeastMastery", -- [1]
      "HunterMarksmanship", -- [2]
      "HunterSurvival", -- [3]
    }, -- [121]
  },
  ["WARRIOR"] = {
    {
      "Interface\\Icons\\Ability_Rogue_Ambush", -- [1]
      1, -- [2]
      1, -- [3]
      12282, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Ability_Parry", -- [1]
      1, -- [2]
      2, -- [3]
      16462, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Ability_Gouge", -- [1]
      1, -- [2]
      3, -- [3]
      12286, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Ability_Warrior_Charge", -- [1]
      2, -- [2]
      1, -- [3]
      12285, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Spell_Magic_MageArmor", -- [1]
      2, -- [2]
      2, -- [3]
      12300, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Ability_ThunderClap", -- [1]
      2, -- [2]
      3, -- [3]
      12287, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\INV_Sword_05", -- [1]
      3, -- [2]
      1, -- [3]
      12290, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfStamina", -- [1]
      3, -- [2]
      2, -- [3]
      12296, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Ability_BackStab", -- [1]
      3, -- [2]
      3, -- [3]
      12834, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\INV_Axe_09", -- [1]
      4, -- [2]
      2, -- [3]
      12163, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Ability_SearingArrow", -- [1]
      4, -- [2]
      3, -- [3]
      16493, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\INV_Axe_06", -- [1]
      5, -- [2]
      1, -- [3]
      12700, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Shadow_DeathPact", -- [1]
      5, -- [2]
      2, -- [3]
      12292, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\INV_Mace_01", -- [1]
      5, -- [2]
      3, -- [3]
      12284, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\INV_Sword_27", -- [1]
      5, -- [2]
      4, -- [3]
      12281, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Ability_Rogue_Sprint", -- [1]
      6, -- [2]
      1, -- [3]
      29888, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Ability_ShockWave", -- [1]
      6, -- [2]
      3, -- [3]
      12289, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Ability_Warrior_ImprovedDisciplines", -- [1]
      6, -- [2]
      4, -- [3]
      29723, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Ability_Warrior_BloodFrenzy", -- [1]
      7, -- [2]
      1, -- [3]
      29836, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Ability_Warrior_SavageBlow", -- [1]
      7, -- [2]
      2, -- [3]
      12294, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Ability_Hunter_Harass", -- [1]
      7, -- [2]
      3, -- [3]
      29834, -- [4]
    }, -- [21]
    {
      "Interface\\Icons\\Ability_Warrior_SavageBlow", -- [1]
      8, -- [2]
      2, -- [3]
      35446, -- [4]
    }, -- [22]
    {
      "Interface\\Icons\\Ability_Warrior_EndlessRage", -- [1]
      9, -- [2]
      2, -- [3]
      29623, -- [4]
    }, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Spell_Nature_Purge", -- [1]
      1, -- [2]
      2, -- [3]
      12321, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Ability_Rogue_Eviscerate", -- [1]
      1, -- [2]
      3, -- [3]
      12320, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Ability_Warrior_WarCry", -- [1]
      2, -- [2]
      2, -- [3]
      12324, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Spell_Nature_StoneClawTotem", -- [1]
      2, -- [2]
      3, -- [3]
      12322, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Ability_Warrior_Cleave", -- [1]
      3, -- [2]
      1, -- [3]
      12329, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Spell_Shadow_DeathScream", -- [1]
      3, -- [2]
      2, -- [3]
      12323, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Shadow_SummonImp", -- [1]
      3, -- [2]
      3, -- [3]
      16487, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Spell_Nature_FocusedMind", -- [1]
      3, -- [2]
      4, -- [3]
      12318, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Ability_DualWield", -- [1]
      4, -- [2]
      1, -- [3]
      23584, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\INV_Sword_48", -- [1]
      4, -- [2]
      2, -- [3]
      20502, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Spell_Shadow_UnholyFrenzy", -- [1]
      4, -- [2]
      3, -- [3]
      12317, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Ability_Warrior_DecisiveStrike", -- [1]
      5, -- [2]
      1, -- [3]
      12862, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Ability_Rogue_SliceDice", -- [1]
      5, -- [2]
      2, -- [3]
      12328, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Ability_Warrior_WeaponMastery", -- [1]
      5, -- [2]
      4, -- [3]
      20504, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Spell_Nature_AncestralGuardian", -- [1]
      6, -- [2]
      1, -- [3]
      20500, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Ability_GhoulFrenzy", -- [1]
      6, -- [2]
      3, -- [3]
      12319, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Ability_Marksmanship", -- [1]
      7, -- [2]
      1, -- [3]
      29590, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Spell_Nature_BloodLust", -- [1]
      7, -- [2]
      2, -- [3]
      23881, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Ability_Whirlwind", -- [1]
      7, -- [2]
      3, -- [3]
      29721, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Ability_Racial_Avatar", -- [1]
      8, -- [2]
      3, -- [3]
      29759, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Ability_Warrior_Rampage", -- [1]
      9, -- [2]
      2, -- [3]
      29801, -- [4]
    }, -- [61]
    nil, -- [62]
    nil, -- [63]
    nil, -- [64]
    nil, -- [65]
    nil, -- [66]
    nil, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Ability_Racial_BloodRage", -- [1]
      1, -- [2]
      1, -- [3]
      12301, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Nature_EnchantArmor", -- [1]
      1, -- [2]
      2, -- [3]
      12295, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Nature_MirrorImage", -- [1]
      1, -- [2]
      3, -- [3]
      12297, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\INV_Shield_06", -- [1]
      2, -- [2]
      2, -- [3]
      12298, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Holy_Devotion", -- [1]
      2, -- [2]
      3, -- [3]
      12299, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_Holy_AshesToAshes", -- [1]
      3, -- [2]
      1, -- [3]
      12975, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Ability_Defend", -- [1]
      3, -- [2]
      2, -- [3]
      12945, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Ability_Warrior_Revenge", -- [1]
      3, -- [2]
      3, -- [3]
      12797, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Ability_Warrior_InnerRage", -- [1]
      3, -- [2]
      4, -- [3]
      12303, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Ability_Warrior_Sunder", -- [1]
      4, -- [2]
      1, -- [3]
      12308, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Ability_Warrior_Disarm", -- [1]
      4, -- [2]
      2, -- [3]
      12313, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Spell_Nature_Reincarnation", -- [1]
      4, -- [2]
      3, -- [3]
      12302, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Ability_Warrior_ShieldWall", -- [1]
      5, -- [2]
      1, -- [3]
      12312, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Ability_ThunderBolt", -- [1]
      5, -- [2]
      2, -- [3]
      12809, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Ability_Warrior_ShieldBash", -- [1]
      5, -- [2]
      3, -- [3]
      12311, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Ability_Warrior_ShieldMastery", -- [1]
      6, -- [2]
      1, -- [3]
      29598, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\INV_Sword_20", -- [1]
      6, -- [2]
      3, -- [3]
      16538, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Ability_Warrior_DefensiveStance", -- [1]
      7, -- [2]
      1, -- [3]
      29593, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\INV_Shield_05", -- [1]
      7, -- [2]
      2, -- [3]
      23922, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Ability_Warrior_FocusedRage", -- [1]
      7, -- [2]
      3, -- [3]
      29787, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\INV_Helmet_21", -- [1]
      8, -- [2]
      2, -- [3]
      29140, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\INV_Sword_11", -- [1]
      9, -- [2]
      2, -- [3]
      20243, -- [4]
    }, -- [102]
    nil, -- [103]
    nil, -- [104]
    nil, -- [105]
    nil, -- [106]
    nil, -- [107]
    nil, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "WarriorArms", -- [1]
      "WarriorFury", -- [2]
      "WarriorProtection", -- [3]
    }, -- [121]
  },
  ["SHAMAN"] = {
    {
      "Interface\\Icons\\Spell_Nature_WispSplode", -- [1]
      1, -- [2]
      2, -- [3]
      16039, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Spell_Fire_Fireball", -- [1]
      1, -- [2]
      3, -- [3]
      16035, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Spell_Nature_StoneClawTotem", -- [1]
      2, -- [2]
      1, -- [3]
      16043, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Spell_Nature_SpiritArmor", -- [1]
      2, -- [2]
      2, -- [3]
      28996, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Spell_Fire_Immolation", -- [1]
      2, -- [2]
      3, -- [3]
      16038, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Spell_Shadow_ManaBurn", -- [1]
      3, -- [2]
      1, -- [3]
      16164, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_Frost_FrostWard", -- [1]
      3, -- [2]
      2, -- [3]
      16040, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_Nature_CallStorm", -- [1]
      3, -- [2]
      3, -- [3]
      16041, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Spell_Fire_SealOfFire", -- [1]
      4, -- [2]
      1, -- [3]
      16086, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Spell_Shadow_SoulLeech_2", -- [1]
      4, -- [2]
      2, -- [3]
      29062, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Spell_Fire_ElementalDevastation", -- [1]
      4, -- [2]
      4, -- [3]
      30160, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Spell_Nature_StormReach", -- [1]
      5, -- [2]
      1, -- [3]
      28999, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Fire_Volcano", -- [1]
      5, -- [2]
      2, -- [3]
      16089, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Nature_UnrelentingStorm", -- [1]
      5, -- [2]
      4, -- [3]
      30664, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Spell_Nature_ElementalPrecision_1", -- [1]
      6, -- [2]
      1, -- [3]
      30672, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Spell_Lightning_LightningBolt01", -- [1]
      6, -- [2]
      3, -- [3]
      16578, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Spell_Nature_WispHeal", -- [1]
      7, -- [2]
      2, -- [3]
      16166, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Nature_ElementalShields", -- [1]
      7, -- [2]
      3, -- [3]
      30669, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Spell_Nature_LightningOverload", -- [1]
      8, -- [2]
      2, -- [3]
      30675, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Spell_Fire_TotemOfWrath", -- [1]
      9, -- [2]
      2, -- [3]
      30706, -- [4]
    }, -- [20]
    nil, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Spell_Shadow_GrimWard", -- [1]
      1, -- [2]
      2, -- [3]
      17485, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\INV_Shield_06", -- [1]
      1, -- [2]
      3, -- [3]
      16253, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Spell_Nature_StoneSkinTotem", -- [1]
      2, -- [2]
      1, -- [3]
      16258, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Ability_ThunderBolt", -- [1]
      2, -- [2]
      2, -- [3]
      16255, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Spell_Nature_SpiritWolf", -- [1]
      2, -- [2]
      3, -- [3]
      16262, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Spell_Nature_LightningShield", -- [1]
      2, -- [2]
      4, -- [3]
      16261, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Nature_EarthBindTotem", -- [1]
      3, -- [2]
      1, -- [3]
      16259, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Spell_Nature_ElementalAbsorption", -- [1]
      3, -- [2]
      3, -- [3]
      43338, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Spell_Nature_MirrorImage", -- [1]
      3, -- [2]
      4, -- [3]
      16254, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Ability_GhoulFrenzy", -- [1]
      4, -- [2]
      2, -- [3]
      16256, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Spell_Holy_Devotion", -- [1]
      4, -- [2]
      3, -- [3]
      16252, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Fire_EnchantWeapon", -- [1]
      5, -- [2]
      1, -- [3]
      29192, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Ability_Parry", -- [1]
      5, -- [2]
      2, -- [3]
      16268, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Spell_Fire_FlameTounge", -- [1]
      5, -- [2]
      3, -- [3]
      16266, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Spell_Nature_MentalQuickness", -- [1]
      6, -- [2]
      1, -- [3]
      30812, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Ability_Hunter_SwiftStrike", -- [1]
      6, -- [2]
      4, -- [3]
      29082, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Ability_DualWieldSpecialization", -- [1]
      7, -- [2]
      1, -- [3]
      30816, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Ability_DualWield", -- [1]
      7, -- [2]
      2, -- [3]
      30798, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Ability_Shaman_Stormstrike", -- [1]
      7, -- [2]
      3, -- [3]
      17364, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Spell_Nature_UnleashedRage", -- [1]
      8, -- [2]
      2, -- [3]
      30802, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Spell_Nature_ShamanRage", -- [1]
      9, -- [2]
      2, -- [3]
      30823, -- [4]
    }, -- [61]
    nil, -- [62]
    nil, -- [63]
    nil, -- [64]
    nil, -- [65]
    nil, -- [66]
    nil, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Spell_Nature_MagicImmunity", -- [1]
      1, -- [2]
      2, -- [3]
      16182, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Frost_ManaRecharge", -- [1]
      1, -- [2]
      3, -- [3]
      16179, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Nature_Reincarnation", -- [1]
      2, -- [2]
      1, -- [3]
      16184, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Spell_Nature_UndyingStrength", -- [1]
      2, -- [2]
      2, -- [3]
      16176, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Nature_MoonGlow", -- [1]
      2, -- [2]
      3, -- [3]
      16173, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_Frost_Stun", -- [1]
      3, -- [2]
      1, -- [3]
      16180, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_Nature_HealingWaveLesser", -- [1]
      3, -- [2]
      2, -- [3]
      16181, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Nature_NullWard", -- [1]
      3, -- [2]
      3, -- [3]
      16189, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Spell_Nature_HealingTouch", -- [1]
      3, -- [2]
      4, -- [3]
      29187, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Spell_Nature_ManaRegenTotem", -- [1]
      4, -- [2]
      2, -- [3]
      16187, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_Nature_Tranquility", -- [1]
      4, -- [2]
      3, -- [3]
      16194, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Spell_Nature_HealingWay", -- [1]
      5, -- [2]
      1, -- [3]
      29206, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Spell_Nature_RavenForm", -- [1]
      5, -- [2]
      3, -- [3]
      16188, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Nature_FocusedMind", -- [1]
      5, -- [2]
      4, -- [3]
      30864, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Frost_WizardMark", -- [1]
      6, -- [2]
      3, -- [3]
      16178, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Spell_Frost_SummonWaterElemental", -- [1]
      7, -- [2]
      2, -- [3]
      16190, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Spell_Nature_NatureGuardian", -- [1]
      7, -- [2]
      3, -- [3]
      30881, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Spell_Nature_NatureBlessing", -- [1]
      8, -- [2]
      2, -- [3]
      30867, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Spell_Nature_HealingWaveGreater", -- [1]
      8, -- [2]
      3, -- [3]
      30872, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Spell_Nature_SkinofEarth", -- [1]
      9, -- [2]
      2, -- [3]
      974, -- [4]
    }, -- [100]
    nil, -- [101]
    nil, -- [102]
    nil, -- [103]
    nil, -- [104]
    nil, -- [105]
    nil, -- [106]
    nil, -- [107]
    nil, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "ShamanElementalCombat", -- [1]
      "ShamanEnhancement", -- [2]
      "ShamanRestoration", -- [3]
    }, -- [121]
  },
  ["MAGE"] = {
    {
      "Interface\\Icons\\Spell_Holy_DispelMagic", -- [1]
      1, -- [2]
      1, -- [3]
      11210, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Spell_Holy_Devotion", -- [1]
      1, -- [2]
      2, -- [3]
      11222, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Spell_Nature_StarFall", -- [1]
      1, -- [2]
      3, -- [3]
      11237, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\INV_Wand_01", -- [1]
      2, -- [2]
      1, -- [3]
      6057, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Spell_Nature_AstralRecalGroup", -- [1]
      2, -- [2]
      2, -- [3]
      29441, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Spell_Shadow_ManaBurn", -- [1]
      2, -- [2]
      3, -- [3]
      11213, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_Nature_AbolishMagic", -- [1]
      3, -- [2]
      1, -- [3]
      11247, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_Nature_WispSplode", -- [1]
      3, -- [2]
      2, -- [3]
      11242, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Spell_Arcane_ArcaneResilience", -- [1]
      3, -- [2]
      4, -- [3]
      28574, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Spell_Shadow_DetectLesserInvisibility", -- [1]
      4, -- [2]
      1, -- [3]
      11252, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Spell_Frost_IceShock", -- [1]
      4, -- [2]
      2, -- [3]
      11255, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Spell_Shadow_SiphonMana", -- [1]
      4, -- [2]
      4, -- [3]
      18462, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Arcane_Blink", -- [1]
      5, -- [2]
      1, -- [3]
      31569, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Nature_EnchantArmor", -- [1]
      5, -- [2]
      2, -- [3]
      12043, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Spell_Shadow_Charm", -- [1]
      5, -- [2]
      4, -- [3]
      11232, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Spell_Arcane_PrismaticCloak", -- [1]
      6, -- [2]
      1, -- [3]
      31574, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Spell_Shadow_Teleport", -- [1]
      6, -- [2]
      2, -- [3]
      15058, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Arcane_ArcanePotency", -- [1]
      6, -- [2]
      3, -- [3]
      31571, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Spell_Nature_StarFall", -- [1]
      7, -- [2]
      1, -- [3]
      31579, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Spell_Nature_Lightning", -- [1]
      7, -- [2]
      2, -- [3]
      12042, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Spell_Arcane_ArcaneTorrent", -- [1]
      7, -- [2]
      3, -- [3]
      35578, -- [4]
    }, -- [21]
    {
      "Interface\\Icons\\Spell_Arcane_MindMastery", -- [1]
      8, -- [2]
      2, -- [3]
      31584, -- [4]
    }, -- [22]
    {
      "Interface\\Icons\\Spell_Nature_Slow", -- [1]
      9, -- [2]
      2, -- [3]
      31589, -- [4]
    }, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Spell_Fire_FlameBolt", -- [1]
      1, -- [2]
      2, -- [3]
      11069, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Spell_Fire_MeteorStorm", -- [1]
      1, -- [2]
      3, -- [3]
      11103, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Spell_Fire_Incinerate", -- [1]
      2, -- [2]
      1, -- [3]
      11119, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Spell_Fire_Flare", -- [1]
      2, -- [2]
      2, -- [3]
      11100, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Spell_Fire_Fireball", -- [1]
      2, -- [2]
      3, -- [3]
      11078, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Spell_Fire_FlameShock", -- [1]
      3, -- [2]
      1, -- [3]
      18459, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Fire_SelfDestruct", -- [1]
      3, -- [2]
      2, -- [3]
      11108, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Spell_Fire_Fireball02", -- [1]
      3, -- [2]
      3, -- [3]
      11366, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Spell_Fire_Fire", -- [1]
      3, -- [2]
      4, -- [3]
      11083, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Spell_Fire_SoulBurn", -- [1]
      4, -- [2]
      1, -- [3]
      11095, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Spell_Fire_FireArmor", -- [1]
      4, -- [2]
      2, -- [3]
      11094, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Fire_MasterOfElements", -- [1]
      4, -- [2]
      4, -- [3]
      29074, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Spell_Fire_PlayingWithFire", -- [1]
      5, -- [2]
      1, -- [3]
      31638, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Spell_Nature_WispHeal", -- [1]
      5, -- [2]
      2, -- [3]
      11115, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Spell_Holy_Excorcism_02", -- [1]
      5, -- [2]
      3, -- [3]
      11113, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Spell_Fire_BurningSpeed", -- [1]
      6, -- [2]
      1, -- [3]
      31641, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Spell_Fire_Immolation", -- [1]
      6, -- [2]
      3, -- [3]
      11124, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Spell_Fire_Burnout", -- [1]
      7, -- [2]
      1, -- [3]
      34293, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Spell_Fire_SealOfFire", -- [1]
      7, -- [2]
      2, -- [3]
      11129, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Spell_Fire_MoltenBlood", -- [1]
      7, -- [2]
      3, -- [3]
      31679, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Spell_Fire_FlameBolt", -- [1]
      8, -- [2]
      3, -- [3]
      31656, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\INV_Misc_Head_Dragon_01", -- [1]
      9, -- [2]
      2, -- [3]
      31661, -- [4]
    }, -- [62]
    nil, -- [63]
    nil, -- [64]
    nil, -- [65]
    nil, -- [66]
    nil, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Spell_Frost_FrostWard", -- [1]
      1, -- [2]
      1, -- [3]
      11189, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Frost_FrostBolt02", -- [1]
      1, -- [2]
      2, -- [3]
      11070, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Ice_MagicDamage", -- [1]
      1, -- [2]
      3, -- [3]
      29438, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Spell_Frost_IceShard", -- [1]
      2, -- [2]
      1, -- [3]
      11207, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Frost_FrostArmor", -- [1]
      2, -- [2]
      2, -- [3]
      11071, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_Frost_FreezingBreath", -- [1]
      2, -- [2]
      3, -- [3]
      11165, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_Frost_Wisp", -- [1]
      2, -- [2]
      4, -- [3]
      11175, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Frost_Frostbolt", -- [1]
      3, -- [2]
      1, -- [3]
      11151, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Spell_Frost_ColdHearted", -- [1]
      3, -- [2]
      2, -- [3]
      12472, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Spell_Frost_IceStorm", -- [1]
      3, -- [2]
      4, -- [3]
      11185, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_Shadow_DarkRitual", -- [1]
      4, -- [2]
      1, -- [3]
      16757, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Spell_Frost_Stun", -- [1]
      4, -- [2]
      2, -- [3]
      11160, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Spell_Frost_FrostShock", -- [1]
      4, -- [2]
      3, -- [3]
      11170, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Frost_FrozenCore", -- [1]
      5, -- [2]
      1, -- [3]
      31667, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Frost_WizardMark", -- [1]
      5, -- [2]
      2, -- [3]
      11958, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Spell_Frost_Glacier", -- [1]
      5, -- [2]
      3, -- [3]
      11190, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Spell_Frost_IceFloes", -- [1]
      6, -- [2]
      1, -- [3]
      31670, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Spell_Frost_ChillingBlast", -- [1]
      6, -- [2]
      3, -- [3]
      11180, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Spell_Ice_Lament", -- [1]
      7, -- [2]
      2, -- [3]
      11426, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Spell_Frost_ArcticWinds", -- [1]
      7, -- [2]
      3, -- [3]
      31674, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Spell_Frost_FrostBolt02", -- [1]
      8, -- [2]
      2, -- [3]
      31682, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Spell_Frost_SummonWaterElemental_2", -- [1]
      9, -- [2]
      2, -- [3]
      31687, -- [4]
    }, -- [102]
    nil, -- [103]
    nil, -- [104]
    nil, -- [105]
    nil, -- [106]
    nil, -- [107]
    nil, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "MageArcane", -- [1]
      "MageFire", -- [2]
      "MageFrost", -- [3]
    }, -- [121]
  },
  ["PRIEST"] = {
    {
      "Interface\\Icons\\Spell_Magic_MageArmor", -- [1]
      1, -- [2]
      2, -- [3]
      14522, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\INV_Wand_01", -- [1]
      1, -- [2]
      3, -- [3]
      14524, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Spell_Nature_ManaRegenTotem", -- [1]
      2, -- [2]
      1, -- [3]
      14523, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Spell_Holy_WordFortitude", -- [1]
      2, -- [2]
      2, -- [3]
      14749, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Spell_Holy_PowerWordShield", -- [1]
      2, -- [2]
      3, -- [3]
      14748, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Spell_Nature_Tranquility", -- [1]
      2, -- [2]
      4, -- [3]
      14531, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_Holy_Absolution", -- [1]
      3, -- [2]
      1, -- [3]
      33167, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_Frost_WindWalkOn", -- [1]
      3, -- [2]
      2, -- [3]
      14751, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Spell_Nature_Sleep", -- [1]
      3, -- [2]
      3, -- [3]
      14521, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Spell_Holy_InnerFire", -- [1]
      4, -- [2]
      1, -- [3]
      14747, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Ability_Hibernation", -- [1]
      4, -- [2]
      2, -- [3]
      14520, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Spell_Shadow_ManaBurn", -- [1]
      4, -- [2]
      4, -- [3]
      14750, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Nature_EnchantArmor", -- [1]
      5, -- [2]
      2, -- [3]
      18551, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Holy_DivineSpirit", -- [1]
      5, -- [2]
      3, -- [3]
      14752, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Spell_Holy_DivineSpirit", -- [1]
      5, -- [2]
      4, -- [3]
      33174, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Spell_Shadow_FocusedPower", -- [1]
      6, -- [2]
      1, -- [3]
      33186, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Spell_Nature_SlowingTotem", -- [1]
      6, -- [2]
      3, -- [3]
      18544, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Arcane_FocusedPower", -- [1]
      7, -- [2]
      1, -- [3]
      45234, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Spell_Holy_PowerInfusion", -- [1]
      7, -- [2]
      2, -- [3]
      10060, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Spell_Holy_PowerWordShield", -- [1]
      7, -- [2]
      3, -- [3]
      33201, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Spell_Arcane_MindMastery", -- [1]
      8, -- [2]
      2, -- [3]
      34908, -- [4]
    }, -- [21]
    {
      "Interface\\Icons\\Spell_Holy_PainSupression", -- [1]
      9, -- [2]
      2, -- [3]
      33206, -- [4]
    }, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Spell_Holy_HealingFocus", -- [1]
      1, -- [2]
      1, -- [3]
      14913, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Spell_Holy_Renew", -- [1]
      1, -- [2]
      2, -- [3]
      14908, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Spell_Holy_SealOfSalvation", -- [1]
      1, -- [2]
      3, -- [3]
      14889, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Spell_Holy_SpellWarding", -- [1]
      2, -- [2]
      2, -- [3]
      27900, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Spell_Holy_SealOfWrath", -- [1]
      2, -- [2]
      3, -- [3]
      18530, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Spell_Holy_HolyNova", -- [1]
      3, -- [2]
      1, -- [3]
      15237, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Holy_BlessedRecovery", -- [1]
      3, -- [2]
      2, -- [3]
      27811, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Spell_Holy_LayOnHands", -- [1]
      3, -- [2]
      4, -- [3]
      14892, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Spell_Holy_Purify", -- [1]
      4, -- [2]
      1, -- [3]
      27789, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Spell_Holy_Heal02", -- [1]
      4, -- [2]
      2, -- [3]
      14912, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Spell_Holy_SearingLightPriest", -- [1]
      4, -- [2]
      3, -- [3]
      14909, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Holy_PrayerOfHealing02", -- [1]
      5, -- [2]
      1, -- [3]
      14911, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\INV_Enchant_EssenceEternalLarge", -- [1]
      5, -- [2]
      2, -- [3]
      20711, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Spell_Holy_SpiritualGuidence", -- [1]
      5, -- [2]
      3, -- [3]
      14901, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Spell_Holy_SurgeOfLight", -- [1]
      6, -- [2]
      1, -- [3]
      33150, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Spell_Nature_MoonGlow", -- [1]
      6, -- [2]
      3, -- [3]
      14898, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Spell_Holy_Fanaticism", -- [1]
      7, -- [2]
      1, -- [3]
      34753, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Spell_Holy_SummonLightwell", -- [1]
      7, -- [2]
      2, -- [3]
      724, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Spell_Holy_BlessedResillience", -- [1]
      7, -- [2]
      3, -- [3]
      33142, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Spell_Holy_GreaterHeal", -- [1]
      8, -- [2]
      2, -- [3]
      33158, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Spell_Holy_CircleOfRenewal", -- [1]
      9, -- [2]
      2, -- [3]
      34861, -- [4]
    }, -- [61]
    nil, -- [62]
    nil, -- [63]
    nil, -- [64]
    nil, -- [65]
    nil, -- [66]
    nil, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Spell_Shadow_Requiem", -- [1]
      1, -- [2]
      2, -- [3]
      15270, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Shadow_GatherShadows", -- [1]
      1, -- [2]
      3, -- [3]
      15268, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowWard", -- [1]
      2, -- [2]
      1, -- [3]
      15318, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowWordPain", -- [1]
      2, -- [2]
      2, -- [3]
      15275, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Shadow_BurningSpirit", -- [1]
      2, -- [2]
      3, -- [3]
      15260, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_Shadow_PsychicScream", -- [1]
      3, -- [2]
      1, -- [3]
      15392, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_Shadow_UnholyFrenzy", -- [1]
      3, -- [2]
      2, -- [3]
      15273, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Shadow_SiphonMana", -- [1]
      3, -- [2]
      3, -- [3]
      15407, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Spell_Magic_LesserInvisibilty", -- [1]
      4, -- [2]
      2, -- [3]
      15274, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Spell_Shadow_ChillTouch", -- [1]
      4, -- [2]
      3, -- [3]
      17322, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_Shadow_BlackPlague", -- [1]
      4, -- [2]
      4, -- [3]
      15257, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Spell_Shadow_ImpPhaseShift", -- [1]
      5, -- [2]
      1, -- [3]
      15487, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Spell_Shadow_UnsummonBuilding", -- [1]
      5, -- [2]
      2, -- [3]
      15286, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Shadow_ImprovedVampiricEmbrace", -- [1]
      5, -- [2]
      3, -- [3]
      27839, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Nature_FocusedMind", -- [1]
      5, -- [2]
      4, -- [3]
      33213, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Spell_Shadow_GrimWard", -- [1]
      6, -- [2]
      1, -- [3]
      14910, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Spell_Shadow_Twilight", -- [1]
      6, -- [2]
      3, -- [3]
      15259, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Spell_Shadow_Shadowform", -- [1]
      7, -- [2]
      2, -- [3]
      15473, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowPower", -- [1]
      7, -- [2]
      3, -- [3]
      33221, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Spell_Shadow_Misery", -- [1]
      8, -- [2]
      3, -- [3]
      33191, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Spell_Holy_Stoicism", -- [1]
      9, -- [2]
      2, -- [3]
      34914, -- [4]
    }, -- [101]
    nil, -- [102]
    nil, -- [103]
    nil, -- [104]
    nil, -- [105]
    nil, -- [106]
    nil, -- [107]
    nil, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "PriestDiscipline", -- [1]
      "PriestHoly", -- [2]
      "PriestShadow", -- [3]
    }, -- [121]
  },
  ["WARLOCK"] = {
    {
      "Interface\\Icons\\Spell_Shadow_UnsummonBuilding", -- [1]
      1, -- [2]
      2, -- [3]
      18174, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Spell_Shadow_AbominationExplosion", -- [1]
      1, -- [2]
      3, -- [3]
      17810, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Spell_Shadow_CurseOfMannoroth", -- [1]
      2, -- [2]
      1, -- [3]
      18179, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Spell_Shadow_Haunting", -- [1]
      2, -- [2]
      2, -- [3]
      18213, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Spell_Shadow_BurningSpirit", -- [1]
      2, -- [2]
      3, -- [3]
      18182, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Spell_Shadow_LifeDrain02", -- [1]
      2, -- [2]
      4, -- [3]
      17804, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_Shadow_CurseOfSargeras", -- [1]
      3, -- [2]
      1, -- [3]
      18827, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_Shadow_FingerOfDeath", -- [1]
      3, -- [2]
      2, -- [3]
      17783, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Spell_Shadow_Contagion", -- [1]
      3, -- [2]
      3, -- [3]
      18288, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Spell_Shadow_CallofBone", -- [1]
      4, -- [2]
      1, -- [3]
      18218, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Spell_Shadow_Twilight", -- [1]
      4, -- [2]
      2, -- [3]
      18094, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Spell_Shadow_AbominationExplosion", -- [1]
      4, -- [2]
      4, -- [3]
      32381, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowEmbrace", -- [1]
      5, -- [2]
      1, -- [3]
      32385, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Shadow_Requiem", -- [1]
      5, -- [2]
      2, -- [3]
      18265, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Spell_Shadow_GrimWard", -- [1]
      5, -- [2]
      3, -- [3]
      18223, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Spell_Shadow_ShadeTrueSight", -- [1]
      6, -- [2]
      2, -- [3]
      18271, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Spell_Shadow_PainfulAfflictions", -- [1]
      7, -- [2]
      2, -- [3]
      30060, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Shadow_DarkRitual", -- [1]
      7, -- [2]
      3, -- [3]
      18220, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Spell_Shadow_DeathScream", -- [1]
      8, -- [2]
      1, -- [3]
      30054, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Spell_Shadow_CurseOfAchimonde", -- [1]
      8, -- [2]
      3, -- [3]
      32477, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Spell_Shadow_UnstableAffliction_3", -- [1]
      9, -- [2]
      2, -- [3]
      30108, -- [4]
    }, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\INV_Stone_04", -- [1]
      1, -- [2]
      1, -- [3]
      18692, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Spell_Shadow_SummonImp", -- [1]
      1, -- [2]
      2, -- [3]
      18694, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Spell_Shadow_Metamorphosis", -- [1]
      1, -- [2]
      3, -- [3]
      18697, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Spell_Shadow_LifeDrain", -- [1]
      2, -- [2]
      1, -- [3]
      18703, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Spell_Shadow_SummonVoidWalker", -- [1]
      2, -- [2]
      2, -- [3]
      18705, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Spell_Holy_MagicalSentry", -- [1]
      2, -- [2]
      3, -- [3]
      18731, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Shadow_SummonSuccubus", -- [1]
      3, -- [2]
      1, -- [3]
      18754, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Spell_Nature_RemoveCurse", -- [1]
      3, -- [2]
      2, -- [3]
      18708, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Spell_Shadow_AntiShadow", -- [1]
      3, -- [2]
      3, -- [3]
      18748, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Spell_Shadow_RagingScream", -- [1]
      3, -- [2]
      4, -- [3]
      30143, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Spell_Shadow_ImpPhaseShift", -- [1]
      4, -- [2]
      2, -- [3]
      18709, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowWordDominate", -- [1]
      4, -- [2]
      3, -- [3]
      18769, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Spell_Shadow_EnslaveDemon", -- [1]
      5, -- [2]
      1, -- [3]
      18821, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Spell_Shadow_PsychicScream", -- [1]
      5, -- [2]
      2, -- [3]
      18788, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\INV_Ammo_FireTar", -- [1]
      5, -- [2]
      4, -- [3]
      18767, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Spell_Shadow_ManaFeed", -- [1]
      6, -- [2]
      1, -- [3]
      30326, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowPact", -- [1]
      6, -- [2]
      3, -- [3]
      23785, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Spell_Shadow_DemonicFortitude", -- [1]
      7, -- [2]
      1, -- [3]
      30319, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Spell_Shadow_GatherShadows", -- [1]
      7, -- [2]
      2, -- [3]
      19028, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Spell_Shadow_ImprovedVampiricEmbrace", -- [1]
      7, -- [2]
      3, -- [3]
      35691, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Spell_Shadow_DemonicTactics", -- [1]
      8, -- [2]
      2, -- [3]
      30242, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\Spell_Shadow_SummonFelGuard", -- [1]
      9, -- [2]
      2, -- [3]
      30146, -- [4]
    }, -- [62]
    nil, -- [63]
    nil, -- [64]
    nil, -- [65]
    nil, -- [66]
    nil, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowBolt", -- [1]
      1, -- [2]
      2, -- [3]
      17793, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Fire_WindsofWoe", -- [1]
      1, -- [2]
      3, -- [3]
      17778, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Shadow_DeathPact", -- [1]
      2, -- [2]
      2, -- [3]
      17788, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Spell_Fire_Fire", -- [1]
      2, -- [2]
      3, -- [3]
      18119, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Fire_FireBolt", -- [1]
      3, -- [2]
      1, -- [3]
      18126, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_Shadow_Curse", -- [1]
      3, -- [2]
      2, -- [3]
      18128, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_Fire_FlameShock", -- [1]
      3, -- [2]
      3, -- [3]
      18130, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Shadow_ScourgeBuild", -- [1]
      3, -- [2]
      4, -- [3]
      17877, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Spell_Fire_LavaSpawn", -- [1]
      4, -- [2]
      1, -- [3]
      18135, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Spell_Shadow_CorpseExplode", -- [1]
      4, -- [2]
      2, -- [3]
      17917, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_Fire_SoulBurn", -- [1]
      4, -- [2]
      4, -- [3]
      17927, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Spell_Fire_Volcano", -- [1]
      5, -- [2]
      1, -- [3]
      18096, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Spell_Fire_Immolation", -- [1]
      5, -- [2]
      2, -- [3]
      17815, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowWordPain", -- [1]
      5, -- [2]
      3, -- [3]
      17959, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Shadow_NetherProtection", -- [1]
      6, -- [2]
      1, -- [3]
      30299, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Spell_Fire_SelfDestruct", -- [1]
      6, -- [2]
      3, -- [3]
      17954, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Spell_Fire_PlayingWithFire", -- [1]
      7, -- [2]
      1, -- [3]
      34935, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Spell_Fire_Fireball", -- [1]
      7, -- [2]
      2, -- [3]
      17962, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Spell_Shadow_SoulLeech_3", -- [1]
      7, -- [2]
      3, -- [3]
      30293, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowandFlame", -- [1]
      8, -- [2]
      2, -- [3]
      30288, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Spell_Shadow_Shadowfury", -- [1]
      9, -- [2]
      2, -- [3]
      30283, -- [4]
    }, -- [101]
    nil, -- [102]
    nil, -- [103]
    nil, -- [104]
    nil, -- [105]
    nil, -- [106]
    nil, -- [107]
    nil, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "WarlockCurses", -- [1]
      "WarlockSummoning", -- [2]
      "WarlockDestruction", -- [3]
    }, -- [121]
  },
  ["DEATHKNIGHT"] = {
    {
      "Interface\\Icons\\INV_Axe_68", -- [1]
      1, -- [2]
      1, -- [3]
      48979, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Spell_DeathKnight_Subversion", -- [1]
      1, -- [2]
      2, -- [3]
      48997, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Ability_UpgradeMoonGlaive", -- [1]
      1, -- [2]
      3, -- [3]
      55226, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\INV_Shoulder_36", -- [1]
      2, -- [2]
      1, -- [3]
      49393, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Ability_Rogue_BloodyEye", -- [1]
      2, -- [2]
      2, -- [3]
      49004, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\INV_Sword_68", -- [1]
      2, -- [2]
      3, -- [3]
      55108, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_DeathKnight_RuneTap", -- [1]
      3, -- [2]
      1, -- [3]
      48982, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_DeathKnight_DarkConviction", -- [1]
      3, -- [2]
      2, -- [3]
      49480, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\INV_Sword_62", -- [1]
      3, -- [2]
      3, -- [3]
      50034, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Spell_DeathKnight_RuneTap", -- [1]
      4, -- [2]
      1, -- [3]
      49489, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Spell_DeathKnight_SpellDeflection", -- [1]
      4, -- [2]
      3, -- [3]
      49497, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Spell_DeathKnight_Vendetta", -- [1]
      4, -- [2]
      4, -- [3]
      49015, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Deathknight_DeathStrike", -- [1]
      5, -- [2]
      1, -- [3]
      49395, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Misc_WarsongFocus", -- [1]
      5, -- [2]
      3, -- [3]
      50029, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Ability_Hunter_RapidKilling", -- [1]
      5, -- [2]
      4, -- [3]
      49005, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Ability_BackStab", -- [1]
      6, -- [2]
      2, -- [3]
      48988, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Ability_Warrior_IntensifyRage", -- [1]
      6, -- [2]
      3, -- [3]
      53138, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Shadow_SoulLeech", -- [1]
      7, -- [2]
      1, -- [3]
      49027, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Spell_DeathKnight_BladedArmor", -- [1]
      7, -- [2]
      2, -- [3]
      49016, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Spell_Deathknight_BloodPresence", -- [1]
      7, -- [2]
      3, -- [3]
      50365, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Spell_DeathKnight_Butcher2", -- [1]
      8, -- [2]
      1, -- [3]
      62908, -- [4]
    }, -- [21]
    {
      "Interface\\Icons\\Spell_Shadow_PainSpike", -- [1]
      8, -- [2]
      2, -- [3]
      49018, -- [4]
    }, -- [22]
    {
      "Interface\\Icons\\Spell_Shadow_LifeDrain", -- [1]
      8, -- [2]
      3, -- [3]
      55233, -- [4]
    }, -- [23]
    {
      "Interface\\Icons\\Ability_Creature_Cursed_02", -- [1]
      9, -- [2]
      1, -- [3]
      50150, -- [4]
    }, -- [24]
    {
      "Interface\\Icons\\INV_Weapon_Shortblade_40", -- [1]
      9, -- [2]
      2, -- [3]
      55050, -- [4]
    }, -- [25]
    {
      "Interface\\Icons\\Spell_Deathknight_ClassIcon", -- [1]
      9, -- [2]
      3, -- [3]
      49023, -- [4]
    }, -- [26]
    {
      "Interface\\Icons\\Spell_Nature_Reincarnation", -- [1]
      10, -- [2]
      2, -- [3]
      61154, -- [4]
    }, -- [27]
    {
      "Interface\\Icons\\INV_Sword_07", -- [1]
      11, -- [2]
      2, -- [3]
      49028, -- [4]
    }, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Spell_DeathKnight_IceTouch", -- [1]
      1, -- [2]
      1, -- [3]
      51456, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Spell_Arcane_Arcane01", -- [1]
      1, -- [2]
      2, -- [3]
      49455, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Spell_Holy_Devotion", -- [1]
      1, -- [2]
      3, -- [3]
      49789, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Spell_Frost_ManaRecharge", -- [1]
      2, -- [2]
      2, -- [3]
      55061, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Spell_Shadow_DarkRitual", -- [1]
      2, -- [2]
      3, -- [3]
      49663, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Ability_DualWield", -- [1]
      2, -- [2]
      4, -- [3]
      49226, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Deathknight_IcyTalons", -- [1]
      3, -- [2]
      1, -- [3]
      50887, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Spell_Shadow_RaiseDead", -- [1]
      3, -- [2]
      2, -- [3]
      49039, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\INV_Weapon_Hand_18", -- [1]
      3, -- [2]
      3, -- [3]
      51468, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\INV_Sword_122", -- [1]
      4, -- [2]
      2, -- [3]
      51128, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Spell_Frost_FrostShock", -- [1]
      4, -- [2]
      3, -- [3]
      49149, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Shadow_Twilight", -- [1]
      4, -- [2]
      4, -- [3]
      49657, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\INV_CHEST_MAIL_04", -- [1]
      5, -- [2]
      2, -- [3]
      51108, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Spell_Nature_RemoveDisease", -- [1]
      5, -- [2]
      3, -- [3]
      49791, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Spell_Shadow_SoulLeech_2", -- [1]
      5, -- [2]
      4, -- [3]
      49796, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Spell_Deathknight_IcyTalons", -- [1]
      6, -- [2]
      1, -- [3]
      55610, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\INV_Sword_112", -- [1]
      6, -- [2]
      2, -- [3]
      49024, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Spell_Frost_FreezingBreath", -- [1]
      6, -- [2]
      3, -- [3]
      49188, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Spell_Frost_Wisp", -- [1]
      7, -- [2]
      1, -- [3]
      50040, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\INV_Staff_15", -- [1]
      7, -- [2]
      2, -- [3]
      49203, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Spell_Deathknight_FrostPresence", -- [1]
      7, -- [2]
      3, -- [3]
      50384, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\Ability_DualWieldSpecialization", -- [1]
      8, -- [2]
      1, -- [3]
      65661, -- [4]
    }, -- [62]
    {
      "Interface\\Icons\\INV_Weapon_Shortblade_79", -- [1]
      8, -- [2]
      2, -- [3]
      54639, -- [4]
    }, -- [63]
    {
      "Interface\\Icons\\INV_Armor_Helm_Plate_Naxxramas_RaidWarrior_C_01", -- [1]
      8, -- [2]
      3, -- [3]
      51271, -- [4]
    }, -- [64]
    {
      "Interface\\Icons\\Spell_Fire_ElementalDevastation", -- [1]
      9, -- [2]
      1, -- [3]
      49200, -- [4]
    }, -- [65]
    {
      "Interface\\Icons\\Spell_DeathKnight_EmpowerRuneBlade2", -- [1]
      9, -- [2]
      2, -- [3]
      49143, -- [4]
    }, -- [66]
    {
      "Interface\\Icons\\INV-Sword_53", -- [1]
      9, -- [2]
      3, -- [3]
      50187, -- [4]
    }, -- [67]
    {
      "Interface\\Icons\\Spell_Nature_Tranquility", -- [1]
      10, -- [2]
      2, -- [3]
      49202, -- [4]
    }, -- [68]
    {
      "Interface\\Icons\\Spell_Frost_ArcticWinds", -- [1]
      11, -- [2]
      2, -- [3]
      49184, -- [4]
    }, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Spell_Deathknight_PlagueStrike", -- [1]
      1, -- [2]
      1, -- [3]
      51745, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Shadow_BurningSpirit", -- [1]
      1, -- [2]
      2, -- [3]
      48962, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Nature_MirrorImage", -- [1]
      1, -- [2]
      3, -- [3]
      55129, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowWordPain", -- [1]
      2, -- [2]
      1, -- [3]
      49036, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Shadow_DeathAndDecay", -- [1]
      2, -- [2]
      2, -- [3]
      48963, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_DeathKnight_Strangulate", -- [1]
      2, -- [2]
      3, -- [3]
      49588, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_DeathKnight_Gnaw_Ghoul", -- [1]
      2, -- [2]
      4, -- [3]
      48965, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Shadow_PlagueCloud", -- [1]
      3, -- [2]
      1, -- [3]
      49013, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\INV_Weapon_Shortblade_60", -- [1]
      3, -- [2]
      2, -- [3]
      51459, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Ability_Creature_Disease_02", -- [1]
      3, -- [2]
      3, -- [3]
      49158, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_DeathKnight_SummonDeathCharger", -- [1]
      4, -- [2]
      2, -- [3]
      49146, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Ability_CriticalStrike", -- [1]
      4, -- [2]
      3, -- [3]
      49219, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Spell_DeathKnight_ArmyOfTheDead", -- [1]
      4, -- [2]
      4, -- [3]
      55620, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Shadow_Contagion", -- [1]
      5, -- [2]
      1, -- [3]
      49194, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowandFlame", -- [1]
      5, -- [2]
      2, -- [3]
      49220, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Spell_Shadow_Shadesofdarkness", -- [1]
      5, -- [2]
      3, -- [3]
      49223, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Spell_Shadow_Shadowfiend", -- [1]
      6, -- [2]
      1, -- [3]
      55666, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Spell_Shadow_AntiMagicShell", -- [1]
      6, -- [2]
      2, -- [3]
      49224, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Spell_Shadow_ShadeTrueSight", -- [1]
      6, -- [2]
      3, -- [3]
      49208, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Spell_Shadow_AnimateDead", -- [1]
      6, -- [2]
      4, -- [3]
      52143, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Spell_Shadow_UnholyFrenzy", -- [1]
      7, -- [2]
      1, -- [3]
      66799, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Spell_DeathKnight_AntiMagicZone", -- [1]
      7, -- [2]
      2, -- [3]
      51052, -- [4]
    }, -- [102]
    {
      "Interface\\Icons\\Spell_Deathknight_UnholyPresence", -- [1]
      7, -- [2]
      3, -- [3]
      50391, -- [4]
    }, -- [103]
    {
      "Interface\\Icons\\Ability_GhoulFrenzy", -- [1]
      7, -- [2]
      4, -- [3]
      63560, -- [4]
    }, -- [104]
    {
      "Interface\\Icons\\Spell_Nature_NullifyDisease", -- [1]
      8, -- [2]
      2, -- [3]
      49032, -- [4]
    }, -- [105]
    {
      "Interface\\Icons\\INV_Chest_Leather_13", -- [1]
      8, -- [2]
      3, -- [3]
      49222, -- [4]
    }, -- [106]
    {
      "Interface\\Icons\\Spell_Shadow_CallofBone", -- [1]
      9, -- [2]
      1, -- [3]
      49217, -- [4]
    }, -- [107]
    {
      "Interface\\Icons\\Ability_Creature_Cursed_03", -- [1]
      9, -- [2]
      2, -- [3]
      51099, -- [4]
    }, -- [108]
    {
      "Interface\\Icons\\Spell_DeathKnight_ScourgeStrike", -- [1]
      9, -- [2]
      3, -- [3]
      55090, -- [4]
    }, -- [109]
    {
      "Interface\\Icons\\INV_Weapon_Halberd14", -- [1]
      10, -- [2]
      2, -- [3]
      50117, -- [4]
    }, -- [110]
    {
      "Interface\\Icons\\Ability_Hunter_Pet_Bat", -- [1]
      11, -- [2]
      2, -- [3]
      49206, -- [4]
    }, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "DeathKnightBlood", -- [1]
      "DeathKnightFrost", -- [2]
      "DeathKnightUnholy", -- [3]
    }, -- [121]
  },
  ["DRUID"] = {
    {
      "Interface\\Icons\\Spell_Nature_AbolishMagic", -- [1]
      1, -- [2]
      1, -- [3]
      16814, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Spell_Nature_NaturesWrath", -- [1]
      1, -- [2]
      2, -- [3]
      16689, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Spell_Nature_NaturesWrath", -- [1]
      1, -- [2]
      3, -- [3]
      17245, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Spell_Nature_StrangleVines", -- [1]
      2, -- [2]
      1, -- [3]
      16918, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\INV_Staff_01", -- [1]
      2, -- [2]
      2, -- [3]
      35363, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Spell_Nature_StarFall", -- [1]
      2, -- [2]
      3, -- [3]
      16821, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_Nature_Thorns", -- [1]
      3, -- [2]
      1, -- [3]
      16836, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_Nature_InsectSwarm", -- [1]
      3, -- [2]
      3, -- [3]
      5570, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Spell_Nature_NatureTouchGrow", -- [1]
      3, -- [2]
      4, -- [3]
      16819, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Spell_Nature_Purge", -- [1]
      4, -- [2]
      2, -- [3]
      16909, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Spell_Arcane_StarFire", -- [1]
      4, -- [2]
      3, -- [3]
      16850, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Ability_Druid_LunarGuidance", -- [1]
      5, -- [2]
      1, -- [3]
      33589, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Nature_NaturesBlessing", -- [1]
      5, -- [2]
      2, -- [3]
      16880, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Nature_Sentinal", -- [1]
      5, -- [2]
      3, -- [3]
      16845, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Spell_Nature_MoonGlow", -- [1]
      6, -- [2]
      2, -- [3]
      16896, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Ability_Druid_BalanceofPower", -- [1]
      6, -- [2]
      3, -- [3]
      33592, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Ability_Druid_Dreamstate", -- [1]
      7, -- [2]
      1, -- [3]
      33597, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Nature_ForceOfNature", -- [1]
      7, -- [2]
      2, -- [3]
      24858, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Spell_Nature_FaerieFire", -- [1]
      7, -- [2]
      3, -- [3]
      33600, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Ability_Druid_TwilightsWrath", -- [1]
      8, -- [2]
      2, -- [3]
      33603, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Ability_Druid_ForceofNature", -- [1]
      9, -- [2]
      2, -- [3]
      33831, -- [4]
    }, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Ability_Hunter_Pet_Hyena", -- [1]
      1, -- [2]
      2, -- [3]
      16934, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Ability_Druid_DemoralizingRoar", -- [1]
      1, -- [2]
      3, -- [3]
      16858, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Ability_Ambush", -- [1]
      2, -- [2]
      1, -- [3]
      16947, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Ability_Druid_Bash", -- [1]
      2, -- [2]
      2, -- [3]
      16940, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\INV_Misc_Pelt_Bear_03", -- [1]
      2, -- [2]
      3, -- [3]
      16929, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Spell_Nature_SpiritWolf", -- [1]
      3, -- [2]
      1, -- [3]
      17002, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Ability_Hunter_Pet_Bear", -- [1]
      3, -- [2]
      2, -- [3]
      16979, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\INV_Misc_MonsterClaw_04", -- [1]
      3, -- [2]
      3, -- [3]
      16942, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Spell_Shadow_VampiricAura", -- [1]
      4, -- [2]
      1, -- [3]
      16966, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Ability_Hunter_Pet_Cat", -- [1]
      4, -- [2]
      2, -- [3]
      16972, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Ability_Racial_Cannibalize", -- [1]
      4, -- [2]
      3, -- [3]
      37116, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Ability_Druid_Ravage", -- [1]
      5, -- [2]
      1, -- [3]
      16998, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Spell_Nature_FaerieFire", -- [1]
      5, -- [2]
      3, -- [3]
      16857, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Ability_Druid_HealingInstincts", -- [1]
      5, -- [2]
      4, -- [3]
      33872, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfAgility", -- [1]
      6, -- [2]
      2, -- [3]
      17003, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Ability_Druid_Enrage", -- [1]
      6, -- [2]
      3, -- [3]
      33853, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Ability_Druid_PrimalTenacity", -- [1]
      7, -- [2]
      1, -- [3]
      33851, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Spell_Nature_UnyeildingStamina", -- [1]
      7, -- [2]
      2, -- [3]
      17007, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Spell_Nature_UnyeildingStamina", -- [1]
      7, -- [2]
      3, -- [3]
      34297, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Ability_Druid_PredatoryInstincts", -- [1]
      8, -- [2]
      3, -- [3]
      33859, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Ability_Druid_Mangle2", -- [1]
      9, -- [2]
      2, -- [3]
      33917, -- [4]
    }, -- [61]
    nil, -- [62]
    nil, -- [63]
    nil, -- [64]
    nil, -- [65]
    nil, -- [66]
    nil, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Spell_Nature_Regeneration", -- [1]
      1, -- [2]
      2, -- [3]
      17050, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfStamina", -- [1]
      1, -- [2]
      3, -- [3]
      17056, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Nature_HealingTouch", -- [1]
      2, -- [2]
      1, -- [3]
      17069, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Spell_Nature_HealingWaveGreater", -- [1]
      2, -- [2]
      2, -- [3]
      17063, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Spell_Nature_WispSplode", -- [1]
      2, -- [2]
      3, -- [3]
      16833, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_Frost_WindWalkOn", -- [1]
      3, -- [2]
      1, -- [3]
      17106, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Ability_EyeOfTheOwl", -- [1]
      3, -- [2]
      2, -- [3]
      17118, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Spell_Nature_CrystalBall", -- [1]
      3, -- [2]
      3, -- [3]
      16864, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Spell_Holy_ElunesGrace", -- [1]
      4, -- [2]
      2, -- [3]
      24968, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Spell_Nature_Rejuvenation", -- [1]
      4, -- [2]
      3, -- [3]
      17111, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_Nature_RavenForm", -- [1]
      5, -- [2]
      1, -- [3]
      17116, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Spell_Nature_ProtectionformNature", -- [1]
      5, -- [2]
      2, -- [3]
      17104, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Spell_Nature_Tranquility", -- [1]
      5, -- [2]
      4, -- [3]
      17123, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Ability_Druid_EmpoweredTouch", -- [1]
      6, -- [2]
      1, -- [3]
      33879, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Nature_ResistNature", -- [1]
      6, -- [2]
      3, -- [3]
      17074, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Spell_Nature_GiftoftheWaterSpirit", -- [1]
      7, -- [2]
      1, -- [3]
      34151, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\INV_Relics_IdolofRejuvenation", -- [1]
      7, -- [2]
      2, -- [3]
      18562, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Ability_Druid_NaturalPerfection", -- [1]
      7, -- [2]
      3, -- [3]
      33881, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Ability_Druid_EmpoweredRejuvination", -- [1]
      8, -- [2]
      2, -- [3]
      33886, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Ability_Druid_TreeofLife", -- [1]
      9, -- [2]
      2, -- [3]
      33891, -- [4]
    }, -- [100]
    nil, -- [101]
    nil, -- [102]
    nil, -- [103]
    nil, -- [104]
    nil, -- [105]
    nil, -- [106]
    nil, -- [107]
    nil, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "DruidBalance", -- [1]
      "DruidFeralCombat", -- [2]
      "DruidRestoration", -- [3]
    }, -- [121]
  },
  ["PALADIN"] = {
    {
      "Interface\\Icons\\Ability_GolemThunderClap", -- [1]
      1, -- [2]
      2, -- [3]
      20262, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Spell_Nature_Sleep", -- [1]
      1, -- [2]
      3, -- [3]
      20257, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Spell_Arcane_Blink", -- [1]
      2, -- [2]
      2, -- [3]
      20205, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Ability_ThunderBolt", -- [1]
      2, -- [2]
      3, -- [3]
      20224, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Spell_Holy_HolyBolt", -- [1]
      3, -- [2]
      1, -- [3]
      20237, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Spell_Holy_AuraMastery", -- [1]
      3, -- [2]
      2, -- [3]
      31821, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Spell_Holy_LayOnHands", -- [1]
      3, -- [2]
      3, -- [3]
      20234, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Spell_Holy_UnyieldingFaith", -- [1]
      3, -- [2]
      4, -- [3]
      9453, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Spell_Holy_GreaterHeal", -- [1]
      4, -- [2]
      2, -- [3]
      20210, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Spell_Holy_SealOfWisdom", -- [1]
      4, -- [2]
      3, -- [3]
      20244, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Spell_Holy_PureOfHeart", -- [1]
      5, -- [2]
      1, -- [3]
      31822, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Spell_Holy_Heal", -- [1]
      5, -- [2]
      2, -- [3]
      20216, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Holy_HealingAura", -- [1]
      5, -- [2]
      3, -- [3]
      20359, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Spell_Holy_PurifyingPower", -- [1]
      6, -- [2]
      1, -- [3]
      31825, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Spell_Holy_Power", -- [1]
      6, -- [2]
      3, -- [3]
      5923, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Spell_Holy_LightsGrace", -- [1]
      7, -- [2]
      1, -- [3]
      31833, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Spell_Holy_SearingLight", -- [1]
      7, -- [2]
      2, -- [3]
      20473, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Holy_BlessedLife", -- [1]
      7, -- [2]
      3, -- [3]
      31828, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Spell_Holy_HolyGuidance", -- [1]
      8, -- [2]
      2, -- [3]
      31837, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Spell_Holy_DivineIllumination", -- [1]
      9, -- [2]
      2, -- [3]
      31842, -- [4]
    }, -- [20]
    nil, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Spell_Holy_DevotionAura", -- [1]
      1, -- [2]
      2, -- [3]
      20138, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Ability_Defend", -- [1]
      1, -- [2]
      3, -- [3]
      20127, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Ability_Rogue_Ambush", -- [1]
      2, -- [2]
      1, -- [3]
      20189, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Spell_Holy_SealOfProtection", -- [1]
      2, -- [2]
      2, -- [3]
      20174, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Spell_Holy_Devotion", -- [1]
      2, -- [2]
      4, -- [3]
      20143, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Spell_Magic_MageArmor", -- [1]
      3, -- [2]
      1, -- [3]
      20217, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Holy_SealOfFury", -- [1]
      3, -- [2]
      2, -- [3]
      20468, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\INV_Shield_06", -- [1]
      3, -- [2]
      3, -- [3]
      20148, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Spell_Magic_LesserInvisibilty", -- [1]
      3, -- [2]
      4, -- [3]
      20096, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Spell_Holy_Stoicism", -- [1]
      4, -- [2]
      1, -- [3]
      31844, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\Spell_Holy_SealOfMight", -- [1]
      4, -- [2]
      2, -- [3]
      20487, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Spell_Holy_MindSooth", -- [1]
      4, -- [2]
      3, -- [3]
      20254, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\Spell_Holy_ImprovedResistanceAuras", -- [1]
      5, -- [2]
      1, -- [3]
      31846, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Spell_Nature_LightningShield", -- [1]
      5, -- [2]
      2, -- [3]
      20911, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfStrength", -- [1]
      5, -- [2]
      3, -- [3]
      20177, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\Spell_Holy_DivineIntervention", -- [1]
      6, -- [2]
      1, -- [3]
      31848, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\INV_Sword_20", -- [1]
      6, -- [2]
      3, -- [3]
      20196, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfProtection", -- [1]
      7, -- [2]
      1, -- [3]
      41021, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfProtection", -- [1]
      7, -- [2]
      2, -- [3]
      20925, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Spell_Holy_ArdentDefender", -- [1]
      7, -- [2]
      3, -- [3]
      31850, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Spell_Holy_WeaponMastery", -- [1]
      8, -- [2]
      3, -- [3]
      31858, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\Spell_Holy_AvengersShield", -- [1]
      9, -- [2]
      2, -- [3]
      31935, -- [4]
    }, -- [62]
    nil, -- [63]
    nil, -- [64]
    nil, -- [65]
    nil, -- [66]
    nil, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Spell_Holy_FistOfJustice", -- [1]
      1, -- [2]
      2, -- [3]
      20042, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Spell_Frost_WindWalkOn", -- [1]
      1, -- [2]
      3, -- [3]
      20101, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Spell_Holy_RighteousFury", -- [1]
      2, -- [2]
      1, -- [3]
      25956, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Spell_Holy_HolySmite", -- [1]
      2, -- [2]
      2, -- [3]
      20335, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Ability_Parry", -- [1]
      2, -- [2]
      3, -- [3]
      20060, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_Holy_Vindication", -- [1]
      3, -- [2]
      1, -- [3]
      9452, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_Holy_RetributionAura", -- [1]
      3, -- [2]
      2, -- [3]
      20117, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Ability_Warrior_InnerRage", -- [1]
      3, -- [2]
      3, -- [3]
      20375, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Spell_Holy_PersuitofJustice", -- [1]
      3, -- [2]
      4, -- [3]
      26022, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Spell_Holy_EyeforanEye", -- [1]
      4, -- [2]
      1, -- [3]
      9799, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\Spell_Holy_AuraOfLight", -- [1]
      4, -- [2]
      3, -- [3]
      20091, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Spell_Holy_Crusade", -- [1]
      4, -- [2]
      4, -- [3]
      31866, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\INV_Hammer_04", -- [1]
      5, -- [2]
      1, -- [3]
      20111, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Holy_MindVision", -- [1]
      5, -- [2]
      3, -- [3]
      20218, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Holy_MindVision", -- [1]
      5, -- [2]
      4, -- [3]
      31869, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Ability_Racial_Avatar", -- [1]
      6, -- [2]
      2, -- [3]
      20049, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\Spell_Holy_RighteousFury", -- [1]
      6, -- [2]
      3, -- [3]
      31876, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Spell_Holy_HolySmite", -- [1]
      7, -- [2]
      1, -- [3]
      32043, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Spell_Holy_PrayerOfHealing", -- [1]
      7, -- [2]
      2, -- [3]
      20066, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Spell_Holy_DivinePurpose", -- [1]
      7, -- [2]
      3, -- [3]
      31871, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Spell_Holy_Fanaticism", -- [1]
      8, -- [2]
      2, -- [3]
      31879, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Spell_Holy_CrusaderStrike", -- [1]
      9, -- [2]
      2, -- [3]
      35395, -- [4]
    }, -- [102]
    nil, -- [103]
    nil, -- [104]
    nil, -- [105]
    nil, -- [106]
    nil, -- [107]
    nil, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "PaladinHoly", -- [1]
      "PaladinProtection", -- [2]
      "PaladinCombat", -- [3]
    }, -- [121]
  },
  ["ROGUE"] = {
    {
      "Interface\\Icons\\Ability_Rogue_Eviscerate", -- [1]
      1, -- [2]
      1, -- [3]
      14162, -- [4]
    }, -- [1]
    {
      "Interface\\Icons\\Ability_FiegnDead", -- [1]
      1, -- [2]
      2, -- [3]
      14144, -- [4]
    }, -- [2]
    {
      "Interface\\Icons\\Ability_Racial_BloodRage", -- [1]
      1, -- [2]
      3, -- [3]
      14138, -- [4]
    }, -- [3]
    {
      "Interface\\Icons\\Ability_Druid_Disembowel", -- [1]
      2, -- [2]
      1, -- [3]
      14156, -- [4]
    }, -- [4]
    {
      "Interface\\Icons\\Spell_Shadow_DeathScream", -- [1]
      2, -- [2]
      2, -- [3]
      14158, -- [4]
    }, -- [5]
    {
      "Interface\\Icons\\Ability_BackStab", -- [1]
      2, -- [2]
      4, -- [3]
      13733, -- [4]
    }, -- [6]
    {
      "Interface\\Icons\\Ability_Warrior_DecisiveStrike", -- [1]
      3, -- [2]
      1, -- [3]
      14179, -- [4]
    }, -- [7]
    {
      "Interface\\Icons\\Ability_Warrior_Riposte", -- [1]
      3, -- [2]
      2, -- [3]
      14168, -- [4]
    }, -- [8]
    {
      "Interface\\Icons\\Ability_CriticalStrike", -- [1]
      3, -- [2]
      3, -- [3]
      14128, -- [4]
    }, -- [9]
    {
      "Interface\\Icons\\Ability_Rogue_FeignDeath", -- [1]
      4, -- [2]
      2, -- [3]
      16513, -- [4]
    }, -- [10]
    {
      "Interface\\Icons\\Ability_Poisons", -- [1]
      4, -- [2]
      3, -- [3]
      14113, -- [4]
    }, -- [11]
    {
      "Interface\\Icons\\Ability_Rogue_FleetFooted", -- [1]
      5, -- [2]
      1, -- [3]
      31208, -- [4]
    }, -- [12]
    {
      "Interface\\Icons\\Spell_Ice_Lament", -- [1]
      5, -- [2]
      2, -- [3]
      14177, -- [4]
    }, -- [13]
    {
      "Interface\\Icons\\Ability_Rogue_KidneyShot", -- [1]
      5, -- [2]
      3, -- [3]
      14174, -- [4]
    }, -- [14]
    {
      "Interface\\Icons\\Ability_Rogue_QuickRecovery", -- [1]
      5, -- [2]
      4, -- [3]
      31244, -- [4]
    }, -- [15]
    {
      "Interface\\Icons\\Spell_Shadow_ChillTouch", -- [1]
      6, -- [2]
      2, -- [3]
      14186, -- [4]
    }, -- [16]
    {
      "Interface\\Icons\\Ability_Creature_Poison_06", -- [1]
      6, -- [2]
      3, -- [3]
      31226, -- [4]
    }, -- [17]
    {
      "Interface\\Icons\\Spell_Nature_EarthBindTotem", -- [1]
      7, -- [2]
      2, -- [3]
      14983, -- [4]
    }, -- [18]
    {
      "Interface\\Icons\\Ability_Rogue_DeadenedNerves", -- [1]
      7, -- [2]
      3, -- [3]
      31380, -- [4]
    }, -- [19]
    {
      "Interface\\Icons\\Ability_Rogue_FindWeakness", -- [1]
      8, -- [2]
      3, -- [3]
      31233, -- [4]
    }, -- [20]
    {
      "Interface\\Icons\\Ability_Rogue_ShadowStrikes", -- [1]
      9, -- [2]
      2, -- [3]
      1329, -- [4]
    }, -- [21]
    nil, -- [22]
    nil, -- [23]
    nil, -- [24]
    nil, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      "Interface\\Icons\\Ability_Gouge", -- [1]
      1, -- [2]
      1, -- [3]
      13741, -- [4]
    }, -- [41]
    {
      "Interface\\Icons\\Spell_Shadow_RitualOfSacrifice", -- [1]
      1, -- [2]
      2, -- [3]
      13732, -- [4]
    }, -- [42]
    {
      "Interface\\Icons\\Spell_Nature_Invisibilty", -- [1]
      1, -- [2]
      3, -- [3]
      13712, -- [4]
    }, -- [43]
    {
      "Interface\\Icons\\Ability_Rogue_SliceDice", -- [1]
      2, -- [2]
      1, -- [3]
      14165, -- [4]
    }, -- [44]
    {
      "Interface\\Icons\\Ability_Parry", -- [1]
      2, -- [2]
      2, -- [3]
      13713, -- [4]
    }, -- [45]
    {
      "Interface\\Icons\\Ability_Marksmanship", -- [1]
      2, -- [2]
      3, -- [3]
      13705, -- [4]
    }, -- [46]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowWard", -- [1]
      3, -- [2]
      1, -- [3]
      13742, -- [4]
    }, -- [47]
    {
      "Interface\\Icons\\Ability_Warrior_Challange", -- [1]
      3, -- [2]
      2, -- [3]
      14251, -- [4]
    }, -- [48]
    {
      "Interface\\Icons\\Ability_Rogue_Sprint", -- [1]
      3, -- [2]
      4, -- [3]
      13743, -- [4]
    }, -- [49]
    {
      "Interface\\Icons\\Ability_Kick", -- [1]
      4, -- [2]
      1, -- [3]
      13754, -- [4]
    }, -- [50]
    {
      "Interface\\Icons\\INV_Weapon_ShortBlade_05", -- [1]
      4, -- [2]
      2, -- [3]
      13706, -- [4]
    }, -- [51]
    {
      "Interface\\Icons\\Ability_DualWield", -- [1]
      4, -- [2]
      3, -- [3]
      13715, -- [4]
    }, -- [52]
    {
      "Interface\\Icons\\INV_Mace_01", -- [1]
      5, -- [2]
      1, -- [3]
      13709, -- [4]
    }, -- [53]
    {
      "Interface\\Icons\\Ability_Warrior_PunishingBlow", -- [1]
      5, -- [2]
      2, -- [3]
      13877, -- [4]
    }, -- [54]
    {
      "Interface\\Icons\\INV_Sword_27", -- [1]
      5, -- [2]
      3, -- [3]
      13960, -- [4]
    }, -- [55]
    {
      "Interface\\Icons\\INV_Gauntlets_04", -- [1]
      5, -- [2]
      4, -- [3]
      13707, -- [4]
    }, -- [56]
    {
      "Interface\\Icons\\Ability_Rogue_BladeTwisting", -- [1]
      6, -- [2]
      1, -- [3]
      31124, -- [4]
    }, -- [57]
    {
      "Interface\\Icons\\Spell_Holy_BlessingOfStrength", -- [1]
      6, -- [2]
      2, -- [3]
      30919, -- [4]
    }, -- [58]
    {
      "Interface\\Icons\\Ability_Racial_Avatar", -- [1]
      6, -- [2]
      3, -- [3]
      18427, -- [4]
    }, -- [59]
    {
      "Interface\\Icons\\Ability_Warrior_Revenge", -- [1]
      7, -- [2]
      1, -- [3]
      31122, -- [4]
    }, -- [60]
    {
      "Interface\\Icons\\Spell_Shadow_ShadowWordDominate", -- [1]
      7, -- [2]
      2, -- [3]
      13750, -- [4]
    }, -- [61]
    {
      "Interface\\Icons\\Ability_Rogue_NervesOfSteel", -- [1]
      7, -- [2]
      3, -- [3]
      31130, -- [4]
    }, -- [62]
    {
      "Interface\\Icons\\INV_Weapon_Shortblade_38", -- [1]
      8, -- [2]
      3, -- [3]
      35541, -- [4]
    }, -- [63]
    {
      "Interface\\Icons\\Ability_Rogue_SurpriseAttack", -- [1]
      9, -- [2]
      2, -- [3]
      32601, -- [4]
    }, -- [64]
    nil, -- [65]
    nil, -- [66]
    nil, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      "Interface\\Icons\\Spell_Shadow_Charm", -- [1]
      1, -- [2]
      2, -- [3]
      13958, -- [4]
    }, -- [81]
    {
      "Interface\\Icons\\Ability_Warrior_WarCry", -- [1]
      1, -- [2]
      3, -- [3]
      14057, -- [4]
    }, -- [82]
    {
      "Interface\\Icons\\Ability_Rogue_Feint", -- [1]
      2, -- [2]
      1, -- [3]
      30892, -- [4]
    }, -- [83]
    {
      "Interface\\Icons\\Ability_Sap", -- [1]
      2, -- [2]
      2, -- [3]
      14076, -- [4]
    }, -- [84]
    {
      "Interface\\Icons\\Ability_Stealth", -- [1]
      2, -- [2]
      3, -- [3]
      13975, -- [4]
    }, -- [85]
    {
      "Interface\\Icons\\Spell_Shadow_Fumble", -- [1]
      3, -- [2]
      1, -- [3]
      13976, -- [4]
    }, -- [86]
    {
      "Interface\\Icons\\Spell_Shadow_Curse", -- [1]
      3, -- [2]
      2, -- [3]
      14278, -- [4]
    }, -- [87]
    {
      "Interface\\Icons\\Ability_Rogue_Ambush", -- [1]
      3, -- [2]
      3, -- [3]
      14079, -- [4]
    }, -- [88]
    {
      "Interface\\Icons\\Spell_Nature_MirrorImage", -- [1]
      4, -- [2]
      1, -- [3]
      13983, -- [4]
    }, -- [89]
    {
      "Interface\\Icons\\Spell_Magic_LesserInvisibilty", -- [1]
      4, -- [2]
      2, -- [3]
      13981, -- [4]
    }, -- [90]
    {
      "Interface\\Icons\\INV_Sword_17", -- [1]
      4, -- [2]
      3, -- [3]
      14171, -- [4]
    }, -- [91]
    {
      "Interface\\Icons\\Ability_Ambush", -- [1]
      5, -- [2]
      1, -- [3]
      30894, -- [4]
    }, -- [92]
    {
      "Interface\\Icons\\Spell_Shadow_AntiShadow", -- [1]
      5, -- [2]
      2, -- [3]
      14185, -- [4]
    }, -- [93]
    {
      "Interface\\Icons\\Spell_Shadow_SummonSuccubus", -- [1]
      5, -- [2]
      3, -- [3]
      14082, -- [4]
    }, -- [94]
    {
      "Interface\\Icons\\Spell_Shadow_LifeDrain", -- [1]
      5, -- [2]
      4, -- [3]
      16511, -- [4]
    }, -- [95]
    {
      "Interface\\Icons\\Ability_Rogue_MasterOfSubtlety", -- [1]
      6, -- [2]
      1, -- [3]
      31221, -- [4]
    }, -- [96]
    {
      "Interface\\Icons\\INV_Weapon_Crossbow_11", -- [1]
      6, -- [2]
      3, -- [3]
      30902, -- [4]
    }, -- [97]
    {
      "Interface\\Icons\\Ability_Rogue_EnvelopingShadows", -- [1]
      7, -- [2]
      1, -- [3]
      31211, -- [4]
    }, -- [98]
    {
      "Interface\\Icons\\Spell_Shadow_Possession", -- [1]
      7, -- [2]
      2, -- [3]
      14183, -- [4]
    }, -- [99]
    {
      "Interface\\Icons\\Ability_Rogue_CheatDeath", -- [1]
      7, -- [2]
      3, -- [3]
      31228, -- [4]
    }, -- [100]
    {
      "Interface\\Icons\\Ability_Rogue_SinisterCalling", -- [1]
      8, -- [2]
      2, -- [3]
      31216, -- [4]
    }, -- [101]
    {
      "Interface\\Icons\\Ability_Rogue_Shadowstep", -- [1]
      9, -- [2]
      2, -- [3]
      36554, -- [4]
    }, -- [102]
    nil, -- [103]
    nil, -- [104]
    nil, -- [105]
    nil, -- [106]
    nil, -- [107]
    nil, -- [108]
    nil, -- [109]
    nil, -- [110]
    nil, -- [111]
    nil, -- [112]
    nil, -- [113]
    nil, -- [114]
    nil, -- [115]
    nil, -- [116]
    nil, -- [117]
    nil, -- [118]
    nil, -- [119]
    nil, -- [120]
    {
      "RogueAssassination", -- [1]
      "RogueCombat", -- [2]
      "RogueSubtlety", -- [3]
    }, -- [121]
  },
}
