local L = WeakAuras.L

local locale = GAME_LOCALE or GetLocale()

-- This File adds Custom Localization for
-- Specializations, Creature Types, Creature Families, TimeUtils and BossNames
if (locale == "enUS" or locale == "enGB") then
  L["|cFFFF0000Encounter Trigger requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000Encounter Trigger requires Deadly Boss Mods (DBM) to be installed and up to date.|r"
  L["|cFFFF0000Encounter load options requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000Encounter load options requires Deadly Boss Mods (DBM) to be installed and up to date.|r"
  L["Requires Deadly Boss Mods (DBM) to detect encounters."] = "Requires Deadly Boss Mods (DBM) to detect encounters."
  L["Based on "] = "Based on "
  L["Requires syncing the specialization via LibGroupTalents."] = "Requires syncing the specialization via LibGroupTalents."
  L["AddOn: APIDocumentation is %s."] = "AddOn: APIDocumentation is %s."
  L["Please install it."] = "Please install it."
  L["Please enable it in your AddOn list."] = "Please enable it in your AddOn list."
  L["AddOn: APIDocumentation is not loaded correctly."] = "AddOn: APIDocumentation is not loaded correctly."

  L["Affliction"] = "Affliction"
  L["Arcane"] = "Arcane"
  L["Arms"] = "Arms"
  L["Assassination"] = "Assassination"
  L["Balance"] = "Balance"
  L["Beast Mastery"] = "Beast Mastery"
  L["Blood"] = "Blood"
  L["Combat"] = "Combat"
  L["Demonology"] = "Demonology"
  L["Destruction"] = "Destruction"
  L["Discipline"] = "Discipline"
  L["ElementalShaman"] = "Elemental"
  L["Enhancement"] = "Enhancement"
  L["Feral Combat"] = "Feral Combat"
  L["Fire"] = "Fire"
  L["Frost"] = "Frost"
  L["Fury"] = "Fury"
  L["Holy"] = "Holy"
  L["Hybrid"] = "Hybrid"
  L["Marksmanship"] = "Marksmanship"
  L["Protection"] = "Protection"
  L["Restoration"] = "Restoration"
  L["Retribution"] = "Retribution"
  L["Shadow"] = "Shadow"
  L["Subtlety"] = "Subtlety"
  L["Survival"] = "Survival"
  L["Unholy"] = "Unholy"

  L["Beast"] = "Beast"
  L["Critter"] = "Critter"
  L["Dragonkin"] = "Dragonkin"
  L["Gas Cloud"] = "Gas Cloud"
  L["Humanoid"] = "Humanoid"
  L["Mechanical"] = "Mechanical"
  L["Non-combat Pet"] = "Non-combat Pet"
  L["Not specified"] = "Not specified"
  L["Totem"] = "Totem"
  L["Undead"] = "Undead"

  L["Wolf"] = "Wolf"
  L["Cat"] = "Cat"
  L["Spider"] = "Spider"
  L["Bear"] = "Bear"
  L["Boar"] = "Boar"
  L["Crocolisk"] = "Crocolisk"
  L["Carrion Bird"] = "Carrion Bird"
  L["Crab"] = "Crab"
  L["Gorilla"] = "Gorilla"
  L["Raptor"] = "Raptor"
  L["Tallstrider"] = "Tallstrider"
  L["Felhunter"] = "Felhunter"
  L["Voidwalker"] = "Voidwalker"
  L["Succubus"] = "Succubus"
  L["Doomguard"] = "Doomguard"
  L["Turtle"] = "Turtle"
  L["Imp"] = "Imp"
  L["Bat"] = "Bat"
  L["Hyena"] = "Hyena"
  L["Bird of Prey"] = "Bird of Prey"
  L["Wind Serpent"] = "Wind Serpent"
  L["Remote Control"] = "Remote Control"
  L["Felguard"] = "Felguard"
  L["Dragonhawk"] = "Dragonhawk"
  L["Warp Stalker"] = "Warp Stalker"
  L["Sporebat"] = "Sporebat"
  L["Nether Ray"] = "Nether Ray"
  L["Serpent"] = "Serpent"
  L["Moth"] = "Moth"
  L["Chimaera"] = "Chimaera"
  L["Devilsaur"] = "Devilsaur"
  L["Ghoul"] = "Ghoul"
  L["Worm"] = "Worm"
  L["Rhino"] = "Rhino"
  L["Wasp"] = "Wasp"
  L["Core Hound"] = "Core Hound"
  L["Spirit Beast"] = "Spirit Beast"
  L["Incubus"] = "Incubus"

  L["SHORTDATE_EU"] = "%1$d/%2$d/%3$02d"
  L["D_SECONDS"] = "%d |4Second:Seconds;"
  L["SECONDS_ABBR"] = "%d |4Sec:Sec;"
  L["SECOND_ONELETTER_ABBR"] = "%d s"
  L["D_MINUTES"] = "%d |4Minute:Minutes;"
  L["MINUTES_ABBR"] = "%d |4Min:Min;"
  L["MINUTE_ONELETTER_ABBR"] = "%d m"
  L["D_HOURS"] = "%d |4Hour:Hours;"
  L["HOURS_ABBR"] = "%d |4Hr:Hr;"
  L["HOUR_ONELETTER_ABBR"] = "%d h"
  L["D_DAYS"] = "%d |4Day:Days;"
  L["DAYS_ABBR"] = "%d |4Day:Days;"
  L["DAY_ONELETTER_ABBR"] = "%d d"
  L["LESS_THAN_OPERAND"] = "< %s"
  L["TIME_UNIT_DELIMITER"] = " "
  L["HOURS_MINUTES_SECONDS"] = "%.2d:%.2d:%.2d"
  L["MINUTES_SECONDS"] = "%.2d:%.2d"
  L["SHORTDATE"] = "%2$d/%1$02d/%3$02d"
  L["SHORTDATENOYEAR"] = "%2$d/%1$02d"
  L["SHORTDATENOYEAR_EU"] = "%1$d/%2$d"
  L["DECIMAL_SEPERATOR"] = "."
  L["SECOND_NUMBER_CAP"] = " M"
  L["FIRST_NUMBER_CAP"] = " K"
  L["FIRST_NUMBER_CAP_NO_SPACE"] = "K"
  L["FOURTH_NUMBER_CAP_NO_SPACE"] = "T"
  L["SECOND_NUMBER_CAP_NO_SPACE"] = "M"
  L["THIRD_NUMBER_CAP_NO_SPACE"] = "B"

  if WeakAuras.IsWrath() then
    L["Vault of Archavon"] = "Vault of Archavon"
    L["Archavon the Stone Watcher"] = "Archavon the Stone Watcher"
    L["Emalon the Storm Watcher"] = "Emalon the Storm Watcher"
    L["Koralon the Flame Watcher"] = "Koralon the Flame Watcher"
    L["Toravon the Ice Watcher"] = "Toravon the Ice Watcher"
    L["Naxxramas"] = "Naxxramas"
    L["Anub'Rekhan"] = "Anub'Rekhan"
    L["Grand Widow Faerlina"] = "Grand Widow Faerlina"
    L["Maexxna"] = "Maexxna"
    L["Noth the Plaguebringer"] = "Noth the Plaguebringer"
    L["Heigan the Unclean"] = "Heigan the Unclean"
    L["Loatheb"] = "Loatheb"
    L["Instructor Razuvious"] = "Instructor Razuvious"
    L["Gothik the Harvester"] = "Gothik the Harvester"
    L["The Four Horsemen"] = "The Four Horsemen"
    L["Patchwerk"] = "Patchwerk"
    L["Grobbulus"] = "Grobbulus"
    L["Gluth"] = "Gluth"
    L["Thaddius"] = "Thaddius"
    L["Sapphiron"] = "Sapphiron"
    L["Kel'Thuzad"] = "Kel'Thuzad"
    L["The Obsidian Sanctum"] = "The Obsidian Sanctum"
    L["Tenebron"] = "Tenebron"
    L["Shadron"] = "Shadron"
    L["Vesperon"] = "Vesperon"
    L["Sartharion"] = "Sartharion"
    L["The Eye of Eternity"] = "The Eye of Eternity"
    L["Malygos"] = "Malygos"
    L["Ulduar"] = "Ulduar"
    L["Flame Leviathan"] = "Flame Leviathan"
    L["Ignis the Furnace Master"] = "Ignis the Furnace Master"
    L["Razorscale"] = "Razorscale"
    L["XT-002 Deconstructor"] = "XT-002 Deconstructor"
    L["Assembly of Iron"] = "Assembly of Iron"
    L["Kologarn"] = "Kologarn"
    L["Auriaya"] = "Auriaya"
    L["Freya"] = "Freya"
    L["Hodir"] = "Hodir"
    L["Mimiron"] = "Mimiron"
    L["Thorim"] = "Thorim"
    L["General Vezax"] = "General Vezax"
    L["Yogg-Saron"] = "Yogg-Saron"
    L["Algalon the Observer"] = "Algalon the Observer"
    L["Trial of the Crusader"] = "Trial of the Crusader"
    L["Northrend Beasts"] = "Northrend Beasts"
    L["Lord Jaraxxus"] = "Lord Jaraxxus"
    L["Faction Champions"] = "Faction Champions"
    L["Val'kyr Twins"] = "Val'kyr Twins"
    L["Anub'arak"] = "Anub'arak"
    L["Onyxia's Lair"] = "Onyxia's Lair"
    L["Onyxia"] = "Onyxia"
    L["Icecrown Citadel"] = "Icecrown Citadel"
    L["Lord Marrowgar"] = "Lord Marrowgar"
    L["Lady Deathwhisper"] = "Lady Deathwhisper"
    L["Gunship Battle"] = "Gunship Battle"
    L["Deathbringer Saurfang"] = "Deathbringer Saurfang"
    L["Festergut"] = "Festergut"
    L["Rotface"] = "Rotface"
    L["Professor Putricide"] = "Professor Putricide"
    L["Blood Prince Council"] = "Blood Prince Council"
    L["Blood-Queen Lana'thel"] = "Blood-Queen Lana'thel"
    L["Valithria Dreamwalker"] = "Valithria Dreamwalker"
    L["Sindragosa"] = "Sindragosa"
    L["The Lich King"] = "The Lich King"
    L["The Ruby Sanctum"] = "The Ruby Sanctum"
    L["Baltharus the Warborn"] = "Baltharus the Warborn"
    L["General Zarithrian"] = "General Zarithrian"
    L["Saviana Ragefire"] = "Saviana Ragefire"
    L["Halion"] = "Halion"

  elseif WeakAuras.IsTBC() then
    L["Karazhan"] = "Karazhan"
    L["Attumen the Huntsman"] = "Attumen the Huntsman"
    L["Moroes"] = "Moroes"
    L["Maiden of Virtue"] = "Maiden of Virtue"
    L["Opera Hall"] = "Opera Hall"
    L["The Curator"] = "The Curator"
    L["Terestian Illhoof"] = "Terestian Illhoof"
    L["Shade of Aran"] = "Shade of Aran"
    L["Netherspite"] = "Netherspite"
    L["Chess Event"] = "Chess Event"
    L["Prince Malchezaar"] = "Prince Malchezaar"
    L["Nightbane"] = "Nightbane"
    L["Gruul's Lair"] = "Gruul's Lair"
    L["High King Maulgar"] = "High King Maulgar"
    L["Gruul the Dragonkiller"] = "Gruul the Dragonkiller"
    L["Magtheridon's Lair"] = "Magtheridon's Lair"
    L["Magtheridon"] = "Magtheridon"
    L["Coilfang: Serpentshrine Cavern"] = "Coilfang: Serpentshrine Cavern"
    L["Hydross the Unstable"] = "Hydross the Unstable"
    L["The Lurker Below"] = "The Lurker Below"
    L["Leotheras the Blind"] = "Leotheras the Blind"
    L["Fathom-Lord Karathress"] = "Fathom-Lord Karathress"
    L["Morogrim Tidewalker"] = "Morogrim Tidewalker"
    L["Lady Vashj"] = "Lady Vashj"
    L["Tempest Keep"] = "Tempest Keep"
    L["Al'ar"] = "Al'ar"
    L["Void Reaver"] = "Void Reaver"
    L["High Astromancer Solarian"] = "High Astromancer Solarian"
    L["Kael'thas Sunstrider"] = "Kael'thas Sunstrider"
    L["The Battle for Mount Hyjal"] = "The Battle for Mount Hyjal"
    L["Rage Winterchill"] = "Rage Winterchill"
    L["Anetheron"] = "Anetheron"
    L["Kaz'rogal"] = "Kaz'rogal"
    L["Azgalor"] = "Azgalor"
    L["Archimonde"] = "Archimonde"
    L["Black Temple"] = "Black Temple"
    L["High Warlord Naj'entus"] = "High Warlord Naj'entus"
    L["Supremus"] = "Supremus"
    L["Shade of Akama"] = "Shade of Akama"
    L["Teron Gorefiend"] = "Teron Gorefiend"
    L["Gurtogg Bloodboil"] = "Gurtogg Bloodboil"
    L["Reliquary of Souls"] = "Reliquary of Souls"
    L["Mother Shahraz"] = "Mother Shahraz"
    L["The Illidari Council"] = "The Illidari Council"
    L["Illidan Stormrage"] = "Illidan Stormrage"
    L["Zul'Aman"] = "Zul'Aman"
    L["Akil'zon"] = "Akil'zon"
    L["Nalorakk"] = "Nalorakk"
    L["Jan'alai"] = "Jan'alai"
    L["Halazzi"] = "Halazzi"
    L["Hex Lord Malacrass"] = "Hex Lord Malacrass"
    L["Daakara"] = "Daakara"
    L["The Sunwell Plateau"] = "The Sunwell Plateau"
    L["Kalecgos"] = "Kalecgos"
    L["Brutallus"] = "Brutallus"
    L["Felmyst"] = "Felmyst"
    L["Eredar Twins"] = "Eredar Twins"
    L["M'uru"] = "M'uru"
    L["Kil'jaeden"] = "Kil'jaeden"
  end

elseif (locale == "deDE") then
  L["|cFFFF0000Encounter Trigger requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000Begegnungsauslöser erfordert, dass Deadly Boss Mods (DBM) installiert und auf dem neuesten Stand ist.|r"
  L["|cFFFF0000Encounter load options requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000Begegnungs-Ladeoptionen erfordern, dass Deadly Boss Mods (DBM) installiert und auf dem neuesten Stand ist.|r"
  L["Requires Deadly Boss Mods (DBM) to detect encounters."] = "Erfordert Deadly Boss Mods (DBM), um Begegnungen zu erkennen."
  L["Based on "] = "Basierend auf "
  L["AddOn: APIDocumentation is %s."] = "AddOn: APIDocumentation ist %s."
  L["Please install it."] = "Bitte installiere es."
  L["Please enable it in your AddOn list."] = "Bitte aktiviere es in deiner AddOn-Liste."
  L["AddOn: APIDocumentation is not loaded correctly."] = "AddOn: APIDocumentation wurde nicht korrekt geladen."

  --[[Translation missing --]]
  L["Requires syncing the specialization via LibGroupTalents."] = "Requires syncing the specialization via LibGroupTalents."
  L["Affliction"] = "Gebrechen"
  L["Arcane"] = "Arkan"
  L["Arms"] = "Waffen"
  L["Assassination"] = "Meucheln"
  L["Balance"] = "Gleichgewicht"
  L["Beast Mastery"] = "Tierherrschaft"
  L["Blood"] = "Blut"
  L["Combat"] = "Kampf"
  L["Demonology"] = "Dämonologie"
  L["Destruction"] = "Zerstörung"
  L["Discipline"] = "Disziplin"
  L["ElementalShaman"] = "Elementar"
  L["Enhancement"] = "Verstärk."
  L["Feral Combat"] = "Wilder Kampf"
  L["Fire"] = "Feuer"
  L["Frost"] = "Frost"
  L["Fury"] = "Furor"
  L["Holy"] = "Heilig"
  L["Hybrid"] = "Hybride"
  L["Marksmanship"] = "Treffsicherheit"
  L["Protection"] = "Schutz"
  L["Restoration"] = "Wiederherst."
  L["Retribution"] = "Vergeltung"
  L["Shadow"] = "Schatten"
  L["Subtlety"] = "Täuschung"
  L["Survival"] = "Überleben"
  L["Unholy"] = "Unheilig"

  L["Beast"] = "Wildtier"
  L["Critter"] = "Tier"
  L["Dragonkin"] = "Drachkin"
  L["Gas Cloud"] = "Gaswolke"
  L["Humanoid"] = "Humanoid"
  L["Mechanical"] = "Mechanisch"
  L["Non-combat Pet"] = "Haustier"
  L["Not specified"] = "Nicht spezifiziert"
  L["Totem"] = "Totem"
  L["Undead"] = "Untoter"

  L["Wolf"] = "Wolf"
  L["Cat"] = "Katze"
  L["Spider"] = "Spinne"
  L["Bear"] = "Bär"
  L["Boar"] = "Eber"
  L["Crocolisk"] = "Krokilisk"
  L["Carrion Bird"] = "Aasvogel"
  L["Crab"] = "Krebs"
  L["Gorilla"] = "Gorilla"
  L["Raptor"] = "Raptor"
  L["Tallstrider"] = "Weitschreiter"
  L["Felhunter"] = "Teufelsjäger"
  L["Voidwalker"] = "Leerwandler"
  L["Succubus"] = "Sukkubus"
  L["Doomguard"] = "Verdammniswache"
  L["Turtle"] = "Schildkröte"
  L["Imp"] = "Wichtel"
  L["Bat"] = "Fledermaus"
  L["Hyena"] = "Hyäne"
  L["Bird of Prey"] = "Raubvogel"
  L["Wind Serpent"] = "Windnatter"
  L["Remote Control"] = "Ferngesteuert"
  L["Felguard"] = "Teufelswache"
  L["Dragonhawk"] = "Drachenfalke"
  L["Warp Stalker"] = "Sphärenjäger"
  L["Sporebat"] = "Sporensegler"
  L["Nether Ray"] = "Netherrochen"
  L["Serpent"] = "Schlange"
  L["Moth"] = "Motte"
  L["Chimaera"] = "Schimäre"
  L["Devilsaur"] = "Teufelssaurier"
  L["Ghoul"] = "Ghul"
  L["Worm"] = "Wurm"
  L["Rhino"] = "Rhinozeros"
  L["Wasp"] = "Wespe"
  L["Core Hound"] = "Kernhund"
  L["Spirit Beast"] = "Geisterbestie"
  L["Incubus"] = "Inkubus"

  L["SHORTDATE_EU"] = "%1$d.%2$d.%3$02d"
  L["D_SECONDS"] = "%d |4Sekunde:Sekunden;"
  L["SECONDS_ABBR"] = "%d |4Sek.:Sek.;"
  L["SECOND_ONELETTER_ABBR"] = "%d s"
  L["D_MINUTES"] = "%d |4Minute:Minuten;"
  L["MINUTES_ABBR"] = "%d |4Min.:Min.;"
  L["MINUTE_ONELETTER_ABBR"] = "%d m"
  L["D_HOURS"] = "%d |4Stunde:Stunden;"
  L["HOURS_ABBR"] = "%d |4Std.:Std.;"
  L["HOUR_ONELETTER_ABBR"] = "%d h"
  L["D_DAYS"] = "%d |4Tag:Tage;"
  L["DAYS_ABBR"] = "%d |4Tag:Tage;"
  L["DAY_ONELETTER_ABBR"] = "%d d"
  L["LESS_THAN_OPERAND"] = "< %s"
  L["TIME_UNIT_DELIMITER"] = " "
  L["HOURS_MINUTES_SECONDS"] = "%.2d:%.2d:%.2d"
  L["MINUTES_SECONDS"] = "%.2d:%.2d"
  L["SHORTDATE"] = "%1$02d.%2$02d.%3$02d"
  L["SHORTDATENOYEAR"] = "%1$02d.%2$d."
  L["SHORTDATENOYEAR_EU"] = "%1$d.%2$d."
  L["DECIMAL_SEPERATOR"] = ","
  L["SECOND_NUMBER_CAP"] = " M"
  L["FIRST_NUMBER_CAP"] = " K"
  L["FIRST_NUMBER_CAP_NO_SPACE"] = "K"
  L["FOURTH_NUMBER_CAP_NO_SPACE"] = " Bio."
  L["SECOND_NUMBER_CAP_NO_SPACE"] = " Mio."
  L["THIRD_NUMBER_CAP_NO_SPACE"] = " Mrd."

  if WeakAuras.IsWrath() then
    L["Vault of Archavon"] = "Vault of Archavon"
    L["Archavon the Stone Watcher"] = "Archavon the Stone Watcher"
    L["Emalon the Storm Watcher"] = "Emalon the Storm Watcher"
    L["Koralon the Flame Watcher"] = "Koralon the Flame Watcher"
    L["Toravon the Ice Watcher"] = "Toravon the Ice Watcher"
    L["Naxxramas"] = "Naxxramas"
    L["Anub'Rekhan"] = "Anub'Rekhan"
    L["Grand Widow Faerlina"] = "Grand Widow Faerlina"
    L["Maexxna"] = "Maexxna"
    L["Noth the Plaguebringer"] = "Noth the Plaguebringer"
    L["Heigan the Unclean"] = "Heigan the Unclean"
    L["Loatheb"] = "Loatheb"
    L["Instructor Razuvious"] = "Instructor Razuvious"
    L["Gothik the Harvester"] = "Gothik the Harvester"
    L["The Four Horsemen"] = "The Four Horsemen"
    L["Patchwerk"] = "Patchwerk"
    L["Grobbulus"] = "Grobbulus"
    L["Gluth"] = "Gluth"
    L["Thaddius"] = "Thaddius"
    L["Sapphiron"] = "Sapphiron"
    L["Kel'Thuzad"] = "Kel'Thuzad"
    L["The Obsidian Sanctum"] = "The Obsidian Sanctum"
    L["Tenebron"] = "Tenebron"
    L["Shadron"] = "Shadron"
    L["Vesperon"] = "Vesperon"
    L["Sartharion"] = "Sartharion"
    L["The Eye of Eternity"] = "The Eye of Eternity"
    L["Malygos"] = "Malygos"
    L["Ulduar"] = "Ulduar"
    L["Flame Leviathan"] = "Flame Leviathan"
    L["Ignis the Furnace Master"] = "Ignis the Furnace Master"
    L["Razorscale"] = "Razorscale"
    L["XT-002 Deconstructor"] = "XT-002 Deconstructor"
    L["Assembly of Iron"] = "Assembly of Iron"
    L["Kologarn"] = "Kologarn"
    L["Auriaya"] = "Auriaya"
    L["Freya"] = "Freya"
    L["Hodir"] = "Hodir"
    L["Mimiron"] = "Mimiron"
    L["Thorim"] = "Thorim"
    L["General Vezax"] = "General Vezax"
    L["Yogg-Saron"] = "Yogg-Saron"
    L["Algalon the Observer"] = "Algalon the Observer"
    L["Trial of the Crusader"] = "Trial of the Crusader"
    L["Northrend Beasts"] = "Northrend Beasts"
    L["Lord Jaraxxus"] = "Lord Jaraxxus"
    L["Faction Champions"] = "Faction Champions"
    L["Val'kyr Twins"] = "Val'kyr Twins"
    L["Anub'arak"] = "Anub'arak"
    L["Onyxia's Lair"] = "Onyxias Hort"
    L["Onyxia"] = "Onyxia"
    L["Icecrown Citadel"] = "Icecrown Citadel"
    L["Lord Marrowgar"] = "Lord Marrowgar"
    L["Lady Deathwhisper"] = "Lady Deathwhisper"
    L["Gunship Battle"] = "Gunship Battle"
    L["Deathbringer Saurfang"] = "Deathbringer Saurfang"
    L["Festergut"] = "Festergut"
    L["Rotface"] = "Rotface"
    L["Professor Putricide"] = "Professor Putricide"
    L["Blood Prince Council"] = "Blood Prince Council"
    L["Blood-Queen Lana'thel"] = "Blood-Queen Lana'thel"
    L["Valithria Dreamwalker"] = "Valithria Dreamwalker"
    L["Sindragosa"] = "Sindragosa"
    L["The Lich King"] = "The Lich King"
    L["The Ruby Sanctum"] = "The Ruby Sanctum"
    L["Baltharus the Warborn"] = "Baltharus the Warborn"
    L["General Zarithrian"] = "General Zarithrian"
    L["Saviana Ragefire"] = "Saviana Ragefire"
    L["Halion"] = "Halion"

  elseif WeakAuras.IsTBC() then
    L["Karazhan"] = "Karazhan"
    L["Attumen the Huntsman"] = "Attumen the Huntsman"
    L["Moroes"] = "Moroes"
    L["Maiden of Virtue"] = "Maiden of Virtue"
    L["Opera Hall"] = "Opera Hall"
    L["The Curator"] = "The Curator"
    L["Terestian Illhoof"] = "Terestian Illhoof"
    L["Shade of Aran"] = "Shade of Aran"
    L["Netherspite"] = "Netherspite"
    L["Chess Event"] = "Chess Event"
    L["Prince Malchezaar"] = "Prince Malchezaar"
    L["Nightbane"] = "Nightbane"
    L["Gruul's Lair"] = "Gruul's Lair"
    L["High King Maulgar"] = "High King Maulgar"
    L["Gruul the Dragonkiller"] = "Gruul the Dragonkiller"
    L["Magtheridon's Lair"] = "Magtheridon's Lair"
    L["Magtheridon"] = "Magtheridon"
    L["Coilfang: Serpentshrine Cavern"] = "Coilfang: Serpentshrine Cavern"
    L["Hydross the Unstable"] = "Hydross the Unstable"
    L["The Lurker Below"] = "The Lurker Below"
    L["Leotheras the Blind"] = "Leotheras the Blind"
    L["Fathom-Lord Karathress"] = "Fathom-Lord Karathress"
    L["Morogrim Tidewalker"] = "Morogrim Tidewalker"
    L["Lady Vashj"] = "Lady Vashj"
    L["Tempest Keep"] = "Tempest Keep"
    L["Al'ar"] = "Al'ar"
    L["Void Reaver"] = "Void Reaver"
    L["High Astromancer Solarian"] = "High Astromancer Solarian"
    L["Kael'thas Sunstrider"] = "Kael'thas Sunstrider"
    L["The Battle for Mount Hyjal"] = "The Battle for Mount Hyjal"
    L["Rage Winterchill"] = "Rage Winterchill"
    L["Anetheron"] = "Anetheron"
    L["Kaz'rogal"] = "Kaz'rogal"
    L["Azgalor"] = "Azgalor"
    L["Archimonde"] = "Archimonde"
    L["Black Temple"] = "Black Temple"
    L["High Warlord Naj'entus"] = "High Warlord Naj'entus"
    L["Supremus"] = "Supremus"
    L["Shade of Akama"] = "Shade of Akama"
    L["Teron Gorefiend"] = "Teron Gorefiend"
    L["Gurtogg Bloodboil"] = "Gurtogg Bloodboil"
    L["Reliquary of Souls"] = "Reliquary of Souls"
    L["Mother Shahraz"] = "Mother Shahraz"
    L["The Illidari Council"] = "The Illidari Council"
    L["Illidan Stormrage"] = "Illidan Stormrage"
    L["Zul'Aman"] = "Zul'Aman"
    L["Akil'zon"] = "Akil'zon"
    L["Nalorakk"] = "Nalorakk"
    L["Jan'alai"] = "Jan'alai"
    L["Halazzi"] = "Halazzi"
    L["Hex Lord Malacrass"] = "Hex Lord Malacrass"
    L["Daakara"] = "Daakara"
    L["The Sunwell Plateau"] = "The Sunwell Plateau"
    L["Kalecgos"] = "Kalecgos"
    L["Brutallus"] = "Brutallus"
    L["Felmyst"] = "Felmyst"
    L["Eredar Twins"] = "Eredar Twins"
    L["M'uru"] = "M'uru"
    L["Kil'jaeden"] = "Kil'jaeden"
  end

elseif (locale == "esES") then
  L["|cFFFF0000Encounter Trigger requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000El disparador del encuentro requiere que Deadly Boss Mods (DBM) esté instalado y actualizado.|r"
  L["|cFFFF0000Encounter load options requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000Las opciones de carga del encuentro requieren que Deadly Boss Mods (DBM) esté instalado y actualizado.|r"
  L["Requires Deadly Boss Mods (DBM) to detect encounters."] = "Requiere Deadly Boss Mods (DBM) para detectar encuentros."
  L["Based on "] = "Basado en "
  L["AddOn: APIDocumentation is %s."] = "AddOn: APIDocumentation está %s."
  L["Please install it."] = "Por favor, instálalo."
  L["Please enable it in your AddOn list."] = "Por favor, actívalo en tu lista de AddOns."
  L["AddOn: APIDocumentation is not loaded correctly."] = "AddOn: APIDocumentation no se ha cargado correctamente."

  L["Requires syncing the specialization via LibGroupTalents."] = "Requiere sincronizar la especialización mediante LibGroupTalents."
  L["Affliction"] = "Aflicción"
  L["Arcane"] = "Arcano"
  L["Arms"] = "Armas"
  L["Assassination"] = "Asesinato"
  L["Balance"] = "Equilibrio"
  L["Beast Mastery"] = "Dominio de bestias"
  L["Blood"] = "Sangre"
  L["Combat"] = "Combate"
  L["Demonology"] = "Demonología"
  L["Destruction"] = "Destrucción"
  L["Discipline"] = "Disciplina"
  L["ElementalShaman"] = "Elemental"
  L["Enhancement"] = "Mejora"
  L["Feral Combat"] = "Combate feral"
  L["Fire"] = "Fuego"
  L["Frost"] = "Escarcha"
  L["Fury"] = "Furia"
  L["Holy"] = "Sagrado"
  L["Hybrid"] = "Híbrido"
  L["Marksmanship"] = "Puntería"
  L["Protection"] = "Protección"
  L["Restoration"] = "Restauración"
  L["Retribution"] = "Reprensión"
  L["Shadow"] = "Sombra"
  L["Subtlety"] = "Sutileza"
  L["Survival"] = "Supervivencia"
  L["Unholy"] = "Profano"

  L["Beast"] = "Bestia"
  L["Critter"] = "Alma"
  L["Dragonkin"] = "Dragón"
  L["Gas Cloud"] = "Nube de Gas"
  L["Humanoid"] = "Humanoide"
  L["Mechanical"] = "Mecánico"
  L["Non-combat Pet"] = "Mascota no combatiente"
  L["Not specified"] = "No especificado"
  L["Totem"] = "Tótem"
  L["Undead"] = "No-muerto"

  L["Wolf"] = "Lobo"
  L["Cat"] = "Felino"
  L["Spider"] = "Araña"
  L["Bear"] = "Oso"
  L["Boar"] = "Jabalí"
  L["Crocolisk"] = "Crocolisco"
  L["Carrion Bird"] = "Carroñero"
  L["Crab"] = "Cangrejo"
  L["Gorilla"] = "Gorila"
  L["Raptor"] = "Raptor"
  L["Tallstrider"] = "Zancaalta"
  L["Felhunter"] = "Manáfago"
  L["Voidwalker"] = "Abisario"
  L["Succubus"] = "Súcubo"
  L["Doomguard"] = "Guardia apocalíptico"
  L["Turtle"] = "Tortuga"
  L["Imp"] = "Diablillo"
  L["Bat"] = "Murciélago"
  L["Hyena"] = "Hiena"
  L["Bird of Prey"] = "Ave rapaz"
  L["Wind Serpent"] = "Serpiente alada"
  L["Remote Control"] = "Control remoto"
  L["Felguard"] = "Guardia vil"
  L["Dragonhawk"] = "Dracohalcón"
  L["Warp Stalker"] = "Acechador deformado"
  L["Sporebat"] = "Esporiélago"
  L["Nether Ray"] = "Raya abisal"
  L["Serpent"] = "Serpiente"
  L["Moth"] = "Palomilla"
  L["Chimaera"] = "Quimera"
  L["Devilsaur"] = "Demosaurio"
  L["Ghoul"] = "Necrófago"
  L["Worm"] = "Gusano"
  L["Rhino"] = "Rinoceronte"
  L["Wasp"] = "Avispa"
  L["Core Hound"] = "Can del Núcleo"
  L["Spirit Beast"] = "Bestia espíritu"
  L["Incubus"] = "Íncubos"

  L["SHORTDATE_EU"] = "%1$d/%2$d/%3$02d"
  L["D_SECONDS"] = "%d |4segundo:segundos;"
  L["SECONDS_ABBR"] = "%d |4s:s;"
  L["SECOND_ONELETTER_ABBR"] = "%d s"
  L["D_MINUTES"] = "%d |4minuto:minutos;"
  L["MINUTES_ABBR"] = "%d |4min:min;"
  L["MINUTE_ONELETTER_ABBR"] = "%d m"
  L["D_HOURS"] = "%d |4hora:horas;"
  L["HOURS_ABBR"] = "%d |4h:h;"
  L["HOUR_ONELETTER_ABBR"] = "%d h"
  L["D_DAYS"] = "%d |4día:días;"
  L["DAYS_ABBR"] = "%d |4día:días;"
  L["DAY_ONELETTER_ABBR"] = "%d d"
  L["LESS_THAN_OPERAND"] = "< %s"
  L["TIME_UNIT_DELIMITER"] = " "
  L["HOURS_MINUTES_SECONDS"] = "%.2d:%.2d:%.2d"
  L["MINUTES_SECONDS"] = "%.2d:%.2d"
  L["SHORTDATE"] = "%1$02d/%2$02d/%3$02d"
  L["SHORTDATENOYEAR"] = "%1$02d/%2$d"
  L["SHORTDATENOYEAR_EU"] = "%1$d/%2$d"
  L["DECIMAL_SEPERATOR"] = "."
  L["SECOND_NUMBER_CAP"] = "mill."
  L["FIRST_NUMBER_CAP"] = "mil"
  L["FIRST_NUMBER_CAP_NO_SPACE"] = "mil"
  L["FOURTH_NUMBER_CAP_NO_SPACE"] = "T"
  L["SECOND_NUMBER_CAP_NO_SPACE"] = "mill."
  L["THIRD_NUMBER_CAP_NO_SPACE"] = "MM"

  if WeakAuras.IsWrath() then
    L["Vault of Archavon"] = "La Cámara de Archavon"
    L["Archavon the Stone Watcher"] = "Archavon el Vigía de Piedra"
    L["Emalon the Storm Watcher"] = "Emalon el Vigía de la Tormenta"
    L["Koralon the Flame Watcher"] = "Koralon el Vigía de las Llamas"
    L["Toravon the Ice Watcher"] = "Toravon el Vigía de Hielo"
    L["Naxxramas"] = "Naxxramas"
    L["Anub'Rekhan"] = "Anub'Rekhan"
    L["Grand Widow Faerlina"] = "Gran Viuda Faerlina"
    L["Maexxna"] = "Maexxna"
    L["Noth the Plaguebringer"] = "Noth el Pesteador"
    L["Heigan the Unclean"] = "Heigan el Impuro"
    L["Loatheb"] = "Loatheb"
    L["Instructor Razuvious"] = "Instructor Razuvious"
    L["Gothik the Harvester"] = "Gothik el Cosechador"
    L["The Four Horsemen"] = "Los cuatro jinetes"
    L["Patchwerk"] = "Remendejo"
    L["Grobbulus"] = "Grobbulus"
    L["Gluth"] = "Gluth"
    L["Thaddius"] = "Thaddius"
    L["Sapphiron"] = "Sapphiron"
    L["Kel'Thuzad"] = "Kel'Thuzad"
    L["The Obsidian Sanctum"] = "El Sagrario Obsidiana"
    L["Tenebron"] = "Tenebron"
    L["Shadron"] = "Shadron"
    L["Vesperon"] = "Vesperon"
    L["Sartharion"] = "Sartharion"
    L["The Eye of Eternity"] = "El Ojo de la Eternidad"
    L["Malygos"] = "Malygos"
    L["Ulduar"] = "Ulduar"
    L["Flame Leviathan"] = "Leviatán de llamas"
    L["Ignis the Furnace Master"] = "Ignis, el Maestro de la Caldera"
    L["Razorscale"] = "Tajoescama"
    L["XT-002 Deconstructor"] = "Desarmador XA-002"
    L["Assembly of Iron"] = "Asamblea de Hierro"
    L["Kologarn"] = "Kologarn"
    L["Auriaya"] = "Auriaya"
    L["Freya"] = "Freya"
    L["Hodir"] = "Hodir"
    L["Mimiron"] = "Mimiron"
    L["Thorim"] = "Thorim"
    L["General Vezax"] = "General Vezax"
    L["Yogg-Saron"] = "Yogg-Saron"
    L["Algalon the Observer"] = "Algalon el Observador"
    L["Trial of the Crusader"] = "Prueba del Cruzado"
    L["Northrend Beasts"] = "Bestias de Rasganorte"
    L["Lord Jaraxxus"] = "Lord Jaraxxus"
    L["Faction Champions"] = "Campeones de facción"
    L["Val'kyr Twins"] = "Gemelas Val'kyr"
    L["Anub'arak"] = "Anub'arak"
    L["Onyxia's Lair"] = "Guarida de Onyxia"
    L["Onyxia"] = "Onyxia"
    L["Icecrown Citadel"] = "Ciudadela de la Corona de Hielo"
    L["Lord Marrowgar"] = "Lord Tuétano"
    L["Lady Deathwhisper"] = "Lady Susurramuerte"
    L["Gunship Battle"] = "Batalla de las naves de guerra"
    L["Deathbringer Saurfang"] = "Libramorte Colmillosauro"
    L["Festergut"] = "Panzachancro"
    L["Rotface"] = "Carapútrea"
    L["Professor Putricide"] = "Profesor Putricidio"
    L["Blood Prince Council"] = "Consejo de Príncipes de Sangre"
    L["Blood-Queen Lana'thel"] = "Reina de Sangre Lana'thel"
    L["Valithria Dreamwalker"] = "Valithria Caminasueños"
    L["Sindragosa"] = "Sindragosa"
    L["The Lich King"] = "El Rey Éxamine"
    L["The Ruby Sanctum"] = "El Sagrario Rubí"
    L["Baltharus the Warborn"] = "Baltharus el Batallante"
    L["General Zarithrian"] = "General Zarithrian"
    L["Saviana Ragefire"] = "Saviana Furia Ardiente"
    L["Halion"] = "Halion"

  elseif WeakAuras.IsTBC() then
    L["Karazhan"] = "Karazhan"
    L["Attumen the Huntsman"] = "Attumen the Huntsman"
    L["Moroes"] = "Moroes"
    L["Maiden of Virtue"] = "Maiden of Virtue"
    L["Opera Hall"] = "Opera Hall"
    L["The Curator"] = "The Curator"
    L["Terestian Illhoof"] = "Terestian Illhoof"
    L["Shade of Aran"] = "Shade of Aran"
    L["Netherspite"] = "Netherspite"
    L["Chess Event"] = "Chess Event"
    L["Prince Malchezaar"] = "Prince Malchezaar"
    L["Nightbane"] = "Nightbane"
    L["Gruul's Lair"] = "Gruul's Lair"
    L["High King Maulgar"] = "High King Maulgar"
    L["Gruul the Dragonkiller"] = "Gruul the Dragonkiller"
    L["Magtheridon's Lair"] = "Magtheridon's Lair"
    L["Magtheridon"] = "Magtheridon"
    L["Coilfang: Serpentshrine Cavern"] = "Coilfang: Serpentshrine Cavern"
    L["Hydross the Unstable"] = "Hydross the Unstable"
    L["The Lurker Below"] = "The Lurker Below"
    L["Leotheras the Blind"] = "Leotheras the Blind"
    L["Fathom-Lord Karathress"] = "Fathom-Lord Karathress"
    L["Morogrim Tidewalker"] = "Morogrim Tidewalker"
    L["Lady Vashj"] = "Lady Vashj"
    L["Tempest Keep"] = "Tempest Keep"
    L["Al'ar"] = "Al'ar"
    L["Void Reaver"] = "Void Reaver"
    L["High Astromancer Solarian"] = "High Astromancer Solarian"
    L["Kael'thas Sunstrider"] = "Kael'thas Sunstrider"
    L["The Battle for Mount Hyjal"] = "The Battle for Mount Hyjal"
    L["Rage Winterchill"] = "Rage Winterchill"
    L["Anetheron"] = "Anetheron"
    L["Kaz'rogal"] = "Kaz'rogal"
    L["Azgalor"] = "Azgalor"
    L["Archimonde"] = "Archimonde"
    L["Black Temple"] = "Black Temple"
    L["High Warlord Naj'entus"] = "High Warlord Naj'entus"
    L["Supremus"] = "Supremus"
    L["Shade of Akama"] = "Shade of Akama"
    L["Teron Gorefiend"] = "Teron Gorefiend"
    L["Gurtogg Bloodboil"] = "Gurtogg Bloodboil"
    L["Reliquary of Souls"] = "Reliquary of Souls"
    L["Mother Shahraz"] = "Mother Shahraz"
    L["The Illidari Council"] = "The Illidari Council"
    L["Illidan Stormrage"] = "Illidan Stormrage"
    L["Zul'Aman"] = "Zul'Aman"
    L["Akil'zon"] = "Akil'zon"
    L["Nalorakk"] = "Nalorakk"
    L["Jan'alai"] = "Jan'alai"
    L["Halazzi"] = "Halazzi"
    L["Hex Lord Malacrass"] = "Hex Lord Malacrass"
    L["Daakara"] = "Daakara"
    L["The Sunwell Plateau"] = "The Sunwell Plateau"
    L["Kalecgos"] = "Kalecgos"
    L["Brutallus"] = "Brutallus"
    L["Felmyst"] = "Felmyst"
    L["Eredar Twins"] = "Eredar Twins"
    L["M'uru"] = "M'uru"
    L["Kil'jaeden"] = "Kil'jaeden"
  end

elseif (locale == "esMX") then
  L["|cFFFF0000Encounter Trigger requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000El disparador del encuentro requiere que Deadly Boss Mods (DBM) esté instalado y actualizado.|r"
  L["|cFFFF0000Encounter load options requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000Las opciones de carga del encuentro requieren que Deadly Boss Mods (DBM) esté instalado y actualizado.|r"
  L["Requires Deadly Boss Mods (DBM) to detect encounters."] = "Requiere Deadly Boss Mods (DBM) para detectar encuentros."
  L["Based on "] = "Basado en "
  L["AddOn: APIDocumentation is %s."] = "AddOn: APIDocumentation está %s."
  L["Please install it."] = "Por favor, instálalo."
  L["Please enable it in your AddOn list."] = "Por favor, actívalo en tu lista de AddOns."
  L["AddOn: APIDocumentation is not loaded correctly."] = "AddOn: APIDocumentation no se ha cargado correctamente."

  L["Requires syncing the specialization via LibGroupTalents."] = "Requiere sincronizar la especialización mediante LibGroupTalents."
  L["Affliction"] = "Aflicción"
  L["Arcane"] = "Arcano"
  L["Arms"] = "Armas"
  L["Assassination"] = "Asesinato"
  L["Balance"] = "Balance"
  L["Beast Mastery"] = "Bestias"
  L["Blood"] = "Sangre"
  L["Combat"] = "Combate"
  L["Demonology"] = "Demonología"
  L["Destruction"] = "Destrucción"
  L["Discipline"] = "Disciplina"
  L["ElementalShaman"] = "Elemental"
  L["Enhancement"] = "Mejora"
  L["Feral Combat"] = "Combate feral"
  L["Fire"] = "Fuego"
  L["Frost"] = "Escarcha"
  L["Fury"] = "Furia"
  L["Holy"] = "Sagrado"
  L["Hybrid"] = "Híbrido"
  L["Marksmanship"] = "Puntería"
  L["Protection"] = "Protección"
  L["Restoration"] = "Restauración"
  L["Retribution"] = "Reprensión"
  L["Shadow"] = "Sombra"
  L["Subtlety"] = "Sutileza"
  L["Survival"] = "Supervivencia"
  L["Unholy"] = "Profano"

  L["Beast"] = "Bestia"
  L["Critter"] = "Alma"
  L["Dragonkin"] = "Dragon"
  L["Gas Cloud"] = "Nube de Gas"
  L["Humanoid"] = "Humanoide"
  L["Mechanical"] = "Mecánico"
  L["Non-combat Pet"] = "Mascota mansa"
  L["Not specified"] = "Sin especificar"
  L["Totem"] = "Totém"
  L["Undead"] = "No-muerto"

  L["Wolf"] = "Lobo"
  L["Cat"] = "Felino"
  L["Spider"] = "Araña"
  L["Bear"] = "Oso"
  L["Boar"] = "Jabalí"
  L["Crocolisk"] = "Crocolisco"
  L["Carrion Bird"] = "Carroñero"
  L["Crab"] = "Cangrejo"
  L["Gorilla"] = "Gorila"
  L["Raptor"] = "Raptor"
  L["Tallstrider"] = "Zancaalta"
  L["Felhunter"] = "Manáfago"
  L["Voidwalker"] = "Abisario"
  L["Succubus"] = "Súcubo"
  L["Doomguard"] = "Guardia apocalíptico"
  L["Turtle"] = "Tortuga"
  L["Imp"] = "Diablillo"
  L["Bat"] = "Murciélago"
  L["Hyena"] = "Hiena"
  L["Bird of Prey"] = "Ave rapaz"
  L["Wind Serpent"] = "Serpiente alada"
  L["Remote Control"] = "Control remoto"
  L["Felguard"] = "Guardia vil"
  L["Dragonhawk"] = "Dracohalcón"
  L["Warp Stalker"] = "Acechador deformado"
  L["Sporebat"] = "Esporiélago"
  L["Nether Ray"] = "Raya abisal"
  L["Serpent"] = "Serpiente"
  L["Moth"] = "Palomilla"
  L["Chimaera"] = "Quimera"
  L["Devilsaur"] = "Demosaurio"
  L["Ghoul"] = "Necrófago"
  L["Worm"] = "Gusano"
  L["Rhino"] = "Rinoceronte"
  L["Wasp"] = "Avispa"
  L["Core Hound"] = "Can del Núcleo"
  L["Spirit Beast"] = "Bestia espíritu"
  L["Incubus"] = "Íncubo"

  L["SHORTDATE_EU"] = "%1$d/%2$d/%3$02d"
  L["D_SECONDS"] = "%d |4segundo:segundos;"
  L["SECONDS_ABBR"] = "%d |4s:s;"
  L["SECOND_ONELETTER_ABBR"] = "%d s"
  L["D_MINUTES"] = "%d |4minuto:minutos;"
  L["MINUTES_ABBR"] = "%d |4min:min;"
  L["MINUTE_ONELETTER_ABBR"] = "%d m"
  L["D_HOURS"] = "%d |4Hora:Horas;"
  L["HOURS_ABBR"] = "%d |4h:h;"
  L["HOUR_ONELETTER_ABBR"] = "%d h"
  L["D_DAYS"] = "%d |4Día:Días;"
  L["DAYS_ABBR"] = "%d |4Día:Días;"
  L["DAY_ONELETTER_ABBR"] = "%d d"
  L["LESS_THAN_OPERAND"] = "< %s"
  L["TIME_UNIT_DELIMITER"] = " "
  L["HOURS_MINUTES_SECONDS"] = "%.2d:%.2d:%.2d"
  L["MINUTES_SECONDS"] = "%.2d:%.2d"
  L["SHORTDATE"] = "%1$02d/%2$02d/%3$02d"
  L["SHORTDATENOYEAR"] = "%1$02d/%2$d"
  L["SHORTDATENOYEAR_EU"] = "%1$d/%2$d"
  L["DECIMAL_SEPERATOR"] = "."
  L["SECOND_NUMBER_CAP"] = "mill."
  L["FIRST_NUMBER_CAP"] = "mil"
  L["FIRST_NUMBER_CAP_NO_SPACE"] = "mil"
  L["FOURTH_NUMBER_CAP_NO_SPACE"] = "T"
  L["SECOND_NUMBER_CAP_NO_SPACE"] = "mill."
  L["THIRD_NUMBER_CAP_NO_SPACE"] = "B"

  if WeakAuras.IsWrath() then
    L["Vault of Archavon"] = "La Cámara de Archavon"
    L["Archavon the Stone Watcher"] = "Archavon el Vigía de Piedra"
    L["Emalon the Storm Watcher"] = "Emalon el Vigía de la Tormenta"
    L["Koralon the Flame Watcher"] = "Koralon el Vigía de las Llamas"
    L["Toravon the Ice Watcher"] = "Toravon el Vigía de Hielo"
    L["Naxxramas"] = "Naxxramas"
    L["Anub'Rekhan"] = "Anub'Rekhan"
    L["Grand Widow Faerlina"] = "Gran Viuda Faerlina"
    L["Maexxna"] = "Maexxna"
    L["Noth the Plaguebringer"] = "Noth el Pesteador"
    L["Heigan the Unclean"] = "Heigan el Impuro"
    L["Loatheb"] = "Loatheb"
    L["Instructor Razuvious"] = "Instructor Razuvious"
    L["Gothik the Harvester"] = "Gothik el Cosechador"
    L["The Four Horsemen"] = "Los cuatro jinetes"
    L["Patchwerk"] = "Remendejo"
    L["Grobbulus"] = "Grobbulus"
    L["Gluth"] = "Gluth"
    L["Thaddius"] = "Thaddius"
    L["Sapphiron"] = "Sapphiron"
    L["Kel'Thuzad"] = "Kel'Thuzad"
    L["The Obsidian Sanctum"] = "El Sagrario Obsidiana"
    L["Tenebron"] = "Tenebron"
    L["Shadron"] = "Shadron"
    L["Vesperon"] = "Vesperon"
    L["Sartharion"] = "Sartharion"
    L["The Eye of Eternity"] = "El Ojo de la Eternidad"
    L["Malygos"] = "Malygos"
    L["Ulduar"] = "Ulduar"
    L["Flame Leviathan"] = "Leviatán de llamas"
    L["Ignis the Furnace Master"] = "Ignis, el Maestro de la Caldera"
    L["Razorscale"] = "Tajoescama"
    L["XT-002 Deconstructor"] = "Desarmador XA-002"
    L["Assembly of Iron"] = "Asamblea de Hierro"
    L["Kologarn"] = "Kologarn"
    L["Auriaya"] = "Auriaya"
    L["Freya"] = "Freya"
    L["Hodir"] = "Hodir"
    L["Mimiron"] = "Mimiron"
    L["Thorim"] = "Thorim"
    L["General Vezax"] = "General Vezax"
    L["Yogg-Saron"] = "Yogg-Saron"
    L["Algalon the Observer"] = "Algalon el Observador"
    L["Trial of the Crusader"] = "Prueba del Cruzado"
    L["Northrend Beasts"] = "Bestias de Rasganorte"
    L["Lord Jaraxxus"] = "Lord Jaraxxus"
    L["Faction Champions"] = "Campeones de facción"
    L["Val'kyr Twins"] = "Gemelas Val'kyr"
    L["Anub'arak"] = "Anub'arak"
    L["Onyxia's Lair"] = "Guarida de Onyxia"
    L["Onyxia"] = "Onyxia"
    L["Icecrown Citadel"] = "Ciudadela de la Corona de Hielo"
    L["Lord Marrowgar"] = "Lord Tuétano"
    L["Lady Deathwhisper"] = "Lady Susurramuerte"
    L["Gunship Battle"] = "Batalla de las naves de guerra"
    L["Deathbringer Saurfang"] = "Libramorte Colmillosauro"
    L["Festergut"] = "Panzachancro"
    L["Rotface"] = "Carapútrea"
    L["Professor Putricide"] = "Profesor Putricidio"
    L["Blood Prince Council"] = "Consejo de Príncipes de Sangre"
    L["Blood-Queen Lana'thel"] = "Reina de Sangre Lana'thel"
    L["Valithria Dreamwalker"] = "Valithria Caminasueños"
    L["Sindragosa"] = "Sindragosa"
    L["The Lich King"] = "El Rey Éxamine"
    L["The Ruby Sanctum"] = "El Sagrario Rubí"
    L["Baltharus the Warborn"] = "Baltharus el Batallante"
    L["General Zarithrian"] = "General Zarithrian"
    L["Saviana Ragefire"] = "Saviana Furia Ardiente"
    L["Halion"] = "Halion"

  elseif WeakAuras.IsTBC() then
    L["Karazhan"] = "Karazhan"
    L["Attumen the Huntsman"] = "Attumen the Huntsman"
    L["Moroes"] = "Moroes"
    L["Maiden of Virtue"] = "Maiden of Virtue"
    L["Opera Hall"] = "Opera Hall"
    L["The Curator"] = "The Curator"
    L["Terestian Illhoof"] = "Terestian Illhoof"
    L["Shade of Aran"] = "Shade of Aran"
    L["Netherspite"] = "Netherspite"
    L["Chess Event"] = "Chess Event"
    L["Prince Malchezaar"] = "Prince Malchezaar"
    L["Nightbane"] = "Nightbane"
    L["Gruul's Lair"] = "Gruul's Lair"
    L["High King Maulgar"] = "High King Maulgar"
    L["Gruul the Dragonkiller"] = "Gruul the Dragonkiller"
    L["Magtheridon's Lair"] = "Magtheridon's Lair"
    L["Magtheridon"] = "Magtheridon"
    L["Coilfang: Serpentshrine Cavern"] = "Coilfang: Serpentshrine Cavern"
    L["Hydross the Unstable"] = "Hydross the Unstable"
    L["The Lurker Below"] = "The Lurker Below"
    L["Leotheras the Blind"] = "Leotheras the Blind"
    L["Fathom-Lord Karathress"] = "Fathom-Lord Karathress"
    L["Morogrim Tidewalker"] = "Morogrim Tidewalker"
    L["Lady Vashj"] = "Lady Vashj"
    L["Tempest Keep"] = "Tempest Keep"
    L["Al'ar"] = "Al'ar"
    L["Void Reaver"] = "Void Reaver"
    L["High Astromancer Solarian"] = "High Astromancer Solarian"
    L["Kael'thas Sunstrider"] = "Kael'thas Sunstrider"
    L["The Battle for Mount Hyjal"] = "The Battle for Mount Hyjal"
    L["Rage Winterchill"] = "Rage Winterchill"
    L["Anetheron"] = "Anetheron"
    L["Kaz'rogal"] = "Kaz'rogal"
    L["Azgalor"] = "Azgalor"
    L["Archimonde"] = "Archimonde"
    L["Black Temple"] = "Black Temple"
    L["High Warlord Naj'entus"] = "High Warlord Naj'entus"
    L["Supremus"] = "Supremus"
    L["Shade of Akama"] = "Shade of Akama"
    L["Teron Gorefiend"] = "Teron Gorefiend"
    L["Gurtogg Bloodboil"] = "Gurtogg Bloodboil"
    L["Reliquary of Souls"] = "Reliquary of Souls"
    L["Mother Shahraz"] = "Mother Shahraz"
    L["The Illidari Council"] = "The Illidari Council"
    L["Illidan Stormrage"] = "Illidan Stormrage"
    L["Zul'Aman"] = "Zul'Aman"
    L["Akil'zon"] = "Akil'zon"
    L["Nalorakk"] = "Nalorakk"
    L["Jan'alai"] = "Jan'alai"
    L["Halazzi"] = "Halazzi"
    L["Hex Lord Malacrass"] = "Hex Lord Malacrass"
    L["Daakara"] = "Daakara"
    L["The Sunwell Plateau"] = "The Sunwell Plateau"
    L["Kalecgos"] = "Kalecgos"
    L["Brutallus"] = "Brutallus"
    L["Felmyst"] = "Felmyst"
    L["Eredar Twins"] = "Eredar Twins"
    L["M'uru"] = "M'uru"
    L["Kil'jaeden"] = "Kil'jaeden"
  end

elseif (locale == "frFR") then
  L["|cFFFF0000Encounter Trigger requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000Le déclencheur de rencontre nécessite que Deadly Boss Mods (DBM) soit installé et à jour.|r"
  L["|cFFFF0000Encounter load options requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000Les options de chargement de la rencontre nécessitent que Deadly Boss Mods (DBM) soit installé et à jour.|r"
  L["Requires Deadly Boss Mods (DBM) to detect encounters."] = "Nécessite Deadly Boss Mods (DBM) pour détecter les rencontres."
  L["Based on "] = "Basé sur "
  L["AddOn: APIDocumentation is %s."] = "Addon: APIDocumentation est %s."
  L["Please install it."] = "Veuillez l'installer."
  L["Please enable it in your AddOn list."] = "Veuillez l'activer dans votre liste d'Addons."
  L["AddOn: APIDocumentation is not loaded correctly."] = "Addon: APIDocumentation n'a pas été chargé correctement."

  --[[Translation missing --]]
  L["Requires syncing the specialization via LibGroupTalents."] = "Requires syncing the specialization via LibGroupTalents."
  L["Affliction"] = "Affliction"
  L["Arcane"] = "Arcane"
  L["Arms"] = "Armes"
  L["Assassination"] = "Assassinat"
  L["Balance"] = "Equilibre"
  L["Beast Mastery"] = "Maîtrise des bêtes"
  L["Blood"] = "Sang"
  L["Combat"] = "Combat"
  L["Demonology"] = "Démonologie"
  L["Destruction"] = "Destruction"
  L["Discipline"] = "Discipline"
  L["ElementalShaman"] = "Elémentaire"
  L["Enhancement"] = "Amélioration"
  L["Feral Combat"] = "Combat farouche"
  L["Fire"] = "Feu"
  L["Frost"] = "Givre"
  L["Fury"] = "Fureur"
  L["Holy"] = "Sacré"
  L["Hybrid"] = "Hybride"
  L["Marksmanship"] = "Précision"
  L["Protection"] = "Protection"
  L["Restoration"] = "Restauration"
  L["Retribution"] = "Vindicte"
  L["Shadow"] = "Ombre"
  L["Subtlety"] = "Finesse"
  L["Survival"] = "Survie"
  L["Unholy"] = "Impie"

  L["Beast"] = "Bête"
  L["Critter"] = "Bestiole"
  L["Dragonkin"] = "Draconien"
  L["Gas Cloud"] = "Nuage de gaz"
  L["Humanoid"] = "Humanoïde"
  L["Mechanical"] = "Mécanique"
  L["Non-combat Pet"] = "Familier pacifique"
  L["Not specified"] = "Non spécifié"
  L["Totem"] = "Totem"
  L["Undead"] = "Mort-vivant"

  L["Wolf"] = "Loup"
  L["Cat"] = "Félin"
  L["Spider"] = "Araignée"
  L["Bear"] = "Ours"
  L["Boar"] = "Sanglier"
  L["Crocolisk"] = "Crocilisque"
  L["Carrion Bird"] = "Charognard"
  L["Crab"] = "Crabe"
  L["Gorilla"] = "Gorille"
  L["Raptor"] = "Raptor"
  L["Tallstrider"] = "Haut-trotteur"
  L["Felhunter"] = "Chasseur corrompu"
  L["Voidwalker"] = "Marcheur du Vide"
  L["Succubus"] = "Succube"
  L["Doomguard"] = "Garde funeste"
  L["Turtle"] = "Tortue"
  L["Imp"] = "Diablotin"
  L["Bat"] = "Chauve-souris"
  L["Hyena"] = "Hyène"
  L["Bird of Prey"] = "Oiseau de proie"
  L["Wind Serpent"] = "Serpent des vents"
  L["Remote Control"] = "Télécommande"
  L["Felguard"] = "Gangregarde"
  L["Dragonhawk"] = "Faucon-dragon"
  L["Warp Stalker"] = "Traqueur dim."
  L["Sporebat"] = "Sporoptère"
  L["Nether Ray"] = "Raie du Néant"
  L["Serpent"] = "Serpent"
  L["Moth"] = "Phalène"
  L["Chimaera"] = "Chimère"
  L["Devilsaur"] = "Diablosaure"
  L["Ghoul"] = "Goule"
  L["Worm"] = "Ver"
  L["Rhino"] = "Rhinocéros"
  L["Wasp"] = "Guêpe"
  L["Core Hound"] = "Chien du Magma"
  L["Spirit Beast"] = "Esprit de bête"
  L["Incubus"] = "Incube"

  L["SHORTDATE_EU"] = "%1$d/%2$d/%3$02d"
  L["D_SECONDS"] = "%d |4seconde:secondes;"
  L["SECONDS_ABBR"] = "%d s"
  L["SECOND_ONELETTER_ABBR"] = "%d s"
  L["D_MINUTES"] = "%d |4minute:minutes;"
  L["MINUTES_ABBR"] = "%d |4min:min;"
  L["MINUTE_ONELETTER_ABBR"] = "%d m"
  L["D_HOURS"] = "%d |4heure:heures;"
  L["HOURS_ABBR"] = "%d |4h:h;"
  L["HOUR_ONELETTER_ABBR"] = "%d h"
  L["D_DAYS"] = "%d |4jour:jours;"
  L["DAYS_ABBR"] = "%d |4jour:jours;"
  L["DAY_ONELETTER_ABBR"] = "%d j"
  L["LESS_THAN_OPERAND"] = "< %s"
  L["TIME_UNIT_DELIMITER"] = " "
  L["HOURS_MINUTES_SECONDS"] = "%.2d:%.2d:%.2d"
  L["MINUTES_SECONDS"] = "%.2d:%.2d"
  L["SHORTDATE"] = "%1$02d/%2$d/%3$02d"
  L["SHORTDATENOYEAR"] = "%1$d/%2$02d"
  L["SHORTDATENOYEAR_EU"] = "%1$d/%2$d"
  L["DECIMAL_SEPERATOR"] = ","
  L["SECOND_NUMBER_CAP"] = " m"
  L["FIRST_NUMBER_CAP"] = " k"
  L["FIRST_NUMBER_CAP_NO_SPACE"] = " k"
  L["FOURTH_NUMBER_CAP_NO_SPACE"] = " T"
  L["SECOND_NUMBER_CAP_NO_SPACE"] = " M"
  L["THIRD_NUMBER_CAP_NO_SPACE"] = " G"

  if WeakAuras.IsWrath() then
    L["Vault of Archavon"] = "Vault of Archavon"
    L["Archavon the Stone Watcher"] = "Archavon the Stone Watcher"
    L["Emalon the Storm Watcher"] = "Emalon the Storm Watcher"
    L["Koralon the Flame Watcher"] = "Koralon the Flame Watcher"
    L["Toravon the Ice Watcher"] = "Toravon the Ice Watcher"
    L["Naxxramas"] = "Naxxramas"
    L["Anub'Rekhan"] = "Anub'Rekhan"
    L["Grand Widow Faerlina"] = "Grand Widow Faerlina"
    L["Maexxna"] = "Maexxna"
    L["Noth the Plaguebringer"] = "Noth le Porte-peste"
    L["Heigan the Unclean"] = "Heigan the Unclean"
    L["Loatheb"] = "Loatheb"
    L["Instructor Razuvious"] = "Instructor Razuvious"
    L["Gothik the Harvester"] = "Gothik the Harvester"
    L["The Four Horsemen"] = "The Four Horsemen"
    L["Patchwerk"] = "Patchwerk"
    L["Grobbulus"] = "Grobbulus"
    L["Gluth"] = "Gluth"
    L["Thaddius"] = "Thaddius"
    L["Sapphiron"] = "Sapphiron"
    L["Kel'Thuzad"] = "Kel'Thuzad"
    L["The Obsidian Sanctum"] = "The Obsidian Sanctum"
    L["Tenebron"] = "Tenebron"
    L["Shadron"] = "Shadron"
    L["Vesperon"] = "Vesperon"
    L["Sartharion"] = "Sartharion"
    L["The Eye of Eternity"] = "The Eye of Eternity"
    L["Malygos"] = "Malygos"
    L["Ulduar"] = "Ulduar"
    L["Flame Leviathan"] = "Flame Leviathan"
    L["Ignis the Furnace Master"] = "Ignis the Furnace Master"
    L["Razorscale"] = "Razorscale"
    L["XT-002 Deconstructor"] = "XT-002 Deconstructor"
    L["Assembly of Iron"] = "Assembly of Iron"
    L["Kologarn"] = "Kologarn"
    L["Auriaya"] = "Auriaya"
    L["Freya"] = "Freya"
    L["Hodir"] = "Hodir"
    L["Mimiron"] = "Mimiron"
    L["Thorim"] = "Thorim"
    L["General Vezax"] = "General Vezax"
    L["Yogg-Saron"] = "Yogg-Saron"
    L["Algalon the Observer"] = "Algalon the Observer"
    L["Trial of the Crusader"] = "Trial of the Crusader"
    L["Northrend Beasts"] = "Northrend Beasts"
    L["Lord Jaraxxus"] = "Lord Jaraxxus"
    L["Faction Champions"] = "Faction Champions"
    L["Val'kyr Twins"] = "Val'kyr Twins"
    L["Anub'arak"] = "Anub'arak"
    L["Onyxia's Lair"] = "Repaire d'Onyxia"
    L["Onyxia"] = "Onyxia"
    L["Icecrown Citadel"] = "Icecrown Citadel"
    L["Lord Marrowgar"] = "Lord Marrowgar"
    L["Lady Deathwhisper"] = "Lady Deathwhisper"
    L["Gunship Battle"] = "Gunship Battle"
    L["Deathbringer Saurfang"] = "Deathbringer Saurfang"
    L["Festergut"] = "Festergut"
    L["Rotface"] = "Rotface"
    L["Professor Putricide"] = "Professor Putricide"
    L["Blood Prince Council"] = "Blood Prince Council"
    L["Blood-Queen Lana'thel"] = "Blood-Queen Lana'thel"
    L["Valithria Dreamwalker"] = "Valithria Dreamwalker"
    L["Sindragosa"] = "Sindragosa"
    L["The Lich King"] = "The Lich King"
    L["The Ruby Sanctum"] = "The Ruby Sanctum"
    L["Baltharus the Warborn"] = "Baltharus the Warborn"
    L["General Zarithrian"] = "General Zarithrian"
    L["Saviana Ragefire"] = "Saviana Ragefire"
    L["Halion"] = "Halion"

  elseif WeakAuras.IsTBC() then
    L["Karazhan"] = "Karazhan"
    L["Attumen the Huntsman"] = "Attumen the Huntsman"
    L["Moroes"] = "Moroes"
    L["Maiden of Virtue"] = "Maiden of Virtue"
    L["Opera Hall"] = "Opera Hall"
    L["The Curator"] = "The Curator"
    L["Terestian Illhoof"] = "Terestian Illhoof"
    L["Shade of Aran"] = "Shade of Aran"
    L["Netherspite"] = "Netherspite"
    L["Chess Event"] = "Événement d'échecs"
    L["Prince Malchezaar"] = "Prince Malchezaar"
    L["Nightbane"] = "Plaie-de-nuit"
    L["Gruul's Lair"] = "Gruul's Lair"
    L["High King Maulgar"] = "High King Maulgar"
    L["Gruul the Dragonkiller"] = "Gruul the Dragonkiller"
    L["Magtheridon's Lair"] = "Magtheridon's Lair"
    L["Magtheridon"] = "Magtheridon"
    L["Coilfang: Serpentshrine Cavern"] = "Coilfang: Serpentshrine Cavern"
    L["Hydross the Unstable"] = "Hydross the Unstable"
    L["The Lurker Below"] = "The Lurker Below"
    L["Leotheras the Blind"] = "Leotheras the Blind"
    L["Fathom-Lord Karathress"] = "Fathom-Lord Karathress"
    L["Morogrim Tidewalker"] = "Morogrim Marcheur-des-flots"
    L["Lady Vashj"] = "Lady Vashj"
    L["Tempest Keep"] = "Tempest Keep"
    L["Al'ar"] = "Al'ar"
    L["Void Reaver"] = "Void Reaver"
    L["High Astromancer Solarian"] = "High Astromancer Solarian"
    L["Kael'thas Sunstrider"] = "Kael'thas Sunstrider"
    L["The Battle for Mount Hyjal"] = "The Battle for Mount Hyjal"
    L["Rage Winterchill"] = "Rage Winterchill"
    L["Anetheron"] = "Anetheron"
    L["Kaz'rogal"] = "Kaz'rogal"
    L["Azgalor"] = "Azgalor"
    L["Archimonde"] = "Archimonde"
    L["Black Temple"] = "Black Temple"
    L["High Warlord Naj'entus"] = "High Warlord Naj'entus"
    L["Supremus"] = "Supremus"
    L["Shade of Akama"] = "Shade of Akama"
    L["Teron Gorefiend"] = "Teron Gorefiend"
    L["Gurtogg Bloodboil"] = "Gurtogg Bloodboil"
    L["Reliquary of Souls"] = "Reliquary of Souls"
    L["Mother Shahraz"] = "Mère Shahraz"
    L["The Illidari Council"] = "The Illidari Council"
    L["Illidan Stormrage"] = "Illidan Hurlorage"
    L["Zul'Aman"] = "Zul'Aman"
    L["Akil'zon"] = "Akil'zon"
    L["Nalorakk"] = "Nalorakk"
    L["Jan'alai"] = "Jan'alai"
    L["Halazzi"] = "Halazzi"
    L["Hex Lord Malacrass"] = "Hex Lord Malacrass"
    L["Daakara"] = "Daakara"
    L["The Sunwell Plateau"] = "The Sunwell Plateau"
    L["Kalecgos"] = "Kalecgos"
    L["Brutallus"] = "Brutallus"
    L["Felmyst"] = "Felmyst"
    L["Eredar Twins"] = "Eredar Twins"
    L["M'uru"] = "M'uru"
    L["Kil'jaeden"] = "Kil'jaeden"
  end

elseif (locale == "itIT") then
  L["|cFFFF0000Encounter Trigger requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000Il trigger dell’incontro richiede che Deadly Boss Mods (DBM) sia installato e aggiornato.|r"
  L["|cFFFF0000Encounter load options requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000Le opzioni di caricamento dell’incontro richiedono che Deadly Boss Mods (DBM) sia installato e aggiornato.|r"
  L["Requires Deadly Boss Mods (DBM) to detect encounters."] = "Richiede Deadly Boss Mods (DBM) per rilevare gli incontri."
  L["Based on "] = "Basato su "
  --[[Translation missing --]]
  L["Requires syncing the specialization via LibGroupTalents."] = "Requires syncing the specialization via LibGroupTalents."
  L["AddOn: APIDocumentation is %s."] = "AddOn: APIDocumentation is %s."
  L["Please install it."] = "Please install it."
  L["Please enable it in your AddOn list."] = "Please enable it in your AddOn list."
  L["AddOn: APIDocumentation is not loaded correctly."] = "AddOn: APIDocumentation is not loaded correctly."

  --[[Translation missing --]]
  L["Requires syncing the specialization via LibGroupTalents."] = "Requires syncing the specialization via LibGroupTalents."
  L["Affliction"] = "Affliction"
  L["Arcane"] = "Arcane"
  L["Arms"] = "Arms"
  L["Assassination"] = "Assassination"
  L["Balance"] = "Balance"
  L["Beast Mastery"] = "Beast Mastery"
  L["Blood"] = "Blood"
  L["Combat"] = "Combat"
  L["Demonology"] = "Demonology"
  L["Destruction"] = "Destruction"
  L["Discipline"] = "Discipline"
  L["ElementalShaman"] = "Elemental"
  L["Enhancement"] = "Enhancement"
  L["Feral Combat"] = "Feral Combat"
  L["Fire"] = "Fire"
  L["Frost"] = "Frost"
  L["Fury"] = "Fury"
  L["Holy"] = "Holy"
  L["Hybrid"] = "Hybrid"
  L["Marksmanship"] = "Marksmanship"
  L["Protection"] = "Protection"
  L["Restoration"] = "Restoration"
  L["Retribution"] = "Retribution"
  L["Shadow"] = "Shadow"
  L["Subtlety"] = "Subtlety"
  L["Survival"] = "Survival"
  L["Unholy"] = "Unholy"

  --[[Translation missing --]]
  L["Beast"] = "Beast"
  L["Critter"] = "Critter"
  L["Dragonkin"] = "Dragonkin"
  L["Gas Cloud"] = "Gas Cloud"
  L["Humanoid"] = "Humanoid"
  L["Mechanical"] = "Mechanical"
  L["Non-combat Pet"] = "Non-combat Pet"
  L["Not specified"] = "Not specified"
  L["Totem"] = "Totem"
  L["Undead"] = "Undead"

  --[[Translation missing --]]
  L["Wolf"] = "Wolf"
  L["Cat"] = "Cat"
  L["Spider"] = "Spider"
  L["Bear"] = "Bear"
  L["Boar"] = "Boar"
  L["Crocolisk"] = "Crocolisk"
  L["Carrion Bird"] = "Carrion Bird"
  L["Crab"] = "Crab"
  L["Gorilla"] = "Gorilla"
  L["Raptor"] = "Raptor"
  L["Tallstrider"] = "Tallstrider"
  L["Felhunter"] = "Felhunter"
  L["Voidwalker"] = "Voidwalker"
  L["Succubus"] = "Succubus"
  L["Doomguard"] = "Doomguard"
  L["Turtle"] = "Turtle"
  L["Imp"] = "Imp"
  L["Bat"] = "Bat"
  L["Hyena"] = "Hyena"
  L["Bird of Prey"] = "Bird of Prey"
  L["Wind Serpent"] = "Wind Serpent"
  L["Remote Control"] = "Remote Control"
  L["Felguard"] = "Felguard"
  L["Dragonhawk"] = "Dragonhawk"
  L["Warp Stalker"] = "Warp Stalker"
  L["Sporebat"] = "Sporebat"
  L["Nether Ray"] = "Nether Ray"
  L["Serpent"] = "Serpent"
  L["Moth"] = "Moth"
  L["Chimaera"] = "Chimaera"
  L["Devilsaur"] = "Devilsaur"
  L["Ghoul"] = "Ghoul"
  L["Worm"] = "Worm"
  L["Rhino"] = "Rhino"
  L["Wasp"] = "Wasp"
  L["Core Hound"] = "Core Hound"
  L["Spirit Beast"] = "Spirit Beast"
  L["Incubus"] = "Incubus"

  L["SHORTDATE_EU"] = "%1$02d/%2$02d/%3$02d"
  L["D_SECONDS"] = "%d s"
  L["SECONDS_ABBR"] = "%d s"
  L["SECOND_ONELETTER_ABBR"] = "%d s"
  L["D_MINUTES"] = "%d |4minuto:minuti;"
  L["MINUTES_ABBR"] = "%d |4min:min;"
  L["MINUTE_ONELETTER_ABBR"] = "%d m"
  L["D_HOURS"] = "%d |4ora:ore;"
  L["HOURS_ABBR"] = "%d |4ora:ore;"
  L["HOUR_ONELETTER_ABBR"] = "%d o"
  L["D_DAYS"] = "%d |4giorno:giorni;"
  L["DAYS_ABBR"] = "%d |4giorno:giorni;"
  L["DAY_ONELETTER_ABBR"] = "%d g"
  L["LESS_THAN_OPERAND"] = "< %s"
  L["TIME_UNIT_DELIMITER"] = " "
  L["HOURS_MINUTES_SECONDS"] = "%.2d:%.2d:%.2d"
  L["MINUTES_SECONDS"] = "%.2d:%.2d"
  L["SHORTDATE"] = "%1$02d/%2$02d/%3$02d"
  L["SHORTDATENOYEAR"] = "%1$d/%2$02d"
  L["SHORTDATENOYEAR_EU"] = "%1$d/%2$d"
  L["DECIMAL_SEPERATOR"] = ","
  L["SECOND_NUMBER_CAP"] = " M"
  L["FIRST_NUMBER_CAP"] = " K"
  L["FIRST_NUMBER_CAP_NO_SPACE"] = "K"
  L["FOURTH_NUMBER_CAP_NO_SPACE"] = "Bld"
  L["SECOND_NUMBER_CAP_NO_SPACE"] = "M"
  L["THIRD_NUMBER_CAP_NO_SPACE"] = "Mld"

  if WeakAuras.IsWrath() then
    L["Vault of Archavon"] = "Vault of Archavon"
    L["Archavon the Stone Watcher"] = "Archavon il Guardiano della Pietra"
    L["Emalon the Storm Watcher"] = "Emalon the Storm Watcher"
    L["Koralon the Flame Watcher"] = "Koralon the Flame Watcher"
    L["Toravon the Ice Watcher"] = "Toravon the Ice Watcher"
    L["Naxxramas"] = "Naxxramas"
    L["Anub'Rekhan"] = "Anub'Rekhan"
    L["Grand Widow Faerlina"] = "Grand Widow Faerlina"
    L["Maexxna"] = "Maexxna"
    L["Noth the Plaguebringer"] = "Noth the Plaguebringer"
    L["Heigan the Unclean"] = "Heigan the Unclean"
    L["Loatheb"] = "Loatheb"
    L["Instructor Razuvious"] = "Instructor Razuvious"
    L["Gothik the Harvester"] = "Gothik the Harvester"
    L["The Four Horsemen"] = "The Four Horsemen"
    L["Patchwerk"] = "Patchwerk"
    L["Grobbulus"] = "Grobbulus"
    L["Gluth"] = "Gluth"
    L["Thaddius"] = "Thaddius"
    L["Sapphiron"] = "Sapphiron"
    L["Kel'Thuzad"] = "Kel'Thuzad"
    L["The Obsidian Sanctum"] = "The Obsidian Sanctum"
    L["Tenebron"] = "Tenebron"
    L["Shadron"] = "Shadron"
    L["Vesperon"] = "Vesperon"
    L["Sartharion"] = "Sartharion"
    L["The Eye of Eternity"] = "The Eye of Eternity"
    L["Malygos"] = "Malygos"
    L["Ulduar"] = "Ulduar"
    L["Flame Leviathan"] = "Flame Leviathan"
    L["Ignis the Furnace Master"] = "Ignis the Furnace Master"
    L["Razorscale"] = "Razorscale"
    L["XT-002 Deconstructor"] = "XT-002 Deconstructor"
    L["Assembly of Iron"] = "Assemblaggio di ferro"
    L["Kologarn"] = "Kologarn"
    L["Auriaya"] = "Auriaya"
    L["Freya"] = "Freya"
    L["Hodir"] = "Hodir"
    L["Mimiron"] = "Mimiron"
    L["Thorim"] = "Thorim"
    L["General Vezax"] = "General Vezax"
    L["Yogg-Saron"] = "Yogg-Saron"
    L["Algalon the Observer"] = "Algalon l'Osservatore"
    L["Trial of the Crusader"] = "Trial of the Crusader"
    L["Northrend Beasts"] = "Northrend Beasts"
    L["Lord Jaraxxus"] = "Lord Jaraxxus"
    L["Faction Champions"] = "Faction Champions"
    L["Val'kyr Twins"] = "Val'kyr Twins"
    L["Anub'arak"] = "Anub'arak"
    L["Onyxia's Lair"] = "Onyxia's Lair"
    L["Onyxia"] = "Onyxia"
    L["Icecrown Citadel"] = "Icecrown Citadel"
    L["Lord Marrowgar"] = "Lord Marrowgar"
    L["Lady Deathwhisper"] = "Lady Deathwhisper"
    L["Gunship Battle"] = "Gunship Battle"
    L["Deathbringer Saurfang"] = "Deathbringer Saurfang"
    L["Festergut"] = "Festergut"
    L["Rotface"] = "Rotface"
    L["Professor Putricide"] = "Professor Putricide"
    L["Blood Prince Council"] = "Consiglio dei Principi del Sangue"
    L["Blood-Queen Lana'thel"] = "La Regina del Sangue Lana'thel"
    L["Valithria Dreamwalker"] = "Valithria Dreamwalker"
    L["Sindragosa"] = "Sindragosa"
    L["The Lich King"] = "The Lich King"
    L["The Ruby Sanctum"] = "The Ruby Sanctum"
    L["Baltharus the Warborn"] = "Baltharus il Guerriero"
    L["General Zarithrian"] = "General Zarithrian"
    L["Saviana Ragefire"] = "Saviana Ragefire"
    L["Halion"] = "Halion"

  elseif WeakAuras.IsTBC() then
    L["Karazhan"] = "Karazhan"
    L["Attumen the Huntsman"] = "Attumen the Huntsman"
    L["Moroes"] = "Moroes"
    L["Maiden of Virtue"] = "Maiden of Virtue"
    L["Opera Hall"] = "Opera Hall"
    L["The Curator"] = "The Curator"
    L["Terestian Illhoof"] = "Terestian Illhoof"
    L["Shade of Aran"] = "Shade of Aran"
    L["Netherspite"] = "Netherspite"
    L["Chess Event"] = "Chess Event"
    L["Prince Malchezaar"] = "Prince Malchezaar"
    L["Nightbane"] = "Nightbane"
    L["Gruul's Lair"] = "Gruul's Lair"
    L["High King Maulgar"] = "High King Maulgar"
    L["Gruul the Dragonkiller"] = "Gruul the Dragonkiller"
    L["Magtheridon's Lair"] = "Magtheridon's Lair"
    L["Magtheridon"] = "Magtheridon"
    L["Coilfang: Serpentshrine Cavern"] = "Coilfang: Serpentshrine Cavern"
    L["Hydross the Unstable"] = "Hydross the Unstable"
    L["The Lurker Below"] = "The Lurker Below"
    L["Leotheras the Blind"] = "Leotheras the Blind"
    L["Fathom-Lord Karathress"] = "Fathom-Lord Karathress"
    L["Morogrim Tidewalker"] = "Morogrim Tidewalker"
    L["Lady Vashj"] = "Lady Vashj"
    L["Tempest Keep"] = "Tempest Keep"
    L["Al'ar"] = "Al'ar"
    L["Void Reaver"] = "Void Reaver"
    L["High Astromancer Solarian"] = "High Astromancer Solarian"
    L["Kael'thas Sunstrider"] = "Kael'thas Sunstrider"
    L["The Battle for Mount Hyjal"] = "The Battle for Mount Hyjal"
    L["Rage Winterchill"] = "Rage Winterchill"
    L["Anetheron"] = "Anetheron"
    L["Kaz'rogal"] = "Kaz'rogal"
    L["Azgalor"] = "Azgalor"
    L["Archimonde"] = "Archimonde"
    L["Black Temple"] = "Black Temple"
    L["High Warlord Naj'entus"] = "High Warlord Naj'entus"
    L["Supremus"] = "Supremus"
    L["Shade of Akama"] = "Shade of Akama"
    L["Teron Gorefiend"] = "Teron Gorefiend"
    L["Gurtogg Bloodboil"] = "Gurtogg Bloodboil"
    L["Reliquary of Souls"] = "Reliquary of Souls"
    L["Mother Shahraz"] = "Mother Shahraz"
    L["The Illidari Council"] = "The Illidari Council"
    L["Illidan Stormrage"] = "Illidan Stormrage"
    L["Zul'Aman"] = "Zul'Aman"
    L["Akil'zon"] = "Akil'zon"
    L["Nalorakk"] = "Nalorakk"
    L["Jan'alai"] = "Jan'alai"
    L["Halazzi"] = "Halazzi"
    L["Hex Lord Malacrass"] = "Hex Lord Malacrass"
    L["Daakara"] = "Daakara"
    L["The Sunwell Plateau"] = "The Sunwell Plateau"
    L["Kalecgos"] = "Kalecgos"
    L["Brutallus"] = "Brutallus"
    L["Felmyst"] = "Felmyst"
    L["Eredar Twins"] = "Eredar Twins"
    L["M'uru"] = "M'uru"
    L["Kil'jaeden"] = "Kil'jaeden"
  end

elseif (locale == "koKR") then
  L["|cFFFF0000Encounter Trigger requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000보스전 트리거를 사용하려면 Deadly Boss Mods (DBM)이 설치되어 최신 상태여야 합니다.|r"
  L["|cFFFF0000Encounter load options requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000보스전 로드 옵션을 사용하려면 Deadly Boss Mods (DBM)이 설치되어 최신 상태여야 합니다.|r"
  L["Requires Deadly Boss Mods (DBM) to detect encounters."] = "보스전을 감지하려면 Deadly Boss Mods (DBM)이 필요합니다."
  L["Based on "] = "기반 "
  L["AddOn: APIDocumentation is %s."] = "애드온: APIDocumentation이(가) %s입니다."
  L["Please install it."] = "설치해 주십시오."
  L["Please enable it in your AddOn list."] = "애드온 목록에서 활성화해 주십시오."
  L["AddOn: APIDocumentation is not loaded correctly."] = "애드온: APIDocumentation이(가) 제대로 로드되지 않았습니다."

  L["Requires syncing the specialization via LibGroupTalents."] = "LibGroupTalents을 통해 전문화를 동기화해야 합니다."
  L["Affliction"] = "고통"
  L["Arcane"] = "비전"
  L["Arms"] = "무기"
  L["Assassination"] = "암살"
  L["Balance"] = "조화"
  L["Beast Mastery"] = "야수"
  L["Blood"] = "혈기"
  L["Combat"] = "전투"
  L["Demonology"] = "악마"
  L["Destruction"] = "파괴"
  L["Discipline"] = "수양"
  L["ElementalShaman"] = "정기"
  L["Enhancement"] = "고양"
  L["Feral Combat"] = "야성"
  L["Fire"] = "화염"
  L["Frost"] = "냉기"
  L["Fury"] = "분노"
  L["Holy"] = "신성"
  L["Hybrid"] = "하이브리드"
  L["Marksmanship"] = "사격"
  L["Protection"] = "방어"
  L["Restoration"] = "복원"
  L["Retribution"] = "징벌"
  L["Shadow"] = "암흑"
  L["Subtlety"] = "잠행"
  L["Survival"] = "생존"
  L["Unholy"] = "부정"

  L["Beast"] = "야수"
  L["Critter"] = "동물"
  L["Dragonkin"] = "용족"
  L["Gas Cloud"] = "가스"
  L["Humanoid"] = "인간형"
  L["Mechanical"] = "기계"
  L["Non-combat Pet"] = "애완동물"
  L["Not specified"] = "기타"
  L["Totem"] = "토템"
  L["Undead"] = "언데드"

  L["Wolf"] = "늑대"
  L["Cat"] = "살쾡이"
  L["Spider"] = "거미"
  L["Bear"] = "곰"
  L["Boar"] = "멧돼지"
  L["Crocolisk"] = "악어"
  L["Carrion Bird"] = "독수리"
  L["Crab"] = "게"
  L["Gorilla"] = "고릴라"
  L["Raptor"] = "랩터"
  L["Tallstrider"] = "타조"
  L["Felhunter"] = "지옥사냥개"
  L["Voidwalker"] = "보이드워커"
  L["Succubus"] = "서큐버스"
  L["Doomguard"] = "파멸의 수호병"
  L["Turtle"] = "거북"
  L["Imp"] = "임프"
  L["Bat"] = "박쥐"
  L["Hyena"] = "하이에나"
  L["Bird of Prey"] = "맹금"
  L["Wind Serpent"] = "천둥매"
  L["Remote Control"] = "무선조종 장난감"
  L["Felguard"] = "지옥수호병"
  L["Dragonhawk"] = "용매"
  L["Warp Stalker"] = "차원의 추적자"
  L["Sporebat"] = "포자날개"
  L["Nether Ray"] = "황천의 가오리"
  L["Serpent"] = "뱀"
  L["Moth"] = "나방"
  L["Chimaera"] = "키메라"
  L["Devilsaur"] = "데빌사우루스"
  L["Ghoul"] = "구울"
  L["Worm"] = "벌레"
  L["Rhino"] = "코뿔소"
  L["Wasp"] = "말벌"
  L["Core Hound"] = "심장부 사냥개"
  L["Spirit Beast"] = "야수 정령"
  L["Incubus"] = "인큐버스"

  L["SHORTDATE_EU"] = "%1$d/%2$d/%3$02d"
  L["D_SECONDS"] = "%d초"
  L["SECONDS_ABBR"] = "%d초"
  L["SECOND_ONELETTER_ABBR"] = "%d초"
  L["D_MINUTES"] = "%d분"
  L["MINUTES_ABBR"] = "%d분"
  L["MINUTE_ONELETTER_ABBR"] = "%d분"
  L["D_HOURS"] = "%d시간"
  L["HOURS_ABBR"] = "%d시간"
  L["HOUR_ONELETTER_ABBR"] = "%d시간"
  L["D_DAYS"] = "%d일"
  L["DAYS_ABBR"] = "%d일"
  L["DAY_ONELETTER_ABBR"] = "%d일"
  L["LESS_THAN_OPERAND"] = "< %s"
  L["TIME_UNIT_DELIMITER"] = " "
  L["HOURS_MINUTES_SECONDS"] = "%.2d:%.2d:%.2d"
  L["MINUTES_SECONDS"] = "%.2d:%.2d"
  L["SHORTDATE"] = "%3$02d/%2$d/%1$02d"
  L["SHORTDATENOYEAR"] = "%2$d/%1$02d"
  L["SHORTDATENOYEAR_EU"] = "%1$d/%2$d"
  L["DECIMAL_SEPERATOR"] = "."
  L["SECOND_NUMBER_CAP"] = "억"
  L["FIRST_NUMBER_CAP"] = "만"
  L["FIRST_NUMBER_CAP_NO_SPACE"] = "만"
  L["FOURTH_NUMBER_CAP_NO_SPACE"] = "경"
  L["SECOND_NUMBER_CAP_NO_SPACE"] = "억"
  L["THIRD_NUMBER_CAP_NO_SPACE"] = "조"

  if WeakAuras.IsWrath() then
    L["Vault of Archavon"] = "아카본 석실"
    L["Archavon the Stone Watcher"] = "바위 감시자 아카본"
    L["Emalon the Storm Watcher"] = "폭풍 감시자 에말론"
    L["Koralon the Flame Watcher"] = "화염 감시자 코랄론"
    L["Toravon the Ice Watcher"] = "얼음 감시자 토라본"
    L["Naxxramas"] = "낙스라마스"
    L["Anub'Rekhan"] = "아눕레칸"
    L["Grand Widow Faerlina"] = "귀부인 팰리나"
    L["Maexxna"] = "맥스나"
    L["Noth the Plaguebringer"] = "역병술사 노스"
    L["Heigan the Unclean"] = "부정의 헤이건"
    L["Loatheb"] = "로데브"
    L["Instructor Razuvious"] = "훈련교관 라주비어스"
    L["Gothik the Harvester"] = "영혼의 착취자 고딕"
    L["The Four Horsemen"] = "4기사단"
    L["Patchwerk"] = "패치워크"
    L["Grobbulus"] = "그라불루스"
    L["Gluth"] = "글루스"
    L["Thaddius"] = "타디우스"
    L["Sapphiron"] = "사피론"
    L["Kel'Thuzad"] = "켈투자드"
    L["The Obsidian Sanctum"] = "흑요석 성소"
    L["Tenebron"] = "테네브론"
    L["Shadron"] = "샤드론"
    L["Vesperon"] = "베스페론"
    L["Sartharion"] = "살타리온"
    L["The Eye of Eternity"] = "영원의 눈"
    L["Malygos"] = "말리고스"
    L["Ulduar"] = "울두아르"
    L["Flame Leviathan"] = "거대 화염전차"
    L["Ignis the Furnace Master"] = "용광로 군주 이그니스"
    L["Razorscale"] = "칼날비늘"
    L["XT-002 Deconstructor"] = "XT-002 해체자"
    L["Assembly of Iron"] = "무쇠 평의회"
    L["Kologarn"] = "콜로간"
    L["Auriaya"] = "아우리아야"
    L["Freya"] = "프레이야"
    L["Hodir"] = "호디르"
    L["Mimiron"] = "미미론"
    L["Thorim"] = "토림"
    L["General Vezax"] = "장군 베작스"
    L["Yogg-Saron"] = "요그사론"
    L["Algalon the Observer"] = "관찰자 알갈론"
    L["Trial of the Crusader"] = "십자군의 시험장"
    L["Northrend Beasts"] = "노스렌드의 야수"
    L["Lord Jaraxxus"] = "군주 자락서스"
    L["Faction Champions"] = "진영 용사"
    L["Val'kyr Twins"] = "발키르 쌍둥이"
    L["Anub'arak"] = "아눕아락"
    L["Onyxia's Lair"] = "오닉시아의 둥지"
    L["Onyxia"] = "오닉시아"
    L["Icecrown Citadel"] = "얼음왕관 성채"
    L["Lord Marrowgar"] = "군주 매로우가르"
    L["Lady Deathwhisper"] = "여교주 데스위스퍼"
    L["Gunship Battle"] = "비행포격선 전투"
    L["Deathbringer Saurfang"] = "죽음의 인도자 사울팽"
    L["Festergut"] = "구린속"
    L["Rotface"] = "썩은얼굴"
    L["Professor Putricide"] = "교수 퓨트리사이드"
    L["Blood Prince Council"] = "피의 의회"
    L["Blood-Queen Lana'thel"] = "피의 여왕 라나텔"
    L["Valithria Dreamwalker"] = "발리스리아 드림워커"
    L["Sindragosa"] = "신드라고사"
    L["The Lich King"] = "리치 왕"
    L["The Ruby Sanctum"] = "루비 성소"
    L["Baltharus the Warborn"] = "전쟁의 아들 발타루스"
    L["General Zarithrian"] = "장군 자리스리안"
    L["Saviana Ragefire"] = "사비아나 레이지파이어"
    L["Halion"] = "할리온"

  elseif WeakAuras.IsTBC() then
    L["Karazhan"] = "카라잔"
    L["Attumen the Huntsman"] = "사냥꾼 어튜멘"
    L["Moroes"] = "모로스"
    L["Maiden of Virtue"] = "고결의 여신"
    L["Opera Hall"] = "오페라 극장"
    L["The Curator"] = "전시 관리인"
    L["Terestian Illhoof"] = "테레스티안 일후프"
    L["Shade of Aran"] = "아란의 망령"
    L["Netherspite"] = "황천의 원령"
    L["Chess Event"] = "체스 이벤트"
    L["Prince Malchezaar"] = "공작 말체자르"
    L["Nightbane"] = "파멸의 어둠"
    L["Gruul's Lair"] = "그룰의 둥지"
    L["High King Maulgar"] = "왕중왕 마울가르"
    L["Gruul the Dragonkiller"] = "용 학살자 그룰"
    L["Magtheridon's Lair"] = "마그테리돈의 둥지"
    L["Magtheridon"] = "마그테리돈"
    L["Coilfang: Serpentshrine Cavern"] = "갈퀴송곳니: 불뱀 제단"
    L["Hydross the Unstable"] = "불안정한 히드로스"
    L["The Lurker Below"] = "심연의 잠복꾼"
    L["Leotheras the Blind"] = "눈먼 레오테라스"
    L["Fathom-Lord Karathress"] = "심연의 군주 카라드레스"
    L["Morogrim Tidewalker"] = "겅둥파도 모로그림"
    L["Lady Vashj"] = "여군주 바쉬"
    L["Tempest Keep"] = "폭풍우 요새"
    L["Al'ar"] = "알라르"
    L["Void Reaver"] = "공허의 절단기"
    L["High Astromancer Solarian"] = "고위 점성술사 솔라리안"
    L["Kael'thas Sunstrider"] = "캘타스 선스트라이더"
    L["The Battle for Mount Hyjal"] = "하이잘 산 전투"
    L["Rage Winterchill"] = "격노한 윈터칠"
    L["Anetheron"] = "아네테론"
    L["Kaz'rogal"] = "카즈로갈"
    L["Azgalor"] = "아즈갈로"
    L["Archimonde"] = "아키몬드"
    L["Black Temple"] = "검은 사원"
    L["High Warlord Naj'entus"] = "대장군 나젠투스"
    L["Supremus"] = "궁극의 심연"
    L["Shade of Akama"] = "아카마의 망령"
    L["Teron Gorefiend"] = "테론 고어핀드"
    L["Gurtogg Bloodboil"] = "구르토그 블러드보일"
    L["Reliquary of Souls"] = "영혼의 성물함"
    L["Mother Shahraz"] = "대모 샤라즈"
    L["The Illidari Council"] = "일리다리 의회"
    L["Illidan Stormrage"] = "일리단 스톰레이지"
    L["Zul'Aman"] = "줄아만"
    L["Akil'zon"] = "아킬존"
    L["Nalorakk"] = "날로라크"
    L["Jan'alai"] = "잔알라이"
    L["Halazzi"] = "할라지"
    L["Hex Lord Malacrass"] = "사술 군주 말라크라스"
    L["Daakara"] = "다카라"
    L["The Sunwell Plateau"] = "태양샘 고원"
    L["Kalecgos"] = "칼렉고스"
    L["Brutallus"] = "브루탈루스"
    L["Felmyst"] = "지옥안개"
    L["Eredar Twins"] = "에레다르 쌍둥이 자매"
    L["M'uru"] = "므우루"
    L["Kil'jaeden"] = "킬제덴"
  end

elseif (locale == "ptBR") then
  L["|cFFFF0000Encounter Trigger requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000O gatilho de encontro requer que Deadly Boss Mods (DBM) esteja instalado e atualizado.|r"
  L["|cFFFF0000Encounter load options requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000As opções de carregamento do encontro requerem que Deadly Boss Mods (DBM) esteja instalado e atualizado.|r"
  L["Requires Deadly Boss Mods (DBM) to detect encounters."] = "Requer Deadly Boss Mods (DBM) para detectar encontros."
  L["Based on "] = "Baseado em "
  --[[Translation missing --]]
  L["Requires syncing the specialization via LibGroupTalents."] = "Requires syncing the specialization via LibGroupTalents."
  L["AddOn: APIDocumentation is %s."] = "AddOn: APIDocumentation is %s."
  L["Please install it."] = "Please install it."
  L["Please enable it in your AddOn list."] = "Please enable it in your AddOn list."
  L["AddOn: APIDocumentation is not loaded correctly."] = "AddOn: APIDocumentation is not loaded correctly."

  --[[Translation missing --]]
  L["Requires syncing the specialization via LibGroupTalents."] = "Requires syncing the specialization via LibGroupTalents."
  L["Affliction"] = "Affliction"
  L["Arcane"] = "Arcane"
  L["Arms"] = "Arms"
  L["Assassination"] = "Assassination"
  L["Balance"] = "Balance"
  L["Beast Mastery"] = "Beast Mastery"
  L["Blood"] = "Blood"
  L["Combat"] = "Combat"
  L["Demonology"] = "Demonology"
  L["Destruction"] = "Destruction"
  L["Discipline"] = "Discipline"
  L["ElementalShaman"] = "Elemental"
  L["Enhancement"] = "Enhancement"
  L["Feral Combat"] = "Feral Combat"
  L["Fire"] = "Fire"
  L["Frost"] = "Frost"
  L["Fury"] = "Fury"
  L["Holy"] = "Holy"
  L["Hybrid"] = "Hybrid"
  L["Marksmanship"] = "Marksmanship"
  L["Protection"] = "Protection"
  L["Restoration"] = "Restoration"
  L["Retribution"] = "Retribution"
  L["Shadow"] = "Shadow"
  L["Subtlety"] = "Subtlety"
  L["Survival"] = "Survival"
  L["Unholy"] = "Unholy"

  L["Beast"] = "Fera"
  L["Critter"] = "Bicho"
  L["Dragonkin"] = "Draconiano"
  L["Gas Cloud"] = "Nuvem de Gás"
  L["Humanoid"] = "Humanoide"
  L["Mechanical"] = "Mecânico"
  L["Non-combat Pet"] = "Mascote"
  L["Not specified"] = "Não Especificado"
  L["Totem"] = "Totem"
  L["Undead"] = "Morto-vivo"

  L["Wolf"] = "Lobo"
  L["Cat"] = "Gato"
  L["Spider"] = "Aranha"
  L["Bear"] = "Urso"
  L["Boar"] = "Javali"
  L["Crocolisk"] = "Crocolisco"
  L["Carrion Bird"] = "Ave Carniceira"
  L["Crab"] = "Caranguejo"
  L["Gorilla"] = "Gorila"
  L["Raptor"] = "Raptor"
  L["Tallstrider"] = "Moa"
  L["Felhunter"] = "Caçador Vil"
  L["Voidwalker"] = "Emissário do Caos"
  L["Succubus"] = "Súcubo"
  L["Doomguard"] = "Demonarca"
  L["Turtle"] = "Tartaruga"
  L["Imp"] = "Diabrete"
  L["Bat"] = "Morcego"
  L["Hyena"] = "Hiena"
  L["Bird of Prey"] = "Ave de Rapina"
  L["Wind Serpent"] = "Serpente Alada"
  L["Remote Control"] = "Controle Remoto"
  L["Felguard"] = "Guarda Vil"
  L["Dragonhawk"] = "Falcodrago"
  L["Warp Stalker"] = "Espreitador Dimens."
  L["Sporebat"] = "Quirósporo"
  L["Nether Ray"] = "Arraia Etérea"
  L["Serpent"] = "Serpente"
  L["Moth"] = "Mariposa"
  L["Chimaera"] = "Quimera"
  L["Devilsaur"] = "Demossauro"
  L["Ghoul"] = "Carniçal"
  L["Worm"] = "Verme"
  L["Rhino"] = "Rinoceronte"
  L["Wasp"] = "Vespa"
  L["Core Hound"] = "Cão-magma"
  L["Spirit Beast"] = "Fera Espiritual"
  L["Incubus"] = "Íncubo"

  L["SHORTDATE_EU"] = "%1$d/%2$d/%3$02d"
  L["D_SECONDS"] = "%d |4segundo:segundos;"
  L["SECONDS_ABBR"] = "%d |4s:s;"
  L["SECOND_ONELETTER_ABBR"] = "%d s"
  L["D_MINUTES"] = "%d |4minuto:minutos;"
  L["MINUTES_ABBR"] = "%d |4min:min;"
  L["MINUTE_ONELETTER_ABBR"] = "%d min"
  L["D_HOURS"] = "%d |4hora:horas;"
  L["HOURS_ABBR"] = "%d |4H:H;"
  L["HOUR_ONELETTER_ABBR"] = "%d h"
  L["D_DAYS"] = "%d |4dia:dias;"
  L["DAYS_ABBR"] = "%d |4dia:dias;"
  L["DAY_ONELETTER_ABBR"] = "%d d"
  L["LESS_THAN_OPERAND"] = "< %s"
  L["TIME_UNIT_DELIMITER"] = " "
  L["HOURS_MINUTES_SECONDS"] = "%.2d:%.2d:%.2d"
  L["MINUTES_SECONDS"] = "%.2d:%.2d"
  L["SHORTDATE"] = "%1$02d/%2$d/%3$02d"
  L["SHORTDATENOYEAR"] = "%1$02d/%2$d"
  L["SHORTDATENOYEAR_EU"] = "%1$d/%2$d"
  L["DECIMAL_SEPERATOR"] = "."
  L["SECOND_NUMBER_CAP"] = " M"
  L["FIRST_NUMBER_CAP"] = " K"
  L["FIRST_NUMBER_CAP_NO_SPACE"] = "K"
  L["FOURTH_NUMBER_CAP_NO_SPACE"] = "T"
  L["SECOND_NUMBER_CAP_NO_SPACE"] = "M"
  L["THIRD_NUMBER_CAP_NO_SPACE"] = "B"

  if WeakAuras.IsWrath() then
    L["Vault of Archavon"] = "Vault of Archavon"
    L["Archavon the Stone Watcher"] = "Archavon the Stone Watcher"
    L["Emalon the Storm Watcher"] = "Emalon the Storm Watcher"
    L["Koralon the Flame Watcher"] = "Koralon the Flame Watcher"
    L["Toravon the Ice Watcher"] = "Toravon the Ice Watcher"
    L["Naxxramas"] = "Naxxramas"
    L["Anub'Rekhan"] = "Anub'Rekhan"
    L["Grand Widow Faerlina"] = "Grand Widow Faerlina"
    L["Maexxna"] = "Maexxna"
    L["Noth the Plaguebringer"] = "Noth the Plaguebringer"
    L["Heigan the Unclean"] = "Heigan the Unclean"
    L["Loatheb"] = "Loatheb"
    L["Instructor Razuvious"] = "Instructor Razuvious"
    L["Gothik the Harvester"] = "Gothik the Harvester"
    L["The Four Horsemen"] = "The Four Horsemen"
    L["Patchwerk"] = "Patchwerk"
    L["Grobbulus"] = "Grobbulus"
    L["Gluth"] = "Gluth"
    L["Thaddius"] = "Thaddius"
    L["Sapphiron"] = "Sapphiron"
    L["Kel'Thuzad"] = "Kel'Thuzad"
    L["The Obsidian Sanctum"] = "The Obsidian Sanctum"
    L["Tenebron"] = "Tenebron"
    L["Shadron"] = "Shadron"
    L["Vesperon"] = "Vesperon"
    L["Sartharion"] = "Sartharion"
    L["The Eye of Eternity"] = "The Eye of Eternity"
    L["Malygos"] = "Malygos"
    L["Ulduar"] = "Ulduar"
    L["Flame Leviathan"] = "Flame Leviathan"
    L["Ignis the Furnace Master"] = "Ignis the Furnace Master"
    L["Razorscale"] = "Razorscale"
    L["XT-002 Deconstructor"] = "XT-002 Deconstructor"
    L["Assembly of Iron"] = "Assembly of Iron"
    L["Kologarn"] = "Kologarn"
    L["Auriaya"] = "Auriaya"
    L["Freya"] = "Freya"
    L["Hodir"] = "Hodir"
    L["Mimiron"] = "Mimiron"
    L["Thorim"] = "Thorim"
    L["General Vezax"] = "General Vezax"
    L["Yogg-Saron"] = "Yogg-Saron"
    L["Algalon the Observer"] = "Algalon the Observer"
    L["Trial of the Crusader"] = "Trial of the Crusader"
    L["Northrend Beasts"] = "Northrend Beasts"
    L["Lord Jaraxxus"] = "Lord Jaraxxus"
    L["Faction Champions"] = "Faction Champions"
    L["Val'kyr Twins"] = "Val'kyr Twins"
    L["Anub'arak"] = "Anub'arak"
    L["Onyxia's Lair"] = "Onyxia's Lair"
    L["Onyxia"] = "Onyxia"
    L["Icecrown Citadel"] = "Icecrown Citadel"
    L["Lord Marrowgar"] = "Lord Marrowgar"
    L["Lady Deathwhisper"] = "Lady Deathwhisper"
    L["Gunship Battle"] = "Gunship Battle"
    L["Deathbringer Saurfang"] = "Deathbringer Saurfang"
    L["Festergut"] = "Festergut"
    L["Rotface"] = "Rotface"
    L["Professor Putricide"] = "Professor Putricide"
    L["Blood Prince Council"] = "Blood Prince Council"
    L["Blood-Queen Lana'thel"] = "Blood-Queen Lana'thel"
    L["Valithria Dreamwalker"] = "Valithria Dreamwalker"
    L["Sindragosa"] = "Sindragosa"
    L["The Lich King"] = "The Lich King"
    L["The Ruby Sanctum"] = "The Ruby Sanctum"
    L["Baltharus the Warborn"] = "Baltharus the Warborn"
    L["General Zarithrian"] = "General Zarithrian"
    L["Saviana Ragefire"] = "Saviana Ragefire"
    L["Halion"] = "Halion"

  elseif WeakAuras.IsTBC() then
    L["Karazhan"] = "Karazhan"
    L["Attumen the Huntsman"] = "Attumen the Huntsman"
    L["Moroes"] = "Moroes"
    L["Maiden of Virtue"] = "Maiden of Virtue"
    L["Opera Hall"] = "Opera Hall"
    L["The Curator"] = "The Curator"
    L["Terestian Illhoof"] = "Terestian Illhoof"
    L["Shade of Aran"] = "Shade of Aran"
    L["Netherspite"] = "Netherspite"
    L["Chess Event"] = "Chess Event"
    L["Prince Malchezaar"] = "Prince Malchezaar"
    L["Nightbane"] = "Nightbane"
    L["Gruul's Lair"] = "Gruul's Lair"
    L["High King Maulgar"] = "High King Maulgar"
    L["Gruul the Dragonkiller"] = "Gruul the Dragonkiller"
    L["Magtheridon's Lair"] = "Magtheridon's Lair"
    L["Magtheridon"] = "Magtheridon"
    L["Coilfang: Serpentshrine Cavern"] = "Coilfang: Serpentshrine Cavern"
    L["Hydross the Unstable"] = "Hydross the Unstable"
    L["The Lurker Below"] = "The Lurker Below"
    L["Leotheras the Blind"] = "Leotheras the Blind"
    L["Fathom-Lord Karathress"] = "Fathom-Lord Karathress"
    L["Morogrim Tidewalker"] = "Morogrim Tidewalker"
    L["Lady Vashj"] = "Lady Vashj"
    L["Tempest Keep"] = "Tempest Keep"
    L["Al'ar"] = "Al'ar"
    L["Void Reaver"] = "Void Reaver"
    L["High Astromancer Solarian"] = "High Astromancer Solarian"
    L["Kael'thas Sunstrider"] = "Kael'thas Sunstrider"
    L["The Battle for Mount Hyjal"] = "The Battle for Mount Hyjal"
    L["Rage Winterchill"] = "Rage Winterchill"
    L["Anetheron"] = "Anetheron"
    L["Kaz'rogal"] = "Kaz'rogal"
    L["Azgalor"] = "Azgalor"
    L["Archimonde"] = "Archimonde"
    L["Black Temple"] = "Black Temple"
    L["High Warlord Naj'entus"] = "High Warlord Naj'entus"
    L["Supremus"] = "Supremus"
    L["Shade of Akama"] = "Shade of Akama"
    L["Teron Gorefiend"] = "Teron Gorefiend"
    L["Gurtogg Bloodboil"] = "Gurtogg Bloodboil"
    L["Reliquary of Souls"] = "Reliquary of Souls"
    L["Mother Shahraz"] = "Mother Shahraz"
    L["The Illidari Council"] = "The Illidari Council"
    L["Illidan Stormrage"] = "Illidan Stormrage"
    L["Zul'Aman"] = "Zul'Aman"
    L["Akil'zon"] = "Akil'zon"
    L["Nalorakk"] = "Nalorakk"
    L["Jan'alai"] = "Jan'alai"
    L["Halazzi"] = "Halazzi"
    L["Hex Lord Malacrass"] = "Hex Lord Malacrass"
    L["Daakara"] = "Daakara"
    L["The Sunwell Plateau"] = "The Sunwell Plateau"
    L["Kalecgos"] = "Kalecgos"
    L["Brutallus"] = "Brutallus"
    L["Felmyst"] = "Felmyst"
    L["Eredar Twins"] = "Eredar Twins"
    L["M'uru"] = "M'uru"
    L["Kil'jaeden"] = "Kil'jaeden"
  end

elseif (locale == "ruRU") then
  L["|cFFFF0000Encounter Trigger requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000Триггер сражения с боссом требует, чтобы Deadly Boss Mods (DBM) был установлен и обновлён.|r"
  L["|cFFFF0000Encounter load options requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000Параметры загрузки сражения с боссом требуют, чтобы Deadly Boss Mods (DBM) был установлен и обновлён.|r"
  L["Requires Deadly Boss Mods (DBM) to detect encounters."] = "Для обнаружения сражений с боссами требуется Deadly Boss Mods (DBM)."
  L["Based on "] = "Основано на "
  L["AddOn: APIDocumentation is %s."] = "Аддон: APIDocumentation %s."
  L["Please install it."] = "Пожалуйста, установите его."
  L["Please enable it in your AddOn list."] = "Пожалуйста, включите его в вашем списке аддонов."
  L["AddOn: APIDocumentation is not loaded correctly."] = "Аддон: APIDocumentation загружен некорректно."

  L["Requires syncing the specialization via LibGroupTalents."] = "Требуется синхронизация специализации через LibGroupTalents."
  L["Affliction"] = "Колдовство"
  L["Arcane"] = "Тайная магия"
  L["Arms"] = "Оружие"
  L["Assassination"] = "Ликвидация"
  L["Balance"] = "Баланс"
  L["Beast Mastery"] = "Повелитель зверей"
  L["Blood"] = "Кровь"
  L["Combat"] = "Бой"
  L["Demonology"] = "Демонология"
  L["Destruction"] = "Разрушение"
  L["Discipline"] = "Послушание"
  L["ElementalShaman"] = "Стихии"
  L["Enhancement"] = "Совершенствование"
  L["Feral Combat"] = "Сила зверя"
  L["Fire"] = "Огонь"
  L["Frost"] = "Лед"
  L["Fury"] = "Неистовство"
  L["Holy"] = "Свет"
  L["Hybrid"] = "Гибрид"
  L["Marksmanship"] = "Стрельба"
  L["Protection"] = "Защита"
  L["Restoration"] = "Исцеление"
  L["Retribution"] = "Воздаяние"
  L["Shadow"] = "Тьма"
  L["Subtlety"] = "Скрытность"
  L["Survival"] = "Выживание"
  L["Unholy"] = "Нечестивость"

  L["Beast"] = "Животное"
  L["Critter"] = "Существо"
  L["Dragonkin"] = "Дракон"
  L["Gas Cloud"] = "Газовое облако"
  L["Humanoid"] = "Гуманоид"
  L["Mechanical"] = "Механизм"
  L["Non-combat Pet"] = "Спутник"
  L["Not specified"] = "Не указано"
  L["Totem"] = "Тотем"
  L["Undead"] = "Нежить"

  L["Wolf"] = "Волк"
  L["Cat"] = "Кошка"
  L["Spider"] = "Паук"
  L["Bear"] = "Медведь"
  L["Boar"] = "Вепрь"
  L["Crocolisk"] = "Кроколиск"
  L["Carrion Bird"] = "Падальщик"
  L["Crab"] = "Краб"
  L["Gorilla"] = "Горилла"
  L["Raptor"] = "Ящер"
  L["Tallstrider"] = "Долгоног"
  L["Felhunter"] = "Охотник Скверны"
  L["Voidwalker"] = "Демон Бездны"
  L["Succubus"] = "Суккуб"
  L["Doomguard"] = "Стражник ужаса"
  L["Turtle"] = "Черепаха"
  L["Imp"] = "Бес"
  L["Bat"] = "Летучая мышь"
  L["Hyena"] = "Гиена"
  L["Bird of Prey"] = "Сова"
  L["Wind Serpent"] = "Крылатый змей"
  L["Remote Control"] = "Управление"
  L["Felguard"] = "Страж Скверны"
  L["Dragonhawk"] = "Дракондор"
  L["Warp Stalker"] = "Прыгуана"
  L["Sporebat"] = "Спороскат"
  L["Nether Ray"] = "Скат Пустоты"
  L["Serpent"] = "Змей"
  L["Moth"] = "моо"
  L["Chimaera"] = "Химера"
  L["Devilsaur"] = "Дьявозавр"
  L["Ghoul"] = "Вурдалак"
  L["Worm"] = "Червь"
  L["Rhino"] = "Люторог"
  L["Wasp"] = "Оса"
  L["Core Hound"] = "Гончая Недр"
  L["Spirit Beast"] = "Дух зверя"
  L["Incubus"] = "Инкуб"

  L["SHORTDATE_EU"] = "%1$d/%2$d/%3$02d"
  L["D_SECONDS"] = "%d c"
  L["SECONDS_ABBR"] = "%d с."
  L["SECOND_ONELETTER_ABBR"] = "%d с."
  L["D_MINUTES"] = "%d |4минута:минуты:минут;"
  L["MINUTES_ABBR"] = "%d мин."
  L["MINUTE_ONELETTER_ABBR"] = "%d м."
  L["D_HOURS"] = "%d ч."
  L["HOURS_ABBR"] = "%d ч."
  L["HOUR_ONELETTER_ABBR"] = "%d ч."
  L["D_DAYS"] = "%d д."
  L["DAYS_ABBR"] = "%d д."
  L["DAY_ONELETTER_ABBR"] = "%d д."
  L["LESS_THAN_OPERAND"] = "< %s"
  L["TIME_UNIT_DELIMITER"] = " "
  L["HOURS_MINUTES_SECONDS"] = "%.2d:%.2d:%.2d"
  L["MINUTES_SECONDS"] = "%.2d:%.2d"
  L["SHORTDATE"] = "%1$d/%2$02d/%3$02d"
  L["SHORTDATENOYEAR"] = "%1$02d/%2$d"
  L["SHORTDATENOYEAR_EU"] = "%1$d/%2$d"
  L["DECIMAL_SEPERATOR"] = ","
  L["SECOND_NUMBER_CAP"] = "M"
  L["FIRST_NUMBER_CAP"] = "T"
  L["FIRST_NUMBER_CAP_NO_SPACE"] = "Т"
  L["FOURTH_NUMBER_CAP_NO_SPACE"] = "T"
  L["SECOND_NUMBER_CAP_NO_SPACE"] = "М"
  L["THIRD_NUMBER_CAP_NO_SPACE"] = "МЛРД"

  if WeakAuras.IsWrath() then
    L["Vault of Archavon"] = "Склеп Аркавона"
    L["Archavon the Stone Watcher"] = "Аркавон Страж Камня"
    L["Emalon the Storm Watcher"] = "Эмалон Страж Бури"
    L["Koralon the Flame Watcher"] = "Коралон Страж Огня"
    L["Toravon the Ice Watcher"] = "Торавон Страж Льда"
    L["Naxxramas"] = "Наксрамас"
    L["Anub'Rekhan"] = "Ануб'Рекан"
    L["Grand Widow Faerlina"] = "Великая вдова Фарлина"
    L["Maexxna"] = "Мексна"
    L["Noth the Plaguebringer"] = "Нот Чумной"
    L["Heigan the Unclean"] = "Хейган Нечестивый"
    L["Loatheb"] = "Лотхиб"
    L["Instructor Razuvious"] = "Инструктор Разувий"
    L["Gothik the Harvester"] = "Готик Жнец"
    L["The Four Horsemen"] = "Четыре всадника"
    L["Patchwerk"] = "Лоскутик"
    L["Grobbulus"] = "Гроббулус"
    L["Gluth"] = "Глут"
    L["Thaddius"] = "Таддиус"
    L["Sapphiron"] = "Сапфирон"
    L["Kel'Thuzad"] = "Кел'Тузад"
    L["The Obsidian Sanctum"] = "Обсидиановое святилище"
    L["Tenebron"] = "Тенеброн"
    L["Shadron"] = "Шадрон"
    L["Vesperon"] = "Весперон"
    L["Sartharion"] = "Сартарион"
    L["The Eye of Eternity"] = "Око Вечности"
    L["Malygos"] = "Малигос"
    L["Ulduar"] = "Ульдуар"
    L["Flame Leviathan"] = "Огненный Левиафан"
    L["Ignis the Furnace Master"] = "Повелитель горнов Игнис"
    L["Razorscale"] = "Острокрылая"
    L["XT-002 Deconstructor"] = "Разрушитель XT-002"
    L["Assembly of Iron"] = "Железное Собрание"
    L["Kologarn"] = "Кологарн"
    L["Auriaya"] = "Ауриайя"
    L["Freya"] = "Фрейя"
    L["Hodir"] = "Ходир"
    L["Mimiron"] = "Мимирон"
    L["Thorim"] = "Торим"
    L["General Vezax"] = "Генерал Везакс"
    L["Yogg-Saron"] = "Йогг-Сарон"
    L["Algalon the Observer"] = "Алгалон Наблюдатель"
    L["Trial of the Crusader"] = "Испытание крестоносца"
    L["Northrend Beasts"] = "Чудовища Нордскола"
    L["Lord Jaraxxus"] = "Лорд Джараксус"
    L["Faction Champions"] = "Чемпионы фракций"
    L["Val'kyr Twins"] = "Валь'киры-близнецы"
    L["Anub'arak"] = "Ануб'арак"
    L["Onyxia's Lair"] = "Логово Ониксии"
    L["Onyxia"] = "Ониксия"
    L["Icecrown Citadel"] = "Цитадель Ледяной Короны"
    L["Lord Marrowgar"] = "Лорд Ребрад"
    L["Lady Deathwhisper"] = "Леди Смертный Шепот"
    L["Gunship Battle"] = "Бой на кораблях"
    L["Deathbringer Saurfang"] = "Саурфанг Смертоносный"
    L["Festergut"] = "Тухлопуз"
    L["Rotface"] = "Гниломорд"
    L["Professor Putricide"] = "Профессор Мерзоцид"
    L["Blood Prince Council"] = "Совет кровавых принцев"
    L["Blood-Queen Lana'thel"] = "Кровавая королева Лана'тель"
    L["Valithria Dreamwalker"] = "Валитрия Сноходица"
    L["Sindragosa"] = "Синдрагоса"
    L["The Lich King"] = "Король-лич"
    L["The Ruby Sanctum"] = "Рубиновое святилище"
    L["Baltharus the Warborn"] = "Балтар Рожденный в Битве"
    L["General Zarithrian"] = "Генерал Заритриан"
    L["Saviana Ragefire"] = "Савиана Огненная Пропасть"
    L["Halion"] = "Халион"

  elseif WeakAuras.IsTBC() then
    L["Karazhan"] = "Каражан"
    L["Attumen the Huntsman"] = "Ловчий Аттумен"
    L["Moroes"] = "Мороуз"
    L["Maiden of Virtue"] = "Благочестивая дева"
    L["Opera Hall"] = "Оперный зал"
    L["The Curator"] = "Смотритель"
    L["Terestian Illhoof"] = "Терестиан Больное Копыто"
    L["Shade of Aran"] = "Тень Арана"
    L["Netherspite"] = "Гнев Пустоты"
    L["Chess Event"] = "Шахматы"
    L["Prince Malchezaar"] = "Принц Малчезар"
    L["Nightbane"] = "Ночная Погибель"
    L["Gruul's Lair"] = "Логово Груула"
    L["High King Maulgar"] = "Король Молгар"
    L["Gruul the Dragonkiller"] = "Груул Драконобой"
    L["Magtheridon's Lair"] = "Логово Магтеридона"
    L["Magtheridon"] = "Магтеридон"
    L["Coilfang: Serpentshrine Cavern"] = "Змеиное святилище"
    L["Hydross the Unstable"] = "Гидросс Нестабильный"
    L["The Lurker Below"] = "Скрытень из глубин"
    L["Leotheras the Blind"] = "Леотерас Слепец"
    L["Fathom-Lord Karathress"] = "Повелитель глубин Каратресс"
    L["Morogrim Tidewalker"] = "Морогрим Волноступ"
    L["Lady Vashj"] = "Леди Вайш"
    L["Tempest Keep"] = "Крепость Бурь"
    L["Al'ar"] = "Ал'ар"
    L["Void Reaver"] = "Страж Бездны"
    L["High Astromancer Solarian"] = "Верховный звездочет Солариан"
    L["Kael'thas Sunstrider"] = "Кель'тас Солнечный Скиталец"
    L["The Battle for Mount Hyjal"] = "Битва за гору Хиджал"
    L["Rage Winterchill"] = "Лютый Хлад"
    L["Anetheron"] = "Анетерон"
    L["Kaz'rogal"] = "Каз'рогал"
    L["Azgalor"] = "Азгалор"
    L["Archimonde"] = "Архимонд"
    L["Black Temple"] = "Черный храм"
    L["High Warlord Naj'entus"] = "Верховный полководец Надж'ентус"
    L["Supremus"] = "Супремус"
    L["Shade of Akama"] = "Тень Акамы"
    L["Teron Gorefiend"] = "Терон Кровожад"
    L["Gurtogg Bloodboil"] = "Гуртогг Кипящая Кровь"
    L["Reliquary of Souls"] = "Реликварий душ"
    L["Mother Shahraz"] = "Матушка Шахраз"
    L["The Illidari Council"] = "Совет иллидари"
    L["Illidan Stormrage"] = "Иллидан Ярость Бури"
    L["Zul'Aman"] = "Зул'Аман"
    L["Akil'zon"] = "Акил'зон"
    L["Nalorakk"] = "Налоракк"
    L["Jan'alai"] = "Джан'алай"
    L["Halazzi"] = "Халаззи"
    L["Hex Lord Malacrass"] = "Повелитель проклятий Малакрасс"
    L["Daakara"] = "Даакара"
    L["The Sunwell Plateau"] = "Плато Солнечного Колодца"
    L["Kalecgos"] = "Калесгос"
    L["Brutallus"] = "Бруталл"
    L["Felmyst"] = "Пророк Скверны"
    L["Eredar Twins"] = "Эредарские близнецы"
    L["M'uru"] = "М'ууру"
    L["Kil'jaeden"] = "Кил'джеден"
  end

elseif (locale == "zhCN") then
  L["|cFFFF0000Encounter Trigger requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000首领战斗触发器需要已安装并更新到最新的 Deadly Boss Mods (DBM)。|r"
  L["|cFFFF0000Encounter load options requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000首领战斗加载选项需要已安装并更新到最新的 Deadly Boss Mods (DBM)。|r"
  L["Requires Deadly Boss Mods (DBM) to detect encounters."] = "检测首领战斗需要 Deadly Boss Mods (DBM)。"
  L["Based on "] = "基于 "
  L["AddOn: APIDocumentation is %s."] = "插件：APIDocumentation %s。"
  L["Please install it."] = "请安装它。"
  L["Please enable it in your AddOn list."] = "请在你的插件列表中启用它。"
  L["AddOn: APIDocumentation is not loaded correctly."] = "插件：APIDocumentation 未正确加载。"

  L["Requires syncing the specialization via LibGroupTalents."] = "需要通过LibGroupTalents同步专精。"
  L["Affliction"] = "痛苦"
  L["Arcane"] = "奥术"
  L["Arms"] = "武器"
  L["Assassination"] = "刺杀"
  L["Balance"] = "平衡"
  L["Beast Mastery"] = "野兽控制"
  L["Blood"] = "鲜血"
  L["Combat"] = "战斗"
  L["Demonology"] = "恶魔学识"
  L["Destruction"] = "毁灭"
  L["Discipline"] = "戒律"
  L["ElementalShaman"] = "元素战斗"
  L["Enhancement"] = "增强"
  L["Feral Combat"] = "野性战斗"
  L["Fire"] = "火焰"
  L["Frost"] = "冰霜"
  L["Fury"] = "狂怒"
  L["Holy"] = "神圣"
  L["Hybrid"] = "混合"
  L["Marksmanship"] = "射击"
  L["Protection"] = "防护"
  L["Restoration"] = "恢复"
  L["Retribution"] = "惩戒"
  L["Shadow"] = "暗影魔法"
  L["Subtlety"] = "敏锐"
  L["Survival"] = "生存技能"
  L["Unholy"] = "邪恶"

  L["Beast"] = "野兽"
  L["Critter"] = "小动物"
  L["Dragonkin"] = "龙类"
  L["Gas Cloud"] = "气体云雾"
  L["Humanoid"] = "人型生物"
  L["Mechanical"] = "机械"
  L["Non-combat Pet"] = "非战斗宠物"
  L["Not specified"] = "未指定"
  L["Totem"] = "图腾"
  L["Undead"] = "亡灵"

  L["Wolf"] = "狼"
  L["Cat"] = "豹"
  L["Spider"] = "蜘蛛"
  L["Bear"] = "熊"
  L["Boar"] = "野猪"
  L["Crocolisk"] = "鳄鱼"
  L["Carrion Bird"] = "食腐鸟"
  L["Crab"] = "螃蟹"
  L["Gorilla"] = "猩猩"
  L["Raptor"] = "迅猛龙"
  L["Tallstrider"] = "陆行鸟"
  L["Felhunter"] = "地狱猎犬"
  L["Voidwalker"] = "虚空行者"
  L["Succubus"] = "魅魔"
  L["Doomguard"] = "末日守卫"
  L["Turtle"] = "海龟"
  L["Imp"] = "小鬼"
  L["Bat"] = "蝙蝠"
  L["Hyena"] = "土狼"
  L["Bird of Prey"] = "猛禽"
  L["Wind Serpent"] = "风蛇"
  L["Remote Control"] = "远程控制"
  L["Felguard"] = "恶魔卫士"
  L["Dragonhawk"] = "龙鹰"
  L["Warp Stalker"] = "迁跃捕猎者"
  L["Sporebat"] = "孢子蝠"
  L["Nether Ray"] = "虚空鳐"
  L["Serpent"] = "蛇"
  L["Moth"] = "蛾子"
  L["Chimaera"] = "奇美拉"
  L["Devilsaur"] = "魔暴龙"
  L["Ghoul"] = "食尸鬼"
  L["Worm"] = "蠕虫"
  L["Rhino"] = "犀牛"
  L["Wasp"] = "巨蜂"
  L["Core Hound"] = "熔岩犬"
  L["Spirit Beast"] = "灵魂兽"
  L["Incubus"] = "夜魔"

  L["SHORTDATE_EU"] = "%1$d/%2$d/%3$02d"
  L["D_SECONDS"] = "%d|4秒:秒;"
  L["SECONDS_ABBR"] = "%d|4秒:秒;"
  L["SECOND_ONELETTER_ABBR"] = "%d s"
  L["D_MINUTES"] = "%d|4分钟:分钟;"
  L["MINUTES_ABBR"] = "%d|4分钟:分钟;"
  L["MINUTE_ONELETTER_ABBR"] = "%d m"
  L["D_HOURS"] = "%d|4小时:小时;"
  L["HOURS_ABBR"] = "%d|4小时:小时;"
  L["HOUR_ONELETTER_ABBR"] = "%d h"
  L["D_DAYS"] = "%d|4天:天;"
  L["DAYS_ABBR"] = "%d|4天:天;"
  L["DAY_ONELETTER_ABBR"] = "%d d"
  L["LESS_THAN_OPERAND"] = "< %s"
  L["TIME_UNIT_DELIMITER"] = " "
  L["HOURS_MINUTES_SECONDS"] = "%.2d:%.2d:%.2d"
  L["MINUTES_SECONDS"] = "%.2d：%.2d"
  L["SHORTDATE"] = "%2$d/%1$02d/%3$02d"
  L["SHORTDATENOYEAR"] = "%2$d/%1$02d"
  L["SHORTDATENOYEAR_EU"] = "%1$d/%2$d"
  L["DECIMAL_SEPERATOR"] = "."
  L["SECOND_NUMBER_CAP"] = "亿"
  L["FIRST_NUMBER_CAP"] = "万"
  L["FIRST_NUMBER_CAP_NO_SPACE"] = "万"
  L["FOURTH_NUMBER_CAP_NO_SPACE"] = "T"
  L["SECOND_NUMBER_CAP_NO_SPACE"] = "亿"
  L["THIRD_NUMBER_CAP_NO_SPACE"] = "B"

  if WeakAuras.IsWrath() then
    L["Vault of Archavon"] = "阿尔卡冯的宝库"
    L["Archavon the Stone Watcher"] = "岩石看守者阿尔卡冯"
    L["Emalon the Storm Watcher"] = "风暴看守者埃玛尔隆"
    L["Koralon the Flame Watcher"] = "火焰看守者科拉隆"
    L["Toravon the Ice Watcher"] = "寒冰看守者图拉旺"
    L["Naxxramas"] = "纳克萨玛斯"
    L["Anub'Rekhan"] = "阿努布雷坎"
    L["Grand Widow Faerlina"] = "黑女巫法琳娜"
    L["Maexxna"] = "迈克斯纳"
    L["Noth the Plaguebringer"] = "瘟疫使者诺斯"
    L["Heigan the Unclean"] = "肮脏的希尔盖"
    L["Loatheb"] = "洛欧塞布"
    L["Instructor Razuvious"] = "教官拉苏维奥斯"
    L["Gothik the Harvester"] = "收割者戈提克"
    L["The Four Horsemen"] = "天启四骑士"
    L["Patchwerk"] = "帕奇维克"
    L["Grobbulus"] = "格罗布鲁斯"
    L["Gluth"] = "格拉斯"
    L["Thaddius"] = "塔迪乌斯"
    L["Sapphiron"] = "萨菲隆"
    L["Kel'Thuzad"] = "克尔苏加德"
    L["The Obsidian Sanctum"] = "黑曜石圣殿"
    L["Tenebron"] = "塔尼布隆"
    L["Shadron"] = "沙德隆"
    L["Vesperon"] = "维斯匹隆"
    L["Sartharion"] = "萨塔里奥"
    L["The Eye of Eternity"] = "永恒之眼"
    L["Malygos"] = "玛里苟斯"
    L["Ulduar"] = "奥杜尔"
    L["Flame Leviathan"] = "烈焰巨兽"
    L["Ignis the Furnace Master"] = "掌炉者伊格尼斯"
    L["Razorscale"] = "锋鳞"
    L["XT-002 Deconstructor"] = "XT-002拆解者"
    L["Assembly of Iron"] = "钢铁议会"
    L["Kologarn"] = "科隆加恩"
    L["Auriaya"] = "欧尔莉亚"
    L["Freya"] = "弗蕾亚"
    L["Hodir"] = "霍迪尔"
    L["Mimiron"] = "米米尔隆"
    L["Thorim"] = "托里姆"
    L["General Vezax"] = "维扎克斯将军"
    L["Yogg-Saron"] = "尤格-萨隆"
    L["Algalon the Observer"] = "观察者奥尔加隆"
    L["Trial of the Crusader"] = "十字军的试炼"
    L["Northrend Beasts"] = "诺森德猛兽"
    L["Lord Jaraxxus"] = "加拉克苏斯大王"
    L["Faction Champions"] = "阵营冠军"
    L["Val'kyr Twins"] = "瓦格里双子"
    L["Anub'arak"] = "阿努布雷坎"
    L["Onyxia's Lair"] = "奥妮克希亚的巢穴"
    L["Onyxia"] = "奥妮克希亚"
    L["Icecrown Citadel"] = "冰冠堡垒"
    L["Lord Marrowgar"] = "玛洛加尔领主"
    L["Lady Deathwhisper"] = "亡语者女士"
    L["Gunship Battle"] = "冰冠冰川炮舰战"
    L["Deathbringer Saurfang"] = "死亡使者萨鲁法尔"
    L["Festergut"] = "烂肠"
    L["Rotface"] = "腐面"
    L["Professor Putricide"] = "普崔塞德教授"
    L["Blood Prince Council"] = "鲜血议会"
    L["Blood-Queen Lana'thel"] = "兰娜瑟尔女王"
    L["Valithria Dreamwalker"] = "踏梦者瓦莉瑟瑞娅"
    L["Sindragosa"] = "辛达苟萨"
    L["The Lich King"] = "巫妖王"
    L["The Ruby Sanctum"] = "红玉圣殿"
    L["Baltharus the Warborn"] = "战争之子巴尔萨鲁斯"
    L["General Zarithrian"] = "萨瑞瑟里安将军"
    L["Saviana Ragefire"] = "塞维娅娜·怒火"
    L["Halion"] = "海里昂"

  elseif WeakAuras.IsTBC() then
    L["Karazhan"] = "卡拉赞"
    L["Attumen the Huntsman"] = "猎手阿图门"
    L["Moroes"] = "莫罗斯"
    L["Maiden of Virtue"] = "贞节圣女"
    L["Opera Hall"] = "歌剧院"
    L["The Curator"] = "馆长"
    L["Terestian Illhoof"] = "特雷斯坦·邪蹄"
    L["Shade of Aran"] = "埃兰之影"
    L["Netherspite"] = "虚空幽龙"
    L["Chess Event"] = "国际象棋"
    L["Prince Malchezaar"] = "玛克扎尔王子"
    L["Nightbane"] = "夜之魇"
    L["Gruul's Lair"] = "格鲁尔的巢穴"
    L["High King Maulgar"] = "莫加尔大王"
    L["Gruul the Dragonkiller"] = "屠龙者格鲁尔"
    L["Magtheridon's Lair"] = "玛瑟里顿的巢穴"
    L["Magtheridon"] = "玛瑟里顿"
    L["Coilfang: Serpentshrine Cavern"] = "盘牙湖泊：毒蛇神殿"
    L["Hydross the Unstable"] = "不稳定的海度斯"
    L["The Lurker Below"] = "鱼斯拉"
    L["Leotheras the Blind"] = "盲眼者莱欧瑟拉斯"
    L["Fathom-Lord Karathress"] = "深水领主卡拉瑟雷斯"
    L["Morogrim Tidewalker"] = "莫洛格里·踏潮者"
    L["Lady Vashj"] = "瓦丝琪"
    L["Tempest Keep"] = "风暴要塞"
    L["Al'ar"] = "奥"
    L["Void Reaver"] = "空灵机甲"
    L["High Astromancer Solarian"] = "大星术师索兰莉安"
    L["Kael'thas Sunstrider"] = "凯尔萨斯·逐日者"
    L["The Battle for Mount Hyjal"] = "海加尔山之战"
    L["Rage Winterchill"] = "雷基·冬寒"
    L["Anetheron"] = "安纳塞隆"
    L["Kaz'rogal"] = "卡兹洛加"
    L["Azgalor"] = "阿兹加洛"
    L["Archimonde"] = "阿克蒙德"
    L["Black Temple"] = "黑暗神殿"
    L["High Warlord Naj'entus"] = "高阶督军纳因图斯"
    L["Supremus"] = "苏普雷姆斯"
    L["Shade of Akama"] = "阿卡玛之影"
    L["Teron Gorefiend"] = "塔隆·血魔"
    L["Gurtogg Bloodboil"] = "古尔图格·血沸"
    L["Reliquary of Souls"] = "灵魂之匣"
    L["Mother Shahraz"] = "莎赫拉丝主母"
    L["The Illidari Council"] = "伊利达雷议会"
    L["Illidan Stormrage"] = "伊利丹·怒风"
    L["Zul'Aman"] = "祖阿曼"
    L["Akil'zon"] = "埃基尔松"
    L["Nalorakk"] = "纳洛拉克"
    L["Jan'alai"] = "加亚莱"
    L["Halazzi"] = "哈尔拉兹"
    L["Hex Lord Malacrass"] = "妖术领主玛拉卡斯"
    L["Daakara"] = "达卡拉"
    L["The Sunwell Plateau"] = "太阳之井"
    L["Kalecgos"] = "卡雷苟斯"
    L["Brutallus"] = "布鲁塔卢斯"
    L["Felmyst"] = "菲米丝"
    L["Eredar Twins"] = "艾瑞达双子"
    L["M'uru"] = "穆鲁"
    L["Kil'jaeden"] = "基尔加丹"
  end

elseif (locale == "zhTW") then
  L["|cFFFF0000Encounter Trigger requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000首領戰觸發需要安裝並更新到最新版本的 Deadly Boss Mods (DBM)。|r"
  L["|cFFFF0000Encounter load options requires Deadly Boss Mods (DBM) to be installed and up to date.|r"] = "|cFFFF0000首領戰載入選項需要安裝並更新到最新版本的 Deadly Boss Mods (DBM)。|r"
  L["Requires Deadly Boss Mods (DBM) to detect encounters."] = "偵測首領戰需要 Deadly Boss Mods (DBM)。"
  L["Based on "] = "基於 "
  L["AddOn: APIDocumentation is %s."] = "插件：APIDocumentation %s。"
  L["Please install it."] = "請安裝它。"
  L["Please enable it in your AddOn list."] = "請在你的插件清單中啟用它。"
  L["AddOn: APIDocumentation is not loaded correctly."] = "插件：APIDocumentation 未正確載入。"

  L["Requires syncing the specialization via LibGroupTalents."] = "需要透由LibGroupTalents同步專精。"
  L["Affliction"] = "痛苦"
  L["Arcane"] = "秘法"
  L["Arms"] = "武器"
  L["Assassination"] = "刺殺"
  L["Balance"] = "平衡"
  L["Beast Mastery"] = "野獸控制"
  L["Blood"] = "血魄"
  L["Combat"] = "戰鬥"
  L["Demonology"] = "惡魔學識"
  L["Destruction"] = "毀滅"
  L["Discipline"] = "戒律"
  L["ElementalShaman"] = "元素"
  L["Enhancement"] = "增強"
  L["Feral Combat"] = "野性戰鬥"
  L["Fire"] = "火焰"
  L["Frost"] = "冰霜"
  L["Fury"] = "狂怒"
  L["Holy"] = "神聖"
  L["Hybrid"] = "混合"
  L["Marksmanship"] = "射擊"
  L["Protection"] = "防護"
  L["Restoration"] = "恢復"
  L["Retribution"] = "懲戒"
  L["Shadow"] = "暗影"
  L["Subtlety"] = "敏銳"
  L["Survival"] = "生存"
  L["Unholy"] = "穢邪"

  L["Beast"] = "野獸"
  L["Critter"] = "小動物"
  L["Dragonkin"] = "龍類"
  L["Gas Cloud"] = "氣體雲"
  L["Humanoid"] = "人型生物"
  L["Mechanical"] = "機械"
  L["Non-combat Pet"] = "非戰鬥寵物"
  L["Not specified"] = "不明"
  L["Totem"] = "圖騰"
  L["Undead"] = "不死族"

  L["Wolf"] = "狼"
  L["Cat"] = "豹"
  L["Spider"] = "蜘蛛"
  L["Bear"] = "熊"
  L["Boar"] = "野豬"
  L["Crocolisk"] = "鱷魚"
  L["Carrion Bird"] = "食腐鳥"
  L["Crab"] = "螃蟹"
  L["Gorilla"] = "猩猩"
  L["Raptor"] = "迅猛龍"
  L["Tallstrider"] = "陸行鳥"
  L["Felhunter"] = "惡魔獵犬"
  L["Voidwalker"] = "虛無行者"
  L["Succubus"] = "魅魔"
  L["Doomguard"] = "末日守衛"
  L["Turtle"] = "海龜"
  L["Imp"] = "小鬼"
  L["Bat"] = "蝙蝠"
  L["Hyena"] = "土狼"
  L["Bird of Prey"] = "猛禽"
  L["Wind Serpent"] = "風蛇"
  L["Remote Control"] = "遙控"
  L["Felguard"] = "惡魔守衛"
  L["Dragonhawk"] = "龍鷹"
  L["Warp Stalker"] = "扭曲巡者"
  L["Sporebat"] = "孢子蝙蝠"
  L["Nether Ray"] = "虛空鰭刺"
  L["Serpent"] = "毒蛇"
  L["Moth"] = "蛾"
  L["Chimaera"] = "奇美拉"
  L["Devilsaur"] = "魔暴龍"
  L["Ghoul"] = "食屍鬼"
  L["Worm"] = "蟲"
  L["Rhino"] = "犀牛"
  L["Wasp"] = "黃蜂"
  L["Core Hound"] = "熔核犬"
  L["Spirit Beast"] = "靈獸"
  L["Incubus"] = "夢魔"

  L["SHORTDATE_EU"] = "%1$d/%2$d/%3$02d"
  L["D_SECONDS"] = "%d秒"
  L["SECONDS_ABBR"] = "%d秒"
  L["SECOND_ONELETTER_ABBR"] = "%d秒"
  L["D_MINUTES"] = "%d分鐘"
  L["MINUTES_ABBR"] = "%d分鐘"
  L["MINUTE_ONELETTER_ABBR"] = "%d分"
  L["D_HOURS"] = "%d小時"
  L["HOURS_ABBR"] = "%d小時"
  L["HOUR_ONELETTER_ABBR"] = "%d小時"
  L["D_DAYS"] = "%d天"
  L["DAYS_ABBR"] = "%d天"
  L["DAY_ONELETTER_ABBR"] = "%d天"
  L["LESS_THAN_OPERAND"] = "< %s"
  L["TIME_UNIT_DELIMITER"] = " "
  L["HOURS_MINUTES_SECONDS"] = "%.2d:%.2d:%.2d"
  L["MINUTES_SECONDS"] = "%.2d:%.2d"
  L["SHORTDATE"] = "%2$d-%1$02d-%3$02d"
  L["SHORTDATENOYEAR"] = "%2$d/%1$02d"
  L["SHORTDATENOYEAR_EU"] = "%1$d/%2$d"
  L["DECIMAL_SEPERATOR"] = "."
  L["SECOND_NUMBER_CAP"] = "億"
  L["FIRST_NUMBER_CAP"] = "萬"
  L["FIRST_NUMBER_CAP_NO_SPACE"] = "萬"
  L["FOURTH_NUMBER_CAP_NO_SPACE"] = "T"
  L["SECOND_NUMBER_CAP_NO_SPACE"] = "億"
  L["THIRD_NUMBER_CAP_NO_SPACE"] = "B"

  if WeakAuras.IsWrath() then
    L["Vault of Archavon"] = "亞夏梵穹殿"
    L["Archavon the Stone Watcher"] = "『石之看守者』亞夏梵"
    L["Emalon the Storm Watcher"] = "『風暴看守者』艾瑪隆"
    L["Koralon the Flame Watcher"] = "『烈焰看守者』寇拉隆"
    L["Toravon the Ice Watcher"] = "『寒冰看守者』拓拉梵"
    L["Naxxramas"] = "納克薩瑪斯"
    L["Anub'Rekhan"] = "阿努比瑞克漢"
    L["Grand Widow Faerlina"] = "大寡婦費琳娜"
    L["Maexxna"] = "梅克絲娜"
    L["Noth the Plaguebringer"] = "『瘟疫使者』諾斯"
    L["Heigan the Unclean"] = "『骯髒者』海根"
    L["Loatheb"] = "憎惡體"
    L["Instructor Razuvious"] = "講師拉祖維斯"
    L["Gothik the Harvester"] = "『收割者』高希"
    L["The Four Horsemen"] = "四騎士"
    L["Patchwerk"] = "縫補者"
    L["Grobbulus"] = "葛羅巴斯"
    L["Gluth"] = "古魯斯"
    L["Thaddius"] = "泰迪斯"
    L["Sapphiron"] = "薩菲隆"
    L["Kel'Thuzad"] = "克爾蘇加德"
    L["The Obsidian Sanctum"] = "黑曜聖所"
    L["Tenebron"] = "坦納伯朗"
    L["Shadron"] = "夏德朗"
    L["Vesperon"] = "維斯佩朗"
    L["Sartharion"] = "撒爾薩里安"
    L["The Eye of Eternity"] = "永恆之眼"
    L["Malygos"] = "瑪里苟斯"
    L["Ulduar"] = "奧杜亞"
    L["Flame Leviathan"] = "烈焰戰輪"
    L["Ignis the Furnace Master"] = "『火爐之主』伊格尼司"
    L["Razorscale"] = "銳鱗"
    L["XT-002 Deconstructor"] = "XT-002拆解者"
    L["Assembly of Iron"] = "鐵之集會"
    L["Kologarn"] = "柯洛剛恩"
    L["Auriaya"] = "奧芮雅"
    L["Freya"] = "芙蕾雅"
    L["Hodir"] = "霍迪爾"
    L["Mimiron"] = "彌米倫"
    L["Thorim"] = "索林姆"
    L["General Vezax"] = "威扎斯將軍"
    L["Yogg-Saron"] = "尤格薩倫"
    L["Algalon the Observer"] = "『觀察者』艾爾加隆"
    L["Trial of the Crusader"] = "十字軍試煉"
    L["Northrend Beasts"] = "北列境野獸"
    L["Lord Jaraxxus"] = "賈拉克瑟斯領主"
    L["Faction Champions"] = "部落勇士"
    L["Val'kyr Twins"] = "華爾琪雙子"
    L["Anub'arak"] = "阿努巴拉克"
    L["Onyxia's Lair"] = "奧妮克希亞的巢穴"
    L["Onyxia"] = "奧妮克希亞"
    L["Icecrown Citadel"] = "冰冠城塞"
    L["Lord Marrowgar"] = "瑪洛嘉領主"
    L["Lady Deathwhisper"] = "亡語女士"
    L["Gunship Battle"] = "冰冠城塞砲艇戰"
    L["Deathbringer Saurfang"] = "死亡使者薩魯法爾"
    L["Festergut"] = "膿腸"
    L["Rotface"] = "腐臉"
    L["Professor Putricide"] = "普崔希德教授"
    L["Blood Prince Council"] = "血親王議會"
    L["Blood-Queen Lana'thel"] = "血腥女王菈娜薩爾"
    L["Valithria Dreamwalker"] = "瓦莉絲瑞雅‧夢行者"
    L["Sindragosa"] = "辛德拉苟莎"
    L["The Lich King"] = "巫妖王"
    L["The Ruby Sanctum"] = "晶紅聖所"
    L["Baltharus the Warborn"] = "『戰爭之子』巴爾薩魯斯"
    L["General Zarithrian"] = "扎里斯利安將軍"
    L["Saviana Ragefire"] = "薩薇安娜‧怒焰"
    L["Halion"] = "海萊恩"

  elseif WeakAuras.IsTBC() then
    L["Karazhan"] = "卡拉贊"
    L["Attumen the Huntsman"] = "獵人阿圖曼"
    L["Moroes"] = "摩洛"
    L["Maiden of Virtue"] = "貞潔聖女"
    L["Opera Hall"] = "歌劇院"
    L["The Curator"] = "館長"
    L["Terestian Illhoof"] = "泰瑞斯提安·疫蹄"
    L["Shade of Aran"] = "艾蘭之影"
    L["Netherspite"] = "尼德斯"
    L["Chess Event"] = "西洋棋事件"
    L["Prince Malchezaar"] = "莫克札王子"
    L["Nightbane"] = "夜禍"
    L["Gruul's Lair"] = "格魯爾的巢穴"
    L["High King Maulgar"] = "大君王莫卡爾"
    L["Gruul the Dragonkiller"] = "弒龍者戈魯爾"
    L["Magtheridon's Lair"] = "瑪瑟里頓的巢穴"
    L["Magtheridon"] = "瑪瑟里頓"
    L["Coilfang: Serpentshrine Cavern"] = "盤牙: 毒蛇神殿洞穴"
    L["Hydross the Unstable"] = "不穩定者海卓司"
    L["The Lurker Below"] = "海底潛伏者"
    L["Leotheras the Blind"] = "『盲目者』李奧薩拉斯"
    L["Fathom-Lord Karathress"] = "深淵之王卡拉薩瑞斯"
    L["Morogrim Tidewalker"] = "莫洛葛利姆·潮行者"
    L["Lady Vashj"] = "瓦許女士"
    L["Tempest Keep"] = "風暴要塞"
    L["Al'ar"] = "歐爾"
    L["Void Reaver"] = "虛無劫奪者"
    L["High Astromancer Solarian"] = "高階星術師索拉瑞恩"
    L["Kael'thas Sunstrider"] = "凱爾薩斯·逐日者"
    L["The Battle for Mount Hyjal"] = "海加爾山之戰"
    L["Rage Winterchill"] = "瑞齊·凜冬"
    L["Anetheron"] = "安納塞隆"
    L["Kaz'rogal"] = "卡茲洛加"
    L["Azgalor"] = "亞茲加洛"
    L["Archimonde"] = "阿克蒙德"
    L["Black Temple"] = "黑暗神廟"
    L["High Warlord Naj'entus"] = "高階督軍納珍塔斯"
    L["Supremus"] = "瑟普莫斯"
    L["Shade of Akama"] = "阿卡瑪之影"
    L["Teron Gorefiend"] = "泰朗血魔"
    L["Gurtogg Bloodboil"] = "葛塔格·血沸"
    L["Reliquary of Souls"] = "靈魂之匣"
    L["Mother Shahraz"] = "薩拉茲女士"
    L["The Illidari Council"] = "伊利達瑞議會"
    L["Illidan Stormrage"] = "伊利丹·怒風"
    L["Zul'Aman"] = "祖阿曼"
    L["Akil'zon"] = "阿奇爾森"
    L["Nalorakk"] = "納羅拉克"
    L["Jan'alai"] = "賈納雷"
    L["Halazzi"] = "哈拉齊"
    L["Hex Lord Malacrass"] = "妖術領主瑪拉克雷斯"
    L["Daakara"] = "達卡拉"
    L["The Sunwell Plateau"] = "太陽之井高地"
    L["Kalecgos"] = "卡雷苟斯"
    L["Brutallus"] = "布魯托魯斯"
    L["Felmyst"] = "魔龍謎霧"
    L["Eredar Twins"] = "埃雷達爾雙子"
    L["M'uru"] = "莫魯"
    L["Kil'jaeden"] = "基爾加丹"
  end
end
