--[[

	Atlas, a World of Warcraft instance map browser
	Copyright 2005-2010 Dan Gilbert <dan.b.gilbert@gmail.com>

	This file is part of Atlas.

	Atlas is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]

-- Atlas Data
-- Compiled by Dan Gilbert
-- loglow@gmail.com
-- Many thanks to all contributors!

local BabbleSubZone = Atlas_GetLocaleLibBabble("LibBabble-SubZone-3.0");
local BabbleZone = Atlas_GetLocaleLibBabble("LibBabble-Zone-3.0");

local BLUE = "|cff6666ff";
local GREY = "|cff999999";
local GREN = "|cff66cc33";
local _RED = "|cffcc6666";
local ORNG = "|cffcc9933";
local PURP = "|cff9900ff";
local INDENT = "      ";

local ZONE = 1;
local NPC = 2;
local ITEM = 3;
local OBJECT = 4;
local FACTION = 5;
local QUEST = 6;

AtlasMaps = {

--************************************************
-- Instance Entrance Maps
--************************************************

	BlackfathomDeepsEnt = {
		ZoneName = { AtlasLocale["Blackfathom Deeps"].." ("..AtlasLocale["Entrance"]..")", 719 };
		Location = { AtlasLocale["Ashenvale"], 331 };
		LevelRange = "20-28";
		MinLevel = "19";
		PlayerLimit = "5";
		Acronym = AtlasLocale["BFD"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Blackfathom Deeps"], ZONE, 719 };
	};
	BlackrockSpireEnt = {
		ZoneName = { AtlasLocale["Blackrock Mountain"].." ("..AtlasLocale["Entrance"]..")", 25 };
		Location = { AtlasLocale["Searing Gorge"].." / "..AtlasLocale["Burning Steppes"], 51, 46 };
		LevelRange = "54-70";
		MinLevel = "45";
		PlayerLimit = "5/10/40";
		Acronym = AtlasLocale["BRM"];
		{ BLUE.."A) "..AtlasLocale["Searing Gorge"], ZONE, 51 };
		{ BLUE.."B) "..AtlasLocale["Burning Steppes"], ZONE, 46 };
		{ BLUE.."C) "..AtlasLocale["Blackrock Depths"].." ("..AtlasLocale["BRD"]..")", ZONE, 1584 };
		{ BLUE..INDENT..AtlasLocale["Molten Core"].." ("..AtlasLocale["MC"]..")", ZONE, 2717 };
		{ BLUE.."D) "..AtlasLocale["Blackrock Spire"].." ("..AtlasLocale["Lower"]..", "..AtlasLocale["LBRS"]..")", ZONE, 1583 };
		{ BLUE..INDENT..AtlasLocale["Blackrock Spire"].." ("..AtlasLocale["Upper"]..", "..AtlasLocale["UBRS"]..")", ZONE, 1583 };
		{ BLUE..INDENT..AtlasLocale["Bodley"].." ("..AtlasLocale["Ghost"]..")", NPC, 16033 };
		{ GREY.."1) "..AtlasLocale["Overmaster Pyron"].." ("..AtlasLocale["Wanders"]..")", NPC, 9026 };
		{ GREY.."2) "..AtlasLocale["Lothos Riftwaker"], NPC, 14387 };
		{ GREY.."3) "..AtlasLocale["Franclorn Forgewright"].." ("..AtlasLocale["Ghost"]..")", NPC, 8888 };
		{ GREY.."4) "..AtlasLocale["Meeting Stone"].." ("..AtlasLocale["BRD"]..")" };
		{ GREY.."5) "..AtlasLocale["Orb of Command"], OBJECT, 179879 };
		{ GREY.."6) "..AtlasLocale["Meeting Stone"].." ("..AtlasLocale["LBRS"]..", "..AtlasLocale["UBRS"]..")" };
		{ GREY.."7) "..AtlasLocale["Scarshield Quartermaster <Scarshield Legion>"], NPC, 9046 };
	};
	GnomereganEnt = {
		ZoneName = { AtlasLocale["Gnomeregan"].." ("..AtlasLocale["Entrance"]..")", 133 };
		Location = { AtlasLocale["Dun Morogh"], 1 };
		LevelRange = "24-32";
		MinLevel = "20";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Gnome"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["Meeting Stone"] };
		{ BLUE.."B) "..AtlasLocale["Gnomeregan"].." ("..AtlasLocale["Front"]..")", ZONE, 133 };
		{ BLUE.."C) "..AtlasLocale["Gnomeregan"].." ("..AtlasLocale["Back"]..")", ZONE, 133 };
		{ GREY.."1) "..AtlasLocale["Elevator"] };
		{ GREY.."2) "..AtlasLocale["Transpolyporter"] };
		{ GREY..INDENT..AtlasLocale["Sprok <Away Team>"], NPC, 8320 };
		{ GREY.."3) "..AtlasLocale["Matrix Punchograph 3005-A"], OBJECT, 142345 };
		{ GREY..INDENT..AtlasLocale["Namdo Bizzfizzle <Engineering Supplies>"], NPC, 2683 };
		{ GREY.."4) "..AtlasLocale["Techbot"], NPC, 6231 };
	};
	MaraudonEnt = {
		ZoneName = { AtlasLocale["Maraudon"].." ("..AtlasLocale["Entrance"]..")", 2100 };
		Location = { AtlasLocale["Desolace"], 405 };
		LevelRange = "42-51";
		MinLevel = "30";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Mara"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["The Nameless Prophet"], NPC, 13718 };
		{ BLUE.."B) "..AtlasLocale["Maraudon"].." ("..AtlasLocale["Purple"]..")", ZONE, 2100 };
		{ BLUE.."C) "..AtlasLocale["Maraudon"].." ("..AtlasLocale["Orange"]..")", ZONE, 2100 };
		{ BLUE.."D) "..AtlasLocale["Maraudon"].." ("..AtlasLocale["Portal"]..")", ZONE, 2100 };
		{ GREY.."1) "..AtlasLocale["Kolk <The First Kahn>"], NPC, 13742 };
		{ GREY.."2) "..AtlasLocale["Gelk <The Second Kahn>"], NPC, 13741 };
		{ GREY.."3) "..AtlasLocale["Magra <The Third Kahn>"], NPC, 13740 };
		{ GREY.."4) "..AtlasLocale["Cavindra"], NPC, 13697 };
	};
	TheDeadminesEnt = {
		ZoneName = { AtlasLocale["The Deadmines"].." ("..AtlasLocale["Entrance"]..")", 1581 };
		Location = { AtlasLocale["Westfall"], 40 };
		LevelRange = "16-22";
		MinLevel = "10";
		PlayerLimit = "5";
		Acronym = AtlasLocale["VC"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["The Deadmines"], ZONE, 1581 };
		{ GREY.."1) "..AtlasLocale["Marisa du'Paige"].." ("..AtlasLocale["Varies"]..")", NPC, 599 };
		{ GREY.."2) "..AtlasLocale["Brainwashed Noble"].." ("..AtlasLocale["Rare"]..")", NPC, 596 };
		{ GREY.."3) "..AtlasLocale["Foreman Thistlenettle"], NPC, 626 };
	};
	TheSunkenTempleEnt = {
		ZoneName = { AtlasLocale["Sunken Temple"].." ("..AtlasLocale["Entrance"]..")", 1417 };
		Location = { AtlasLocale["Swamp of Sorrows"], 8 };
		LevelRange = "46-53";
		MinLevel = "35";
		PlayerLimit = "5";
		Acronym = AtlasLocale["ST"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["Meeting Stone"] };
		{ GREY..INDENT..AtlasLocale["Jade"].." ("..AtlasLocale["Rare"]..")", NPC, 1063 };
		{ BLUE.."B) "..AtlasLocale["Sunken Temple"], ZONE, 1417 };
		{ GREY.."1) "..AtlasLocale["Kazkaz the Unholy"].." ("..AtlasLocale["Upper"]..")", NPC, 5401 };
		{ GREY.."2) "..AtlasLocale["Veyzhak the Cannibal"], NPC, 5399 };
		{ GREY.."3) "..AtlasLocale["Zekkis"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Lower"]..")", NPC, 5400 };
	};
	UldamanEnt = {
		ZoneName = { AtlasLocale["Uldaman"].." ("..AtlasLocale["Entrance"]..")", 1337 };
		Location = { AtlasLocale["Badlands"], 3 };
		LevelRange = "36-42";
		MinLevel = "30";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Ulda"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Uldaman"], ZONE, 1337 };
		{ GREY.."1) "..AtlasLocale["Hammertoe Grez"], NPC, 2909 };
		{ GREY.."2) "..AtlasLocale["Magregan Deepshadow"].." ("..AtlasLocale["Wanders"]..")", NPC, 2932 };
		{ GREY.."3) "..AtlasLocale["Tablet of Ryun'Eh"], ITEM, 4631 };
		{ GREY.."4) "..AtlasLocale["Krom Stoutarm's Chest"], OBJECT, 124389 };
		{ GREY.."5) "..AtlasLocale["Garrett Family Chest"], OBJECT, 124388 };
		{ GREN.."1') "..AtlasLocale["Digmaster Shovelphlange"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Varies"]..")", NPC, 7057 };
	};
	WailingCavernsEnt = {
		ZoneName = { AtlasLocale["Wailing Caverns"].." ("..AtlasLocale["Entrance"]..")", 718 };
		Location = { AtlasLocale["The Barrens"], 17 };
		LevelRange = "16-25";
		MinLevel = "10";
		PlayerLimit = "5";
		Acronym = AtlasLocale["WC"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Wailing Caverns"], ZONE, 718 };
		{ GREY.."1) "..AtlasLocale["Mad Magglish"].." ("..AtlasLocale["Varies"]..")", NPC, 3655 };
		{ GREY.."2) "..AtlasLocale["Trigore the Lasher"].." ("..AtlasLocale["Rare"]..")", NPC, 3652 };
		{ GREY.."3) "..AtlasLocale["Boahn <Druid of the Fang>"].." ("..AtlasLocale["Rare"]..")", NPC, 3672 };
		{ "" };
		{ ORNG..AtlasLocale["Above the Entrance:"] };
		{ GREY..INDENT..AtlasLocale["Ebru <Disciple of Naralex>"], NPC, 5768 };
		{ GREY..INDENT..AtlasLocale["Nalpak <Disciple of Naralex>"], NPC, 5767 };
		{ GREY..INDENT..AtlasLocale["Kalldan Felmoon <Specialist Leatherworking Supplies>"], NPC, 5783 };
		{ GREY..INDENT..AtlasLocale["Waldor <Leatherworking Trainer>"], NPC, 5784 };
	};
	SMEnt = {
		ZoneName = { AtlasLocale["Scarlet Monastery"].." ("..AtlasLocale["Entrance"]..")", 796 };
		Location = { AtlasLocale["Tirisfal Glades"], 85 };
		LevelRange = "28-42";
		MinLevel = "20";
		PlayerLimit = "5";
		Acronym = AtlasLocale["SM"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Graveyard"], ZONE, 796 };
		{ BLUE.."C) "..AtlasLocale["Cathedral"], ZONE, 796 };
		{ BLUE.."D) "..AtlasLocale["Armory"], ZONE, 796 };
		{ BLUE.."E) "..AtlasLocale["Library"], ZONE, 796 };
	};

--************************************************
-- Kalimdor Instances (Classic)
--************************************************

	StonetalonCaverns = {
		ZoneName = { AtlasLocale["Stonetalon Caverns"], 999999 };
		Location = { AtlasLocale["Stonetalon Mountains"], 406 };
		LevelRange = "57-60";
		MinLevel = "??";
		PlayerLimit = "5";
		Acronym = AtlasLocale["STC"];
		{ GREY.."1) "..AtlasLocale["Upcoming"], NPC, 999999 };
	};
	RagefireChasm = {
		ZoneName = { AtlasLocale["Ragefire Chasm"], 2437 };
		Location = { AtlasLocale["Orgrimmar"], 1637 };
		LevelRange = "12-18";
		MinLevel = "8";
		PlayerLimit = "5";
		Acronym = AtlasLocale["RFC"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Maur Grimtotem"], NPC, 11834 };
		{ GREY..INDENT..AtlasLocale["Oggleflint <Ragefire Chieftain>"], NPC, 11517 };
		{ GREY.."2) "..AtlasLocale["Taragaman the Hungerer"], NPC, 11520 };
		{ GREY.."3) "..AtlasLocale["Jergosh the Invoker"], NPC, 11518 };
		{ GREY..INDENT..AtlasLocale["Zelemar the Wrathful"].." ("..AtlasLocale["Summon"]..")", NPC, 17830 };
		{ GREY.."4) "..AtlasLocale["Bazzalan"], NPC, 11519 };
	};
	WailingCaverns = {
		ZoneName = { AtlasLocale["Wailing Caverns"], 718 };
		Location = { AtlasLocale["The Barrens"], 17 };
		LevelRange = "16-25";
		MinLevel = "10";
		PlayerLimit = "5";
		Acronym = AtlasLocale["WC"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Lady Anacondra <Fanglord>"], NPC, 3671 };
		{ GREY.."2) "..AtlasLocale["Skum"], NPC, 3674 };
		{ GREY.."3) "..AtlasLocale["Lord Pythas <Fanglord>"], NPC, 3670 };
		{ GREY.."4) "..AtlasLocale["Verdan the Everliving"].." ("..AtlasLocale["Upper"]..")", NPC, 5775 };
		{ GREY.."5) "..AtlasLocale["Razor"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Varies"]..")", NPC, 999999 };
		{ GREY.."6) "..AtlasLocale["Kresh"].." ("..AtlasLocale["Varies"]..")", NPC, 3653 };
		{ GREY.."7) "..AtlasLocale["Nyx"], NPC, 5912 };
		{ GREY.."8) "..AtlasLocale["Lord Serpentis <Fanglord>"], NPC, 3673 };
		{ GREY.."9) "..AtlasLocale["Lord Cobrahn <Fanglord>"], NPC, 3669 };
		{ GREY.."10) "..AtlasLocale["Muggugaj"], NPC, 999999 };
	};
	BlackfathomDeeps = {
		ZoneName = { AtlasLocale["Blackfathom Deeps"], 719 };
		Location = { AtlasLocale["Ashenvale"], 331 };
		LevelRange = "20-28";
		MinLevel = "19";
		PlayerLimit = "5";
		Acronym = AtlasLocale["BFD"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Ghamoo-ra"], NPC, 4887 };
		{ GREY.."2) "..AtlasLocale["Lorgalis Manuscript"], ITEM, 5359 };
		{ GREY.."3) "..AtlasLocale["Lady Sarevess"], NPC, 4831 };
		{ GREY.."4) "..AtlasLocale["Argent Guard Thaelrid <The Argent Dawn>"], NPC, 4787 };
		{ GREY.."5) "..AtlasLocale["Gelihast"], NPC, 6243 };
		{ GREY..INDENT..AtlasLocale["Shrine of Gelihast"] };
		{ GREY.."6) "..AtlasLocale["Lorgus Jett"].." ("..AtlasLocale["Varies"]..")", NPC, 12902 };
		{ GREY.."7) "..AtlasLocale["Fathom Stone"], OBJECT, 177964 };
		{ GREY..INDENT..AtlasLocale["Baron Aquanis"], NPC, 12876 };
		{ GREY.."8) "..AtlasLocale["Twilight Lord Kelris"], NPC, 4832 };
		{ GREY.."9) "..AtlasLocale["Old Serra'kis"], NPC, 4830 };
		{ GREY.."10) "..AtlasLocale["Aku'mai"], NPC, 4829 };
		{ GREY..INDENT..AtlasLocale["Morridune"], NPC, 6729 };
		{ GREY..INDENT..AtlasLocale["Altar of the Deeps"] };
	};
	RazorfenKraul = {
		ZoneName = { AtlasLocale["Razorfen Kraul"], 491 };
		Location = { AtlasLocale["The Barrens"], 17 };
		LevelRange = "23-33";
		MinLevel = "17";
		PlayerLimit = "5";
		Acronym = AtlasLocale["RFK"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Roogug"], NPC, 6168 };
		{ GREY.."2) "..AtlasLocale["Aggem Thorncurse <Death's Head Prophet>"], NPC, 4424 };
		{ GREY.."3) "..AtlasLocale["Death Speaker Jargba <Death's Head Captain>"], NPC, 4428 };
		{ GREY.."4) "..AtlasLocale["Overlord Ramtusk"], NPC, 4420 };
		{ GREY..INDENT..AtlasLocale["Razorfen Spearhide"], NPC, 4438 };
		{ GREY.."5) "..AtlasLocale["Agathelos the Raging"], NPC, 4422 };
		{ GREY.."6) "..AtlasLocale["Blind Hunter"].." ("..AtlasLocale["Rare"]..")", NPC, 4425 };
		{ GREY.."7) "..AtlasLocale["Charlga Razorflank <The Crone>"], NPC, 4421 };
		{ GREY.."8) "..AtlasLocale["Willix the Importer"], NPC, 4508 };
		{ GREY..INDENT..AtlasLocale["Heralath Fallowbrook"], NPC, 4510 };
		{ GREY.."9) "..AtlasLocale["Earthcaller Halmgar"].." ("..AtlasLocale["Rare"]..")", NPC, 4842 };
	};
	RazorfenDowns = {
		ZoneName = { AtlasLocale["Razorfen Downs"], 722 };
		Location = { AtlasLocale["The Barrens"], 17 };
		LevelRange = "33-42";
		MinLevel = "25";
		PlayerLimit = "5";
		Acronym = AtlasLocale["RFD"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Tuten'kash"], NPC, 7355 };
		{ GREY.."2) "..AtlasLocale["Henry Stern"], NPC, 8696 };
		{ GREY..INDENT..AtlasLocale["Belnistrasz"], NPC, 8516 };
		{ GREY..INDENT..AtlasLocale["Sah'rhee"], NPC, 8767 };
		{ GREY.."3) "..AtlasLocale["Mordresh Fire Eye"], NPC, 7357 };
		{ GREY.."4) "..AtlasLocale["Glutton"], NPC, 8567 };
		{ GREY.."5) "..AtlasLocale["Ragglesnout"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Varies"]..")", NPC, 7354 };
		{ GREY.."6) "..AtlasLocale["Amnennar the Coldbringer"], NPC, 7358 };
		{ GREY.."7) "..AtlasLocale["Plaguemaw the Rotting"], NPC, 7356 };
	};
	ZulFarrak = {
		ZoneName = { AtlasLocale["Zul'Farrak"], 978 };
		Location = { AtlasLocale["Tanaris"], 440 };
		LevelRange = "42-48";
		MinLevel = "35";
		PlayerLimit = "5";
		Acronym = AtlasLocale["ZF"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Antu'sul <Overseer of Sul>"], NPC, 8127 };
		{ GREY.."2) "..AtlasLocale["Theka the Martyr"], NPC, 7272 };
		{ GREY.."3) "..AtlasLocale["Witch Doctor Zum'rah"], NPC, 7271 };
		{ GREY..INDENT..AtlasLocale["Zul'Farrak Dead Hero"], NPC, 7276 };
		{ GREY.."4) "..AtlasLocale["Nekrum Gutchewer"], NPC, 7796 };
		{ GREY..INDENT..AtlasLocale["Shadowpriest Sezz'ziz"], NPC, 7275 };
		{ GREY..INDENT..AtlasLocale["Dustwraith"].." ("..AtlasLocale["Rare"]..")", NPC, 10081 };
		{ GREY.."5) "..AtlasLocale["Sergeant Bly"], NPC, 7604 };
		{ GREY..INDENT..AtlasLocale["Weegli Blastfuse"], NPC, 7607 };
		{ GREY..INDENT..AtlasLocale["Murta Grimgut"], NPC, 7608 };
		{ GREY..INDENT..AtlasLocale["Raven"], NPC, 7605 };
		{ GREY..INDENT..AtlasLocale["Oro Eyegouge"], NPC, 7606 };
		{ GREY..INDENT..AtlasLocale["Sandfury Executioner"], NPC, 7274 };
		{ GREY.."6) "..AtlasLocale["Hydromancer Velratha"], NPC, 7795 };
		{ GREY..INDENT..AtlasLocale["Gahz'rilla"].." ("..AtlasLocale["Summon"]..")", NPC, 7273 };
		{ GREY..INDENT..AtlasLocale["Elder Wildmane"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15578 };
		{ GREY.."7) "..AtlasLocale["Chief Ukorz Sandscalp"], NPC, 7267 };
		{ GREY..INDENT..AtlasLocale["Ruuzlu"], NPC, 7797 };
		{ GREY.."8) "..AtlasLocale["Zerillis"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Wanders"]..")", NPC, 10082 };
		{ GREY.."9) "..AtlasLocale["Sandarr Dunereaver"].." ("..AtlasLocale["Rare"]..")", NPC, 10080 };
	};
	Maraudon = {
		ZoneName = { AtlasLocale["Maraudon"], 2100 };
		Location = { AtlasLocale["Desolace"], 405 };
		LevelRange = "42-51";
		MinLevel = "30";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Mara"];
		{ BLUE.."A) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Orange"]..")" };
		{ BLUE.."B) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Purple"]..")" };
		{ BLUE.."C) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Portal"]..")" };
		{ GREY.."1) "..AtlasLocale["Veng <The Fifth Khan>"], NPC, 13738 };
		{ GREY.."2) "..AtlasLocale["Noxxion"], NPC, 13282 };
		{ GREY.."3) "..AtlasLocale["Razorlash"], NPC, 12258 };
		{ GREY.."4) "..AtlasLocale["Maraudos <The Fourth Khan>"], NPC, 13739 };
		{ GREY.."5) "..AtlasLocale["Lord Vyletongue"], NPC, 12236 };
		{ GREY.."6) "..AtlasLocale["Meshlok the Harvester"].." ("..AtlasLocale["Rare"]..")", NPC, 12237 };
		{ GREY.."7) "..AtlasLocale["Celebras the Cursed"], NPC, 12225 };
		{ GREY.."8) "..AtlasLocale["Landslide"], NPC, 12203 };
		{ GREY.."9) "..AtlasLocale["Tinkerer Gizlock"], NPC, 13601 };
		{ GREY.."10) "..AtlasLocale["Rotgrip"], NPC, 13596 };
		{ GREY.."11) "..AtlasLocale["Princess Theradras"], NPC, 12201 };
		{ GREY.."12) "..AtlasLocale["Elder Splitrock"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15556 };
	};

--************************************************
-- Eastern Kingdoms Instances
--************************************************
	
	BaradinHold = {
		ZoneName = { AtlasLocale["Baradin Hold"], 999999 };
		Location = { AtlasLocale["Tol Barad"], 999999 };
		LevelRange = "57-60";
		MinLevel = "??";
		PlayerLimit = "5";
		Acronym = AtlasLocale["BH"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Morrumus"], NPC, 999999 };
		{ GREY.."2) "..AtlasLocale["Dak´mal"], NPC, 999999 };
		{ GREY.."3) "..AtlasLocale["Millhouse Manastorm"], NPC, 999999 };
		{ GREY.."4) "..AtlasLocale["Glagut"], NPC, 999999 };
		{ GREY.."5) "..AtlasLocale["Astilos the Hollow"], NPC, 999999 };
		{ GREY.."6) "..AtlasLocale["Nazrasash"], NPC, 999999 };
		{ GREY.."7) "..AtlasLocale["Calypso"], NPC, 999999 };
		{ GREY.."7) "..AtlasLocale["Pirate Lord Blackstone"], NPC, 999999 };
		{ GREY..INDENT..AtlasLocale["Mickey G"].." ("..AtlasLocale["Rare"]..")", NPC, 999999 };
		{ GREY..INDENT..AtlasLocale["Head Chef Ramsay"].." ("..AtlasLocale["Rare"]..")", NPC, 999999 };
		{ GREY..INDENT..AtlasLocale["First Mate Malin"].." ("..AtlasLocale["Rare"]..")", NPC, 999999 };
	};
	BlackrockDepths = {
		ZoneName = { AtlasLocale["Blackrock Mountain"]..": "..AtlasLocale["Blackrock Depths"], 1584 };
		Location = { AtlasLocale["Searing Gorge"].." / "..AtlasLocale["Burning Steppes"], 51, 46 };
		LevelRange = "52-58";
		MinLevel = "40";
		PlayerLimit = "5";
		Acronym = AtlasLocale["BRD"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Shadowforge Key"], ITEM, 11000 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Prison Cell Key"].." ("..AtlasLocale["Jail Break!"]..")", ITEM, 11140 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Lord Roccor"], NPC, 9025 };
		{ GREY.."2) "..AtlasLocale["Kharan Mighthammer"], NPC, 9021 };
		{ GREY.."3) "..AtlasLocale["Commander Gor'shak <Kargath Expeditionary Force>"], NPC, 9020 };
		{ GREY.."4) "..AtlasLocale["Marshal Windsor"], NPC, 9023 };
		{ GREY.."5) "..AtlasLocale["High Interrogator Gerstahn <Twilight's Hammer Interrogator>"], NPC, 9018 };
		{ GREY.."6) "..AtlasLocale["Ring of Law"] };
		{ GREY..INDENT..AtlasLocale["Anub'shiah"].." ("..AtlasLocale["Random"]..")", NPC, 9031 };
		{ GREY..INDENT..AtlasLocale["Eviscerator"].." ("..AtlasLocale["Random"]..")", NPC, 9029 };
		{ GREY..INDENT..AtlasLocale["Gorosh the Dervish"].." ("..AtlasLocale["Random"]..")", NPC, 9027 };
		{ GREY..INDENT..AtlasLocale["Grizzle"].." ("..AtlasLocale["Random"]..")", NPC, 9028 };
		{ GREY..INDENT..AtlasLocale["Hedrum the Creeper"].." ("..AtlasLocale["Random"]..")", NPC, 9032 };
		{ GREY..INDENT..AtlasLocale["Ok'thor the Breaker"].." ("..AtlasLocale["Random"]..")", NPC, 9030 };
		{ GREY..INDENT..AtlasLocale["Zuul"].." ("..AtlasLocale["Random"]..")", NPC, 999999 };
		{ GREY..INDENT..AtlasLocale["Twitches"].." ("..AtlasLocale["Random"]..")", NPC, 999999 };
		{ GREY..INDENT..AtlasLocale["Mecha-Chicken 3000"].." ("..AtlasLocale["Random"]..")", NPC, 999999 };
		{ GREY..INDENT..AtlasLocale["Theldren"].." ("..AtlasLocale["Summon"]..")", NPC, 16059 };
		{ GREY..INDENT..AtlasLocale["Lefty"], NPC, 16049 };
		{ GREY..INDENT..AtlasLocale["Malgen Longspear"], NPC, 16052 };
		{ GREY..INDENT..AtlasLocale["Gnashjaw <Malgen Longspear's Pet>"], NPC, 16095 };
		{ GREY..INDENT..AtlasLocale["Rotfang"], NPC, 16050 };
		{ GREY..INDENT..AtlasLocale["Va'jashni"], NPC, 16055 };
		{ GREY..INDENT..AtlasLocale["Houndmaster Grebmar"].." ("..AtlasLocale["Lower"]..")", NPC, 9319 };
		{ GREY..INDENT..AtlasLocale["Elder Morndeep"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15549 };
		{ GREY..INDENT..AtlasLocale["High Justice Grimstone"], NPC, 10096 };
		{ GREY.."7) "..AtlasLocale["Monument of Franclorn Forgewright"], OBJECT, 164689 };
		{ GREY..INDENT..AtlasLocale["Pyromancer Loregrain"], NPC, 9024 };
		{ GREY.."8) "..AtlasLocale["The Vault"] };
		{ GREY..INDENT..AtlasLocale["Warder Stilgiss"], NPC, 9041 };
		{ GREY..INDENT..AtlasLocale["Verek"], NPC, 9042 };
		{ GREY..INDENT..AtlasLocale["Watchman Doomgrip"], NPC, 9476 };
		{ GREY.."9) "..AtlasLocale["Fineous Darkvire <Chief Architect>"], NPC, 9056 };
		{ GREY.."10) "..AtlasLocale["The Black Anvil"] };
		{ GREY..INDENT..AtlasLocale["Lord Incendius"], NPC, 9017 };
		{ GREY.."11) "..AtlasLocale["Bael'Gar"], NPC, 9016 };
		{ GREY.."12) "..AtlasLocale["Shadowforge Lock"] };
		{ GREY.."13) "..AtlasLocale["General Angerforge"], NPC, 9033 };
		{ GREY.."14) "..AtlasLocale["Golem Lord Argelmach"], NPC, 8983 };
		{ GREY..INDENT..AtlasLocale["Field Repair Bot 74A"], NPC, 14337 };
		{ GREY..INDENT..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
		{ GREY.."15) "..AtlasLocale["The Grim Guzzler"] };
		{ GREY..INDENT..AtlasLocale["Hurley Blackbreath"], NPC, 9537 };
		{ GREY..INDENT..AtlasLocale["Lokhtos Darkbargainer <The Thorium Brotherhood>"], NPC, 12944 };
		{ GREY..INDENT..AtlasLocale["Mistress Nagmara"], NPC, 9500 };
		{ GREY..INDENT..AtlasLocale["Phalanx"], NPC, 9502 };
		{ GREY..INDENT..AtlasLocale["Plugger Spazzring"], NPC, 9499 };
		{ GREY..INDENT..AtlasLocale["Private Rocknot"], NPC, 9503 };
		{ GREY..INDENT..AtlasLocale["Ribbly Screwspigot"], NPC, 9543 };
		{ GREY..INDENT..AtlasLocale["Coren Direbrew"].." ("..AtlasLocale["Brewfest"]..")", NPC, 23872 };
		{ GREY.."16) "..AtlasLocale["Ambassador Flamelash"], NPC, 9156 };
		{ GREY.."17) "..AtlasLocale["Panzor the Invincible"].." ("..AtlasLocale["Rare"]..")", NPC, 8923 };
		{ GREY..INDENT..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
		{ GREY.."18) "..AtlasLocale["Summoner's Tomb"] };
		{ GREY.."19) "..AtlasLocale["The Lyceum"] };
		{ GREY.."20) "..AtlasLocale["Magmus"], NPC, 9938 };
		{ GREY.."21) "..AtlasLocale["Emperor Dagran Thaurissan"], NPC, 9019 };
		{ GREY..INDENT..AtlasLocale["Princess Moira Bronzebeard <Princess of Ironforge>"], NPC, 8929 };
		{ GREY..INDENT..AtlasLocale["High Priestess of Thaurissan"], NPC, 10076 };
		{ GREY.."22) "..AtlasLocale["The Black Forge"] };
		{ GREY.."23) "..AtlasLocale["Molten Core"], ZONE, 2717 };
		{ GREY..INDENT..AtlasLocale["Core Fragment"], OBJECT, 179553 };
		{ GREY.."24) "..AtlasLocale["Overmaster Pyron"], NPC, 9026 };
		{ GREY.."25) "..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
	};
	BlackrockSpireLower = {
		ZoneName = { AtlasLocale["Blackrock Mountain"]..": "..AtlasLocale["Blackrock Spire"].." ("..AtlasLocale["Lower"]..")", 1583 };
		Location = { AtlasLocale["Searing Gorge"].." / "..AtlasLocale["Burning Steppes"], 51, 46 };
		LevelRange = "54-60";
		MinLevel = "45";
		PlayerLimit = "5";
		Acronym = AtlasLocale["LBRS"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Blackrock Spire"].." ("..AtlasLocale["Upper"]..")", ZONE, 1583 };
		{ BLUE.."C-G) "..AtlasLocale["Connection"] };
		{ GREY.."1) "..AtlasLocale["Vaelan"].." ("..AtlasLocale["Upper"]..")", NPC, 10296 };
		{ GREY.."2) "..AtlasLocale["Warosh <The Cursed>"].." ("..AtlasLocale["Wanders"]..")", NPC, 10799 };
		{ GREY..INDENT..AtlasLocale["Elder Stonefort"], NPC, 15560 };
		{ GREY.."3) "..AtlasLocale["Roughshod Pike"], OBJECT, 175886 };
		{ GREY.."4) "..AtlasLocale["Spirestone Butcher"].." ("..AtlasLocale["Rare"]..")", NPC, 9219 };
		{ GREY.."5) "..AtlasLocale["Highlord Omokk"], NPC, 9196 };
		{ GREY.."6) "..AtlasLocale["Spirestone Battle Lord"].." ("..AtlasLocale["Rare"]..")", NPC, 9218 };
		{ GREY..INDENT..AtlasLocale["Spirestone Lord Magus"].." ("..AtlasLocale["Rare"]..")", NPC, 9217 };
		{ GREY.."7) "..AtlasLocale["Shadow Hunter Vosh'gajin"], NPC, 9236 };
		{ GREY..INDENT..AtlasLocale["Fifth Mosh'aru Tablet"], OBJECT, 175949 };
		{ GREY.."8) "..AtlasLocale["Bijou"], NPC, 10257 };
		{ GREY.."9) "..AtlasLocale["War Master Voone"], NPC, 9237 };
		{ GREY..INDENT..AtlasLocale["Mor Grayhoof"].." ("..AtlasLocale["Summon"]..")", NPC, 16080 };
		{ GREY..INDENT..AtlasLocale["Sixth Mosh'aru Tablet"], OBJECT, 175950 };
		{ GREY.."10) "..AtlasLocale["Human Remains"].." ("..AtlasLocale["Lower"]..")", OBJECT, 176090 };
		{ GREY..INDENT..AtlasLocale["Unfired Plate Gauntlets"].." ("..AtlasLocale["Lower"]..")", OBJECT, 176089 };
		{ GREY.."11) "..AtlasLocale["Bannok Grimaxe <Firebrand Legion Champion>"].." ("..AtlasLocale["Rare"]..")", NPC, 9596 };
		{ GREY.."12) "..AtlasLocale["Bijou's Belongings"].." ("..AtlasLocale["Lower"]..")", OBJECT, 175334 };
		{ GREY.."13) "..AtlasLocale["Mother Smolderweb"], NPC, 10596 };
		{ GREY.."14) "..AtlasLocale["Crystal Fang"].." ("..AtlasLocale["Rare"]..")", NPC, 10376 };
		{ GREY.."15) "..AtlasLocale["Urok's Tribute Pile"], OBJECT, 175621 };
		{ GREY..INDENT..AtlasLocale["Urok Doomhowl"].." ("..AtlasLocale["Summon"]..")", NPC, 10584 };
		{ GREY.."16) "..AtlasLocale["Quartermaster Zigris <Bloodaxe Legion>"], NPC, 9736 };
		{ GREY.."17) "..AtlasLocale["Halycon"], NPC, 10220 };
		{ GREY..INDENT..AtlasLocale["Gizrul the Slavener"], NPC, 10268 };
		{ GREY.."18) "..AtlasLocale["Ghok Bashguud <Bloodaxe Champion>"].." ("..AtlasLocale["Rare"]..")", NPC, 9718 };
		{ GREY.."19) "..AtlasLocale["Overlord Wyrmthalak"], NPC, 9568 };
		{ GREN.."1') "..AtlasLocale["Burning Felguard"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Summon"]..")", NPC, 10263 };
	};
	BlackrockSpireUpper = {
		ZoneName = { AtlasLocale["Blackrock Mountain"]..": "..AtlasLocale["Blackrock Spire"].." ("..AtlasLocale["Upper"]..")", 1583 };
		Location = { AtlasLocale["Searing Gorge"].." / "..AtlasLocale["Burning Steppes"], 51, 46 };
		LevelRange = "56-61";
		MinLevel = "45";
		PlayerLimit = "5";
		Acronym = AtlasLocale["UBRS"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Blackrock Spire"].." ("..AtlasLocale["Lower"]..")", ZONE, 1583 };
		{ BLUE.."C-D) "..AtlasLocale["Connection"] };
		{ GREY.."1) "..AtlasLocale["Pyroguard Emberseer"], NPC, 9816 };
		{ GREY.."2) "..AtlasLocale["Solakar Flamewreath"], NPC, 10264 };
		{ GREY..INDENT..AtlasLocale["Father Flame"], OBJECT, 175245 };
		{ GREY.."3) "..AtlasLocale["Darkstone Tablet"], OBJECT, 175385 };
		{ GREY..INDENT..AtlasLocale["Doomrigger's Coffer"], OBJECT, 175382 };
		{ GREY.."4) "..AtlasLocale["Jed Runewatcher <Blackhand Legion>"].." ("..AtlasLocale["Rare"]..")", NPC, 10509 };
		{ GREY.."5) "..AtlasLocale["Goraluk Anvilcrack <Blackhand Legion Armorsmith>"], NPC, 10899 };
		{ GREY.."6) "..AtlasLocale["Warchief Rend Blackhand"], NPC, 10429 };
		{ GREY..INDENT..AtlasLocale["Gyth <Rend Blackhand's Mount>"], NPC, 10339 };
		{ GREY.."7) "..AtlasLocale["Awbee"], NPC, 10740 };
		{ GREY.."8) "..AtlasLocale["The Beast"], NPC, 10430 };
		{ GREY..INDENT..AtlasLocale["Lord Valthalak"].." ("..AtlasLocale["Summon"]..")", NPC, 16042 };
		{ GREY..INDENT..AtlasLocale["Finkle Einhorn"], NPC, 10776 };
		{ GREY.."9) "..AtlasLocale["General Drakkisath"], NPC, 10363 };
		{ GREY..INDENT..AtlasLocale["Drakkisath's Brand"], OBJECT, 179880 };
	};
	GlittermurkMines = {
		ZoneName = { AtlasLocale["Glittermurk Mines"], 2057 };
		Location = { AtlasLocale["Stranglethorn Vale"], 33 };
		LevelRange = "39-44";
		MinLevel = "??";
		PlayerLimit = "5";
		Acronym = AtlasLocale["GMM"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Exit"] };
		{ GREY.."1) "..AtlasLocale["Supervisor Grimgash"], NPC, 999999 };
		{ GREY.."2) "..AtlasLocale["Krakken"], NPC, 999999 };
		{ GREY.."3) "..AtlasLocale["Prismscale"], NPC, 999999 };
		{ GREY.."4) "..AtlasLocale["Foreman Sprocket"], NPC, 999999 };
		{ GREY.."5) "..AtlasLocale["Miner Davod"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Varies"]..")", NPC, 999999 };
		{ GREY.."6) "..AtlasLocale["Murklurk"], NPC, 999999 };
		{ GREY.."7) "..AtlasLocale["Gnash"], NPC, 999999 };
	};
	Gnomeregan = {
		ZoneName = { AtlasLocale["Gnomeregan"], 133 };
		Location = { AtlasLocale["Dun Morogh"], 1 };
		LevelRange = "24-32";
		MinLevel = "20";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Gnome"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Workshop Key"].." ("..AtlasLocale["Back"]..")", ITEM, 6893 };
		{ BLUE.."A) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Front"]..")" };
		{ BLUE.."B) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Back"]..")" };
		{ GREY.."1) "..AtlasLocale["Blastmaster Emi Shortfuse"], NPC, 7998 };
		{ GREY..INDENT..AtlasLocale["Grubbis"], NPC, 7361 };
		{ GREY..INDENT..AtlasLocale["Chomper"], NPC, 6215 };
		{ GREY.."2) "..AtlasLocale["Clean Room"] };
		{ GREY..INDENT..AtlasLocale["Tink Sprocketwhistle <Engineering Supplies>"], NPC, 9676 };
		{ GREY..INDENT..AtlasLocale["The Sparklematic 5200"], OBJECT, 142487 };
		{ GREY..INDENT..AtlasLocale["Mail Box"] };
		{ GREY.."3) "..AtlasLocale["Kernobee"], NPC, 7850 };
		{ GREY..INDENT..AtlasLocale["Alarm-a-bomb 2600"], NPC, 7897 };
		{ GREY..INDENT..AtlasLocale["Matrix Punchograph 3005-B"], OBJECT, 142475 };
		{ GREY.."4) "..AtlasLocale["Viscous Fallout"], NPC, 7079 };
		{ GREY.."5) "..AtlasLocale["Electrocutioner 6000"], NPC, 6235 };
		{ GREY..INDENT..AtlasLocale["Matrix Punchograph 3005-C"], OBJECT, 142476 };
		{ GREY.."6) "..AtlasLocale["Crowd Pummeler 9-60"].." ("..AtlasLocale["Upper"]..")", NPC, 6229 };
		{ GREY..INDENT..AtlasLocale["Matrix Punchograph 3005-D"], OBJECT, 142696 };
		{ GREY.."7) "..AtlasLocale["Dark Iron Ambassador"], NPC, 6228 };
		{ GREY.."8) "..AtlasLocale["Mekgineer Thermaplugg"], NPC, 7800 };
	};
	MoltenCore = {
		ZoneName = { AtlasLocale["Blackrock Mountain"]..": "..AtlasLocale["Molten Core"], 2717 };
		Location = { AtlasLocale["Searing Gorge"].." / "..AtlasLocale["Burning Steppes"], 51, 46 };
		LevelRange = "60-70";
		MinLevel = "50";
		PlayerLimit = "25";
		Acronym = AtlasLocale["MC"];
		{ ORNG..AtlasLocale["Attunement Required"] };
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Hydraxian Waterlords"], FACTION, 749 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Lucifron"], NPC, 12118 };
		{ GREY.."2) "..AtlasLocale["Magmadar"], NPC, 11982 };
		{ GREY.."3) "..AtlasLocale["Gehennas"], NPC, 12259 };
		{ GREY.."4) "..AtlasLocale["Garr"], NPC, 12057 };
		{ GREY.."5) "..AtlasLocale["Shazzrah"], NPC, 12264 };
		{ GREY.."6) "..AtlasLocale["Baron Geddon"], NPC, 12056 };
		{ GREY.."7) "..AtlasLocale["Golemagg the Incinerator"], NPC, 11988 };
		{ GREY.."8) "..AtlasLocale["Sulfuron Harbinger"], NPC, 12098 };
		{ GREY.."9) "..AtlasLocale["Majordomo Executus"], NPC, 12018 };
		{ GREY.."10) "..AtlasLocale["Ragnaros"], NPC, 11502 };
	};
	SMLibrary = {
		ZoneName = { AtlasLocale["Scarlet Monastery"]..": "..AtlasLocale["Library"], 796 };
		Location = { AtlasLocale["Tirisfal Glades"], 85 };
		LevelRange = "31-37";
		MinLevel = "20";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Lib"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Houndmaster Loksey"], NPC, 3974 };
		{ GREY.."2) "..AtlasLocale["Arcanist Doan"], NPC, 6487 };
	};
	SMArmory = {
		ZoneName = { AtlasLocale["Scarlet Monastery"]..": "..AtlasLocale["Armory"], 796 };
		Location = { AtlasLocale["Tirisfal Glades"], 85 };
		LevelRange = "33-40";
		MinLevel = "20";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Armory"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["The Scarlet Key"], ITEM, 7146 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Herod <The Scarlet Champion>"], NPC, 3975 };
	};
	SMCathedral = {
		ZoneName = { AtlasLocale["Scarlet Monastery"]..": "..AtlasLocale["Cathedral"], 796 };
		Location = { AtlasLocale["Tirisfal Glades"], 85 };
		LevelRange = "36-42";
		MinLevel = "20";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Cath"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["The Scarlet Key"], ITEM, 7146 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["High Inquisitor Fairbanks"], NPC, 4542 };
		{ GREY.."2) "..AtlasLocale["Scarlet Commander Mograine"], NPC, 3976 };
		{ GREY..INDENT..AtlasLocale["High Inquisitor Whitemane"], NPC, 3977 };
	};
	SMGraveyard = {
		ZoneName = { AtlasLocale["Scarlet Monastery"]..": "..AtlasLocale["Graveyard"], 796 };
		Location = { AtlasLocale["Tirisfal Glades"], 85 };
		LevelRange = "28-35";
		MinLevel = "20";
		PlayerLimit = "5";
		Acronym = AtlasLocale["GY"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Interrogator Vishas"], NPC, 3983 };
		{ GREY..INDENT..AtlasLocale["Vorrel Sengutz"], NPC, 3981 };
		{ GREY.."2) "..AtlasLocale["Pumpkin Shrine"].." ("..AtlasLocale["Hallow's End"]..")", OBJECT, 186267 };
		{ GREY.."3) "..AtlasLocale["Bloodmage Thalnos"], NPC, 4543 };
		{ GREN.."1') "..AtlasLocale["Ironspine"].." ("..AtlasLocale["Rare"]..")", NPC, 6489 };
		{ GREN..INDENT..AtlasLocale["Azshir the Sleepless"].." ("..AtlasLocale["Rare"]..")", NPC, 6490 };
		{ GREN..INDENT..AtlasLocale["Fallen Champion"].." ("..AtlasLocale["Rare"]..")", NPC, 6488 };
	};
	Scholomance = {
		ZoneName = { AtlasLocale["Scholomance"], 2057 };
		Location = { AtlasLocale["Western Plaguelands"], 28 };
		LevelRange = "58-60";
		MinLevel = "45";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Scholo"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Argent Dawn"], FACTION, 529 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Skeleton Key"], ITEM, 13704 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Viewing Room Key"].." ("..AtlasLocale["Viewing Room"]..")", ITEM, 13873 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Connection"] };
		{ BLUE.."C) "..AtlasLocale["Connection"] };
		{ GREY.."1) "..AtlasLocale["Blood Steward of Kirtonos"], NPC, 14861 };
		{ GREY..INDENT..AtlasLocale["The Deed to Southshore"], OBJECT, 176486 };
		{ GREY.."2) "..AtlasLocale["Kirtonos the Herald"].." ("..AtlasLocale["Summon"]..")", NPC, 10506 };
		{ GREY.."3) "..AtlasLocale["Jandice Barov"], NPC, 10503 };
		{ GREY.."4) "..AtlasLocale["The Deed to Tarren Mill"], OBJECT, 176487 };
		{ GREY.."5) "..AtlasLocale["Rattlegore"].." ("..AtlasLocale["Lower"]..")", NPC, 11622 };
		{ GREY..INDENT..AtlasLocale["Death Knight Darkreaver"].." ("..AtlasLocale["Summon"]..")", NPC, 14516 };
		{ GREY.."6) "..AtlasLocale["Marduk Blackpool"], NPC, 10433 };
		{ GREY..INDENT..AtlasLocale["Vectus"], NPC, 10432 };
		{ GREY.."7) "..AtlasLocale["Ras Frostwhisper"], NPC, 10508 };
		{ GREY..INDENT..AtlasLocale["The Deed to Brill"], OBJECT, 176484 };
		{ GREY..INDENT..AtlasLocale["Kormok"].." ("..AtlasLocale["Summon"]..")", NPC, 16118 };
		{ GREY.."8) "..AtlasLocale["Instructor Malicia"], NPC, 10505 };
		{ GREY.."9) "..AtlasLocale["Doctor Theolen Krastinov <The Butcher>"], NPC, 11261 };
		{ GREY.."10) "..AtlasLocale["Lorekeeper Polkelt"], NPC, 10901 };
		{ GREY.."11) "..AtlasLocale["The Ravenian"], NPC, 10507 };
		{ GREY.."12) "..AtlasLocale["Lord Alexei Barov"], NPC, 10504 };
		{ GREY..INDENT..AtlasLocale["The Deed to Caer Darrow"], OBJECT, 176485 };
		{ GREY.."13) "..AtlasLocale["Lady Illucia Barov"], NPC, 10502 };
		{ GREY..INDENT..AtlasLocale["Classic shared Basement Loot"], OBJECT, 999999 };
		{ GREY.."14) "..AtlasLocale["Darkmaster Gandling"], NPC, 1853 };
		{ GREN.."1') "..AtlasLocale["Torch Lever"] };
		{ GREN.."2') "..AtlasLocale["Secret Chest"] };
		{ GREN.."3') "..AtlasLocale["Alchemy Lab"] };
	};
	ShadowfangKeep = {
		ZoneName = { AtlasLocale["Shadowfang Keep"], 209 };
		Location = { AtlasLocale["Silverpine Forest"], 130 };
		LevelRange = "17-25";
		MinLevel = "10";
		PlayerLimit = "5";
		Acronym = AtlasLocale["SFK"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Rethilgore <The Cell Keeper>"], NPC, 3914 };
		{ GREY..INDENT..AtlasLocale["Sorcerer Ashcrombe"], NPC, 3850 };
		{ GREY..INDENT..AtlasLocale["Deathstalker Adamant"], NPC, 3849 };
		{ GREY..INDENT..AtlasLocale["Landen Stilwell"], NPC, 17822 };
		{ GREY.."2) "..AtlasLocale["Deathstalker Vincent"], NPC, 4444 };
		{ GREY.."3) "..AtlasLocale["Fel Steed"], NPC, 3864 };
		{ GREY..INDENT..AtlasLocale["Jordan's Hammer"], OBJECT, 91138 };
		{ GREY..INDENT..AtlasLocale["Crate of Ingots"], OBJECT, 182011 };
		{ GREY.."4) "..AtlasLocale["Razorclaw the Butcher"], NPC, 3886 };
		{ GREY.."5) "..AtlasLocale["Baron Silverlaine"], NPC, 3887 };
		{ GREY.."6) "..AtlasLocale["Commander Springvale"], NPC, 4278 };
		{ GREY.."7) "..AtlasLocale["Odo the Blindwatcher"], NPC, 4279 };
		{ GREY.."8) "..AtlasLocale["Deathsworn Captain"].." ("..AtlasLocale["Rare"]..")", NPC, 3872 };
		{ GREY.."9) "..AtlasLocale["Fenrus the Devourer"], NPC, 4274 };
		{ GREY..INDENT..AtlasLocale["Arugal's Voidwalker"], NPC, 4627 };
		{ GREY..INDENT..AtlasLocale["The Book of Ur"], OBJECT, 36738 };
		{ GREY.."10) "..AtlasLocale["Wolf Master Nandos"], NPC, 3927 };
		{ GREY.."11) "..AtlasLocale["Archmage Arugal"], NPC, 4275 };
		{ GREY.."12) "..AtlasLocale["Steward Graves"].." ("..AtlasLocale["Rare"]..")", NPC, 999999 };
	};
	Stratholme = {
		ZoneName = { AtlasLocale["Stratholme"], 2017 };
		Location = { AtlasLocale["Eastern Plaguelands"], 139 };
		LevelRange = "58-60";
		MinLevel = "45";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Strat"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Argent Dawn"], FACTION, 529 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["The Scarlet Key"].." ("..AtlasLocale["Living Side"]..")", ITEM, 7146 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Key to the City"].." ("..AtlasLocale["Undead Side"]..")", ITEM, 12382 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Various Postbox Keys"].." ("..AtlasLocale["Postmaster Malown"]..")" };
		{ BLUE.."A) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Front"]..")" };
		{ BLUE.."B) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Side"]..")" };
		{ GREY.."1) "..AtlasLocale["Skul"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Varies"]..")", NPC, 10393 };
		{ GREY..INDENT..AtlasLocale["Stratholme Courier"], NPC, 11082 };
		{ GREY..INDENT..AtlasLocale["Fras Siabi"], NPC, 11058 };
		{ GREY.."3) "..AtlasLocale["Hearthsinger Forresten"].." ("..AtlasLocale["Varies"]..")", NPC, 10558 };
		{ GREY.."4) "..AtlasLocale["The Unforgiven"], NPC, 10516 };
		{ GREY.."5) "..AtlasLocale["Elder Farwhisper"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15607 };
		{ GREY.."6) "..AtlasLocale["Timmy the Cruel"], NPC, 10808 };
		{ GREY.."7) "..AtlasLocale["Malor the Zealous"], NPC, 11032 };
		{ GREY..INDENT..AtlasLocale["Malor's Strongbox"], OBJECT, 176112 };
		{ GREY.."8) "..AtlasLocale["Crimson Hammersmith"].." ("..AtlasLocale["Summon"]..")", NPC, 11120 };
		{ GREY..INDENT..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
		{ GREY.."9) "..AtlasLocale["Cannon Master Willey"], NPC, 10997 };
		{ GREY.."10) "..AtlasLocale["Archivist Galford"], NPC, 10811 };
		{ GREY.."11) "..AtlasLocale["Grand Crusader Dathrohan"], NPC, 10812 };
		{ GREY..INDENT..AtlasLocale["Balnazzar"], NPC, 10813 };
		{ GREY..INDENT..AtlasLocale["Sothos"].." ("..AtlasLocale["Summon"]..")", NPC, 16102 };
		{ GREY..INDENT..AtlasLocale["Jarien"].." ("..AtlasLocale["Summon"]..")", NPC, 16101 };
		{ GREY.."12) "..AtlasLocale["Magistrate Barthilas"].." ("..AtlasLocale["Varies"]..")", NPC, 10435 };
		{ GREY.."13) "..AtlasLocale["Aurius"], NPC, 10917 };
		{ GREY.."14) "..AtlasLocale["Stonespine"].." ("..AtlasLocale["Rare"]..")", NPC, 10809 };
		{ GREY.."15) "..AtlasLocale["Baroness Anastari"], NPC, 10436 };
		{ GREY..INDENT..AtlasLocale["Black Guard Swordsmith"].." ("..AtlasLocale["Summon"]..")", NPC, 11121 };
		{ GREY..INDENT..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
		{ GREY.."16) "..AtlasLocale["Nerub'enkan"], NPC, 10437 };
		{ GREY.."17) "..AtlasLocale["Maleki the Pallid"], NPC, 10438 };
		{ GREY.."18) "..AtlasLocale["Ramstein the Gorger"], NPC, 10439 };
		{ GREY.."19) "..AtlasLocale["Baron Rivendare"], NPC, 10440 };
		{ GREY..INDENT..AtlasLocale["Ysida Harmon"], NPC, 16031 };
		{ GREN.."1') "..AtlasLocale["Crusaders' Square Postbox"] };
		{ GREN.."2') "..AtlasLocale["Market Row Postbox"] };
		{ GREN.."3') "..AtlasLocale["Festival Lane Postbox"] };
		{ GREN.."4') "..AtlasLocale["Elders' Square Postbox"] };
		{ GREN.."5') "..AtlasLocale["King's Square Postbox"] };
		{ GREN.."6') "..AtlasLocale["Fras Siabi's Postbox"] };
		{ GREN..AtlasLocale["3rd Box Opened"]..": "..AtlasLocale["Postmaster Malown"], NPC, 11143 };
	};
	TheDeadmines = {
		ZoneName = { AtlasLocale["The Deadmines"], 1581 };
		Location = { AtlasLocale["Westfall"], 40 };
		LevelRange = "16-22";
		MinLevel = "10";
		PlayerLimit = "5";
		Acronym = AtlasLocale["VC"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Exit"] };
		{ GREY.."1) "..AtlasLocale["Rizzo"], NPC, 999999 };
		{ GREY.."2) "..AtlasLocale["Rhahk'Zor <The Foreman>"], NPC, 644 };
		{ GREY.."3) "..AtlasLocale["Miner Johnson"].." ("..AtlasLocale["Rare"]..")", NPC, 3586 };
		{ GREY.."4) "..AtlasLocale["Sneed <Lumbermaster>"], NPC, 643 };
		{ GREY..INDENT..AtlasLocale["Sneed's Shredder <Lumbermaster>"], NPC, 642 };
		{ GREY.."5) "..AtlasLocale["Gilnid <The Smelter>"], NPC, 1763 };
		{ GREY.."6) "..AtlasLocale["Mr. Smite <The Ship's First Mate>"], NPC, 646 };
		{ GREY.."7) "..AtlasLocale["Scinti"], NPC, 999999 };
		{ GREY.."7) "..AtlasLocale["Captain Greenskin"], NPC, 647 };
		{ GREY.."7) "..AtlasLocale["Edwin VanCleef <Defias Kingpin>"], NPC, 639 };
		{ GREY.."8) "..AtlasLocale["Cookie <The Ship's Cook>"], NPC, 645 };
	};
	TheStockade = {
		ZoneName = { AtlasLocale["The Stockade"], 717 };
		Location = { AtlasLocale["Stormwind City"], 1519 };
		LevelRange = "21-27";
		MinLevel = "15";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Stocks"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Targorr the Dread"].." ("..AtlasLocale["Varies"]..")", NPC, 1696 };
		{ GREY.."2) "..AtlasLocale["Kam Deepfury"], NPC, 1666 };
		{ GREY.."3) "..AtlasLocale["Hamhock"], NPC, 1717 };
		{ GREY.."4) "..AtlasLocale["Bazil Thredd"], NPC, 1716 };
		{ GREY.."5) "..AtlasLocale["Dextren Ward"], NPC, 1663 };
		{ GREY.."6) "..AtlasLocale["Bruegal Ironknuckle"].." ("..AtlasLocale["Rare"]..")", NPC, 1720 };
	};
	TheSunkenTemple = {
		ZoneName = { AtlasLocale["Sunken Temple"], 1417 };
		Location = { AtlasLocale["Swamp of Sorrows"], 8 };
		LevelRange = "46-53";
		MinLevel = "35";
		PlayerLimit = "5";
		Acronym = AtlasLocale["ST"];
		{ ORNG..AtlasLocale["AKA"]..": "..AtlasLocale["The Temple of Atal'Hakkar"] };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B-I) "..AtlasLocale["Connection"] };
		{ GREY.."1) "..AtlasLocale["Altar of Hakkar"], OBJECT, 148836 };
		{ GREY..INDENT..AtlasLocale["Atal'alarion <Guardian of the Idol>"], NPC, 8580 };
		{ GREY.."2) "..AtlasLocale["Dreamscythe"], NPC, 5721 };
		{ GREY..INDENT..AtlasLocale["Weaver"], NPC, 5720 };
		{ GREY.."3) "..AtlasLocale["Avatar of Hakkar"], NPC, 8443 };
		{ GREY.."4) "..AtlasLocale["Jammal'an the Prophet"], NPC, 5710 };
		{ GREY..INDENT..AtlasLocale["Ogom the Wretched"], NPC, 5711 };
		{ GREY.."5) "..AtlasLocale["Morphaz"], NPC, 5719 };
		{ GREY..INDENT..AtlasLocale["Hazzas"], NPC, 5722 };
		{ GREY.."6) "..AtlasLocale["Shade of Eranikus"], NPC, 5709 };
		{ GREY..INDENT..AtlasLocale["Essence Font"], OBJECT, 148512 };
		{ GREY.."7) "..AtlasLocale["Spawn of Hakkar"].." ("..AtlasLocale["Rare"]..")", NPC, 5708 };
		{ GREY.."8) "..AtlasLocale["Elder Starsong"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15593 };
		{ GREN.."1'-6') "..AtlasLocale["Statue Activation Order"] };
		{ GREN.."7') "..AtlasLocale["Atal'ai Defenders"] };
		{ GREN..INDENT..AtlasLocale["Gasher"], NPC, 5713 };
		{ GREN..INDENT..AtlasLocale["Loro"], NPC, 5714 };
		{ GREN..INDENT..AtlasLocale["Hukku"], NPC, 5715 };
		{ GREN..INDENT..AtlasLocale["Zolo"], NPC, 5712 };
		{ GREN..INDENT..AtlasLocale["Mijan"], NPC, 5717 };
		{ GREN..INDENT..AtlasLocale["Zul'Lor"], NPC, 5716 };
	};
	Uldaman = {
		ZoneName = { AtlasLocale["Uldaman"], 1337 };
		Location = { AtlasLocale["Badlands"], 3 };
		LevelRange = "36-42";
		MinLevel = "30";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Ulda"];
		{ BLUE.."A) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Front"]..")" };
		{ BLUE.."B) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Back"]..")" };
		{ GREY.."1) "..AtlasLocale["Baelog"], NPC, 6906 };
		{ GREY..INDENT..AtlasLocale["Eric \"The Swift\""], NPC, 6907 };
		{ GREY..INDENT..AtlasLocale["Olaf"], NPC, 6908 };
		{ GREY..INDENT..AtlasLocale["Conspicuous Urn"], OBJECT, 125477 };
		{ GREY.."2) "..AtlasLocale["Remains of a Paladin"], NPC, 6912 };
		{ GREY.."3) "..AtlasLocale["Revelosh"], NPC, 6910 };
		{ GREY.."4) "..AtlasLocale["Ironaya"], NPC, 7228 };
		{ GREY.."5) "..AtlasLocale["Obsidian Sentinel"], NPC, 7023 };
		{ GREY.."6) "..AtlasLocale["Annora <Enchanting Trainer>"], NPC, 11073 };
		{ GREY.."7) "..AtlasLocale["Ancient Stone Keeper"], NPC, 7206 };
		{ GREY.."8) "..AtlasLocale["Galgann Firehammer"], NPC, 7291 };
		{ GREY..INDENT..AtlasLocale["Tablet of Will"], OBJECT, 142088 };
		{ GREY..INDENT..AtlasLocale["Shadowforge Cache"], OBJECT, 113757 };
		{ GREY.."9) "..AtlasLocale["Grimlok <Stonevault Chieftain>"], NPC, 4854 };
		{ GREY.."10) "..AtlasLocale["Archaedas <Ancient Stone Watcher>"].." ("..AtlasLocale["Lower"]..")", NPC, 2748 };
		{ GREY.."11) "..AtlasLocale["The Discs of Norgannon"].." ("..AtlasLocale["Lower"]..")", OBJECT, 131474 };
		{ GREY..INDENT..AtlasLocale["Ancient Treasure"].." ("..AtlasLocale["Lower"]..")", OBJECT, 141979 };
	};
};