local _, GBB = GroupBulletinBoard_Loader.Main()

-- IMPORTANT, everything must be in low-case and with no space!

local function langSplit( source )
  local ret = {}
  for lang, pat in pairs( source ) do
    if pat ~= "-" then
      ret[ lang ] = GBB.Tool.Split( pat, " " )
    end
  end
  return ret
end

GBB.suffixTagsLoc = langSplit( {
  enGB = "s group run runs",
  deDE = "gruppe",
  ruRU = "группран фарм фарма фармить",
  frFR = "groupe",
  zhTW = "",
} )

GBB.searchTagsLoc = langSplit( {
  enGB =
  "group lfg lf lfm lf1m lf2m lf3m lf4m lf5m lftank lfheal lfhealer lfdps lfdd dd heal healer tank dps druid dudu huntard hunter mage pala pally paladin priest rogue rouge shaman lock warlock warrior elite quest elitequest elitequests",

  deDE =
  "gesucht suche suchen sucht such gruppe grp sfg sfm druide dudu jäger magier priester warri schurke rschami schamane hexer hexenmeister hm krieger heiler xheiler go run",

  ruRU = "лфг ищет ищу нид нужны лфм лф2м ищем пати похилю лф танк хил нужен дд рдд мдд ршам рога вар прист армс пал",
  frFR = "groupe cherche chasseur druide mage paladin pretre voleur chaman quete",

  zhTW = "缺 來 找 徵 坦 補 DD 輸出 戰 聖 薩 獵 德 賊 法 牧 術",
} )

GBB.badTagsLoc = langSplit( {
  enGB = "layer boost",
  deDE = "fc",
  ruRU = "гильдию гильдия слой",
  frFR = "",
  zhTW = "影布 回流",
} )

GBB.heroicTagsLoc = langSplit( {
  enGB = "h hc heroic hero",
  deDE = "h hc heroic hero",
  ruRU = "гер героик",
  frFR = "h hc heroic hm hero",
  zhTW = "h 英雄",
} )



GBB.dungeonTagsLoc = {
  enGB = langSplit( {
    [ "RFC" ]    = "rfc ragefire chasm",
    [ "DM" ]     = "dm deadmines vancleef vc",
    [ "WC" ]     = "wc wailing wailingcaverns",
    [ "SFK" ]    = "sfk shadowfang",
    [ "STOCKS" ] = "stk stock stocks stockade stockades",
    [ "BFD" ]    = "bfd blackfathom fathom",
    [ "GNOMER" ] = "gnomer gnomeregan",
    [ "RFK" ]    = "rfk kraul",
    [ "SM2" ]    = "sm scarlet monastery",
    [ "GY" ]     = "gy smgy graveyard",
    [ "LIB" ]    = "lib smlib library",
    [ "ARMS" ]   = "armory smarmory armoury arms",
    [ "CATH" ]   = "cath smcath cathedral",
    [ "RFD" ]    = "rfd downs",
    [ "ULDA" ]   = "uld ulda uldaman",
    [ "ZF" ]     = "zf zul farrak zul'farrak zulfarrak zulfarak",
    [ "MARA" ]   = "mara maraudon maraorange marapurple maraprincess",
    [ "ST" ]     = "st sunken atal temple",
    [ "BRD" ]    = "brd brdarena brdemp",
    [ "DM2" ]    = "dire maul diremaul",
    [ "DME" ]    = "dme dmeast east",
    [ "DMN" ]    = "dmn dmnorth north tribute",
    [ "DMW" ]    = "dmw dmwest west",
    [ "STRAT" ]  = "stratlive live living stratud ud baron stratholme strath strat",
    [ "SCHOLO" ] = "scholomance scholo",
    [ "LBRS" ]   = "lower lbrs",
    [ "UBRS" ]   = "upper ubrs",
    [ "RAMPS" ]  = "ramparts rampart ramp ramps",
    [ "BF" ]     = "furnace furn bf",
    [ "SP" ]     = "slavepens pens sp",
    [ "UB" ]     = "underbog ub",
    [ "MT" ]     = "manatombs mana mt tomb tombs",
    [ "AC" ]     = "crypts crypt auchenai ac",
    [ "SH" ]     = "sh sethekk seth sethek",
    [ "OHF" ]    = "ohf durnholde hillsbrad",
    [ "MECHA" ]  = "mecha mech mechanar",
    [ "BM" ]     = "morass bm black",
    [ "MGT" ]    = "mgt terrace magisters magister",
    [ "SHH" ]    = "shh shattered",
    [ "BOTA" ]   = "botanica bota",
    [ "SL" ]     = "sl slabs",
    [ "SV" ]     = "sv steamvault steamvaults steam vault",
    [ "ARCA" ]   = "arca arcatraz",
    [ "KARA" ]   = "kara karazhan",
    [ "GRUULS" ] = "gl gruul gruuls gruul's",
    [ "MAGS" ]   = "mag mags magtheridon magtheridon's",
    [ "SSC" ]    = "ssc serpentshrine",
    [ "ZA" ]     = "za zulaman zul'aman",
    [ "EYE" ]    = "eye tk",
    [ "HYJAL" ]  = "hyjal mh",
    [ "BT" ]     = "bt",
    [ "SWP" ]    = "swp sunwell plateau",
    [ "ONY" ]    = "onyxia ony onaxxia",
    [ "MC" ]     = "molten core mc",
    [ "ZG" ]     = "zg gurub zul'gurub zulgurub",
    [ "AQ20" ]   = "aq20",
    [ "BWL" ]    = "blackwing bwl",
    [ "AQ40" ]   = "aq40",
    [ "NAXX" ]   = "naxxramas naxx",
    [ "WSG" ]    = "wsg",
    [ "AB" ]     = "ab",
    [ "AV" ]     = "av",
    [ "EOTS" ]   = "eots",
    [ "ARENA" ]  = "2s 3s 5s 3v3 5v5 2v2 2vs2 3vs3 5vs5",
    [ "BREW" ]   = "brewfest coren direbrew",
    [ "HOLLOW" ] = "headless horseman",
    [ "TRADE" ]  = "buy buying sell selling wts wtb hitem henchant htrade enchanter", --hlink
    [ "GM" ]     = "glittermurk glitter gm ggm gmm glittermurk",
    [ "BH" ]     = "baradin hold bh baradinhold",
    [ "SC" ]     = "stonetalon sc stonetaloncaverns",
  } ),
  deDE = langSplit( {
    [ "RFC" ]    = "rfa ragefireabgrund flammenschlund flamenschlund rf rfg",
    [ "DM" ]     = "todesminen todesmine tm",
    [ "WC" ]     = "hdw wehklagens",
    [ "SFK" ]    = "burg bsf schattenfang",
    [ "STOCKS" ] = "verlies verließ verliess",
    [ "BFD" ]    = "bft blackfathomtiefen tiefschwarze grotte tsg",
    --["GNOMER"] =  	{} ,
    [ "RFK" ]    = "kral krall karl",
    [ "GY" ]     = "friedhof hof fh freidhof",
    [ "LIB" ]    = "bibli bibi bibliothek bib bücherei bibo biblio biblo bibl",
    [ "SM2" ]    = "kloster",
    [ "ARMS" ]   = "wk waffenkammer arsenal",
    [ "CATH" ]   = "kathe kathedrale kath katha kahte",
    [ "RFD" ]    = "hügel huegel",
    [ "ULDA" ]   = "uldamann",
    --["ZF"]  = 	{} ,
    [ "MARA" ]   = "prinzessinnenrun prinzessinenrun prinzessinrun prinzessrun",
    [ "ST" ]     = "tempel",
    [ "BRD" ]    = "blackrocktiefen blackrock brt imperator imp",
    [ "DM2" ]    = "düsterbruch duesterbruch db",
    [ "DME" ]    = "ost dbo dbost",
    [ "DMN" ]    = "tribut dbn nord dbnord",
    [ "DMW" ]    = "dbw dbwest",
    [ "STRAT" ]  = "lebend untot",
    --["SCHOLO"] = 	{},
    --["LBRS"] = 	{},
    --["UBRS"] =	{},
    --["ONY"] = 	{},
    [ "MC" ]     = "kern",
    --["ZG"]  = 	{},
    --["AQ20"] = 	{},
    --["BWL"] = 	{},
    --["AQ40"] = 	{} ,
    --["NAXX"] = 	{},
    [ "RAMPS" ]  = "bm bollwerk höllenfeuerbollwerk bw",
    [ "BF" ]     = "bk kessel blutkessel",
    [ "SP" ]     = "sp sklaven sklavenunterkünfte",
    [ "UB" ]     = "ts sumpf tiefensumpf tiefen",
    [ "MT" ]     = "mg gruft managruft manatomb tomb mana",
    [ "AC" ]     = "krypta auchenaikrypta auchen",
    [ "SH" ]     = "sh sethekhallen seth sethek",
    [ "OHF" ]    = "hdz1 hillsbrad",
    [ "MECHA" ]  = "mecha mechanar mech",
    [ "BM" ]     = "hdz2 morast",
    [ "MGT" ]    = "tdm terasse",
    [ "SHH" ]    = "zh zerschmetterte hallen",
    [ "BOTA" ]   = "bota botanika botanica",
    [ "SL" ]     = "sl schlabby schattenlab shadow schattenlaby shadowlab",
    [ "SV" ]     = "dk dampfkammer",
    [ "ARCA" ]   = "arca arka arkatraz arcatraz",
    [ "KARA" ]   = "kara karazahn",
    [ "GRUULS" ] = "grull grul gruul",
    [ "MAGS" ]   = "maggi magi magtheridons magtheridon",
    [ "SSC" ]    = "ssc vashi schlangenschrein",
    [ "ZA" ]     = "za zulaman aman zul",
    [ "EYE" ]    = "auge tk fds",
    [ "HYJAL" ]  = "hdz3 mount hyjal mounthyjal ",
    [ "BT" ]     = "tempel bt black blacktempel blacktemple temple",
    --["SWP"] = {},

    [ "WSG" ]    = "warsongschlucht schlucht",
    --["AB"]  = 	{},
    --["AV"]  = 	{},
    [ "EOTS" ]   = "ads",
    [ "ARENA" ]  = "2s 3s 5s 3v3 5v5 2v2 2vs2 3vs3 5vs5",
    [ "TRADE" ]  = "kaufe verkauf kauf verkaufe ah vk tg trinkgeld trinkgold vz schneider verzauberer verzaubere schliesskassetten schließkassetten kassetten schlossknacken schloßknacken alchimie",
  } ),
  ruRU = langSplit( {
    [ "AB" ] = "низина арати",
    [ "AQ20" ] = "руины ра20",
    [ "AQ40" ] = "ан40",
    [ "AV" ] = "ад альтеракская долина ",
    [ "BFD" ] = "нп непроглядная пучина пучину",
    [ "BRD" ] = "брд гчг глубины генерал арена ран глубины черной горы",
    [ "BWL" ] = "логово крыла тьмы лкт",
    [ "DM" ] = "мк мертвые копи ванклиф",
    [ "DM2" ] = "дм забытый город",
    [ "DME" ] = "восток вдм дмвосток джампран",
    [ "DMN" ] = "дмн дмсевер север трибут трибьют",
    [ "DMW" ] = "дмв запад дмзапад",
    [ "GNOMER" ] = "гномреган гномер гномрег гномериган гномерган",
    [ "LBRS" ] = "лбрс нвчг нпчг нижний низ",
    [ "MARA" ] = "мар мара марадон мараудон мару мародон мароудон мродон мородон",
    [ "MC" ] = "недра",
    [ "NAXX" ] = "наксрамас накс",
    [ "ONY" ] = "ониксия оня ониксию",
    [ "RFC" ] = "оп огненная пропасть",
    [ "RFD" ] = "ки курганы",
    [ "RFK" ] = "ли лабиринты",
    [ "SCHOLO" ] = "шоло некроситет некр",
    [ "SFK" ] = "ктк темного клыка",
    [ "SM2" ] = "мао монастырь",
    [ "ARMS" ] = "оружейная армори арм оружейка",
    [ "CATH" ] = "собор",
    [ "GY" ] = "кладбон кладбище",
    [ "LIB" ] = "библиотека библиотеку библу библа",
    [ "ST" ] = "зх затанувший храм санкен сункен темпл",
    [ "STOCKS" ] = "тюрьма тюрьму тюрягу",
    [ "STRAT" ] = "ст страт стратхольм",
    [ "RAMPS" ] = "бастионы адского пламени цап бастион бап",
    [ "BF" ] = "кузня крови кк кузню кузни",
    [ "SP" ] = "узилище узилише улилище узилища узилеще узлще",
    [ "UB" ] = "нижетопь нт нежитопь нижнетопь",
    [ "MT" ] = "маны гм манатомбс манатомбы томбы мана томбс манатобс манатомб манатомс ману",
    [ "AC" ] = "аукенайские аг аукенские аукинайские аук аукен",
    [ "SH" ] = "сетеккские залы сз сетеки сеттек сетекские сетеков сетеккскиезалы сеттекские",
    [ "OHF" ] = "cтарые предгорья хилсбрада спх старый хилсбрад хилсбард",
    [ "MECHA" ] = "механар кбм механар мех меха меху",
    [ "BM" ] = "черные топи",
    [ "MGT" ] = "терраса магистров тм",
    [ "SHH" ] = "разрушенные рз разрушенных разрушеные",
    [ "BOTA" ] = "ботаника кбб ботанику бот боту",
    [ "SL" ] = "темный тёмный  лаберинт лабиринт шл лаба",
    [ "SV" ] = "резервуар паровое паравое паровые пп парового",
    [ "ARCA" ] = "аркатрац кба алькатрац аркатрас алькатрас алькатраз арка аркатраз",
    [ "TRADE" ] = "куплю продам втс втб чантера чант энчантера скрафчу сделаю чарю чары",
    [ "UBRS" ] = "убрс ввчг вчвчг впчг вчпчг верх верхний",
    [ "ULDA" ] = "ульд ульда ульдаман ульду ульдман улдаман ульдуман",
    [ "WC" ] = "пс стенаний пещеры",
    [ "WSG" ] = "упв ущелье песни войны варсонг всг",
    [ "ZF" ] = "зф фарак фаррак зул'фаррак зулфарак зулфаррак зульфарак",
    [ "ZG" ] = "зг гуруб зул'гуруб  зулгуруб  зул´гуруб зул`гуруб зул'гуруба",
    [ "KARA" ] = "каражан кара караджан кару",
    [ "ARENA" ] = "2s 3s 5s 3v3 5v5 2v2 2vs2 3vs3 5vs5",
    [ "GRUULS" ] = "грул груула",
  } ),
  frFR = langSplit( {
    [ "RFC" ]    = "rfc ragefeu",
    [ "DM" ]     = "mm mortemines mine mortemine",
    [ "WC" ]     = "lams lam lamentations",
    [ "SFK" ]    = "ombrecroc",
    [ "STOCKS" ] = "prison",
    [ "BFD" ]    = "brassenoire",
    --["GNOMER"] = "",
    [ "RFK" ]    = "kraal",
    --["SM2"] =	"",
    [ "GY" ]     = "cimetière cimetiere cim",
    [ "LIB" ]    = "bibli bibliothèque bibliotheque librairie",
    [ "ARMS" ]   = "armu armurerie",
    [ "CATH" ]   = "cathé cathe",
    [ "RFD" ]    = "souille souilles",
    --["ULDA"] = "",
    --["ZF"]  = "",
    --["MARA"] = "",
    [ "ST" ]     = "st sunken englouti atal",
    [ "BRD" ]    = "brd profondeur profondeurs",
    [ "DM2" ]    = "ht hache-tripes hachetripes hache tripe tripes",
    [ "DME" ]    = "htest",
    [ "DMN" ]    = "tribut nord",
    [ "DMW" ]    = "ouest",
    --["STRAT"] = "",
    --["SCHOLO"] = "",
    --["LBRS"] = "",
    --["UBRS"] = "",
    [ "RAMPS" ]  = "remparts rempart renpart ranpart renparts rampart ramparts",
    [ "BF" ]     = "fournaise",
    [ "SP" ]     = "enclos enclo",
    [ "UB" ]     = "bt basse tourbière tourbiere",
    [ "MT" ]     = "tombe mana tm manatomb",
    [ "AC" ]     = "crypte cryptes crypts crypt auchenaï auchenai",
    [ "SH" ]     = "sethekk seth sethek setthek settek",
    [ "OHF" ]    = "gt1",
    [ "MECHA" ]  = "méca mech mechanar méchanar",
    [ "BM" ]     = "gt2",
    --["MGT"] = "",
    [ "SHH" ]    = "salles salle brisées brisees brise brisés brisé sb brisée halls",
    [ "BOTA" ]   = "botanica bota",
    [ "SL" ]     = "labyrinth lab laby shadowlab",
    [ "SV" ]     = "steam vault réservoir reservoir caveau caveaux",
    [ "ARCA" ]   = "arca",
    --["KARA"] = "",
    --["GRUULS"] = "",
    --["MAGS"] = "",
    --["SSC"] = "",
    --["ZA"] = "",
    --["EYE"] = "",
    --["HYJAL"] = "",
    --["BT"] = "",
    --["SWP"] = "",
    --["ONY"] = "",
    --["MC"] = "",
    --["ZG"] = "",
    --["AQ20"] = "",
    --["BWL"] = "",
    --["AQ40"] = "" ,
    --["NAXX"] = "",
    --["WSG"] = "",
    [ "AB" ]     = "arathi",
    [ "AV" ]     = "alterac",
    [ "ARENA" ]  = "2s 3s 5s 3v3 5v5 2v2 2vs2 3vs3 5vs5",
    --["EOTS"] = "",
    [ "TRADE" ]  = "achete vends enchanteur vend",
  } ),
  zhTW = langSplit( {
    [ "RFC" ]    = "怒焰裂谷 怒驗 怒焰",
    [ "DM" ]     = "死亡礦坑 死況 死礦",
    [ "WC" ]     = "哀嚎洞穴 哀號 哀嚎",
    [ "SFK" ]    = "影牙城堡 影牙",
    -- ["STOCKS"] = 	"" ,
    [ "BFD" ]    = "黑暗深淵",
    [ "GNOMER" ] = "諾姆瑞根",
    [ "RFK" ]    = "剃刀沼澤",
    [ "SM2" ]    = "血色",
    [ "GY" ]     = "血色墓地",
    [ "LIB" ]    = "血色圖書館",
    [ "ARMS" ]   = "軍械",
    [ "CATH" ]   = "教堂",
    [ "RFD" ]    = "剃刀高地",
    [ "ULDA" ]   = "奧達曼",
    [ "ZF" ]     = "ZF 組爾法 祖爾法",
    [ "MARA" ]   = "馬拉 瑪拉",
    [ "ST" ]     = "神廟 阿塔哈卡",
    [ "BRD" ]    = "黑深 深淵",
    [ "DM2" ]    = "厄運 惡運 噩運",
    [ "DME" ]    = "厄東 惡東 噩東",
    [ "DMN" ]    = "厄北 惡北 噩北 完美厄運 完美惡運 完美噩運",
    [ "DMW" ]    = "厄西 惡西 噩西",
    [ "STRAT" ]  = "斯坦",
    [ "SCHOLO" ] = "通靈",
    [ "LBRS" ]   = "黑下 黑石塔下",
    [ "UBRS" ]   = "黑上 黑石塔上",
    [ "RAMPS" ]  = "堡壘 壁壘 火堡 火壘 火堡壘 火壁壘",
    [ "BF" ]     = "血熔爐 熔爐 融爐 血熔盧 熔盧 融盧",
    [ "SP" ]     = "奴隸 監獄 奴監",
    [ "UB" ]     = "深幽 泥沼",
    [ "MT" ]     = "法力 墓地 法墓",
    [ "AC" ]     = "地穴",
    [ "SH" ]     = "鳥廳 塞斯克 塞司克 賽司克 賽斯克 鳥聽 烏鴉",
    [ "OHF" ]    = "索爾 丘陵",
    [ "MECHA" ]  = "麥克",
    [ "BM" ]     = "18波 黑色沼澤 黑沼 沼澤",
    [ "MGT" ]    = "博學",
    [ "SHH" ]    = "破碎",
    [ "BOTA" ]   = "波塔 波卡",
    [ "SL" ]     = "迷宮 暗影 暗宮",
    [ "SV" ]     = "蒸氣 蒸汽",
    [ "ARCA" ]   = "亞克",
    [ "KARA" ]   = "卡拉 卡啦",
    [ "GRUULS" ] = "戈魯 魯爾 戈乳 哥魯 哥乳",
    [ "MAGS" ]   = "馬肥 瑪色 馬瑟 瑪瑟",
    [ "SSC" ]    = "毒蛇",
    [ "ZA" ]     = "ZA 阿曼",
    [ "EYE" ]    = "風暴 要塞 鳳凰",
    [ "HYJAL" ]  = "海珊 海山 海加爾",
    [ "BT" ]     = "黑暗神廟 黑廟",
    [ "SWP" ]    = "太陽",
    [ "ONY" ]    = "黑妹 龍妹 奧妮 ONYX",
    [ "MC" ]     = "MC 熔火 螺絲",
    [ "ZG" ]     = "ZG 祖爾格 組爾格 龍虎",
    [ "AQ20" ]   = "RAQ AQ20 廢墟",
    [ "BWL" ]    = "BWL 黑翼",
    [ "AQ40" ]   = "TAQ AQ40 安琪拉 安其拉",
    [ "NAXX" ]   = "NAXXX 老克 納克",
    [ "WSG" ]    = "戰哥 戰歌",
    [ "AB" ]     = "阿拉溪 阿拉希 阿拉西",
    [ "AV" ]     = "奧山 奧特蘭",
    [ "EOTS" ]   = "暴風眼 暴風之眼",
    [ "ARENA" ]  = "競技 22 33 3v3 5v5 2v2 2vs2 3vs3 5vs5",
    [ "TRADE" ]  = "買 賣 售 收 代工 出售 附魔 COD", --hlink
  } ),
}

GBB.dungeonTagsLoc.enGB[ "DEADMINES" ] = { "dm" }

GBB.dungeonSecondTags = {
  [ "DEADMINES" ] = { "DM", "-DMW", "-DME", "-DMN" },
  [ "SM2" ] = { "GY", "LIB", "ARMS", "CATH" },
  [ "DM2" ] = { "DMW", "DME", "DMN", "-DM" },
}
