LBP_Data = {}

LBP_Data.ButtonSpells = {
	DEATHKNIGHT = {
		-- Deathchill
		[49020] = 1,
		[51423] = 1,
		[51424] = 1,
		[51425] = 1,
		[66198] = 1,
		[66972] = 1,
		[66973] = 1,
		[66974] = 1,

		-- Deathchill / Killing Machine
		[49143] = 2,
		[51416] = 2,
		[51417] = 2,
		[51418] = 2,
		[51419] = 2,
		[55268] = 2,
		[66196] = 2,
		[66958] = 2,
		[66959] = 2,
		[66960] = 2,
		[66961] = 2,
		[66962] = 2,

		-- Deathchill / Killing Machine / Freezing Fog
		[45477] = 3,
		[49184] = 3,
		[49896] = 3,
		[49903] = 3,
		[49904] = 3,
		[49909] = 3,
		[50880] = 3,
		[50884] = 3,
		[50885] = 3,
		[50886] = 3,
		[50887] = 3,
		[51409] = 3,
		[51410] = 3,
		[51411] = 3,
		[52372] = 3,
		[52789] = 3,
		[53536] = 3,
		[53549] = 3,
		[59131] = 3,
	},
	DRUID = {
		-- Eclipse (Solar)
		[5176] = 1,
		[5177] = 1,
		[5178] = 1,
		[5179] = 1,
		[5180] = 1,
		[6780] = 1,
		[8905] = 1,
		[9912] = 1,
		[26984] = 1,
		[26985] = 1,
		[48459] = 1,
		[48461] = 1,

		-- Eclipse (Lunar)
		[2912] = 2,
		[8949] = 2,
		[8950] = 2,
		[8951] = 2,
		[9875] = 2,
		[9876] = 2,
		[20687] = 2,
		[21668] = 2,
		[25298] = 2,
		[26986] = 2,
		[35243] = 2,
		[37124] = 2,
		[38935] = 2,
		[40344] = 2,
		[41349] = 2,
		[41357] = 2,
		[41360] = 2,
		[48464] = 2,
		[48465] = 2,

		-- Berserk
		[33878] = 3,
		[33986] = 3,
		[33987] = 3,
		[48563] = 3,
		[48564] = 3,
	},
	HUNTER = {
		-- Improved Steady Shot
		[19434] = 1,
		[20900] = 1,
		[20901] = 1,
		[20902] = 1,
		[20903] = 1,
		[20904] = 1,
		[27065] = 1,
		[27632] = 1,
		[30614] = 1,
		[31623] = 1,
		[38370] = 1,
		[38861] = 1,
		[44271] = 1,
		[48871] = 1,
		[49049] = 1,
		[49050] = 1,
		[52718] = 1,
		[53209] = 1,
		[54615] = 1,
		[59243] = 1,

		-- Lock and Load
		[34498] = 2,
		[53301] = 2,
		[60051] = 2,
		[60052] = 2,
		[60053] = 2,

		-- Improved Steady Shot / Lock and Load
		[3044] = 3,
		[14281] = 3,
		[14282] = 3,
		[14283] = 3,
		[14284] = 3,
		[14285] = 3,
		[14286] = 3,
		[14287] = 3,
		[19597] = 3,
		[19676] = 3,
		[19677] = 3,
		[19678] = 3,
		[19679] = 3,
		[19680] = 3,
		[19681] = 3,
		[19682] = 3,
		[19683] = 3,
		[19684] = 3,
		[19685] = 3,
		[19686] = 3,
		[27019] = 3,
		[30100] = 3,
		[30103] = 3,
		[30104] = 3,
		[30647] = 3,
		[30648] = 3,
		[30652] = 3,
		[34829] = 3,
		[35401] = 3,
		[36293] = 3,
		[36609] = 3,
		[36623] = 3,
		[38807] = 3,
		[43337] = 3,
		[49044] = 3,
		[49045] = 3,
		[51742] = 3,
		[53214] = 3,

		-- Kill Shot
		[53351] = 4,
		[61005] = 4,
		[61006] = 4,
	},
	MAGE = {
		-- Missile Barrage
		[5143] = 1,
		[5144] = 1,
		[5145] = 1,
		[8416] = 1,
		[8417] = 1,
		[10211] = 1,
		[10212] = 1,
		[25345] = 1,
		[27075] = 1,
		[38699] = 1,
		[38704] = 1,
		[42843] = 1,
		[42846] = 1,

		-- Hot Streak
		[11366] = 2,
		[12505] = 2,
		[12522] = 2,
		[12523] = 2,
		[12524] = 2,
		[12525] = 2,
		[12526] = 2,
		[18809] = 2,
		[27132] = 2,
		[33938] = 2,
		[42890] = 2,
		[42891] = 2,

		-- Firestarter
		[2120] = 3,
		[2121] = 3,
		[8422] = 3,
		[8423] = 3,
		[10215] = 3,
		[10216] = 3,
		[12354] = 3,
		[18948] = 3,
		[18949] = 3,
		[27086] = 3,
		[42925] = 3,
		[42926] = 3,
		[46224] = 3,

		-- Fireball!
		[133] = 4,
		[143] = 4,
		[145] = 4,
		[3140] = 4,
		[8400] = 4,
		[8401] = 4,
		[8402] = 4,
		[10148] = 4,
		[10149] = 4,
		[10150] = 4,
		[10151] = 4,
		[21230] = 4,
		[25306] = 4,
		[27070] = 4,
		[37921] = 4,
		[38274] = 4,
		[38275] = 4,
		[38276] = 4,
		[38556] = 4,
		[38557] = 4,
		[38558] = 4,
		[38559] = 4,
		[38560] = 4,
		[38561] = 4,
		[38562] = 4,
		[38563] = 4,
		[38564] = 4,
		[38565] = 4,
		[38566] = 4,
		[38567] = 4,
		[38568] = 4,
		[38569] = 4,
		[38570] = 4,
		[38692] = 4,
		[40822] = 4,
		[41060] = 4,
		[41346] = 4,
		[42332] = 4,
		[42357] = 4,
		[42359] = 4,
		[42412] = 4,
		[42832] = 4,
		[42833] = 4,
		[42834] = 4,
		[43409] = 4,
		[43515] = 4,
		[43520] = 4,
		[43525] = 4,
		[43665] = 4,
		[43993] = 4,
		[44614] = 4,
		[45108] = 4,
		[46440] = 4,
		[46602] = 4,
		[46704] = 4,
		[47610] = 4,
		[48975] = 4,
		[49512] = 4,
		[51235] = 4,
		[51236] = 4,
		[52356] = 4,
		[59138] = 4,
		[59603] = 4,
		[61168] = 4,
		[68812] = 4,

		-- Impact
		[2136] = 5,
		[2137] = 5,
		[2138] = 5,
		[8412] = 5,
		[8413] = 5,
		[10197] = 5,
		[10199] = 5,
		[27078] = 5,
		[27079] = 5,
		[42872] = 5,
		[42873] = 5,

		-- Fingers of Frost
		[13878] = 6,
		[15041] = 6,
		[15091] = 6,
		[15241] = 6,
		[15744] = 6,
		[16046] = 6,
		[16785] = 6,
		[17145] = 6,
		[17195] = 6,
		[17277] = 6,
		[20229] = 6,
		[22424] = 6,
		[23039] = 6,
		[23113] = 6,
		[23331] = 6,
		[25049] = 6,
		[28323] = 6,
		[30092] = 6,
		[30455] = 6,
		[30600] = 6,
		[33061] = 6,
		[35377] = 6,
		[36278] = 6,
		[36342] = 6,
		[36628] = 6,
		[36807] = 6,
		[37844] = 6,
		[38064] = 6,
		[38391] = 6,
		[38536] = 6,
		[38636] = 6,
		[38712] = 6,
		[39001] = 6,
		[39038] = 6,
		[42913] = 6,
		[42914] = 6,
		[43571] = 6,
		[44137] = 6,
		[44138] = 6,
		[44572] = 6,
		[46187] = 6,
		[46188] = 6,
		[47723] = 6,
		[50183] = 6,
		[56938] = 6,
		[58534] = 6,
		[58970] = 6,
		[60290] = 6,
		[61362] = 6,
		[61577] = 6,
		[71590] = 6,
		[71591] = 6,
		[71786] = 6,
		[75412] = 6,
		[75419] = 6,

		-- Impact / Fingers of Frost
		[13339] = 7,
		[13340] = 7,
		[13341] = 7,
		[13342] = 7,
		[13374] = 7,
		[14145] = 7,
		[15574] = 7,
		[16144] = 7,
		[17276] = 7,
		[17492] = 7,
		[20623] = 7,
		[20679] = 7,
		[20795] = 7,
		[20832] = 7,
		[24530] = 7,
		[25028] = 7,
		[30512] = 7,
		[30516] = 7,
		[31378] = 7,
		[36339] = 7,
		[37110] = 7,
		[37988] = 7,
		[38526] = 7,
		[43245] = 7,
		[57984] = 7,
		[59637] = 7,
	},
	PALADIN = {
		-- Hammer of Wrath
		[24239] = 1,
		[24274] = 1,
		[24275] = 1,
		[27180] = 1,
		[48805] = 1,
		[48806] = 1,

		-- The Art of War
		[879] = 2,
		[5614] = 2,
		[5615] = 2,
		[10312] = 2,
		[10313] = 2,
		[10314] = 2,
		[27138] = 2,
		[36944] = 2,
		[48800] = 2,
		[48801] = 2,

		-- Infusion of Light
		[635] = 3,
		[639] = 3,
		[647] = 3,
		[1026] = 3,
		[1042] = 3,
		[3472] = 3,
		[10328] = 3,
		[10329] = 3,
		[25292] = 3,
		[27135] = 3,
		[27136] = 3,
		[48781] = 3,
		[48782] = 3,
		[56539] = 3,
		[58053] = 3,
		[58153] = 3,

		-- Infusion of Light / The Art of War
		[19750] = 4,
		[19939] = 4,
		[19940] = 4,
		[19941] = 4,
		[19942] = 4,
		[19943] = 4,
		[27137] = 4,
		[48784] = 4,
		[48785] = 4,
		[60648] = 4,
		[60656] = 4,
		[60659] = 4,
		[60661] = 4,
		[60662] = 4,
		[60664] = 4,
		[60800] = 4,
	},
	PRIEST = {
		-- Surge of Light
		[585] = 1,
		[591] = 1,
		[598] = 1,
		[984] = 1,
		[1004] = 1,
		[2061] = 1,
		[6060] = 1,
		[9472] = 1,
		[9473] = 1,
		[9474] = 1,
		[10915] = 1,
		[10916] = 1,
		[10917] = 1,
		[10933] = 1,
		[10934] = 1,
		[17137] = 1,
		[17138] = 1,
		[17843] = 1,
		[25233] = 1,
		[25235] = 1,
		[25363] = 1,
		[25364] = 1,
		[27608] = 1,
		[29564] = 1,
		[33641] = 1,
		[34176] = 1,
		[35096] = 1,
		[38580] = 1,
		[38588] = 1,
		[41378] = 1,
		[42420] = 1,
		[43431] = 1,
		[43516] = 1,
		[43575] = 1,
		[48070] = 1,
		[48071] = 1,
		[48122] = 1,
		[48123] = 1,
		[49348] = 1,
		[56331] = 1,
		[56919] = 1,
		[57766] = 1,
		[57775] = 1,
		[59997] = 1,
		[60003] = 1,
		[61965] = 1,
		[62334] = 1,
		[62442] = 1,
		[62809] = 1,
		[63760] = 1,
		[67254] = 1,
		[67291] = 1,
		[71930] = 1,
		[71931] = 1,
		[72484] = 1,

		-- Serendipity
		[596] = 2,
		[996] = 2,
		[2060] = 2,
		[10960] = 2,
		[10961] = 2,
		[10963] = 2,
		[10964] = 2,
		[10965] = 2,
		[15068] = 2,
		[25210] = 2,
		[25213] = 2,
		[25308] = 2,
		[25314] = 2,
		[25316] = 2,
		[26565] = 2,
		[30604] = 2,
		[39321] = 2,
		[48062] = 2,
		[48063] = 2,
		[48072] = 2,

		-- Surge of Light / Serendipity
		[47536] = 3,
	},
	ROGUE = {
	},
	SHAMAN = {
	},
	WARLOCK = {
		-- Shadow Trance / Backlash
		[686] = 1,
		[695] = 1,
		[705] = 1,
		[1088] = 1,
		[1106] = 1,
		[7641] = 1,
		[11659] = 1,
		[11660] = 1,
		[11661] = 1,
		[25307] = 1,
		[27209] = 1,
		[34177] = 1,
		[47808] = 1,
		[47809] = 1,
		[48687] = 1,
		[68073] = 1,

		-- Molten Core
		[6353] = 2,
		[17924] = 2,
		[27211] = 2,
		[30545] = 2,
		[47824] = 2,
		[47825] = 2,

		-- Backlash / Molten Core
		[29722] = 3,
		[32231] = 3,
		[36832] = 3,
		[38918] = 3,
		[47837] = 3,
		[47838] = 3,
	},
	WARRIOR = {
		-- Revenge
		[6572] = 1,
		[6574] = 1,
		[7379] = 1,
		[11600] = 1,
		[11601] = 1,
		[25269] = 1,
		[25288] = 1,
		[30357] = 1,
		[57823] = 1,

		-- Overpower
		[7384] = 2,
		[7887] = 2,
		[11584] = 2,
		[11585] = 2,
		[14895] = 2,
		[17198] = 2,
		[24407] = 2,
		[24817] = 2,
		[32154] = 2,
		[37321] = 2,
		[43456] = 2,

		-- Victory Rush
		[34428] = 3,

		-- Slam!
		[1464] = 4,
		[8820] = 4,
		[11604] = 4,
		[11605] = 4,
		[22427] = 4,
		[25241] = 4,
		[25242] = 4,
		[32588] = 4,
		[41182] = 4,
		[47474] = 4,
		[47475] = 4,
		[50782] = 4,
		[50783] = 4,
		[52719] = 4,

		-- Sword and Board
		[23922] = 5,
		[23923] = 5,
		[23924] = 5,
		[23925] = 5,
		[25258] = 5,
		[30356] = 5,
		[47487] = 5,
		[47488] = 5,

		-- Execute / Sudden Death
		[5308] = 6,
		[20647] = 6,
		[20658] = 6,
		[20660] = 6,
		[20661] = 6,
		[20662] = 6,
		[25234] = 6,
		[25236] = 6,
		[47470] = 6,
		[47471] = 6,
	},
}

LBP_Data.ButtonProcs = {
	DEATHKNIGHT = {
		-- Deathchill
		{49796},
		-- Deathchill / Killing Machine
		{49796, 51124},
		-- Deathchill / Killing Machine / Freezing Fog
		{49796, 51124, 59052},
	},
	DRUID = {
		-- Eclipse (Solar)
		{48517},
		-- Eclipse (Lunar)
		{48518},
		-- Berserk
		{50334},
	},
	HUNTER = {
		-- Improved Steady Shot
		{53220},
		-- Lock and Load
		{56453},
		-- Improved Steady Shot / Lock and Load
		{53220, 56453},
		-- Kill Shot
		{61006},
	},
	MAGE = {
		-- Missile Barrage
		{44401},
		-- Hot Streak
		{48108},
		-- Firestarter
		{54741},
		-- Fireball!
		{57761},
		-- Impact
		{64343},
		-- Fingers of Frost
		{74396},
		-- Impact / Fingers of Frost
		{64343, 74396},
	},
	PALADIN = {
		-- Hammer of Wrath
		{24275},
		-- The Art of War
		{59578},
		-- Infusion of Light
		{53672, 54149},
		-- Infusion of Light / The Art of War
		{53672, 54149, 59578},
	},
	PRIEST = {
		-- Surge of Light
		{33151},
		-- Serendipity
		{63731, 63734, 63735},
		-- Surge of Light / Serendipity
		{33151, 63731, 63734, 63735},
	},
	ROGUE = {
	},
	SHAMAN = {
	},
	WARLOCK = {
		-- Shadow Trance / Backlash
		{17941, 34936},
		-- Molten Core
		{47383, 71162, 71165},
		-- Backlash / Molten Core
		{34936, 47383, 71162, 71165},
	},
	WARRIOR = {
		-- Revenge
		{6572},
		-- Overpower / Taste for Blood
		{7384, 60503},
		-- Victory Rush
		{34428},
		-- Slam!
		{46916},
		-- Sword and Board
		{50227},
		-- Execute / Sudden Death
		{5308, 52437},
	}
}

LBP_Data.OverlayProcs = {
	DEATHKNIGHT = {
		-- Freezing Fog
		[59052] = 1,
		-- Killing Machine
		[51124] = 2,
		-- Deathchill
		[49796] = nil,
	},
	DRUID = {
		-- Eclipse (Solar)
		[48517] = 1,
		-- Eclipse (Lunar)
		[48518] = 2,
		-- Berserk
		[50334] = nil,
		-- Tree of Life
		[33891] = nil,
		-- Clearcasting
		[16870] = 3,
	},
	HUNTER = {
		-- Improved Steady Shot
		[53220] = 1,
		-- Lock and Load
		[56453] = 2,
		-- Kill Shot
		[61006] = nil,
	},
	MAGE = {
		-- Hot Streak
		[48108] = 1,
		-- Fireball!
		[57761] = 2,
		-- Fingers of Frost
		[74396] = 3,
		-- Arcane Missiles
		[5143] = nil,
		-- Impact
		[64343] = 4,
		-- Missile Barrage
		[44401] = 5,
		-- Firestarter
		[54741] = nil,
	},
	PALADIN = {
		-- The Art of War
		[59578] = 1,
		-- Surge of Light
		[33151] = 2,
		-- Hammer of Wrath
		[24275] = nil,
		-- Infusion of Light
		[53672] = 3,
		[54149] = 3,
	},
	PRIEST = {
		-- Serendipity
		[63731] = 1,
		[63734] = 1,
		[63735] = 1,
		-- Surge of Light
		[33151] = 2,
	},
	ROGUE = {
	},
	SHAMAN = {
		-- Maelstrom Weapon
		[53817] = 1,
	},
	WARLOCK = {
		-- Shadow Trance
		[17941] = 1,
		-- Empowered Imp
		[47283] = 2,
		-- Molten Core
		[47383] = 3,
		[71162] = 3,
		[71165] = 3,
		-- Backlash
		[34936] = 4,
	},
	WARRIOR = {
		-- Sword and Board
		[50227] = 1,
		-- Sudden Death
		[52437] = 2,
		-- Revenge
		[6572] = nil,
		-- Execute
		[5308] = nil,
		-- Victory Rush
		[34428] = nil,
		-- Slam!
		[46916] = 3,
		-- Overpower
		[7384] = nil,
	}
}

LBP_Data.OverlayTextures = {
	DEATHKNIGHT = {
		-- Freezing Fog
		{0, "Rime.blp", "Top", 1, 1, 1, 1},
		-- Killing Machine
		{0, "Killing_Machine.blp", "Left + Right (Flipped)", 1, 1, 1, 1},
	},
	DRUID = {
		-- Eclipse (Solar)
		{0, "Eclipse_Sun.blp", "TopRight", 1, 0.9568, 0.9568, 0.9568},
		-- Eclipse (Lunar)
		{0, "Eclipse_Moon.blp", "TopLeft", 1, 0.9568, 0.9568, 0.9568},
		-- Clearcasting
		{0, "Natures_Grace.blp", "Left + Right (Flipped)", 1, 1, 1, 1},
	},
	HUNTER = {
		-- Improved Steady Shot
		{0, "Master_Marksman.blp", "Top", 1, 1, 1, 1},
		-- Lock and Load
		{0, "Lock_and_Load.blp", "Top", 1, 1, 1, 1},
	},
	MAGE = {
		-- Hot Streak
		{1, "Hot_Streak.blp", "Left + Right (Flipped)", 1, 1, 1, 1},
		-- Fireball!
		{0, "Brain_Freeze.blp", "Top", 1, 1, 1, 1},
		-- Fingers of Frost
		{1, "Frozen_Fingers.blp", "Left + Right (Flipped)", 1, 1, 1, 1},
		-- Impact
		{0, "Impact.blp", "Top", 1, 1, 1, 1},
		-- Missile Barrage
		{0, "Arcane_Missiles.blp", "Left + Right (Flipped)", 1, 1, 1, 1},
	},
	PALADIN = {
		-- The Art of War
		{0, "Art_of_War.blp", "Left + Right (Flipped)", 1, 1, 1, 1},
		-- Surge of Light
		{0, "Surge_of_Light.blp", "Left + Right (Flipped)", 1, 1, 1, 1},
		-- Infusion of Light
		{0, "Denounce.blp", "Top", 1, 1, 1, 1},
	},
	PRIEST = {
		-- Serendipity
		{3, "Serendipity.blp", "Top", 1, 1, 1, 1},
		-- Surge of Light
		{0, "Surge_of_Light.blp", "Left + Right (Flipped)", 1, 1, 1, 1},
	},
	ROGUE = {
	},
	SHAMAN = {
		-- Maelstrom Weapon
		{5, "Maelstrom_Weapon.blp", "Top", 1, 1, 1, 1},
	},
	WARLOCK = {
		-- Shadow Trance
		{0, "Nightfall.blp", "Left + Right (Flipped)", 1, 1, 1, 1},
		-- Empowered Imp
		{0, "Imp_Empowerment.blp", "Left + Right (Flipped)", 1, 1, 1, 1},
		-- Molten Core
		{0, "Molten_Core.blp", "Left + Right (Flipped)", 1, 1, 1, 1},
		-- Backlash
		{0, "Backlash.blp", "Top", 1, 1, 1, 1},
	},
	WARRIOR = {
		-- Sword and Board
		{0, "Sword_and_Board.blp", "Left + Right (Flipped)", 1, 1, 1, 1},
		-- Sudden Death
		{0, "Sudden_Death.blp", "Left + Right (Flipped)", 1, 1, 1, 1},
		-- Slam!
		{0, "Blood_Surge.blp", "Left + Right (Flipped)", 1, 1, 1, 1},
	}
}